/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.spdy;

import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.tomcat.spdy.SpdyStream;

public class SpdyFrame {
    public static final byte[] STATUS = "status".getBytes();
    public static final byte[] VERSION = "version".getBytes();
    public static final byte[] HTTP11 = "HTTP/1.1".getBytes();
    public static final byte[] OK200 = "200 OK".getBytes();
    public byte[] data;
    public int off = 8;
    int endReadData;
    public int endData;
    boolean c;
    int version;
    int flags;
    public int type;
    public int streamId;
    public int pri;
    public int associated;
    public int nvCount;
    public SpdyStream stream;

    public SpdyFrame(int size) {
        this.data = new byte[size];
    }

    public int getDataSize() {
        return this.endData - 8;
    }

    public void recyle() {
        this.type = 0;
        this.c = false;
        this.endReadData = 0;
        this.off = 8;
        this.streamId = 0;
        this.nvCount = 0;
        this.endData = 0;
    }

    public String toString() {
        if (this.c) {
            if (this.type == 6) {
                return "C PING " + this.read32(this.data, 0);
            }
            return "C S=" + this.streamId + (this.flags != 0 ? " F=" + this.flags : "") + (this.version != 2 ? "  v" + this.version : "") + " t=" + this.type + " L=" + this.endData + "/" + this.off;
        }
        return "D S=" + this.streamId + (this.flags != 0 ? " F=" + this.flags : "") + " L=" + this.endData + "/" + this.off;
    }

    public int serializeHead() {
        if (this.c) {
            this.data[0] = -128;
            this.data[1] = 2;
            this.data[2] = 0;
            this.data[3] = (byte)this.type;
            this.data[4] = (byte)this.flags;
            SpdyFrame.append24(this.data, 5, this.endData - 8);
            if (this.type == 1) {
                SpdyFrame.append32(this.data, 8, this.streamId);
                SpdyFrame.append32(this.data, 12, this.associated);
                this.data[16] = 0;
                this.data[17] = 0;
                return 18;
            }
            if (this.type == 2) {
                SpdyFrame.append32(this.data, 8, this.streamId);
                this.data[12] = 0;
                this.data[13] = 0;
                return 14;
            }
            if (this.type == 8) {
                SpdyFrame.append32(this.data, 8, this.streamId);
                this.data[12] = 0;
                this.data[13] = 0;
                return 14;
            }
        } else {
            SpdyFrame.append32(this.data, 0, this.streamId);
            this.data[4] = (byte)this.flags;
            SpdyFrame.append24(this.data, 5, this.endData - 8);
        }
        return 8;
    }

    public boolean parse() {
        this.endData = 0;
        this.streamId = 0;
        this.nvCount = 0;
        int b0 = this.data[0] & 0xFF;
        if (b0 < 128) {
            this.c = false;
            this.streamId = this.read32(this.data, 0);
            this.version = 2;
        } else {
            this.c = true;
            this.version = (b0 -= 128) << 8 | this.data[1] & 0xFF;
            if (this.version > 2) {
                return false;
            }
            b0 = this.data[2] & 0xFF;
            this.type = b0 << 8 | this.data[3] & 0xFF;
        }
        this.flags = this.data[4] & 0xFF;
        for (int i = 5; i < 8; ++i) {
            b0 = this.data[i] & 0xFF;
            this.endData = this.endData << 8 | b0;
        }
        this.endData += 8;
        return true;
    }

    public boolean isHalfClose() {
        return (this.flags & 1) != 0;
    }

    public void halfClose() {
        this.flags = 1;
    }

    public boolean closed() {
        return (this.flags & 1) != 0;
    }

    static void append24(byte[] buff, int off, int v) {
        buff[off++] = (byte)((v & 0xFF0000) >> 16);
        buff[off++] = (byte)((v & 0xFF00) >> 8);
        buff[off++] = (byte)(v & 0xFF);
    }

    static void append32(byte[] buff, int off, int v) {
        buff[off++] = (byte)((v & 0xFF000000) >> 24);
        buff[off++] = (byte)((v & 0xFF0000) >> 16);
        buff[off++] = (byte)((v & 0xFF00) >> 8);
        buff[off++] = (byte)(v & 0xFF);
    }

    public void append32(int v) {
        this.makeSpace(4);
        this.data[this.off++] = (byte)((v & 0xFF000000) >> 24);
        this.data[this.off++] = (byte)((v & 0xFF0000) >> 16);
        this.data[this.off++] = (byte)((v & 0xFF00) >> 8);
        this.data[this.off++] = (byte)(v & 0xFF);
    }

    public void append16(int v) {
        this.makeSpace(2);
        this.data[this.off++] = (byte)((v & 0xFF00) >> 8);
        this.data[this.off++] = (byte)(v & 0xFF);
    }

    void fixNV(int nvPos) {
        this.data[nvPos++] = (byte)((this.nvCount & 0xFF00) >> 8);
        this.data[nvPos] = (byte)(this.nvCount & 0xFF);
    }

    public void append(byte[] buf, int soff, int len) {
        this.makeSpace(len + this.off);
        System.arraycopy(buf, soff, this.data, this.off, len);
        this.off += len;
    }

    public void headerValue(byte[] buf, int soff, int len) {
        this.makeSpace(len + 4);
        this.append16(len);
        System.arraycopy(buf, soff, this.data, this.off, len);
        this.off += len;
    }

    public void headerName(byte[] buf, int soff, int len) {
        if (this.off == 8) {
            if (this.type == 2) {
                this.off = 16;
            } else if (this.type == 1) {
                this.off = 20;
            } else if (this.type != 8) {
                this.off = 16;
            } else {
                throw new RuntimeException("Wrong frame type");
            }
        }
        ++this.nvCount;
        this.headerValue(buf, soff, len);
    }

    public void addHeader(String name, String value) {
        byte[] nameB = name.getBytes();
        this.headerName(nameB, 0, nameB.length);
        nameB = value.getBytes();
        this.headerValue(nameB, 0, nameB.length);
    }

    public void addHeader(byte[] nameB, String value) {
        this.headerName(nameB, 0, nameB.length);
        nameB = value.getBytes();
        this.headerValue(nameB, 0, nameB.length);
    }

    public void addHeader(byte[] nameB, byte[] valueB) {
        this.headerName(nameB, 0, nameB.length);
        this.headerValue(valueB, 0, valueB.length);
    }

    public void getHeaders(Map<String, String> resHeaders) {
        for (int i = 0; i < this.nvCount; ++i) {
            int len = this.read16();
            String n = new String(this.data, this.off, len, StandardCharsets.UTF_8);
            this.advance(len);
            len = this.read16();
            String v = new String(this.data, this.off, len, StandardCharsets.UTF_8);
            this.advance(len);
            resHeaders.put(n, v);
        }
    }

    void makeSpace(int len) {
        if (len < 256) {
            len = 256;
        }
        if (this.data == null) {
            this.data = new byte[len];
            return;
        }
        int newEnd = this.off + len;
        if (this.data.length < newEnd) {
            byte[] tmp = new byte[newEnd];
            System.err.println("cp " + this.off + " " + this.data.length + " " + len + " " + tmp.length);
            System.arraycopy(this.data, 0, tmp, 0, this.off);
            this.data = tmp;
        }
    }

    public int read16() {
        int res = this.data[this.off++] & 0xFF;
        return res << 8 | this.data[this.off++] & 0xFF;
    }

    int readInt() {
        int res = 0;
        for (int i = 0; i < 4; ++i) {
            int b0 = this.data[this.off++] & 0xFF;
            res = res << 8 | b0;
        }
        return res;
    }

    int read24() {
        int res = 0;
        for (int i = 0; i < 3; ++i) {
            int b0 = this.data[this.off++] & 0xFF;
            res = res << 8 | b0;
        }
        return res;
    }

    int read32(byte[] data, int off) {
        int res = 0;
        for (int i = 0; i < 4; ++i) {
            int b0 = data[off++] & 0xFF;
            res = res << 8 | b0;
        }
        return res;
    }

    int read32() {
        int res = 0;
        for (int i = 0; i < 4; ++i) {
            int b0 = this.data[this.off++] & 0xFF;
            res = res << 8 | b0;
        }
        return res;
    }

    public int readByte() {
        return this.data[this.off++] & 0xFF;
    }

    public int remaining() {
        return this.endData - this.off;
    }

    public void advance(int cnt) {
        this.off += cnt;
    }

    public boolean isData() {
        return !this.c;
    }
}

