/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.compat;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.util.Deque;
import java.util.Set;
import java.util.jar.JarFile;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.compat.Jre8Compat;
import org.apache.tomcat.util.res.StringManager;

class Jre9Compat
extends Jre8Compat {
    private static final Log log = LogFactory.getLog(Jre9Compat.class);
    private static final StringManager sm = StringManager.getManager(Jre9Compat.class);
    private static final Class<?> inaccessibleObjectExceptionClazz;
    private static final Method setDefaultUseCachesMethod;
    private static final Method bootMethod;
    private static final Method configurationMethod;
    private static final Method modulesMethod;
    private static final Method referenceMethod;
    private static final Method locationMethod;
    private static final Method isPresentMethod;
    private static final Method getMethod;
    private static final Constructor<JarFile> jarFileConstructor;
    private static final Method isMultiReleaseMethod;
    private static final Object RUNTIME_VERSION;
    private static final int RUNTIME_MAJOR_VERSION;

    Jre9Compat() {
    }

    static boolean isSupported() {
        return inaccessibleObjectExceptionClazz != null;
    }

    @Override
    public boolean isInstanceOfInaccessibleObjectException(Throwable t) {
        if (t == null) {
            return false;
        }
        return inaccessibleObjectExceptionClazz.isAssignableFrom(t.getClass());
    }

    @Override
    public void disableCachingForJarUrlConnections() throws IOException {
        try {
            setDefaultUseCachesMethod.invoke(null, "JAR", Boolean.FALSE);
        }
        catch (IllegalAccessException e) {
            throw new UnsupportedOperationException(e);
        }
        catch (IllegalArgumentException e) {
            throw new UnsupportedOperationException(e);
        }
        catch (InvocationTargetException e) {
            throw new UnsupportedOperationException(e);
        }
    }

    @Override
    public void addBootModulePath(Deque<URL> classPathUrlsToProcess) {
        try {
            Object bootLayer = bootMethod.invoke(null, new Object[0]);
            Object bootConfiguration = configurationMethod.invoke(bootLayer, new Object[0]);
            Set resolvedModules = (Set)modulesMethod.invoke(bootConfiguration, new Object[0]);
            for (Object resolvedModule : resolvedModules) {
                Object moduleReference = referenceMethod.invoke(resolvedModule, new Object[0]);
                Object optionalURI = locationMethod.invoke(moduleReference, new Object[0]);
                Boolean isPresent = (Boolean)isPresentMethod.invoke(optionalURI, new Object[0]);
                if (!isPresent.booleanValue()) continue;
                URI uri = (URI)getMethod.invoke(optionalURI, new Object[0]);
                try {
                    URL url = uri.toURL();
                    classPathUrlsToProcess.add(url);
                }
                catch (MalformedURLException e) {
                    log.warn((Object)sm.getString("jre9Compat.invalidModuleUri", new Object[]{uri}), (Throwable)e);
                }
            }
        }
        catch (IllegalArgumentException e) {
            throw new UnsupportedOperationException(e);
        }
        catch (IllegalAccessException e) {
            throw new UnsupportedOperationException(e);
        }
        catch (InvocationTargetException e) {
            throw new UnsupportedOperationException(e);
        }
    }

    @Override
    public JarFile jarFileNewInstance(File f) throws IOException {
        try {
            return jarFileConstructor.newInstance(f, Boolean.TRUE, 1, RUNTIME_VERSION);
        }
        catch (IllegalArgumentException e) {
            throw new IOException(e);
        }
        catch (InstantiationException e) {
            throw new IOException(e);
        }
        catch (IllegalAccessException e) {
            throw new IOException(e);
        }
        catch (InvocationTargetException e) {
            throw new IOException(e);
        }
    }

    @Override
    public boolean jarFileIsMultiRelease(JarFile jarFile) {
        try {
            return (Boolean)isMultiReleaseMethod.invoke((Object)jarFile, new Object[0]);
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        catch (IllegalAccessException e) {
            return false;
        }
        catch (InvocationTargetException e) {
            return false;
        }
    }

    @Override
    public int jarFileRuntimeMajorVersion() {
        return RUNTIME_MAJOR_VERSION;
    }

    static {
        Class<?> c1 = null;
        Method m4 = null;
        Method m5 = null;
        Method m6 = null;
        Method m7 = null;
        Method m8 = null;
        Method m9 = null;
        Method m10 = null;
        Method m11 = null;
        Constructor c12 = null;
        Method m13 = null;
        Object o14 = null;
        Object o15 = null;
        try {
            Class<?> moduleLayerClazz = Class.forName("java.lang.ModuleLayer");
            Class<?> configurationClazz = Class.forName("java.lang.module.Configuration");
            Class<?> resolvedModuleClazz = Class.forName("java.lang.module.ResolvedModule");
            Class<?> moduleReferenceClazz = Class.forName("java.lang.module.ModuleReference");
            Class<?> optionalClazz = Class.forName("java.util.Optional");
            Class<?> versionClazz = Class.forName("java.lang.Runtime$Version");
            Method runtimeVersionMethod = JarFile.class.getMethod("runtimeVersion", new Class[0]);
            Method majorMethod = versionClazz.getMethod("major", new Class[0]);
            c1 = Class.forName("java.lang.reflect.InaccessibleObjectException");
            m4 = URLConnection.class.getMethod("setDefaultUseCaches", String.class, Boolean.TYPE);
            m5 = moduleLayerClazz.getMethod("boot", new Class[0]);
            m6 = moduleLayerClazz.getMethod("configuration", new Class[0]);
            m7 = configurationClazz.getMethod("modules", new Class[0]);
            m8 = resolvedModuleClazz.getMethod("reference", new Class[0]);
            m9 = moduleReferenceClazz.getMethod("location", new Class[0]);
            m10 = optionalClazz.getMethod("isPresent", new Class[0]);
            m11 = optionalClazz.getMethod("get", new Class[0]);
            c12 = JarFile.class.getConstructor(File.class, Boolean.TYPE, Integer.TYPE, versionClazz);
            m13 = JarFile.class.getMethod("isMultiRelease", new Class[0]);
            o14 = runtimeVersionMethod.invoke(null, new Object[0]);
            o15 = majorMethod.invoke(o14, new Object[0]);
        }
        catch (SecurityException e) {
        }
        catch (NoSuchMethodException e) {
        }
        catch (ClassNotFoundException e) {
        }
        catch (IllegalArgumentException e) {
        }
        catch (IllegalAccessException e) {
        }
        catch (InvocationTargetException e) {
            // empty catch block
        }
        inaccessibleObjectExceptionClazz = c1;
        setDefaultUseCachesMethod = m4;
        bootMethod = m5;
        configurationMethod = m6;
        modulesMethod = m7;
        referenceMethod = m8;
        locationMethod = m9;
        isPresentMethod = m10;
        getMethod = m11;
        jarFileConstructor = c12;
        isMultiReleaseMethod = m13;
        RUNTIME_VERSION = o14;
        RUNTIME_MAJOR_VERSION = o15 != null ? (Integer)o15 : 8;
    }
}

