/* Driver template for the LEMON parser generator.
** The author disclaims copyright to this source code.
*/
/* First off, code is include which follows the "include" declaration
** in the input file. */
#include <stdio.h>
#line 51 "ext/pdo_sqlite/sqlite/src/parse.y"

#include "sqliteInt.h"
#include "parse.h"

/*
** An instance of this structure holds information about the
** LIMIT clause of a SELECT statement.
*/
struct LimitVal {
  Expr *pLimit;    /* The LIMIT expression.  NULL if there is no limit */
  Expr *pOffset;   /* The OFFSET expression.  NULL if there is none */
};

/*
** An instance of this structure is used to store the LIKE,
** GLOB, NOT LIKE, and NOT GLOB operators.
*/
struct LikeOp {
  Token operator;  /* "like" or "glob" or "regexp" */
  int not;         /* True if the NOT keyword is present */
};

/*
** An instance of the following structure describes the event of a
** TRIGGER.  "a" is the event type, one of TK_UPDATE, TK_INSERT,
** TK_DELETE, or TK_INSTEAD.  If the event is of the form
**
**      UPDATE ON (a,b,c)
**
** Then the "b" IdList records the list "a,b,c".
*/
struct TrigEvent { int a; IdList * b; };

/*
** An instance of this structure holds the ATTACH key and the key type.
*/
struct AttachKey { int type;  Token key; };

#line 48 "ext/pdo_sqlite/sqlite/src/parse.c"
/* Next is all token values, in a form suitable for use by makeheaders.
** This section will be null unless lemon is run with the -m switch.
*/
/* 
** These constants (all generated automatically by the parser generator)
** specify the various kinds of tokens (terminals) that the parser
** understands. 
**
** Each symbol here is a terminal symbol in the grammar.
*/
/* Make sure the INTERFACE macro is defined.
*/
#ifndef INTERFACE
# define INTERFACE 1
#endif
/* The next thing included is series of defines which control
** various aspects of the generated parser.
**    YYCODETYPE         is the data type used for storing terminal
**                       and nonterminal numbers.  "unsigned char" is
**                       used if there are fewer than 250 terminals
**                       and nonterminals.  "int" is used otherwise.
**    YYNOCODE           is a number of type YYCODETYPE which corresponds
**                       to no legal terminal or nonterminal number.  This
**                       number is used to fill in empty slots of the hash 
**                       table.
**    YYFALLBACK         If defined, this indicates that one or more tokens
**                       have fall-back values which should be used if the
**                       original value of the token will not parse.
**    YYACTIONTYPE       is the data type used for storing terminal
**                       and nonterminal numbers.  "unsigned char" is
**                       used if there are fewer than 250 rules and
**                       states combined.  "int" is used otherwise.
**    sqlite3ParserTOKENTYPE     is the data type used for minor tokens given 
**                       directly to the parser from the tokenizer.
**    YYMINORTYPE        is the data type used for all minor tokens.
**                       This is typically a union of many types, one of
**                       which is sqlite3ParserTOKENTYPE.  The entry in the union
**                       for base tokens is called "yy0".
**    YYSTACKDEPTH       is the maximum depth of the parser's stack.
**    sqlite3ParserARG_SDECL     A static variable declaration for the %extra_argument
**    sqlite3ParserARG_PDECL     A parameter declaration for the %extra_argument
**    sqlite3ParserARG_STORE     Code to store %extra_argument into yypParser
**    sqlite3ParserARG_FETCH     Code to extract %extra_argument from yypParser
**    YYNSTATE           the combined number of states.
**    YYNRULE            the number of rules in the grammar
**    YYERRORSYMBOL      is the code number of the error symbol.  If not
**                       defined, then do no error processing.
*/
#define YYCODETYPE unsigned char
#define YYNOCODE 247
#define YYACTIONTYPE unsigned short int
#define sqlite3ParserTOKENTYPE Token
typedef union {
  sqlite3ParserTOKENTYPE yy0;
  struct TrigEvent yy30;
  Expr* yy62;
  SrcList* yy151;
  Token yy198;
  struct LimitVal yy220;
  struct LikeOp yy222;
  IdList* yy240;
  int yy280;
  struct {int value; int mask;} yy359;
  TriggerStep* yy360;
  struct AttachKey yy361;
  Select* yy375;
  ExprList* yy418;
  int yy493;
} YYMINORTYPE;
#define YYSTACKDEPTH 100
#define sqlite3ParserARG_SDECL Parse *pParse;
#define sqlite3ParserARG_PDECL ,Parse *pParse
#define sqlite3ParserARG_FETCH Parse *pParse = yypParser->pParse
#define sqlite3ParserARG_STORE yypParser->pParse = pParse
#define YYNSTATE 581
#define YYNRULE 311
#define YYERRORSYMBOL 146
#define YYERRSYMDT yy493
#define YYFALLBACK 1
#define YY_NO_ACTION      (YYNSTATE+YYNRULE+2)
#define YY_ACCEPT_ACTION  (YYNSTATE+YYNRULE+1)
#define YY_ERROR_ACTION   (YYNSTATE+YYNRULE)

/* Next are that tables used to determine what action to take based on the
** current state and lookahead token.  These tables are used to implement
** functions that take a state number and lookahead value and return an
** action integer.  
**
** Suppose the action integer is N.  Then the action is determined as
** follows
**
**   0 <= N < YYNSTATE                  Shift N.  That is, push the lookahead
**                                      token onto the stack and goto state N.
**
**   YYNSTATE <= N < YYNSTATE+YYNRULE   Reduce by rule N-YYNSTATE.
**
**   N == YYNSTATE+YYNRULE              A syntax error has occurred.
**
**   N == YYNSTATE+YYNRULE+1            The parser accepts its input.
**
**   N == YYNSTATE+YYNRULE+2            No such action.  Denotes unused
**                                      slots in the yy_action[] table.
**
** The action table is constructed as a single large table named yy_action[].
** Given state S and lookahead X, the action is computed as
**
**      yy_action[ yy_shift_ofst[S] + X ]
**
** If the index value yy_shift_ofst[S]+X is out of range or if the value
** yy_lookahead[yy_shift_ofst[S]+X] is not equal to X or if yy_shift_ofst[S]
** is equal to YY_SHIFT_USE_DFLT, it means that the action is not in the table
** and that yy_default[S] should be used instead.  
**
** The formula above is for computing the action when the lookahead is
** a terminal symbol.  If the lookahead is a non-terminal (as occurs after
** a reduce action) then the yy_reduce_ofst[] array is used in place of
** the yy_shift_ofst[] array and YY_REDUCE_USE_DFLT is used in place of
** YY_SHIFT_USE_DFLT.
**
** The following are the tables generated in this section:
**
**  yy_action[]        A single table containing all actions.
**  yy_lookahead[]     A table containing the lookahead for each entry in
**                     yy_action.  Used to detect hash collisions.
**  yy_shift_ofst[]    For each state, the offset into yy_action for
**                     shifting terminals.
**  yy_reduce_ofst[]   For each state, the offset into yy_action for
**                     shifting non-terminals after a reduce.
**  yy_default[]       Default action for each state.
*/
static const YYACTIONTYPE yy_action[] = {
 /*     0 */   286,  584,  113,  140,  142,  138,  144,  581,  150,  152,
 /*    10 */   154,  156,  158,  160,  162,  164,  166,  168,    3,  577,
 /*    20 */   740,  170,  178,  150,  152,  154,  156,  158,  160,  162,
 /*    30 */   164,  166,  168,  158,  160,  162,  164,  166,  168,  135,
 /*    40 */    97,  171,  181,  186,  191,  180,  185,  146,  148,  140,
 /*    50 */   142,  138,  144,   51,  150,  152,  154,  156,  158,  160,
 /*    60 */   162,  164,  166,  168,   16,   17,   18,  114,    7,  248,
 /*    70 */   150,  152,  154,  156,  158,  160,  162,  164,  166,  168,
 /*    80 */    13,   37,  362,   40,   59,   67,   69,  326,  357,  170,
 /*    90 */     6,    5,  331,   95,  364,  359,   25,  374,  258,  893,
 /*   100 */     1,  580,  514,   13,    4,  575,   33,  135,   97,  171,
 /*   110 */   181,  186,  191,  180,  185,  146,  148,  140,  142,  138,
 /*   120 */   144,    9,  150,  152,  154,  156,  158,  160,  162,  164,
 /*   130 */   166,  168,  374,  136,  592,   80,  112,   99,  269,   34,
 /*   140 */    32,   33,  132,  373,  115,   14,   15,  378,  333,   99,
 /*   150 */   380,  387,  392,   13,  367,  370,  194,  170,   78,  500,
 /*   160 */   525,  315,  395,  369,  375,  408,   10,   98,   14,   15,
 /*   170 */    78,  200,  286,  864,  113,  135,   97,  171,  181,  186,
 /*   180 */   191,  180,  185,  146,  148,  140,  142,  138,  144,   80,
 /*   190 */   150,  152,  154,  156,  158,  160,  162,  164,  166,  168,
 /*   200 */   104,  105,  106,  661,  496,  376,  374,  170,  467,   13,
 /*   210 */     2,   28,  237,    4,  409,   33,    3,  577,   14,   15,
 /*   220 */    51,  132,  133,  115,  241,  135,   97,  171,  181,  186,
 /*   230 */   191,  180,  185,  146,  148,  140,  142,  138,  144,  114,
 /*   240 */   150,  152,  154,  156,  158,  160,  162,  164,  166,  168,
 /*   250 */    40,   59,   67,   69,  326,  357,  136,   44,   45,  501,
 /*   260 */   473,  463,  359,   36,  361,  130,  128,  660,  275,   31,
 /*   270 */    84,   99,  356,  378,   14,   15,  380,  387,  392,   52,
 /*   280 */   170,  117,  122,  123,  113,  541,  369,  643,  395,  348,
 /*   290 */    98,   54,   78,  200,  302,   57,   58,  819,  135,   97,
 /*   300 */   171,  181,  186,  191,  180,  185,  146,  148,  140,  142,
 /*   310 */   138,  144,  861,  150,  152,  154,  156,  158,  160,  162,
 /*   320 */   164,  166,  168,  104,  105,  106,  817,   80,   48,  316,
 /*   330 */   162,  164,  166,  168,  319,  277,   12,   49,   99,  303,
 /*   340 */   283,  818,   99,  124,  304,   99,  241,  172,  593,  114,
 /*   350 */    50,  193,   46,  378,  170,   13,  380,  387,  392,   78,
 /*   360 */   260,  276,   47,   78,  200,   64,   78,  260,  395,  174,
 /*   370 */   175,  221,  135,   97,  171,  181,  186,  191,  180,  185,
 /*   380 */   146,  148,  140,  142,  138,  144,  199,  150,  152,  154,
 /*   390 */   156,  158,  160,  162,  164,  166,  168,  173,  252,  261,
 /*   400 */   120,  122,  123,  212,  170,  268,  254,  130,  128,  288,
 /*   410 */   590,  176,  246,  187,  192,  414,  195,  241,  197,  198,
 /*   420 */    14,   15,  135,   97,  171,  181,  186,  191,  180,  185,
 /*   430 */   146,  148,  140,  142,  138,  144,  433,  150,  152,  154,
 /*   440 */   156,  158,  160,  162,  164,  166,  168,  311,   99,  707,
 /*   450 */    99,  422,  708,  417,  275,   81,  318,  598,   99,  219,
 /*   460 */    13,  231,  124,   13,  176,   48,  187,  192,   20,   78,
 /*   470 */   317,   78,  214,  195,   49,  197,  198,  462,  170,   78,
 /*   480 */   200,  116,   27,   13,  410,  113,  591,   50,   80,  225,
 /*   490 */   195,   11,  197,  198,  506,  235,  135,   97,  171,  181,
 /*   500 */   186,  191,  180,  185,  146,  148,  140,  142,  138,  144,
 /*   510 */    80,  150,  152,  154,  156,  158,  160,  162,  164,  166,
 /*   520 */   168,  277,  215,  324,  606,   14,   15,  301,   14,   15,
 /*   530 */   512,   13,  508,  240,  196,  486,  195,  685,  197,  198,
 /*   540 */    22,  834,  445,  331,  462,  170,  444,  276,   14,   15,
 /*   550 */   114,  468,  278,  394,  599,  280,  470,  288,  446,  680,
 /*   560 */    13,  321,  404,  135,   97,  171,  181,  186,  191,  180,
 /*   570 */   185,  146,  148,  140,  142,  138,  144,   80,  150,  152,
 /*   580 */   154,  156,  158,  160,  162,  164,  166,  168,   74,   99,
 /*   590 */   540,  366,   73,   99,  352,  289,   14,   15,  176,  333,
 /*   600 */   187,  192,  486,  869,  359,  273,  283,  542,  543,  867,
 /*   610 */    78,  500,  510,  170,   78,  323,  682,  176,  472,  187,
 /*   620 */   192,  746,  118,  470,  119,   14,   15,  195,  346,  197,
 /*   630 */   198,  135,   97,  171,  181,  186,  191,  180,  185,  146,
 /*   640 */   148,  140,  142,  138,  144,   99,  150,  152,  154,  156,
 /*   650 */   158,  160,  162,  164,  166,  168,  532,  334,  341,  343,
 /*   660 */   841,   39,  195,  170,  197,  198,   78,   94,  124,  356,
 /*   670 */   271,  353,  439,  441,  440,  544,  883,  428,   72,  862,
 /*   680 */   288,  135,   97,  171,  181,  186,  191,  180,  185,  146,
 /*   690 */   148,  140,  142,  138,  144,   13,  150,  152,  154,  156,
 /*   700 */   158,  160,  162,  164,  166,  168,  195,   99,  197,  198,
 /*   710 */   406,  330,  195,  170,  197,  198,  568,  405,  306,  195,
 /*   720 */    42,  197,  198,   65,  195,  539,  197,  198,   78,   96,
 /*   730 */    66,  135,   97,  171,  181,  186,  191,  180,  185,  146,
 /*   740 */   148,  140,  142,  138,  144,  885,  150,  152,  154,  156,
 /*   750 */   158,  160,  162,  164,  166,  168,   99,  740,   99,  298,
 /*   760 */    14,   15,  272,  170,   13,   74,  572,   86,  600,   73,
 /*   770 */   126,  127,  614,  709,  309,  478,   24,   78,  247,   78,
 /*   780 */   111,  135,   97,  171,  181,  186,  191,  180,  185,  146,
 /*   790 */   148,  140,  142,  138,  144,   99,  150,  152,  154,  156,
 /*   800 */   158,  160,  162,  164,  166,  168,   99,  238,  113,  239,
 /*   810 */   295,   26,  296,  170,  338,  337,   78,  137,  294,  320,
 /*   820 */   347,  239,  348,  390,  211,  348,   30,   78,  139,   14,
 /*   830 */    15,  135,  189,  171,  181,  186,  191,  180,  185,  146,
 /*   840 */   148,  140,  142,  138,  144,   99,  150,  152,  154,  156,
 /*   850 */   158,  160,  162,  164,  166,  168,   99,   80,   99,  372,
 /*   860 */   399,  442,  348,  170,  298,  243,   78,  141,  363,  601,
 /*   870 */   428,  437,  438,  114,  411,  269,  605,   78,  143,   78,
 /*   880 */   145,  448,   97,  171,  181,  186,  191,  180,  185,  146,
 /*   890 */   148,  140,  142,  138,  144,   99,  150,  152,  154,  156,
 /*   900 */   158,  160,  162,  164,  166,  168,   99,   80,   99,  430,
 /*   910 */    99,  296,  555,  170,  413,  856,   78,  147,  672,  457,
 /*   920 */   352,  348,  298,  443,  465,   45,   35,   78,  149,   78,
 /*   930 */   151,   78,  153,  171,  181,  186,  191,  180,  185,  146,
 /*   940 */   148,  140,  142,  138,  144,   99,  150,  152,  154,  156,
 /*   950 */   158,  160,  162,  164,  166,  168,   99,  459,   99,   29,
 /*   960 */    79,  464,  183,  483,   71,  339,   78,  155,  709,  421,
 /*   970 */   428,   79,  109,   99,  491,   71,  296,   78,  157,   78,
 /*   980 */   159,  490,  243,  109,   99,  340,   99,  449,  857,  223,
 /*   990 */    99,  460,  182,  709,   78,  161,   99,  349,  827,  136,
 /*  1000 */   223,   99,   80,  201,   99,   78,  163,   78,  165,  507,
 /*  1010 */   136,   78,  167,   42,  201,   38,  493,   78,  169,  569,
 /*  1020 */   207,  205,   78,  177,  674,   78,  179,  477,  203,   76,
 /*  1030 */    77,  207,  205,   98,   99,   84,   99,   42,  336,  203,
 /*  1040 */    76,   77,   99,   43,   98,   41,  428,   79,  494,   80,
 /*  1050 */   428,   71,   84,   99,  352,   78,  188,   78,  190,  109,
 /*  1060 */   499,  428,  497,   78,  202,   60,  104,  105,  106,  107,
 /*  1070 */   108,  209,  213,   99,   78,  204,  223,  104,  105,  106,
 /*  1080 */   107,  108,  209,  213,  820,  509,  136,   53,  383,  511,
 /*  1090 */   201,   99,   56,   61,   78,  206,   55,  428,  428,  889,
 /*  1100 */   513,   99,  243,   99,  352,   99,   79,  207,  205,  312,
 /*  1110 */    71,   99,   78,  208,  483,  203,   76,   77,  109,  533,
 /*  1120 */    98,  497,   78,  220,   78,  222,   78,  232,   84,   99,
 /*  1130 */   428,  353,   78,  234,  352,  223,  517,  521,  389,   99,
 /*  1140 */    62,  530,   99,   64,   63,  136,   68,  529,   70,  201,
 /*  1150 */    78,  236,  352,  104,  105,  106,  107,  108,  209,  213,
 /*  1160 */    78,  249,   99,   78,  265,  877,  207,  205,  398,  527,
 /*  1170 */    99,  615,  616,  313,  203,   76,   77,   99,  523,   98,
 /*  1180 */    80,  353,    8,   78,  270,   99,  456,   19,   21,   23,
 /*  1190 */   412,   78,  300,   75,   78,  310,   82,   84,   78,  365,
 /*  1200 */   563,   83,  547,   99,   87,  553,   78,  393,   85,  557,
 /*  1210 */    99,  353,  104,  105,  106,  107,  108,  209,  213,   99,
 /*  1220 */   269,  536,   99,  467,   78,  434,   88,  266,  534,  353,
 /*  1230 */   560,   78,  481,  566,  264,   89,  250,   90,   93,   91,
 /*  1240 */    78,  485,  101,   78,  498,   92,  100,  102,  103,  110,
 /*  1250 */   131,  121,  134,  125,  129,  168,  184,  242,  686,  687,
 /*  1260 */   688,  210,  233,  218,  224,  216,  227,  226,  217,  229,
 /*  1270 */   228,  230,  243,  251,  515,  519,  463,  245,  253,  244,
 /*  1280 */   505,  257,  255,  256,  258,   84,  259,  262,  263,  239,
 /*  1290 */   267,  279,  274,  281,  282,  299,  285,  292,  284,  287,
 /*  1300 */   290,  293,  297,  305,  314,  291,  307,  322,  308,  325,
 /*  1310 */   327,  345,  329,  328,  332,  350,  354,  330,  358,  335,
 /*  1320 */   342,  379,  381,  382,  344,  351,  368,  385,  355,  371,
 /*  1330 */   388,  360,  396,  397,  400,  401,  415,   54,  416,  386,
 /*  1340 */   384,  391,  418,  402,  407,  419,  377,  420,  423,  424,
 /*  1350 */   403,  426,  425,  427,  429,  435,  431,  849,  436,  854,
 /*  1360 */   432,  855,  450,  447,  451,  452,  454,  453,  825,  455,
 /*  1370 */   458,  826,  469,  461,  466,  747,  748,  848,  471,  464,
 /*  1380 */   863,  480,  474,  475,  476,  482,  865,  479,  487,  484,
 /*  1390 */   489,  488,  492,  866,  495,  868,  504,  679,  502,  681,
 /*  1400 */   833,  875,  518,  503,  516,  739,  520,  524,  522,  742,
 /*  1410 */   745,  531,  526,  835,  535,  528,  538,  537,  836,  837,
 /*  1420 */   838,  839,  545,  546,  840,  550,  876,  556,  551,  878,
 /*  1430 */   548,  549,  554,  879,  559,  882,  884,  562,  886,  561,
 /*  1440 */   552,  558,  564,  567,  570,  565,  571,  887,  576,  574,
 /*  1450 */   573,  888,  578,  559,  559,  579,
};
static const YYCODETYPE yy_lookahead[] = {
 /*     0 */    28,   11,   30,   77,   78,   79,   80,    0,   82,   83,
 /*    10 */    84,   85,   86,   87,   88,   89,   90,   91,   11,   12,
 /*    20 */    11,   49,   81,   82,   83,   84,   85,   86,   87,   88,
 /*    30 */    89,   90,   91,   86,   87,   88,   89,   90,   91,   67,
 /*    40 */    68,   69,   70,   71,   72,   73,   74,   75,   76,   77,
 /*    50 */    78,   79,   80,   69,   82,   83,   84,   85,   86,   87,
 /*    60 */    88,   89,   90,   91,   17,   18,   19,   95,   11,   29,
 /*    70 */    82,   83,   84,   85,   86,   87,   88,   89,   90,   91,
 /*    80 */    30,   97,   98,   99,  100,  101,  102,  103,  104,   49,
 /*    90 */   150,  151,   50,   53,   26,  111,  156,  155,   30,  147,
 /*   100 */   148,  149,  162,   30,  152,  163,  164,   67,   68,   69,
 /*   110 */    70,   71,   72,   73,   74,   75,   76,   77,   78,   79,
 /*   120 */    80,  153,   82,   83,   84,   85,   86,   87,   88,   89,
 /*   130 */    90,   91,  155,   65,   11,  195,   28,  155,  129,  165,
 /*   140 */   163,  164,  168,  169,  170,   95,   96,   97,  106,  155,
 /*   150 */   100,  101,  102,   30,   86,   87,  162,   49,  176,  177,
 /*   160 */   220,   88,  112,   95,  187,  188,  154,   99,   95,   96,
 /*   170 */   176,  177,   28,   21,   30,   67,   68,   69,   70,   71,
 /*   180 */    72,   73,   74,   75,   76,   77,   78,   79,   80,  195,
 /*   190 */    82,   83,   84,   85,   86,   87,   88,   89,   90,   91,
 /*   200 */   132,  133,  134,   27,  222,   29,  155,   49,   56,   30,
 /*   210 */   149,  160,  218,  152,  163,  164,   11,   12,   95,   96,
 /*   220 */    69,  168,  169,  170,  230,   67,   68,   69,   70,   71,
 /*   230 */    72,   73,   74,   75,   76,   77,   78,   79,   80,   95,
 /*   240 */    82,   83,   84,   85,   86,   87,   88,   89,   90,   91,
 /*   250 */    99,  100,  101,  102,  103,  104,   65,  192,  193,  107,
 /*   260 */   108,  109,  111,  174,  175,   86,   87,   27,   29,   29,
 /*   270 */   118,  155,  183,   97,   95,   96,  100,  101,  102,   99,
 /*   280 */    49,  171,  172,  173,   30,  106,   95,   27,  112,   29,
 /*   290 */    99,  111,  176,  177,  162,   17,   18,  139,   67,   68,
 /*   300 */    69,   70,   71,   72,   73,   74,   75,   76,   77,   78,
 /*   310 */    79,   80,   15,   82,   83,   84,   85,   86,   87,   88,
 /*   320 */    89,   90,   91,  132,  133,  134,   21,  195,   22,   27,
 /*   330 */    88,   89,   90,   91,  218,   96,  155,   31,  155,  207,
 /*   340 */   208,   21,  155,  233,  212,  155,  230,   49,   11,   95,
 /*   350 */    44,   26,   46,   97,   49,   30,  100,  101,  102,  176,
 /*   360 */   177,  122,   56,  176,  177,  105,  176,  177,  112,   71,
 /*   370 */    72,  140,   67,   68,   69,   70,   71,   72,   73,   74,
 /*   380 */    75,   76,   77,   78,   79,   80,   27,   82,   83,   84,
 /*   390 */    85,   86,   87,   88,   89,   90,   91,   99,  215,  216,
 /*   400 */   171,  172,  173,   27,   49,  218,  216,   86,   87,  168,
 /*   410 */    11,  223,  224,  225,  226,   24,  114,  230,  116,  117,
 /*   420 */    95,   96,   67,   68,   69,   70,   71,   72,   73,   74,
 /*   430 */    75,   76,   77,   78,   79,   80,  139,   82,   83,   84,
 /*   440 */    85,   86,   87,   88,   89,   90,   91,  206,  155,   27,
 /*   450 */   155,   60,   27,   62,   29,  162,   27,   11,  155,  139,
 /*   460 */    30,  141,  233,   30,  223,   22,  225,  226,  154,  176,
 /*   470 */   177,  176,  177,  114,   31,  116,  117,  162,   49,  176,
 /*   480 */   177,   26,   26,   30,   28,   30,   11,   44,  195,   46,
 /*   490 */   114,   16,  116,  117,   24,  140,   67,   68,   69,   70,
 /*   500 */    71,   72,   73,   74,   75,   76,   77,   78,   79,   80,
 /*   510 */   195,   82,   83,   84,   85,   86,   87,   88,   89,   90,
 /*   520 */    91,   96,  227,   27,   11,   95,   96,   26,   95,   96,
 /*   530 */    60,   30,   62,  230,  115,  220,  114,  118,  116,  117,
 /*   540 */   154,   11,   32,   50,  162,   49,   36,  122,   95,   96,
 /*   550 */    95,  236,  122,  178,   11,  122,  241,  168,   48,   11,
 /*   560 */    30,   88,   69,   67,   68,   69,   70,   71,   72,   73,
 /*   570 */    74,   75,   76,   77,   78,   79,   80,  195,   82,   83,
 /*   580 */    84,   85,   86,   87,   88,   89,   90,   91,  115,  155,
 /*   590 */   155,   27,  119,  155,  155,  206,   95,   96,  223,  106,
 /*   600 */   225,  226,  220,   11,  111,  207,  208,  172,  173,   11,
 /*   610 */   176,  177,  142,   49,  176,  177,   11,  223,  236,  225,
 /*   620 */   226,   11,   27,  241,   29,   95,   96,  114,  189,  116,
 /*   630 */   117,   67,   68,   69,   70,   71,   72,   73,   74,   75,
 /*   640 */    76,   77,   78,   79,   80,  155,   82,   83,   84,   85,
 /*   650 */    86,   87,   88,   89,   90,   91,  222,  107,  108,  109,
 /*   660 */    11,  175,  114,   49,  116,  117,  176,  177,  233,  183,
 /*   670 */    29,  232,  107,  108,  109,   26,   11,  155,   26,   15,
 /*   680 */   168,   67,   68,   69,   70,   71,   72,   73,   74,   75,
 /*   690 */    76,   77,   78,   79,   80,   30,   82,   83,   84,   85,
 /*   700 */    86,   87,   88,   89,   90,   91,  114,  155,  116,  117,
 /*   710 */   183,  184,  114,   49,  116,  117,  194,  190,  206,  114,
 /*   720 */   106,  116,  117,   34,  114,   76,  116,  117,  176,  177,
 /*   730 */    41,   67,   68,   69,   70,   71,   72,   73,   74,   75,
 /*   740 */    76,   77,   78,   79,   80,   11,   82,   83,   84,   85,
 /*   750 */    86,   87,   88,   89,   90,   91,  155,   11,  155,  155,
 /*   760 */    95,   96,  121,   49,   30,  115,  244,  198,   11,  119,
 /*   770 */   132,  133,  120,   28,  205,   29,  154,  176,  177,  176,
 /*   780 */   177,   67,   68,   69,   70,   71,   72,   73,   74,   75,
 /*   790 */    76,   77,   78,   79,   80,  155,   82,   83,   84,   85,
 /*   800 */    86,   87,   88,   89,   90,   91,  155,   27,   30,   29,
 /*   810 */    27,  157,   29,   49,   98,   99,  176,  177,  214,   27,
 /*   820 */    27,   29,   29,   27,  162,   29,   27,  176,  177,   95,
 /*   830 */    96,   67,   68,   69,   70,   71,   72,   73,   74,   75,
 /*   840 */    76,   77,   78,   79,   80,  155,   82,   83,   84,   85,
 /*   850 */    86,   87,   88,   89,   90,   91,  155,  195,  155,  167,
 /*   860 */    27,   52,   29,   49,  155,  120,  176,  177,  176,   11,
 /*   870 */   155,   58,   59,   95,  162,  129,   11,  176,  177,  176,
 /*   880 */   177,   25,   68,   69,   70,   71,   72,   73,   74,   75,
 /*   890 */    76,   77,   78,   79,   80,  155,   82,   83,   84,   85,
 /*   900 */    86,   87,   88,   89,   90,   91,  155,  195,  155,  194,
 /*   910 */   155,   29,  134,   49,  158,  106,  176,  177,   11,   27,
 /*   920 */   155,   29,  155,  214,  192,  193,  166,  176,  177,  176,
 /*   930 */   177,  176,  177,   69,   70,   71,   72,   73,   74,   75,
 /*   940 */    76,   77,   78,   79,   80,  155,   82,   83,   84,   85,
 /*   950 */    86,   87,   88,   89,   90,   91,  155,  101,  155,  161,
 /*   960 */    26,   67,   69,  155,   30,   37,  176,  177,  106,  162,
 /*   970 */   155,   26,   38,  155,   27,   30,   29,  176,  177,  176,
 /*   980 */   177,  214,  120,   38,  155,   57,  155,  231,  106,   55,
 /*   990 */   155,  235,   99,   11,  176,  177,  155,  232,  142,   65,
 /*  1000 */    55,  155,  195,   69,  155,  176,  177,  176,  177,  194,
 /*  1010 */    65,  176,  177,  106,   69,  155,  162,  176,  177,   64,
 /*  1020 */    86,   87,  176,  177,  130,  176,  177,  219,   94,   95,
 /*  1030 */    96,   86,   87,   99,  155,  118,  155,  106,  110,   94,
 /*  1040 */    95,   96,  155,   39,   99,  178,  155,   26,  131,  195,
 /*  1050 */   155,   30,  118,  155,  155,  176,  177,  176,  177,   38,
 /*  1060 */    27,  155,   29,  176,  177,   51,  132,  133,  134,  135,
 /*  1070 */   136,  137,  138,  155,  176,  177,   55,  132,  133,  134,
 /*  1080 */   135,  136,  137,  138,  139,  194,   65,  178,  189,  194,
 /*  1090 */    69,  155,   47,  179,  176,  177,  186,  155,  155,  144,
 /*  1100 */   194,  155,  120,  155,  155,  155,   26,   86,   87,   88,
 /*  1110 */    30,  155,  176,  177,  155,   94,   95,   96,   38,   27,
 /*  1120 */    99,   29,  176,  177,  176,  177,  176,  177,  118,  155,
 /*  1130 */   155,  232,  176,  177,  155,   55,  194,  194,  189,  155,
 /*  1140 */   178,  131,  155,  105,  180,   65,  178,  162,   26,   69,
 /*  1150 */   176,  177,  155,  132,  133,  134,  135,  136,  137,  138,
 /*  1160 */   176,  177,  155,  176,  177,   11,   86,   87,  189,  194,
 /*  1170 */   155,  120,  120,  155,   94,   95,   96,  155,  219,   99,
 /*  1180 */   195,  232,   15,  176,  177,  155,  189,   20,   21,   22,
 /*  1190 */    23,  176,  177,  197,  176,  177,  196,  118,  176,  177,
 /*  1200 */    33,  195,   35,  155,  199,   51,  176,  177,  197,   42,
 /*  1210 */   155,  232,  132,  133,  134,  135,  136,  137,  138,  155,
 /*  1220 */   129,   54,  155,   56,  176,  177,  200,  126,   61,  232,
 /*  1230 */    63,  176,  177,   66,  127,  201,  124,  202,  128,  203,
 /*  1240 */   176,  177,  155,  176,  177,  204,  120,  120,  155,   26,
 /*  1250 */   168,   27,   27,  234,  234,   91,   99,  155,  118,  118,
 /*  1260 */   118,   26,  139,   21,   26,  228,  193,   27,  229,  155,
 /*  1270 */    29,   27,  120,  125,  107,  108,  109,  159,   29,  155,
 /*  1280 */   113,  104,  217,  179,   30,  118,  167,  217,  179,   29,
 /*  1290 */   125,  155,  209,  155,  122,  106,  159,  123,  155,  155,
 /*  1300 */   210,   26,  155,   27,  120,  211,  210,   27,  211,  178,
 /*  1310 */   155,   26,  182,  181,  155,  217,  217,  184,  167,  185,
 /*  1320 */   185,  155,   51,   26,  185,  179,  176,   27,  179,  176,
 /*  1330 */    26,  186,   51,   26,  103,  155,  155,  111,  159,  178,
 /*  1340 */   180,  178,  155,  181,  188,  159,  188,   28,  155,  159,
 /*  1350 */   182,  238,  237,  106,  159,   45,  239,   15,   43,  106,
 /*  1360 */   240,  106,  142,   52,  155,  159,  155,  106,   11,   26,
 /*  1370 */   178,  142,   21,   15,  191,  130,  130,   11,   11,   67,
 /*  1380 */    21,   76,  191,  155,  110,  200,   11,  155,  130,   76,
 /*  1390 */    26,  155,  221,   11,   26,   11,  200,   11,  121,   11,
 /*  1400 */    11,   11,  200,  155,  121,   11,  191,  200,  110,   11,
 /*  1410 */    11,   26,  130,   11,  155,  221,  159,  155,   11,   11,
 /*  1420 */    11,   11,  155,   27,   11,   28,   11,   40,  155,   11,
 /*  1430 */   242,  168,  168,   11,  155,   11,   11,  159,   11,  155,
 /*  1440 */   243,  242,  155,   24,  143,  159,  155,   11,  145,  245,
 /*  1450 */   144,   11,   13,  246,  246,   14,
};
#define YY_SHIFT_USE_DFLT (-75)
static const short yy_shift_ofst[] = {
 /*     0 */   205,    7,  -75,  -75, 1167,  -10,   57,  -75,   47,  475,
 /*    10 */   399,  123,  337,  -75,  -75,  -75,  -75,  -75,  -75,  475,
 /*    20 */   446,  475,  543,  475,  757,  456,  858,  453,  240,  799,
 /*    30 */   865,   50,  -75,  254,  -75,  -16,  -75,  453,  151,  -75,
 /*    40 */   931,  -75, 1004,  306,  -75,  -75,  -75,  -75,  -75,  -75,
 /*    50 */   -75,  180,  931,  -75, 1045,  -75,  278,  -75,  -75, 1014,
 /*    60 */   689,  931, 1038,  -75,  -75,  -75,  -75,  931,  -75, 1122,
 /*    70 */  1080,  652,  473,  -75,  -75, 1080, 1051, 1052,  -75,  934,
 /*    80 */   -75,  302, 1079,  -75,  650,  -75,  641, 1091, 1101, 1107,
 /*    90 */  1112, 1110,  -75, 1080,   40, 1080,  714, 1080,  -75, 1126,
 /*   100 */   453, 1127,  453,  -75,  -75,  -75,  -75,  -75,  -75, 1223,
 /*   110 */  1080,  108,  254,  -75,  -75,  455,  321,  595,  -75,  321,
 /*   120 */  1224,  -75,  -75,  -75,  638,  -75,  -75,  -75,  638,  -75,
 /*   130 */   -75,  -75,  -75, 1225,  -75, 1080,  -75,  814, 1080,  -12,
 /*   140 */  1080,  -12, 1080,  -12, 1080,  -12, 1080,  -74, 1080,  -74,
 /*   150 */  1080,  -53, 1080,  -53, 1080,  -53, 1080,  -53, 1080,  242,
 /*   160 */  1080,  242, 1080, 1164, 1080, 1164, 1080, 1164, 1080,  -75,
 /*   170 */   -75,  298,  -75,  -75,  -75,  -75, 1080,  -59, 1080,  -12,
 /*   180 */   -75,  893,  -75, 1157,  -75,  -75,  -75, 1080,  764, 1080,
 /*   190 */   -74,  -75,  325,  934,  359,  419, 1140, 1141, 1142,  -75,
 /*   200 */   714, 1080,  864, 1080,  -75, 1080,  -75, 1080,  -75, 1235,
 /*   210 */  1079,  376,  -75,  945,  158, 1123,  320, 1242,  -75, 1080,
 /*   220 */   231, 1080,  714, 1238,  443, 1240,  -75, 1241,  453, 1244,
 /*   230 */   -75, 1080,  305, 1080,  355, 1080,  714,  780,  -75, 1080,
 /*   240 */   -75,  -75, 1152,  453,  -75,  -75,  -75,  864, 1080,  714,
 /*   250 */  1148, 1080, 1249, 1080, 1177,  689,  -75, 1254,  -75,  -75,
 /*   260 */   714, 1177,  689,  -75, 1080,  714, 1165, 1080, 1260, 1080,
 /*   270 */   714,  -75,  -75,  239,  -75,  -75,  -75,  430,  -75,  433,
 /*   280 */   -75, 1172,  -75,  501, 1152,  144,  453,  -75,  -75, 1189,
 /*   290 */  1174,  -75, 1275,  453,  783,  -75,  453,  -75,  -75, 1080,
 /*   300 */   714, 1079,  422,  425, 1276,  144, 1189, 1174,  -75, 1021,
 /*   310 */   -28,  -75,  -75, 1184,   73,  -75,  -75,  429,  -75,  792,
 /*   320 */   -75, 1280,  -75,  496,  931,  -75,  453, 1285,  -75,   42,
 /*   330 */   -75,  453,  -75,  550,  928,  -75,  716,  -75,  -75,  -75,
 /*   340 */   -75,  928,  -75,  928,  -75,  453,  793,  -75,  453, 1177,
 /*   350 */   689,  -75,  -75, 1177,  689,  -75,  -75, 1254,  -75, 1045,
 /*   360 */   -75,  -75,   68,  -75, 1080,  564,  -75,  191,  -75,  -75,
 /*   370 */   191,  -75,  -75,  -75,  -75,  176,  256,  -75,  453,  -75,
 /*   380 */  1271, 1297,  453,  260, 1300,  931,  -75, 1304,  453,  796,
 /*   390 */   931,  -75, 1080,  614,  -75, 1281, 1307,  453,  833, 1231,
 /*   400 */   453, 1285,  -75,  493, 1226,  -75,  -75,  -75,  -75,  -75,
 /*   410 */  1079,  513,  856,  391,  453, 1152,  -75,  453,  745, 1319,
 /*   420 */  1079,  548,  453, 1152,  510,  565, 1247,  453, 1152,  -75,
 /*   430 */  1310,  297, 1342, 1080,  664, 1315,  813,  -75,  -75, 1253,
 /*   440 */  1255,  809,  453,  882,  -75,  -75, 1311,  -75,  -75, 1220,
 /*   450 */   453,  862, 1261,  453, 1343,  453,  892,  907, 1357, 1229,
 /*   460 */  1358,  152,  592,  894,  306,  -75, 1245, 1246, 1351, 1366,
 /*   470 */  1367,  152, 1359, 1312,  453, 1274,  453,  746,  453, 1305,
 /*   480 */  1080,  714, 1375, 1313, 1080,  714, 1258,  453, 1364,  453,
 /*   490 */   947,  -75,  917,  598, 1368, 1080, 1033, 1080,  714, 1382,
 /*   500 */   714, 1277,  453,    9, 1384,  470,  453, 1386,  453, 1388,
 /*   510 */   453, 1389,  453, 1390,  605, 1283,  453,    9, 1394, 1312,
 /*   520 */   453, 1298,  453,  746, 1398, 1282,  453, 1364, 1010,  610,
 /*   530 */  1385, 1080, 1092, 1399,  530, 1402,  453, 1152,  649,  179,
 /*   540 */  1407, 1408, 1409, 1410,  453, 1396, 1413, 1387,  254, 1397,
 /*   550 */   453, 1154, 1415,  778, 1418, 1422,  -75, 1387,  453, 1424,
 /*   560 */   665,  982, 1425,  734,  982, 1427, 1419,  453,  955, 1301,
 /*   570 */   453, 1436, 1306, 1303,  453, 1440,  -75, 1439, 1441,  -75,
 /*   580 */   -75,
};
#define YY_REDUCE_USE_DFLT (-61)
static const short yy_reduce_ofst[] = {
 /*     0 */   -48,   61,  -61,  -61,  -60,  -61,  -61,  -61,  -32,   12,
 /*    10 */   -61,  181,  -61,  -61,  -61,  -61,  -61,  -61,  -61,  314,
 /*    20 */   -61,  386,  -61,  622,  -61,  654,  -61,   51,  798,  -61,
 /*    30 */   -61,  -23,  -61,  -26,  760,   89,  -61,  860,  486,  -61,
 /*    40 */   867,  -61,  -61,   65,  -61,  -61,  -61,  -61,  -61,  -61,
 /*    50 */   -61,  -61,  909,  -61,  910,  -61,  -61,  -61,  -61,  -61,
 /*    60 */   914,  962,  964,  -61,  -61,  -61,  -61,  968,  -61,  -61,
 /*    70 */   438,  -61,  996,  -61,  -61,  116,  -61,  -61,  -61,  293,
 /*    80 */   -61, 1000, 1006,  -61, 1011,  569, 1005, 1026, 1034, 1035,
 /*    90 */  1036, 1041,  -61,  490,  394,  552,  394,  601,  -61,  -61,
 /*   100 */  1087,  -61, 1093,  -61,  -61,  -61,  -61,  -61,  -61,  -61,
 /*   110 */   603,  394,   53,  -61,  -61, 1082,  110,  -61,  -61,  229,
 /*   120 */   -61,  -61,  -61,  -61, 1019,  -61,  -61,  -61, 1020,  -61,
 /*   130 */   -61,  -61,  -61,  -61,  -61,  640,  -61,  394,  651,  394,
 /*   140 */   690,  394,  701,  394,  703,  394,  740,  394,  751,  394,
 /*   150 */   753,  394,  755,  394,  790,  394,  801,  394,  803,  394,
 /*   160 */   818,  394,  829,  394,  831,  394,  835,  394,  841,  394,
 /*   170 */   -61,  -61,  -61,  -61,  -61,  -61,  846,  188,  849,  394,
 /*   180 */   -61,  -61,  -61,  -61,  -61,  -61,  -61,  879,  394,  881,
 /*   190 */   394,  -61, 1102,   -6, 1000,  -61,  -61,  -61,  -61,  -61,
 /*   200 */   394,  887,  394,  898,  394,  918,  394,  936,  394,  -61,
 /*   210 */   662, 1000,  -61,  295,  394, 1037, 1039,  -61,  -61,  946,
 /*   220 */   394,  948,  394,  -61, 1073,  -61,  -61,  -61, 1114,  -61,
 /*   230 */   -61,  950,  394,  956,  394,  974,  394,  -61,  -61,  303,
 /*   240 */   -61,  -61, 1118, 1124,  -61,  -61,  -61,  394,  984,  394,
 /*   250 */   -61,  183,  -61,  190, 1065, 1104,  -61, 1119,  -61,  -61,
 /*   260 */   394, 1070, 1109,  -61,  987,  394,  -61,  187,  -61, 1007,
 /*   270 */   394,  -61,  398, 1083,  -61,  -61,  -61, 1136,  -61, 1138,
 /*   280 */   -61,  -61,  -61, 1143, 1137,  389, 1144,  -61,  -61, 1090,
 /*   290 */  1094,  -61,  -61,  604,  -61,  -61, 1147,  -61,  -61, 1015,
 /*   300 */   394,  132, 1000, 1083,  -61,  512, 1096, 1097,  -61, 1018,
 /*   310 */   241,  -61,  -61,  -61, 1087,  -61,  -61,  394,  -61,  -61,
 /*   320 */   -61,  -61,  -61,  394, 1131,  -61, 1155, 1132, 1130, 1133,
 /*   330 */   -61, 1159,  -61,  -61, 1134,  -61,  -61,  -61,  -61,  -61,
 /*   340 */   -61, 1135,  -61, 1139,  -61,  439,  -61,  -61,  765, 1098,
 /*   350 */  1146,  -61,  -61, 1099, 1149,  -61,  -61, 1151,  -61, 1145,
 /*   360 */   -61,  -61,  692,  -61, 1022,  394,  -61, 1150,  -61,  -61,
 /*   370 */  1153,  -61,  -61,  -61,  -61, 1156, 1158,  -61, 1166,  -61,
 /*   380 */   -61,  -61,  899, 1160,  -61, 1161,  -61,  -61,  949,  -61,
 /*   390 */  1163,  -61, 1030,  375,  -61,  -61,  -61,  979,  -61,  -61,
 /*   400 */  1180, 1162, 1168,  527,  -61,  -61,  -61,  -61,  -61,  -61,
 /*   410 */   712, 1000,  756,  -61, 1181, 1179,  -61, 1187, 1186,  -61,
 /*   420 */   807, 1000, 1193, 1190, 1115, 1113,  -61,  715, 1195,  -61,
 /*   430 */  1117, 1120,  -61, 1048,  394,  -61,  -61,  -61,  -61,  -61,
 /*   440 */   -61,  -61,  709,  -61,  -61,  -61,  -61,  -61,  -61,  -61,
 /*   450 */  1209, 1206,  -61, 1211,  -61,  997,  -61, 1192,  -61,  -61,
 /*   460 */   -61,  315, 1000, 1183,  732,  -61,  -61,  -61,  -61,  -61,
 /*   470 */   -61,  382,  -61, 1191, 1228,  -61,  808, 1185, 1232,  -61,
 /*   480 */  1055,  394,  -61,  -61, 1064,  394,  -61, 1236, 1171,  767,
 /*   490 */   -61,  -61,  854, 1000,  -61,  -18,  -61, 1067,  394,  -61,
 /*   500 */   394,  -61, 1248, 1196,  -61,  -61,  815,  -61,  891,  -61,
 /*   510 */   895,  -61,  906,  -61, 1000,  -61,  942, 1202,  -61, 1215,
 /*   520 */   943,  -61,  959, 1207,  -61,  -61,  975, 1194,  985, 1000,
 /*   530 */   -61,  434,  -61,  -61, 1259,  -61, 1262, 1257,  -61,  435,
 /*   540 */   -61,  -61,  -61,  -61, 1267,  -61,  -61, 1188, 1263,  -61,
 /*   550 */  1273, 1197,  -61, 1264,  -61,  -61,  -61, 1199, 1279,  -61,
 /*   560 */  1284, 1278,  -61, 1287, 1286,  -61,  -61,  522,  -61,  -61,
 /*   570 */  1291,  -61,  -61, 1204,  -58,  -61,  -61,  -61,  -61,  -61,
 /*   580 */   -61,
};
static const YYACTIONTYPE yy_default[] = {
 /*     0 */   587,  587,  582,  585,  892,  892,  892,  586,  594,  892,
 /*    10 */   892,  892,  892,  614,  615,  616,  595,  596,  597,  892,
 /*    20 */   892,  892,  892,  892,  892,  892,  892,  892,  892,  892,
 /*    30 */   892,  892,  607,  617,  627,  609,  626,  892,  892,  628,
 /*    40 */   672,  635,  892,  892,  673,  676,  677,  678,  872,  873,
 /*    50 */   874,  892,  672,  636,  657,  655,  892,  658,  659,  892,
 /*    60 */   728,  672,  643,  637,  644,  726,  727,  672,  638,  892,
 /*    70 */   892,  758,  692,  690,  691,  824,  764,  759,  755,  892,
 /*    80 */   683,  892,  892,  684,  692,  694,  701,  740,  731,  733,
 /*    90 */   721,  735,  689,  892,  736,  892,  737,  892,  757,  892,
 /*   100 */   892,  760,  892,  761,  762,  763,  765,  766,  767,  892,
 /*   110 */   892,  892,  892,  612,  613,  619,  847,  892,  620,  847,
 /*   120 */   892,  621,  624,  625,  892,  842,  844,  845,  892,  843,
 /*   130 */   846,  623,  622,  892,  768,  892,  771,  773,  892,  774,
 /*   140 */   892,  775,  892,  776,  892,  777,  892,  778,  892,  779,
 /*   150 */   892,  780,  892,  781,  892,  782,  892,  783,  892,  784,
 /*   160 */   892,  785,  892,  786,  892,  787,  892,  788,  892,  789,
 /*   170 */   790,  892,  791,  798,  805,  808,  892,  793,  892,  792,
 /*   180 */   795,  892,  796,  892,  799,  797,  804,  892,  892,  892,
 /*   190 */   806,  807,  892,  824,  892,  892,  892,  892,  892,  811,
 /*   200 */   823,  892,  800,  892,  801,  892,  802,  892,  803,  892,
 /*   210 */   892,  892,  813,  892,  892,  892,  892,  892,  814,  892,
 /*   220 */   892,  892,  815,  892,  892,  892,  870,  892,  892,  892,
 /*   230 */   871,  892,  892,  892,  892,  892,  816,  892,  809,  824,
 /*   240 */   821,  822,  709,  892,  710,  812,  794,  772,  892,  738,
 /*   250 */   892,  892,  722,  892,  729,  728,  723,  892,  611,  730,
 /*   260 */   725,  729,  728,  724,  892,  734,  892,  824,  732,  892,
 /*   270 */   741,  693,  704,  702,  703,  712,  713,  892,  714,  892,
 /*   280 */   715,  892,  716,  892,  709,  700,  892,  698,  699,  718,
 /*   290 */   720,  705,  892,  892,  892,  719,  892,  753,  754,  892,
 /*   300 */   717,  704,  892,  892,  892,  700,  718,  720,  706,  892,
 /*   310 */   700,  695,  696,  892,  892,  697,  810,  892,  756,  892,
 /*   320 */   769,  892,  770,  892,  672,  639,  892,  828,  645,  640,
 /*   330 */   646,  892,  647,  892,  892,  648,  892,  651,  652,  653,
 /*   340 */   654,  892,  649,  892,  650,  892,  892,  829,  892,  729,
 /*   350 */   728,  830,  832,  729,  728,  831,  641,  892,  642,  657,
 /*   360 */   656,  629,  892,  630,  892,  892,  631,  892,  632,  764,
 /*   370 */   892,  633,  634,  618,  610,  892,  892,  662,  892,  665,
 /*   380 */   892,  892,  892,  892,  892,  672,  666,  892,  892,  892,
 /*   390 */   672,  667,  892,  672,  668,  892,  892,  892,  892,  892,
 /*   400 */   892,  828,  645,  670,  892,  669,  671,  663,  664,  608,
 /*   410 */   892,  892,  604,  892,  892,  709,  602,  892,  892,  892,
 /*   420 */   892,  892,  892,  709,  853,  892,  892,  892,  709,  711,
 /*   430 */   858,  892,  892,  892,  892,  892,  892,  859,  860,  892,
 /*   440 */   892,  892,  892,  892,  850,  851,  892,  852,  603,  892,
 /*   450 */   892,  892,  892,  892,  892,  892,  892,  892,  892,  892,
 /*   460 */   892,  892,  892,  892,  892,  675,  892,  892,  892,  892,
 /*   470 */   892,  892,  892,  674,  892,  892,  892,  892,  892,  892,
 /*   480 */   892,  743,  892,  892,  892,  744,  892,  892,  751,  892,
 /*   490 */   892,  752,  892,  892,  892,  892,  892,  892,  749,  892,
 /*   500 */   750,  892,  892,  892,  892,  892,  892,  892,  892,  892,
 /*   510 */   892,  892,  892,  892,  892,  892,  892,  892,  892,  674,
 /*   520 */   892,  892,  892,  892,  892,  892,  892,  751,  892,  892,
 /*   530 */   892,  892,  892,  892,  892,  892,  892,  709,  892,  847,
 /*   540 */   892,  892,  892,  892,  892,  892,  892,  881,  892,  892,
 /*   550 */   892,  892,  892,  892,  892,  892,  880,  881,  892,  892,
 /*   560 */   892,  892,  892,  892,  892,  892,  892,  892,  892,  892,
 /*   570 */   892,  892,  892,  890,  892,  892,  891,  588,  892,  589,
 /*   580 */   583,
};
#define YY_SZ_ACTTAB (sizeof(yy_action)/sizeof(yy_action[0]))

/* The next table maps tokens into fallback tokens.  If a construct
** like the following:
** 
**      %fallback ID X Y Z.
**
** appears in the grammer, then ID becomes a fallback token for X, Y,
** and Z.  Whenever one of the tokens X, Y, or Z is input to the parser
** but it does not parse, the type of the token is changed to ID and
** the parse is retried before an error is thrown.
*/
#ifdef YYFALLBACK
static const YYCODETYPE yyFallback[] = {
    0,  /*          $ => nothing */
    0,  /* END_OF_FILE => nothing */
    0,  /*    ILLEGAL => nothing */
    0,  /*      SPACE => nothing */
    0,  /* UNCLOSED_STRING => nothing */
    0,  /*    COMMENT => nothing */
    0,  /*   FUNCTION => nothing */
    0,  /*     COLUMN => nothing */
    0,  /* AGG_FUNCTION => nothing */
    0,  /* AGG_COLUMN => nothing */
    0,  /* CONST_FUNC => nothing */
    0,  /*       SEMI => nothing */
   30,  /*    EXPLAIN => ID */
   30,  /*      QUERY => ID */
   30,  /*       PLAN => ID */
   30,  /*      BEGIN => ID */
    0,  /* TRANSACTION => nothing */
   30,  /*   DEFERRED => ID */
   30,  /*  IMMEDIATE => ID */
   30,  /*  EXCLUSIVE => ID */
    0,  /*     COMMIT => nothing */
   30,  /*        END => ID */
    0,  /*   ROLLBACK => nothing */
    0,  /*     CREATE => nothing */
    0,  /*      TABLE => nothing */
   30,  /*       TEMP => ID */
    0,  /*         LP => nothing */
    0,  /*         RP => nothing */
    0,  /*         AS => nothing */
    0,  /*      COMMA => nothing */
    0,  /*         ID => nothing */
   30,  /*      ABORT => ID */
   30,  /*      AFTER => ID */
   30,  /*    ANALYZE => ID */
   30,  /*        ASC => ID */
   30,  /*     ATTACH => ID */
   30,  /*     BEFORE => ID */
   30,  /*    CASCADE => ID */
   30,  /*       CAST => ID */
   30,  /*   CONFLICT => ID */
   30,  /*   DATABASE => ID */
   30,  /*       DESC => ID */
   30,  /*     DETACH => ID */
   30,  /*       EACH => ID */
   30,  /*       FAIL => ID */
   30,  /*        FOR => ID */
   30,  /*     IGNORE => ID */
   30,  /*  INITIALLY => ID */
   30,  /*    INSTEAD => ID */
   30,  /*    LIKE_KW => ID */
   30,  /*      MATCH => ID */
   30,  /*        KEY => ID */
   30,  /*         OF => ID */
   30,  /*     OFFSET => ID */
   30,  /*     PRAGMA => ID */
   30,  /*      RAISE => ID */
   30,  /*    REPLACE => ID */
   30,  /*   RESTRICT => ID */
   30,  /*        ROW => ID */
   30,  /*  STATEMENT => ID */
   30,  /*    TRIGGER => ID */
   30,  /*     VACUUM => ID */
   30,  /*       VIEW => ID */
   30,  /*    REINDEX => ID */
   30,  /*     RENAME => ID */
   30,  /*   CTIME_KW => ID */
   30,  /*      ALTER => ID */
    0,  /*         OR => nothing */
    0,  /*        AND => nothing */
    0,  /*        NOT => nothing */
    0,  /*         IS => nothing */
    0,  /*    BETWEEN => nothing */
    0,  /*         IN => nothing */
    0,  /*     ISNULL => nothing */
    0,  /*    NOTNULL => nothing */
    0,  /*         NE => nothing */
    0,  /*         EQ => nothing */
    0,  /*         GT => nothing */
    0,  /*         LE => nothing */
    0,  /*         LT => nothing */
    0,  /*         GE => nothing */
    0,  /*     ESCAPE => nothing */
    0,  /*     BITAND => nothing */
    0,  /*      BITOR => nothing */
    0,  /*     LSHIFT => nothing */
    0,  /*     RSHIFT => nothing */
    0,  /*       PLUS => nothing */
    0,  /*      MINUS => nothing */
    0,  /*       STAR => nothing */
    0,  /*      SLASH => nothing */
    0,  /*        REM => nothing */
    0,  /*     CONCAT => nothing */
    0,  /*     UMINUS => nothing */
    0,  /*      UPLUS => nothing */
    0,  /*     BITNOT => nothing */
    0,  /*     STRING => nothing */
    0,  /*    JOIN_KW => nothing */
    0,  /* CONSTRAINT => nothing */
    0,  /*    DEFAULT => nothing */
    0,  /*       NULL => nothing */
    0,  /*    PRIMARY => nothing */
    0,  /*     UNIQUE => nothing */
    0,  /*      CHECK => nothing */
    0,  /* REFERENCES => nothing */
    0,  /*    COLLATE => nothing */
    0,  /*   AUTOINCR => nothing */
    0,  /*         ON => nothing */
    0,  /*     DELETE => nothing */
    0,  /*     UPDATE => nothing */
    0,  /*     INSERT => nothing */
    0,  /*        SET => nothing */
    0,  /* DEFERRABLE => nothing */
    0,  /*    FOREIGN => nothing */
    0,  /*       DROP => nothing */
    0,  /*      UNION => nothing */
    0,  /*        ALL => nothing */
    0,  /*  INTERSECT => nothing */
    0,  /*     EXCEPT => nothing */
    0,  /*     SELECT => nothing */
    0,  /*   DISTINCT => nothing */
    0,  /*        DOT => nothing */
    0,  /*       FROM => nothing */
    0,  /*       JOIN => nothing */
    0,  /*      USING => nothing */
    0,  /*      ORDER => nothing */
    0,  /*         BY => nothing */
    0,  /*      GROUP => nothing */
    0,  /*     HAVING => nothing */
    0,  /*      LIMIT => nothing */
    0,  /*      WHERE => nothing */
    0,  /*       INTO => nothing */
    0,  /*     VALUES => nothing */
    0,  /*    INTEGER => nothing */
    0,  /*      FLOAT => nothing */
    0,  /*       BLOB => nothing */
    0,  /*   REGISTER => nothing */
    0,  /*   VARIABLE => nothing */
    0,  /*     EXISTS => nothing */
    0,  /*       CASE => nothing */
    0,  /*       WHEN => nothing */
    0,  /*       THEN => nothing */
    0,  /*       ELSE => nothing */
    0,  /*      INDEX => nothing */
    0,  /*         TO => nothing */
    0,  /*        ADD => nothing */
    0,  /*   COLUMNKW => nothing */
};
#endif /* YYFALLBACK */

/* The following structure represents a single element of the
** parser's stack.  Information stored includes:
**
**   +  The state number for the parser at this level of the stack.
**
**   +  The value of the token stored at this level of the stack.
**      (In other words, the "major" token.)
**
**   +  The semantic value stored at this level of the stack.  This is
**      the information used by the action routines in the grammar.
**      It is sometimes called the "minor" token.
*/
struct yyStackEntry {
  int stateno;       /* The state-number */
  int major;         /* The major token value.  This is the code
                     ** number for the token at this stack level */
  YYMINORTYPE minor; /* The user-supplied minor token value.  This
                     ** is the value of the token  */
};
typedef struct yyStackEntry yyStackEntry;

/* The state of the parser is completely contained in an instance of
** the following structure */
struct yyParser {
  int yyidx;                    /* Index of top element in stack */
  int yyerrcnt;                 /* Shifts left before out of the error */
  sqlite3ParserARG_SDECL                /* A place to hold %extra_argument */
  yyStackEntry yystack[YYSTACKDEPTH];  /* The parser's stack */
};
typedef struct yyParser yyParser;

#ifndef NDEBUG
#include <stdio.h>
static FILE *yyTraceFILE = 0;
static char *yyTracePrompt = 0;
#endif /* NDEBUG */

#ifndef NDEBUG
/* 
** Turn parser tracing on by giving a stream to which to write the trace
** and a prompt to preface each trace message.  Tracing is turned off
** by making either argument NULL 
**
** Inputs:
** <ul>
** <li> A FILE* to which trace output should be written.
**      If NULL, then tracing is turned off.
** <li> A prefix string written at the beginning of every
**      line of trace output.  If NULL, then tracing is
**      turned off.
** </ul>
**
** Outputs:
** None.
*/
void sqlite3ParserTrace(FILE *TraceFILE, char *zTracePrompt){
  yyTraceFILE = TraceFILE;
  yyTracePrompt = zTracePrompt;
  if( yyTraceFILE==0 ) yyTracePrompt = 0;
  else if( yyTracePrompt==0 ) yyTraceFILE = 0;
}
#endif /* NDEBUG */

#ifndef NDEBUG
/* For tracing shifts, the names of all terminals and nonterminals
** are required.  The following table supplies these names */
static const char *const yyTokenName[] = { 
  "$",             "END_OF_FILE",   "ILLEGAL",       "SPACE",       
  "UNCLOSED_STRING",  "COMMENT",       "FUNCTION",      "COLUMN",      
  "AGG_FUNCTION",  "AGG_COLUMN",    "CONST_FUNC",    "SEMI",        
  "EXPLAIN",       "QUERY",         "PLAN",          "BEGIN",       
  "TRANSACTION",   "DEFERRED",      "IMMEDIATE",     "EXCLUSIVE",   
  "COMMIT",        "END",           "ROLLBACK",      "CREATE",      
  "TABLE",         "TEMP",          "LP",            "RP",          
  "AS",            "COMMA",         "ID",            "ABORT",       
  "AFTER",         "ANALYZE",       "ASC",           "ATTACH",      
  "BEFORE",        "CASCADE",       "CAST",          "CONFLICT",    
  "DATABASE",      "DESC",          "DETACH",        "EACH",        
  "FAIL",          "FOR",           "IGNORE",        "INITIALLY",   
  "INSTEAD",       "LIKE_KW",       "MATCH",         "KEY",         
  "OF",            "OFFSET",        "PRAGMA",        "RAISE",       
  "REPLACE",       "RESTRICT",      "ROW",           "STATEMENT",   
  "TRIGGER",       "VACUUM",        "VIEW",          "REINDEX",     
  "RENAME",        "CTIME_KW",      "ALTER",         "OR",          
  "AND",           "NOT",           "IS",            "BETWEEN",     
  "IN",            "ISNULL",        "NOTNULL",       "NE",          
  "EQ",            "GT",            "LE",            "LT",          
  "GE",            "ESCAPE",        "BITAND",        "BITOR",       
  "LSHIFT",        "RSHIFT",        "PLUS",          "MINUS",       
  "STAR",          "SLASH",         "REM",           "CONCAT",      
  "UMINUS",        "UPLUS",         "BITNOT",        "STRING",      
  "JOIN_KW",       "CONSTRAINT",    "DEFAULT",       "NULL",        
  "PRIMARY",       "UNIQUE",        "CHECK",         "REFERENCES",  
  "COLLATE",       "AUTOINCR",      "ON",            "DELETE",      
  "UPDATE",        "INSERT",        "SET",           "DEFERRABLE",  
  "FOREIGN",       "DROP",          "UNION",         "ALL",         
  "INTERSECT",     "EXCEPT",        "SELECT",        "DISTINCT",    
  "DOT",           "FROM",          "JOIN",          "USING",       
  "ORDER",         "BY",            "GROUP",         "HAVING",      
  "LIMIT",         "WHERE",         "INTO",          "VALUES",      
  "INTEGER",       "FLOAT",         "BLOB",          "REGISTER",    
  "VARIABLE",      "EXISTS",        "CASE",          "WHEN",        
  "THEN",          "ELSE",          "INDEX",         "TO",          
  "ADD",           "COLUMNKW",      "error",         "input",       
  "cmdlist",       "ecmd",          "cmdx",          "cmd",         
  "explain",       "transtype",     "trans_opt",     "nm",          
  "create_table",  "create_table_args",  "temp",          "dbnm",        
  "columnlist",    "conslist_opt",  "select",        "column",      
  "columnid",      "type",          "carglist",      "id",          
  "ids",           "typetoken",     "typename",      "signed",      
  "plus_num",      "minus_num",     "carg",          "ccons",       
  "term",          "expr",          "onconf",        "sortorder",   
  "autoinc",       "idxlist_opt",   "refargs",       "defer_subclause",
  "refarg",        "refact",        "init_deferred_pred_opt",  "conslist",    
  "tcons",         "idxlist",       "defer_subclause_opt",  "orconf",      
  "resolvetype",   "raisetype",     "fullname",      "oneselect",   
  "multiselect_op",  "distinct",      "selcollist",    "from",        
  "where_opt",     "groupby_opt",   "having_opt",    "orderby_opt", 
  "limit_opt",     "sclp",          "as",            "seltablist",  
  "stl_prefix",    "joinop",        "on_opt",        "using_opt",   
  "seltablist_paren",  "joinop2",       "inscollist",    "sortlist",    
  "sortitem",      "collate",       "exprlist",      "setlist",     
  "insert_cmd",    "inscollist_opt",  "itemlist",      "likeop",      
  "escape",        "between_op",    "in_op",         "case_operand",
  "case_exprlist",  "case_else",     "expritem",      "uniqueflag",  
  "idxitem",       "plus_opt",      "number",        "trigger_decl",
  "trigger_cmd_list",  "trigger_time",  "trigger_event",  "foreach_clause",
  "when_clause",   "trigger_cmd",   "database_kw_opt",  "key_opt",     
  "add_column_fullname",  "kwcolumn_opt",
};
#endif /* NDEBUG */

#ifndef NDEBUG
/* For tracing reduce actions, the names of all rules are required.
*/
static const char *const yyRuleName[] = {
 /*   0 */ "input ::= cmdlist",
 /*   1 */ "cmdlist ::= cmdlist ecmd",
 /*   2 */ "cmdlist ::= ecmd",
 /*   3 */ "cmdx ::= cmd",
 /*   4 */ "ecmd ::= SEMI",
 /*   5 */ "ecmd ::= explain cmdx SEMI",
 /*   6 */ "explain ::=",
 /*   7 */ "explain ::= EXPLAIN",
 /*   8 */ "explain ::= EXPLAIN QUERY PLAN",
 /*   9 */ "cmd ::= BEGIN transtype trans_opt",
 /*  10 */ "trans_opt ::=",
 /*  11 */ "trans_opt ::= TRANSACTION",
 /*  12 */ "trans_opt ::= TRANSACTION nm",
 /*  13 */ "transtype ::=",
 /*  14 */ "transtype ::= DEFERRED",
 /*  15 */ "transtype ::= IMMEDIATE",
 /*  16 */ "transtype ::= EXCLUSIVE",
 /*  17 */ "cmd ::= COMMIT trans_opt",
 /*  18 */ "cmd ::= END trans_opt",
 /*  19 */ "cmd ::= ROLLBACK trans_opt",
 /*  20 */ "cmd ::= create_table create_table_args",
 /*  21 */ "create_table ::= CREATE temp TABLE nm dbnm",
 /*  22 */ "temp ::= TEMP",
 /*  23 */ "temp ::=",
 /*  24 */ "create_table_args ::= LP columnlist conslist_opt RP",
 /*  25 */ "create_table_args ::= AS select",
 /*  26 */ "columnlist ::= columnlist COMMA column",
 /*  27 */ "columnlist ::= column",
 /*  28 */ "column ::= columnid type carglist",
 /*  29 */ "columnid ::= nm",
 /*  30 */ "id ::= ID",
 /*  31 */ "ids ::= ID",
 /*  32 */ "ids ::= STRING",
 /*  33 */ "nm ::= ID",
 /*  34 */ "nm ::= STRING",
 /*  35 */ "nm ::= JOIN_KW",
 /*  36 */ "type ::=",
 /*  37 */ "type ::= typetoken",
 /*  38 */ "typetoken ::= typename",
 /*  39 */ "typetoken ::= typename LP signed RP",
 /*  40 */ "typetoken ::= typename LP signed COMMA signed RP",
 /*  41 */ "typename ::= ids",
 /*  42 */ "typename ::= typename ids",
 /*  43 */ "signed ::= plus_num",
 /*  44 */ "signed ::= minus_num",
 /*  45 */ "carglist ::= carglist carg",
 /*  46 */ "carglist ::=",
 /*  47 */ "carg ::= CONSTRAINT nm ccons",
 /*  48 */ "carg ::= ccons",
 /*  49 */ "carg ::= DEFAULT term",
 /*  50 */ "carg ::= DEFAULT LP expr RP",
 /*  51 */ "carg ::= DEFAULT PLUS term",
 /*  52 */ "carg ::= DEFAULT MINUS term",
 /*  53 */ "carg ::= DEFAULT id",
 /*  54 */ "ccons ::= NULL onconf",
 /*  55 */ "ccons ::= NOT NULL onconf",
 /*  56 */ "ccons ::= PRIMARY KEY sortorder onconf autoinc",
 /*  57 */ "ccons ::= UNIQUE onconf",
 /*  58 */ "ccons ::= CHECK LP expr RP onconf",
 /*  59 */ "ccons ::= REFERENCES nm idxlist_opt refargs",
 /*  60 */ "ccons ::= defer_subclause",
 /*  61 */ "ccons ::= COLLATE id",
 /*  62 */ "autoinc ::=",
 /*  63 */ "autoinc ::= AUTOINCR",
 /*  64 */ "refargs ::=",
 /*  65 */ "refargs ::= refargs refarg",
 /*  66 */ "refarg ::= MATCH nm",
 /*  67 */ "refarg ::= ON DELETE refact",
 /*  68 */ "refarg ::= ON UPDATE refact",
 /*  69 */ "refarg ::= ON INSERT refact",
 /*  70 */ "refact ::= SET NULL",
 /*  71 */ "refact ::= SET DEFAULT",
 /*  72 */ "refact ::= CASCADE",
 /*  73 */ "refact ::= RESTRICT",
 /*  74 */ "defer_subclause ::= NOT DEFERRABLE init_deferred_pred_opt",
 /*  75 */ "defer_subclause ::= DEFERRABLE init_deferred_pred_opt",
 /*  76 */ "init_deferred_pred_opt ::=",
 /*  77 */ "init_deferred_pred_opt ::= INITIALLY DEFERRED",
 /*  78 */ "init_deferred_pred_opt ::= INITIALLY IMMEDIATE",
 /*  79 */ "conslist_opt ::=",
 /*  80 */ "conslist_opt ::= COMMA conslist",
 /*  81 */ "conslist ::= conslist COMMA tcons",
 /*  82 */ "conslist ::= conslist tcons",
 /*  83 */ "conslist ::= tcons",
 /*  84 */ "tcons ::= CONSTRAINT nm",
 /*  85 */ "tcons ::= PRIMARY KEY LP idxlist autoinc RP onconf",
 /*  86 */ "tcons ::= UNIQUE LP idxlist RP onconf",
 /*  87 */ "tcons ::= CHECK expr onconf",
 /*  88 */ "tcons ::= FOREIGN KEY LP idxlist RP REFERENCES nm idxlist_opt refargs defer_subclause_opt",
 /*  89 */ "defer_subclause_opt ::=",
 /*  90 */ "defer_subclause_opt ::= defer_subclause",
 /*  91 */ "onconf ::=",
 /*  92 */ "onconf ::= ON CONFLICT resolvetype",
 /*  93 */ "orconf ::=",
 /*  94 */ "orconf ::= OR resolvetype",
 /*  95 */ "resolvetype ::= raisetype",
 /*  96 */ "resolvetype ::= IGNORE",
 /*  97 */ "resolvetype ::= REPLACE",
 /*  98 */ "cmd ::= DROP TABLE fullname",
 /*  99 */ "cmd ::= CREATE temp VIEW nm dbnm AS select",
 /* 100 */ "cmd ::= DROP VIEW fullname",
 /* 101 */ "cmd ::= select",
 /* 102 */ "select ::= oneselect",
 /* 103 */ "select ::= select multiselect_op oneselect",
 /* 104 */ "multiselect_op ::= UNION",
 /* 105 */ "multiselect_op ::= UNION ALL",
 /* 106 */ "multiselect_op ::= INTERSECT",
 /* 107 */ "multiselect_op ::= EXCEPT",
 /* 108 */ "oneselect ::= SELECT distinct selcollist from where_opt groupby_opt having_opt orderby_opt limit_opt",
 /* 109 */ "distinct ::= DISTINCT",
 /* 110 */ "distinct ::= ALL",
 /* 111 */ "distinct ::=",
 /* 112 */ "sclp ::= selcollist COMMA",
 /* 113 */ "sclp ::=",
 /* 114 */ "selcollist ::= sclp expr as",
 /* 115 */ "selcollist ::= sclp STAR",
 /* 116 */ "selcollist ::= sclp nm DOT STAR",
 /* 117 */ "as ::= AS nm",
 /* 118 */ "as ::= ids",
 /* 119 */ "as ::=",
 /* 120 */ "from ::=",
 /* 121 */ "from ::= FROM seltablist",
 /* 122 */ "stl_prefix ::= seltablist joinop",
 /* 123 */ "stl_prefix ::=",
 /* 124 */ "seltablist ::= stl_prefix nm dbnm as on_opt using_opt",
 /* 125 */ "seltablist ::= stl_prefix LP seltablist_paren RP as on_opt using_opt",
 /* 126 */ "seltablist_paren ::= select",
 /* 127 */ "seltablist_paren ::= seltablist",
 /* 128 */ "dbnm ::=",
 /* 129 */ "dbnm ::= DOT nm",
 /* 130 */ "fullname ::= nm dbnm",
 /* 131 */ "joinop ::= COMMA",
 /* 132 */ "joinop ::= JOIN",
 /* 133 */ "joinop ::= JOIN_KW JOIN",
 /* 134 */ "joinop ::= JOIN_KW nm JOIN",
 /* 135 */ "joinop ::= JOIN_KW nm nm JOIN",
 /* 136 */ "on_opt ::= ON expr",
 /* 137 */ "on_opt ::=",
 /* 138 */ "using_opt ::= USING LP inscollist RP",
 /* 139 */ "using_opt ::=",
 /* 140 */ "orderby_opt ::=",
 /* 141 */ "orderby_opt ::= ORDER BY sortlist",
 /* 142 */ "sortlist ::= sortlist COMMA sortitem collate sortorder",
 /* 143 */ "sortlist ::= sortitem collate sortorder",
 /* 144 */ "sortitem ::= expr",
 /* 145 */ "sortorder ::= ASC",
 /* 146 */ "sortorder ::= DESC",
 /* 147 */ "sortorder ::=",
 /* 148 */ "collate ::=",
 /* 149 */ "collate ::= COLLATE id",
 /* 150 */ "groupby_opt ::=",
 /* 151 */ "groupby_opt ::= GROUP BY exprlist",
 /* 152 */ "having_opt ::=",
 /* 153 */ "having_opt ::= HAVING expr",
 /* 154 */ "limit_opt ::=",
 /* 155 */ "limit_opt ::= LIMIT expr",
 /* 156 */ "limit_opt ::= LIMIT expr OFFSET expr",
 /* 157 */ "limit_opt ::= LIMIT expr COMMA expr",
 /* 158 */ "cmd ::= DELETE FROM fullname where_opt",
 /* 159 */ "where_opt ::=",
 /* 160 */ "where_opt ::= WHERE expr",
 /* 161 */ "cmd ::= UPDATE orconf fullname SET setlist where_opt",
 /* 162 */ "setlist ::= setlist COMMA nm EQ expr",
 /* 163 */ "setlist ::= nm EQ expr",
 /* 164 */ "cmd ::= insert_cmd INTO fullname inscollist_opt VALUES LP itemlist RP",
 /* 165 */ "cmd ::= insert_cmd INTO fullname inscollist_opt select",
 /* 166 */ "insert_cmd ::= INSERT orconf",
 /* 167 */ "insert_cmd ::= REPLACE",
 /* 168 */ "itemlist ::= itemlist COMMA expr",
 /* 169 */ "itemlist ::= expr",
 /* 170 */ "inscollist_opt ::=",
 /* 171 */ "inscollist_opt ::= LP inscollist RP",
 /* 172 */ "inscollist ::= inscollist COMMA nm",
 /* 173 */ "inscollist ::= nm",
 /* 174 */ "expr ::= term",
 /* 175 */ "expr ::= LP expr RP",
 /* 176 */ "term ::= NULL",
 /* 177 */ "expr ::= ID",
 /* 178 */ "expr ::= JOIN_KW",
 /* 179 */ "expr ::= nm DOT nm",
 /* 180 */ "expr ::= nm DOT nm DOT nm",
 /* 181 */ "term ::= INTEGER",
 /* 182 */ "term ::= FLOAT",
 /* 183 */ "term ::= STRING",
 /* 184 */ "term ::= BLOB",
 /* 185 */ "expr ::= REGISTER",
 /* 186 */ "expr ::= VARIABLE",
 /* 187 */ "expr ::= CAST LP expr AS typetoken RP",
 /* 188 */ "expr ::= ID LP distinct exprlist RP",
 /* 189 */ "expr ::= ID LP STAR RP",
 /* 190 */ "term ::= CTIME_KW",
 /* 191 */ "expr ::= expr AND expr",
 /* 192 */ "expr ::= expr OR expr",
 /* 193 */ "expr ::= expr LT expr",
 /* 194 */ "expr ::= expr GT expr",
 /* 195 */ "expr ::= expr LE expr",
 /* 196 */ "expr ::= expr GE expr",
 /* 197 */ "expr ::= expr NE expr",
 /* 198 */ "expr ::= expr EQ expr",
 /* 199 */ "expr ::= expr BITAND expr",
 /* 200 */ "expr ::= expr BITOR expr",
 /* 201 */ "expr ::= expr LSHIFT expr",
 /* 202 */ "expr ::= expr RSHIFT expr",
 /* 203 */ "expr ::= expr PLUS expr",
 /* 204 */ "expr ::= expr MINUS expr",
 /* 205 */ "expr ::= expr STAR expr",
 /* 206 */ "expr ::= expr SLASH expr",
 /* 207 */ "expr ::= expr REM expr",
 /* 208 */ "expr ::= expr CONCAT expr",
 /* 209 */ "likeop ::= LIKE_KW",
 /* 210 */ "likeop ::= NOT LIKE_KW",
 /* 211 */ "escape ::= ESCAPE expr",
 /* 212 */ "escape ::=",
 /* 213 */ "expr ::= expr likeop expr escape",
 /* 214 */ "expr ::= expr ISNULL",
 /* 215 */ "expr ::= expr IS NULL",
 /* 216 */ "expr ::= expr NOTNULL",
 /* 217 */ "expr ::= expr NOT NULL",
 /* 218 */ "expr ::= expr IS NOT NULL",
 /* 219 */ "expr ::= NOT expr",
 /* 220 */ "expr ::= BITNOT expr",
 /* 221 */ "expr ::= MINUS expr",
 /* 222 */ "expr ::= PLUS expr",
 /* 223 */ "between_op ::= BETWEEN",
 /* 224 */ "between_op ::= NOT BETWEEN",
 /* 225 */ "expr ::= expr between_op expr AND expr",
 /* 226 */ "in_op ::= IN",
 /* 227 */ "in_op ::= NOT IN",
 /* 228 */ "expr ::= expr in_op LP exprlist RP",
 /* 229 */ "expr ::= LP select RP",
 /* 230 */ "expr ::= expr in_op LP select RP",
 /* 231 */ "expr ::= expr in_op nm dbnm",
 /* 232 */ "expr ::= EXISTS LP select RP",
 /* 233 */ "expr ::= CASE case_operand case_exprlist case_else END",
 /* 234 */ "case_exprlist ::= case_exprlist WHEN expr THEN expr",
 /* 235 */ "case_exprlist ::= WHEN expr THEN expr",
 /* 236 */ "case_else ::= ELSE expr",
 /* 237 */ "case_else ::=",
 /* 238 */ "case_operand ::= expr",
 /* 239 */ "case_operand ::=",
 /* 240 */ "exprlist ::= exprlist COMMA expritem",
 /* 241 */ "exprlist ::= expritem",
 /* 242 */ "expritem ::= expr",
 /* 243 */ "expritem ::=",
 /* 244 */ "cmd ::= CREATE uniqueflag INDEX nm dbnm ON nm LP idxlist RP onconf",
 /* 245 */ "uniqueflag ::= UNIQUE",
 /* 246 */ "uniqueflag ::=",
 /* 247 */ "idxlist_opt ::=",
 /* 248 */ "idxlist_opt ::= LP idxlist RP",
 /* 249 */ "idxlist ::= idxlist COMMA idxitem collate sortorder",
 /* 250 */ "idxlist ::= idxitem collate sortorder",
 /* 251 */ "idxitem ::= nm",
 /* 252 */ "cmd ::= DROP INDEX fullname",
 /* 253 */ "cmd ::= VACUUM",
 /* 254 */ "cmd ::= VACUUM nm",
 /* 255 */ "cmd ::= PRAGMA nm dbnm EQ nm",
 /* 256 */ "cmd ::= PRAGMA nm dbnm EQ ON",
 /* 257 */ "cmd ::= PRAGMA nm dbnm EQ plus_num",
 /* 258 */ "cmd ::= PRAGMA nm dbnm EQ minus_num",
 /* 259 */ "cmd ::= PRAGMA nm dbnm LP nm RP",
 /* 260 */ "cmd ::= PRAGMA nm dbnm",
 /* 261 */ "plus_num ::= plus_opt number",
 /* 262 */ "minus_num ::= MINUS number",
 /* 263 */ "number ::= INTEGER",
 /* 264 */ "number ::= FLOAT",
 /* 265 */ "plus_opt ::= PLUS",
 /* 266 */ "plus_opt ::=",
 /* 267 */ "cmd ::= CREATE trigger_decl BEGIN trigger_cmd_list END",
 /* 268 */ "trigger_decl ::= temp TRIGGER nm dbnm trigger_time trigger_event ON fullname foreach_clause when_clause",
 /* 269 */ "trigger_time ::= BEFORE",
 /* 270 */ "trigger_time ::= AFTER",
 /* 271 */ "trigger_time ::= INSTEAD OF",
 /* 272 */ "trigger_time ::=",
 /* 273 */ "trigger_event ::= DELETE",
 /* 274 */ "trigger_event ::= INSERT",
 /* 275 */ "trigger_event ::= UPDATE",
 /* 276 */ "trigger_event ::= UPDATE OF inscollist",
 /* 277 */ "foreach_clause ::=",
 /* 278 */ "foreach_clause ::= FOR EACH ROW",
 /* 279 */ "foreach_clause ::= FOR EACH STATEMENT",
 /* 280 */ "when_clause ::=",
 /* 281 */ "when_clause ::= WHEN expr",
 /* 282 */ "trigger_cmd_list ::= trigger_cmd SEMI trigger_cmd_list",
 /* 283 */ "trigger_cmd_list ::=",
 /* 284 */ "trigger_cmd ::= UPDATE orconf nm SET setlist where_opt",
 /* 285 */ "trigger_cmd ::= insert_cmd INTO nm inscollist_opt VALUES LP itemlist RP",
 /* 286 */ "trigger_cmd ::= insert_cmd INTO nm inscollist_opt select",
 /* 287 */ "trigger_cmd ::= DELETE FROM nm where_opt",
 /* 288 */ "trigger_cmd ::= select",
 /* 289 */ "expr ::= RAISE LP IGNORE RP",
 /* 290 */ "expr ::= RAISE LP raisetype COMMA nm RP",
 /* 291 */ "raisetype ::= ROLLBACK",
 /* 292 */ "raisetype ::= ABORT",
 /* 293 */ "raisetype ::= FAIL",
 /* 294 */ "cmd ::= DROP TRIGGER fullname",
 /* 295 */ "cmd ::= ATTACH database_kw_opt ids AS nm key_opt",
 /* 296 */ "key_opt ::=",
 /* 297 */ "key_opt ::= KEY ids",
 /* 298 */ "key_opt ::= KEY BLOB",
 /* 299 */ "database_kw_opt ::= DATABASE",
 /* 300 */ "database_kw_opt ::=",
 /* 301 */ "cmd ::= DETACH database_kw_opt nm",
 /* 302 */ "cmd ::= REINDEX",
 /* 303 */ "cmd ::= REINDEX nm dbnm",
 /* 304 */ "cmd ::= ANALYZE",
 /* 305 */ "cmd ::= ANALYZE nm dbnm",
 /* 306 */ "cmd ::= ALTER TABLE fullname RENAME TO nm",
 /* 307 */ "cmd ::= ALTER TABLE add_column_fullname ADD kwcolumn_opt column",
 /* 308 */ "add_column_fullname ::= fullname",
 /* 309 */ "kwcolumn_opt ::=",
 /* 310 */ "kwcolumn_opt ::= COLUMNKW",
};
#endif /* NDEBUG */

/*
** This function returns the symbolic name associated with a token
** value.
*/
const char *sqlite3ParserTokenName(int tokenType){
#ifndef NDEBUG
  if( tokenType>0 && tokenType<(sizeof(yyTokenName)/sizeof(yyTokenName[0])) ){
    return yyTokenName[tokenType];
  }else{
    return "Unknown";
  }
#else
  return "";
#endif
}

/* 
** This function allocates a new parser.
** The only argument is a pointer to a function which works like
** malloc.
**
** Inputs:
** A pointer to the function used to allocate memory.
**
** Outputs:
** A pointer to a parser.  This pointer is used in subsequent calls
** to sqlite3Parser and sqlite3ParserFree.
*/
void *sqlite3ParserAlloc(void *(*mallocProc)(size_t)){
  yyParser *pParser;
  pParser = (yyParser*)(*mallocProc)( (size_t)sizeof(yyParser) );
  if( pParser ){
    pParser->yyidx = -1;
  }
  return pParser;
}

/* The following function deletes the value associated with a
** symbol.  The symbol can be either a terminal or nonterminal.
** "yymajor" is the symbol code, and "yypminor" is a pointer to
** the value.
*/
static void yy_destructor(YYCODETYPE yymajor, YYMINORTYPE *yypminor){
  switch( yymajor ){
    /* Here is inserted the actions which take place when a
    ** terminal or non-terminal is destroyed.  This can happen
    ** when the symbol is popped from the stack during a
    ** reduce or during error processing or when a parser is 
    ** being destroyed before it is finished parsing.
    **
    ** Note: during a reduce, the only symbols destroyed are those
    ** which appear on the RHS of the rule, but which are not used
    ** inside the C code.
    */
    case 162:
    case 195:
    case 212:
#line 370 "ext/pdo_sqlite/sqlite/src/parse.y"
{sqlite3SelectDelete((yypminor->yy375));}
#line 1332 "ext/pdo_sqlite/sqlite/src/parse.c"
      break;
    case 176:
    case 177:
    case 200:
    case 202:
    case 210:
    case 216:
    case 230:
#line 629 "ext/pdo_sqlite/sqlite/src/parse.y"
{sqlite3ExprDelete((yypminor->yy62));}
#line 1343 "ext/pdo_sqlite/sqlite/src/parse.c"
      break;
    case 181:
    case 189:
    case 198:
    case 201:
    case 203:
    case 205:
    case 215:
    case 218:
    case 219:
    case 222:
    case 228:
#line 876 "ext/pdo_sqlite/sqlite/src/parse.y"
{sqlite3ExprListDelete((yypminor->yy418));}
#line 1358 "ext/pdo_sqlite/sqlite/src/parse.c"
      break;
    case 194:
    case 199:
    case 207:
    case 208:
#line 499 "ext/pdo_sqlite/sqlite/src/parse.y"
{sqlite3SrcListDelete((yypminor->yy151));}
#line 1366 "ext/pdo_sqlite/sqlite/src/parse.c"
      break;
    case 204:
#line 561 "ext/pdo_sqlite/sqlite/src/parse.y"
{
  sqlite3ExprDelete((yypminor->yy220).pLimit);
  sqlite3ExprDelete((yypminor->yy220).pOffset);
}
#line 1374 "ext/pdo_sqlite/sqlite/src/parse.c"
      break;
    case 211:
    case 214:
    case 221:
#line 517 "ext/pdo_sqlite/sqlite/src/parse.y"
{sqlite3IdListDelete((yypminor->yy240));}
#line 1381 "ext/pdo_sqlite/sqlite/src/parse.c"
      break;
    case 236:
    case 241:
#line 969 "ext/pdo_sqlite/sqlite/src/parse.y"
{sqlite3DeleteTriggerStep((yypminor->yy360));}
#line 1387 "ext/pdo_sqlite/sqlite/src/parse.c"
      break;
    case 238:
#line 953 "ext/pdo_sqlite/sqlite/src/parse.y"
{sqlite3IdListDelete((yypminor->yy30).b);}
#line 1392 "ext/pdo_sqlite/sqlite/src/parse.c"
      break;
    default:  break;   /* If no destructor action specified: do nothing */
  }
}

/*
** Pop the parser's stack once.
**
** If there is a destructor routine associated with the token which
** is popped from the stack, then call it.
**
** Return the major token number for the symbol popped.
*/
static int yy_pop_parser_stack(yyParser *pParser){
  YYCODETYPE yymajor;
  yyStackEntry *yytos = &pParser->yystack[pParser->yyidx];

  if( pParser->yyidx<0 ) return 0;
#ifndef NDEBUG
  if( yyTraceFILE && pParser->yyidx>=0 ){
    fprintf(yyTraceFILE,"%sPopping %s\n",
      yyTracePrompt,
      yyTokenName[yytos->major]);
  }
#endif
  yymajor = yytos->major;
  yy_destructor( yymajor, &yytos->minor);
  pParser->yyidx--;
  return yymajor;
}

/* 
** Deallocate and destroy a parser.  Destructors are all called for
** all stack elements before shutting the parser down.
**
** Inputs:
** <ul>
** <li>  A pointer to the parser.  This should be a pointer
**       obtained from sqlite3ParserAlloc.
** <li>  A pointer to a function used to reclaim memory obtained
**       from malloc.
** </ul>
*/
void sqlite3ParserFree(
  void *p,                    /* The parser to be deleted */
  void (*freeProc)(void*)     /* Function used to reclaim memory */
){
  yyParser *pParser = (yyParser*)p;
  if( pParser==0 ) return;
  while( pParser->yyidx>=0 ) yy_pop_parser_stack(pParser);
  (*freeProc)((void*)pParser);
}

/*
** Find the appropriate action for a parser given the terminal
** look-ahead token iLookAhead.
**
** If the look-ahead token is YYNOCODE, then check to see if the action is
** independent of the look-ahead.  If it is, return the action, otherwise
** return YY_NO_ACTION.
*/
static int yy_find_shift_action(
  yyParser *pParser,        /* The parser */
  int iLookAhead            /* The look-ahead token */
){
  int i;
  int stateno = pParser->yystack[pParser->yyidx].stateno;
 
  /* if( pParser->yyidx<0 ) return YY_NO_ACTION;  */
  i = yy_shift_ofst[stateno];
  if( i==YY_SHIFT_USE_DFLT ){
    return yy_default[stateno];
  }
  if( iLookAhead==YYNOCODE ){
    return YY_NO_ACTION;
  }
  i += iLookAhead;
  if( i<0 || i>=YY_SZ_ACTTAB || yy_lookahead[i]!=iLookAhead ){
#ifdef YYFALLBACK
    int iFallback;            /* Fallback token */
    if( iLookAhead<sizeof(yyFallback)/sizeof(yyFallback[0])
           && (iFallback = yyFallback[iLookAhead])!=0 ){
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE, "%sFALLBACK %s => %s\n",
           yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[iFallback]);
      }
#endif
      return yy_find_shift_action(pParser, iFallback);
    }
#endif
    return yy_default[stateno];
  }else{
    return yy_action[i];
  }
}

/*
** Find the appropriate action for a parser given the non-terminal
** look-ahead token iLookAhead.
**
** If the look-ahead token is YYNOCODE, then check to see if the action is
** independent of the look-ahead.  If it is, return the action, otherwise
** return YY_NO_ACTION.
*/
static int yy_find_reduce_action(
  int stateno,              /* Current state number */
  int iLookAhead            /* The look-ahead token */
){
  int i;
  /* int stateno = pParser->yystack[pParser->yyidx].stateno; */
 
  i = yy_reduce_ofst[stateno];
  if( i==YY_REDUCE_USE_DFLT ){
    return yy_default[stateno];
  }
  if( iLookAhead==YYNOCODE ){
    return YY_NO_ACTION;
  }
  i += iLookAhead;
  if( i<0 || i>=YY_SZ_ACTTAB || yy_lookahead[i]!=iLookAhead ){
    return yy_default[stateno];
  }else{
    return yy_action[i];
  }
}

/*
** Perform a shift action.
*/
static void yy_shift(
  yyParser *yypParser,          /* The parser to be shifted */
  int yyNewState,               /* The new state to shift in */
  int yyMajor,                  /* The major token to shift in */
  YYMINORTYPE *yypMinor         /* Pointer ot the minor token to shift in */
){
  yyStackEntry *yytos;
  yypParser->yyidx++;
  if( yypParser->yyidx>=YYSTACKDEPTH ){
     sqlite3ParserARG_FETCH;
     yypParser->yyidx--;
#ifndef NDEBUG
     if( yyTraceFILE ){
       fprintf(yyTraceFILE,"%sStack Overflow!\n",yyTracePrompt);
     }
#endif
     while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
     /* Here code is inserted which will execute if the parser
     ** stack every overflows */
     sqlite3ParserARG_STORE; /* Suppress warning about unused %extra_argument var */
     return;
  }
  yytos = &yypParser->yystack[yypParser->yyidx];
  yytos->stateno = yyNewState;
  yytos->major = yyMajor;
  yytos->minor = *yypMinor;
#ifndef NDEBUG
  if( yyTraceFILE && yypParser->yyidx>0 ){
    int i;
    fprintf(yyTraceFILE,"%sShift %d\n",yyTracePrompt,yyNewState);
    fprintf(yyTraceFILE,"%sStack:",yyTracePrompt);
    for(i=1; i<=yypParser->yyidx; i++)
      fprintf(yyTraceFILE," %s",yyTokenName[yypParser->yystack[i].major]);
    fprintf(yyTraceFILE,"\n");
  }
#endif
}

/* The following table contains information about every rule that
** is used during the reduce.
*/
static const struct {
  YYCODETYPE lhs;         /* Symbol on the left-hand side of the rule */
  unsigned char nrhs;     /* Number of right-hand side symbols in the rule */
} yyRuleInfo[] = {
  { 147, 1 },
  { 148, 2 },
  { 148, 1 },
  { 150, 1 },
  { 149, 1 },
  { 149, 3 },
  { 152, 0 },
  { 152, 1 },
  { 152, 3 },
  { 151, 3 },
  { 154, 0 },
  { 154, 1 },
  { 154, 2 },
  { 153, 0 },
  { 153, 1 },
  { 153, 1 },
  { 153, 1 },
  { 151, 2 },
  { 151, 2 },
  { 151, 2 },
  { 151, 2 },
  { 156, 5 },
  { 158, 1 },
  { 158, 0 },
  { 157, 4 },
  { 157, 2 },
  { 160, 3 },
  { 160, 1 },
  { 163, 3 },
  { 164, 1 },
  { 167, 1 },
  { 168, 1 },
  { 168, 1 },
  { 155, 1 },
  { 155, 1 },
  { 155, 1 },
  { 165, 0 },
  { 165, 1 },
  { 169, 1 },
  { 169, 4 },
  { 169, 6 },
  { 170, 1 },
  { 170, 2 },
  { 171, 1 },
  { 171, 1 },
  { 166, 2 },
  { 166, 0 },
  { 174, 3 },
  { 174, 1 },
  { 174, 2 },
  { 174, 4 },
  { 174, 3 },
  { 174, 3 },
  { 174, 2 },
  { 175, 2 },
  { 175, 3 },
  { 175, 5 },
  { 175, 2 },
  { 175, 5 },
  { 175, 4 },
  { 175, 1 },
  { 175, 2 },
  { 180, 0 },
  { 180, 1 },
  { 182, 0 },
  { 182, 2 },
  { 184, 2 },
  { 184, 3 },
  { 184, 3 },
  { 184, 3 },
  { 185, 2 },
  { 185, 2 },
  { 185, 1 },
  { 185, 1 },
  { 183, 3 },
  { 183, 2 },
  { 186, 0 },
  { 186, 2 },
  { 186, 2 },
  { 161, 0 },
  { 161, 2 },
  { 187, 3 },
  { 187, 2 },
  { 187, 1 },
  { 188, 2 },
  { 188, 7 },
  { 188, 5 },
  { 188, 3 },
  { 188, 10 },
  { 190, 0 },
  { 190, 1 },
  { 178, 0 },
  { 178, 3 },
  { 191, 0 },
  { 191, 2 },
  { 192, 1 },
  { 192, 1 },
  { 192, 1 },
  { 151, 3 },
  { 151, 7 },
  { 151, 3 },
  { 151, 1 },
  { 162, 1 },
  { 162, 3 },
  { 196, 1 },
  { 196, 2 },
  { 196, 1 },
  { 196, 1 },
  { 195, 9 },
  { 197, 1 },
  { 197, 1 },
  { 197, 0 },
  { 205, 2 },
  { 205, 0 },
  { 198, 3 },
  { 198, 2 },
  { 198, 4 },
  { 206, 2 },
  { 206, 1 },
  { 206, 0 },
  { 199, 0 },
  { 199, 2 },
  { 208, 2 },
  { 208, 0 },
  { 207, 6 },
  { 207, 7 },
  { 212, 1 },
  { 212, 1 },
  { 159, 0 },
  { 159, 2 },
  { 194, 2 },
  { 209, 1 },
  { 209, 1 },
  { 209, 2 },
  { 209, 3 },
  { 209, 4 },
  { 210, 2 },
  { 210, 0 },
  { 211, 4 },
  { 211, 0 },
  { 203, 0 },
  { 203, 3 },
  { 215, 5 },
  { 215, 3 },
  { 216, 1 },
  { 179, 1 },
  { 179, 1 },
  { 179, 0 },
  { 217, 0 },
  { 217, 2 },
  { 201, 0 },
  { 201, 3 },
  { 202, 0 },
  { 202, 2 },
  { 204, 0 },
  { 204, 2 },
  { 204, 4 },
  { 204, 4 },
  { 151, 4 },
  { 200, 0 },
  { 200, 2 },
  { 151, 6 },
  { 219, 5 },
  { 219, 3 },
  { 151, 8 },
  { 151, 5 },
  { 220, 2 },
  { 220, 1 },
  { 222, 3 },
  { 222, 1 },
  { 221, 0 },
  { 221, 3 },
  { 214, 3 },
  { 214, 1 },
  { 177, 1 },
  { 177, 3 },
  { 176, 1 },
  { 177, 1 },
  { 177, 1 },
  { 177, 3 },
  { 177, 5 },
  { 176, 1 },
  { 176, 1 },
  { 176, 1 },
  { 176, 1 },
  { 177, 1 },
  { 177, 1 },
  { 177, 6 },
  { 177, 5 },
  { 177, 4 },
  { 176, 1 },
  { 177, 3 },
  { 177, 3 },
  { 177, 3 },
  { 177, 3 },
  { 177, 3 },
  { 177, 3 },
  { 177, 3 },
  { 177, 3 },
  { 177, 3 },
  { 177, 3 },
  { 177, 3 },
  { 177, 3 },
  { 177, 3 },
  { 177, 3 },
  { 177, 3 },
  { 177, 3 },
  { 177, 3 },
  { 177, 3 },
  { 223, 1 },
  { 223, 2 },
  { 224, 2 },
  { 224, 0 },
  { 177, 4 },
  { 177, 2 },
  { 177, 3 },
  { 177, 2 },
  { 177, 3 },
  { 177, 4 },
  { 177, 2 },
  { 177, 2 },
  { 177, 2 },
  { 177, 2 },
  { 225, 1 },
  { 225, 2 },
  { 177, 5 },
  { 226, 1 },
  { 226, 2 },
  { 177, 5 },
  { 177, 3 },
  { 177, 5 },
  { 177, 4 },
  { 177, 4 },
  { 177, 5 },
  { 228, 5 },
  { 228, 4 },
  { 229, 2 },
  { 229, 0 },
  { 227, 1 },
  { 227, 0 },
  { 218, 3 },
  { 218, 1 },
  { 230, 1 },
  { 230, 0 },
  { 151, 11 },
  { 231, 1 },
  { 231, 0 },
  { 181, 0 },
  { 181, 3 },
  { 189, 5 },
  { 189, 3 },
  { 232, 1 },
  { 151, 3 },
  { 151, 1 },
  { 151, 2 },
  { 151, 5 },
  { 151, 5 },
  { 151, 5 },
  { 151, 5 },
  { 151, 6 },
  { 151, 3 },
  { 172, 2 },
  { 173, 2 },
  { 234, 1 },
  { 234, 1 },
  { 233, 1 },
  { 233, 0 },
  { 151, 5 },
  { 235, 10 },
  { 237, 1 },
  { 237, 1 },
  { 237, 2 },
  { 237, 0 },
  { 238, 1 },
  { 238, 1 },
  { 238, 1 },
  { 238, 3 },
  { 239, 0 },
  { 239, 3 },
  { 239, 3 },
  { 240, 0 },
  { 240, 2 },
  { 236, 3 },
  { 236, 0 },
  { 241, 6 },
  { 241, 8 },
  { 241, 5 },
  { 241, 4 },
  { 241, 1 },
  { 177, 4 },
  { 177, 6 },
  { 193, 1 },
  { 193, 1 },
  { 193, 1 },
  { 151, 3 },
  { 151, 6 },
  { 243, 0 },
  { 243, 2 },
  { 243, 2 },
  { 242, 1 },
  { 242, 0 },
  { 151, 3 },
  { 151, 1 },
  { 151, 3 },
  { 151, 1 },
  { 151, 3 },
  { 151, 6 },
  { 151, 6 },
  { 244, 1 },
  { 245, 0 },
  { 245, 1 },
};

static void yy_accept(yyParser*);  /* Forward Declaration */

/*
** Perform a reduce action and the shift that must immediately
** follow the reduce.
*/
static void yy_reduce(
  yyParser *yypParser,         /* The parser */
  int yyruleno                 /* Number of the rule by which to reduce */
){
  int yygoto;                     /* The next state */
  int yyact;                      /* The next action */
  YYMINORTYPE yygotominor;        /* The LHS of the rule reduced */
  yyStackEntry *yymsp;            /* The top of the parser's stack */
  int yysize;                     /* Amount to pop the stack */
  sqlite3ParserARG_FETCH;
  yymsp = &yypParser->yystack[yypParser->yyidx];
#ifndef NDEBUG
  if( yyTraceFILE && yyruleno>=0 
        && yyruleno<sizeof(yyRuleName)/sizeof(yyRuleName[0]) ){
    fprintf(yyTraceFILE, "%sReduce [%s].\n", yyTracePrompt,
      yyRuleName[yyruleno]);
  }
#endif /* NDEBUG */

#ifndef NDEBUG
  /* Silence complaints from purify about yygotominor being uninitialized
  ** in some cases when it is copied into the stack after the following
  ** switch.  yygotominor is uninitialized when a rule reduces that does
  ** not set the value of its left-hand side nonterminal.  Leaving the
  ** value of the nonterminal uninitialized is utterly harmless as long
  ** as the value is never used.  So really the only thing this code
  ** accomplishes is to quieten purify.  
  */
  memset(&yygotominor, 0, sizeof(yygotominor));
#endif

  switch( yyruleno ){
  /* Beginning here are the reduction cases.  A typical example
  ** follows:
  **   case 0:
  **  #line <lineno> <grammarfile>
  **     { ... }           // User supplied code
  **  #line <lineno> <thisfile>
  **     break;
  */
      case 3:
#line 102 "ext/pdo_sqlite/sqlite/src/parse.y"
{ sqlite3FinishCoding(pParse); }
#line 1930 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 6:
#line 105 "ext/pdo_sqlite/sqlite/src/parse.y"
{ sqlite3BeginParse(pParse, 0); }
#line 1935 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 7:
#line 107 "ext/pdo_sqlite/sqlite/src/parse.y"
{ sqlite3BeginParse(pParse, 1); }
#line 1940 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 8:
#line 108 "ext/pdo_sqlite/sqlite/src/parse.y"
{ sqlite3BeginParse(pParse, 2); }
#line 1945 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 9:
#line 114 "ext/pdo_sqlite/sqlite/src/parse.y"
{sqlite3BeginTransaction(pParse, yymsp[-1].minor.yy280);}
#line 1950 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 13:
#line 119 "ext/pdo_sqlite/sqlite/src/parse.y"
{yygotominor.yy280 = TK_DEFERRED;}
#line 1955 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 14:
      case 15:
      case 16:
      case 104:
      case 106:
      case 107:
#line 120 "ext/pdo_sqlite/sqlite/src/parse.y"
{yygotominor.yy280 = yymsp[0].major;}
#line 1965 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 17:
      case 18:
#line 123 "ext/pdo_sqlite/sqlite/src/parse.y"
{sqlite3CommitTransaction(pParse);}
#line 1971 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 19:
#line 125 "ext/pdo_sqlite/sqlite/src/parse.y"
{sqlite3RollbackTransaction(pParse);}
#line 1976 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 21:
#line 130 "ext/pdo_sqlite/sqlite/src/parse.y"
{
   sqlite3StartTable(pParse,&yymsp[-4].minor.yy0,&yymsp[-1].minor.yy198,&yymsp[0].minor.yy198,yymsp[-3].minor.yy280,0);
}
#line 1983 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 22:
      case 63:
      case 77:
      case 109:
      case 224:
      case 227:
#line 135 "ext/pdo_sqlite/sqlite/src/parse.y"
{yygotominor.yy280 = 1;}
#line 1993 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 23:
      case 62:
      case 76:
      case 78:
      case 89:
      case 110:
      case 111:
      case 223:
      case 226:
#line 137 "ext/pdo_sqlite/sqlite/src/parse.y"
{yygotominor.yy280 = 0;}
#line 2006 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 24:
#line 138 "ext/pdo_sqlite/sqlite/src/parse.y"
{
  sqlite3EndTable(pParse,&yymsp[-1].minor.yy198,&yymsp[0].minor.yy0,0);
}
#line 2013 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 25:
#line 141 "ext/pdo_sqlite/sqlite/src/parse.y"
{
  sqlite3EndTable(pParse,0,0,yymsp[0].minor.yy375);
  sqlite3SelectDelete(yymsp[0].minor.yy375);
}
#line 2021 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 28:
#line 153 "ext/pdo_sqlite/sqlite/src/parse.y"
{
  yygotominor.yy198.z = yymsp[-2].minor.yy198.z;
  yygotominor.yy198.n = (pParse->sLastToken.z-yymsp[-2].minor.yy198.z) + pParse->sLastToken.n;
}
#line 2029 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 29:
#line 157 "ext/pdo_sqlite/sqlite/src/parse.y"
{
  sqlite3AddColumn(pParse,&yymsp[0].minor.yy198);
  yygotominor.yy198 = yymsp[0].minor.yy198;
}
#line 2037 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 30:
      case 31:
      case 32:
      case 33:
      case 34:
      case 35:
      case 263:
      case 264:
#line 167 "ext/pdo_sqlite/sqlite/src/parse.y"
{yygotominor.yy198 = yymsp[0].minor.yy0;}
#line 2049 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 37:
#line 227 "ext/pdo_sqlite/sqlite/src/parse.y"
{sqlite3AddColumnType(pParse,&yymsp[0].minor.yy198);}
#line 2054 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 38:
      case 41:
      case 117:
      case 118:
      case 129:
      case 149:
      case 251:
      case 261:
      case 262:
#line 228 "ext/pdo_sqlite/sqlite/src/parse.y"
{yygotominor.yy198 = yymsp[0].minor.yy198;}
#line 2067 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 39:
#line 229 "ext/pdo_sqlite/sqlite/src/parse.y"
{
  yygotominor.yy198.z = yymsp[-3].minor.yy198.z;
  yygotominor.yy198.n = &yymsp[0].minor.yy0.z[yymsp[0].minor.yy0.n] - yymsp[-3].minor.yy198.z;
}
#line 2075 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 40:
#line 233 "ext/pdo_sqlite/sqlite/src/parse.y"
{
  yygotominor.yy198.z = yymsp[-5].minor.yy198.z;
  yygotominor.yy198.n = &yymsp[0].minor.yy0.z[yymsp[0].minor.yy0.n] - yymsp[-5].minor.yy198.z;
}
#line 2083 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 42:
#line 239 "ext/pdo_sqlite/sqlite/src/parse.y"
{yygotominor.yy198.z=yymsp[-1].minor.yy198.z; yygotominor.yy198.n=yymsp[0].minor.yy198.n+(yymsp[0].minor.yy198.z-yymsp[-1].minor.yy198.z);}
#line 2088 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 43:
#line 241 "ext/pdo_sqlite/sqlite/src/parse.y"
{ yygotominor.yy280 = atoi(yymsp[0].minor.yy198.z); }
#line 2093 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 44:
#line 242 "ext/pdo_sqlite/sqlite/src/parse.y"
{ yygotominor.yy280 = -atoi(yymsp[0].minor.yy198.z); }
#line 2098 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 49:
      case 51:
#line 251 "ext/pdo_sqlite/sqlite/src/parse.y"
{sqlite3AddDefaultValue(pParse,yymsp[0].minor.yy62);}
#line 2104 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 50:
#line 252 "ext/pdo_sqlite/sqlite/src/parse.y"
{sqlite3AddDefaultValue(pParse,yymsp[-1].minor.yy62);}
#line 2109 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 52:
#line 254 "ext/pdo_sqlite/sqlite/src/parse.y"
{
  Expr *p = sqlite3Expr(TK_UMINUS, yymsp[0].minor.yy62, 0, 0);
  sqlite3AddDefaultValue(pParse,p);
}
#line 2117 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 53:
#line 258 "ext/pdo_sqlite/sqlite/src/parse.y"
{
  Expr *p = sqlite3Expr(TK_STRING, 0, 0, &yymsp[0].minor.yy198);
  sqlite3AddDefaultValue(pParse,p);
}
#line 2125 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 55:
#line 267 "ext/pdo_sqlite/sqlite/src/parse.y"
{sqlite3AddNotNull(pParse, yymsp[0].minor.yy280);}
#line 2130 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 56:
#line 269 "ext/pdo_sqlite/sqlite/src/parse.y"
{sqlite3AddPrimaryKey(pParse,0,yymsp[-1].minor.yy280,yymsp[0].minor.yy280);}
#line 2135 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 57:
#line 270 "ext/pdo_sqlite/sqlite/src/parse.y"
{sqlite3CreateIndex(pParse,0,0,0,0,yymsp[0].minor.yy280,0,0);}
#line 2140 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 58:
#line 271 "ext/pdo_sqlite/sqlite/src/parse.y"
{sqlite3ExprDelete(yymsp[-2].minor.yy62);}
#line 2145 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 59:
#line 273 "ext/pdo_sqlite/sqlite/src/parse.y"
{sqlite3CreateForeignKey(pParse,0,&yymsp[-2].minor.yy198,yymsp[-1].minor.yy418,yymsp[0].minor.yy280);}
#line 2150 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 60:
#line 274 "ext/pdo_sqlite/sqlite/src/parse.y"
{sqlite3DeferForeignKey(pParse,yymsp[0].minor.yy280);}
#line 2155 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 61:
#line 275 "ext/pdo_sqlite/sqlite/src/parse.y"
{sqlite3AddCollateType(pParse, yymsp[0].minor.yy198.z, yymsp[0].minor.yy198.n);}
#line 2160 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 64:
#line 288 "ext/pdo_sqlite/sqlite/src/parse.y"
{ yygotominor.yy280 = OE_Restrict * 0x010101; }
#line 2165 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 65:
#line 289 "ext/pdo_sqlite/sqlite/src/parse.y"
{ yygotominor.yy280 = (yymsp[-1].minor.yy280 & yymsp[0].minor.yy359.mask) | yymsp[0].minor.yy359.value; }
#line 2170 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 66:
#line 291 "ext/pdo_sqlite/sqlite/src/parse.y"
{ yygotominor.yy359.value = 0;     yygotominor.yy359.mask = 0x000000; }
#line 2175 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 67:
#line 292 "ext/pdo_sqlite/sqlite/src/parse.y"
{ yygotominor.yy359.value = yymsp[0].minor.yy280;     yygotominor.yy359.mask = 0x0000ff; }
#line 2180 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 68:
#line 293 "ext/pdo_sqlite/sqlite/src/parse.y"
{ yygotominor.yy359.value = yymsp[0].minor.yy280<<8;  yygotominor.yy359.mask = 0x00ff00; }
#line 2185 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 69:
#line 294 "ext/pdo_sqlite/sqlite/src/parse.y"
{ yygotominor.yy359.value = yymsp[0].minor.yy280<<16; yygotominor.yy359.mask = 0xff0000; }
#line 2190 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 70:
#line 296 "ext/pdo_sqlite/sqlite/src/parse.y"
{ yygotominor.yy280 = OE_SetNull; }
#line 2195 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 71:
#line 297 "ext/pdo_sqlite/sqlite/src/parse.y"
{ yygotominor.yy280 = OE_SetDflt; }
#line 2200 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 72:
#line 298 "ext/pdo_sqlite/sqlite/src/parse.y"
{ yygotominor.yy280 = OE_Cascade; }
#line 2205 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 73:
#line 299 "ext/pdo_sqlite/sqlite/src/parse.y"
{ yygotominor.yy280 = OE_Restrict; }
#line 2210 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 74:
      case 75:
      case 90:
      case 92:
      case 94:
      case 95:
      case 166:
#line 301 "ext/pdo_sqlite/sqlite/src/parse.y"
{yygotominor.yy280 = yymsp[0].minor.yy280;}
#line 2221 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 79:
#line 311 "ext/pdo_sqlite/sqlite/src/parse.y"
{yygotominor.yy198.n = 0; yygotominor.yy198.z = 0;}
#line 2226 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 80:
#line 312 "ext/pdo_sqlite/sqlite/src/parse.y"
{yygotominor.yy198 = yymsp[-1].minor.yy0;}
#line 2231 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 85:
#line 318 "ext/pdo_sqlite/sqlite/src/parse.y"
{sqlite3AddPrimaryKey(pParse,yymsp[-3].minor.yy418,yymsp[0].minor.yy280,yymsp[-2].minor.yy280);}
#line 2236 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 86:
#line 320 "ext/pdo_sqlite/sqlite/src/parse.y"
{sqlite3CreateIndex(pParse,0,0,0,yymsp[-2].minor.yy418,yymsp[0].minor.yy280,0,0);}
#line 2241 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 88:
#line 323 "ext/pdo_sqlite/sqlite/src/parse.y"
{
    sqlite3CreateForeignKey(pParse, yymsp[-6].minor.yy418, &yymsp[-3].minor.yy198, yymsp[-2].minor.yy418, yymsp[-1].minor.yy280);
    sqlite3DeferForeignKey(pParse, yymsp[0].minor.yy280);
}
#line 2249 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 91:
      case 93:
#line 337 "ext/pdo_sqlite/sqlite/src/parse.y"
{yygotominor.yy280 = OE_Default;}
#line 2255 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 96:
#line 342 "ext/pdo_sqlite/sqlite/src/parse.y"
{yygotominor.yy280 = OE_Ignore;}
#line 2260 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 97:
      case 167:
#line 343 "ext/pdo_sqlite/sqlite/src/parse.y"
{yygotominor.yy280 = OE_Replace;}
#line 2266 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 98:
#line 347 "ext/pdo_sqlite/sqlite/src/parse.y"
{
  sqlite3DropTable(pParse, yymsp[0].minor.yy151, 0);
}
#line 2273 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 99:
#line 354 "ext/pdo_sqlite/sqlite/src/parse.y"
{
  sqlite3CreateView(pParse, &yymsp[-6].minor.yy0, &yymsp[-3].minor.yy198, &yymsp[-2].minor.yy198, yymsp[0].minor.yy375, yymsp[-5].minor.yy280);
}
#line 2280 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 100:
#line 357 "ext/pdo_sqlite/sqlite/src/parse.y"
{
  sqlite3DropTable(pParse, yymsp[0].minor.yy151, 1);
}
#line 2287 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 101:
#line 364 "ext/pdo_sqlite/sqlite/src/parse.y"
{
  sqlite3Select(pParse, yymsp[0].minor.yy375, SRT_Callback, 0, 0, 0, 0, 0);
  sqlite3SelectDelete(yymsp[0].minor.yy375);
}
#line 2295 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 102:
      case 126:
#line 374 "ext/pdo_sqlite/sqlite/src/parse.y"
{yygotominor.yy375 = yymsp[0].minor.yy375;}
#line 2301 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 103:
#line 376 "ext/pdo_sqlite/sqlite/src/parse.y"
{
  if( yymsp[0].minor.yy375 ){
    yymsp[0].minor.yy375->op = yymsp[-1].minor.yy280;
    yymsp[0].minor.yy375->pPrior = yymsp[-2].minor.yy375;
  }
  yygotominor.yy375 = yymsp[0].minor.yy375;
}
#line 2312 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 105:
#line 385 "ext/pdo_sqlite/sqlite/src/parse.y"
{yygotominor.yy280 = TK_ALL;}
#line 2317 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 108:
#line 390 "ext/pdo_sqlite/sqlite/src/parse.y"
{
  yygotominor.yy375 = sqlite3SelectNew(yymsp[-6].minor.yy418,yymsp[-5].minor.yy151,yymsp[-4].minor.yy62,yymsp[-3].minor.yy418,yymsp[-2].minor.yy62,yymsp[-1].minor.yy418,yymsp[-7].minor.yy280,yymsp[0].minor.yy220.pLimit,yymsp[0].minor.yy220.pOffset);
}
#line 2324 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 112:
      case 248:
#line 411 "ext/pdo_sqlite/sqlite/src/parse.y"
{yygotominor.yy418 = yymsp[-1].minor.yy418;}
#line 2330 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 113:
      case 140:
      case 150:
      case 247:
#line 412 "ext/pdo_sqlite/sqlite/src/parse.y"
{yygotominor.yy418 = 0;}
#line 2338 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 114:
#line 413 "ext/pdo_sqlite/sqlite/src/parse.y"
{
   yygotominor.yy418 = sqlite3ExprListAppend(yymsp[-2].minor.yy418,yymsp[-1].minor.yy62,yymsp[0].minor.yy198.n?&yymsp[0].minor.yy198:0);
}
#line 2345 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 115:
#line 416 "ext/pdo_sqlite/sqlite/src/parse.y"
{
  yygotominor.yy418 = sqlite3ExprListAppend(yymsp[-1].minor.yy418, sqlite3Expr(TK_ALL, 0, 0, 0), 0);
}
#line 2352 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 116:
#line 419 "ext/pdo_sqlite/sqlite/src/parse.y"
{
  Expr *pRight = sqlite3Expr(TK_ALL, 0, 0, 0);
  Expr *pLeft = sqlite3Expr(TK_ID, 0, 0, &yymsp[-2].minor.yy198);
  yygotominor.yy418 = sqlite3ExprListAppend(yymsp[-3].minor.yy418, sqlite3Expr(TK_DOT, pLeft, pRight, 0), 0);
}
#line 2361 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 119:
#line 431 "ext/pdo_sqlite/sqlite/src/parse.y"
{yygotominor.yy198.n = 0;}
#line 2366 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 120:
#line 443 "ext/pdo_sqlite/sqlite/src/parse.y"
{yygotominor.yy151 = sqliteMalloc(sizeof(*yygotominor.yy151));}
#line 2371 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 121:
#line 444 "ext/pdo_sqlite/sqlite/src/parse.y"
{yygotominor.yy151 = yymsp[0].minor.yy151;}
#line 2376 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 122:
#line 449 "ext/pdo_sqlite/sqlite/src/parse.y"
{
   yygotominor.yy151 = yymsp[-1].minor.yy151;
   if( yygotominor.yy151 && yygotominor.yy151->nSrc>0 ) yygotominor.yy151->a[yygotominor.yy151->nSrc-1].jointype = yymsp[0].minor.yy280;
}
#line 2384 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 123:
#line 453 "ext/pdo_sqlite/sqlite/src/parse.y"
{yygotominor.yy151 = 0;}
#line 2389 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 124:
#line 454 "ext/pdo_sqlite/sqlite/src/parse.y"
{
  yygotominor.yy151 = sqlite3SrcListAppend(yymsp[-5].minor.yy151,&yymsp[-4].minor.yy198,&yymsp[-3].minor.yy198);
  if( yymsp[-2].minor.yy198.n ) sqlite3SrcListAddAlias(yygotominor.yy151,&yymsp[-2].minor.yy198);
  if( yymsp[-1].minor.yy62 ){
    if( yygotominor.yy151 && yygotominor.yy151->nSrc>1 ){ yygotominor.yy151->a[yygotominor.yy151->nSrc-2].pOn = yymsp[-1].minor.yy62; }
    else { sqlite3ExprDelete(yymsp[-1].minor.yy62); }
  }
  if( yymsp[0].minor.yy240 ){
    if( yygotominor.yy151 && yygotominor.yy151->nSrc>1 ){ yygotominor.yy151->a[yygotominor.yy151->nSrc-2].pUsing = yymsp[0].minor.yy240; }
    else { sqlite3IdListDelete(yymsp[0].minor.yy240); }
  }
}
#line 2405 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 125:
#line 468 "ext/pdo_sqlite/sqlite/src/parse.y"
{
    yygotominor.yy151 = sqlite3SrcListAppend(yymsp[-6].minor.yy151,0,0);
    yygotominor.yy151->a[yygotominor.yy151->nSrc-1].pSelect = yymsp[-4].minor.yy375;
    if( yymsp[-2].minor.yy198.n ) sqlite3SrcListAddAlias(yygotominor.yy151,&yymsp[-2].minor.yy198);
    if( yymsp[-1].minor.yy62 ){
      if( yygotominor.yy151 && yygotominor.yy151->nSrc>1 ){ yygotominor.yy151->a[yygotominor.yy151->nSrc-2].pOn = yymsp[-1].minor.yy62; }
      else { sqlite3ExprDelete(yymsp[-1].minor.yy62); }
    }
    if( yymsp[0].minor.yy240 ){
      if( yygotominor.yy151 && yygotominor.yy151->nSrc>1 ){ yygotominor.yy151->a[yygotominor.yy151->nSrc-2].pUsing = yymsp[0].minor.yy240; }
      else { sqlite3IdListDelete(yymsp[0].minor.yy240); }
    }
  }
#line 2422 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 127:
#line 489 "ext/pdo_sqlite/sqlite/src/parse.y"
{
     yygotominor.yy375 = sqlite3SelectNew(0,yymsp[0].minor.yy151,0,0,0,0,0,0,0);
  }
#line 2429 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 128:
#line 495 "ext/pdo_sqlite/sqlite/src/parse.y"
{yygotominor.yy198.z=0; yygotominor.yy198.n=0;}
#line 2434 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 130:
#line 500 "ext/pdo_sqlite/sqlite/src/parse.y"
{yygotominor.yy151 = sqlite3SrcListAppend(0,&yymsp[-1].minor.yy198,&yymsp[0].minor.yy198);}
#line 2439 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 131:
      case 132:
#line 504 "ext/pdo_sqlite/sqlite/src/parse.y"
{ yygotominor.yy280 = JT_INNER; }
#line 2445 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 133:
#line 506 "ext/pdo_sqlite/sqlite/src/parse.y"
{ yygotominor.yy280 = sqlite3JoinType(pParse,&yymsp[-1].minor.yy0,0,0); }
#line 2450 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 134:
#line 507 "ext/pdo_sqlite/sqlite/src/parse.y"
{ yygotominor.yy280 = sqlite3JoinType(pParse,&yymsp[-2].minor.yy0,&yymsp[-1].minor.yy198,0); }
#line 2455 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 135:
#line 509 "ext/pdo_sqlite/sqlite/src/parse.y"
{ yygotominor.yy280 = sqlite3JoinType(pParse,&yymsp[-3].minor.yy0,&yymsp[-2].minor.yy198,&yymsp[-1].minor.yy198); }
#line 2460 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 136:
      case 144:
      case 153:
      case 160:
      case 174:
      case 211:
      case 236:
      case 238:
      case 242:
#line 513 "ext/pdo_sqlite/sqlite/src/parse.y"
{yygotominor.yy62 = yymsp[0].minor.yy62;}
#line 2473 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 137:
      case 152:
      case 159:
      case 212:
      case 237:
      case 239:
      case 243:
#line 514 "ext/pdo_sqlite/sqlite/src/parse.y"
{yygotominor.yy62 = 0;}
#line 2484 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 138:
      case 171:
#line 518 "ext/pdo_sqlite/sqlite/src/parse.y"
{yygotominor.yy240 = yymsp[-1].minor.yy240;}
#line 2490 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 139:
      case 170:
#line 519 "ext/pdo_sqlite/sqlite/src/parse.y"
{yygotominor.yy240 = 0;}
#line 2496 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 141:
      case 151:
#line 530 "ext/pdo_sqlite/sqlite/src/parse.y"
{yygotominor.yy418 = yymsp[0].minor.yy418;}
#line 2502 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 142:
#line 531 "ext/pdo_sqlite/sqlite/src/parse.y"
{
  yygotominor.yy418 = sqlite3ExprListAppend(yymsp[-4].minor.yy418,yymsp[-2].minor.yy62,yymsp[-1].minor.yy198.n>0?&yymsp[-1].minor.yy198:0);
  if( yygotominor.yy418 ) yygotominor.yy418->a[yygotominor.yy418->nExpr-1].sortOrder = yymsp[0].minor.yy280;
}
#line 2510 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 143:
#line 535 "ext/pdo_sqlite/sqlite/src/parse.y"
{
  yygotominor.yy418 = sqlite3ExprListAppend(0,yymsp[-2].minor.yy62,yymsp[-1].minor.yy198.n>0?&yymsp[-1].minor.yy198:0);
  if( yygotominor.yy418 && yygotominor.yy418->a ) yygotominor.yy418->a[0].sortOrder = yymsp[0].minor.yy280;
}
#line 2518 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 145:
      case 147:
#line 544 "ext/pdo_sqlite/sqlite/src/parse.y"
{yygotominor.yy280 = SQLITE_SO_ASC;}
#line 2524 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 146:
#line 545 "ext/pdo_sqlite/sqlite/src/parse.y"
{yygotominor.yy280 = SQLITE_SO_DESC;}
#line 2529 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 148:
#line 547 "ext/pdo_sqlite/sqlite/src/parse.y"
{yygotominor.yy198.z = 0; yygotominor.yy198.n = 0;}
#line 2534 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 154:
#line 565 "ext/pdo_sqlite/sqlite/src/parse.y"
{yygotominor.yy220.pLimit = 0; yygotominor.yy220.pOffset = 0;}
#line 2539 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 155:
#line 566 "ext/pdo_sqlite/sqlite/src/parse.y"
{yygotominor.yy220.pLimit = yymsp[0].minor.yy62; yygotominor.yy220.pOffset = 0;}
#line 2544 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 156:
#line 568 "ext/pdo_sqlite/sqlite/src/parse.y"
{yygotominor.yy220.pLimit = yymsp[-2].minor.yy62; yygotominor.yy220.pOffset = yymsp[0].minor.yy62;}
#line 2549 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 157:
#line 570 "ext/pdo_sqlite/sqlite/src/parse.y"
{yygotominor.yy220.pOffset = yymsp[-2].minor.yy62; yygotominor.yy220.pLimit = yymsp[0].minor.yy62;}
#line 2554 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 158:
#line 574 "ext/pdo_sqlite/sqlite/src/parse.y"
{sqlite3DeleteFrom(pParse,yymsp[-1].minor.yy151,yymsp[0].minor.yy62);}
#line 2559 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 161:
#line 585 "ext/pdo_sqlite/sqlite/src/parse.y"
{sqlite3Update(pParse,yymsp[-3].minor.yy151,yymsp[-1].minor.yy418,yymsp[0].minor.yy62,yymsp[-4].minor.yy280);}
#line 2564 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 162:
#line 591 "ext/pdo_sqlite/sqlite/src/parse.y"
{yygotominor.yy418 = sqlite3ExprListAppend(yymsp[-4].minor.yy418,yymsp[0].minor.yy62,&yymsp[-2].minor.yy198);}
#line 2569 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 163:
#line 592 "ext/pdo_sqlite/sqlite/src/parse.y"
{yygotominor.yy418 = sqlite3ExprListAppend(0,yymsp[0].minor.yy62,&yymsp[-2].minor.yy198);}
#line 2574 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 164:
#line 598 "ext/pdo_sqlite/sqlite/src/parse.y"
{sqlite3Insert(pParse, yymsp[-5].minor.yy151, yymsp[-1].minor.yy418, 0, yymsp[-4].minor.yy240, yymsp[-7].minor.yy280);}
#line 2579 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 165:
#line 600 "ext/pdo_sqlite/sqlite/src/parse.y"
{sqlite3Insert(pParse, yymsp[-2].minor.yy151, 0, yymsp[0].minor.yy375, yymsp[-1].minor.yy240, yymsp[-4].minor.yy280);}
#line 2584 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 168:
      case 240:
#line 610 "ext/pdo_sqlite/sqlite/src/parse.y"
{yygotominor.yy418 = sqlite3ExprListAppend(yymsp[-2].minor.yy418,yymsp[0].minor.yy62,0);}
#line 2590 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 169:
      case 241:
#line 611 "ext/pdo_sqlite/sqlite/src/parse.y"
{yygotominor.yy418 = sqlite3ExprListAppend(0,yymsp[0].minor.yy62,0);}
#line 2596 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 172:
#line 620 "ext/pdo_sqlite/sqlite/src/parse.y"
{yygotominor.yy240 = sqlite3IdListAppend(yymsp[-2].minor.yy240,&yymsp[0].minor.yy198);}
#line 2601 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 173:
#line 621 "ext/pdo_sqlite/sqlite/src/parse.y"
{yygotominor.yy240 = sqlite3IdListAppend(0,&yymsp[0].minor.yy198);}
#line 2606 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 175:
#line 632 "ext/pdo_sqlite/sqlite/src/parse.y"
{yygotominor.yy62 = yymsp[-1].minor.yy62; sqlite3ExprSpan(yygotominor.yy62,&yymsp[-2].minor.yy0,&yymsp[0].minor.yy0); }
#line 2611 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 176:
      case 181:
      case 182:
      case 183:
      case 184:
#line 633 "ext/pdo_sqlite/sqlite/src/parse.y"
{yygotominor.yy62 = sqlite3Expr(yymsp[0].major, 0, 0, &yymsp[0].minor.yy0);}
#line 2620 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 177:
      case 178:
#line 634 "ext/pdo_sqlite/sqlite/src/parse.y"
{yygotominor.yy62 = sqlite3Expr(TK_ID, 0, 0, &yymsp[0].minor.yy0);}
#line 2626 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 179:
#line 636 "ext/pdo_sqlite/sqlite/src/parse.y"
{
  Expr *temp1 = sqlite3Expr(TK_ID, 0, 0, &yymsp[-2].minor.yy198);
  Expr *temp2 = sqlite3Expr(TK_ID, 0, 0, &yymsp[0].minor.yy198);
  yygotominor.yy62 = sqlite3Expr(TK_DOT, temp1, temp2, 0);
}
#line 2635 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 180:
#line 641 "ext/pdo_sqlite/sqlite/src/parse.y"
{
  Expr *temp1 = sqlite3Expr(TK_ID, 0, 0, &yymsp[-4].minor.yy198);
  Expr *temp2 = sqlite3Expr(TK_ID, 0, 0, &yymsp[-2].minor.yy198);
  Expr *temp3 = sqlite3Expr(TK_ID, 0, 0, &yymsp[0].minor.yy198);
  Expr *temp4 = sqlite3Expr(TK_DOT, temp2, temp3, 0);
  yygotominor.yy62 = sqlite3Expr(TK_DOT, temp1, temp4, 0);
}
#line 2646 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 185:
#line 652 "ext/pdo_sqlite/sqlite/src/parse.y"
{yygotominor.yy62 = sqlite3RegisterExpr(pParse, &yymsp[0].minor.yy0);}
#line 2651 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 186:
#line 653 "ext/pdo_sqlite/sqlite/src/parse.y"
{
  Token *pToken = &yymsp[0].minor.yy0;
  Expr *pExpr = yygotominor.yy62 = sqlite3Expr(TK_VARIABLE, 0, 0, pToken);
  sqlite3ExprAssignVarNumber(pParse, pExpr);
}
#line 2660 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 187:
#line 659 "ext/pdo_sqlite/sqlite/src/parse.y"
{
  yygotominor.yy62 = sqlite3Expr(TK_CAST, yymsp[-3].minor.yy62, 0, &yymsp[-1].minor.yy198);
  sqlite3ExprSpan(yygotominor.yy62,&yymsp[-5].minor.yy0,&yymsp[0].minor.yy0);
}
#line 2668 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 188:
#line 664 "ext/pdo_sqlite/sqlite/src/parse.y"
{
  yygotominor.yy62 = sqlite3ExprFunction(yymsp[-1].minor.yy418, &yymsp[-4].minor.yy0);
  sqlite3ExprSpan(yygotominor.yy62,&yymsp[-4].minor.yy0,&yymsp[0].minor.yy0);
  if( yymsp[-2].minor.yy280 ){
    yygotominor.yy62->flags |= EP_Distinct;
  }
}
#line 2679 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 189:
#line 671 "ext/pdo_sqlite/sqlite/src/parse.y"
{
  yygotominor.yy62 = sqlite3ExprFunction(0, &yymsp[-3].minor.yy0);
  sqlite3ExprSpan(yygotominor.yy62,&yymsp[-3].minor.yy0,&yymsp[0].minor.yy0);
}
#line 2687 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 190:
#line 675 "ext/pdo_sqlite/sqlite/src/parse.y"
{
  /* The CURRENT_TIME, CURRENT_DATE, and CURRENT_TIMESTAMP values are
  ** treated as functions that return constants */
  yygotominor.yy62 = sqlite3ExprFunction(0,&yymsp[0].minor.yy0);
  if( yygotominor.yy62 ) yygotominor.yy62->op = TK_CONST_FUNC;  
}
#line 2697 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 191:
      case 192:
      case 193:
      case 194:
      case 195:
      case 196:
      case 197:
      case 198:
      case 199:
      case 200:
      case 201:
      case 202:
      case 203:
      case 204:
      case 205:
      case 206:
      case 207:
      case 208:
#line 681 "ext/pdo_sqlite/sqlite/src/parse.y"
{yygotominor.yy62 = sqlite3Expr(yymsp[-1].major, yymsp[-2].minor.yy62, yymsp[0].minor.yy62, 0);}
#line 2719 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 209:
#line 700 "ext/pdo_sqlite/sqlite/src/parse.y"
{yygotominor.yy222.operator = yymsp[0].minor.yy0; yygotominor.yy222.not = 0;}
#line 2724 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 210:
#line 701 "ext/pdo_sqlite/sqlite/src/parse.y"
{yygotominor.yy222.operator = yymsp[0].minor.yy0; yygotominor.yy222.not = 1;}
#line 2729 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 213:
#line 705 "ext/pdo_sqlite/sqlite/src/parse.y"
{
  ExprList *pList = sqlite3ExprListAppend(0, yymsp[-1].minor.yy62, 0);
  pList = sqlite3ExprListAppend(pList, yymsp[-3].minor.yy62, 0);
  if( yymsp[0].minor.yy62 ){
    pList = sqlite3ExprListAppend(pList, yymsp[0].minor.yy62, 0);
  }
  yygotominor.yy62 = sqlite3ExprFunction(pList, &yymsp[-2].minor.yy222.operator);
  if( yymsp[-2].minor.yy222.not ) yygotominor.yy62 = sqlite3Expr(TK_NOT, yygotominor.yy62, 0, 0);
  sqlite3ExprSpan(yygotominor.yy62, &yymsp[-3].minor.yy62->span, &yymsp[-1].minor.yy62->span);
}
#line 2743 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 214:
#line 716 "ext/pdo_sqlite/sqlite/src/parse.y"
{
  yygotominor.yy62 = sqlite3Expr(TK_ISNULL, yymsp[-1].minor.yy62, 0, 0);
  sqlite3ExprSpan(yygotominor.yy62,&yymsp[-1].minor.yy62->span,&yymsp[0].minor.yy0);
}
#line 2751 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 215:
#line 720 "ext/pdo_sqlite/sqlite/src/parse.y"
{
  yygotominor.yy62 = sqlite3Expr(TK_ISNULL, yymsp[-2].minor.yy62, 0, 0);
  sqlite3ExprSpan(yygotominor.yy62,&yymsp[-2].minor.yy62->span,&yymsp[0].minor.yy0);
}
#line 2759 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 216:
#line 724 "ext/pdo_sqlite/sqlite/src/parse.y"
{
  yygotominor.yy62 = sqlite3Expr(TK_NOTNULL, yymsp[-1].minor.yy62, 0, 0);
  sqlite3ExprSpan(yygotominor.yy62,&yymsp[-1].minor.yy62->span,&yymsp[0].minor.yy0);
}
#line 2767 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 217:
#line 728 "ext/pdo_sqlite/sqlite/src/parse.y"
{
  yygotominor.yy62 = sqlite3Expr(TK_NOTNULL, yymsp[-2].minor.yy62, 0, 0);
  sqlite3ExprSpan(yygotominor.yy62,&yymsp[-2].minor.yy62->span,&yymsp[0].minor.yy0);
}
#line 2775 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 218:
#line 732 "ext/pdo_sqlite/sqlite/src/parse.y"
{
  yygotominor.yy62 = sqlite3Expr(TK_NOTNULL, yymsp[-3].minor.yy62, 0, 0);
  sqlite3ExprSpan(yygotominor.yy62,&yymsp[-3].minor.yy62->span,&yymsp[0].minor.yy0);
}
#line 2783 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 219:
      case 220:
#line 736 "ext/pdo_sqlite/sqlite/src/parse.y"
{
  yygotominor.yy62 = sqlite3Expr(yymsp[-1].major, yymsp[0].minor.yy62, 0, 0);
  sqlite3ExprSpan(yygotominor.yy62,&yymsp[-1].minor.yy0,&yymsp[0].minor.yy62->span);
}
#line 2792 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 221:
#line 744 "ext/pdo_sqlite/sqlite/src/parse.y"
{
  yygotominor.yy62 = sqlite3Expr(TK_UMINUS, yymsp[0].minor.yy62, 0, 0);
  sqlite3ExprSpan(yygotominor.yy62,&yymsp[-1].minor.yy0,&yymsp[0].minor.yy62->span);
}
#line 2800 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 222:
#line 748 "ext/pdo_sqlite/sqlite/src/parse.y"
{
  yygotominor.yy62 = sqlite3Expr(TK_UPLUS, yymsp[0].minor.yy62, 0, 0);
  sqlite3ExprSpan(yygotominor.yy62,&yymsp[-1].minor.yy0,&yymsp[0].minor.yy62->span);
}
#line 2808 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 225:
#line 755 "ext/pdo_sqlite/sqlite/src/parse.y"
{
  ExprList *pList = sqlite3ExprListAppend(0, yymsp[-2].minor.yy62, 0);
  pList = sqlite3ExprListAppend(pList, yymsp[0].minor.yy62, 0);
  yygotominor.yy62 = sqlite3Expr(TK_BETWEEN, yymsp[-4].minor.yy62, 0, 0);
  if( yygotominor.yy62 ){
    yygotominor.yy62->pList = pList;
  }else{
    sqlite3ExprListDelete(pList);
  } 
  if( yymsp[-3].minor.yy280 ) yygotominor.yy62 = sqlite3Expr(TK_NOT, yygotominor.yy62, 0, 0);
  sqlite3ExprSpan(yygotominor.yy62,&yymsp[-4].minor.yy62->span,&yymsp[0].minor.yy62->span);
}
#line 2824 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 228:
#line 771 "ext/pdo_sqlite/sqlite/src/parse.y"
{
    yygotominor.yy62 = sqlite3Expr(TK_IN, yymsp[-4].minor.yy62, 0, 0);
    if( yygotominor.yy62 ){
      yygotominor.yy62->pList = yymsp[-1].minor.yy418;
    }else{
      sqlite3ExprListDelete(yymsp[-1].minor.yy418);
    }
    if( yymsp[-3].minor.yy280 ) yygotominor.yy62 = sqlite3Expr(TK_NOT, yygotominor.yy62, 0, 0);
    sqlite3ExprSpan(yygotominor.yy62,&yymsp[-4].minor.yy62->span,&yymsp[0].minor.yy0);
  }
#line 2838 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 229:
#line 781 "ext/pdo_sqlite/sqlite/src/parse.y"
{
    yygotominor.yy62 = sqlite3Expr(TK_SELECT, 0, 0, 0);
    if( yygotominor.yy62 ){
      yygotominor.yy62->pSelect = yymsp[-1].minor.yy375;
    }else{
      sqlite3SelectDelete(yymsp[-1].minor.yy375);
    }
    sqlite3ExprSpan(yygotominor.yy62,&yymsp[-2].minor.yy0,&yymsp[0].minor.yy0);
  }
#line 2851 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 230:
#line 790 "ext/pdo_sqlite/sqlite/src/parse.y"
{
    yygotominor.yy62 = sqlite3Expr(TK_IN, yymsp[-4].minor.yy62, 0, 0);
    if( yygotominor.yy62 ){
      yygotominor.yy62->pSelect = yymsp[-1].minor.yy375;
    }else{
      sqlite3SelectDelete(yymsp[-1].minor.yy375);
    }
    if( yymsp[-3].minor.yy280 ) yygotominor.yy62 = sqlite3Expr(TK_NOT, yygotominor.yy62, 0, 0);
    sqlite3ExprSpan(yygotominor.yy62,&yymsp[-4].minor.yy62->span,&yymsp[0].minor.yy0);
  }
#line 2865 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 231:
#line 800 "ext/pdo_sqlite/sqlite/src/parse.y"
{
    SrcList *pSrc = sqlite3SrcListAppend(0,&yymsp[-1].minor.yy198,&yymsp[0].minor.yy198);
    yygotominor.yy62 = sqlite3Expr(TK_IN, yymsp[-3].minor.yy62, 0, 0);
    if( yygotominor.yy62 ){
      yygotominor.yy62->pSelect = sqlite3SelectNew(0,pSrc,0,0,0,0,0,0,0);
    }else{
      sqlite3SrcListDelete(pSrc);
    }
    if( yymsp[-2].minor.yy280 ) yygotominor.yy62 = sqlite3Expr(TK_NOT, yygotominor.yy62, 0, 0);
    sqlite3ExprSpan(yygotominor.yy62,&yymsp[-3].minor.yy62->span,yymsp[0].minor.yy198.z?&yymsp[0].minor.yy198:&yymsp[-1].minor.yy198);
  }
#line 2880 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 232:
#line 811 "ext/pdo_sqlite/sqlite/src/parse.y"
{
    Expr *p = yygotominor.yy62 = sqlite3Expr(TK_EXISTS, 0, 0, 0);
    if( p ){
      p->pSelect = yymsp[-1].minor.yy375;
      sqlite3ExprSpan(p,&yymsp[-3].minor.yy0,&yymsp[0].minor.yy0);
    }else{
      sqlite3SelectDelete(yymsp[-1].minor.yy375);
    }
  }
#line 2893 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 233:
#line 823 "ext/pdo_sqlite/sqlite/src/parse.y"
{
  yygotominor.yy62 = sqlite3Expr(TK_CASE, yymsp[-3].minor.yy62, yymsp[-1].minor.yy62, 0);
  if( yygotominor.yy62 ){
    yygotominor.yy62->pList = yymsp[-2].minor.yy418;
  }else{
    sqlite3ExprListDelete(yymsp[-2].minor.yy418);
  }
  sqlite3ExprSpan(yygotominor.yy62, &yymsp[-4].minor.yy0, &yymsp[0].minor.yy0);
}
#line 2906 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 234:
#line 834 "ext/pdo_sqlite/sqlite/src/parse.y"
{
  yygotominor.yy418 = sqlite3ExprListAppend(yymsp[-4].minor.yy418, yymsp[-2].minor.yy62, 0);
  yygotominor.yy418 = sqlite3ExprListAppend(yygotominor.yy418, yymsp[0].minor.yy62, 0);
}
#line 2914 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 235:
#line 838 "ext/pdo_sqlite/sqlite/src/parse.y"
{
  yygotominor.yy418 = sqlite3ExprListAppend(0, yymsp[-2].minor.yy62, 0);
  yygotominor.yy418 = sqlite3ExprListAppend(yygotominor.yy418, yymsp[0].minor.yy62, 0);
}
#line 2922 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 244:
#line 863 "ext/pdo_sqlite/sqlite/src/parse.y"
{
  if( yymsp[-9].minor.yy280!=OE_None ) yymsp[-9].minor.yy280 = yymsp[0].minor.yy280;
  if( yymsp[-9].minor.yy280==OE_Default) yymsp[-9].minor.yy280 = OE_Abort;
  sqlite3CreateIndex(pParse, &yymsp[-7].minor.yy198, &yymsp[-6].minor.yy198, sqlite3SrcListAppend(0,&yymsp[-4].minor.yy198,0),yymsp[-2].minor.yy418,yymsp[-9].minor.yy280, &yymsp[-10].minor.yy0, &yymsp[-1].minor.yy0);
}
#line 2931 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 245:
      case 292:
#line 870 "ext/pdo_sqlite/sqlite/src/parse.y"
{yygotominor.yy280 = OE_Abort;}
#line 2937 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 246:
#line 871 "ext/pdo_sqlite/sqlite/src/parse.y"
{yygotominor.yy280 = OE_None;}
#line 2942 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 249:
#line 881 "ext/pdo_sqlite/sqlite/src/parse.y"
{
  Expr *p = 0;
  if( yymsp[-1].minor.yy198.n>0 ){
    p = sqlite3Expr(TK_COLUMN, 0, 0, 0);
    if( p ) p->pColl = sqlite3LocateCollSeq(pParse, yymsp[-1].minor.yy198.z, yymsp[-1].minor.yy198.n);
  }
  yygotominor.yy418 = sqlite3ExprListAppend(yymsp[-4].minor.yy418, p, &yymsp[-2].minor.yy198);
}
#line 2954 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 250:
#line 889 "ext/pdo_sqlite/sqlite/src/parse.y"
{
  Expr *p = 0;
  if( yymsp[-1].minor.yy198.n>0 ){
    p = sqlite3Expr(TK_COLUMN, 0, 0, 0);
    if( p ) p->pColl = sqlite3LocateCollSeq(pParse, yymsp[-1].minor.yy198.z, yymsp[-1].minor.yy198.n);
  }
  yygotominor.yy418 = sqlite3ExprListAppend(0, p, &yymsp[-2].minor.yy198);
}
#line 2966 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 252:
#line 902 "ext/pdo_sqlite/sqlite/src/parse.y"
{sqlite3DropIndex(pParse, yymsp[0].minor.yy151);}
#line 2971 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 253:
      case 254:
#line 906 "ext/pdo_sqlite/sqlite/src/parse.y"
{sqlite3Vacuum(pParse,0);}
#line 2977 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 255:
      case 257:
#line 912 "ext/pdo_sqlite/sqlite/src/parse.y"
{sqlite3Pragma(pParse,&yymsp[-3].minor.yy198,&yymsp[-2].minor.yy198,&yymsp[0].minor.yy198,0);}
#line 2983 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 256:
#line 913 "ext/pdo_sqlite/sqlite/src/parse.y"
{sqlite3Pragma(pParse,&yymsp[-3].minor.yy198,&yymsp[-2].minor.yy198,&yymsp[0].minor.yy0,0);}
#line 2988 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 258:
#line 915 "ext/pdo_sqlite/sqlite/src/parse.y"
{
  sqlite3Pragma(pParse,&yymsp[-3].minor.yy198,&yymsp[-2].minor.yy198,&yymsp[0].minor.yy198,1);
}
#line 2995 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 259:
#line 918 "ext/pdo_sqlite/sqlite/src/parse.y"
{sqlite3Pragma(pParse,&yymsp[-4].minor.yy198,&yymsp[-3].minor.yy198,&yymsp[-1].minor.yy198,0);}
#line 3000 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 260:
#line 919 "ext/pdo_sqlite/sqlite/src/parse.y"
{sqlite3Pragma(pParse,&yymsp[-1].minor.yy198,&yymsp[0].minor.yy198,0,0);}
#line 3005 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 267:
#line 932 "ext/pdo_sqlite/sqlite/src/parse.y"
{
  Token all;
  all.z = yymsp[-3].minor.yy198.z;
  all.n = (yymsp[0].minor.yy0.z - yymsp[-3].minor.yy198.z) + yymsp[0].minor.yy0.n;
  sqlite3FinishTrigger(pParse, yymsp[-1].minor.yy360, &all);
}
#line 3015 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 268:
#line 941 "ext/pdo_sqlite/sqlite/src/parse.y"
{
  sqlite3BeginTrigger(pParse, &yymsp[-7].minor.yy198, &yymsp[-6].minor.yy198, yymsp[-5].minor.yy280, yymsp[-4].minor.yy30.a, yymsp[-4].minor.yy30.b, yymsp[-2].minor.yy151, yymsp[-1].minor.yy280, yymsp[0].minor.yy62, yymsp[-9].minor.yy280);
  yygotominor.yy198 = (yymsp[-6].minor.yy198.n==0?yymsp[-7].minor.yy198:yymsp[-6].minor.yy198);
}
#line 3023 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 269:
      case 272:
#line 947 "ext/pdo_sqlite/sqlite/src/parse.y"
{ yygotominor.yy280 = TK_BEFORE; }
#line 3029 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 270:
#line 948 "ext/pdo_sqlite/sqlite/src/parse.y"
{ yygotominor.yy280 = TK_AFTER;  }
#line 3034 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 271:
#line 949 "ext/pdo_sqlite/sqlite/src/parse.y"
{ yygotominor.yy280 = TK_INSTEAD;}
#line 3039 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 273:
      case 274:
      case 275:
#line 954 "ext/pdo_sqlite/sqlite/src/parse.y"
{yygotominor.yy30.a = yymsp[0].major; yygotominor.yy30.b = 0;}
#line 3046 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 276:
#line 957 "ext/pdo_sqlite/sqlite/src/parse.y"
{yygotominor.yy30.a = TK_UPDATE; yygotominor.yy30.b = yymsp[0].minor.yy240;}
#line 3051 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 277:
      case 278:
#line 960 "ext/pdo_sqlite/sqlite/src/parse.y"
{ yygotominor.yy280 = TK_ROW; }
#line 3057 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 279:
#line 962 "ext/pdo_sqlite/sqlite/src/parse.y"
{ yygotominor.yy280 = TK_STATEMENT; }
#line 3062 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 280:
#line 965 "ext/pdo_sqlite/sqlite/src/parse.y"
{ yygotominor.yy62 = 0; }
#line 3067 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 281:
#line 966 "ext/pdo_sqlite/sqlite/src/parse.y"
{ yygotominor.yy62 = yymsp[0].minor.yy62; }
#line 3072 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 282:
#line 970 "ext/pdo_sqlite/sqlite/src/parse.y"
{
  yymsp[-2].minor.yy360->pNext = yymsp[0].minor.yy360;
  yygotominor.yy360 = yymsp[-2].minor.yy360;
}
#line 3080 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 283:
#line 974 "ext/pdo_sqlite/sqlite/src/parse.y"
{ yygotominor.yy360 = 0; }
#line 3085 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 284:
#line 980 "ext/pdo_sqlite/sqlite/src/parse.y"
{ yygotominor.yy360 = sqlite3TriggerUpdateStep(&yymsp[-3].minor.yy198, yymsp[-1].minor.yy418, yymsp[0].minor.yy62, yymsp[-4].minor.yy280); }
#line 3090 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 285:
#line 985 "ext/pdo_sqlite/sqlite/src/parse.y"
{yygotominor.yy360 = sqlite3TriggerInsertStep(&yymsp[-5].minor.yy198, yymsp[-4].minor.yy240, yymsp[-1].minor.yy418, 0, yymsp[-7].minor.yy280);}
#line 3095 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 286:
#line 988 "ext/pdo_sqlite/sqlite/src/parse.y"
{yygotominor.yy360 = sqlite3TriggerInsertStep(&yymsp[-2].minor.yy198, yymsp[-1].minor.yy240, 0, yymsp[0].minor.yy375, yymsp[-4].minor.yy280);}
#line 3100 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 287:
#line 992 "ext/pdo_sqlite/sqlite/src/parse.y"
{yygotominor.yy360 = sqlite3TriggerDeleteStep(&yymsp[-1].minor.yy198, yymsp[0].minor.yy62);}
#line 3105 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 288:
#line 995 "ext/pdo_sqlite/sqlite/src/parse.y"
{yygotominor.yy360 = sqlite3TriggerSelectStep(yymsp[0].minor.yy375); }
#line 3110 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 289:
#line 998 "ext/pdo_sqlite/sqlite/src/parse.y"
{
  yygotominor.yy62 = sqlite3Expr(TK_RAISE, 0, 0, 0); 
  yygotominor.yy62->iColumn = OE_Ignore;
  sqlite3ExprSpan(yygotominor.yy62, &yymsp[-3].minor.yy0, &yymsp[0].minor.yy0);
}
#line 3119 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 290:
#line 1003 "ext/pdo_sqlite/sqlite/src/parse.y"
{
  yygotominor.yy62 = sqlite3Expr(TK_RAISE, 0, 0, &yymsp[-1].minor.yy198); 
  yygotominor.yy62->iColumn = yymsp[-3].minor.yy280;
  sqlite3ExprSpan(yygotominor.yy62, &yymsp[-5].minor.yy0, &yymsp[0].minor.yy0);
}
#line 3128 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 291:
#line 1011 "ext/pdo_sqlite/sqlite/src/parse.y"
{yygotominor.yy280 = OE_Rollback;}
#line 3133 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 293:
#line 1013 "ext/pdo_sqlite/sqlite/src/parse.y"
{yygotominor.yy280 = OE_Fail;}
#line 3138 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 294:
#line 1018 "ext/pdo_sqlite/sqlite/src/parse.y"
{
  sqlite3DropTrigger(pParse,yymsp[0].minor.yy151);
}
#line 3145 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 295:
#line 1024 "ext/pdo_sqlite/sqlite/src/parse.y"
{
  sqlite3Attach(pParse, &yymsp[-3].minor.yy198, &yymsp[-1].minor.yy198, yymsp[0].minor.yy361.type, &yymsp[0].minor.yy361.key);
}
#line 3152 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 296:
#line 1028 "ext/pdo_sqlite/sqlite/src/parse.y"
{ yygotominor.yy361.type = 0; }
#line 3157 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 297:
#line 1029 "ext/pdo_sqlite/sqlite/src/parse.y"
{ yygotominor.yy361.type=1; yygotominor.yy361.key = yymsp[0].minor.yy198; }
#line 3162 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 298:
#line 1030 "ext/pdo_sqlite/sqlite/src/parse.y"
{ yygotominor.yy361.type=2; yygotominor.yy361.key = yymsp[0].minor.yy0; }
#line 3167 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 301:
#line 1036 "ext/pdo_sqlite/sqlite/src/parse.y"
{
  sqlite3Detach(pParse, &yymsp[0].minor.yy198);
}
#line 3174 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 302:
#line 1042 "ext/pdo_sqlite/sqlite/src/parse.y"
{sqlite3Reindex(pParse, 0, 0);}
#line 3179 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 303:
#line 1043 "ext/pdo_sqlite/sqlite/src/parse.y"
{sqlite3Reindex(pParse, &yymsp[-1].minor.yy198, &yymsp[0].minor.yy198);}
#line 3184 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 304:
#line 1048 "ext/pdo_sqlite/sqlite/src/parse.y"
{sqlite3Analyze(pParse, 0, 0);}
#line 3189 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 305:
#line 1049 "ext/pdo_sqlite/sqlite/src/parse.y"
{sqlite3Analyze(pParse, &yymsp[-1].minor.yy198, &yymsp[0].minor.yy198);}
#line 3194 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 306:
#line 1054 "ext/pdo_sqlite/sqlite/src/parse.y"
{
  sqlite3AlterRenameTable(pParse,yymsp[-3].minor.yy151,&yymsp[0].minor.yy198);
}
#line 3201 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 307:
#line 1057 "ext/pdo_sqlite/sqlite/src/parse.y"
{
  sqlite3AlterFinishAddColumn(pParse, &yymsp[0].minor.yy198);
}
#line 3208 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 308:
#line 1060 "ext/pdo_sqlite/sqlite/src/parse.y"
{
  sqlite3AlterBeginAddColumn(pParse, yymsp[0].minor.yy151);
}
#line 3215 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
  };
  yygoto = yyRuleInfo[yyruleno].lhs;
  yysize = yyRuleInfo[yyruleno].nrhs;
  yypParser->yyidx -= yysize;
  yyact = yy_find_reduce_action(yymsp[-yysize].stateno,yygoto);
  if( yyact < YYNSTATE ){
#ifdef NDEBUG
    /* If we are not debugging and the reduce action popped at least
    ** one element off the stack, then we can push the new element back
    ** onto the stack here, and skip the stack overflow test in yy_shift().
    ** That gives a significant speed improvement. */
    if( yysize ){
      yypParser->yyidx++;
      yymsp -= yysize-1;
      yymsp->stateno = yyact;
      yymsp->major = yygoto;
      yymsp->minor = yygotominor;
    }else
#endif
    {
      yy_shift(yypParser,yyact,yygoto,&yygotominor);
    }
  }else if( yyact == YYNSTATE + YYNRULE + 1 ){
    yy_accept(yypParser);
  }
}

/*
** The following code executes when the parse fails
*/
static void yy_parse_failed(
  yyParser *yypParser           /* The parser */
){
  sqlite3ParserARG_FETCH;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sFail!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser fails */
  sqlite3ParserARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

/*
** The following code executes when a syntax error first occurs.
*/
static void yy_syntax_error(
  yyParser *yypParser,           /* The parser */
  int yymajor,                   /* The major type of the error token */
  YYMINORTYPE yyminor            /* The minor type of the error token */
){
  sqlite3ParserARG_FETCH;
#define TOKEN (yyminor.yy0)
#line 34 "ext/pdo_sqlite/sqlite/src/parse.y"

  if( pParse->zErrMsg==0 ){
    if( TOKEN.z[0] ){
      sqlite3ErrorMsg(pParse, "near \"%T\": syntax error", &TOKEN);
    }else{
      sqlite3ErrorMsg(pParse, "incomplete SQL statement");
    }
  }
#line 3282 "ext/pdo_sqlite/sqlite/src/parse.c"
  sqlite3ParserARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

/*
** The following is executed when the parser accepts
*/
static void yy_accept(
  yyParser *yypParser           /* The parser */
){
  sqlite3ParserARG_FETCH;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sAccept!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser accepts */
  sqlite3ParserARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

/* The main parser program.
** The first argument is a pointer to a structure obtained from
** "sqlite3ParserAlloc" which describes the current state of the parser.
** The second argument is the major token number.  The third is
** the minor token.  The fourth optional argument is whatever the
** user wants (and specified in the grammar) and is available for
** use by the action routines.
**
** Inputs:
** <ul>
** <li> A pointer to the parser (an opaque structure.)
** <li> The major token number.
** <li> The minor token number.
** <li> An option argument of a grammar-specified type.
** </ul>
**
** Outputs:
** None.
*/
void sqlite3Parser(
  void *yyp,                   /* The parser */
  int yymajor,                 /* The major token code number */
  sqlite3ParserTOKENTYPE yyminor       /* The value for the token */
  sqlite3ParserARG_PDECL               /* Optional %extra_argument parameter */
){
  YYMINORTYPE yyminorunion;
  int yyact;            /* The parser action. */
  int yyendofinput;     /* True if we are at the end of input */
  int yyerrorhit = 0;   /* True if yymajor has invoked an error */
  yyParser *yypParser;  /* The parser */

  /* (re)initialize the parser, if necessary */
  yypParser = (yyParser*)yyp;
  if( yypParser->yyidx<0 ){
    /* if( yymajor==0 ) return; // not sure why this was here... */
    yypParser->yyidx = 0;
    yypParser->yyerrcnt = -1;
    yypParser->yystack[0].stateno = 0;
    yypParser->yystack[0].major = 0;
  }
  yyminorunion.yy0 = yyminor;
  yyendofinput = (yymajor==0);
  sqlite3ParserARG_STORE;

#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sInput %s\n",yyTracePrompt,yyTokenName[yymajor]);
  }
#endif

  do{
    yyact = yy_find_shift_action(yypParser,yymajor);
    if( yyact<YYNSTATE ){
      yy_shift(yypParser,yyact,yymajor,&yyminorunion);
      yypParser->yyerrcnt--;
      if( yyendofinput && yypParser->yyidx>=0 ){
        yymajor = 0;
      }else{
        yymajor = YYNOCODE;
      }
    }else if( yyact < YYNSTATE + YYNRULE ){
      yy_reduce(yypParser,yyact-YYNSTATE);
    }else if( yyact == YY_ERROR_ACTION ){
      int yymx;
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE,"%sSyntax Error!\n",yyTracePrompt);
      }
#endif
#ifdef YYERRORSYMBOL
      /* A syntax error has occurred.
      ** The response to an error depends upon whether or not the
      ** grammar defines an error token "ERROR".  
      **
      ** This is what we do if the grammar does define ERROR:
      **
      **  * Call the %syntax_error function.
      **
      **  * Begin popping the stack until we enter a state where
      **    it is legal to shift the error symbol, then shift
      **    the error symbol.
      **
      **  * Set the error count to three.
      **
      **  * Begin accepting and shifting new tokens.  No new error
      **    processing will occur until three tokens have been
      **    shifted successfully.
      **
      */
      if( yypParser->yyerrcnt<0 ){
        yy_syntax_error(yypParser,yymajor,yyminorunion);
      }
      yymx = yypParser->yystack[yypParser->yyidx].major;
      if( yymx==YYERRORSYMBOL || yyerrorhit ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE,"%sDiscard input token %s\n",
             yyTracePrompt,yyTokenName[yymajor]);
        }
#endif
        yy_destructor(yymajor,&yyminorunion);
        yymajor = YYNOCODE;
      }else{
         while(
          yypParser->yyidx >= 0 &&
          yymx != YYERRORSYMBOL &&
          (yyact = yy_find_shift_action(yypParser,YYERRORSYMBOL)) >= YYNSTATE
        ){
          yy_pop_parser_stack(yypParser);
        }
        if( yypParser->yyidx < 0 || yymajor==0 ){
          yy_destructor(yymajor,&yyminorunion);
          yy_parse_failed(yypParser);
          yymajor = YYNOCODE;
        }else if( yymx!=YYERRORSYMBOL ){
          YYMINORTYPE u2;
          u2.YYERRSYMDT = 0;
          yy_shift(yypParser,yyact,YYERRORSYMBOL,&u2);
        }
      }
      yypParser->yyerrcnt = 3;
      yyerrorhit = 1;
#else  /* YYERRORSYMBOL is not defined */
      /* This is what we do if the grammar does not define ERROR:
      **
      **  * Report an error message, and throw away the input token.
      **
      **  * If the input token is $, then fail the parse.
      **
      ** As before, subsequent error messages are suppressed until
      ** three input tokens have been successfully shifted.
      */
      if( yypParser->yyerrcnt<=0 ){
        yy_syntax_error(yypParser,yymajor,yyminorunion);
      }
      yypParser->yyerrcnt = 3;
      yy_destructor(yymajor,&yyminorunion);
      if( yyendofinput ){
        yy_parse_failed(yypParser);
      }
      yymajor = YYNOCODE;
#endif
    }else{
      yy_accept(yypParser);
      yymajor = YYNOCODE;
    }
  }while( yymajor!=YYNOCODE && yypParser->yyidx>=0 );
  return;
}
