<?php
///////////////////////////////////////////////////////////////////////////////
//
// NagiosQL
//
///////////////////////////////////////////////////////////////////////////////
//
// (c) 2005-2012 by Martin Willisegger
//
// Project   : NagiosQL
// Component : Admin file deletion
// Website   : http://www.nagiosql.org
// Date      : $LastChangedDate: 2012-02-27 13:01:17 +0100 (Mon, 27 Feb 2012) $
// Author    : $LastChangedBy: martin $
// Version   : 3.2.0
// Revision  : $LastChangedRevision: 1257 $
//
///////////////////////////////////////////////////////////////////////////////
//
// Define common variables
// =======================
$prePageId			= 26;
$preContent   		= "admin/delbackup.tpl.htm";
$preAccess    		= 1;
$preFieldvars 		= 1;
//
// Include preprocessing files
// ===========================
require("../functions/prepend_adm.php");
require("../functions/prepend_content.php");
//
// Get configuration set ID
// ========================
$arrConfigSet = $myConfigClass->getConfigSets();
$intConfigId  = $arrConfigSet[0];
$myConfigClass->getConfigData($intConfigId,"method",$intMethod);
$myConfigClass->getConfigData($intConfigId,"backupdir",$strBackupDir);
$myConfigClass->getConfigData($intConfigId,"hostbackup",$strHostBackupDir);
$myConfigClass->getConfigData($intConfigId,"servicebackup",$strServiceBackupDir);
//
// Process form inputs
// ===================
if (($chkMselValue1[0] != "") && ($chkStatus == 1)) {
	foreach($chkMselValue1 AS $elem) {
		$intCheck = $myConfigClass->removeFile(trim($elem),$intConfigId);
		$strFile = str_replace($strServiceBackupDir,"",$elem);
		$strFile = str_replace($strHostBackupDir,"",$strFile);
		$strFile = str_replace($strBackupDir,"",$strFile);
    	if ($intCheck == 0) {
      		$myDataClass->writeLog(translate("File deleted").": ".trim($strFile));
      		$myVisClass->processMessage($strFile." ".translate("successfully deleted")."!",$strInfoMessage);
    	} else {
			$myVisClass->processMessage($myConfigClass->strErrorMessage,$strErrorMessage);		
    	}
  	}
}
//
// Include content
// ===============
$conttp->setVariable("TITLE",translate("Delete backup files"));
$conttp->parse("header");
$conttp->show("header");
$conttp->setVariable("LANG_SEARCH_STRING",translate('Filter string'));
$conttp->setVariable("LANG_SEARCH",translate('Search'));
$conttp->setVariable("LANG_DELETE",translate('Delete'));
$conttp->setVariable("LANG_DELETE_SEARCH",translate("Reset filter"));
$conttp->setVariable("DAT_SEARCH",$chkTfSearch);
$conttp->setVariable("BACKUPFILE",translate("Backup file"));
$conttp->setVariable("LANG_REQUIRED",translate("required"));
$conttp->setVariable("MAKE",translate("Delete"));
$conttp->setVariable("ABORT",translate("Abort"));
$conttp->setVariable("CTRL_INFO",translate("Hold CTRL to select<br>more than one entry"));
$conttp->setVariable("IMAGE_PATH",$_SESSION['SETS']['path']['base_url']."images/");
$conttp->setVariable("ACTION_INSERT",filter_var($_SERVER['PHP_SELF'], FILTER_SANITIZE_STRING));
// Build a local file list
if ($intMethod == 1) {
	$output = array();
	$temp=$myConfigClass->DirToArray($strBackupDir, "\.cfg_", "",$output,$strErrorMessage);
  	if (is_array($output) && (count($output) != 0)) {
    	foreach ($output AS $elem) {
      		if (($chkTfSearch == "") || (substr_count($elem,$chkTfSearch) != 0)) {
				$conttp->setVariable("DAT_BACKUPFILE",$elem);
				$conttp->parse("filelist");
      		}
    	}
  	}
} else if ($intMethod == 2) {
	// Set up basic connection
	if ($myConfigClass->getFTPConnection($intConfigId) == "0") {
		$arrFiles  = array();
		$arrFiles1 = ftp_nlist($myConfigClass->resConnectId,$strBackupDir);
		if (is_array($arrFiles1)) $arrFiles = array_merge($arrFiles,$arrFiles1);
		$arrFiles2 = ftp_nlist($myConfigClass->resConnectId,$strHostBackupDir);
		if (is_array($arrFiles2)) $arrFiles = array_merge($arrFiles,$arrFiles2);
		$arrFiles1 = ftp_nlist($myConfigClass->resConnectId,$strServiceBackupDir);
		if (is_array($arrFiles1)) $arrFiles = array_merge($arrFiles,$arrFiles1);
		if (is_array($arrFiles) && (count($arrFiles) != 0)) {
			foreach ($arrFiles AS $elem) {
				if (!substr_count($elem,"cfg")) continue;
				if (($chkTfSearch == "") || (substr_count($elem,$chkTfSearch) != 0)) {
					$conttp->setVariable("DAT_BACKUPFILE",$elem);
					$conttp->parse("filelist");
				}
			}
		} else {
			$myVisClass->processMessage(translate("No backup files or no permission to read the backup files"),$strErrorMessage);
		}
		ftp_close($myConfigClass->resConnectId);
	} else {
		$myVisClass->processMessage($myConfigClass->strErrorMessage,$strErrorMessage);
	}
} else if ($intMethod == 3) {
  	// Set up basic connection
  	if ($myConfigClass->getSSHConnection($intConfigId) == "0") {
		$arrFiles  = array();
		$arrFiles1 = $myConfigClass->sendSSHCommand("ls ".$strBackupDir."*.cfg_old*");
		if (is_array($arrFiles1)) $arrFiles = array_merge($arrFiles,$arrFiles1);
		$arrFiles2 = $myConfigClass->sendSSHCommand("ls ".$strHostBackupDir."*.cfg_old*");
		if (is_array($arrFiles2)) $arrFiles = array_merge($arrFiles,$arrFiles2);
		$arrFiles3 = $myConfigClass->sendSSHCommand("ls ".$strServiceBackupDir."*.cfg_old*");
		if (is_array($arrFiles3)) $arrFiles = array_merge($arrFiles,$arrFiles3);
		if (is_array($arrFiles) && (count($arrFiles) != 0)) {
			foreach ($arrFiles AS $elem) {
				if (!substr_count($elem,"cfg_old")) continue;
				if (($chkTfSearch == "") || (substr_count($elem,$chkTfSearch) != 0)) {
			  		$conttp->setVariable("DAT_BACKUPFILE",str_replace("//","/",$elem));
			  		$conttp->parse("filelist");
				}
			}
		} else {
			$myVisClass->processMessage(translate("No backup files or no permission to read the backup files"),$strErrorMessage);
		}
	} else {
		$myVisClass->processMessage($myConfigClass->strErrorMessage,$strErrorMessage);
	}
}
if ($strErrorMessage != "") $conttp->setVariable("ERRORMESSAGE",$strErrorMessage);
$conttp->setVariable("INFOMESSAGE",$strInfoMessage);
// Check access rights for adding new objects
if ($myVisClass->checkAccGroup($prePageKey,'write') != 0) $conttp->setVariable("ADD_CONTROL","disabled=\"disabled\"");
$conttp->parse("main");
$conttp->show("main");
//
// Footer ausgeben
// ===============
$maintp->setVariable("VERSION_INFO","<a href='http://www.nagiosql.org' target='_blank'>NagiosQL</a> $setFileVersion");
$maintp->parse("footer");
$maintp->show("footer");
?>