/* Copyright (c) 2006-2008 MySQL AB, 2009 Sun Microsystems, Inc.
   Use is subject to license terms.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License, version 2.0,
   as published by the Free Software Foundation.

   This program is also distributed with certain software (including
   but not limited to OpenSSL) that is licensed under separate terms,
   as designated in a particular file or component or in included license
   documentation.  The authors of MySQL hereby grant you an additional
   permission to link the program and your derivative works with the
   separately licensed software that they have included with MySQL.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License, version 2.0, for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301  USA */


volatile int32 bad;
pthread_attr_t thr_attr;
mysql_mutex_t mutex;
mysql_cond_t cond;
uint running_threads;
const int THREADS= 30;
const int CYCLES= 3000;

void test_concurrently(const char *test, pthread_handler handler, int n, int m)
{
  pthread_t t;
  ulonglong now= my_getsystime();

  bad= 0;

  for (running_threads= n ; n ; n--)
  {
    if (pthread_create(&t, &thr_attr, handler, &m) != 0)
    {
      ADD_FAILURE() << "Could not create thread";
      abort();
    }
  }
  mysql_mutex_lock(&mutex);
  while (running_threads)
    mysql_cond_wait(&cond, &mutex);
  mysql_mutex_unlock(&mutex);

  now= my_getsystime()-now;
  EXPECT_FALSE(bad)
    << "tested " << test
    << " in " << ((double)now)/1e7 << " secs "
    << "(" << bad << ")";
}
