
/* A Bison parser, made by GNU Bison 2.4.1.  */

/* Skeleton implementation for Bison's Yacc-like parsers in C
   
      Copyright (C) 1984, 1989, 1990, 2000, 2001, 2002, 2003, 2004, 2005, 2006
   Free Software Foundation, Inc.
   
   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.  */

/* As a special exception, you may create a larger work that contains
   part or all of the Bison parser skeleton and distribute that work
   under terms of your choice, so long as that work isn't itself a
   parser generator using the skeleton or a modified version thereof
   as a parser skeleton.  Alternatively, if you modify or redistribute
   the parser skeleton itself, you may (at your option) remove this
   special exception, which will cause the skeleton and the resulting
   Bison output files to be licensed under the GNU General Public
   License without this special exception.
   
   This special exception was added by the Free Software Foundation in
   version 2.2 of Bison.  */

/* C LALR(1) parser skeleton written by Richard Stallman, by
   simplifying the original so-called "semantic" parser.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output.  */
#define YYBISON 1

/* Bison version.  */
#define YYBISON_VERSION "2.4.1"

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 1

/* Push parsers.  */
#define YYPUSH 0

/* Pull parsers.  */
#define YYPULL 1

/* Using locations.  */
#define YYLSP_NEEDED 0

/* Substitute the variable and function names.  */
#define yyparse         MYSQLparse
#define yylex           MYSQLlex
#define yyerror         MYSQLerror
#define yylval          MYSQLlval
#define yychar          MYSQLchar
#define yydebug         MYSQLdebug
#define yynerrs         MYSQLnerrs


/* Copy the first part of user declarations.  */

/* Line 189 of yacc.c  */
#line 25 "/home/buildbot/bzr/build/sql/sql_yacc.yy"

#define YYLIP  (& thd->m_parser_state->m_lip)
#define YYPS   (& thd->m_parser_state->m_yacc)
#define YYCSCL (thd->variables.character_set_client)

#define MYSQL_YACC
#define YYINITDEPTH 100
#define YYMAXDEPTH 3200                        /* Because of 64K stack */
#define Lex (thd->lex)

#define Select Lex->current_select
#include "sql_priv.h"
#include "unireg.h"                    // REQUIRED: for other includes
#include "sql_parse.h"                        /* comp_*_creator */
#include "sql_table.h"                        /* primary_key_name */
#include "sql_partition.h"  /* mem_alloc_error, partition_info, HASH_PARTITION */
#include "sql_acl.h"                          /* *_ACL */
#include "password.h"       /* my_make_scrambled_password_323, my_make_scrambled_password */
#include "sql_class.h"      /* Key_part_spec, enum_filetype, Diag_condition_item_name */
#include "slave.h"
#include "lex_symbol.h"
#include "item_create.h"
#include "sp_head.h"
#include "sp_pcontext.h"
#include "sp_rcontext.h"
#include "sp.h"
#include "sql_alter.h"                         // Sql_cmd_alter_table*
#include "sql_truncate.h"                      // Sql_cmd_truncate_table
#include "sql_admin.h"                         // Sql_cmd_analyze/Check..._table
#include "sql_partition_admin.h"               // Sql_cmd_alter_table_*_part.
#include "sql_handler.h"                       // Sql_cmd_handler_*
#include "sql_signal.h"
#include "sql_get_diagnostics.h"               // Sql_cmd_get_diagnostics
#include "event_parse_data.h"
#include "create_options.h"
#include <myisam.h>
#include <myisammrg.h>
#include "keycaches.h"
#include "set_var.h"
#include "rpl_mi.h"

/* this is to get the bison compilation windows warnings out */
#ifdef _MSC_VER
/* warning C4065: switch statement contains 'default' but no 'case' labels */
#pragma warning (disable : 4065)
#endif

int yylex(void *yylval, void *yythd);

#define yyoverflow(A,B,C,D,E,F)               \
  {                                           \
    ulong val= *(F);                          \
    if (my_yyoverflow((B), (D), &val))        \
    {                                         \
      yyerror(current_thd, (char*) (A));      \
      return 2;                               \
    }                                         \
    else                                      \
    {                                         \
      *(F)= (YYSIZE_T)val;                    \
    }                                         \
  }

#define MYSQL_YYABORT                         \
  do                                          \
  {                                           \
    LEX::cleanup_lex_after_parse_error(thd);  \
    YYABORT;                                  \
  } while (0)

#define MYSQL_YYABORT_UNLESS(A)         \
  if (!(A))                             \
  {                                     \
    my_parse_error(ER(ER_SYNTAX_ERROR));\
    MYSQL_YYABORT;                      \
  }

/*
  Work around for broken code generated by bison 1.875.

  The code generated by bison 1.875a and later, bison 2.1 and bison 2.2 is ok.
  With bison 1.875 however, the generated code contains:
<pre>
  yyerrlab1:
  #if defined (__GNUC_MINOR__) && 2093 <= (__GNUC__ * 1000 + __GNUC_MINOR__)
    __attribute__ ((__unused__))
  #endif
</pre>
  This usage of __attribute__ is illegal, so we remove it.
  See the following references for details:
  http://lists.gnu.org/archive/html/bug-bison/2004-02/msg00014.html
  http://gcc.gnu.org/bugzilla/show_bug.cgi?id=14273
*/

#if defined (__GNUC_MINOR__) && 2093 <= (__GNUC__ * 1000 + __GNUC_MINOR__)
#undef __attribute__
#define __attribute__(X)
#endif


#ifndef DBUG_OFF
#define YYDEBUG 1
#else
#define YYDEBUG 0
#endif

/**
  @brief Push an error message into MySQL error stack with line
  and position information.

  This function provides semantic action implementers with a way
  to push the famous "You have a syntax error near..." error
  message into the error stack, which is normally produced only if
  a parse error is discovered internally by the Bison generated
  parser.
*/

void my_parse_error(const char *s)
{
  THD *thd= current_thd;
  Lex_input_stream *lip= & thd->m_parser_state->m_lip;

  const char *yytext= lip->get_tok_start();
  if (!yytext)
    yytext= "";

  /* Push an error into the error stack */
  ErrConvString err(yytext, strlen(yytext), thd->variables.character_set_client);
  my_printf_error(ER_PARSE_ERROR,  ER(ER_PARSE_ERROR), MYF(0), s,
                  err.ptr(), lip->yylineno);
}

/**
  @brief Bison callback to report a syntax/OOM error

  This function is invoked by the bison-generated parser
  when a syntax error, a parse error or an out-of-memory
  condition occurs. This function is not invoked when the
  parser is requested to abort by semantic action code
  by means of YYABORT or YYACCEPT macros. This is why these
  macros should not be used (use MYSQL_YYABORT/MYSQL_YYACCEPT
  instead).

  The parser will abort immediately after invoking this callback.

  This function is not for use in semantic actions and is internal to
  the parser, as it performs some pre-return cleanup. 
  In semantic actions, please use my_parse_error or my_error to
  push an error into the error stack and MYSQL_YYABORT
  to abort from the parser.
*/

void MYSQLerror(THD *thd, const char *s)
{
  /*
    Restore the original LEX if it was replaced when parsing
    a stored procedure. We must ensure that a parsing error
    does not leave any side effects in the THD.
  */
  LEX::cleanup_lex_after_parse_error(thd);

  /* "parse error" changed into "syntax error" between bison 1.75 and 1.875 */
  if (strcmp(s,"parse error") == 0 || strcmp(s,"syntax error") == 0)
    s= ER(ER_SYNTAX_ERROR);
  my_parse_error(s);
}


#ifndef DBUG_OFF
void turn_parser_debug_on()
{
  /*
     MYSQLdebug is in sql/sql_yacc.cc, in bison generated code.
     Turning this option on is **VERY** verbose, and should be
     used when investigating a syntax error problem only.

     The syntax to run with bison traces is as follows :
     - Starting a server manually :
       mysqld --debug-dbug="d,parser_debug" ...
     - Running a test :
       mysql-test-run.pl --mysqld="--debug-dbug=d,parser_debug" ...

     The result will be in the process stderr (var/log/master.err)
   */

  extern int yydebug;
  yydebug= 1;
}
#endif

static bool is_native_function(THD *thd, const LEX_STRING *name)
{
  if (find_native_function_builder(thd, *name))
    return true;

  if (is_lex_native_function(name))
    return true;

  return false;
}


/**
  Helper action for a case statement (entering the CASE).
  This helper is used for both 'simple' and 'searched' cases.
  This helper, with the other case_stmt_action_..., is executed when
  the following SQL code is parsed:
<pre>
CREATE PROCEDURE proc_19194_simple(i int)
BEGIN
  DECLARE str CHAR(10);

  CASE i
    WHEN 1 THEN SET str="1";
    WHEN 2 THEN SET str="2";
    WHEN 3 THEN SET str="3";
    ELSE SET str="unknown";
  END CASE;

  SELECT str;
END
</pre>
  The actions are used to generate the following code:
<pre>
SHOW PROCEDURE CODE proc_19194_simple;
Pos     Instruction
0       set str@1 NULL
1       set_case_expr (12) 0 i@0
2       jump_if_not 5(12) (case_expr@0 = 1)
3       set str@1 _latin1'1'
4       jump 12
5       jump_if_not 8(12) (case_expr@0 = 2)
6       set str@1 _latin1'2'
7       jump 12
8       jump_if_not 11(12) (case_expr@0 = 3)
9       set str@1 _latin1'3'
10      jump 12
11      set str@1 _latin1'unknown'
12      stmt 0 "SELECT str"
</pre>

  @param lex the parser lex context
*/

void case_stmt_action_case(LEX *lex)
{
  lex->sphead->new_cont_backpatch(NULL);

  /*
    BACKPATCH: Creating target label for the jump to
    "case_stmt_action_end_case"
    (Instruction 12 in the example)
  */

  lex->spcont->push_label(current_thd, empty_lex_str, lex->sphead->instructions());
}

/**
  Helper action for a case expression statement (the expr in 'CASE expr').
  This helper is used for 'searched' cases only.
  @param lex the parser lex context
  @param expr the parsed expression
  @return 0 on success
*/

int case_stmt_action_expr(LEX *lex, Item* expr)
{
  sp_head *sp= lex->sphead;
  sp_pcontext *parsing_ctx= lex->spcont;
  int case_expr_id= parsing_ctx->register_case_expr();
  sp_instr_set_case_expr *i;

  if (parsing_ctx->push_case_expr_id(case_expr_id))
    return 1;

  i= new sp_instr_set_case_expr(sp->instructions(),
                                parsing_ctx, case_expr_id, expr, lex);

  sp->add_cont_backpatch(i);
  return sp->add_instr(i);
}

/**
  Helper action for a case when condition.
  This helper is used for both 'simple' and 'searched' cases.
  @param lex the parser lex context
  @param when the parsed expression for the WHEN clause
  @param simple true for simple cases, false for searched cases
*/

int case_stmt_action_when(LEX *lex, Item *when, bool simple)
{
  sp_head *sp= lex->sphead;
  sp_pcontext *ctx= lex->spcont;
  uint ip= sp->instructions();
  sp_instr_jump_if_not *i;
  Item_case_expr *var;
  Item *expr;

  if (simple)
  {
    var= new Item_case_expr(ctx->get_current_case_expr_id());

#ifndef DBUG_OFF
    if (var)
    {
      var->m_sp= sp;
    }
#endif

    expr= new Item_func_eq(var, when);
    i= new sp_instr_jump_if_not(ip, ctx, expr, lex);
  }
  else
    i= new sp_instr_jump_if_not(ip, ctx, when, lex);

  /*
    BACKPATCH: Registering forward jump from
    "case_stmt_action_when" to "case_stmt_action_then"
    (jump_if_not from instruction 2 to 5, 5 to 8 ... in the example)
  */

  return !MY_TEST(i) ||
         sp->push_backpatch(i, ctx->push_label(current_thd, empty_lex_str, 0)) ||
         sp->add_cont_backpatch(i) ||
         sp->add_instr(i);
}

/**
  Helper action for a case then statements.
  This helper is used for both 'simple' and 'searched' cases.
  @param lex the parser lex context
*/

int case_stmt_action_then(LEX *lex)
{
  sp_head *sp= lex->sphead;
  sp_pcontext *ctx= lex->spcont;
  uint ip= sp->instructions();
  sp_instr_jump *i = new sp_instr_jump(ip, ctx);
  if (!MY_TEST(i) || sp->add_instr(i))
    return 1;

  /*
    BACKPATCH: Resolving forward jump from
    "case_stmt_action_when" to "case_stmt_action_then"
    (jump_if_not from instruction 2 to 5, 5 to 8 ... in the example)
  */

  sp->backpatch(ctx->pop_label());

  /*
    BACKPATCH: Registering forward jump from
    "case_stmt_action_then" to "case_stmt_action_end_case"
    (jump from instruction 4 to 12, 7 to 12 ... in the example)
  */

  return sp->push_backpatch(i, ctx->last_label());
}

/**
  Helper action for an end case.
  This helper is used for both 'simple' and 'searched' cases.
  @param lex the parser lex context
  @param simple true for simple cases, false for searched cases
*/

void case_stmt_action_end_case(LEX *lex, bool simple)
{
  /*
    BACKPATCH: Resolving forward jump from
    "case_stmt_action_then" to "case_stmt_action_end_case"
    (jump from instruction 4 to 12, 7 to 12 ... in the example)
  */
  lex->sphead->backpatch(lex->spcont->pop_label());

  if (simple)
    lex->spcont->pop_case_expr_id();

  lex->sphead->do_cont_backpatch();
}


static bool
find_sys_var_null_base(THD *thd, struct sys_var_with_base *tmp)
{
  tmp->var= find_sys_var(thd, tmp->base_name.str, tmp->base_name.length);

  if (tmp->var == NULL)
    my_error(ER_UNKNOWN_SYSTEM_VARIABLE, MYF(0), tmp->base_name.str);
  else
    tmp->base_name= null_lex_str;

  return thd->is_error();
}


/**
  Helper action for a SET statement.
  Used to push a system variable into the assignment list.

  @param thd      the current thread
  @param tmp      the system variable with base name
  @param var_type the scope of the variable
  @param val      the value being assigned to the variable

  @return TRUE if error, FALSE otherwise.
*/

static bool
set_system_variable(THD *thd, struct sys_var_with_base *tmp,
                    enum enum_var_type var_type, Item *val)
{
  set_var *var;
  LEX *lex= thd->lex;

  /* No AUTOCOMMIT from a stored function or trigger. */
  if (lex->spcont && tmp->var == Sys_autocommit_ptr)
    lex->sphead->m_flags|= sp_head::HAS_SET_AUTOCOMMIT_STMT;

  if (val && val->type() == Item::FIELD_ITEM &&
      ((Item_field*)val)->table_name)
  {
    my_error(ER_WRONG_TYPE_FOR_VAR, MYF(0), tmp->var->name.str);
    return TRUE;
  }

  if (! (var= new set_var(var_type, tmp->var, &tmp->base_name, val)))
    return TRUE;

  return lex->var_list.push_back(var);
}


/**
  Helper action for a SET statement.
  Used to push a SP local variable into the assignment list.

  @param thd      the current thread
  @param var_type the SP local variable
  @param val      the value being assigned to the variable

  @return TRUE if error, FALSE otherwise.
*/

static bool
set_local_variable(THD *thd, sp_variable *spv, Item *val)
{
  Item *it;
  LEX *lex= thd->lex;
  sp_instr_set *sp_set;

  if (val)
    it= val;
  else if (spv->default_value)
    it= spv->default_value;
  else
  {
    it= new (thd->mem_root) Item_null();
    if (it == NULL)
      return TRUE;
  }

  sp_set= new sp_instr_set(lex->sphead->instructions(), lex->spcont,
                           spv->offset, it, spv->type, lex, TRUE);

  return (sp_set == NULL || lex->sphead->add_instr(sp_set));
}


/**
  Helper action for a SET statement.
  Used to SET a field of NEW row.

  @param thd      the current thread
  @param name     the field name
  @param val      the value being assigned to the row

  @return TRUE if error, FALSE otherwise.
*/

static bool
set_trigger_new_row(THD *thd, LEX_STRING *name, Item *val)
{
  LEX *lex= thd->lex;
  Item_trigger_field *trg_fld;
  sp_instr_set_trigger_field *sp_fld;

  /* QQ: Shouldn't this be field's default value ? */
  if (! val)
    val= new Item_null();

  DBUG_ASSERT(lex->trg_chistics.action_time == TRG_ACTION_BEFORE &&
              (lex->trg_chistics.event == TRG_EVENT_INSERT ||
               lex->trg_chistics.event == TRG_EVENT_UPDATE));

  trg_fld= new (thd->mem_root)
            Item_trigger_field(lex->current_context(),
                               Item_trigger_field::NEW_ROW,
                               name->str, UPDATE_ACL, FALSE);

  if (trg_fld == NULL)
    return TRUE;

  sp_fld= new sp_instr_set_trigger_field(lex->sphead->instructions(),
                                         lex->spcont, trg_fld, val, lex);

  if (sp_fld == NULL)
    return TRUE;

  /*
    Let us add this item to list of all Item_trigger_field
    objects in trigger.
  */
  lex->trg_table_fields.link_in_list(trg_fld, &trg_fld->next_trg_field);

  return lex->sphead->add_instr(sp_fld);
}


/**
  Create an object to represent a SP variable in the Item-hierarchy.

  @param  thd         The current thread.
  @param  name        The SP variable name.
  @param  spvar       The SP variable (optional).
  @param  start_in_q  Start position of the SP variable name in the query.
  @param  end_in_q    End position of the SP variable name in the query.

  @remark If spvar is not specified, the name is used to search for the
          variable in the parse-time context. If the variable does not
          exist, a error is set and NULL is returned to the caller.

  @return An Item_splocal object representing the SP variable, or NULL on error.
*/
static Item_splocal*
create_item_for_sp_var(THD *thd, LEX_STRING name, sp_variable *spvar,
                       const char *start_in_q, const char *end_in_q)
{
  Item_splocal *item;
  LEX *lex= thd->lex;
  uint pos_in_q, len_in_q;
  sp_pcontext *spc = lex->spcont;

  /* If necessary, look for the variable. */
  if (spc && !spvar)
    spvar= spc->find_variable(name, false);

  if (!spvar)
  {
    my_error(ER_SP_UNDECLARED_VAR, MYF(0), name.str);
    return NULL;
  }

  DBUG_ASSERT(spc && spvar);

  /* Position and length of the SP variable name in the query. */
  pos_in_q= start_in_q - lex->sphead->m_tmp_query;
  len_in_q= end_in_q - start_in_q;

  item= new (thd->mem_root)
    Item_splocal(name, spvar->offset, spvar->type, pos_in_q, len_in_q);

#ifndef DBUG_OFF
  if (item)
    item->m_sp= lex->sphead;
#endif

  return item;
}

/**
  Helper to resolve the SQL:2003 Syntax exception 1) in <in predicate>.
  See SQL:2003, Part 2, section 8.4 <in predicate>, Note 184, page 383.
  This function returns the proper item for the SQL expression
  <code>left [NOT] IN ( expr )</code>
  @param thd the current thread
  @param left the in predicand
  @param equal true for IN predicates, false for NOT IN predicates
  @param expr first and only expression of the in value list
  @return an expression representing the IN predicate.
*/
Item* handle_sql2003_note184_exception(THD *thd, Item* left, bool equal,
                                       Item *expr)
{
  /*
    Relevant references for this issue:
    - SQL:2003, Part 2, section 8.4 <in predicate>, page 383,
    - SQL:2003, Part 2, section 7.2 <row value expression>, page 296,
    - SQL:2003, Part 2, section 6.3 <value expression primary>, page 174,
    - SQL:2003, Part 2, section 7.15 <subquery>, page 370,
    - SQL:2003 Feature F561, "Full value expressions".

    The exception in SQL:2003 Note 184 means:
    Item_singlerow_subselect, which corresponds to a <scalar subquery>,
    should be re-interpreted as an Item_in_subselect, which corresponds
    to a <table subquery> when used inside an <in predicate>.

    Our reading of Note 184 is reccursive, so that all:
    - IN (( <subquery> ))
    - IN ((( <subquery> )))
    - IN '('^N <subquery> ')'^N
    - etc
    should be interpreted as a <table subquery>, no matter how deep in the
    expression the <subquery> is.
  */

  Item *result;

  DBUG_ENTER("handle_sql2003_note184_exception");

  if (expr->type() == Item::SUBSELECT_ITEM)
  {
    Item_subselect *expr2 = (Item_subselect*) expr;

    if (expr2->substype() == Item_subselect::SINGLEROW_SUBS)
    {
      Item_singlerow_subselect *expr3 = (Item_singlerow_subselect*) expr2;
      st_select_lex *subselect;

      /*
        Implement the mandated change, by altering the semantic tree:
          left IN Item_singlerow_subselect(subselect)
        is modified to
          left IN (subselect)
        which is represented as
          Item_in_subselect(left, subselect)
      */
      subselect= expr3->invalidate_and_restore_select_lex();
      result= new (thd->mem_root) Item_in_subselect(left, subselect);

      if (! equal)
        result = negate_expression(thd, result);

      DBUG_RETURN(result);
    }
  }

  if (equal)
    result= new (thd->mem_root) Item_func_eq(left, expr);
  else
    result= new (thd->mem_root) Item_func_ne(left, expr);

  DBUG_RETURN(result);
}

/**
   @brief Creates a new SELECT_LEX for a UNION branch.

   Sets up and initializes a SELECT_LEX structure for a query once the parser
   discovers a UNION token. The current SELECT_LEX is pushed on the stack and
   the new SELECT_LEX becomes the current one.

   @param lex The parser state.

   @param is_union_distinct True if the union preceding the new select statement
   uses UNION DISTINCT.

   @param is_top_level This should be @c TRUE if the newly created SELECT_LEX
   is a non-nested statement.

   @return <code>false</code> if successful, <code>true</code> if an error was
   reported. In the latter case parsing should stop.
 */
bool add_select_to_union_list(LEX *lex, bool is_union_distinct, 
                              bool is_top_level)
{
  /* 
     Only the last SELECT can have INTO. Since the grammar won't allow INTO in
     a nested SELECT, we make this check only when creating a top-level SELECT.
  */
  if (is_top_level && lex->result)
  {
    my_error(ER_WRONG_USAGE, MYF(0), "UNION", "INTO");
    return TRUE;
  }
  if (lex->current_select->linkage == GLOBAL_OPTIONS_TYPE)
  {
    my_parse_error(ER(ER_SYNTAX_ERROR));
    return TRUE;
  }
  /* This counter shouldn't be incremented for UNION parts */
  lex->nest_level--;
  if (mysql_new_select(lex, 0))
    return TRUE;
  mysql_init_select(lex);
  lex->current_select->linkage=UNION_TYPE;
  if (is_union_distinct) /* UNION DISTINCT - remember position */
    lex->current_select->master_unit()->union_distinct=
      lex->current_select;
  return FALSE;
}

/**
   @brief Initializes a SELECT_LEX for a query within parentheses (aka
   braces).

   @return false if successful, true if an error was reported. In the latter
   case parsing should stop.
 */
bool setup_select_in_parentheses(LEX *lex) 
{
  SELECT_LEX * sel= lex->current_select;
  if (sel->set_braces(1))
  {
    my_parse_error(ER(ER_SYNTAX_ERROR));
    return TRUE;
  }
  if (sel->linkage == UNION_TYPE &&
      !sel->master_unit()->first_select()->braces &&
      sel->master_unit()->first_select()->linkage ==
      UNION_TYPE)
  {
    my_parse_error(ER(ER_SYNTAX_ERROR));
    return TRUE;
  }
  if (sel->linkage == UNION_TYPE &&
      sel->olap != UNSPECIFIED_OLAP_TYPE &&
      sel->master_unit()->fake_select_lex)
  {
    my_error(ER_WRONG_USAGE, MYF(0), "CUBE/ROLLUP", "ORDER BY");
    return TRUE;
  }
  /* select in braces, can't contain global parameters */
  if (sel->master_unit()->fake_select_lex)
    sel->master_unit()->global_parameters=
      sel->master_unit()->fake_select_lex;
  return FALSE;
}

static bool add_create_index_prepare (LEX *lex, Table_ident *table)
{
  lex->sql_command= SQLCOM_CREATE_INDEX;
  if (!lex->current_select->add_table_to_list(lex->thd, table, NULL,
                                              TL_OPTION_UPDATING,
                                              TL_READ_NO_INSERT,
                                              MDL_SHARED_UPGRADABLE))
    return TRUE;
  lex->alter_info.reset();
  lex->alter_info.flags= Alter_info::ALTER_ADD_INDEX;
  lex->col_list.empty();
  lex->change= NullS;
  lex->option_list= NULL;
  return FALSE;
}

static bool add_create_index (LEX *lex, Key::Keytype type,
                              const LEX_STRING &name,
                              KEY_CREATE_INFO *info= NULL, bool generated= 0)
{
  Key *key;
  key= new Key(type, name, info ? info : &lex->key_create_info, generated, 
               lex->col_list, lex->option_list, lex->check_exists);
  if (key == NULL)
    return TRUE;

  lex->alter_info.key_list.push_back(key);
  lex->col_list.empty();
  return FALSE;
}


/**
  Create a separate LEX for each assignment if in SP.

  If we are in SP we want have own LEX for each assignment.
  This is mostly because it is hard for several sp_instr_set
  and sp_instr_set_trigger instructions share one LEX.
  (Well, it is theoretically possible but adds some extra
  overhead on preparation for execution stage and IMO less
  robust).

  QQ: May be we should simply prohibit group assignments in SP?

  @see sp_create_assignment_instr

  @param thd           Thread context
  @param no_lookahead  True if the parser has no lookahead
*/

static void sp_create_assignment_lex(THD *thd, bool no_lookahead)
{
  LEX *lex= thd->lex;

  if (lex->sphead)
  {
    Lex_input_stream *lip= &thd->m_parser_state->m_lip;
    LEX *old_lex= lex;
    lex->sphead->reset_lex(thd);
    lex= thd->lex;

    /* Set new LEX as if we at start of set rule. */
    lex->sql_command= SQLCOM_SET_OPTION;
    mysql_init_select(lex);
    lex->var_list.empty();
    lex->autocommit= 0;
    /* get_ptr() is only correct with no lookahead. */
    DBUG_ASSERT(no_lookahead);
    lex->sphead->m_tmp_query= lip->get_ptr();
    /* Inherit from outer lex. */
    lex->option_type= old_lex->option_type;
  }
}


/**
  Create a SP instruction for a SET assignment.

  @see sp_create_assignment_lex

  @param thd           Thread context
  @param no_lookahead  True if the parser has no lookahead

  @return false if success, true otherwise.
*/

static bool sp_create_assignment_instr(THD *thd, bool no_lookahead)
{
  LEX *lex= thd->lex;

  if (lex->sphead)
  {
    sp_head *sp= lex->sphead;

    if (!lex->var_list.is_empty())
    {
      /*
        We have assignment to user or system variable or
        option setting, so we should construct sp_instr_stmt
        for it.
      */
      LEX_STRING qbuff;
      sp_instr_stmt *i;
      Lex_input_stream *lip= &thd->m_parser_state->m_lip;

      if (!(i= new sp_instr_stmt(sp->instructions(), lex->spcont,
                                 lex)))
        return true;

      /*
        Extract the query statement from the tokenizer.  The
        end is either lip->ptr, if there was no lookahead,
        lip->tok_end otherwise.
      */
      if (no_lookahead)
        qbuff.length= lip->get_ptr() - sp->m_tmp_query;
      else
        qbuff.length= lip->get_tok_end() - sp->m_tmp_query;

      if (!(qbuff.str= (char*) alloc_root(thd->mem_root,
                                          qbuff.length + 5)))
        return true;

      strmake(strmake(qbuff.str, "SET ", 4), sp->m_tmp_query,
              qbuff.length);
      qbuff.length+= 4;
      i->m_query= qbuff;
      if (sp->add_instr(i))
        return true;
    }
    enum_var_type inner_option_type= lex->option_type;
    if (lex->sphead->restore_lex(thd))
      return true;
    /* Copy option_type to outer lex in case it has changed. */
    thd->lex->option_type= inner_option_type;
  }
  return false;
}




/* Line 189 of yacc.c  */
#line 954 "/home/buildbot/bzr/build/mkdist/sql/sql_yacc.cc"

/* Enabling traces.  */
#ifndef YYDEBUG
# define YYDEBUG 0
#endif

/* Enabling verbose error messages.  */
#ifdef YYERROR_VERBOSE
# undef YYERROR_VERBOSE
# define YYERROR_VERBOSE 1
#else
# define YYERROR_VERBOSE 0
#endif

/* Enabling the token table.  */
#ifndef YYTOKEN_TABLE
# define YYTOKEN_TABLE 0
#endif


/* Tokens.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
   /* Put the tokens into the symbol table, so that GDB and other debuggers
      know about them.  */
   enum yytokentype {
     ABORT_SYM = 258,
     ACCESSIBLE_SYM = 259,
     ACTION = 260,
     ADD = 261,
     ADMIN_SYM = 262,
     ADDDATE_SYM = 263,
     AFTER_SYM = 264,
     AGAINST = 265,
     AGGREGATE_SYM = 266,
     ALGORITHM_SYM = 267,
     ALL = 268,
     ALTER = 269,
     ALWAYS_SYM = 270,
     ANALYZE_SYM = 271,
     AND_AND_SYM = 272,
     AND_SYM = 273,
     ANY_SYM = 274,
     AS = 275,
     ASC = 276,
     ASCII_SYM = 277,
     ASENSITIVE_SYM = 278,
     AT_SYM = 279,
     AUTHORS_SYM = 280,
     AUTOEXTEND_SIZE_SYM = 281,
     AUTO_INC = 282,
     AUTO_SYM = 283,
     AVG_ROW_LENGTH = 284,
     AVG_SYM = 285,
     BACKUP_SYM = 286,
     BEFORE_SYM = 287,
     BEGIN_SYM = 288,
     BETWEEN_SYM = 289,
     BIGINT = 290,
     BINARY = 291,
     BINLOG_SYM = 292,
     BIN_NUM = 293,
     BIT_AND = 294,
     BIT_OR = 295,
     BIT_SYM = 296,
     BIT_XOR = 297,
     BLOB_SYM = 298,
     BLOCK_SYM = 299,
     BOOLEAN_SYM = 300,
     BOOL_SYM = 301,
     BOTH = 302,
     BTREE_SYM = 303,
     BY = 304,
     BYTE_SYM = 305,
     CACHE_SYM = 306,
     CALL_SYM = 307,
     CASCADE = 308,
     CASCADED = 309,
     CASE_SYM = 310,
     CAST_SYM = 311,
     CATALOG_NAME_SYM = 312,
     CHAIN_SYM = 313,
     CHANGE = 314,
     CHANGED = 315,
     CHARSET = 316,
     CHAR_SYM = 317,
     CHECKPOINT_SYM = 318,
     CHECKSUM_SYM = 319,
     CHECK_SYM = 320,
     CIPHER_SYM = 321,
     CLASS_ORIGIN_SYM = 322,
     CLIENT_SYM = 323,
     CLIENT_STATS_SYM = 324,
     CLOSE_SYM = 325,
     COALESCE = 326,
     CODE_SYM = 327,
     COLLATE_SYM = 328,
     COLLATION_SYM = 329,
     COLUMNS = 330,
     COLUMN_ADD_SYM = 331,
     COLUMN_CHECK_SYM = 332,
     COLUMN_CREATE_SYM = 333,
     COLUMN_DELETE_SYM = 334,
     COLUMN_GET_SYM = 335,
     COLUMN_SYM = 336,
     COLUMN_NAME_SYM = 337,
     COMMENT_SYM = 338,
     COMMITTED_SYM = 339,
     COMMIT_SYM = 340,
     COMPACT_SYM = 341,
     COMPLETION_SYM = 342,
     COMPRESSED_SYM = 343,
     CONCURRENT = 344,
     CONDITION_SYM = 345,
     CONNECTION_SYM = 346,
     CONSISTENT_SYM = 347,
     CONSTRAINT = 348,
     CONSTRAINT_CATALOG_SYM = 349,
     CONSTRAINT_NAME_SYM = 350,
     CONSTRAINT_SCHEMA_SYM = 351,
     CONTAINS_SYM = 352,
     CONTEXT_SYM = 353,
     CONTINUE_SYM = 354,
     CONTRIBUTORS_SYM = 355,
     CONVERT_SYM = 356,
     COUNT_SYM = 357,
     CPU_SYM = 358,
     CREATE = 359,
     CROSS = 360,
     CUBE_SYM = 361,
     CURDATE = 362,
     CURRENT_SYM = 363,
     CURRENT_USER = 364,
     CURRENT_ROLE = 365,
     CURRENT_POS_SYM = 366,
     CURSOR_SYM = 367,
     CURSOR_NAME_SYM = 368,
     CURTIME = 369,
     DATABASE = 370,
     DATABASES = 371,
     DATAFILE_SYM = 372,
     DATA_SYM = 373,
     DATETIME = 374,
     DATE_ADD_INTERVAL = 375,
     DATE_SUB_INTERVAL = 376,
     DATE_SYM = 377,
     DAY_HOUR_SYM = 378,
     DAY_MICROSECOND_SYM = 379,
     DAY_MINUTE_SYM = 380,
     DAY_SECOND_SYM = 381,
     DAY_SYM = 382,
     DEALLOCATE_SYM = 383,
     DECIMAL_NUM = 384,
     DECIMAL_SYM = 385,
     DECLARE_SYM = 386,
     DEFAULT = 387,
     DEFINER_SYM = 388,
     DELAYED_SYM = 389,
     DELAY_KEY_WRITE_SYM = 390,
     DELETE_SYM = 391,
     DESC = 392,
     DESCRIBE = 393,
     DES_KEY_FILE = 394,
     DETERMINISTIC_SYM = 395,
     DIAGNOSTICS_SYM = 396,
     DIRECTORY_SYM = 397,
     DISABLE_SYM = 398,
     DISCARD = 399,
     DISK_SYM = 400,
     DISTINCT = 401,
     DIV_SYM = 402,
     DOUBLE_SYM = 403,
     DO_SYM = 404,
     DROP = 405,
     DUAL_SYM = 406,
     DUMPFILE = 407,
     DUPLICATE_SYM = 408,
     DYNAMIC_SYM = 409,
     EACH_SYM = 410,
     ELSE = 411,
     ELSEIF_SYM = 412,
     ENABLE_SYM = 413,
     ENCLOSED = 414,
     END = 415,
     ENDS_SYM = 416,
     END_OF_INPUT = 417,
     ENGINES_SYM = 418,
     ENGINE_SYM = 419,
     ENUM = 420,
     EQ = 421,
     EQUAL_SYM = 422,
     ERROR_SYM = 423,
     ERRORS = 424,
     ESCAPED = 425,
     ESCAPE_SYM = 426,
     EVENTS_SYM = 427,
     EVENT_SYM = 428,
     EVERY_SYM = 429,
     EXCHANGE_SYM = 430,
     EXAMINED_SYM = 431,
     EXECUTE_SYM = 432,
     EXISTS = 433,
     EXIT_SYM = 434,
     EXPANSION_SYM = 435,
     EXPORT_SYM = 436,
     EXTENDED_SYM = 437,
     EXTENT_SIZE_SYM = 438,
     EXTRACT_SYM = 439,
     FALSE_SYM = 440,
     FAST_SYM = 441,
     FAULTS_SYM = 442,
     FETCH_SYM = 443,
     FILE_SYM = 444,
     FIRST_SYM = 445,
     FIXED_SYM = 446,
     FLOAT_NUM = 447,
     FLOAT_SYM = 448,
     FLUSH_SYM = 449,
     FORCE_SYM = 450,
     FOREIGN = 451,
     FOR_SYM = 452,
     FOUND_SYM = 453,
     FROM = 454,
     FULL = 455,
     FULLTEXT_SYM = 456,
     FUNCTION_SYM = 457,
     GE = 458,
     GENERAL = 459,
     GENERATED_SYM = 460,
     GEOMETRYCOLLECTION = 461,
     GEOMETRY_SYM = 462,
     GET_FORMAT = 463,
     GET_SYM = 464,
     GLOBAL_SYM = 465,
     GRANT = 466,
     GRANTS = 467,
     GROUP_SYM = 468,
     GROUP_CONCAT_SYM = 469,
     GT_SYM = 470,
     HANDLER_SYM = 471,
     HARD_SYM = 472,
     HASH_SYM = 473,
     HAVING = 474,
     HELP_SYM = 475,
     HEX_NUM = 476,
     HEX_STRING = 477,
     HIGH_PRIORITY = 478,
     HOST_SYM = 479,
     HOSTS_SYM = 480,
     HOUR_MICROSECOND_SYM = 481,
     HOUR_MINUTE_SYM = 482,
     HOUR_SECOND_SYM = 483,
     HOUR_SYM = 484,
     ID_SYM = 485,
     IDENT = 486,
     IDENTIFIED_SYM = 487,
     IDENT_QUOTED = 488,
     IF = 489,
     IGNORE_SYM = 490,
     IGNORE_SERVER_IDS_SYM = 491,
     IMPORT = 492,
     INDEXES = 493,
     INDEX_SYM = 494,
     INDEX_STATS_SYM = 495,
     INFILE = 496,
     INITIAL_SIZE_SYM = 497,
     INNER_SYM = 498,
     INOUT_SYM = 499,
     INSENSITIVE_SYM = 500,
     INSERT = 501,
     INSERT_METHOD = 502,
     INSTALL_SYM = 503,
     INTERVAL_SYM = 504,
     INTO = 505,
     INT_SYM = 506,
     INVOKER_SYM = 507,
     IN_SYM = 508,
     IO_SYM = 509,
     IPC_SYM = 510,
     IS = 511,
     ISOLATION = 512,
     ISSUER_SYM = 513,
     ITERATE_SYM = 514,
     JOIN_SYM = 515,
     KEYS = 516,
     KEY_BLOCK_SIZE = 517,
     KEY_SYM = 518,
     KILL_SYM = 519,
     LANGUAGE_SYM = 520,
     LAST_SYM = 521,
     LAST_VALUE = 522,
     LE = 523,
     LEADING = 524,
     LEAVES = 525,
     LEAVE_SYM = 526,
     LEFT = 527,
     LESS_SYM = 528,
     LEVEL_SYM = 529,
     LEX_HOSTNAME = 530,
     LIKE = 531,
     LIMIT = 532,
     LINEAR_SYM = 533,
     LINES = 534,
     LINESTRING = 535,
     LIST_SYM = 536,
     LOAD = 537,
     LOCAL_SYM = 538,
     LOCATOR_SYM = 539,
     LOCKS_SYM = 540,
     LOCK_SYM = 541,
     LOGFILE_SYM = 542,
     LOGS_SYM = 543,
     LONGBLOB = 544,
     LONGTEXT = 545,
     LONG_NUM = 546,
     LONG_SYM = 547,
     LOOP_SYM = 548,
     LOW_PRIORITY = 549,
     LT = 550,
     MASTER_CONNECT_RETRY_SYM = 551,
     MASTER_GTID_POS_SYM = 552,
     MASTER_HOST_SYM = 553,
     MASTER_LOG_FILE_SYM = 554,
     MASTER_LOG_POS_SYM = 555,
     MASTER_PASSWORD_SYM = 556,
     MASTER_PORT_SYM = 557,
     MASTER_SERVER_ID_SYM = 558,
     MASTER_SSL_CAPATH_SYM = 559,
     MASTER_SSL_CA_SYM = 560,
     MASTER_SSL_CERT_SYM = 561,
     MASTER_SSL_CIPHER_SYM = 562,
     MASTER_SSL_CRL_SYM = 563,
     MASTER_SSL_CRLPATH_SYM = 564,
     MASTER_SSL_KEY_SYM = 565,
     MASTER_SSL_SYM = 566,
     MASTER_SSL_VERIFY_SERVER_CERT_SYM = 567,
     MASTER_SYM = 568,
     MASTER_USER_SYM = 569,
     MASTER_USE_GTID_SYM = 570,
     MASTER_HEARTBEAT_PERIOD_SYM = 571,
     MATCH = 572,
     MAX_CONNECTIONS_PER_HOUR = 573,
     MAX_QUERIES_PER_HOUR = 574,
     MAX_ROWS = 575,
     MAX_SIZE_SYM = 576,
     MAX_SYM = 577,
     MAX_UPDATES_PER_HOUR = 578,
     MAX_USER_CONNECTIONS_SYM = 579,
     MAX_VALUE_SYM = 580,
     MEDIUMBLOB = 581,
     MEDIUMINT = 582,
     MEDIUMTEXT = 583,
     MEDIUM_SYM = 584,
     MEMORY_SYM = 585,
     MERGE_SYM = 586,
     MESSAGE_TEXT_SYM = 587,
     MICROSECOND_SYM = 588,
     MIGRATE_SYM = 589,
     MINUTE_MICROSECOND_SYM = 590,
     MINUTE_SECOND_SYM = 591,
     MINUTE_SYM = 592,
     MIN_ROWS = 593,
     MIN_SYM = 594,
     MODE_SYM = 595,
     MODIFIES_SYM = 596,
     MODIFY_SYM = 597,
     MOD_SYM = 598,
     MONTH_SYM = 599,
     MULTILINESTRING = 600,
     MULTIPOINT = 601,
     MULTIPOLYGON = 602,
     MUTEX_SYM = 603,
     MYSQL_ERRNO_SYM = 604,
     NAMES_SYM = 605,
     NAME_SYM = 606,
     NATIONAL_SYM = 607,
     NATURAL = 608,
     NCHAR_STRING = 609,
     NCHAR_SYM = 610,
     NDBCLUSTER_SYM = 611,
     NE = 612,
     NEG = 613,
     NEW_SYM = 614,
     NEXT_SYM = 615,
     NODEGROUP_SYM = 616,
     NONE_SYM = 617,
     NOT2_SYM = 618,
     NOT_SYM = 619,
     NOW_SYM = 620,
     NO_SYM = 621,
     NO_WAIT_SYM = 622,
     NO_WRITE_TO_BINLOG = 623,
     NULL_SYM = 624,
     NUM = 625,
     NUMBER_SYM = 626,
     NUMERIC_SYM = 627,
     NVARCHAR_SYM = 628,
     OFFSET_SYM = 629,
     OLD_PASSWORD = 630,
     ON = 631,
     ONE_SYM = 632,
     ONLY_SYM = 633,
     ONLINE_SYM = 634,
     OPEN_SYM = 635,
     OPTIMIZE = 636,
     OPTIONS_SYM = 637,
     OPTION = 638,
     OPTIONALLY = 639,
     OR2_SYM = 640,
     ORDER_SYM = 641,
     OR_OR_SYM = 642,
     OR_SYM = 643,
     OUTER = 644,
     OUTFILE = 645,
     OUT_SYM = 646,
     OWNER_SYM = 647,
     PACK_KEYS_SYM = 648,
     PAGE_SYM = 649,
     PAGE_CHECKSUM_SYM = 650,
     PARAM_MARKER = 651,
     PARSER_SYM = 652,
     PARSE_VCOL_EXPR_SYM = 653,
     PARTIAL = 654,
     PARTITION_SYM = 655,
     PARTITIONS_SYM = 656,
     PARTITIONING_SYM = 657,
     PASSWORD = 658,
     PERSISTENT_SYM = 659,
     PHASE_SYM = 660,
     PLUGINS_SYM = 661,
     PLUGIN_SYM = 662,
     POINT_SYM = 663,
     POLYGON = 664,
     PORT_SYM = 665,
     POSITION_SYM = 666,
     PRECISION = 667,
     PREPARE_SYM = 668,
     PRESERVE_SYM = 669,
     PREV_SYM = 670,
     PRIMARY_SYM = 671,
     PRIVILEGES = 672,
     PROCEDURE_SYM = 673,
     PROCESS = 674,
     PROCESSLIST_SYM = 675,
     PROFILE_SYM = 676,
     PROFILES_SYM = 677,
     PROXY_SYM = 678,
     PURGE = 679,
     QUARTER_SYM = 680,
     QUERY_SYM = 681,
     QUICK = 682,
     RANGE_SYM = 683,
     READS_SYM = 684,
     READ_ONLY_SYM = 685,
     READ_SYM = 686,
     READ_WRITE_SYM = 687,
     REAL = 688,
     REBUILD_SYM = 689,
     RECOVER_SYM = 690,
     REDOFILE_SYM = 691,
     REDO_BUFFER_SIZE_SYM = 692,
     REDUNDANT_SYM = 693,
     REFERENCES = 694,
     REGEXP = 695,
     RELAY = 696,
     RELAYLOG_SYM = 697,
     RELAY_LOG_FILE_SYM = 698,
     RELAY_LOG_POS_SYM = 699,
     RELAY_THREAD = 700,
     RELEASE_SYM = 701,
     RELOAD = 702,
     REMOVE_SYM = 703,
     RENAME = 704,
     REORGANIZE_SYM = 705,
     REPAIR = 706,
     REPEATABLE_SYM = 707,
     REPEAT_SYM = 708,
     REPLACE = 709,
     REPLICATION = 710,
     REQUIRE_SYM = 711,
     RESET_SYM = 712,
     RESIGNAL_SYM = 713,
     RESOURCES = 714,
     RESTORE_SYM = 715,
     RESTRICT = 716,
     RESUME_SYM = 717,
     RETURNED_SQLSTATE_SYM = 718,
     RETURNING_SYM = 719,
     RETURNS_SYM = 720,
     RETURN_SYM = 721,
     REVERSE_SYM = 722,
     REVOKE = 723,
     RIGHT = 724,
     ROLE_SYM = 725,
     ROLLBACK_SYM = 726,
     ROLLUP_SYM = 727,
     ROUTINE_SYM = 728,
     ROWS_SYM = 729,
     ROW_FORMAT_SYM = 730,
     ROW_SYM = 731,
     ROW_COUNT_SYM = 732,
     RTREE_SYM = 733,
     SAVEPOINT_SYM = 734,
     SCHEDULE_SYM = 735,
     SCHEMA_NAME_SYM = 736,
     SECOND_MICROSECOND_SYM = 737,
     SECOND_SYM = 738,
     SECURITY_SYM = 739,
     SELECT_SYM = 740,
     SENSITIVE_SYM = 741,
     SEPARATOR_SYM = 742,
     SERIALIZABLE_SYM = 743,
     SERIAL_SYM = 744,
     SESSION_SYM = 745,
     SERVER_SYM = 746,
     SERVER_OPTIONS = 747,
     SET = 748,
     SET_VAR = 749,
     SHARE_SYM = 750,
     SHIFT_LEFT = 751,
     SHIFT_RIGHT = 752,
     SHOW = 753,
     SHUTDOWN = 754,
     SIGNAL_SYM = 755,
     SIGNED_SYM = 756,
     SIMPLE_SYM = 757,
     SLAVE = 758,
     SLAVES = 759,
     SLAVE_POS_SYM = 760,
     SLOW = 761,
     SMALLINT = 762,
     SNAPSHOT_SYM = 763,
     SOCKET_SYM = 764,
     SOFT_SYM = 765,
     SONAME_SYM = 766,
     SOUNDS_SYM = 767,
     SOURCE_SYM = 768,
     SPATIAL_SYM = 769,
     SPECIFIC_SYM = 770,
     SQLEXCEPTION_SYM = 771,
     SQLSTATE_SYM = 772,
     SQLWARNING_SYM = 773,
     SQL_BIG_RESULT = 774,
     SQL_BUFFER_RESULT = 775,
     SQL_CACHE_SYM = 776,
     SQL_CALC_FOUND_ROWS = 777,
     SQL_NO_CACHE_SYM = 778,
     SQL_SMALL_RESULT = 779,
     SQL_SYM = 780,
     SQL_THREAD = 781,
     SSL_SYM = 782,
     STARTING = 783,
     STARTS_SYM = 784,
     START_SYM = 785,
     STATS_AUTO_RECALC_SYM = 786,
     STATS_PERSISTENT_SYM = 787,
     STATS_SAMPLE_PAGES_SYM = 788,
     STATUS_SYM = 789,
     STDDEV_SAMP_SYM = 790,
     STD_SYM = 791,
     STOP_SYM = 792,
     STORAGE_SYM = 793,
     STRAIGHT_JOIN = 794,
     STRING_SYM = 795,
     SUBCLASS_ORIGIN_SYM = 796,
     SUBDATE_SYM = 797,
     SUBJECT_SYM = 798,
     SUBPARTITIONS_SYM = 799,
     SUBPARTITION_SYM = 800,
     SUBSTRING = 801,
     SUM_SYM = 802,
     SUPER_SYM = 803,
     SUSPEND_SYM = 804,
     SWAPS_SYM = 805,
     SWITCHES_SYM = 806,
     SYSDATE = 807,
     TABLES = 808,
     TABLESPACE = 809,
     TABLE_REF_PRIORITY = 810,
     TABLE_STATS_SYM = 811,
     TABLE_SYM = 812,
     TABLE_CHECKSUM_SYM = 813,
     TABLE_NAME_SYM = 814,
     TEMPORARY = 815,
     TEMPTABLE_SYM = 816,
     TERMINATED = 817,
     TEXT_STRING = 818,
     TEXT_SYM = 819,
     THAN_SYM = 820,
     THEN_SYM = 821,
     TIMESTAMP = 822,
     TIMESTAMP_ADD = 823,
     TIMESTAMP_DIFF = 824,
     TIME_SYM = 825,
     TINYBLOB = 826,
     TINYINT = 827,
     TINYTEXT = 828,
     TO_SYM = 829,
     TRAILING = 830,
     TRANSACTION_SYM = 831,
     TRANSACTIONAL_SYM = 832,
     TRIGGERS_SYM = 833,
     TRIGGER_SYM = 834,
     TRIM = 835,
     TRUE_SYM = 836,
     TRUNCATE_SYM = 837,
     TYPES_SYM = 838,
     TYPE_SYM = 839,
     UDF_RETURNS_SYM = 840,
     ULONGLONG_NUM = 841,
     UNCOMMITTED_SYM = 842,
     UNDEFINED_SYM = 843,
     UNDERSCORE_CHARSET = 844,
     UNDOFILE_SYM = 845,
     UNDO_BUFFER_SIZE_SYM = 846,
     UNDO_SYM = 847,
     UNICODE_SYM = 848,
     UNINSTALL_SYM = 849,
     UNION_SYM = 850,
     UNIQUE_SYM = 851,
     UNKNOWN_SYM = 852,
     UNLOCK_SYM = 853,
     UNSIGNED = 854,
     UNTIL_SYM = 855,
     UPDATE_SYM = 856,
     UPGRADE_SYM = 857,
     USAGE = 858,
     USER = 859,
     USER_STATS_SYM = 860,
     USE_FRM = 861,
     USE_SYM = 862,
     USING = 863,
     UTC_DATE_SYM = 864,
     UTC_TIMESTAMP_SYM = 865,
     UTC_TIME_SYM = 866,
     VALUES = 867,
     VALUE_SYM = 868,
     VARBINARY = 869,
     VARCHAR = 870,
     VARIABLES = 871,
     VARIANCE_SYM = 872,
     VARYING = 873,
     VAR_SAMP_SYM = 874,
     VIA_SYM = 875,
     VIEW_SYM = 876,
     VIRTUAL_SYM = 877,
     WAIT_SYM = 878,
     WARNINGS = 879,
     WEEK_SYM = 880,
     WEIGHT_STRING_SYM = 881,
     WHEN_SYM = 882,
     WHERE = 883,
     WHILE_SYM = 884,
     WITH = 885,
     WITH_CUBE_SYM = 886,
     WITH_ROLLUP_SYM = 887,
     WORK_SYM = 888,
     WRAPPER_SYM = 889,
     WRITE_SYM = 890,
     X509_SYM = 891,
     XA_SYM = 892,
     XML_SYM = 893,
     XOR = 894,
     YEAR_MONTH_SYM = 895,
     YEAR_SYM = 896,
     ZEROFILL = 897,
     IMPOSSIBLE_ACTION = 898
   };
#endif
/* Tokens.  */
#define ABORT_SYM 258
#define ACCESSIBLE_SYM 259
#define ACTION 260
#define ADD 261
#define ADMIN_SYM 262
#define ADDDATE_SYM 263
#define AFTER_SYM 264
#define AGAINST 265
#define AGGREGATE_SYM 266
#define ALGORITHM_SYM 267
#define ALL 268
#define ALTER 269
#define ALWAYS_SYM 270
#define ANALYZE_SYM 271
#define AND_AND_SYM 272
#define AND_SYM 273
#define ANY_SYM 274
#define AS 275
#define ASC 276
#define ASCII_SYM 277
#define ASENSITIVE_SYM 278
#define AT_SYM 279
#define AUTHORS_SYM 280
#define AUTOEXTEND_SIZE_SYM 281
#define AUTO_INC 282
#define AUTO_SYM 283
#define AVG_ROW_LENGTH 284
#define AVG_SYM 285
#define BACKUP_SYM 286
#define BEFORE_SYM 287
#define BEGIN_SYM 288
#define BETWEEN_SYM 289
#define BIGINT 290
#define BINARY 291
#define BINLOG_SYM 292
#define BIN_NUM 293
#define BIT_AND 294
#define BIT_OR 295
#define BIT_SYM 296
#define BIT_XOR 297
#define BLOB_SYM 298
#define BLOCK_SYM 299
#define BOOLEAN_SYM 300
#define BOOL_SYM 301
#define BOTH 302
#define BTREE_SYM 303
#define BY 304
#define BYTE_SYM 305
#define CACHE_SYM 306
#define CALL_SYM 307
#define CASCADE 308
#define CASCADED 309
#define CASE_SYM 310
#define CAST_SYM 311
#define CATALOG_NAME_SYM 312
#define CHAIN_SYM 313
#define CHANGE 314
#define CHANGED 315
#define CHARSET 316
#define CHAR_SYM 317
#define CHECKPOINT_SYM 318
#define CHECKSUM_SYM 319
#define CHECK_SYM 320
#define CIPHER_SYM 321
#define CLASS_ORIGIN_SYM 322
#define CLIENT_SYM 323
#define CLIENT_STATS_SYM 324
#define CLOSE_SYM 325
#define COALESCE 326
#define CODE_SYM 327
#define COLLATE_SYM 328
#define COLLATION_SYM 329
#define COLUMNS 330
#define COLUMN_ADD_SYM 331
#define COLUMN_CHECK_SYM 332
#define COLUMN_CREATE_SYM 333
#define COLUMN_DELETE_SYM 334
#define COLUMN_GET_SYM 335
#define COLUMN_SYM 336
#define COLUMN_NAME_SYM 337
#define COMMENT_SYM 338
#define COMMITTED_SYM 339
#define COMMIT_SYM 340
#define COMPACT_SYM 341
#define COMPLETION_SYM 342
#define COMPRESSED_SYM 343
#define CONCURRENT 344
#define CONDITION_SYM 345
#define CONNECTION_SYM 346
#define CONSISTENT_SYM 347
#define CONSTRAINT 348
#define CONSTRAINT_CATALOG_SYM 349
#define CONSTRAINT_NAME_SYM 350
#define CONSTRAINT_SCHEMA_SYM 351
#define CONTAINS_SYM 352
#define CONTEXT_SYM 353
#define CONTINUE_SYM 354
#define CONTRIBUTORS_SYM 355
#define CONVERT_SYM 356
#define COUNT_SYM 357
#define CPU_SYM 358
#define CREATE 359
#define CROSS 360
#define CUBE_SYM 361
#define CURDATE 362
#define CURRENT_SYM 363
#define CURRENT_USER 364
#define CURRENT_ROLE 365
#define CURRENT_POS_SYM 366
#define CURSOR_SYM 367
#define CURSOR_NAME_SYM 368
#define CURTIME 369
#define DATABASE 370
#define DATABASES 371
#define DATAFILE_SYM 372
#define DATA_SYM 373
#define DATETIME 374
#define DATE_ADD_INTERVAL 375
#define DATE_SUB_INTERVAL 376
#define DATE_SYM 377
#define DAY_HOUR_SYM 378
#define DAY_MICROSECOND_SYM 379
#define DAY_MINUTE_SYM 380
#define DAY_SECOND_SYM 381
#define DAY_SYM 382
#define DEALLOCATE_SYM 383
#define DECIMAL_NUM 384
#define DECIMAL_SYM 385
#define DECLARE_SYM 386
#define DEFAULT 387
#define DEFINER_SYM 388
#define DELAYED_SYM 389
#define DELAY_KEY_WRITE_SYM 390
#define DELETE_SYM 391
#define DESC 392
#define DESCRIBE 393
#define DES_KEY_FILE 394
#define DETERMINISTIC_SYM 395
#define DIAGNOSTICS_SYM 396
#define DIRECTORY_SYM 397
#define DISABLE_SYM 398
#define DISCARD 399
#define DISK_SYM 400
#define DISTINCT 401
#define DIV_SYM 402
#define DOUBLE_SYM 403
#define DO_SYM 404
#define DROP 405
#define DUAL_SYM 406
#define DUMPFILE 407
#define DUPLICATE_SYM 408
#define DYNAMIC_SYM 409
#define EACH_SYM 410
#define ELSE 411
#define ELSEIF_SYM 412
#define ENABLE_SYM 413
#define ENCLOSED 414
#define END 415
#define ENDS_SYM 416
#define END_OF_INPUT 417
#define ENGINES_SYM 418
#define ENGINE_SYM 419
#define ENUM 420
#define EQ 421
#define EQUAL_SYM 422
#define ERROR_SYM 423
#define ERRORS 424
#define ESCAPED 425
#define ESCAPE_SYM 426
#define EVENTS_SYM 427
#define EVENT_SYM 428
#define EVERY_SYM 429
#define EXCHANGE_SYM 430
#define EXAMINED_SYM 431
#define EXECUTE_SYM 432
#define EXISTS 433
#define EXIT_SYM 434
#define EXPANSION_SYM 435
#define EXPORT_SYM 436
#define EXTENDED_SYM 437
#define EXTENT_SIZE_SYM 438
#define EXTRACT_SYM 439
#define FALSE_SYM 440
#define FAST_SYM 441
#define FAULTS_SYM 442
#define FETCH_SYM 443
#define FILE_SYM 444
#define FIRST_SYM 445
#define FIXED_SYM 446
#define FLOAT_NUM 447
#define FLOAT_SYM 448
#define FLUSH_SYM 449
#define FORCE_SYM 450
#define FOREIGN 451
#define FOR_SYM 452
#define FOUND_SYM 453
#define FROM 454
#define FULL 455
#define FULLTEXT_SYM 456
#define FUNCTION_SYM 457
#define GE 458
#define GENERAL 459
#define GENERATED_SYM 460
#define GEOMETRYCOLLECTION 461
#define GEOMETRY_SYM 462
#define GET_FORMAT 463
#define GET_SYM 464
#define GLOBAL_SYM 465
#define GRANT 466
#define GRANTS 467
#define GROUP_SYM 468
#define GROUP_CONCAT_SYM 469
#define GT_SYM 470
#define HANDLER_SYM 471
#define HARD_SYM 472
#define HASH_SYM 473
#define HAVING 474
#define HELP_SYM 475
#define HEX_NUM 476
#define HEX_STRING 477
#define HIGH_PRIORITY 478
#define HOST_SYM 479
#define HOSTS_SYM 480
#define HOUR_MICROSECOND_SYM 481
#define HOUR_MINUTE_SYM 482
#define HOUR_SECOND_SYM 483
#define HOUR_SYM 484
#define ID_SYM 485
#define IDENT 486
#define IDENTIFIED_SYM 487
#define IDENT_QUOTED 488
#define IF 489
#define IGNORE_SYM 490
#define IGNORE_SERVER_IDS_SYM 491
#define IMPORT 492
#define INDEXES 493
#define INDEX_SYM 494
#define INDEX_STATS_SYM 495
#define INFILE 496
#define INITIAL_SIZE_SYM 497
#define INNER_SYM 498
#define INOUT_SYM 499
#define INSENSITIVE_SYM 500
#define INSERT 501
#define INSERT_METHOD 502
#define INSTALL_SYM 503
#define INTERVAL_SYM 504
#define INTO 505
#define INT_SYM 506
#define INVOKER_SYM 507
#define IN_SYM 508
#define IO_SYM 509
#define IPC_SYM 510
#define IS 511
#define ISOLATION 512
#define ISSUER_SYM 513
#define ITERATE_SYM 514
#define JOIN_SYM 515
#define KEYS 516
#define KEY_BLOCK_SIZE 517
#define KEY_SYM 518
#define KILL_SYM 519
#define LANGUAGE_SYM 520
#define LAST_SYM 521
#define LAST_VALUE 522
#define LE 523
#define LEADING 524
#define LEAVES 525
#define LEAVE_SYM 526
#define LEFT 527
#define LESS_SYM 528
#define LEVEL_SYM 529
#define LEX_HOSTNAME 530
#define LIKE 531
#define LIMIT 532
#define LINEAR_SYM 533
#define LINES 534
#define LINESTRING 535
#define LIST_SYM 536
#define LOAD 537
#define LOCAL_SYM 538
#define LOCATOR_SYM 539
#define LOCKS_SYM 540
#define LOCK_SYM 541
#define LOGFILE_SYM 542
#define LOGS_SYM 543
#define LONGBLOB 544
#define LONGTEXT 545
#define LONG_NUM 546
#define LONG_SYM 547
#define LOOP_SYM 548
#define LOW_PRIORITY 549
#define LT 550
#define MASTER_CONNECT_RETRY_SYM 551
#define MASTER_GTID_POS_SYM 552
#define MASTER_HOST_SYM 553
#define MASTER_LOG_FILE_SYM 554
#define MASTER_LOG_POS_SYM 555
#define MASTER_PASSWORD_SYM 556
#define MASTER_PORT_SYM 557
#define MASTER_SERVER_ID_SYM 558
#define MASTER_SSL_CAPATH_SYM 559
#define MASTER_SSL_CA_SYM 560
#define MASTER_SSL_CERT_SYM 561
#define MASTER_SSL_CIPHER_SYM 562
#define MASTER_SSL_CRL_SYM 563
#define MASTER_SSL_CRLPATH_SYM 564
#define MASTER_SSL_KEY_SYM 565
#define MASTER_SSL_SYM 566
#define MASTER_SSL_VERIFY_SERVER_CERT_SYM 567
#define MASTER_SYM 568
#define MASTER_USER_SYM 569
#define MASTER_USE_GTID_SYM 570
#define MASTER_HEARTBEAT_PERIOD_SYM 571
#define MATCH 572
#define MAX_CONNECTIONS_PER_HOUR 573
#define MAX_QUERIES_PER_HOUR 574
#define MAX_ROWS 575
#define MAX_SIZE_SYM 576
#define MAX_SYM 577
#define MAX_UPDATES_PER_HOUR 578
#define MAX_USER_CONNECTIONS_SYM 579
#define MAX_VALUE_SYM 580
#define MEDIUMBLOB 581
#define MEDIUMINT 582
#define MEDIUMTEXT 583
#define MEDIUM_SYM 584
#define MEMORY_SYM 585
#define MERGE_SYM 586
#define MESSAGE_TEXT_SYM 587
#define MICROSECOND_SYM 588
#define MIGRATE_SYM 589
#define MINUTE_MICROSECOND_SYM 590
#define MINUTE_SECOND_SYM 591
#define MINUTE_SYM 592
#define MIN_ROWS 593
#define MIN_SYM 594
#define MODE_SYM 595
#define MODIFIES_SYM 596
#define MODIFY_SYM 597
#define MOD_SYM 598
#define MONTH_SYM 599
#define MULTILINESTRING 600
#define MULTIPOINT 601
#define MULTIPOLYGON 602
#define MUTEX_SYM 603
#define MYSQL_ERRNO_SYM 604
#define NAMES_SYM 605
#define NAME_SYM 606
#define NATIONAL_SYM 607
#define NATURAL 608
#define NCHAR_STRING 609
#define NCHAR_SYM 610
#define NDBCLUSTER_SYM 611
#define NE 612
#define NEG 613
#define NEW_SYM 614
#define NEXT_SYM 615
#define NODEGROUP_SYM 616
#define NONE_SYM 617
#define NOT2_SYM 618
#define NOT_SYM 619
#define NOW_SYM 620
#define NO_SYM 621
#define NO_WAIT_SYM 622
#define NO_WRITE_TO_BINLOG 623
#define NULL_SYM 624
#define NUM 625
#define NUMBER_SYM 626
#define NUMERIC_SYM 627
#define NVARCHAR_SYM 628
#define OFFSET_SYM 629
#define OLD_PASSWORD 630
#define ON 631
#define ONE_SYM 632
#define ONLY_SYM 633
#define ONLINE_SYM 634
#define OPEN_SYM 635
#define OPTIMIZE 636
#define OPTIONS_SYM 637
#define OPTION 638
#define OPTIONALLY 639
#define OR2_SYM 640
#define ORDER_SYM 641
#define OR_OR_SYM 642
#define OR_SYM 643
#define OUTER 644
#define OUTFILE 645
#define OUT_SYM 646
#define OWNER_SYM 647
#define PACK_KEYS_SYM 648
#define PAGE_SYM 649
#define PAGE_CHECKSUM_SYM 650
#define PARAM_MARKER 651
#define PARSER_SYM 652
#define PARSE_VCOL_EXPR_SYM 653
#define PARTIAL 654
#define PARTITION_SYM 655
#define PARTITIONS_SYM 656
#define PARTITIONING_SYM 657
#define PASSWORD 658
#define PERSISTENT_SYM 659
#define PHASE_SYM 660
#define PLUGINS_SYM 661
#define PLUGIN_SYM 662
#define POINT_SYM 663
#define POLYGON 664
#define PORT_SYM 665
#define POSITION_SYM 666
#define PRECISION 667
#define PREPARE_SYM 668
#define PRESERVE_SYM 669
#define PREV_SYM 670
#define PRIMARY_SYM 671
#define PRIVILEGES 672
#define PROCEDURE_SYM 673
#define PROCESS 674
#define PROCESSLIST_SYM 675
#define PROFILE_SYM 676
#define PROFILES_SYM 677
#define PROXY_SYM 678
#define PURGE 679
#define QUARTER_SYM 680
#define QUERY_SYM 681
#define QUICK 682
#define RANGE_SYM 683
#define READS_SYM 684
#define READ_ONLY_SYM 685
#define READ_SYM 686
#define READ_WRITE_SYM 687
#define REAL 688
#define REBUILD_SYM 689
#define RECOVER_SYM 690
#define REDOFILE_SYM 691
#define REDO_BUFFER_SIZE_SYM 692
#define REDUNDANT_SYM 693
#define REFERENCES 694
#define REGEXP 695
#define RELAY 696
#define RELAYLOG_SYM 697
#define RELAY_LOG_FILE_SYM 698
#define RELAY_LOG_POS_SYM 699
#define RELAY_THREAD 700
#define RELEASE_SYM 701
#define RELOAD 702
#define REMOVE_SYM 703
#define RENAME 704
#define REORGANIZE_SYM 705
#define REPAIR 706
#define REPEATABLE_SYM 707
#define REPEAT_SYM 708
#define REPLACE 709
#define REPLICATION 710
#define REQUIRE_SYM 711
#define RESET_SYM 712
#define RESIGNAL_SYM 713
#define RESOURCES 714
#define RESTORE_SYM 715
#define RESTRICT 716
#define RESUME_SYM 717
#define RETURNED_SQLSTATE_SYM 718
#define RETURNING_SYM 719
#define RETURNS_SYM 720
#define RETURN_SYM 721
#define REVERSE_SYM 722
#define REVOKE 723
#define RIGHT 724
#define ROLE_SYM 725
#define ROLLBACK_SYM 726
#define ROLLUP_SYM 727
#define ROUTINE_SYM 728
#define ROWS_SYM 729
#define ROW_FORMAT_SYM 730
#define ROW_SYM 731
#define ROW_COUNT_SYM 732
#define RTREE_SYM 733
#define SAVEPOINT_SYM 734
#define SCHEDULE_SYM 735
#define SCHEMA_NAME_SYM 736
#define SECOND_MICROSECOND_SYM 737
#define SECOND_SYM 738
#define SECURITY_SYM 739
#define SELECT_SYM 740
#define SENSITIVE_SYM 741
#define SEPARATOR_SYM 742
#define SERIALIZABLE_SYM 743
#define SERIAL_SYM 744
#define SESSION_SYM 745
#define SERVER_SYM 746
#define SERVER_OPTIONS 747
#define SET 748
#define SET_VAR 749
#define SHARE_SYM 750
#define SHIFT_LEFT 751
#define SHIFT_RIGHT 752
#define SHOW 753
#define SHUTDOWN 754
#define SIGNAL_SYM 755
#define SIGNED_SYM 756
#define SIMPLE_SYM 757
#define SLAVE 758
#define SLAVES 759
#define SLAVE_POS_SYM 760
#define SLOW 761
#define SMALLINT 762
#define SNAPSHOT_SYM 763
#define SOCKET_SYM 764
#define SOFT_SYM 765
#define SONAME_SYM 766
#define SOUNDS_SYM 767
#define SOURCE_SYM 768
#define SPATIAL_SYM 769
#define SPECIFIC_SYM 770
#define SQLEXCEPTION_SYM 771
#define SQLSTATE_SYM 772
#define SQLWARNING_SYM 773
#define SQL_BIG_RESULT 774
#define SQL_BUFFER_RESULT 775
#define SQL_CACHE_SYM 776
#define SQL_CALC_FOUND_ROWS 777
#define SQL_NO_CACHE_SYM 778
#define SQL_SMALL_RESULT 779
#define SQL_SYM 780
#define SQL_THREAD 781
#define SSL_SYM 782
#define STARTING 783
#define STARTS_SYM 784
#define START_SYM 785
#define STATS_AUTO_RECALC_SYM 786
#define STATS_PERSISTENT_SYM 787
#define STATS_SAMPLE_PAGES_SYM 788
#define STATUS_SYM 789
#define STDDEV_SAMP_SYM 790
#define STD_SYM 791
#define STOP_SYM 792
#define STORAGE_SYM 793
#define STRAIGHT_JOIN 794
#define STRING_SYM 795
#define SUBCLASS_ORIGIN_SYM 796
#define SUBDATE_SYM 797
#define SUBJECT_SYM 798
#define SUBPARTITIONS_SYM 799
#define SUBPARTITION_SYM 800
#define SUBSTRING 801
#define SUM_SYM 802
#define SUPER_SYM 803
#define SUSPEND_SYM 804
#define SWAPS_SYM 805
#define SWITCHES_SYM 806
#define SYSDATE 807
#define TABLES 808
#define TABLESPACE 809
#define TABLE_REF_PRIORITY 810
#define TABLE_STATS_SYM 811
#define TABLE_SYM 812
#define TABLE_CHECKSUM_SYM 813
#define TABLE_NAME_SYM 814
#define TEMPORARY 815
#define TEMPTABLE_SYM 816
#define TERMINATED 817
#define TEXT_STRING 818
#define TEXT_SYM 819
#define THAN_SYM 820
#define THEN_SYM 821
#define TIMESTAMP 822
#define TIMESTAMP_ADD 823
#define TIMESTAMP_DIFF 824
#define TIME_SYM 825
#define TINYBLOB 826
#define TINYINT 827
#define TINYTEXT 828
#define TO_SYM 829
#define TRAILING 830
#define TRANSACTION_SYM 831
#define TRANSACTIONAL_SYM 832
#define TRIGGERS_SYM 833
#define TRIGGER_SYM 834
#define TRIM 835
#define TRUE_SYM 836
#define TRUNCATE_SYM 837
#define TYPES_SYM 838
#define TYPE_SYM 839
#define UDF_RETURNS_SYM 840
#define ULONGLONG_NUM 841
#define UNCOMMITTED_SYM 842
#define UNDEFINED_SYM 843
#define UNDERSCORE_CHARSET 844
#define UNDOFILE_SYM 845
#define UNDO_BUFFER_SIZE_SYM 846
#define UNDO_SYM 847
#define UNICODE_SYM 848
#define UNINSTALL_SYM 849
#define UNION_SYM 850
#define UNIQUE_SYM 851
#define UNKNOWN_SYM 852
#define UNLOCK_SYM 853
#define UNSIGNED 854
#define UNTIL_SYM 855
#define UPDATE_SYM 856
#define UPGRADE_SYM 857
#define USAGE 858
#define USER 859
#define USER_STATS_SYM 860
#define USE_FRM 861
#define USE_SYM 862
#define USING 863
#define UTC_DATE_SYM 864
#define UTC_TIMESTAMP_SYM 865
#define UTC_TIME_SYM 866
#define VALUES 867
#define VALUE_SYM 868
#define VARBINARY 869
#define VARCHAR 870
#define VARIABLES 871
#define VARIANCE_SYM 872
#define VARYING 873
#define VAR_SAMP_SYM 874
#define VIA_SYM 875
#define VIEW_SYM 876
#define VIRTUAL_SYM 877
#define WAIT_SYM 878
#define WARNINGS 879
#define WEEK_SYM 880
#define WEIGHT_STRING_SYM 881
#define WHEN_SYM 882
#define WHERE 883
#define WHILE_SYM 884
#define WITH 885
#define WITH_CUBE_SYM 886
#define WITH_ROLLUP_SYM 887
#define WORK_SYM 888
#define WRAPPER_SYM 889
#define WRITE_SYM 890
#define X509_SYM 891
#define XA_SYM 892
#define XML_SYM 893
#define XOR 894
#define YEAR_MONTH_SYM 895
#define YEAR_SYM 896
#define ZEROFILL 897
#define IMPOSSIBLE_ACTION 898




#if ! defined YYSTYPE && ! defined YYSTYPE_IS_DECLARED
typedef union YYSTYPE
{

/* Line 214 of yacc.c  */
#line 896 "/home/buildbot/bzr/build/sql/sql_yacc.yy"

  int  num;
  ulong ulong_num;
  ulonglong ulonglong_number;
  longlong longlong_number;
  LEX_STRING lex_str;
  LEX_STRING *lex_str_ptr;
  LEX_SYMBOL symbol;
  Table_ident *table;
  char *simple_string;
  Item *item;
  Item_num *item_num;
  List<Item> *item_list;
  List<String> *string_list;
  String *string;
  Key_part_spec *key_part;
  TABLE_LIST *table_list;
  udf_func *udf;
  LEX_USER *lex_user;
  struct sys_var_with_base variable;
  enum enum_var_type var_type;
  Key::Keytype key_type;
  enum ha_key_alg key_alg;
  handlerton *db_type;
  enum row_type row_type;
  enum ha_rkey_function ha_rkey_mode;
  enum enum_tx_isolation tx_isolation;
  enum Cast_target cast_type;
  enum Item_udftype udf_type;
  enum ha_choice choice;
  CHARSET_INFO *charset;
  thr_lock_type lock_type;
  interval_type interval, interval_time_st;
  timestamp_type date_time_type;
  st_select_lex *select_lex;
  chooser_compare_func_creator boolfunc2creator;
  class sp_condition_value *spcondvalue;
  struct { int vars, conds, hndlrs, curs; } spblock;
  sp_name *spname;
  LEX *lex;
  sp_head *sphead;
  struct p_elem_val *p_elem_value;
  enum index_hint_type index_hint;
  enum enum_filetype filetype;
  enum Foreign_key::fk_option m_fk_option;
  enum enum_yes_no_unknown m_yes_no_unk;
  Diag_condition_item_name diag_condition_item_name;
  Diagnostics_information::Which_area diag_area;
  Diagnostics_information *diag_info;
  Statement_information_item *stmt_info_item;
  Statement_information_item::Name stmt_info_item_name;
  List<Statement_information_item> *stmt_info_list;
  Condition_information_item *cond_info_item;
  Condition_information_item::Name cond_info_item_name;
  List<Condition_information_item> *cond_info_list;
  DYNCALL_CREATE_DEF *dyncol_def;
  List<DYNCALL_CREATE_DEF> *dyncol_def_list;
  bool is_not_empty;



/* Line 214 of yacc.c  */
#line 2338 "/home/buildbot/bzr/build/mkdist/sql/sql_yacc.cc"
} YYSTYPE;
# define YYSTYPE_IS_TRIVIAL 1
# define yystype YYSTYPE /* obsolescent; will be withdrawn */
# define YYSTYPE_IS_DECLARED 1
#endif


/* Copy the second part of user declarations.  */

/* Line 264 of yacc.c  */
#line 956 "/home/buildbot/bzr/build/sql/sql_yacc.yy"

bool my_yyoverflow(short **a, YYSTYPE **b, ulong *yystacksize);


/* Line 264 of yacc.c  */
#line 2355 "/home/buildbot/bzr/build/mkdist/sql/sql_yacc.cc"

#ifdef short
# undef short
#endif

#ifdef YYTYPE_UINT8
typedef YYTYPE_UINT8 yytype_uint8;
#else
typedef unsigned char yytype_uint8;
#endif

#ifdef YYTYPE_INT8
typedef YYTYPE_INT8 yytype_int8;
#elif (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
typedef signed char yytype_int8;
#else
typedef short int yytype_int8;
#endif

#ifdef YYTYPE_UINT16
typedef YYTYPE_UINT16 yytype_uint16;
#else
typedef unsigned short int yytype_uint16;
#endif

#ifdef YYTYPE_INT16
typedef YYTYPE_INT16 yytype_int16;
#else
typedef short int yytype_int16;
#endif

#ifndef YYSIZE_T
# ifdef __SIZE_TYPE__
#  define YYSIZE_T __SIZE_TYPE__
# elif defined size_t
#  define YYSIZE_T size_t
# elif ! defined YYSIZE_T && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# else
#  define YYSIZE_T unsigned int
# endif
#endif

#define YYSIZE_MAXIMUM ((YYSIZE_T) -1)

#ifndef YY_
# if YYENABLE_NLS
#  if ENABLE_NLS
#   include <libintl.h> /* INFRINGES ON USER NAME SPACE */
#   define YY_(msgid) dgettext ("bison-runtime", msgid)
#  endif
# endif
# ifndef YY_
#  define YY_(msgid) msgid
# endif
#endif

/* Suppress unused-variable warnings by "using" E.  */
#if ! defined lint || defined __GNUC__
# define YYUSE(e) ((void) (e))
#else
# define YYUSE(e) /* empty */
#endif

/* Identity function, used to suppress warnings about constant conditions.  */
#ifndef lint
# define YYID(n) (n)
#else
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static int
YYID (int yyi)
#else
static int
YYID (yyi)
    int yyi;
#endif
{
  return yyi;
}
#endif

#if ! defined yyoverflow || YYERROR_VERBOSE

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# ifdef YYSTACK_USE_ALLOCA
#  if YYSTACK_USE_ALLOCA
#   ifdef __GNUC__
#    define YYSTACK_ALLOC __builtin_alloca
#   elif defined __BUILTIN_VA_ARG_INCR
#    include <alloca.h> /* INFRINGES ON USER NAME SPACE */
#   elif defined _AIX
#    define YYSTACK_ALLOC __alloca
#   elif defined _MSC_VER
#    include <malloc.h> /* INFRINGES ON USER NAME SPACE */
#    define alloca _alloca
#   else
#    define YYSTACK_ALLOC alloca
#    if ! defined _ALLOCA_H && ! defined _STDLIB_H && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
#     include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#     ifndef _STDLIB_H
#      define _STDLIB_H 1
#     endif
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's `empty if-body' warning.  */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (YYID (0))
#  ifndef YYSTACK_ALLOC_MAXIMUM
    /* The OS might guarantee only one guard page at the bottom of the stack,
       and a page size can be as small as 4096 bytes.  So we cannot safely
       invoke alloca (N) if N exceeds 4096.  Use a slightly smaller number
       to allow for a few compiler-allocated temporary stack slots.  */
#   define YYSTACK_ALLOC_MAXIMUM 4032 /* reasonable circa 2006 */
#  endif
# else
#  define YYSTACK_ALLOC YYMALLOC
#  define YYSTACK_FREE YYFREE
#  ifndef YYSTACK_ALLOC_MAXIMUM
#   define YYSTACK_ALLOC_MAXIMUM YYSIZE_MAXIMUM
#  endif
#  if (defined __cplusplus && ! defined _STDLIB_H \
       && ! ((defined YYMALLOC || defined malloc) \
	     && (defined YYFREE || defined free)))
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   ifndef _STDLIB_H
#    define _STDLIB_H 1
#   endif
#  endif
#  ifndef YYMALLOC
#   define YYMALLOC malloc
#   if ! defined malloc && ! defined _STDLIB_H && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
void *malloc (YYSIZE_T); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
#  ifndef YYFREE
#   define YYFREE free
#   if ! defined free && ! defined _STDLIB_H && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
void free (void *); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
# endif
#endif /* ! defined yyoverflow || YYERROR_VERBOSE */


#if (! defined yyoverflow \
     && (! defined __cplusplus \
	 || (defined YYSTYPE_IS_TRIVIAL && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  yytype_int16 yyss_alloc;
  YYSTYPE yyvs_alloc;
};

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (sizeof (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (sizeof (yytype_int16) + sizeof (YYSTYPE)) \
      + YYSTACK_GAP_MAXIMUM)

/* Copy COUNT objects from FROM to TO.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if defined __GNUC__ && 1 < __GNUC__
#   define YYCOPY(To, From, Count) \
      __builtin_memcpy (To, From, (Count) * sizeof (*(From)))
#  else
#   define YYCOPY(To, From, Count)		\
      do					\
	{					\
	  YYSIZE_T yyi;				\
	  for (yyi = 0; yyi < (Count); yyi++)	\
	    (To)[yyi] = (From)[yyi];		\
	}					\
      while (YYID (0))
#  endif
# endif

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack_alloc, Stack)				\
    do									\
      {									\
	YYSIZE_T yynewbytes;						\
	YYCOPY (&yyptr->Stack_alloc, Stack, yysize);			\
	Stack = &yyptr->Stack_alloc;					\
	yynewbytes = yystacksize * sizeof (*Stack) + YYSTACK_GAP_MAXIMUM; \
	yyptr += yynewbytes / sizeof (*yyptr);				\
      }									\
    while (YYID (0))

#endif

/* YYFINAL -- State number of the termination state.  */
#define YYFINAL  622
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   65776

/* YYNTOKENS -- Number of terminals.  */
#define YYNTOKENS  663
/* YYNNTS -- Number of nonterminals.  */
#define YYNNTS  996
/* YYNRULES -- Number of rules.  */
#define YYNRULES  2821
/* YYNRULES -- Number of states.  */
#define YYNSTATES  4789

/* YYTRANSLATE(YYLEX) -- Bison symbol number corresponding to YYLEX.  */
#define YYUNDEFTOK  2
#define YYMAXUTOK   898

#define YYTRANSLATE(YYX)						\
  ((unsigned int) (YYX) <= YYMAXUTOK ? yytranslate[YYX] : YYUNDEFTOK)

/* YYTRANSLATE[YYLEX] -- Bison symbol number corresponding to YYLEX.  */
static const yytype_uint16 yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,   656,     2,     2,     2,   650,   645,     2,
     653,   654,   648,   647,   655,   646,   661,   649,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,   662,   659,
       2,     2,     2,     2,   660,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,   651,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,   657,   644,   658,   652,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    66,    67,    68,    69,    70,    71,    72,    73,    74,
      75,    76,    77,    78,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    88,    89,    90,    91,    92,    93,    94,
      95,    96,    97,    98,    99,   100,   101,   102,   103,   104,
     105,   106,   107,   108,   109,   110,   111,   112,   113,   114,
     115,   116,   117,   118,   119,   120,   121,   122,   123,   124,
     125,   126,   127,   128,   129,   130,   131,   132,   133,   134,
     135,   136,   137,   138,   139,   140,   141,   142,   143,   144,
     145,   146,   147,   148,   149,   150,   151,   152,   153,   154,
     155,   156,   157,   158,   159,   160,   161,   162,   163,   164,
     165,   166,   167,   168,   169,   170,   171,   172,   173,   174,
     175,   176,   177,   178,   179,   180,   181,   182,   183,   184,
     185,   186,   187,   188,   189,   190,   191,   192,   193,   194,
     195,   196,   197,   198,   199,   200,   201,   202,   203,   204,
     205,   206,   207,   208,   209,   210,   211,   212,   213,   214,
     215,   216,   217,   218,   219,   220,   221,   222,   223,   224,
     225,   226,   227,   228,   229,   230,   231,   232,   233,   234,
     235,   236,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   246,   247,   248,   249,   250,   251,   252,   253,   254,
     255,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,   396,   397,   398,   399,   400,   401,   402,   403,   404,
     405,   406,   407,   408,   409,   410,   411,   412,   413,   414,
     415,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,   427,   428,   429,   430,   431,   432,   433,   434,
     435,   436,   437,   438,   439,   440,   441,   442,   443,   444,
     445,   446,   447,   448,   449,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   460,   461,   462,   463,   464,
     465,   466,   467,   468,   469,   470,   471,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,   482,   483,   484,
     485,   486,   487,   488,   489,   490,   491,   492,   493,   494,
     495,   496,   497,   498,   499,   500,   501,   502,   503,   504,
     505,   506,   507,   508,   509,   510,   511,   512,   513,   514,
     515,   516,   517,   518,   519,   520,   521,   522,   523,   524,
     525,   526,   527,   528,   529,   530,   531,   532,   533,   534,
     535,   536,   537,   538,   539,   540,   541,   542,   543,   544,
     545,   546,   547,   548,   549,   550,   551,   552,   553,   554,
     555,   556,   557,   558,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   572,   573,   574,
     575,   576,   577,   578,   579,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,   592,   593,   594,
     595,   596,   597,   598,   599,   600,   601,   602,   603,   604,
     605,   606,   607,   608,   609,   610,   611,   612,   613,   614,
     615,   616,   617,   618,   619,   620,   621,   622,   623,   624,
     625,   626,   627,   628,   629,   630,   631,   632,   633,   634,
     635,   636,   637,   638,   639,   640,   641,   642,   643
};

#if YYDEBUG
/* YYPRHS[YYN] -- Index of the first RHS symbol of rule number YYN in
   YYRHS.  */
static const yytype_uint16 yyprhs[] =
{
       0,     0,     3,     5,     6,    11,    14,    15,    17,    19,
      21,    23,    25,    27,    29,    31,    33,    35,    37,    39,
      41,    43,    45,    47,    49,    51,    53,    55,    57,    59,
      61,    63,    65,    67,    69,    71,    73,    75,    77,    79,
      81,    83,    85,    87,    89,    91,    93,    95,    97,    99,
     101,   103,   105,   107,   109,   111,   113,   115,   117,   119,
     121,   123,   125,   127,   129,   131,   135,   137,   139,   144,
     146,   149,   150,   155,   156,   159,   163,   165,   168,   169,
     173,   174,   181,   183,   187,   191,   195,   199,   203,   207,
     211,   215,   219,   223,   227,   231,   235,   239,   243,   247,
     253,   255,   256,   258,   262,   264,   268,   272,   276,   280,
     284,   288,   292,   293,   295,   297,   298,   306,   307,   308,
     324,   325,   326,   342,   343,   344,   360,   361,   368,   369,
     373,   378,   384,   389,   393,   396,   407,   409,   413,   416,
     419,   422,   425,   428,   431,   434,   435,   449,   450,   457,
     460,   461,   463,   467,   469,   470,   473,   474,   477,   478,
     480,   484,   489,   490,   493,   494,   497,   499,   501,   503,
     505,   507,   509,   511,   513,   515,   517,   519,   521,   523,
     524,   528,   530,   531,   534,   535,   538,   541,   544,   547,
     550,   554,   558,   560,   562,   564,   567,   571,   575,   576,
     581,   582,   586,   587,   589,   593,   595,   596,   598,   602,
     604,   605,   609,   610,   612,   616,   618,   623,   624,   626,
     628,   630,   631,   635,   638,   642,   643,   647,   648,   654,
     660,   661,   669,   675,   676,   679,   681,   683,   685,   689,
     691,   693,   695,   699,   700,   702,   704,   706,   708,   711,
     713,   717,   719,   721,   722,   724,   725,   728,   732,   738,
     740,   742,   744,   746,   748,   750,   752,   754,   756,   758,
     760,   762,   764,   766,   768,   772,   777,   778,   780,   782,
     786,   788,   792,   796,   798,   801,   803,   805,   807,   809,
     813,   817,   819,   821,   823,   825,   827,   829,   831,   833,
     835,   837,   839,   841,   843,   845,   849,   850,   853,   855,
     857,   859,   861,   863,   865,   867,   869,   871,   873,   875,
     877,   879,   880,   886,   887,   890,   891,   895,   896,   899,
     902,   905,   908,   909,   916,   919,   920,   923,   925,   927,
     931,   932,   933,   934,   942,   943,   946,   949,   951,   953,
     954,   955,   964,   965,   972,   974,   977,   979,   982,   983,
     984,   991,   992,   993,  1000,  1001,  1004,  1005,  1011,  1012,
    1014,  1015,  1021,  1022,  1025,  1026,  1032,  1037,  1038,  1039,
    1048,  1049,  1057,  1059,  1061,  1063,  1065,  1067,  1070,  1075,
    1081,  1082,  1087,  1092,  1097,  1101,  1105,  1108,  1111,  1112,
    1115,  1117,  1120,  1124,  1126,  1128,  1130,  1132,  1134,  1137,
    1141,  1143,  1145,  1147,  1149,  1151,  1153,  1155,  1157,  1159,
    1161,  1164,  1168,  1170,  1172,  1174,  1176,  1178,  1180,  1182,
    1185,  1189,  1191,  1193,  1195,  1197,  1199,  1201,  1203,  1205,
    1207,  1210,  1214,  1216,  1218,  1220,  1223,  1226,  1229,  1231,
    1233,  1235,  1237,  1240,  1244,  1248,  1252,  1256,  1260,  1264,
    1268,  1272,  1277,  1278,  1280,  1282,  1284,  1286,  1288,  1289,
    1297,  1301,  1302,  1308,  1310,  1313,  1318,  1319,  1320,  1326,
    1327,  1335,  1337,  1338,  1340,  1341,  1346,  1347,  1348,  1352,
    1358,  1365,  1366,  1371,  1374,  1377,  1380,  1383,  1384,  1386,
    1387,  1391,  1392,  1394,  1396,  1400,  1402,  1407,  1413,  1419,
    1420,  1423,  1424,  1425,  1433,  1434,  1445,  1447,  1451,  1453,
    1455,  1456,  1459,  1460,  1464,  1466,  1470,  1471,  1478,  1480,
    1481,  1482,  1488,  1489,  1494,  1496,  1498,  1500,  1504,  1506,
    1510,  1511,  1512,  1518,  1520,  1524,  1526,  1528,  1529,  1533,
    1535,  1539,  1540,  1545,  1547,  1548,  1550,  1553,  1555,  1559,
    1564,  1568,  1572,  1576,  1580,  1585,  1590,  1594,  1595,  1596,
    1603,  1604,  1606,  1607,  1609,  1611,  1614,  1616,  1618,  1619,
    1621,  1623,  1626,  1628,  1629,  1633,  1635,  1639,  1640,  1642,
    1644,  1647,  1649,  1652,  1656,  1660,  1664,  1668,  1672,  1676,
    1680,  1684,  1688,  1692,  1696,  1700,  1704,  1708,  1712,  1716,
    1720,  1724,  1728,  1732,  1736,  1737,  1744,  1746,  1748,  1752,
    1757,  1762,  1765,  1768,  1771,  1775,  1779,  1783,  1787,  1791,
    1795,  1799,  1804,  1809,  1811,  1813,  1815,  1817,  1819,  1821,
    1823,  1825,  1827,  1829,  1831,  1833,  1835,  1838,  1840,  1842,
    1844,  1846,  1848,  1850,  1854,  1856,  1858,  1861,  1864,  1865,
    1874,  1875,  1885,  1886,  1896,  1897,  1907,  1916,  1919,  1920,
    1922,  1927,  1928,  1930,  1933,  1934,  1938,  1941,  1950,  1951,
    1954,  1955,  1957,  1959,  1960,  1962,  1965,  1967,  1969,  1972,
    1975,  1980,  1984,  1988,  1992,  1996,  1998,  2001,  2003,  2005,
    2009,  2012,  2016,  2019,  2022,  2024,  2028,  2032,  2035,  2039,
    2041,  2044,  2047,  2050,  2052,  2055,  2057,  2059,  2061,  2064,
    2068,  2071,  2075,  2078,  2081,  2085,  2089,  2093,  2094,  2101,
    2102,  2109,  2112,  2114,  2116,  2118,  2120,  2122,  2124,  2126,
    2128,  2130,  2132,  2134,  2137,  2140,  2142,  2145,  2147,  2150,
    2154,  2157,  2159,  2161,  2163,  2165,  2167,  2169,  2171,  2174,
    2175,  2177,  2179,  2185,  2186,  2188,  2191,  2193,  2195,  2197,
    2199,  2203,  2207,  2211,  2215,  2216,  2218,  2219,  2221,  2222,
    2224,  2227,  2229,  2231,  2234,  2237,  2242,  2244,  2248,  2251,
    2253,  2256,  2259,  2262,  2266,  2270,  2274,  2278,  2281,  2284,
    2286,  2288,  2290,  2293,  2295,  2297,  2299,  2301,  2303,  2304,
    2307,  2309,  2311,  2313,  2315,  2317,  2318,  2321,  2323,  2325,
    2326,  2328,  2330,  2333,  2336,  2338,  2341,  2344,  2345,  2347,
    2349,  2351,  2355,  2357,  2361,  2362,  2364,  2365,  2370,  2372,
    2374,  2376,  2377,  2379,  2382,  2384,  2386,  2389,  2391,  2395,
    2399,  2401,  2403,  2404,  2407,  2408,  2410,  2416,  2417,  2421,
    2425,  2427,  2428,  2431,  2434,  2437,  2438,  2442,  2446,  2453,
    2460,  2462,  2464,  2467,  2470,  2473,  2475,  2478,  2481,  2483,
    2485,  2486,  2488,  2490,  2492,  2494,  2495,  2497,  2499,  2501,
    2502,  2504,  2507,  2508,  2510,  2511,  2513,  2514,  2516,  2518,
    2521,  2523,  2526,  2528,  2531,  2534,  2537,  2541,  2544,  2548,
    2552,  2556,  2560,  2562,  2564,  2566,  2568,  2572,  2574,  2576,
    2578,  2583,  2586,  2588,  2593,  2594,  2596,  2599,  2600,  2603,
    2605,  2609,  2610,  2611,  2619,  2620,  2626,  2634,  2635,  2641,
    2642,  2648,  2649,  2655,  2656,  2661,  2662,  2673,  2677,  2682,
    2686,  2690,  2698,  2699,  2703,  2705,  2710,  2711,  2715,  2716,
    2719,  2720,  2722,  2723,  2726,  2729,  2732,  2735,  2737,  2739,
    2741,  2746,  2751,  2752,  2759,  2764,  2765,  2771,  2772,  2779,
    2784,  2788,  2790,  2798,  2801,  2803,  2805,  2806,  2813,  2814,
    2818,  2821,  2822,  2828,  2829,  2830,  2837,  2839,  2843,  2845,
    2847,  2851,  2855,  2859,  2862,  2867,  2868,  2876,  2877,  2878,
    2887,  2893,  2899,  2903,  2908,  2911,  2914,  2921,  2927,  2931,
    2937,  2939,  2941,  2943,  2945,  2947,  2948,  2950,  2952,  2955,
    2958,  2962,  2966,  2970,  2974,  2975,  2977,  2978,  2980,  2981,
    2984,  2985,  2987,  2990,  2992,  2994,  2996,  2997,  2999,  3001,
    3002,  3005,  3007,  3008,  3010,  3012,  3014,  3015,  3022,  3023,
    3029,  3034,  3039,  3043,  3044,  3046,  3048,  3052,  3056,  3059,
    3062,  3063,  3066,  3068,  3072,  3073,  3075,  3077,  3078,  3081,
    3086,  3088,  3092,  3093,  3099,  3100,  3102,  3104,  3105,  3112,
    3113,  3115,  3117,  3120,  3122,  3124,  3126,  3127,  3133,  3135,
    3139,  3142,  3143,  3147,  3149,  3154,  3156,  3157,  3162,  3164,
    3165,  3170,  3171,  3173,  3177,  3178,  3180,  3184,  3186,  3188,
    3191,  3192,  3198,  3199,  3201,  3203,  3206,  3208,  3210,  3212,
    3214,  3216,  3219,  3220,  3226,  3227,  3229,  3231,  3232,  3237,
    3242,  3246,  3252,  3254,  3258,  3262,  3263,  3270,  3272,  3274,
    3276,  3280,  3283,  3287,  3289,  3291,  3292,  3299,  3301,  3303,
    3305,  3309,  3313,  3318,  3319,  3326,  3327,  3330,  3331,  3336,
    3337,  3340,  3342,  3345,  3350,  3353,  3357,  3360,  3364,  3365,
    3369,  3370,  3371,  3378,  3381,  3383,  3385,  3388,  3391,  3400,
    3405,  3406,  3408,  3411,  3413,  3415,  3417,  3419,  3420,  3423,
    3428,  3432,  3434,  3436,  3440,  3445,  3446,  3447,  3448,  3451,
    3454,  3456,  3458,  3459,  3462,  3466,  3467,  3470,  3474,  3475,
    3478,  3482,  3486,  3490,  3493,  3497,  3502,  3506,  3511,  3515,
    3520,  3522,  3526,  3531,  3535,  3539,  3546,  3548,  3554,  3561,
    3567,  3575,  3582,  3591,  3597,  3604,  3609,  3614,  3620,  3624,
    3629,  3631,  3635,  3639,  3643,  3647,  3651,  3655,  3661,  3667,
    3671,  3675,  3679,  3683,  3687,  3691,  3693,  3695,  3697,  3699,
    3701,  3703,  3705,  3707,  3709,  3711,  3713,  3715,  3717,  3719,
    3721,  3723,  3725,  3726,  3729,  3731,  3734,  3736,  3738,  3740,
    3743,  3746,  3748,  3750,  3753,  3756,  3761,  3763,  3767,  3769,
    3771,  3773,  3775,  3777,  3781,  3783,  3785,  3787,  3789,  3793,
    3796,  3799,  3802,  3805,  3809,  3813,  3819,  3826,  3831,  3836,
    3844,  3847,  3854,  3860,  3867,  3874,  3879,  3884,  3890,  3895,
    3902,  3905,  3908,  3913,  3918,  3923,  3934,  3941,  3950,  3957,
    3962,  3967,  3974,  3979,  3984,  3989,  3996,  4001,  4009,  4017,
    4025,  4032,  4039,  4046,  4053,  4057,  4062,  4069,  4078,  4081,
    4084,  4093,  4102,  4109,  4116,  4119,  4126,  4133,  4142,  4151,
    4158,  4167,  4174,  4177,  4186,  4195,  4198,  4201,  4204,  4211,
    4218,  4223,  4228,  4237,  4242,  4247,  4252,  4257,  4261,  4270,
    4275,  4280,  4287,  4292,  4297,  4302,  4309,  4318,  4323,  4327,
    4334,  4339,  4346,  4352,  4361,  4369,  4380,  4382,  4389,  4394,
    4399,  4404,  4409,  4414,  4421,  4426,  4427,  4433,  4440,  4443,
    4447,  4448,  4453,  4454,  4458,  4459,  4461,  4463,  4467,  4472,
    4477,  4483,  4488,  4493,  4498,  4504,  4509,  4510,  4511,  4519,
    4524,  4530,  4535,  4541,  4546,  4551,  4556,  4561,  4566,  4572,
    4573,  4582,  4583,  4587,  4591,  4593,  4598,  4599,  4601,  4602,
    4605,  4606,  4607,  4612,  4617,  4620,  4621,  4625,  4628,  4632,
    4635,  4637,  4639,  4642,  4644,  4647,  4649,  4652,  4655,  4658,
    4659,  4663,  4664,  4666,  4668,  4672,  4674,  4678,  4680,  4684,
    4685,  4687,  4688,  4691,  4696,  4702,  4704,  4706,  4708,  4710,
    4715,  4717,  4721,  4725,  4726,  4733,  4734,  4743,  4748,  4749,
    4758,  4759,  4770,  4777,  4778,  4787,  4788,  4799,  4806,  4808,
    4811,  4813,  4815,  4818,  4819,  4821,  4827,  4828,  4834,  4838,
    4844,  4847,  4848,  4849,  4857,  4859,  4860,  4861,  4868,  4869,
    4873,  4874,  4875,  4881,  4882,  4884,  4885,  4887,  4888,  4891,
    4895,  4899,  4901,  4903,  4904,  4912,  4913,  4921,  4923,  4926,
    4927,  4928,  4931,  4932,  4935,  4936,  4938,  4940,  4942,  4944,
    4948,  4950,  4954,  4956,  4958,  4960,  4962,  4964,  4966,  4968,
    4970,  4972,  4974,  4976,  4978,  4980,  4982,  4984,  4986,  4988,
    4990,  4992,  4994,  4996,  4998,  5000,  5002,  5004,  5005,  5007,
    5009,  5010,  5013,  5014,  5016,  5017,  5018,  5022,  5023,  5024,
    5028,  5031,  5032,  5033,  5038,  5043,  5046,  5047,  5049,  5051,
    5055,  5059,  5061,  5064,  5065,  5067,  5068,  5073,  5078,  5081,
    5082,  5084,  5086,  5087,  5089,  5090,  5092,  5095,  5101,  5106,
    5108,  5112,  5116,  5118,  5120,  5122,  5124,  5126,  5128,  5129,
    5132,  5136,  5141,  5143,  5146,  5149,  5151,  5153,  5155,  5157,
    5159,  5161,  5163,  5165,  5167,  5169,  5171,  5173,  5175,  5177,
    5179,  5181,  5183,  5185,  5187,  5189,  5191,  5193,  5195,  5197,
    5199,  5201,  5202,  5203,  5210,  5211,  5213,  5217,  5219,  5223,
    5224,  5227,  5231,  5233,  5236,  5238,  5239,  5243,  5244,  5245,
    5253,  5256,  5258,  5259,  5263,  5264,  5272,  5273,  5281,  5286,
    5293,  5298,  5303,  5308,  5313,  5314,  5321,  5326,  5331,  5337,
    5344,  5349,  5351,  5355,  5357,  5360,  5362,  5366,  5368,  5369,
    5372,  5373,  5375,  5376,  5377,  5386,  5387,  5388,  5395,  5396,
    5398,  5400,  5402,  5404,  5406,  5409,  5411,  5413,  5415,  5419,
    5424,  5425,  5429,  5433,  5435,  5438,  5441,  5442,  5446,  5447,
    5453,  5457,  5459,  5463,  5465,  5469,  5471,  5473,  5474,  5476,
    5477,  5482,  5483,  5485,  5489,  5491,  5493,  5495,  5496,  5497,
    5504,  5505,  5506,  5518,  5522,  5524,  5528,  5532,  5534,  5538,
    5539,  5541,  5542,  5547,  5548,  5549,  5559,  5560,  5566,  5567,
    5574,  5575,  5578,  5580,  5584,  5587,  5592,  5593,  5596,  5597,
    5600,  5602,  5604,  5606,  5607,  5612,  5613,  5615,  5616,  5618,
    5620,  5624,  5626,  5628,  5631,  5634,  5637,  5639,  5641,  5643,
    5645,  5646,  5650,  5651,  5655,  5658,  5663,  5668,  5672,  5677,
    5682,  5684,  5688,  5692,  5696,  5700,  5707,  5710,  5713,  5714,
    5721,  5722,  5730,  5736,  5739,  5741,  5743,  5745,  5751,  5757,
    5760,  5763,  5765,  5770,  5774,  5777,  5781,  5784,  5787,  5789,
    5793,  5798,  5802,  5806,  5809,  5813,  5816,  5820,  5822,  5824,
    5826,  5828,  5832,  5836,  5840,  5844,  5848,  5852,  5856,  5860,
    5864,  5866,  5868,  5870,  5872,  5874,  5875,  5877,  5878,  5881,
    5882,  5884,  5886,  5888,  5889,  5892,  5893,  5896,  5897,  5900,
    5903,  5904,  5909,  5910,  5915,  5917,  5919,  5921,  5923,  5925,
    5927,  5929,  5930,  5932,  5934,  5935,  5937,  5939,  5940,  5945,
    5946,  5951,  5953,  5954,  5956,  5961,  5962,  5966,  5970,  5972,
    5975,  5978,  5981,  5984,  5987,  5991,  5994,  5996,  5998,  6000,
    6002,  6005,  6007,  6009,  6011,  6013,  6015,  6017,  6019,  6020,
    6022,  6023,  6027,  6028,  6032,  6036,  6038,  6039,  6044,  6046,
    6049,  6050,  6052,  6053,  6057,  6061,  6064,  6067,  6068,  6074,
    6075,  6077,  6079,  6080,  6082,  6084,  6087,  6089,  6092,  6094,
    6097,  6098,  6099,  6100,  6101,  6124,  6126,  6128,  6129,  6131,
    6132,  6134,  6136,  6137,  6139,  6141,  6142,  6145,  6148,  6150,
    6154,  6159,  6163,  6167,  6168,  6171,  6174,  6176,  6180,  6184,
    6185,  6190,  6191,  6195,  6197,  6199,  6200,  6204,  6207,  6211,
    6213,  6215,  6218,  6219,  6222,  6226,  6228,  6234,  6236,  6238,
    6241,  6244,  6246,  6248,  6250,  6252,  6254,  6256,  6259,  6262,
    6264,  6266,  6268,  6270,  6272,  6274,  6276,  6278,  6280,  6283,
    6286,  6288,  6290,  6292,  6294,  6296,  6299,  6302,  6305,  6307,
    6309,  6313,  6319,  6321,  6323,  6325,  6327,  6329,  6333,  6338,
    6344,  6346,  6352,  6356,  6359,  6361,  6365,  6368,  6371,  6376,
    6378,  6380,  6382,  6384,  6386,  6388,  6390,  6392,  6394,  6396,
    6398,  6400,  6402,  6404,  6408,  6411,  6413,  6415,  6417,  6419,
    6421,  6423,  6425,  6427,  6429,  6431,  6433,  6435,  6437,  6439,
    6441,  6443,  6445,  6447,  6449,  6451,  6453,  6455,  6457,  6459,
    6461,  6463,  6465,  6467,  6469,  6471,  6473,  6475,  6477,  6479,
    6481,  6483,  6485,  6487,  6489,  6491,  6493,  6495,  6497,  6499,
    6501,  6503,  6505,  6507,  6509,  6511,  6513,  6515,  6517,  6519,
    6521,  6523,  6525,  6527,  6529,  6531,  6533,  6535,  6537,  6539,
    6541,  6543,  6545,  6547,  6549,  6551,  6553,  6555,  6557,  6559,
    6561,  6563,  6565,  6567,  6569,  6571,  6573,  6575,  6577,  6579,
    6581,  6583,  6585,  6587,  6589,  6591,  6593,  6595,  6597,  6599,
    6601,  6603,  6605,  6607,  6609,  6611,  6613,  6615,  6617,  6619,
    6621,  6623,  6625,  6627,  6629,  6631,  6633,  6635,  6637,  6639,
    6641,  6643,  6645,  6647,  6649,  6651,  6653,  6655,  6657,  6659,
    6661,  6663,  6665,  6667,  6669,  6671,  6673,  6675,  6677,  6679,
    6681,  6683,  6685,  6687,  6689,  6691,  6693,  6695,  6697,  6699,
    6701,  6703,  6705,  6707,  6709,  6711,  6713,  6715,  6717,  6719,
    6721,  6723,  6725,  6727,  6729,  6731,  6733,  6735,  6737,  6739,
    6741,  6743,  6745,  6747,  6749,  6751,  6753,  6755,  6757,  6759,
    6761,  6763,  6765,  6767,  6769,  6771,  6773,  6775,  6777,  6779,
    6781,  6783,  6785,  6787,  6789,  6791,  6793,  6795,  6797,  6799,
    6801,  6803,  6805,  6807,  6809,  6811,  6813,  6815,  6817,  6819,
    6821,  6823,  6825,  6827,  6829,  6831,  6833,  6835,  6837,  6839,
    6841,  6843,  6845,  6847,  6849,  6851,  6853,  6855,  6857,  6859,
    6861,  6863,  6865,  6867,  6869,  6871,  6873,  6875,  6877,  6879,
    6881,  6883,  6885,  6887,  6889,  6891,  6893,  6895,  6897,  6899,
    6901,  6903,  6905,  6907,  6909,  6911,  6913,  6915,  6917,  6919,
    6921,  6923,  6925,  6927,  6929,  6931,  6933,  6935,  6937,  6939,
    6941,  6943,  6945,  6947,  6949,  6951,  6953,  6955,  6957,  6959,
    6961,  6963,  6965,  6967,  6969,  6971,  6973,  6975,  6977,  6979,
    6981,  6983,  6985,  6987,  6989,  6991,  6993,  6995,  6997,  6999,
    7001,  7003,  7005,  7007,  7009,  7011,  7013,  7015,  7017,  7019,
    7021,  7023,  7025,  7027,  7029,  7031,  7033,  7035,  7037,  7039,
    7041,  7043,  7045,  7047,  7049,  7051,  7053,  7055,  7057,  7059,
    7061,  7063,  7065,  7067,  7069,  7071,  7073,  7075,  7077,  7079,
    7081,  7083,  7085,  7087,  7089,  7091,  7093,  7095,  7097,  7099,
    7101,  7103,  7105,  7107,  7109,  7111,  7113,  7115,  7117,  7119,
    7121,  7123,  7125,  7127,  7129,  7131,  7133,  7135,  7137,  7139,
    7141,  7143,  7145,  7147,  7149,  7151,  7153,  7155,  7157,  7158,
    7162,  7163,  7167,  7168,  7172,  7173,  7177,  7178,  7182,  7185,
    7186,  7189,  7190,  7193,  7194,  7199,  7200,  7204,  7206,  7208,
    7210,  7212,  7213,  7215,  7217,  7219,  7220,  7223,  7226,  7229,
    7233,  7237,  7242,  7249,  7252,  7256,  7260,  7263,  7267,  7273,
    7275,  7279,  7283,  7285,  7287,  7291,  7295,  7297,  7301,  7304,
    7307,  7310,  7313,  7316,  7318,  7320,  7325,  7330,  7332,  7334,
    7336,  7338,  7340,  7341,  7346,  7348,  7350,  7352,  7356,  7360,
    7362,  7364,  7367,  7370,  7373,  7374,  7378,  7383,  7387,  7388,
    7396,  7398,  7401,  7403,  7405,  7407,  7409,  7411,  7413,  7414,
    7420,  7422,  7424,  7426,  7428,  7430,  7434,  7441,  7448,  7455,
    7463,  7469,  7473,  7478,  7480,  7484,  7493,  7502,  7511,  7518,
    7523,  7524,  7528,  7529,  7533,  7535,  7539,  7542,  7544,  7546,
    7547,  7549,  7551,  7554,  7555,  7557,  7559,  7563,  7564,  7568,
    7569,  7573,  7574,  7578,  7579,  7583,  7585,  7587,  7589,  7591,
    7593,  7595,  7597,  7599,  7601,  7603,  7605,  7608,  7611,  7613,
    7617,  7620,  7623,  7626,  7629,  7632,  7635,  7638,  7641,  7643,
    7645,  7648,  7649,  7651,  7655,  7657,  7660,  7663,  7666,  7668,
    7672,  7676,  7678,  7680,  7684,  7686,  7690,  7692,  7696,  7698,
    7700,  7702,  7704,  7709,  7715,  7720,  7727,  7729,  7730,  7734,
    7738,  7740,  7742,  7743,  7746,  7749,  7752,  7755,  7756,  7759,
    7760,  7764,  7767,  7769,  7772,  7775,  7778,  7781,  7784,  7785,
    7789,  7790,  7792,  7793,  7797,  7800,  7801,  7803,  7806,  7807,
    7809,  7814,  7819,  7825,  7828,  7832,  7833,  7835,  7836,  7841,
    7842,  7844,  7846,  7847,  7849,  7850,  7853,  7856,  7858,  7859,
    7861,  7863,  7866,  7870,  7873,  7874,  7881,  7885,  7886,  7887,
    7888,  7890,  7893,  7895,  7897,  7899,  7901,  7903,  7905,  7907,
    7909,  7911,  7914,  7917,  7921,  7923,  7925,  7927,  7929,  7931,
    7933,  7935,  7937,  7939,  7941,  7943,  7945,  7947,  7948,  7952,
    7956,  7960,  7964,  7965,  7969,  7973,  7974,  7982,  7983,  7987,
    7989,  7993,  7994,  7998,  8001,  8006,  8007,  8011,  8016,  8021,
    8022,  8023,  8024,  8041,  8050,  8058,  8059,  8060,  8061,  8062,
    8063,  8079,  8080,  8081,  8082,  8083,  8096,  8101,  8106,  8110,
    8115,  8119,  8122,  8124,  8128,  8134,  8136,  8138,  8139,  8141,
    8143,  8144,  8147,  8148,  8149,  8153,  8154,  8157,  8163,  8167,
    8171,  8175
};

/* YYRHS -- A `-1'-separated list of the rules' RHS.  */
static const yytype_int16 yyrhs[] =
{
     664,     0,    -1,   162,    -1,    -1,   667,   665,   659,   666,
      -1,   667,   162,    -1,    -1,   162,    -1,   668,    -1,  1588,
      -1,  1054,    -1,  1122,    -1,  1135,    -1,   722,    -1,   680,
      -1,  1136,    -1,  1114,    -1,  1594,    -1,   689,    -1,   669,
      -1,  1387,    -1,  1421,    -1,  1338,    -1,  1340,    -1,   673,
      -1,  1428,    -1,   758,    -1,  1554,    -1,  1544,    -1,   678,
      -1,  1351,    -1,  1656,    -1,  1658,    -1,  1149,    -1,  1449,
      -1,  1456,    -1,  1536,    -1,  1141,    -1,   968,    -1,   877,
      -1,  1156,    -1,   671,    -1,  1445,    -1,  1597,    -1,  1144,
      -1,  1117,    -1,  1354,    -1,  1439,    -1,   757,    -1,  1551,
      -1,  1595,    -1,  1596,    -1,  1168,    -1,  1509,    -1,   750,
      -1,  1407,    -1,  1454,    -1,  1101,    -1,  1104,    -1,  1400,
      -1,  1657,    -1,  1542,    -1,  1379,    -1,  1455,    -1,  1648,
      -1,   670,   413,  1501,    -1,   128,    -1,   150,    -1,   413,
    1501,   199,   672,    -1,  1498,    -1,   660,  1503,    -1,    -1,
     177,  1501,   674,   675,    -1,    -1,   608,   676,    -1,   676,
     655,   677,    -1,   677,    -1,   660,  1503,    -1,    -1,   220,
     679,  1503,    -1,    -1,    59,   313,   687,   574,   681,   682,
      -1,   683,    -1,   682,   655,   683,    -1,   298,   166,  1498,
      -1,   314,   166,  1498,    -1,   301,   166,  1498,    -1,   302,
     166,  1317,    -1,   296,   166,  1317,    -1,   311,   166,  1317,
      -1,   305,   166,  1498,    -1,   304,   166,  1498,    -1,   306,
     166,  1498,    -1,   307,   166,  1498,    -1,   310,   166,  1498,
      -1,   312,   166,  1317,    -1,   308,   166,  1498,    -1,   309,
     166,  1498,    -1,   316,   166,  1485,    -1,   236,   166,   653,
     684,   654,    -1,   686,    -1,    -1,   685,    -1,   684,   655,
     685,    -1,  1317,    -1,   299,   166,  1498,    -1,   300,   166,
    1319,    -1,   443,   166,  1498,    -1,   444,   166,  1317,    -1,
     315,   166,   111,    -1,   315,   166,   505,    -1,   315,   166,
     366,    -1,    -1,   688,    -1,  1498,    -1,    -1,   933,   929,
     557,   932,  1494,   690,   865,    -1,    -1,    -1,   104,  1031,
     239,   932,  1501,  1035,   376,  1494,   691,   653,  1048,   654,
    1036,   692,  1088,    -1,    -1,    -1,   104,  1032,   239,   932,
    1501,  1034,   376,  1494,   693,   653,  1048,   654,  1037,   694,
    1088,    -1,    -1,    -1,   104,  1033,   239,   932,  1501,  1034,
     376,  1494,   695,   653,  1048,   654,  1038,   696,  1088,    -1,
      -1,   104,   115,   932,  1501,   697,   926,    -1,    -1,   933,
     698,  1616,    -1,   104,   604,   715,  1575,    -1,   104,   470,
     715,  1558,  1556,    -1,   104,   287,   213,   828,    -1,   104,
     554,   825,    -1,   104,   699,    -1,   491,  1503,   196,   118,
     634,  1503,   382,   653,   700,   654,    -1,   701,    -1,   700,
     655,   701,    -1,   604,  1498,    -1,   224,  1498,    -1,   115,
    1498,    -1,   392,  1498,    -1,   403,  1498,    -1,   509,  1498,
      -1,   410,  1317,    -1,    -1,  1185,   173,   932,   716,   703,
     376,   480,   704,   709,   706,   711,   149,   712,    -1,    -1,
     174,  1191,  1287,   705,   707,   708,    -1,    24,  1191,    -1,
      -1,   158,    -1,   143,   376,   503,    -1,   143,    -1,    -1,
     529,  1191,    -1,    -1,   161,  1191,    -1,    -1,   710,    -1,
     376,    87,   414,    -1,   376,    87,   364,   414,    -1,    -1,
      83,  1498,    -1,    -1,   713,   714,    -1,   774,    -1,   776,
      -1,   772,    -1,   793,    -1,   811,    -1,   813,    -1,   808,
      -1,   778,    -1,   780,    -1,   781,    -1,   782,    -1,   783,
      -1,   785,    -1,    -1,  1501,   661,  1501,    -1,  1501,    -1,
      -1,   717,   719,    -1,    -1,   718,   720,    -1,    83,  1498,
      -1,   265,   525,    -1,   366,   525,    -1,    97,   525,    -1,
     429,   525,   118,    -1,   341,   525,   118,    -1,   721,    -1,
     719,    -1,   140,    -1,  1197,   140,    -1,   525,   484,   133,
      -1,   525,   484,   252,    -1,    -1,    52,   716,   723,   724,
      -1,    -1,   653,   725,   654,    -1,    -1,   726,    -1,   726,
     655,  1191,    -1,  1191,    -1,    -1,   728,    -1,   728,   655,
     730,    -1,   730,    -1,    -1,  1501,   729,   991,    -1,    -1,
     732,    -1,   732,   655,   733,    -1,   733,    -1,   734,   729,
    1501,   991,    -1,    -1,   253,    -1,   391,    -1,   244,    -1,
      -1,   735,   771,   659,    -1,   771,   659,    -1,   736,   771,
     659,    -1,    -1,   737,   738,   659,    -1,    -1,   131,   769,
     739,   991,   770,    -1,   131,  1501,    90,   197,   746,    -1,
      -1,   131,   743,   216,   197,   740,   744,   771,    -1,   131,
    1501,   112,   197,   741,    -1,    -1,   742,  1168,    -1,   179,
      -1,    99,    -1,   745,    -1,   744,   655,   745,    -1,   749,
      -1,  1317,    -1,   747,    -1,   517,   748,  1499,    -1,    -1,
     613,    -1,   746,    -1,  1501,    -1,   518,    -1,  1197,   198,
      -1,   516,    -1,   500,   751,   753,    -1,  1501,    -1,   747,
      -1,    -1,   751,    -1,    -1,   493,   754,    -1,   756,   166,
     755,    -1,   754,   655,   756,   166,   755,    -1,  1484,    -1,
    1222,    -1,  1490,    -1,    67,    -1,   541,    -1,    94,    -1,
      96,    -1,    95,    -1,    57,    -1,   481,    -1,   559,    -1,
      82,    -1,   113,    -1,   332,    -1,   349,    -1,   458,   752,
     753,    -1,   209,   759,   141,   760,    -1,    -1,   108,    -1,
     761,    -1,    90,   765,   766,    -1,   762,    -1,   761,   655,
     762,    -1,   763,   166,   764,    -1,  1501,    -1,   660,  1503,
      -1,   371,    -1,   477,    -1,   755,    -1,   767,    -1,   766,
     655,   767,    -1,   763,   166,   768,    -1,    67,    -1,   541,
      -1,    94,    -1,    96,    -1,    95,    -1,    57,    -1,   481,
      -1,   559,    -1,    82,    -1,   113,    -1,   332,    -1,   349,
      -1,   463,    -1,  1501,    -1,   769,   655,  1501,    -1,    -1,
     132,  1191,    -1,   774,    -1,   776,    -1,   772,    -1,   793,
      -1,   811,    -1,   813,    -1,   808,    -1,   778,    -1,   780,
      -1,   781,    -1,   782,    -1,   783,    -1,   785,    -1,    -1,
     234,   773,   788,   160,   234,    -1,    -1,   775,   668,    -1,
      -1,   466,   777,  1191,    -1,    -1,   779,   817,    -1,   271,
    1502,    -1,   259,  1502,    -1,   380,  1501,    -1,    -1,   188,
     786,  1501,   250,   784,   787,    -1,    70,  1501,    -1,    -1,
     360,   199,    -1,   199,    -1,  1501,    -1,   787,   655,  1501,
      -1,    -1,    -1,    -1,   789,  1191,   566,   790,   736,   791,
     792,    -1,    -1,   157,   788,    -1,   156,   736,    -1,   794,
      -1,   797,    -1,    -1,    -1,    55,   795,  1191,   796,   799,
     807,   160,    55,    -1,    -1,    55,   798,   800,   807,   160,
      55,    -1,   801,    -1,   799,   801,    -1,   804,    -1,   800,
     804,    -1,    -1,    -1,   627,   802,  1191,   803,   566,   736,
      -1,    -1,    -1,   627,   805,  1191,   806,   566,   736,    -1,
      -1,   156,   736,    -1,    -1,  1502,   662,   809,   817,   810,
      -1,    -1,  1502,    -1,    -1,  1502,   662,   812,   815,   810,
      -1,    -1,   814,   815,    -1,    -1,    33,   816,   737,   735,
     160,    -1,   293,   736,   160,   293,    -1,    -1,    -1,   629,
     818,  1191,   149,   819,   736,   160,   629,    -1,    -1,   453,
     736,   600,   820,  1191,   160,   453,    -1,    32,    -1,     9,
      -1,   246,    -1,   601,    -1,   136,    -1,   850,   852,    -1,
     850,    59,   847,   831,    -1,   850,     6,   847,   826,   835,
      -1,    -1,   607,   287,   213,  1501,    -1,   850,     6,   847,
     838,    -1,   850,   150,   847,   838,    -1,   851,   830,   841,
      -1,   851,   830,   844,    -1,     6,   848,    -1,     6,   849,
      -1,    -1,   832,   833,    -1,   834,    -1,   833,   834,    -1,
     833,   655,   834,    -1,   853,    -1,   854,    -1,   855,    -1,
     836,    -1,   837,    -1,   836,   837,    -1,   836,   655,   837,
      -1,   853,    -1,   854,    -1,   855,    -1,   856,    -1,   859,
      -1,   861,    -1,   863,    -1,   860,    -1,   839,    -1,   840,
      -1,   839,   840,    -1,   839,   655,   840,    -1,   853,    -1,
     854,    -1,   855,    -1,   861,    -1,   863,    -1,   842,    -1,
     843,    -1,   842,   843,    -1,   842,   655,   843,    -1,   853,
      -1,   857,    -1,   858,    -1,   859,    -1,   861,    -1,   863,
      -1,   860,    -1,   845,    -1,   846,    -1,   845,   846,    -1,
     845,   655,   846,    -1,   853,    -1,   861,    -1,   863,    -1,
     117,  1498,    -1,   590,  1498,    -1,   436,  1498,    -1,  1501,
      -1,  1501,    -1,   430,    -1,   432,    -1,   364,     4,    -1,
     242,  1371,   864,    -1,    26,  1371,   864,    -1,   321,  1371,
     864,    -1,   183,  1371,   864,    -1,   591,  1371,   864,    -1,
     437,  1371,   864,    -1,   361,  1371,  1318,    -1,    83,  1371,
    1498,    -1,  1414,   164,  1371,   941,    -1,    -1,   863,    -1,
     623,    -1,   367,    -1,  1320,    -1,  1497,    -1,    -1,   653,
     947,   654,   866,   934,   872,   869,    -1,   934,   872,   869,
      -1,    -1,   653,   922,   654,   867,  1601,    -1,   868,    -1,
     276,  1494,    -1,   653,   276,  1494,   654,    -1,    -1,    -1,
    1464,   925,   922,   870,  1598,    -1,    -1,  1464,   925,   653,
     922,   654,   871,  1601,    -1,   873,    -1,    -1,   874,    -1,
      -1,   400,   876,   875,   879,    -1,    -1,    -1,   400,   878,
     879,    -1,    49,   880,   890,   891,   898,    -1,   882,   263,
     883,   653,   884,   654,    -1,    -1,   882,   218,   881,   888,
      -1,   428,   888,    -1,   428,   887,    -1,   281,   888,    -1,
     281,   887,    -1,    -1,   278,    -1,    -1,    12,   166,  1318,
      -1,    -1,   885,    -1,   886,    -1,   885,   655,   886,    -1,
    1501,    -1,    75,   653,   884,   654,    -1,   653,  1185,   896,
    1186,   654,    -1,   653,  1185,   896,  1186,   654,    -1,    -1,
     401,  1318,    -1,    -1,    -1,   545,    49,   882,   218,   889,
     892,   897,    -1,    -1,   545,    49,   882,   263,   883,   653,
     894,   654,   893,   897,    -1,   895,    -1,   894,   655,   895,
      -1,  1501,    -1,  1194,    -1,    -1,   544,  1318,    -1,    -1,
     653,   899,   654,    -1,   900,    -1,   899,   655,   900,    -1,
      -1,   400,   901,   902,   903,   919,   914,    -1,  1501,    -1,
      -1,    -1,   612,   273,   565,   904,   906,    -1,    -1,   612,
     253,   905,   907,    -1,   325,    -1,   909,    -1,   909,    -1,
     653,   908,   654,    -1,   909,    -1,   908,   655,   909,    -1,
      -1,    -1,   653,   910,   912,   911,   654,    -1,   913,    -1,
     912,   655,   913,    -1,   325,    -1,  1194,    -1,    -1,   653,
     915,   654,    -1,   916,    -1,   915,   655,   916,    -1,    -1,
     545,   917,   918,   919,    -1,  1503,    -1,    -1,   920,    -1,
     920,   921,    -1,   921,    -1,   554,  1371,  1503,    -1,  1414,
     164,  1371,   941,    -1,    91,  1371,  1498,    -1,   361,  1371,
    1318,    -1,   320,  1371,  1320,    -1,   338,  1371,  1320,    -1,
     118,   142,  1371,  1498,    -1,   239,   142,  1371,  1498,    -1,
      83,  1371,  1498,    -1,    -1,    -1,   485,   923,  1179,  1183,
     924,   945,    -1,    -1,    20,    -1,    -1,   927,    -1,   928,
      -1,   927,   928,    -1,   940,    -1,   939,    -1,    -1,   930,
      -1,   931,    -1,   931,   930,    -1,   560,    -1,    -1,   234,
    1197,   178,    -1,   104,    -1,   104,   388,   454,    -1,    -1,
     936,    -1,   937,    -1,   937,   935,    -1,   937,    -1,   937,
     936,    -1,   937,   655,   936,    -1,   164,  1371,   941,    -1,
     320,  1371,  1319,    -1,   338,  1371,  1319,    -1,    29,  1371,
    1317,    -1,   403,  1371,  1498,    -1,    83,  1371,  1498,    -1,
      27,  1371,  1319,    -1,   393,  1371,  1317,    -1,   393,  1371,
     132,    -1,   531,  1371,  1317,    -1,   531,  1371,   132,    -1,
     532,  1371,  1317,    -1,   532,  1371,   132,    -1,   533,  1371,
    1317,    -1,   533,  1371,   132,    -1,    64,  1371,  1317,    -1,
     558,  1371,  1317,    -1,   395,  1371,  1323,    -1,   135,  1371,
    1317,    -1,   475,  1371,   943,    -1,    -1,   595,  1371,   938,
     653,  1437,   654,    -1,   939,    -1,   940,    -1,   247,  1371,
     944,    -1,   118,   142,  1371,  1498,    -1,   239,   142,  1371,
    1498,    -1,   554,  1501,    -1,   538,   145,    -1,   538,   330,
      -1,    91,  1371,  1498,    -1,   262,  1371,  1317,    -1,   577,
    1371,  1323,    -1,  1497,  1370,  1498,    -1,  1497,  1370,  1501,
      -1,  1497,  1370,  1320,    -1,  1497,  1370,   132,    -1,  1003,
     994,  1371,   996,    -1,  1003,    73,  1371,  1002,    -1,  1503,
      -1,  1503,    -1,   132,    -1,   191,    -1,   154,    -1,    88,
      -1,   438,    -1,    86,    -1,   394,    -1,   366,    -1,   190,
      -1,   266,    -1,  1310,    -1,  1178,  1182,    -1,   540,    -1,
     433,    -1,   130,    -1,   251,    -1,   948,    -1,   949,    -1,
     948,   655,   949,    -1,   950,    -1,   951,    -1,   960,   956,
      -1,   960,  1020,    -1,    -1,  1026,  1051,  1035,   653,  1048,
     654,   952,  1036,    -1,    -1,  1032,  1029,  1051,  1034,   653,
    1048,   654,   953,  1037,    -1,    -1,  1033,  1029,  1051,  1034,
     653,  1048,   654,   954,  1038,    -1,    -1,   958,  1027,  1051,
    1035,   653,  1048,   654,   955,  1036,    -1,   958,   196,   263,
    1051,   653,  1048,   654,  1020,    -1,   958,   957,    -1,    -1,
     957,    -1,    65,   653,  1191,   654,    -1,    -1,   959,    -1,
      93,  1050,    -1,    -1,  1493,   961,   962,    -1,   970,   988,
      -1,   970,   963,    20,   653,   969,   654,   964,   965,    -1,
      -1,   205,    15,    -1,    -1,   622,    -1,   404,    -1,    -1,
     966,    -1,   966,   967,    -1,   967,    -1,   596,    -1,   596,
     263,    -1,    83,  1498,    -1,   398,   653,   969,   654,    -1,
    1185,  1191,  1186,    -1,   978,   986,   982,    -1,   979,   987,
     982,    -1,   193,   980,   982,    -1,    41,    -1,    41,   985,
      -1,    46,    -1,    45,    -1,   974,   985,  1006,    -1,   974,
    1006,    -1,   975,   985,  1007,    -1,   975,  1007,    -1,    36,
     985,    -1,    36,    -1,   976,   985,  1006,    -1,   977,   985,
    1007,    -1,   614,   985,    -1,   641,   986,   982,    -1,   122,
      -1,   570,   986,    -1,   567,   986,    -1,   119,   986,    -1,
     571,    -1,    43,   986,    -1,   973,    -1,   326,    -1,   289,
      -1,   292,   614,    -1,   292,   976,  1006,    -1,   573,  1006,
      -1,   564,   986,  1006,    -1,   328,  1006,    -1,   290,  1006,
      -1,   130,   980,   982,    -1,   372,   980,   982,    -1,   191,
     980,   982,    -1,    -1,   165,   971,   653,  1053,   654,  1006,
      -1,    -1,   493,   972,   653,  1053,   654,  1006,    -1,   292,
    1006,    -1,   489,    -1,   207,    -1,   206,    -1,   408,    -1,
     346,    -1,   280,    -1,   345,    -1,   409,    -1,   347,    -1,
      62,    -1,   355,    -1,   352,    62,    -1,   974,   618,    -1,
     615,    -1,   352,   615,    -1,   373,    -1,   355,   615,    -1,
     352,    62,   618,    -1,   355,   618,    -1,   251,    -1,   572,
      -1,   507,    -1,   327,    -1,    35,    -1,   433,    -1,   148,
      -1,   148,   412,    -1,    -1,   985,    -1,   981,    -1,   653,
     370,   655,   370,   654,    -1,    -1,   983,    -1,   983,   984,
      -1,   984,    -1,   501,    -1,   599,    -1,   642,    -1,   653,
     291,   654,    -1,   653,   586,   654,    -1,   653,   129,   654,
      -1,   653,   370,   654,    -1,    -1,   985,    -1,    -1,   981,
      -1,    -1,   989,    -1,   989,   990,    -1,   990,    -1,   369,
      -1,  1197,   369,    -1,   132,   992,    -1,   376,   601,   365,
    1188,    -1,    27,    -1,   489,   132,   613,    -1,  1019,   263,
      -1,   596,    -1,   596,   263,    -1,    83,  1498,    -1,    73,
    1000,    -1,  1497,  1370,  1498,    -1,  1497,  1370,  1501,    -1,
    1497,  1370,  1320,    -1,  1497,  1370,   132,    -1,   970,  1001,
      -1,   365,  1188,    -1,  1483,    -1,   221,    -1,   222,    -1,
      62,   493,    -1,    61,    -1,  1503,    -1,    36,    -1,   995,
      -1,   132,    -1,    -1,   994,   996,    -1,  1503,    -1,    36,
      -1,   998,    -1,   132,    -1,  1503,    -1,    -1,    73,  1002,
      -1,  1000,    -1,   132,    -1,    -1,   132,    -1,    22,    -1,
      36,    22,    -1,    22,    36,    -1,   593,    -1,   593,    36,
      -1,    36,   593,    -1,    -1,  1004,    -1,  1005,    -1,    50,
      -1,   994,   995,  1007,    -1,    36,    -1,    36,   994,   995,
      -1,    -1,    36,    -1,    -1,   653,  1318,  1009,   654,    -1,
      21,    -1,   137,    -1,   467,    -1,    -1,  1010,    -1,  1010,
    1011,    -1,  1011,    -1,  1318,    -1,  1013,  1012,    -1,  1014,
      -1,  1015,   655,  1014,    -1,  1013,   646,  1013,    -1,  1015,
      -1,  1016,    -1,    -1,   274,  1017,    -1,    -1,   416,    -1,
     439,  1494,  1021,  1023,  1024,    -1,    -1,   653,  1022,   654,
      -1,  1022,   655,  1501,    -1,  1501,    -1,    -1,   317,   200,
      -1,   317,   399,    -1,   317,   502,    -1,    -1,   376,   601,
    1025,    -1,   376,   136,  1025,    -1,   376,   601,  1025,   376,
     136,  1025,    -1,   376,   136,  1025,   376,   601,  1025,    -1,
     461,    -1,    53,    -1,   493,   369,    -1,   366,     5,    -1,
     493,   132,    -1,  1028,    -1,   416,   263,    -1,   596,  1029,
      -1,   263,    -1,   239,    -1,    -1,  1028,    -1,   261,    -1,
     239,    -1,   238,    -1,    -1,   596,    -1,   201,    -1,   514,
      -1,    -1,  1034,    -1,  1034,  1042,    -1,    -1,  1039,    -1,
      -1,  1041,    -1,    -1,  1040,    -1,  1044,    -1,  1039,  1044,
      -1,  1045,    -1,  1040,  1045,    -1,  1046,    -1,  1041,  1046,
      -1,   608,  1047,    -1,   584,  1047,    -1,   262,  1371,  1317,
      -1,    83,  1498,    -1,  1497,  1370,  1498,    -1,  1497,  1370,
    1501,    -1,  1497,  1370,  1320,    -1,  1497,  1370,   132,    -1,
    1043,    -1,  1042,    -1,  1043,    -1,  1043,    -1,   630,   397,
    1497,    -1,    48,    -1,   478,    -1,   218,    -1,  1048,   655,
    1049,  1308,    -1,  1049,  1308,    -1,  1501,    -1,  1501,   653,
     370,   654,    -1,    -1,  1493,    -1,   932,  1050,    -1,    -1,
     661,  1501,    -1,  1481,    -1,  1053,   655,  1481,    -1,    -1,
      -1,    14,  1055,  1093,   557,  1494,  1056,  1067,    -1,    -1,
      14,   115,  1066,  1057,   927,    -1,    14,   115,  1501,   602,
     118,   142,   351,    -1,    -1,    14,   418,   716,  1058,   717,
      -1,    -1,    14,   202,   716,  1059,   717,    -1,    -1,    14,
    1622,  1619,  1060,  1624,    -1,    -1,    14,  1619,  1061,  1624,
      -1,    -1,    14,  1619,   173,   716,  1062,  1063,  1064,   706,
     711,  1065,    -1,    14,   554,   827,    -1,    14,   287,   213,
     829,    -1,    14,   554,   824,    -1,    14,   554,   823,    -1,
      14,   491,  1503,   382,   653,   700,   654,    -1,    -1,   376,
     480,   704,    -1,   710,    -1,   376,   480,   704,   710,    -1,
      -1,   449,   574,   716,    -1,    -1,   149,   712,    -1,    -1,
    1501,    -1,    -1,   144,   554,    -1,   237,   554,    -1,  1082,
     873,    -1,  1082,  1071,    -1,  1071,    -1,   874,    -1,  1073,
      -1,   150,   400,  1349,  1080,    -1,   434,   400,  1143,  1072,
      -1,    -1,   381,   400,  1143,  1072,  1068,  1143,    -1,    16,
     400,  1143,  1072,    -1,    -1,    65,   400,  1072,  1069,  1138,
      -1,    -1,   451,   400,  1143,  1072,  1070,  1119,    -1,    71,
     400,  1143,  1318,    -1,   582,   400,  1072,    -1,  1076,    -1,
     175,   400,  1081,   630,   557,  1494,   876,    -1,   448,   402,
      -1,    13,    -1,  1080,    -1,    -1,     6,   400,   932,  1143,
    1074,  1075,    -1,    -1,   653,   899,   654,    -1,   401,  1318,
      -1,    -1,   450,   400,  1143,  1077,  1078,    -1,    -1,    -1,
    1080,  1079,   250,   653,   899,   654,    -1,  1081,    -1,  1080,
     655,  1081,    -1,  1501,    -1,  1084,    -1,  1082,   655,  1084,
      -1,     6,  1091,   932,    -1,  1083,   950,  1099,    -1,     6,
     951,    -1,  1083,   653,   947,   654,    -1,    -1,    59,  1091,
    1349,  1493,  1085,   960,  1099,    -1,    -1,    -1,   342,  1091,
    1349,  1493,  1086,   962,  1087,  1099,    -1,   150,  1091,  1349,
    1493,  1098,    -1,   150,   196,   263,  1349,  1493,    -1,   150,
     416,   263,    -1,   150,  1028,  1349,  1493,    -1,   143,   261,
      -1,   158,   261,    -1,    14,  1091,  1493,   493,   132,  1483,
      -1,    14,  1091,  1493,   150,   132,    -1,   449,  1100,  1494,
      -1,   101,   574,   994,   996,  1001,    -1,   935,    -1,   195,
      -1,  1301,    -1,  1089,    -1,  1090,    -1,    -1,  1090,    -1,
    1089,    -1,  1090,  1089,    -1,  1089,  1090,    -1,    12,  1371,
     132,    -1,    12,  1371,  1501,    -1,   286,  1371,   132,    -1,
     286,  1371,  1501,    -1,    -1,    81,    -1,    -1,   235,    -1,
      -1,  1094,  1095,    -1,    -1,  1096,    -1,  1096,  1097,    -1,
    1097,    -1,   235,    -1,   379,    -1,    -1,   461,    -1,    53,
      -1,    -1,     9,  1501,    -1,   190,    -1,    -1,   574,    -1,
     166,    -1,    20,    -1,    -1,   530,   503,   687,  1108,  1102,
    1112,    -1,    -1,   530,    13,   504,  1108,  1103,    -1,   537,
     503,   687,  1108,    -1,   537,    13,   504,  1108,    -1,   530,
     576,  1105,    -1,    -1,  1106,    -1,  1107,    -1,  1106,   655,
    1107,    -1,   630,    92,   508,    -1,   431,   378,    -1,   431,
     635,    -1,    -1,  1109,  1110,    -1,  1111,    -1,  1110,   655,
    1111,    -1,    -1,   526,    -1,   445,    -1,    -1,   600,  1113,
      -1,   600,   297,   166,  1498,    -1,   686,    -1,  1113,   655,
     686,    -1,    -1,    64,  1538,  1115,  1344,  1116,    -1,    -1,
     427,    -1,   182,    -1,    -1,   451,  1143,  1538,  1118,  1344,
    1119,    -1,    -1,  1120,    -1,  1121,    -1,  1121,  1120,    -1,
     427,    -1,   182,    -1,   606,    -1,    -1,    16,  1143,  1538,
    1123,  1124,    -1,  1125,    -1,  1124,   655,  1125,    -1,  1345,
    1126,    -1,    -1,   404,   197,  1127,    -1,    13,    -1,    75,
    1128,   238,  1130,    -1,    13,    -1,    -1,   653,  1129,  1132,
     654,    -1,    13,    -1,    -1,   653,  1131,  1133,   654,    -1,
      -1,  1501,    -1,  1132,   655,  1501,    -1,    -1,  1134,    -1,
    1133,   655,  1134,    -1,  1501,    -1,   416,    -1,    37,  1498,
      -1,    -1,    65,  1538,  1137,  1344,  1138,    -1,    -1,  1139,
      -1,  1140,    -1,  1140,  1139,    -1,   427,    -1,   186,    -1,
     329,    -1,   182,    -1,    60,    -1,   197,   602,    -1,    -1,
     381,  1143,  1538,  1142,  1344,    -1,    -1,   368,    -1,   283,
      -1,    -1,   449,  1538,  1145,  1147,    -1,   449,   604,   715,
    1146,    -1,  1506,   574,  1506,    -1,  1146,   655,  1506,   574,
    1506,    -1,  1148,    -1,  1147,   655,  1148,    -1,  1494,   574,
    1494,    -1,    -1,    51,   239,  1150,  1151,   253,  1155,    -1,
    1152,    -1,  1154,    -1,  1153,    -1,  1152,   655,  1153,    -1,
    1494,  1164,    -1,  1494,  1162,  1164,    -1,  1501,    -1,   132,
      -1,    -1,   282,   239,   250,    51,  1157,  1158,    -1,  1161,
      -1,  1159,    -1,  1160,    -1,  1159,   655,  1160,    -1,  1494,
    1164,  1167,    -1,  1494,  1162,  1164,  1167,    -1,    -1,   400,
     876,  1163,   653,  1072,   654,    -1,    -1,  1165,  1166,    -1,
      -1,  1028,   653,  1283,   654,    -1,    -1,   235,   270,    -1,
    1169,    -1,   485,  1172,    -1,   653,  1170,   654,  1601,    -1,
     485,  1174,    -1,   653,  1170,   654,    -1,   485,  1262,    -1,
     653,  1171,   654,    -1,    -1,  1174,  1173,  1598,    -1,    -1,
      -1,  1175,  1179,  1183,  1176,  1177,  1182,    -1,  1304,  1310,
      -1,  1333,    -1,  1178,    -1,  1333,  1178,    -1,  1178,  1333,
      -1,   199,  1242,  1293,  1298,  1295,  1304,  1310,  1324,    -1,
     199,   151,  1293,  1310,    -1,    -1,  1180,    -1,  1180,  1181,
      -1,  1181,    -1,  1615,    -1,   523,    -1,   521,    -1,    -1,
     197,   601,    -1,   286,   253,   495,   340,    -1,  1183,   655,
    1184,    -1,  1184,    -1,   648,    -1,  1185,  1488,  1186,    -1,
    1185,  1191,  1186,  1187,    -1,    -1,    -1,    -1,    20,  1501,
      -1,    20,  1498,    -1,  1501,    -1,  1498,    -1,    -1,   653,
     654,    -1,   653,  1318,   654,    -1,    -1,   653,   654,    -1,
     653,  1318,   654,    -1,    -1,   653,   654,    -1,  1191,  1195,
    1191,    -1,  1191,   639,  1191,    -1,  1191,  1196,  1191,    -1,
     364,  1191,    -1,  1192,   256,   581,    -1,  1192,   256,  1197,
     581,    -1,  1192,   256,   185,    -1,  1192,   256,  1197,   185,
      -1,  1192,   256,   597,    -1,  1192,   256,  1197,   597,    -1,
    1192,    -1,  1192,   256,   369,    -1,  1192,   256,  1197,   369,
      -1,  1192,   167,  1193,    -1,  1192,  1199,  1193,    -1,  1192,
    1199,  1200,   653,  1610,   654,    -1,  1193,    -1,  1194,   253,
     653,  1610,   654,    -1,  1194,  1197,   253,   653,  1610,   654,
      -1,  1194,   253,   653,  1191,   654,    -1,  1194,   253,   653,
    1191,   655,  1235,   654,    -1,  1194,  1197,   253,   653,  1191,
     654,    -1,  1194,  1197,   253,   653,  1191,   655,  1235,   654,
      -1,  1194,    34,  1194,    18,  1193,    -1,  1194,  1197,    34,
    1194,    18,  1193,    -1,  1194,   512,   276,  1194,    -1,  1194,
     276,  1205,  1297,    -1,  1194,  1197,   276,  1205,  1297,    -1,
    1194,   440,  1194,    -1,  1194,  1197,   440,  1194,    -1,  1194,
      -1,  1194,   644,  1194,    -1,  1194,   645,  1194,    -1,  1194,
     496,  1194,    -1,  1194,   497,  1194,    -1,  1194,   647,  1194,
      -1,  1194,   646,  1194,    -1,  1194,   647,   249,  1191,  1287,
      -1,  1194,   646,   249,  1191,  1287,    -1,  1194,   648,  1194,
      -1,  1194,   649,  1194,    -1,  1194,   650,  1194,    -1,  1194,
     147,  1194,    -1,  1194,   343,  1194,    -1,  1194,   651,  1194,
      -1,  1205,    -1,   388,    -1,   385,    -1,    18,    -1,    17,
      -1,   364,    -1,   363,    -1,   656,    -1,   363,    -1,   166,
      -1,   203,    -1,   215,    -1,   268,    -1,   295,    -1,   357,
      -1,    13,    -1,    19,    -1,    -1,    20,  1202,    -1,   251,
      -1,   599,   251,    -1,   148,    -1,   433,    -1,   193,    -1,
     130,   980,    -1,   974,  1006,    -1,   975,    -1,   122,    -1,
     570,   986,    -1,   119,   986,    -1,  1191,   655,  1191,  1201,
      -1,  1203,    -1,  1204,   655,  1203,    -1,  1490,    -1,  1206,
      -1,  1207,    -1,  1210,    -1,  1208,    -1,  1205,    73,  1503,
      -1,  1484,    -1,  1482,    -1,  1222,    -1,  1218,    -1,  1205,
     387,  1205,    -1,   647,  1205,    -1,   646,  1205,    -1,   652,
    1205,    -1,  1198,  1205,    -1,   653,  1610,   654,    -1,   653,
    1191,   654,    -1,   653,  1191,   655,  1235,   654,    -1,   476,
     653,  1191,   655,  1235,   654,    -1,   178,   653,  1610,   654,
      -1,   657,  1501,  1191,   658,    -1,   317,  1236,    10,   653,
    1194,  1212,   654,    -1,    36,  1205,    -1,    56,   653,  1191,
      20,  1232,   654,    -1,    55,  1238,  1240,  1239,   160,    -1,
     101,   653,  1191,   655,  1232,   654,    -1,   101,   653,  1191,
     608,   995,   654,    -1,   132,   653,  1490,   654,    -1,   612,
     653,  1491,   654,    -1,   249,  1191,  1287,   647,  1191,    -1,
      62,   653,  1235,   654,    -1,    62,   653,  1235,   608,   995,
     654,    -1,   109,  1190,    -1,   110,  1190,    -1,   122,   653,
    1191,   654,    -1,   127,   653,  1191,   654,    -1,   229,   653,
    1191,   654,    -1,   246,   653,  1191,   655,  1191,   655,  1191,
     655,  1191,   654,    -1,   249,   653,  1191,   655,  1191,   654,
      -1,   249,   653,  1191,   655,  1191,   655,  1235,   654,    -1,
     272,   653,  1191,   655,  1191,   654,    -1,   337,   653,  1191,
     654,    -1,   344,   653,  1191,   654,    -1,   469,   653,  1191,
     655,  1191,   654,    -1,   483,   653,  1191,   654,    -1,   570,
     653,  1191,   654,    -1,   567,   653,  1191,   654,    -1,   567,
     653,  1191,   655,  1191,   654,    -1,   580,   653,  1191,   654,
      -1,   580,   653,   269,  1191,   199,  1191,   654,    -1,   580,
     653,   575,  1191,   199,  1191,   654,    -1,   580,   653,    47,
    1191,   199,  1191,   654,    -1,   580,   653,   269,   199,  1191,
     654,    -1,   580,   653,   575,   199,  1191,   654,    -1,   580,
     653,    47,   199,  1191,   654,    -1,   580,   653,  1191,   199,
    1191,   654,    -1,   604,   653,   654,    -1,   641,   653,  1191,
     654,    -1,     8,   653,  1191,   655,  1191,   654,    -1,     8,
     653,  1191,   655,   249,  1191,  1287,   654,    -1,   107,  1190,
      -1,   114,  1189,    -1,   120,   653,  1191,   655,   249,  1191,
    1287,   654,    -1,   121,   653,  1191,   655,   249,  1191,  1287,
     654,    -1,   184,   653,  1287,   199,  1191,   654,    -1,   208,
     653,  1289,   655,  1191,   654,    -1,   365,  1189,    -1,   411,
     653,  1194,   253,  1191,   654,    -1,   542,   653,  1191,   655,
    1191,   654,    -1,   542,   653,  1191,   655,   249,  1191,  1287,
     654,    -1,   546,   653,  1191,   655,  1191,   655,  1191,   654,
      -1,   546,   653,  1191,   655,  1191,   654,    -1,   546,   653,
    1191,   199,  1191,   197,  1191,   654,    -1,   546,   653,  1191,
     199,  1191,   654,    -1,   552,  1189,    -1,   568,   653,  1288,
     655,  1191,   655,  1191,   654,    -1,   569,   653,  1288,   655,
    1191,   655,  1191,   654,    -1,   609,  1190,    -1,   611,  1189,
      -1,   610,  1189,    -1,    76,   653,  1191,   655,  1204,   654,
      -1,    79,   653,  1191,   655,  1235,   654,    -1,    77,   653,
    1191,   654,    -1,    78,   653,  1204,   654,    -1,    80,   653,
    1191,   655,  1191,    20,  1232,   654,    -1,    22,   653,  1191,
     654,    -1,    61,   653,  1191,   654,    -1,    71,   653,  1235,
     654,    -1,    74,   653,  1191,   654,    -1,   115,   653,   654,
      -1,   234,   653,  1191,   655,  1191,   655,  1191,   654,    -1,
     267,   653,  1235,   654,    -1,   333,   653,  1191,   654,    -1,
     343,   653,  1191,   655,  1191,   654,    -1,   375,   653,  1191,
     654,    -1,   403,   653,  1191,   654,    -1,   425,   653,  1191,
     654,    -1,   453,   653,  1191,   655,  1191,   654,    -1,   454,
     653,  1191,   655,  1191,   655,  1191,   654,    -1,   467,   653,
    1191,   654,    -1,   477,   653,   654,    -1,   582,   653,  1191,
     655,  1191,   654,    -1,   625,   653,  1191,   654,    -1,   625,
     653,  1191,   655,  1191,   654,    -1,   626,   653,  1191,  1018,
     654,    -1,   626,   653,  1191,    20,    62,  1008,  1018,   654,
      -1,   626,   653,  1191,    20,    36,  1008,   654,    -1,   626,
     653,  1191,   655,  1317,   655,  1317,   655,  1317,   654,    -1,
    1209,    -1,    97,   653,  1191,   655,  1191,   654,    -1,   206,
     653,  1235,   654,    -1,   280,   653,  1235,   654,    -1,   345,
     653,  1235,   654,    -1,   346,   653,  1235,   654,    -1,   347,
     653,  1235,   654,    -1,   408,   653,  1191,   655,  1191,   654,
      -1,   409,   653,  1235,   654,    -1,    -1,  1497,   653,  1211,
    1215,   654,    -1,  1501,   661,  1501,   653,  1234,   654,    -1,
    1213,  1214,    -1,   253,    45,   340,    -1,    -1,   253,   353,
     265,   340,    -1,    -1,   630,   426,   180,    -1,    -1,  1216,
      -1,  1217,    -1,  1216,   655,  1217,    -1,  1185,  1191,  1186,
    1187,    -1,    30,   653,  1230,   654,    -1,    30,   653,   146,
    1230,   654,    -1,    39,   653,  1230,   654,    -1,    40,   653,
    1230,   654,    -1,    42,   653,  1230,   654,    -1,   102,   653,
    1292,   648,   654,    -1,   102,   653,  1230,   654,    -1,    -1,
      -1,   102,   653,   146,  1219,  1235,  1220,   654,    -1,   339,
     653,  1230,   654,    -1,   339,   653,   146,  1230,   654,    -1,
     322,   653,  1230,   654,    -1,   322,   653,   146,  1230,   654,
      -1,   536,   653,  1230,   654,    -1,   617,   653,  1230,   654,
      -1,   535,   653,  1230,   654,    -1,   619,   653,  1230,   654,
      -1,   547,   653,  1230,   654,    -1,   547,   653,   146,  1230,
     654,    -1,    -1,   214,   653,  1225,  1221,  1235,  1227,  1226,
     654,    -1,    -1,   660,  1223,  1224,    -1,  1503,   494,  1191,
      -1,  1503,    -1,   660,  1525,  1503,  1052,    -1,    -1,   146,
      -1,    -1,   487,  1481,    -1,    -1,    -1,   386,    49,  1228,
    1229,    -1,  1229,   655,  1489,  1308,    -1,  1489,  1308,    -1,
      -1,  1292,  1231,  1191,    -1,    36,   986,    -1,    62,   986,
    1006,    -1,   355,   986,    -1,   251,    -1,   501,    -1,   501,
     251,    -1,   599,    -1,   599,   251,    -1,   122,    -1,   570,
     986,    -1,   119,   986,    -1,   130,   980,    -1,    -1,   148,
    1233,   987,    -1,    -1,  1235,    -1,  1191,    -1,  1235,   655,
    1191,    -1,  1237,    -1,   653,  1237,   654,    -1,  1490,    -1,
    1237,   655,  1490,    -1,    -1,  1191,    -1,    -1,   156,  1191,
      -1,   627,  1191,   566,  1191,    -1,  1240,   627,  1191,   566,
    1191,    -1,  1256,    -1,  1245,    -1,  1244,    -1,  1241,    -1,
     657,  1501,  1241,   658,    -1,  1243,    -1,  1244,   655,  1243,
      -1,  1241,  1253,  1241,    -1,    -1,  1241,  1253,  1241,   376,
    1246,  1191,    -1,    -1,  1241,  1253,  1241,   608,  1247,   653,
    1286,   654,    -1,  1241,   353,  1252,  1256,    -1,    -1,  1241,
     272,  1272,   260,  1241,   376,  1248,  1191,    -1,    -1,  1241,
     272,  1272,   260,  1256,  1249,   608,   653,  1286,   654,    -1,
    1241,   353,   272,  1272,   260,  1256,    -1,    -1,  1241,   469,
    1272,   260,  1241,   376,  1250,  1191,    -1,    -1,  1241,   469,
    1272,   260,  1256,  1251,   608,   653,  1286,   654,    -1,  1241,
     353,   469,  1272,   260,  1256,    -1,   260,    -1,   243,   260,
      -1,   539,    -1,  1252,    -1,   105,   260,    -1,    -1,  1255,
      -1,   400,   653,  1286,   654,   876,    -1,    -1,  1257,  1494,
    1254,  1291,  1281,    -1,  1271,  1270,  1267,    -1,   653,  1270,
    1258,   654,  1291,    -1,  1265,  1602,    -1,    -1,    -1,  1258,
     595,  1606,  1259,  1607,  1260,  1602,    -1,  1262,    -1,    -1,
      -1,  1263,  1613,  1183,  1264,   945,  1182,    -1,    -1,  1270,
    1266,  1244,    -1,    -1,    -1,  1268,  1179,  1183,  1269,   945,
      -1,    -1,   485,    -1,    -1,   389,    -1,    -1,   197,   260,
      -1,   197,   386,    49,    -1,   197,   213,    49,    -1,   195,
      -1,   235,    -1,    -1,  1274,  1028,  1273,  1276,   653,  1285,
     654,    -1,    -1,   607,  1028,  1273,  1277,   653,  1283,   654,
      -1,  1275,    -1,  1278,  1275,    -1,    -1,    -1,  1280,  1278,
      -1,    -1,  1282,  1279,    -1,    -1,  1285,    -1,  1501,    -1,
     416,    -1,  1284,    -1,  1285,   655,  1284,    -1,  1501,    -1,
    1286,   655,  1501,    -1,  1288,    -1,   123,    -1,   124,    -1,
     125,    -1,   126,    -1,   226,    -1,   227,    -1,   228,    -1,
     335,    -1,   336,    -1,   482,    -1,   640,    -1,   127,    -1,
     625,    -1,   229,    -1,   337,    -1,   344,    -1,   425,    -1,
     483,    -1,   333,    -1,   641,    -1,   122,    -1,   570,    -1,
     119,    -1,   567,    -1,    -1,    20,    -1,   166,    -1,    -1,
    1290,  1501,    -1,    -1,    13,    -1,    -1,    -1,   628,  1294,
    1191,    -1,    -1,    -1,   219,  1296,  1191,    -1,   171,  1205,
      -1,    -1,    -1,   213,    49,  1299,  1300,    -1,  1299,   655,
    1489,  1308,    -1,  1489,  1308,    -1,    -1,   631,    -1,   632,
      -1,   386,    49,  1302,    -1,  1302,   655,  1303,    -1,  1303,
      -1,  1491,  1308,    -1,    -1,  1305,    -1,    -1,   386,    49,
    1306,  1307,    -1,  1307,   655,  1489,  1308,    -1,  1489,  1308,
      -1,    -1,    21,    -1,   137,    -1,    -1,  1311,    -1,    -1,
    1311,    -1,   277,  1312,    -1,   277,  1312,   474,   176,  1314,
      -1,   277,   474,   176,  1314,    -1,  1313,    -1,  1313,   655,
    1313,    -1,  1313,   374,  1313,    -1,  1501,    -1,  1482,    -1,
     586,    -1,   291,    -1,   370,    -1,  1313,    -1,    -1,   277,
    1313,    -1,   277,   474,   176,    -1,   277,  1313,   474,   176,
      -1,   370,    -1,   646,   370,    -1,   646,   291,    -1,   370,
      -1,   221,    -1,   291,    -1,   586,    -1,   129,    -1,   192,
      -1,   370,    -1,   221,    -1,   291,    -1,   586,    -1,  1321,
      -1,   370,    -1,   586,    -1,   291,    -1,   129,    -1,   192,
      -1,   370,    -1,   586,    -1,   221,    -1,   291,    -1,  1321,
      -1,  1322,    -1,   129,    -1,   192,    -1,  1317,    -1,   132,
      -1,    -1,    -1,   418,  1501,  1325,   653,  1326,   654,    -1,
      -1,  1327,    -1,  1327,   655,  1328,    -1,  1328,    -1,  1185,
    1191,  1186,    -1,    -1,  1330,  1331,    -1,  1331,   655,  1332,
      -1,  1332,    -1,   660,  1503,    -1,  1503,    -1,    -1,   250,
    1334,  1335,    -1,    -1,    -1,   390,  1500,  1336,   997,  1337,
    1465,  1468,    -1,   152,  1500,    -1,  1329,    -1,    -1,   149,
    1339,  1235,    -1,    -1,   150,  1350,  1538,  1349,  1341,  1344,
    1098,    -1,    -1,   150,   239,  1349,  1501,   376,  1494,  1342,
      -1,   150,   115,  1349,  1501,    -1,   150,   202,  1349,  1501,
     661,  1501,    -1,   150,   202,  1349,  1501,    -1,   150,   418,
    1349,   716,    -1,   150,   604,   715,  1574,    -1,   150,   470,
     715,  1558,    -1,    -1,   150,   621,  1349,  1343,  1344,  1098,
      -1,   150,   173,  1349,   716,    -1,   150,   579,  1349,   716,
      -1,   150,   554,   850,   861,   862,    -1,   150,   287,   213,
     851,   861,   862,    -1,   150,   491,  1349,  1503,    -1,  1345,
      -1,  1344,   655,  1345,    -1,  1494,    -1,  1494,  1254,    -1,
    1348,    -1,  1347,   655,  1348,    -1,  1495,    -1,    -1,   234,
     178,    -1,    -1,   560,    -1,    -1,    -1,   246,  1352,  1357,
    1092,  1359,  1353,  1361,  1377,    -1,    -1,    -1,   454,  1355,
    1358,  1359,  1356,  1361,    -1,    -1,   294,    -1,   134,    -1,
     223,    -1,  1386,    -1,   134,    -1,   250,  1360,    -1,  1360,
      -1,  1346,    -1,  1364,    -1,   653,   654,  1364,    -1,   653,
    1363,   654,  1364,    -1,    -1,   493,  1362,  1368,    -1,  1363,
     655,  1487,    -1,  1487,    -1,   612,  1367,    -1,   613,  1367,
      -1,    -1,   922,  1365,  1598,    -1,    -1,   653,   922,   654,
    1366,  1601,    -1,  1367,   655,  1372,    -1,  1372,    -1,  1368,
     655,  1369,    -1,  1369,    -1,  1491,  1370,  1376,    -1,   166,
      -1,   494,    -1,    -1,  1370,    -1,    -1,   653,  1373,  1374,
     654,    -1,    -1,  1375,    -1,  1375,   655,  1376,    -1,  1376,
      -1,  1191,    -1,   132,    -1,    -1,    -1,   376,   153,  1378,
     263,   601,  1384,    -1,    -1,    -1,   601,  1380,  1386,  1092,
    1242,   493,  1382,  1381,  1293,  1304,  1315,    -1,  1382,   655,
    1383,    -1,  1383,    -1,  1491,  1370,  1376,    -1,  1384,   655,
    1385,    -1,  1385,    -1,  1491,  1370,  1376,    -1,    -1,   294,
      -1,    -1,   136,  1388,  1398,  1389,    -1,    -1,    -1,   199,
    1494,  1254,  1390,  1293,  1304,  1315,  1391,  1394,    -1,    -1,
    1395,  1392,   199,  1242,  1293,    -1,    -1,   199,  1347,  1393,
     608,  1242,  1293,    -1,    -1,   464,  1183,    -1,  1396,    -1,
    1395,   655,  1396,    -1,  1501,  1397,    -1,  1501,   661,  1501,
    1397,    -1,    -1,   661,   648,    -1,    -1,  1399,  1398,    -1,
     427,    -1,   294,    -1,   235,    -1,    -1,   582,  1402,  1401,
    1345,    -1,    -1,   557,    -1,    -1,  1404,    -1,  1405,    -1,
    1404,   655,  1405,    -1,   103,    -1,   330,    -1,    44,   254,
      -1,    98,   551,    -1,   394,   187,    -1,   255,    -1,   550,
      -1,   513,    -1,    13,    -1,    -1,   197,   426,   370,    -1,
      -1,   498,  1408,  1409,    -1,   116,  1420,    -1,  1416,   553,
    1415,  1420,    -1,  1416,   578,  1415,  1420,    -1,   172,  1415,
    1420,    -1,   557,   534,  1415,  1420,    -1,   380,   553,  1415,
    1420,    -1,   406,    -1,   406,   511,  1498,    -1,   406,   511,
    1420,    -1,   164,   942,  1412,    -1,   164,    13,  1412,    -1,
    1416,    75,  1417,  1494,  1415,  1420,    -1,  1413,   288,    -1,
     503,   225,    -1,    -1,    37,   172,  1418,  1419,  1410,  1309,
      -1,    -1,   442,   687,   172,  1418,  1419,  1411,  1309,    -1,
    1030,  1417,  1494,  1415,  1293,    -1,  1414,   163,    -1,    25,
      -1,   100,    -1,   417,    -1,   102,   653,   648,   654,   624,
      -1,   102,   653,   648,   654,   169,    -1,   624,  1309,    -1,
     169,  1309,    -1,   422,    -1,   421,  1403,  1406,  1309,    -1,
    1524,   534,  1420,    -1,  1416,   420,    -1,  1524,   616,  1420,
      -1,   994,  1420,    -1,    74,  1420,    -1,   212,    -1,   212,
     197,  1505,    -1,   104,   115,   932,  1501,    -1,   104,   557,
    1494,    -1,   104,   621,  1494,    -1,   313,   534,    -1,    13,
     504,   534,    -1,   503,   534,    -1,   503,   688,   534,    -1,
      69,    -1,   605,    -1,   556,    -1,   240,    -1,   104,   418,
     716,    -1,   104,   202,   716,    -1,   104,   579,   716,    -1,
     418,   534,  1420,    -1,   202,   534,  1420,    -1,   418,    72,
     716,    -1,   202,    72,   716,    -1,   104,   173,   716,    -1,
    1425,   197,  1191,    -1,   534,    -1,   348,    -1,   288,    -1,
     313,    -1,    36,    -1,    -1,   538,    -1,    -1,  1417,  1501,
      -1,    -1,   200,    -1,   199,    -1,   253,    -1,    -1,   253,
    1498,    -1,    -1,   199,  1319,    -1,    -1,   276,  1498,    -1,
     628,  1191,    -1,    -1,  1425,  1494,  1422,  1427,    -1,    -1,
    1425,  1426,  1423,  1424,    -1,  1168,    -1,  1351,    -1,  1354,
      -1,  1379,    -1,  1387,    -1,   137,    -1,   138,    -1,    -1,
     182,    -1,   401,    -1,    -1,  1481,    -1,  1501,    -1,    -1,
     194,  1143,  1429,  1430,    -1,    -1,  1538,  1431,  1437,  1432,
      -1,  1435,    -1,    -1,  1433,    -1,   630,   431,   286,  1438,
      -1,    -1,   197,  1434,   181,    -1,  1435,   655,  1436,    -1,
    1436,    -1,   168,   288,    -1,   164,   288,    -1,   204,   288,
      -1,   506,   288,    -1,    36,   288,    -1,   441,   288,   687,
      -1,   426,    51,    -1,   225,    -1,   417,    -1,   288,    -1,
     534,    -1,   503,   687,    -1,    69,    -1,   605,    -1,   556,
      -1,   240,    -1,   313,    -1,   139,    -1,   459,    -1,    -1,
    1344,    -1,    -1,    18,   143,    63,    -1,    -1,   457,  1440,
    1441,    -1,  1441,   655,  1442,    -1,  1442,    -1,    -1,   503,
    1443,   687,  1444,    -1,   313,    -1,   426,    51,    -1,    -1,
      13,    -1,    -1,   424,  1446,  1447,    -1,  1413,   288,  1448,
      -1,   574,  1498,    -1,    32,  1191,    -1,    -1,   264,  1450,
    1451,  1452,  1453,    -1,    -1,   217,    -1,   510,    -1,    -1,
      91,    -1,   426,    -1,   426,   230,    -1,  1191,    -1,   604,
    1506,    -1,   499,    -1,   607,  1501,    -1,    -1,    -1,    -1,
      -1,   282,  1461,  1457,  1463,  1462,   241,  1500,  1458,  1464,
     250,   557,  1494,  1254,  1459,   997,  1460,  1471,  1465,  1468,
    1472,  1474,  1477,    -1,   118,    -1,   638,    -1,    -1,   283,
      -1,    -1,    89,    -1,   294,    -1,    -1,   454,    -1,   235,
      -1,    -1,    75,  1466,    -1,  1466,  1467,    -1,  1467,    -1,
     562,    49,  1481,    -1,   384,   159,    49,  1481,    -1,   159,
      49,  1481,    -1,   170,    49,  1481,    -1,    -1,   279,  1469,
      -1,  1469,  1470,    -1,  1470,    -1,   562,    49,  1481,    -1,
     528,    49,  1481,    -1,    -1,   474,   232,    49,  1481,    -1,
      -1,   235,   370,  1473,    -1,   279,    -1,   474,    -1,    -1,
     653,  1475,   654,    -1,   653,   654,    -1,  1475,   655,  1476,
      -1,  1476,    -1,  1491,    -1,   660,  1503,    -1,    -1,   493,
    1478,    -1,  1478,   655,  1479,    -1,  1479,    -1,  1491,  1370,
    1185,  1376,  1186,    -1,   563,    -1,   354,    -1,   589,   563,
      -1,  1480,  1499,    -1,  1499,    -1,   221,    -1,   222,    -1,
      38,    -1,   396,    -1,  1484,    -1,   647,  1485,    -1,   646,
    1485,    -1,  1480,    -1,  1485,    -1,  1486,    -1,   369,    -1,
     185,    -1,   581,    -1,   221,    -1,   222,    -1,    38,    -1,
     589,   993,    -1,   589,    38,    -1,   370,    -1,   291,    -1,
     586,    -1,   129,    -1,   192,    -1,   122,   563,    -1,   570,
     563,    -1,   567,   563,    -1,  1491,    -1,  1488,    -1,  1501,
     661,   648,    -1,  1501,   661,  1501,   661,   648,    -1,  1191,
      -1,  1501,    -1,  1492,    -1,  1501,    -1,  1492,    -1,  1501,
     661,  1501,    -1,   661,  1501,   661,  1501,    -1,  1501,   661,
    1501,   661,  1501,    -1,  1501,    -1,  1501,   661,  1501,   661,
    1501,    -1,  1501,   661,  1501,    -1,   661,  1501,    -1,  1501,
      -1,  1501,   661,  1501,    -1,   661,  1501,    -1,  1501,  1397,
      -1,  1501,   661,  1501,  1397,    -1,  1501,    -1,   231,    -1,
     233,    -1,   563,    -1,   563,    -1,   563,    -1,  1497,    -1,
    1507,    -1,  1497,    -1,  1508,    -1,  1501,    -1,  1498,    -1,
     275,    -1,  1503,    -1,  1503,   660,  1503,    -1,   109,  1190,
      -1,  1504,    -1,  1559,    -1,  1504,    -1,  1508,    -1,    22,
      -1,    31,    -1,    33,    -1,    50,    -1,    51,    -1,    61,
      -1,    64,    -1,    63,    -1,    70,    -1,    76,    -1,    77,
      -1,    78,    -1,    79,    -1,    80,    -1,    83,    -1,    85,
      -1,    97,    -1,   128,    -1,   149,    -1,   160,    -1,   176,
      -1,   177,    -1,   194,    -1,   209,    -1,   216,    -1,   220,
      -1,   224,    -1,   248,    -1,   265,    -1,   366,    -1,   380,
      -1,   383,    -1,   382,    -1,   392,    -1,   397,    -1,   410,
      -1,   413,    -1,   448,    -1,   451,    -1,   457,    -1,   460,
      -1,   471,    -1,   479,    -1,   484,    -1,   491,    -1,   499,
      -1,   501,    -1,   509,    -1,   503,    -1,   504,    -1,   511,
      -1,   530,    -1,   537,    -1,   582,    -1,   593,    -1,   594,
      -1,   634,    -1,   637,    -1,   602,    -1,     5,    -1,     8,
      -1,     7,    -1,     9,    -1,    10,    -1,    11,    -1,    12,
      -1,    15,    -1,    19,    -1,    24,    -1,    25,    -1,    27,
      -1,    26,    -1,    28,    -1,    29,    -1,    30,    -1,    37,
      -1,    41,    -1,    44,    -1,    46,    -1,    45,    -1,    48,
      -1,    54,    -1,    57,    -1,    58,    -1,    60,    -1,    66,
      -1,    69,    -1,    68,    -1,    67,    -1,    71,    -1,    72,
      -1,    74,    -1,    82,    -1,    75,    -1,    84,    -1,    86,
      -1,    87,    -1,    88,    -1,    89,    -1,    91,    -1,    92,
      -1,    94,    -1,    96,    -1,    95,    -1,    98,    -1,   100,
      -1,   111,    -1,   103,    -1,   106,    -1,   108,    -1,   113,
      -1,   118,    -1,   117,    -1,   119,    -1,   122,    -1,   127,
      -1,   133,    -1,   135,    -1,   139,    -1,   141,    -1,   142,
      -1,   143,    -1,   144,    -1,   145,    -1,   152,    -1,   153,
      -1,   154,    -1,   161,    -1,   165,    -1,   164,    -1,   163,
      -1,   168,    -1,   169,    -1,   171,    -1,   173,    -1,   172,
      -1,   174,    -1,   175,    -1,   180,    -1,   181,    -1,   182,
      -1,   183,    -1,   187,    -1,   186,    -1,   198,    -1,   158,
      -1,   200,    -1,   189,    -1,   190,    -1,   191,    -1,   204,
      -1,   205,    -1,   207,    -1,   206,    -1,   208,    -1,   212,
      -1,   210,    -1,   218,    -1,   217,    -1,   225,    -1,   229,
      -1,   230,    -1,   232,    -1,   236,    -1,   240,    -1,   252,
      -1,   237,    -1,   238,    -1,   242,    -1,   254,    -1,   255,
      -1,   257,    -1,   258,    -1,   247,    -1,   262,    -1,   267,
      -1,   266,    -1,   270,    -1,   273,    -1,   274,    -1,   280,
      -1,   281,    -1,   283,    -1,   285,    -1,   287,    -1,   288,
      -1,   320,    -1,   313,    -1,   316,    -1,   297,    -1,   298,
      -1,   302,    -1,   299,    -1,   300,    -1,   314,    -1,   315,
      -1,   301,    -1,   303,    -1,   296,    -1,   311,    -1,   305,
      -1,   304,    -1,   306,    -1,   307,    -1,   308,    -1,   309,
      -1,   310,    -1,   318,    -1,   319,    -1,   321,    -1,   323,
      -1,   324,    -1,   329,    -1,   330,    -1,   331,    -1,   332,
      -1,   333,    -1,   334,    -1,   337,    -1,   338,    -1,   342,
      -1,   340,    -1,   344,    -1,   345,    -1,   346,    -1,   347,
      -1,   348,    -1,   349,    -1,   351,    -1,   350,    -1,   352,
      -1,   355,    -1,   356,    -1,   360,    -1,   359,    -1,   367,
      -1,   361,    -1,   362,    -1,   371,    -1,   373,    -1,   374,
      -1,   375,    -1,   377,    -1,   379,    -1,   378,    -1,   393,
      -1,   394,    -1,   399,    -1,   402,    -1,   401,    -1,   403,
      -1,   404,    -1,   405,    -1,   407,    -1,   406,    -1,   408,
      -1,   409,    -1,   414,    -1,   415,    -1,   417,    -1,   419,
      -1,   420,    -1,   421,    -1,   422,    -1,   423,    -1,   425,
      -1,   426,    -1,   427,    -1,   430,    -1,   434,    -1,   435,
      -1,   437,    -1,   436,    -1,   438,    -1,   441,    -1,   442,
      -1,   443,    -1,   444,    -1,   445,    -1,   447,    -1,   450,
      -1,   452,    -1,   455,    -1,   459,    -1,   462,    -1,   463,
      -1,   465,    -1,   467,    -1,   470,    -1,   472,    -1,   473,
      -1,   474,    -1,   477,    -1,   475,    -1,   476,    -1,   478,
      -1,   480,    -1,   481,    -1,   483,    -1,   489,    -1,   488,
      -1,   490,    -1,   502,    -1,   495,    -1,   505,    -1,   506,
      -1,   508,    -1,   510,    -1,   512,    -1,   513,    -1,   521,
      -1,   520,    -1,   523,    -1,   526,    -1,   529,    -1,   534,
      -1,   538,    -1,   540,    -1,   541,    -1,   542,    -1,   543,
      -1,   545,    -1,   544,    -1,   548,    -1,   549,    -1,   550,
      -1,   551,    -1,   559,    -1,   556,    -1,   553,    -1,   558,
      -1,   554,    -1,   560,    -1,   561,    -1,   564,    -1,   565,
      -1,   576,    -1,   577,    -1,   578,    -1,   567,    -1,   568,
      -1,   569,    -1,   570,    -1,   583,    -1,   584,    -1,   585,
      -1,   202,    -1,   587,    -1,   588,    -1,   591,    -1,   590,
      -1,   597,    -1,   600,    -1,   604,    -1,   605,    -1,   606,
      -1,   616,    -1,   621,    -1,   622,    -1,   613,    -1,   624,
      -1,   623,    -1,   625,    -1,   626,    -1,   633,    -1,   636,
      -1,   638,    -1,   641,    -1,   620,    -1,    -1,   493,  1510,
    1511,    -1,    -1,  1527,  1512,  1517,    -1,    -1,   576,  1513,
    1529,    -1,    -1,  1523,  1514,  1515,    -1,    -1,  1526,  1516,
    1517,    -1,   576,  1529,    -1,    -1,   655,  1518,    -1,    -1,
    1519,  1521,    -1,    -1,  1518,   655,  1520,  1521,    -1,    -1,
    1523,  1522,  1526,    -1,  1527,    -1,   210,    -1,   283,    -1,
     490,    -1,    -1,   210,    -1,   283,    -1,   490,    -1,    -1,
     210,   661,    -1,   283,   661,    -1,   490,   661,    -1,  1528,
    1370,  1535,    -1,  1528,  1370,  1535,    -1,   660,  1503,  1370,
    1191,    -1,   660,   660,  1525,  1528,  1370,  1535,    -1,   994,
     999,    -1,   350,  1370,  1191,    -1,   350,   996,  1001,    -1,
     470,  1503,    -1,   403,  1370,  1534,    -1,   403,   197,  1506,
    1370,  1534,    -1,  1501,    -1,  1501,   661,  1501,    -1,   132,
     661,  1501,    -1,  1530,    -1,  1531,    -1,  1530,   655,  1531,
      -1,  1531,   655,  1530,    -1,  1532,    -1,   257,   274,  1533,
      -1,   431,   378,    -1,   431,   635,    -1,   431,   587,    -1,
     431,    84,    -1,   452,   431,    -1,   488,    -1,   563,    -1,
     403,   653,   563,   654,    -1,   375,   653,   563,   654,    -1,
    1191,    -1,   132,    -1,   376,    -1,    13,    -1,    36,    -1,
      -1,   286,  1538,  1537,  1539,    -1,   557,    -1,   553,    -1,
    1540,    -1,  1539,   655,  1540,    -1,  1494,  1291,  1541,    -1,
     431,    -1,   635,    -1,   635,    89,    -1,   294,   635,    -1,
     431,   283,    -1,    -1,   598,  1543,  1538,    -1,   216,  1494,
     380,  1291,    -1,   216,  1496,    70,    -1,    -1,   216,  1496,
     431,  1545,  1546,  1293,  1310,    -1,  1547,    -1,  1501,  1548,
      -1,   190,    -1,   360,    -1,   190,    -1,   360,    -1,   415,
      -1,   266,    -1,    -1,  1550,  1549,   653,  1375,   654,    -1,
     166,    -1,   203,    -1,   268,    -1,   215,    -1,   295,    -1,
     468,   715,  1552,    -1,  1562,   376,  1561,  1573,   199,  1576,
      -1,  1562,   376,   202,  1573,   199,  1576,    -1,  1562,   376,
     418,  1573,   199,  1576,    -1,    13,  1563,   655,   211,   383,
     199,  1576,    -1,   423,   376,  1506,   199,  1574,    -1,  1553,
     199,  1576,    -1,     7,   383,   197,  1560,    -1,  1560,    -1,
     211,   715,  1555,    -1,  1562,   376,  1561,  1573,   574,  1575,
    1583,  1584,    -1,  1562,   376,   202,  1573,   574,  1575,  1583,
    1584,    -1,  1562,   376,   418,  1573,   574,  1575,  1583,  1584,
      -1,   423,   376,  1506,   574,  1575,  1585,    -1,  1560,   574,
    1575,  1557,    -1,    -1,   630,     7,  1505,    -1,    -1,   630,
       7,   383,    -1,  1560,    -1,  1558,   655,  1560,    -1,   110,
    1190,    -1,  1503,    -1,  1559,    -1,    -1,   557,    -1,  1564,
      -1,    13,  1563,    -1,    -1,   417,    -1,  1565,    -1,  1564,
     655,  1565,    -1,    -1,   485,  1566,  1580,    -1,    -1,   246,
    1567,  1580,    -1,    -1,   601,  1568,  1580,    -1,    -1,   439,
    1569,  1580,    -1,   136,    -1,   603,    -1,   239,    -1,    14,
      -1,   104,    -1,   150,    -1,   177,    -1,   447,    -1,   499,
      -1,   419,    -1,   189,    -1,   211,   383,    -1,   498,   116,
      -1,   548,    -1,   104,   560,   553,    -1,   286,   553,    -1,
     455,   503,    -1,   455,    68,    -1,   104,   621,    -1,   498,
     621,    -1,   104,   473,    -1,    14,   473,    -1,   104,   604,
      -1,   173,    -1,   579,    -1,   104,   554,    -1,    -1,    18,
      -1,  1572,  1570,  1571,    -1,  1572,    -1,   543,   563,    -1,
     258,   563,    -1,    66,   563,    -1,   648,    -1,  1501,   661,
     648,    -1,   648,   661,   648,    -1,  1494,    -1,  1506,    -1,
    1574,   655,  1506,    -1,  1579,    -1,  1575,   655,  1579,    -1,
    1505,    -1,  1576,   655,  1505,    -1,   620,    -1,   630,    -1,
     608,    -1,    20,    -1,  1506,   232,    49,   563,    -1,  1506,
     232,    49,   403,   563,    -1,  1506,   232,  1577,  1503,    -1,
    1506,   232,  1577,  1503,  1578,  1498,    -1,  1505,    -1,    -1,
     653,  1581,   654,    -1,  1581,   655,  1582,    -1,  1582,    -1,
    1501,    -1,    -1,   456,  1571,    -1,   456,   527,    -1,   456,
     636,    -1,   456,   362,    -1,    -1,   630,  1586,    -1,    -1,
     630,   211,   383,    -1,  1586,  1587,    -1,  1587,    -1,   211,
     383,    -1,   319,  1317,    -1,   323,  1317,    -1,   318,  1317,
      -1,   324,  1316,    -1,    -1,    33,  1589,  1590,    -1,    -1,
     633,    -1,    -1,    18,   366,    58,    -1,    18,    58,    -1,
      -1,   446,    -1,   366,   446,    -1,    -1,   479,    -1,    85,
    1590,  1591,  1592,    -1,   471,  1590,  1591,  1592,    -1,   471,
    1590,   574,  1593,  1501,    -1,   479,  1501,    -1,   446,   479,
    1501,    -1,    -1,  1599,    -1,    -1,   595,  1606,  1600,  1169,
      -1,    -1,  1599,    -1,  1603,    -1,    -1,  1603,    -1,    -1,
    1604,  1605,    -1,  1305,  1309,    -1,  1311,    -1,    -1,   146,
      -1,    13,    -1,   485,  1261,    -1,   653,  1171,   654,    -1,
    1607,  1602,    -1,    -1,  1608,   595,  1606,  1609,  1607,  1602,
      -1,  1611,  1608,  1612,    -1,    -1,    -1,    -1,  1614,    -1,
    1614,  1615,    -1,  1615,    -1,   539,    -1,   223,    -1,   146,
      -1,   524,    -1,   519,    -1,   520,    -1,   522,    -1,    13,
      -1,  1621,  1617,    -1,  1620,  1618,    -1,  1622,  1619,  1624,
      -1,  1624,    -1,  1632,    -1,  1643,    -1,  1637,    -1,   702,
      -1,  1624,    -1,  1632,    -1,  1643,    -1,  1637,    -1,  1636,
      -1,   702,    -1,  1620,    -1,  1621,    -1,    -1,   133,   166,
    1505,    -1,    12,   166,   588,    -1,    12,   166,   331,    -1,
      12,   166,   561,    -1,    -1,   525,   484,   133,    -1,   525,
     484,   252,    -1,    -1,  1623,   621,  1494,  1625,  1626,    20,
    1628,    -1,    -1,   653,  1627,   654,    -1,  1501,    -1,  1627,
     655,  1501,    -1,    -1,  1629,  1630,  1631,    -1,   485,  1172,
      -1,   653,  1170,   654,  1601,    -1,    -1,   630,    65,   383,
      -1,   630,    54,    65,   383,    -1,   630,   283,    65,   383,
      -1,    -1,    -1,    -1,   579,  1185,   716,   821,   822,   376,
    1185,  1633,  1494,   197,  1185,  1634,   155,   476,  1635,   771,
      -1,    11,  1185,   202,  1501,   465,   946,   511,  1498,    -1,
    1185,   202,  1501,   465,   946,   511,  1498,    -1,    -1,    -1,
      -1,    -1,    -1,  1185,   202,   716,   653,  1638,   727,   654,
    1639,   465,  1640,   991,  1641,   718,  1642,   771,    -1,    -1,
      -1,    -1,    -1,   418,  1185,   716,  1644,   653,  1645,   731,
     654,  1646,   718,  1647,   771,    -1,   637,  1650,  1649,  1651,
      -1,   637,   160,  1649,  1653,    -1,   637,   413,  1649,    -1,
     637,    85,  1649,  1652,    -1,   637,   471,  1649,    -1,   637,
     435,    -1,  1481,    -1,  1481,   655,  1481,    -1,  1481,   655,
    1481,   655,  1317,    -1,    33,    -1,   530,    -1,    -1,   260,
      -1,   462,    -1,    -1,   377,   405,    -1,    -1,    -1,   549,
    1654,  1655,    -1,    -1,   197,   334,    -1,   248,   407,  1501,
     511,  1498,    -1,   248,   511,  1498,    -1,   594,   407,  1501,
      -1,   594,   511,  1498,    -1,   643,    -1
};

/* YYRLINE[YYN] -- source line where rule number YYN was defined.  */
static const yytype_uint16 yyrline[] =
{
       0,  1936,  1936,  1948,  1947,  1972,  1979,  1981,  1985,  1986,
    1991,  1992,  1993,  1994,  1995,  1996,  1997,  1998,  1999,  2000,
    2001,  2002,  2003,  2004,  2005,  2006,  2007,  2008,  2009,  2010,
    2011,  2012,  2013,  2014,  2015,  2016,  2017,  2018,  2019,  2020,
    2021,  2022,  2023,  2024,  2025,  2026,  2027,  2028,  2029,  2030,
    2031,  2032,  2033,  2034,  2035,  2036,  2037,  2038,  2039,  2040,
    2041,  2042,  2043,  2044,  2045,  2049,  2058,  2059,  2063,  2072,
    2078,  2088,  2087,  2097,  2099,  2103,  2104,  2108,  2121,  2120,
    2140,  2139,  2148,  2149,  2153,  2157,  2161,  2165,  2169,  2173,
    2178,  2182,  2186,  2190,  2194,  2198,  2203,  2207,  2212,  2243,
    2248,  2251,  2253,  2254,  2258,  2264,  2268,  2284,  2288,  2294,
    2304,  2314,  2327,  2331,  2335,  2351,  2350,  2395,  2400,  2394,
    2407,  2412,  2405,  2419,  2424,  2417,  2430,  2429,  2442,  2441,
    2457,  2461,  2465,  2469,  2473,  2480,  2493,  2494,  2498,  2502,
    2506,  2510,  2514,  2518,  2522,  2530,  2529,  2560,  2559,  2566,
    2573,  2574,  2580,  2586,  2596,  2602,  2608,  2610,  2617,  2618,
    2622,  2628,  2637,  2638,  2646,  2646,  2702,  2703,  2704,  2705,
    2706,  2707,  2708,  2709,  2710,  2711,  2712,  2713,  2714,  2719,
    2733,  2749,  2767,  2768,  2772,  2773,  2778,  2780,  2782,  2784,
    2786,  2788,  2790,  2796,  2797,  2798,  2802,  2806,  2814,  2813,
    2826,  2828,  2831,  2833,  2837,  2841,  2848,  2850,  2854,  2855,
    2860,  2880,  2908,  2910,  2914,  2915,  2919,  2946,  2947,  2948,
    2949,  2953,  2954,  2958,  2959,  2964,  2967,  2994,  2993,  3057,
    3073,  3072,  3128,  3154,  3154,  3177,  3178,  3183,  3185,  3190,
    3212,  3223,  3227,  3249,  3250,  3254,  3258,  3267,  3273,  3279,
    3288,  3302,  3325,  3331,  3332,  3338,  3341,  3345,  3353,  3373,
    3375,  3393,  3399,  3401,  3403,  3405,  3407,  3409,  3411,  3413,
    3415,  3417,  3419,  3421,  3426,  3441,  3457,  3458,  3463,  3469,
    3478,  3484,  3493,  3501,  3510,  3519,  3521,  3530,  3535,  3541,
    3550,  3558,  3560,  3562,  3564,  3566,  3568,  3570,  3572,  3574,
    3576,  3578,  3580,  3582,  3587,  3605,  3626,  3627,  3631,  3632,
    3633,  3634,  3635,  3636,  3637,  3638,  3639,  3640,  3641,  3642,
    3643,  3648,  3647,  3654,  3654,  3709,  3708,  3737,  3737,  3752,
    3805,  3848,  3869,  3868,  3890,  3909,  3911,  3912,  3916,  3936,
    3959,  3961,  3977,  3959,  3996,  3998,  3999,  4003,  4004,  4009,
    4015,  4008,  4036,  4035,  4051,  4052,  4056,  4057,  4062,  4066,
    4061,  4087,  4091,  4086,  4110,  4120,  4125,  4124,  4159,  4160,
    4165,  4164,  4196,  4196,  4211,  4210,  4247,  4259,  4261,  4258,
    4288,  4287,  4308,  4310,  4315,  4317,  4319,  4336,  4341,  4347,
    4354,  4355,  4363,  4369,  4378,  4384,  4390,  4391,  4395,  4395,
    4400,  4401,  4402,  4406,  4407,  4408,  4412,  4416,  4417,  4418,
    4422,  4423,  4424,  4425,  4426,  4427,  4428,  4429,  4433,  4437,
    4438,  4439,  4443,  4444,  4445,  4446,  4447,  4451,  4455,  4456,
    4457,  4461,  4462,  4463,  4464,  4465,  4466,  4467,  4471,  4475,
    4476,  4477,  4481,  4482,  4483,  4488,  4496,  4504,  4512,  4524,
    4536,  4541,  4546,  4554,  4562,  4570,  4578,  4586,  4594,  4602,
    4615,  4628,  4641,  4643,  4647,  4652,  4665,  4666,  4718,  4717,
    4720,  4726,  4726,  4727,  4741,  4742,  4746,  4748,  4747,  4751,
    4750,  4756,  4793,  4794,  4799,  4798,  4817,  4836,  4835,  4852,
    4856,  4864,  4863,  4866,  4868,  4870,  4872,  4877,  4878,  4884,
    4885,  4902,  4903,  4907,  4908,  4912,  4931,  4941,  4952,  4961,
    4962,  4978,  4980,  4979,  4984,  4982,  4993,  4994,  4998,  5016,
    5032,  5033,  5049,  5064,  5086,  5087,  5092,  5091,  5115,  5125,
    5147,  5146,  5164,  5163,  5183,  5205,  5209,  5238,  5250,  5251,
    5256,  5267,  5255,  5292,  5293,  5297,  5310,  5331,  5344,  5370,
    5371,  5376,  5375,  5412,  5417,  5418,  5422,  5423,  5427,  5429,
    5435,  5441,  5443,  5445,  5447,  5449,  5451,  5461,  5476,  5460,
    5490,  5491,  5495,  5496,  5500,  5501,  5505,  5506,  5510,  5511,
    5515,  5516,  5520,  5525,  5529,  5537,  5541,  5547,  5549,  5553,
    5554,  5558,  5559,  5560,  5564,  5569,  5574,  5579,  5584,  5589,
    5594,  5599,  5614,  5620,  5635,  5640,  5655,  5661,  5679,  5684,
    5689,  5694,  5699,  5704,  5710,  5709,  5735,  5736,  5737,  5742,
    5747,  5752,  5754,  5756,  5758,  5764,  5769,  5774,  5780,  5786,
    5792,  5801,  5819,  5836,  5859,  5873,  5874,  5875,  5876,  5877,
    5878,  5879,  5883,  5884,  5885,  5889,  5890,  5894,  5895,  5896,
    5897,  5902,  5909,  5910,  5914,  5915,  5919,  5920,  5928,  5927,
    5936,  5934,  5944,  5942,  5952,  5950,  5958,  5979,  5985,  5987,
    5991,  5995,  5996,  6000,  6005,  6004,  6030,  6031,  6040,  6042,
    6047,  6050,  6054,  6061,  6062,  6066,  6067,  6071,  6077,  6083,
    6087,  6103,  6119,  6120,  6121,  6122,  6127,  6131,  6136,  6141,
    6145,  6150,  6155,  6161,  6166,  6172,  6176,  6181,  6186,  6204,
    6206,  6208,  6221,  6223,  6228,  6233,  6245,  6250,  6255,  6260,
    6262,  6264,  6266,  6268,  6270,  6272,  6274,  6277,  6276,  6281,
    6280,  6284,  6286,  6295,  6296,  6297,  6302,  6303,  6304,  6305,
    6306,  6310,  6314,  6315,  6319,  6320,  6324,  6325,  6326,  6327,
    6328,  6332,  6333,  6334,  6335,  6336,  6340,  6345,  6347,  6353,
    6354,  6356,  6361,  6370,  6371,  6375,  6376,  6380,  6381,  6382,
    6386,  6387,  6388,  6389,  6392,  6393,  6397,  6398,  6402,  6403,
    6407,  6408,  6412,  6413,  6414,  6415,  6422,  6423,  6429,  6435,
    6441,  6447,  6448,  6461,  6467,  6473,  6479,  6488,  6509,  6515,
    6520,  6521,  6525,  6526,  6530,  6538,  6542,  6543,  6547,  6548,
    6552,  6561,  6565,  6566,  6570,  6578,  6579,  6583,  6584,  6588,
    6589,  6594,  6595,  6599,  6606,  6615,  6620,  6628,  6629,  6630,
    6631,  6632,  6633,  6638,  6646,  6647,  6652,  6651,  6664,  6665,
    6669,  6672,  6673,  6674,  6675,  6679,  6687,  6694,  6695,  6699,
    6709,  6710,  6714,  6715,  6718,  6720,  6724,  6736,  6737,  6741,
    6748,  6761,  6762,  6764,  6766,  6772,  6777,  6783,  6789,  6796,
    6806,  6807,  6808,  6809,  6810,  6814,  6818,  6819,  6823,  6824,
    6828,  6829,  6833,  6834,  6835,  6839,  6840,  6844,  6848,  6861,
    6873,  6874,  6878,  6879,  6883,  6884,  6888,  6889,  6893,  6894,
    6898,  6899,  6903,  6904,  6908,  6909,  6913,  6915,  6916,  6922,
    6928,  6934,  6942,  6943,  6947,  6951,  6952,  6965,  6966,  6967,
    6971,  6972,  6976,  6982,  6996,  6997,  7001,  7013,  7014,  7018,
    7019,  7027,  7044,  7026,  7064,  7063,  7077,  7089,  7088,  7107,
    7106,  7125,  7124,  7143,  7137,  7157,  7156,  7189,  7194,  7199,
    7204,  7209,  7219,  7220,  7221,  7222,  7226,  7227,  7239,  7240,
    7244,  7245,  7248,  7250,  7258,  7266,  7268,  7270,  7271,  7279,
    7280,  7284,  7293,  7291,  7304,  7317,  7316,  7329,  7327,  7340,
    7347,  7357,  7358,  7385,  7392,  7396,  7401,  7400,  7416,  7418,
    7423,  7431,  7430,  7446,  7450,  7449,  7461,  7462,  7466,  7481,
    7482,  7486,  7495,  7499,  7504,  7510,  7509,  7521,  7532,  7520,
    7548,  7557,  7566,  7576,  7585,  7591,  7597,  7606,  7615,  7634,
    7654,  7664,  7668,  7673,  7674,  7677,  7679,  7680,  7681,  7682,
    7685,  7690,  7701,  7706,  7717,  7718,  7722,  7723,  7727,  7727,
    7730,  7732,  7736,  7737,  7741,  7742,  7750,  7751,  7752,  7756,
    7757,  7762,  7770,  7771,  7772,  7773,  7778,  7777,  7787,  7786,
    7793,  7800,  7810,  7827,  7830,  7837,  7841,  7848,  7852,  7856,
    7863,  7863,  7869,  7870,  7874,  7875,  7876,  7880,  7881,  7894,
    7901,  7902,  7907,  7906,  7918,  7919,  7920,  7925,  7924,  7945,
    7946,  7950,  7951,  7955,  7956,  7957,  7962,  7961,  7982,  7983,
    7987,  7992,  7993,  8000,  8002,  8006,  8008,  8007,  8019,  8021,
    8020,  8033,  8034,  8039,  8048,  8049,  8050,  8054,  8060,  8069,
    8078,  8077,  8103,  8104,  8108,  8109,  8113,  8114,  8115,  8116,
    8117,  8118,  8123,  8122,  8143,  8144,  8145,  8150,  8149,  8155,
    8162,  8167,  8175,  8176,  8180,  8194,  8193,  8206,  8207,  8211,
    8212,  8216,  8226,  8236,  8237,  8242,  8241,  8252,  8253,  8257,
    8258,  8262,  8272,  8283,  8282,  8290,  8290,  8299,  8300,  8305,
    8306,  8315,  8324,  8325,  8329,  8334,  8339,  8344,  8349,  8348,
    8368,  8376,  8368,  8383,  8384,  8385,  8386,  8387,  8391,  8398,
    8405,  8407,  8418,  8419,  8423,  8424,  8452,  8482,  8484,  8490,
    8500,  8501,  8502,  8516,  8521,  8546,  8552,  8558,  8559,  8560,
    8561,  8562,  8566,  8567,  8568,  8572,  8573,  8574,  8578,  8579,
    8584,  8635,  8642,  8685,  8691,  8697,  8703,  8709,  8715,  8721,
    8727,  8731,  8737,  8743,  8749,  8755,  8761,  8765,  8771,  8780,
    8786,  8794,  8800,  8810,  8816,  8825,  8835,  8841,  8851,  8857,
    8866,  8870,  8876,  8882,  8888,  8894,  8900,  8906,  8912,  8918,
    8924,  8930,  8936,  8942,  8948,  8954,  8958,  8959,  8963,  8964,
    8968,  8969,  8973,  8974,  8978,  8979,  8980,  8981,  8982,  8983,
    8987,  8988,  8993,  8999,  9003,  9010,  9017,  9024,  9031,  9038,
    9043,  9049,  9056,  9063,  9071,  9082,  9104,  9111,  9119,  9120,
    9121,  9122,  9123,  9124,  9135,  9136,  9137,  9138,  9139,  9145,
    9149,  9155,  9161,  9167,  9173,  9175,  9182,  9189,  9195,  9238,
    9247,  9254,  9262,  9268,  9275,  9281,  9295,  9302,  9318,  9324,
    9330,  9338,  9346,  9352,  9358,  9364,  9370,  9384,  9395,  9401,
    9407,  9413,  9419,  9425,  9431,  9437,  9443,  9449,  9455,  9461,
    9467,  9473,  9479,  9485,  9491,  9499,  9520,  9527,  9533,  9540,
    9547,  9554,  9561,  9567,  9573,  9580,  9586,  9593,  9599,  9605,
    9611,  9617,  9623,  9641,  9647,  9653,  9660,  9667,  9675,  9682,
    9689,  9696,  9703,  9720,  9726,  9732,  9738,  9744,  9751,  9757,
    9763,  9769,  9775,  9781,  9792,  9798,  9804,  9810,  9816,  9824,
    9830,  9841,  9847,  9853,  9861,  9871,  9877,  9893,  9899,  9906,
    9913,  9920,  9927,  9934,  9938,  9958,  9957, 10029, 10070, 10072,
   10077, 10078, 10082, 10083, 10087, 10088, 10092, 10099, 10107, 10133,
   10139, 10145, 10151, 10157, 10163, 10172, 10179, 10181, 10178, 10188,
   10199, 10205, 10211, 10217, 10223, 10229, 10235, 10241, 10247, 10254,
   10253, 10273, 10272, 10287, 10297, 10305, 10321, 10322, 10327, 10332,
   10335, 10338, 10337, 10354, 10356, 10362, 10361, 10378, 10380, 10382,
   10384, 10386, 10388, 10390, 10392, 10394, 10396, 10402, 10408, 10411,
   10410, 10416, 10417, 10421, 10428, 10436, 10437, 10441, 10448, 10456,
   10457, 10461, 10462, 10466, 10474, 10485, 10486, 10498, 10509, 10510,
   10516, 10517, 10537, 10541, 10539, 10557, 10555, 10566, 10576, 10574,
   10592, 10591, 10601, 10612, 10610, 10629, 10628, 10639, 10651, 10652,
   10653, 10657, 10658, 10666, 10667, 10671, 10686, 10686, 10701, 10741,
   10817, 10828, 10833, 10825, 10852, 10872, 10880, 10872, 10889, 10888,
   10911, 10928, 10911, 10935, 10939, 10965, 10966, 10971, 10974, 10975,
   10976, 10980, 10981, 10986, 10985, 10991, 10990, 10998, 10999, 11002,
   11004, 11004, 11008, 11008, 11013, 11014, 11018, 11020, 11025, 11026,
   11030, 11041, 11054, 11055, 11056, 11057, 11058, 11059, 11060, 11061,
   11062, 11063, 11064, 11065, 11069, 11070, 11071, 11072, 11073, 11074,
   11075, 11076, 11077, 11081, 11082, 11083, 11084, 11087, 11089, 11090,
   11094, 11095, 11103, 11105, 11109, 11111, 11110, 11124, 11127, 11126,
   11141, 11147, 11161, 11163, 11167, 11169, 11174, 11175, 11195, 11220,
   11224, 11225, 11229, 11241, 11243, 11248, 11247, 11282, 11284, 11289,
   11290, 11291, 11296, 11303, 11307, 11308, 11312, 11319, 11323, 11330,
   11337, 11344, 11354, 11387, 11391, 11397, 11403, 11412, 11420, 11424,
   11431, 11432, 11436, 11437, 11438, 11442, 11443, 11444, 11445, 11446,
   11447, 11451, 11452, 11453, 11454, 11455, 11459, 11460, 11461, 11462,
   11463, 11467, 11468, 11469, 11470, 11471, 11475, 11480, 11481, 11485,
   11486, 11489, 11492, 11491, 11522, 11523, 11527, 11528, 11532, 11542,
   11542, 11552, 11553, 11557, 11576, 11609, 11608, 11621, 11629, 11620,
   11631, 11643, 11655, 11654, 11672, 11671, 11682, 11682, 11698, 11705,
   11727, 11747, 11759, 11763, 11768, 11767, 11777, 11783, 11790, 11795,
   11800, 11810, 11811, 11815, 11826, 11839, 11840, 11844, 11856, 11860,
   11868, 11869, 11877, 11885, 11876, 11895, 11902, 11894, 11912, 11920,
   11921, 11929, 11933, 11934, 11945, 11946, 11950, 11959, 11960, 11961,
   11963, 11962, 11973, 11974, 11978, 11979, 11981, 11980, 11984, 11983,
   11989, 11990, 11994, 11995, 11999, 12009, 12010, 12014, 12015, 12020,
   12019, 12033, 12034, 12038, 12043, 12051, 12052, 12060, 12062, 12062,
   12070, 12078, 12069, 12100, 12101, 12105, 12113, 12114, 12118, 12128,
   12129, 12136, 12135, 12151, 12162, 12150, 12165, 12164, 12176, 12175,
   12188, 12190, 12194, 12195, 12199, 12212, 12228, 12229, 12233, 12234,
   12238, 12239, 12240, 12245, 12244, 12265, 12267, 12270, 12272, 12275,
   12276, 12279, 12283, 12287, 12291, 12295, 12299, 12303, 12307, 12311,
   12319, 12322, 12332, 12331, 12347, 12354, 12362, 12370, 12378, 12386,
   12394, 12401, 12408, 12414, 12416, 12418, 12427, 12431, 12436, 12435,
   12441, 12440, 12445, 12454, 12461, 12466, 12471, 12476, 12478, 12480,
   12482, 12484, 12486, 12493, 12501, 12503, 12511, 12518, 12525, 12532,
   12538, 12544, 12553, 12561, 12565, 12570, 12577, 12582, 12589, 12596,
   12603, 12610, 12617, 12624, 12630, 12637, 12644, 12649, 12654, 12659,
   12669, 12671, 12673, 12678, 12679, 12682, 12684, 12688, 12689, 12693,
   12694, 12698, 12699, 12703, 12704, 12708, 12709, 12712, 12714, 12721,
   12732, 12731, 12747, 12746, 12756, 12757, 12758, 12759, 12760, 12764,
   12765, 12769, 12770, 12771, 12775, 12776, 12777, 12792, 12791, 12804,
   12803, 12814, 12818, 12819, 12832, 12835, 12834, 12846, 12847, 12852,
   12854, 12856, 12858, 12860, 12862, 12873, 12875, 12877, 12879, 12885,
   12887, 12898, 12900, 12902, 12904, 12906, 12908, 12910, 12915, 12916,
   12920, 12921, 12925, 12924, 12934, 12935, 12939, 12939, 12942, 12943,
   12947, 12948, 12953, 12952, 12963, 12967, 12971, 12984, 12983, 12998,
   12999, 13000, 13003, 13004, 13005, 13006, 13014, 13018, 13027, 13033,
   13045, 13056, 13066, 13076, 13044, 13084, 13085, 13089, 13090, 13094,
   13095, 13103, 13107, 13108, 13109, 13112, 13114, 13118, 13119, 13123,
   13128, 13135, 13140, 13147, 13149, 13153, 13154, 13158, 13163, 13171,
   13172, 13175, 13177, 13185, 13187, 13191, 13192, 13193, 13197, 13199,
   13204, 13205, 13214, 13215, 13219, 13220, 13224, 13237, 13260, 13272,
   13283, 13302, 13310, 13322, 13330, 13345, 13365, 13366, 13367, 13375,
   13376, 13377, 13378, 13385, 13391, 13397, 13403, 13409, 13415, 13444,
   13475, 13485, 13495, 13501, 13510, 13522, 13528, 13534, 13550, 13551,
   13555, 13564, 13579, 13583, 13629, 13633, 13650, 13654, 13732, 13756,
   13786, 13787, 13803, 13813, 13817, 13823, 13829, 13839, 13845, 13854,
   13864, 13865, 13893, 13907, 13921, 13936, 13937, 13947, 13948, 13958,
   13959, 13960, 13964, 13979, 14011, 14021, 14021, 14023, 14033, 14034,
   14035, 14036, 14037, 14038, 14039, 14040, 14041, 14042, 14043, 14044,
   14045, 14046, 14047, 14048, 14049, 14050, 14051, 14052, 14053, 14054,
   14055, 14056, 14057, 14058, 14059, 14060, 14061, 14062, 14063, 14064,
   14065, 14066, 14067, 14068, 14069, 14070, 14071, 14072, 14073, 14074,
   14075, 14076, 14077, 14078, 14079, 14080, 14081, 14082, 14083, 14084,
   14085, 14086, 14087, 14088, 14089, 14090, 14091, 14092, 14102, 14103,
   14104, 14105, 14106, 14107, 14108, 14109, 14110, 14111, 14112, 14113,
   14114, 14115, 14116, 14117, 14118, 14119, 14120, 14121, 14122, 14123,
   14124, 14125, 14126, 14127, 14128, 14129, 14130, 14131, 14132, 14133,
   14134, 14135, 14136, 14137, 14138, 14139, 14140, 14141, 14142, 14143,
   14144, 14145, 14146, 14147, 14148, 14149, 14150, 14151, 14156, 14157,
   14158, 14159, 14160, 14161, 14162, 14163, 14164, 14165, 14166, 14167,
   14168, 14169, 14170, 14171, 14172, 14173, 14174, 14175, 14176, 14177,
   14178, 14179, 14180, 14181, 14182, 14183, 14184, 14185, 14186, 14187,
   14188, 14189, 14190, 14191, 14192, 14193, 14194, 14195, 14196, 14197,
   14198, 14199, 14200, 14201, 14202, 14203, 14204, 14205, 14206, 14207,
   14208, 14209, 14210, 14211, 14212, 14213, 14214, 14215, 14216, 14217,
   14218, 14219, 14220, 14221, 14222, 14223, 14224, 14225, 14226, 14227,
   14228, 14229, 14230, 14231, 14232, 14233, 14234, 14235, 14236, 14237,
   14238, 14239, 14240, 14241, 14242, 14243, 14244, 14245, 14246, 14247,
   14248, 14249, 14250, 14251, 14252, 14253, 14254, 14255, 14256, 14257,
   14258, 14259, 14260, 14261, 14262, 14263, 14264, 14265, 14266, 14267,
   14268, 14269, 14270, 14271, 14272, 14273, 14274, 14275, 14276, 14277,
   14278, 14279, 14280, 14281, 14282, 14283, 14284, 14285, 14286, 14287,
   14288, 14289, 14290, 14291, 14292, 14293, 14294, 14295, 14296, 14297,
   14298, 14299, 14300, 14301, 14302, 14303, 14304, 14305, 14306, 14307,
   14308, 14309, 14310, 14311, 14312, 14313, 14314, 14315, 14316, 14317,
   14318, 14319, 14320, 14321, 14322, 14323, 14324, 14325, 14326, 14327,
   14328, 14329, 14330, 14331, 14332, 14333, 14334, 14335, 14336, 14337,
   14338, 14339, 14340, 14341, 14342, 14343, 14344, 14345, 14346, 14347,
   14348, 14349, 14350, 14351, 14352, 14353, 14354, 14355, 14356, 14357,
   14358, 14359, 14360, 14361, 14362, 14363, 14364, 14365, 14366, 14367,
   14368, 14369, 14370, 14371, 14372, 14373, 14374, 14375, 14376, 14377,
   14378, 14379, 14380, 14381, 14382, 14383, 14384, 14385, 14386, 14387,
   14388, 14389, 14390, 14391, 14392, 14393, 14394, 14395, 14396, 14397,
   14398, 14399, 14400, 14401, 14402, 14403, 14404, 14405, 14406, 14407,
   14408, 14409, 14410, 14411, 14412, 14413, 14414, 14415, 14427, 14426,
   14444, 14443, 14450, 14449, 14459, 14458, 14469, 14468, 14474, 14482,
   14484, 14489, 14489, 14498, 14497, 14511, 14510, 14515, 14519, 14520,
   14521, 14525, 14526, 14527, 14528, 14532, 14533, 14534, 14535, 14540,
   14564, 14590, 14601, 14613, 14626, 14641, 14660, 14666, 14691, 14704,
   14730, 14773, 14787, 14788, 14789, 14790, 14794, 14811, 14828, 14829,
   14833, 14834, 14835, 14836, 14840, 14841, 14850, 14861, 14862, 14863,
   14869, 14875, 14887, 14886, 14902, 14903, 14907, 14908, 14912, 14927,
   14928, 14929, 14934, 14935, 14940, 14939, 14959, 14971, 14984, 14983,
   15017, 15018, 15022, 15023, 15027, 15028, 15029, 15030, 15032, 15031,
   15044, 15045, 15046, 15047, 15048, 15054, 15059, 15065, 15076, 15087,
   15091, 15098, 15107, 15109, 15114, 15119, 15126, 15138, 15150, 15157,
   15169, 15170, 15173, 15174, 15177, 15182, 15190, 15201, 15221, 15224,
   15226, 15230, 15231, 15238, 15240, 15244, 15245, 15250, 15249, 15253,
   15252, 15256, 15255, 15259, 15258, 15261, 15262, 15263, 15264, 15265,
   15266, 15267, 15268, 15269, 15270, 15271, 15272, 15273, 15274, 15275,
   15276, 15277, 15278, 15279, 15280, 15281, 15282, 15283, 15284, 15285,
   15286, 15290, 15291, 15295, 15296, 15300, 15310, 15320, 15333, 15348,
   15361, 15374, 15386, 15391, 15399, 15404, 15412, 15417, 15424, 15424,
   15425, 15425, 15428, 15457, 15462, 15468, 15474, 15480, 15484, 15488,
   15489, 15493, 15520, 15522, 15526, 15530, 15534, 15541, 15542, 15546,
   15547, 15551, 15552, 15556, 15557, 15563, 15569, 15575, 15585, 15584,
   15594, 15595, 15600, 15601, 15602, 15607, 15608, 15609, 15613, 15614,
   15618, 15630, 15639, 15649, 15658, 15672, 15673, 15678, 15677, 15693,
   15694, 15695, 15699, 15700, 15704, 15704, 15726, 15727, 15731, 15732,
   15733, 15737, 15741, 15748, 15751, 15749, 15765, 15772, 15793, 15810,
   15812, 15816, 15817, 15821, 15822, 15830, 15831, 15832, 15833, 15839,
   15845, 15855, 15857, 15859, 15864, 15865, 15866, 15867, 15868, 15872,
   15873, 15874, 15875, 15876, 15877, 15887, 15888, 15893, 15906, 15919,
   15921, 15923, 15929, 15930, 15932, 15938, 15937, 15954, 15955, 15959,
   15964, 15972, 15972, 15996, 15997, 16002, 16003, 16005, 16007, 16025,
   16031, 16036, 16018, 16097, 16114, 16138, 16169, 16173, 16182, 16205,
   16134, 16268, 16292, 16301, 16308, 16267, 16328, 16332, 16336, 16340,
   16344, 16348, 16355, 16362, 16369, 16379, 16380, 16384, 16385, 16386,
   16390, 16391, 16396, 16398, 16397, 16403, 16404, 16408, 16415, 16425,
   16431, 16442
};
#endif

#if YYDEBUG || YYERROR_VERBOSE || YYTOKEN_TABLE
/* YYTNAME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals.  */
static const char *const yytname[] =
{
  "$end", "error", "$undefined", "ABORT_SYM", "ACCESSIBLE_SYM", "ACTION",
  "ADD", "ADMIN_SYM", "ADDDATE_SYM", "AFTER_SYM", "AGAINST",
  "AGGREGATE_SYM", "ALGORITHM_SYM", "ALL", "ALTER", "ALWAYS_SYM",
  "ANALYZE_SYM", "AND_AND_SYM", "AND_SYM", "ANY_SYM", "AS", "ASC",
  "ASCII_SYM", "ASENSITIVE_SYM", "AT_SYM", "AUTHORS_SYM",
  "AUTOEXTEND_SIZE_SYM", "AUTO_INC", "AUTO_SYM", "AVG_ROW_LENGTH",
  "AVG_SYM", "BACKUP_SYM", "BEFORE_SYM", "BEGIN_SYM", "BETWEEN_SYM",
  "BIGINT", "BINARY", "BINLOG_SYM", "BIN_NUM", "BIT_AND", "BIT_OR",
  "BIT_SYM", "BIT_XOR", "BLOB_SYM", "BLOCK_SYM", "BOOLEAN_SYM", "BOOL_SYM",
  "BOTH", "BTREE_SYM", "BY", "BYTE_SYM", "CACHE_SYM", "CALL_SYM",
  "CASCADE", "CASCADED", "CASE_SYM", "CAST_SYM", "CATALOG_NAME_SYM",
  "CHAIN_SYM", "CHANGE", "CHANGED", "CHARSET", "CHAR_SYM",
  "CHECKPOINT_SYM", "CHECKSUM_SYM", "CHECK_SYM", "CIPHER_SYM",
  "CLASS_ORIGIN_SYM", "CLIENT_SYM", "CLIENT_STATS_SYM", "CLOSE_SYM",
  "COALESCE", "CODE_SYM", "COLLATE_SYM", "COLLATION_SYM", "COLUMNS",
  "COLUMN_ADD_SYM", "COLUMN_CHECK_SYM", "COLUMN_CREATE_SYM",
  "COLUMN_DELETE_SYM", "COLUMN_GET_SYM", "COLUMN_SYM", "COLUMN_NAME_SYM",
  "COMMENT_SYM", "COMMITTED_SYM", "COMMIT_SYM", "COMPACT_SYM",
  "COMPLETION_SYM", "COMPRESSED_SYM", "CONCURRENT", "CONDITION_SYM",
  "CONNECTION_SYM", "CONSISTENT_SYM", "CONSTRAINT",
  "CONSTRAINT_CATALOG_SYM", "CONSTRAINT_NAME_SYM", "CONSTRAINT_SCHEMA_SYM",
  "CONTAINS_SYM", "CONTEXT_SYM", "CONTINUE_SYM", "CONTRIBUTORS_SYM",
  "CONVERT_SYM", "COUNT_SYM", "CPU_SYM", "CREATE", "CROSS", "CUBE_SYM",
  "CURDATE", "CURRENT_SYM", "CURRENT_USER", "CURRENT_ROLE",
  "CURRENT_POS_SYM", "CURSOR_SYM", "CURSOR_NAME_SYM", "CURTIME",
  "DATABASE", "DATABASES", "DATAFILE_SYM", "DATA_SYM", "DATETIME",
  "DATE_ADD_INTERVAL", "DATE_SUB_INTERVAL", "DATE_SYM", "DAY_HOUR_SYM",
  "DAY_MICROSECOND_SYM", "DAY_MINUTE_SYM", "DAY_SECOND_SYM", "DAY_SYM",
  "DEALLOCATE_SYM", "DECIMAL_NUM", "DECIMAL_SYM", "DECLARE_SYM", "DEFAULT",
  "DEFINER_SYM", "DELAYED_SYM", "DELAY_KEY_WRITE_SYM", "DELETE_SYM",
  "DESC", "DESCRIBE", "DES_KEY_FILE", "DETERMINISTIC_SYM",
  "DIAGNOSTICS_SYM", "DIRECTORY_SYM", "DISABLE_SYM", "DISCARD", "DISK_SYM",
  "DISTINCT", "DIV_SYM", "DOUBLE_SYM", "DO_SYM", "DROP", "DUAL_SYM",
  "DUMPFILE", "DUPLICATE_SYM", "DYNAMIC_SYM", "EACH_SYM", "ELSE",
  "ELSEIF_SYM", "ENABLE_SYM", "ENCLOSED", "END", "ENDS_SYM",
  "END_OF_INPUT", "ENGINES_SYM", "ENGINE_SYM", "ENUM", "EQ", "EQUAL_SYM",
  "ERROR_SYM", "ERRORS", "ESCAPED", "ESCAPE_SYM", "EVENTS_SYM",
  "EVENT_SYM", "EVERY_SYM", "EXCHANGE_SYM", "EXAMINED_SYM", "EXECUTE_SYM",
  "EXISTS", "EXIT_SYM", "EXPANSION_SYM", "EXPORT_SYM", "EXTENDED_SYM",
  "EXTENT_SIZE_SYM", "EXTRACT_SYM", "FALSE_SYM", "FAST_SYM", "FAULTS_SYM",
  "FETCH_SYM", "FILE_SYM", "FIRST_SYM", "FIXED_SYM", "FLOAT_NUM",
  "FLOAT_SYM", "FLUSH_SYM", "FORCE_SYM", "FOREIGN", "FOR_SYM", "FOUND_SYM",
  "FROM", "FULL", "FULLTEXT_SYM", "FUNCTION_SYM", "GE", "GENERAL",
  "GENERATED_SYM", "GEOMETRYCOLLECTION", "GEOMETRY_SYM", "GET_FORMAT",
  "GET_SYM", "GLOBAL_SYM", "GRANT", "GRANTS", "GROUP_SYM",
  "GROUP_CONCAT_SYM", "GT_SYM", "HANDLER_SYM", "HARD_SYM", "HASH_SYM",
  "HAVING", "HELP_SYM", "HEX_NUM", "HEX_STRING", "HIGH_PRIORITY",
  "HOST_SYM", "HOSTS_SYM", "HOUR_MICROSECOND_SYM", "HOUR_MINUTE_SYM",
  "HOUR_SECOND_SYM", "HOUR_SYM", "ID_SYM", "IDENT", "IDENTIFIED_SYM",
  "IDENT_QUOTED", "IF", "IGNORE_SYM", "IGNORE_SERVER_IDS_SYM", "IMPORT",
  "INDEXES", "INDEX_SYM", "INDEX_STATS_SYM", "INFILE", "INITIAL_SIZE_SYM",
  "INNER_SYM", "INOUT_SYM", "INSENSITIVE_SYM", "INSERT", "INSERT_METHOD",
  "INSTALL_SYM", "INTERVAL_SYM", "INTO", "INT_SYM", "INVOKER_SYM",
  "IN_SYM", "IO_SYM", "IPC_SYM", "IS", "ISOLATION", "ISSUER_SYM",
  "ITERATE_SYM", "JOIN_SYM", "KEYS", "KEY_BLOCK_SIZE", "KEY_SYM",
  "KILL_SYM", "LANGUAGE_SYM", "LAST_SYM", "LAST_VALUE", "LE", "LEADING",
  "LEAVES", "LEAVE_SYM", "LEFT", "LESS_SYM", "LEVEL_SYM", "LEX_HOSTNAME",
  "LIKE", "LIMIT", "LINEAR_SYM", "LINES", "LINESTRING", "LIST_SYM", "LOAD",
  "LOCAL_SYM", "LOCATOR_SYM", "LOCKS_SYM", "LOCK_SYM", "LOGFILE_SYM",
  "LOGS_SYM", "LONGBLOB", "LONGTEXT", "LONG_NUM", "LONG_SYM", "LOOP_SYM",
  "LOW_PRIORITY", "LT", "MASTER_CONNECT_RETRY_SYM", "MASTER_GTID_POS_SYM",
  "MASTER_HOST_SYM", "MASTER_LOG_FILE_SYM", "MASTER_LOG_POS_SYM",
  "MASTER_PASSWORD_SYM", "MASTER_PORT_SYM", "MASTER_SERVER_ID_SYM",
  "MASTER_SSL_CAPATH_SYM", "MASTER_SSL_CA_SYM", "MASTER_SSL_CERT_SYM",
  "MASTER_SSL_CIPHER_SYM", "MASTER_SSL_CRL_SYM", "MASTER_SSL_CRLPATH_SYM",
  "MASTER_SSL_KEY_SYM", "MASTER_SSL_SYM",
  "MASTER_SSL_VERIFY_SERVER_CERT_SYM", "MASTER_SYM", "MASTER_USER_SYM",
  "MASTER_USE_GTID_SYM", "MASTER_HEARTBEAT_PERIOD_SYM", "MATCH",
  "MAX_CONNECTIONS_PER_HOUR", "MAX_QUERIES_PER_HOUR", "MAX_ROWS",
  "MAX_SIZE_SYM", "MAX_SYM", "MAX_UPDATES_PER_HOUR",
  "MAX_USER_CONNECTIONS_SYM", "MAX_VALUE_SYM", "MEDIUMBLOB", "MEDIUMINT",
  "MEDIUMTEXT", "MEDIUM_SYM", "MEMORY_SYM", "MERGE_SYM",
  "MESSAGE_TEXT_SYM", "MICROSECOND_SYM", "MIGRATE_SYM",
  "MINUTE_MICROSECOND_SYM", "MINUTE_SECOND_SYM", "MINUTE_SYM", "MIN_ROWS",
  "MIN_SYM", "MODE_SYM", "MODIFIES_SYM", "MODIFY_SYM", "MOD_SYM",
  "MONTH_SYM", "MULTILINESTRING", "MULTIPOINT", "MULTIPOLYGON",
  "MUTEX_SYM", "MYSQL_ERRNO_SYM", "NAMES_SYM", "NAME_SYM", "NATIONAL_SYM",
  "NATURAL", "NCHAR_STRING", "NCHAR_SYM", "NDBCLUSTER_SYM", "NE", "NEG",
  "NEW_SYM", "NEXT_SYM", "NODEGROUP_SYM", "NONE_SYM", "NOT2_SYM",
  "NOT_SYM", "NOW_SYM", "NO_SYM", "NO_WAIT_SYM", "NO_WRITE_TO_BINLOG",
  "NULL_SYM", "NUM", "NUMBER_SYM", "NUMERIC_SYM", "NVARCHAR_SYM",
  "OFFSET_SYM", "OLD_PASSWORD", "ON", "ONE_SYM", "ONLY_SYM", "ONLINE_SYM",
  "OPEN_SYM", "OPTIMIZE", "OPTIONS_SYM", "OPTION", "OPTIONALLY", "OR2_SYM",
  "ORDER_SYM", "OR_OR_SYM", "OR_SYM", "OUTER", "OUTFILE", "OUT_SYM",
  "OWNER_SYM", "PACK_KEYS_SYM", "PAGE_SYM", "PAGE_CHECKSUM_SYM",
  "PARAM_MARKER", "PARSER_SYM", "PARSE_VCOL_EXPR_SYM", "PARTIAL",
  "PARTITION_SYM", "PARTITIONS_SYM", "PARTITIONING_SYM", "PASSWORD",
  "PERSISTENT_SYM", "PHASE_SYM", "PLUGINS_SYM", "PLUGIN_SYM", "POINT_SYM",
  "POLYGON", "PORT_SYM", "POSITION_SYM", "PRECISION", "PREPARE_SYM",
  "PRESERVE_SYM", "PREV_SYM", "PRIMARY_SYM", "PRIVILEGES", "PROCEDURE_SYM",
  "PROCESS", "PROCESSLIST_SYM", "PROFILE_SYM", "PROFILES_SYM", "PROXY_SYM",
  "PURGE", "QUARTER_SYM", "QUERY_SYM", "QUICK", "RANGE_SYM", "READS_SYM",
  "READ_ONLY_SYM", "READ_SYM", "READ_WRITE_SYM", "REAL", "REBUILD_SYM",
  "RECOVER_SYM", "REDOFILE_SYM", "REDO_BUFFER_SIZE_SYM", "REDUNDANT_SYM",
  "REFERENCES", "REGEXP", "RELAY", "RELAYLOG_SYM", "RELAY_LOG_FILE_SYM",
  "RELAY_LOG_POS_SYM", "RELAY_THREAD", "RELEASE_SYM", "RELOAD",
  "REMOVE_SYM", "RENAME", "REORGANIZE_SYM", "REPAIR", "REPEATABLE_SYM",
  "REPEAT_SYM", "REPLACE", "REPLICATION", "REQUIRE_SYM", "RESET_SYM",
  "RESIGNAL_SYM", "RESOURCES", "RESTORE_SYM", "RESTRICT", "RESUME_SYM",
  "RETURNED_SQLSTATE_SYM", "RETURNING_SYM", "RETURNS_SYM", "RETURN_SYM",
  "REVERSE_SYM", "REVOKE", "RIGHT", "ROLE_SYM", "ROLLBACK_SYM",
  "ROLLUP_SYM", "ROUTINE_SYM", "ROWS_SYM", "ROW_FORMAT_SYM", "ROW_SYM",
  "ROW_COUNT_SYM", "RTREE_SYM", "SAVEPOINT_SYM", "SCHEDULE_SYM",
  "SCHEMA_NAME_SYM", "SECOND_MICROSECOND_SYM", "SECOND_SYM",
  "SECURITY_SYM", "SELECT_SYM", "SENSITIVE_SYM", "SEPARATOR_SYM",
  "SERIALIZABLE_SYM", "SERIAL_SYM", "SESSION_SYM", "SERVER_SYM",
  "SERVER_OPTIONS", "SET", "SET_VAR", "SHARE_SYM", "SHIFT_LEFT",
  "SHIFT_RIGHT", "SHOW", "SHUTDOWN", "SIGNAL_SYM", "SIGNED_SYM",
  "SIMPLE_SYM", "SLAVE", "SLAVES", "SLAVE_POS_SYM", "SLOW", "SMALLINT",
  "SNAPSHOT_SYM", "SOCKET_SYM", "SOFT_SYM", "SONAME_SYM", "SOUNDS_SYM",
  "SOURCE_SYM", "SPATIAL_SYM", "SPECIFIC_SYM", "SQLEXCEPTION_SYM",
  "SQLSTATE_SYM", "SQLWARNING_SYM", "SQL_BIG_RESULT", "SQL_BUFFER_RESULT",
  "SQL_CACHE_SYM", "SQL_CALC_FOUND_ROWS", "SQL_NO_CACHE_SYM",
  "SQL_SMALL_RESULT", "SQL_SYM", "SQL_THREAD", "SSL_SYM", "STARTING",
  "STARTS_SYM", "START_SYM", "STATS_AUTO_RECALC_SYM",
  "STATS_PERSISTENT_SYM", "STATS_SAMPLE_PAGES_SYM", "STATUS_SYM",
  "STDDEV_SAMP_SYM", "STD_SYM", "STOP_SYM", "STORAGE_SYM", "STRAIGHT_JOIN",
  "STRING_SYM", "SUBCLASS_ORIGIN_SYM", "SUBDATE_SYM", "SUBJECT_SYM",
  "SUBPARTITIONS_SYM", "SUBPARTITION_SYM", "SUBSTRING", "SUM_SYM",
  "SUPER_SYM", "SUSPEND_SYM", "SWAPS_SYM", "SWITCHES_SYM", "SYSDATE",
  "TABLES", "TABLESPACE", "TABLE_REF_PRIORITY", "TABLE_STATS_SYM",
  "TABLE_SYM", "TABLE_CHECKSUM_SYM", "TABLE_NAME_SYM", "TEMPORARY",
  "TEMPTABLE_SYM", "TERMINATED", "TEXT_STRING", "TEXT_SYM", "THAN_SYM",
  "THEN_SYM", "TIMESTAMP", "TIMESTAMP_ADD", "TIMESTAMP_DIFF", "TIME_SYM",
  "TINYBLOB", "TINYINT", "TINYTEXT", "TO_SYM", "TRAILING",
  "TRANSACTION_SYM", "TRANSACTIONAL_SYM", "TRIGGERS_SYM", "TRIGGER_SYM",
  "TRIM", "TRUE_SYM", "TRUNCATE_SYM", "TYPES_SYM", "TYPE_SYM",
  "UDF_RETURNS_SYM", "ULONGLONG_NUM", "UNCOMMITTED_SYM", "UNDEFINED_SYM",
  "UNDERSCORE_CHARSET", "UNDOFILE_SYM", "UNDO_BUFFER_SIZE_SYM", "UNDO_SYM",
  "UNICODE_SYM", "UNINSTALL_SYM", "UNION_SYM", "UNIQUE_SYM", "UNKNOWN_SYM",
  "UNLOCK_SYM", "UNSIGNED", "UNTIL_SYM", "UPDATE_SYM", "UPGRADE_SYM",
  "USAGE", "USER", "USER_STATS_SYM", "USE_FRM", "USE_SYM", "USING",
  "UTC_DATE_SYM", "UTC_TIMESTAMP_SYM", "UTC_TIME_SYM", "VALUES",
  "VALUE_SYM", "VARBINARY", "VARCHAR", "VARIABLES", "VARIANCE_SYM",
  "VARYING", "VAR_SAMP_SYM", "VIA_SYM", "VIEW_SYM", "VIRTUAL_SYM",
  "WAIT_SYM", "WARNINGS", "WEEK_SYM", "WEIGHT_STRING_SYM", "WHEN_SYM",
  "WHERE", "WHILE_SYM", "WITH", "WITH_CUBE_SYM", "WITH_ROLLUP_SYM",
  "WORK_SYM", "WRAPPER_SYM", "WRITE_SYM", "X509_SYM", "XA_SYM", "XML_SYM",
  "XOR", "YEAR_MONTH_SYM", "YEAR_SYM", "ZEROFILL", "IMPOSSIBLE_ACTION",
  "'|'", "'&'", "'-'", "'+'", "'*'", "'/'", "'%'", "'^'", "'~'", "'('",
  "')'", "','", "'!'", "'{'", "'}'", "';'", "'@'", "'.'", "':'", "$accept",
  "query", "$@1", "opt_end_of_input", "verb_clause", "statement",
  "deallocate", "deallocate_or_drop", "prepare", "prepare_src", "execute",
  "$@2", "execute_using", "execute_var_list", "execute_var_ident", "help",
  "$@3", "change", "$@4", "master_defs", "master_def",
  "ignore_server_id_list", "ignore_server_id", "master_file_def",
  "optional_connection_name", "connection_name", "create", "$@5", "$@6",
  "$@7", "$@8", "$@9", "$@10", "$@11", "$@12", "$@13", "server_def",
  "server_options_list", "server_option", "event_tail", "$@14",
  "ev_schedule_time", "$@15", "opt_ev_status", "ev_starts", "ev_ends",
  "opt_ev_on_completion", "ev_on_completion", "opt_ev_comment",
  "ev_sql_stmt", "$@16", "ev_sql_stmt_inner", "clear_privileges",
  "sp_name", "sp_a_chistics", "sp_c_chistics", "sp_chistic",
  "sp_c_chistic", "sp_suid", "call", "$@17", "opt_sp_cparam_list",
  "opt_sp_cparams", "sp_cparams", "sp_fdparam_list", "sp_fdparams",
  "sp_init_param", "sp_fdparam", "sp_pdparam_list", "sp_pdparams",
  "sp_pdparam", "sp_opt_inout", "sp_proc_stmts", "sp_proc_stmts1",
  "sp_decls", "sp_decl", "$@18", "$@19", "sp_cursor_stmt", "$@20",
  "sp_handler_type", "sp_hcond_list", "sp_hcond_element", "sp_cond",
  "sqlstate", "opt_value", "sp_hcond", "signal_stmt", "signal_value",
  "opt_signal_value", "opt_set_signal_information",
  "signal_information_item_list", "signal_allowed_expr",
  "signal_condition_information_item_name", "resignal_stmt",
  "get_diagnostics", "which_area", "diagnostics_information",
  "statement_information", "statement_information_item",
  "simple_target_specification", "statement_information_item_name",
  "condition_number", "condition_information",
  "condition_information_item", "condition_information_item_name",
  "sp_decl_idents", "sp_opt_default", "sp_proc_stmt", "sp_proc_stmt_if",
  "$@21", "sp_proc_stmt_statement", "$@22", "sp_proc_stmt_return", "$@23",
  "sp_proc_stmt_unlabeled", "$@24", "sp_proc_stmt_leave",
  "sp_proc_stmt_iterate", "sp_proc_stmt_open", "sp_proc_stmt_fetch",
  "$@25", "sp_proc_stmt_close", "sp_opt_fetch_noise", "sp_fetch_list",
  "sp_if", "$@26", "$@27", "$@28", "sp_elseifs", "case_stmt_specification",
  "simple_case_stmt", "$@29", "$@30", "searched_case_stmt", "$@31",
  "simple_when_clause_list", "searched_when_clause_list",
  "simple_when_clause", "$@32", "$@33", "searched_when_clause", "$@34",
  "$@35", "else_clause_opt", "sp_labeled_control", "$@36", "sp_opt_label",
  "sp_labeled_block", "$@37", "sp_unlabeled_block", "$@38",
  "sp_block_content", "$@39", "sp_unlabeled_control", "$@40", "$@41",
  "$@42", "trg_action_time", "trg_event", "change_tablespace_access",
  "change_tablespace_info", "tablespace_info", "opt_logfile_group_name",
  "alter_tablespace_info", "logfile_group_info",
  "alter_logfile_group_info", "add_log_file", "change_ts_option_list",
  "$@43", "change_ts_options", "change_ts_option",
  "tablespace_option_list", "tablespace_options", "tablespace_option",
  "alter_tablespace_option_list", "alter_tablespace_options",
  "alter_tablespace_option", "logfile_group_option_list",
  "logfile_group_options", "logfile_group_option",
  "alter_logfile_group_option_list", "alter_logfile_group_options",
  "alter_logfile_group_option", "ts_datafile", "lg_undofile",
  "lg_redofile", "tablespace_name", "logfile_group_name", "ts_access_mode",
  "opt_ts_initial_size", "opt_ts_autoextend_size", "opt_ts_max_size",
  "opt_ts_extent_size", "opt_ts_undo_buffer_size",
  "opt_ts_redo_buffer_size", "opt_ts_nodegroup", "opt_ts_comment",
  "opt_ts_engine", "opt_ts_wait", "ts_wait", "size_number", "create_body",
  "$@44", "$@45", "create_like", "opt_create_select", "$@46", "$@47",
  "opt_create_partitioning", "opt_partitioning", "partitioning", "$@48",
  "have_partitioning", "partition_entry", "$@49", "partition",
  "part_type_def", "$@50", "opt_linear", "opt_key_algo", "part_field_list",
  "part_field_item_list", "part_field_item", "part_column_list",
  "part_func", "sub_part_func", "opt_num_parts", "opt_sub_part", "$@51",
  "$@52", "sub_part_field_list", "sub_part_field_item", "part_func_expr",
  "opt_num_subparts", "part_defs", "part_def_list", "part_definition",
  "$@53", "part_name", "opt_part_values", "$@54", "$@55", "part_func_max",
  "part_values_in", "part_value_list", "part_value_item", "$@56", "$@57",
  "part_value_item_list", "part_value_expr_item", "opt_sub_partition",
  "sub_part_list", "sub_part_definition", "$@58", "sub_name",
  "opt_part_options", "opt_part_option_list", "opt_part_option",
  "create_select", "$@59", "$@60", "opt_as", "opt_create_database_options",
  "create_database_options", "create_database_option", "opt_table_options",
  "table_options", "table_option", "opt_if_not_exists",
  "create_or_replace", "opt_create_table_options",
  "create_table_options_space_separated", "create_table_options",
  "create_table_option", "$@61", "default_charset", "default_collation",
  "storage_engines", "known_storage_engines", "row_types",
  "merge_insert_types", "opt_select_from", "udf_type", "create_field_list",
  "field_list", "field_list_item", "column_def", "key_def", "$@62", "$@63",
  "$@64", "$@65", "opt_check_constraint", "check_constraint",
  "opt_constraint", "constraint", "field_spec", "$@66", "field_def",
  "opt_generated_always", "vcol_opt_specifier", "vcol_opt_attribute",
  "vcol_opt_attribute_list", "vcol_attribute", "parse_vcol_expr",
  "virtual_column_func", "type", "$@67", "$@68", "spatial_type", "char",
  "nchar", "varchar", "nvarchar", "int_type", "real_type", "float_options",
  "precision", "field_options", "field_opt_list", "field_option",
  "field_length", "opt_field_length", "opt_precision", "opt_attribute",
  "opt_attribute_list", "attribute", "type_with_opt_collate",
  "now_or_signed_literal", "hex_num_or_string", "charset", "charset_name",
  "charset_name_or_default", "opt_load_data_charset",
  "old_or_new_charset_name", "old_or_new_charset_name_or_default",
  "collation_name", "opt_collate", "collation_name_or_default",
  "opt_default", "ascii", "unicode", "opt_binary", "opt_bin_mod",
  "ws_nweights", "$@69", "ws_level_flag_desc", "ws_level_flag_reverse",
  "ws_level_flags", "ws_level_number", "ws_level_list_item",
  "ws_level_list", "ws_level_range", "ws_level_list_or_range",
  "opt_ws_levels", "opt_primary", "references", "opt_ref_list", "ref_list",
  "opt_match_clause", "opt_on_update_delete", "delete_option",
  "normal_key_type", "constraint_key_type", "key_or_index",
  "opt_key_or_index", "keys_or_index", "opt_unique", "fulltext", "spatial",
  "init_key_options", "key_alg", "normal_key_options",
  "fulltext_key_options", "spatial_key_options", "normal_key_opts",
  "spatial_key_opts", "fulltext_key_opts", "key_using_alg", "all_key_opt",
  "normal_key_opt", "spatial_key_opt", "fulltext_key_opt",
  "btree_or_rtree", "key_list", "key_part", "opt_ident",
  "opt_if_not_exists_ident", "opt_component", "string_list", "alter",
  "$@70", "$@71", "$@72", "$@73", "$@74", "$@75", "$@76", "$@77",
  "ev_alter_on_schedule_completion", "opt_ev_rename_to", "opt_ev_sql_stmt",
  "ident_or_empty", "alter_commands", "$@78", "$@79", "$@80",
  "remove_partitioning", "all_or_alt_part_name_list", "add_partition_rule",
  "$@81", "add_part_extra", "reorg_partition_rule", "$@82",
  "reorg_parts_rule", "$@83", "alt_part_name_list", "alt_part_name_item",
  "alter_list", "add_column", "alter_list_item", "$@84", "$@85", "$@86",
  "opt_index_lock_algorithm", "alter_algorithm_option",
  "alter_lock_option", "opt_column", "opt_ignore", "alter_options", "$@87",
  "alter_options_part2", "alter_option_list", "alter_option",
  "opt_restrict", "opt_place", "opt_to", "slave", "$@88", "$@89", "start",
  "opt_start_transaction_option_list", "start_transaction_option_list",
  "start_transaction_option", "slave_thread_opts", "$@90",
  "slave_thread_opt_list", "slave_thread_opt", "slave_until",
  "slave_until_opts", "checksum", "$@91", "opt_checksum_type", "repair",
  "$@92", "opt_mi_repair_type", "mi_repair_types", "mi_repair_type",
  "analyze", "$@93", "analyze_table_list", "analyze_table_elem_spec",
  "opt_persistent_stat_clause", "persistent_stat_spec",
  "persistent_column_stat_spec", "$@94", "persistent_index_stat_spec",
  "$@95", "table_column_list", "table_index_list", "table_index_name",
  "binlog_base64_event", "check", "$@96", "opt_mi_check_type",
  "mi_check_types", "mi_check_type", "optimize", "$@97",
  "opt_no_write_to_binlog", "rename", "$@98", "rename_list",
  "table_to_table_list", "table_to_table", "keycache", "$@99",
  "keycache_list_or_parts", "keycache_list", "assign_to_keycache",
  "assign_to_keycache_parts", "key_cache_name", "preload", "$@100",
  "preload_list_or_parts", "preload_list", "preload_keys",
  "preload_keys_parts", "adm_partition", "$@101", "cache_keys_spec",
  "$@102", "cache_key_list_or_empty", "opt_ignore_leaves", "select",
  "select_init", "select_paren", "select_paren_derived", "select_init2",
  "$@103", "select_part2", "$@104", "$@105", "select_into", "select_from",
  "select_options", "select_option_list", "select_option",
  "select_lock_type", "select_item_list", "select_item", "remember_name",
  "remember_end", "select_alias", "opt_default_time_precision",
  "opt_time_precision", "optional_braces", "expr", "bool_pri", "predicate",
  "bit_expr", "or", "and", "not", "not2", "comp_op", "all_or_any",
  "opt_dyncol_type", "dyncol_type", "dyncall_create_element",
  "dyncall_create_list", "simple_expr", "function_call_keyword",
  "function_call_nonkeyword", "function_call_conflict",
  "geometry_function", "function_call_generic", "@106", "fulltext_options",
  "opt_natural_language_mode", "opt_query_expansion", "opt_udf_expr_list",
  "udf_expr_list", "udf_expr", "sum_expr", "$@107", "$@108", "$@109",
  "variable", "$@110", "variable_aux", "opt_distinct",
  "opt_gconcat_separator", "opt_gorder_clause", "$@111", "gorder_list",
  "in_sum_expr", "$@112", "cast_type", "$@113", "opt_expr_list",
  "expr_list", "ident_list_arg", "ident_list", "opt_expr", "opt_else",
  "when_list", "table_ref", "join_table_list", "esc_table_ref",
  "derived_table_list", "join_table", "$@114", "$@115", "$@116", "$@117",
  "$@118", "$@119", "inner_join", "normal_join", "opt_use_partition",
  "use_partition", "table_factor", "$@120", "select_derived_union",
  "$@121", "$@122", "select_init2_derived", "select_part2_derived",
  "$@123", "$@124", "select_derived", "$@125", "select_derived2", "$@126",
  "$@127", "get_select_lex", "select_derived_init", "opt_outer",
  "index_hint_clause", "index_hint_type", "index_hint_definition", "$@128",
  "$@129", "index_hints_list", "opt_index_hints_list", "$@130",
  "opt_key_definition", "$@131", "opt_key_usage_list", "key_usage_element",
  "key_usage_list", "using_list", "interval", "interval_time_stamp",
  "date_time_type", "table_alias", "opt_table_alias", "opt_all",
  "where_clause", "$@132", "having_clause", "$@133", "opt_escape",
  "group_clause", "group_list", "olap_opt", "alter_order_clause",
  "alter_order_list", "alter_order_item", "opt_order_clause",
  "order_clause", "$@134", "order_list", "order_dir",
  "opt_limit_clause_init", "opt_limit_clause", "limit_clause",
  "limit_options", "limit_option", "limit_rows_option",
  "delete_limit_clause", "int_num", "ulong_num", "real_ulong_num",
  "ulonglong_num", "real_ulonglong_num", "dec_num_error", "dec_num",
  "choice", "procedure_clause", "$@135", "procedure_list",
  "procedure_list2", "procedure_item", "select_var_list_init", "$@136",
  "select_var_list", "select_var_ident", "into", "$@137",
  "into_destination", "$@138", "$@139", "do", "$@140", "drop", "$@141",
  "$@142", "$@143", "table_list", "table_name",
  "table_name_with_opt_use_partition", "table_alias_ref_list",
  "table_alias_ref", "opt_if_exists", "opt_temporary", "insert", "$@144",
  "$@145", "replace", "$@146", "$@147", "insert_lock_option",
  "replace_lock_option", "insert2", "insert_table", "insert_field_spec",
  "$@148", "fields", "insert_values", "$@149", "$@150", "values_list",
  "ident_eq_list", "ident_eq_value", "equal", "opt_equal", "no_braces",
  "$@151", "opt_values", "values", "expr_or_default", "opt_insert_update",
  "$@152", "update", "$@153", "$@154", "update_list", "update_elem",
  "insert_update_list", "insert_update_elem", "opt_low_priority", "delete",
  "$@155", "single_multi", "$@156", "$@157", "$@158", "$@159",
  "opt_select_expressions", "table_wild_list", "table_wild_one",
  "opt_wild", "opt_delete_options", "opt_delete_option", "truncate",
  "$@160", "opt_table_sym", "opt_profile_defs", "profile_defs",
  "profile_def", "opt_profile_args", "show", "$@161", "show_param",
  "$@162", "$@163", "show_engine_param", "master_or_binary", "opt_storage",
  "opt_db", "opt_full", "from_or_in", "binlog_in", "binlog_from",
  "wild_and_where", "describe", "$@164", "$@165", "explainable_command",
  "describe_command", "opt_extended_describe", "opt_describe_column",
  "flush", "$@166", "flush_options", "$@167", "opt_flush_lock",
  "flush_lock", "$@168", "flush_options_list", "flush_option",
  "opt_table_list", "optional_flush_tables_arguments", "reset", "$@169",
  "reset_options", "reset_option", "$@170", "slave_reset_options", "purge",
  "$@171", "purge_options", "purge_option", "kill", "$@172", "kill_type",
  "kill_option", "kill_expr", "shutdown", "use", "load", "$@173", "$@174",
  "$@175", "$@176", "data_or_xml", "opt_local", "load_data_lock",
  "opt_duplicate", "opt_field_term", "field_term_list", "field_term",
  "opt_line_term", "line_term_list", "line_term",
  "opt_xml_rows_identified_by", "opt_ignore_lines", "lines_or_rows",
  "opt_field_or_var_spec", "fields_or_vars", "field_or_var",
  "opt_load_data_set_spec", "load_data_set_list", "load_data_set_elem",
  "text_literal", "text_string", "param_marker", "signed_literal",
  "literal", "NUM_literal", "temporal_literal", "insert_ident",
  "table_wild", "order_ident", "simple_ident", "simple_ident_nospvar",
  "simple_ident_q", "field_ident", "table_ident", "table_ident_opt_wild",
  "table_ident_nodb", "IDENT_sys", "TEXT_STRING_sys",
  "TEXT_STRING_literal", "TEXT_STRING_filesystem", "ident", "label_ident",
  "ident_or_text", "user_maybe_role", "user_or_role", "user", "keyword",
  "keyword_sp", "set", "$@177", "start_option_value_list", "$@178",
  "$@179", "$@180", "start_option_value_list_following_option_type",
  "$@181", "option_value_list_continued", "option_value_list", "$@182",
  "$@183", "option_value", "$@184", "option_type", "opt_var_type",
  "opt_var_ident_type", "option_value_following_option_type",
  "option_value_no_option_type", "internal_variable_name",
  "transaction_characteristics", "transaction_access_mode",
  "isolation_level", "transaction_access_mode_types", "isolation_types",
  "text_or_password", "set_expr_or_default", "lock", "$@185",
  "table_or_tables", "table_lock_list", "table_lock", "lock_option",
  "unlock", "$@186", "handler", "$@187", "handler_read_or_scan",
  "handler_scan_function", "handler_rkey_function", "$@188",
  "handler_rkey_mode", "revoke", "revoke_command", "admin_option_for_role",
  "grant", "grant_command", "opt_with_admin", "opt_with_admin_option",
  "role_list", "current_role", "grant_role", "opt_table",
  "grant_privileges", "opt_privileges", "object_privilege_list",
  "object_privilege", "$@189", "$@190", "$@191", "$@192", "opt_and",
  "require_list", "require_list_element", "grant_ident", "user_list",
  "grant_list", "user_and_role_list", "via_or_with", "using_or_as",
  "grant_user", "opt_column_list", "column_list", "column_list_id",
  "require_clause", "grant_options", "opt_grant_option",
  "grant_option_list", "grant_option", "begin", "$@193", "opt_work",
  "opt_chain", "opt_release", "opt_savepoint", "commit", "rollback",
  "savepoint", "release", "union_clause", "union_list", "$@194",
  "union_opt", "opt_union_order_or_limit", "union_order_or_limit", "$@195",
  "order_or_limit", "union_option", "query_specification",
  "query_expression_body", "$@196", "subselect", "subselect_start",
  "subselect_end", "opt_query_expression_options",
  "query_expression_option_list", "query_expression_option",
  "view_or_trigger_or_sp_or_event", "definer_tail", "no_definer_tail",
  "definer_opt", "no_definer", "definer", "view_algorithm", "view_suid",
  "view_tail", "$@197", "view_list_opt", "view_list", "view_select",
  "$@198", "view_select_aux", "view_check_option", "trigger_tail", "$@199",
  "$@200", "$@201", "udf_tail", "sf_tail", "$@202", "$@203", "$@204",
  "$@205", "$@206", "sp_tail", "$@207", "$@208", "$@209", "$@210", "xa",
  "xid", "begin_or_start", "opt_join_or_resume", "opt_one_phase",
  "opt_suspend", "$@211", "opt_migrate", "install", "uninstall",
  "keep_gcc_happy", 0
};
#endif

# ifdef YYPRINT
/* YYTOKNUM[YYLEX-NUM] -- Internal token number corresponding to
   token YYLEX-NUM.  */
static const yytype_uint16 yytoknum[] =
{
       0,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,   396,   397,   398,   399,   400,   401,   402,   403,   404,
     405,   406,   407,   408,   409,   410,   411,   412,   413,   414,
     415,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,   427,   428,   429,   430,   431,   432,   433,   434,
     435,   436,   437,   438,   439,   440,   441,   442,   443,   444,
     445,   446,   447,   448,   449,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   460,   461,   462,   463,   464,
     465,   466,   467,   468,   469,   470,   471,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,   482,   483,   484,
     485,   486,   487,   488,   489,   490,   491,   492,   493,   494,
     495,   496,   497,   498,   499,   500,   501,   502,   503,   504,
     505,   506,   507,   508,   509,   510,   511,   512,   513,   514,
     515,   516,   517,   518,   519,   520,   521,   522,   523,   524,
     525,   526,   527,   528,   529,   530,   531,   532,   533,   534,
     535,   536,   537,   538,   539,   540,   541,   542,   543,   544,
     545,   546,   547,   548,   549,   550,   551,   552,   553,   554,
     555,   556,   557,   558,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   572,   573,   574,
     575,   576,   577,   578,   579,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,   592,   593,   594,
     595,   596,   597,   598,   599,   600,   601,   602,   603,   604,
     605,   606,   607,   608,   609,   610,   611,   612,   613,   614,
     615,   616,   617,   618,   619,   620,   621,   622,   623,   624,
     625,   626,   627,   628,   629,   630,   631,   632,   633,   634,
     635,   636,   637,   638,   639,   640,   641,   642,   643,   644,
     645,   646,   647,   648,   649,   650,   651,   652,   653,   654,
     655,   656,   657,   658,   659,   660,   661,   662,   663,   664,
     665,   666,   667,   668,   669,   670,   671,   672,   673,   674,
     675,   676,   677,   678,   679,   680,   681,   682,   683,   684,
     685,   686,   687,   688,   689,   690,   691,   692,   693,   694,
     695,   696,   697,   698,   699,   700,   701,   702,   703,   704,
     705,   706,   707,   708,   709,   710,   711,   712,   713,   714,
     715,   716,   717,   718,   719,   720,   721,   722,   723,   724,
     725,   726,   727,   728,   729,   730,   731,   732,   733,   734,
     735,   736,   737,   738,   739,   740,   741,   742,   743,   744,
     745,   746,   747,   748,   749,   750,   751,   752,   753,   754,
     755,   756,   757,   758,   759,   760,   761,   762,   763,   764,
     765,   766,   767,   768,   769,   770,   771,   772,   773,   774,
     775,   776,   777,   778,   779,   780,   781,   782,   783,   784,
     785,   786,   787,   788,   789,   790,   791,   792,   793,   794,
     795,   796,   797,   798,   799,   800,   801,   802,   803,   804,
     805,   806,   807,   808,   809,   810,   811,   812,   813,   814,
     815,   816,   817,   818,   819,   820,   821,   822,   823,   824,
     825,   826,   827,   828,   829,   830,   831,   832,   833,   834,
     835,   836,   837,   838,   839,   840,   841,   842,   843,   844,
     845,   846,   847,   848,   849,   850,   851,   852,   853,   854,
     855,   856,   857,   858,   859,   860,   861,   862,   863,   864,
     865,   866,   867,   868,   869,   870,   871,   872,   873,   874,
     875,   876,   877,   878,   879,   880,   881,   882,   883,   884,
     885,   886,   887,   888,   889,   890,   891,   892,   893,   894,
     895,   896,   897,   898,   124,    38,    45,    43,    42,    47,
      37,    94,   126,    40,    41,    44,    33,   123,   125,    59,
      64,    46,    58
};
# endif

/* YYR1[YYN] -- Symbol number of symbol that rule YYN derives.  */
static const yytype_uint16 yyr1[] =
{
       0,   663,   664,   665,   664,   664,   666,   666,   667,   667,
     668,   668,   668,   668,   668,   668,   668,   668,   668,   668,
     668,   668,   668,   668,   668,   668,   668,   668,   668,   668,
     668,   668,   668,   668,   668,   668,   668,   668,   668,   668,
     668,   668,   668,   668,   668,   668,   668,   668,   668,   668,
     668,   668,   668,   668,   668,   668,   668,   668,   668,   668,
     668,   668,   668,   668,   668,   669,   670,   670,   671,   672,
     672,   674,   673,   675,   675,   676,   676,   677,   679,   678,
     681,   680,   682,   682,   683,   683,   683,   683,   683,   683,
     683,   683,   683,   683,   683,   683,   683,   683,   683,   683,
     683,   684,   684,   684,   685,   686,   686,   686,   686,   686,
     686,   686,   687,   687,   688,   690,   689,   691,   692,   689,
     693,   694,   689,   695,   696,   689,   697,   689,   698,   689,
     689,   689,   689,   689,   689,   699,   700,   700,   701,   701,
     701,   701,   701,   701,   701,   703,   702,   705,   704,   704,
     706,   706,   706,   706,   707,   707,   708,   708,   709,   709,
     710,   710,   711,   711,   713,   712,   714,   714,   714,   714,
     714,   714,   714,   714,   714,   714,   714,   714,   714,   715,
     716,   716,   717,   717,   718,   718,   719,   719,   719,   719,
     719,   719,   719,   720,   720,   720,   721,   721,   723,   722,
     724,   724,   725,   725,   726,   726,   727,   727,   728,   728,
     729,   730,   731,   731,   732,   732,   733,   734,   734,   734,
     734,   735,   735,   736,   736,   737,   737,   739,   738,   738,
     740,   738,   738,   742,   741,   743,   743,   744,   744,   745,
     746,   746,   747,   748,   748,   749,   749,   749,   749,   749,
     750,   751,   751,   752,   752,   753,   753,   754,   754,   755,
     755,   755,   756,   756,   756,   756,   756,   756,   756,   756,
     756,   756,   756,   756,   757,   758,   759,   759,   760,   760,
     761,   761,   762,   763,   763,   764,   764,   765,   766,   766,
     767,   768,   768,   768,   768,   768,   768,   768,   768,   768,
     768,   768,   768,   768,   769,   769,   770,   770,   771,   771,
     771,   771,   771,   771,   771,   771,   771,   771,   771,   771,
     771,   773,   772,   775,   774,   777,   776,   779,   778,   780,
     781,   782,   784,   783,   785,   786,   786,   786,   787,   787,
     789,   790,   791,   788,   792,   792,   792,   793,   793,   795,
     796,   794,   798,   797,   799,   799,   800,   800,   802,   803,
     801,   805,   806,   804,   807,   807,   809,   808,   810,   810,
     812,   811,   814,   813,   816,   815,   817,   818,   819,   817,
     820,   817,   821,   821,   822,   822,   822,   823,   824,   825,
     826,   826,   827,   827,   828,   829,   830,   830,   832,   831,
     833,   833,   833,   834,   834,   834,   835,   836,   836,   836,
     837,   837,   837,   837,   837,   837,   837,   837,   838,   839,
     839,   839,   840,   840,   840,   840,   840,   841,   842,   842,
     842,   843,   843,   843,   843,   843,   843,   843,   844,   845,
     845,   845,   846,   846,   846,   847,   848,   849,   850,   851,
     852,   852,   852,   853,   854,   855,   856,   857,   858,   859,
     860,   861,   862,   862,   863,   863,   864,   864,   866,   865,
     865,   867,   865,   865,   868,   868,   869,   870,   869,   871,
     869,   872,   873,   873,   875,   874,   876,   878,   877,   879,
     880,   881,   880,   880,   880,   880,   880,   882,   882,   883,
     883,   884,   884,   885,   885,   886,   887,   888,   889,   890,
     890,   891,   892,   891,   893,   891,   894,   894,   895,   896,
     897,   897,   898,   898,   899,   899,   901,   900,   902,   903,
     904,   903,   905,   903,   906,   906,   907,   907,   908,   908,
     910,   911,   909,   912,   912,   913,   913,   914,   914,   915,
     915,   917,   916,   918,   919,   919,   920,   920,   921,   921,
     921,   921,   921,   921,   921,   921,   921,   923,   924,   922,
     925,   925,   926,   926,   927,   927,   928,   928,   929,   929,
     930,   930,   931,   932,   932,   933,   933,   934,   934,   935,
     935,   936,   936,   936,   937,   937,   937,   937,   937,   937,
     937,   937,   937,   937,   937,   937,   937,   937,   937,   937,
     937,   937,   937,   937,   938,   937,   937,   937,   937,   937,
     937,   937,   937,   937,   937,   937,   937,   937,   937,   937,
     937,   939,   940,   941,   942,   943,   943,   943,   943,   943,
     943,   943,   944,   944,   944,   945,   945,   946,   946,   946,
     946,   947,   948,   948,   949,   949,   950,   950,   952,   951,
     953,   951,   954,   951,   955,   951,   951,   951,   956,   956,
     957,   958,   958,   959,   961,   960,   962,   962,   963,   963,
     964,   964,   964,   965,   965,   966,   966,   967,   967,   967,
     968,   969,   970,   970,   970,   970,   970,   970,   970,   970,
     970,   970,   970,   970,   970,   970,   970,   970,   970,   970,
     970,   970,   970,   970,   970,   970,   970,   970,   970,   970,
     970,   970,   970,   970,   970,   970,   970,   971,   970,   972,
     970,   970,   970,   973,   973,   973,   973,   973,   973,   973,
     973,   974,   975,   975,   976,   976,   977,   977,   977,   977,
     977,   978,   978,   978,   978,   978,   979,   979,   979,   980,
     980,   980,   981,   982,   982,   983,   983,   984,   984,   984,
     985,   985,   985,   985,   986,   986,   987,   987,   988,   988,
     989,   989,   990,   990,   990,   990,   990,   990,   990,   990,
     990,   990,   990,   990,   990,   990,   990,   991,   992,   992,
     993,   993,   994,   994,   995,   995,   996,   996,   997,   997,
     998,   998,   999,   999,  1000,  1001,  1001,  1002,  1002,  1003,
    1003,  1004,  1004,  1004,  1005,  1005,  1005,  1006,  1006,  1006,
    1006,  1006,  1006,  1006,  1007,  1007,  1009,  1008,  1010,  1010,
    1011,  1012,  1012,  1012,  1012,  1013,  1014,  1015,  1015,  1016,
    1017,  1017,  1018,  1018,  1019,  1019,  1020,  1021,  1021,  1022,
    1022,  1023,  1023,  1023,  1023,  1024,  1024,  1024,  1024,  1024,
    1025,  1025,  1025,  1025,  1025,  1026,  1027,  1027,  1028,  1028,
    1029,  1029,  1030,  1030,  1030,  1031,  1031,  1032,  1033,  1034,
    1035,  1035,  1036,  1036,  1037,  1037,  1038,  1038,  1039,  1039,
    1040,  1040,  1041,  1041,  1042,  1042,  1043,  1043,  1043,  1043,
    1043,  1043,  1044,  1044,  1045,  1046,  1046,  1047,  1047,  1047,
    1048,  1048,  1049,  1049,  1050,  1050,  1051,  1052,  1052,  1053,
    1053,  1055,  1056,  1054,  1057,  1054,  1054,  1058,  1054,  1059,
    1054,  1060,  1054,  1061,  1054,  1062,  1054,  1054,  1054,  1054,
    1054,  1054,  1063,  1063,  1063,  1063,  1064,  1064,  1065,  1065,
    1066,  1066,  1067,  1067,  1067,  1067,  1067,  1067,  1067,  1067,
    1067,  1067,  1068,  1067,  1067,  1069,  1067,  1070,  1067,  1067,
    1067,  1067,  1067,  1071,  1072,  1072,  1074,  1073,  1075,  1075,
    1075,  1077,  1076,  1078,  1079,  1078,  1080,  1080,  1081,  1082,
    1082,  1083,  1084,  1084,  1084,  1085,  1084,  1086,  1087,  1084,
    1084,  1084,  1084,  1084,  1084,  1084,  1084,  1084,  1084,  1084,
    1084,  1084,  1084,  1084,  1084,  1088,  1088,  1088,  1088,  1088,
    1089,  1089,  1090,  1090,  1091,  1091,  1092,  1092,  1094,  1093,
    1095,  1095,  1096,  1096,  1097,  1097,  1098,  1098,  1098,  1099,
    1099,  1099,  1100,  1100,  1100,  1100,  1102,  1101,  1103,  1101,
    1101,  1101,  1104,  1105,  1105,  1106,  1106,  1107,  1107,  1107,
    1109,  1108,  1110,  1110,  1111,  1111,  1111,  1112,  1112,  1112,
    1113,  1113,  1115,  1114,  1116,  1116,  1116,  1118,  1117,  1119,
    1119,  1120,  1120,  1121,  1121,  1121,  1123,  1122,  1124,  1124,
    1125,  1126,  1126,  1127,  1127,  1128,  1129,  1128,  1130,  1131,
    1130,  1132,  1132,  1132,  1133,  1133,  1133,  1134,  1134,  1135,
    1137,  1136,  1138,  1138,  1139,  1139,  1140,  1140,  1140,  1140,
    1140,  1140,  1142,  1141,  1143,  1143,  1143,  1145,  1144,  1144,
    1146,  1146,  1147,  1147,  1148,  1150,  1149,  1151,  1151,  1152,
    1152,  1153,  1154,  1155,  1155,  1157,  1156,  1158,  1158,  1159,
    1159,  1160,  1161,  1163,  1162,  1165,  1164,  1166,  1166,  1167,
    1167,  1168,  1169,  1169,  1170,  1170,  1171,  1171,  1173,  1172,
    1175,  1176,  1174,  1177,  1177,  1177,  1177,  1177,  1178,  1178,
    1179,  1179,  1180,  1180,  1181,  1181,  1181,  1182,  1182,  1182,
    1183,  1183,  1183,  1184,  1184,  1185,  1186,  1187,  1187,  1187,
    1187,  1187,  1188,  1188,  1188,  1189,  1189,  1189,  1190,  1190,
    1191,  1191,  1191,  1191,  1191,  1191,  1191,  1191,  1191,  1191,
    1191,  1192,  1192,  1192,  1192,  1192,  1192,  1193,  1193,  1193,
    1193,  1193,  1193,  1193,  1193,  1193,  1193,  1193,  1193,  1193,
    1193,  1194,  1194,  1194,  1194,  1194,  1194,  1194,  1194,  1194,
    1194,  1194,  1194,  1194,  1194,  1194,  1195,  1195,  1196,  1196,
    1197,  1197,  1198,  1198,  1199,  1199,  1199,  1199,  1199,  1199,
    1200,  1200,  1201,  1201,  1202,  1202,  1202,  1202,  1202,  1202,
    1202,  1202,  1202,  1202,  1202,  1203,  1204,  1204,  1205,  1205,
    1205,  1205,  1205,  1205,  1205,  1205,  1205,  1205,  1205,  1205,
    1205,  1205,  1205,  1205,  1205,  1205,  1205,  1205,  1205,  1205,
    1205,  1205,  1205,  1205,  1205,  1205,  1205,  1205,  1206,  1206,
    1206,  1206,  1206,  1206,  1206,  1206,  1206,  1206,  1206,  1206,
    1206,  1206,  1206,  1206,  1206,  1206,  1206,  1206,  1206,  1206,
    1206,  1206,  1206,  1206,  1206,  1206,  1207,  1207,  1207,  1207,
    1207,  1207,  1207,  1207,  1207,  1207,  1207,  1207,  1207,  1207,
    1207,  1207,  1207,  1207,  1207,  1207,  1207,  1207,  1207,  1207,
    1207,  1207,  1207,  1208,  1208,  1208,  1208,  1208,  1208,  1208,
    1208,  1208,  1208,  1208,  1208,  1208,  1208,  1208,  1208,  1208,
    1208,  1208,  1208,  1208,  1208,  1208,  1208,  1209,  1209,  1209,
    1209,  1209,  1209,  1209,  1209,  1211,  1210,  1210,  1212,  1212,
    1213,  1213,  1214,  1214,  1215,  1215,  1216,  1216,  1217,  1218,
    1218,  1218,  1218,  1218,  1218,  1218,  1219,  1220,  1218,  1218,
    1218,  1218,  1218,  1218,  1218,  1218,  1218,  1218,  1218,  1221,
    1218,  1223,  1222,  1224,  1224,  1224,  1225,  1225,  1226,  1226,
    1227,  1228,  1227,  1229,  1229,  1231,  1230,  1232,  1232,  1232,
    1232,  1232,  1232,  1232,  1232,  1232,  1232,  1232,  1232,  1233,
    1232,  1234,  1234,  1235,  1235,  1236,  1236,  1237,  1237,  1238,
    1238,  1239,  1239,  1240,  1240,  1241,  1241,  1242,  1243,  1243,
    1244,  1244,  1245,  1246,  1245,  1247,  1245,  1245,  1248,  1245,
    1249,  1245,  1245,  1250,  1245,  1251,  1245,  1245,  1252,  1252,
    1252,  1253,  1253,  1254,  1254,  1255,  1257,  1256,  1256,  1256,
    1258,  1259,  1260,  1258,  1261,  1263,  1264,  1262,  1266,  1265,
    1268,  1269,  1267,  1270,  1271,  1272,  1272,  1273,  1273,  1273,
    1273,  1274,  1274,  1276,  1275,  1277,  1275,  1278,  1278,  1279,
    1280,  1279,  1282,  1281,  1283,  1283,  1284,  1284,  1285,  1285,
    1286,  1286,  1287,  1287,  1287,  1287,  1287,  1287,  1287,  1287,
    1287,  1287,  1287,  1287,  1288,  1288,  1288,  1288,  1288,  1288,
    1288,  1288,  1288,  1289,  1289,  1289,  1289,  1290,  1290,  1290,
    1291,  1291,  1292,  1292,  1293,  1294,  1293,  1295,  1296,  1295,
    1297,  1297,  1298,  1298,  1299,  1299,  1300,  1300,  1300,  1301,
    1302,  1302,  1303,  1304,  1304,  1306,  1305,  1307,  1307,  1308,
    1308,  1308,  1309,  1309,  1310,  1310,  1311,  1311,  1311,  1312,
    1312,  1312,  1313,  1313,  1313,  1313,  1313,  1314,  1315,  1315,
    1315,  1315,  1316,  1316,  1316,  1317,  1317,  1317,  1317,  1317,
    1317,  1318,  1318,  1318,  1318,  1318,  1319,  1319,  1319,  1319,
    1319,  1320,  1320,  1320,  1320,  1320,  1321,  1322,  1322,  1323,
    1323,  1324,  1325,  1324,  1326,  1326,  1327,  1327,  1328,  1330,
    1329,  1331,  1331,  1332,  1332,  1334,  1333,  1336,  1337,  1335,
    1335,  1335,  1339,  1338,  1341,  1340,  1342,  1340,  1340,  1340,
    1340,  1340,  1340,  1340,  1343,  1340,  1340,  1340,  1340,  1340,
    1340,  1344,  1344,  1345,  1346,  1347,  1347,  1348,  1349,  1349,
    1350,  1350,  1352,  1353,  1351,  1355,  1356,  1354,  1357,  1357,
    1357,  1357,  1358,  1358,  1359,  1359,  1360,  1361,  1361,  1361,
    1362,  1361,  1363,  1363,  1364,  1364,  1365,  1364,  1366,  1364,
    1367,  1367,  1368,  1368,  1369,  1370,  1370,  1371,  1371,  1373,
    1372,  1374,  1374,  1375,  1375,  1376,  1376,  1377,  1378,  1377,
    1380,  1381,  1379,  1382,  1382,  1383,  1384,  1384,  1385,  1386,
    1386,  1388,  1387,  1390,  1391,  1389,  1392,  1389,  1393,  1389,
    1394,  1394,  1395,  1395,  1396,  1396,  1397,  1397,  1398,  1398,
    1399,  1399,  1399,  1401,  1400,  1402,  1402,  1403,  1403,  1404,
    1404,  1405,  1405,  1405,  1405,  1405,  1405,  1405,  1405,  1405,
    1406,  1406,  1408,  1407,  1409,  1409,  1409,  1409,  1409,  1409,
    1409,  1409,  1409,  1409,  1409,  1409,  1409,  1409,  1410,  1409,
    1411,  1409,  1409,  1409,  1409,  1409,  1409,  1409,  1409,  1409,
    1409,  1409,  1409,  1409,  1409,  1409,  1409,  1409,  1409,  1409,
    1409,  1409,  1409,  1409,  1409,  1409,  1409,  1409,  1409,  1409,
    1409,  1409,  1409,  1409,  1409,  1409,  1409,  1409,  1409,  1409,
    1412,  1412,  1412,  1413,  1413,  1414,  1414,  1415,  1415,  1416,
    1416,  1417,  1417,  1418,  1418,  1419,  1419,  1420,  1420,  1420,
    1422,  1421,  1423,  1421,  1424,  1424,  1424,  1424,  1424,  1425,
    1425,  1426,  1426,  1426,  1427,  1427,  1427,  1429,  1428,  1431,
    1430,  1430,  1432,  1432,  1433,  1434,  1433,  1435,  1435,  1436,
    1436,  1436,  1436,  1436,  1436,  1436,  1436,  1436,  1436,  1436,
    1436,  1436,  1436,  1436,  1436,  1436,  1436,  1436,  1437,  1437,
    1438,  1438,  1440,  1439,  1441,  1441,  1443,  1442,  1442,  1442,
    1444,  1444,  1446,  1445,  1447,  1448,  1448,  1450,  1449,  1451,
    1451,  1451,  1452,  1452,  1452,  1452,  1453,  1453,  1454,  1455,
    1457,  1458,  1459,  1460,  1456,  1461,  1461,  1462,  1462,  1463,
    1463,  1463,  1464,  1464,  1464,  1465,  1465,  1466,  1466,  1467,
    1467,  1467,  1467,  1468,  1468,  1469,  1469,  1470,  1470,  1471,
    1471,  1472,  1472,  1473,  1473,  1474,  1474,  1474,  1475,  1475,
    1476,  1476,  1477,  1477,  1478,  1478,  1479,  1480,  1480,  1480,
    1480,  1481,  1481,  1481,  1481,  1482,  1483,  1483,  1483,  1484,
    1484,  1484,  1484,  1484,  1484,  1484,  1484,  1484,  1484,  1484,
    1485,  1485,  1485,  1485,  1485,  1486,  1486,  1486,  1487,  1487,
    1488,  1488,  1489,  1490,  1490,  1491,  1491,  1492,  1492,  1492,
    1493,  1493,  1493,  1493,  1494,  1494,  1494,  1495,  1495,  1496,
    1497,  1497,  1498,  1499,  1500,  1501,  1501,  1502,  1502,  1503,
    1503,  1503,  1504,  1504,  1504,  1505,  1505,  1506,  1507,  1507,
    1507,  1507,  1507,  1507,  1507,  1507,  1507,  1507,  1507,  1507,
    1507,  1507,  1507,  1507,  1507,  1507,  1507,  1507,  1507,  1507,
    1507,  1507,  1507,  1507,  1507,  1507,  1507,  1507,  1507,  1507,
    1507,  1507,  1507,  1507,  1507,  1507,  1507,  1507,  1507,  1507,
    1507,  1507,  1507,  1507,  1507,  1507,  1507,  1507,  1507,  1507,
    1507,  1507,  1507,  1507,  1507,  1507,  1507,  1507,  1508,  1508,
    1508,  1508,  1508,  1508,  1508,  1508,  1508,  1508,  1508,  1508,
    1508,  1508,  1508,  1508,  1508,  1508,  1508,  1508,  1508,  1508,
    1508,  1508,  1508,  1508,  1508,  1508,  1508,  1508,  1508,  1508,
    1508,  1508,  1508,  1508,  1508,  1508,  1508,  1508,  1508,  1508,
    1508,  1508,  1508,  1508,  1508,  1508,  1508,  1508,  1508,  1508,
    1508,  1508,  1508,  1508,  1508,  1508,  1508,  1508,  1508,  1508,
    1508,  1508,  1508,  1508,  1508,  1508,  1508,  1508,  1508,  1508,
    1508,  1508,  1508,  1508,  1508,  1508,  1508,  1508,  1508,  1508,
    1508,  1508,  1508,  1508,  1508,  1508,  1508,  1508,  1508,  1508,
    1508,  1508,  1508,  1508,  1508,  1508,  1508,  1508,  1508,  1508,
    1508,  1508,  1508,  1508,  1508,  1508,  1508,  1508,  1508,  1508,
    1508,  1508,  1508,  1508,  1508,  1508,  1508,  1508,  1508,  1508,
    1508,  1508,  1508,  1508,  1508,  1508,  1508,  1508,  1508,  1508,
    1508,  1508,  1508,  1508,  1508,  1508,  1508,  1508,  1508,  1508,
    1508,  1508,  1508,  1508,  1508,  1508,  1508,  1508,  1508,  1508,
    1508,  1508,  1508,  1508,  1508,  1508,  1508,  1508,  1508,  1508,
    1508,  1508,  1508,  1508,  1508,  1508,  1508,  1508,  1508,  1508,
    1508,  1508,  1508,  1508,  1508,  1508,  1508,  1508,  1508,  1508,
    1508,  1508,  1508,  1508,  1508,  1508,  1508,  1508,  1508,  1508,
    1508,  1508,  1508,  1508,  1508,  1508,  1508,  1508,  1508,  1508,
    1508,  1508,  1508,  1508,  1508,  1508,  1508,  1508,  1508,  1508,
    1508,  1508,  1508,  1508,  1508,  1508,  1508,  1508,  1508,  1508,
    1508,  1508,  1508,  1508,  1508,  1508,  1508,  1508,  1508,  1508,
    1508,  1508,  1508,  1508,  1508,  1508,  1508,  1508,  1508,  1508,
    1508,  1508,  1508,  1508,  1508,  1508,  1508,  1508,  1508,  1508,
    1508,  1508,  1508,  1508,  1508,  1508,  1508,  1508,  1508,  1508,
    1508,  1508,  1508,  1508,  1508,  1508,  1508,  1508,  1508,  1508,
    1508,  1508,  1508,  1508,  1508,  1508,  1508,  1508,  1508,  1508,
    1508,  1508,  1508,  1508,  1508,  1508,  1508,  1508,  1508,  1508,
    1508,  1508,  1508,  1508,  1508,  1508,  1508,  1508,  1508,  1508,
    1508,  1508,  1508,  1508,  1508,  1508,  1508,  1508,  1510,  1509,
    1512,  1511,  1513,  1511,  1514,  1511,  1516,  1515,  1515,  1517,
    1517,  1519,  1518,  1520,  1518,  1522,  1521,  1521,  1523,  1523,
    1523,  1524,  1524,  1524,  1524,  1525,  1525,  1525,  1525,  1526,
    1527,  1527,  1527,  1527,  1527,  1527,  1527,  1527,  1527,  1528,
    1528,  1528,  1529,  1529,  1529,  1529,  1530,  1531,  1532,  1532,
    1533,  1533,  1533,  1533,  1534,  1534,  1534,  1535,  1535,  1535,
    1535,  1535,  1537,  1536,  1538,  1538,  1539,  1539,  1540,  1541,
    1541,  1541,  1541,  1541,  1543,  1542,  1544,  1544,  1545,  1544,
    1546,  1546,  1547,  1547,  1548,  1548,  1548,  1548,  1549,  1548,
    1550,  1550,  1550,  1550,  1550,  1551,  1552,  1552,  1552,  1552,
    1552,  1552,  1553,  1553,  1554,  1555,  1555,  1555,  1555,  1555,
    1556,  1556,  1557,  1557,  1558,  1558,  1559,  1560,  1560,  1561,
    1561,  1562,  1562,  1563,  1563,  1564,  1564,  1566,  1565,  1567,
    1565,  1568,  1565,  1569,  1565,  1565,  1565,  1565,  1565,  1565,
    1565,  1565,  1565,  1565,  1565,  1565,  1565,  1565,  1565,  1565,
    1565,  1565,  1565,  1565,  1565,  1565,  1565,  1565,  1565,  1565,
    1565,  1570,  1570,  1571,  1571,  1572,  1572,  1572,  1573,  1573,
    1573,  1573,  1574,  1574,  1575,  1575,  1576,  1576,  1577,  1577,
    1578,  1578,  1579,  1579,  1579,  1579,  1579,  1580,  1580,  1581,
    1581,  1582,  1583,  1583,  1583,  1583,  1583,  1584,  1584,  1585,
    1585,  1586,  1586,  1587,  1587,  1587,  1587,  1587,  1589,  1588,
    1590,  1590,  1591,  1591,  1591,  1592,  1592,  1592,  1593,  1593,
    1594,  1595,  1595,  1596,  1597,  1598,  1598,  1600,  1599,  1601,
    1601,  1601,  1602,  1602,  1604,  1603,  1605,  1605,  1606,  1606,
    1606,  1607,  1607,  1608,  1609,  1608,  1610,  1611,  1612,  1613,
    1613,  1614,  1614,  1615,  1615,  1615,  1615,  1615,  1615,  1615,
    1615,  1616,  1616,  1616,  1617,  1617,  1617,  1617,  1617,  1618,
    1618,  1618,  1618,  1618,  1618,  1619,  1619,  1620,  1621,  1622,
    1622,  1622,  1623,  1623,  1623,  1625,  1624,  1626,  1626,  1627,
    1627,  1629,  1628,  1630,  1630,  1631,  1631,  1631,  1631,  1633,
    1634,  1635,  1632,  1636,  1636,  1638,  1639,  1640,  1641,  1642,
    1637,  1644,  1645,  1646,  1647,  1643,  1648,  1648,  1648,  1648,
    1648,  1648,  1649,  1649,  1649,  1650,  1650,  1651,  1651,  1651,
    1652,  1652,  1653,  1654,  1653,  1655,  1655,  1656,  1656,  1657,
    1657,  1658
};

/* YYR2[YYN] -- Number of symbols composing right hand side of rule YYN.  */
static const yytype_uint8 yyr2[] =
{
       0,     2,     1,     0,     4,     2,     0,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     3,     1,     1,     4,     1,
       2,     0,     4,     0,     2,     3,     1,     2,     0,     3,
       0,     6,     1,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     5,
       1,     0,     1,     3,     1,     3,     3,     3,     3,     3,
       3,     3,     0,     1,     1,     0,     7,     0,     0,    15,
       0,     0,    15,     0,     0,    15,     0,     6,     0,     3,
       4,     5,     4,     3,     2,    10,     1,     3,     2,     2,
       2,     2,     2,     2,     2,     0,    13,     0,     6,     2,
       0,     1,     3,     1,     0,     2,     0,     2,     0,     1,
       3,     4,     0,     2,     0,     2,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     0,
       3,     1,     0,     2,     0,     2,     2,     2,     2,     2,
       3,     3,     1,     1,     1,     2,     3,     3,     0,     4,
       0,     3,     0,     1,     3,     1,     0,     1,     3,     1,
       0,     3,     0,     1,     3,     1,     4,     0,     1,     1,
       1,     0,     3,     2,     3,     0,     3,     0,     5,     5,
       0,     7,     5,     0,     2,     1,     1,     1,     3,     1,
       1,     1,     3,     0,     1,     1,     1,     1,     2,     1,
       3,     1,     1,     0,     1,     0,     2,     3,     5,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     3,     4,     0,     1,     1,     3,
       1,     3,     3,     1,     2,     1,     1,     1,     1,     3,
       3,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     3,     0,     2,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     0,     5,     0,     2,     0,     3,     0,     2,     2,
       2,     2,     0,     6,     2,     0,     2,     1,     1,     3,
       0,     0,     0,     7,     0,     2,     2,     1,     1,     0,
       0,     8,     0,     6,     1,     2,     1,     2,     0,     0,
       6,     0,     0,     6,     0,     2,     0,     5,     0,     1,
       0,     5,     0,     2,     0,     5,     4,     0,     0,     8,
       0,     7,     1,     1,     1,     1,     1,     2,     4,     5,
       0,     4,     4,     4,     3,     3,     2,     2,     0,     2,
       1,     2,     3,     1,     1,     1,     1,     1,     2,     3,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       2,     3,     1,     1,     1,     1,     1,     1,     1,     2,
       3,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       2,     3,     1,     1,     1,     2,     2,     2,     1,     1,
       1,     1,     2,     3,     3,     3,     3,     3,     3,     3,
       3,     4,     0,     1,     1,     1,     1,     1,     0,     7,
       3,     0,     5,     1,     2,     4,     0,     0,     5,     0,
       7,     1,     0,     1,     0,     4,     0,     0,     3,     5,
       6,     0,     4,     2,     2,     2,     2,     0,     1,     0,
       3,     0,     1,     1,     3,     1,     4,     5,     5,     0,
       2,     0,     0,     7,     0,    10,     1,     3,     1,     1,
       0,     2,     0,     3,     1,     3,     0,     6,     1,     0,
       0,     5,     0,     4,     1,     1,     1,     3,     1,     3,
       0,     0,     5,     1,     3,     1,     1,     0,     3,     1,
       3,     0,     4,     1,     0,     1,     2,     1,     3,     4,
       3,     3,     3,     3,     4,     4,     3,     0,     0,     6,
       0,     1,     0,     1,     1,     2,     1,     1,     0,     1,
       1,     2,     1,     0,     3,     1,     3,     0,     1,     1,
       2,     1,     2,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     0,     6,     1,     1,     3,     4,
       4,     2,     2,     2,     3,     3,     3,     3,     3,     3,
       3,     4,     4,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     2,     1,     1,     1,
       1,     1,     1,     3,     1,     1,     2,     2,     0,     8,
       0,     9,     0,     9,     0,     9,     8,     2,     0,     1,
       4,     0,     1,     2,     0,     3,     2,     8,     0,     2,
       0,     1,     1,     0,     1,     2,     1,     1,     2,     2,
       4,     3,     3,     3,     3,     1,     2,     1,     1,     3,
       2,     3,     2,     2,     1,     3,     3,     2,     3,     1,
       2,     2,     2,     1,     2,     1,     1,     1,     2,     3,
       2,     3,     2,     2,     3,     3,     3,     0,     6,     0,
       6,     2,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     2,     2,     1,     2,     1,     2,     3,
       2,     1,     1,     1,     1,     1,     1,     1,     2,     0,
       1,     1,     5,     0,     1,     2,     1,     1,     1,     1,
       3,     3,     3,     3,     0,     1,     0,     1,     0,     1,
       2,     1,     1,     2,     2,     4,     1,     3,     2,     1,
       2,     2,     2,     3,     3,     3,     3,     2,     2,     1,
       1,     1,     2,     1,     1,     1,     1,     1,     0,     2,
       1,     1,     1,     1,     1,     0,     2,     1,     1,     0,
       1,     1,     2,     2,     1,     2,     2,     0,     1,     1,
       1,     3,     1,     3,     0,     1,     0,     4,     1,     1,
       1,     0,     1,     2,     1,     1,     2,     1,     3,     3,
       1,     1,     0,     2,     0,     1,     5,     0,     3,     3,
       1,     0,     2,     2,     2,     0,     3,     3,     6,     6,
       1,     1,     2,     2,     2,     1,     2,     2,     1,     1,
       0,     1,     1,     1,     1,     0,     1,     1,     1,     0,
       1,     2,     0,     1,     0,     1,     0,     1,     1,     2,
       1,     2,     1,     2,     2,     2,     3,     2,     3,     3,
       3,     3,     1,     1,     1,     1,     3,     1,     1,     1,
       4,     2,     1,     4,     0,     1,     2,     0,     2,     1,
       3,     0,     0,     7,     0,     5,     7,     0,     5,     0,
       5,     0,     5,     0,     4,     0,    10,     3,     4,     3,
       3,     7,     0,     3,     1,     4,     0,     3,     0,     2,
       0,     1,     0,     2,     2,     2,     2,     1,     1,     1,
       4,     4,     0,     6,     4,     0,     5,     0,     6,     4,
       3,     1,     7,     2,     1,     1,     0,     6,     0,     3,
       2,     0,     5,     0,     0,     6,     1,     3,     1,     1,
       3,     3,     3,     2,     4,     0,     7,     0,     0,     8,
       5,     5,     3,     4,     2,     2,     6,     5,     3,     5,
       1,     1,     1,     1,     1,     0,     1,     1,     2,     2,
       3,     3,     3,     3,     0,     1,     0,     1,     0,     2,
       0,     1,     2,     1,     1,     1,     0,     1,     1,     0,
       2,     1,     0,     1,     1,     1,     0,     6,     0,     5,
       4,     4,     3,     0,     1,     1,     3,     3,     2,     2,
       0,     2,     1,     3,     0,     1,     1,     0,     2,     4,
       1,     3,     0,     5,     0,     1,     1,     0,     6,     0,
       1,     1,     2,     1,     1,     1,     0,     5,     1,     3,
       2,     0,     3,     1,     4,     1,     0,     4,     1,     0,
       4,     0,     1,     3,     0,     1,     3,     1,     1,     2,
       0,     5,     0,     1,     1,     2,     1,     1,     1,     1,
       1,     2,     0,     5,     0,     1,     1,     0,     4,     4,
       3,     5,     1,     3,     3,     0,     6,     1,     1,     1,
       3,     2,     3,     1,     1,     0,     6,     1,     1,     1,
       3,     3,     4,     0,     6,     0,     2,     0,     4,     0,
       2,     1,     2,     4,     2,     3,     2,     3,     0,     3,
       0,     0,     6,     2,     1,     1,     2,     2,     8,     4,
       0,     1,     2,     1,     1,     1,     1,     0,     2,     4,
       3,     1,     1,     3,     4,     0,     0,     0,     2,     2,
       1,     1,     0,     2,     3,     0,     2,     3,     0,     2,
       3,     3,     3,     2,     3,     4,     3,     4,     3,     4,
       1,     3,     4,     3,     3,     6,     1,     5,     6,     5,
       7,     6,     8,     5,     6,     4,     4,     5,     3,     4,
       1,     3,     3,     3,     3,     3,     3,     5,     5,     3,
       3,     3,     3,     3,     3,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     0,     2,     1,     2,     1,     1,     1,     2,
       2,     1,     1,     2,     2,     4,     1,     3,     1,     1,
       1,     1,     1,     3,     1,     1,     1,     1,     3,     2,
       2,     2,     2,     3,     3,     5,     6,     4,     4,     7,
       2,     6,     5,     6,     6,     4,     4,     5,     4,     6,
       2,     2,     4,     4,     4,    10,     6,     8,     6,     4,
       4,     6,     4,     4,     4,     6,     4,     7,     7,     7,
       6,     6,     6,     6,     3,     4,     6,     8,     2,     2,
       8,     8,     6,     6,     2,     6,     6,     8,     8,     6,
       8,     6,     2,     8,     8,     2,     2,     2,     6,     6,
       4,     4,     8,     4,     4,     4,     4,     3,     8,     4,
       4,     6,     4,     4,     4,     6,     8,     4,     3,     6,
       4,     6,     5,     8,     7,    10,     1,     6,     4,     4,
       4,     4,     4,     6,     4,     0,     5,     6,     2,     3,
       0,     4,     0,     3,     0,     1,     1,     3,     4,     4,
       5,     4,     4,     4,     5,     4,     0,     0,     7,     4,
       5,     4,     5,     4,     4,     4,     4,     4,     5,     0,
       8,     0,     3,     3,     1,     4,     0,     1,     0,     2,
       0,     0,     4,     4,     2,     0,     3,     2,     3,     2,
       1,     1,     2,     1,     2,     1,     2,     2,     2,     0,
       3,     0,     1,     1,     3,     1,     3,     1,     3,     0,
       1,     0,     2,     4,     5,     1,     1,     1,     1,     4,
       1,     3,     3,     0,     6,     0,     8,     4,     0,     8,
       0,    10,     6,     0,     8,     0,    10,     6,     1,     2,
       1,     1,     2,     0,     1,     5,     0,     5,     3,     5,
       2,     0,     0,     7,     1,     0,     0,     6,     0,     3,
       0,     0,     5,     0,     1,     0,     1,     0,     2,     3,
       3,     1,     1,     0,     7,     0,     7,     1,     2,     0,
       0,     2,     0,     2,     0,     1,     1,     1,     1,     3,
       1,     3,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     0,     1,     1,
       0,     2,     0,     1,     0,     0,     3,     0,     0,     3,
       2,     0,     0,     4,     4,     2,     0,     1,     1,     3,
       3,     1,     2,     0,     1,     0,     4,     4,     2,     0,
       1,     1,     0,     1,     0,     1,     2,     5,     4,     1,
       3,     3,     1,     1,     1,     1,     1,     1,     0,     2,
       3,     4,     1,     2,     2,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     0,     0,     6,     0,     1,     3,     1,     3,     0,
       2,     3,     1,     2,     1,     0,     3,     0,     0,     7,
       2,     1,     0,     3,     0,     7,     0,     7,     4,     6,
       4,     4,     4,     4,     0,     6,     4,     4,     5,     6,
       4,     1,     3,     1,     2,     1,     3,     1,     0,     2,
       0,     1,     0,     0,     8,     0,     0,     6,     0,     1,
       1,     1,     1,     1,     2,     1,     1,     1,     3,     4,
       0,     3,     3,     1,     2,     2,     0,     3,     0,     5,
       3,     1,     3,     1,     3,     1,     1,     0,     1,     0,
       4,     0,     1,     3,     1,     1,     1,     0,     0,     6,
       0,     0,    11,     3,     1,     3,     3,     1,     3,     0,
       1,     0,     4,     0,     0,     9,     0,     5,     0,     6,
       0,     2,     1,     3,     2,     4,     0,     2,     0,     2,
       1,     1,     1,     0,     4,     0,     1,     0,     1,     1,
       3,     1,     1,     2,     2,     2,     1,     1,     1,     1,
       0,     3,     0,     3,     2,     4,     4,     3,     4,     4,
       1,     3,     3,     3,     3,     6,     2,     2,     0,     6,
       0,     7,     5,     2,     1,     1,     1,     5,     5,     2,
       2,     1,     4,     3,     2,     3,     2,     2,     1,     3,
       4,     3,     3,     2,     3,     2,     3,     1,     1,     1,
       1,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       1,     1,     1,     1,     1,     0,     1,     0,     2,     0,
       1,     1,     1,     0,     2,     0,     2,     0,     2,     2,
       0,     4,     0,     4,     1,     1,     1,     1,     1,     1,
       1,     0,     1,     1,     0,     1,     1,     0,     4,     0,
       4,     1,     0,     1,     4,     0,     3,     3,     1,     2,
       2,     2,     2,     2,     3,     2,     1,     1,     1,     1,
       2,     1,     1,     1,     1,     1,     1,     1,     0,     1,
       0,     3,     0,     3,     3,     1,     0,     4,     1,     2,
       0,     1,     0,     3,     3,     2,     2,     0,     5,     0,
       1,     1,     0,     1,     1,     2,     1,     2,     1,     2,
       0,     0,     0,     0,    22,     1,     1,     0,     1,     0,
       1,     1,     0,     1,     1,     0,     2,     2,     1,     3,
       4,     3,     3,     0,     2,     2,     1,     3,     3,     0,
       4,     0,     3,     1,     1,     0,     3,     2,     3,     1,
       1,     2,     0,     2,     3,     1,     5,     1,     1,     2,
       2,     1,     1,     1,     1,     1,     1,     2,     2,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     2,     2,
       1,     1,     1,     1,     1,     2,     2,     2,     1,     1,
       3,     5,     1,     1,     1,     1,     1,     3,     4,     5,
       1,     5,     3,     2,     1,     3,     2,     2,     4,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     3,     2,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     0,     3,
       0,     3,     0,     3,     0,     3,     0,     3,     2,     0,
       2,     0,     2,     0,     4,     0,     3,     1,     1,     1,
       1,     0,     1,     1,     1,     0,     2,     2,     2,     3,
       3,     4,     6,     2,     3,     3,     2,     3,     5,     1,
       3,     3,     1,     1,     3,     3,     1,     3,     2,     2,
       2,     2,     2,     1,     1,     4,     4,     1,     1,     1,
       1,     1,     0,     4,     1,     1,     1,     3,     3,     1,
       1,     2,     2,     2,     0,     3,     4,     3,     0,     7,
       1,     2,     1,     1,     1,     1,     1,     1,     0,     5,
       1,     1,     1,     1,     1,     3,     6,     6,     6,     7,
       5,     3,     4,     1,     3,     8,     8,     8,     6,     4,
       0,     3,     0,     3,     1,     3,     2,     1,     1,     0,
       1,     1,     2,     0,     1,     1,     3,     0,     3,     0,
       3,     0,     3,     0,     3,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     2,     2,     1,     3,
       2,     2,     2,     2,     2,     2,     2,     2,     1,     1,
       2,     0,     1,     3,     1,     2,     2,     2,     1,     3,
       3,     1,     1,     3,     1,     3,     1,     3,     1,     1,
       1,     1,     4,     5,     4,     6,     1,     0,     3,     3,
       1,     1,     0,     2,     2,     2,     2,     0,     2,     0,
       3,     2,     1,     2,     2,     2,     2,     2,     0,     3,
       0,     1,     0,     3,     2,     0,     1,     2,     0,     1,
       4,     4,     5,     2,     3,     0,     1,     0,     4,     0,
       1,     1,     0,     1,     0,     2,     2,     1,     0,     1,
       1,     2,     3,     2,     0,     6,     3,     0,     0,     0,
       1,     2,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     2,     2,     3,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     0,     3,     3,
       3,     3,     0,     3,     3,     0,     7,     0,     3,     1,
       3,     0,     3,     2,     4,     0,     3,     4,     4,     0,
       0,     0,    16,     8,     7,     0,     0,     0,     0,     0,
      15,     0,     0,     0,     0,    12,     4,     4,     3,     4,
       3,     2,     1,     3,     5,     1,     1,     0,     1,     1,
       0,     2,     0,     0,     3,     0,     2,     5,     3,     3,
       3,     1
};

/* YYDEFACT[STATE-NAME] -- Default rule to reduce with in state
   STATE-NUM when YYTABLE doesn't specify something else to do.  Zero
   means the default is an error.  */
static const yytype_uint16 yydefact[] =
{
       0,   931,  1134,  2688,     0,     0,     0,     0,     0,     0,
    2690,   585,    66,  1791,  1919,  1920,  1702,  1730,     2,     0,
    1134,   276,   179,     0,    78,  1732,     0,  1977,     0,     0,
    1134,     0,   487,     0,  1972,     0,     0,  1134,  1735,  1962,
     253,   179,  2690,     0,  1180,  2478,  1832,  1988,     0,     0,
       0,  1815,     0,  2554,  1780,     0,     0,  2821,     0,     0,
       3,     8,    19,     0,    41,    24,    29,    14,    18,    13,
      54,    48,    26,    39,   128,    38,    10,    57,    58,    16,
      45,    11,    12,    15,    37,    44,    33,    40,    52,  1171,
      22,    23,    30,    46,    62,    20,    59,    55,    21,  1921,
      25,    47,    42,    34,    56,    63,    35,    53,    36,    61,
      28,    49,    27,     9,    17,    50,    51,    43,    64,    31,
      60,    32,     0,   960,     0,     0,     0,     0,     0,     0,
    1038,   943,  2755,  2756,  2757,  1136,  1135,     0,  2690,  2092,
    1119,  1145,  2168,  2170,  2169,  2171,  2172,  2173,  2174,  2175,
    2176,  2109,  2177,  2178,  2180,  2179,  2181,  2182,  2183,  2110,
    2111,  2184,  2185,  2186,  2188,  2187,  2189,  2112,  2113,  2190,
    2191,  2192,  2193,  2114,  2116,  2115,  2194,  2197,  2196,  2195,
    2117,  2198,  2199,  2200,  2202,  2118,  2119,  2120,  2121,  2122,
    2201,  2123,  2203,  2124,  2204,  2205,  2206,  2207,  2208,  2209,
    2210,  2212,  2211,  2125,  2213,  2214,  2216,  2217,  2218,  2215,
    2219,  2221,  2220,  2222,  2223,  2224,  2126,  2225,  2226,  2227,
    2228,  2229,  2230,  2231,  2232,  2127,  2233,  2234,  2235,  2254,
    2128,  2236,  2239,  2238,  2237,  2240,  2241,  2242,  2244,  2243,
    2245,  2246,  2129,  2130,  2247,  2248,  2249,  2250,  2252,  2251,
    2256,  2257,  2258,  2131,  2253,  2255,  2455,  2259,  2260,  2262,
    2261,  2263,  2132,  2265,  2264,  2133,  2267,  2266,  2134,  2135,
    2268,  2269,  2270,  2090,  2271,  2091,  2272,  2275,  2276,  2273,
    2277,  2282,  2136,  2274,  2278,  2279,  2280,  2281,  2283,  2137,
    2285,  2284,  2286,  2287,  2288,  2289,  2290,  2291,  2292,  2293,
    2294,  2307,  2298,  2299,  2301,  2302,  2305,  2300,  2306,  2310,
    2309,  2311,  2312,  2313,  2314,  2315,  2308,  2296,  2303,  2304,
    2297,  2316,  2317,  2295,  2318,  2319,  2320,  2321,  2322,  2323,
    2324,  2325,  2326,  2327,  2328,  2330,  2329,  2331,  2332,  2333,
    2334,  2335,  2336,  2338,  2337,  2339,  2340,  2341,  2343,  2342,
    2345,  2346,  2138,  2344,  2347,  2348,  2349,  2350,  2351,  2353,
    2352,  2139,  2141,  2140,  2142,  2354,  2355,  2143,  2356,  2358,
    2357,  2359,  2360,  2361,  2363,  2362,  2364,  2365,  2144,  2145,
    2366,  2367,  2368,  2369,  2370,  2371,  2372,  2373,  2374,  2375,
    2376,  2377,  2378,  2379,  2381,  2380,  2382,  2383,  2384,  2385,
    2386,  2387,  2388,  2146,  2389,  2147,  2390,  2391,  2148,  2392,
    2149,  2393,  2394,  2395,  2396,  2397,  2150,  2398,  2399,  2400,
    2402,  2403,  2401,  2404,  2151,  2405,  2406,  2407,  2152,  2409,
    2408,  2410,  2153,  2412,  2154,  2155,  2411,  2157,  2158,  2413,
    2414,  2415,  2156,  2416,  2159,  2417,  2418,  2420,  2419,  2421,
    2422,  2423,  2160,  2424,  2161,  2425,  2426,  2427,  2428,  2429,
    2431,  2430,  2432,  2433,  2434,  2435,  2438,  2440,  2437,  2439,
    2436,  2441,  2442,  2443,  2444,  2448,  2449,  2450,  2451,  2445,
    2446,  2447,  2162,  2452,  2453,  2454,  2456,  2457,  2459,  2458,
    2163,  2164,  2460,  2461,  2167,  2462,  2463,  2464,  2468,  2465,
    2477,  2466,  2467,  2470,  2469,  2471,  2472,  2473,  2165,  2474,
    2166,  2475,  2476,   198,  2095,   181,  2096,  2108,   112,  2545,
    2544,  1082,  1120,  2691,  2692,   583,   887,     0,     0,   179,
       0,   888,     0,   886,   179,   134,     0,     0,     0,  1808,
       0,  1728,  1728,  1728,  1728,     0,  1728,   179,  1728,     0,
    1731,  1728,   179,  1728,     0,    71,  1927,   277,     0,     0,
       0,     0,     0,  2089,     0,  1738,     0,     0,  1979,  1995,
       0,  1996,  1990,  2542,     0,  1205,     0,     0,     0,     0,
     179,  1137,     0,  1789,     0,   243,   252,   254,   255,   251,
       0,  2692,  2703,  1172,  1178,  1190,     0,  1899,   255,     0,
     112,  1063,     0,   112,  1816,  1813,     0,     0,     0,  1789,
    1989,  2805,     0,     0,     0,  2801,     0,  2806,     0,  1180,
       0,     0,     1,     5,     0,     0,   582,  2757,     0,   579,
     580,  2249,  2358,  1912,  1910,  2084,     0,   934,   961,     0,
     939,     0,   937,  2101,  2100,  2099,     0,   950,   949,   947,
       0,   448,     0,  1040,     0,  2762,   941,  1096,  2689,     0,
     200,     0,     0,   113,   114,     0,     0,     0,  2695,     0,
       0,     0,   586,     0,     0,   133,     0,     0,   583,   583,
     583,  1812,  1811,  1810,     0,  1808,  2169,  2109,  2183,     0,
    2057,     0,     0,     0,  1489,     0,  2114,     0,  2198,  2200,
    2118,  2119,  2120,  2121,  2122,  2125,     0,     0,  1218,  1218,
    1218,  1215,     0,     0,     0,  2223,  2224,  2063,     0,     0,
       0,  2053,  2064,  2262,  2263,     0,  2055,  2056,  2269,     0,
       0,     0,  2284,     0,  2289,  2061,     0,     0,  2325,  2327,
       0,     0,  2331,  2332,  2333,  2334,  2038,  1273,     0,  1215,
    2052,  2060,  2350,  2045,  2359,  2364,  2365,     0,  2374,     0,
       0,  2396,     0,  2403,  2401,  2407,     0,     0,  2428,     0,
       0,  1215,  2037,  2448,  2449,  2450,  2451,     0,  2054,  2162,
    2062,     0,  2462,  1218,  1215,  1215,     0,     0,     0,  2471,
    2472,  2476,     0,     0,     0,  2727,  1272,     0,  1451,     0,
    1483,  1230,  1236,  1250,     0,  1265,  1299,  1300,  1302,  1406,
    1301,  1307,  1306,  1703,  2049,  1305,  1304,  2050,  2051,  1298,
    2074,  2095,  2073,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1895,     0,     0,  1714,  1728,    73,     0,     0,
    2603,  2618,  2619,  1218,  2615,  2620,  2243,  2130,  2256,     0,
    2617,  2609,     0,  2369,  2373,  2613,  2388,  2391,  2607,     0,
    2154,  2432,  2639,  2611,  2616,  2597,  2584,  2598,     0,     0,
    2601,  2605,  2086,  1597,  2557,  2558,     0,    79,  1740,  1741,
    1739,  1036,     0,  2818,  1980,  1981,  1982,     0,  1999,     0,
    1132,     0,     0,   497,   488,     0,  1894,  1893,     0,  1973,
    2704,     0,     0,  1087,  1743,  1790,     0,  1742,  1968,     0,
    1966,  1963,  1965,   244,     0,     0,   274,  2170,  2603,  2373,
    2575,     0,  2583,     0,  2698,  2695,  2705,  2740,  2735,  2734,
    2737,  2738,  1196,  2739,  1195,  2736,  2733,  1205,  1191,  1193,
    1194,   803,     0,     0,  2498,  2499,  2338,  2359,  2397,  2500,
    2445,     0,     0,  2519,  2479,  2484,  2480,     0,     0,  1854,
       0,   803,  1877,  1907,  1855,     0,     0,  1907,     0,  1632,
    1897,  1900,     0,  2502,  1868,   884,   883,  1880,   882,  2503,
    1893,     0,  1840,  1856,     0,  1817,  1861,   112,  2504,     0,
    1896,  1879,     0,  1878,  1632,  1907,     0,  1833,     0,     0,
       0,     0,     0,   250,  1070,  1070,     0,     0,  1062,  1064,
    1065,  1070,  1070,     0,  2819,  2820,  2555,  1036,  2044,  2042,
    2043,  2093,  2802,  2041,  2810,  2812,  2798,  2800,  2807,  1174,
       0,  2709,     6,    65,   129,  1205,  1205,  2757,   583,   581,
       0,  1924,  2760,  2761,  2759,   819,     0,  1218,  2102,  2105,
    2758,  2106,   182,   948,     0,   449,   182,     0,     0,     0,
       0,     0,   450,   451,   387,     0,  1044,  1045,  1039,  1041,
    1043,   945,     0,     0,   944,  2762,     0,     0,  1147,  1149,
    1148,  1165,   202,   199,   180,    80,  1084,  1721,  1723,  1122,
    2694,     0,     0,  2696,  2700,  1271,  1270,     0,   126,   132,
       0,  2590,  2594,     0,     0,  2105,  2666,     0,   130,  2654,
       0,     0,     0,     0,  1792,  1796,  1802,  1806,  1809,     0,
       0,  1602,  1320,  1602,  1602,  1602,  1490,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1602,     0,  1358,  1330,  1331,     0,  1359,     0,     0,     0,
    2065,     0,     0,     0,  2727,     0,     0,     0,  1456,     0,
       0,     0,  2727,     0,     0,     0,     0,     0,     0,  1485,
    1487,  2073,  1602,     0,     0,  1602,     0,     0,     0,     0,
       0,  1223,  1364,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1602,  1602,     0,     0,
    1602,  1372,  2067,     0,     0,     0,  2066,     0,     0,     0,
    2059,   800,   801,  2039,  2058,     0,  1375,  1377,  1376,     0,
    1602,  1602,     0,     0,     0,  1310,  1309,  1311,     0,     0,
       0,     0,     0,     0,  1269,  1268,  1267,  1266,     0,     0,
       0,  1274,     0,  1275,  1276,     0,  1277,  1278,  1279,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1312,     0,
       0,     0,  2040,  1415,     0,  1729,  1708,  1716,  1710,     0,
    1895,  1711,  1713,  1720,   462,     0,  1717,  2107,  2652,  1712,
       0,  1704,     0,    72,     0,  1951,  1956,     0,     0,     0,
    1946,  1954,  1948,  1955,  1947,     0,     0,  1957,   112,     0,
    1949,  1953,  1952,  1928,  1931,  1938,  1929,     0,     0,   275,
     278,   280,     0,   283,  2604,  2602,  2636,  2635,  2640,     0,
    2637,  2633,  2596,  2626,  2667,  2630,     0,  2667,  2632,  2631,
    2667,  2627,  2634,  2667,     0,  2599,     0,  1598,  1599,     0,
    2556,     0,  2085,  1037,     0,     0,  1983,  1984,     0,  1155,
    2000,  2001,  1997,  1597,  2543,  2546,     0,   690,  1206,   498,
       0,     0,   509,     0,     0,    68,    69,     0,  1139,     0,
    1138,  1142,     0,     0,     0,  1746,  1736,  1745,  1523,  1969,
     112,     0,   242,   267,   262,   270,   264,   266,   265,   271,
     272,   273,   268,   263,   269,   256,     0,     0,  2602,     0,
       0,  2599,  2699,     0,  2701,  2718,  1179,  2706,  1202,  1181,
    1201,     0,  1192,   802,     0,   805,   807,  1765,  1766,   806,
     815,     0,   804,     0,     0,  2516,     0,  2505,     0,   811,
     813,   812,  2513,   810,     0,     0,  2489,     0,     0,  1903,
       0,     0,  1867,     0,   583,     0,     0,     0,     0,     0,
       0,  1834,     0,     0,   634,     0,  1860,  1633,  1901,  1902,
    1907,     0,     0,  1907,     0,  1873,  1897,  1907,     0,  1907,
    1829,     0,     0,  1821,  1826,  1822,     0,  1828,  1827,  1830,
    1818,  1819,     0,  1847,  1875,     0,  1897,  1859,  1866,     0,
    1846,  1853,     0,  1864,  1897,  1897,     0,  1907,  1907,  1058,
    1074,  1056,  1068,  1069,     0,     0,  1061,  1060,  1814,  1526,
       0,     0,  2799,  2813,  2797,  2808,  2809,  2796,  1175,  2710,
    1173,  2711,     0,     7,     4,  1205,  1205,  1205,  2754,     0,
    2742,  2749,  2750,  2753,  2752,  2751,  2748,     0,  2741,  2744,
    2745,  2747,  2746,  2762,     0,  1914,  1915,  1916,  1917,  1918,
    1913,  1911,  1925,  1926,   820,   819,   574,   577,   576,     0,
       0,  2104,     0,   940,     0,  1895,   938,     0,     0,  1895,
     398,  1895,   452,   932,  1042,   952,     0,     0,   942,  1097,
    1098,  1101,     0,     0,   486,  1165,  1151,  1167,     0,   203,
     205,     0,  1086,  1085,     0,  1083,  1130,  1129,  1127,     0,
    1128,  1126,  1121,  1123,  1124,  2693,  2697,   584,   819,  1895,
       0,     0,   131,     0,   390,     0,     0,   889,   889,   889,
    1798,  1725,  1523,  1727,  2084,     0,     0,     0,  1804,     0,
       0,  1603,  1602,     0,  1465,     0,     0,     0,     0,  1491,
       0,     0,     0,     0,     0,     0,     0,     0,  1296,     0,
       0,     0,     0,     0,  1436,     0,  1465,  1219,  1677,  1678,
    1662,  1663,  1661,  1664,  1216,     0,  1665,  1676,  1387,     0,
       0,     0,     0,     0,     0,  1573,  1574,  1575,  1576,  1584,
    1577,  1578,  1579,  1586,  1591,  1580,  1581,  1587,  1588,  1589,
    1582,  1590,  1585,  1583,  1592,     0,  1572,     0,  1595,  1593,
    1596,  1594,     0,  1457,  1449,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1602,     0,     0,
       0,  1602,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1398,
       0,     0,     0,     0,     0,  1602,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1354,     0,  2076,  2075,
       0,     0,     0,   852,     0,  1314,     0,  1313,  1535,     0,
    2712,  2728,     0,  2505,  1452,  1454,     0,  1221,  1220,  1222,
    1233,  1226,  1231,  1224,  1228,     0,  1280,  2176,  1234,     0,
       0,  1262,  2727,  1611,  1263,  1248,  1253,  1254,     0,  1251,
    1252,     0,  1256,     0,  1255,  1259,  1260,  1261,  1264,     0,
       0,     0,     0,  1303,  1308,  1484,  1205,  2077,     0,     0,
     462,   465,   464,  1718,   463,  1767,     0,  1046,     0,     0,
      74,    76,  1943,  1940,  1939,  1941,  1945,   112,  1950,  1942,
       0,  1958,  2223,  2448,  2451,   287,     0,   260,   259,   261,
     284,     0,     0,  2629,     0,  2610,     0,  2614,  2608,  2612,
    2592,     0,     0,  2600,     0,  2638,  2621,  2625,  2624,  2622,
       0,  2623,  2628,  2606,  1601,  2257,  2342,     0,  1604,  2560,
    1733,  2817,  1985,  2462,  1986,  1978,     0,  1998,     0,     0,
       0,  1133,   691,     0,  1205,   496,   495,   494,   493,     0,
     511,   491,   499,    70,     0,     0,  1974,     0,     0,     0,
       0,  1089,  1744,     0,     0,  1724,  1524,  1970,  1964,     0,
       0,     0,     0,     0,  2656,  2581,     0,     0,     0,  2702,
    2720,  2719,  2707,  1205,  1623,  1206,  1206,  2073,  2521,     0,
    2515,  2514,     0,     0,     0,  2534,  2517,     0,     0,  2483,
    2522,  2523,  2526,     0,     0,     0,     0,     0,  2520,  2445,
    2485,  2486,     0,  2491,  2481,  2540,  2541,  2538,  2539,  2537,
    2510,  1874,     0,  1905,  1908,  1909,     0,     0,  1888,  1882,
    1881,  1871,  1883,  1872,  1892,  1891,  1890,  1844,  1843,  1645,
    1646,  2400,  1644,  1636,  1639,  1643,  1642,  1837,  1898,  1887,
    1885,  1869,  1907,  1842,  1841,  1886,  1884,  1823,  1824,  1825,
       0,  1632,     0,  1903,  1876,  1907,  1897,     0,  1907,  1907,
    1889,  1863,  1865,  1059,  1076,  1075,  1071,  1072,  1077,  1067,
    1066,  1544,  1543,     0,  1498,     0,  1500,  1497,  1496,  1495,
       0,  1543,  2803,  2811,  2815,     0,  1632,  2717,  2715,     0,
       0,     0,   583,     0,     0,  2743,   115,   575,  1767,  1767,
       0,  2103,     0,     0,     0,     0,     0,     0,     0,   183,
     192,     0,     0,   396,   397,  1767,   395,   438,   439,   442,
     443,   444,     0,     0,     0,     0,     0,     0,     0,     0,
     136,   445,  1767,  1767,   392,   418,   419,   422,   423,   424,
     425,   426,   388,     0,   393,   819,     0,   954,   956,  2763,
    2764,  2765,     0,     0,  1100,  1154,  1146,  1153,  1150,  1165,
    1163,  1152,   879,   878,     0,  1166,   201,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    81,
      82,   100,  1722,  1131,  1125,   127,   819,  1767,  1767,  1767,
    1767,   394,   427,   428,   431,   432,   433,   434,   437,   435,
     436,     0,  2595,     0,     0,  1895,     0,  2658,  2659,     0,
    2655,   890,     0,     0,     0,     0,     0,  1793,     0,  2087,
    1803,  1526,  1807,  1806,     0,  1383,     0,  1429,     0,  1431,
    1432,  1433,     0,     0,     0,     0,     0,  1384,     0,  1328,
    1385,  1386,     0,  1380,     0,  1381,     0,     0,     0,     0,
       0,     0,     0,  1435,     0,  1217,     0,     0,  1332,  1333,
    1325,  1317,     0,  1408,     0,     0,  1334,     0,     0,     0,
       0,  1389,     0,  1409,  1486,     0,  1488,  2077,     0,  1441,
    1390,  1339,     0,  1439,     0,  1340,  1410,  1411,  1412,  1392,
    1393,     0,  1414,     0,  1394,     0,     0,  1397,     0,     0,
    1342,  1445,  1443,     0,     0,     0,     0,  1447,  1344,     0,
       0,     0,  1343,     0,     0,     0,     0,     0,     0,     0,
    1346,     0,  1326,  1444,  1446,  1400,     0,     0,     0,     0,
       0,  1355,     0,  2721,  1534,  2729,  1535,     0,     0,  2723,
    2713,  2718,  2726,  1318,     0,     0,  2078,  1227,  1232,  1225,
    1229,  2727,     0,     0,     0,     0,  1246,  1245,     0,     0,
       0,  2727,  1611,  1249,     0,     0,  1425,  1426,  1481,     0,
    1709,  1706,  1719,  1768,     0,  2653,  1048,  1047,  1715,  1046,
      77,     0,  1944,  1937,  1959,  1932,     0,   279,   288,   281,
     285,   286,   282,  2671,     0,  2670,     0,     0,  2589,  2648,
    2651,  2084,     0,     0,     0,  2570,  2564,  2571,  2573,  2567,
    2572,  2574,  2565,  2566,  2561,  2568,  1605,  1634,     0,  1987,
    1156,  1158,  1159,  1157,  1165,     0,     0,  2549,  2550,  2548,
    2547,   501,     0,   510,     0,   522,     0,     0,     0,  1976,
    1975,     0,  1140,  1143,  1144,  1094,  1093,  1095,  1088,  1090,
    1091,   567,  1750,     0,     0,     0,  1756,  1737,  1747,     0,
    1971,  1967,     0,   257,  2582,     0,     0,     0,     0,     0,
       0,     0,  1200,  1526,  1695,  1197,  1185,  1634,  1624,  1184,
    1207,  1203,     0,   818,   817,   816,   814,     0,     0,     0,
       0,  2528,  2529,     0,     0,  2506,  2507,  2508,     0,  2511,
    2488,  2489,     0,  2490,     0,  1904,     0,  1848,     0,  1870,
       0,     0,     0,     0,  1839,     0,  1862,  1820,  1905,  1838,
    1604,  1897,  1835,  1836,  1074,     0,  1057,  1543,  1526,     0,
       0,  1518,  1545,     0,  1545,  1520,  1521,  1526,     0,  1526,
    1523,  1540,     0,     0,  2814,  1625,  2716,     0,  2791,     0,
       0,     0,   181,   587,     0,     0,   936,   186,   189,   187,
       0,   188,     0,     0,   447,   446,     0,  1895,   440,   140,
     139,   141,   142,  1659,  1660,  1656,  1657,  1655,  1658,   144,
     143,   138,   951,     0,     0,     0,  1895,   420,   399,   400,
     403,   404,   405,  1034,  1767,  1034,     0,  1767,  1767,  1034,
    1767,     0,     0,  1767,  1767,     0,     0,  1767,     0,     0,
    1034,     0,  1767,     0,  1021,     0,     0,  1767,  1767,  1767,
    1767,  1767,  1034,     0,     0,  1767,  1767,   486,  1767,     0,
       0,  1052,     0,     0,  1767,  1767,  1767,  1767,     0,     0,
    1767,  1767,     0,  1767,   968,  1020,   589,   616,   617,   933,
     967,   969,   981,   482,     0,   999,  1023,  1024,  1022,     0,
       0,     0,     0,   150,  2767,  1099,     0,     0,  1564,   204,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1895,   429,  2591,     0,
       0,  1767,   389,   406,   407,   410,   411,   412,   413,   414,
     417,   415,   416,     0,  2662,  2664,     0,     0,   891,     0,
       0,     0,  1726,  1806,  1526,  1604,  2085,  1604,     0,  1805,
       0,     0,  1430,  1466,     0,  1492,     0,  1322,   774,   774,
     774,  1475,   759,  1479,  1470,   774,  1471,   774,  1473,     0,
       0,     0,  1282,  1297,     0,     0,     0,     0,     0,  1437,
    1434,     0,     0,     0,     0,  1460,     0,     0,     0,  1327,
       0,  1420,  1442,  1440,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1448,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     841,   847,   850,   851,   853,   845,     0,  1402,  1315,  1205,
    2730,  2732,  1176,     0,  2722,  2724,   927,  1453,     0,  1243,
    1239,     0,  1237,  1610,  1258,  1257,     0,     0,     0,  1247,
    1206,  1416,  1205,     0,  1482,  2079,  1707,   461,   633,  1705,
      75,  1935,     0,  1930,  1933,     0,     0,  2668,     0,  2679,
       0,     0,     0,     0,     0,     0,     0,     0,  2559,  1635,
    1777,     0,  1165,  1169,  2094,  1991,  2552,  2553,  2551,     0,
     502,   503,   505,  1206,   519,   497,     0,   489,   492,     0,
     501,     0,  1092,  1190,     0,  1769,  1754,  1761,  1755,     0,
       0,     0,  1753,  2069,  2068,  2075,  2705,     0,  1570,     0,
       0,  2580,  2657,     0,     0,     0,  2708,  1604,  1604,  1689,
       0,     0,  1182,  1187,  1183,  1186,     0,  1204,  1211,  1210,
    2070,  2077,  2518,     0,     0,     0,     0,  2533,  2527,  2524,
    2525,     0,  2487,  2509,  2493,  2492,  2495,  2497,  1669,  1670,
    1668,  1666,  1667,  1906,  1632,  1858,  1857,  1647,  1638,     0,
    1641,  1640,  1831,  1850,  1852,  1907,  1073,     0,  1080,  1078,
       0,  2712,  1538,     0,  1522,  1519,  1546,     0,  1545,  1545,
    1526,     0,  1502,  1781,  1784,     0,  1501,  1597,  1528,  1190,
    2804,  2816,     0,     0,     0,   383,   382,     0,   145,  2785,
       0,     0,   671,   116,   473,   482,   588,   591,   632,   631,
     191,   190,   196,   197,  1673,  1674,  1671,  1672,   453,   466,
    1675,   467,   441,   137,   454,   455,   421,     0,   401,  1035,
     924,   583,  1003,     0,   672,   583,   875,   880,   880,   583,
       0,     0,  1134,     0,     0,  1728,     0,     0,  1134,     0,
       0,     0,  1767,     0,  1014,   963,     0,  1728,     0,  1728,
    1728,  1015,     0,     0,   964,  1767,     0,     0,     0,     0,
       0,  1728,  1134,     0,     0,     0,   484,     0,  1134,   983,
    1055,  1054,  1053,     0,  1134,  1134,     0,     0,     0,     0,
     622,   623,   621,     0,     0,     0,   614,   590,   819,   965,
     483,   966,   671,     0,  1049,   668,   674,  2080,     0,     0,
     160,     0,     0,   953,     0,   153,   151,   162,     0,     0,
    1103,     0,  1102,     0,  1567,     0,  1568,  1565,  1566,   101,
      88,    84,   105,   106,    86,    87,    91,    90,    92,    93,
      96,    97,    94,    89,    95,    85,   109,   111,   110,    98,
     107,   108,    83,   460,   459,   458,   457,   430,     0,     0,
       0,  1895,   408,  2663,  2661,  2660,     0,   917,   919,   918,
     905,   904,   117,   120,   123,     0,  1604,  1623,  2088,  1797,
       0,  1356,  1493,     0,     0,   775,  1467,   827,  1477,     0,
    1478,   761,   760,   776,  1469,  1472,  1476,  1474,  1321,  1329,
    1378,     0,  1295,  1379,     0,  1407,  1324,  1323,     0,     0,
       0,  1362,  1363,     0,  1458,     0,     0,  1336,     0,  1338,
       0,     0,  1422,  1391,  1413,  1365,  1395,     0,  1341,  1316,
       0,  1366,     0,  1371,  1369,     0,  1345,     0,     0,  1352,
       0,  1350,     0,  1351,     0,  1353,  1399,  1401,     0,     0,
     852,   838,   839,   840,     0,   842,   844,   846,     0,     0,
    1536,  2731,  1177,     0,     0,  1455,  1235,     0,  1244,  1241,
       0,  1238,  1207,  1427,  1417,     0,     0,   296,   291,   299,
     293,   295,   294,   300,   301,   302,   303,   297,   292,   298,
     290,   289,  2669,     0,  2588,  2593,  2650,  2649,  2672,  2672,
    2672,     0,  1606,     0,  1734,  1160,  1165,  1169,     0,  1161,
    2002,   506,     0,     0,     0,   526,     0,   524,   500,     0,
    1141,  1205,  1751,  1763,     0,  1771,     0,     0,  1748,  1758,
       0,     0,     0,  1757,   486,     0,   258,     0,  2577,  2578,
    2576,  1634,  1612,     0,     0,  1701,     0,  1696,  1198,     0,
    1209,  1208,     0,  2536,  2535,  2531,  2530,  2532,  2512,     0,
       0,  1849,  1637,  1632,  1845,     0,     0,  2718,  1597,  1530,
    1526,  1499,  1526,     0,     0,  1507,  1526,  1503,  1505,     0,
    1604,     0,  1562,  1205,  2072,  1626,  1629,     0,  2792,   386,
     384,   385,     0,     0,   206,   649,   650,   648,   647,     0,
     474,     0,     0,     0,   651,   652,   654,   655,  2002,   481,
     819,   592,   402,   673,   925,  1134,     0,     0,     0,   880,
     667,   583,   924,   889,   881,   583,   583,  1001,  1030,  1031,
       0,     0,   600,   597,     0,   609,   984,   975,   985,   996,
     998,     0,   599,   624,     0,     0,   612,  1728,     0,  1012,
       0,     0,   594,     0,     0,   643,   644,   642,   618,   625,
    1032,  1033,   595,   596,     0,     0,  1619,  1621,  1629,   602,
     601,  1680,  1679,   611,     0,   598,     0,  1018,   991,     0,
     640,   638,   635,   637,   636,   641,   639,   613,   604,   603,
     606,   605,   608,   607,   610,   626,   980,     0,  1034,  1034,
    1000,     0,  2083,     0,  1051,  1002,     0,   656,   669,   657,
       0,     0,   630,   629,   627,   628,   161,   149,     0,     0,
     955,   957,     0,     0,   958,  2769,     0,  2771,  1105,  1106,
       0,     0,  1168,     0,     0,   102,   104,     0,   391,   456,
     409,  2665,     0,     0,     0,  1806,  1799,  1648,     0,  1494,
       0,     0,     0,     0,   821,   832,   830,   824,     0,   828,
     829,  1468,     0,     0,   777,  1480,   741,   774,  1292,   759,
    1286,  1288,  1284,     0,   742,  1287,   774,     0,   827,  1291,
    1283,     0,  1438,     0,     0,  1461,     0,     0,     0,     0,
       0,     0,     0,  1319,     0,  1418,     0,     0,     0,     0,
       0,     0,  1349,  1347,  1348,   836,  1404,     0,   849,   843,
     841,   848,     0,  1634,  2712,   928,  1240,     0,  1428,  1936,
    1960,     0,     0,  2677,  2677,  2677,  1776,  1775,     0,  1774,
    1778,  1162,  1170,  2004,  2003,     0,   504,   507,     0,   499,
       0,   523,     0,   490,   568,     0,     0,     0,  1772,  1760,
    2709,  1749,  1752,  2077,  1525,  1571,  2579,  1189,     0,  1607,
    1700,  1697,     0,  1690,  1692,  1694,     0,  2071,  2494,  2496,
    1851,  1079,  1081,  1531,  1529,  1539,     0,  1495,  1526,  1526,
       0,  1495,     0,     0,  1783,  1623,  1785,  1527,  1559,  1541,
       0,  1630,  1631,  1628,     0,   217,  1205,     0,     0,   207,
     209,   210,     0,     0,   471,   468,   671,   470,   570,   593,
     986,     0,   583,   876,   877,   889,   926,     0,   889,   889,
       0,     0,   974,  1005,  1122,     0,   979,   815,   619,     0,
     970,  1013,  1046,     0,   620,  1007,   972,     0,  1622,   485,
     971,   993,   977,  1958,  1004,  1050,   857,   755,   704,   695,
     774,   698,   697,   774,   709,   759,   757,   727,   759,   759,
     734,   733,   751,   737,   717,   827,   827,   716,   754,   827,
     738,   736,   740,     0,   742,   759,   747,   735,   739,   756,
     732,   729,   753,   774,   774,   774,   713,   752,   827,     0,
     745,   774,   675,   778,   715,   827,   834,     0,     0,   774,
     776,  2082,   147,   152,   163,   164,   946,  2768,     0,  2766,
       0,  1111,     0,  1164,  1569,    99,     0,     0,     0,     0,
       0,     0,  1794,  1357,   772,   770,   773,   771,   823,   822,
     826,     0,   825,   834,     0,     0,  1294,  1289,   743,  1293,
    1285,  1290,  1382,  1360,  1361,     0,  1459,  1450,  1388,     0,
    1337,  1419,     0,     0,  1396,  1367,  1370,  1368,  1373,  1374,
       0,  1403,     0,  1197,  1197,   645,  2725,  1242,     0,  1934,
    2680,     0,     0,  2676,  2674,     0,  2675,  2673,  2641,     0,
    2586,  2587,  2585,  2569,     0,     0,     0,  1205,   512,     0,
     529,   528,   525,  1634,  1762,  1764,  1770,  1759,     0,  1608,
    1623,   808,  1693,     0,  1199,     0,  1508,     0,  1512,  1517,
    1513,     0,  1504,     0,  1648,  1563,     0,  1634,  1629,     0,
     220,   218,   219,     0,   213,   215,   210,  2779,     0,  2786,
       0,     0,  2784,   475,  2709,   587,   653,   571,     0,   988,
       0,     0,     0,     0,     0,     0,  1017,     0,     0,   976,
     997,  1019,  1011,  1010,     0,     0,  1134,  1620,   992,   994,
    1089,     0,     0,   861,   703,   696,   714,   712,   763,   758,
       0,   763,   763,   723,   741,   718,     0,   827,   731,   722,
     743,   746,   748,   750,   763,     0,   827,   711,   710,   720,
     707,   763,   786,     0,     0,     0,     0,   782,     0,   855,
       0,   789,     0,   676,   779,   781,     0,     0,     0,   744,
     827,   700,   835,   834,   702,   827,   834,   763,   763,     0,
     154,   959,   323,  2770,  1180,     0,  2775,     0,  1112,  1108,
    1109,  1104,   103,   135,     0,  1629,   922,     0,     0,  2400,
    1649,  1800,   833,   831,     0,  1462,  1629,     0,  1421,  1423,
     837,     0,  1537,   646,     0,  2647,  2646,  2645,  2642,     0,
       0,     0,     0,     0,     0,  2678,  2682,  1773,     0,     0,
       0,   520,     0,     0,   554,   569,  1616,  1629,     0,  1634,
       0,  1698,  1691,  1532,     0,     0,     0,     0,     0,  1782,
    1551,  1552,     0,     0,  1557,  1561,  1542,  1627,  2783,  2793,
     217,     0,     0,   158,     0,   208,   815,   211,   472,   482,
       0,   477,     0,     0,   987,   670,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1016,  2046,  1049,   486,
    1008,   973,     0,   978,   615,     0,   860,     0,   865,   767,
     768,   769,   724,   764,   766,     0,   726,   694,   719,   749,
     725,     0,   721,   708,   792,   791,  1212,   784,   799,   679,
       0,     0,   790,     0,   780,   788,   783,     0,   699,   701,
     705,   706,   692,   693,  2081,     0,   156,   349,     0,   335,
     321,     0,     0,     0,   325,   165,   168,   166,     0,   167,
     173,     0,   174,   175,   176,   177,   178,   169,   347,   348,
     172,   170,   171,     0,  2097,     0,  2098,  2773,     0,     0,
    2772,  1107,     0,  1114,   892,     0,   921,     0,   894,   896,
    1650,     0,  1205,  1795,   762,     0,  1464,  1335,  1405,  1961,
    2643,  2683,  2686,  2684,  2685,  1652,     0,  2687,  2681,     0,
    1523,  1206,     0,   513,     0,   516,   518,   532,     0,  1767,
    1767,     0,     0,  1767,  1767,  1767,  1767,   547,   555,   557,
       0,  1617,  1618,     0,  1613,  1615,  1609,  1681,   809,  2005,
    2712,  1509,     0,  1514,     0,  1506,  1547,  1547,  1558,   184,
     214,     0,     0,   150,   159,  2787,   797,  2002,     0,  2705,
     990,     0,     0,     0,   658,     0,     0,  2048,  2047,  1006,
     982,  1049,     0,   858,     0,   862,   863,   864,     0,   856,
     765,     0,   929,     0,     0,   798,  1212,   787,  1205,   796,
     795,   793,   794,   155,     0,   148,     0,     0,   334,   337,
       0,     0,   340,   330,   329,   331,     0,   324,   323,   323,
     377,   328,   374,   373,   366,  2709,     0,     0,     0,  1113,
    1118,     0,  1115,  1117,     0,  1767,   118,   893,   913,   912,
     898,     0,  1629,     0,     0,   121,   895,   915,   902,   124,
     897,   914,   900,  1651,  1801,  1629,  1654,  1653,  1779,  1787,
       0,  1992,     0,   521,   514,     0,     0,   530,     0,     0,
    1767,  1767,     0,     0,     0,     0,     0,   527,   556,  1767,
    1629,     0,  1188,     0,  2013,  1533,     0,     0,     0,  1555,
    1553,  2794,   216,  1205,   162,     0,   469,   479,   478,   989,
       0,   664,   892,   660,   662,  1009,     0,   859,     0,     0,
     827,     0,   827,  1213,     0,   785,     0,   157,   350,   361,
     364,   356,   336,     0,     0,     0,   326,   323,     0,   310,
     308,   309,   315,   316,   317,   318,   319,   320,   311,   314,
     312,   313,   323,     0,   225,     0,     0,  2774,     0,  2776,
       0,  1110,     0,   907,     0,  1025,   899,     0,   920,   923,
       0,  1025,   903,  1025,   901,  1463,     0,     0,   808,   508,
     520,   517,   540,   533,   536,     0,   566,   560,     0,     0,
     562,   563,   561,   558,   551,     0,   549,     0,  1614,  1682,
       0,     0,     0,     0,  2006,  2008,     0,  1699,  1511,  1516,
       0,  1548,     0,     0,     0,   194,   193,   185,     0,   323,
    2780,     0,  2788,  2709,   666,   892,   659,   894,   896,     0,
     871,     0,   870,     0,   867,   866,   728,   930,   730,  1214,
     680,     0,     0,   323,   357,     0,   332,     0,     0,     0,
       0,   223,   380,     0,   221,   368,   368,  2777,  2778,  1116,
     906,   119,  1027,  1026,   911,   910,   908,   909,   916,   122,
     125,  1786,  1788,  1993,   515,   540,     0,   538,     0,   534,
     531,   535,   564,   565,     0,   548,     0,   559,     0,     0,
       0,     0,     0,  2007,     0,     0,  2014,  2016,  1550,  1549,
    1564,     0,   195,  2795,     0,   164,   184,   480,   665,   661,
     663,   995,   873,   874,   872,     0,     0,   682,   681,   683,
     358,   364,   354,   362,   323,     0,     0,   322,   341,   376,
     224,     0,   378,     0,   323,     0,   367,   369,   371,  1029,
    1028,  2019,   537,     0,   545,   541,   543,   546,   554,   553,
     550,  1205,  2011,  2012,     0,  2009,     0,     0,  2015,     0,
       0,     0,   146,  2789,     0,     0,     0,   687,   677,   684,
     686,     0,   355,     0,     0,   353,   333,   338,   323,     0,
     323,   236,   235,     0,   227,   304,   375,     0,   226,     0,
    2005,   539,     0,     0,   552,     0,     0,  1685,  1687,  2010,
    2018,  2017,  1556,  1554,  2781,   323,   869,   868,   689,   688,
     685,   359,     0,   323,     0,   323,     0,   323,     0,     0,
       0,     0,     0,   222,     0,  2013,   544,   542,  1206,  1683,
    1205,   323,  2790,     0,   351,   323,   339,   344,   381,     0,
     230,   305,   306,     0,   233,     0,  2021,  1688,  1686,  2782,
     323,   323,   340,   343,   379,     0,     0,   228,   229,   241,
     240,   232,     0,  2020,     0,  2025,   323,   323,   345,   249,
     247,   323,   237,   245,   239,     0,   246,   307,   234,     0,
       0,  2032,     0,   231,   248,  2023,  2024,  2022,  2027,     0,
       0,  2029,  2030,     0,  1994,   238,  2031,  2026,     0,  2033,
    2035,     0,  2028,     0,  1205,  2034,     0,  1206,  2036
};

/* YYDEFGOTO[NTERM-NUM].  */
static const yytype_int16 yydefgoto[] =
{
      -1,    59,   624,  1534,    60,    61,    62,    63,    64,  1375,
      65,   837,  1293,  1840,  1841,    66,   564,    67,  1601,  2159,
    2160,  3504,  3505,  2161,   662,   663,    68,  2533,  3512,  4445,
    3513,  4451,  3514,  4453,  1618,   627,   535,  2099,  2100,  1538,
    3363,  3083,  3990,  3087,  4146,  4295,  4253,  2117,  3494,  3991,
    3992,  4155,   559,  2531,  1573,  4381,  2079,  4497,  2080,    69,
     660,  1083,  1598,  1599,  3668,  3669,  3901,  3670,  3893,  3894,
    3895,  3896,  4614,  4417,  4534,  4615,  4700,  4735,  4741,  4742,
    4663,  4751,  4752,  4753,  4739,   914,  4754,    70,   587,   588,
     916,  1405,  1855,  1406,    71,    72,   558,  1319,  1320,  1321,
    1322,  2372,  1856,  2367,  2368,  3260,  4664,  4737,  4418,  4419,
    4302,  4420,  4158,  4421,  4306,  4422,  4161,  4423,  4424,  4425,
    4426,  4606,  4427,  4301,  4656,  4414,  4415,  4658,  4717,  4733,
    4428,  4168,  4296,  4521,  4169,  4297,  4601,  4410,  4602,  4651,
    4713,  4411,  4522,  4654,  4525,  4429,  4435,  4616,  4430,  4436,
    4431,  4173,  4313,  4434,  4311,  4433,  4660,  4611,  2967,  3362,
     647,   648,   675,  2185,   649,  1099,  1053,  1575,  2112,  2113,
    2568,  2569,  2682,  2683,  2684,  2104,  2105,  2106,  2171,  2172,
    2173,  2086,  2087,  2088,  1579,  2083,  2084,   650,  1054,  1064,
    2107,  2108,  2109,  2688,  2175,  2176,  2177,  2178,  2110,  1833,
    2111,  2988,  2973,  3905,  3904,  2974,  3677,  4259,  4503,  3378,
    3379,  3070,  3444,  2130,    73,   576,   894,  1372,  2416,  1373,
    2418,  2849,  2850,  2851,  1905,  1906,  3858,  1910,  2415,  4041,
    4460,  4214,  4215,  2853,  4213,  2857,  3286,  3287,  3610,  3860,
    4044,  4465,  4356,  4560,  4463,  4556,  4464,  4558,  4673,  4625,
    4626,  4367,  4475,  4476,  4564,  4628,  4227,  4228,  4229,  2436,
    2863,  3863,  3908,  2165,  1565,  1566,   628,   629,   630,  3392,
      74,  2975,  2625,  2976,  2977,  3467,  2627,  2628,  2817,  1463,
    3457,  3428,  3833,  3369,  3373,  3374,  3375,  3376,  3377,  4392,
    4507,  4508,  4505,  3477,  3390,  3003,  3004,  3075,  3480,  3762,
    3972,  4599,  4648,  4649,  4650,    75,   891,  4076,  3940,  3955,
    3764,  3765,  3766,  3767,  3768,  3769,  3770,  3160,  3161,  4112,
    4113,  4114,  3155,  3156,  3535,  3973,  3974,  3975,  4077,  4127,
    1214,  3528,  1429,  1430,  4051,  1441,  1442,  2464,  1950,  2465,
    1569,  3529,  3530,  3531,  3984,  3219,  3830,  3225,  3226,  3227,
    2780,  2781,  2782,  2783,  2784,  2310,  3976,  3479,  3933,  4105,
    4108,  4279,  4514,  3005,  3391,  3006,  3395,   996,   536,  3007,
    3008,  2191,  2192,  4326,  4335,  4339,  4327,  4340,  4336,  4328,
    4329,  4330,  4342,  4338,  3140,  4004,  4005,  3383,  3393,  3235,
    4281,    76,   130,  2115,  1045,  1056,  1052,  1075,   655,  1585,
    2118,  2643,  3776,   637,  2629,  3926,  3694,  3930,  2630,  3407,
    2631,  3909,  4084,  2632,  3711,  3928,  4102,  3408,  3409,  2633,
    2634,  2635,  3918,  3925,  4271,  4541,  4542,  4543,  3009,  1354,
     652,   653,  1068,  1069,  1070,  2358,  3475,  3053,    77,  2038,
    2033,    78,  1008,  1009,  1010,  1509,  1510,  2036,  2037,  2506,
    2939,    79,   665,  1605,    80,  1383,  2428,  2429,  2430,    81,
    1076,  1589,  1590,  2124,  3092,  3500,  3781,  4001,  4183,  3997,
    4321,  4322,    82,    83,   666,  1612,  1613,  1614,    84,  1366,
     137,    85,   902,  1378,  1380,  1381,    86,   659,  1077,  1078,
    1079,  1080,  2126,    87,  1896,  2400,  2401,  2402,  2403,  1595,
    2647,  1596,  1597,  2135,  3279,    88,    89,   621,  2318,   593,
     926,   594,   595,  1944,  2455,  3834,   937,   938,   939,  2892,
    1419,  1420,  1421,  1902,  2897,  4285,  1146,  1142,   800,   801,
     802,   803,  1239,  1240,  3977,   804,  1249,  1799,  3172,  3550,
    1658,  1659,   805,   806,   807,   808,   809,   810,  1826,  3191,
    3192,  3565,  2345,  2346,  2347,   811,  2232,  3178,  2245,   812,
    1232,  1784,  1714,  3557,  3184,  3815,  4015,  1643,  2208,  2729,
    3163,  2813,  2312,  1168,  1169,  1127,  2215,  1649,  2044,  2045,
    2046,  2047,  2048,  3652,  3653,  4054,  3877,  4056,  3881,  2516,
    2517,  1925,  1926,  2049,  2050,  2940,  3875,  4240,  2313,  2314,
    2315,  3583,  2941,  3340,  2958,  2959,  3887,  2507,  2051,  2947,
    4379,  4063,  4064,  4494,  4493,  4065,  3885,  3886,  3657,  3658,
    3095,  3096,  3097,  2877,  1705,  1706,  1712,  1349,  1350,  1644,
    2397,  2837,  3870,  4048,  2336,  3629,  4046,  4234,  2638,  3436,
    3437,  2457,  2458,  2962,  3355,  3663,  1466,  3835,  2839,  2003,
    2927,  2928,  3792,  4207,  4740,  2785,  2923,  2989,  1676,  1677,
    3443,  4372,  4568,  4676,  4677,  4678,  3315,  3316,  3633,  3634,
    2459,  2889,  3317,  3871,  4239,    90,   540,    91,  1838,  2816,
    1290,  2364,  1087,  1385,  1630,  1631,   824,   554,    92,   565,
    2398,    93,   583,  1923,   881,   906,  1386,  1387,  2437,  2864,
    2871,  2438,  2876,  3620,  2866,  3292,  3293,  2353,  2354,  2867,
    3295,  3617,  3598,  3599,  3274,  3855,    94,   609,  3350,  2953,
    2954,  4348,  4349,   907,    95,   539,  1114,  2705,  4011,  1636,
    2196,  4193,  1115,  1116,  2199,   684,   685,    96,  1013,   605,
    1489,  1490,  1491,  2021,    97,   597,   997,  2924,  3333,  1997,
     898,  1285,  1470,  1000,  1471,  1983,  2487,  1452,    98,  1041,
    1040,  1560,    99,   633,  1561,   100,   838,  1313,  1851,  2823,
    2824,  3245,  1314,  1315,  2365,  3839,   101,   584,   911,   912,
    1390,  2441,   102,   578,   899,  1916,   103,   568,   886,  1358,
    1895,   104,   105,   106,   888,  3280,  4458,  4621,   572,  1898,
    1362,  3678,  4374,  4484,  4485,  4487,  4576,  4577,  4670,  4745,
    4767,  4761,  4770,  4771,  4774,  4779,  4780,   814,  1022,   815,
    4096,   816,   817,   818,  2872,  2873,  3356,   819,  2874,   820,
    3076,  1088,  1633,   562,   514,   644,  1023,  2845,   822,  4175,
    1048,  1287,  1106,  1107,   516,   517,   107,   596,   954,  1446,
    1436,  1445,  1970,  2481,  1974,  2483,  2484,  3329,  2915,  3330,
    2916,  1002,  1966,  1971,  2917,   957,  1959,  1960,  1961,  1962,
    2908,  1956,  1980,   108,   889,   521,  1364,  1365,  2409,   109,
     608,   110,  1351,  1888,  1889,  2394,  2836,  2395,   111,   920,
     921,   112,   866,  1622,  2378,  1101,  1051,  1102,  1874,   869,
    1325,   870,   871,  1340,  1334,  1343,  1337,  4029,  3847,  3848,
    2382,  1289,  1108,  1935,  2189,  3136,  1109,  1865,  2374,  2375,
    3593,  3850,  3264,  4035,  4036,   113,   138,   524,   668,  1094,
    1413,   114,   115,   116,   117,  1416,  1529,  2451,  1530,  2319,
    1531,  1532,  2058,  1942,  1780,  1781,  3233,  1229,  1230,  2322,
    2789,  2790,   940,  1034,  1548,  1540,   131,   132,   133,   134,
    1073,  1074,  2644,  3089,  3496,  3779,  3780,  3996,  4180,  1542,
    4072,  4584,  4711,  1543,  1544,  3364,  4074,  4385,  4586,  4685,
    1545,  2964,  3665,  4249,  4499,   118,  1024,   618,  1527,  1522,
    1524,  2054,  2524,   119,   120,   121
};

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
#define YYPACT_NINF -4078
static const int yypact[] =
{
    6335,  2243,   890, -4078,  -184,  1057, 57515,   721,  1171,  1171,
     539,  3329, -4078, -4078, -4078, -4078, -4078,  2978, -4078, 57515,
     890,  1238, -4078, 25732, -4078, -4078,   -66, -4078,    50,  1171,
     890,   784, -4078, 57515, -4078,  1016,  1296,   890, -4078, -4078,
   50530, -4078,   539, 57515, -4078, -4078, -4078, -4078, 50530,   207,
     240,   952,  1123, -4078, -4078, 57515,  2203, -4078,  -171,  1557,
    1514, -4078, -4078,  1389, -4078, -4078, -4078, -4078, -4078, -4078,
   -4078, -4078, -4078, -4078,  1476, -4078, -4078, -4078, -4078, -4078,
   -4078, -4078, -4078, -4078, -4078, -4078, -4078, -4078, -4078, -4078,
   -4078, -4078, -4078, -4078, -4078, -4078, -4078, -4078, -4078, 26370,
   -4078, -4078, -4078, -4078, -4078, -4078, -4078, -4078, -4078, -4078,
   -4078, -4078, -4078, -4078, -4078, -4078, -4078, -4078, -4078, -4078,
   -4078, -4078,  1682, 57515,  1694, 57515,  1710, 57515, 48625, 57515,
   -4078,  1764, -4078, -4078,  1806, -4078, -4078,  1171,   539, -4078,
   -4078, -4078, -4078, -4078, -4078, -4078, -4078, -4078, -4078, -4078,
   -4078, -4078, -4078, -4078, -4078, -4078, -4078, -4078, -4078, -4078,
   -4078, -4078, -4078, -4078, -4078, -4078, -4078, -4078, -4078, -4078,
   -4078, -4078, -4078, -4078, -4078, -4078, -4078, -4078, -4078, -4078,
   -4078, -4078, -4078, -4078, -4078, -4078, -4078, -4078, -4078, -4078,
   -4078, -4078, -4078, -4078, -4078, -4078, -4078, -4078, -4078, -4078,
   -4078, -4078, -4078, -4078, -4078, -4078, -4078, -4078, -4078, -4078,
   -4078, -4078, -4078, -4078, -4078, -4078, -4078, -4078, -4078, -4078,
   -4078, -4078, -4078, -4078, -4078, -4078, -4078, -4078, -4078, -4078,
   -4078, -4078, -4078, -4078, -4078, -4078, -4078, -4078, -4078, -4078,
   -4078, -4078, -4078, -4078, -4078, -4078, -4078, -4078, -4078, -4078,
   -4078, -4078, -4078, -4078, -4078, -4078, -4078, -4078, -4078, -4078,
   -4078, -4078, -4078, -4078, -4078, -4078, -4078, -4078, -4078, -4078,
   -4078, -4078, -4078, -4078, -4078, -4078, -4078, -4078, -4078, -4078,
   -4078, -4078, -4078, -4078, -4078, -4078, -4078, -4078, -4078, -4078,
   -4078, -4078, -4078, -4078, -4078, -4078, -4078, -4078, -4078, -4078,
   -4078, -4078, -4078, -4078, -4078, -4078, -4078, -4078, -4078, -4078,
   -4078, -4078, -4078, -4078, -4078, -4078, -4078, -4078, -4078, -4078,
   -4078, -4078, -4078, -4078, -4078, -4078, -4078, -4078, -4078, -4078,
   -4078, -4078, -4078, -4078, -4078, -4078, -4078, -4078, -4078, -4078,
   -4078, -4078, -4078, -4078, -4078, -4078, -4078, -4078, -4078, -4078,
   -4078, -4078, -4078, -4078, -4078, -4078, -4078, -4078, -4078, -4078,
   -4078, -4078, -4078, -4078, -4078, -4078, -4078, -4078, -4078, -4078,
   -4078, -4078, -4078, -4078, -4078, -4078, -4078, -4078, -4078, -4078,
   -4078, -4078, -4078, -4078, -4078, -4078, -4078, -4078, -4078, -4078,
   -4078, -4078, -4078, -4078, -4078, -4078, -4078, -4078, -4078, -4078,
   -4078, -4078, -4078, -4078, -4078, -4078, -4078, -4078, -4078, -4078,
   -4078, -4078, -4078, -4078, -4078, -4078, -4078, -4078, -4078, -4078,
   -4078, -4078, -4078, -4078, -4078, -4078, -4078, -4078, -4078, -4078,
   -4078, -4078, -4078, -4078, -4078, -4078, -4078, -4078, -4078, -4078,
   -4078, -4078, -4078, -4078, -4078, -4078, -4078, -4078, -4078, -4078,
   -4078, -4078, -4078, -4078, -4078, -4078, -4078, -4078, -4078, -4078,
   -4078, -4078, -4078, -4078, -4078, -4078, -4078, -4078, -4078, -4078,
   -4078, -4078, -4078, -4078, -4078, -4078, -4078, -4078, -4078, -4078,
   -4078, -4078, -4078, -4078, -4078, -4078, -4078, -4078, -4078, -4078,
   -4078, -4078, -4078, -4078, -4078, -4078, -4078, -4078, -4078, -4078,
   -4078, -4078, -4078, -4078, -4078, -4078, -4078, -4078, -4078, -4078,
   -4078, -4078, -4078, -4078, -4078,  1303, -4078, -4078,  -184, -4078,
   -4078, -4078, -4078, -4078,  1971,  1766, -4078,  1801,  1572, -4078,
   48625, -4078, 57515, -4078, -4078, -4078,  1792,  1807,  1827,    81,
   12109,  1844,  1844,  1844,  1844,  1869,  1844, -4078,  1844, 57515,
   -4078,  1844, -4078,  1844,  1171, -4078, -4078, -4078,  1932, 36560,
   57515,  1705,   203,  -129, 48625,  1515, 57515,  -184,    47, -4078,
    1857, -4078, -4078, -4078,  1171, -4078,  2045,  1901,   248, 57515,
   -4078, -4078,  1171,   233,     4,  1504, -4078, -4078,  1633, -4078,
   37195,   230, -4078, -4078, -4078,  2292, 28284,  7246,  1633,  1630,
    -184,  -133,  1632,  -184, -4078, -4078, 57515,  -184,  1171,  1849,
   -4078, -4078,   272,   272,   272, -4078,   272, -4078,   272, -4078,
    -171,  1506, -4078, -4078,  1531, 57515, -4078,   322,  1606, -4078,
    1614,  2026,  2198, -4078, -4078,  1533,   -36, -4078,  1599, 41005,
   -4078, 57515, -4078, -4078, -4078, -4078,  1831, -4078, -4078, -4078,
    1982, -4078,  1690,  1278, 57515,  1725, -4078, -4078, -4078, 25732,
    1567, 57515,  1680, -4078, -4078, 25732, 25732,   232,   753,  1402,
   57515, 57515, -4078, 45450,  2043, -4078,  2252, 41005,  1766,  1766,
    1766, -4078, -4078, -4078, 51165,    81,  1616,  1618,  1628, 17365,
   -4078,  1634,  1647,  1653, 12109,  1678,  1689,  1701,  1704,  1720,
    1722,  1726,  1728,  1731,  1733,  1736,  1746,  1756,  1758,  1758,
    1758,  1773,  1786,  1802,  1812,  -213,  1815, -4078,  1817,  1829,
    1837, -4078, -4078,  1843,  1847,  1855, -4078, -4078,  1867,  1873,
    1879, 12766,  1882,  1891,  1906, -4078, 22530,  1916,  1921,  1923,
    1929,  1938,  1946,  1978,  1980,  1984, -4078, -4078, 12109,  1773,
   -4078, -4078,  2004, -4078,  2010,  2015,  2022,  2024,  2035,  2039,
    2046,  2050,  2053,  2064,  2082,  2084,  2099,  2102,  2104,  2111,
    2113,  1773, -4078,  -205,  2116,  2118,   482,  2120, -4078,  2123,
   -4078,   291,  2127,  1758,  1773,  1773,  2140,  2143,  2165,  2168,
    2183,  2204, 17365, 17365, 17365, 12109, -4078, 57515, -4078, 57515,
     796,  2854, -4078,  2522, 17365,   214, -4078, -4078, -4078, -4078,
   -4078, -4078, -4078,  1643,  1740, -4078, -4078, -4078, -4078, -4078,
   -4078,  2208,  1624,  2184, 57515, 57515, 57515, 57515, 57515, 57515,
   45450, 48625,  1881, 57515, 46085, -4078,  1844,  1799,  4533, 31469,
    2044,  1944,  1243,  1758, -4078, -4078,  -110,   681,   726,  2109,
   -4078, -4078,  1957,   809,  2098, -4078,   841,   402, -4078,    88,
     877,   891, -4078, -4078, -4078, -4078, -4078, -4078,  2074,  2279,
    2025, -4078, -4078,   173, -4078, -4078, 57515, -4078, -4078, -4078,
   -4078,  2496,  2352, -4078, -4078, -4078,   166,  2818,   222, 25732,
   -4078,  2222, 12109,  1538, -4078,   597, -4078, -4078,  2595, -4078,
   -4078, 46085, 25732, -4078, -4078, -4078, 23170, -4078, -4078,  2840,
   -4078,  2241, -4078, -4078,  1740,  3306, -4078,  2516,  2044,  2531,
   -4078,  2723, -4078,  2551,  2452,   753,  2340, -4078, -4078, -4078,
   -4078, -4078, -4078, -4078, -4078, -4078, -4078,  2290,  2292, -4078,
   -4078,   390,  2446,  2280,   440,   463, 40370,   795, 48625,   530,
      37, 28921, 41640,  2281, -4078, -4078, -4078,   116,  2436, -4078,
    2773, -4078, -4078,   733, -4078,  2295,  2474,   733, 46720,  2673,
     184, -4078,   171, -4078,  2754, -4078, -4078, -4078, -4078, -4078,
    2422,  2404,  2453, -4078,   258,  1020, -4078,  -184, -4078,    13,
   -4078, -4078,  2429, -4078,  2673,   733,   184, -4078,  2679,  2805,
     794,  2772,  -174, -4078, -4078, -4078,   755,  2880, -4078,  2318,
   -4078, -4078, -4078, 25732, -4078, -4078, -4078,  2496, -4078, -4078,
   -4078, -4078,  2319, -4078,  2598,  2428, -4078, -4078,    66, -4078,
    2327,   -32,  2824, -4078, -4078,   350,  1331,  1806,  1766, -4078,
    2231, 42275, -4078, -4078, -4078,  2856,  2873,  1758,  2336, -4078,
   -4078, -4078, -4078, -4078,  3001, -4078, -4078,  2355,  2893,  2893,
    2893,  3009, -4078, -4078, -4078, 25732, -4078, -4078, -4078,  1278,
   -4078, -4078,  2530,  2401, -4078,  1725, 25732,  2771,  2380, -4078,
   -4078,  2636, 12109, -4078, -4078, -4078,    53, -4078, -4078,   268,
   -4078,  2982,  2596, -4078, -4078, -4078, -4078,  2870, -4078, -4078,
    3001,  -217, -4078,  2931,  2893,  2828, -4078,  2829,  2397, -4078,
   57515, 57515, 57515, 25732, -4078,  2403, -4078,  2395, -4078, 12109,
   12109,  1127,  2990,  3051,  3051,  3051,   796,  2438, 12109, 12109,
   12109, 12109, 12109, 12109, 12109, 12109, 12109, 12109, 12109, 12109,
    1550,  2414, -4078, -4078, -4078,  2078, -4078,  2416, 12109, 12109,
   -4078, 12109, 12109, 27008, -4078,  3898, 12109,   327,  2927, 12109,
   12109, 12109, 12109,  3033, 12109, 12109, 12109, 27008,  3065,  2421,
   -4078,  2419,  1617, 12109, 12109,  1664, 12109, 12109, 12109, 12109,
   12109, -4078, -4078, 12109, 12109, 12109, 12109, 17365, 12109, 12109,
   12109, 12109, 12109, 12109,  2423, 12109,  3051,  3051, 12109, 12109,
    1681, -4078, -4078, 12109,  2560,  2560, -4078, 12109,  8824, 12109,
   -4078, -4078, -4078, -4078, -4078,  2434, -4078, -4078, -4078, 27008,
    3051,  3051, 12109, 12109, 12109,  2990,  2990,  2990,   237,  2435,
    -112, 12109, 29558,  2430, -4078, -4078, -4078, -4078, 12109, 12109,
   12109, -4078, 17365, -4078, -4078,   897, -4078, -4078, -4078, 13423,
   17365, 17365,  2443, 17365, 17365, 17365, 17365, 17365,  2821, 17365,
   17365, 18022, 18679, 17365, 17365, 17365, 17365,   228,  2990, 48625,
   17365, 12109, -4078, -4078, 57515, -4078, -4078, -4078,  2437,  2725,
    1881, -4078,  2447, -4078,   783,  2939, -4078, -4078, -4078,  2449,
   25732, -4078,  2448, -4078,  2817, -4078, -4078,  2827,  2830,  2831,
   -4078, -4078, -4078, -4078, -4078,  3058,  2832, -4078,  -184,  2833,
   -4078, -4078, -4078, -4078,  2461, -4078, -4078, 19336, 48625, -4078,
    2469, -4078,  2959, -4078, -4078, -4078, -4078, -4078, -4078,  2573,
   -4078, -4078, -4078, -4078,  2476, -4078, 46085,  2476, -4078, -4078,
    2476, -4078, -4078,  2476, 41005,    57,  3759, -4078, -4078, 57515,
   -4078, 58150, -4078, -4078, 23170,  -184, -4078,  2900, 14080, -4078,
   -4078, -4078,  2848,   281,  2477, -4078, 25732, -4078,   796, -4078,
     113,   113,  2732,   168, 48625, -4078, -4078,   175,  2485,  2569,
    2490, -4078,  2572, 25732, 25732, -4078, -4078, -4078,  2747, -4078,
    -184,     4, -4078, -4078, -4078, -4078, -4078, -4078, -4078, -4078,
   -4078, -4078, -4078, -4078, -4078,  2495,  2987,  2951,  2499, 46085,
   41005,   776, -4078, 57515, -4078,  1735, -4078, -4078, -4078,  2506,
   -4078, 12109, -4078, -4078, 57515, -4078, -4078, -4078, -4078, -4078,
    3090, 12109, -4078, 46085,   -78, -4078,    86,  1045,   116, -4078,
   -4078, -4078, -4078, -4078, 57515, 51800,  2519,  9481,  2642,  2922,
    -184, 12109, -4078,  2533,  1766, 57515, 57515, 57515, 25732, 57515,
   25732, -4078,  1217,  1217, -4078, 42910, -4078, -4078, -4078, -4078,
     733, 57515, 57515,   733, 41005, -4078,   184,   -15, 57515,   733,
   -4078,  2925,  2632, -4078, -4078, -4078,  2999, -4078, -4078,  2991,
    2534, -4078,  3020, -4078, -4078,  2659,   184, -4078, -4078, 25732,
   -4078, -4078,   184, -4078,   184,   184, 12109,   733,   733, -4078,
    1315, -4078, -4078, -4078,  2686,  -133, -4078, -4078, -4078,  1003,
     272,  2791, -4078, -4078, -4078, -4078, -4078, -4078, -4078, -4078,
   -4078, -4078,    76, -4078, -4078, -4078, -4078, -4078, -4078,   220,
   -4078, -4078, -4078, -4078, -4078, -4078, -4078,   234, -4078, -4078,
   -4078, -4078, -4078,  1725, 25732, -4078, -4078, -4078, -4078, -4078,
   -4078, -4078, -4078, -4078, -4078,    70, -4078, -4078, -4078,  2105,
    3055, -4078, 48625,  2388,  -124,  1400,  2388,  1709,  -184,   694,
   -4078,   694, -4078, -4078, -4078,  2822,  1272, 25732, -4078,  2544,
   -4078,  2796, 52435, 25732, -4078, -4078, -4078,   176,  2556,  2559,
     796,  4004, -4078, -4078, 25732, -4078, -4078, -4078, -4078,  2613,
   -4078, -4078, -4078, -4078,  1187, -4078, -4078, -4078,    79,  1638,
    3209, 45450, -4078,  2584,  2612,   143, 41005, -4078, -4078, -4078,
    2566, -4078,  2747, -4078,  1294, 57515,  3023, 34013, -4078,   315,
     441, -4078,  3051,  2570, -4078,  2571,  2575,  2576, 12109,   120,
     304,   472,  1134,  1449,   700,   372,   982,   493, -4078,  1474,
     497,   532,   550,   201, -4078,  2577,  2578, -4078, -4078, -4078,
   -4078, -4078, -4078, -4078, -4078,  2579, -4078, -4078, -4078,   564,
     658,  1247,  1307,  2580,  2583, -4078, -4078, -4078, -4078, -4078,
   -4078, -4078, -4078, -4078, -4078, -4078, -4078, -4078, -4078, -4078,
   -4078, -4078, -4078, -4078, -4078,  3028, -4078,  1503, -4078, -4078,
   -4078, -4078,  2585, -4078, -4078,  1362,   664,   696,   351,  2591,
    1587,   758,  1602,  1637,  2588, 27008, 57515,  3051,  2594,  1368,
    1376,  3051,  2597,   777,  1393,  1669,  1671,  1695,  1411,  1413,
     871,  1742,  2859,  1423,   884,   895,  1429,   913,   930, -4078,
    1486,  2599,  2601,   956,   254,  3051,  2602,   363,  2603,  2611,
    1494, 10138, 10795, 11452,   285,   978, -4078,  2614, -4078,  2419,
    2617,  2618,   374,   195,  1511, -4078, 12109, -4078, -4078,   640,
    1001,  2637,   148,  1045, -4078,  2755, 57515,  2417,   205, -4078,
   -4078, -4078, -4078, -4078, -4078,  1102, -4078,  2622, -4078,  2624,
    2075,  2616, 12109,  1160,  2616,  3099,  1327,  1327, 17365,  2558,
    2641, 12766,   751, 12766,   751,  2616,  2616,  2616, -4078, 17365,
    2626, 17365, 17365, -4078,  2990,   796,  2627,  -229, 57515, 25732,
     783, -4078, -4078, -4078, -4078,   116, 46085,   133, 25732, 48625,
    2625, -4078, -4078, -4078, -4078, -4078, -4078,  -184, -4078, -4078,
    4625, 25732,  2687,  2689,  2719, -4078, 32106, -4078, -4078, -4078,
   -4078, 32106,   -26, -4078, 57515, -4078,  2712, -4078, -4078, -4078,
    1214, 23808, 23808, -4078, 23808, -4078, -4078, -4078, -4078, -4078,
     402, -4078, -4078, -4078, -4078,   252,   316,  2721,  2669, -4078,
   -4078, -4078, -4078, 33378,   796, -4078, 25732, -4078,  3057,   785,
   25732,  2645, -4078,  2650, -4078, -4078, -4078, -4078, -4078,  3342,
    2762, -4078,  3296, -4078, 12109,  -184, -4078, 46085, 46085, 25732,
   25732,   736, -4078,  1230,  2656, -4078, -4078,  3299, -4078,  3306,
   19336, 45450,  3102,  3115, -4078,  2660, 23808, 23808, 23808, -4078,
   -4078, -4078, -4078, -4078,   137,   796, -4078,  2657, -4078, 47355,
   -4078,   796,   116,  2664,  2668, -4078, -4078,  3054,   761, -4078,
    2670,  2672, -4078,  2671,  2675,  2676, 53070, 12109, -4078,    86,
   -4078, -4078,   116, -4078, -4078, -4078, 17365,  1817, -4078,   796,
   -4078, -4078,  -184,  3131, -4078,   796,  2677, 57515, -4078, -4078,
   -4078, -4078, -4078, -4078, -4078, -4078, -4078, -4078, -4078, -4078,
   -4078,  3157, -4078,  2860,  -109, -4078, -4078, -4078, -4078, -4078,
   -4078, -4078,   733, -4078, -4078, -4078, -4078, -4078, -4078, -4078,
    2912,  2673,  1020,  2922, -4078,   733,   184, 25732,   733,   733,
     796, -4078, -4078, -4078, -4078, -4078,  2684, -4078,  2740, -4078,
   -4078, -4078, -4078, 57515,  2718,  2853, -4078,  2693, -4078, -4078,
   25732, -4078,  2694, -4078,  3154,  3303,  2673, -4078, -4078,  3160,
   57515, 57515,  1766, 57515, 57515, -4078, -4078, -4078,   116,   116,
    3008, -4078,  -184,  2849,  2858,  2879,  2884,  2885,  2901, -4078,
   -4078,  -184,  -184, -4078, -4078,   116, -4078,  1150, -4078, -4078,
   -4078, -4078,  -184,  -184,  -184,  -184,  3358,  -184,  -184,  1782,
   -4078, -4078,   116,   116, -4078,  1828, -4078, -4078, -4078, -4078,
   -4078, -4078, -4078,  1471, -4078,  5490,   534, -4078,  2964, -4078,
   -4078, -4078, 25732,  3220, -4078, -4078, -4078, -4078, -4078, -4078,
   -4078, -4078, -4078, -4078,  2767, -4078, -4078, 12109,  3260,  3267,
    3269,  3270,  3272,  3275,  3279,  3280,  3281,  3283,  3286,  3291,
    3293,  3295,  3297,  3298,  3300,  3302,  3307,  3310,  3311,  2810,
   -4078, -4078, -4078, -4078, -4078, -4078,   153,   116,   116,   116,
     116, -4078,  2337, -4078, -4078, -4078, -4078, -4078, -4078, -4078,
   -4078, 41005, -4078, 48625,  3185,  2311,  1135, -4078, -4078, 48625,
   -4078,   701,  3106,  3110,  3112, 57515,  2881, -4078, 34013, -4078,
   -4078,  1003, -4078,  2837, 14737, -4078,  2836, -4078, 12109, -4078,
   -4078, -4078,  1621, 12109, 12109,  3318,  2445, -4078, 47990, -4078,
   -4078, -4078, 12109, -4078, 12109, -4078, 12109, 12109, 12109, 12109,
   47990,  2445, 12109, -4078,  2838, -4078,  3242,  3250, -4078, -4078,
   -4078, -4078, 12109, -4078, 12109, 12109, -4078, 12109, 12109, 12109,
   12109, -4078, 12109, -4078, -4078, 17365, -4078,  2857,  2847, -4078,
   -4078, -4078,  2863, -4078, 12109, -4078, -4078, -4078, -4078, -4078,
   -4078, 12109, -4078, 12109, -4078, 12109, 12109, -4078, 12109, 12109,
   -4078, -4078, -4078, 15394, 12109, 12109,  2866, -4078, -4078, 12109,
   12109, 12109, -4078, 12109,  1218, 12109,  2091, 12109,  2128, 12109,
   -4078, 12109, -4078, -4078, -4078, -4078, 12109,   348,  3342,  3358,
    2867, -4078,  1795, -4078, -4078,  1713, -4078,   640,  2872, -4078,
   -4078,  1735, -4078, -4078, 48625, 12109, -4078, -4078, -4078, -4078,
   -4078, -4078, 17365,   384,  2874, 17365, -4078,  3099,  3033,  3033,
    2193, 12109,  1160,  3099, 12109,  2882,  2869, -4078, 12109, 57515,
   -4078, -4078, -4078, -4078, 48625, -4078, -4078, -4078, -4078,   133,
   -4078,  2448, -4078, -4078,  2645,   211,  3361,  2887, -4078, -4078,
   -4078, -4078, -4078, -4078,  1804, -4078, 41005,  3526, -4078,  2876,
   -4078,  2883,  2961,  2965,  2971, -4078, -4078, -4078, -4078, -4078,
   -4078, -4078, -4078, -4078, -4078, -4078, -4078,  2673,  1230, -4078,
   -4078,  2896, -4078, -4078,  2636,  2989,  2919,  3273,  3473, -4078,
   -4078, 57515, 17365, -4078,  3523,  2920,  2921,  3412,  2928,   796,
   -4078,  3011, -4078, -4078, -4078, -4078, -4078, -4078, -4078, -4078,
     816, -4078, -4078,  2930,  2930, 21252, -4078, -4078, -4078, 57515,
   -4078, -4078,  3422, -4078, -4078,  3206, 46085, 41005,  3391,  3392,
    3393,   657, -4078,   805, -4078,   158,  3343,  2673, -4078,  3398,
   49260, -4078, 34648, -4078, -4078, -4078, -4078,   -78,  3035,  3038,
     -55, -4078, -4078,  3346,  3179, -4078, -4078, -4078,   116,   796,
   -4078,  2519,  9481,  2957, 30195, -4078,  2155, -4078,    55, -4078,
   43545,  3437, 43545, 43545, -4078,  3244, -4078, -4078,  3131, -4078,
    2669,   184, -4078, -4078,  1315,  1823, -4078, -4078,  1006,  3355,
    3357, -4078,  3229,  1383,  3229, -4078, -4078,  1006, 27008,  1003,
    2747, -4078,  3358,  3285, -4078, -4078, -4078, 57515, -4078,  1174,
   57515,  2968,  -156,  4679, 47355, 44180, -4078, -4078, -4078, -4078,
    3504, -4078,  3505,  1483, -4078, -4078,  3114,  1400, -4078, -4078,
   -4078, -4078, -4078, -4078, -4078, -4078, -4078, -4078, -4078, -4078,
   -4078, -4078, -4078,  1709,  3114,  3114,   694, -4078,   152, -4078,
   -4078, -4078, -4078,  2878,   116,  3546,  3230,   116,   116,  3546,
     116,  3231,  3234,   116,   116,  3063,  3498,   116,  3380,  3091,
    2270,  3386,   116,  3252, -4078,  3096,  3511,   116,   116,   116,
     116,   116,  3546,  3256,  3610,   116,   116, -4078,   116,  3271,
    3274,   181,  3278,  3282,   116,   116,   116,   116,   192, 57515,
     116,   116,  3284,   116, -4078, -4078,  5769, -4078, -4078, -4078,
   -4078, -4078, -4078,  1107, 24452, -4078, -4078, -4078, -4078,   116,
       7,   332,  3086,  1839,  3016, -4078,   353,  3022, 53705,   796,
    3026,  3358,  -184,  -184,  2155,  -184,  3358,  -184,  -184,  -184,
    -184,  -184,  -184,  -184,  3358,  3358,  -184,   844,  2172,  -184,
    3358,  4004,  -184,  3342,  3114,  3114,  1638, -4078, -4078,  3301,
    3467,   116, -4078,  2227, -4078, -4078, -4078, -4078, -4078, -4078,
   -4078, -4078, -4078,  3118, -4078,   169,   409,   409, -4078, 25732,
   25732, 25732, -4078,  3024,  1003,  2669,  1437,  2669,  3040, -4078,
   12766,  1560, -4078,   796, 12109,   796,  1858, -4078,  3037,  3037,
    3037, -4078,  3039, -4078, -4078,  3037,  3435,  3037,  3440,  3041,
    3045,  1848,  2180, -4078,  1850,  2185,  1565,  3049,  3052,  1643,
   -4078, 12109, 12109,  1571,  1584,  -136,   986,  1024,   401, -4078,
    1595,  3017, -4078, -4078,  1605,  1650,  1654,  1663,  1036,  1668,
    1863, 12766,  1691,   219,   454, -4078,  1714,  1072,  1113,  1754,
   12109,  1759, 12109,  1767, 12109,  1776,  1803,  1808,  3066,  3066,
     159, -4078,  3056, -4078, -4078, -4078,  3067, -4078, -4078,  2290,
    1713, -4078, -4078,  3064, -4078, -4078,  3060,   796,  3072, -4078,
   -4078, 12109, -4078,   214, -4078, -4078, 17365,   483,  3073, -4078,
     796, -4078, -4078,  3075,  1643, -4078, -4078, -4078, -4078, -4078,
   -4078, -4078,  3263, -4078, -4078,  3802, 32106, -4078, 57515,  1289,
    3347,  3083, 35283, 41005, 41005, 41005,  3079, 12109, -4078, -4078,
    3362, 25732, -4078,  3499, -4078, -4078, -4078, -4078, -4078,  3085,
    3078, -4078, -4078, -4078,  3099,  3462,  3351, -4078, -4078,  3342,
   57515, 46085, -4078,  2292, 27008, -4078,  3087, -4078,  3087,  1501,
    3100,  1868, -4078, -4078, -4078,  3095,  2340,  1886, -4078, 19336,
    3558,  2449, -4078, 41005, 41005, 41005, -4078,  2669,  2669,   947,
    3159,  3510, -4078, -4078, -4078, -4078, 54340, -4078, -4078, -4078,
   -4078,  1268, -4078,  3104,  3117,   224,  3333, -4078, -4078, -4078,
   -4078,  9481, -4078, -4078, -4078, -4078, -4078, -4078, -4078, -4078,
   -4078, -4078, -4078, -4078,  2673, -4078, -4078, -4078, -4078, 43545,
   -4078, -4078, -4078, -4078, -4078,   733, -4078,  3602, -4078,  3119,
    -225,  1001, -4078,  1401, -4078, -4078, -4078,  3517,  3229,  3229,
    1006,  3518,   923,  3133, -4078,   116, -4078,  3107, -4078,  2292,
   -4078, -4078, 12109,  3321,  3136, -4078, -4078,   139, -4078, -4078,
     942, 25732, 19976, -4078, -4078,  3390, -4078,  3740, -4078, -4078,
   -4078, -4078, -4078, -4078, -4078, -4078, -4078, -4078, -4078, -4078,
   -4078, -4078, -4078, -4078, -4078, -4078, -4078,  1471, -4078, -4078,
   27646,  1766, -4078,   307, -4078,  1766, -4078,   176,   176,  1766,
   54975, 27646,   890,  2155,  3358,  1844,  3358, 55610,   890,  -184,
    -184,  2493,   116,  3358, -4078, -4078,  3528,  1844,  3529,  1844,
    1844, -4078, 48625, 57515, -4078,   116,  1352,  3358, 56245,  2155,
    2155,  1844,   890, 27008,  2653,  2820, -4078,  -184,   890, -4078,
   -4078, -4078, -4078, 25732,   890,   890,  2826,  3190,  3232,  3258,
   -4078, -4078, -4078,  3358,  2820, 55610, -4078, -4078,  3955, -4078,
   -4078, -4078, 20614, 57515,  1041,   537, -4078,  3132, 38465,  3382,
   -4078, 12109, 12109,  3418, 57515,  3424, -4078,  3715, 57515,  3785,
   -4078,   146, -4078, 55610, -4078,  3152, -4078,  3153, -4078,  3358,
   -4078, -4078, -4078, -4078, -4078, -4078, -4078, -4078, -4078, -4078,
   -4078, -4078, -4078, -4078, -4078, -4078, -4078, -4078, -4078, -4078,
   -4078, -4078, -4078, -4078, -4078, -4078, -4078, -4078,  3162, 57515,
    3114,  2311, -4078, -4078, -4078, -4078,  -184, -4078, -4078, -4078,
   -4078, -4078, -4078, -4078, -4078, 34013,  2669,  3421, -4078, -4078,
    3033, -4078,   796, 12109,    97, -4078, -4078,   208, -4078,  1319,
   -4078, -4078, -4078,  3163, -4078, -4078, -4078, -4078, -4078, -4078,
   -4078,  2543, -4078, -4078,  2445, -4078, -4078, -4078,  3156,  3033,
    3033, -4078, -4078,  3763,  3330, 12109, 12109, -4078, 12109, -4078,
    1070,  3167,  3192, -4078, -4078, -4078, -4078, 12109, -4078, -4078,
    3033, -4078, 12109, -4078, -4078, 12109, -4078, 12109, 12109, -4078,
    1821, -4078,  1860, -4078,  1880, -4078, -4078, -4078,  3342,  3170,
    3551, -4078, -4078, -4078,  3342,  3359, -4078, -4078,  3342,  3358,
    2506, -4078, -4078,  -112, 57515, -4078, -4078,  1907, -4078, -4078,
   12109, -4078, 49260, -4078, -4078,  3647,  3543, -4078, -4078, -4078,
   -4078, -4078, -4078, -4078, -4078, -4078, -4078, -4078, -4078, -4078,
   -4078, -4078, -4078,  3619, -4078, -4078, -4078, -4078,  -157,  -157,
    -157, 16051,   796,  3679, -4078, -4078, -4078,  3499,  3565, -4078,
      48, -4078, 57515,  3182,  1007, -4078,  1942, -4078, -4078,  3183,
   -4078,  2290,  3184, -4078,   116, 16051,  2930,  3353, -4078, -4078,
    1501, 27008, 34648, -4078, -4078, 57515, -4078, 41005,  2660,  2660,
    2660,  2673,  3627,  2989,  2989, -4078, 30832, -4078, -4078,  3350,
   -4078, -4078, 35918, -4078, -4078, -4078, -4078, -4078, -4078, 30195,
   53070, -4078, -4078,  2673, -4078,  -184,  2029,  1735,  3334, -4078,
    1003, -4078,  1006,  3581,  3582, -4078,  1006, -4078, -4078, 27008,
    2669, 16051, -4078,  2290,   796,  3191,   306,   942, -4078, -4078,
   -4078, -4078,  3472,  3474, 57515, -4078, -4078, -4078, -4078,  3338,
   -4078, 25732,  3199,  3208,  3211, -4078, -4078, -4078,   886, -4078,
    6612, -4078, -4078, -4078, -4078,   890,  3218,  3601,  3611,   176,
   -4078,  1766, 27646, -4078, -4078,  1766,  1766, -4078, -4078, -4078,
     933, 55610, -4078, -4078, 27646, -4078, -4078, -4078,  3223, -4078,
   -4078,  3342, -4078, -4078, 44180,  -184, -4078,  1844, 57515, -4078,
   27646, 27646, -4078,  3249,  -184, -4078, -4078, -4078, -4078, -4078,
   -4078, -4078, -4078, -4078, 27646, 55610,  3226, -4078,   306, -4078,
   -4078, -4078, -4078, -4078,  2045, -4078, 55610, -4078, -4078, 55610,
   -4078, -4078, -4078, -4078, -4078, -4078, -4078, -4078, -4078, -4078,
   -4078, -4078, -4078, -4078, -4078, -4078, -4078,  3233,  2889,  1665,
   -4078,  3228, -4078, 57515, -4078, -4078, 25732, -4078, -4078, -4078,
    7796, 57515, -4078, -4078, -4078, -4078, -4078,   796,  3033,  3798,
   -4078, -4078,  3385,  -184,  3742, -4078,  1960, -4078, -4078, -4078,
    3651,  3238, -4078, 53705,  1975, -4078, -4078,  1709, -4078, -4078,
   -4078, -4078,  3240,  3246,  3247,  2837, -4078,  3624,  -242,   796,
    3248,  3251,  3257,  3262,  3867,   172, -4078,  3870, 47990, -4078,
   -4078, -4078,  1981,  3540, -4078, -4078, -4078,  3037, -4078,  3039,
   -4078, -4078, -4078,  3852, -4078, -4078,  3037,  3668,   208, -4078,
   -4078,  3266, -4078,  3268,  3276, -4078,   272,  3277,  1898,  1212,
    1989,  3583,  3656, -4078,  3501, -4078,  1924,  1058,  1953,  1967,
    1986,  1995, -4078, -4078, -4078, -4078, -4078,  3287, -4078, -4078,
     474, -4078,  3288,  1467,  1001, -4078, -4078,  1996, -4078, -4078,
    3906,  3552,  1424,  3304,  3304,  3304,  1817,   796,  2005, -4078,
   -4078, -4078, -4078, -4078, -4078,  3687, -4078, -4078,  3292,  3296,
   57515, -4078,  3351, -4078,  2506, 27008, 16051,  3305,  3294, -4078,
     -32, -4078, -4078,  3290, -4078, -4078,  2660, -4078,  3889,  3720,
   -4078, -4078, 48625,  3308, -4078, -4078,  3600, -4078, -4078, -4078,
   -4078, -4078, -4078, -4078, -4078,  2693,  3481,  3345,  1006,  1006,
    3537,  3348, 12109,  3312, -4078,  3421, -4078, -4078,    65,  2506,
   12109, -4078, -4078, -4078,  3443,   974, -4078,  3466,  3314,  3317,
   -4078, -4078,  -184,  3320, -4078, -4078, 20614, -4078,  3935, -4078,
   -4078, 12109,  1766, -4078, -4078, -4078, -4078,  3313, -4078, -4078,
    3826,  3828, -4078, -4078,  1187, 57515, -4078,  3090, -4078, 27646,
    3223, -4078,   465,  3420, -4078, -4078, -4078, 27008, -4078, -4078,
   -4078, 57515, -4078, 25732, -4078, -4078,  3325, -4078,  3037,  3037,
    3037, -4078, -4078,  3037, -4078,  3039,  3568, -4078,  3039,  3039,
   -4078, -4078, -4078, -4078, -4078,   208,   373, -4078, -4078,   208,
   -4078, -4078, -4078,   141,  1425,  3039, -4078, -4078, -4078, -4078,
   -4078, -4078, -4078,  3037,  3037,  3037, -4078, -4078,   208,  3037,
   -4078,  3037, -4078,  3492, -4078,   178,   155,  3037,  3037,  3037,
    3163,  3324, -4078, -4078, -4078, -4078, -4078, -4078, 57515, -4078,
    1037, 57515,   149, -4078, -4078, -4078,  3358,  2012, 57515, 57515,
   57515, 44815, -4078, -4078, -4078, -4078, -4078, -4078, -4078, -4078,
   -4078, 47990, -4078,  3950,  3620,  3336, -4078, -4078, -4078, -4078,
   -4078, -4078, -4078, -4078, -4078, 12109, -4078, -4078, -4078, 12109,
   -4078, -4078,  3654,  3815, -4078, -4078, -4078, -4078, -4078, -4078,
    3349, -4078,  3358,   158,   158, -4078, -4078, -4078,  3853, -4078,
   -4078,  3434,  3436, -4078, -4078,  3441, -4078, -4078,   151,  1997,
   -4078, -4078, -4078, -4078, 16051,  3744,  3451, -4078, -4078,  3356,
    3399, -4078, -4078,  1467, -4078, -4078, -4078, -4078, 12109, -4078,
    3421,  2493, -4078, 30832, -4078,  -112, -4078,  3402, -4078, -4078,
   -4078,  3404,   796, 57515,  3624, -4078,   343,  1467,   306,  -184,
   -4078, -4078, -4078,  3363,  3371, -4078, -4078, -4078,   332, -4078,
   57515,  7796, -4078, -4078,   -32,  5769, -4078, -4078,  1069,   609,
    2000,  3360,  3365, 57515,  3374,  3375, -4078,  2808, 27646, -4078,
   -4078, -4078, -4078, -4078, 25732,  7796,   890, -4078, -4078,  3223,
     816,  3376, 57515,  3699, -4078, -4078, -4078, -4078,  1075, -4078,
    3378,  1075,  1075, -4078,  2446, -4078,  3411,   208, -4078, -4078,
    3414, -4078, -4078, -4078,  1075,  3381,   208, -4078, -4078, -4078,
   -4078,  1075, -4078, 48625,  -184,  3062,  4022, -4078,  3438, -4078,
    3908,  3778,  4023, -4078,  2539, -4078,  3779,  3678,   116, -4078,
     208, -4078, -4078,  3950, -4078,   208,  3950,  1075,  1075, 57515,
    3519, -4078, 63865, -4078, -4078,  -171,  3419,  2027, -4078, -4078,
   -4078, -4078, -4078, -4078,  2054,   306,  3397,  2056,  2058,  3876,
    3579,  3590, -4078, -4078,  3401,  3403,   306,  2002, -4078, -4078,
   -4078,  3407, -4078, -4078,  3994, -4078, -4078, -4078, -4078,   183,
    3680,  3358,  3358,  3358,   677,  1997, -4078, -4078,  3461, 25732,
   17365,  3520, 57515,  1021,  3316, -4078,  1181,   306, 12109,  2673,
   44180, -4078, -4078, -4078, 12109,  3415, 12109,  3416,  2060, -4078,
   -4078, -4078,   176,   176, -4078,   343, -4078, -4078, -4078, -4078,
    1526, 57515, 25732,  3418,  3605, -4078,  3090, -4078, -4078,  3390,
    3353, -4078,  3342,  3351, -4078, -4078, 57515, 57515,  2073, 57515,
   57515,  2687,  2689,  2719,  2172,  2172, -4078, -4078,  1041, -4078,
   -4078, -4078,  3821, -4078, -4078,  2106, -4078,   917,  3696, -4078,
   -4078, -4078, -4078,  1075, -4078,   272, -4078, -4078, -4078, -4078,
   -4078,   272, -4078, -4078, -4078, -4078,  3426, -4078, -4078, -4078,
    3709,  3469, -4078,  3432, -4078, -4078, -4078, 39100, -4078, -4078,
   -4078, -4078, -4078, -4078, -4078, 12109,  3914,  3459, 57515,   119,
   -4078, 65135, 65135, 57515, -4078, -4078, -4078, -4078,  6945, -4078,
   -4078,    -1, -4078, -4078, -4078, -4078, -4078, -4078, -4078, -4078,
   -4078, -4078, -4078,  4058, -4078,  3430, -4078, -4078,  3439,   226,
   -4078, -4078, 57515, 56880,  1126, 57515, -4078,  3725,   115,  1342,
   -4078,  3920,  2290, -4078, -4078, 12109, -4078, -4078, -4078, -4078,
   -4078, -4078, -4078, -4078, -4078, -4078,  1363, -4078, -4078, 27008,
    2747, -4078,  3342, -4078,  2108, -4078, -4078, -4078,  3532,   116,
     116,  3959,  3961,   116,   116,   116,   116,  3453,  3316, -4078,
    3943, -4078, -4078, 12109, -4078, -4078,   796,  3690, -4078,  4034,
    1001,   796, 57515,   796, 57515, -4078,  3913,  3913, -4078, -4078,
   -4078,  7796,  3915,  1839, -4078, -4078, -4078,   886,  3457,  2340,
   -4078,  2124,  2129,  2132, -4078,  2149,  2151, -4078, -4078, -4078,
   -4078,  1041,  3463, -4078, 57515, -4078, -4078, -4078,   106, -4078,
   -4078,  2153, -4078,  2179,  2609, -4078,  3426, -4078, -4078, -4078,
   -4078, -4078, -4078,   796, 12109, -4078, 12109,  3487, -4078, -4078,
    3916, 57515, -4078, -4078, -4078, -4078, 12109, -4078, 63865, 63865,
   -4078, -4078, -4078, -4078,  4084,   -32,  4053,  3737,  4056, -4078,
   -4078,  2205, -4078, -4078,  -184,   116, -4078,  1126, -4078, -4078,
   -4078,   116,   306,  3468,  3726, -4078,   115, -4078, -4078, -4078,
    1342, -4078, -4078, -4078,  2506,   306, -4078, -4078,  3477, -4078,
     116, -4078,  3475, -4078, -4078, 57515,  3483, -4078,  -184,  -184,
     116,   116,  3366,  3366,  3342, 48625,  3592, -4078, -4078,   116,
     306, 57515, -4078,   104,  3849, -4078,  2213,  2217,  1176, -4078,
   -4078,  3736, -4078, -4078,  3715,  7796, -4078, -4078, -4078, -4078,
    3700, -4078,  1126, -4078, -4078, -4078,  3351, -4078,   915,   915,
     208,   272,   208, -4078,  3486, -4078,  3490,   796,   796, -4078,
     188, -4078, -4078,  3891,  3985, 12109,   796, 60690,  3489, -4078,
   -4078, -4078, -4078, -4078, -4078, -4078, -4078, -4078, -4078, -4078,
   -4078, -4078, 64500, 12109, -4078,    -1,  4058, -4078,  3769, -4078,
    3770, -4078, 56880, -4078,  3358,  1195, -4078, 39735, -4078, -4078,
     955,  1195, -4078,  1195, -4078, -4078, 27008, 16051,  2493, -4078,
    3520, -4078,  3493, -4078, -4078,   676, -4078, -4078,  -184,  -184,
   -4078, -4078, -4078, -4078, -4078,  2226, -4078, 48625, -4078, -4078,
    4106,  4107,  3998,  4109,   104, -4078,  -164, -4078, -4078, -4078,
    4110, -4078,  4111,  3508,  3509, -4078, -4078, -4078,  4024, 63865,
   -4078,  4017, -4078,   -32, -4078,  1126, -4078,   115,  1342,  2234,
   -4078,  4162, -4078,   161,  3792,  3793, -4078, -4078, -4078, -4078,
    -123,  3545, 12109, 63865, -4078,  4010, -4078,  3939,  2079,  3881,
    3516, -4078,  3521,  2007,  4049, 65135, 65135, -4078, -4078, -4078,
   -4078, -4078,  3895,  4170, -4078, -4078, -4078, -4078, -4078, -4078,
   -4078, -4078, -4078, -4078, -4078, -4078,  2251, -4078, 16708, -4078,
   -4078, -4078, -4078, -4078, 48625, -4078,  3592, -4078,  3531,   272,
     272,  4136,   272, -4078,  4138,  4140,  -164, -4078, -4078, -4078,
   53705, 53705, -4078, -4078,  4035, -4078, -4078, -4078, -4078, -4078,
   -4078, -4078, -4078, -4078, -4078,  3591,  4057, -4078, -4078,   126,
   -4078,   209, -4078,   796, 61325,  4141, 57515, -4078, -4078, -4078,
   -4078, 12109, -4078, 49895, 61960,  3536, -4078, -4078, -4078, -4078,
   -4078,  3723, -4078,  3493, -4078,  3544, -4078,  3099,  3316, -4078,
   -4078,  3547, -4078, -4078,   272, -4078,   272,   272, -4078,  3550,
    2255,  3724, -4078,  3736,   915,   915,  -184,  3942, -4078,   126,
   -4078, 12109, -4078,  4047,  3643, -4078,  3555, -4078, 63865,   382,
   63865, -4078, -4078,  3995,  3561,   284, -4078,  3554, -4078,  3986,
    4034, -4078, 16708,  3566, -4078, 12109,  3567,  3564, -4078, -4078,
   -4078, -4078, -4078, -4078, -4078, 63865, -4078, -4078, -4078, -4078,
   -4078,   796,  4175, 63865, 57515, 58785,  3772, 62595,  4040, 57515,
    7796,  4042,  4046, -4078,  4183,  3849, -4078, -4078,   796, -4078,
   -4078, 63865, -4078,  3681, -4078, 59420, -4078,  2691, -4078,  3616,
   -4078, -4078,  4114,  3053, -4078,   272,  4013, -4078, -4078, -4078,
   63865, 63865, -4078, -4078, -4078, 37830, 12109, -4078, -4078, -4078,
   -4078, -4078,   657, -4078,  3879,  3597, 60055, 63230, -4078, -4078,
   -4078, 32743, -4078, -4078, -4078,  4061, -4078,   796, -4078,     9,
   21890,  3758, 37830, -4078, -4078, -4078, -4078, -4078, -4078, 48625,
    2262, -4078, -4078, 27008, -4078, -4078, -4078, -4078, 25092,  3608,
   -4078,   116, -4078, 27008, -4078, -4078, 16051, -4078, -4078
};

/* YYPGOTO[NTERM-NUM].  */
static const yytype_int16 yypgoto[] =
{
   -4078, -4078, -4078, -4078, -4078,    98, -4078, -4078, -4078, -4078,
   -4078, -4078, -4078, -4078,  1899, -4078, -4078, -4078, -4078, -4078,
    1596, -4078,   480, -2355,  -491,  3332, -4078, -4078, -4078, -4078,
   -4078, -4078, -4078, -4078, -4078, -4078, -4078,   762,  1707,  3241,
   -4078,   376, -4078,    26, -4078, -4078, -4078, -2970,  -104,  -304,
   -4078, -4078,  1117,    30,  3235,  -302, -4077, -4078, -4078, -4078,
   -4078, -4078, -4078, -4078, -4078, -4078,   386,   385, -4078, -4078,
     217, -4078, -4078,  -879, -4078, -4078, -4078, -4078, -4078, -4078,
   -4078, -4078,  -474,  -434,  1887, -4078, -4078, -4078,  4242, -4078,
    3694, -4078, -1804,  2367, -4078, -4078, -4078, -4078, -4078,  2440,
   -1740, -4078, -4078, -4078,  1473, -4078, -4078, -4078,  -328,   330,
   -4078,   333, -4078,   334, -4078,   335, -4078,   337,   338,   339,
     340, -4078,   341, -4078, -4078,  -408, -4078, -4078, -4078, -4078,
     342, -4078, -4078, -4078, -4078, -4078, -4078, -4078,  -265, -4078,
   -4078,   -73, -4078, -4078,  -262,   352, -4078,  -196,   354, -4078,
     355, -4078,   -94, -4078,   -90, -4078, -4078, -4078, -4078, -4078,
   -4078, -4078, -4078, -4078, -4078, -4078, -4078,  3253, -4078, -4078,
   -4078, -2076, -4078, -4078, -2454,  2770, -4078, -1680, -4078, -4078,
   -1975, -4078, -4078, -1670,   803, -4078, -4078,  1447,   416, -4078,
   -1388, -2003, -1977, -4078, -4078, -4078, -2040, -2021,  -729,  2524,
   -1213, -2369, -4078, -4078, -4078, -4078,    99, -4078, -4078,   276,
    1737,  2253, -4078, -2546, -4078, -4078,   922, -4078, -4078,  1516,
     764,  1517, -4078,  1093,  3005, -1271, -4078, -4078, -4078, -4078,
   -4078, -4078,    23,   344,   -81, -4078, -3151,   770, -4078, -4078,
   -4078, -4078, -4078, -4078, -4078, -4078, -2866, -4078, -4078, -4078,
    -287, -4078, -4078,  -180, -4078, -4078,  -240, -4078,   162, -2387,
   -4078, -4078, -4078, -4078,  2774, -1384, -4078,  3761, -4078,  -503,
   -4078,   484,  1768, -2443, -1995, -4078,  -927,  -920, -2952, -4078,
   -4078, -4078, -1979,  1039,  1321, -4078,   722,  1763, -2442, -4078,
   -4078, -4078, -4078, -4078,  1324, -4078, -4078,   485, -4078,   475,
   -4078, -4078, -4078, -4078,  -248, -4078,   114, -3228, -4078, -4078,
   -4078, -2946,  1234,   670, -4078, -4078, -4078, -1836, -2996, -1403,
   -4078,   294, -2517, -2579,   638, -4078, -4078,   435, -3848, -4078,
   -4078,  -578, -2164, -2489,   -48, -4078, -4078,   449, -3123,  1883,
   -4078, -4078, -4078, -3416, -2179,  1635, -4078, -4078,  1188, -4078,
   -1230,  1192, -4078, -4078, -4078,  1196, -4078,    25, -4078, -4078,
   -4078, -4078, -2944, -4078, -4078, -1574, -2429, -4078, -4078,  4410,
    4411, -1578, -3114, -4029,   -83,   -82, -4078, -4078, -4078,  2236,
   -1958,   101,    85,    93,  1734, -1088,   247,  1042, -1876, -4078,
     312, -4078, -4078, -4078, -4078, -4078, -4078, -4078, -4078, -4078,
   -4078, -4078, -4078, -4078, -4078, -4078, -4078, -4078,  1805, -1841,
   -4078, -4078, -4078, -4078, -4078, -4078, -4078, -2406, -2879, -4078,
   -4078,  1367, -4078, -4078, -4078, -3213, -2091, -2089, -2432,  3423,
   -4078, -4078, -4078, -4078,  3368, -2258, -3030, -4078, -4078, -4078,
   -4078, -4078, -4078, -4078,  2924,  1119, -4078, -4078,  1939, -4078,
   -4078, -4078, -4078, -4078, -4078, -4078,   512,  2014, -4078, -4078,
   -4078, -4078,  2329, -4078, -4078, -4078, -4078, -4078, -4078, -4078,
   -4078,    10, -4078, -4078, -4078,   759,  2835, -4078, -4078, -4078,
      -9, -4078, -4078, -4078, -4078,  2535, -4078, -4078, -4078, -4078,
    2862, -4078, -4078, -4078, -4078, -4078, -4078,  1615, -4078,  2055,
   -4078, -1551, -4078, -4078,  1180, -1038,  2009,  -614,  2141,   468,
   -4078,  3844, -4078, -4078, -4078, -1727, -1201, -4078,  3527, -1024,
   -2692,  2521,  -572, -1931,  1224,   182,  1548,  -432,  4169, -4078,
   -1153, -1178, -4078, -4078,  -668, -4078, -4078, -4078, -4078, -4078,
    2244,  2245,  -621, -4078, -4078, -4078, -4078, -4078, -4078, -4078,
   -4078, -4078, -4078, -4078,  1657, -4078, -4078, -4078, -4078, -1272,
   -4078, -4078, -4078, -4078, -4078, -4078, -4078,  1139, -4078, -2103,
   -4078, -4078,  -445, -4078,  3309, -4078, -4078, -4078, -2357, -1797,
    1954,  1132, -4078, -4078, -4078, -4078, -4078, -4078, -4078,  1961,
   -4078, -1612, -4078, -2787, -4078, -4078, -4078, -4078, -4078,  2159,
   -4078, -4078, -4078, -4078, -4078, -4078, -4078, -1669, -4078, -1851,
     231, -4078,   412, -4078, -4078, -4078, -4078, -4078, -4078, -4078,
    -101,   977,  -100, -2686, -1116,  1648, -4078, -4078, -1330,  3344,
   -2367, -4078, -4078, -4078,  2147, -4078, -4078, -4078, -4078, -4078,
     775, -2998,  2953, -4078, -4078, -3301,  -956, -2342,  -929, -4078,
   -1426,  1554,   606, -4078, -1737, -1129, -1499, -2980, -2490, -4078,
    1427, -4078, -4078, -4078, -4078,  -218, -4078, -4078, -4078,   621,
    2040, -4078, -4078, -4078, -4078, -4078, -4078, -4078, -4078, -4078,
   -4078,  -536,  -902, -4078, -4078,  2300,  -484, -4078,  3458, -4078,
   -4078,  3464, -4078, -4078, -4078, -4078,  3143,  3116,  2101, -4078,
   -4078, -2449, -4078, -4078,  2067, -4078,   887,  -894,     3,  1207,
   -4078, -4078,  1210, -3259, -4078, -4078,  3470, -4078, -4078, -4078,
    1157, -4078,    51,  3899,  3471, -4078, -4078, -4078, -4078, -4078,
   -4078, -4078, -4078,  2877, -1087,  3829, -4078, -4078, -4078, -4078,
   -4078, -4078,  2494, -4078, -4078, -4078, -4078, -4078, -4078,  3059,
    3918,  -593, -1352, -4078,  -786,  2497,  2019,  -861, -4078, -4078,
   -4078, -4078,  3921, -4078, -4078, -4078, -4078, -4078, -4078, -4078,
   -4078, -4078, -4078,  2674,   806, -4078, -4078, -4078, -4078,  3130,
   -4078, -4078, -4078, -4078, -4078, -4078, -4078, -4078, -4078, -4078,
   -4078, -4078, -4078, -4078, -4078, -4078, -4078, -4078, -4078, -4078,
   -4078,  1245,  -144, -4078,    43,  -177, -4078,   -47, -4078, -4078,
   -4078, -4078, -4078,  -247, -4078, -4078,  -253, -4078, -1029, -1430,
     568, -1307, -2611, -4078,  1235,  3120, -3329,  -693, -1212, -1214,
   -2784,    91, -4078, -4078,  3460,    87,   826,  -395,    -6, -3884,
    -103,  -607,  -610,  -740, -4078, -2956, -4078, -4078, -4078, -4078,
   -4078, -4078, -4078, -4078,  2059, -4078, -4078, -4078,  1206, -4078,
    3941, -4078,  2760,  1215,  3948, -1404,  2582,  2072,  2076, -4078,
   -4078,  2080, -2005, -4078, -4078,   170, -4078,  2648, -4078, -4078,
   -4078, -4078, -4078, -4078, -4078, -4078, -4078, -4078, -4078, -4078,
   -4078, -4078, -4078, -4078, -4078,  3722,  -452,  -451,  3142,  3964,
    3639, -4078,  3213, -4078, -4078, -4078, -4078, -4078,   531, -4078,
     279,  2115, -1242, -1771, -4078, -4078,  2936,   548, -4078,  1738,
    -349,  -669, -4078, -4078,   528, -4078, -4078,  1645,  3973,  3640,
   -4078, -4078, -4078, -4078, -4078, -2786,  -918, -4078, -3478, -2842,
   -1749, -4078, -4078, -2217, -3077, -4078, -4078, -1049, -4078, -4078,
   -4078, -4078, -2059, -4078, -4078, -4078,    -7,  3940,  3944,  3945,
   -4078,  -789, -4078, -4078, -4078, -4078, -4078, -4078, -4078,  3534,
   -4078, -4078, -4078, -4078,  3541, -4078, -4078, -4078, -4078, -4078,
    3542, -4078, -4078, -4078, -4078, -4078,  1809, -4078, -4078, -4078,
   -4078, -4078, -4078, -4078, -4078, -4078
};

/* YYTABLE[YYPACT[STATE-NUM]].  What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule which
   number is the opposite.  If zero, do what YYDEFACT says.
   If YYTABLE_NINF, syntax error.  */
#define YYTABLE_NINF -2763
static const yytype_int16 yytable[] =
{
     515,  1097,  1555,   892,   999,  1768,  1030,  1767,  1417,  1742,
    1858,   556,  1562,   555,  2460,  2461,  1675,   563,   952,   995,
    2197,   574,   670,  2134,  2636,   646,  2637,   577,   582,  1050,
    1638,  2320,  1049,  1899,   589,  2005,   513,   592,  1497,  2004,
    1467,  1972,   589,  1170,  2131,  1857,  2979,  1719,  2870,   610,
    2193,  2194,  1431,  1434,  2730,  2838,  2990,  3119,   825,   826,
     827,  3046,   829,  1447,   831,  1467,  2737,   833,  1122,   835,
    1105,  1834,  1800,  1801,  2990,  2990,  1804,  1805,  1806,  1807,
    3422,  1809,  1810,  1812,  1814,  1815,  1816,  1817,  1818,  1790,
    3303,   140,  3656,   635,  1288,   813,  1798,  3230,  3483,  3339,
    1908,  2819,  1870,  1284,  2795,  1684,  1461,   867,   868,  1005,
    2571,  1518,  1012,  3490,   561,  2894,  2366,   638,  1567,   515,
    2626,   515,   645,   651,  2012,  1568,  2443,   656,  2738,  1086,
    1089,  3002,  3811,  2934,  1498,  1267,  2572,  3708,   867,   922,
    3157,  3158,  3867,  3011,  2025,  2689,  3164,  3015,  3166,  3517,
    2938,  2943,  2028,  2029,  3423,   640,  3584,   642,  3030,  3498,
    2952,  1379,  3999,  3345,  2690,  1234,  1235,  3534,   569,  4028,
    3041,  1225,  1226,  1227,  1591,  1110,  1111,  1112,  2102,   522,
    3221,  2067,  2686,  1268,  2990,  2990,  2356,  2089,  1903,  3134,
     634,  3982,  2186,  1347,  3799,  2994,  2995,  2677,  4324,   573,
    3524,  3050,  1564,  3950,  1341,  3162,   581,  1914,  2687,  4646,
    1499,  1564,  1234,  1235,  3525,  2307,  3384,  2456,  1234,  1235,
     599,   867,  1234,  1235,  2925,  3548,  3520,  3400,  3526,  3132,
    3524,  2174,  -935,   961,   942,  1602,  1234,  1235,  1493,   961,
     942,  -572,  4398,  1472,  3525, -2714,  1541,  1549,   667,  3841,
    3183, -2084,  3763,   602,  1234,  1235,  2791,  1356,  3526,  1871,
   -1560,  1450,  1819,  4480,   884,  2492, -2638,  4303,  4304,   961,
     942,  1234,  1235,   874,  4481,  3359,  2213,  1143,  1144,  3687,
    4316,  4597,  1427,  3603,   896,  1564,  1588,  1269,  4765,   570,
    1090,  4317,  4308,  4593, -2482,  1042,  3222,  1953,  1006,  3592,
   -1560,  1347,  1234,  1235,  4496,  3125,  3126,   657,  3325,  2970,
    1018,  1360,  2081, -2644,   619,  -573,   681,   908,  4299,  3943,
    3948,  1234,  1235,  3949,  2216,  1954,  1525,  3661,  1606,  1210,
    1478,  3888,  1234,  1235,   122, -1600,  2453,  3060,  3147,  1348,
    3149,   566,  3959,  1957,  4523,  2370,   273,  3051,   275,  3981,
    1150,  1216,  1291,  1465, -2714,  2890,  3081,  3865,  1202,  2559,
    1507,  1535,  2091,  4506,  4574,  4523,  3090,   904,  1234,  1235,
    3337,  3079,  3386,  1778,  4701,   682,  2905,  4325,   867,   139,
    1234,  1235,  2521,  1468,  2778,  3360,  1911,  2454,  3521,  1234,
    1235,  1234,  1235,  2062,  2085,  3524,  4702,  2906,  4575,  1234,
    1235,  1234,  1235,  4382,  2707,  2250,  2180,  2062,  2821,  3525,
    2779,  1332,  3793,  1620, -2562,  2132,  3202,  2548,  1234,  1235,
    3298,  3080,  2063,  3526,  2348,  2567,  4078,   674,  3091,  3338,
     909,  1912,  2349,  2907,   961,  3944,  2064,  1469,  1621,  2133,
    1151,  3842,  1508,  3662,  2891,   567,  1708,  1348,  1203,  1709,
    1607,  2371,  4309,  2284,  1608,   124,   865,  3137,  1234,  1235,
    1683,   877,  2055,  1539,  1547,  1609,  2082,  3522, -2482,  2308,
    1338,  1234,  1235,  2103,  1170,  1872,  4588,  2913, -2563,  4300,
    1603,  1820,   620,  4766,  2299,  1955,  4016,   865,  4482,  1234,
    1235,  2052,  2998,  1019,  1020,  3221,  1492,  1007,  1626,  4598,
    1234,  1235,  3604,  3387,  1821,   661,  3082,   910,   683,  4318,
    1234,  1235,  1211,  1212,  1234,  1235,  1361,  1958,  2356,  1271,
    3311,  3312,  3061,  2055,   645,  1043,   651,   905,  1526, -2562,
    4594,  4118,   876,  1236,  3381,  1554,  1237,  4502,  4060,  4047,
    4122,  1779,  4696,   651,  1967, -2638,  2493,  1494,   139,  1234,
    1235,  1830,  1044,   645,   872,  3647, -2114,   885,   645,  3651,
     882,   897,  2478,  1415,  4138,  2571,  4496,  1234,  1235,  4140,
     865,  3912,  2786,   900,  3921, -1600,   139,  1795,  4061,  3396,
    1236,  1234,  1235,  1237,   645,  3372,  1236,  4067,  2990,  1237,
     953,  2572,  1357, -2563,  2357,  4037,  1866,  1610,  1091,  3614,
    1014,  1270,  3386,  2057,  1236,   664, -2265,  1237,  3384,  2007,
    1428,  3222,  2010,  1451,  1873,  1571,  2013,  1834,  2016,  1033,
    3693,  2640,  1236,  1858,  1859,  1237,  3223,  3138,  4310, -2291,
    2337,  2626,  1803,   645,   875,  1055,  3701,  3702,  1567,  1236,
    2990,  2340,  1237,  2689,  2343,  1568,  2031,  2032,   515,  1824,
    3705,  4617,  4617,   635,   883,  1084,  2888,  3884,  1857,   635,
     635,  3659,  2690,  2951,  1098,  1055,  4483,   645,  1822,  1933,
    1236,   645, -1560,  1237,  2500,  1234,  1235,  3510,  1117,  2926,
    2686,  1234,  1235,  3523,  1071,  1652,  1653,   664,   571,  1236,
     664,  1567,  1237,  1952,  1015,  1611, -2410,  3763,  1568,  2089,
    1236,  3127,  2162,  1237,  4186,  1473,  2687,  4399,  1604,  1342,
     600,  1707, -1600,  1234,  1235,  4196,  2027,  1234,  1235,  1720,
    2102,  1722,  4647,  3388,   836,  2570,  3845,   865,  1283,  -935,
    1171,  3231,  2895,  1735,  1736,  1737,  1236,  1105,  -572,  1237,
    3361,  1741,  3836,   603,   890,  4334,  4235,  2214,  1236,  1915,
    1081,  1237,   903,  2334,  1837,  3052,  3951,  1236,  3624,  1236,
    1237,  3509,  1237,  2187,  2065,  3800,  1904,  1236,  1536,  1236,
    1237,  3527,  1237,  2188,  3534,  1234,  1235,  3135,  1016,  3516,
    2413, -2644,  2067,   601,  2174,  2960,  1236,  1238,  1604,  1237,
    3946,  1231,  1479,  1233,  1234,  1235,  3979,  2685,  4053,  3499,
    1934,  3527,  4000,  1049,   924,  3224,  2323,  2997,  3154,  2230,
   -2644,  3326,  -573,  1234,  1235,  4409,  3920,  1848,  1276,   515,
    1278,  1279,  1055,   515,   645,   645,  1236,   515,   645,  1237,
    1901,  3154, -1600,  1323,  1238,  1021,  4600,  4437,  2942,  1236,
    1238,  2822,  1237,  1432,  1238,  1435,  2090,  1921,  1438,  1443,
    2309,  3621,  4722,  2843,  1213,  1277,  2231,  1236,  1238,  1281,
    1237,  3878,  3879,  1286,  2011,  1464,  4345,  1049,  1236,  1502,
    1352,  1237,  4049,  3203,  2091,  1072,  1238,  2992,  1236,  3242,
   -2562,  1237,  1236,   635, -2114,  1237,  2996,  3139,  1234,  1235,
    2179,  1775,  1776,  1238,  1710,   645,   635,  1711,  1251,  1927,
     635,  1234,  1235,  3389,  4370,  1339,  3328,  3146,  2957,  2285,
    2870, -2562,  1234,  1235,  3100,  3922, -1600,  1236,  2425,  3105,
    1237,  3382,  3283,  1604,  1238,  3697,  2357,  3113,  3114,  1537,
    1234,  1235,  4261,  3121, -2265,  1236,  2085,  3679,  1237,  2300,
     645,  3223,   645,  1238, -2563,   645,   645,  1234,  1235,  1236,
    4062,  1987,  1237,  4256,  1238,  3116,  2887, -2291,  3806,  2180,
    3684,  1427,   645,  2059,  2060,  2061,  3527,  3809,  4510,  3627,
    2204, -2762,  2692,  1234,  1235, -2563,  3476,  2636,  1936,  2637,
    1363,  3642,  1376,  3655,  4516,  3646,  4518,  3945,  3760,  3650,
    1238,  2069,  1433,  1382,  2571,  1234,  1235,  1388,  2425,  1234,
    1235,  4559,  1238,  1234,  1235,  1775,  2249,   635,  1316,  1450,
    4082,  1238,  3700,  1238,  2641,  2103,  3029,  2288,  2289,  1105,
    2572,  1238,  3162,  1238, -2410,  4587,  3002,  2222,  2305,  2306,
    1553,  4448,  2256,  1480,   518,  1563,  4176,  3030,  2800,  2801,
    1238,  1234,  1235,  1236,  4455,  1206,  1237,  4205,  -476,  1236,
    3473, -2114,  1237,  1234,  1235,  3187,  3188, -2621,  2467,   635,
    2005,  1831,  2005,  2005,  1481,  2496,  2930,  2931,  4269,  4478,
     635,  3551,  3365,  2626,   664,  3306,   664,  2751,  2482,  2406,
    1238,  1236,  1791,  3690,  1237,  1236,  2366,  1100,  1237,  1234,
    1235,  2689,  1467,  1238,  1254,  2205,  2355,  3343,  3344,  3313,
    2526, -2265, -2625,  4254,  1627,  1628,  1629,  1634,  3204,  3205,
    2690,  1238,  3308,  3309,  3310,  3561,  2709,  4275,  1482,  1092,
    3643,  3603,  1238,  1483, -2291,  2316,  2217,  1467,  2686,  1785,
    1234,  1235,  1238,  1512,  2829,  1207,  1238,  3239,  3240,  2471,
    1641,  3936,    44,  1236,  3937,  2858,  1237,  1171,  2224,  2935,
    1831,  2494,  2227,  2399,  2687,  3103,  1583,  4290,   590,  2089,
     139,  1171,  1236,  2426,  2499,  1237,  1823,  2502,  2503,   867,
    2182,  1238,   523,   135,  3956,  3957,  3958,  2421,  2422,  2799,
    2570,  1236,  3961,  2965,  1237, -2624,   273,  2228,   275,  1238,
    3987, -2410,  2320,  3366,  1937,  4176,  4176,  4058,  4552,  1093,
    2342,  3934,  3935,  1238,  1632,  2229,  2966,  2574,  3162,  4324,
    3117,  3162,  3162,  1769,  1503,  1860,  2407, -2622,  3890,  2236,
    1591,  1768,  2804,  2805,  3466,  3608,   645,  3891,  3162,  1234,
    1235,  3474,   990,  1269,  2854,  1234,  1235,  1859,  4549,  1567,
    4550,  4395,  3960,  2426,  1280,  4509,  1568,  1606,  3980,  3983,
    3985,  3986,  3501, -2623,  2344,  1963,  1236,  1374,   136,  1237,
    1095,  1096,  4083,   645,  1234,  1235,  1792, -2628,  1827,  1236,
    3609,  1913,  1237,  1642,  4217,  1484,  2513,  3403, -2714,  3405,
    1236,  4511,  2798,  1237,   635,  2696,  3416,  2327,  2174,  1428,
    2041,  3277,  2808,  2317,  4218,  2685,   141,  1238,  1236,  3347,
    3429,  1237,  2359,  1238,  1768,  3929,  2955,  3440,  3442,  2697,
      58,  1171,   645,  2237, -1895,  1236,  4276,  1832,  1237,  2247,
    3459,  3461,  3463,  4206,  1234,  1235,  3464,  3442,  1964,  4555,
     645,  2335,  2412,  1873,  2091,  1238, -2621,  3314,   645,  1238,
    3604,  1236,  2427,  1884,  1237,  1887,   557,  1504,   635,  3118,
    1485,  2248,  4176,  4176,  2221,  1122,  2362,   273,  2090,   275,
     635,  1451,  3506,  1236,  3803,  3892,  1237,  1236,   645,  1607,
    1237,  1236,  1505,  1608,  1237,  3367,  4512,   635,   635,  1234,
    1235, -2625,  4470,  4471,  1609,  1234,  1235, -2714,  4325,  4490,
    1513,  1604,  2085,  1234,  1235,   664,  2472,  1238,  4375,  1263,
    1264,  1265,  1266,   645,   645,  2119,  1832,  1939,  4513,  1236,
    1234,  1235,  1237,  2252,  1486,  1947,  1238,  2770,  1948,  4277,
    2408,  1236,  2427,  3562,  1237,  4324,  3691,   645,  1234,  1235,
    1234,  1235,  2264,  3394,  3394,  1238,  4491,   575,  1968,   953,
    1234,  1235,  1891,  2179,  3923,  1388,  1234,  1235,  3520,   515,
     515,   515,   635,   515,   635,  4515,  2691,  1236,  2042,  2006,
    1237,  4176,  2043,  2180, -2624,  2008,   515,  4545,   645,  2071,
    2692,  2328,   515,  4388,  1251,  1388,  4176,   664,  1793,   867,
    2444,  2599,  3368,  4267,  4268,  1988,  1989,  1990,  2041,  1992,
    3841,  2041,  3582,   635,  1794,   579, -2622,  2102,  1236,  2005,
    4344,  1237,  2009,  1234,  1235,  1994,  2509,  2607,  2015,   604,
    1238,  1234,  1235,  1066,  3402,  3685,  1610,  1831,   865,  3688,
    3689,  4081,  3994,  1238,  2120,  4567,  2271,  4787,  1234,  1235,
     606,  3348, -2623,  1487,  1238,  1965,  3626,  1984,  2693,  2275,
    3432,  3433,  3425,  4176,  3124,  -476, -2628,  1270,   635,  1991,
    2276,  1993,  1238,  4270,  2431,  2610,  4376,   622,  4377,  2530,
    3692,  4238,  4492,  1641,  2014,  1995,   645,  4176,  2278,  1238,
    1488,  2678,  1858,   273,  1049,   275,  4109,  1234,  1235,  4176,
    4176,   635,  1234,  1235,  2911,  2279,  2127,   635,  1234,  1235,
    2026,  3268,  3269,  3270,  3706,  1238,  4557,  1236,   635,  4561,
    1237,  1234,  1235,  1236,  4325,  3710,  1237,  1857,  3712,  2570,
    3521,  2283,  1234,  1235,  1611,   645,  2982,  1238,  3426,  3148,
     645,  1238,  1234,  1235,  4013,  1238,  2510,  3352,  -212,  1117,
    1641,  2203,  1236,  2301,   607,  1237,  2223,  4012,  1234,  1235,
    1272,  3185,  2085,  2511,  2510,  2066,   673,  2990,  4176,   878,
    1768,   677,  3294,  3238,  4346,  2948,  2042,  1067,  4176,  2042,
    2043,  2511,  3291,  1238,   830,  2101,  2453,  1234,  1235,   834,
    1254,  1234,  1235,  2512,  4110,  1238,   623,  1641,  2121,  3186,
    1234,  1235,  3842,  2329,  2129,  1234,  1235,   591,   990,  3532,
    3995,  3197,  1236,  4258,  1641,  1237,  1664,   901,  2694,  2330,
    4686,  4687,  4176,  3807,  4176,  2250,  1288,  4237,  1234,  1235,
    2696,  1238,  3825,  2085,  2803,  2431,  1327,  4111,  3427,  1171,
    2257,  2167,  4080,  2432,   519,  2843,   927,  3207,   520,  4176,
    3288,  1234,  1235,  4347,  2697,  2983,  2360,  4176,   879,  4176,
    1392,  4176,  2218,  2685,  1465,  3078,  2999,  1236,  1940,  1536,
    1237,  1996,  1238,  1236,  2513,  4176,  1237,  4671,  3353,  4176,
    2034,  1236,  3068,  1727,  1237,  1095,  1096,  1831,  3208,  1105,
    3890,  1234,  1235,  1832,  4176,  4176,  1234,  1235,  1236,  3891,
    2326,  1237,  2734,   658,  1234,  1235,  3843,  2739,  2219,  1271,
    4176,  4176,  2103,  1234,  1235,  4176,  1236,  1328,  1236,  1237,
    2745,  1237,   625,  1329,  4139,  2547,  3911,  4141,  1236,   880,
    1731,  1237,  4231,  4232,  1236,  3394,  1369,  1237,  2090,  1370,
    1234,  1235,  2350,   635,  2092,  1234,  1235,  1755,   865,  1768,
     645,  3438,   635,   645,  2760,  2320,  4233,  2882,  1234,  1235,
    1049,  2035,  2433,  2434,  2377,   635,  2466,  1330,   636,   519,
    1323,  1238,  2949,   520,  2102,  1323,  1072,  1238,  2373,   928,
     639,  3026,  1580,  1581,  1331,  2381,  2381,  3819,  2381,  1626,
    2514,  1236,  2990,  2990,  1237,  1234,  1235,  1234,  1235,  1236,
    2085,  1941,  1237,  2435,  4045,  1867,  1238,   645,  1868,  3938,
     635,  1869,  3941,  3942,   635,  3029,  1236,  1234,  1235,  1237,
     580,  2238, -1806,  2814,  2132,  3523,   952,  1624,  4066,  3954,
    1537,   645,   645,   635,   635,  1234,  1235,  3892,  2692,  3263,
    2351,  2348,  2515,   641,  1171,   645,  1972,   586,  2133,  3322,
    2381,  2381,  2381,  2093,   664,   586,   929,   654,   990,   124,
    2515,  1234,  1235,   645,  1626,  1236,  1238,  2179,  1237, -1806,
    1236,  3844, -2762,  1237,  2691,  2198,  1236,  2990,  1417,  1237,
     953,  2239,  2380,  2380,   661,  2380,  1371,  3845,  3331,  1236,
    1234,  1235,  1237,  1261,  1262,  1263,  1264,  1265,  1266,   676,
    1236,  2489,  3085,  1237,  1234,  1235,  2431,  2404,  1058,   667,
    1236,  1363, -1895,  1237,  3578,  1467,   832,  3086,  3580,  2168,
     669,  1238,  2420,  1234,  1235,  1831,  1236,  1238,  3644,  1237,
    1382,  2424,  1234,  1235,   671,  1238,  2246,  1234,  1235,  1234,
    1235,   635,  2260,  1832,  1234,  1235,   672,  2380,  2380,  2380,
    2261,   678,  1238,  -578,  3518,  1236,   626,  2508,  1237,  1236,
    3952,  1059,  1237,  3953,   635, -1806,   679,  2265,  1236,  3506,
    1238,  1237,  1238,  1236,   515,   515,  1237,  2532,   515,  3341,
    3846,  3351,  1238,  3553,  3554,  2269,   680,  2270,  1238,  2485,
    2085,  2534,  2535,   839,  3334,  2169,  1236,  2274,   823,  1237,
    2679,  3028,   828,  2277,  3567,   873,  2695,  1768,  2546,  3575,
    2528,  2529, -1806,  2332,   893,  4021,  1234,  1235,  2708,  1236,
     895,  2094,  1237,  2220,  1271,  2564,  2565,   887,  1234,  1235,
    3914,  3915,  2095,  2433,  2434,  1432,   635,   913,  2501,  2096,
    2937,  3290,  2141,  2142,  1511,  1238,   915,  1432,  2225,  2226,
    1516,  1517,  1060,  1238,  1004,  1768,  1011,  2955,  2155,  1236,
    2280,  2520,  1237,   905,  1236,  1234,  1235,  1237,  2292,  2103,
    1238,  2383,  1236,  2384,  3297,  1237,  4612,  2243,  1271,  2537,
    1031,  1236, -1922,  1038,  1237,  2311,   961,   942,  2544,  2545,
    2672,  2673,  2674,  2675,   626,   645,   990,   645,  2068,  2549,
    2550,  2551,  2552,   645,  2560,  2561,  1859,  2714,  1236,  2703,
    1032,  1237,  2706,  1236,   876,  1831,  1237,  1234,  1235,  1238,
    3171,  1046,  1234,  1235,  1238,  3174,  1236,  1668,  4030,  1237,
    1238,  2806,   645,  1057,  3151,  2448,  2449,  2450,  2097,  3175,
    1082,  2796,  1251,  1238,   645,  3181,  1105,  1105,  1105,  2170,
    4337,  4341,   930,   931,  1238,   933,   611,   935,  3182,  1103,
    2344,  2251,  1271,  1236,  1238,  1236,  1237,  1065,  1237,  3189,
    1072,  2818,   936,  2102,  1085,   122,  2253,  1271,  1104,  3193,
    1238,  1832,  1645,  1646,  1647,  1236,  2157,  2158,  1237,  1119,
    1669,  1120, -1922,  1934,  1934,  1934,  1049,  1049,  1049,  1665,
    4352,  1121,  3696,  1236,  2918,  1274,  1237,  1123,   612,  1238,
    2772,  2254,  1725,  1238,  4202,  4203,  4204,  1182,  1271,  1670,
    1124,   717,  1238,  1021,  3194,   927,  1125,  1238,  3195,  1236,
    2167,  1728,  1237,  2098,  1732,  4031,  4032,  3196,   645,  1201,
    4033,  4034,  3198,  2266,  1271,  2267,  1271,  2774,  2141,  2142,
    1238,  1128,  1217,  1218, -1923,  1751,  1752,  2102,  1236,  1756,
    1251,  1237,  1129,  2815,  2155,  3201,  1061,  2919,   645,  2268,
    1271,  2999,  1236,  1238,  1130,  1237,  3237,  1131,   123,  1770,
    1771,  2005,  1275,   613,   722,  4010,   990,    13,  3206,  1671,
     645,  1236,  3772,  1132,  1237,  1133,   124,  3640,  4337,  1134,
    1236,  1135,  4341,  1237,  1136,  1236,  1137,  1236,  1237,  1138,
    1237, -1895,  1236,  1238,  2167,  1237,  2272,  1271,  1238,  1139,
    3616,  1768,  2691,  3294,  1467,  2852,  1238,  1292,  3209,  1140,
    2681,  1141,  1062,  3211,  1063,  1238, -2757,  1326,  1254,   990,
    2167,  3213,  1025,  1026,  3153,  1027,  1145,  1028,  3148,  2875,
    3215,  2466,  1432,  2878,  1234,  1235,  2562,  2563,   928,  1147,
     645,   645,  1238,  3414, -1923,   125,  2920,  1238,  1672,  2788,
    1271,  1832,  4620,  4619,  2899,  1148,  2901,  3216,  2827,  2828,
    1238,  1324,  3217,   735,  1236,  1149,  3026,  1237,  1152,  2085,
    1153,  2072,  2157,  2158,  1336,  3572,  1236,    25,   953,  1237,
   -1922,  2718,  1154,  2566,  2006,  2073,  2006,  2006,  4246,  4247,
    1155,  2320,  1333,  1768,  2681,  3438,  1156,  1238,  3385,  1238,
    1157, -1895,  3170,  2226,  3173,  1271,  3397,  2719,  1158,  2132,
    1335, -1922,  1769,  1236,  3573,   929,  1237,  3199,  1271,  1238,
    1159,  2963,  3300,  3301,   515,  2921,  1160,  3816,   645,   645,
     126,  3404,  1161,  2133,  3574,  1164,  1254,  1238,  4116,  4117,
    3304,  3305,   751,  3418,  1165,  3420,  3421,  2898,  2103,  4337,
    4341,  4120,  3818,  2085,   961,   942,  1250,  3434,  4123,  1166,
    2968,  3586,  1271,  1238,  2720,  1236,  3962,  2721,  1237,  1172,
    1236,  1256,  1257,  1237,  1173,  2722,  1174,  3010,  3824,  2085,
    3013,  3014,  1175,  3016,  4142,  4143,  3019,  3020,  2168,  1454,
    3023,  1176,  1238,  2723,  1831,  3032,  3611,  3612,  4351,  1177,
    3036,  3037,  3038,  3039,  3040,  3536,  1238,  3826,  3044,  3045,
    4097,  3047,  3963,  3062,  3777,  3778,   614,  3056,  3057,  3058,
    3059,  3827,  3964,  3063,  3064,  1238,  3066, -1922,  3077,  3785,
    3786,  1178,  2103,  1179,  1238,  3796,  3804,  1180,   615,  1238,
    3828,  1238,  3098,  3820,  1271,  4608,  1238,  1455,  1344,  3829,
    3837,  1271, -1923,  2074,  4085,  1345,  4197,  1183,  4097,  3853,
    3854,   127,  3537,  1184,  1673,  3538,  4003,  2563,  1185,  1251,
    3027,  3965,  2168,  3539,   616,  1186,  1456,  1187,  1831, -1922,
    1346,  4181,  4182, -1923,  3130,    38,  3028,  1689,  1188,  1256,
    1257,  3540,  1189,   635,   635,   635,  2724,  1934,  2168,  1190,
    1049,  4007,  4008,  1191,  1831,  1251,  1192,  4540,  4184,  4185,
    4188,  4185,  4189,  4185,  4245,  3305,    44,  1193,  1238,  1259,
    1260,  1261,  1262,  1263,  1264,  1265,  1266,  4264,  4185,  2075,
    1238,  1353,  1674,   617,   128,  1194,  3541,  1195,  1668,  3101,
    3102,  2922,  3104,  3560,  3106,  3107,  3108,  3109,  3110,  3111,
    3112,   952,  1196,  3115,  2076,  1197,  3120,  1198,   780,  3123,
    4273,  4274,  4354,  4355,  1199,   990,  1200,  1238, -2757,  1204,
     273,  1205,   275,  1208,  2169,  1252,  1209,  4727,  4389,  3612,
    1215,  2206,  2553,  4390,  4185,  3439,  4391,  4185,  1251,  1693,
    3142,  3143,  3144,  1219,  3542,  3587,  1220,   129,  1253, -1923,
    2725,  1669,  -854,  4393,  4185,  4394,  4185,  4400,  4401,  4022,
    4023,   930,   931,   932,   933,   934,   935,  2077,  1221,  1238,
    1323,  1222,  2373,  2509,  1238,  4088,  1352,   645,   645,   645,
    1670,   936,    54,  4402,  4401,   635,  1223,  1259,  1260,  1261,
    1262,  1263,  1264,  1265,  1266,  2554,   690,  4731,  4732,   990,
    1832, -1923,  1758,  1759,  2852,   645,  4788,  1224,  1769,  4441,
    4442,  1273,  2854,  1355, -2757,  1254,  2258,  4488,  3305,  1359,
    2262,  4489,  3305,  1171,  2555,   990,  1367,   645,   645,   645,
    4565,  4566,  3131,  1377,    58,  1095,  1096,  2385,  4591,  3612,
    3321,  1389,  1457,  1694,  2286,  3543,  1391,  1697,  3544,  1407,
    1671,  1254,  1095,  1096,  1698,  4622,  4623,  1409,  3967,  4683,
    3503,  2386,  3450,  2078,  3451,  3968,  4777,  4778,  3630,  3631,
    3594,  3595,  1410,  2006,  2387,  3851,  3852,  1411,  2170,  2818,
    4091,  1412,  3276,  3699,  1832,  1415,  2388,   717,  1418,  1423,
    1448,  1424,  1444,  -671,  2556,  1449,  2726,  3801,  1453,  2553,
    1465,  1474,  3441,  4260,  -671,  3969,  1475,  1476,  3452,  2999,
    1832,  2510,  1255,  1496,  1477,   635,  3077,  1500,  1501,  1506,
    2999,  3000,  1514,  1515,  1520,  1521,  3545,  1523,  2511,  1672,
    3453,  1528,  3000,  3320,  1254,  1699,  1533,  2389,  1564,  2390,
    2512,  1570,  2676,   721,  3077,  1768,  1572,  4350,  4262,  4263,
     722,  4265,  4266,  3401,  3399,  3077,  1251,  1574,  1577,  3411,
    1578,  3410,  2554,  1582,  1586,  2727,  2391,  3454,  1256,  1257,
    1241,  1242,  1587,  2557,  1592,  3415,   645,  3410,  3970,   726,
     727,  1458,  3431,  3435,  1258,  1593,  1594,  1769,  3424,  3446,
    1615,  2555,  1616,  1701,  2728,  3448,  3449,   635,  1617,  1623,
    1234,  1235,  1626,  1459,  1256,  1257,  1637,  1243,  1635,  3410,
   -2107,  1625,  3370,  1269,  1641,  1648,  3077,  3472,  1667,  1244,
    1678,  2513,  3485,  1713,  -671,  1724,  1725,  1749,   515,   526,
    1726,  2392,  3495,  4353,  4137,  -671,  4282,  3410,  1766,  1777,
     526,  1786,  4282,   541,  3897,  1460,  1802,  1808,  1828,   735,
     690,  1829,  1621,  1835,  1836,  1842,  3412,  3413,  1839,  1846,
    1245,  2556,  2273,  3546,  3491,  1843,  1850,  2132,  1844,  1845,
    1847,  1849,  1246,  3508,  1861,  1862,  1863,  1347,  2132,  1864,
    1892,  1897,  1900,  1909,  3445,  3971,  2393,  1256,  1257,  3515,
    1917,  2133,  3547,  1918,  3447,  1919,  1920,  1924,  1931,  1247,
    1929,   542,  2133,  1930,  1932,  4404,  1685,  1686,  1687,  1688,
    1689,  1943,   746,  1949,  1251,  3484,  1259,  1260,  1261,  1262,
    1263,  1264,  1265,  1266,  1973,  1982,  1981,   750,   751,  2017,
     543,  1986,  2553,  2018,  4091,  1702,  2019,  2514,  2020,  2022,
    2557,   717,  2023,  2024,  2039,  1673,  2053,  2070,  2116,  2122,
    2123,  1704,  1254,  1260,  1261,  1262,  1263,  1264,  1265,  1266,
    2136,  1248, -1600,  3635,  2137,  2163,  2181,   544,  2183,  2184,
    3455,  2195,  2201,  3511,  2207,  2209,  2234,  2242,  3585,  2210,
    2211,  2233,  2321,  2235,  2240,  4472,  2899,  2241,  2250,  2558,
    2244,  2255,  1768,  1668,  4350,  2554,  1251,   721,  2259,  2325,
    1150,  2263,  1202,  2281,   722,  2282,  2287,  2515,  2290,  1690,
    1691,  1692,  1693,  4403,  3456,   545,  2291,  1266,  2302, -1600,
    3190,  2303,  2304,  1348,  2555, -1281,  2852,  2331,  3001,  2341,
    2361, -1424,  1206,   726,   727,  4040,  2376,  1261,  1262,  1263,
    1264,  1265,  1266,  4050,  -671,  2875,  3623,  2396,  2405,  3625,
    1604,   645, -1600,  2411, -1600,  -671,  1669,  2414,  2417,  2439,
     645,  1432,  2440,  2445,  2446,  2447,  2815,  2468,  2462,  2553,
   -1600,  2469,  3458,   953,   953,  2473, -1600,  2474,  2470,  2898,
    2486,  2488,  2475,  2490,  2491,  2984,  2476,  2477,  2495,  2504,
    2505,  1417, -1600,  1769,  2556,   273,  2518,   275,  2519,  2522,
   -1600,  2523,  2525,   735,  1347,  1256,  1257, -1600,  3671,  2536,
    1254,  2553,  2527,  1393,  3460,   635,  1694, -1600,  1695,  1696,
    1697,   772,  4517,  1394,  2538,  4092,  3680,  1698,  4093, -1600,
    4627,  4178,  2554,  2539, -1600,  2543,  3077,  2553,  1395,   778,
    3462,   -67,   531, -1600,   780,  3410,   546,   781,  3077,  4219,
    1396,  1397,  1398,   531,  2540,  2985,  2558,  4220,   645,  2541,
    2542,  2555,  3410,  2642,  3077,  3077,   746,  2646,  1236,  1399,
    2648,  1237,  3641,  2557,  2554,  1432,  2650,  4126,  3077,  3410,
    4432,   750,   751,  2651,  4221,  2652,  2653,  4447,  2654, -1600,
    3410,  2655,  1254,  3410,   525,  2656,  2657,  2658,   547,  2659,
    2554,  4230,  2660,  2555,  4094,  4095,  4457,  2661,  1699,  2662,
   -1600,  2663,  3673,  2664,  2665,  2671,  2666,  3715,  2667,   548,
     635,  1668,  2680,  2668,  -671,  3771,  2669,  2670,  2717,  2555,
   -1895,  2556,  2699, -1600,  2986,  -671,  2700,  2553,  2701,  2704,
    2712,  2741,  2740, -1600,  4627,  1668, -1600,  3098,  2708,  2742,
    1348,  2752,  3698,  1259,  1260,  1261,  1262,  1263,  1264,  1265,
    1266,  3704,  -678,  1256,  1257,  1700,  1701,  2753,  2349,  3962,
    2765,  2787,   645,  2556,  2812, -1600,  2794,  2825,  2802,  3872,
     526, -1600,   549,  2830,  1669,  2833,  2811,  2831,   550,  2834,
    4632,  4633,  2826,  4635,  2832,  2835,  1768, -1600,  4772,  2556,
    2554,  2841,  2844, -1600,  2846,  4222,  2847,   551,  1669,  1768,
    2557,  4781,  2848,  1670,  1768,  3963,  4772,  3716,  -885,  1768,
     585,  4781,  2855,  2856,  1904,  3964, -1600, -1600,  2859,  2555,
    3774,  2860,   552,  2865, -1600,  2861,  2509,  2984,  2879,  2880,
    2883,  2884,  2885,  2454, -1600,  1256,  1257,  2453,  2903,   553,
   -1600,  2904,  2557,  1957,  3861,  4679, -1600,  4680,  4681,  1769,
    1958, -1600,  2914,  2929,  2932,  2944,   527,  2945,  2946,  2961,
   -1600,  2969,  2980,  2981,  3965,   772,   645,  2999,  2557,  4092,
    3012,  3017,  4093,  1671,  3018,  4230,  4223,  3021,  1400,  2558,
    3022,  3024,  2509,   778,  4604,  3025, -1600,  3031,   780,  2556,
    3034,   781,  3033,  3035,  4224,  1401,  3042,  2985,  1702,  3043,
    3084,  1259,  1260,  1261,  1262,  1263,  1264,  1265,  1266,  3088,
    3077,  3048,  1238,  1703,  1704,  3093,  3049,  4225,  3054,  3099,
    3129,  3133,  3055,  3128,  3065,  3145,  3165, -1600,  2202,  3410,
    3154,  3167,  3159,  3077,  3246,  3168,  4743,  3966,  1432,  3169,
    2987,  1769, -1600,  3176,  4758,  3410,  3177,   635,  4094,  4095,
   -1600,  3228,  1672,  4498, -1600, -1600,   892,   528,  3232,  3218,
   -1600,  3234,  3229,   273,  2510,   275,  3236,  3241,  2557,  3244,
    3265,  3266,  3271,  3282,  3278, -1600,  2986, -1600,  3273,  3281,
    1369,  2511,  3296,  1259,  1260,  1261,  1262,  1263,  1264,  1265,
    1266,  3285, -1600,  2512,  3299,  -854,  3302,  3307,  3323,  3902,
    3318, -1600, -1600,  3319,  3327, -1600, -1600,  2577,  3335,  2578,
    3635,  3324,  3993,   841,  3336,  3998,  2558,  3342,  3346,  4695,
    2510,  4697,  4006,  4006,  4006,  2006,  3357,  1402,  3349,  3358,
    2607,  3417,  3419,  3481,  3489,   645,  3486,  2511,  3493,   529,
    3492,  -819,  -819, -1600,  2580,  3497,  3502,  2055,  3503,  2512,
    3552,  4500,  3555,  -819,  4715,  3507,  3533,  3556,  2558,  2072,
     530,  3563,  3564,  2583,  3576,  2308,  3223, -1600,  3589,  3590,
    3591,  2584,  3600,  2073,  2513,  3602,  3607,  3613,  2431,  3615,
    3628,  3648,  3649,   531,  2558,  3636,  3660,  1403,  3666,  3672,
    3667,  4746,  4747,  3674,   990,  1095,  1096,  3876,  2586,  3247,
    2466,  3967,  3675,   842,  3682,  1404,  3676,   645,  3968,  3248,
    4226,  3681,  1564, -1600,  3683,  2587,  4495,  2878,  3695,  3703,
    4050,  3707,  3714,   532,  3249,  2640,  3713,  4784,  3773,  3782,
    2513,  3775,  3783,  3788,  3671,   844,  3250,  3251,  3252,  3789,
    3790,  3791,  3794,  3798,  2592,  3795,  3802,  4006,  3969,   845,
    3805,  3796,  3077,  3880,  3808,  3253,  3797,  4101,   635,  3810,
    3812,  3822,  3813,  3821,  3838,   533,  4106,  3823,  1673, -1600,
    3814,  3817,  1875,   534,  3849,  3840,  1876,  3856,  3868,  3869,
    3874,  3831, -1600,  3832,  2558,  3857,  3898,  1432,  1877,  3854,
    2514,  3322,  2987, -1510,  3889,  3907, -1515,   645,  3916,  3866,
    3917,  3468, -1600,  3873, -1600,  3883,  3913,  2574,  3899,  2575,
     849,   273,  3900,   275,  3903,  4498,  4068,  3924,  3932,  2596,
    3939,  3970,  2577,  4144,  2578,  3989,  3982,  2597, -1600, -1600,
    4014,  3804, -1600, -1600,  4018,  4019,  4024,  4025,   850,  4026,
     821,  2074,  2598,  4020,  4027,   851,  2514,  4038,  4039,  4042,
    4055,  4043,  4057,  4086,  2579,  4099,  4107,  4069,  4087,  2580,
    2515,  1685,  1686,  1687,  1688,  1689,  4070,  4089,  4090,  3979,
    4104,  4115,  4119,   635,  4121,  4230,  4216,  4129,  2583,  4130,
    4131,  4132,  4135,  4133,   645,   852,  2584,  4136,  4145,  4179,
    4187,  4125,  4190,  4191,  4192,  4194,  2585,  4199,  4195,  4675,
    2600,  4198,  4209,  4201,  4212,  4251,   635,  4755,  4242,  4244,
    4255,  4272,  4278,  2586,  4286,  4294,  2515,  2075,  2601,  4284,
    4006,  4006,  4287,  4006,  4006,  4288,  -352,  1564,  3971,  4530,
    2587,  4312,  4314,  4315,  4755,  4333,  4343,  4357,  2588,  1095,
    1096,  4360,  2076,  4361,  4530,  3469,  4366,  4369,  4371,  4373,
    4378,  4387,  4383,  2591,  4409,  4412,  4396,  -370,  4438,  2592,
    4439,  4440,  4449,  4450,  1690,  1691,  1692,  1693,  4486,  4459,
    4210,  4292,  4456,  2605,  3254,  2606,  4462,  4474,  4675,  3476,
    4519,  4526,  4298,  2608,  4520,  4527,  4555,  4305,  4531,   821,
    2594,  3255,  4537,  4538,   821,  4569,  4570,  4571,  4572,  4578,
    4579,  4580,  4581,  4252,  4582,  2077,  4585,  4592,  4595,  4596,
    4605,  4583,  4600,  4607,  4609,  4610,  4319,  4323,  1878,  4006,
    4613,  2599,  2574, -2461,  4631,  4634,   273,  4636,   275,  4637,
    4641,   821,  4644,  4645,  2596,  4668,  4655,  4669,   855,  4672,
    4684, -1684,  2597,  1769,  4682,  4689,  1879,  4692,   821,  4693,
    4694,  4698,  4786,  4703,  1880,  2614,  4699,  2598,  4704,  4710,
    4707,  4709,  4358,  4359,  4291,  4718,  4362,  4363,  4364,  4365,
    4714,  1694,  4725,  1695,  1696,  1697,  2878,  4720,  2878,  4723,
    2138,  2599,  1698,  4724,   858,  4734,  4736,  4730,  4744,  4759,
    4760,  4773,   821,   821,   821,   821,  4307,   859,  1881,  4764,
    2820,  2078,  4473,  4783,   821,  3256,  4002,  3122,  4397,  3787,
    2993,  2615,  2616,  2617,  4073,  2600,  4530,  1546,  2618,  4384,
    4501,  4642,  4071,  3257,  4643,  4075,  4667,  4250,  4775,  4738,
     598,  1576,  1003,  2601,  2619,  4413,  2442,  2602,  2620,  3261,
    2139,  2369,  2140,  2141,  2142,  2143,  2144,  1882,  2145,  2146,
    2147,  2148,  2149,  2150,  2151,  2152,  2153,  2621,  2154,  2155,
    2156,  1495,  4156,  1699,  4748,  4157,  4159,  4160,  4444,  4162,
    4163,  4164,  4165,  4166,  4167,  2623,  4652,  4524,   862,  4653,
    4618,  2604,  4536,  3258,  4170,  4535,  4171,  4172,  2605,  4216,
    2606,  2114,   821,  1619,  2352,  4257,  4386,  4712,  2608,   645,
     863,  3259,   864,  4468,  4469,  4479,  3709,  4530,  2624,  4530,
    3069,  3284,  4477,  3859,  2818,  3606,  1907,  3289,  4461,  4554,
    1700,  1701,  3862,  4729,  4211,  4706,  4630,  4530,  4674,  4079,
    4368,  1039,  2166,  3471,  3067,  3380,  3664,  3074,  3906,  3478,
    4100,  4690,  4406,  4098,  2611,  3549,  3947,  4280,  3988,  4134,
    4553,  4443,  4124,  3579,  3220,  4504,  3577,  2978,  4530,  4530,
    3581,   537,   538,  4763,  4589,  4454,  4590,  2698,  4446,  4452,
    2614,  3141,  4332,  4283,  3686,  3470,  4323,  1584,  3071,  2040,
    1519,  4547,  4103,  2936,  2862,  4466,  4467,  2157,  2158,  2164,
    1769,  2645,  4539,  3919,  2423,  2128,  3275,  3601,  2793,  2842,
    2886,  4629,  4177,  1029,  2452,  1422,  3588,  2731,  4405,  3243,
    2733,   645,  3645,  2956,  2950,  2792,  1723,  4248,  4380,  4639,
    3784,  4640,  3927,  3332,  1666,  2056,  2615,  2616,  2617,  2809,
    4059,  3465,  4728,  2618,  4052,  2702,  2893,  1890,  1556,  2840,
    1922,  2868,  3864,  3619,  1557,  3618,  3654,  4551,  1017,  2619,
    1558,  1559,  2200,  2620,  1118,   998,  2497,  2933,  1001,  3931,
    2498,  1928,  1998,  1702,  2363,  3605,  4705,  4573,  4726,  4638,
    4785,  4782,  2621,  4128,  4546,  3638,  3622,   955,  1703,  1704,
    2912,  1946,   821,  2324,   956,  3639,  2910,  2902,  2410,  2909,
    2623,  2480,  1282,  1938,   923,  4562,  4563,  1408,   645,  1883,
    4200,  2881,  2190,  4208,   925,  1414,  3262,  1035,     0,  1294,
    1550,  1036,  1037,     0,  3098,  3098,     0,  1551,  1552,   821,
     821,     0,     0,     0,     0,     0,     0,     0,   821,   821,
     821,   821,   821,   821,   821,   821,   821,   821,   821,   821,
    4657,     0,  1295,     0,     0,     0,     0,  4665,   821,   821,
       0,   821,   821,     0,     0,     0,   821,     0,     0,   821,
     821,   821,   821,     0,   821,   821,   821,     0,     0,     0,
       0,     0,     0,   821,   821,     0,   821,   821,   821,   821,
     821,     0,     0,   821,   821,   821,   821,   821,   821,   821,
     821,   821,   821,   821,     0,   821,     0,     0,   821,   821,
       0,  1294,     0,   821,     0,     0,  4776,   821,   821,   821,
       0,     0,  1296,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   821,   821,   821,     0,     0,     0,  4716,     0,
       0,   821,     0,  4721,  1295,     0,     0,  1297,   821,   821,
     821,  1298,   821,     0,     0,     0,  2577,     0,  2578,   821,
     821,   821,     0,   821,   821,   821,   821,   821,     0,   821,
     821,   821,   821,   821,   821,   821,   821,     0,     0,  4756,
     821,   821,     0,  4688,     0,     0,     0,  1299,     0,     0,
    -819,  -819,     0,  2580,     0,     0,     0,     0,     0,     0,
       0,     0,  -819,     0,  1769,     0,  4756,     0,  1300,     0,
       0,     0,  2583,   645,  1296,     0,     0,  1769,     0,     0,
    2584,     0,  1769,  1301,     0,     0,     0,  1769,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1297,
       0,     0,     0,  1298,     0,     0,     0,  2586,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1564,     0,     0,  2587,     0,     0,     0,   821,     0,
       0,  1302,     0,     0,     0,     0,     0,     0,     0,  1299,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2592,     0,     0,  1303,     0,     0,     0,
    1300,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1126,     0,  1301,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   821,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   821,     0,     0,     0,     0,     0,     0,     0,     0,
    1163,     0,     0,     0,     0,     0,     0,   821,     0,     0,
     273,   821,   275,  1302,     0,     0,     0,  1181,  2596,     0,
       0,     0,     0,     0,     0,     0,  2597,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1303,     0,
       0,  2598,     0,     0,     0,     0,     0,     0,     0,     0,
    1304,     0,     0,     0,     0,  2971,     0,     0,     0,  1305,
       0,     0,     0,     0,  1228,     0,   821,     0,     0,     0,
       0,     0,     0,     0,  1306,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1307,     0,     0,     0,     0,     0,     0,  2600,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2601,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1308,     0,     0,  1309,
       0,     0,  1304,     0,     0,     0,     0,     0,     0,     0,
       0,  1305,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1368,     0,     0,     0,     0,  1306,  1310,     0,     0,
       0,     0,  2605,     0,  2606,     0,     0,     0,     0,     0,
       0,     0,  2608,     0,  1307,     0,   519,     0,     0,  1311,
     520,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   821,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1308,     0,
       0,  1309,     0,     0,     0,     0,     0,     0,  1312,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2614,     0,     0,     0,     0,  1310,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1311,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2615,  2616,  2617,     0,     0,     0,     0,  2618,     0,     0,
       0,   821,   821,   821,     0,     0,     0,     0,     0,     0,
    1312,     0,     0,  2619,     0,     0,   821,  2620,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1600,     0,     0,     0,     0,  2621,     0,     0,     0,
       0,     0,   821,     0,     0,     0,     0,     0,   821,     0,
       0,   821,     0,   821,  2623,     0,     0,     0,     0,   821,
       0,   821,   821,     0,     0,     0,     0,     0,  1639,  1640,
       0,     0,     0,     0,     0,     0,     0,  1650,  1651,     0,
       0,  1654,  1655,  1656,  1657,  1660,  1661,  1662,  1663,     0,
       0,     0,     0,     0,     0,     0,     0,  1679,  1680,     0,
    1681,  1682,     0,     0,     0,     0,     0,     0,  1715,  1716,
    1717,  1718,  2972,     0,  1721,     0,     0,     0,     0,     0,
       0,     0,  1729,  1730,     0,  1733,  1734,     0,     0,     0,
       0,     0,  1738,  1739,  1740,     0,     0,  1743,  1744,  1745,
    1746,  1747,  1748,     0,  1750,     0,     0,  1753,  1754,     0,
       0,     0,  1757,     0,   821,     0,  1760,  1764,  1765,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1772,  1773,  1774,     0,     0,     0,     0,     0,     0,
    1782,     0,     0,     0,     0,     0,     0,  1787,  1788,  1789,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   821,     0,     0,
       0,     0,     0,     0,     0,     0,   821,     0,     0,     0,
    1825,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2573,     0,     0,     0,
       0,     0,  2574,     0,  2575,     0,  2576,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2577,     0,  2578,
       0,     0,     0,     0,     0,     0,     0,  1894,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2579,
       0,     0,     0,     0,  2580,  2581,     0,     0,     0,     0,
       0,  2582,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2583,     0,  2639,     0,     0,     0,     0,
       0,  2584,     0,     0,     0,     0,     0,     0,     0,     0,
    1945,  2585,     0,     0,     0,     0,     0,   821,     0,     0,
    1951,     0,     0,     0,     0,     0,     0,     0,  2586,     0,
       0,     0,     0,     0,     0,     0,  1979,     0,     0,     0,
    1985,     0,  1564,     0,     0,  2587,     0,     0,     0,     0,
       0,     0,     0,  2588,  2589,     0,     0,     0,     0,     0,
    2590,     0,     0,     0,     0,     0,     0,     0,  2591,     0,
       0,     0,  -962,     0,  2592,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   821,  2593,     0,     0,   821,     0,
       0,     0,     0,   821,   821,  2030,     0,     0,     0,     0,
       0,     0,   821,     0,   821,  2594,   821,   821,   821,   821,
       0,     0,   821,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   821,     0,   821,   821,     0,   821,   821,   821,
     821,     0,   821,     0,     0,   821,     0,     0,     0,     0,
       0,   273,     0,   275,   821,     0,     0,  2595,     0,  2596,
       0,   821,     0,   821,     0,   821,   821,  2597,   821,   821,
       0,     0,     0,   821,   821,   821,     0,     0,     0,   821,
     821,   821,  2598,   821,     0,   821,     0,   821,     0,   821,
       0,   821,     0,     0,     0,     0,   821,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2599,     0,     0,     0,
       0,     0,     0,     0,     0,   821,     0,     0,     0,     0,
       0,     0,   821,     0,     0,   821,  2577,     0,  2578,     0,
       0,   821,     0,     0,   821,     0,     0,     0,   821,     0,
    2600,     0,     0,     0,     0,     0,     0,  2212,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2601,     0,
    -819,  -819,  2602,  2580,     0,     0,     0,     0,     0,     0,
       0,     0,  -819,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2583,     0,     0,     0,     0,     0,     0,     0,
    2584,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2603,   821,     0,     0,     0,  2604,     0,     0,     0,
       0,     0,     0,  2605,     0,  2606,     0,  2586,     0,     0,
    2607,     0,     0,  2608,     0,     0,     0,     0,     0,     0,
       0,  1564,     0,     0,  2587,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2609,     0,     0,     0,     0,     0,
    2294,  2296,  2298,  2592,     0,     0,     0,     0,  2610,  2611,
    2612,  2613,   821,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2614,     0,     0,     0,     0,
       0,  2333,     0,     0,     0,     0,     0,     0,     0,     0,
    2338,     0,  2339,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2639,     0,     0,     0,     0,     0,     0,
     273,     0,   275,     0,     0,     0,  2991,     0,  2596,     0,
       0,     0,     0,     0,     0,     0,  2597,     0,     0,     0,
       0,  2615,  2616,  2617,  2991,  2991,     0,     0,  2618,     0,
       0,  2598,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2619,     0,     0,     0,  2620,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2621,     0,     0,
       0,     0,  2622,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2419,     0,  2623,  2639,     0,     0,  2600,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2601,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2991,  2991,  2479,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  -962,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2605,     0,  2606,     0,     0,     0,     0,     0,
     821,     0,  2608,     0,   821,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   821,   821,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   821,     0,     0,     0,     0,     0,     0,     0,     0,
     821,     0,   821,     0,   821,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2614,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   821,     0,     0,     0,     0,   821,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   821,     0,     0,
    2615,  2616,  2617,     0,     0,     0,  2649,  2618,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2619,     0,     0,     0,  2620,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2621,     0,     0,     1,
       0,     2,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2623,     0,     0,     0,     3,     0,
       0,   821,     4,  2711,     0,     0,     0,  2713,     0,     0,
       0,     0,  2715,  2716,     0,     0,     5,     6,     0,     0,
       0,  1657,     0,  2732,     7,  1657,     0,  2735,  2736,     8,
       9,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2743,     0,  2744,     0,     0,  2746,  2747,  2748,  2749,
      10,  2750,   821,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2754,     0,     0,     0,  2639,     0,    11,
    2755,     0,  2756,     0,  2757,  2758,     0,  2759,     0,     0,
       0,     0,  2762,  2763,  2764,     0,     0,     0,  2766,  2767,
    2768,     0,  2769,    12,  2771,     0,  2773,     0,  2775,     0,
    2776,    13,    14,    15,     0,  2777,     0,     0,     0,     0,
       0,     0,     0,     0,    16,    17,     0,     0,     0,     0,
       0,     0,     0,     0,  2797,     0,     0,    18,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2807,     0,    19,  2810,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2639,    20,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   821,   821,     0,    21,     0,    22,     0,     0,     0,
       0,    23,     0,     0,     0,    24,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    25,     0,    26,     0,     0,     0,     0,     0,     0,
    2991,     0,     0,     0,     0,     0,     0,     0,     0,    27,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   821,     0,     0,     0,    28,     0,     0,
       0,    29,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2577,
       0,  2578,     0,     0,     0,   821,   821,     0,   821,     0,
       0,  1979,     0,     0,     0,     0,     0,   821,     0,     0,
       0,     0,   821,     0,     0,   821,     0,   821,   821,     0,
       0,     0,     0,     0,     0,     0,  2580,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2583,     0,     0,     0,     0,
     821,     0,     0,  2584,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    30,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2586,   821,     0,    31,     0,    32,     0,     0,     0,     0,
       0,     0,     0,     0,  1564,     0,     0,  2587,    33,     0,
       0,     0,     0,     0,     0,   821,     0,     0,     0,    34,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2592,     0,     0,     0,
       0,    35,     0,     0,    36,     0,    37,     0,     0,    38,
       0,     0,    39,    40,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    41,     0,     0,    42,     0,     0,     0,
       0,   821,     0,     0,    43,     0,     0,     0,     0,     0,
      44,     0,     0,     0,     0,     0,     0,     0,    45,     0,
       0,     0,     0,    46,    47,    48,     0,     0,     0,     0,
    2639,     0,     0,   273,     0,   275,     0,     0,     0,     0,
       0,  2596,     0,     0,     0,     0,     0,     0,     0,  2597,
       0,     0,     0,     0,     0,    49,     0,     0,     0,     0,
       0,     0,    50,     0,  2598,     0,     0,     0,     0,  3150,
       0,     0,     0,  3152,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    3179,  3180,     0,     0,     0,     0,     0,    51,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    52,
    3200,     0,  2600,    53,     0,     0,    54,     0,     0,  3210,
       0,  3212,    55,  3214,     0,     0,     0,     0,     0,     0,
    2601,     0,     0,     0,     0,     0,     0,     0,     0,     1,
       0,     2,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    56,     0,     0,     0,     0,     0,    57,     0,
       0,     0,     4,     0,     0,     0,     0,     0,    58,     0,
       0,     0,     0,     0,     0,     0,     5,     6,     0,     0,
       0,     0,     0,     0,     7,  2605,  3272,  2606,     0,     8,
       9,     0,     0,     0,     0,  2608,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      10,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    11,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    12,     0,     0,   821,     0,     0,     0,
    1979,    13,    14,    15,     0,     0,     0,  2614,     0,     0,
       0,     0,     0,     0,    16,    17,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   821,     0,     0,     0,     0,     0,     0,     0,
     821,     0,    19,     0,     0,     0,     0,     0,     0,     0,
       0,  3354,     0,     0,     0,     0,     0,     0,     0,    20,
       0,   821,     0,  2615,  2616,  2617,     0,     0,     0,     0,
    2618,     0,     0,     0,    21,     0,    22,     0,     0,     0,
       0,    23,     0,     0,     0,    24,  2619,     0,     0,     0,
    2620,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2621,
       0,    25,     0,    26,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2623,     0,    27,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  3978,     0,     0,     0,    28,     0,     0,
       0,    29,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    3487,  3488,     0,     0,     0,     0,     0,     0,     0,   958,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   959,     0,     0,     0,   821,     0,     0,     0,   821,
       0,     0,   896,   960,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   961,   942,     0,
       0,     0,     0,     0,   821,   962,     0,     0,     0,     0,
     963,     0,  3519,     0,     0,     0,    30,     0,   821,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    31,     0,    32,   964,     0,   965,     0,
     966,     0,     0,     0,  3558,  3559,     0,     0,    33,     0,
       0,     0,   967,     0,     0,  2639,  3566,     0,     0,    34,
       0,  3568,     0,     0,  3569,     0,  3570,  3571,     0,     0,
       0,     0,     0,    14,    15,     0,     0,     0,     0,     0,
       0,    35,     0,     0,    36,     0,    37,     0,     0,    38,
       0,     0,    39,    40,     0,     0,     0,     0,     0, -1895,
     968,     0,     0,    41,     0,   969,    42,     0,   970,     0,
       0,     0,     0,     0,    43,     0,     0,     0,     0,     0,
      44,     0,     0,     0,  3978,     0,     0,     0,    45,     0,
    3597,     0,     0,    46,    47,    48,   971,     0,   972,     0,
       0,     0,  4174,     0,     0,     0,   973,     0,   974,     0,
       0,     0,     0,     0,  3597,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    49,     0,     0,     0,     0,
       0,     0,    50,     0,   975,   976,   977,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     821,     0,     0,     0,     0,     0,     0,   978,   821,     0,
       0,     0,     0,     0,   821,     0,   821,     0,     0,     0,
    3597,     0,     0,     0,     0,     0,     0,    51,     0,   979,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    52,
       0,     0,     0,    53,     0,     0,    54,     0,     0,     0,
       0,     0,    55,     0,     0,     0,     0,     0,     0,   980,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    56,     0,     0,     0,     0,     0,    57,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    58,     0,
       0,     0,     0,     0,     0,   821,     0,     0,     0,     0,
       0,  4174,  4174,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   981,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  4331,     0,     0,     0,  4331,  4331,
       0,     0,   982,     0,     0,   821,     0,     0,     0,     0,
       0,     0,     0,   983,   984,     0,     0,   985,   986,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   987,     0,
       0,     0,     0,   821,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   988,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   989,
       0,     0,     0,     0,   821,     0,   821,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   821,     0,  4174,  4174,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
   -2501,     0,     0,     0,   990,  3597,     0,  4331,     0,     0,
       0,     0,     0,     0,     0,     0,  4331,     0,     0,     0,
    4331,     0,   991,   992,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  3882,     0,     0,     0,     0,     0,     0,     0,  3354,
       0,  3717,  3718,     0,     0,     0,     0,  3719,     0,  3720,
       0,  3721,  3722,     0,     0,     0,     0,     0,     0,     0,
    3910,   993,  4331,     0,     0,     0,     0,     0,  3536,     0,
       0,     0, -2501,     0,     0,     0,     0,     0,     0,     0,
     994,     0,     0,     0,     0,   821,     0,  4174,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  4174,   821,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    4548,     0,     0,     0,     0,  3723,     0,   821,  3724,     0,
       0,     0,     0,     0,     0,     0,  3725,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  3726,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  4174,
       0,  3727,     0,     0,     0,  4331,     0,  4331,  4331,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   821,  4174,  3354,     0,     0,  3728,  4017,  3729,
       0,     0,     0,     0,     0,  4174,  4174,     0,     0,     0,
       0,     0,  3730,  3731,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   821,     0,
       0,     0,     0,  3597,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  3354,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  3732,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  4174,     0,     0,     0,     0,     0,
       0,   821,     0,     0,  4174,     0,  3733,     0,     0,     0,
       0,     0,     0,     0,     0,  3734,  3735,     0,  3736,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   821,     0,     0,     0,     0,     0,     0,  4174,     0,
    4174,     0,  3737,  3738,  3739,     0,     0,     0,     0,     0,
       0,     0,   821,     0,     0,   821,     0,     0,     0,     0,
       0,  3740,  3741,  3742,     0,  4174,     0,     0,  3743,     0,
       0,  3744,     0,  4174,     0,  4174,     0,  4174,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  3745,  3746,
       0,  4174,     0,     0,     0,  4174,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    4174,  4174,     0,     0,     0,     0,   821,     0,     0,     0,
       0,     0,     0,     0,  3747,  3748,  4174,  4174,     0,     0,
       0,  4174,     0,     0,     0,     0,     0,  4236,     0,     0,
       0,     0,     0,  4241,     0,  4243,     0,     0,     0,  3749,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   821,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  3750,     0,     0,     0,  3751,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  3752,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  4293,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    3753,     0,     0,  3754,  3354,     0,  3755,  3756,  3757,  3758,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  3354,     0,     0,     0,     0,     0,     0,     0,
    3759,  3760,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  3761,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  4407,     0,  4408,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  4416,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  4528,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  4533,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  3597,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  4603,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    4659,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    4691,     0,     0,     0,     0,     0,     0,     0,     0,   142,
       0,   143,   686,   145,   146,   147,   148,     0,     0,   149,
       0,     0,     0,   150,  4708,     0,   687,     0,   152,   153,
     154,   155,   156,   157,   688,   159,     0,   160,     0,     0,
     689,   161,   690,   691,   692,   162,   693,     0,   163,   164,
     165,  1761,   166,     0,   167,   168,     0,     0,   169,   694,
     695,   170,   171,     0,   172,   696,   697,   174,   175,     0,
     176,   177,   178,   179,   180,   698,   182,     0,   699,   184,
     700,   701,   702,   703,   704,  4757,   190,   191,   192,   193,
     194,   195,   196,   197,     0,   198,   199,     0,   200,   201,
     202,   705,   204,     0,   205,   706,   707,   206,     0,     0,
     207,   708,   208,   709,   710,   209,     0,   210,   711,   712,
       0,   211,   212,   213,   713,   714,   715,     0,     0,     0,
       0,   716,   216,   717,     0,  3597,   718,   217,     0,   218,
       0,     0,     0,   219,     0,   220,   221,   222,   223,   224,
       0,     0,     0,   225,     0,     0,   226,   227,   228,     0,
       0,     0,   229,     0,   230,   231,     0,   232,   233,   234,
       0,     0,   235,   236,     0,   237,   238,   239,   240,   241,
     242,   243,   719,     0,   244,   245,   246,   247,   720,   721,
     248,   249,     0,   250,   251,   252,   722,     0,   253,     0,
       0,     0,   254,     0,   255,     0,   256,     0,   257,   258,
     723,   260,   724,   262,   263,     0,   264,     0,   725,     0,
     265,   266,   267,     0,   268,   726,   727,     0,   269,   270,
       0,     0,     0,   728,   272,   273,   274,   275,   729,     0,
     276,   277,   278,     0,   279,     0,   280,     0,     0,     0,
     730,   281,   282,   731,     0,     0,   283,     0,   284,   285,
       0,   286,   287,     0,     0,     0,   288,     0,     0,   289,
     290,   732,     0,  1762,   292,     0,   733,   293,   294,     0,
       0,     0,     0,     0,   734,   296,     0,   297,     0,   298,
       0,   299,   300,     0,     0,   735,     0,     0,     0,     0,
     301,   302,   303,   304,   305,   306,   307,   308,   309,   310,
     311,   312,   313,   314,   315,   316,     0,   317,   318,   319,
     320,   736,   321,   322,   323,   324,   737,   325,   326,     0,
       0,     0,     0,   327,   328,   329,   330,   738,   332,     0,
       0,   739,   334,   740,   335,     0,   336,   741,   742,   743,
     744,   745,   341,   342,   343,   344,   345,     0,   746,   346,
     347,     0,     0,   348,   349,   350,   351,   747,   748,   749,
     352,   353,     0,   750,   751,   354,     0,   355,   356,   752,
       0,   358,   359,   360,   361,     0,   362,   363,     0,     0,
       0,     0,     0,     0,     0,     0,   364,   365,   366,     0,
     753,   367,     0,   368,     0,   369,   370,   754,   372,   373,
     374,   375,   755,   756,   378,   757,     0,   379,   380,   381,
       0,   382,     0,   383,   384,   385,   386,   387,     0,   758,
     389,   390,     0,     0,   391,     0,     0,     0,   392,   393,
     394,   395,   396,     0,     0,   397,   398,   399,   400,   401,
       0,   402,   403,     0,   404,   405,   406,   759,   760,   407,
       0,   408,     0,   409,   410,     0,   411,   412,     0,   413,
       0,   761,     0,   762,   415,   416,   417,   418,   419,   420,
     763,   764,   423,   424,   425,   426,     0,   765,   428,     0,
       0,     0,   429,   430,   431,   432,     0,     0,     0,   433,
       0,     0,     0,   434,     0,   435,   436,   437,   438,   439,
     440,     0,   441,   442,   443,   444,   445,   446,     0,     0,
       0,     0,     0,     0,   447,   448,     0,   449,     0,     0,
     450,     0,     0,   451,   452,     0,     0,     0,   453,   766,
     767,   454,   455,     0,   456,   457,   768,   459,   460,   461,
     769,   770,   462,   463,   464,   465,   771,   466,   467,     0,
     468,     0,   469,   470,   471,   472,     0,   772,   473,   474,
       0,   773,   774,   775,   776,     0,     0,     0,     0,  1763,
     479,   480,   481,     0,   777,   778,   779,   483,   484,   485,
     780,   486,   487,   781,   488,   489,     0,   490,   491,     0,
       0,   492,     0,     0,   493,     0,   494,     0,   782,   496,
     497,     0,     0,   783,   784,   785,   786,   498,     0,     0,
     499,   787,     0,   788,   500,   501,   502,   503,   504,   789,
     790,     0,     0,     0,     0,     0,     0,   507,   508,     0,
     509,   510,   511,     0,     0,   791,     0,     0,     0,     0,
     792,   793,     0,     0,     0,     0,   794,   795,     0,     0,
     796,   797,     0,     0,   798,   799,   142,     0,   143,   686,
     145,   146,   147,   148,  1975,     0,   149,     0,     0,     0,
     150,     0,     0,   687,     0,   152,   153,   154,   155,   156,
     157,   688,   159,     0,   160,     0,     0,  1976,   161,   690,
     691,   692,   162,   693,     0,   163,   164,   165,     0,   166,
       0,   167,   168,     0,     0,   169,   694,   695,   170,   171,
       0,   172,   696,   697,   174,   175,     0,   176,   177,   178,
     179,   180,   698,   182,     0,   699,   184,   700,   701,   702,
     703,   704,     0,   190,   191,   192,   193,   194,   195,   196,
     197,     0,   198,   199,     0,   200,   201,   202,   705,   204,
       0,   205,   706,   707,   206,     0,     0,   207,   708,   208,
     709,   710,   209,     0,   210,   711,   712,     0,   211,   212,
     213,   713,   714,   715,     0,     0,     0,     0,   716,   216,
     717,     0,     0,  1977,   217,     0,   218,     0,     0,     0,
     219,     0,   220,   221,   222,   223,   224,     0,     0,     0,
     225,     0,     0,   226,   227,   228,     0,     0,     0,   229,
       0,   230,   231,     0,   232,   233,   234,     0,     0,   235,
     236,     0,   237,   238,   239,   240,   241,   242,   243,   719,
       0,   244,   245,   246,   247,   720,   721,   248,   249,     0,
     250,   251,   252,   722,     0,   253,     0,     0,     0,   254,
       0,   255,     0,   256,     0,   257,   258,   723,   260,   724,
     262,   263,     0,   264,     0,   725,     0,   265,   266,   267,
       0,   268,   726,   727,     0,   269,   270,     0,     0,     0,
     728,   272,   273,   274,   275,   729,     0,   276,   277,   278,
       0,   279,     0,   280,     0,     0,     0,   730,   281,   282,
     731,     0,     0,   283,     0,   284,   285,     0,   286,   287,
       0,     0,     0,   288,     0,     0,   289,   290,   732,     0,
       0,   292,     0,   733,   293,   294,     0,     0,     0,     0,
       0,   734,   296,     0,   297,     0,   298,     0,   299,   300,
       0,     0,   735,     0,     0,     0,     0,   301,   302,   303,
     304,   305,   306,   307,   308,   309,   310,   311,   312,   313,
     314,   315,   316,     0,   317,   318,   319,   320,   736,   321,
     322,   323,   324,   737,   325,   326,     0,     0,     0,     0,
     327,   328,   329,   330,   738,   332,     0,     0,   739,   334,
     740,   335,     0,   336,   741,   742,   743,   744,   745,   341,
     342,   343,   344,   345,     0,   746,   346,   347,     0,     0,
     348,   349,   350,   351,   747,   748,   749,   352,   353,     0,
     750,   751,   354,     0,   355,   356,   752,  1978,   358,   359,
     360,   361,     0,   362,   363,     0,     0,     0,     0,     0,
       0,     0,     0,   364,   365,   366,     0,   753,   367,     0,
     368,     0,   369,   370,   754,   372,   373,   374,   375,   755,
     756,   378,   757,     0,   379,   380,   381,     0,   382,     0,
     383,   384,   385,   386,   387,     0,   758,   389,   390,     0,
       0,   391,     0,     0,     0,   392,   393,   394,   395,   396,
       0,     0,   397,   398,   399,   400,   401,     0,   402,   403,
       0,   404,   405,   406,   759,   760,   407,     0,   408,     0,
     409,   410,     0,   411,   412,     0,   413,     0,   761,     0,
     762,   415,   416,   417,   418,   419,   420,   763,   764,   423,
     424,   425,   426,     0,   765,   428,     0,     0,     0,   429,
     430,   431,   432,     0,     0,     0,   433,     0,     0,     0,
     434,     0,   435,   436,   437,   438,   439,   440,     0,   441,
     442,   443,   444,   445,   446,     0,     0,     0,     0,     0,
       0,   447,   448,     0,   449,     0,     0,   450,     0,     0,
     451,   452,     0,     0,     0,   453,   766,   767,   454,   455,
       0,   456,   457,   768,   459,   460,   461,   769,   770,   462,
     463,   464,   465,   771,   466,   467,     0,   468,     0,   469,
     470,   471,   472,     0,   772,   473,   474,     0,   773,   774,
     775,   776,     0,     0,     0,     0,     0,   479,   480,   481,
       0,   777,   778,   779,   483,   484,   485,   780,   486,   487,
     781,   488,   489,     0,   490,   491,     0,     0,   492,     0,
       0,   493,     0,   494,     0,   782,   496,   497,     0,     0,
     783,   784,   785,   786,   498,     0,     0,   499,   787,     0,
     788,   500,   501,   502,   503,   504,   789,   790,     0,     0,
       0,     0,     0,     0,   507,   508,     0,   509,   510,   511,
       0,     0,   791,     0,     0,     0,     0,   792,   793,     0,
       0,     0,     0,   794,   795,     0,     0,   796,   797,     0,
       0,   798,   799,   142,     0,   143,   686,   145,   146,   147,
     148,     0,     0,   149,     0,     0,     0,   150,     0,     0,
     687,     0,   152,   153,   154,   155,   156,   157,   688,   159,
       0,   160,     0,     0,   689,   161,   690,   691,   692,   162,
     693,     0,   163,   164,   165,     0,   166,     0,   167,   168,
       0,     0,   169,   694,   695,   170,   171,     0,   172,   696,
     697,   174,   175,     0,   176,   177,   178,   179,   180,   698,
     182,     0,   699,   184,   700,   701,   702,   703,   704,     0,
     190,   191,   192,   193,   194,   195,   196,   197,     0,   198,
     199,     0,   200,   201,   202,   705,   204,     0,   205,   706,
     707,   206,     0,     0,   207,   708,   208,   709,   710,   209,
       0,   210,   711,   712,     0,   211,   212,   213,   713,   714,
     715,     0,     0,     0,     0,   716,   216,   717,     0,     0,
     718,   217,     0,   218,     0,     0,     0,   219,     0,   220,
     221,   222,   223,   224,     0,     0,     0,   225,     0,     0,
     226,   227,   228,     0,     0,     0,   229,     0,   230,   231,
       0,   232,   233,   234,     0,     0,   235,   236,     0,   237,
     238,   239,   240,   241,   242,   243,   719,     0,   244,   245,
     246,   247,   720,   721,   248,   249,     0,   250,   251,   252,
     722,     0,   253,     0,     0,     0,   254,  2293,   255,     0,
     256,     0,   257,   258,   723,   260,   724,   262,   263,     0,
     264,     0,   725,     0,   265,   266,   267,     0,   268,   726,
     727,     0,   269,   270,     0,     0,     0,   728,   272,   273,
     274,   275,   729,     0,   276,   277,   278,     0,   279,     0,
     280,     0,     0,     0,   730,   281,   282,   731,     0,     0,
     283,     0,   284,   285,     0,   286,   287,     0,     0,     0,
     288,     0,     0,   289,   290,   732,     0,     0,   292,     0,
     733,   293,   294,     0,     0,     0,     0,     0,   734,   296,
       0,   297,     0,   298,     0,   299,   300,     0,     0,   735,
       0,     0,     0,     0,   301,   302,   303,   304,   305,   306,
     307,   308,   309,   310,   311,   312,   313,   314,   315,   316,
       0,   317,   318,   319,   320,   736,   321,   322,   323,   324,
     737,   325,   326,     0,     0,     0,     0,   327,   328,   329,
     330,   738,   332,     0,     0,   739,   334,   740,   335,     0,
     336,   741,   742,   743,   744,   745,   341,   342,   343,   344,
     345,     0,   746,   346,   347,     0,     0,   348,   349,   350,
     351,   747,   748,   749,   352,   353,     0,   750,   751,   354,
       0,   355,   356,   752,     0,   358,   359,   360,   361,     0,
     362,   363,     0,     0,     0,     0,     0,     0,     0,     0,
     364,   365,   366,     0,   753,   367,     0,   368,     0,   369,
     370,   754,   372,   373,   374,   375,   755,   756,   378,   757,
       0,   379,   380,   381,     0,   382,     0,   383,   384,   385,
     386,   387,     0,   758,   389,   390,     0,     0,   391,     0,
       0,     0,   392,   393,   394,   395,   396,     0,     0,   397,
     398,   399,   400,   401,     0,   402,   403,     0,   404,   405,
     406,   759,   760,   407,     0,   408,     0,   409,   410,     0,
     411,   412,     0,   413,     0,   761,     0,   762,   415,   416,
     417,   418,   419,   420,   763,   764,   423,   424,   425,   426,
       0,   765,   428,     0,     0,     0,   429,   430,   431,   432,
       0,     0,     0,   433,     0,     0,     0,   434,     0,   435,
     436,   437,   438,   439,   440,     0,   441,   442,   443,   444,
     445,   446,     0,     0,     0,     0,     0,     0,   447,   448,
       0,   449,     0,     0,   450,     0,     0,   451,   452,     0,
       0,     0,   453,   766,   767,   454,   455,     0,   456,   457,
     768,   459,   460,   461,   769,   770,   462,   463,   464,   465,
     771,   466,   467,     0,   468,     0,   469,   470,   471,   472,
       0,   772,   473,   474,     0,   773,   774,   775,   776,     0,
       0,     0,     0,     0,   479,   480,   481,     0,   777,   778,
     779,   483,   484,   485,   780,   486,   487,   781,   488,   489,
       0,   490,   491,     0,     0,   492,     0,     0,   493,     0,
     494,     0,   782,   496,   497,     0,     0,   783,   784,   785,
     786,   498,     0,     0,   499,   787,     0,   788,   500,   501,
     502,   503,   504,   789,   790,     0,     0,     0,     0,     0,
       0,   507,   508,     0,   509,   510,   511,     0,     0,   791,
       0,     0,     0,     0,   792,   793,     0,     0,     0,     0,
     794,   795,     0,     0,   796,   797,     0,     0,   798,   799,
     142,     0,   143,   686,   145,   146,   147,   148,     0,     0,
     149,     0,     0,     0,   150,     0,     0,   687,     0,   152,
     153,   154,   155,   156,   157,   688,   159,     0,   160,     0,
       0,   689,   161,   690,   691,   692,   162,   693,     0,   163,
     164,   165,     0,   166,     0,   167,   168,     0,     0,   169,
     694,   695,   170,   171,     0,   172,   696,   697,   174,   175,
       0,   176,   177,   178,   179,   180,   698,   182,     0,   699,
     184,   700,   701,   702,   703,   704,     0,   190,   191,   192,
     193,   194,   195,   196,   197,     0,   198,   199,     0,   200,
     201,   202,   705,   204,     0,   205,   706,   707,   206,     0,
       0,   207,   708,   208,   709,   710,   209,     0,   210,   711,
     712,     0,   211,   212,   213,   713,   714,   715,     0,     0,
       0,     0,   716,   216,   717,     0,     0,   718,   217,     0,
     218,     0,     0,     0,   219,     0,   220,   221,   222,   223,
     224,     0,     0,     0,   225,     0,     0,   226,   227,   228,
       0,     0,     0,   229,     0,   230,   231,     0,   232,   233,
     234,     0,     0,   235,   236,     0,   237,   238,   239,   240,
     241,   242,   243,   719,     0,   244,   245,   246,   247,   720,
     721,   248,   249,     0,   250,   251,   252,   722,     0,   253,
       0,     0,     0,   254,  2295,   255,     0,   256,     0,   257,
     258,   723,   260,   724,   262,   263,     0,   264,     0,   725,
       0,   265,   266,   267,     0,   268,   726,   727,     0,   269,
     270,     0,     0,     0,   728,   272,   273,   274,   275,   729,
       0,   276,   277,   278,     0,   279,     0,   280,     0,     0,
       0,   730,   281,   282,   731,     0,     0,   283,     0,   284,
     285,     0,   286,   287,     0,     0,     0,   288,     0,     0,
     289,   290,   732,     0,     0,   292,     0,   733,   293,   294,
       0,     0,     0,     0,     0,   734,   296,     0,   297,     0,
     298,     0,   299,   300,     0,     0,   735,     0,     0,     0,
       0,   301,   302,   303,   304,   305,   306,   307,   308,   309,
     310,   311,   312,   313,   314,   315,   316,     0,   317,   318,
     319,   320,   736,   321,   322,   323,   324,   737,   325,   326,
       0,     0,     0,     0,   327,   328,   329,   330,   738,   332,
       0,     0,   739,   334,   740,   335,     0,   336,   741,   742,
     743,   744,   745,   341,   342,   343,   344,   345,     0,   746,
     346,   347,     0,     0,   348,   349,   350,   351,   747,   748,
     749,   352,   353,     0,   750,   751,   354,     0,   355,   356,
     752,     0,   358,   359,   360,   361,     0,   362,   363,     0,
       0,     0,     0,     0,     0,     0,     0,   364,   365,   366,
       0,   753,   367,     0,   368,     0,   369,   370,   754,   372,
     373,   374,   375,   755,   756,   378,   757,     0,   379,   380,
     381,     0,   382,     0,   383,   384,   385,   386,   387,     0,
     758,   389,   390,     0,     0,   391,     0,     0,     0,   392,
     393,   394,   395,   396,     0,     0,   397,   398,   399,   400,
     401,     0,   402,   403,     0,   404,   405,   406,   759,   760,
     407,     0,   408,     0,   409,   410,     0,   411,   412,     0,
     413,     0,   761,     0,   762,   415,   416,   417,   418,   419,
     420,   763,   764,   423,   424,   425,   426,     0,   765,   428,
       0,     0,     0,   429,   430,   431,   432,     0,     0,     0,
     433,     0,     0,     0,   434,     0,   435,   436,   437,   438,
     439,   440,     0,   441,   442,   443,   444,   445,   446,     0,
       0,     0,     0,     0,     0,   447,   448,     0,   449,     0,
       0,   450,     0,     0,   451,   452,     0,     0,     0,   453,
     766,   767,   454,   455,     0,   456,   457,   768,   459,   460,
     461,   769,   770,   462,   463,   464,   465,   771,   466,   467,
       0,   468,     0,   469,   470,   471,   472,     0,   772,   473,
     474,     0,   773,   774,   775,   776,     0,     0,     0,     0,
       0,   479,   480,   481,     0,   777,   778,   779,   483,   484,
     485,   780,   486,   487,   781,   488,   489,     0,   490,   491,
       0,     0,   492,     0,     0,   493,     0,   494,     0,   782,
     496,   497,     0,     0,   783,   784,   785,   786,   498,     0,
       0,   499,   787,     0,   788,   500,   501,   502,   503,   504,
     789,   790,     0,     0,     0,     0,     0,     0,   507,   508,
       0,   509,   510,   511,     0,     0,   791,     0,     0,     0,
       0,   792,   793,     0,     0,     0,     0,   794,   795,     0,
       0,   796,   797,     0,     0,   798,   799,   142,     0,   143,
     686,   145,   146,   147,   148,     0,     0,   149,     0,     0,
       0,   150,     0,     0,   687,     0,   152,   153,   154,   155,
     156,   157,   688,   159,     0,   160,     0,     0,   689,   161,
     690,   691,   692,   162,   693,     0,   163,   164,   165,     0,
     166,     0,   167,   168,     0,     0,   169,   694,   695,   170,
     171,     0,   172,   696,   697,   174,   175,     0,   176,   177,
     178,   179,   180,   698,   182,     0,   699,   184,   700,   701,
     702,   703,   704,     0,   190,   191,   192,   193,   194,   195,
     196,   197,     0,   198,   199,     0,   200,   201,   202,   705,
     204,     0,   205,   706,   707,   206,     0,     0,   207,   708,
     208,   709,   710,   209,     0,   210,   711,   712,     0,   211,
     212,   213,   713,   714,   715,     0,     0,     0,     0,   716,
     216,   717,     0,     0,   718,   217,     0,   218,     0,     0,
       0,   219,     0,   220,   221,   222,   223,   224,     0,     0,
       0,   225,     0,     0,   226,   227,   228,     0,     0,     0,
     229,     0,   230,   231,     0,   232,   233,   234,     0,     0,
     235,   236,     0,   237,   238,   239,   240,   241,   242,   243,
     719,     0,   244,   245,   246,   247,   720,   721,   248,   249,
       0,   250,   251,   252,   722,     0,   253,     0,     0,     0,
     254,  2297,   255,     0,   256,     0,   257,   258,   723,   260,
     724,   262,   263,     0,   264,     0,   725,     0,   265,   266,
     267,     0,   268,   726,   727,     0,   269,   270,     0,     0,
       0,   728,   272,   273,   274,   275,   729,     0,   276,   277,
     278,     0,   279,     0,   280,     0,     0,     0,   730,   281,
     282,   731,     0,     0,   283,     0,   284,   285,     0,   286,
     287,     0,     0,     0,   288,     0,     0,   289,   290,   732,
       0,     0,   292,     0,   733,   293,   294,     0,     0,     0,
       0,     0,   734,   296,     0,   297,     0,   298,     0,   299,
     300,     0,     0,   735,     0,     0,     0,     0,   301,   302,
     303,   304,   305,   306,   307,   308,   309,   310,   311,   312,
     313,   314,   315,   316,     0,   317,   318,   319,   320,   736,
     321,   322,   323,   324,   737,   325,   326,     0,     0,     0,
       0,   327,   328,   329,   330,   738,   332,     0,     0,   739,
     334,   740,   335,     0,   336,   741,   742,   743,   744,   745,
     341,   342,   343,   344,   345,     0,   746,   346,   347,     0,
       0,   348,   349,   350,   351,   747,   748,   749,   352,   353,
       0,   750,   751,   354,     0,   355,   356,   752,     0,   358,
     359,   360,   361,     0,   362,   363,     0,     0,     0,     0,
       0,     0,     0,     0,   364,   365,   366,     0,   753,   367,
       0,   368,     0,   369,   370,   754,   372,   373,   374,   375,
     755,   756,   378,   757,     0,   379,   380,   381,     0,   382,
       0,   383,   384,   385,   386,   387,     0,   758,   389,   390,
       0,     0,   391,     0,     0,     0,   392,   393,   394,   395,
     396,     0,     0,   397,   398,   399,   400,   401,     0,   402,
     403,     0,   404,   405,   406,   759,   760,   407,     0,   408,
       0,   409,   410,     0,   411,   412,     0,   413,     0,   761,
       0,   762,   415,   416,   417,   418,   419,   420,   763,   764,
     423,   424,   425,   426,     0,   765,   428,     0,     0,     0,
     429,   430,   431,   432,     0,     0,     0,   433,     0,     0,
       0,   434,     0,   435,   436,   437,   438,   439,   440,     0,
     441,   442,   443,   444,   445,   446,     0,     0,     0,     0,
       0,     0,   447,   448,     0,   449,     0,     0,   450,     0,
       0,   451,   452,     0,     0,     0,   453,   766,   767,   454,
     455,     0,   456,   457,   768,   459,   460,   461,   769,   770,
     462,   463,   464,   465,   771,   466,   467,     0,   468,     0,
     469,   470,   471,   472,     0,   772,   473,   474,     0,   773,
     774,   775,   776,     0,     0,     0,     0,     0,   479,   480,
     481,     0,   777,   778,   779,   483,   484,   485,   780,   486,
     487,   781,   488,   489,     0,   490,   491,     0,     0,   492,
       0,     0,   493,     0,   494,     0,   782,   496,   497,     0,
       0,   783,   784,   785,   786,   498,     0,     0,   499,   787,
       0,   788,   500,   501,   502,   503,   504,   789,   790,     0,
       0,     0,     0,     0,     0,   507,   508,     0,   509,   510,
     511,     0,     0,   791,     0,     0,     0,     0,   792,   793,
       0,     0,     0,     0,   794,   795,     0,     0,   796,   797,
       0,     0,   798,   799,   142,     0,   143,   686,   145,   146,
     147,   148,     0,     0,   149,     0,     0,     0,   150,     0,
       0,   687,     0,   152,   153,   154,   155,   156,   157,   688,
     159,     0,   160,     0,     0,   689,   161,   690,   691,   692,
     162,   693,     0,   163,   164,   165,     0,   166,     0,   167,
     168,     0,     0,   169,   694,   695,   170,   171,     0,   172,
     696,   697,   174,   175,     0,   176,   177,   178,   179,   180,
     698,   182,     0,   699,   184,   700,   701,   702,   703,   704,
       0,   190,   191,   192,   193,   194,   195,   196,   197,     0,
     198,   199,     0,   200,   201,   202,   705,   204,     0,   205,
     706,   707,   206,     0,     0,   207,   708,   208,   709,   710,
     209,     0,   210,   711,   712,     0,   211,   212,   213,   713,
     714,   715,     0,     0,     0,     0,   716,   216,   717,     0,
       0,   718,   217,     0,   218,     0,     0,     0,   219,     0,
     220,   221,   222,   223,   224,     0,     0,     0,   225,     0,
       0,   226,   227,   228,     0,     0,     0,   229,     0,   230,
     231,     0,   232,   233,   234,     0,     0,   235,   236,     0,
     237,   238,   239,   240,   241,   242,   243,   719,     0,   244,
     245,   246,   247,   720,   721,   248,   249,     0,   250,   251,
     252,   722,     0,   253,     0,     0,     0,   254,     0,   255,
       0,   256,     0,   257,   258,   723,   260,   724,   262,   263,
       0,   264,     0,   725,     0,   265,   266,   267,     0,   268,
     726,   727,     0,   269,   270,     0,     0,     0,   728,   272,
     273,   274,   275,   729,     0,   276,   277,   278,     0,   279,
       0,   280,     0,     0,     0,   730,   281,   282,   731,     0,
       0,   283,     0,   284,   285,     0,   286,   287,     0,     0,
       0,   288,     0,     0,   289,   290,   732,     0,     0,   292,
       0,   733,   293,   294,     0,     0,     0,     0,     0,   734,
     296,     0,   297,     0,   298,     0,   299,   300,     0,     0,
     735,     0,     0,     0,     0,   301,   302,   303,   304,   305,
     306,   307,   308,   309,   310,   311,   312,   313,   314,   315,
     316,     0,   317,   318,   319,   320,   736,   321,   322,   323,
     324,   737,   325,   326,     0,     0,     0,     0,   327,   328,
     329,   330,   738,   332,     0,     0,   739,   334,   740,   335,
       0,   336,   741,   742,   743,   744,   745,   341,   342,   343,
     344,   345,     0,   746,   346,   347,     0,     0,   348,   349,
     350,   351,   747,   748,   749,   352,   353,     0,   750,   751,
     354,     0,   355,   356,   752,     0,   358,   359,   360,   361,
       0,   362,   363,     0,     0,     0,     0,     0,     0,     0,
       0,   364,   365,   366,     0,   753,   367,     0,   368,     0,
     369,   370,   754,   372,   373,   374,   375,   755,   756,   378,
     757,     0,   379,   380,   381,     0,   382,     0,   383,   384,
     385,   386,   387,     0,   758,   389,   390,     0,     0,   391,
       0,     0,     0,   392,   393,   394,   395,   396,     0,     0,
     397,   398,   399,   400,   401,     0,   402,   403,     0,   404,
     405,   406,   759,   760,   407,     0,   408,     0,   409,   410,
       0,   411,   412,     0,   413,     0,   761,     0,   762,   415,
     416,   417,   418,   419,   420,   763,   764,   423,   424,   425,
     426,     0,   765,   428,     0,     0,     0,   429,   430,   431,
     432,     0,     0,     0,   433,     0,     0,     0,   434,     0,
     435,   436,   437,   438,   439,   440,     0,   441,   442,   443,
     444,   445,   446,     0,     0,     0,     0,     0,     0,   447,
     448,     0,   449,     0,     0,   450,     0,     0,   451,   452,
       0,     0,     0,   453,   766,   767,   454,   455,     0,   456,
     457,   768,   459,   460,   461,   769,   770,   462,   463,   464,
     465,   771,   466,   467,     0,   468,     0,   469,   470,   471,
     472,     0,   772,   473,   474,     0,   773,   774,   775,   776,
       0,     0,     0,     0,     0,   479,   480,   481,     0,   777,
     778,   779,   483,   484,   485,   780,   486,   487,   781,   488,
     489,     0,   490,   491,     0,     0,   492,     0,     0,   493,
       0,   494,     0,   782,   496,   497,     0,     0,   783,   784,
     785,   786,   498,     0,     0,   499,   787,     0,   788,   500,
     501,   502,   503,   504,   789,   790,     0,     0,     0,     0,
       0,     0,   507,   508,     0,   509,   510,   511,     0,     0,
     791,     0,     0,     0,     0,   792,   793,     0,     0,     0,
       0,   794,   795,     0,     0,   796,   797,     0,     0,   798,
     799,   142,     0,   143,   686,   145,   146,   147,   148,     0,
       0,   149,     0,     0,     0,   150,     0,     0,   687,     0,
     152,   153,   154,   155,   156,   157,   688,   159,     0,   160,
       0,     0,   689,   161,   690,   691,   692,   162,   693,     0,
     163,   164,   165,     0,   166,     0,   167,   168,     0,     0,
     169,   694,   695,   170,   171,     0,   172,   696,   697,   174,
     175,     0,   176,   177,   178,   179,   180,   698,   182,     0,
     699,   184,   700,   701,   702,   703,   704,     0,   190,   191,
     192,   193,   194,   195,   196,   197,     0,   198,   199,     0,
     200,   201,   202,   705,   204,     0,   205,   706,   707,   206,
       0,     0,   207,   708,   208,   709,   710,   209,     0,   210,
     711,   712,     0,   211,   212,   213,   713,   714,   715,     0,
       0,     0,     0,   716,   216,   717,     0,     0,   718,   217,
       0,   218,     0,     0,     0,   219,     0,   220,   221,   222,
     223,   224,     0,     0,     0,   225,     0,     0,   226,   227,
     228,     0,     0,     0,   229,     0,   230,   231,     0,   232,
     233,   234,     0,     0,   235,   236,     0,   237,   238,   239,
     240,   241,   242,   243,   719,     0,   244,   245,   246,   247,
     720,   721,   248,   249,     0,   250,   251,   252,   722,     0,
     253,     0,     0,     0,   254,     0,   255,     0,   256,     0,
     257,   258,   723,   260,   724,   262,   263,     0,   264,     0,
     725,     0,   265,   266,   267,     0,   268,   726,   727,     0,
     269,   270,     0,     0,     0,   728,   272,   273,   274,   275,
     729,     0,   276,   277,   278,     0,   279,     0,   280,     0,
       0,     0,   730,   281,   282,   731,     0,     0,   283,     0,
     284,   285,     0,   286,   287,     0,     0,     0,   288,     0,
       0,   289,   290,   732,     0,     0,   292,     0,   733,   293,
     294,     0,     0,     0,     0,     0,   734,   296,     0,   297,
       0,   298,     0,   299,   300,     0,     0,   735,     0,     0,
       0,     0,   301,   302,   303,   304,   305,   306,   307,   308,
     309,   310,   311,   312,   313,   314,   315,   316,     0,   317,
     318,   319,   320,   736,   321,   322,   323,   324,   737,   325,
     326,     0,     0,     0,     0,   327,   328,   329,   330,   738,
     332,     0,     0,   739,   334,   740,   335,     0,   336,   741,
     742,   743,   744,   745,   341,   342,   343,   344,   345,     0,
     746,   346,   347,     0,     0,   348,   349,   350,   351,   747,
     748,   749,   352,   353,     0,   750,   751,   354,     0,   355,
     356,   752,     0,   358,   359,   360,   361,     0,   362,   363,
       0,     0,     0,     0,     0,     0,     0,     0,   364,   365,
     366,     0,   753,   367,     0,   368,     0,   369,   370,   754,
     372,   373,   374,   375,   755,   756,   378,   757,     0,   379,
     380,   381,     0,   382,     0,   383,   384,   385,   386,   387,
       0,   758,   389,   390,     0,     0,   391,     0,     0,     0,
     392,   393,   394,   395,   396,     0,     0,   397,   398,   399,
     400,   401,     0,   402,   403,     0,   404,   405,   406,   759,
     760,   407,     0,   408,     0,   409,   410,     0,   411,   412,
       0,   413,     0,   761,     0,   762,   415,   416,   417,   418,
     419,   420,   763,   764,   423,   424,   425,   426,     0,   765,
     428,     0,     0,     0,   429,   430,   431,   432,     0,     0,
       0,   433,     0,     0,     0,   434,     0,   435,   436,   437,
     438,   439,   440,     0,   441,   442,   443,   444,   445,   446,
       0,     0,     0,     0,     0,     0,   447,   448,     0,   449,
       0,     0,   450,     0,     0,   451,   452,     0,     0,     0,
     453,   766,   767,   454,   455,     0,   456,   457,   768,   459,
     460,   461,   769,   770,   462,   463,   464,   465,   771,   466,
     467,     0,   468,     0,   469,   470,   471,   472,     0,   772,
     473,   474,     0,   773,   774,   775,   776,     0,     0,     0,
       0,     0,   479,   480,   481,     0,   777,   778,   779,   483,
     484,   485,   780,   486,   487,   781,   488,   489,     0,   490,
     491,     0,     0,   492,     0,     0,   493,     0,   494,     0,
     782,   496,   497,     0,     0,   783,   784,   785,   786,   498,
       0,     0,   499,   787,     0,   788,   500,   501,   502,   503,
     504,   789,   790,     0,     0,     0,     0,     0,     0,   507,
     508,     0,   509,   510,   511,     0,     0,   791,     0,     0,
       0,     0,   792,   793,     0,     0,     0,     0,   794,  1162,
       0,     0,   796,   797,     0,     0,   798,   799,   142,     0,
     143,   686,   145,   146,   147,   148,  1796,     0,   149,     0,
       0,     0,  1797,     0,     0,   687,     0,   152,   153,   154,
     155,   156,   157,   688,   159,     0,   160,     0,     0,   689,
     161,   690,   691,   692,   162,   693,     0,   163,   164,   165,
       0,   166,     0,   167,   168,     0,     0,   169,   694,   695,
     170,   171,     0,   172,   696,   697,   174,   175,     0,   176,
     177,   178,   179,   180,   698,   182,     0,   699,   184,   700,
     701,   702,   703,   704,     0,   190,   191,   192,   193,   194,
     195,   196,   197,     0,   198,   199,     0,   200,   201,   202,
     705,   204,     0,   205,   706,   707,   206,     0,     0,   207,
     708,   208,   709,   710,   209,     0,   210,   711,   712,     0,
     211,   212,   213,   713,   714,   715,     0,     0,     0,     0,
     716,   216,   717,     0,     0,   718,   217,     0,   218,     0,
       0,     0,   219,     0,   220,   221,   222,   223,   224,     0,
       0,     0,   225,     0,     0,   226,   227,   228,     0,     0,
       0,   229,     0,   230,   231,     0,   232,   233,   234,     0,
       0,   235,   236,     0,   237,   238,   239,   240,   241,   242,
     243,   719,     0,   244,   245,   246,   247,   720,   721,   248,
     249,     0,   250,   251,   252,   722,     0,   253,     0,     0,
       0,   254,     0,   255,     0,   256,     0,   257,   258,   723,
     260,   724,   262,   263,     0,   264,     0,   725,     0,   265,
     266,   267,     0,   268,   726,   727,     0,   269,   270,     0,
       0,     0,   728,   272,   273,   274,   275,   729,     0,   276,
     277,   278,     0,   279,     0,   280,     0,     0,     0,   730,
     281,   282,   731,     0,     0,   283,     0,   284,   285,     0,
     286,   287,     0,     0,     0,   288,     0,     0,   289,   290,
     732,     0,     0,   292,     0,   733,   293,   294,     0,     0,
       0,     0,     0,   734,   296,     0,   297,     0,   298,     0,
     299,   300,     0,     0,   735,     0,     0,     0,     0,   301,
     302,   303,   304,   305,   306,   307,   308,   309,   310,   311,
     312,   313,   314,   315,   316,     0,   317,   318,   319,   320,
     736,   321,   322,   323,   324,   737,   325,   326,     0,     0,
       0,     0,   327,   328,   329,   330,   738,   332,     0,     0,
     739,   334,   740,   335,     0,   336,   741,   742,   743,   744,
     745,   341,   342,   343,   344,   345,     0,   746,   346,   347,
       0,     0,   348,   349,   350,   351,   747,     0,   749,   352,
     353,     0,   750,   751,   354,     0,   355,   356,   752,     0,
     358,   359,   360,   361,     0,   362,   363,     0,     0,     0,
       0,     0,     0,     0,     0,   364,   365,   366,     0,   753,
     367,     0,   368,     0,   369,   370,   754,   372,   373,   374,
     375,   755,   756,   378,   757,     0,   379,   380,   381,     0,
     382,     0,   383,   384,   385,   386,   387,     0,   758,   389,
     390,     0,     0,   391,     0,     0,     0,   392,   393,   394,
     395,   396,     0,     0,   397,   398,   399,   400,   401,     0,
     402,   403,     0,   404,   405,   406,   759,   760,   407,     0,
     408,     0,   409,   410,     0,   411,   412,     0,   413,     0,
     761,     0,   762,   415,   416,   417,   418,   419,   420,   763,
     764,   423,   424,   425,   426,     0,   765,   428,     0,     0,
       0,   429,   430,   431,   432,     0,     0,     0,   433,     0,
       0,     0,   434,     0,   435,   436,   437,   438,   439,   440,
       0,   441,   442,   443,   444,   445,   446,     0,     0,     0,
       0,     0,     0,   447,   448,     0,   449,     0,     0,   450,
       0,     0,   451,   452,     0,     0,     0,   453,   766,   767,
     454,   455,     0,   456,   457,   768,   459,   460,   461,   769,
     770,   462,   463,   464,   465,   771,   466,   467,     0,   468,
       0,   469,   470,   471,   472,     0,   772,   473,   474,     0,
     773,   774,   775,   776,     0,     0,     0,     0,     0,   479,
     480,   481,     0,   777,   778,   779,   483,   484,   485,   780,
     486,   487,   781,   488,   489,     0,   490,   491,     0,     0,
     492,     0,     0,   493,     0,   494,     0,   782,   496,   497,
       0,     0,   783,   784,   785,   786,   498,     0,     0,   499,
     787,     0,   788,   500,   501,   502,   503,   504,   789,   790,
       0,     0,     0,     0,     0,     0,   507,   508,     0,   509,
     510,   511,     0,     0,   791,     0,     0,     0,     0,   792,
     793,     0,     0,     0,     0,   794,   795,     0,     0,   796,
     797,     0,     0,   798,   799,   142,     0,   143,   686,   145,
     146,   147,   148,     0,     0,   149,     0,     0,     0,   150,
       0,     0,   687,     0,   152,   153,   154,   155,   156,   157,
     688,   159,     0,   160,     0,     0,   689,   161,   690,   691,
     692,   162,   693,     0,   163,   164,   165,     0,   166,     0,
     167,   168,     0,     0,   169,   694,   695,   170,   171,     0,
     172,   696,   697,   174,   175,     0,   176,   177,   178,   179,
     180,   698,   182,     0,   699,   184,   700,   701,   702,   703,
     704,     0,   190,   191,   192,   193,   194,   195,   196,   197,
       0,   198,   199,     0,   200,   201,   202,   705,   204,     0,
     205,   706,   707,   206,     0,     0,   207,   708,   208,   709,
     710,   209,     0,   210,   711,   712,     0,   211,   212,   213,
     713,   714,   715,     0,     0,     0,     0,   716,   216,   717,
       0,     0,   718,   217,     0,   218,     0,     0,     0,   219,
       0,   220,   221,   222,   223,   224,     0,     0,     0,   225,
       0,     0,   226,   227,   228,     0,     0,     0,   229,     0,
     230,   231,     0,   232,   233,   234,     0,     0,   235,   236,
       0,   237,   238,   239,   240,   241,   242,   243,   719,     0,
     244,   245,   246,   247,   720,   721,   248,   249,     0,   250,
     251,   252,   722,     0,   253,     0,     0,     0,   254,     0,
     255,     0,   256,     0,   257,   258,   723,   260,   724,   262,
     263,     0,   264,     0,   725,     0,   265,   266,   267,     0,
     268,   726,   727,     0,   269,   270,     0,     0,     0,   728,
     272,   273,   274,   275,   729,     0,   276,   277,   278,     0,
     279,     0,   280,     0,     0,     0,   730,   281,   282,   731,
       0,     0,   283,     0,   284,   285,     0,   286,   287,     0,
       0,     0,   288,     0,     0,   289,   290,   732,     0,     0,
     292,     0,   733,   293,   294,     0,     0,     0,     0,     0,
     734,   296,     0,   297,     0,   298,     0,   299,   300,     0,
       0,   735,     0,     0,     0,     0,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,     0,   317,   318,   319,   320,   736,   321,   322,
     323,   324,   737,   325,   326,     0,     0,     0,     0,   327,
     328,   329,   330,   738,   332,     0,     0,   739,   334,   740,
     335,     0,   336,   741,   742,   743,   744,   745,   341,   342,
     343,   344,   345,     0,   746,   346,   347,     0,     0,   348,
     349,   350,   351,   747,   748,   749,   352,   353,     0,   750,
     751,   354,     0,   355,   356,   752,     0,   358,   359,   360,
     361,     0,   362,   363,     0,     0,     0,     0,     0,     0,
       0,     0,   364,   365,   366,     0,   753,   367,     0,   368,
       0,   369,   370,   754,   372,   373,   374,   375,   755,   756,
     378,   757,     0,   379,   380,   381,     0,   382,     0,   383,
     384,   385,   386,   387,     0,   758,   389,   390,     0,     0,
     391,     0,     0,     0,   392,   393,   394,   395,   396,     0,
       0,   397,   398,   399,   400,   401,     0,   402,   403,     0,
     404,   405,   406,   759,   760,   407,     0,   408,     0,   409,
     410,     0,   411,   412,     0,   413,     0,   761,     0,   762,
     415,   416,   417,   418,   419,   420,   763,   764,   423,   424,
     425,   426,     0,   765,   428,     0,     0,     0,   429,   430,
     431,   432,     0,     0,     0,   433,     0,     0,     0,   434,
       0,   435,   436,   437,   438,   439,   440,     0,   441,   442,
     443,   444,   445,   446,     0,     0,     0,     0,     0,     0,
     447,   448,     0,   449,     0,     0,   450,     0,     0,   451,
     452,     0,     0,     0,   453,   766,   767,   454,   455,     0,
     456,   457,   768,   459,   460,   461,   769,   770,   462,   463,
     464,   465,   771,   466,   467,     0,   468,     0,   469,   470,
     471,   472,     0,   772,   473,   474,     0,   773,   774,   775,
     776,     0,     0,     0,     0,     0,   479,   480,   481,     0,
     777,   778,   779,   483,   484,   485,   780,   486,   487,   781,
     488,   489,     0,   490,   491,     0,     0,   492,     0,     0,
     493,     0,   494,     0,  1893,   496,   497,     0,     0,   783,
     784,   785,   786,   498,     0,     0,   499,   787,     0,   788,
     500,   501,   502,   503,   504,   789,   790,     0,     0,     0,
       0,     0,     0,   507,   508,     0,   509,   510,   511,     0,
       0,   791,     0,     0,     0,     0,   792,   793,     0,     0,
       0,     0,   794,   795,     0,     0,   796,   797,     0,     0,
     798,   799,   142,     0,   143,   686,   145,   146,   147,   148,
       0,     0,   149,     0,     0,     0,   150,     0,     0,   687,
       0,   152,   153,   154,   155,   156,   157,   688,   159,     0,
     160,     0,     0,   689,   161,   690,   691,   692,   162,   693,
       0,   163,   164,   165,     0,   166,     0,   167,   168,     0,
       0,   169,   694,   695,   170,   171,     0,   172,   696,   697,
     174,   175,     0,   176,   177,   178,   179,   180,   698,   182,
       0,   699,   184,   700,   701,   702,   703,   704,     0,   190,
     191,   192,   193,   194,   195,   196,   197,     0,   198,   199,
       0,   200,   201,   202,   705,   204,     0,   205,   706,   707,
     206,     0,     0,   207,   708,   208,   709,   710,   209,     0,
     210,   711,   712,     0,   211,   212,   213,   713,   714,   715,
       0,     0,     0,     0,   716,   216,   717,     0,     0,   718,
     217,     0,   218,     0,     0,     0,   219,     0,   220,   221,
     222,   223,   224,     0,     0,     0,   225,     0,     0,   226,
     227,   228,     0,     0,     0,   229,     0,   230,   231,     0,
     232,   233,   234,     0,     0,   235,   236,     0,   237,   238,
     239,   240,   241,   242,   243,   719,     0,   244,   245,   246,
     247,   720,   721,   248,   249,     0,   250,   251,   252,   722,
       0,   253,     0,     0,     0,   254,     0,   255,     0,   256,
       0,   257,   258,   723,   260,   724,   262,   263,     0,   264,
       0,   725,     0,   265,   266,   267,     0,   268,   726,   727,
       0,   269,   270,     0,     0,     0,   728,   272,   273,   274,
     275,   729,     0,   276,   277,   278,     0,   279,     0,   280,
       0,     0,     0,   730,   281,   282,  2710,     0,     0,   283,
       0,   284,   285,     0,   286,   287,     0,     0,     0,   288,
       0,     0,   289,   290,   732,     0,     0,   292,     0,   733,
     293,   294,     0,     0,     0,     0,     0,   734,   296,     0,
     297,     0,   298,     0,   299,   300,     0,     0,   735,     0,
       0,     0,     0,   301,   302,   303,   304,   305,   306,   307,
     308,   309,   310,   311,   312,   313,   314,   315,   316,     0,
     317,   318,   319,   320,   736,   321,   322,   323,   324,   737,
     325,   326,     0,     0,     0,     0,   327,   328,   329,   330,
     738,   332,     0,     0,   739,   334,   740,   335,     0,   336,
     741,   742,   743,   744,   745,   341,   342,   343,   344,   345,
       0,   746,   346,   347,     0,     0,   348,   349,   350,   351,
     747,   748,   749,   352,   353,     0,   750,   751,   354,     0,
     355,   356,   752,     0,   358,   359,   360,   361,     0,   362,
     363,     0,     0,     0,     0,     0,     0,     0,     0,   364,
     365,   366,     0,   753,   367,     0,   368,     0,   369,   370,
     754,   372,   373,   374,   375,   755,   756,   378,   757,     0,
     379,   380,   381,     0,   382,     0,   383,   384,   385,   386,
     387,     0,   758,   389,   390,     0,     0,   391,     0,     0,
       0,   392,   393,   394,   395,   396,     0,     0,   397,   398,
     399,   400,   401,     0,   402,   403,     0,   404,   405,   406,
     759,   760,   407,     0,   408,     0,   409,   410,     0,   411,
     412,     0,   413,     0,   761,     0,   762,   415,   416,   417,
     418,   419,   420,   763,   764,   423,   424,   425,   426,     0,
     765,   428,     0,     0,     0,   429,   430,   431,   432,     0,
       0,     0,   433,     0,     0,     0,   434,     0,   435,   436,
     437,   438,   439,   440,     0,   441,   442,   443,   444,   445,
     446,     0,     0,     0,     0,     0,     0,   447,   448,     0,
     449,     0,     0,   450,     0,     0,   451,   452,     0,     0,
       0,   453,   766,   767,   454,   455,     0,   456,   457,   768,
     459,   460,   461,   769,   770,   462,   463,   464,   465,   771,
     466,   467,     0,   468,     0,   469,   470,   471,   472,     0,
     772,   473,   474,     0,   773,   774,   775,   776,     0,     0,
       0,     0,     0,   479,   480,   481,     0,   777,   778,   779,
     483,   484,   485,   780,   486,   487,   781,   488,   489,     0,
     490,   491,     0,     0,   492,     0,     0,   493,     0,   494,
       0,   782,   496,   497,     0,     0,   783,   784,   785,   786,
     498,     0,     0,   499,   787,     0,   788,   500,   501,   502,
     503,   504,   789,   790,     0,     0,     0,     0,     0,     0,
     507,   508,     0,   509,   510,   511,     0,     0,   791,     0,
       0,     0,     0,   792,   793,     0,     0,     0,     0,   794,
     795,     0,     0,   796,   797,     0,     0,   798,   799,   142,
       0,   143,   686,   145,   146,   147,   148,     0,     0,   149,
       0,     0,     0,   150,     0,     0,   687,     0,   152,   153,
     154,   155,   156,   157,   688,   159,     0,   160,     0,     0,
     689,   161,   690,   691,   692,   162,   693,     0,   163,   164,
     165,     0,   166,     0,   167,   168,     0,     0,   169,   694,
     695,   170,   171,     0,   172,   696,   697,   174,   175,     0,
     176,   177,   178,   179,   180,   698,   182,     0,   699,   184,
     700,   701,   702,   703,   704,     0,   190,   191,   192,   193,
     194,   195,   196,   197,     0,   198,   199,     0,   200,   201,
     202,   705,   204,     0,   205,   706,   707,   206,     0,     0,
     207,   708,   208,   709,   710,   209,     0,   210,   711,   712,
       0,   211,   212,   213,   713,   714,   715,     0,     0,     0,
       0,   716,   216,   717,     0,     0,   718,   217,     0,   218,
       0,     0,     0,   219,     0,   220,   221,   222,   223,   224,
       0,     0,     0,   225,     0,     0,   226,   227,   228,     0,
       0,     0,   229,     0,   230,   231,     0,   232,   233,   234,
       0,     0,   235,   236,     0,   237,   238,   239,   240,   241,
     242,   243,   719,     0,   244,   245,   246,   247,   720,   721,
     248,   249,     0,   250,   251,   252,   722,     0,   253,     0,
       0,     0,   254,     0,   255,     0,   256,     0,   257,   258,
     723,   260,   724,   262,   263,     0,   264,     0,   725,     0,
     265,   266,   267,     0,   268,   726,   727,     0,   269,   270,
       0,     0,     0,   728,   272,   273,   274,   275,   729,     0,
     276,   277,   278,     0,   279,     0,   280,     0,     0,     0,
     730,   281,   282,  2761,     0,     0,   283,     0,   284,   285,
       0,   286,   287,     0,     0,     0,   288,     0,     0,   289,
     290,   732,     0,     0,   292,     0,   733,   293,   294,     0,
       0,     0,     0,     0,   734,   296,     0,   297,     0,   298,
       0,   299,   300,     0,     0,   735,     0,     0,     0,     0,
     301,   302,   303,   304,   305,   306,   307,   308,   309,   310,
     311,   312,   313,   314,   315,   316,     0,   317,   318,   319,
     320,   736,   321,   322,   323,   324,   737,   325,   326,     0,
       0,     0,     0,   327,   328,   329,   330,   738,   332,     0,
       0,   739,   334,   740,   335,     0,   336,   741,   742,   743,
     744,   745,   341,   342,   343,   344,   345,     0,   746,   346,
     347,     0,     0,   348,   349,   350,   351,   747,   748,   749,
     352,   353,     0,   750,   751,   354,     0,   355,   356,   752,
       0,   358,   359,   360,   361,     0,   362,   363,     0,     0,
       0,     0,     0,     0,     0,     0,   364,   365,   366,     0,
     753,   367,     0,   368,     0,   369,   370,   754,   372,   373,
     374,   375,   755,   756,   378,   757,     0,   379,   380,   381,
       0,   382,     0,   383,   384,   385,   386,   387,     0,   758,
     389,   390,     0,     0,   391,     0,     0,     0,   392,   393,
     394,   395,   396,     0,     0,   397,   398,   399,   400,   401,
       0,   402,   403,     0,   404,   405,   406,   759,   760,   407,
       0,   408,     0,   409,   410,     0,   411,   412,     0,   413,
       0,   761,     0,   762,   415,   416,   417,   418,   419,   420,
     763,   764,   423,   424,   425,   426,     0,   765,   428,     0,
       0,     0,   429,   430,   431,   432,     0,     0,     0,   433,
       0,     0,     0,   434,     0,   435,   436,   437,   438,   439,
     440,     0,   441,   442,   443,   444,   445,   446,     0,     0,
       0,     0,     0,     0,   447,   448,     0,   449,     0,     0,
     450,     0,     0,   451,   452,     0,     0,     0,   453,   766,
     767,   454,   455,     0,   456,   457,   768,   459,   460,   461,
     769,   770,   462,   463,   464,   465,   771,   466,   467,     0,
     468,     0,   469,   470,   471,   472,     0,   772,   473,   474,
       0,   773,   774,   775,   776,     0,     0,     0,     0,     0,
     479,   480,   481,     0,   777,   778,   779,   483,   484,   485,
     780,   486,   487,   781,   488,   489,     0,   490,   491,     0,
       0,   492,     0,     0,   493,     0,   494,     0,   782,   496,
     497,     0,     0,   783,   784,   785,   786,   498,     0,     0,
     499,   787,     0,   788,   500,   501,   502,   503,   504,   789,
     790,     0,     0,     0,     0,     0,     0,   507,   508,     0,
     509,   510,   511,     0,     0,   791,     0,     0,     0,     0,
     792,   793,     0,     0,     0,     0,   794,   795,     0,     0,
     796,   797,     0,     0,   798,   799,   142,     0,   143,   686,
     145,   146,   147,   148,     0,     0,   149,     0,     0,     0,
     150,     0,     0,   687,     0,   152,   153,   154,   155,   156,
     157,   688,   159,     0,   160,     0,     0,   689,   161,   690,
     691,   692,   162,   693,     0,   163,   164,   165,     0,   166,
       0,   167,   168,     0,     0,   169,   694,   695,   170,   171,
       0,   172,   696,   697,   174,   175,     0,   176,   177,   178,
     179,   180,   698,   182,     0,   699,   184,   700,   701,   702,
     703,   704,     0,   190,   191,   192,   193,   194,   195,   196,
     197,     0,   198,   199,     0,   200,   201,   202,   705,   204,
       0,   205,   706,   707,   206,     0,     0,   207,   708,   208,
     709,   710,   209,     0,   210,   711,   712,     0,   211,   212,
     213,   713,   714,   715,     0,     0,     0,     0,   716,   216,
     717,     0,     0,  3596,   217,     0,   218,     0,     0,     0,
     219,     0,   220,   221,   222,   223,   224,     0,     0,     0,
     225,     0,     0,   226,   227,   228,     0,     0,     0,   229,
       0,   230,   231,     0,   232,   233,   234,     0,     0,   235,
     236,     0,   237,   238,   239,   240,   241,   242,   243,   719,
       0,   244,   245,   246,   247,   720,   721,   248,   249,     0,
     250,   251,   252,   722,     0,   253,     0,     0,     0,   254,
       0,   255,     0,   256,     0,   257,   258,   723,   260,   724,
     262,   263,     0,   264,     0,   725,     0,   265,   266,   267,
       0,   268,   726,   727,     0,   269,   270,     0,     0,     0,
     728,   272,   273,   274,   275,   729,     0,   276,   277,   278,
       0,   279,     0,   280,     0,     0,     0,   730,   281,   282,
     731,     0,     0,   283,     0,   284,   285,     0,   286,   287,
       0,     0,     0,   288,     0,     0,   289,   290,   732,     0,
       0,   292,     0,   733,   293,   294,     0,     0,     0,     0,
       0,   734,   296,     0,   297,     0,   298,     0,   299,   300,
       0,     0,   735,     0,     0,     0,     0,   301,   302,   303,
     304,   305,   306,   307,   308,   309,   310,   311,   312,   313,
     314,   315,   316,     0,   317,   318,   319,   320,   736,   321,
     322,   323,   324,   737,   325,   326,     0,     0,     0,     0,
     327,   328,   329,   330,   738,   332,     0,     0,   739,   334,
     740,   335,     0,   336,   741,   742,   743,   744,   745,   341,
     342,   343,   344,   345,     0,   746,   346,   347,     0,     0,
     348,   349,   350,   351,   747,   748,   749,   352,   353,     0,
     750,   751,   354,     0,   355,   356,   752,     0,   358,   359,
     360,   361,     0,   362,   363,     0,     0,     0,     0,     0,
       0,     0,     0,   364,   365,   366,     0,   753,   367,     0,
     368,     0,   369,   370,   754,   372,   373,   374,   375,   755,
     756,   378,   757,     0,   379,   380,   381,     0,   382,     0,
     383,   384,   385,   386,   387,     0,   758,   389,   390,     0,
       0,   391,     0,     0,     0,   392,   393,   394,   395,   396,
       0,     0,   397,   398,   399,   400,   401,     0,   402,   403,
       0,   404,   405,   406,   759,   760,   407,     0,   408,     0,
     409,   410,     0,   411,   412,     0,   413,     0,   761,     0,
     762,   415,   416,   417,   418,   419,   420,   763,   764,   423,
     424,   425,   426,     0,   765,   428,     0,     0,     0,   429,
     430,   431,   432,     0,     0,     0,   433,     0,     0,     0,
     434,     0,   435,   436,   437,   438,   439,   440,     0,   441,
     442,   443,   444,   445,   446,     0,     0,     0,     0,     0,
       0,   447,   448,     0,   449,     0,     0,   450,     0,     0,
     451,   452,     0,     0,     0,   453,   766,   767,   454,   455,
       0,   456,   457,   768,   459,   460,   461,   769,   770,   462,
     463,   464,   465,   771,   466,   467,     0,   468,     0,   469,
     470,   471,   472,     0,   772,   473,   474,     0,   773,   774,
     775,   776,     0,     0,     0,     0,     0,   479,   480,   481,
       0,   777,   778,   779,   483,   484,   485,   780,   486,   487,
     781,   488,   489,     0,   490,   491,     0,     0,   492,     0,
       0,   493,     0,   494,     0,   782,   496,   497,     0,     0,
     783,   784,   785,   786,   498,     0,     0,   499,   787,     0,
     788,   500,   501,   502,   503,   504,   789,   790,     0,     0,
       0,     0,     0,     0,   507,   508,     0,   509,   510,   511,
       0,     0,   791,     0,     0,     0,     0,   792,   793,     0,
       0,     0,     0,   794,   795,     0,     0,   796,   797,     0,
       0,   798,   799,   142,     0,   143,   686,   145,   146,   147,
     148,     0,     0,   149,     0,     0,     0,   150,     0,     0,
     687,     0,   152,   153,   154,   155,   156,   157,   688,   159,
       0,   160,     0,     0,   689,   161,   690,   691,   692,   162,
     693,     0,   163,   164,   165,     0,   166,     0,   167,   168,
       0,     0,   169,   694,   695,   170,   171,     0,   172,   696,
     697,   174,   175,     0,   176,   177,   178,   179,   180,   698,
     182,     0,   699,   184,   700,   701,   702,   703,   704,     0,
     190,   191,   192,   193,   194,   195,   196,   197,     0,   198,
     199,     0,   200,   201,   202,   705,   204,     0,   205,   706,
     707,   206,     0,     0,   207,   708,   208,   709,   710,   209,
       0,   210,   711,   712,     0,   211,   212,   213,   713,   714,
     715,     0,     0,     0,     0,   716,   216,   717,     0,     0,
     718,   217,     0,   218,     0,     0,     0,   219,     0,   220,
     221,   222,   223,   224,     0,     0,     0,   225,     0,     0,
     226,   227,   228,     0,     0,     0,   229,     0,   230,   231,
       0,   232,   233,   234,     0,     0,   235,   236,     0,   237,
     238,   239,   240,   241,   242,   243,   719,     0,   244,   245,
     246,   247,   720,   721,   248,   249,     0,   250,   251,   252,
     722,     0,   253,     0,     0,     0,   254,     0,   255,     0,
     256,     0,   257,   258,   723,   260,   724,   262,   263,     0,
     264,     0,   725,     0,   265,   266,   267,     0,   268,   726,
     727,     0,   269,   270,     0,     0,     0,   728,   272,   273,
     274,   275,   729,     0,   276,   277,   278,     0,   279,     0,
     280,     0,     0,     0,   730,   281,   282,   731,     0,     0,
     283,     0,   284,   285,     0,   286,   287,     0,     0,     0,
     288,     0,     0,   289,   290,   732,     0,     0,   292,     0,
     733,   293,   294,     0,     0,     0,     0,     0,   734,   296,
       0,   297,     0,   298,     0,   299,   300,     0,     0,   735,
       0,     0,     0,     0,   301,   302,   303,   304,   305,   306,
     307,   308,   309,   310,   311,   312,   313,   314,   315,   316,
       0,   317,   318,   319,   320,   736,   321,   322,   323,   324,
     737,   325,   326,  4624,     0,     0,     0,   327,   328,   329,
     330,   738,   332,     0,     0,   739,   334,   740,   335,     0,
     336,   741,   742,   743,   744,   745,   341,   342,   343,   344,
     345,     0,   746,   346,   347,     0,     0,   348,   349,   350,
     351,   747,     0,   749,   352,   353,     0,   750,   751,   354,
       0,   355,   356,   752,     0,   358,   359,   360,   361,     0,
     362,   363,     0,     0,     0,     0,     0,     0,     0,     0,
     364,   365,   366,     0,   753,   367,     0,   368,     0,   369,
     370,   754,   372,   373,   374,   375,   755,   756,   378,   757,
       0,   379,   380,   381,     0,   382,     0,   383,   384,   385,
     386,   387,     0,   758,   389,   390,     0,     0,   391,     0,
       0,     0,   392,   393,   394,   395,   396,     0,     0,   397,
     398,   399,   400,   401,     0,   402,   403,     0,   404,   405,
     406,   759,   760,   407,     0,   408,     0,   409,   410,     0,
     411,   412,     0,   413,     0,   761,     0,   762,   415,   416,
     417,   418,   419,   420,   763,   764,   423,   424,   425,   426,
       0,   765,   428,     0,     0,     0,   429,   430,   431,   432,
       0,     0,     0,   433,     0,     0,     0,   434,     0,   435,
     436,   437,   438,   439,   440,     0,   441,   442,   443,   444,
     445,   446,     0,     0,     0,     0,     0,     0,   447,   448,
       0,   449,     0,     0,   450,     0,     0,   451,   452,     0,
       0,     0,   453,   766,   767,   454,   455,     0,   456,   457,
     768,   459,   460,   461,   769,   770,   462,   463,   464,   465,
     771,   466,   467,     0,   468,     0,   469,   470,   471,   472,
       0,   772,   473,   474,     0,   773,   774,   775,   776,     0,
       0,     0,     0,     0,   479,   480,   481,     0,   777,   778,
     779,   483,   484,   485,   780,   486,   487,   781,   488,   489,
       0,   490,   491,     0,     0,   492,     0,     0,   493,     0,
     494,     0,   782,   496,   497,     0,     0,   783,   784,   785,
     786,   498,     0,     0,   499,   787,     0,   788,   500,   501,
     502,   503,   504,   789,   790,     0,     0,     0,     0,     0,
       0,   507,   508,     0,   509,   510,   511,     0,     0,   791,
       0,     0,     0,     0,   792,   793,     0,     0,     0,     0,
     794,   795,     0,     0,   796,   797,     0,     0,   798,   799,
     142,     0,   143,   686,   145,   146,   147,   148,     0,     0,
     149,     0,     0,     0,   150,     0,     0,   687,     0,   152,
     153,   154,   155,   156,   157,   688,   159,     0,   160,     0,
       0,   689,   161,   690,   691,   692,   162,   693,     0,   163,
     164,   165,     0,   166,     0,   167,   168,     0,     0,   169,
     694,   695,   170,   171,     0,   172,   696,   697,   174,   175,
       0,   176,   177,   178,   179,   180,   698,   182,     0,   699,
     184,   700,   701,   702,   703,   704,     0,   190,   191,   192,
     193,   194,   195,   196,   197,     0,   198,   199,     0,   200,
     201,   202,   705,   204,     0,   205,   706,   707,   206,     0,
       0,   207,   708,   208,   709,   710,   209,     0,   210,   711,
     712,     0,   211,   212,   213,   713,   714,   715,     0,     0,
       0,     0,   716,   216,   717,     0,     0,   718,   217,     0,
     218,     0,     0,     0,   219,     0,   220,   221,   222,   223,
     224,     0,     0,     0,   225,     0,     0,   226,   227,   228,
       0,     0,     0,   229,     0,   230,   231,     0,   232,   233,
     234,     0,     0,   235,   236,     0,   237,   238,   239,   240,
     241,   242,   243,   719,     0,   244,   245,   246,   247,   720,
     721,   248,   249,     0,   250,   251,   252,   722,     0,   253,
       0,     0,     0,   254,     0,   255,     0,   256,     0,   257,
     258,   723,   260,   724,   262,   263,     0,   264,     0,   725,
       0,   265,   266,   267,     0,   268,   726,   727,     0,   269,
     270,     0,     0,     0,   728,   272,   273,   274,   275,   729,
       0,   276,   277,   278,     0,   279,     0,   280,     0,     0,
       0,   730,   281,   282,   731,     0,     0,   283,     0,   284,
     285,     0,   286,   287,     0,     0,     0,   288,     0,     0,
     289,   290,   732,     0,     0,   292,     0,   733,   293,   294,
       0,     0,     0,     0,     0,   734,   296,     0,   297,     0,
     298,     0,   299,   300,     0,     0,   735,     0,     0,     0,
       0,   301,   302,   303,   304,   305,   306,   307,   308,   309,
     310,   311,   312,   313,   314,   315,   316,     0,   317,   318,
     319,   320,   736,   321,   322,   323,   324,   737,   325,   326,
       0,     0,     0,     0,   327,   328,   329,   330,   738,   332,
       0,     0,   739,   334,   740,   335,     0,   336,   741,   742,
     743,   744,   745,   341,   342,   343,   344,   345,     0,   746,
     346,   347,     0,     0,   348,   349,   350,   351,   747,     0,
     749,   352,   353,     0,   750,   751,   354,     0,   355,   356,
     752,     0,   358,   359,   360,   361,     0,   362,   363,     0,
       0,     0,     0,     0,     0,     0,     0,   364,   365,   366,
       0,   753,   367,     0,   368,     0,   369,   370,   754,   372,
     373,   374,   375,   755,   756,   378,   757,     0,   379,   380,
     381,     0,   382,     0,   383,   384,   385,   386,   387,     0,
     758,   389,   390,     0,     0,   391,     0,     0,     0,   392,
     393,   394,   395,   396,     0,     0,   397,   398,   399,   400,
     401,     0,   402,   403,     0,   404,   405,   406,   759,   760,
     407,     0,   408,     0,   409,   410,     0,   411,   412,     0,
     413,     0,   761,     0,   762,   415,   416,   417,   418,   419,
     420,   763,   764,   423,   424,   425,   426,     0,   765,   428,
       0,     0,     0,   429,   430,   431,   432,     0,     0,     0,
     433,     0,     0,     0,   434,     0,   435,   436,   437,   438,
     439,   440,     0,   441,   442,   443,   444,   445,   446,     0,
       0,     0,     0,     0,     0,   447,   448,     0,   449,     0,
       0,   450,     0,     0,   451,   452,     0,     0,     0,   453,
     766,   767,   454,   455,     0,   456,   457,   768,   459,   460,
     461,   769,   770,   462,   463,   464,   465,   771,   466,   467,
       0,   468,     0,   469,   470,   471,   472,     0,   772,   473,
     474,     0,   773,   774,   775,   776,     0,     0,     0,     0,
       0,   479,   480,   481,     0,   777,   778,   779,   483,   484,
     485,   780,   486,   487,   781,   488,   489,     0,   490,   491,
       0,     0,   492,     0,     0,   493,     0,   494,     0,   782,
     496,   497,     0,     0,   783,   784,   785,   786,   498,     0,
       0,   499,   787,     0,   788,   500,   501,   502,   503,   504,
     789,   790,     0,     0,     0,     0,     0,     0,   507,   508,
       0,   509,   510,   511,     0,     0,   791,     0,     0,     0,
       0,   792,   793,     0,     0,     0,     0,   794,   795,     0,
       0,   796,   797,     0,     0,   798,   799,   142,     0,   143,
     686,   145,   146,   147,   148,     0,     0,   149,     0,     0,
       0,   150,     0,     0,   687,     0,   152,   153,   154,   155,
     156,   157,   688,   159,     0,   160,     0,     0,   689,   161,
     690,   691,   692,   162,   693,     0,   163,   164,   165,     0,
     166,     0,   167,   168,     0,     0,   169,   694,   695,   170,
     171,     0,   172,   696,   697,   174,   175,     0,   176,   177,
     178,   179,   180,   698,   182,     0,   699,   184,   700,   701,
     702,   703,   704,     0,   190,   191,   192,   193,   194,   195,
     196,   197,     0,   198,   199,     0,   200,   201,   202,   705,
     204,     0,   205,   706,   707,   206,     0,     0,   207,   708,
     208,   709,   710,   209,     0,   210,   711,   712,     0,   211,
     212,   213,   713,   714,   715,     0,     0,     0,     0,   716,
     216,   717,     0,     0,   718,   217,     0,   218,     0,     0,
       0,   219,     0,   220,   221,   222,   223,   224,     0,     0,
       0,   225,     0,     0,   226,   227,   228,     0,     0,     0,
     229,     0,   230,   231,     0,   232,   233,   234,     0,     0,
     235,   236,     0,   237,   238,   239,   240,   241,   242,   243,
     719,     0,   244,   245,   246,   247,   720,   721,   248,   249,
       0,   250,   251,   252,   722,     0,   253,     0,     0,     0,
     254,     0,   255,     0,   256,     0,   257,   258,   723,   260,
     724,   262,   263,     0,   264,     0,   725,     0,   265,   266,
     267,     0,   268,   726,   727,     0,   269,   270,     0,     0,
       0,   728,   272,   273,   274,   275,   729,     0,   276,   277,
     278,     0,   279,     0,   280,     0,     0,     0,   730,   281,
     282,  1811,     0,     0,   283,     0,   284,   285,     0,   286,
     287,     0,     0,     0,   288,     0,     0,   289,   290,   732,
       0,     0,   292,     0,   733,   293,   294,     0,     0,     0,
       0,     0,   734,   296,     0,   297,     0,   298,     0,   299,
     300,     0,     0,   735,     0,     0,     0,     0,   301,   302,
     303,   304,   305,   306,   307,   308,   309,   310,   311,   312,
     313,   314,   315,   316,     0,   317,   318,   319,   320,   736,
     321,   322,   323,   324,   737,   325,   326,     0,     0,     0,
       0,   327,   328,   329,   330,   738,   332,     0,     0,   739,
     334,   740,   335,     0,   336,   741,   742,   743,   744,   745,
     341,   342,   343,   344,   345,     0,   746,   346,   347,     0,
       0,   348,   349,   350,   351,   747,     0,   749,   352,   353,
       0,   750,   751,   354,     0,   355,   356,   752,     0,   358,
     359,   360,   361,     0,   362,   363,     0,     0,     0,     0,
       0,     0,     0,     0,   364,   365,   366,     0,   753,   367,
       0,   368,     0,   369,   370,   754,   372,   373,   374,   375,
     755,   756,   378,   757,     0,   379,   380,   381,     0,   382,
       0,   383,   384,   385,   386,   387,     0,   758,   389,   390,
       0,     0,   391,     0,     0,     0,   392,   393,   394,   395,
     396,     0,     0,   397,   398,   399,   400,   401,     0,   402,
     403,     0,   404,   405,   406,   759,   760,   407,     0,   408,
       0,   409,   410,     0,   411,   412,     0,   413,     0,   761,
       0,   762,   415,   416,   417,   418,   419,   420,   763,   764,
     423,   424,   425,   426,     0,   765,   428,     0,     0,     0,
     429,   430,   431,   432,     0,     0,     0,   433,     0,     0,
       0,   434,     0,   435,   436,   437,   438,   439,   440,     0,
     441,   442,   443,   444,   445,   446,     0,     0,     0,     0,
       0,     0,   447,   448,     0,   449,     0,     0,   450,     0,
       0,   451,   452,     0,     0,     0,   453,   766,   767,   454,
     455,     0,   456,   457,   768,   459,   460,   461,   769,   770,
     462,   463,   464,   465,   771,   466,   467,     0,   468,     0,
     469,   470,   471,   472,     0,   772,   473,   474,     0,   773,
     774,   775,   776,     0,     0,     0,     0,     0,   479,   480,
     481,     0,   777,   778,   779,   483,   484,   485,   780,   486,
     487,   781,   488,   489,     0,   490,   491,     0,     0,   492,
       0,     0,   493,     0,   494,     0,   782,   496,   497,     0,
       0,   783,   784,   785,   786,   498,     0,     0,   499,   787,
       0,   788,   500,   501,   502,   503,   504,   789,   790,     0,
       0,     0,     0,     0,     0,   507,   508,     0,   509,   510,
     511,     0,     0,   791,     0,     0,     0,     0,   792,   793,
       0,     0,     0,     0,   794,   795,     0,     0,   796,   797,
       0,     0,   798,   799,   142,     0,   143,   686,   145,   146,
     147,   148,     0,     0,   149,     0,     0,     0,   150,     0,
       0,   687,     0,   152,   153,   154,   155,   156,   157,   688,
     159,     0,   160,     0,     0,   689,   161,   690,   691,   692,
     162,   693,     0,   163,   164,   165,     0,   166,     0,   167,
     168,     0,     0,   169,   694,   695,   170,   171,     0,   172,
     696,   697,   174,   175,     0,   176,   177,   178,   179,   180,
     698,   182,     0,   699,   184,   700,   701,   702,   703,   704,
       0,   190,   191,   192,   193,   194,   195,   196,   197,     0,
     198,   199,     0,   200,   201,   202,   705,   204,     0,   205,
     706,   707,   206,     0,     0,   207,   708,   208,   709,   710,
     209,     0,   210,   711,   712,     0,   211,   212,   213,   713,
     714,   715,     0,     0,     0,     0,   716,   216,   717,     0,
       0,   718,   217,     0,   218,     0,     0,     0,   219,     0,
     220,   221,   222,   223,   224,     0,     0,     0,   225,     0,
       0,   226,   227,   228,     0,     0,     0,   229,     0,   230,
     231,     0,   232,   233,   234,     0,     0,   235,   236,     0,
     237,   238,   239,   240,   241,   242,   243,   719,     0,   244,
     245,   246,   247,   720,   721,   248,   249,     0,   250,   251,
     252,   722,     0,   253,     0,     0,     0,   254,     0,   255,
       0,   256,     0,   257,   258,   723,   260,   724,   262,   263,
       0,   264,     0,   725,     0,   265,   266,   267,     0,   268,
     726,   727,     0,   269,   270,     0,     0,     0,   728,   272,
     273,   274,   275,   729,     0,   276,   277,   278,     0,   279,
       0,   280,     0,     0,     0,   730,   281,   282,  1813,     0,
       0,   283,     0,   284,   285,     0,   286,   287,     0,     0,
       0,   288,     0,     0,   289,   290,   732,     0,     0,   292,
       0,   733,   293,   294,     0,     0,     0,     0,     0,   734,
     296,     0,   297,     0,   298,     0,   299,   300,     0,     0,
     735,     0,     0,     0,     0,   301,   302,   303,   304,   305,
     306,   307,   308,   309,   310,   311,   312,   313,   314,   315,
     316,     0,   317,   318,   319,   320,   736,   321,   322,   323,
     324,   737,   325,   326,     0,     0,     0,     0,   327,   328,
     329,   330,   738,   332,     0,     0,   739,   334,   740,   335,
       0,   336,   741,   742,   743,   744,   745,   341,   342,   343,
     344,   345,     0,   746,   346,   347,     0,     0,   348,   349,
     350,   351,   747,     0,   749,   352,   353,     0,   750,   751,
     354,     0,   355,   356,   752,     0,   358,   359,   360,   361,
       0,   362,   363,     0,     0,     0,     0,     0,     0,     0,
       0,   364,   365,   366,     0,   753,   367,     0,   368,     0,
     369,   370,   754,   372,   373,   374,   375,   755,   756,   378,
     757,     0,   379,   380,   381,     0,   382,     0,   383,   384,
     385,   386,   387,     0,   758,   389,   390,     0,     0,   391,
       0,     0,     0,   392,   393,   394,   395,   396,     0,     0,
     397,   398,   399,   400,   401,     0,   402,   403,     0,   404,
     405,   406,   759,   760,   407,     0,   408,     0,   409,   410,
       0,   411,   412,     0,   413,     0,   761,     0,   762,   415,
     416,   417,   418,   419,   420,   763,   764,   423,   424,   425,
     426,     0,   765,   428,     0,     0,     0,   429,   430,   431,
     432,     0,     0,     0,   433,     0,     0,     0,   434,     0,
     435,   436,   437,   438,   439,   440,     0,   441,   442,   443,
     444,   445,   446,     0,     0,     0,     0,     0,     0,   447,
     448,     0,   449,     0,     0,   450,     0,     0,   451,   452,
       0,     0,     0,   453,   766,   767,   454,   455,     0,   456,
     457,   768,   459,   460,   461,   769,   770,   462,   463,   464,
     465,   771,   466,   467,     0,   468,     0,   469,   470,   471,
     472,     0,   772,   473,   474,     0,   773,   774,   775,   776,
       0,     0,     0,     0,     0,   479,   480,   481,     0,   777,
     778,   779,   483,   484,   485,   780,   486,   487,   781,   488,
     489,     0,   490,   491,     0,     0,   492,     0,     0,   493,
       0,   494,     0,   782,   496,   497,     0,     0,   783,   784,
     785,   786,   498,     0,     0,   499,   787,     0,   788,   500,
     501,   502,   503,   504,   789,   790,     0,     0,     0,     0,
       0,     0,   507,   508,     0,   509,   510,   511,     0,     0,
     791,     0,     0,     0,     0,   792,   793,     0,     0,     0,
       0,   794,   795,     0,     0,   796,   797,     0,     0,   798,
     799,   142,     0,   143,   144,   145,   146,   147,   148,     0,
       0,   149,     0,     0,     0,   150,     0,     0,   151,     0,
     152,   153,   154,   155,   156,   157,   158,   159,     0,   160,
       0,     0,     0,   161,   690,     0,     0,   162,     0,     0,
     163,   164,   165,     0,   166,     0,   167,   168,     0,     0,
     169,     0,     0,   170,   171,     0,   172,   173,     0,   174,
     175,     0,   176,   177,   178,   179,   180,   181,   182,     0,
     183,   184,   185,   186,   187,   188,   189,     0,   190,   191,
     192,   193,   194,   195,   196,   197,     0,   198,   199,     0,
     200,   201,   202,   203,   204,     0,   205,     0,     0,   206,
       0,     0,   207,     0,   208,     0,     0,   209,     0,   210,
       0,     0,     0,   211,   212,   213,     0,     0,  1852,     0,
       0,     0,     0,   215,   216,   717,     0,     0,     0,   217,
       0,   218,     0,     0,     0,   219,     0,   220,   221,   222,
     223,   224,     0,     0,     0,   225,     0,     0,   226,   227,
     228,     0,     0,     0,   229,     0,   230,   231,     0,   232,
     233,   234,     0,     0,   235,   236,     0,   237,   238,   239,
     240,   241,   242,   243,     0,     0,   244,   245,   246,   247,
       0,   721,   248,   249,     0,   250,   251,   252,   722,     0,
     253,     0,     0,     0,   254,     0,   255,     0,   256,     0,
     257,   258,   259,   260,   261,   262,   263,     0,   264,     0,
       0,     0,   265,   266,   267,     0,   268,   726,   727,     0,
     269,   270,     0,     0,     0,   271,   272,   273,   274,   275,
       0,     0,   276,   277,   278,     0,   279,     0,   280,     0,
       0,     0,     0,   281,   282,     0,     0,     0,   283,     0,
     284,   285,     0,   286,   287,     0,     0,     0,   288,     0,
       0,   289,   290,   291,     0,     0,   292,     0,     0,   293,
     294,     0,     0,     0,     0,     0,   295,   296,     0,   297,
       0,   298,     0,   299,   300,     0,     0,   735,     0,     0,
       0,     0,   301,   302,   303,   304,   305,   306,   307,   308,
     309,   310,   311,   312,   313,   314,   315,   316,     0,   317,
     318,   319,   320,     0,   321,   322,   323,   324,     0,   325,
     326,     0,     0,     0,     0,   327,   328,   329,   330,   331,
     332,     0,     0,   333,   334,     0,   335,     0,   336,     0,
     337,   338,   339,   340,   341,   342,   343,   344,   345,     0,
     746,   346,   347,     0,     0,   348,   349,   350,   351,     0,
       0,     0,   352,   353,     0,   750,   751,   354,     0,   355,
     356,   357,     0,   358,   359,   360,   361,     0,   362,   363,
       0,     0,     0,     0,     0,     0,     0,     0,   364,   365,
     366,     0,     0,   367,     0,   368,     0,   369,   370,   371,
     372,   373,   374,   375,   376,   377,   378,     0,     0,   379,
     380,   381,     0,   382,     0,   383,   384,   385,   386,   387,
       0,   388,   389,   390,     0,     0,   391,     0,     0,     0,
     392,   393,   394,   395,   396,     0,     0,   397,   398,   399,
     400,   401,     0,   402,   403,     0,   404,   405,   406,     0,
       0,   407,     0,   408,     0,   409,   410,     0,   411,   412,
       0,   413,     0,   414,     0,     0,   415,   416,   417,   418,
     419,   420,   421,   422,   423,   424,   425,   426,     0,   427,
     428,     0,     0,     0,   429,   430,   431,   432,     0,     0,
       0,   433,     0,     0,     0,   434,     0,   435,   436,   437,
     438,   439,   440,     0,   441,   442,   443,   444,   445,   446,
       0,     0,     0,     0,     0,     0,   447,   448,     0,   449,
       0,     0,   450,     0,     0,   451,   452,     0,     0,     0,
     453,     0,     0,   454,   455,     0,   456,   457,   458,   459,
     460,   461,     0,     0,   462,   463,   464,   465,     0,   466,
     467,     0,   468,     0,   469,   470,   471,   472,     0,   772,
     473,   474,     0,  1853,   476,   477,  1854,     0,     0,     0,
       0,     0,   479,   480,   481,     0,     0,   778,   482,   483,
     484,   485,   780,   486,   487,   781,   488,   489,     0,   490,
     491,     0,     0,   492,     0,     0,   493,     0,   494,     0,
     495,   496,   497,     0,     0,     0,     0,     0,     0,   498,
       0,     0,   499,     0,     0,     0,   500,   501,   502,   503,
     504,   505,   506,     0,     0,     0,     0,     0,     0,   507,
     508,     0,   509,   510,   511,     0,     0,   512,     0,     0,
       0,   142,     0,   143,   144,   145,   146,   147,   148,     0,
       0,   149,     0,     0,     0,   150,   798,   799,   151,     0,
     152,   153,   154,   155,   156,   157,   158,   159,     0,   160,
       0,     0,     0,   161,     0,     0,     0,   162,     0,     0,
     163,   164,   165,     0,   166,     0,   167,   168,     0,     0,
     169,     0,     0,   170,   171,     0,   172,   173,     0,   174,
     175,     0,   176,   177,   178,   179,   180,   181,   182,     0,
     183,   184,   185,   186,   187,   188,   189,     0,   190,   191,
     192,   193,   194,   195,   196,   197,     0,   198,   199,  3000,
     200,   201,   202,   203,   204,     0,   205,     0,     0,   206,
       0,     0,   207,     0,   208,     0,     0,   209,     0,   210,
       0,     0,     0,   211,   212,   213,     0,     0,   214,     0,
       0,     0,     0,   215,   216,     0,     0,     0,     0,   217,
       0,   218,     0,     0,     0,   219,     0,   220,   221,   222,
     223,   224,     0,     0,     0,   225,     0,     0,   226,   227,
     228,     0,     0,     0,   229,     0,   230,   231,     0,   232,
     233,   234,     0,     0,   235,   236,     0,   237,   238,   239,
     240,   241,   242,   243,     0,     0,   244,   245,   246,   247,
       0,     0,   248,   249,     0,   250,   251,   252,     0,     0,
     253,     0,     0,     0,   254,     0,   255,   526,   256,     0,
     257,   258,   259,   260,   261,   262,   263,     0,   264,     0,
       0,     0,   265,   266,   267,     0,   268,     0,     0,     0,
     269,   270,     0,     0,     0,   271,   272,   273,   274,   275,
       0,     0,   276,   277,   278,  2132,   279,     0,   280,     0,
       0,     0,     0,   281,   282,     0,     0,     0,   283,     0,
     284,   285,     0,   286,   287,     0,     0,     0,   288,  2133,
       0,   289,   290,   291,     0,     0,   292,     0,     0,   293,
     294,     0,  3371,     0,     0,     0,   295,   296,     0,   297,
       0,   298,     0,   299,   300,     0,     0,     0,     0,     0,
       0,     0,   301,   302,   303,   304,   305,   306,   307,   308,
     309,   310,   311,   312,   313,   314,   315,   316,     0,   317,
     318,   319,   320,     0,   321,   322,   323,   324,     0,   325,
     326,     0,     0,     0,     0,   327,   328,   329,   330,   331,
     332,     0,     0,   333,   334,     0,   335,     0,   336,     0,
     337,   338,   339,   340,   341,   342,   343,   344,   345,     0,
       0,   346,   347,     0,     0,   348,   349,   350,   351,     0,
       0,     0,   352,   353,     0,     0,     0,   354,     0,   355,
     356,   357,     0,   358,   359,   360,   361,     0,   362,   363,
       0,     0,     0,     0,     0,     0,     0,     0,   364,   365,
     366,     0,     0,   367,     0,   368,     0,   369,   370,   371,
     372,   373,   374,   375,   376,   377,   378,     0,     0,   379,
     380,   381,     0,   382,     0,   383,   384,   385,   386,   387,
       0,   388,   389,   390,     0,     0,   391,     0,     0,     0,
     392,   393,   394,   395,   396,     0,     0,   397,   398,   399,
     400,   401,     0,   402,   403,     0,   404,   405,   406,     0,
       0,   407,     0,   408,     0,   409,   410,     0,   411,   412,
       0,   413,     0,   414,     0,     0,   415,   416,   417,   418,
     419,   420,   421,   422,   423,   424,   425,   426,     0,   427,
     428,  2431,     0,     0,   429,   430,   431,   432,     0,     0,
       0,   433,     0,     0,     0,   434,     0,   435,   436,   437,
     438,   439,   440,     0,   441,   442,   443,   444,   445,   446,
     531,     0,     0,     0,     0,     0,   447,   448,     0,   449,
       0,     0,   450,     0,     0,   451,   452,     0,     0,     0,
     453,     0,     0,   454,   455,     0,   456,   457,   458,   459,
     460,   461,     0,     0,   462,   463,   464,   465,     0,   466,
     467,     0,   468,     0,   469,   470,   471,   472,     0,     0,
     473,   474,     0,   475,   476,   477,   478,     0,     0,     0,
       0,     0,   479,   480,   481,     0,     0,     0,   482,   483,
     484,   485,     0,   486,   487,     0,   488,   489,     0,   490,
     491,     0,     0,   492,     0,     0,   493,     0,   494,     0,
     495,   496,   497,     0,     0,     0,     0,     0,     0,   498,
       0,     0,   499,     0,     0,     0,   500,   501,   502,   503,
     504,   505,   506,     0,     0,     0,     0,     0,     0,   507,
     508,     0,   509,   510,   511,     0,     0,   512,     0,   142,
       0,   143,   144,   145,   146,   147,   148,     0,     0,   149,
       0,     0,     0,   150,     0,     0,   151,  3073,   152,   153,
     154,   155,   156,   157,   158,   159,     0,   160,     0,     0,
       0,   161,     0,     0,     0,   162,     0,     0,   163,   164,
     165,     0,   166,     0,   167,   168,     0,     0,   169,     0,
       0,   170,   171,     0,   172,   173,     0,   174,   175,     0,
     176,   177,   178,   179,   180,   181,   182,     0,   183,   184,
     185,   186,   187,   188,   189,     0,   190,   191,   192,   193,
     194,   195,   196,   197,     0,   198,   199,  3000,   200,   201,
     202,   203,   204,     0,   205,     0,     0,   206,     0,     0,
     207,     0,   208,     0,     0,   209,     0,   210,     0,     0,
       0,   211,   212,   213,     0,     0,   214,     0,     0,     0,
       0,   215,   216,     0,     0,     0,     0,   217,     0,   218,
       0,     0,     0,   219,     0,   220,   221,   222,   223,   224,
       0,     0,     0,   225,     0,     0,   226,   227,   228,     0,
       0,     0,   229,     0,   230,   231,     0,   232,   233,   234,
       0,     0,   235,   236,     0,   237,   238,   239,   240,   241,
     242,   243,     0,     0,   244,   245,   246,   247,     0,     0,
     248,   249,     0,   250,   251,   252,     0,     0,   253,     0,
       0,     0,   254,     0,   255,   526,   256,     0,   257,   258,
     259,   260,   261,   262,   263,     0,   264,     0,     0,     0,
     265,   266,   267,     0,   268,     0,     0,     0,   269,   270,
       0,     0,     0,   271,   272,   273,   274,   275,     0,     0,
     276,   277,   278,  2132,   279,     0,   280,     0,     0,     0,
       0,   281,   282,     0,     0,     0,   283,     0,   284,   285,
       0,   286,   287,     0,     0,     0,   288,  2133,     0,   289,
     290,   291,     0,     0,   292,     0,     0,   293,   294,     0,
       0,     0,     0,     0,   295,   296,     0,   297,     0,   298,
       0,   299,   300,     0,     0,     0,     0,     0,     0,     0,
     301,   302,   303,   304,   305,   306,   307,   308,   309,   310,
     311,   312,   313,   314,   315,   316,     0,   317,   318,   319,
     320,     0,   321,   322,   323,   324,     0,   325,   326,     0,
       0,     0,     0,   327,   328,   329,   330,   331,   332,     0,
       0,   333,   334,     0,   335,     0,   336,     0,   337,   338,
     339,   340,   341,   342,   343,   344,   345,     0,     0,   346,
     347,     0,     0,   348,   349,   350,   351,     0,     0,     0,
     352,   353,     0,     0,     0,   354,     0,   355,   356,   357,
       0,   358,   359,   360,   361,     0,   362,   363,     0,     0,
       0,     0,     0,     0,     0,     0,   364,   365,   366,     0,
       0,   367,     0,   368,     0,   369,   370,   371,   372,   373,
     374,   375,   376,   377,   378,     0,     0,   379,   380,   381,
       0,   382,     0,   383,   384,   385,   386,   387,     0,   388,
     389,   390,     0,     0,   391,     0,     0,     0,   392,   393,
     394,   395,   396,     0,     0,   397,   398,   399,   400,   401,
       0,   402,   403,     0,   404,   405,   406,     0,     0,   407,
       0,   408,     0,   409,   410,     0,   411,   412,     0,   413,
       0,   414,     0,     0,   415,   416,   417,   418,   419,   420,
     421,   422,   423,   424,   425,   426,     0,   427,   428,     0,
       0,     0,   429,   430,   431,   432,     0,     0,     0,   433,
       0,     0,     0,   434,     0,   435,   436,   437,   438,   439,
     440,     0,   441,   442,   443,   444,   445,   446,   531,     0,
       0,     0,     0,     0,   447,   448,     0,   449,     0,     0,
     450,     0,     0,   451,   452,     0,     0,     0,   453,     0,
       0,   454,   455,     0,   456,   457,   458,   459,   460,   461,
       0,     0,   462,   463,   464,   465,     0,   466,   467,     0,
     468,     0,   469,   470,   471,   472,     0,     0,   473,   474,
       0,   475,   476,   477,   478,     0,     0,     0,     0,     0,
     479,   480,   481,     0,     0,     0,   482,   483,   484,   485,
       0,   486,   487,     0,   488,   489,     0,   490,   491,     0,
       0,   492,     0,     0,   493,     0,   494,     0,   495,   496,
     497,     0,     0,     0,     0,     0,     0,   498,     0,     0,
     499,     0,     0,     0,   500,   501,   502,   503,   504,   505,
     506,     0,     0,     0,     0,     0,     0,   507,   508,     0,
     509,   510,   511,     0,     0,   512,     0,   142,     0,   143,
     144,   145,   146,   147,   148,     0,     0,   149,     0,     0,
       0,   150,     0,     0,   151,  3073,   152,   153,   154,   155,
     156,   157,   158,   159,     0,   160,     0,     0,     0,   161,
       0,     0,     0,   162,     0,     0,   163,   164,   165,     0,
     166,     0,   167,   168,     0,     0,   169,     0,     0,   170,
     171,     0,   172,   173,     0,   174,   175,     0,   176,   177,
     178,   179,   180,   181,   182,     0,   183,   184,   185,   186,
     187,   188,   189,     0,   190,   191,   192,   193,   194,   195,
     196,   197,     0,   198,   199,     0,   200,   201,   202,   203,
     204,     0,   205,     0,     0,   206,     0,     0,   207,     0,
     208,     0,     0,   209,     0,   210,     0,     0,     0,   211,
     212,   213,     0,     0,   214,     0,     0,     0,     0,   215,
     216,     0,     0,     0,     0,   217,     0,   218,     0,     0,
       0,   219,     0,   220,   221,   222,   223,   224,     0,     0,
       0,   225,     0,     0,   226,   227,   228,     0,     0,     0,
     229,     0,   230,   231,     0,   232,   233,   234,     0,     0,
     235,   236,     0,   237,   238,   239,   240,   241,   242,   243,
       0,     0,   244,   245,   246,   247,     0,     0,   248,   249,
       0,   250,   251,   252,     0,     0,   253,     0,     0,     0,
     254,     0,   255,     0,   256,     0,   257,   258,   259,   260,
     261,   262,   263,     0,   264,     0,     0,     0,   265,   266,
     267,     0,   268,     0,     0,     0,   269,   270,     0,     0,
       0,   271,   272,   273,   274,   275,     0,     0,   276,   277,
     278,     0,   279,     0,   280,     0,     0,     0,     0,   281,
     282,     0,     0,     0,   283,     0,   284,   285,     0,   286,
     287,     0,     0,     0,   288,     0,     0,   289,   290,   291,
       0,     0,   292,     0,     0,   293,   294,     0,     0,     0,
       0,     0,   295,   296,     0,   297,     0,   298,     0,   299,
     300,     0,     0,     0,     0,     0,     0,     0,   301,   302,
     303,   304,   305,   306,   307,   308,   309,   310,   311,   312,
     313,   314,   315,   316,     0,   317,   318,   319,   320,     0,
     321,   322,   323,   324,     0,   325,   326,     0,     0,     0,
       0,   327,   328,   329,   330,   331,   332,     0,     0,   333,
     334,     0,   335,     0,   336,     0,   337,   338,   339,   340,
     341,   342,   343,   344,   345,     0,     0,   346,   347,     0,
       0,   348,   349,   350,   351,     0,     0,     0,   352,   353,
       0,     0,     0,   354,     0,   355,   356,   357,     0,   358,
     359,   360,   361,     0,   362,   363,     0,     0,     0,     0,
       0,     0,     0,     0,   364,   365,   366,     0,     0,   367,
       0,   368,     0,   369,   370,   371,   372,   373,   374,   375,
     376,   377,   378,     0,     0,   379,   380,   381,     0,   382,
       0,   383,   384,   385,   386,   387,     0,   388,   389,   390,
       0,     0,   391,     0,     0,     0,   392,   393,   394,   395,
     396,     0,     0,   397,   398,   399,   400,   401,     0,   402,
     403,     0,   404,   405,   406,     0,     0,   407,     0,   408,
       0,   409,   410,     0,   411,   412,     0,   413,     0,   414,
       0,     0,   415,   416,   417,   418,   419,   420,   421,   422,
     423,   424,   425,   426,     0,   427,   428,  2431,     0,     0,
     429,   430,   431,   432,     0,     0,     0,   433,     0,     0,
       0,   434,     0,   435,   436,   437,   438,   439,   440,     0,
     441,   442,   443,   444,   445,   446,     0,     0,     0,     0,
       0,     0,   447,   448,     0,   449,     0,     0,   450,     0,
       0,   451,   452,     0,     0,     0,   453,     0,     0,   454,
     455,     0,   456,   457,   458,   459,   460,   461,     0,     0,
     462,   463,   464,   465,     0,   466,   467,     0,   468,     0,
     469,   470,   471,   472,     0,     0,   473,   474,     0,   475,
     476,   477,   478,     0,     0,     0,     0,     0,   479,   480,
     481,     0,     0,     0,   482,   483,   484,   485,     0,   486,
     487,     0,   488,   489,     0,   490,   491,     0,     0,   492,
       0,     0,   493,     0,   494,     0,   495,   496,   497,     0,
       0,     0,     0,     0,     0,   498,     0,     0,   499,     0,
       0,     0,   500,   501,   502,   503,   504,   505,   506,     0,
       0,     0,     0,     0,     0,   507,   508,     0,   509,   510,
     511,     0,     0,   512,     0,   142,     0,   143,   144,   145,
     146,   147,   148,     0,     0,   149,  2869,     0,     0,   150,
       0,     0,   151,   799,   152,   153,   154,   155,   156,   157,
     158,   159,     0,   160,     0,     0,     0,   161,     0,     0,
       0,   162,     0,     0,   163,   164,   165,     0,   166,     0,
     167,   168,     0,     0,   169,     0,     0,   170,   171,     0,
     172,   173,     0,   174,   175,     0,   176,   177,   178,   179,
     180,   181,   182,     0,   183,   184,   185,   186,   187,   188,
     189,     0,   190,   191,   192,   193,   194,   195,   196,   197,
       0,   198,   199,     0,   200,   201,   202,   203,   204,     0,
     205,     0,     0,   206,     0,     0,   207,     0,   208,     0,
       0,   209,     0,   210,     0,     0,     0,   211,   212,   213,
       0,     0,   214,     0,     0,     0,     0,   215,   216,     0,
       0,     0,     0,   217,     0,   218,     0,     0,     0,   219,
       0,   220,   221,   222,   223,   224,     0,     0,     0,   225,
       0,     0,   226,   227,   228,     0,     0,     0,   229,     0,
     230,   231,     0,   232,   233,   234,     0,     0,   235,   236,
       0,   237,   238,   239,   240,   241,   242,   243,     0,     0,
     244,   245,   246,   247,     0,     0,   248,   249,     0,   250,
     251,   252,     0,     0,   253,     0,     0,     0,   254,     0,
     255,     0,   256,     0,   257,   258,   259,   260,   261,   262,
     263,     0,   264,     0,     0,     0,   265,   266,   267,     0,
     268,     0,     0,     0,   269,   270,     0,     0,     0,   271,
     272,   273,   274,   275,     0,     0,   276,   277,   278,     0,
     279,     0,   280,     0,     0,     0,     0,   281,   282,     0,
       0,     0,   283,     0,   284,   285,     0,   286,   287,     0,
       0,     0,   288,     0,     0,   289,   290,   291,     0,     0,
     292,     0,     0,   293,   294,     0,     0,     0,     0,     0,
     295,   296,     0,   297,     0,   298,     0,   299,   300,     0,
       0,     0,     0,     0,     0,     0,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,     0,   317,   318,   319,   320,     0,   321,   322,
     323,   324,     0,   325,   326,     0,     0,     0,     0,   327,
     328,   329,   330,   331,   332,     0,     0,   333,   334,     0,
     335,     0,   336,     0,   337,   338,   339,   340,   341,   342,
     343,   344,   345,     0,     0,   346,   347,     0,     0,   348,
     349,   350,   351,     0,     0,     0,   352,   353,     0,     0,
       0,   354,     0,   355,   356,   357,     0,   358,   359,   360,
     361,     0,   362,   363,     0,     0,     0,     0,     0,     0,
       0,     0,   364,   365,   366,     0,     0,   367,     0,   368,
       0,   369,   370,   371,   372,   373,   374,   375,   376,   377,
     378,     0,     0,   379,   380,   381,     0,   382,     0,   383,
     384,   385,   386,   387,     0,   388,   389,   390,     0,     0,
     391,     0,     0,     0,   392,   393,   394,   395,   396,     0,
       0,   397,   398,   399,   400,   401,     0,   402,   403,     0,
     404,   405,   406,     0,     0,   407,     0,   408,     0,   409,
     410,     0,   411,   412,     0,   413,     0,   414,     0,     0,
     415,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,     0,   427,   428,     0,     0,     0,   429,   430,
     431,   432,     0,     0,     0,   433,     0,     0,     0,   434,
       0,   435,   436,   437,   438,   439,   440,     0,   441,   442,
     443,   444,   445,   446,     0,     0,     0,     0,     0,     0,
     447,   448,     0,   449,     0,     0,   450,     0,     0,   451,
     452,     0,     0,     0,   453,     0,     0,   454,   455,     0,
     456,   457,   458,   459,   460,   461,     0,     0,   462,   463,
     464,   465,     0,   466,   467,     0,   468,     0,   469,   470,
     471,   472,     0,     0,   473,   474,     0,   475,   476,   477,
     478,     0,     0,     0,     0,     0,   479,   480,   481,     0,
       0,     0,   482,   483,   484,   485,     0,   486,   487,     0,
     488,   489,     0,   490,   491,     0,     0,   492,     0,     0,
     493,     0,   494,     0,   495,   496,   497,     0,     0,     0,
       0,     0,     0,   498,     0,     0,   499,     0,     0,     0,
     500,   501,   502,   503,   504,   505,   506,     0,     0,     0,
       0,     0,     0,   507,   508,     0,   509,   510,   511,     0,
       0,   512,     0,     0,     0,   142,     0,   143,   144,   145,
     146,   147,   148,     0,  4768,   149,     0,     0,     0,   150,
    4769,   799,   151,     0,   152,   153,   154,   155,   156,   157,
     158,   159,     0,   160,     0,     0,     0,   161,     0,     0,
       0,   162,     0,     0,   163,   164,   165,     0,   166,     0,
     167,   168,     0,     0,   169,     0,     0,   170,   171,     0,
     172,   173,     0,   174,   175,     0,   176,   177,   178,   179,
     180,   181,   182,     0,   183,   184,   185,   186,   187,   188,
     189,     0,   190,   191,   192,   193,   194,   195,   196,   197,
       0,   198,   199,     0,   200,   201,   202,   203,   204,     0,
     205,     0,     0,   206,     0,     0,   207,     0,   208,     0,
       0,   209,     0,   210,     0,     0,     0,   211,   212,   213,
       0,     0,   214,     0,     0,     0,     0,   215,   216,     0,
       0,     0,     0,   217,     0,   218,     0,     0,     0,   219,
       0,   220,   221,   222,   223,   224,     0,     0,     0,   225,
       0,     0,   226,   227,   228,     0,     0,     0,   229,     0,
     230,   231,     0,   232,   233,   234,     0,     0,   235,   236,
       0,   237,   238,   239,   240,   241,   242,   243,     0,     0,
     244,   245,   246,   247,     0,     0,   248,   249,     0,   250,
     251,   252,     0,     0,   253,     0,     0,     0,   254,     0,
     255,     0,   256,     0,   257,   258,   259,   260,   261,   262,
     263,     0,   264,     0,     0,     0,   265,   266,   267,     0,
     268,     0,     0,     0,   269,   270,     0,     0,     0,   271,
     272,   273,   274,   275,     0,     0,   276,   277,   278,     0,
     279,     0,   280,     0,     0,     0,     0,   281,   282,     0,
       0,     0,   283,     0,   284,   285,     0,   286,   287,     0,
       0,     0,   288,     0,     0,   289,   290,   291,     0,     0,
     292,     0,     0,   293,   294,     0,     0,     0,     0,     0,
     295,   296,     0,   297,     0,   298,     0,   299,   300,     0,
       0,     0,     0,     0,     0,     0,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,     0,   317,   318,   319,   320,     0,   321,   322,
     323,   324,     0,   325,   326,     0,     0,     0,     0,   327,
     328,   329,   330,   331,   332,     0,     0,   333,   334,     0,
     335,     0,   336,     0,   337,   338,   339,   340,   341,   342,
     343,   344,   345,     0,     0,   346,   347,     0,     0,   348,
     349,   350,   351,     0,     0,     0,   352,   353,     0,     0,
       0,   354,     0,   355,   356,   357,     0,   358,   359,   360,
     361,     0,   362,   363,     0,     0,     0,     0,     0,     0,
       0,     0,   364,   365,   366,     0,     0,   367,     0,   368,
       0,   369,   370,   371,   372,   373,   374,   375,   376,   377,
     378,     0,     0,   379,   380,   381,     0,   382,     0,   383,
     384,   385,   386,   387,     0,   388,   389,   390,     0,     0,
     391,     0,     0,     0,   392,   393,   394,   395,   396,     0,
       0,   397,   398,   399,   400,   401,     0,   402,   403,     0,
     404,   405,   406,     0,     0,   407,     0,   408,     0,   409,
     410,     0,   411,   412,     0,   413,     0,   414,     0,     0,
     415,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,     0,   427,   428,     0,     0,     0,   429,   430,
     431,   432,     0,     0,     0,   433,     0,     0,     0,   434,
       0,   435,   436,   437,   438,   439,   440,     0,   441,   442,
     443,   444,   445,   446,     0,     0,     0,     0,     0,     0,
     447,   448,     0,   449,     0,     0,   450,     0,     0,   451,
     452,     0,     0,     0,   453,     0,     0,   454,   455,     0,
     456,   457,   458,   459,   460,   461,     0,     0,   462,   463,
     464,   465,     0,   466,   467,     0,   468,     0,   469,   470,
     471,   472,     0,     0,   473,   474,     0,   475,   476,   477,
     478,     0,     0,     0,     0,     0,   479,   480,   481,     0,
       0,     0,   482,   483,   484,   485,     0,   486,   487,     0,
     488,   489,     0,   490,   491,     0,     0,   492,     0,     0,
     493,     0,   494,     0,   495,   496,   497,     0,     0,     0,
       0,     0,     0,   498,     0,     0,   499,     0,     0,     0,
     500,   501,   502,   503,   504,   505,   506,     0,     0,     0,
       0,     0,     0,   507,   508,     0,   509,   510,   511,     0,
       0,   512,     0,     0,     0,   142,     0,   143,   144,   145,
     146,   147,   148,  1167,     0,   149,     0,     0,     0,   150,
       0,   799,   151,     0,   152,   153,   154,   155,   156,   157,
     158,   159,     0,   160,     0,     0,     0,   161,     0,     0,
       0,   162,     0,     0,   163,   164,   165,     0,   166,     0,
     167,   168,     0,     0,   169,     0,     0,   170,   171,     0,
     172,   173,     0,   174,   175,     0,   176,   177,   178,   179,
     180,   181,   182,     0,   183,   184,   185,   186,   187,   188,
     189,     0,   190,   191,   192,   193,   194,   195,   196,   197,
       0,   198,   199,     0,   200,   201,   202,   203,   204,     0,
     205,     0,     0,   206,     0,     0,   207,     0,   208,     0,
       0,   209,     0,   210,     0,     0,     0,   211,   212,   213,
       0,     0,   214,     0,     0,     0,     0,   215,   216,     0,
       0,     0,     0,   217,     0,   218,     0,     0,     0,   219,
       0,   220,   221,   222,   223,   224,     0,     0,     0,   225,
       0,     0,   226,   227,   228,     0,     0,     0,   229,     0,
     230,   231,     0,   232,   233,   234,     0,     0,   235,   236,
       0,   237,   238,   239,   240,   241,   242,   243,     0,     0,
     244,   245,   246,   247,     0,     0,   248,   249,     0,   250,
     251,   252,     0,     0,   253,     0,     0,     0,   254,     0,
     255,     0,   256,     0,   257,   258,   259,   260,   261,   262,
     263,     0,   264,     0,     0,     0,   265,   266,   267,     0,
     268,     0,     0,     0,   269,   270,     0,     0,     0,   271,
     272,   273,   274,   275,     0,     0,   276,   277,   278,     0,
     279,     0,   280,     0,     0,     0,     0,   281,   282,     0,
    1384,     0,   283,     0,   284,   285,     0,   286,   287,     0,
       0,     0,   288,     0,     0,   289,   290,   291,     0,     0,
     292,     0,     0,   293,   294,     0,     0,     0,     0,     0,
     295,   296,     0,   297,     0,   298,     0,   299,   300,     0,
       0,     0,     0,     0,     0,     0,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,     0,   317,   318,   319,   320,     0,   321,   322,
     323,   324,     0,   325,   326,     0,     0,     0,     0,   327,
     328,   329,   330,   331,   332,     0,     0,   333,   334,     0,
     335,     0,   336,     0,   337,   338,   339,   340,   341,   342,
     343,   344,   345,     0,     0,   346,   347,     0,     0,   348,
     349,   350,   351,     0,     0,     0,   352,   353,     0,     0,
       0,   354,     0,   355,   356,   357,     0,   358,   359,   360,
     361,     0,   362,   363,     0,     0,     0,     0,     0,     0,
       0,     0,   364,   365,   366,     0,     0,   367,     0,   368,
       0,   369,   370,   371,   372,   373,   374,   375,   376,   377,
     378,     0,     0,   379,   380,   381,     0,   382,     0,   383,
     384,   385,   386,   387,     0,   388,   389,   390,     0,     0,
     391,     0,     0,     0,   392,   393,   394,   395,   396,     0,
       0,   397,   398,   399,   400,   401,     0,   402,   403,     0,
     404,   405,   406,     0,     0,   407,     0,   408,     0,   409,
     410,     0,   411,   412,     0,   413,     0,   414,     0,     0,
     415,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,     0,   427,   428,     0,     0,     0,   429,   430,
     431,   432,     0,     0,     0,   433,     0,     0,     0,   434,
       0,   435,   436,   437,   438,   439,   440,     0,   441,   442,
     443,   444,   445,   446,     0,     0,     0,     0,     0,     0,
     447,   448,     0,   449,     0,     0,   450,     0,     0,   451,
     452,     0,     0,     0,   453,     0,     0,   454,   455,     0,
     456,   457,   458,   459,   460,   461,     0,     0,   462,   463,
     464,   465,     0,   466,   467,     0,   468,     0,   469,   470,
     471,   472,     0,     0,   473,   474,     0,   475,   476,   477,
     478,     0,     0,     0,     0,     0,   479,   480,   481,     0,
       0,     0,   482,   483,   484,   485,     0,   486,   487,     0,
     488,   489,     0,   490,   491,     0,     0,   492,     0,     0,
     493,     0,   494,     0,   495,   496,   497,     0,     0,     0,
       0,     0,     0,   498,     0,     0,   499,     0,     0,     0,
     500,   501,   502,   503,   504,   505,   506,     0,     0,     0,
       0,     0,     0,   507,   508,     0,   509,   510,   511,     0,
       0,   512,     0,   142,     0,   143,   144,   145,   146,   147,
     148,     0,     0,   149,     0,     0,     0,   150,     0,     0,
     151,   560,   152,   153,   154,   155,   156,   157,   158,   159,
       0,   160,     0,     0,     0,   161,     0,     0,     0,   162,
       0,     0,   163,   164,   165,     0,   166,     0,   167,   168,
       0,     0,   169,     0,     0,   170,   171,     0,   172,   173,
       0,   174,   175,     0,   176,   177,   178,   179,   180,   181,
     182,     0,   183,   184,   185,   186,   187,   188,   189,     0,
     190,   191,   192,   193,   194,   195,   196,   197,     0,   198,
     199,     0,   200,   201,   202,   203,   204,     0,   205,     0,
       0,   206,     0,     0,   207,     0,   208,     0,     0,   209,
       0,   210,     0,     0,     0,   211,   212,   213,     0,     0,
     214,     0,     0,     0,     0,   215,   216,     0,     0,     0,
       0,   217,     0,   218,     0,     0,     0,   219,     0,   220,
     221,   222,   223,   224,     0,     0,     0,   225,     0,     0,
     226,   227,   228,     0,     0,     0,   229,     0,   230,   231,
       0,   232,   233,   234,     0,     0,   235,   236,     0,   237,
     238,   239,   240,   241,   242,   243,     0,     0,   244,   245,
     246,   247,     0,     0,   248,   249,     0,   250,   251,   252,
       0,     0,   253,     0,     0,     0,   254,     0,   255,     0,
     256,     0,   257,   258,   259,   260,   261,   262,   263,     0,
     264,     0,     0,     0,   265,   266,   267,     0,   268,     0,
       0,     0,   269,   270,     0,     0,     0,   271,   272,   273,
     274,   275,     0,     0,   276,   277,   278,     0,   279,     0,
     280,     0,     0,     0,     0,   281,   282,     0,     0,     0,
     283,     0,   284,   285,     0,   286,   287,     0,     0,     0,
     288,     0,     0,   289,   290,   291,     0,     0,   292,     0,
       0,   293,   294,     0,     0,     0,     0,     0,   295,   296,
       0,   297,     0,   298,     0,   299,   300,     0,     0,     0,
       0,     0,     0,     0,   301,   302,   303,   304,   305,   306,
     307,   308,   309,   310,   311,   312,   313,   314,   315,   316,
       0,   317,   318,   319,   320,     0,   321,   322,   323,   324,
       0,   325,   326,     0,     0,     0,     0,   327,   328,   329,
     330,   331,   332,     0,     0,   333,   334,     0,   335,     0,
     336,     0,   337,   338,   339,   340,   341,   342,   343,   344,
     345,     0,     0,   346,   347,     0,     0,   348,   349,   350,
     351,     0,     0,     0,   352,   353,     0,     0,     0,   354,
       0,   355,   356,   357,     0,   358,   359,   360,   361,     0,
     362,   363,     0,     0,     0,     0,     0,     0,     0,     0,
     364,   365,   366,     0,     0,   367,     0,   368,     0,   369,
     370,   371,   372,   373,   374,   375,   376,   377,   378,     0,
       0,   379,   380,   381,     0,   382,     0,   383,   384,   385,
     386,   387,     0,   388,   389,   390,     0,     0,   391,     0,
       0,     0,   392,   393,   394,   395,   396,     0,     0,   397,
     398,   399,   400,   401,     0,   402,   403,     0,   404,   405,
     406,     0,     0,   407,     0,   408,     0,   409,   410,     0,
     411,   412,     0,   413,     0,   414,     0,     0,   415,   416,
     417,   418,   419,   420,   421,   422,   423,   424,   425,   426,
       0,   427,   428,     0,     0,     0,   429,   430,   431,   432,
       0,     0,     0,   433,     0,     0,     0,   434,     0,   435,
     436,   437,   438,   439,   440,     0,   441,   442,   443,   444,
     445,   446,     0,     0,     0,     0,     0,     0,   447,   448,
       0,   449,     0,     0,   450,     0,     0,   451,   452,     0,
       0,     0,   453,     0,     0,   454,   455,     0,   456,   457,
     458,   459,   460,   461,     0,     0,   462,   463,   464,   465,
       0,   466,   467,     0,   468,     0,   469,   470,   471,   472,
       0,     0,   473,   474,     0,   475,   476,   477,   478,     0,
       0,     0,     0,     0,   479,   480,   481,     0,     0,     0,
     482,   483,   484,   485,     0,   486,   487,     0,   488,   489,
       0,   490,   491,     0,     0,   492,     0,     0,   493,     0,
     494,     0,   495,   496,   497,     0,     0,     0,     0,     0,
       0,   498,     0,     0,   499,     0,     0,     0,   500,   501,
     502,   503,   504,   505,   506,     0,     0,     0,     0,     0,
       0,   507,   508,     0,   509,   510,   511,     0,     0,   512,
       0,     0,     0,     0,     0,     0,  2379,   142,     0,   143,
     144,   145,   146,   147,   148,     0,     0,   149,     0,   560,
       0,   150,     0,     0,   151,     0,   152,   153,   154,   155,
     156,   157,   158,   159,     0,   160,     0,     0,     0,   161,
       0,     0,     0,   162,     0,     0,   163,   164,   165,     0,
     166,     0,   167,   168,     0,     0,   169,     0,     0,   170,
     171,     0,   172,   173,     0,   174,   175,     0,   176,   177,
     178,   179,   180,   181,   182,     0,   183,   184,   185,   186,
     187,   188,   189,     0,   190,   191,   192,   193,   194,   195,
     196,   197,     0,   198,   199,     0,   200,   201,   202,   203,
     204,     0,   205,     0,     0,   206,     0,     0,   207,     0,
     208,     0,     0,   209,     0,   210,     0,     0,     0,   211,
     212,   213,     0,     0,   214,     0,     0,     0,     0,   215,
     216,     0,     0,     0,     0,   217,     0,   218,     0,     0,
       0,   219,     0,   220,   221,   222,   223,   224,     0,     0,
       0,   225,     0,     0,   226,   227,   228,     0,     0,     0,
     229,     0,   230,   231,     0,   232,   233,   234,     0,     0,
     235,   236,     0,   237,   238,   239,   240,   241,   242,   243,
       0,     0,   244,   245,   246,   247,     0,     0,   248,   249,
       0,   250,   251,   252,     0,     0,   253,     0,     0,     0,
     254,     0,   255,     0,   256,     0,   257,   258,   259,   260,
     261,   262,   263,     0,   264,     0,     0,     0,   265,   266,
     267,     0,   268,     0,     0,     0,   269,   270,     0,     0,
       0,   271,   272,   273,   274,   275,     0,     0,   276,   277,
     278,     0,   279,     0,   280,     0,     0,     0,     0,   281,
     282,     0,     0,     0,   283,     0,   284,   285,     0,   286,
     287,     0,     0,     0,   288,     0,     0,   289,   290,   291,
       0,     0,   292,     0,     0,   293,   294,     0,     0,     0,
       0,     0,   295,   296,     0,   297,     0,   298,     0,   299,
     300,     0,     0,     0,     0,     0,     0,     0,   301,   302,
     303,   304,   305,   306,   307,   308,   309,   310,   311,   312,
     313,   314,   315,   316,     0,   317,   318,   319,   320,     0,
     321,   322,   323,   324,     0,   325,   326,     0,     0,     0,
       0,   327,   328,   329,   330,   331,   332,     0,     0,   333,
     334,     0,   335,     0,   336,     0,   337,   338,   339,   340,
     341,   342,   343,   344,   345,     0,     0,   346,   347,     0,
       0,   348,   349,   350,   351,     0,     0,     0,   352,   353,
       0,     0,     0,   354,     0,   355,   356,   357,     0,   358,
     359,   360,   361,     0,   362,   363,     0,     0,     0,     0,
       0,     0,     0,     0,   364,   365,   366,     0,     0,   367,
       0,   368,     0,   369,   370,   371,   372,   373,   374,   375,
     376,   377,   378,     0,     0,   379,   380,   381,     0,   382,
       0,   383,   384,   385,   386,   387,     0,   388,   389,   390,
       0,     0,   391,     0,     0,     0,   392,   393,   394,   395,
     396,     0,     0,   397,   398,   399,   400,   401,     0,   402,
     403,     0,   404,   405,   406,     0,     0,   407,     0,   408,
       0,   409,   410,     0,   411,   412,     0,   413,     0,   414,
       0,     0,   415,   416,   417,   418,   419,   420,   421,   422,
     423,   424,   425,   426,     0,   427,   428,     0,     0,     0,
     429,   430,   431,   432,     0,     0,     0,   433,     0,     0,
       0,   434,     0,   435,   436,   437,   438,   439,   440,     0,
     441,   442,   443,   444,   445,   446,     0,     0,     0,     0,
       0,     0,   447,   448,     0,   449,     0,     0,   450,     0,
       0,   451,   452,     0,     0,     0,   453,     0,     0,   454,
     455,     0,   456,   457,   458,   459,   460,   461,     0,     0,
     462,   463,   464,   465,     0,   466,   467,     0,   468,     0,
     469,   470,   471,   472,     0,     0,   473,   474,     0,   475,
     476,   477,   478,     0,     0,     0,     0,     0,   479,   480,
     481,     0,     0,     0,   482,   483,   484,   485,     0,   486,
     487,     0,   488,   489,     0,   490,   491,     0,     0,   492,
       0,     0,   493,     0,   494,     0,   495,   496,   497,     0,
       0,     0,     0,     0,     0,   498,     0,     0,   499,     0,
       0,     0,   500,   501,   502,   503,   504,   505,   506,     0,
       0,     0,     0,     0,     0,   507,   508,     0,   509,   510,
     511,     0,     0,   512,     0,     0,     0,   142,     0,   143,
     144,   145,   146,   147,   148,  3072,     0,   149,     0,     0,
       0,   150,     0,  3073,   151,     0,   152,   153,   154,   155,
     156,   157,   158,   159,     0,   160,     0,     0,     0,   161,
       0,     0,     0,   162,     0,     0,   163,   164,   165,     0,
     166,     0,   167,   168,     0,     0,   169,     0,     0,   170,
     171,     0,   172,   173,     0,   174,   175,     0,   176,   177,
     178,   179,   180,   181,   182,     0,   183,   184,   185,   186,
     187,   188,   189,     0,   190,   191,   192,   193,   194,   195,
     196,   197,     0,   198,   199,     0,   200,   201,   202,   203,
     204,     0,   205,     0,     0,   206,     0,     0,   207,     0,
     208,     0,     0,   209,     0,   210,     0,     0,     0,   211,
     212,   213,     0,     0,   214,     0,     0,     0,     0,   215,
     216,     0,     0,     0,     0,   217,     0,   218,     0,     0,
       0,   219,     0,   220,   221,   222,   223,   224,     0,     0,
       0,   225,     0,     0,   226,   227,   228,     0,     0,     0,
     229,     0,   230,   231,     0,   232,   233,   234,     0,     0,
     235,   236,     0,   237,   238,   239,   240,   241,   242,   243,
       0,     0,   244,   245,   246,   247,     0,     0,   248,   249,
       0,   250,   251,   252,     0,     0,   253,     0,     0,     0,
     254,     0,   255,     0,   256,     0,   257,   258,   259,   260,
     261,   262,   263,     0,   264,     0,     0,     0,   265,   266,
     267,     0,   268,     0,     0,     0,   269,   270,     0,     0,
       0,   271,   272,   273,   274,   275,     0,     0,   276,   277,
     278,     0,   279,     0,   280,     0,     0,     0,     0,   281,
     282,     0,     0,     0,   283,     0,   284,   285,     0,   286,
     287,     0,     0,     0,   288,     0,     0,   289,   290,   291,
       0,     0,   292,     0,     0,   293,   294,     0,     0,     0,
       0,     0,   295,   296,     0,   297,     0,   298,     0,   299,
     300,     0,     0,     0,     0,     0,     0,     0,   301,   302,
     303,   304,   305,   306,   307,   308,   309,   310,   311,   312,
     313,   314,   315,   316,     0,   317,   318,   319,   320,     0,
     321,   322,   323,   324,     0,   325,   326,     0,     0,     0,
       0,   327,   328,   329,   330,   331,   332,     0,     0,   333,
     334,     0,   335,     0,   336,     0,   337,   338,   339,   340,
     341,   342,   343,   344,   345,     0,     0,   346,   347,     0,
       0,   348,   349,   350,   351,     0,     0,     0,   352,   353,
       0,     0,     0,   354,     0,   355,   356,   357,     0,   358,
     359,   360,   361,     0,   362,   363,     0,     0,     0,     0,
       0,     0,     0,     0,   364,   365,   366,     0,     0,   367,
       0,   368,     0,   369,   370,   371,   372,   373,   374,   375,
     376,   377,   378,     0,     0,   379,   380,   381,     0,   382,
       0,   383,   384,   385,   386,   387,     0,   388,   389,   390,
       0,     0,   391,     0,     0,     0,   392,   393,   394,   395,
     396,     0,     0,   397,   398,   399,   400,   401,     0,   402,
     403,     0,   404,   405,   406,     0,     0,   407,     0,   408,
       0,   409,   410,     0,   411,   412,     0,   413,     0,   414,
       0,     0,   415,   416,   417,   418,   419,   420,   421,   422,
     423,   424,   425,   426,     0,   427,   428,     0,     0,     0,
     429,   430,   431,   432,     0,     0,     0,   433,     0,     0,
       0,   434,     0,   435,   436,   437,   438,   439,   440,     0,
     441,   442,   443,   444,   445,   446,     0,     0,     0,     0,
       0,     0,   447,   448,     0,   449,     0,     0,   450,     0,
       0,   451,   452,     0,     0,     0,   453,     0,     0,   454,
     455,     0,   456,   457,   458,   459,   460,   461,     0,     0,
     462,   463,   464,   465,     0,   466,   467,     0,   468,     0,
     469,   470,   471,   472,     0,     0,   473,   474,     0,   475,
     476,   477,   478,     0,     0,     0,     0,     0,   479,   480,
     481,     0,     0,     0,   482,   483,   484,   485,     0,   486,
     487,     0,   488,   489,     0,   490,   491,     0,     0,   492,
       0,     0,   493,     0,   494,     0,   495,   496,   497,     0,
       0,     0,     0,     0,     0,   498,     0,     0,   499,     0,
       0,     0,   500,   501,   502,   503,   504,   505,   506,     0,
       0,     0,     0,     0,     0,   507,   508,     0,   509,   510,
     511,     0,     0,   512,     0,     0,     0,   142,     0,   143,
     144,   145,   146,   147,   148,     0,     0,   149,     0,     0,
       0,   150,  4769,   799,   151,     0,   152,   153,   154,   155,
     156,   157,   158,   159,     0,   160,     0,     0,     0,   161,
       0,     0,     0,   162,     0,     0,   163,   164,   165,     0,
     166,     0,   167,   168,     0,     0,   169,     0,     0,   170,
     171,     0,   172,   173,     0,   174,   175,     0,   176,   177,
     178,   179,   180,   181,   182,     0,   183,   184,   185,   186,
     187,   188,   189,     0,   190,   191,   192,   193,   194,   195,
     196,   197,     0,   198,   199,     0,   200,   201,   202,   203,
     204,     0,   205,     0,     0,   206,     0,     0,   207,     0,
     208,     0,     0,   209,     0,   210,     0,     0,     0,   211,
     212,   213,     0,     0,   214,     0,     0,     0,     0,   215,
     216,     0,     0,     0,     0,   217,     0,   218,     0,     0,
       0,   219,     0,   220,   221,   222,   223,   224,     0,     0,
       0,   225,     0,     0,   226,   227,   228,     0,     0,     0,
     229,     0,   230,   231,     0,   232,   233,   234,     0,     0,
     235,   236,     0,   237,   238,   239,   240,   241,   242,   243,
       0,     0,   244,   245,   246,   247,     0,     0,   248,   249,
       0,   250,   251,   252,     0,     0,   253,     0,     0,     0,
     254,     0,   255,     0,   256,     0,   257,   258,   259,   260,
     261,   262,   263,     0,   264,     0,     0,     0,   265,   266,
     267,     0,   268,     0,     0,     0,   269,   270,     0,     0,
       0,   271,   272,   273,   274,   275,     0,     0,   276,   277,
     278,     0,   279,     0,   280,     0,     0,     0,     0,   281,
     282,     0,     0,     0,   283,     0,   284,   285,     0,   286,
     287,     0,     0,     0,   288,     0,     0,   289,   290,   291,
       0,     0,   292,     0,     0,   293,   294,     0,     0,     0,
       0,     0,   295,   296,     0,   297,     0,   298,     0,   299,
     300,     0,     0,     0,     0,     0,     0,     0,   301,   302,
     303,   304,   305,   306,   307,   308,   309,   310,   311,   312,
     313,   314,   315,   316,     0,   317,   318,   319,   320,     0,
     321,   322,   323,   324,     0,   325,   326,     0,     0,     0,
       0,   327,   328,   329,   330,   331,   332,     0,     0,   333,
     334,     0,   335,     0,   336,     0,   337,   338,   339,   340,
     341,   342,   343,   344,   345,     0,     0,   346,   347,     0,
       0,   348,   349,   350,   351,     0,     0,     0,   352,   353,
       0,     0,     0,   354,     0,   355,   356,   357,     0,   358,
     359,   360,   361,     0,   362,   363,     0,     0,     0,     0,
       0,     0,     0,     0,   364,   365,   366,     0,     0,   367,
       0,   368,     0,   369,   370,   371,   372,   373,   374,   375,
     376,   377,   378,     0,     0,   379,   380,   381,     0,   382,
       0,   383,   384,   385,   386,   387,     0,   388,   389,   390,
       0,     0,   391,     0,     0,     0,   392,   393,   394,   395,
     396,     0,     0,   397,   398,   399,   400,   401,     0,   402,
     403,     0,   404,   405,   406,     0,     0,   407,     0,   408,
       0,   409,   410,     0,   411,   412,     0,   413,     0,   414,
       0,     0,   415,   416,   417,   418,   419,   420,   421,   422,
     423,   424,   425,   426,     0,   427,   428,     0,     0,     0,
     429,   430,   431,   432,     0,     0,     0,   433,     0,     0,
       0,   434,     0,   435,   436,   437,   438,   439,   440,     0,
     441,   442,   443,   444,   445,   446,     0,     0,     0,     0,
       0,     0,   447,   448,     0,   449,     0,     0,   450,     0,
       0,   451,   452,     0,     0,     0,   453,     0,     0,   454,
     455,     0,   456,   457,   458,   459,   460,   461,     0,     0,
     462,   463,   464,   465,     0,   466,   467,     0,   468,     0,
     469,   470,   471,   472,     0,     0,   473,   474,     0,   475,
     476,   477,   478,     0,     0,     0,     0,     0,   479,   480,
     481,     0,     0,     0,   482,   483,   484,   485,     0,   486,
     487,     0,   488,   489,     0,   490,   491,     0,     0,   492,
       0,     0,   493,     0,   494,     0,   495,   496,   497,     0,
       0,     0,     0,     0,     0,   498,     0,     0,   499,     0,
       0,     0,   500,   501,   502,   503,   504,   505,   506,     0,
       0,     0,     0,     0,     0,   507,   508,     0,   509,   510,
     511,     0,     0,   512,     0,   142,     0,   143,   144,   145,
     146,   147,   148,     0,     0,   149,     0,     0,     0,   150,
       0,     0,   151,   560,   152,   153,   154,   155,   156,   157,
     158,   159,     0,   160,     0,     0,     0,   161,     0,     0,
       0,   162,     0,     0,   163,   164,   165,     0,   166,     0,
     167,   168,     0,     0,   169,     0,     0,   170,   171,     0,
     172,   173,     0,   174,   175,     0,   176,   177,   178,   179,
     180,   181,   182,     0,   183,   184,   185,   186,   187,   188,
     189,     0,   190,   191,   192,   193,   194,   195,   196,   197,
       0,   198,   199,     0,   200,   201,   202,   203,   204,     0,
     205,     0,     0,   206,     0,     0,   207,     0,   208,     0,
       0,   209,     0,   210,     0,     0,     0,   211,   212,   213,
       0,     0,   214,     0,     0,     0,     0,   215,   216,     0,
       0,     0,     0,   217,     0,   218,     0,     0,     0,   219,
       0,   220,   221,   222,   223,   224,     0,     0,     0,   225,
       0,     0,   226,   227,   228,     0,     0,     0,   229,     0,
     230,   231,     0,   232,   233,   234,     0,     0,   235,   236,
       0,   237,   238,   239,   240,   241,   242,   243,     0,     0,
     244,   245,   631,   247,     0,     0,   248,   249,     0,   250,
     251,   252,     0,     0,   253,     0,     0,     0,   254,     0,
     255,     0,   256,     0,   257,   258,   259,   260,   261,   262,
     263,     0,   264,     0,     0,     0,   265,   266,   267,     0,
     268,     0,     0,     0,   269,   270,     0,     0,     0,   271,
     272,   273,   274,   275,     0,     0,   276,   277,   278,     0,
     279,     0,   280,     0,     0,     0,     0,   281,   282,     0,
       0,     0,   283,     0,   284,   285,     0,   286,   287,     0,
       0,     0,   288,     0,     0,   289,   290,   291,     0,     0,
     292,     0,     0,   293,   294,     0,     0,     0,     0,     0,
     295,   296,     0,   297,     0,   298,     0,   299,   300,     0,
       0,     0,     0,     0,     0,     0,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,     0,   317,   318,   319,   320,     0,   321,   322,
     323,   324,     0,   325,   326,     0,     0,     0,     0,   327,
     328,   329,   330,   331,   332,     0,     0,   333,   334,     0,
     335,     0,   336,     0,   337,   338,   339,   340,   341,   342,
     343,   344,   345,     0,     0,   346,   347,     0,     0,   348,
     349,   350,   351,     0,     0,     0,   352,   353,     0,     0,
       0,   354,     0,   355,   356,   357,     0,   358,   359,   360,
     361,     0,   362,   363,     0,     0,     0,     0,     0,     0,
       0,     0,   364,   365,   366,     0,     0,   367,     0,   368,
       0,   632,   370,   371,   372,   373,   374,   375,   376,   377,
     378,     0,     0,   379,   380,   381,     0,   382,     0,   383,
     384,   385,   386,   387,     0,   388,   389,   390,     0,     0,
     391,     0,     0,     0,   392,   393,   394,   395,   396,     0,
       0,   397,   398,   399,   400,   401,     0,   402,   403,     0,
     404,   405,   406,     0,     0,   407,     0,   408,     0,   409,
     410,     0,   411,   412,     0,   413,     0,   414,     0,     0,
     415,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,     0,   427,   428,     0,     0,     0,   429,   430,
     431,   432,     0,     0,     0,   433,     0,     0,     0,   434,
       0,   435,   436,   437,   438,   439,   440,     0,   441,   442,
     443,   444,   445,   446,     0,     0,     0,     0,     0,     0,
     447,   448,     0,   449,     0,     0,   450,     0,     0,   451,
     452,     0,     0,     0,   453,     0,     0,   454,   455,     0,
     456,   457,   458,   459,   460,   461,     0,     0,   462,   463,
     464,   465,     0,   466,   467,     0,   468,     0,   469,   470,
     471,   472,     0,     0,   473,   474,     0,   475,   476,   477,
     478,     0,     0,     0,     0,     0,   479,   480,   481,     0,
       0,     0,   482,   483,   484,   485,     0,   486,   487,     0,
     488,   489,     0,   490,   491,     0,     0,   492,     0,     0,
     493,     0,   494,     0,   495,   496,   497,     0,     0,     0,
       0,     0,     0,   498,     0,     0,   499,     0,     0,     0,
     500,   501,   502,   503,   504,   505,   506,     0,     0,     0,
       0,     0,     0,   507,   508,     0,   509,   510,   511,     0,
       0,   512,     0,   142,     0,   143,   144,   145,   146,   147,
     148,     0,     0,   149,     0,     0,     0,   150,     0,     0,
     151,   560,   152,   153,   154,   155,   156,   157,   158,   159,
       0,   160,     0,     0,     0,   161,     0,     0,     0,   162,
       0,     0,   163,   164,   165,     0,   166,     0,   167,   168,
       0,     0,   169,     0,     0,   170,   171,     0,   172,   173,
       0,   174,   175,     0,   176,   177,   178,   179,   180,   181,
     182,     0,   183,   184,   185,   186,   187,   188,   189,     0,
     190,   191,   192,   193,   194,   195,   196,   197,     0,   198,
     199,     0,   200,   201,   202,   203,   204,     0,   205,     0,
       0,   206,     0,     0,   207,     0,   208,     0,     0,   209,
       0,   210,     0,     0,     0,   211,   212,   213,     0,     0,
     214,     0,     0,     0,     0,   215,   216,     0,     0,     0,
       0,   217,     0,   218,     0,     0,     0,   219,     0,   220,
     221,   222,   223,   224,     0,     0,     0,   225,     0,     0,
     226,   227,   228,     0,     0,     0,   229,     0,   230,   231,
       0,   232,   233,   234,     0,     0,   235,   236,     0,   237,
     238,   239,   240,   241,   242,   243,     0,     0,   244,   245,
     246,   247,     0,     0,   248,   249,     0,   250,   251,   252,
       0,     0,   253,     0,     0,     0,   254,     0,   255,     0,
     256,     0,   257,   258,   259,   260,   261,   262,   263,     0,
     264,     0,     0,     0,   265,   266,   267,     0,   268,     0,
       0,     0,   269,   270,     0,     0,     0,   271,   272,   273,
     274,   275,     0,     0,   276,   277,   278,     0,   279,     0,
     280,     0,     0,     0,     0,   281,   282,     0,     0,     0,
     283,     0,   284,   285,     0,   286,   287,     0,     0,     0,
     288,     0,     0,   289,   290,   291,     0,     0,   292,     0,
       0,   293,   294,     0,     0,     0,     0,     0,   295,   296,
       0,   297,     0,   298,     0,   299,   300,     0,     0,     0,
       0,     0,     0,     0,   301,   302,   303,   304,   305,   306,
     307,   308,   309,   310,   311,   312,   313,   314,   315,   316,
       0,   317,   318,   319,   320,     0,   321,   322,   323,   324,
       0,   325,   326,     0,     0,     0,     0,   327,   328,   329,
     330,   331,   332,     0,     0,   333,   334,     0,   335,     0,
     336,     0,   337,   338,   339,   340,   341,   342,   343,   344,
     345,     0,     0,   346,   347,     0,     0,   348,   349,   350,
     351,     0,     0,     0,   352,   353,     0,     0,     0,   354,
       0,   355,   356,   357,     0,   358,   359,   360,   361,     0,
     362,   363,     0,     0,     0,     0,     0,     0,     0,     0,
     364,   365,   366,     0,     0,   367,     0,   368,     0,   369,
     370,   371,   372,   373,   374,   375,   376,   377,   378,     0,
       0,   379,   380,   381,     0,   382,     0,   383,   384,   385,
     386,   387,     0,   388,   389,   390,     0,     0,   391,     0,
       0,     0,   392,   393,   394,   395,   396,     0,     0,   397,
     398,   399,   400,   401,     0,   402,   403,     0,   404,   405,
     406,     0,     0,   407,     0,   408,     0,   409,   410,     0,
     411,   412,     0,   413,     0,   414,     0,     0,   415,   416,
     417,   418,   419,   420,   421,   422,   423,   424,   425,   426,
       0,   427,   428,     0,     0,     0,   429,   430,   431,   432,
       0,     0,     0,   433,     0,     0,     0,   434,     0,   435,
     436,   437,   438,   439,   440,     0,   441,   442,   443,   444,
     445,   446,     0,     0,     0,     0,     0,     0,   447,   448,
       0,   449,     0,     0,   450,     0,     0,   451,   452,     0,
       0,     0,   453,     0,     0,   454,   455,     0,   456,   457,
     458,   459,   460,   461,     0,     0,   462,   463,   464,   465,
       0,   466,   467,     0,   468,     0,   469,   470,   471,   472,
       0,     0,   473,   474,     0,   475,   476,   477,   478,     0,
       0,     0,     0,     0,   479,   480,   481,     0,     0,     0,
     482,   483,   484,   485,     0,   486,   487,     0,   488,   489,
       0,   490,   491,     0,     0,   492,     0,     0,   493,     0,
     494,     0,   495,   496,   497,     0,     0,     0,     0,     0,
       0,   498,     0,     0,   499,     0,     0,     0,   500,   501,
     502,   503,   504,   505,   506,     0,     0,     0,     0,     0,
       0,   507,   508,     0,   509,   510,   511,     0,     0,   512,
       0,   142,     0,   143,   144,   145,   146,   147,   148,     0,
       0,   149,     0,     0,     0,   150,     0,     0,   151,   799,
     152,   153,   154,   155,   156,   157,   158,   159,     0,   160,
       0,     0,     0,   161,     0,     0,     0,   162,     0,     0,
     163,   164,   165,     0,   166,     0,   167,   168,     0,     0,
     169,     0,     0,   170,   171,     0,   172,   173,     0,   174,
     175,     0,   176,   177,   178,   179,   180,   181,   182,     0,
     183,   184,   185,   186,   187,   188,   189,     0,   190,   191,
     192,   193,   194,   195,   196,   197,     0,   198,   199,     0,
     200,   201,   202,   203,   204,     0,   205,     0,     0,   206,
       0,     0,   207,     0,   208,     0,     0,   209,     0,   210,
       0,     0,     0,   211,   212,   213,     0,     0,   214,     0,
       0,     0,     0,   215,   216,     0,     0,     0,     0,   217,
       0,   218,     0,     0,     0,   219,     0,   220,   221,   222,
     223,   224,     0,     0,     0,   225,     0,     0,   226,   227,
     228,     0,     0,     0,   229,     0,   230,   231,     0,   232,
     233,   234,     0,     0,   235,   236,     0,   237,   238,   239,
     240,   241,   242,   243,     0,     0,   244,   245,   246,   247,
       0,     0,   248,   249,     0,   250,   251,   252,     0,     0,
     253,     0,     0,     0,   254,     0,   255,     0,   256,     0,
     257,   258,   259,   260,   261,   262,   263,     0,   264,     0,
       0,     0,   265,   266,   267,     0,   268,     0,     0,     0,
     269,   270,     0,     0,     0,   271,   272,   273,   274,   275,
       0,     0,   276,   277,   278,     0,   279,     0,   280,     0,
       0,     0,     0,   281,   282,     0,     0,     0,   283,     0,
     284,   285,     0,   286,   287,     0,     0,     0,   288,     0,
       0,   289,   290,   291,     0,     0,   292,     0,     0,   293,
     294,     0,     0,     0,     0,     0,   295,   296,     0,   297,
       0,   298,     0,   299,   300,     0,     0,     0,     0,     0,
       0,     0,   301,   302,   303,   304,   305,   306,   307,   308,
     309,   310,   311,   312,   313,   314,   315,   316,     0,   317,
     318,   319,   320,     0,   321,   322,   323,   324,     0,   325,
     326,     0,     0,     0,     0,   327,   328,   329,   330,   331,
     332,     0,     0,   333,   334,     0,   335,     0,   336,     0,
     337,   338,   339,   340,   341,   342,   343,   344,   345,     0,
       0,   346,   347,     0,     0,   348,   349,   350,   351,     0,
       0,     0,   352,   353,     0,     0,     0,   354,     0,   355,
     356,   357,     0,   358,   359,   360,   361,     0,   362,   363,
       0,     0,     0,     0,     0,     0,     0,     0,   364,   365,
     366,     0,     0,   367,     0,   368,     0,   369,   370,   371,
     372,   373,   374,   375,   376,   377,   378,     0,     0,   379,
     380,   381,     0,   382,     0,   383,   384,   385,   386,   387,
       0,   388,   389,   390,     0,     0,   391,     0,     0,     0,
     392,   393,   394,   395,   396,     0,     0,   397,   398,   399,
     400,   401,     0,   402,   403,     0,   404,   405,   406,     0,
       0,   407,     0,   408,     0,   409,   410,     0,   411,   412,
       0,   413,     0,   414,     0,     0,   415,   416,   417,   418,
     419,   420,   421,   422,   423,   424,   425,   426,     0,   427,
     428,     0,     0,     0,   429,   430,   431,   432,     0,     0,
       0,   433,     0,     0,     0,   434,     0,   435,   436,   437,
     438,   439,   440,     0,   441,   442,   443,   444,   445,   446,
       0,     0,     0,     0,     0,     0,   447,   448,     0,   449,
       0,     0,   450,     0,     0,   451,   452,     0,     0,     0,
     453,     0,     0,   454,   455,     0,   456,   457,   458,   459,
     460,   461,     0,     0,   462,   463,   464,   465,     0,   466,
     467,     0,   468,     0,   469,   470,   471,   472,     0,     0,
     473,   474,     0,   475,   476,   477,   478,     0,     0,     0,
       0,     0,   479,   480,   481,     0,     0,     0,   482,   483,
     484,   485,     0,   486,   487,     0,   488,   489,     0,   490,
     491,     0,     0,   492,     0,     0,   493,     0,   494,     0,
     495,   496,   497,     0,     0,     0,     0,     0,     0,   498,
       0,     0,   499,     0,     0,     0,   500,   501,   502,   503,
     504,   505,   506,     0,     0,     0,     0,     0,     0,   507,
     508,     0,   509,   510,   511,     0,     0,   512,     0,   142,
       0,   143,   144,   145,   146,   147,   148,     0,     0,   149,
       0,     0,     0,   150,     0,     0,   151,  3073,   152,   153,
     154,   155,   156,   157,   158,   159,     0,   160,     0,     0,
       0,   161,     0,     0,     0,   162,     0,     0,   163,   164,
     165,     0,   166,     0,   167,   168,     0,     0,   169,     0,
       0,   170,   171,     0,   172,   941,   942,   174,   175,     0,
     176,   177,   178,   179,   180,   181,   182,     0,   183,   184,
     185,   186,   187,   188,   189,     0,   190,   191,   192,   193,
     194,   195,   196,   197,     0,   198,   199,     0,   200,   201,
     202,   203,   204,     0,   205,     0,     0,   206,     0,     0,
     207,     0,   208,     0,     0,   209,     0,   210,     0,     0,
       0,   211,   212,   213,     0,     0,   214,     0,     0,     0,
       0,   215,   216,     0,     0,     0,   943,   217,     0,   218,
       0,     0,     0,   219,     0,   220,   221,   222,   223,   224,
       0,     0,     0,   225,     0,     0,   226,   227,   228,     0,
       0,     0,   229,     0,   230,   231,     0,   232,   233,   234,
       0,     0,   235,   236,     0,   237,   238,   239,   240,   241,
     242,   243,     0,     0,   244,   245,   246,   247,     0,     0,
     248,   249,     0,   250,   251,   252,     0,     0,   253,     0,
       0,     0,   254,     0,   255,     0,   256,     0,   257,   258,
     259,   260,   261,   262,   944,     0,   264,     0,     0,     0,
     265,   266,   267,     0,   268,     0,     0,     0,   269,   270,
       0,     0,     0,   271,   272,   273,   274,   275,     0,     0,
     276,   277,   278,     0,   279,     0,   280,     0,     0,     0,
       0,   281,   282,     0,     0,     0,   283,     0,   284,   285,
       0,   286,   287,     0,     0,     0,   288,     0,     0,   289,
     290,   291,     0,     0,   292,     0,     0,   293,   294,     0,
       0,     0,     0,     0,   295,   296,     0,   945,     0,   298,
       0,   299,   300,     0,     0,     0,     0,     0,     0,     0,
     301,   302,   303,   304,   305,   306,   307,   308,   309,   310,
     311,   312,   313,   314,   315,   316,     0,   317,   318,   319,
     320,     0,   321,   322,   323,   324,     0,   325,   326,     0,
       0,     0,     0,   327,   328,   329,   330,   331,   332,     0,
       0,   333,   334,     0,   335,     0,   336,     0,   337,   338,
     339,   340,   341,   342,   946,   344,   345,     0,     0,   346,
     347,     0,     0,   348,   349,   350,   351,     0,     0,     0,
     352,   353,     0,     0,     0,   354,     0,   355,   356,   357,
       0,   358,   359,   360,   361,     0,   362,   363,     0,     0,
       0,     0,     0,     0,     0,     0,   364,   365,   366,     0,
       0,   367,     0,   368,     0,   369,   370,   947,   372,   373,
     374,   375,   376,   377,   378,     0,     0,   379,   380,   381,
       0,   382,     0,   383,   384,   385,   386,   387,     0,   388,
     389,   390,     0,     0,   391,     0,     0,     0,   392,   393,
     394,   395,   396,     0,     0,   397,   398,   399,   400,   401,
       0,   402,   403,     0,   404,   405,   406,     0,     0,   407,
       0,   408,     0,   409,   410,     0,   411,   412,     0,   413,
       0,   414,     0,     0,   948,   416,   417,   418,   419,   420,
     421,   422,   423,   424,   425,   426,     0,   427,   428,     0,
       0,     0,   429,   430,   949,   432,     0,     0,     0,   433,
       0,     0,     0,   434,     0,   435,   436,   437,   438,   439,
     440,     0,   441,   442,   443,   444,   445,   446,     0,     0,
       0,     0,     0,     0,   447,   448,     0,   449,     0,     0,
     450,     0,     0,   451,   452,     0,     0,     0,   453,     0,
       0,   454,   455,     0,   456,   457,   458,   459,   460,   461,
       0,     0,   462,   463,   464,   465,     0,   466,   467,     0,
     468,     0,   469,   470,   471,   472,     0,     0,   473,   474,
       0,   475,   476,   477,   478,     0,     0,     0,     0,     0,
     950,   480,   481,     0,     0,     0,   482,   483,   484,   485,
       0,   486,   487,     0,   488,   489,     0,   490,   491,     0,
       0,   492,     0,     0,   493,     0,   494,     0,   495,   496,
     497,     0,     0,     0,     0,     0,     0,   498,     0,     0,
     499,     0,     0,     0,   500,   501,   502,   503,   504,   505,
     506,     0,     0,     0,     0,     0,     0,   507,   508,     0,
     509,   510,   511,     0,     0,   512,   142,     0,   143,   144,
     145,   146,   147,   148,     0,     0,   149,     0,     0,     0,
     150,     0,     0,   151,   951,   152,   153,   154,   155,   156,
     157,   158,   159,     0,   160,     0,     0,     0,   161,     0,
       0,     0,   162,     0,     0,   163,   164,   165,     0,   166,
       0,   167,   168,     0,     0,   169,     0,     0,   170,   171,
       0,   172,   173,     0,   174,   175,     0,   176,   177,   178,
     179,   180,   181,   182,     0,   183,   184,   185,   186,   187,
     188,   189,     0,   190,   191,   192,   193,   194,   195,   196,
     197,     0,   198,   199,     0,   200,   201,   202,   203,   204,
       0,   205,     0,     0,   206,     0,     0,   207,     0,   208,
       0,     0,   209,     0,   210,     0,     0,     0,   211,   212,
     213,     0,     0,   214,     0,     0,     0,     0,   215,   216,
       0,     0,     0,     0,   217,     0,   218,     0,     0,     0,
     219,     0,   220,   221,   222,   223,   224,     0,     0,     0,
     225,     0,     0,   226,   227,   228,     0,     0,     0,   229,
       0,   230,   231,     0,   232,   233,   234,     0,     0,   235,
     236,     0,   237,   238,   239,   240,   241,   242,   243,     0,
       0,   244,   245,   246,   247,     0,     0,   248,   249,     0,
     250,   251,   252,     0,     0,   253,     0,     0,     0,   254,
       0,   255,     0,   256,     0,   257,   258,   259,   260,   261,
     262,   263,     0,   264,     0,     0,     0,   265,   266,   267,
       0,   268,     0,     0,     0,   269,   270,     0,     0,     0,
     271,   272,   273,   274,   275,     0,     0,   276,   277,   278,
       0,   279,     0,   280,     0,     0,     0,     0,   281,   282,
       0,     0,     0,   283,     0,   284,   285,     0,   286,   287,
       0,     0,     0,   288,     0,     0,   289,   290,   291,     0,
       0,   292,     0,     0,   293,   294,   643,     0,     0,     0,
       0,   295,   296,     0,   297,     0,   298,     0,   299,   300,
       0,     0,     0,     0,     0,     0,     0,   301,   302,   303,
     304,   305,   306,   307,   308,   309,   310,   311,   312,   313,
     314,   315,   316,     0,   317,   318,   319,   320,     0,   321,
     322,   323,   324,     0,   325,   326,     0,     0,     0,     0,
     327,   328,   329,   330,   331,   332,     0,     0,   333,   334,
       0,   335,     0,   336,     0,   337,   338,   339,   340,   341,
     342,   343,   344,   345,     0,     0,   346,   347,     0,     0,
     348,   349,   350,   351,     0,     0,     0,   352,   353,     0,
       0,     0,   354,     0,   355,   356,   357,     0,   358,   359,
     360,   361,     0,   362,   363,     0,     0,     0,     0,     0,
       0,     0,     0,   364,   365,   366,     0,     0,   367,     0,
     368,     0,   369,   370,   371,   372,   373,   374,   375,   376,
     377,   378,     0,     0,   379,   380,   381,     0,   382,     0,
     383,   384,   385,   386,   387,     0,   388,   389,   390,     0,
       0,   391,     0,     0,     0,   392,   393,   394,   395,   396,
       0,     0,   397,   398,   399,   400,   401,     0,   402,   403,
       0,   404,   405,   406,     0,     0,   407,     0,   408,     0,
     409,   410,     0,   411,   412,     0,   413,     0,   414,     0,
       0,   415,   416,   417,   418,   419,   420,   421,   422,   423,
     424,   425,   426,     0,   427,   428,     0,     0,     0,   429,
     430,   431,   432,     0,     0,     0,   433,     0,     0,     0,
     434,     0,   435,   436,   437,   438,   439,   440,     0,   441,
     442,   443,   444,   445,   446,     0,     0,     0,     0,     0,
       0,   447,   448,     0,   449,     0,     0,   450,     0,     0,
     451,   452,     0,     0,     0,   453,     0,     0,   454,   455,
       0,   456,   457,   458,   459,   460,   461,     0,     0,   462,
     463,   464,   465,     0,   466,   467,     0,   468,     0,   469,
     470,   471,   472,     0,   139,   473,   474,     0,   475,   476,
     477,   478,     0,     0,     0,     0,     0,   479,   480,   481,
       0,     0,     0,   482,   483,   484,   485,     0,   486,   487,
       0,   488,   489,     0,   490,   491,     0,     0,   492,     0,
       0,   493,     0,   494,     0,   495,   496,   497,     0,     0,
       0,     0,     0,     0,   498,     0,     0,   499,     0,     0,
       0,   500,   501,   502,   503,   504,   505,   506,     0,     0,
       0,     0,     0,     0,   507,   508,     0,   509,   510,   511,
       0,     0,   512,   142,     0,   143,   144,   145,   146,   147,
     148,     0,     0,   149,     0,     0,     0,   150,     0,     0,
     151,  1437,   152,   153,   154,   155,   156,   157,   158,   159,
       0,   160,     0,     0,     0,   161,     0,     0,     0,   162,
       0,     0,   163,   164,   165,     0,   166,     0,   167,   168,
       0,     0,   169,     0,     0,   170,   171,     0,   172,   173,
       0,   174,   175,     0,   176,   177,   178,   179,   180,   181,
     182,     0,   183,   184,   185,   186,   187,   188,   189,     0,
     190,   191,   192,   193,   194,   195,   196,   197,     0,   198,
     199,     0,   200,   201,   202,   203,   204,     0,   205,     0,
       0,   206,     0,     0,   207,     0,   208,     0,     0,   209,
       0,   210,     0,     0,     0,   211,   212,   213,     0,     0,
     214,     0,     0,     0,     0,   215,   216,     0,     0,     0,
       0,   217,     0,   218,     0,     0,     0,   219,     0,   220,
     221,   222,   223,   224,     0,     0,     0,   225,     0,     0,
     226,   227,   228,     0,     0,     0,   229,     0,   230,   231,
       0,   232,   233,   234,     0,     0,   235,   236,     0,   237,
     238,   239,   240,   241,   242,   243,     0,     0,   244,   245,
     246,   247,     0,     0,   248,   249,     0,   250,   251,   252,
       0,     0,   253,     0,     0,     0,   254,     0,   255,     0,
     256,     0,   257,   258,   259,   260,   261,   262,   263,     0,
     264,     0,     0,     0,   265,   266,   267,     0,   268,     0,
       0,     0,   269,   270,     0,     0,     0,   271,   272,   273,
     274,   275,     0,     0,   276,   277,   278,     0,   279,     0,
     280,     0,     0,     0,     0,   281,   282,     0,     0,     0,
     283,     0,   284,   285,     0,   286,   287,     0,     0,     0,
     288,     0,     0,   289,   290,   291,     0,     0,   292,     0,
       0,   293,   294,   643,     0,     0,     0,     0,   295,   296,
       0,   297,     0,   298,     0,   299,   300,     0,     0,     0,
       0,     0,     0,     0,   301,   302,   303,   304,   305,   306,
     307,   308,   309,   310,   311,   312,   313,   314,   315,   316,
       0,   317,   318,   319,   320,     0,   321,   322,   323,   324,
       0,   325,   326,     0,     0,     0,     0,   327,   328,   329,
     330,   331,   332,     0,     0,   333,   334,     0,   335,     0,
     336,     0,   337,   338,   339,   340,   341,   342,   343,   344,
     345,     0,     0,   346,   347,     0,     0,   348,   349,   350,
     351,     0,     0,     0,   352,   353,     0,     0,     0,   354,
       0,   355,   356,   357,     0,   358,   359,   360,   361,     0,
     362,   363,     0,     0,     0,     0,     0,     0,     0,     0,
     364,   365,   366,     0,     0,   367,     0,   368,     0,   369,
     370,   371,   372,   373,   374,   375,   376,   377,   378,     0,
       0,   379,   380,   381,     0,   382,     0,   383,   384,   385,
     386,   387,     0,   388,   389,   390,     0,     0,   391,     0,
       0,     0,   392,   393,   394,   395,   396,     0,     0,   397,
     398,   399,   400,   401,     0,   402,   403,     0,   404,   405,
     406,     0,     0,   407,     0,   408,     0,   409,   410,     0,
     411,   412,     0,   413,     0,   414,     0,     0,   415,   416,
     417,   418,   419,   420,   421,   422,   423,   424,   425,   426,
       0,   427,   428,     0,     0,     0,   429,   430,   431,   432,
       0,     0,     0,   433,     0,     0,     0,   434,     0,   435,
     436,   437,   438,   439,   440,     0,   441,   442,   443,   444,
     445,   446,     0,     0,     0,     0,     0,     0,   447,   448,
       0,   449,     0,     0,   450,     0,     0,   451,   452,     0,
       0,     0,   453,     0,     0,   454,   455,     0,   456,   457,
     458,   459,   460,   461,     0,     0,   462,   463,   464,   465,
       0,   466,   467,     0,   468,     0,   469,   470,   471,   472,
       0,   139,   473,   474,     0,   475,   476,   477,   478,     0,
       0,     0,     0,     0,   479,   480,   481,     0,     0,     0,
     482,   483,   484,   485,     0,   486,   487,     0,   488,   489,
       0,   490,   491,     0,     0,   492,     0,     0,   493,     0,
     494,     0,   495,   496,   497,     0,     0,     0,     0,     0,
       0,   498,     0,     0,   499,     0,     0,     0,   500,   501,
     502,   503,   504,   505,   506,     0,     0,     0,     0,     0,
       0,   507,   508,     0,   509,   510,   511,     0,     0,   512,
     142,     0,   143,   144,   145,   146,   147,   148,     0,     0,
     149,     0,     0,     0,   150,     0,     0,   151,  1783,   152,
     153,   154,   155,   156,   157,   158,   159,     0,   160,     0,
       0,     0,   161,     0,     0,     0,   162,     0,     0,   163,
     164,   165,     0,   166,     0,   167,   168,     0,     0,   169,
       0,     0,   170,   171,     0,   172,   941,   942,   174,   175,
       0,   176,   177,   178,   179,   180,   181,   182,     0,   183,
     184,   185,   186,   187,   188,   189,     0,   190,   191,   192,
     193,   194,   195,   196,   197,     0,   198,   199,     0,   200,
     201,   202,   203,   204,     0,   205,     0,     0,   206,     0,
       0,   207,     0,   208,     0,     0,   209,     0,   210,     0,
       0,     0,   211,   212,   213,     0,     0,   214,     0,     0,
       0,     0,   215,   216,     0,     0,     0,   943,   217,     0,
     218,     0,     0,     0,   219,     0,   220,   221,   222,   223,
     224,     0,     0,     0,   225,     0,     0,   226,   227,   228,
       0,     0,     0,   229,     0,   230,   231,     0,   232,   233,
     234,     0,     0,   235,   236,     0,   237,   238,   239,   240,
     241,   242,   243,     0,     0,   244,   245,   246,   247,     0,
       0,   248,   249,     0,   250,   251,   252,     0,     0,   253,
       0,     0,     0,   254,     0,   255,     0,   256,     0,   257,
     258,   259,   260,   261,   262,   944,     0,   264,     0,     0,
       0,   265,   266,   267,     0,   268,     0,     0,     0,   269,
     270,     0,     0,     0,   271,   272,   273,   274,   275,     0,
       0,   276,   277,   278,     0,   279,     0,   280,     0,     0,
       0,     0,   281,   282,     0,     0,     0,   283,     0,   284,
     285,     0,   286,   287,     0,     0,     0,   288,     0,     0,
     289,   290,   291,     0,     0,   292,     0,     0,   293,   294,
       0,     0,     0,     0,     0,   295,   296,     0,   945,     0,
     298,     0,   299,   300,     0,     0,     0,     0,     0,     0,
       0,   301,   302,   303,   304,   305,   306,   307,   308,   309,
     310,   311,   312,   313,   314,   315,   316,     0,   317,   318,
     319,   320,     0,   321,   322,   323,   324,     0,   325,   326,
       0,     0,     0,     0,   327,   328,   329,   330,   331,   332,
       0,     0,   333,   334,     0,   335,     0,   336,     0,   337,
     338,   339,   340,   341,   342,   946,   344,   345,     0,     0,
     346,   347,     0,     0,   348,   349,   350,   351,     0,     0,
       0,   352,   353,     0,     0,     0,   354,     0,   355,   356,
     357,     0,   358,   359,   360,   361,     0,   362,   363,     0,
       0,     0,     0,     0,     0,     0,     0,   364,   365,   366,
       0,     0,   367,     0,   368,     0,   369,   370,   947,   372,
     373,   374,   375,   376,   377,   378,     0,     0,   379,   380,
     381,     0,   382,     0,   383,   384,   385,   386,   387,     0,
     388,   389,   390,     0,     0,   391,     0,     0,     0,   392,
     393,   394,   395,   396,     0,     0,   397,   398,   399,   400,
     401,     0,   402,   403,     0,   404,   405,   406,     0,     0,
     407,     0,   408,     0,   409,   410,     0,   411,   412,     0,
     413,     0,   414,     0,     0,   948,   416,   417,   418,   419,
     420,   421,   422,   423,   424,   425,   426,     0,   427,   428,
       0,     0,     0,   429,   430,   949,   432,     0,     0,     0,
     433,     0,     0,     0,   434,     0,   435,   436,   437,   438,
     439,   440,     0,   441,   442,   443,   444,   445,   446,     0,
       0,     0,     0,     0,     0,   447,   448,     0,   449,     0,
       0,   450,     0,     0,   451,   452,     0,     0,     0,   453,
       0,     0,   454,   455,     0,   456,   457,   458,   459,   460,
     461,     0,     0,   462,   463,   464,   465,     0,   466,   467,
       0,   468,     0,   469,   470,   471,   472,     0,     0,   473,
     474,     0,   475,   476,   477,   478,     0,     0,     0,     0,
       0,   479,   480,   481,     0,     0,     0,   482,   483,   484,
     485,     0,   486,   487,     0,   488,   489,     0,   490,   491,
       0,     0,   492,     0,     0,   493,     0,   494,     0,   495,
     496,   497,     0,     0,     0,     0,     0,     0,   498,     0,
       0,   499,     0,     0,     0,   500,   501,   502,   503,   504,
     505,   506,     0,     0,     0,     0,     0,     0,   507,   508,
       0,   509,   510,   511,     0,     0,   512,   142,     0,   143,
     144,   145,   146,   147,   148,     0,     0,   149,     0,     0,
       0,   150,     0,     0,   151,   951,   152,   153,   154,   155,
     156,   157,   158,   159,     0,   160,     0,     0,     0,   161,
       0,     0,     0,   162,     0,     0,   163,   164,   165,     0,
     166,     0,   167,   168,     0,     0,   169,     0,     0,   170,
     171,     0,   172,   173,     0,   174,   175,     0,   176,   177,
     178,   179,   180,   181,   182,     0,   183,   184,   185,   186,
     187,   188,   189,     0,   190,   191,   192,   193,   194,   195,
     196,   197,     0,   198,   199,     0,   200,   201,   202,   203,
     204,     0,   205,     0,     0,   206,     0,     0,   207,     0,
     208,     0,     0,   209,     0,   210,     0,     0,     0,   211,
     212,   213,     0,     0,   214,     0,     0,     0,     0,   215,
     216,     0,     0,     0,     0,   217,     0,   218,     0,     0,
       0,   219,     0,   220,   221,   222,   223,   224,     0,     0,
       0,   225,     0,     0,   226,   227,   228,     0,     0,     0,
     229,     0,   230,   231,     0,   232,   233,   234,     0,     0,
     235,   236,     0,   237,   238,   239,   240,   241,   242,   243,
       0,     0,   244,   245,   246,   247,     0,     0,   248,   249,
       0,   250,   251,   252,     0,     0,   253,     0,     0,     0,
     254,     0,   255,     0,   256,     0,   257,   258,   259,   260,
     261,   262,   263,     0,   264,     0,     0,     0,   265,   266,
     267,     0,   268,     0,     0,     0,   269,   270,     0,     0,
       0,   271,   272,   273,   274,   275,     0,     0,   276,   277,
     278,     0,   279,     0,   280,     0,     0,     0,     0,   281,
     282,     0,     0,     0,   283,     0,   284,   285,     0,   286,
     287,     0,     0,     0,   288,     0,     0,   289,   290,   291,
       0,     0,   292,     0,     0,   293,   294,   643,     0,     0,
       0,     0,   295,   296,     0,   297,     0,   298,     0,   299,
     300,     0,     0,     0,     0,     0,     0,     0,   301,   302,
     303,   304,   305,   306,   307,   308,   309,   310,   311,   312,
     313,   314,   315,   316,     0,   317,   318,   319,   320,     0,
     321,   322,   323,   324,     0,   325,   326,     0,     0,     0,
       0,   327,   328,   329,   330,   331,   332,     0,     0,   333,
     334,     0,   335,     0,   336,     0,   337,   338,   339,   340,
     341,   342,   343,   344,   345,     0,     0,   346,   347,     0,
       0,   348,   349,   350,   351,     0,     0,     0,   352,   353,
       0,     0,     0,   354,     0,   355,   356,   357,     0,   358,
     359,   360,   361,     0,   362,   363,     0,     0,     0,     0,
       0,     0,     0,     0,   364,   365,   366,     0,     0,   367,
       0,   368,     0,   369,   370,   371,   372,   373,   374,   375,
     376,   377,   378,     0,     0,   379,   380,   381,     0,   382,
       0,   383,   384,   385,   386,   387,     0,   388,   389,   390,
       0,     0,   391,     0,     0,     0,   392,   393,   394,   395,
     396,     0,     0,   397,   398,   399,   400,   401,     0,   402,
     403,     0,   404,   405,   406,     0,     0,   407,     0,   408,
       0,   409,   410,     0,   411,   412,     0,   413,     0,   414,
       0,     0,   415,   416,   417,   418,   419,   420,   421,   422,
     423,   424,   425,   426,     0,   427,   428,     0,     0,     0,
     429,   430,   431,   432,     0,     0,     0,   433,     0,     0,
       0,   434,     0,   435,   436,   437,   438,   439,   440,     0,
     441,   442,   443,   444,   445,   446,     0,     0,     0,     0,
       0,     0,   447,   448,     0,   449,     0,     0,   450,     0,
       0,   451,   452,     0,     0,     0,   453,     0,     0,   454,
     455,     0,   456,   457,   458,   459,   460,   461,     0,     0,
     462,   463,   464,   465,     0,   466,   467,     0,   468,     0,
     469,   470,   471,   472,     0,   139,   473,   474,     0,   475,
     476,   477,   478,     0,     0,     0,     0,     0,   479,   480,
     481,     0,     0,     0,   482,   483,   484,   485,     0,   486,
     487,     0,   488,   489,     0,   490,   491,     0,     0,   492,
       0,     0,   493,     0,   494,     0,   495,   496,   497,     0,
       0,     0,     0,     0,     0,   498,     0,     0,   499,     0,
       0,     0,   500,   501,   502,   503,   504,   505,   506,     0,
       0,     0,     0,     0,     0,   507,   508,     0,   509,   510,
     511,     0,     0,   512,   142,     0,   143,   144,   145,   146,
     147,   148,     0,     0,   149,     0,     0,     0,   150,     0,
       0,   151,  3632,   152,   153,   154,   155,   156,   157,   158,
     159,     0,   160,     0,     0,     0,   161,     0,     0,     0,
     162,     0,     0,   163,   164,   165,     0,   166,     0,   167,
     168,     0,     0,   169,     0,     0,   170,   171,     0,   172,
     173,     0,   174,   175,     0,   176,   177,   178,   179,   180,
     181,   182,     0,   183,   184,   185,   186,   187,   188,   189,
       0,   190,   191,   192,   193,   194,   195,   196,   197,  1317,
     198,   199,     0,   200,   201,   202,   203,   204,     0,   205,
       0,     0,   206,     0,     0,   207,     0,   208,     0,     0,
     209,     0,   210,     0,     0,     0,   211,   212,   213,     0,
       0,   214,     0,     0,     0,     0,   215,   216,     0,     0,
       0,     0,   217,     0,   218,     0,     0,     0,   219,     0,
     220,   221,   222,   223,   224,     0,     0,     0,   225,     0,
       0,   226,   227,   228,     0,     0,     0,   229,     0,   230,
     231,     0,   232,   233,   234,     0,     0,   235,   236,     0,
     237,   238,   239,   240,   241,   242,   243,     0,     0,   244,
     245,   246,   247,     0,     0,   248,   249,     0,   250,   251,
     252,     0,     0,   253,     0,     0,     0,   254,     0,   255,
       0,   256,     0,   257,   258,   259,   260,   261,   262,   263,
       0,   264,     0,     0,     0,   265,   266,   267,     0,   268,
       0,     0,     0,   269,   270,     0,     0,     0,   271,   272,
     273,   274,   275,     0,     0,   276,   277,   278,     0,   279,
       0,   280,     0,     0,     0,     0,   281,   282,     0,     0,
       0,   283,     0,   284,   285,     0,   286,   287,     0,     0,
       0,   288,     0,     0,   289,   290,   291,     0,     0,   292,
       0,     0,   293,   294,     0,     0,     0,     0,     0,   295,
     296,     0,   297,     0,   298,     0,   299,   300,     0,     0,
       0,     0,     0,     0,     0,   301,   302,   303,   304,   305,
     306,   307,   308,   309,   310,   311,   312,   313,   314,   315,
     316,     0,   317,   318,   319,   320,     0,   321,   322,   323,
     324,     0,   325,   326,     0,     0,     0,     0,   327,   328,
     329,   330,   331,   332,     0,     0,   333,   334,     0,   335,
       0,   336,     0,   337,   338,   339,   340,   341,   342,   343,
     344,   345,     0,     0,   346,   347,     0,     0,   348,   349,
     350,   351,     0,     0,     0,   352,   353,     0,     0,     0,
     354,     0,   355,   356,   357,     0,   358,   359,   360,   361,
       0,   362,   363,     0,     0,     0,     0,     0,     0,     0,
       0,   364,   365,   366,     0,     0,   367,     0,   368,     0,
     369,   370,   371,   372,   373,   374,   375,   376,   377,   378,
       0,     0,   379,   380,   381,     0,   382,     0,   383,   384,
     385,   386,   387,     0,   388,   389,   390,     0,     0,   391,
       0,     0,     0,   392,   393,   394,   395,   396,     0,     0,
     397,   398,   399,   400,   401,     0,   402,   403,     0,   404,
     405,   406,     0,     0,   407,     0,   408,     0,   409,   410,
       0,   411,   412,     0,   413,     0,   414,     0,     0,   415,
     416,   417,   418,   419,   420,   421,   422,   423,   424,   425,
     426,     0,   427,   428,     0,     0,     0,   429,   430,   431,
     432,     0,     0,     0,   433,     0,     0,     0,   434,     0,
     435,   436,   437,   438,   439,   440,     0,   441,   442,   443,
     444,   445,   446,     0,     0,     0,     0,     0,     0,   447,
     448,     0,   449,     0,     0,   450,     0,     0,   451,   452,
       0,     0,     0,   453,     0,     0,   454,   455,     0,   456,
     457,   458,   459,   460,   461,     0,     0,   462,   463,   464,
     465,     0,   466,   467,     0,   468,     0,   469,   470,   471,
     472,     0,     0,   473,   474,     0,   475,   476,   477,   478,
       0,     0,     0,     0,     0,   479,   480,   481,     0,     0,
       0,   482,   483,   484,   485,     0,   486,   487,     0,   488,
     489,     0,   490,   491,     0,     0,   492,     0,     0,   493,
       0,   494,     0,   495,   496,   497,     0,     0,     0,     0,
       0,     0,   498,     0,     0,   499,     0,     0,     0,   500,
     501,   502,   503,   504,   505,   506,     0,     0,     0,     0,
       0,     0,   507,   508,     0,   509,   510,   511,     0,     0,
     512,   142,     0,   143,   144,   145,   146,   147,   148,     0,
       0,   149,     0,     0,     0,   150,     0,     0,   151,  1318,
     152,   153,   154,   155,   156,   157,   158,   159,     0,   160,
       0,     0,     0,   161,     0,     0,     0,   162,     0,     0,
     163,   164,   165,     0,   166,     0,   167,   168,     0,     0,
     169,     0,     0,   170,   171,     0,   172,   173,     0,   174,
     175,     0,   176,   177,   178,   179,   180,   181,   182,     0,
     183,   184,   185,   186,   187,   188,   189,     0,   190,   191,
     192,   193,   194,   195,   196,   197,     0,   198,   199,     0,
     200,   201,   202,   203,   204,     0,   205,     0,     0,   206,
       0,     0,   207,     0,   208,     0,     0,   209,     0,   210,
       0,     0,     0,   211,   212,   213,     0,     0,   214,     0,
       0,     0,     0,   215,   216,     0,     0,     0,     0,   217,
       0,   218,     0,     0,     0,   219,     0,   220,   221,   222,
     223,   224,     0,     0,     0,   225,     0,     0,   226,   227,
     228,     0,     0,     0,   229,     0,   230,   231,     0,   232,
     233,   234,     0,     0,   235,   236,     0,   237,   238,   239,
     240,   241,   242,   243,     0,     0,   244,   245,   246,   247,
       0,     0,   248,   249,     0,   250,   251,   252,     0,     0,
     253,     0,     0,     0,   254,     0,   255,     0,   256,     0,
     257,   258,   259,   260,   261,   262,   263,     0,   264,     0,
       0,     0,   265,   266,   267,     0,   268,     0,     0,     0,
     269,   270,     0,     0,     0,   271,   272,   273,   274,   275,
       0,     0,   276,   277,   278,     0,   279,     0,   280,     0,
       0,     0,     0,   281,   282,     0,     0,     0,   283,     0,
     284,   285,     0,   286,   287,     0,     0,     0,   288,     0,
       0,   289,   290,   291,     0,     0,   292,     0,     0,   293,
     294,     0,     0,     0,     0,     0,   295,   296,     0,   297,
       0,   298,     0,   299,   300,     0,     0,     0,     0,     0,
       0,     0,   301,   302,   303,   304,   305,   306,   307,   308,
     309,   310,   311,   312,   313,   314,   315,   316,     0,   317,
     318,   319,   320,     0,   321,   322,   323,   324,     0,   325,
     326,     0,     0,     0,     0,   327,   328,   329,   330,   331,
     332,     0,     0,   333,   334,     0,   335,     0,   336,     0,
     337,   338,   339,   340,   341,   342,   343,   344,   345,     0,
       0,   346,   347,     0,     0,   348,   349,   350,   351,     0,
       0,     0,   352,   353,     0,     0,     0,   354,     0,   355,
     356,   357,     0,   358,   359,   360,   361,     0,   362,   363,
       0,     0,     0,     0,     0,     0,     0,     0,   364,   365,
     366,     0,     0,   367,     0,   368,     0,   369,   370,   371,
     372,   373,   374,   375,   376,   377,   378,     0,     0,   379,
     380,   381,     0,   382,     0,   383,   384,   385,   386,   387,
       0,   388,   389,   390,     0,     0,   391,     0,     0,     0,
     392,   393,   394,   395,   396,     0,     0,   397,   398,   399,
     400,   401,     0,   402,   403,     0,   404,   405,   406,     0,
       0,   407,     0,   408,     0,   409,   410,     0,   411,   412,
       0,   413,     0,   414,     0,     0,   415,   416,   417,   418,
     419,   420,   421,   422,   423,   424,   425,   426,     0,   427,
     428,     0,     0,     0,   429,   430,   431,   432,     0,     0,
       0,   433,     0,     0,     0,   434,     0,   435,   436,   437,
     438,   439,   440,     0,   441,   442,   443,   444,   445,   446,
       0,     0,     0,     0,     0,     0,   447,   448,     0,   449,
       0,     0,   450,     0,     0,   451,   452,     0,     0,     0,
     453,     0,     0,   454,   455,     0,   456,   457,   458,   459,
     460,   461,     0,     0,   462,   463,   464,   465,     0,   466,
     467,     0,   468,     0,   469,   470,   471,   472,     0,     0,
     473,   474,     0,   475,   476,   477,   478,     0,     0,     0,
       0,     0,   479,   480,   481,     0,     0,     0,   482,   483,
     484,   485,     0,   486,   487,     0,   488,   489,     0,   490,
     491,     0,     0,   492,     0,     0,   493,     0,   494,     0,
     495,   496,   497,     0,     0,     0,     0,     0,     0,   498,
       0,     0,   499,     0,     0,     0,   500,   501,   502,   503,
     504,   505,   506,     0,     0,     0,     0,     0,     0,   507,
     508,     0,   509,   510,   511,     0,     0,   512,   142,     0,
     143,   144,   145,   146,   147,   148,     0,     0,   149,     0,
       0,     0,   150,     0,     0,     0,  1318,   152,   153,   154,
     155,   156,   157,   158,     0,     0,  -372,     0,     0,     0,
     161,     0,     0,     0,   162,     0,     0,   163,   164,   165,
       0,   166,     0,     0,     0,     0,     0,   169,  4147,     0,
     170,   171,     0,   172,     0,     0,     0,     0,     0,   176,
     177,   178,   179,  4148,   181,   182,     0,   183,   184,     0,
       0,     0,     0,     0,     0,   190,     0,   192,     0,   194,
     195,   196,   197,     0,   198,   199,     0,   200,   201,   202,
       0,   204,     0,   205,     0,     0,   206,     0,     0,   207,
       0,   208,     0,     0,   209,     0,   210,     0,     0,     0,
     211,   212,   213,     0,     0,   214,     0,     0,     0,     0,
     215,     0,     0,     0,     0,     0,   217,     0,   218,     0,
       0,     0,   219,     0,   220,   221,   222,   223,   224,     0,
       0,     0,     0,     0,     0,   226,   227,   228,     0,     0,
       0,   229,     0,     0,   231,     0,   232,   233,   234,     0,
       0,   235,   236,     0,   237,   238,   239,   240,   241,     0,
       0,     0,     0,   244,   245,   246,   247,     0,     0,   248,
     249,  4149,   250,   251,   252,     0,     0,     0,     0,     0,
       0,   254,     0,   255,     0,   256,     0,   257,   258,   259,
     260,   261,     0,   263,     0,   264,     0,     0,     0,     0,
     266,   267,     0,     0,     0,     0,     0,     0,   270,     0,
       0,     0,   271,   272,   273,   274,   275,  4150,     0,   276,
     277,   278,     0,   279,     0,   280,     0,     0,     0,     0,
     281,     0,     0,     0,     0,   283,     0,   284,   285,     0,
     286,   287,  4151,     0,     0,   288,     0,     0,     0,   290,
     291,     0,     0,   292,  4152,     0,   293,   294,     0,     0,
       0,     0,     0,   295,   296,     0,   297,     0,   298,     0,
     299,   300,     0,     0,     0,     0,  -327,     0,     0,   301,
     302,   303,   304,   305,   306,   307,   308,   309,   310,   311,
     312,   313,   314,   315,   316,     0,   317,   318,   319,   320,
       0,   321,   322,   323,   324,     0,   325,   326,     0,     0,
       0,     0,   327,   328,   329,   330,   331,   332,     0,     0,
     333,   334,     0,   335,     0,   336,     0,   337,   338,   339,
     340,   341,   342,   343,   344,   345,     0,     0,   346,   347,
       0,     0,   348,   349,   350,   351,     0,     0,     0,     0,
     353,     0,     0,     0,   354,     0,   355,   356,   357,     0,
     358,   359,   360,  4153,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   365,   366,     0,     0,
       0,     0,   368,     0,   369,   370,   371,   372,   373,   374,
     375,   376,   377,     0,     0,     0,     0,   380,   381,     0,
     382,     0,   383,   384,   385,   386,   387,     0,   388,   389,
     390,     0,     0,   391,     0,     0,     0,   392,   393,   394,
     395,   396,     0,     0,   397,   398,   399,   400,   401,     0,
     402,     0,     0,   404,     0,   406,  -327,     0,   407,     0,
       0,     0,   409,     0,     0,   411,   412,     0,   413,  4154,
     414,     0,     0,   415,     0,   417,   418,   419,   420,   421,
     422,   423,     0,   425,   426,     0,   427,     0,     0,     0,
       0,   429,   430,   431,     0,     0,     0,     0,   433,     0,
       0,     0,     0,     0,     0,   436,     0,     0,   439,   440,
       0,   441,     0,   443,     0,   445,   446,     0,     0,     0,
       0,     0,     0,   447,   448,     0,   449,     0,     0,   450,
       0,     0,   451,     0,     0,     0,     0,   453,     0,     0,
       0,   455,     0,   456,   457,   458,   459,   460,   461,     0,
       0,   462,   463,   464,   465,     0,   466,   467,     0,   468,
       0,   469,   470,   471,   472,     0,     0,   473,   474,     0,
     475,   476,   477,   478,     0,     0,     0,     0,     0,   479,
     480,   481,     0,     0,     0,     0,   483,   484,   485,     0,
     486,   487,     0,   488,   489,     0,     0,     0,     0,     0,
     492,     0,     0,   493,     0,     0,     0,   495,   496,   497,
       0,     0,     0,     0,     0,     0,   498,     0,     0,   499,
       0,     0,     0,   500,   501,   502,   503,   504,   505,   506,
       0,     0,  -327,     0,     0,     0,   507,     0,     0,   509,
       0,   511,     0,   142,   512,   143,   144,   145,   146,   147,
     148,     0,     0,   149,     0,     0,     0,   150,  4762,     0,
     151,     0,   152,   153,   154,   155,   156,   157,   158,   159,
       0,   160,     0,     0,     0,   161,     0,     0,     0,   162,
       0,     0,   163,   164,   165,     0,   166,     0,   167,   168,
       0,     0,   169,     0,     0,   170,   171,     0,   172,   173,
       0,   174,   175,     0,   176,   177,   178,   179,   180,   181,
     182,     0,   183,   184,   185,   186,   187,   188,   189,     0,
     190,   191,   192,   193,   194,   195,   196,   197,     0,   198,
     199,     0,   200,   201,   202,   203,   204,     0,   205,     0,
       0,   206,     0,     0,   207,     0,   208,  1047,     0,   209,
       0,   210,     0,     0,     0,   211,   212,   213,     0,     0,
     214,     0,     0,     0,     0,   215,   216,     0,     0,     0,
       0,   217,     0,   218,     0,     0,     0,   219,     0,   220,
     221,   222,   223,   224,     0,     0,     0,   225,     0,     0,
     226,   227,   228,     0,     0,     0,   229,     0,   230,   231,
       0,   232,   233,   234,     0,     0,   235,   236,     0,   237,
     238,   239,   240,   241,   242,   243,     0,     0,   244,   245,
     246,   247,     0,     0,   248,   249,     0,   250,   251,   252,
       0,     0,   253,     0,     0,     0,   254,     0,   255,     0,
     256,     0,   257,   258,   259,   260,   261,   262,   263,     0,
     264,     0,     0,     0,   265,   266,   267,     0,   268,     0,
       0,     0,   269,   270,     0,     0,     0,   271,   272,   273,
     274,   275,     0,     0,   276,   277,   278,     0,   279,     0,
     280,     0,     0,     0,     0,   281,   282,     0,     0,     0,
     283,     0,   284,   285,     0,   286,   287,     0,     0,     0,
     288,     0,     0,   289,   290,   291,     0,     0,   292,     0,
       0,   293,   294,   643,     0,     0,     0,     0,   295,   296,
       0,   297,     0,   298,     0,   299,   300,     0,     0,     0,
       0,     0,     0,     0,   301,   302,   303,   304,   305,   306,
     307,   308,   309,   310,   311,   312,   313,   314,   315,   316,
       0,   317,   318,   319,   320,     0,   321,   322,   323,   324,
       0,   325,   326,     0,     0,     0,     0,   327,   328,   329,
     330,   331,   332,     0,     0,   333,   334,     0,   335,     0,
     336,     0,   337,   338,   339,   340,   341,   342,   343,   344,
     345,     0,     0,   346,   347,     0,     0,   348,   349,   350,
     351,     0,     0,     0,   352,   353,     0,     0,     0,   354,
       0,   355,   356,   357,     0,   358,   359,   360,   361,     0,
     362,   363,     0,     0,     0,     0,     0,     0,     0,     0,
     364,   365,   366,     0,     0,   367,     0,   368,     0,   369,
     370,   371,   372,   373,   374,   375,   376,   377,   378,     0,
       0,   379,   380,   381,     0,   382,     0,   383,   384,   385,
     386,   387,     0,   388,   389,   390,     0,     0,   391,     0,
       0,     0,   392,   393,   394,   395,   396,     0,     0,   397,
     398,   399,   400,   401,     0,   402,   403,     0,   404,   405,
     406,     0,     0,   407,     0,   408,     0,   409,   410,     0,
     411,   412,     0,   413,     0,   414,     0,     0,   415,   416,
     417,   418,   419,   420,   421,   422,   423,   424,   425,   426,
       0,   427,   428,     0,     0,     0,   429,   430,   431,   432,
       0,     0,     0,   433,     0,     0,     0,   434,     0,   435,
     436,   437,   438,   439,   440,     0,   441,   442,   443,   444,
     445,   446,     0,     0,     0,     0,     0,     0,   447,   448,
       0,   449,     0,     0,   450,     0,     0,   451,   452,     0,
       0,     0,   453,     0,     0,   454,   455,     0,   456,   457,
     458,   459,   460,   461,     0,     0,   462,   463,   464,   465,
       0,   466,   467,     0,   468,     0,   469,   470,   471,   472,
       0,   139,   473,   474,     0,   475,   476,   477,   478,     0,
       0,     0,     0,     0,   479,   480,   481,     0,     0,     0,
     482,   483,   484,   485,     0,   486,   487,     0,   488,   489,
       0,   490,   491,     0,     0,   492,     0,     0,   493,     0,
     494,     0,   495,   496,   497,     0,     0,     0,     0,     0,
       0,   498,     0,     0,   499,     0,     0,     0,   500,   501,
     502,   503,   504,   505,   506,     0,     0,     0,     0,     0,
       0,   507,   508,     0,   509,   510,   511,     0,   142,   512,
     143,   144,   145,   146,   147,   148,     0,     0,   149,     0,
       0,  1215,   150,     0,     0,   151,     0,   152,   153,   154,
     155,   156,   157,   158,   159,     0,   160,     0,     0,     0,
     161,     0,     0,     0,   162,     0,     0,   163,   164,   165,
       0,   166,     0,   167,   168,     0,     0,   169,     0,     0,
     170,   171,     0,   172,   173,     0,   174,   175,     0,   176,
     177,   178,   179,   180,   181,   182,     0,   183,   184,   185,
     186,   187,   188,   189,     0,   190,   191,   192,   193,   194,
     195,   196,   197,     0,   198,   199,     0,   200,   201,   202,
     203,   204,     0,   205,     0,     0,   206,     0,     0,   207,
       0,   208,     0,     0,   209,     0,   210,     0,     0,     0,
     211,   212,   213,     0,     0,   214,     0,     0,     0,     0,
     215,   216,     0,     0,     0,     0,   217,     0,   218,     0,
       0,     0,   219,     0,   220,   221,   222,   223,   224,     0,
       0,     0,   225,     0,     0,   226,   227,   228,     0,     0,
       0,   229,     0,   230,   231,     0,   232,   233,   234,     0,
       0,   235,   236,     0,   237,   238,   239,   240,   241,   242,
     243,     0,     0,   244,   245,   246,   247,     0,     0,   248,
     249,     0,   250,   251,   252,     0,     0,   253,     0,     0,
       0,   254,     0,   255,     0,   256,     0,   257,   258,   259,
     260,   261,   262,   263,     0,   264,     0,     0,     0,   265,
     266,   267,     0,   268,     0,     0,     0,   269,   270,     0,
       0,     0,   271,   272,   273,   274,   275,     0,     0,   276,
     277,   278,     0,   279,     0,   280,     0,     0,     0,     0,
     281,   282,     0,     0,     0,   283,     0,   284,   285,     0,
     286,   287,     0,     0,     0,   288,     0,     0,   289,   290,
     291,     0,     0,   292,     0,     0,   293,   294,     0,     0,
       0,     0,     0,   295,   296,     0,   297,     0,   298,     0,
     299,   300,     0,     0,     0,     0,     0,     0,     0,   301,
     302,   303,   304,   305,   306,   307,   308,   309,   310,   311,
     312,   313,   314,   315,   316,     0,   317,   318,   319,   320,
       0,   321,   322,   323,   324,     0,   325,   326,     0,     0,
       0,     0,   327,   328,   329,   330,   331,   332,     0,     0,
     333,   334,     0,   335,     0,   336,     0,   337,   338,   339,
     340,   341,   342,   343,   344,   345,     0,     0,   346,   347,
       0,     0,   348,   349,   350,   351,     0,     0,     0,   352,
     353,     0,     0,     0,   354,     0,   355,   356,   357,     0,
     358,   359,   360,   361,     0,   362,   363,     0,     0,     0,
       0,     0,     0,     0,     0,   364,   365,   366,     0,     0,
     367,     0,   368,     0,   369,   370,   371,   372,   373,   374,
     375,   376,   377,   378,     0,     0,   379,   380,   381,     0,
     382,     0,   383,   384,   385,   386,   387,     0,   388,   389,
     390,     0,     0,   391,     0,     0,     0,   392,   393,   394,
     395,   396,     0,     0,   397,   398,   399,   400,   401,     0,
     402,   403,     0,   404,   405,   406,     0,     0,   407,     0,
     408,     0,   409,   410,     0,   411,   412,     0,   413,     0,
     414,     0,     0,   415,   416,   417,   418,   419,   420,   421,
     422,   423,   424,   425,   426,     0,   427,   428,     0,     0,
       0,   429,   430,   431,   432,     0,     0,     0,   433,     0,
       0,     0,   434,     0,   435,   436,   437,   438,   439,   440,
       0,   441,   442,   443,   444,   445,   446,     0,     0,     0,
       0,     0,     0,   447,   448,     0,   449,     0,     0,   450,
       0,     0,   451,   452,     0,     0,     0,   453,     0,     0,
     454,   455,     0,   456,   457,   458,   459,   460,   461,     0,
       0,   462,   463,   464,   465,     0,   466,   467,     0,   468,
       0,   469,   470,   471,   472,     0,     0,   473,   474,     0,
     475,   476,   477,   478,     0,     0,     0,     0,     0,   479,
     480,   481,     0,     0,     0,   482,   483,   484,   485,     0,
     486,   487,     0,   488,   489,     0,   490,   491,     0,     0,
     492,     0,     0,   493,     0,   494,     0,   495,   496,   497,
       0,     0,     0,     0,     0,     0,   498,     0,     0,   499,
       0,     0,     0,   500,   501,   502,   503,   504,   505,   506,
       0,     0,     0,     0,     0,     0,   507,   508,     0,   509,
     510,   511,     0,   142,   512,   143,   144,   145,   146,   147,
     148,  2202,     0,   149,     0,     0,     0,   150,     0,     0,
     151,     0,   152,   153,   154,   155,   156,   157,   158,   159,
       0,   160,     0,     0,     0,   161,     0,     0,     0,   162,
       0,     0,   163,   164,   165,     0,   166,     0,   167,   168,
       0,     0,   169,     0,     0,   170,   171,     0,   172,   173,
       0,   174,   175,     0,   176,   177,   178,   179,   180,   181,
     182,     0,   183,   184,   185,   186,   187,   188,   189,     0,
     190,   191,   192,   193,   194,   195,   196,   197,     0,   198,
     199,     0,   200,   201,   202,   203,   204,     0,   205,     0,
       0,   206,     0,     0,   207,     0,   208,     0,     0,   209,
       0,   210,     0,     0,     0,   211,   212,   213,     0,     0,
     214,     0,     0,     0,     0,   215,   216,     0,     0,     0,
       0,   217,     0,   218,     0,     0,     0,   219,     0,   220,
     221,   222,   223,   224,     0,     0,     0,   225,     0,     0,
     226,   227,   228,     0,     0,     0,   229,     0,   230,   231,
       0,   232,   233,   234,     0,     0,   235,   236,     0,   237,
     238,   239,   240,   241,   242,   243,     0,     0,   244,   245,
     246,   247,     0,     0,   248,   249,     0,   250,   251,   252,
       0,     0,   253,     0,     0,     0,   254,     0,   255,     0,
     256,     0,   257,   258,   259,   260,   261,   262,   263,     0,
     264,     0,     0,     0,   265,   266,   267,     0,   268,     0,
       0,     0,   269,   270,     0,     0,     0,   271,   272,   273,
     274,   275,     0,     0,   276,   277,   278,     0,   279,     0,
     280,     0,     0,     0,     0,   281,   282,     0,     0,     0,
     283,     0,   284,   285,     0,   286,   287,     0,     0,     0,
     288,     0,     0,   289,   290,   291,     0,     0,   292,     0,
       0,   293,   294,     0,     0,     0,     0,     0,   295,   296,
       0,   297,     0,   298,     0,   299,   300,     0,     0,     0,
       0,     0,     0,     0,   301,   302,   303,   304,   305,   306,
     307,   308,   309,   310,   311,   312,   313,   314,   315,   316,
       0,   317,   318,   319,   320,     0,   321,   322,   323,   324,
       0,   325,   326,     0,     0,     0,     0,   327,   328,   329,
     330,   331,   332,     0,     0,   333,   334,     0,   335,     0,
     336,     0,   337,   338,   339,   340,   341,   342,   343,   344,
     345,     0,     0,   346,   347,     0,     0,   348,   349,   350,
     351,     0,     0,     0,   352,   353,     0,     0,     0,   354,
       0,   355,   356,   357,     0,   358,   359,   360,   361,     0,
     362,   363,     0,     0,     0,     0,     0,     0,     0,     0,
     364,   365,   366,     0,     0,   367,     0,   368,     0,   369,
     370,   371,   372,   373,   374,   375,   376,   377,   378,     0,
       0,   379,   380,   381,     0,   382,     0,   383,   384,   385,
     386,   387,     0,   388,   389,   390,     0,     0,   391,     0,
       0,     0,   392,   393,   394,   395,   396,     0,     0,   397,
     398,   399,   400,   401,     0,   402,   403,     0,   404,   405,
     406,     0,     0,   407,     0,   408,     0,   409,   410,     0,
     411,   412,     0,   413,     0,   414,     0,     0,   415,   416,
     417,   418,   419,   420,   421,   422,   423,   424,   425,   426,
       0,   427,   428,     0,     0,     0,   429,   430,   431,   432,
       0,     0,     0,   433,     0,     0,     0,   434,     0,   435,
     436,   437,   438,   439,   440,     0,   441,   442,   443,   444,
     445,   446,     0,     0,     0,     0,     0,     0,   447,   448,
       0,   449,     0,     0,   450,     0,     0,   451,   452,     0,
       0,     0,   453,     0,     0,   454,   455,     0,   456,   457,
     458,   459,   460,   461,     0,     0,   462,   463,   464,   465,
       0,   466,   467,     0,   468,     0,   469,   470,   471,   472,
       0,     0,   473,   474,     0,   475,   476,   477,   478,     0,
       0,     0,     0,     0,   479,   480,   481,     0,     0,     0,
     482,   483,   484,   485,     0,   486,   487,     0,   488,   489,
       0,   490,   491,     0,     0,   492,     0,     0,   493,     0,
     494,     0,   495,   496,   497,     0,     0,     0,     0,     0,
       0,   498,     0,     0,   499,     0,     0,     0,   500,   501,
     502,   503,   504,   505,   506,     0,     0,     0,     0,     0,
       0,   507,   508,     0,   509,   510,   511,     0,   142,   512,
     143,   144,   145,   146,   147,   148,  2900,     0,   149,     0,
       0,     0,   150,     0,     0,   151,     0,   152,   153,   154,
     155,   156,   157,   158,   159,     0,   160,     0,     0,     0,
     161,     0,     0,     0,   162,     0,     0,   163,   164,   165,
       0,   166,     0,   167,   168,     0,     0,   169,     0,     0,
     170,   171,     0,   172,   173,     0,   174,   175,     0,   176,
     177,   178,   179,   180,   181,   182,     0,   183,   184,   185,
     186,   187,   188,   189,     0,   190,   191,   192,   193,   194,
     195,   196,   197,     0,   198,   199,     0,   200,   201,   202,
     203,   204,     0,   205,     0,     0,   206,     0,     0,   207,
       0,   208,     0,     0,   209,     0,   210,     0,     0,     0,
     211,   212,   213,     0,     0,   214,     0,     0,     0,     0,
     215,   216,     0,     0,     0,     0,   217,     0,   218,     0,
       0,     0,   219,     0,   220,   221,   222,   223,   224,     0,
       0,     0,   225,     0,     0,   226,   227,   228,     0,     0,
       0,   229,     0,   230,   231,     0,   232,   233,   234,     0,
       0,   235,   236,     0,   237,   238,   239,   240,   241,   242,
     243,     0,     0,   244,   245,   246,   247,     0,     0,   248,
     249,     0,   250,   251,   252,     0,     0,   253,     0,     0,
       0,   254,     0,   255,     0,   256,     0,   257,   258,   259,
     260,   261,   262,   263,     0,   264,     0,     0,     0,   265,
     266,   267,     0,   268,     0,     0,     0,   269,   270,     0,
       0,     0,   271,   272,   273,   274,   275,     0,     0,   276,
     277,   278,     0,   279,     0,   280,     0,     0,     0,     0,
     281,   282,     0,     0,     0,   283,     0,   284,   285,     0,
     286,   287,     0,     0,     0,   288,     0,     0,   289,   290,
     291,     0,     0,   292,     0,     0,   293,   294,     0,     0,
       0,     0,     0,   295,   296,     0,   297,     0,   298,     0,
     299,   300,     0,     0,     0,     0,     0,     0,     0,   301,
     302,   303,   304,   305,   306,   307,   308,   309,   310,   311,
     312,   313,   314,   315,   316,     0,   317,   318,   319,   320,
       0,   321,   322,   323,   324,     0,   325,   326,     0,     0,
       0,     0,   327,   328,   329,   330,   331,   332,     0,     0,
     333,   334,     0,   335,     0,   336,     0,   337,   338,   339,
     340,   341,   342,   343,   344,   345,     0,     0,   346,   347,
       0,     0,   348,   349,   350,   351,     0,     0,     0,   352,
     353,     0,     0,     0,   354,     0,   355,   356,   357,     0,
     358,   359,   360,   361,     0,   362,   363,     0,     0,     0,
       0,     0,     0,     0,     0,   364,   365,   366,     0,     0,
     367,     0,   368,     0,   369,   370,   371,   372,   373,   374,
     375,   376,   377,   378,     0,     0,   379,   380,   381,     0,
     382,     0,   383,   384,   385,   386,   387,     0,   388,   389,
     390,     0,     0,   391,     0,     0,     0,   392,   393,   394,
     395,   396,     0,     0,   397,   398,   399,   400,   401,     0,
     402,   403,     0,   404,   405,   406,     0,     0,   407,     0,
     408,     0,   409,   410,     0,   411,   412,     0,   413,     0,
     414,     0,     0,   415,   416,   417,   418,   419,   420,   421,
     422,   423,   424,   425,   426,     0,   427,   428,     0,     0,
       0,   429,   430,   431,   432,     0,     0,     0,   433,     0,
       0,     0,   434,     0,   435,   436,   437,   438,   439,   440,
       0,   441,   442,   443,   444,   445,   446,     0,     0,     0,
       0,     0,     0,   447,   448,     0,   449,     0,     0,   450,
       0,     0,   451,   452,     0,     0,     0,   453,     0,     0,
     454,   455,     0,   456,   457,   458,   459,   460,   461,     0,
       0,   462,   463,   464,   465,     0,   466,   467,     0,   468,
       0,   469,   470,   471,   472,     0,     0,   473,   474,     0,
     475,   476,   477,   478,     0,     0,     0,     0,     0,   479,
     480,   481,     0,     0,     0,   482,   483,   484,   485,     0,
     486,   487,     0,   488,   489,     0,   490,   491,     0,     0,
     492,     0,     0,   493,     0,   494,     0,   495,   496,   497,
       0,     0,     0,     0,     0,     0,   498,     0,     0,   499,
       0,     0,     0,   500,   501,   502,   503,   504,   505,   506,
       0,     0,     0,     0,     0,     0,   507,   508,     0,   509,
     510,   511,     0,   142,   512,   143,   144,   145,   146,   147,
     148,  3267,     0,   149,     0,     0,     0,   150,     0,     0,
     151,     0,   152,   153,   154,   155,   156,   157,   158,   159,
       0,   160,     0,     0,     0,   161,     0,     0,     0,   162,
       0,     0,   163,   164,   165,     0,   166,     0,   167,   168,
       0,     0,   169,     0,     0,   170,   171,     0,   172,   173,
       0,   174,   175,     0,   176,   177,   178,   179,   180,   181,
     182,     0,   183,   184,   185,   186,   187,   188,   189,     0,
     190,   191,   192,   193,   194,   195,   196,   197,     0,   198,
     199,     0,   200,   201,   202,   203,   204,     0,   205,     0,
       0,   206,     0,     0,   207,     0,   208,     0,     0,   209,
       0,   210,     0,     0,     0,   211,   212,   213,     0,     0,
     214,     0,     0,     0,     0,   215,   216,     0,     0,     0,
       0,   217,     0,   218,     0,     0,     0,   219,     0,   220,
     221,   222,   223,   224,     0,     0,     0,   225,     0,     0,
     226,   227,   228,     0,     0,     0,   229,     0,   230,   231,
       0,   232,   233,   234,     0,     0,   235,   236,     0,   237,
     238,   239,   240,   241,   242,   243,     0,     0,   244,   245,
     246,   247,     0,     0,   248,   249,     0,   250,   251,   252,
       0,     0,   253,     0,     0,     0,   254,     0,   255,     0,
     256,     0,   257,   258,   259,   260,   261,   262,   263,     0,
     264,     0,     0,     0,   265,   266,   267,     0,   268,     0,
       0,     0,   269,   270,     0,     0,     0,   271,   272,   273,
     274,   275,     0,     0,   276,   277,   278,     0,   279,     0,
     280,     0,     0,     0,     0,   281,   282,     0,     0,     0,
     283,     0,   284,   285,     0,   286,   287,     0,     0,     0,
     288,     0,     0,   289,   290,   291,     0,     0,   292,     0,
       0,   293,   294,     0,     0,     0,     0,     0,   295,   296,
       0,   297,     0,   298,     0,   299,   300,     0,     0,     0,
       0,     0,     0,     0,   301,   302,   303,   304,   305,   306,
     307,   308,   309,   310,   311,   312,   313,   314,   315,   316,
       0,   317,   318,   319,   320,     0,   321,   322,   323,   324,
       0,   325,   326,     0,     0,     0,     0,   327,   328,   329,
     330,   331,   332,     0,     0,   333,   334,     0,   335,     0,
     336,     0,   337,   338,   339,   340,   341,   342,   343,   344,
     345,     0,     0,   346,   347,     0,     0,   348,   349,   350,
     351,     0,     0,     0,   352,   353,     0,     0,     0,   354,
       0,   355,   356,   357,     0,   358,   359,   360,   361,     0,
     362,   363,     0,     0,     0,     0,     0,     0,     0,     0,
     364,   365,   366,     0,     0,   367,     0,   368,     0,   369,
     370,   371,   372,   373,   374,   375,   376,   377,   378,     0,
       0,   379,   380,   381,     0,   382,     0,   383,   384,   385,
     386,   387,     0,   388,   389,   390,     0,     0,   391,     0,
       0,     0,   392,   393,   394,   395,   396,     0,     0,   397,
     398,   399,   400,   401,     0,   402,   403,     0,   404,   405,
     406,     0,     0,   407,     0,   408,     0,   409,   410,     0,
     411,   412,     0,   413,     0,   414,     0,     0,   415,   416,
     417,   418,   419,   420,   421,   422,   423,   424,   425,   426,
       0,   427,   428,     0,     0,     0,   429,   430,   431,   432,
       0,     0,     0,   433,     0,     0,     0,   434,     0,   435,
     436,   437,   438,   439,   440,     0,   441,   442,   443,   444,
     445,   446,     0,     0,     0,     0,     0,     0,   447,   448,
       0,   449,     0,     0,   450,     0,     0,   451,   452,     0,
       0,     0,   453,     0,     0,   454,   455,     0,   456,   457,
     458,   459,   460,   461,     0,     0,   462,   463,   464,   465,
       0,   466,   467,     0,   468,     0,   469,   470,   471,   472,
       0,     0,   473,   474,     0,   475,   476,   477,   478,     0,
       0,     0,     0,     0,   479,   480,   481,     0,     0,     0,
     482,   483,   484,   485,     0,   486,   487,     0,   488,   489,
       0,   490,   491,     0,     0,   492,     0,     0,   493,     0,
     494,     0,   495,   496,   497,     0,     0,     0,     0,     0,
       0,   498,     0,     0,   499,     0,     0,     0,   500,   501,
     502,   503,   504,   505,   506,     0,     0,     0,     0,     0,
       0,   507,   508,     0,   509,   510,   511,     0,     0,   512,
       0,     0,     0,     0,     0,   142,  3637,   143,   144,   145,
     146,   147,   148,   840,   841,   149,     0,     0,     0,   150,
       0,     0,   151,     0,   152,   153,   154,   155,   156,   157,
     158,   159,     0,   160,     0,     0,     0,   161,     0,     0,
       0,   162,     0,     0,   163,   164,   165,     0,   166,     0,
     167,   168,     0,     0,   169,     0,     0,   170,   171,     0,
     172,   173,     0,   174,   175,     0,   176,   177,   178,   179,
     180,   181,   182,     0,   183,   184,   185,   186,   187,   188,
     189,     0,   190,   191,   192,   193,   194,   195,   196,   197,
       0,   198,   199,     0,   200,   201,   202,   203,   204,     0,
     205,     0,     0,   206,   842,     0,   207,     0,   208,     0,
     843,   209,     0,   210,     0,     0,     0,   211,   212,   213,
       0,     0,   214,     0,     0,     0,     0,   215,   216,     0,
       0,     0,     0,   217,     0,   218,   844,     0,     0,   219,
       0,   220,   221,   222,   223,   224,     0,     0,     0,   225,
     845,     0,   226,   227,   228,     0,     0,     0,   229,     0,
     230,   231,     0,   232,   233,   234,     0,     0,   235,   236,
       0,   237,   238,   846,   240,   241,   242,   847,     0,     0,
     244,   245,   246,   247,     0,     0,   248,   249,     0,   848,
     251,   252,     0,     0,   253,     0,     0,     0,   254,     0,
     255,     0,   256,     0,   257,   258,   259,   260,   261,   262,
     263,   849,   264,     0,     0,     0,   265,   266,   267,     0,
     268,     0,     0,     0,   269,   270,     0,     0,     0,   271,
     272,   273,   274,   275,     0,     0,   276,   277,   278,   850,
     279,     0,   280,     0,     0,     0,   851,   281,   282,     0,
       0,     0,   283,     0,   284,   285,     0,   286,   287,     0,
       0,     0,   288,     0,     0,   289,   290,   291,     0,     0,
     292,     0,     0,   293,   294,   643,     0,     0,     0,     0,
     295,   296,     0,   297,     0,   298,   852,   299,   300,     0,
       0,     0,     0,     0,     0,     0,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,     0,   317,   318,   319,   320,     0,   321,   322,
     323,   324,     0,   325,   326,     0,     0,     0,     0,   327,
     328,   329,   330,   331,   332,     0,     0,   333,   334,     0,
     335,     0,   336,     0,   337,   338,   339,   340,   341,   342,
     343,   344,   345,     0,     0,   346,   347,     0,     0,   348,
     349,   350,   351,     0,     0,     0,   352,   353,     0,     0,
       0,   354,     0,   355,   356,   357,     0,   358,   359,   360,
     361,     0,   362,   363,     0,     0,     0,     0,     0,     0,
       0,     0,   364,   365,   366,     0,     0,   367,     0,   368,
       0,   369,   370,   371,   372,   373,   374,   375,   376,   377,
     378,     0,     0,   379,   380,   381,     0,   382,     0,   853,
     384,   385,   386,   854,     0,   388,   389,   390,     0,     0,
     391,     0,     0,     0,   392,   393,   394,   395,   396,   855,
       0,   397,   398,   399,   400,   401,     0,   856,   403,     0,
     404,   405,   406,     0,     0,   857,     0,   408,     0,   409,
     410,     0,   411,   412,     0,   413,     0,   414,     0,     0,
     415,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,     0,   427,   428,   858,     0,     0,   429,   430,
     431,   432,     0,     0,     0,   433,     0,     0,   859,   860,
       0,   435,   436,   437,   438,   439,   440,     0,   441,   442,
     443,   444,   445,   446,     0,     0,     0,     0,     0,     0,
     447,   448,     0,   449,     0,     0,   450,     0,     0,   451,
     452,     0,     0,     0,   453,     0,     0,   454,   455,     0,
     456,   457,   458,   459,   460,   461,     0,     0,   861,   463,
     464,   465,     0,   466,   467,     0,   468,     0,   469,   470,
     471,   472,     0,   139,   473,   474,     0,   475,   476,   477,
     478,     0,     0,     0,     0,     0,   479,   480,   481,   862,
       0,     0,   482,   483,   484,   485,     0,   486,   487,     0,
     488,   489,     0,   490,   491,     0,     0,   492,     0,     0,
     493,   863,   494,   864,   495,   496,   497,     0,     0,     0,
       0,     0,     0,   498,     0,     0,   499,     0,     0,     0,
     500,   501,   502,   503,   504,   505,   506,     0,     0,     0,
       0,     0,     0,   507,   508,     0,   509,   510,   511,     0,
     142,   512,   917,   144,   145,   146,   147,   148,   918,   841,
     149,     0,     0,     0,   150,     0,     0,   151,     0,   152,
     153,   154,   155,   156,   157,   158,   159,     0,   160,     0,
       0,     0,   161,     0,     0,     0,   162,     0,     0,   163,
     164,   165,     0,   166,     0,   167,   168,     0,     0,   169,
       0,     0,   170,   171,     0,   172,   173,     0,   174,   175,
       0,   176,   177,   178,   179,   180,   181,   182,     0,   183,
     184,   185,   186,   187,   188,   189,     0,   190,   191,   192,
     193,   194,   195,   196,   197,     0,   198,   199,     0,   200,
     201,   202,   203,   204,     0,   205,     0,     0,   206,   842,
       0,   207,     0,   208,     0,   843,   209,     0,   210,     0,
       0,     0,   211,   212,   213,     0,     0,   214,     0,     0,
       0,     0,   215,   216,     0,     0,     0,     0,   217,     0,
     218,   844,     0,     0,   219,     0,   220,   221,   222,   223,
     224,     0,     0,     0,   225,   845,     0,   226,   227,   228,
       0,     0,     0,   229,     0,   230,   231,     0,   232,   233,
     234,     0,     0,   235,   236,     0,   237,   238,   846,   240,
     241,   242,   847,     0,     0,   244,   245,   246,   247,     0,
       0,   248,   249,     0,   848,   251,   252,     0,     0,   253,
       0,     0,     0,   254,     0,   255,     0,   256,     0,   257,
     258,   259,   260,   261,   262,   263,   849,   264,     0,     0,
       0,   265,   266,   267,     0,   268,     0,     0,     0,   269,
     270,     0,     0,     0,   271,   272,   273,   274,   275,     0,
       0,   276,   277,   278,   850,   279,     0,   280,     0,     0,
       0,   851,   281,   282,     0,     0,     0,   283,     0,   284,
     285,     0,   286,   287,     0,     0,     0,   288,     0,     0,
     289,   290,   291,     0,     0,   292,     0,     0,   293,   294,
     643,     0,     0,     0,     0,   295,   296,     0,   297,     0,
     298,   852,   299,   300,     0,     0,     0,     0,     0,     0,
       0,   301,   302,   303,   304,   305,   306,   307,   308,   309,
     310,   311,   312,   313,   314,   315,   316,     0,   317,   318,
     319,   320,     0,   321,   322,   323,   324,     0,   325,   326,
       0,     0,     0,     0,   327,   328,   329,   330,   331,   332,
       0,     0,   333,   334,     0,   335,     0,   336,     0,   337,
     338,   339,   340,   341,   342,   343,   344,   345,     0,     0,
     346,   347,     0,     0,   348,   349,   350,   351,     0,     0,
       0,   352,   353,     0,     0,     0,   354,     0,   355,   356,
     357,     0,   358,   359,   360,   361,     0,   362,   363,     0,
       0,     0,     0,     0,     0,     0,     0,   364,   365,   366,
       0,     0,   367,     0,   368,     0,   369,   370,   371,   372,
     373,   374,   375,   376,   377,   378,     0,     0,   379,   380,
     381,     0,   382,     0,   853,   384,   385,   386,   919,     0,
     388,   389,   390,     0,     0,   391,     0,     0,     0,   392,
     393,   394,   395,   396,   855,     0,   397,   398,   399,   400,
     401,     0,   856,   403,     0,   404,   405,   406,     0,     0,
     857,     0,   408,     0,   409,   410,     0,   411,   412,     0,
     413,     0,   414,     0,     0,   415,   416,   417,   418,   419,
     420,   421,   422,   423,   424,   425,   426,     0,   427,   428,
     858,     0,     0,   429,   430,   431,   432,     0,     0,     0,
     433,     0,     0,   859,   860,     0,   435,   436,   437,   438,
     439,   440,     0,   441,   442,   443,   444,   445,   446,     0,
       0,     0,     0,     0,     0,   447,   448,     0,   449,     0,
       0,   450,     0,     0,   451,   452,     0,     0,     0,   453,
       0,     0,   454,   455,     0,   456,   457,   458,   459,   460,
     461,     0,     0,   861,   463,   464,   465,     0,   466,   467,
       0,   468,     0,   469,   470,   471,   472,     0,   139,   473,
     474,     0,   475,   476,   477,   478,     0,     0,     0,     0,
       0,   479,   480,   481,   862,     0,     0,   482,   483,   484,
     485,     0,   486,   487,     0,   488,   489,     0,   490,   491,
       0,     0,   492,     0,     0,   493,   863,   494,   864,   495,
     496,   497,     0,     0,     0,     0,     0,     0,   498,     0,
       0,   499,     0,     0,     0,   500,   501,   502,   503,   504,
     505,   506,     0,     0,     0,     0,     0,     0,   507,   508,
       0,   509,   510,   511,     0,   142,   512,   143,   144,   145,
     146,   147,   148,     0,     0,   149,     0,     0,     0,   150,
       0,     0,   151,     0,   152,   153,   154,   155,   156,   157,
     158,   159,     0,   160,     0,     0,     0,   161,     0,     0,
       0,   162,     0,     0,   163,   164,   165,     0,   166,     0,
     167,   168,     0,     0,   169,     0,     0,   170,   171,     0,
     172,   173,     0,   174,   175,     0,   176,   177,   178,   179,
     180,   181,   182,     0,   183,   184,   185,   186,   187,   188,
     189,     0,   190,   191,   192,   193,   194,   195,   196,   197,
       0,   198,   199,     0,   200,   201,   202,   203,   204,     0,
     205,     0,     0,   206,     0,     0,   207,     0,   208,     0,
       0,   209,     0,   210,     0,     0,     0,   211,   212,   213,
       0,     0,   214,     0,     0,     0,     0,   215,   216,  2553,
       0,     0,     0,   217,     0,   218,     0,     0,     0,   219,
       0,   220,   221,   222,   223,   224,     0,     0,     0,   225,
       0,     0,   226,   227,   228,     0,     0,     0,   229,     0,
     230,   231,     0,   232,   233,   234,     0,     0,   235,   236,
       0,   237,   238,   239,   240,   241,   242,   243,     0,     0,
     244,   245,   246,   247,     0,     0,   248,   249,     0,   250,
     251,   252,  2554,     0,   253,     0,     0,     0,   254,     0,
     255,     0,   256,     0,   257,   258,   259,   260,   261,   262,
     263,     0,   264,     0,     0,     0,   265,   266,   267,     0,
     268,  2555,     0,     0,   269,   270,     0,     0,     0,   271,
     272,   273,   274,   275,     0,     0,   276,   277,   278,     0,
     279,     0,   280,     0,     0,     0,     0,   281,   282,     0,
       0,     0,   283,     0,   284,   285,     0,   286,   287,     0,
       0,     0,   288,     0,     0,   289,   290,   291,     0,     0,
     292,     0,     0,   293,   294,     0,     0,     0,     0,     0,
     295,   296,     0,   297,     0,   298,     0,   299,   300,     0,
       0,  2556,     0,     0,     0,     0,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,     0,   317,   318,   319,   320,     0,   321,   322,
     323,   324,     0,   325,   326,     0,     0,     0,     0,   327,
     328,   329,   330,   331,   332,     0,     0,   333,   334,     0,
     335,     0,   336,     0,   337,   338,   339,   340,   341,   342,
     343,   344,   345,     0,     0,   346,   347,     0,     0,   348,
     349,   350,   351,  1095,  1096,     0,   352,   353,     0,     0,
    2557,   354,     0,   355,   356,   357,     0,   358,   359,   360,
     361,     0,   362,   363,     0,     0,     0,     0,     0,     0,
       0,     0,   364,   365,   366,     0,     0,   367,     0,   368,
       0,   369,   370,   371,   372,   373,   374,   375,   376,   377,
     378,     0,     0,   379,   380,   381,     0,   382,     0,   383,
     384,   385,   386,   387,     0,   388,   389,   390,     0,     0,
     391,     0,     0,     0,   392,   393,   394,   395,   396,     0,
       0,   397,   398,   399,   400,   401,     0,   402,   403,     0,
     404,   405,   406,     0,     0,   407,     0,   408,     0,   409,
     410,     0,   411,   412,     0,   413,     0,   414,     0,     0,
     415,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,     0,   427,   428,     0,     0,     0,   429,   430,
     431,   432,     0,     0,     0,   433,     0,     0,     0,   434,
       0,   435,   436,   437,   438,   439,   440,     0,   441,   442,
     443,   444,   445,   446,     0,     0,  4749,   585,  4750,     0,
     447,   448,     0,   449,     0,     0,   450,     0,     0,   451,
     452,     0,     0,     0,   453,     0,     0,   454,   455,     0,
     456,   457,   458,   459,   460,   461,     0,     0,   462,   463,
     464,   465,     0,   466,   467,     0,   468,     0,   469,   470,
     471,   472,     0,     0,   473,   474,     0,   475,   476,   477,
     478,     0,     0,     0,     0,     0,   479,   480,   481,     0,
       0,     0,   482,   483,   484,   485,  2558,   486,   487,     0,
     488,   489,     0,   490,   491,     0,     0,   492,     0,     0,
     493,     0,   494,     0,   495,   496,   497,     0,     0,     0,
       0,     0,     0,   498,     0,     0,   499,     0,     0,     0,
     500,   501,   502,   503,   504,   505,   506,     0,     0,     0,
       0,     0,     0,   507,   508,     0,   509,   510,   511,     0,
     142,   512,   143,   144,   145,   146,   147,   148,     0,     0,
     149,     0,     0,     0,   150,     0,     0,   151,     0,   152,
     153,   154,   155,   156,   157,   158,   159,     0,   160,     0,
       0,     0,   161,     0,     0,     0,   162,     0,     0,   163,
     164,   165,     0,   166,     0,   167,   168,     0,     0,   169,
       0,     0,   170,   171,     0,   172,   173,     0,   174,   175,
       0,   176,   177,   178,   179,   180,   181,   182,     0,   183,
     184,   185,   186,   187,   188,   189,     0,   190,   191,   192,
     193,   194,   195,   196,   197,     0,   198,   199,     0,   200,
     201,   202,   203,   204,     0,   205,     0,     0,   206,     0,
       0,   207,     0,   208,     0,     0,   209,     0,   210,     0,
       0,     0,   211,   212,   213,     0,     0,   214,     0,     0,
       0,     0,   215,   216,  1668,     0,     0,  3482,   217,     0,
     218,     0,     0,     0,   219,     0,   220,   221,   222,   223,
     224,     0,     0,     0,   225,     0,     0,   226,   227,   228,
       0,     0,     0,   229,     0,   230,   231,     0,   232,   233,
     234,     0,     0,   235,   236,     0,   237,   238,   239,   240,
     241,   242,   243,     0,     0,   244,   245,   246,   247,     0,
       0,   248,   249,     0,   250,   251,   252,  1669,     0,   253,
       0,     0,     0,   254,     0,   255,     0,   256,     0,   257,
     258,   259,   260,   261,   262,   263,     0,   264,     0,     0,
       0,   265,   266,   267,     0,   268,  2984,     0,     0,   269,
     270,     0,     0,     0,   271,   272,   273,   274,   275,     0,
       0,   276,   277,   278,     0,   279,     0,   280,     0,     0,
       0,     0,   281,   282,     0,     0,     0,   283,     0,   284,
     285,     0,   286,   287,     0,     0,     0,   288,     0,     0,
     289,   290,   291,     0,     0,   292,     0,     0,   293,   294,
       0,     0,     0,     0,     0,   295,   296,     0,   297,     0,
     298,     0,   299,   300,     0,     0,  2985,     0,     0,     0,
       0,   301,   302,   303,   304,   305,   306,   307,   308,   309,
     310,   311,   312,   313,   314,   315,   316,     0,   317,   318,
     319,   320,     0,   321,   322,   323,   324,     0,   325,   326,
       0,     0,     0,     0,   327,   328,   329,   330,   331,   332,
       0,     0,   333,   334,     0,   335,     0,   336,     0,   337,
     338,   339,   340,   341,   342,   343,   344,   345,     0,     0,
     346,   347,     0,     0,   348,   349,   350,   351,     0,     0,
       0,   352,   353,     0,     0,  2986,   354,     0,   355,   356,
     357,     0,   358,   359,   360,   361,     0,   362,   363,     0,
       0,     0,     0,     0,     0,     0,     0,   364,   365,   366,
       0,     0,   367,     0,   368,     0,   369,   370,   371,   372,
     373,   374,   375,   376,   377,   378,     0,     0,   379,   380,
     381,     0,   382,     0,   383,   384,   385,   386,   387,     0,
     388,   389,   390,     0,     0,   391,     0,     0,     0,   392,
     393,   394,   395,   396,     0,     0,   397,   398,   399,   400,
     401,     0,   402,   403,     0,   404,   405,   406,     0,     0,
     407,     0,   408,     0,   409,   410,     0,   411,   412,     0,
     413,     0,   414,     0,     0,   415,   416,   417,   418,   419,
     420,   421,   422,   423,   424,   425,   426,     0,   427,   428,
       0,     0,     0,   429,   430,   431,   432,     0,     0,     0,
     433,     0,     0,     0,   434,     0,   435,   436,   437,   438,
     439,   440,     0,   441,   442,   443,   444,   445,   446,     0,
       0,     0,     0,     0,     0,   447,   448,     0,   449,     0,
       0,   450,     0,     0,   451,   452,     0,     0,     0,   453,
       0,     0,   454,   455,     0,   456,   457,   458,   459,   460,
     461,     0,     0,   462,   463,   464,   465,     0,   466,   467,
       0,   468,     0,   469,   470,   471,   472,     0,   139,   473,
     474,     0,   475,   476,   477,   478,     0,     0,     0,     0,
       0,   479,   480,   481,     0,     0,     0,   482,   483,   484,
     485,  2987,   486,   487,     0,   488,   489,     0,   490,   491,
       0,     0,   492,     0,     0,   493,     0,   494,     0,   495,
     496,   497,     0,     0,     0,     0,     0,     0,   498,     0,
       0,   499,     0,     0,     0,   500,   501,   502,   503,   504,
     505,   506,     0,     0,     0,     0,     0,     0,   507,   508,
       0,   509,   510,   511,     0,   142,   512,   143,   144,   145,
     146,   147,   148,     0,     0,   149,     0,     0,     0,   150,
       0,     0,   151,     0,   152,   153,   154,   155,   156,   157,
     158,   159,     0,   160,     0,     0,     0,   161,     0,     0,
       0,   162,     0,     0,   163,   164,   165,     0,   166,     0,
     167,   168,     0,     0,   169,     0,     0,   170,   171,     0,
     172,   173,     0,   174,   175,     0,   176,   177,   178,   179,
     180,   181,   182,     0,   183,   184,   185,   186,   187,   188,
     189,     0,   190,   191,   192,   193,   194,   195,   196,   197,
       0,   198,   199,     0,   200,   201,   202,   203,   204,     0,
     205,     0,     0,   206,     0,     0,   207,     0,   208,     0,
       0,   209,     0,   210,     0,     0,     0,   211,   212,   213,
       0,     0,   214,     0,     0,     0,     0,   215,   216,  1668,
       0,     0,  4289,   217,     0,   218,     0,     0,     0,   219,
       0,   220,   221,   222,   223,   224,     0,     0,     0,   225,
       0,     0,   226,   227,   228,     0,     0,     0,   229,     0,
     230,   231,     0,   232,   233,   234,     0,     0,   235,   236,
       0,   237,   238,   239,   240,   241,   242,   243,     0,     0,
     244,   245,   246,   247,     0,     0,   248,   249,     0,   250,
     251,   252,  1669,     0,   253,     0,     0,     0,   254,     0,
     255,     0,   256,     0,   257,   258,   259,   260,   261,   262,
     263,     0,   264,     0,     0,     0,   265,   266,   267,     0,
     268,  2984,     0,     0,   269,   270,     0,     0,     0,   271,
     272,   273,   274,   275,     0,     0,   276,   277,   278,     0,
     279,     0,   280,     0,     0,     0,     0,   281,   282,     0,
       0,     0,   283,     0,   284,   285,     0,   286,   287,     0,
       0,     0,   288,     0,     0,   289,   290,   291,     0,     0,
     292,     0,     0,   293,   294,     0,     0,     0,     0,     0,
     295,   296,     0,   297,     0,   298,     0,   299,   300,     0,
       0,  2985,     0,     0,     0,     0,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,     0,   317,   318,   319,   320,     0,   321,   322,
     323,   324,     0,   325,   326,     0,     0,     0,     0,   327,
     328,   329,   330,   331,   332,     0,     0,   333,   334,     0,
     335,     0,   336,     0,   337,   338,   339,   340,   341,   342,
     343,   344,   345,     0,     0,   346,   347,     0,     0,   348,
     349,   350,   351,     0,     0,     0,   352,   353,     0,     0,
    2986,   354,     0,   355,   356,   357,     0,   358,   359,   360,
     361,     0,   362,   363,     0,     0,     0,     0,     0,     0,
       0,     0,   364,   365,   366,     0,     0,   367,     0,   368,
       0,   369,   370,   371,   372,   373,   374,   375,   376,   377,
     378,     0,     0,   379,   380,   381,     0,   382,     0,   383,
     384,   385,   386,   387,     0,   388,   389,   390,     0,     0,
     391,     0,     0,     0,   392,   393,   394,   395,   396,     0,
       0,   397,   398,   399,   400,   401,     0,   402,   403,     0,
     404,   405,   406,     0,     0,   407,     0,   408,     0,   409,
     410,     0,   411,   412,     0,   413,     0,   414,     0,     0,
     415,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,     0,   427,   428,     0,     0,     0,   429,   430,
     431,   432,     0,     0,     0,   433,     0,     0,     0,   434,
       0,   435,   436,   437,   438,   439,   440,     0,   441,   442,
     443,   444,   445,   446,     0,     0,     0,     0,     0,     0,
     447,   448,     0,   449,     0,     0,   450,     0,     0,   451,
     452,     0,     0,     0,   453,     0,     0,   454,   455,     0,
     456,   457,   458,   459,   460,   461,     0,     0,   462,   463,
     464,   465,     0,   466,   467,     0,   468,     0,   469,   470,
     471,   472,     0,   139,   473,   474,     0,   475,   476,   477,
     478,     0,     0,     0,     0,     0,   479,   480,   481,     0,
       0,     0,   482,   483,   484,   485,  2987,   486,   487,     0,
     488,   489,     0,   490,   491,     0,     0,   492,     0,     0,
     493,     0,   494,     0,   495,   496,   497,     0,     0,     0,
       0,     0,     0,   498,     0,     0,   499,     0,     0,     0,
     500,   501,   502,   503,   504,   505,   506,     0,     0,     0,
       0,     0,     0,   507,   508,     0,   509,   510,   511,     0,
     142,   512,   143,   144,   145,   146,   147,   148,     0,     0,
     149,     0,     0,     0,   150,     0,     0,   151,     0,   152,
     153,   154,   155,   156,   157,   158,   159,     0,   160,     0,
       0,     0,   161,     0,     0,     0,   162,     0,     0,   163,
     164,   165,     0,   166,     0,   167,   168,     0,     0,   169,
       0,     0,   170,   171,     0,   172,   173,     0,   174,   175,
       0,   176,   177,   178,   179,   180,   181,   182,     0,   183,
     184,   185,   186,   187,   188,   189,     0,   190,   191,   192,
     193,   194,   195,   196,   197,     0,   198,   199,     0,   200,
     201,   202,   203,   204,     0,   205,     0,     0,   206,     0,
       0,   207,     0,   208,     0,     0,   209,     0,   210,     0,
       0,     0,   211,   212,   213,     0,     0,   214,     0,     0,
       0,     0,   215,   216,  1668,     0,     0,  4544,   217,     0,
     218,     0,     0,     0,   219,     0,   220,   221,   222,   223,
     224,     0,     0,     0,   225,     0,     0,   226,   227,   228,
       0,     0,     0,   229,     0,   230,   231,     0,   232,   233,
     234,     0,     0,   235,   236,     0,   237,   238,   239,   240,
     241,   242,   243,     0,     0,   244,   245,   246,   247,     0,
       0,   248,   249,     0,   250,   251,   252,  1669,     0,   253,
       0,     0,     0,   254,     0,   255,     0,   256,     0,   257,
     258,   259,   260,   261,   262,   263,     0,   264,     0,     0,
       0,   265,   266,   267,     0,   268,  2984,     0,     0,   269,
     270,     0,     0,     0,   271,   272,   273,   274,   275,     0,
       0,   276,   277,   278,     0,   279,     0,   280,     0,     0,
       0,     0,   281,   282,     0,     0,     0,   283,     0,   284,
     285,     0,   286,   287,     0,     0,     0,   288,     0,     0,
     289,   290,   291,     0,     0,   292,     0,     0,   293,   294,
       0,     0,     0,     0,     0,   295,   296,     0,   297,     0,
     298,     0,   299,   300,     0,     0,  2985,     0,     0,     0,
       0,   301,   302,   303,   304,   305,   306,   307,   308,   309,
     310,   311,   312,   313,   314,   315,   316,     0,   317,   318,
     319,   320,     0,   321,   322,   323,   324,     0,   325,   326,
       0,     0,     0,     0,   327,   328,   329,   330,   331,   332,
       0,     0,   333,   334,     0,   335,     0,   336,     0,   337,
     338,   339,   340,   341,   342,   343,   344,   345,     0,     0,
     346,   347,     0,     0,   348,   349,   350,   351,     0,     0,
       0,   352,   353,     0,     0,  2986,   354,     0,   355,   356,
     357,     0,   358,   359,   360,   361,     0,   362,   363,     0,
       0,     0,     0,     0,     0,     0,     0,   364,   365,   366,
       0,     0,   367,     0,   368,     0,   369,   370,   371,   372,
     373,   374,   375,   376,   377,   378,     0,     0,   379,   380,
     381,     0,   382,     0,   383,   384,   385,   386,   387,     0,
     388,   389,   390,     0,     0,   391,     0,     0,     0,   392,
     393,   394,   395,   396,     0,     0,   397,   398,   399,   400,
     401,     0,   402,   403,     0,   404,   405,   406,     0,     0,
     407,     0,   408,     0,   409,   410,     0,   411,   412,     0,
     413,     0,   414,     0,     0,   415,   416,   417,   418,   419,
     420,   421,   422,   423,   424,   425,   426,     0,   427,   428,
       0,     0,     0,   429,   430,   431,   432,     0,     0,     0,
     433,     0,     0,     0,   434,     0,   435,   436,   437,   438,
     439,   440,     0,   441,   442,   443,   444,   445,   446,     0,
       0,     0,     0,     0,     0,   447,   448,     0,   449,     0,
       0,   450,     0,     0,   451,   452,     0,     0,     0,   453,
       0,     0,   454,   455,     0,   456,   457,   458,   459,   460,
     461,     0,     0,   462,   463,   464,   465,     0,   466,   467,
       0,   468,     0,   469,   470,   471,   472,     0,   139,   473,
     474,     0,   475,   476,   477,   478,     0,     0,     0,     0,
       0,   479,   480,   481,     0,     0,     0,   482,   483,   484,
     485,  2987,   486,   487,     0,   488,   489,     0,   490,   491,
       0,     0,   492,     0,     0,   493,     0,   494,     0,   495,
     496,   497,     0,     0,     0,     0,     0,     0,   498,     0,
       0,   499,     0,     0,     0,   500,   501,   502,   503,   504,
     505,   506,     0,     0,     0,     0,     0,     0,   507,   508,
       0,   509,   510,   511,     0,   142,   512,   143,   144,   145,
     146,   147,   148,     0,     0,   149,     0,     0,     0,   150,
       0,     0,   151,     0,   152,   153,   154,   155,   156,   157,
     158,   159,     0,   160,     0,     0,  1425,   161,     0,     0,
       0,   162,     0,     0,   163,   164,   165,     0,   166,     0,
     167,   168,     0,     0,   169,     0,     0,   170,   171,     0,
     172,   173,     0,   174,   175,     0,   176,   177,   178,   179,
     180,   181,   182,     0,   183,   184,   185,   186,   187,   188,
     189,     0,   190,   191,   192,   193,   194,   195,   196,   197,
       0,   198,   199,     0,   200,   201,   202,   203,   204,     0,
     205,     0,     0,   206,     0,     0,   207,     0,   208,     0,
       0,   209,     0,   210,     0,     0,     0,   211,   212,   213,
       0,     0,   214,     0,     0,     0,     0,   215,   216,     0,
       0,     0,  1426,   217,     0,   218,     0,     0,     0,   219,
       0,   220,   221,   222,   223,   224,     0,     0,     0,   225,
       0,     0,   226,   227,   228,     0,     0,     0,   229,     0,
     230,   231,     0,   232,   233,   234,  1427,     0,   235,   236,
       0,   237,   238,   239,   240,   241,   242,   243,     0,     0,
     244,   245,   246,   247,     0,     0,   248,   249,     0,   250,
     251,   252,     0,     0,   253,     0,     0,     0,   254,     0,
     255,     0,   256,     0,   257,   258,   259,   260,   261,   262,
     263,     0,   264,     0,     0,     0,   265,   266,   267,     0,
     268,     0,     0,     0,   269,   270,     0,     0,     0,   271,
     272,   273,   274,   275,     0,     0,   276,   277,   278,     0,
     279,     0,   280,     0,     0,     0,     0,   281,   282,     0,
       0,     0,   283,     0,   284,   285,     0,   286,   287,     0,
       0,     0,   288,     0,     0,   289,   290,   291,     0,     0,
     292,     0,     0,   293,   294,   643,     0,     0,     0,     0,
     295,   296,     0,   297,     0,   298,     0,   299,   300,     0,
       0,     0,     0,     0,     0,     0,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,     0,   317,   318,   319,   320,     0,   321,   322,
     323,   324,     0,   325,   326,     0,     0,     0,     0,   327,
     328,   329,   330,   331,   332,     0,     0,   333,   334,     0,
     335,     0,   336,     0,   337,   338,   339,   340,   341,   342,
     343,   344,   345,     0,     0,   346,   347,     0,     0,   348,
     349,   350,   351,     0,     0,     0,   352,   353,     0,     0,
       0,   354,     0,   355,   356,   357,     0,   358,   359,   360,
     361,     0,   362,   363,     0,     0,     0,     0,     0,     0,
       0,     0,   364,   365,   366,     0,     0,   367,     0,   368,
       0,   369,   370,   371,   372,   373,   374,   375,   376,   377,
     378,     0,     0,   379,   380,   381,     0,   382,     0,   383,
     384,   385,   386,   387,     0,   388,   389,   390,     0,     0,
     391,     0,     0,     0,   392,   393,   394,   395,   396,     0,
       0,   397,   398,   399,   400,   401,     0,   402,   403,     0,
     404,   405,   406,     0,     0,   407,     0,   408,     0,   409,
     410,     0,   411,   412,     0,   413,     0,   414,     0,     0,
     415,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,     0,   427,   428,     0,     0,     0,   429,   430,
     431,   432,     0,     0,  1428,   433,     0,     0,     0,   434,
       0,   435,   436,   437,   438,   439,   440,     0,   441,   442,
     443,   444,   445,   446,     0,     0,     0,     0,     0,     0,
     447,   448,     0,   449,     0,     0,   450,     0,     0,   451,
     452,     0,     0,     0,   453,     0,     0,   454,   455,     0,
     456,   457,   458,   459,   460,   461,     0,     0,   462,   463,
     464,   465,     0,   466,   467,     0,   468,     0,   469,   470,
     471,   472,     0,   139,   473,   474,     0,   475,   476,   477,
     478,     0,     0,     0,     0,     0,   479,   480,   481,     0,
       0,     0,   482,   483,   484,   485,     0,   486,   487,     0,
     488,   489,     0,   490,   491,     0,     0,   492,     0,     0,
     493,     0,   494,     0,   495,   496,   497,     0,     0,     0,
       0,     0,     0,   498,     0,     0,   499,     0,     0,     0,
     500,   501,   502,   503,   504,   505,   506,     0,     0,     0,
       0,     0,     0,   507,   508,     0,   509,   510,   511,     0,
     142,   512,   143,   144,   145,   146,   147,   148,     0,     0,
     149,     0,     0,     0,   150,     0,     0,   151,     0,   152,
     153,   154,   155,   156,   157,   158,   159,     0,   160,     0,
       0,     0,   161,     0,     0,     0,   162,     0,     0,   163,
     164,   165,     0,   166,     0,   167,   168,     0,     0,   169,
       0,     0,   170,   171,     0,   172,   173,     0,   174,   175,
       0,   176,   177,   178,   179,   180,   181,   182,     0,   183,
     184,   185,   186,   187,   188,   189,     0,   190,   191,   192,
     193,   194,   195,   196,   197,     0,   198,   199,     0,   200,
     201,   202,   203,   204,     0,   205,     0,     0,   206,     0,
       0,   207,     0,   208,  1047,   843,   209,     0,   210,     0,
       0,     0,   211,   212,   213,     0,     0,   214,     0,     0,
       0,     0,   215,   216,     0,     0,     0,     0,   217,     0,
     218,     0,     0,     0,   219,     0,   220,   221,   222,   223,
     224,     0,     0,     0,   225,     0,     0,   226,   227,   228,
       0,     0,     0,   229,     0,   230,   231,     0,   232,   233,
     234,     0,     0,   235,   236,     0,   237,   238,   239,   240,
     241,   242,   243,     0,     0,   244,   245,   246,   247,     0,
       0,   248,   249,     0,   250,   251,   252,     0,     0,   253,
       0,     0,     0,   254,     0,   255,     0,   256,     0,   257,
     258,   259,   260,   261,   262,   263,     0,   264,     0,     0,
       0,   265,   266,   267,     0,   268,     0,     0,     0,   269,
     270,     0,     0,     0,   271,   272,   273,   274,   275,     0,
       0,   276,   277,   278,     0,   279,     0,   280,     0,     0,
       0,     0,   281,   282,     0,     0,     0,   283,     0,   284,
     285,     0,   286,   287,     0,     0,     0,   288,     0,     0,
     289,   290,   291,     0,     0,   292,     0,     0,   293,   294,
     643,     0,     0,     0,     0,   295,   296,     0,   297,     0,
     298,     0,   299,   300,     0,     0,     0,     0,     0,     0,
       0,   301,   302,   303,   304,   305,   306,   307,   308,   309,
     310,   311,   312,   313,   314,   315,   316,     0,   317,   318,
     319,   320,     0,   321,   322,   323,   324,     0,   325,   326,
       0,     0,     0,     0,   327,   328,   329,   330,   331,   332,
       0,     0,   333,   334,     0,   335,     0,   336,     0,   337,
     338,   339,   340,   341,   342,   343,   344,   345,     0,     0,
     346,   347,     0,     0,   348,   349,   350,   351,     0,     0,
       0,   352,   353,     0,     0,     0,   354,     0,   355,   356,
     357,     0,   358,   359,   360,   361,     0,   362,   363,     0,
       0,     0,     0,     0,     0,     0,     0,   364,   365,   366,
       0,     0,   367,     0,   368,     0,   369,   370,   371,   372,
     373,   374,   375,   376,   377,   378,     0,     0,   379,   380,
     381,     0,   382,     0,   383,   384,   385,   386,   387,     0,
     388,   389,   390,     0,     0,   391,     0,     0,     0,   392,
     393,   394,   395,   396,     0,     0,   397,   398,   399,   400,
     401,     0,   402,   403,     0,   404,   405,   406,     0,     0,
     407,     0,   408,     0,   409,   410,     0,   411,   412,     0,
     413,     0,   414,     0,     0,   415,   416,   417,   418,   419,
     420,   421,   422,   423,   424,   425,   426,     0,   427,   428,
       0,     0,     0,   429,   430,   431,   432,     0,     0,     0,
     433,     0,     0,     0,   434,     0,   435,   436,   437,   438,
     439,   440,     0,   441,   442,   443,   444,   445,   446,     0,
       0,     0,     0,     0,     0,   447,   448,     0,   449,     0,
       0,   450,     0,     0,   451,   452,     0,     0,     0,   453,
       0,     0,   454,   455,     0,   456,   457,   458,   459,   460,
     461,     0,     0,   462,   463,   464,   465,     0,   466,   467,
       0,   468,     0,   469,   470,   471,   472,     0,   139,   473,
     474,     0,   475,   476,   477,   478,     0,     0,     0,     0,
       0,   479,   480,   481,     0,     0,     0,   482,   483,   484,
     485,     0,   486,   487,     0,   488,   489,     0,   490,   491,
       0,     0,   492,     0,     0,   493,     0,   494,     0,   495,
     496,   497,     0,     0,     0,     0,     0,     0,   498,     0,
       0,   499,     0,     0,     0,   500,   501,   502,   503,   504,
     505,   506,     0,     0,     0,     0,     0,     0,   507,   508,
       0,   509,   510,   511,     0,   142,   512,   143,   144,   145,
     146,   147,   148,     0,     0,   149,     0,     0,     0,   150,
       0,     0,   151,     0,   152,   153,   154,   155,   156,   157,
     158,   159,     0,   160,     0,     0,  1439,   161,     0,     0,
       0,   162,     0,     0,   163,   164,   165,     0,   166,     0,
     167,   168,     0,     0,   169,     0,     0,   170,   171,     0,
     172,   173,     0,   174,   175,     0,   176,   177,   178,   179,
     180,   181,   182,     0,   183,   184,   185,   186,   187,   188,
     189,     0,   190,   191,   192,   193,   194,   195,   196,   197,
       0,   198,   199,     0,   200,   201,   202,   203,   204,     0,
     205,     0,     0,   206,     0,     0,   207,     0,   208,     0,
       0,   209,     0,   210,     0,     0,     0,   211,   212,   213,
       0,     0,   214,     0,     0,     0,     0,   215,   216,     0,
       0,     0,  1440,   217,     0,   218,     0,     0,     0,   219,
       0,   220,   221,   222,   223,   224,     0,     0,     0,   225,
       0,     0,   226,   227,   228,     0,     0,     0,   229,     0,
     230,   231,     0,   232,   233,   234,     0,     0,   235,   236,
       0,   237,   238,   239,   240,   241,   242,   243,     0,     0,
     244,   245,   246,   247,     0,     0,   248,   249,     0,   250,
     251,   252,     0,     0,   253,     0,     0,     0,   254,     0,
     255,     0,   256,     0,   257,   258,   259,   260,   261,   262,
     263,     0,   264,     0,     0,     0,   265,   266,   267,     0,
     268,     0,     0,     0,   269,   270,     0,     0,     0,   271,
     272,   273,   274,   275,     0,     0,   276,   277,   278,     0,
     279,     0,   280,     0,     0,     0,     0,   281,   282,     0,
       0,     0,   283,     0,   284,   285,     0,   286,   287,     0,
       0,     0,   288,     0,     0,   289,   290,   291,     0,     0,
     292,     0,     0,   293,   294,   643,     0,     0,     0,     0,
     295,   296,     0,   297,     0,   298,     0,   299,   300,     0,
       0,     0,     0,     0,     0,     0,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,     0,   317,   318,   319,   320,     0,   321,   322,
     323,   324,     0,   325,   326,     0,     0,     0,     0,   327,
     328,   329,   330,   331,   332,     0,     0,   333,   334,     0,
     335,     0,   336,     0,   337,   338,   339,   340,   341,   342,
     343,   344,   345,     0,     0,   346,   347,     0,     0,   348,
     349,   350,   351,     0,     0,     0,   352,   353,     0,     0,
       0,   354,     0,   355,   356,   357,     0,   358,   359,   360,
     361,     0,   362,   363,     0,     0,     0,     0,     0,     0,
       0,     0,   364,   365,   366,     0,     0,   367,     0,   368,
       0,   369,   370,   371,   372,   373,   374,   375,   376,   377,
     378,     0,     0,   379,   380,   381,     0,   382,     0,   383,
     384,   385,   386,   387,     0,   388,   389,   390,     0,     0,
     391,     0,     0,     0,   392,   393,   394,   395,   396,     0,
       0,   397,   398,   399,   400,   401,     0,   402,   403,     0,
     404,   405,   406,     0,     0,   407,     0,   408,     0,   409,
     410,     0,   411,   412,     0,   413,     0,   414,     0,     0,
     415,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,     0,   427,   428,     0,     0,     0,   429,   430,
     431,   432,     0,     0,     0,   433,     0,     0,     0,   434,
       0,   435,   436,   437,   438,   439,   440,     0,   441,   442,
     443,   444,   445,   446,     0,     0,     0,     0,     0,     0,
     447,   448,     0,   449,     0,     0,   450,     0,     0,   451,
     452,     0,     0,     0,   453,     0,     0,   454,   455,     0,
     456,   457,   458,   459,   460,   461,     0,     0,   462,   463,
     464,   465,     0,   466,   467,     0,   468,     0,   469,   470,
     471,   472,     0,   139,   473,   474,     0,   475,   476,   477,
     478,     0,     0,     0,     0,     0,   479,   480,   481,     0,
       0,     0,   482,   483,   484,   485,     0,   486,   487,     0,
     488,   489,     0,   490,   491,     0,     0,   492,     0,     0,
     493,     0,   494,     0,   495,   496,   497,     0,     0,     0,
       0,     0,     0,   498,     0,     0,   499,     0,     0,     0,
     500,   501,   502,   503,   504,   505,   506,     0,     0,     0,
       0,     0,     0,   507,   508,     0,   509,   510,   511,     0,
     142,   512,   143,   144,   145,   146,   147,   148,     0,     0,
     149,     0,     0,     0,   150,     0,     0,   151,     0,   152,
     153,   154,   155,   156,   157,   158,   159,     0,   160,     0,
       0,     0,   161,  1018,     0,     0,   162,     0,     0,   163,
     164,   165,     0,   166,     0,   167,   168,     0,     0,   169,
       0,     0,   170,   171,     0,   172,   173,     0,   174,   175,
       0,   176,   177,   178,   179,   180,   181,   182,     0,   183,
     184,   185,   186,   187,   188,   189,     0,   190,   191,   192,
     193,   194,   195,   196,   197,     0,   198,   199,     0,   200,
     201,   202,   203,   204,     0,   205,     0,     0,   206,     0,
       0,   207,     0,   208,     0,     0,   209,     0,   210,     0,
       0,     0,   211,   212,   213,     0,     0,   214,     0,     0,
       0,     0,   215,   216,     0,     0,     0,     0,   217,     0,
     218,     0,     0,     0,   219,     0,   220,   221,   222,   223,
     224,     0,     0,     0,   225,     0,     0,   226,   227,   228,
       0,     0,     0,   229,     0,   230,   231,     0,   232,   233,
     234,     0,     0,   235,   236,     0,   237,   238,   239,   240,
     241,   242,   243,     0,     0,   244,   245,   246,   247,     0,
       0,   248,   249,     0,   250,   251,   252,     0,     0,   253,
       0,     0,     0,   254,     0,   255,     0,   256,     0,   257,
     258,   259,   260,   261,   262,   263,     0,   264,     0,     0,
       0,   265,   266,   267,     0,   268,  1019,  1020,     0,   269,
     270,     0,     0,     0,   271,   272,   273,   274,   275,     0,
       0,   276,   277,   278,     0,   279,     0,   280,     0,     0,
       0,     0,   281,   282,     0,     0,     0,   283,     0,   284,
     285,     0,   286,   287,     0,     0,     0,   288,     0,     0,
     289,   290,   291,     0,     0,   292,     0,     0,   293,   294,
       0,     0,     0,     0,     0,   295,   296,     0,   297,     0,
     298,     0,   299,   300,     0,     0,     0,     0,     0,     0,
       0,   301,   302,   303,   304,   305,   306,   307,   308,   309,
     310,   311,   312,   313,   314,   315,   316,     0,   317,   318,
     319,   320,     0,   321,   322,   323,   324,     0,   325,   326,
       0,     0,     0,     0,   327,   328,   329,   330,   331,   332,
       0,     0,   333,   334,     0,   335,     0,   336,     0,   337,
     338,   339,   340,   341,   342,   343,   344,   345,     0,     0,
     346,   347,     0,     0,   348,   349,   350,   351,     0,     0,
       0,   352,   353,     0,     0,     0,   354,     0,   355,   356,
     357,     0,   358,   359,   360,   361,     0,   362,   363,     0,
       0,     0,     0,     0,     0,     0,     0,   364,   365,   366,
       0,     0,   367,     0,   368,     0,   369,   370,   371,   372,
     373,   374,   375,   376,   377,   378,     0,     0,   379,   380,
     381,     0,   382,     0,   383,   384,   385,   386,   387,     0,
     388,   389,   390,     0,     0,   391,     0,     0,     0,   392,
     393,   394,   395,   396,     0,     0,   397,   398,   399,   400,
     401,     0,   402,   403,     0,   404,   405,   406,     0,     0,
     407,     0,   408,     0,   409,   410,     0,   411,   412,     0,
     413,     0,   414,     0,     0,   415,   416,   417,   418,   419,
     420,   421,   422,   423,   424,   425,   426,     0,   427,   428,
       0,     0,     0,   429,   430,   431,   432,     0,     0,     0,
     433,     0,     0,     0,   434,     0,   435,   436,   437,   438,
     439,   440,     0,   441,   442,   443,   444,   445,   446,     0,
       0,     0,     0,     0,     0,   447,   448,     0,   449,     0,
       0,   450,     0,     0,   451,   452,     0,     0,     0,   453,
       0,     0,   454,   455,     0,   456,   457,   458,   459,   460,
     461,     0,     0,   462,   463,   464,   465,     0,   466,   467,
       0,   468,     0,   469,   470,   471,   472,     0,  1021,   473,
     474,     0,   475,   476,   477,   478,     0,     0,     0,     0,
       0,   479,   480,   481,     0,     0,     0,   482,   483,   484,
     485,     0,   486,   487,     0,   488,   489,     0,   490,   491,
       0,     0,   492,     0,     0,   493,     0,   494,     0,   495,
     496,   497,     0,     0,     0,     0,     0,     0,   498,     0,
       0,   499,     0,     0,     0,   500,   501,   502,   503,   504,
     505,   506,     0,     0,     0,     0,     0,     0,   507,   508,
       0,   509,   510,   511,     0,   142,   512,   143,   144,   145,
     146,   147,   148,     0,     0,   149,     0,     0,     0,   150,
       0,     0,   151,     0,   152,   153,   154,   155,   156,   157,
     158,   159,     0,   160,     0,     0,     0,   161,     0,     0,
       0,   162,     0,     0,   163,   164,   165,     0,   166,     0,
     167,   168,     0,     0,   169,     0,     0,   170,   171,     0,
     172,   173,     0,   174,   175,     0,   176,   177,   178,   179,
     180,   181,   182,     0,   183,   184,   185,   186,   187,   188,
     189,     0,   190,   191,   192,   193,   194,   195,   196,   197,
       0,   198,   199,     0,   200,   201,   202,   203,   204,     0,
     205,     0,     0,   206,     0,     0,   207,     0,   208,     0,
       0,   209,     0,   210,     0,     0,     0,   211,   212,   213,
       0,     0,   214,     0,     0,     0,     0,   215,   216,     0,
       0,     0,     0,   217,     0,   218,     0,     0,     0,   219,
       0,   220,   221,   222,   223,   224,     0,     0,     0,   225,
       0,     0,   226,   227,   228,     0,     0,     0,   229,     0,
     230,   231,     0,   232,   233,   234,     0,     0,   235,   236,
       0,   237,   238,   239,   240,   241,   242,   243,     0,     0,
     244,   245,   246,   247,     0,     0,   248,   249,     0,   250,
     251,   252,     0,     0,   253,     0,     0,     0,   254,     0,
     255,     0,   256,     0,   257,   258,   259,   260,   261,   262,
     263,     0,   264,     0,     0,     0,   265,   266,   267,     0,
     268,     0,     0,     0,   269,   270,     0,     0,     0,   271,
     272,   273,   274,   275,     0,     0,   276,   277,   278,     0,
     279,     0,   280,     0,     0,     0,     0,   281,   282,     0,
       0,     0,   283,     0,   284,   285,     0,   286,   287,     0,
       0,     0,   288,     0,     0,   289,   290,   291,     0,     0,
     292,     0,     0,   293,   294,     0,     0,     0,     0,     0,
     295,   296,     0,   297,     0,   298,     0,   299,   300,     0,
       0,  1999,     0,     0,     0,     0,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,     0,   317,   318,   319,   320,     0,   321,   322,
     323,   324,     0,   325,   326,     0,     0,     0,     0,   327,
     328,   329,   330,   331,   332,     0,     0,   333,   334,     0,
     335,     0,   336,     0,   337,   338,   339,   340,   341,   342,
     343,   344,   345,     0,     0,   346,   347,     0,     0,   348,
     349,   350,   351,     0,     0,     0,   352,   353,     0,     0,
    2000,   354,     0,   355,   356,   357,     0,   358,   359,   360,
     361,     0,   362,   363,     0,     0,     0,     0,     0,     0,
       0,     0,   364,   365,   366,     0,   753,   367,     0,   368,
       0,   369,   370,   371,   372,   373,   374,   375,   376,   377,
     378,     0,     0,   379,   380,   381,     0,   382,     0,   383,
     384,   385,   386,   387,     0,   388,   389,   390,     0,     0,
     391,     0,     0,     0,   392,   393,   394,   395,   396,     0,
       0,   397,   398,   399,   400,   401,     0,   402,   403,     0,
     404,   405,   406,     0,     0,   407,     0,   408,     0,   409,
     410,     0,   411,   412,     0,   413,     0,   414,     0,     0,
     415,   416,   417,   418,  2001,   420,   421,   422,   423,   424,
     425,   426,     0,   427,   428,     0,     0,     0,   429,   430,
     431,   432,     0,     0,     0,   433,     0,     0,     0,   434,
       0,   435,   436,   437,   438,   439,   440,     0,   441,   442,
     443,   444,   445,   446,     0,     0,     0,     0,     0,     0,
     447,   448,     0,   449,     0,     0,   450,     0,     0,   451,
     452,     0,     0,     0,   453,     0,     0,   454,   455,     0,
     456,   457,   458,   459,   460,   461,     0,     0,   462,   463,
     464,   465,     0,   466,   467,     0,   468,     0,   469,   470,
     471,   472,     0,     0,   473,   474,     0,   475,   476,   477,
     478,     0,     0,     0,     0,     0,   479,   480,   481,     0,
       0,     0,   482,   483,   484,   485,  2002,   486,   487,     0,
     488,   489,     0,   490,   491,     0,     0,   492,     0,     0,
     493,     0,   494,     0,   495,   496,   497,     0,     0,     0,
       0,     0,     0,   498,     0,     0,   499,     0,     0,     0,
     500,   501,   502,   503,   504,   505,   506,     0,     0,     0,
       0,     0,     0,   507,   508,     0,   509,   510,   511,     0,
     142,   512,   143,   144,   145,   146,   147,   148,     0,     0,
     149,     0,     0,     0,   150,     0,     0,   151,     0,   152,
     153,   154,   155,   156,   157,   158,   159,     0,   160,     0,
       0,     0,   161,     0,     0,     0,   162,     0,     0,   163,
     164,   165,     0,   166,     0,   167,   168,     0,     0,   169,
       0,     0,   170,   171,     0,   172,   173,     0,   174,   175,
       0,   176,   177,   178,   179,   180,   181,   182,     0,   183,
     184,   185,   186,   187,   188,   189,     0,   190,   191,   192,
     193,   194,   195,   196,   197,     0,   198,   199,     0,   200,
     201,   202,   203,   204,     0,   205,     0,     0,   206,     0,
       0,   207,     0,   208,     0,     0,   209,     0,   210,     0,
       0,     0,   211,   212,   213,     0,     0,   214,     0,     0,
       0,     0,   215,   216,     0,     0,     0,     0,   217,     0,
     218,     0,     0,     0,   219,     0,   220,   221,   222,   223,
     224,     0,     0,     0,   225,     0,     0,   226,   227,   228,
       0,     0,     0,   229,     0,   230,   231,     0,   232,   233,
     234,     0,     0,   235,   236,     0,   237,   238,   239,   240,
     241,   242,   243,     0,     0,   244,   245,   246,   247,     0,
       0,   248,   249,     0,   250,   251,   252,     0,     0,   253,
       0,     0,     0,   254,     0,   255,     0,   256,     0,   257,
     258,   259,   260,   261,   262,   263,     0,   264,     0,     0,
       0,   265,   266,   267,     0,   268,     0,     0,     0,   269,
     270,     0,     0,     0,   271,   272,   273,   274,   275,     0,
       0,   276,   277,   278,     0,   279,     0,   280,     0,     0,
       0,     0,   281,   282,     0,     0,     0,   283,     0,   284,
     285,     0,   286,   287,     0,     0,     0,   288,     0,     0,
     289,   290,   291,     0,     0,   292,     0,     0,   293,   294,
       0,     0,     0,     0,     0,   295,   296,     0,   297,     0,
     298,     0,   299,   300,     0,     0,  1999,     0,     0,     0,
       0,   301,   302,   303,   304,   305,   306,   307,   308,   309,
     310,   311,   312,   313,   314,   315,   316,     0,   317,   318,
     319,   320,     0,   321,   322,   323,   324,     0,   325,   326,
       0,     0,     0,     0,   327,   328,   329,   330,   331,   332,
       0,     0,   333,   334,     0,   335,     0,   336,     0,   337,
     338,   339,   340,   341,   342,   343,   344,   345,     0,     0,
     346,   347,     0,     0,   348,   349,   350,   351,     0,     0,
       0,   352,   353,     0,     0,  2000,   354,     0,   355,   356,
     357,     0,   358,   359,   360,   361,     0,   362,   363,     0,
       0,     0,     0,     0,     0,     0,     0,   364,   365,   366,
       0,   753,   367,     0,   368,     0,   369,   370,   371,   372,
     373,   374,   375,   376,   377,   378,     0,     0,   379,   380,
     381,     0,   382,     0,   383,   384,   385,   386,   387,     0,
     388,   389,   390,     0,     0,   391,     0,     0,     0,   392,
     393,   394,   395,   396,     0,     0,   397,   398,   399,   400,
     401,     0,   402,   403,     0,   404,   405,   406,     0,     0,
     407,     0,   408,     0,   409,   410,     0,   411,   412,     0,
     413,     0,   414,     0,     0,   415,   416,   417,   418,   419,
     420,   421,   422,   423,   424,   425,   426,     0,   427,   428,
       0,     0,     0,   429,   430,   431,   432,     0,     0,     0,
     433,     0,     0,     0,   434,     0,   435,   436,   437,   438,
     439,   440,     0,   441,   442,   443,   444,   445,   446,     0,
       0,     0,     0,     0,     0,   447,   448,     0,   449,     0,
       0,   450,     0,     0,   451,   452,     0,     0,     0,   453,
       0,     0,   454,   455,     0,   456,   457,   458,   459,   460,
     461,     0,     0,   462,   463,   464,   465,     0,   466,   467,
       0,   468,     0,   469,   470,   471,   472,     0,     0,   473,
     474,     0,   475,   476,   477,   478,     0,     0,     0,     0,
       0,   479,   480,   481,     0,     0,     0,   482,   483,   484,
     485,  2002,   486,   487,     0,   488,   489,     0,   490,   491,
       0,     0,   492,     0,     0,   493,     0,   494,     0,   495,
     496,   497,     0,     0,     0,     0,     0,     0,   498,     0,
       0,   499,     0,     0,     0,   500,   501,   502,   503,   504,
     505,   506,     0,     0,     0,     0,     0,     0,   507,   508,
       0,   509,   510,   511,     0,   142,   512,   143,   144,   145,
     146,   147,   148,     0,     0,   149,     0,     0,     0,   150,
       0,     0,   151,     0,   152,   153,   154,   155,   156,   157,
     158,   159,     0,   160,     0,     0,  1425,   161,     0,     0,
       0,   162,     0,     0,   163,   164,   165,     0,   166,     0,
     167,   168,     0,     0,   169,     0,     0,   170,   171,     0,
     172,   173,     0,   174,   175,     0,   176,   177,   178,   179,
     180,   181,   182,     0,   183,   184,   185,   186,   187,   188,
     189,     0,   190,   191,   192,   193,   194,   195,   196,   197,
       0,   198,   199,     0,   200,   201,   202,   203,   204,     0,
     205,     0,     0,   206,     0,     0,   207,     0,   208,     0,
       0,   209,     0,   210,     0,     0,     0,   211,   212,   213,
       0,     0,   214,     0,     0,     0,     0,   215,   216,     0,
       0,     0,  1426,   217,     0,   218,     0,     0,     0,   219,
       0,   220,   221,   222,   223,   224,     0,     0,     0,   225,
       0,     0,   226,   227,   228,     0,     0,     0,   229,     0,
     230,   231,     0,   232,   233,   234,     0,     0,   235,   236,
       0,   237,   238,   239,   240,   241,   242,   243,     0,     0,
     244,   245,   246,   247,     0,     0,   248,   249,     0,   250,
     251,   252,     0,     0,   253,     0,     0,     0,   254,     0,
     255,     0,   256,     0,   257,   258,   259,   260,   261,   262,
     263,     0,   264,     0,     0,     0,   265,   266,   267,     0,
     268,     0,     0,     0,   269,   270,     0,     0,     0,   271,
     272,   273,   274,   275,     0,     0,   276,   277,   278,     0,
     279,     0,   280,     0,     0,     0,     0,   281,   282,     0,
       0,     0,   283,     0,   284,   285,     0,   286,   287,     0,
       0,     0,   288,     0,     0,   289,   290,   291,     0,     0,
     292,     0,     0,   293,   294,   643,     0,     0,     0,     0,
     295,   296,     0,   297,     0,   298,     0,   299,   300,     0,
       0,     0,     0,     0,     0,     0,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,     0,   317,   318,   319,   320,     0,   321,   322,
     323,   324,     0,   325,   326,     0,     0,     0,     0,   327,
     328,   329,   330,   331,   332,     0,     0,   333,   334,     0,
     335,     0,   336,     0,   337,   338,   339,   340,   341,   342,
     343,   344,   345,     0,     0,   346,   347,     0,     0,   348,
     349,   350,   351,     0,     0,     0,   352,   353,     0,     0,
       0,   354,     0,   355,   356,   357,     0,   358,   359,   360,
     361,     0,   362,   363,     0,     0,     0,     0,     0,     0,
       0,     0,   364,   365,   366,     0,     0,   367,     0,   368,
       0,   369,   370,   371,   372,   373,   374,   375,   376,   377,
     378,     0,     0,   379,   380,   381,     0,   382,     0,   383,
     384,   385,   386,   387,     0,   388,   389,   390,     0,     0,
     391,     0,     0,     0,   392,   393,   394,   395,   396,     0,
       0,   397,   398,   399,   400,   401,     0,   402,   403,     0,
     404,   405,   406,     0,     0,   407,     0,   408,     0,   409,
     410,     0,   411,   412,     0,   413,     0,   414,     0,     0,
     415,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,     0,   427,   428,     0,     0,     0,   429,   430,
     431,   432,     0,     0,     0,   433,     0,     0,     0,   434,
       0,   435,   436,   437,   438,   439,   440,     0,   441,   442,
     443,   444,   445,   446,     0,     0,     0,     0,     0,     0,
     447,   448,     0,   449,     0,     0,   450,     0,     0,   451,
     452,     0,     0,     0,   453,     0,     0,   454,   455,     0,
     456,   457,   458,   459,   460,   461,     0,     0,   462,   463,
     464,   465,     0,   466,   467,     0,   468,     0,   469,   470,
     471,   472,     0,   139,   473,   474,     0,   475,   476,   477,
     478,     0,     0,     0,     0,     0,   479,   480,   481,     0,
       0,     0,   482,   483,   484,   485,     0,   486,   487,     0,
     488,   489,     0,   490,   491,     0,     0,   492,     0,     0,
     493,     0,   494,     0,   495,   496,   497,     0,     0,     0,
       0,     0,     0,   498,     0,     0,   499,     0,     0,     0,
     500,   501,   502,   503,   504,   505,   506,     0,     0,     0,
       0,     0,     0,   507,   508,     0,   509,   510,   511,     0,
     142,   512,   143,   144,   145,   146,   147,   148,     0,     0,
     149,     0,     0,     0,   150,     0,     0,   151,     0,   152,
     153,   154,   155,   156,   157,   158,   159,     0,   160,     0,
       0,     0,   161,     0,     0,     0,   162,     0,     0,   163,
     164,   165,     0,   166,     0,   167,   168,     0,     0,   169,
       0,     0,   170,   171,     0,   172,   173,     0,   174,   175,
       0,   176,   177,   178,   179,   180,   181,   182,     0,   183,
     184,   185,   186,   187,   188,   189,     0,   190,   191,   192,
     193,   194,   195,   196,   197,     0,   198,   199,     0,   200,
     201,   202,   203,   204,     0,   205,     0,     0,   206,     0,
       0,   207,     0,   208,     0,     0,   209,     0,   210,     0,
       0,     0,   211,   212,   213,     0,     0,   214,     0,     0,
       0,     0,   215,   216,     0,     0,     0,     0,   217,     0,
     218,     0,     0,     0,   219,     0,   220,   221,   222,   223,
     224,     0,     0,     0,   225,     0,     0,   226,   227,   228,
       0,     0,     0,   229,     0,   230,   231,     0,   232,   233,
     234,     0,     0,   235,   236,     0,   237,   238,   239,   240,
     241,   242,   243,     0,     0,   244,   245,   246,   247,     0,
       0,   248,   249,     0,   250,   251,   252,     0,     0,   253,
       0,     0,     0,   254,     0,   255,     0,   256,     0,   257,
     258,   259,   260,   261,   262,   263,     0,   264,     0,     0,
       0,   265,   266,   267,     0,   268,     0,     0,     0,   269,
     270,     0,     0,     0,   271,   272,   273,   274,   275,     0,
       0,   276,   277,   278,     0,   279,     0,   280,     0,     0,
       0,     0,   281,   282,     0,     0,     0,   283,     0,   284,
     285,     0,   286,   287,     0,     0,     0,   288,     0,     0,
     289,   290,   291,     0,     0,   292,     0,     0,   293,   294,
       0,     0,     0,     0,     0,   295,   296,     0,   297,     0,
     298,     0,   299,   300,     0,     0,  1999,     0,     0,     0,
       0,   301,   302,   303,   304,   305,   306,   307,   308,   309,
     310,   311,   312,   313,   314,   315,   316,     0,   317,   318,
     319,   320,     0,   321,   322,   323,   324,     0,   325,   326,
       0,     0,     0,     0,   327,   328,   329,   330,   331,   332,
       0,     0,   333,   334,     0,   335,     0,   336,     0,   337,
     338,   339,   340,   341,   342,   343,   344,   345,     0,     0,
     346,   347,     0,     0,   348,   349,   350,   351,     0,     0,
       0,   352,   353,     0,     0,  2000,   354,     0,   355,   356,
     357,     0,   358,   359,   360,   361,     0,   362,   363,     0,
       0,     0,     0,     0,     0,     0,     0,   364,   365,   366,
       0,   753,   367,     0,   368,     0,   369,   370,   371,   372,
     373,   374,   375,   376,   377,   378,     0,     0,   379,   380,
     381,     0,   382,     0,   383,   384,   385,   386,   387,     0,
     388,   389,   390,     0,     0,   391,     0,     0,     0,   392,
     393,   394,   395,   396,     0,     0,   397,   398,   399,   400,
     401,     0,   402,   403,     0,   404,   405,   406,     0,     0,
     407,     0,   408,     0,   409,   410,     0,   411,   412,     0,
     413,     0,   414,     0,     0,   415,   416,   417,   418,  4009,
     420,   421,   422,   423,   424,   425,   426,     0,   427,   428,
       0,     0,     0,   429,   430,   431,   432,     0,     0,     0,
     433,     0,     0,     0,   434,     0,   435,   436,   437,   438,
     439,   440,     0,   441,   442,   443,   444,   445,   446,     0,
       0,     0,     0,     0,     0,   447,   448,     0,   449,     0,
       0,   450,     0,     0,   451,   452,     0,     0,     0,   453,
       0,     0,   454,   455,     0,   456,   457,   458,   459,   460,
     461,     0,     0,   462,   463,   464,   465,     0,   466,   467,
       0,   468,     0,   469,   470,   471,   472,     0,     0,   473,
     474,     0,   475,   476,   477,   478,     0,     0,     0,     0,
       0,   479,   480,   481,     0,     0,     0,   482,   483,   484,
     485,  2002,   486,   487,     0,   488,   489,     0,   490,   491,
       0,     0,   492,     0,     0,   493,     0,   494,     0,   495,
     496,   497,     0,     0,     0,     0,     0,     0,   498,     0,
       0,   499,     0,     0,     0,   500,   501,   502,   503,   504,
     505,   506,     0,     0,     0,     0,     0,     0,   507,   508,
       0,   509,   510,   511,     0,   142,   512,   143,   144,   145,
     146,   147,   148,     0,     0,   149,     0,     0,     0,   150,
       0,     0,   151,     0,   152,   153,   154,   155,   156,   157,
     158,   159,     0,   160,     0,     0,     0,   161,     0,     0,
       0,   162,     0,     0,   163,   164,   165,     0,   166,     0,
     167,   168,     0,     0,   169,     0,     0,   170,   171,     0,
     172,   173,     0,   174,   175,     0,   176,   177,   178,   179,
     180,   181,   182,     0,   183,   184,   185,   186,   187,   188,
     189,     0,   190,   191,   192,   193,   194,   195,   196,   197,
       0,   198,   199,     0,   200,   201,   202,   203,   204,     0,
     205,     0,     0,   206,     0,     0,   207,     0,   208,     0,
     843,   209,     0,   210,     0,     0,     0,   211,   212,   213,
       0,     0,   214,     0,     0,     0,     0,   215,   216,     0,
       0,     0,     0,   217,     0,   218,     0,     0,     0,   219,
       0,   220,   221,   222,   223,   224,     0,     0,     0,   225,
       0,     0,   226,   227,   228,     0,     0,     0,   229,     0,
     230,   231,     0,   232,   233,   234,     0,     0,   235,   236,
       0,   237,   238,   239,   240,   241,   242,   243,     0,     0,
     244,   245,   246,   247,     0,     0,   248,   249,     0,   250,
     251,   252,     0,     0,   253,     0,     0,     0,   254,     0,
     255,     0,   256,     0,   257,   258,   259,   260,   261,   262,
     263,     0,   264,     0,     0,     0,   265,   266,   267,     0,
     268,     0,     0,     0,   269,   270,     0,     0,     0,   271,
     272,   273,   274,   275,     0,     0,   276,   277,   278,     0,
     279,     0,   280,     0,     0,     0,     0,   281,   282,     0,
       0,     0,   283,     0,   284,   285,     0,   286,   287,     0,
       0,     0,   288,     0,     0,   289,   290,   291,     0,     0,
     292,     0,     0,   293,   294,   643,     0,     0,     0,     0,
     295,   296,     0,   297,     0,   298,     0,   299,   300,     0,
       0,     0,     0,     0,     0,     0,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,     0,   317,   318,   319,   320,     0,   321,   322,
     323,   324,     0,   325,   326,     0,     0,     0,     0,   327,
     328,   329,   330,   331,   332,     0,     0,   333,   334,     0,
     335,     0,   336,     0,   337,   338,   339,   340,   341,   342,
     343,   344,   345,     0,     0,   346,   347,     0,     0,   348,
     349,   350,   351,     0,     0,     0,   352,   353,     0,     0,
       0,   354,     0,   355,   356,   357,     0,   358,   359,   360,
     361,     0,   362,   363,     0,     0,     0,     0,     0,     0,
       0,     0,   364,   365,   366,     0,     0,   367,     0,   368,
       0,   369,   370,   371,   372,   373,   374,   375,   376,   377,
     378,     0,     0,   379,   380,   381,     0,   382,     0,   383,
     384,   385,   386,   387,     0,   388,   389,   390,     0,     0,
     391,     0,     0,     0,   392,   393,   394,   395,   396,     0,
       0,   397,   398,   399,   400,   401,     0,   402,   403,     0,
     404,   405,   406,     0,     0,   407,     0,   408,     0,   409,
     410,     0,   411,   412,     0,   413,     0,   414,     0,     0,
     415,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,     0,   427,   428,     0,     0,     0,   429,   430,
     431,   432,     0,     0,     0,   433,     0,     0,     0,   434,
       0,   435,   436,   437,   438,   439,   440,     0,   441,   442,
     443,   444,   445,   446,     0,     0,     0,     0,     0,     0,
     447,   448,     0,   449,     0,     0,   450,     0,     0,   451,
     452,     0,     0,     0,   453,     0,     0,   454,   455,     0,
     456,   457,   458,   459,   460,   461,     0,     0,   462,   463,
     464,   465,     0,   466,   467,     0,   468,     0,   469,   470,
     471,   472,     0,   139,   473,   474,     0,   475,   476,   477,
     478,     0,     0,     0,     0,     0,   479,   480,   481,     0,
       0,     0,   482,   483,   484,   485,     0,   486,   487,     0,
     488,   489,     0,   490,   491,     0,     0,   492,     0,     0,
     493,     0,   494,     0,   495,   496,   497,     0,     0,     0,
       0,     0,     0,   498,     0,     0,   499,     0,     0,     0,
     500,   501,   502,   503,   504,   505,   506,     0,     0,     0,
       0,     0,     0,   507,   508,     0,   509,   510,   511,     0,
     142,   512,   143,   144,   145,   146,   147,   148,     0,     0,
     149,     0,     0,     0,   150,     0,     0,   151,     0,   152,
     153,   154,   155,   156,   157,   158,   159,     0,   160,     0,
       0,     0,   161,     0,     0,     0,   162,     0,     0,   163,
     164,   165,     0,   166,     0,   167,   168,     0,     0,   169,
       0,     0,   170,   171,     0,   172,   173,     0,   174,   175,
       0,   176,   177,   178,   179,   180,   181,   182,     0,   183,
     184,   185,   186,   187,   188,   189,     0,   190,   191,   192,
     193,   194,   195,   196,   197,     0,   198,   199,     0,   200,
     201,   202,   203,   204,     0,   205,     0,     0,   206,     0,
       0,   207,     0,   208,  1047,     0,   209,     0,   210,     0,
       0,     0,   211,   212,   213,     0,     0,   214,     0,     0,
       0,     0,   215,   216,     0,     0,     0,     0,   217,     0,
     218,     0,     0,     0,   219,     0,   220,   221,   222,   223,
     224,     0,     0,     0,   225,     0,     0,   226,   227,   228,
       0,     0,     0,   229,     0,   230,   231,     0,   232,   233,
     234,     0,     0,   235,   236,     0,   237,   238,   239,   240,
     241,   242,   243,     0,     0,   244,   245,   246,   247,     0,
       0,   248,   249,     0,   250,   251,   252,     0,     0,   253,
       0,     0,     0,   254,     0,   255,     0,   256,     0,   257,
     258,   259,   260,   261,   262,   263,     0,   264,     0,     0,
       0,   265,   266,   267,     0,   268,     0,     0,     0,   269,
     270,     0,     0,     0,   271,   272,   273,   274,   275,     0,
       0,   276,   277,   278,     0,   279,     0,   280,     0,     0,
       0,     0,   281,   282,     0,     0,     0,   283,     0,   284,
     285,     0,   286,   287,     0,     0,     0,   288,     0,     0,
     289,   290,   291,     0,     0,   292,     0,     0,   293,   294,
     643,     0,     0,     0,     0,   295,   296,     0,   297,     0,
     298,     0,   299,   300,     0,     0,     0,     0,     0,     0,
       0,   301,   302,   303,   304,   305,   306,   307,   308,   309,
     310,   311,   312,   313,   314,   315,   316,     0,   317,   318,
     319,   320,     0,   321,   322,   323,   324,     0,   325,   326,
       0,     0,     0,     0,   327,   328,   329,   330,   331,   332,
       0,     0,   333,   334,     0,   335,     0,   336,     0,   337,
     338,   339,   340,   341,   342,   343,   344,   345,     0,     0,
     346,   347,     0,     0,   348,   349,   350,   351,     0,     0,
       0,   352,   353,     0,     0,     0,   354,     0,   355,   356,
     357,     0,   358,   359,   360,   361,     0,   362,   363,     0,
       0,     0,     0,     0,     0,     0,     0,   364,   365,   366,
       0,     0,   367,     0,   368,     0,   369,   370,   371,   372,
     373,   374,   375,   376,   377,   378,     0,     0,   379,   380,
     381,     0,   382,     0,   383,   384,   385,   386,   387,     0,
     388,   389,   390,     0,     0,   391,     0,     0,     0,   392,
     393,   394,   395,   396,     0,     0,   397,   398,   399,   400,
     401,     0,   402,   403,     0,   404,   405,   406,     0,     0,
     407,     0,   408,     0,   409,   410,     0,   411,   412,     0,
     413,     0,   414,     0,     0,   415,   416,   417,   418,   419,
     420,   421,   422,   423,   424,   425,   426,     0,   427,   428,
       0,     0,     0,   429,   430,   431,   432,     0,     0,     0,
     433,     0,     0,     0,   434,     0,   435,   436,   437,   438,
     439,   440,     0,   441,   442,   443,   444,   445,   446,     0,
       0,     0,     0,     0,     0,   447,   448,     0,   449,     0,
       0,   450,     0,     0,   451,   452,     0,     0,     0,   453,
       0,     0,   454,   455,     0,   456,   457,   458,   459,   460,
     461,     0,     0,   462,   463,   464,   465,     0,   466,   467,
       0,   468,     0,   469,   470,   471,   472,     0,   139,   473,
     474,     0,   475,   476,   477,   478,     0,     0,     0,     0,
       0,   479,   480,   481,     0,     0,     0,   482,   483,   484,
     485,     0,   486,   487,     0,   488,   489,     0,   490,   491,
       0,     0,   492,     0,     0,   493,     0,   494,     0,   495,
     496,   497,     0,     0,     0,     0,     0,     0,   498,     0,
       0,   499,     0,     0,     0,   500,   501,   502,   503,   504,
     505,   506,     0,     0,     0,     0,     0,     0,   507,   508,
       0,   509,   510,   511,     0,   142,   512,   143,   144,   145,
     146,   147,   148,  1462,     0,   149,     0,     0,     0,   150,
       0,     0,   151,     0,   152,   153,   154,   155,   156,   157,
     158,   159,     0,   160,     0,     0,     0,   161,     0,     0,
       0,   162,     0,     0,   163,   164,   165,     0,   166,     0,
     167,   168,     0,     0,   169,     0,     0,   170,   171,     0,
     172,   173,     0,   174,   175,     0,   176,   177,   178,   179,
     180,   181,   182,     0,   183,   184,   185,   186,   187,   188,
     189,     0,   190,   191,   192,   193,   194,   195,   196,   197,
       0,   198,   199,     0,   200,   201,   202,   203,   204,     0,
     205,     0,     0,   206,     0,     0,   207,     0,   208,     0,
       0,   209,     0,   210,     0,     0,     0,   211,   212,   213,
       0,     0,   214,     0,     0,     0,     0,   215,   216,     0,
       0,     0,     0,   217,     0,   218,     0,     0,     0,   219,
       0,   220,   221,   222,   223,   224,     0,     0,     0,   225,
       0,     0,   226,   227,   228,     0,     0,     0,   229,     0,
     230,   231,     0,   232,   233,   234,     0,     0,   235,   236,
       0,   237,   238,   239,   240,   241,   242,   243,     0,     0,
     244,   245,   246,   247,     0,     0,   248,   249,     0,   250,
     251,   252,     0,     0,   253,     0,     0,     0,   254,     0,
     255,     0,   256,     0,   257,   258,   259,   260,   261,   262,
     263,     0,   264,     0,     0,     0,   265,   266,   267,     0,
     268,     0,     0,     0,   269,   270,     0,     0,     0,   271,
     272,   273,   274,   275,     0,     0,   276,   277,   278,     0,
     279,     0,   280,     0,     0,     0,     0,   281,   282,     0,
       0,     0,   283,     0,   284,   285,     0,   286,   287,     0,
       0,     0,   288,     0,     0,   289,   290,   291,     0,     0,
     292,     0,     0,   293,   294,   643,     0,     0,     0,     0,
     295,   296,     0,   297,     0,   298,     0,   299,   300,     0,
       0,     0,     0,     0,     0,     0,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,     0,   317,   318,   319,   320,     0,   321,   322,
     323,   324,     0,   325,   326,     0,     0,     0,     0,   327,
     328,   329,   330,   331,   332,     0,     0,   333,   334,     0,
     335,     0,   336,     0,   337,   338,   339,   340,   341,   342,
     343,   344,   345,     0,     0,   346,   347,     0,     0,   348,
     349,   350,   351,     0,     0,     0,   352,   353,     0,     0,
       0,   354,     0,   355,   356,   357,     0,   358,   359,   360,
     361,     0,   362,   363,     0,     0,     0,     0,     0,     0,
       0,     0,   364,   365,   366,     0,     0,   367,     0,   368,
       0,   369,   370,   371,   372,   373,   374,   375,   376,   377,
     378,     0,     0,   379,   380,   381,     0,   382,     0,   383,
     384,   385,   386,   387,     0,   388,   389,   390,     0,     0,
     391,     0,     0,     0,   392,   393,   394,   395,   396,     0,
       0,   397,   398,   399,   400,   401,     0,   402,   403,     0,
     404,   405,   406,     0,     0,   407,     0,   408,     0,   409,
     410,     0,   411,   412,     0,   413,     0,   414,     0,     0,
     415,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,     0,   427,   428,     0,     0,     0,   429,   430,
     431,   432,     0,     0,     0,   433,     0,     0,     0,   434,
       0,   435,   436,   437,   438,   439,   440,     0,   441,   442,
     443,   444,   445,   446,     0,     0,     0,     0,     0,     0,
     447,   448,     0,   449,     0,     0,   450,     0,     0,   451,
     452,     0,     0,     0,   453,     0,     0,   454,   455,     0,
     456,   457,   458,   459,   460,   461,     0,     0,   462,   463,
     464,   465,     0,   466,   467,     0,   468,     0,   469,   470,
     471,   472,     0,   139,   473,   474,     0,   475,   476,   477,
     478,     0,     0,     0,     0,     0,   479,   480,   481,     0,
       0,     0,   482,   483,   484,   485,     0,   486,   487,     0,
     488,   489,     0,   490,   491,     0,     0,   492,     0,     0,
     493,     0,   494,     0,   495,   496,   497,     0,     0,     0,
       0,     0,     0,   498,     0,     0,   499,     0,     0,     0,
     500,   501,   502,   503,   504,   505,   506,     0,     0,     0,
       0,     0,     0,   507,   508,     0,   509,   510,   511,     0,
     142,   512,   143,   144,   145,   146,   147,   148,     0,     0,
     149,     0,     0,     0,   150,     0,     0,   151,     0,   152,
     153,   154,   155,   156,   157,   158,   159,     0,   160,     0,
       0,     0,   161,     0,     0,     0,   162,     0,     0,   163,
     164,   165,     0,   166,     0,   167,   168,     0,     0,   169,
       0,     0,   170,   171,     0,   172,   173,     0,   174,   175,
       0,   176,   177,   178,   179,   180,   181,   182,     0,   183,
     184,   185,   186,   187,   188,   189,     0,   190,   191,   192,
     193,   194,   195,   196,   197,     0,   198,   199,     0,   200,
     201,   202,   203,   204,     0,   205,     0,     0,   206,     0,
       0,   207,     0,   208,     0,     0,   209,     0,   210,     0,
       0,     0,   211,   212,   213,     0,     0,   214,     0,     0,
       0,     0,   215,   216,     0,     0,     0,  2463,   217,     0,
     218,     0,     0,     0,   219,     0,   220,   221,   222,   223,
     224,     0,     0,     0,   225,     0,     0,   226,   227,   228,
       0,     0,     0,   229,     0,   230,   231,     0,   232,   233,
     234,     0,     0,   235,   236,     0,   237,   238,   239,   240,
     241,   242,   243,     0,     0,   244,   245,   246,   247,     0,
       0,   248,   249,     0,   250,   251,   252,     0,     0,   253,
       0,     0,     0,   254,     0,   255,     0,   256,     0,   257,
     258,   259,   260,   261,   262,   263,     0,   264,     0,     0,
       0,   265,   266,   267,     0,   268,     0,     0,     0,   269,
     270,     0,     0,     0,   271,   272,   273,   274,   275,     0,
       0,   276,   277,   278,     0,   279,     0,   280,     0,     0,
       0,     0,   281,   282,     0,     0,     0,   283,     0,   284,
     285,     0,   286,   287,     0,     0,     0,   288,     0,     0,
     289,   290,   291,     0,     0,   292,     0,     0,   293,   294,
     643,     0,     0,     0,     0,   295,   296,     0,   297,     0,
     298,     0,   299,   300,     0,     0,     0,     0,     0,     0,
       0,   301,   302,   303,   304,   305,   306,   307,   308,   309,
     310,   311,   312,   313,   314,   315,   316,     0,   317,   318,
     319,   320,     0,   321,   322,   323,   324,     0,   325,   326,
       0,     0,     0,     0,   327,   328,   329,   330,   331,   332,
       0,     0,   333,   334,     0,   335,     0,   336,     0,   337,
     338,   339,   340,   341,   342,   343,   344,   345,     0,     0,
     346,   347,     0,     0,   348,   349,   350,   351,     0,     0,
       0,   352,   353,     0,     0,     0,   354,     0,   355,   356,
     357,     0,   358,   359,   360,   361,     0,   362,   363,     0,
       0,     0,     0,     0,     0,     0,     0,   364,   365,   366,
       0,     0,   367,     0,   368,     0,   369,   370,   371,   372,
     373,   374,   375,   376,   377,   378,     0,     0,   379,   380,
     381,     0,   382,     0,   383,   384,   385,   386,   387,     0,
     388,   389,   390,     0,     0,   391,     0,     0,     0,   392,
     393,   394,   395,   396,     0,     0,   397,   398,   399,   400,
     401,     0,   402,   403,     0,   404,   405,   406,     0,     0,
     407,     0,   408,     0,   409,   410,     0,   411,   412,     0,
     413,     0,   414,     0,     0,   415,   416,   417,   418,   419,
     420,   421,   422,   423,   424,   425,   426,     0,   427,   428,
       0,     0,     0,   429,   430,   431,   432,     0,     0,     0,
     433,     0,     0,     0,   434,     0,   435,   436,   437,   438,
     439,   440,     0,   441,   442,   443,   444,   445,   446,     0,
       0,     0,     0,     0,     0,   447,   448,     0,   449,     0,
       0,   450,     0,     0,   451,   452,     0,     0,     0,   453,
       0,     0,   454,   455,     0,   456,   457,   458,   459,   460,
     461,     0,     0,   462,   463,   464,   465,     0,   466,   467,
       0,   468,     0,   469,   470,   471,   472,     0,   139,   473,
     474,     0,   475,   476,   477,   478,     0,     0,     0,     0,
       0,   479,   480,   481,     0,     0,     0,   482,   483,   484,
     485,     0,   486,   487,     0,   488,   489,     0,   490,   491,
       0,     0,   492,     0,     0,   493,     0,   494,     0,   495,
     496,   497,     0,     0,     0,     0,     0,     0,   498,     0,
       0,   499,     0,     0,     0,   500,   501,   502,   503,   504,
     505,   506,     0,     0,     0,     0,     0,     0,   507,   508,
       0,   509,   510,   511,     0,   142,   512,   143,   144,   145,
     146,   147,   148,     0,     0,   149,     0,     0,     0,   150,
       0,     0,   151,     0,   152,   153,   154,   155,   156,   157,
     158,   159,     0,   160,     0,     0,  1425,   161,     0,     0,
       0,   162,     0,     0,   163,   164,   165,     0,   166,     0,
     167,   168,     0,     0,   169,     0,     0,   170,   171,     0,
     172,   173,     0,   174,   175,     0,   176,   177,   178,   179,
     180,   181,   182,     0,   183,   184,   185,   186,   187,   188,
     189,     0,   190,   191,   192,   193,   194,   195,   196,   197,
       0,   198,   199,     0,   200,   201,   202,   203,   204,     0,
     205,     0,     0,   206,     0,     0,   207,     0,   208,     0,
       0,   209,     0,   210,     0,     0,     0,   211,   212,   213,
       0,     0,   214,     0,     0,     0,     0,   215,   216,     0,
       0,     0,     0,   217,     0,   218,     0,     0,     0,   219,
       0,   220,   221,   222,   223,   224,     0,     0,     0,   225,
       0,     0,   226,   227,   228,     0,     0,     0,   229,     0,
     230,   231,     0,   232,   233,   234,     0,     0,   235,   236,
       0,   237,   238,   239,   240,   241,   242,   243,     0,     0,
     244,   245,   246,   247,     0,     0,   248,   249,     0,   250,
     251,   252,     0,     0,   253,     0,     0,     0,   254,     0,
     255,     0,   256,     0,   257,   258,   259,   260,   261,   262,
     263,     0,   264,     0,     0,     0,   265,   266,   267,     0,
     268,     0,     0,     0,   269,   270,     0,     0,     0,   271,
     272,   273,   274,   275,     0,     0,   276,   277,   278,     0,
     279,     0,   280,     0,     0,     0,     0,   281,   282,     0,
       0,     0,   283,     0,   284,   285,     0,   286,   287,     0,
       0,     0,   288,     0,     0,   289,   290,   291,     0,     0,
     292,     0,     0,   293,   294,   643,     0,     0,     0,     0,
     295,   296,     0,   297,     0,   298,     0,   299,   300,     0,
       0,     0,     0,     0,     0,     0,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,     0,   317,   318,   319,   320,     0,   321,   322,
     323,   324,     0,   325,   326,     0,     0,     0,     0,   327,
     328,   329,   330,   331,   332,     0,     0,   333,   334,     0,
     335,     0,   336,     0,   337,   338,   339,   340,   341,   342,
     343,   344,   345,     0,     0,   346,   347,     0,     0,   348,
     349,   350,   351,     0,     0,     0,   352,   353,     0,     0,
       0,   354,     0,   355,   356,   357,     0,   358,   359,   360,
     361,     0,   362,   363,     0,     0,     0,     0,     0,     0,
       0,     0,   364,   365,   366,     0,     0,   367,     0,   368,
       0,   369,   370,   371,   372,   373,   374,   375,   376,   377,
     378,     0,     0,   379,   380,   381,     0,   382,     0,   383,
     384,   385,   386,   387,     0,   388,   389,   390,     0,     0,
     391,     0,     0,     0,   392,   393,   394,   395,   396,     0,
       0,   397,   398,   399,   400,   401,     0,   402,   403,     0,
     404,   405,   406,     0,     0,   407,     0,   408,     0,   409,
     410,     0,   411,   412,     0,   413,     0,   414,     0,     0,
     415,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,     0,   427,   428,     0,     0,     0,   429,   430,
     431,   432,     0,     0,     0,   433,     0,     0,     0,   434,
       0,   435,   436,   437,   438,   439,   440,     0,   441,   442,
     443,   444,   445,   446,     0,     0,     0,     0,     0,     0,
     447,   448,     0,   449,     0,     0,   450,     0,     0,   451,
     452,     0,     0,     0,   453,     0,     0,   454,   455,     0,
     456,   457,   458,   459,   460,   461,     0,     0,   462,   463,
     464,   465,     0,   466,   467,     0,   468,     0,   469,   470,
     471,   472,     0,   139,   473,   474,     0,   475,   476,   477,
     478,     0,     0,     0,     0,     0,   479,   480,   481,     0,
       0,     0,   482,   483,   484,   485,     0,   486,   487,     0,
     488,   489,     0,   490,   491,     0,     0,   492,     0,     0,
     493,     0,   494,     0,   495,   496,   497,     0,     0,     0,
       0,     0,     0,   498,     0,     0,   499,     0,     0,     0,
     500,   501,   502,   503,   504,   505,   506,     0,     0,     0,
       0,     0,     0,   507,   508,     0,   509,   510,   511,     0,
     142,   512,   143,   144,   145,   146,   147,   148,     0,     0,
     149,     0,     0,     0,   150,     0,     0,   151,     0,   152,
     153,   154,   155,   156,   157,   158,   159,     0,   160,     0,
       0,     0,   161,     0,     0,     0,   162,     0,     0,   163,
     164,   165,     0,   166,     0,   167,   168,     0,     0,   169,
       0,     0,   170,   171,     0,   172,   173,     0,   174,   175,
       0,   176,   177,   178,   179,   180,   181,   182,     0,   183,
     184,   185,   186,   187,   188,   189,     0,   190,   191,   192,
     193,   194,   195,   196,   197,     0,   198,   199,     0,   200,
     201,   202,   203,   204,     0,   205,     0,     0,   206,     0,
       0,   207,     0,   208,     0,     0,   209,     0,   210,     0,
       0,     0,   211,   212,   213,     0,     0,   214,     0,     0,
       0,     0,   215,   216,     0,     0,     0,     0,   217,     0,
     218,     0,     0,     0,   219,     0,   220,   221,   222,   223,
     224,     0,     0,     0,   225,     0,     0,   226,   227,   228,
       0,     0,     0,   229,     0,   230,   231,     0,   232,   233,
     234,     0,     0,   235,   236,     0,   237,   238,   239,   240,
     241,   242,   243,     0,     0,   244,   245,   246,   247,     0,
       0,   248,   249,     0,   250,   251,   252,     0,     0,   253,
       0,     0,     0,   254,     0,   255,     0,   256,     0,   257,
     258,   259,   260,   261,   262,   263,     0,   264,     0,     0,
       0,   265,   266,   267,     0,   268,     0,     0,     0,   269,
     270,     0,     0,     0,   271,   272,   273,   274,   275,     0,
       0,   276,   277,   278,     0,   279,     0,   280,     0,     0,
       0,     0,   281,   282,     0,     0,     0,   283,     0,   284,
     285,     0,   286,   287,     0,     0,     0,   288,     0,     0,
     289,   290,   291,     0,     0,   292,     0,     0,   293,   294,
     643,     0,     0,     0,     0,   295,   296,     0,   297,     0,
     298,     0,   299,   300,     0,     0,     0,     0,     0,     0,
       0,   301,   302,   303,   304,   305,   306,   307,   308,   309,
     310,   311,   312,   313,   314,   315,   316,     0,   317,   318,
     319,   320,     0,   321,   322,   323,   324,     0,   325,   326,
       0,     0,     0,     0,   327,   328,   329,   330,   331,   332,
       0,     0,   333,   334,     0,   335,     0,   336,     0,   337,
     338,   339,   340,   341,   342,   343,   344,   345,     0,     0,
     346,   347,     0,     0,   348,   349,   350,   351,     0,     0,
       0,   352,   353,     0,     0,     0,   354,     0,   355,   356,
     357,     0,   358,   359,   360,   361,     0,   362,   363,     0,
       0,     0,     0,     0,     0,     0,     0,   364,   365,   366,
       0,     0,   367,     0,   368,     0,   369,   370,   371,   372,
     373,   374,   375,   376,   377,   378,     0,     0,   379,   380,
     381,     0,   382,     0,   383,   384,   385,   386,   387,     0,
     388,   389,   390,     0,     0,   391,     0,     0,     0,   392,
     393,   394,   395,   396,     0,     0,   397,   398,   399,   400,
     401,     0,   402,   403,     0,   404,   405,   406,     0,     0,
     407,     0,   408,     0,   409,   410,     0,   411,   412,     0,
     413,     0,   414,     0,     0,   415,   416,   417,   418,   419,
     420,   421,   422,   423,   424,   425,   426,     0,   427,   428,
       0,     0,     0,   429,   430,   431,   432,     0,     0,     0,
     433,     0,     0,     0,   434,     0,   435,   436,   437,   438,
     439,   440,     0,   441,   442,   443,   444,   445,   446,     0,
       0,     0,     0,     0,     0,   447,   448,     0,   449,     0,
       0,   450,     0,     0,   451,   452,     0,     0,     0,   453,
       0,     0,   454,   455,     0,   456,   457,   458,   459,   460,
     461,     0,     0,   462,   463,   464,   465,     0,   466,   467,
       0,   468,     0,   469,   470,   471,   472,     0,   139,   473,
     474,     0,   475,   476,   477,   478,     0,     0,     0,     0,
       0,   479,   480,   481,     0,     0,     0,   482,   483,   484,
     485,     0,   486,   487,     0,   488,   489,     0,   490,   491,
       0,     0,   492,     0,     0,   493,     0,   494,     0,   495,
     496,   497,     0,     0,     0,     0,     0,     0,   498,     0,
       0,   499,     0,     0,     0,   500,   501,   502,   503,   504,
     505,   506,     0,     0,     0,     0,     0,     0,   507,   508,
       0,   509,   510,   511,     0,   142,   512,   143,   144,   145,
     146,   147,   148,     0,     0,   149,     0,     0,     0,   150,
    2896,     0,   151,     0,   152,   153,   154,   155,   156,   157,
     158,   159,     0,   160,     0,     0,     0,   161,     0,     0,
       0,   162,     0,     0,   163,   164,   165,     0,   166,     0,
     167,   168,     0,     0,   169,     0,     0,   170,   171,     0,
     172,   173,     0,   174,   175,     0,   176,   177,   178,   179,
     180,   181,   182,     0,   183,   184,   185,   186,   187,   188,
     189,     0,   190,   191,   192,   193,   194,   195,   196,   197,
       0,   198,   199,     0,   200,   201,   202,   203,   204,     0,
     205,     0,     0,   206,     0,     0,   207,     0,   208,     0,
       0,   209,     0,   210,     0,     0,     0,   211,   212,   213,
       0,     0,   214,     0,     0,     0,     0,   215,   216,     0,
       0,     0,     0,   217,     0,   218,     0,     0,     0,   219,
       0,   220,   221,   222,   223,   224,     0,     0,     0,   225,
       0,     0,   226,   227,   228,     0,     0,     0,   229,     0,
     230,   231,     0,   232,   233,   234,     0,     0,   235,   236,
       0,   237,   238,   239,   240,   241,   242,   243,     0,     0,
     244,   245,   246,   247,     0,     0,   248,   249,     0,   250,
     251,   252,     0,     0,   253,     0,     0,     0,   254,     0,
     255,     0,   256,     0,   257,   258,   259,   260,   261,   262,
     263,     0,   264,     0,     0,     0,   265,   266,   267,     0,
     268,     0,     0,     0,   269,   270,     0,     0,     0,   271,
     272,   273,   274,   275,     0,     0,   276,   277,   278,     0,
     279,     0,   280,     0,     0,     0,     0,   281,   282,     0,
       0,     0,   283,     0,   284,   285,     0,   286,   287,     0,
       0,     0,   288,     0,     0,   289,   290,   291,     0,     0,
     292,     0,     0,   293,   294,     0,     0,     0,     0,     0,
     295,   296,     0,   297,     0,   298,     0,   299,   300,     0,
       0,     0,     0,     0,     0,     0,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,     0,   317,   318,   319,   320,     0,   321,   322,
     323,   324,     0,   325,   326,     0,     0,     0,     0,   327,
     328,   329,   330,   331,   332,     0,     0,   333,   334,     0,
     335,     0,   336,     0,   337,   338,   339,   340,   341,   342,
     343,   344,   345,     0,     0,   346,   347,     0,     0,   348,
     349,   350,   351,     0,     0,     0,   352,   353,     0,     0,
       0,   354,     0,   355,   356,   357,     0,   358,   359,   360,
     361,     0,   362,   363,     0,     0,     0,     0,     0,     0,
       0,     0,   364,   365,   366,     0,     0,   367,     0,   368,
       0,   369,   370,   371,   372,   373,   374,   375,   376,   377,
     378,     0,     0,   379,   380,   381,     0,   382,     0,   383,
     384,   385,   386,   387,     0,   388,   389,   390,     0,     0,
     391,     0,     0,     0,   392,   393,   394,   395,   396,     0,
       0,   397,   398,   399,   400,   401,     0,   402,   403,     0,
     404,   405,   406,     0,     0,   407,     0,   408,     0,   409,
     410,     0,   411,   412,     0,   413,     0,   414,     0,     0,
     415,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,     0,   427,   428,     0,     0,     0,   429,   430,
     431,   432,     0,     0,     0,   433,     0,     0,     0,   434,
       0,   435,   436,   437,   438,   439,   440,     0,   441,   442,
     443,   444,   445,   446,     0,     0,     0,     0,     0,     0,
     447,   448,     0,   449,     0,     0,   450,     0,     0,   451,
     452,     0,     0,     0,   453,     0,     0,   454,   455,     0,
     456,   457,   458,   459,   460,   461,     0,     0,   462,   463,
     464,   465,     0,   466,   467,     0,   468,     0,   469,   470,
     471,   472,     0,   139,   473,   474,     0,   475,   476,   477,
     478,     0,     0,     0,     0,     0,   479,   480,   481,     0,
       0,     0,   482,   483,   484,   485,     0,   486,   487,     0,
     488,   489,     0,   490,   491,     0,     0,   492,     0,     0,
     493,     0,   494,     0,   495,   496,   497,     0,     0,     0,
       0,     0,     0,   498,     0,     0,   499,     0,     0,     0,
     500,   501,   502,   503,   504,   505,   506,     0,     0,     0,
       0,     0,     0,   507,   508,     0,   509,   510,   511,     0,
     142,   512,   143,   144,   145,   146,   147,   148,     0,     0,
     149,     0,     0,     0,   150,     0,     0,   151,     0,   152,
     153,   154,   155,   156,   157,   158,   159,     0,   160,     0,
       0,     0,   161,     0,     0,     0,   162,     0,     0,   163,
     164,   165,     0,   166,     0,   167,   168,     0,     0,   169,
       0,     0,   170,   171,     0,   172,   173,     0,   174,   175,
       0,   176,   177,   178,   179,   180,   181,   182,     0,   183,
     184,   185,   186,   187,   188,   189,     0,   190,   191,   192,
     193,   194,   195,   196,   197,     0,   198,   199,     0,   200,
     201,   202,   203,   204,  4661,   205,     0,     0,   206,     0,
       0,   207,     0,   208,     0,     0,   209,     0,   210,     0,
       0,     0,   211,   212,   213,     0,     0,   214,     0,     0,
       0,     0,   215,   216,     0,     0,     0,     0,   217,     0,
     218,     0,     0,     0,   219,     0,   220,   221,   222,   223,
     224,     0,     0,     0,   225,     0,     0,   226,   227,   228,
       0,     0,     0,   229,     0,   230,   231,     0,   232,   233,
     234,     0,     0,   235,   236,     0,   237,   238,   239,   240,
     241,   242,   243,     0,  4662,   244,   245,   246,   247,     0,
       0,   248,   249,     0,   250,   251,   252,     0,     0,   253,
       0,     0,     0,   254,     0,   255,     0,   256,     0,   257,
     258,   259,   260,   261,   262,   263,     0,   264,     0,     0,
       0,   265,   266,   267,     0,   268,     0,     0,     0,   269,
     270,     0,     0,     0,   271,   272,   273,   274,   275,     0,
       0,   276,   277,   278,     0,   279,     0,   280,     0,     0,
       0,     0,   281,   282,     0,     0,     0,   283,     0,   284,
     285,     0,   286,   287,     0,     0,     0,   288,     0,     0,
     289,   290,   291,     0,     0,   292,     0,     0,   293,   294,
       0,     0,     0,     0,     0,   295,   296,     0,   297,     0,
     298,     0,   299,   300,     0,     0,     0,     0,     0,     0,
       0,   301,   302,   303,   304,   305,   306,   307,   308,   309,
     310,   311,   312,   313,   314,   315,   316,     0,   317,   318,
     319,   320,     0,   321,   322,   323,   324,     0,   325,   326,
       0,     0,     0,     0,   327,   328,   329,   330,   331,   332,
       0,     0,   333,   334,     0,   335,     0,   336,     0,   337,
     338,   339,   340,   341,   342,   343,   344,   345,     0,     0,
     346,   347,     0,     0,   348,   349,   350,   351,     0,     0,
       0,   352,   353,     0,     0,     0,   354,     0,   355,   356,
     357,     0,   358,   359,   360,   361,     0,   362,   363,     0,
       0,     0,     0,     0,     0,     0,     0,   364,   365,   366,
       0,     0,   367,     0,   368,     0,   369,   370,   371,   372,
     373,   374,   375,   376,   377,   378,     0,     0,   379,   380,
     381,     0,   382,     0,   383,   384,   385,   386,   387,     0,
     388,   389,   390,     0,     0,   391,     0,     0,     0,   392,
     393,   394,   395,   396,     0,     0,   397,   398,   399,   400,
     401,     0,   402,   403,     0,   404,   405,   406,     0,     0,
     407,     0,   408,     0,   409,   410,     0,   411,   412,     0,
     413,     0,   414,     0,     0,   415,   416,   417,   418,   419,
     420,   421,   422,   423,   424,   425,   426,     0,   427,   428,
       0,     0,     0,   429,   430,   431,   432,     0,     0,     0,
     433,     0,     0,     0,   434,     0,   435,   436,   437,   438,
     439,   440,     0,   441,   442,   443,   444,   445,   446,     0,
       0,     0,     0,     0,     0,   447,   448,     0,   449,     0,
       0,   450,     0,     0,   451,   452,     0,     0,     0,   453,
       0,     0,   454,   455,     0,   456,   457,   458,   459,   460,
     461,     0,     0,   462,   463,   464,   465,     0,   466,   467,
       0,   468,     0,   469,   470,   471,   472,     0,     0,   473,
     474,     0,   475,   476,   477,   478,     0,     0,     0,     0,
       0,   479,   480,   481,     0,     0,     0,   482,   483,   484,
     485,     0,   486,   487,     0,   488,   489,     0,   490,   491,
       0,     0,   492,     0,     0,   493,     0,   494,     0,   495,
     496,   497,     0,     0,     0,     0,     0,     0,   498,     0,
       0,   499,     0,     0,     0,   500,   501,   502,   503,   504,
     505,   506,     0,     0,     0,     0,     0,     0,   507,   508,
       0,   509,   510,   511,     0,   142,   512,   143,   144,   145,
     146,   147,   148,     0,     0,   149,     0,     0,     0,   150,
       0,     0,   151,     0,   152,   153,   154,   155,   156,   157,
     158,   159,     0,   160,     0,     0,     0,   161,     0,     0,
       0,   162,     0,     0,   163,   164,   165,     0,   166,     0,
     167,   168,     0,     0,   169,     0,     0,   170,   171,     0,
     172,   173,     0,   174,   175,     0,   176,   177,   178,   179,
     180,   181,   182,     0,   183,   184,   185,   186,   187,   188,
     189,     0,   190,   191,   192,   193,   194,   195,   196,   197,
       0,   198,   199,     0,   200,   201,   202,   203,   204,     0,
     205,     0,     0,   206,     0,     0,   207,     0,   208,     0,
       0,   209,     0,   210,     0,     0,     0,   211,   212,   213,
       0,     0,   214,     0,     0,     0,     0,   215,   216,     0,
       0,     0,     0,   217,     0,   218,     0,     0,     0,   219,
       0,   220,   221,   222,   223,   224,     0,     0,     0,   225,
       0,     0,   226,   227,   228,     0,     0,     0,   229,     0,
     230,   231,     0,   232,   233,   234,     0,     0,   235,   236,
       0,   237,   238,   239,   240,   241,   242,   243,     0,     0,
     244,   245,   246,   247,     0,     0,   248,   249,     0,   250,
     251,   252,     0,     0,   253,     0,     0,     0,   254,     0,
     255,     0,   256,     0,   257,   258,   259,   260,   261,   262,
     263,     0,   264,     0,     0,     0,   265,   266,   267,     0,
     268,     0,     0,     0,   269,   270,     0,     0,     0,   271,
     272,   273,   274,   275,     0,     0,   276,   277,   278,     0,
     279,     0,   280,     0,     0,     0,     0,   281,   282,     0,
       0,     0,   283,     0,   284,   285,     0,   286,   287,     0,
       0,     0,   288,     0,     0,   289,   290,   291,     0,     0,
     292,     0,     0,   293,   294,     0,     0,     0,     0,     0,
     295,   296,     0,   297,     0,   298,     0,   299,   300,     0,
       0,     0,     0,     0,     0,     0,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,     0,   317,   318,   319,   320,     0,   321,   322,
     323,   324,     0,   325,   326,     0,     0,     0,     0,   327,
     328,   329,   330,   331,   332,     0,     0,   333,   334,     0,
     335,     0,   336,     0,   337,   338,   339,   340,   341,   342,
     343,   344,   345,     0,     0,   346,   347,     0,     0,   348,
     349,   350,   351,     0,     0,     0,   352,   353,     0,     0,
       0,   354,     0,   355,   356,   357,     0,   358,   359,   360,
     361,     0,   362,   363,     0,     0,     0,     0,     0,     0,
       0,     0,   364,   365,   366,     0,     0,   367,     0,   368,
       0,   369,   370,   371,   372,   373,   374,   375,   376,   377,
     378,     0,     0,   379,   380,   381,     0,   382,     0,   383,
     384,   385,   386,   387,     0,   388,   389,   390,     0,     0,
     391,     0,     0,     0,   392,   393,   394,   395,   396,     0,
       0,   397,   398,   399,   400,   401,     0,   402,   403,     0,
     404,   405,   406,     0,     0,   407,     0,   408,     0,   409,
     410,     0,   411,   412,     0,   413,     0,   414,     0,     0,
     415,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,     0,   427,   428,     0,     0,     0,   429,   430,
     431,   432,     0,     0,     0,   433,     0,     0,     0,   434,
       0,   435,   436,   437,   438,   439,   440,     0,   441,   442,
     443,   444,   445,   446,     0,     0,     0,   585,     0,     0,
     447,   448,     0,   449,     0,     0,   450,     0,     0,   451,
     452,     0,     0,     0,   453,     0,     0,   454,   455,     0,
     456,   457,   458,   459,   460,   461,     0,     0,   462,   463,
     464,   465,     0,   466,   467,     0,   468,     0,   469,   470,
     471,   472,     0,     0,   473,   474,     0,   475,   476,   477,
     478,     0,     0,     0,     0,     0,   479,   480,   481,     0,
       0,     0,   482,   483,   484,   485,     0,   486,   487,     0,
     488,   489,     0,   490,   491,     0,     0,   492,     0,     0,
     493,     0,   494,     0,   495,   496,   497,     0,     0,     0,
       0,     0,     0,   498,     0,     0,   499,     0,     0,     0,
     500,   501,   502,   503,   504,   505,   506,     0,     0,     0,
       0,     0,     0,   507,   508,     0,   509,   510,   511,     0,
     142,   512,   143,   144,   145,   146,   147,   148,     0,     0,
     149,     0,     0,     0,   150,     0,     0,   151,     0,   152,
     153,   154,   155,   156,   157,   158,   159,     0,   160,     0,
       0,     0,   161,     0,     0,     0,   162,     0,     0,   163,
     164,   165,     0,   166,     0,   167,   168,     0,     0,   169,
       0,     0,   170,   171,     0,   172,   173,     0,   174,   175,
       0,   176,   177,   178,   179,   180,   181,   182,     0,   183,
     184,   185,   186,   187,   188,   189,     0,   190,   191,   192,
     193,   194,   195,   196,   197,     0,   198,   199,     0,   200,
     201,   202,   203,   204,     0,   205,     0,     0,   206,     0,
       0,   207,     0,   208,     0,     0,   209,     0,   210,     0,
       0,     0,   211,   212,   213,     0,     0,   214,     0,     0,
       0,     0,   215,   216,     0,     0,     0,     0,   217,     0,
     218,     0,     0,     0,   219,     0,   220,   221,   222,   223,
     224,     0,     0,     0,   225,     0,     0,   226,   227,   228,
       0,     0,     0,   229,     0,   230,   231,     0,   232,   233,
     234,     0,     0,   235,   236,     0,   237,   238,   239,   240,
     241,   242,   243,     0,     0,   244,   245,   246,   247,     0,
       0,   248,   249,     0,   250,   251,   252,     0,     0,   253,
       0,     0,     0,   254,  1113,   255,     0,   256,     0,   257,
     258,   259,   260,   261,   262,   263,     0,   264,     0,     0,
       0,   265,   266,   267,     0,   268,     0,     0,     0,   269,
     270,     0,     0,     0,   271,   272,   273,   274,   275,     0,
       0,   276,   277,   278,     0,   279,     0,   280,     0,     0,
       0,     0,   281,   282,     0,     0,     0,   283,     0,   284,
     285,     0,   286,   287,     0,     0,     0,   288,     0,     0,
     289,   290,   291,     0,     0,   292,     0,     0,   293,   294,
       0,     0,     0,     0,     0,   295,   296,     0,   297,     0,
     298,     0,   299,   300,     0,     0,     0,     0,     0,     0,
       0,   301,   302,   303,   304,   305,   306,   307,   308,   309,
     310,   311,   312,   313,   314,   315,   316,     0,   317,   318,
     319,   320,     0,   321,   322,   323,   324,     0,   325,   326,
       0,     0,     0,     0,   327,   328,   329,   330,   331,   332,
       0,     0,   333,   334,     0,   335,     0,   336,     0,   337,
     338,   339,   340,   341,   342,   343,   344,   345,     0,     0,
     346,   347,     0,     0,   348,   349,   350,   351,     0,     0,
       0,   352,   353,     0,     0,     0,   354,     0,   355,   356,
     357,     0,   358,   359,   360,   361,     0,   362,   363,     0,
       0,     0,     0,     0,     0,     0,     0,   364,   365,   366,
       0,     0,   367,     0,   368,     0,   369,   370,   371,   372,
     373,   374,   375,   376,   377,   378,     0,     0,   379,   380,
     381,     0,   382,     0,   383,   384,   385,   386,   387,     0,
     388,   389,   390,     0,     0,   391,     0,     0,     0,   392,
     393,   394,   395,   396,     0,     0,   397,   398,   399,   400,
     401,     0,   402,   403,     0,   404,   405,   406,     0,     0,
     407,     0,   408,     0,   409,   410,     0,   411,   412,     0,
     413,     0,   414,     0,     0,   415,   416,   417,   418,   419,
     420,   421,   422,   423,   424,   425,   426,     0,   427,   428,
       0,     0,     0,   429,   430,   431,   432,     0,     0,     0,
     433,     0,     0,     0,   434,     0,   435,   436,   437,   438,
     439,   440,     0,   441,   442,   443,   444,   445,   446,     0,
       0,     0,     0,     0,     0,   447,   448,     0,   449,     0,
       0,   450,     0,     0,   451,   452,     0,     0,     0,   453,
       0,     0,   454,   455,     0,   456,   457,   458,   459,   460,
     461,     0,     0,   462,   463,   464,   465,     0,   466,   467,
       0,   468,     0,   469,   470,   471,   472,     0,     0,   473,
     474,     0,   475,   476,   477,   478,     0,     0,     0,     0,
       0,   479,   480,   481,     0,     0,     0,   482,   483,   484,
     485,     0,   486,   487,     0,   488,   489,     0,   490,   491,
       0,     0,   492,     0,     0,   493,     0,   494,     0,   495,
     496,   497,     0,     0,     0,     0,     0,     0,   498,     0,
       0,   499,     0,     0,     0,   500,   501,   502,   503,   504,
     505,   506,     0,     0,     0,     0,     0,     0,   507,   508,
       0,   509,   510,   511,     0,   142,   512,   143,   144,   145,
     146,   147,   148,     0,     0,   149,     0,     0,     0,   150,
       0,     0,   151,     0,   152,   153,   154,   155,   156,   157,
     158,   159,     0,   160,     0,     0,     0,   161,     0,     0,
       0,   162,     0,     0,   163,   164,   165,     0,   166,     0,
     167,   168,     0,     0,   169,     0,     0,   170,   171,     0,
     172,   173,     0,   174,   175,     0,   176,   177,   178,   179,
     180,   181,   182,     0,   183,   184,   185,   186,   187,   188,
     189,     0,   190,   191,   192,   193,   194,   195,   196,   197,
       0,   198,   199,     0,   200,   201,   202,   203,   204,     0,
     205,     0,     0,   206,     0,     0,   207,     0,   208,     0,
       0,   209,     0,   210,     0,     0,     0,   211,   212,   213,
       0,     0,   214,     0,     0,     0,     0,   215,   216,     0,
       0,     0,   943,   217,     0,   218,     0,     0,     0,   219,
       0,   220,   221,   222,   223,   224,     0,     0,     0,   225,
       0,     0,   226,   227,   228,     0,     0,     0,   229,     0,
     230,   231,     0,   232,   233,   234,     0,     0,   235,   236,
       0,   237,   238,   239,   240,   241,   242,   243,     0,     0,
     244,   245,   246,   247,     0,     0,   248,   249,     0,   250,
     251,   252,     0,     0,   253,     0,     0,     0,   254,     0,
     255,     0,   256,     0,   257,   258,   259,   260,   261,   262,
     263,     0,   264,     0,     0,     0,   265,   266,   267,     0,
     268,     0,     0,     0,   269,   270,     0,     0,     0,   271,
     272,   273,   274,   275,     0,     0,   276,   277,   278,     0,
     279,     0,   280,     0,     0,     0,     0,   281,   282,     0,
       0,     0,   283,     0,   284,   285,     0,   286,   287,     0,
       0,     0,   288,     0,     0,   289,   290,   291,     0,     0,
     292,     0,     0,   293,   294,     0,     0,     0,     0,     0,
     295,   296,     0,   297,     0,   298,     0,   299,   300,     0,
       0,     0,     0,     0,     0,     0,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,     0,   317,   318,   319,   320,     0,   321,   322,
     323,   324,     0,   325,   326,     0,     0,     0,     0,   327,
     328,   329,   330,   331,   332,     0,     0,   333,   334,     0,
     335,     0,   336,     0,   337,   338,   339,   340,   341,   342,
     343,   344,   345,     0,     0,   346,   347,     0,     0,   348,
     349,   350,   351,     0,     0,     0,   352,   353,     0,     0,
       0,   354,     0,   355,   356,   357,     0,   358,   359,   360,
     361,     0,   362,   363,     0,     0,     0,     0,     0,     0,
       0,     0,   364,   365,   366,     0,     0,   367,     0,   368,
       0,   369,   370,   371,   372,   373,   374,   375,   376,   377,
     378,     0,     0,   379,   380,   381,     0,   382,     0,   383,
     384,   385,   386,   387,     0,   388,   389,   390,     0,     0,
     391,     0,     0,     0,   392,   393,   394,   395,   396,     0,
       0,   397,   398,   399,   400,   401,     0,   402,   403,     0,
     404,   405,   406,     0,     0,   407,     0,   408,     0,   409,
     410,     0,   411,   412,     0,   413,     0,   414,     0,     0,
     415,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,     0,   427,   428,     0,     0,     0,   429,   430,
     431,   432,     0,     0,     0,   433,     0,     0,     0,   434,
       0,   435,   436,   437,   438,   439,   440,     0,   441,   442,
     443,   444,   445,   446,     0,     0,     0,     0,     0,     0,
     447,   448,     0,   449,     0,     0,   450,     0,     0,   451,
     452,     0,     0,     0,   453,     0,     0,   454,   455,     0,
     456,   457,   458,   459,   460,   461,     0,     0,   462,   463,
     464,   465,     0,   466,   467,     0,   468,     0,   469,   470,
     471,   472,     0,     0,   473,   474,     0,   475,   476,   477,
     478,     0,     0,     0,     0,     0,  1969,   480,   481,     0,
       0,     0,   482,   483,   484,   485,     0,   486,   487,     0,
     488,   489,     0,   490,   491,     0,     0,   492,     0,     0,
     493,     0,   494,     0,   495,   496,   497,     0,     0,     0,
       0,     0,     0,   498,     0,     0,   499,     0,     0,     0,
     500,   501,   502,   503,   504,   505,   506,     0,     0,     0,
       0,     0,     0,   507,   508,     0,   509,   510,   511,     0,
     142,   512,   143,   144,   145,   146,   147,   148,     0,     0,
     149,     0,     0,     0,   150,     0,     0,   151,     0,   152,
     153,   154,   155,   156,   157,   158,   159,     0,   160,     0,
       0,     0,   161,     0,     0,     0,   162,     0,     0,   163,
     164,   165,     0,   166,     0,   167,   168,     0,     0,   169,
       0,     0,   170,   171,     0,   172,   173,     0,   174,   175,
       0,   176,   177,   178,   179,   180,   181,   182,     0,   183,
     184,   185,   186,   187,   188,   189,     0,   190,   191,   192,
     193,   194,   195,   196,   197,     0,   198,   199,     0,   200,
     201,   202,   203,   204,     0,   205,     0,     0,   206,     0,
       0,   207,     0,   208,     0,     0,   209,     0,   210,     0,
       0,     0,   211,   212,   213,     0,     0,   214,     0,     0,
       0,     0,   215,   216,     0,     0,     0,  2125,   217,     0,
     218,     0,     0,     0,   219,     0,   220,   221,   222,   223,
     224,     0,     0,     0,   225,     0,     0,   226,   227,   228,
       0,     0,     0,   229,     0,   230,   231,     0,   232,   233,
     234,     0,     0,   235,   236,     0,   237,   238,   239,   240,
     241,   242,   243,     0,     0,   244,   245,   246,   247,     0,
       0,   248,   249,     0,   250,   251,   252,     0,     0,   253,
       0,     0,     0,   254,     0,   255,     0,   256,     0,   257,
     258,   259,   260,   261,   262,   263,     0,   264,     0,     0,
       0,   265,   266,   267,     0,   268,     0,     0,     0,   269,
     270,     0,     0,     0,   271,   272,   273,   274,   275,     0,
       0,   276,   277,   278,     0,   279,     0,   280,     0,     0,
       0,     0,   281,   282,     0,     0,     0,   283,     0,   284,
     285,     0,   286,   287,     0,     0,     0,   288,     0,     0,
     289,   290,   291,     0,     0,   292,     0,     0,   293,   294,
       0,     0,     0,     0,     0,   295,   296,     0,   297,     0,
     298,     0,   299,   300,     0,     0,     0,     0,     0,     0,
       0,   301,   302,   303,   304,   305,   306,   307,   308,   309,
     310,   311,   312,   313,   314,   315,   316,     0,   317,   318,
     319,   320,     0,   321,   322,   323,   324,     0,   325,   326,
       0,     0,     0,     0,   327,   328,   329,   330,   331,   332,
       0,     0,   333,   334,     0,   335,     0,   336,     0,   337,
     338,   339,   340,   341,   342,   343,   344,   345,     0,     0,
     346,   347,     0,     0,   348,   349,   350,   351,     0,     0,
       0,   352,   353,     0,     0,     0,   354,     0,   355,   356,
     357,     0,   358,   359,   360,   361,     0,   362,   363,     0,
       0,     0,     0,     0,     0,     0,     0,   364,   365,   366,
       0,     0,   367,     0,   368,     0,   369,   370,   371,   372,
     373,   374,   375,   376,   377,   378,     0,     0,   379,   380,
     381,     0,   382,     0,   383,   384,   385,   386,   387,     0,
     388,   389,   390,     0,     0,   391,     0,     0,     0,   392,
     393,   394,   395,   396,     0,     0,   397,   398,   399,   400,
     401,     0,   402,   403,     0,   404,   405,   406,     0,     0,
     407,     0,   408,     0,   409,   410,     0,   411,   412,     0,
     413,     0,   414,     0,     0,   415,   416,   417,   418,   419,
     420,   421,   422,   423,   424,   425,   426,     0,   427,   428,
       0,     0,     0,   429,   430,   431,   432,     0,     0,     0,
     433,     0,     0,     0,   434,     0,   435,   436,   437,   438,
     439,   440,     0,   441,   442,   443,   444,   445,   446,     0,
       0,     0,     0,     0,     0,   447,   448,     0,   449,     0,
       0,   450,     0,     0,   451,   452,     0,     0,     0,   453,
       0,     0,   454,   455,     0,   456,   457,   458,   459,   460,
     461,     0,     0,   462,   463,   464,   465,     0,   466,   467,
       0,   468,     0,   469,   470,   471,   472,     0,     0,   473,
     474,     0,   475,   476,   477,   478,     0,     0,     0,     0,
       0,   479,   480,   481,     0,     0,     0,   482,   483,   484,
     485,     0,   486,   487,     0,   488,   489,     0,   490,   491,
       0,     0,   492,     0,     0,   493,     0,   494,     0,   495,
     496,   497,     0,     0,     0,     0,     0,     0,   498,     0,
       0,   499,     0,     0,     0,   500,   501,   502,   503,   504,
     505,   506,     0,     0,     0,     0,     0,     0,   507,   508,
       0,   509,   510,   511,     0,   142,   512,   143,   144,   145,
     146,   147,   148,     0,     0,   149,     0,     0,     0,   150,
       0,     0,   151,     0,   152,   153,   154,   155,   156,   157,
     158,   159,     0,   160,     0,     0,     0,   161,     0,     0,
       0,   162,     0,     0,   163,   164,   165,     0,   166,     0,
     167,   168,     0,     0,   169,     0,     0,   170,   171,     0,
     172,   173,     0,   174,   175,     0,   176,   177,   178,   179,
     180,   181,   182,     0,   183,   184,   185,   186,   187,   188,
     189,     0,   190,   191,   192,   193,   194,   195,   196,   197,
       0,   198,   199,     0,   200,   201,   202,   203,   204,     0,
     205,     0,     0,   206,     0,     0,   207,     0,   208,     0,
       0,   209,     0,   210,     0,     0,     0,   211,   212,   213,
       0,     0,   214,     0,     0,     0,     0,   215,   216,     0,
       0,     0,   943,   217,     0,   218,     0,     0,     0,   219,
       0,   220,   221,   222,   223,   224,     0,     0,     0,   225,
       0,     0,   226,   227,   228,     0,     0,     0,   229,     0,
     230,   231,     0,   232,   233,   234,     0,     0,   235,   236,
       0,   237,   238,   239,   240,   241,   242,   243,     0,     0,
     244,   245,   246,   247,     0,     0,   248,   249,     0,   250,
     251,   252,     0,     0,   253,     0,     0,     0,   254,     0,
     255,     0,   256,     0,   257,   258,   259,   260,   261,   262,
     263,     0,   264,     0,     0,     0,   265,   266,   267,     0,
     268,     0,     0,     0,   269,   270,     0,     0,     0,   271,
     272,   273,   274,   275,     0,     0,   276,   277,   278,     0,
     279,     0,   280,     0,     0,     0,     0,   281,   282,     0,
       0,     0,   283,     0,   284,   285,     0,   286,   287,     0,
       0,     0,   288,     0,     0,   289,   290,   291,     0,     0,
     292,     0,     0,   293,   294,     0,     0,     0,     0,     0,
     295,   296,     0,   297,     0,   298,     0,   299,   300,     0,
       0,     0,     0,     0,     0,     0,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,     0,   317,   318,   319,   320,     0,   321,   322,
     323,   324,     0,   325,   326,     0,     0,     0,     0,   327,
     328,   329,   330,   331,   332,     0,     0,   333,   334,     0,
     335,     0,   336,     0,   337,   338,   339,   340,   341,   342,
     343,   344,   345,     0,     0,   346,   347,     0,     0,   348,
     349,   350,   351,     0,     0,     0,   352,   353,     0,     0,
       0,   354,     0,   355,   356,   357,     0,   358,   359,   360,
     361,     0,   362,   363,     0,     0,     0,     0,     0,     0,
       0,     0,   364,   365,   366,     0,     0,   367,     0,   368,
       0,   369,   370,   371,   372,   373,   374,   375,   376,   377,
     378,     0,     0,   379,   380,   381,     0,   382,     0,   383,
     384,   385,   386,   387,     0,   388,   389,   390,     0,     0,
     391,     0,     0,     0,   392,   393,   394,   395,   396,     0,
       0,   397,   398,   399,   400,   401,     0,   402,   403,     0,
     404,   405,   406,     0,     0,   407,     0,   408,     0,   409,
     410,     0,   411,   412,     0,   413,     0,   414,     0,     0,
     415,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,     0,   427,   428,     0,     0,     0,   429,   430,
     431,   432,     0,     0,     0,   433,     0,     0,     0,   434,
       0,   435,   436,   437,   438,   439,   440,     0,   441,   442,
     443,   444,   445,   446,     0,     0,     0,     0,     0,     0,
     447,   448,     0,   449,     0,     0,   450,     0,     0,   451,
     452,     0,     0,     0,   453,     0,     0,   454,   455,     0,
     456,   457,   458,   459,   460,   461,     0,     0,   462,   463,
     464,   465,     0,   466,   467,     0,   468,     0,   469,   470,
     471,   472,     0,     0,   473,   474,     0,   475,   476,   477,
     478,     0,     0,     0,     0,     0,   479,   480,   481,     0,
       0,     0,   482,   483,   484,   485,     0,   486,   487,     0,
     488,   489,     0,   490,   491,     0,     0,   492,     0,     0,
     493,     0,   494,     0,   495,   496,   497,     0,     0,     0,
       0,     0,     0,   498,     0,     0,   499,     0,     0,     0,
     500,   501,   502,   503,   504,   505,   506,     0,     0,     0,
       0,     0,     0,   507,   508,     0,   509,   510,   511,     0,
     142,   512,   143,   144,   145,   146,   147,   148,     0,     0,
     149,     0,     0,     0,   150,     0,     0,   151,     0,   152,
     153,   154,   155,   156,   157,   158,   159,     0,   160,     0,
       0,     0,   161,     0,     0,     0,   162,     0,     0,   163,
     164,   165,     0,   166,     0,   167,   168,     0,     0,   169,
       0,     0,   170,   171,     0,   172,   173,     0,   174,   175,
       0,   176,   177,   178,   179,   180,   181,   182,     0,   183,
     184,   185,   186,   187,   188,   189,     0,   190,   191,   192,
     193,   194,   195,   196,   197,     0,   198,   199,     0,   200,
     201,   202,   203,   204,     0,   205,     0,     0,   206,     0,
       0,   207,     0,   208,     0,     0,   209,     0,   210,     0,
       0,     0,   211,   212,   213,     0,     0,   214,     0,     0,
       0,     0,   215,   216,     0,     0,     0,     0,   217,     0,
     218,     0,     0,     0,   219,     0,   220,   221,   222,   223,
     224,     0,     0,     0,   225,     0,     0,   226,   227,   228,
       0,     0,     0,   229,     0,   230,   231,     0,   232,   233,
     234,     0,     0,   235,   236,     0,   237,   238,   239,   240,
     241,   242,   243,     0,     0,   244,   245,   246,   247,     0,
       0,   248,   249,     0,   250,   251,   252,     0,     0,   253,
       0,     0,     0,   254,     0,   255,     0,   256,     0,   257,
     258,   259,   260,   261,   262,   263,     0,   264,     0,     0,
       0,   265,   266,   267,     0,   268,     0,     0,     0,   269,
     270,     0,     0,     0,   271,   272,   273,   274,   275,     0,
       0,   276,   277,   278,     0,   279,     0,   280,     0,     0,
       0,     0,   281,   282,     0,     0,     0,   283,     0,   284,
     285,     0,   286,   287,     0,     0,     0,   288,     0,     0,
     289,   290,   291,     0,     0,   292,     0,     0,   293,   294,
       0,     0,     0,     0,     0,   295,   296,     0,   297,     0,
     298,     0,   299,   300,     0,     0,     0,     0,     0,     0,
       0,   301,   302,   303,   304,   305,   306,   307,   308,   309,
     310,   311,   312,   313,   314,   315,   316,     0,   317,   318,
     319,   320,     0,   321,   322,   323,   324,     0,   325,   326,
       0,     0,     0,     0,   327,   328,   329,   330,   331,   332,
       0,     0,   333,   334,     0,   335,     0,   336,     0,   337,
     338,   339,   340,   341,   342,   343,   344,   345,     0,     0,
     346,   347,     0,     0,   348,   349,   350,   351,     0,     0,
       0,   352,   353,     0,     0,     0,   354,     0,   355,   356,
     357,     0,   358,   359,   360,   361,     0,   362,   363,     0,
       0,     0,     0,     0,     0,     0,     0,   364,   365,   366,
       0,     0,   367,     0,   368,     0,   369,   370,   371,   372,
     373,   374,   375,   376,   377,   378,     0,     0,   379,   380,
     381,  3094,   382,     0,   383,   384,   385,   386,   387,     0,
     388,   389,   390,     0,     0,   391,     0,     0,     0,   392,
     393,   394,   395,   396,     0,     0,   397,   398,   399,   400,
     401,     0,   402,   403,     0,   404,   405,   406,     0,     0,
     407,     0,   408,     0,   409,   410,     0,   411,   412,     0,
     413,     0,   414,     0,     0,   415,   416,   417,   418,   419,
     420,   421,   422,   423,   424,   425,   426,     0,   427,   428,
       0,     0,     0,   429,   430,   431,   432,     0,     0,     0,
     433,     0,     0,     0,   434,     0,   435,   436,   437,   438,
     439,   440,     0,   441,   442,   443,   444,   445,   446,     0,
       0,     0,     0,     0,     0,   447,   448,     0,   449,     0,
       0,   450,     0,     0,   451,   452,     0,     0,     0,   453,
       0,     0,   454,   455,     0,   456,   457,   458,   459,   460,
     461,     0,     0,   462,   463,   464,   465,     0,   466,   467,
       0,   468,     0,   469,   470,   471,   472,     0,     0,   473,
     474,     0,   475,   476,   477,   478,     0,     0,     0,     0,
       0,   479,   480,   481,     0,     0,     0,   482,   483,   484,
     485,     0,   486,   487,     0,   488,   489,     0,   490,   491,
       0,     0,   492,     0,     0,   493,     0,   494,     0,   495,
     496,   497,     0,     0,     0,     0,     0,     0,   498,     0,
       0,   499,     0,     0,     0,   500,   501,   502,   503,   504,
     505,   506,     0,     0,     0,     0,     0,     0,   507,   508,
       0,   509,   510,   511,     0,   142,   512,   143,   144,   145,
     146,   147,   148,     0,     0,   149,     0,     0,     0,   150,
       0,     0,   151,     0,   152,   153,   154,   155,   156,   157,
     158,   159,     0,   160,     0,     0,     0,   161,     0,     0,
       0,   162,     0,     0,   163,   164,   165,     0,   166,     0,
     167,   168,     0,     0,   169,     0,     0,   170,   171,     0,
     172,   173,     0,   174,   175,     0,   176,   177,   178,   179,
     180,   181,   182,     0,   183,   184,   185,   186,   187,   188,
     189,     0,   190,   191,   192,   193,   194,   195,   196,   197,
       0,   198,   199,     0,   200,   201,   202,   203,   204,     0,
     205,     0,     0,   206,     0,     0,   207,     0,   208,     0,
       0,   209,     0,   210,     0,     0,     0,   211,   212,   213,
       0,     0,   214,     0,     0,     0,     0,   215,   216,     0,
       0,     0,     0,   217,     0,   218,     0,     0,     0,   219,
       0,   220,   221,   222,   223,   224,     0,     0,     0,   225,
       0,     0,   226,   227,   228,     0,     0,     0,   229,     0,
     230,   231,     0,   232,   233,   234,     0,     0,   235,   236,
       0,   237,   238,   239,   240,   241,   242,   243,     0,     0,
     244,   245,   246,   247,     0,     0,   248,   249,     0,   250,
     251,   252,     0,     0,   253,     0,     0,     0,   254,     0,
     255,     0,   256,     0,   257,   258,   259,   260,   261,   262,
     263,     0,   264,     0,     0,     0,   265,   266,   267,     0,
     268,     0,     0,     0,   269,   270,     0,     0,     0,   271,
     272,   273,   274,   275,     0,     0,   276,   277,   278,     0,
     279,     0,   280,     0,     0,     0,     0,   281,   282,     0,
       0,     0,   283,     0,   284,   285,     0,   286,   287,     0,
       0,     0,   288,     0,     0,   289,   290,   291,     0,     0,
     292,     0,     0,   293,   294,     0,     0,     0,     0,     0,
     295,   296,     0,   297,     0,   298,     0,   299,   300,     0,
       0,     0,     0,     0,     0,     0,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,     0,   317,   318,   319,   320,     0,   321,   322,
     323,   324,     0,   325,   326,     0,     0,     0,     0,   327,
     328,   329,   330,   331,   332,     0,     0,   333,   334,     0,
     335,     0,   336,     0,   337,   338,   339,   340,   341,   342,
     343,   344,   345,     0,     0,   346,   347,     0,     0,   348,
     349,   350,   351,     0,     0,     0,   352,   353,     0,     0,
       0,   354,     0,   355,   356,   357,     0,   358,   359,   360,
     361,     0,   362,   363,     0,     0,     0,     0,     0,     0,
       0,     0,   364,   365,   366,     0,     0,   367,     0,   368,
       0,   369,   370,   371,   372,   373,   374,   375,   376,   377,
     378,     0,     0,   379,   380,   381,     0,   382,     0,   383,
     384,   385,   386,   387,     0,   388,   389,   390,     0,     0,
     391,     0,     0,     0,   392,   393,   394,   395,   396,     0,
       0,   397,   398,   399,   400,   401,     0,   402,   403,     0,
     404,   405,   406,     0,     0,   407,     0,   408,     0,   409,
     410,     0,   411,   412,     0,   413,     0,   414,     0,     0,
     415,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,     0,   427,   428,     0,     0,     0,   429,   430,
     431,   432,     0,     0,     0,   433,     0,     0,     0,   434,
       0,   435,   436,   437,   438,   439,   440,     0,   441,   442,
     443,   444,   445,   446,     0,     0,     0,     0,     0,     0,
     447,   448,     0,   449,     0,     0,   450,     0,     0,   451,
     452,     0,     0,     0,   453,     0,     0,   454,   455,     0,
     456,   457,   458,   459,   460,   461,     0,     0,   462,   463,
     464,   465,     0,   466,   467,     0,   468,     0,   469,   470,
     471,   472,     0,   139,   473,   474,     0,   475,   476,   477,
     478,     0,     0,     0,     0,     0,   479,   480,   481,     0,
       0,     0,   482,   483,   484,   485,     0,   486,   487,     0,
     488,   489,     0,   490,   491,     0,     0,   492,     0,     0,
     493,     0,   494,     0,   495,   496,   497,     0,     0,     0,
       0,     0,     0,   498,     0,     0,   499,     0,     0,     0,
     500,   501,   502,   503,   504,   505,   506,     0,     0,     0,
       0,     0,     0,   507,   508,     0,   509,   510,   511,     0,
     142,   512,   143,   144,   145,   146,   147,   148,     0,     0,
     149,     0,     0,     0,   150,     0,     0,   151,     0,   152,
     153,   154,   155,   156,   157,   158,   159,     0,   160,     0,
       0,     0,   161,     0,     0,     0,   162,     0,     0,   163,
     164,   165,     0,   166,     0,   167,   168,     0,     0,   169,
       0,     0,   170,   171,     0,   172,   173,     0,   174,   175,
       0,   176,   177,   178,   179,   180,   181,   182,     0,   183,
     184,   185,   186,   187,   188,   189,     0,   190,   191,   192,
     193,   194,   195,   196,   197,     0,   198,   199,     0,   200,
     201,   202,   203,   204,     0,   205,     0,     0,   206,     0,
       0,   207,     0,   208,     0,     0,   209,     0,   210,     0,
       0,     0,   211,   212,   213,     0,     0,   214,     0,     0,
       0,     0,   215,   216,     0,     0,     0,  3398,   217,     0,
     218,     0,     0,     0,   219,     0,   220,   221,   222,   223,
     224,     0,     0,     0,   225,     0,     0,   226,   227,   228,
       0,     0,     0,   229,     0,   230,   231,     0,   232,   233,
     234,     0,     0,   235,   236,     0,   237,   238,   239,   240,
     241,   242,   243,     0,     0,   244,   245,   246,   247,     0,
       0,   248,   249,     0,   250,   251,   252,     0,     0,   253,
       0,     0,     0,   254,     0,   255,     0,   256,     0,   257,
     258,   259,   260,   261,   262,   263,     0,   264,     0,     0,
       0,   265,   266,   267,     0,   268,     0,     0,     0,   269,
     270,     0,     0,     0,   271,   272,   273,   274,   275,     0,
       0,   276,   277,   278,     0,   279,     0,   280,     0,     0,
       0,     0,   281,   282,     0,     0,     0,   283,     0,   284,
     285,     0,   286,   287,     0,     0,     0,   288,     0,     0,
     289,   290,   291,     0,     0,   292,     0,     0,   293,   294,
       0,     0,     0,     0,     0,   295,   296,     0,   297,     0,
     298,     0,   299,   300,     0,     0,     0,     0,     0,     0,
       0,   301,   302,   303,   304,   305,   306,   307,   308,   309,
     310,   311,   312,   313,   314,   315,   316,     0,   317,   318,
     319,   320,     0,   321,   322,   323,   324,     0,   325,   326,
       0,     0,     0,     0,   327,   328,   329,   330,   331,   332,
       0,     0,   333,   334,     0,   335,     0,   336,     0,   337,
     338,   339,   340,   341,   342,   343,   344,   345,     0,     0,
     346,   347,     0,     0,   348,   349,   350,   351,     0,     0,
       0,   352,   353,     0,     0,     0,   354,     0,   355,   356,
     357,     0,   358,   359,   360,   361,     0,   362,   363,     0,
       0,     0,     0,     0,     0,     0,     0,   364,   365,   366,
       0,     0,   367,     0,   368,     0,   369,   370,   371,   372,
     373,   374,   375,   376,   377,   378,     0,     0,   379,   380,
     381,     0,   382,     0,   383,   384,   385,   386,   387,     0,
     388,   389,   390,     0,     0,   391,     0,     0,     0,   392,
     393,   394,   395,   396,     0,     0,   397,   398,   399,   400,
     401,     0,   402,   403,     0,   404,   405,   406,     0,     0,
     407,     0,   408,     0,   409,   410,     0,   411,   412,     0,
     413,     0,   414,     0,     0,   415,   416,   417,   418,   419,
     420,   421,   422,   423,   424,   425,   426,     0,   427,   428,
       0,     0,     0,   429,   430,   431,   432,     0,     0,     0,
     433,     0,     0,     0,   434,     0,   435,   436,   437,   438,
     439,   440,     0,   441,   442,   443,   444,   445,   446,     0,
       0,     0,     0,     0,     0,   447,   448,     0,   449,     0,
       0,   450,     0,     0,   451,   452,     0,     0,     0,   453,
       0,     0,   454,   455,     0,   456,   457,   458,   459,   460,
     461,     0,     0,   462,   463,   464,   465,     0,   466,   467,
       0,   468,     0,   469,   470,   471,   472,     0,     0,   473,
     474,     0,   475,   476,   477,   478,     0,     0,     0,     0,
       0,   479,   480,   481,     0,     0,     0,   482,   483,   484,
     485,     0,   486,   487,     0,   488,   489,     0,   490,   491,
       0,     0,   492,     0,     0,   493,     0,   494,     0,   495,
     496,   497,     0,     0,     0,     0,     0,     0,   498,     0,
       0,   499,     0,     0,     0,   500,   501,   502,   503,   504,
     505,   506,     0,     0,     0,     0,     0,     0,   507,   508,
       0,   509,   510,   511,     0,   142,   512,   143,   144,   145,
     146,   147,   148,  3406,     0,   149,     0,     0,     0,   150,
       0,     0,   151,     0,   152,   153,   154,   155,   156,   157,
     158,   159,     0,   160,     0,     0,     0,   161,     0,     0,
       0,   162,     0,     0,   163,   164,   165,     0,   166,     0,
     167,   168,     0,     0,   169,     0,     0,   170,   171,     0,
     172,   173,     0,   174,   175,     0,   176,   177,   178,   179,
     180,   181,   182,     0,   183,   184,   185,   186,   187,   188,
     189,     0,   190,   191,   192,   193,   194,   195,   196,   197,
       0,   198,   199,     0,   200,   201,   202,   203,   204,     0,
     205,     0,     0,   206,     0,     0,   207,     0,   208,     0,
       0,   209,     0,   210,     0,     0,     0,   211,   212,   213,
       0,     0,   214,     0,     0,     0,     0,   215,   216,     0,
       0,     0,     0,   217,     0,   218,     0,     0,     0,   219,
       0,   220,   221,   222,   223,   224,     0,     0,     0,   225,
       0,     0,   226,   227,   228,     0,     0,     0,   229,     0,
     230,   231,     0,   232,   233,   234,     0,     0,   235,   236,
       0,   237,   238,   239,   240,   241,   242,   243,     0,     0,
     244,   245,   246,   247,     0,     0,   248,   249,     0,   250,
     251,   252,     0,     0,   253,     0,     0,     0,   254,     0,
     255,     0,   256,     0,   257,   258,   259,   260,   261,   262,
     263,     0,   264,     0,     0,     0,   265,   266,   267,     0,
     268,     0,     0,     0,   269,   270,     0,     0,     0,   271,
     272,   273,   274,   275,     0,     0,   276,   277,   278,     0,
     279,     0,   280,     0,     0,     0,     0,   281,   282,     0,
       0,     0,   283,     0,   284,   285,     0,   286,   287,     0,
       0,     0,   288,     0,     0,   289,   290,   291,     0,     0,
     292,     0,     0,   293,   294,     0,     0,     0,     0,     0,
     295,   296,     0,   297,     0,   298,     0,   299,   300,     0,
       0,     0,     0,     0,     0,     0,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,     0,   317,   318,   319,   320,     0,   321,   322,
     323,   324,     0,   325,   326,     0,     0,     0,     0,   327,
     328,   329,   330,   331,   332,     0,     0,   333,   334,     0,
     335,     0,   336,     0,   337,   338,   339,   340,   341,   342,
     343,   344,   345,     0,     0,   346,   347,     0,     0,   348,
     349,   350,   351,     0,     0,     0,   352,   353,     0,     0,
       0,   354,     0,   355,   356,   357,     0,   358,   359,   360,
     361,     0,   362,   363,     0,     0,     0,     0,     0,     0,
       0,     0,   364,   365,   366,     0,     0,   367,     0,   368,
       0,   369,   370,   371,   372,   373,   374,   375,   376,   377,
     378,     0,     0,   379,   380,   381,     0,   382,     0,   383,
     384,   385,   386,   387,     0,   388,   389,   390,     0,     0,
     391,     0,     0,     0,   392,   393,   394,   395,   396,     0,
       0,   397,   398,   399,   400,   401,     0,   402,   403,     0,
     404,   405,   406,     0,     0,   407,     0,   408,     0,   409,
     410,     0,   411,   412,     0,   413,     0,   414,     0,     0,
     415,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,     0,   427,   428,     0,     0,     0,   429,   430,
     431,   432,     0,     0,     0,   433,     0,     0,     0,   434,
       0,   435,   436,   437,   438,   439,   440,     0,   441,   442,
     443,   444,   445,   446,     0,     0,     0,     0,     0,     0,
     447,   448,     0,   449,     0,     0,   450,     0,     0,   451,
     452,     0,     0,     0,   453,     0,     0,   454,   455,     0,
     456,   457,   458,   459,   460,   461,     0,     0,   462,   463,
     464,   465,     0,   466,   467,     0,   468,     0,   469,   470,
     471,   472,     0,     0,   473,   474,     0,   475,   476,   477,
     478,     0,     0,     0,     0,     0,   479,   480,   481,     0,
       0,     0,   482,   483,   484,   485,     0,   486,   487,     0,
     488,   489,     0,   490,   491,     0,     0,   492,     0,     0,
     493,     0,   494,     0,   495,   496,   497,     0,     0,     0,
       0,     0,     0,   498,     0,     0,   499,     0,     0,     0,
     500,   501,   502,   503,   504,   505,   506,     0,     0,     0,
       0,     0,     0,   507,   508,     0,   509,   510,   511,     0,
     142,   512,   143,   144,   145,   146,   147,   148,     0,     0,
     149,     0,     0,     0,   150,     0,     0,   151,     0,   152,
     153,   154,   155,   156,   157,   158,   159,     0,   160,     0,
       0,     0,   161,     0,     0,     0,   162,     0,     0,   163,
     164,   165,     0,   166,     0,   167,   168,     0,     0,   169,
       0,     0,   170,   171,     0,   172,   173,     0,   174,   175,
       0,   176,   177,   178,   179,   180,   181,   182,     0,   183,
     184,   185,   186,   187,   188,   189,     0,   190,   191,   192,
     193,   194,   195,   196,   197,     0,   198,   199,     0,   200,
     201,   202,   203,   204,     0,   205,     0,     0,   206,     0,
       0,   207,     0,   208,     0,     0,   209,     0,   210,     0,
       0,     0,   211,   212,   213,     0,     0,   214,     0,     0,
       0,     0,   215,   216,     0,     0,     0,  3430,   217,     0,
     218,     0,     0,     0,   219,     0,   220,   221,   222,   223,
     224,     0,     0,     0,   225,     0,     0,   226,   227,   228,
       0,     0,     0,   229,     0,   230,   231,     0,   232,   233,
     234,     0,     0,   235,   236,     0,   237,   238,   239,   240,
     241,   242,   243,     0,     0,   244,   245,   246,   247,     0,
       0,   248,   249,     0,   250,   251,   252,     0,     0,   253,
       0,     0,     0,   254,     0,   255,     0,   256,     0,   257,
     258,   259,   260,   261,   262,   263,     0,   264,     0,     0,
       0,   265,   266,   267,     0,   268,     0,     0,     0,   269,
     270,     0,     0,     0,   271,   272,   273,   274,   275,     0,
       0,   276,   277,   278,     0,   279,     0,   280,     0,     0,
       0,     0,   281,   282,     0,     0,     0,   283,     0,   284,
     285,     0,   286,   287,     0,     0,     0,   288,     0,     0,
     289,   290,   291,     0,     0,   292,     0,     0,   293,   294,
       0,     0,     0,     0,     0,   295,   296,     0,   297,     0,
     298,     0,   299,   300,     0,     0,     0,     0,     0,     0,
       0,   301,   302,   303,   304,   305,   306,   307,   308,   309,
     310,   311,   312,   313,   314,   315,   316,     0,   317,   318,
     319,   320,     0,   321,   322,   323,   324,     0,   325,   326,
       0,     0,     0,     0,   327,   328,   329,   330,   331,   332,
       0,     0,   333,   334,     0,   335,     0,   336,     0,   337,
     338,   339,   340,   341,   342,   343,   344,   345,     0,     0,
     346,   347,     0,     0,   348,   349,   350,   351,     0,     0,
       0,   352,   353,     0,     0,     0,   354,     0,   355,   356,
     357,     0,   358,   359,   360,   361,     0,   362,   363,     0,
       0,     0,     0,     0,     0,     0,     0,   364,   365,   366,
       0,     0,   367,     0,   368,     0,   369,   370,   371,   372,
     373,   374,   375,   376,   377,   378,     0,     0,   379,   380,
     381,     0,   382,     0,   383,   384,   385,   386,   387,     0,
     388,   389,   390,     0,     0,   391,     0,     0,     0,   392,
     393,   394,   395,   396,     0,     0,   397,   398,   399,   400,
     401,     0,   402,   403,     0,   404,   405,   406,     0,     0,
     407,     0,   408,     0,   409,   410,     0,   411,   412,     0,
     413,     0,   414,     0,     0,   415,   416,   417,   418,   419,
     420,   421,   422,   423,   424,   425,   426,     0,   427,   428,
       0,     0,     0,   429,   430,   431,   432,     0,     0,     0,
     433,     0,     0,     0,   434,     0,   435,   436,   437,   438,
     439,   440,     0,   441,   442,   443,   444,   445,   446,     0,
       0,     0,     0,     0,     0,   447,   448,     0,   449,     0,
       0,   450,     0,     0,   451,   452,     0,     0,     0,   453,
       0,     0,   454,   455,     0,   456,   457,   458,   459,   460,
     461,     0,     0,   462,   463,   464,   465,     0,   466,   467,
       0,   468,     0,   469,   470,   471,   472,     0,     0,   473,
     474,     0,   475,   476,   477,   478,     0,     0,     0,     0,
       0,   479,   480,   481,     0,     0,     0,   482,   483,   484,
     485,     0,   486,   487,     0,   488,   489,     0,   490,   491,
       0,     0,   492,     0,     0,   493,     0,   494,     0,   495,
     496,   497,     0,     0,     0,     0,     0,     0,   498,     0,
       0,   499,     0,     0,     0,   500,   501,   502,   503,   504,
     505,   506,     0,     0,     0,     0,     0,     0,   507,   508,
       0,   509,   510,   511,     0,   142,   512,   143,   144,   145,
     146,   147,   148,     0,     0,   149,     0,     0,     0,   150,
       0,     0,   151,     0,   152,   153,   154,   155,   156,   157,
     158,   159,     0,   160,     0,     0,     0,   161,     0,     0,
       0,   162,     0,     0,   163,   164,   165,     0,   166,     0,
     167,   168,     0,     0,   169,     0,     0,   170,   171,     0,
     172,   173,     0,   174,   175,     0,   176,   177,   178,   179,
     180,   181,   182,     0,   183,   184,   185,   186,   187,   188,
     189,     0,   190,   191,   192,   193,   194,   195,   196,   197,
       0,   198,   199,     0,   200,   201,   202,   203,   204,     0,
     205,     0,     0,   206,     0,     0,   207,     0,   208,     0,
       0,   209,     0,   210,     0,     0,     0,   211,   212,   213,
       0,     0,   214,     0,     0,     0,     0,   215,   216,     0,
       0,     0,     0,   217,     0,   218,     0,     0,     0,   219,
       0,   220,   221,   222,   223,   224,     0,     0,     0,   225,
       0,     0,   226,   227,   228,     0,     0,     0,   229,     0,
     230,   231,     0,   232,   233,   234,     0,     0,   235,   236,
       0,   237,   238,   239,   240,   241,   242,   243,     0,     0,
     244,   245,   246,   247,     0,     0,   248,   249,     0,   250,
     251,   252,     0,     0,   253,     0,     0,     0,   254,     0,
     255,     0,   256,     0,   257,   258,   259,   260,   261,   262,
     263,     0,   264,     0,     0,     0,   265,   266,   267,     0,
     268,     0,     0,     0,   269,   270,     0,     0,     0,   271,
     272,   273,   274,   275,     0,     0,   276,   277,   278,     0,
     279,     0,   280,     0,     0,     0,     0,   281,   282,     0,
       0,     0,   283,     0,   284,   285,     0,   286,   287,     0,
       0,     0,   288,     0,     0,   289,   290,   291,     0,     0,
     292,     0,     0,   293,   294,     0,     0,     0,     0,     0,
     295,   296,     0,   297,     0,   298,     0,   299,   300,     0,
       0,     0,     0,     0,     0,     0,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,     0,   317,   318,   319,   320,     0,   321,   322,
     323,   324,     0,   325,   326,     0,     0,     0,     0,   327,
     328,   329,   330,   331,   332,     0,     0,   333,   334,     0,
     335,     0,   336,     0,   337,   338,   339,   340,   341,   342,
     343,   344,   345,     0,     0,   346,   347,     0,     0,   348,
     349,   350,   351,     0,     0,     0,   352,   353,     0,     0,
       0,   354,     0,   355,   356,   357,     0,   358,   359,   360,
     361,     0,   362,   363,     0,     0,     0,     0,     0,     0,
       0,     0,   364,   365,   366,     0,     0,   367,     0,   368,
       0,   369,   370,   371,   372,   373,   374,   375,   376,   377,
     378,     0,     0,   379,   380,   381,  4320,   382,     0,   383,
     384,   385,   386,   387,     0,   388,   389,   390,     0,     0,
     391,     0,     0,     0,   392,   393,   394,   395,   396,     0,
       0,   397,   398,   399,   400,   401,     0,   402,   403,     0,
     404,   405,   406,     0,     0,   407,     0,   408,     0,   409,
     410,     0,   411,   412,     0,   413,     0,   414,     0,     0,
     415,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,     0,   427,   428,     0,     0,     0,   429,   430,
     431,   432,     0,     0,     0,   433,     0,     0,     0,   434,
       0,   435,   436,   437,   438,   439,   440,     0,   441,   442,
     443,   444,   445,   446,     0,     0,     0,     0,     0,     0,
     447,   448,     0,   449,     0,     0,   450,     0,     0,   451,
     452,     0,     0,     0,   453,     0,     0,   454,   455,     0,
     456,   457,   458,   459,   460,   461,     0,     0,   462,   463,
     464,   465,     0,   466,   467,     0,   468,     0,   469,   470,
     471,   472,     0,     0,   473,   474,     0,   475,   476,   477,
     478,     0,     0,     0,     0,     0,   479,   480,   481,     0,
       0,     0,   482,   483,   484,   485,     0,   486,   487,     0,
     488,   489,     0,   490,   491,     0,     0,   492,     0,     0,
     493,     0,   494,     0,   495,   496,   497,     0,     0,     0,
       0,     0,     0,   498,     0,     0,   499,     0,     0,     0,
     500,   501,   502,   503,   504,   505,   506,     0,     0,     0,
       0,     0,     0,   507,   508,     0,   509,   510,   511,     0,
     142,   512,   143,   144,   145,   146,   147,   148,     0,     0,
     149,     0,     0,     0,   150,     0,     0,   151,     0,   152,
     153,   154,   155,   156,   157,   158,   159,     0,   160,     0,
       0,     0,   161,     0,     0,     0,   162,     0,     0,   163,
     164,   165,     0,   166,     0,   167,   168,     0,     0,   169,
       0,     0,   170,   171,     0,   172,   173,     0,   174,   175,
       0,   176,   177,   178,   179,   180,   181,   182,     0,   183,
     184,   185,   186,   187,   188,   189,     0,   190,   191,   192,
     193,   194,   195,   196,   197,     0,   198,   199,     0,   200,
     201,   202,   203,   204,     0,   205,     0,     0,   206,     0,
       0,   207,     0,   208,     0,     0,   209,     0,   210,     0,
       0,     0,   211,   212,   213,     0,     0,   214,     0,     0,
       0,     0,   215,   216,     0,     0,     0,     0,   217,     0,
     218,     0,     0,     0,   219,     0,   220,   221,   222,   223,
     224,     0,     0,     0,   225,     0,     0,   226,   227,   228,
       0,     0,     0,   229,     0,   230,   231,     0,   232,   233,
     234,     0,     0,   235,   236,     0,   237,   238,   239,   240,
     241,   242,   243,     0,     0,   244,   245,   246,   247,     0,
       0,   248,   249,     0,   250,   251,   252,     0,     0,   253,
       0,     0,     0,   254,     0,   255,     0,   256,     0,   257,
     258,   259,   260,   261,   262,   263,     0,   264,     0,     0,
       0,   265,   266,   267,     0,   268,     0,     0,     0,   269,
     270,     0,     0,     0,   271,   272,   273,   274,   275,     0,
       0,   276,   277,   278,     0,   279,     0,   280,     0,     0,
       0,     0,   281,   282,     0,     0,     0,   283,     0,   284,
     285,     0,   286,   287,     0,     0,     0,   288,     0,     0,
     289,   290,   291,     0,     0,   292,     0,     0,   293,   294,
       0,     0,     0,     0,     0,   295,   296,     0,   297,     0,
     298,     0,   299,   300,     0,     0,     0,     0,     0,     0,
       0,   301,   302,   303,   304,   305,   306,   307,   308,   309,
     310,   311,   312,   313,   314,   315,   316,     0,   317,   318,
     319,   320,     0,   321,   322,   323,   324,     0,   325,   326,
       0,     0,     0,     0,   327,   328,   329,   330,   331,   332,
       0,     0,   333,   334,     0,   335,     0,   336,     0,   337,
     338,   339,   340,   341,   342,   343,   344,   345,     0,     0,
     346,   347,     0,     0,   348,   349,   350,   351,     0,     0,
       0,   352,   353,     0,     0,     0,   354,     0,   355,   356,
     357,     0,   358,   359,   360,   361,     0,   362,   363,     0,
       0,     0,     0,     0,     0,     0,     0,   364,   365,   366,
       0,     0,   367,     0,   368,     0,   369,   370,   371,   372,
     373,   374,   375,   376,   377,   378,     0,     0,   379,   380,
     381,     0,   382,     0,   383,   384,   385,   386,   387,     0,
     388,   389,   390,     0,     0,   391,     0,     0,     0,   392,
     393,   394,   395,   396,     0,     0,   397,   398,   399,   400,
     401,     0,   402,   403,     0,   404,   405,   406,     0,     0,
     407,     0,   408,     0,   409,   410,     0,   411,   412,     0,
     413,     0,   414,     0,     0,   415,   416,   417,   418,   419,
     420,   421,   422,   423,   424,   425,   426,     0,   427,   428,
       0,     0,     0,   429,   430,   431,   432,     0,     0,     0,
     433,     0,     0,     0,   434,     0,   435,   436,   437,   438,
     439,   440,     0,   441,   442,   443,   444,   445,   446,     0,
       0,     0,     0,     0,     0,   447,   448,     0,   449,     0,
       0,   450,     0,     0,   451,   452,     0,     0,     0,   453,
       0,     0,   454,   455,     0,   456,   457,   458,   459,   460,
     461,     0,     0,   462,   463,   464,   465,     0,   466,   467,
       0,   468,     0,   469,   470,   471,   472,     0,     0,   473,
     474,     0,   475,   476,   477,   478,     0,     0,     0,     0,
       0,   479,   480,   481,     0,     0,     0,   482,   483,   484,
     485,     0,   486,   487,     0,   488,   489,     0,   490,   491,
       0,     0,   492,     0,     0,   493,     0,   494,     0,   495,
     496,   497,     0,     0,     0,     0,     0,     0,   498,     0,
       0,   499,     0,     0,     0,   500,   501,   502,   503,   504,
     505,   506,     0,     0,     0,     0,     0,     0,   507,   508,
       0,   509,   510,   511,     0,   142,   512,   143,   144,   145,
     146,   147,   148,     0,     0,   149,     0,     0,     0,   150,
       0,     0,   151,     0,   152,   153,   154,   155,   156,   157,
     158,   159,     0,   160,     0,     0,     0,   161,     0,     0,
       0,   162,     0,     0,   163,   164,   165,     0,   166,     0,
     167,   168,     0,     0,   169,     0,     0,   170,   171,     0,
     172,   173,     0,   174,   175,     0,   176,   177,   178,   179,
     180,   181,   182,     0,   183,   184,   185,   186,   187,   188,
     189,     0,   190,   191,   192,   193,   194,   195,   196,   197,
       0,   198,   199,     0,   200,   201,   202,   203,   204,     0,
     205,     0,     0,   206,     0,     0,   207,     0,   208,     0,
       0,   209,     0,   210,     0,     0,     0,   211,   212,   213,
       0,     0,   214,     0,     0,     0,     0,   215,   216,     0,
       0,     0,     0,   217,     0,   218,     0,     0,     0,   219,
       0,   220,   221,   222,   223,   224,     0,     0,     0,   225,
       0,     0,   226,   227,   228,     0,     0,     0,   229,     0,
     230,   231,     0,   232,   233,   234,     0,     0,   235,   236,
       0,   237,   238,   239,   240,   241,   242,   243,     0,     0,
     244,   245,   246,   247,     0,     0,   248,   249,     0,   250,
    1885,   252,     0,     0,   253,     0,     0,     0,   254,     0,
     255,     0,   256,     0,   257,   258,   259,   260,   261,   262,
     263,     0,   264,     0,     0,     0,   265,   266,   267,     0,
     268,     0,     0,     0,   269,   270,     0,     0,     0,   271,
     272,   273,   274,   275,     0,     0,   276,   277,   278,     0,
     279,     0,   280,     0,     0,     0,     0,   281,   282,     0,
       0,     0,   283,     0,   284,   285,     0,   286,   287,     0,
       0,     0,   288,     0,     0,   289,   290,   291,     0,     0,
     292,     0,     0,   293,   294,     0,     0,     0,     0,     0,
     295,   296,     0,   297,     0,   298,     0,   299,   300,     0,
       0,     0,     0,     0,     0,     0,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,     0,   317,   318,   319,   320,     0,   321,   322,
     323,   324,     0,   325,   326,     0,     0,     0,     0,   327,
     328,   329,   330,   331,   332,     0,     0,   333,   334,     0,
     335,     0,   336,     0,   337,   338,   339,   340,   341,   342,
     343,   344,   345,     0,     0,   346,   347,     0,     0,   348,
    1886,   350,   351,     0,     0,     0,   352,   353,     0,     0,
       0,   354,     0,   355,   356,   357,     0,   358,   359,   360,
     361,     0,   362,   363,     0,     0,     0,     0,     0,     0,
       0,     0,   364,   365,   366,     0,     0,   367,     0,   368,
       0,   369,   370,   371,   372,   373,   374,   375,   376,   377,
     378,     0,     0,   379,   380,   381,     0,   382,     0,   383,
     384,   385,   386,   387,     0,   388,   389,   390,     0,     0,
     391,     0,     0,     0,   392,   393,   394,   395,   396,     0,
       0,   397,   398,   399,   400,   401,     0,   402,   403,     0,
     404,   405,   406,     0,     0,   407,     0,   408,     0,   409,
     410,     0,   411,   412,     0,   413,     0,   414,     0,     0,
     415,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,     0,   427,   428,     0,     0,     0,   429,   430,
     431,   432,     0,     0,     0,   433,     0,     0,     0,   434,
       0,   435,   436,   437,   438,   439,   440,     0,   441,   442,
     443,   444,   445,   446,     0,     0,     0,     0,     0,     0,
     447,   448,     0,   449,     0,     0,   450,     0,     0,   451,
     452,     0,     0,     0,   453,     0,     0,   454,   455,     0,
     456,   457,   458,   459,   460,   461,     0,     0,   462,   463,
     464,   465,     0,   466,   467,     0,   468,     0,   469,   470,
     471,   472,     0,     0,   473,   474,     0,   475,   476,   477,
     478,     0,     0,     0,     0,     0,   479,   480,   481,     0,
       0,     0,   482,   483,   484,   485,     0,   486,   487,     0,
     488,   489,     0,   490,   491,     0,     0,   492,     0,     0,
     493,     0,   494,     0,   495,   496,   497,     0,     0,     0,
       0,     0,     0,   498,     0,     0,   499,     0,     0,     0,
     500,   501,   502,   503,   504,   505,   506,     0,     0,     0,
       0,     0,     0,   507,   508,     0,   509,   510,   511,     0,
     142,   512,   143,   144,   145,   146,   147,   148,     0,     0,
     149,     0,     0,     0,   150,     0,     0,     0,     0,   152,
     153,   154,   155,   156,   157,   158,     0,     0,  -372,     0,
       0,     0,   161,     0,     0,     0,   162,     0,     0,   163,
     164,   165,     0,   166,     0,     0,     0,     0,     0,   169,
    4147,     0,   170,   171,     0,   172,     0,     0,     0,     0,
       0,   176,   177,   178,   179,  4148,   181,   182,     0,   183,
     184,     0,     0,     0,     0,     0,     0,   190,     0,   192,
       0,   194,   195,   196,   197,     0,   198,   199,     0,   200,
     201,   202,     0,   204,     0,   205,     0,     0,   206,     0,
       0,   207,     0,   208,     0,     0,   209,     0,   210,     0,
       0,     0,   211,   212,   213,     0,     0,   214,     0,     0,
       0,     0,   215,     0,     0,     0,     0,     0,   217,     0,
     218,     0,     0,     0,   219,     0,   220,   221,   222,   223,
     224,     0,     0,     0,     0,     0,     0,   226,   227,   228,
       0,  -342,  -342,   229,     0,  -342,   231,     0,   232,   233,
     234,     0,     0,   235,   236,     0,   237,   238,   239,   240,
     241,     0,     0,     0,     0,   244,   245,   246,   247,     0,
       0,   248,   249,  4149,   250,   251,   252,     0,     0,     0,
       0,     0,     0,   254,     0,   255,     0,   256,     0,   257,
     258,   259,   260,   261,     0,   263,     0,   264,     0,     0,
       0,     0,   266,   267,     0,     0,     0,     0,     0,     0,
     270,     0,     0,     0,   271,   272,   273,   274,   275,  4150,
       0,   276,   277,   278,     0,   279,     0,   280,     0,     0,
       0,     0,   281,     0,     0,     0,     0,   283,     0,   284,
     285,     0,   286,   287,  4151,     0,     0,   288,     0,     0,
       0,   290,   291,     0,     0,   292,  4152,     0,   293,   294,
       0,     0,     0,     0,     0,   295,   296,     0,   297,     0,
     298,     0,   299,   300,     0,     0,     0,     0,  -327,     0,
       0,   301,   302,   303,   304,   305,   306,   307,   308,   309,
     310,   311,   312,   313,   314,   315,   316,     0,   317,   318,
     319,   320,     0,   321,   322,   323,   324,     0,   325,   326,
       0,     0,     0,     0,   327,   328,   329,   330,   331,   332,
       0,     0,   333,   334,     0,   335,     0,   336,     0,   337,
     338,   339,   340,   341,   342,   343,   344,   345,     0,     0,
     346,   347,     0,     0,   348,   349,   350,   351,     0,     0,
       0,     0,   353,     0,     0,     0,   354,     0,   355,   356,
     357,     0,   358,   359,   360,  4153,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   365,   366,
       0,     0,     0,     0,   368,     0,   369,   370,   371,   372,
     373,   374,   375,   376,   377,     0,     0,     0,     0,   380,
     381,     0,   382,     0,   383,   384,   385,   386,   387,     0,
     388,   389,   390,     0,     0,   391,     0,     0,     0,   392,
     393,   394,   395,   396,     0,     0,   397,   398,   399,   400,
     401,     0,   402,     0,     0,   404,     0,   406,  -327,     0,
     407,     0,     0,     0,   409,     0,     0,   411,   412,     0,
     413,  4154,   414,     0,     0,   415,     0,   417,   418,   419,
     420,   421,   422,   423,     0,   425,   426,     0,   427,     0,
       0,     0,     0,   429,   430,   431,     0,     0,     0,     0,
     433,     0,     0,     0,     0,     0,     0,   436,     0,     0,
     439,   440,     0,   441,     0,   443,     0,   445,   446,     0,
       0,     0,     0,     0,     0,   447,   448,     0,   449,     0,
       0,   450,     0,     0,   451,     0,     0,     0,     0,   453,
       0,     0,     0,   455,     0,   456,   457,   458,   459,   460,
     461,     0,     0,   462,   463,   464,   465,     0,   466,   467,
       0,   468,     0,   469,   470,   471,   472,     0,     0,   473,
     474,     0,   475,   476,   477,   478,     0,     0,     0,     0,
       0,   479,   480,   481,     0,     0,     0,     0,   483,   484,
     485,     0,   486,   487,     0,   488,   489,     0,     0,     0,
       0,     0,   492,     0,     0,   493,     0,     0,     0,   495,
     496,   497,     0,     0,     0,     0,     0,     0,   498,     0,
       0,   499,     0,     0,     0,   500,   501,   502,   503,   504,
     505,   506,     0,     0,  -327,     0,     0,     0,   507,     0,
       0,   509,     0,   511,     0,   142,   512,   143,   144,   145,
     146,   147,   148,     0,     0,   149,     0,     0,     0,   150,
       0,     0,     0,     0,   152,   153,   154,   155,   156,   157,
     158,     0,     0,  -372,     0,     0,     0,   161,     0,     0,
       0,   162,     0,     0,   163,   164,   165,     0,   166,     0,
       0,     0,     0,     0,   169,  4147,     0,   170,   171,     0,
     172,     0,     0,     0,     0,     0,   176,   177,   178,   179,
    4148,   181,   182,     0,   183,   184,     0,     0,     0,     0,
       0,     0,   190,     0,   192,     0,   194,   195,   196,   197,
       0,   198,   199,     0,   200,   201,   202,     0,   204,     0,
     205,     0,     0,   206,     0,     0,   207,     0,   208,     0,
       0,   209,     0,   210,     0,     0,     0,   211,   212,   213,
       0,     0,   214,     0,     0,     0,     0,   215,     0,     0,
       0,     0,     0,   217,     0,   218,     0,     0,     0,   219,
       0,   220,   221,   222,   223,   224,     0,     0,     0,     0,
       0,     0,   226,   227,   228,     0,  -363,     0,   229,     0,
    -363,   231,     0,   232,   233,   234,     0,     0,   235,   236,
       0,   237,   238,   239,   240,   241,     0,     0,     0,     0,
     244,   245,   246,   247,     0,     0,   248,   249,  4149,   250,
     251,   252,     0,     0,     0,     0,     0,     0,   254,     0,
     255,     0,   256,     0,   257,   258,   259,   260,   261,     0,
     263,     0,   264,     0,     0,     0,     0,   266,   267,     0,
       0,     0,     0,     0,     0,   270,     0,     0,     0,   271,
     272,   273,   274,   275,  4150,     0,   276,   277,   278,     0,
     279,     0,   280,     0,     0,     0,     0,   281,     0,     0,
       0,     0,   283,     0,   284,   285,     0,   286,   287,  4151,
       0,     0,   288,     0,     0,     0,   290,   291,     0,     0,
     292,  4152,     0,   293,   294,     0,     0,     0,     0,     0,
     295,   296,     0,   297,     0,   298,     0,   299,   300,     0,
       0,     0,     0,  -327,     0,     0,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,     0,   317,   318,   319,   320,     0,   321,   322,
     323,   324,     0,   325,   326,     0,     0,     0,     0,   327,
     328,   329,   330,   331,   332,     0,     0,   333,   334,     0,
     335,     0,   336,     0,   337,   338,   339,   340,   341,   342,
     343,   344,   345,     0,     0,   346,   347,     0,     0,   348,
     349,   350,   351,     0,     0,     0,     0,   353,     0,     0,
       0,   354,     0,   355,   356,   357,     0,   358,   359,   360,
    4153,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   365,   366,     0,     0,     0,     0,   368,
       0,   369,   370,   371,   372,   373,   374,   375,   376,   377,
       0,     0,     0,     0,   380,   381,     0,   382,     0,   383,
     384,   385,   386,   387,     0,   388,   389,   390,     0,     0,
     391,     0,     0,     0,   392,   393,   394,   395,   396,     0,
       0,   397,   398,   399,   400,   401,     0,   402,     0,     0,
     404,     0,   406,  -327,     0,   407,     0,     0,     0,   409,
       0,     0,   411,   412,     0,   413,  4154,   414,     0,     0,
     415,     0,   417,   418,   419,   420,   421,   422,   423,     0,
     425,   426,     0,   427,     0,     0,     0,     0,   429,   430,
     431,     0,     0,     0,     0,   433,     0,     0,     0,     0,
       0,     0,   436,     0,     0,   439,   440,     0,   441,     0,
     443,     0,   445,   446,     0,     0,     0,     0,     0,     0,
     447,   448,     0,   449,     0,     0,   450,     0,     0,   451,
       0,     0,     0,     0,   453,     0,     0,     0,   455,     0,
     456,   457,   458,   459,   460,   461,     0,     0,   462,   463,
     464,   465,     0,   466,   467,     0,   468,     0,   469,   470,
     471,   472,     0,     0,   473,   474,     0,   475,   476,   477,
     478,     0,     0,     0,     0,     0,   479,   480,   481,     0,
       0,     0,     0,   483,   484,   485,     0,   486,   487,     0,
     488,   489,     0,     0,     0,     0,     0,   492,     0,     0,
     493,     0,     0,     0,   495,   496,   497,     0,     0,     0,
       0,     0,     0,   498,     0,     0,   499,     0,     0,     0,
     500,   501,   502,   503,   504,   505,   506,  -363,     0,  -327,
       0,     0,     0,   507,     0,     0,   509,     0,   511,     0,
     142,   512,   143,   144,   145,   146,   147,   148,     0,     0,
     149,     0,     0,     0,   150,     0,     0,     0,     0,   152,
     153,   154,   155,   156,   157,   158,     0,     0,  -372,     0,
       0,     0,   161,     0,     0,     0,   162,     0,     0,   163,
     164,   165,     0,   166,     0,     0,     0,     0,     0,   169,
    4147,     0,   170,   171,     0,   172,     0,     0,     0,     0,
       0,   176,   177,   178,   179,  4148,   181,   182,     0,   183,
     184,     0,     0,     0,     0,     0,     0,   190,     0,   192,
       0,   194,   195,   196,   197,     0,   198,   199,     0,   200,
     201,   202,     0,   204,     0,   205,     0,     0,   206,     0,
       0,   207,     0,   208,     0,     0,   209,     0,   210,     0,
       0,     0,   211,   212,   213,     0,     0,   214,     0,     0,
       0,     0,   215,     0,     0,     0,     0,     0,   217,     0,
     218,     0,     0,     0,   219,     0,   220,   221,   222,   223,
     224,     0,     0,     0,     0,     0,     0,   226,   227,   228,
       0,  -360,     0,   229,     0,  -360,   231,     0,   232,   233,
     234,     0,     0,   235,   236,     0,   237,   238,   239,   240,
     241,     0,     0,     0,     0,   244,   245,   246,   247,     0,
       0,   248,   249,  4149,   250,   251,   252,     0,     0,     0,
       0,     0,     0,   254,     0,   255,     0,   256,     0,   257,
     258,   259,   260,   261,     0,   263,     0,   264,     0,     0,
       0,     0,   266,   267,     0,     0,     0,     0,     0,     0,
     270,     0,     0,     0,   271,   272,   273,   274,   275,  4150,
       0,   276,   277,   278,     0,   279,     0,   280,     0,     0,
       0,     0,   281,     0,     0,     0,     0,   283,     0,   284,
     285,     0,   286,   287,  4151,     0,     0,   288,     0,     0,
       0,   290,   291,     0,     0,   292,  4152,     0,   293,   294,
       0,     0,     0,     0,     0,   295,   296,     0,   297,     0,
     298,     0,   299,   300,     0,     0,     0,     0,  -327,     0,
       0,   301,   302,   303,   304,   305,   306,   307,   308,   309,
     310,   311,   312,   313,   314,   315,   316,     0,   317,   318,
     319,   320,     0,   321,   322,   323,   324,     0,   325,   326,
       0,     0,     0,     0,   327,   328,   329,   330,   331,   332,
       0,     0,   333,   334,     0,   335,     0,   336,     0,   337,
     338,   339,   340,   341,   342,   343,   344,   345,     0,     0,
     346,   347,     0,     0,   348,   349,   350,   351,     0,     0,
       0,     0,   353,     0,     0,     0,   354,     0,   355,   356,
     357,     0,   358,   359,   360,  4153,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   365,   366,
       0,     0,     0,     0,   368,     0,   369,   370,   371,   372,
     373,   374,   375,   376,   377,     0,     0,     0,     0,   380,
     381,     0,   382,     0,   383,   384,   385,   386,   387,     0,
     388,   389,   390,     0,     0,   391,     0,     0,     0,   392,
     393,   394,   395,   396,     0,     0,   397,   398,   399,   400,
     401,     0,   402,     0,     0,   404,     0,   406,  -327,     0,
     407,     0,     0,     0,   409,     0,     0,   411,   412,     0,
     413,  4154,   414,     0,     0,   415,     0,   417,   418,   419,
     420,   421,   422,   423,     0,   425,   426,     0,   427,     0,
       0,     0,     0,   429,   430,   431,     0,     0,     0,     0,
     433,     0,     0,     0,     0,     0,     0,   436,     0,     0,
     439,   440,     0,   441,     0,   443,     0,   445,   446,     0,
       0,     0,     0,     0,     0,   447,   448,     0,   449,     0,
       0,   450,     0,     0,   451,     0,     0,     0,     0,   453,
       0,     0,     0,   455,     0,   456,   457,   458,   459,   460,
     461,     0,     0,   462,   463,   464,   465,     0,   466,   467,
       0,   468,     0,   469,   470,   471,   472,     0,     0,   473,
     474,     0,   475,   476,   477,   478,     0,     0,     0,     0,
       0,   479,   480,   481,     0,     0,     0,     0,   483,   484,
     485,     0,   486,   487,     0,   488,   489,     0,     0,     0,
       0,     0,   492,     0,     0,   493,     0,     0,     0,   495,
     496,   497,     0,     0,     0,     0,     0,     0,   498,     0,
       0,   499,     0,     0,     0,   500,   501,   502,   503,   504,
     505,   506,  -360,     0,  -327,     0,     0,     0,   507,     0,
       0,   509,     0,   511,     0,   142,   512,   143,   144,   145,
     146,   147,   148,     0,     0,   149,     0,     0,     0,   150,
       0,     0,     0,     0,   152,   153,   154,   155,   156,   157,
     158,     0,     0,  -372,     0,     0,     0,   161,     0,     0,
       0,   162,     0,     0,   163,   164,   165,     0,   166,     0,
       0,     0,     0,     0,   169,  4147,     0,   170,   171,     0,
     172,     0,     0,     0,     0,     0,   176,   177,   178,   179,
    4148,   181,   182,     0,   183,   184,     0,     0,     0,     0,
       0,     0,   190,     0,   192,     0,   194,   195,   196,   197,
       0,   198,   199,     0,   200,   201,   202,     0,   204,     0,
     205,     0,     0,   206,     0,     0,   207,     0,   208,     0,
       0,   209,     0,   210,     0,     0,     0,   211,   212,   213,
       0,     0,   214,     0,     0,     0,     0,   215,     0,     0,
       0,     0,     0,   217,     0,   218,     0,     0,     0,   219,
       0,   220,   221,   222,   223,   224,     0,     0,     0,     0,
       0,     0,   226,   227,   228,     0,     0,     0,   229,     0,
    4529,   231,     0,   232,   233,   234,     0,     0,   235,   236,
       0,   237,   238,   239,   240,   241,     0,     0,     0,     0,
     244,   245,   246,   247,     0,     0,   248,   249,  4149,   250,
     251,   252,     0,     0,     0,     0,     0,     0,   254,     0,
     255,     0,   256,     0,   257,   258,   259,   260,   261,     0,
     263,     0,   264,     0,     0,     0,     0,   266,   267,     0,
       0,     0,     0,     0,     0,   270,     0,     0,     0,   271,
     272,   273,   274,   275,  4150,     0,   276,   277,   278,     0,
     279,     0,   280,     0,     0,     0,     0,   281,     0,     0,
       0,     0,   283,     0,   284,   285,     0,   286,   287,  4151,
       0,     0,   288,     0,     0,     0,   290,   291,     0,     0,
     292,  4152,     0,   293,   294,     0,     0,     0,     0,     0,
     295,   296,     0,   297,     0,   298,     0,   299,   300,     0,
       0,     0,     0,  -327,     0,     0,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,     0,   317,   318,   319,   320,     0,   321,   322,
     323,   324,     0,   325,   326,     0,     0,     0,     0,   327,
     328,   329,   330,   331,   332,     0,     0,   333,   334,     0,
     335,     0,   336,     0,   337,   338,   339,   340,   341,   342,
     343,   344,   345,     0,     0,   346,   347,     0,     0,   348,
     349,   350,   351,     0,     0,     0,     0,   353,     0,     0,
       0,   354,     0,   355,   356,   357,     0,   358,   359,   360,
    4153,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   365,   366,     0,     0,     0,     0,   368,
       0,   369,   370,   371,   372,   373,   374,   375,   376,   377,
       0,     0,     0,     0,   380,   381,     0,   382,     0,   383,
     384,   385,   386,   387,     0,   388,   389,   390,     0,     0,
     391,     0,     0,     0,   392,   393,   394,   395,   396,     0,
       0,   397,   398,   399,   400,   401,     0,   402,     0,     0,
     404,     0,   406,  -327,     0,   407,     0,     0,     0,   409,
       0,     0,   411,   412,     0,   413,  4154,   414,     0,     0,
     415,     0,   417,   418,   419,   420,   421,   422,   423,     0,
     425,   426,     0,   427,     0,     0,     0,     0,   429,   430,
     431,     0,     0,     0,     0,   433,     0,     0,     0,     0,
       0,     0,   436,     0,     0,   439,   440,     0,   441,     0,
     443,     0,   445,   446,     0,     0,     0,     0,     0,     0,
     447,   448,     0,   449,     0,     0,   450,     0,     0,   451,
       0,     0,     0,     0,   453,     0,     0,     0,   455,     0,
     456,   457,   458,   459,   460,   461,     0,     0,   462,   463,
     464,   465,     0,   466,   467,     0,   468,     0,   469,   470,
     471,   472,     0,     0,   473,   474,     0,   475,   476,   477,
     478,     0,     0,     0,     0,     0,   479,   480,   481,     0,
       0,     0,     0,   483,   484,   485,     0,   486,   487,     0,
     488,   489,     0,     0,     0,     0,     0,   492,     0,     0,
     493,     0,     0,     0,   495,   496,   497,     0,     0,     0,
       0,     0,     0,   498,     0,     0,   499,     0,     0,     0,
     500,   501,   502,   503,   504,   505,   506,     0,     0,  -327,
       0,     0,     0,   507,     0,     0,   509,     0,   511,     0,
     142,   512,   143,   144,   145,   146,   147,   148,     0,     0,
     149,     0,     0,     0,   150,     0,     0,     0,     0,   152,
     153,   154,   155,   156,   157,   158,     0,     0,  -372,     0,
       0,     0,   161,     0,     0,     0,   162,     0,     0,   163,
     164,   165,     0,   166,     0,     0,     0,     0,     0,   169,
    4147,     0,   170,   171,     0,   172,     0,     0,     0,     0,
       0,   176,   177,   178,   179,  4148,   181,   182,     0,   183,
     184,     0,     0,     0,     0,     0,     0,   190,     0,   192,
       0,   194,   195,   196,   197,     0,   198,   199,     0,   200,
     201,   202,     0,   204,     0,   205,     0,     0,   206,     0,
       0,   207,     0,   208,     0,     0,   209,     0,   210,     0,
       0,     0,   211,   212,   213,     0,     0,   214,     0,     0,
       0,     0,   215,     0,     0,     0,     0,     0,   217,     0,
     218,     0,     0,     0,   219,     0,   220,   221,   222,   223,
     224,     0,     0,     0,     0,     0,     0,   226,   227,   228,
       0,     0,     0,   229,     0,  -365,   231,     0,   232,   233,
     234,     0,     0,   235,   236,     0,   237,   238,   239,   240,
     241,     0,     0,     0,     0,   244,   245,   246,   247,     0,
       0,   248,   249,  4149,   250,   251,   252,     0,     0,     0,
       0,     0,     0,   254,     0,   255,     0,   256,     0,   257,
     258,   259,   260,   261,     0,   263,     0,   264,     0,     0,
       0,     0,   266,   267,     0,     0,     0,     0,     0,     0,
     270,     0,     0,     0,   271,   272,   273,   274,   275,  4150,
       0,   276,   277,   278,     0,   279,     0,   280,     0,     0,
       0,     0,   281,     0,     0,     0,     0,   283,     0,   284,
     285,     0,   286,   287,  4151,     0,     0,   288,     0,     0,
       0,   290,   291,     0,     0,   292,  4152,     0,   293,   294,
       0,     0,     0,     0,     0,   295,   296,     0,   297,     0,
     298,     0,   299,   300,     0,     0,     0,     0,  -327,     0,
       0,   301,   302,   303,   304,   305,   306,   307,   308,   309,
     310,   311,   312,   313,   314,   315,   316,     0,   317,   318,
     319,   320,     0,   321,   322,   323,   324,     0,   325,   326,
       0,     0,     0,     0,   327,   328,   329,   330,   331,   332,
       0,     0,   333,   334,     0,   335,     0,   336,     0,   337,
     338,   339,   340,   341,   342,   343,   344,   345,     0,     0,
     346,   347,     0,     0,   348,   349,   350,   351,     0,     0,
       0,     0,   353,     0,     0,     0,   354,     0,   355,   356,
     357,     0,   358,   359,   360,  4153,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   365,   366,
       0,     0,     0,     0,   368,     0,   369,   370,   371,   372,
     373,   374,   375,   376,   377,     0,     0,     0,     0,   380,
     381,     0,   382,     0,   383,   384,   385,   386,   387,     0,
     388,   389,   390,     0,     0,   391,     0,     0,     0,   392,
     393,   394,   395,   396,     0,     0,   397,   398,   399,   400,
     401,     0,   402,     0,     0,   404,     0,   406,  -327,     0,
     407,     0,     0,     0,   409,     0,     0,   411,   412,     0,
     413,  4154,   414,     0,     0,   415,     0,   417,   418,   419,
     420,   421,   422,   423,     0,   425,   426,     0,   427,     0,
       0,     0,     0,   429,   430,   431,     0,     0,     0,     0,
     433,     0,     0,     0,     0,     0,     0,   436,     0,     0,
     439,   440,     0,   441,     0,   443,     0,   445,   446,     0,
       0,     0,     0,     0,     0,   447,   448,     0,   449,     0,
       0,   450,     0,     0,   451,     0,     0,     0,     0,   453,
       0,     0,     0,   455,     0,   456,   457,   458,   459,   460,
     461,     0,     0,   462,   463,   464,   465,     0,   466,   467,
       0,   468,     0,   469,   470,   471,   472,     0,     0,   473,
     474,     0,   475,   476,   477,   478,     0,     0,     0,     0,
       0,   479,   480,   481,     0,     0,     0,     0,   483,   484,
     485,     0,   486,   487,     0,   488,   489,     0,     0,     0,
       0,     0,   492,     0,     0,   493,     0,     0,     0,   495,
     496,   497,     0,     0,     0,     0,     0,     0,   498,     0,
       0,   499,     0,     0,     0,   500,   501,   502,   503,   504,
     505,   506,     0,     0,  -327,     0,     0,     0,   507,     0,
       0,   509,     0,   511,     0,   142,   512,   143,   144,   145,
     146,   147,   148,     0,     0,   149,     0,     0,     0,   150,
       0,     0,     0,     0,   152,   153,   154,   155,   156,   157,
     158,     0,     0,  -372,     0,     0,     0,   161,     0,     0,
       0,   162,     0,     0,   163,   164,   165,     0,   166,     0,
       0,     0,     0,     0,   169,  4147,     0,   170,   171,     0,
     172,     0,     0,     0,     0,     0,   176,   177,   178,   179,
    4148,   181,   182,     0,   183,   184,     0,     0,     0,     0,
       0,     0,   190,     0,   192,     0,   194,   195,   196,   197,
       0,   198,   199,     0,   200,   201,   202,     0,   204,     0,
     205,     0,     0,   206,     0,     0,   207,     0,   208,     0,
       0,   209,     0,   210,     0,     0,     0,   211,   212,   213,
       0,     0,   214,     0,     0,     0,     0,   215,     0,     0,
       0,     0,     0,   217,     0,   218,     0,     0,     0,   219,
       0,   220,   221,   222,   223,   224,     0,     0,     0,     0,
       0,     0,   226,   227,   228,     0,     0,     0,   229,     0,
    4666,   231,     0,   232,   233,   234,     0,     0,   235,   236,
       0,   237,   238,   239,   240,   241,     0,     0,     0,     0,
     244,   245,   246,   247,     0,     0,   248,   249,  4149,   250,
     251,   252,     0,     0,     0,     0,     0,     0,   254,     0,
     255,     0,   256,     0,   257,   258,   259,   260,   261,     0,
     263,     0,   264,     0,     0,     0,     0,   266,   267,     0,
       0,     0,     0,     0,     0,   270,     0,     0,     0,   271,
     272,   273,   274,   275,  4150,     0,   276,   277,   278,     0,
     279,     0,   280,     0,     0,     0,     0,   281,     0,     0,
       0,     0,   283,     0,   284,   285,     0,   286,   287,  4151,
       0,     0,   288,     0,     0,     0,   290,   291,     0,     0,
     292,  4152,     0,   293,   294,     0,     0,     0,     0,     0,
     295,   296,     0,   297,     0,   298,     0,   299,   300,     0,
       0,     0,     0,  -327,     0,     0,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,     0,   317,   318,   319,   320,     0,   321,   322,
     323,   324,     0,   325,   326,     0,     0,     0,     0,   327,
     328,   329,   330,   331,   332,     0,     0,   333,   334,     0,
     335,     0,   336,     0,   337,   338,   339,   340,   341,   342,
     343,   344,   345,     0,     0,   346,   347,     0,     0,   348,
     349,   350,   351,     0,     0,     0,     0,   353,     0,     0,
       0,   354,     0,   355,   356,   357,     0,   358,   359,   360,
    4153,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   365,   366,     0,     0,     0,     0,   368,
       0,   369,   370,   371,   372,   373,   374,   375,   376,   377,
       0,     0,     0,     0,   380,   381,     0,   382,     0,   383,
     384,   385,   386,   387,     0,   388,   389,   390,     0,     0,
     391,     0,     0,     0,   392,   393,   394,   395,   396,     0,
       0,   397,   398,   399,   400,   401,     0,   402,     0,     0,
     404,     0,   406,  -327,     0,   407,     0,     0,     0,   409,
       0,     0,   411,   412,     0,   413,  4154,   414,     0,     0,
     415,     0,   417,   418,   419,   420,   421,   422,   423,     0,
     425,   426,     0,   427,     0,     0,     0,     0,   429,   430,
     431,     0,     0,     0,     0,   433,     0,     0,     0,     0,
       0,     0,   436,     0,     0,   439,   440,     0,   441,     0,
     443,     0,   445,   446,     0,     0,     0,     0,     0,     0,
     447,   448,     0,   449,     0,     0,   450,     0,     0,   451,
       0,     0,     0,     0,   453,     0,     0,     0,   455,     0,
     456,   457,   458,   459,   460,   461,     0,     0,   462,   463,
     464,   465,     0,   466,   467,     0,   468,     0,   469,   470,
     471,   472,     0,     0,   473,   474,     0,   475,   476,   477,
     478,     0,     0,     0,     0,     0,   479,   480,   481,     0,
       0,     0,     0,   483,   484,   485,     0,   486,   487,     0,
     488,   489,     0,     0,     0,     0,     0,   492,     0,     0,
     493,     0,     0,     0,   495,   496,   497,     0,     0,     0,
       0,     0,     0,   498,     0,     0,   499,     0,     0,     0,
     500,   501,   502,   503,   504,   505,   506,     0,     0,  -327,
       0,     0,     0,   507,     0,     0,   509,     0,   511,     0,
     142,   512,   143,   144,   145,   146,   147,   148,     0,     0,
     149,     0,     0,     0,   150,     0,     0,     0,     0,   152,
     153,   154,   155,   156,   157,   158,     0,     0,  -372,     0,
       0,     0,   161,     0,     0,     0,   162,     0,     0,   163,
     164,   165,     0,   166,     0,     0,     0,     0,     0,   169,
    4147,     0,   170,   171,     0,   172,     0,     0,     0,     0,
       0,   176,   177,   178,   179,  4148,   181,   182,     0,   183,
     184,     0,     0,     0,     0,     0,     0,   190,     0,   192,
       0,   194,   195,   196,   197,     0,   198,   199,     0,   200,
     201,   202,     0,   204,     0,   205,     0,     0,   206,     0,
       0,   207,     0,   208,     0,     0,   209,     0,   210,     0,
       0,     0,   211,   212,   213,     0,     0,   214,     0,     0,
       0,     0,   215,     0,     0,     0,     0,     0,   217,     0,
     218,     0,     0,     0,   219,     0,   220,   221,   222,   223,
     224,     0,     0,     0,     0,     0,     0,   226,   227,   228,
       0,     0,     0,   229,     0,  4719,   231,     0,   232,   233,
     234,     0,     0,   235,   236,     0,   237,   238,   239,   240,
     241,     0,     0,     0,     0,   244,   245,   246,   247,     0,
       0,   248,   249,  4149,   250,   251,   252,     0,     0,     0,
       0,     0,     0,   254,     0,   255,     0,   256,     0,   257,
     258,   259,   260,   261,     0,   263,     0,   264,     0,     0,
       0,     0,   266,   267,     0,     0,     0,     0,     0,     0,
     270,     0,     0,     0,   271,   272,   273,   274,   275,  4150,
       0,   276,   277,   278,     0,   279,     0,   280,     0,     0,
       0,     0,   281,     0,     0,     0,     0,   283,     0,   284,
     285,     0,   286,   287,  4151,     0,     0,   288,     0,     0,
       0,   290,   291,     0,     0,   292,  4152,     0,   293,   294,
       0,     0,     0,     0,     0,   295,   296,     0,   297,     0,
     298,     0,   299,   300,     0,     0,     0,     0,  -327,     0,
       0,   301,   302,   303,   304,   305,   306,   307,   308,   309,
     310,   311,   312,   313,   314,   315,   316,     0,   317,   318,
     319,   320,     0,   321,   322,   323,   324,     0,   325,   326,
       0,     0,     0,     0,   327,   328,   329,   330,   331,   332,
       0,     0,   333,   334,     0,   335,     0,   336,     0,   337,
     338,   339,   340,   341,   342,   343,   344,   345,     0,     0,
     346,   347,     0,     0,   348,   349,   350,   351,     0,     0,
       0,     0,   353,     0,     0,     0,   354,     0,   355,   356,
     357,     0,   358,   359,   360,  4153,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   365,   366,
       0,     0,     0,     0,   368,     0,   369,   370,   371,   372,
     373,   374,   375,   376,   377,     0,     0,     0,     0,   380,
     381,     0,   382,     0,   383,   384,   385,   386,   387,     0,
     388,   389,   390,     0,     0,   391,     0,     0,     0,   392,
     393,   394,   395,   396,     0,     0,   397,   398,   399,   400,
     401,     0,   402,     0,     0,   404,     0,   406,  -327,     0,
     407,     0,     0,     0,   409,     0,     0,   411,   412,     0,
     413,  4154,   414,     0,     0,   415,     0,   417,   418,   419,
     420,   421,   422,   423,     0,   425,   426,     0,   427,     0,
       0,     0,     0,   429,   430,   431,     0,     0,     0,     0,
     433,     0,     0,     0,     0,     0,     0,   436,     0,     0,
     439,   440,     0,   441,     0,   443,     0,   445,   446,     0,
       0,     0,     0,     0,     0,   447,   448,     0,   449,     0,
       0,   450,     0,     0,   451,     0,     0,     0,     0,   453,
       0,     0,     0,   455,     0,   456,   457,   458,   459,   460,
     461,     0,     0,   462,   463,   464,   465,     0,   466,   467,
       0,   468,     0,   469,   470,   471,   472,     0,     0,   473,
     474,     0,   475,   476,   477,   478,     0,     0,     0,     0,
       0,   479,   480,   481,     0,     0,     0,     0,   483,   484,
     485,     0,   486,   487,     0,   488,   489,     0,     0,     0,
       0,     0,   492,     0,     0,   493,     0,     0,     0,   495,
     496,   497,     0,     0,     0,     0,     0,     0,   498,     0,
       0,   499,     0,     0,     0,   500,   501,   502,   503,   504,
     505,   506,     0,     0,  -327,     0,     0,     0,   507,     0,
       0,   509,     0,   511,     0,   142,   512,   143,   144,   145,
     146,   147,   148,     0,     0,   149,     0,     0,     0,   150,
       0,     0,     0,     0,   152,   153,   154,   155,   156,   157,
     158,     0,     0,  -372,     0,     0,     0,   161,     0,     0,
       0,   162,     0,     0,   163,   164,   165,     0,   166,     0,
       0,     0,     0,     0,   169,  4147,     0,   170,   171,     0,
     172,     0,     0,     0,     0,     0,   176,   177,   178,   179,
    4148,   181,   182,     0,   183,   184,     0,     0,     0,     0,
       0,     0,   190,     0,   192,     0,   194,   195,   196,   197,
       0,   198,   199,     0,   200,   201,   202,     0,   204,     0,
     205,     0,     0,   206,     0,     0,   207,     0,   208,     0,
       0,   209,     0,   210,     0,     0,     0,   211,   212,   213,
       0,     0,   214,     0,     0,     0,     0,   215,     0,     0,
       0,     0,     0,   217,     0,   218,     0,     0,     0,   219,
       0,   220,   221,   222,   223,   224,     0,     0,     0,     0,
       0,     0,   226,   227,   228,     0,     0,     0,   229,     0,
    -346,   231,     0,   232,   233,   234,     0,     0,   235,   236,
       0,   237,   238,   239,   240,   241,     0,     0,     0,     0,
     244,   245,   246,   247,     0,     0,   248,   249,  4149,   250,
     251,   252,     0,     0,     0,     0,     0,     0,   254,     0,
     255,     0,   256,     0,   257,   258,   259,   260,   261,     0,
     263,     0,   264,     0,     0,     0,     0,   266,   267,     0,
       0,     0,     0,     0,     0,   270,     0,     0,     0,   271,
     272,   273,   274,   275,  4150,     0,   276,   277,   278,     0,
     279,     0,   280,     0,     0,     0,     0,   281,     0,     0,
       0,     0,   283,     0,   284,   285,     0,   286,   287,  4151,
       0,     0,   288,     0,     0,     0,   290,   291,     0,     0,
     292,  4152,     0,   293,   294,     0,     0,     0,     0,     0,
     295,   296,     0,   297,     0,   298,     0,   299,   300,     0,
       0,     0,     0,  -327,     0,     0,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,     0,   317,   318,   319,   320,     0,   321,   322,
     323,   324,     0,   325,   326,     0,     0,     0,     0,   327,
     328,   329,   330,   331,   332,     0,     0,   333,   334,     0,
     335,     0,   336,     0,   337,   338,   339,   340,   341,   342,
     343,   344,   345,     0,     0,   346,   347,     0,     0,   348,
     349,   350,   351,     0,     0,     0,     0,   353,     0,     0,
       0,   354,     0,   355,   356,   357,     0,   358,   359,   360,
    4153,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   365,   366,     0,     0,     0,     0,   368,
       0,   369,   370,   371,   372,   373,   374,   375,   376,   377,
       0,     0,     0,     0,   380,   381,     0,   382,     0,   383,
     384,   385,   386,   387,     0,   388,   389,   390,     0,     0,
     391,     0,     0,     0,   392,   393,   394,   395,   396,     0,
       0,   397,   398,   399,   400,   401,     0,   402,     0,     0,
     404,     0,   406,  -327,     0,   407,     0,     0,     0,   409,
       0,     0,   411,   412,     0,   413,  4154,   414,     0,     0,
     415,     0,   417,   418,   419,   420,   421,   422,   423,     0,
     425,   426,     0,   427,     0,     0,     0,     0,   429,   430,
     431,     0,     0,     0,     0,   433,     0,     0,     0,     0,
       0,     0,   436,     0,     0,   439,   440,     0,   441,     0,
     443,     0,   445,   446,     0,     0,     0,     0,     0,     0,
     447,   448,     0,   449,     0,     0,   450,     0,     0,   451,
       0,     0,     0,     0,   453,     0,     0,     0,   455,     0,
     456,   457,   458,   459,   460,   461,     0,     0,   462,   463,
     464,   465,     0,   466,   467,     0,   468,     0,   469,   470,
     471,   472,     0,     0,   473,   474,     0,   475,   476,   477,
     478,     0,     0,     0,     0,     0,   479,   480,   481,     0,
       0,     0,     0,   483,   484,   485,     0,   486,   487,     0,
     488,   489,     0,     0,     0,     0,     0,   492,     0,     0,
     493,     0,     0,     0,   495,   496,   497,     0,     0,     0,
       0,     0,     0,   498,     0,     0,   499,     0,     0,     0,
     500,   501,   502,   503,   504,   505,   506,     0,     0,  -327,
       0,     0,     0,   507,     0,     0,   509,     0,   511,     0,
     142,   512,   143,   144,   145,   146,   147,   148,     0,     0,
     149,     0,     0,     0,   150,     0,     0,     0,     0,   152,
     153,   154,   155,   156,   157,   158,     0,     0,  -372,     0,
       0,     0,   161,     0,     0,     0,   162,     0,     0,   163,
     164,   165,     0,   166,     0,     0,     0,     0,     0,   169,
    4147,     0,   170,   171,     0,   172,     0,     0,     0,     0,
       0,   176,   177,   178,   179,  4148,   181,   182,     0,   183,
     184,     0,     0,     0,     0,     0,     0,   190,     0,   192,
       0,   194,   195,   196,   197,     0,   198,   199,     0,   200,
     201,   202,     0,   204,     0,   205,     0,     0,   206,     0,
       0,   207,     0,   208,     0,     0,   209,     0,   210,     0,
       0,     0,   211,   212,   213,     0,     0,   214,     0,     0,
       0,     0,   215,     0,     0,     0,     0,     0,   217,     0,
     218,     0,     0,     0,   219,     0,   220,   221,   222,   223,
     224,     0,     0,     0,     0,     0,     0,   226,   227,   228,
       0,     0,     0,   229,     0,     0,   231,     0,   232,   233,
     234,     0,     0,   235,   236,     0,   237,   238,   239,   240,
     241,     0,     0,     0,     0,   244,   245,   246,   247,     0,
       0,   248,   249,  4149,   250,   251,   252,     0,     0,     0,
       0,     0,     0,   254,     0,   255,     0,   256,     0,   257,
     258,   259,   260,   261,     0,   263,     0,   264,     0,     0,
       0,     0,   266,   267,     0,     0,     0,     0,     0,     0,
     270,     0,     0,     0,   271,   272,   273,   274,   275,  4150,
       0,   276,   277,   278,     0,   279,     0,   280,     0,     0,
       0,     0,   281,     0,     0,     0,     0,   283,     0,   284,
     285,     0,   286,   287,  4151,     0,     0,   288,     0,     0,
       0,   290,   291,     0,     0,   292,  4152,     0,   293,   294,
       0,     0,     0,     0,     0,   295,   296,     0,   297,     0,
     298,     0,   299,   300,     0,     0,     0,     0,  -327,     0,
       0,   301,   302,   303,   304,   305,   306,   307,   308,   309,
     310,   311,   312,   313,   314,   315,   316,     0,   317,   318,
     319,   320,     0,   321,   322,   323,   324,     0,   325,   326,
       0,     0,     0,     0,   327,   328,   329,   330,   331,   332,
       0,     0,   333,   334,     0,   335,     0,   336,     0,   337,
     338,   339,   340,   341,   342,   343,   344,   345,     0,     0,
     346,   347,     0,     0,   348,   349,   350,   351,     0,     0,
       0,     0,   353,     0,     0,     0,   354,     0,   355,   356,
     357,     0,   358,   359,   360,  4153,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   365,   366,
       0,     0,     0,     0,   368,     0,   369,   370,   371,   372,
     373,   374,   375,   376,   377,     0,     0,     0,     0,   380,
     381,     0,   382,     0,   383,   384,   385,   386,   387,     0,
     388,   389,   390,     0,     0,   391,     0,     0,     0,   392,
     393,   394,   395,   396,     0,     0,   397,   398,   399,   400,
     401,     0,   402,     0,     0,   404,     0,   406,  -327,     0,
     407,     0,     0,     0,   409,     0,     0,   411,   412,     0,
     413,  4154,   414,     0,     0,   415,     0,   417,   418,   419,
     420,   421,   422,   423,     0,   425,   426,     0,   427,     0,
       0,     0,     0,   429,   430,   431,     0,     0,     0,     0,
     433,     0,     0,     0,     0,     0,     0,   436,     0,     0,
     439,   440,     0,   441,     0,   443,     0,   445,   446,     0,
       0,     0,     0,     0,     0,   447,   448,     0,   449,     0,
       0,   450,     0,     0,   451,     0,     0,     0,     0,   453,
       0,     0,     0,   455,     0,   456,   457,   458,   459,   460,
     461,     0,     0,   462,   463,   464,   465,     0,   466,   467,
       0,   468,     0,   469,   470,   471,   472,     0,     0,   473,
     474,     0,   475,   476,   477,   478,     0,     0,     0,     0,
       0,   479,   480,   481,     0,     0,     0,     0,   483,   484,
     485,     0,   486,   487,     0,   488,   489,     0,     0,     0,
       0,     0,   492,     0,     0,   493,     0,     0,     0,   495,
     496,   497,     0,     0,     0,     0,     0,     0,   498,     0,
       0,   499,     0,     0,     0,   500,   501,   502,   503,   504,
     505,   506,     0,     0,  -327,     0,     0,     0,   507,     0,
       0,   509,     0,   511,     0,   142,   512,   143,   144,   145,
     146,   147,   148,     0,     0,   149,     0,     0,     0,   150,
       0,     0,     0,     0,   152,   153,   154,   155,   156,   157,
     158,     0,     0,  -372,     0,     0,     0,   161,     0,     0,
       0,   162,     0,     0,   163,   164,   165,     0,   166,     0,
       0,     0,     0,     0,   169,  4147,     0,   170,   171,     0,
     172,     0,     0,     0,     0,     0,   176,   177,   178,   179,
    4148,   181,   182,     0,   183,   184,     0,     0,     0,     0,
       0,     0,   190,     0,   192,     0,   194,   195,   196,   197,
       0,   198,   199,     0,   200,   201,   202,     0,   204,     0,
     205,     0,     0,   206,     0,     0,   207,     0,   208,     0,
       0,   209,     0,   210,     0,     0,     0,   211,   212,   213,
       0,     0,   214,     0,     0,     0,     0,   215,     0,     0,
       0,     0,     0,   217,     0,   218,     0,     0,     0,   219,
       0,   220,   221,   222,   223,   224,     0,     0,     0,     0,
       0,     0,   226,   227,   228,     0,     0,     0,   229,     0,
       0,   231,     0,   232,   233,   234,     0,     0,   235,   236,
       0,   237,   238,   239,   240,   241,     0,     0,     0,     0,
     244,   245,   246,   247,     0,     0,   248,   249,  4149,   250,
     251,   252,     0,     0,     0,     0,     0,     0,   254,     0,
     255,     0,   256,     0,   257,   258,   259,   260,   261,     0,
     263,     0,   264,     0,     0,     0,     0,   266,   267,     0,
       0,     0,     0,     0,     0,   270,     0,     0,     0,   271,
     272,   273,   274,   275,  4150,     0,   276,   277,   278,     0,
     279,     0,   280,     0,     0,     0,     0,   281,     0,     0,
       0,     0,   283,     0,   284,   285,     0,   286,   287,  4151,
       0,     0,   288,     0,     0,     0,   290,   291,     0,     0,
     292,  4152,     0,   293,   294,     0,     0,     0,     0,     0,
     295,   296,     0,   297,     0,   298,     0,   299,   300,     0,
       0,     0,     0,  -327,     0,     0,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,     0,   317,   318,   319,   320,     0,   321,   322,
     323,   324,     0,   325,   326,     0,     0,     0,     0,   327,
     328,   329,   330,   331,   332,     0,     0,   333,   334,     0,
     335,     0,   336,     0,   337,   338,   339,   340,   341,   342,
     343,   344,   345,     0,     0,   346,   347,     0,     0,   348,
     349,   350,   351,     0,     0,     0,     0,   353,     0,     0,
       0,   354,     0,   355,   356,   357,     0,   358,   359,   360,
    4153,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   365,   366,     0,     0,     0,     0,   368,
       0,   369,   370,   371,   372,   373,   374,   375,   376,   377,
       0,     0,     0,     0,   380,   381,     0,   382,     0,   383,
     384,   385,   386,   387,     0,   388,   389,   390,     0,     0,
     391,     0,     0,     0,   392,   393,   394,   395,   396,     0,
       0,   397,   398,   399,   400,   401,     0,   402,     0,     0,
     404,     0,   406,  -327,     0,   407,     0,     0,     0,   409,
       0,     0,   411,   412,     0,   413,  4154,   414,     0,     0,
     415,     0,   417,   418,   419,   420,   421,   422,   423,     0,
     425,   426,     0,   427,     0,     0,     0,     0,   429,   430,
     431,     0,     0,     0,     0,   433,     0,     0,     0,     0,
       0,     0,   436,     0,     0,   439,   440,     0,   441,     0,
     443,     0,   445,   446,     0,     0,     0,     0,     0,     0,
     447,   448,     0,   449,     0,     0,   450,     0,     0,   451,
       0,     0,     0,     0,   453,     0,     0,     0,   455,     0,
     456,   457,   458,   459,   460,   461,     0,     0,   462,   463,
     464,   465,     0,   466,   467,     0,   468,     0,   469,   470,
     471,   472,     0,     0,   473,   474,     0,   475,   476,   477,
     478,     0,     0,     0,     0,     0,   479,   480,   481,     0,
       0,     0,     0,   483,   484,   485,     0,   486,   487,     0,
     488,   489,     0,     0,     0,     0,     0,   492,     0,     0,
    4532,     0,     0,     0,   495,   496,   497,     0,     0,     0,
       0,     0,     0,   498,     0,     0,   499,     0,     0,     0,
     500,   501,   502,   503,   504,   505,   506,     0,     0,  -327,
       0,     0,     0,   507,     0,     0,   509,     0,   511,     0,
     142,   512,   143,   144,   145,   146,   147,   148,     0,     0,
     149,     0,     0,     0,   150,     0,     0,     0,     0,   152,
     153,   154,   155,   156,   157,   158,     0,     0,     0,     0,
       0,     0,   161,     0,     0,     0,   162,     0,     0,   163,
     164,   165,     0,   166,     0,     0,     0,     0,     0,   169,
       0,     0,   170,   171,     0,   172,     0,     0,     0,     0,
       0,   176,   177,   178,   179,     0,   181,   182,     0,   183,
     184,     0,     0,     0,     0,     0,     0,   190,     0,   192,
       0,   194,   195,   196,   197,     0,   198,   199,     0,   200,
     201,   202,     0,   204,     0,   205,     0,     0,   206,     0,
       0,   207,     0,   208,     0,     0,   209,     0,   210,     0,
       0,     0,   211,   212,   213,     0,     0,   214,     0,     0,
       0,     0,   215,     0,     0,     0,     0,     0,   217,     0,
     218,     0,     0,     0,   219,     0,   220,   221,   222,   223,
     224,     0,     0,     0,     0,     0,     0,   226,   227,   228,
       0,     0,     0,   229,     0,     0,   231,     0,   232,   233,
     234,     0,     0,   235,   236,     0,   237,   238,   239,   240,
     241,     0,     0,     0,     0,   244,   245,   246,   247,     0,
       0,   248,   249,     0,   250,   251,   252,     0,     0,     0,
       0,     0,     0,   254,     0,   255,     0,   256,     0,   257,
     258,   259,   260,   261,     0,   263,     0,   264,     0,     0,
       0,     0,   266,   267,     0,     0,     0,     0,     0,     0,
     270,     0,     0,     0,   271,   272,   273,   274,   275,     0,
       0,   276,   277,   278,     0,   279,     0,   280,     0,     0,
       0,     0,   281,     0,     0,     0,     0,   283,     0,   284,
     285,     0,   286,   287,     0,     0,     0,   288,     0,     0,
       0,   290,   291,     0,     0,   292,     0,     0,   293,   294,
       0,     0,     0,     0,     0,   295,   296,     0,   297,     0,
     298,     0,   299,   300,     0,     0,     0,     0,     0,     0,
       0,   301,   302,   303,   304,   305,   306,   307,   308,   309,
     310,   311,   312,   313,   314,   315,   316,     0,   317,   318,
     319,   320,     0,   321,   322,   323,   324,     0,   325,   326,
       0,     0,     0,     0,   327,   328,   329,   330,   331,   332,
       0,     0,   333,   334,     0,   335,     0,   336,     0,   337,
     338,   339,   340,   341,   342,   343,   344,   345,     0,     0,
     346,   347,     0,     0,   348,   349,   350,   351,     0,     0,
       0,     0,   353,     0,     0,     0,   354,     0,   355,   356,
     357,     0,   358,   359,   360,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   365,   366,
       0,     0,     0,     0,   368,     0,   369,   370,   371,   372,
     373,   374,   375,   376,   377,     0,     0,     0,     0,   380,
     381,     0,   382,     0,   383,   384,   385,   386,   387,     0,
     388,   389,   390,     0,     0,   391,     0,     0,     0,   392,
     393,   394,   395,   396,     0,     0,   397,   398,   399,   400,
     401,     0,   402,     0,     0,   404,     0,   406,     0,     0,
     407,     0,     0,     0,   409,     0,     0,   411,   412,     0,
     413,     0,   414,     0,     0,   415,     0,   417,   418,   419,
     420,   421,   422,   423,     0,   425,   426,     0,   427,     0,
       0,     0,     0,   429,   430,   431,     0,     0,     0,     0,
     433,     0,     0,     0,     0,     0,     0,   436,     0,     0,
     439,   440,     0,   441,     0,   443,     0,   445,   446,     0,
       0,     0,     0,     0,     0,   447,   448,     0,   449,     0,
       0,   450,     0,     0,   451,     0,     0,     0,     0,   453,
       0,     0,     0,   455,     0,   456,   457,   458,   459,   460,
     461,     0,     0,   462,   463,   464,   465,     0,   466,   467,
       0,   468,     0,   469,   470,   471,   472,     0,     0,   473,
     474,     0,   475,   476,   477,   478,     0,     0,     0,     0,
       0,   479,   480,   481,     0,     0,     0,     0,   483,   484,
     485,     0,   486,   487,     0,   488,   489,     0,     0,     0,
       0,     0,   492,     0,     0,   493,     0,     0,     0,   495,
     496,   497,     0,     0,     0,     0,     0,     0,   498,     0,
       0,   499,     0,     0,     0,   500,   501,   502,   503,   504,
     505,   506,     0,     0,     0,     0,     0,     0,   507,     0,
       0,   509,     0,   511,     0,     0,   512
};

static const yytype_int16 yycheck[] =
{
       6,   669,  1040,   575,   597,  1219,   620,  1219,   926,  1187,
    1317,    20,  1041,    19,  1945,  1946,  1145,    23,   596,   597,
    1632,    30,   525,  1597,  2115,   128,  2115,    33,    37,   639,
    1117,  1780,   639,  1363,    40,  1465,     6,    43,   994,  1465,
     969,  1445,    48,   736,  1595,  1317,  2535,  1163,  2435,    55,
    1628,  1629,   946,   947,  2218,  2397,  2546,  2668,   542,   543,
     544,  2607,   546,   957,   548,   994,  2230,   551,   689,   553,
     677,  1284,  1250,  1251,  2564,  2565,  1254,  1255,  1256,  1257,
    3032,  1259,  1260,  1261,  1262,  1263,  1264,  1265,  1266,  1242,
    2876,     4,  3351,    99,   834,   540,  1249,  2789,  3078,  2941,
    1371,  2359,  1344,   832,  2321,  1154,   967,   559,   559,   600,
    2113,  1013,   603,  3083,    23,  2457,  1856,   123,  1045,   125,
    2115,   127,   128,   129,  1476,  1045,  1930,   134,  2231,   665,
     666,  2573,  3548,  2500,   995,   803,  2113,  3438,   590,   590,
    2719,  2720,  3620,  2575,  1496,  2185,  2725,  2579,  2727,  3147,
    2505,  2508,  1504,  1505,  3033,   125,  3233,   127,  2590,    13,
    2517,   901,    13,  2950,  2185,    17,    18,  3163,   118,    18,
    2602,   792,   793,   794,  1076,   678,   679,   680,    26,     9,
      21,  1565,  2185,   804,  2674,  2675,    53,  1575,    75,    20,
      99,    36,    49,    20,    22,  2564,  2565,  2172,    83,    29,
      22,    20,   132,    62,   116,  2722,    36,    32,  2185,    83,
     996,   132,    17,    18,    36,    20,  3000,  1944,    17,    18,
      13,   673,    17,    18,   169,  3171,   129,  3011,    50,  2683,
      22,  1619,   162,    61,    62,   182,    17,    18,   225,    61,
      62,   162,   136,    72,    36,   277,  1035,  1036,    18,    66,
     386,   380,  3480,    13,    17,    18,  2315,    91,    50,   202,
     195,   276,    34,   159,   217,   374,   376,  4151,  4152,    61,
      62,    17,    18,    70,   170,   136,   156,   709,   710,  3393,
      54,   404,   166,   235,    36,   132,  1075,    73,   279,   239,
      58,    65,   293,   132,   257,   331,   137,   375,   431,   456,
     235,    20,    17,    18,  4381,  2674,  2675,   137,    84,   465,
      38,    89,   436,   162,   485,   162,   235,   313,   199,  3735,
    3736,    17,    18,  3739,    20,   403,   260,    21,    60,    38,
      72,  3660,    17,    18,    12,   162,   199,   145,  2705,   166,
    2707,   407,  3758,   257,   156,   371,   231,   166,   233,  3765,
     563,   783,   836,   277,   386,   197,    24,  3616,   563,  2096,
     534,    11,  1575,  4392,   528,   156,    13,   134,    17,    18,
     595,   364,    65,   485,    90,   294,   431,   262,   830,   563,
      17,    18,  2051,   199,    36,   246,   218,   250,   291,    17,
      18,    17,    18,   173,   242,    22,   112,   452,   562,    17,
      18,    17,    18,  4251,  2201,   647,  1619,   173,   197,    36,
      62,   843,   654,   630,   162,   239,   197,  2087,    17,    18,
    2869,   414,   202,    50,   653,  2105,  3904,   530,    75,   654,
     426,   263,   661,   488,    61,    62,   202,   253,   655,   263,
     653,   258,   616,   137,   286,   511,   119,   166,   653,   122,
     182,   477,   453,   199,   186,   133,   559,    48,    17,    18,
    1153,   564,   386,  1035,  1036,   197,   590,   370,   431,   274,
      68,    17,    18,   321,  1167,   418,  4505,  2482,   162,   360,
     427,   253,   653,   474,   199,   563,  3815,   590,   384,    17,
      18,  1520,  2568,   221,   222,    21,   987,   630,   655,   622,
      17,    18,   454,   196,   276,   661,   174,   503,   427,   283,
      17,    18,   221,   222,    17,    18,   294,   431,    53,   655,
    2887,  2888,   330,   386,   530,   561,   532,   294,   462,   277,
     369,  3947,   661,   385,  2977,  1038,   388,  4385,   195,  3868,
    3956,   653,   160,   549,  1438,   655,   655,   534,   563,    17,
      18,  1280,   588,   559,   560,  3342,   166,   510,   564,  3346,
     566,   313,  1966,   595,  3980,  2568,  4643,    17,    18,  3985,
     673,  3685,  2309,   579,  3697,   294,   563,  1245,   235,  3008,
     385,    17,    18,   388,   590,  2972,   385,  3888,  3078,   388,
     596,  2568,   426,   277,   461,  3854,  1336,   329,   366,  3291,
     606,   387,    65,  1532,   385,   518,   166,   388,  3392,  1470,
     494,   137,  1473,   628,   557,  1047,  1477,  1830,  1479,   625,
    3404,    87,   385,  1930,  1317,   388,   467,   218,   629,   166,
    1808,  2626,  1253,   639,   431,   641,  3420,  3421,  1565,   385,
    3130,  1819,   388,  2683,  1822,  1565,  1507,  1508,   654,  1270,
    3434,  4535,  4536,   659,   567,   661,  2453,  3655,  1930,   665,
     666,  3353,  2683,  2514,   670,   671,   562,   673,   440,  1409,
     385,   677,   607,   388,  2026,    17,    18,  3131,   684,   624,
    2683,    17,    18,   586,   654,  1130,  1131,   600,   638,   385,
     603,  1618,   388,  1433,   607,   427,   166,  3925,  1618,  2087,
     385,  2676,  1604,   388,  4005,   534,  2683,   601,   655,   621,
     503,  1156,   431,    17,    18,  4016,  1502,    17,    18,  1164,
      26,  1166,   596,   416,   554,  2113,   543,   830,   831,   659,
     736,  2790,  2459,  1178,  1179,  1180,   385,  1344,   659,   388,
     601,  1186,  3584,   503,   574,   630,  4047,   627,   385,   574,
     659,   388,   582,  1802,  1290,   574,   615,   385,  3304,   385,
     388,  3130,   388,   620,  1553,   593,   653,   385,   418,   385,
     388,   593,   388,   630,  3770,    17,    18,   608,   608,  3146,
    1909,   630,  2166,   576,  2172,  2522,   385,   639,   655,   388,
    3736,   797,   534,   799,    17,    18,   618,  2185,  3875,   653,
    1410,   593,   653,  1410,   574,   646,   658,   655,   653,   608,
     659,   587,   659,    17,    18,   627,  3695,  1308,   824,   825,
     826,   827,   828,   829,   830,   831,   385,   833,   834,   388,
    1366,   653,   659,   839,   639,   563,   627,  4315,  2507,   385,
     639,   630,   388,   946,   639,   948,  1575,  1383,   951,   952,
     655,  3300,  4700,  2404,   563,   825,   655,   385,   639,   829,
     388,  3648,  3649,   833,  1474,   968,  4195,  1474,   385,    75,
     876,   388,  3870,   654,  2087,   525,   639,  2547,   385,  2810,
     628,   388,   385,   889,   494,   388,  2566,   478,    17,    18,
    1619,   654,   655,   639,   567,   901,   902,   570,   147,  1390,
     906,    17,    18,   596,  4233,   503,  2911,  2704,  2520,   655,
    3297,   659,    17,    18,  2651,  3699,   635,   385,   182,  2656,
     388,  2997,  2853,   655,   639,  3414,   461,  2664,  2665,   579,
      17,    18,  4083,  2670,   494,   385,   242,  3380,   388,   654,
     946,   467,   948,   639,   628,   951,   952,    17,    18,   385,
     607,  1454,   388,  4076,   639,   111,   151,   494,  3537,  2172,
    3389,   166,   968,  1535,  1536,  1537,   593,  3546,    53,  3311,
     655,   621,  2185,    17,    18,   659,   439,  3068,   202,  3068,
     889,  3336,   895,  3350,  4400,  3342,  4402,   614,   615,  3346,
     639,  1569,   197,   902,  2997,    17,    18,   906,   182,    17,
      18,   325,   639,    17,    18,   654,   655,  1013,   838,   276,
     401,   639,  3418,   639,   480,   321,  2590,   654,   655,  1626,
    2997,   639,  3539,   639,   494,  4503,  3468,   655,   654,   655,
    1037,  4332,  1725,    13,   313,  1041,  3992,  3469,   654,   655,
     639,    17,    18,   385,  4345,   563,   388,   370,   162,   385,
       9,   661,   388,    17,    18,   654,   655,   376,  1952,  1065,
    2490,   367,  2492,  2493,    44,  2021,  2492,  2493,  4098,  4370,
    1076,  3174,   130,  3068,   987,  2879,   989,  2255,  1972,   294,
     639,   385,   185,   150,   388,   385,  2826,   671,   388,    17,
      18,  3131,  2021,   639,   343,   654,  1836,  2948,  2949,   152,
    2056,   661,   376,  4073,  1110,  1111,  1112,  1113,   654,   655,
    3131,   639,  2883,  2884,  2885,    45,  2203,   200,    98,   366,
    3337,   235,   639,   103,   661,   485,   654,  2056,  3131,  1232,
      17,    18,   639,   378,  2376,   653,   639,   654,   655,   378,
      13,  3720,   485,   385,  3723,  2416,   388,  1153,   655,  2501,
     367,  2012,   655,  1893,  3131,  2654,  1065,  4137,    41,  2547,
     563,  1167,   385,   427,  2025,   388,  1269,  2028,  2029,  1621,
    1621,   639,   633,   283,  3753,  3754,  3755,  1917,  1918,  2332,
    2568,   385,  3761,     9,   388,   376,   231,   655,   233,   639,
    3769,   661,  2941,   251,   418,  4151,  4152,  3883,  4457,   446,
    1821,  3718,  3719,   639,  1113,   655,    32,    12,  3725,    83,
     366,  3728,  3729,  1219,   420,  1318,   431,   376,   244,   655,
    2122,  2435,  2338,  2339,  3065,   218,  1232,   253,  3745,    17,
      18,   190,   538,    73,  2412,    17,    18,  1930,  4451,  2166,
    4453,  4271,  3759,   427,   828,  4396,  2166,    60,  3765,  3766,
    3767,  3768,  3093,   376,  1826,   210,   385,   660,   368,   388,
     363,   364,   653,  1269,    17,    18,   369,   376,  1274,   385,
     263,  1374,   388,   146,   253,   255,   353,  3014,   277,  3016,
     385,   366,  2331,   388,  1290,   584,  3023,   185,  2676,   494,
     485,  2842,  2341,   653,   273,  2683,   239,   639,   385,   376,
    3037,   388,  1838,   639,  2518,  3711,  2518,  3044,  3045,   608,
     653,  1317,  1318,   655,   164,   385,   399,   623,   388,   655,
    3057,  3058,  3059,   646,    17,    18,  3063,  3064,   283,   653,
    1336,   171,  1904,   557,  2547,   639,   655,   390,  1344,   639,
     454,   385,   606,  1349,   388,  1351,   108,   553,  1354,   505,
     330,   655,  4308,  4309,   654,  1976,  1847,   231,  2087,   233,
    1366,   628,  3099,   385,  3528,   391,   388,   385,  1374,   182,
     388,   385,   578,   186,   388,   433,   461,  1383,  1384,    17,
      18,   655,  4362,  4363,   197,    17,    18,   386,   262,   213,
     635,   655,   242,    17,    18,  1308,   635,   639,  4240,   648,
     649,   650,   651,  1409,  1410,   133,   623,  1413,   493,   385,
      17,    18,   388,   655,   394,  1421,   639,   199,  1424,   502,
     635,   385,   606,   353,   388,    83,   493,  1433,    17,    18,
      17,    18,   655,  3007,  3008,   639,   260,   653,  1444,  1445,
      17,    18,  1355,  2172,  3702,  1354,    17,    18,   129,  1455,
    1456,  1457,  1458,  1459,  1460,  4399,  2185,   385,   653,  1465,
     388,  4417,   657,  2676,   655,  1471,  1472,  4447,  1474,  1572,
    2683,   369,  1478,  4259,   147,  1384,  4432,  1390,   581,  1931,
    1931,   286,   540,  4094,  4095,  1455,  1456,  1457,   485,  1459,
      66,   485,  3229,  1499,   597,   479,   655,    26,   385,  2929,
    4192,   388,  1472,    17,    18,   288,   105,   400,  1478,   557,
     639,    17,    18,   235,  3013,  3391,   329,   367,  1621,  3395,
    3396,  3908,   485,   639,   252,  4477,   655,  4786,    17,    18,
     407,   608,   655,   513,   639,   490,  3307,  1450,   403,   655,
    3039,  3040,   190,  4499,  2673,   659,   655,   387,  1554,  1458,
     655,  1460,   639,  4099,   485,   448,  4242,     0,  4244,  2062,
    3401,  4050,   386,    13,  1477,   348,  1572,  4523,   655,   639,
     550,  2181,  2879,   231,  2181,   233,   501,    17,    18,  4535,
    4536,  1587,    17,    18,  2478,   655,  1592,  1593,    17,    18,
    1499,  2833,  2834,  2835,  3435,   639,  4462,   385,  1604,  4465,
     388,    17,    18,   385,   262,  3446,   388,  2879,  3449,  2997,
     291,   655,    17,    18,   427,  1621,   133,   639,   266,  2706,
    1626,   639,    17,    18,  3803,   639,   243,  2957,   654,  1635,
      13,  1637,   385,   655,   511,   388,   654,  3801,    17,    18,
     814,   655,   242,   260,   243,  1554,   529,  4137,  4604,   134,
    2864,   534,  2864,  2806,   291,   272,   653,   379,  4614,   653,
     657,   260,  2863,   639,   547,  1578,   199,    17,    18,   552,
     343,    17,    18,   272,   599,   639,   162,    13,  1587,   655,
      17,    18,   258,   581,  1593,    17,    18,    42,   538,   370,
     653,   655,   385,  4080,    13,   388,   146,   580,   563,   597,
    4644,  4645,  4658,  3539,  4660,   647,  2446,  4049,    17,    18,
     584,   639,   654,   242,  2335,   485,   473,   642,   366,  1725,
    1726,    83,   653,   493,   553,  3276,    13,   655,   557,  4685,
    2859,    17,    18,   370,   608,   252,  1839,  4693,   223,  4695,
     914,  4697,   608,  3131,   277,  2639,    81,   385,    13,   418,
     388,   534,   639,   385,   353,  4711,   388,  4623,  2959,  4715,
     445,   385,   655,   146,   388,   363,   364,   367,   655,  2376,
     244,    17,    18,   623,  4730,  4731,    17,    18,   385,   253,
    1786,   388,  2227,   138,    17,    18,   362,  2232,   654,   655,
    4746,  4747,   321,    17,    18,  4751,   385,   554,   385,   388,
    2245,   388,   413,   560,  3983,   655,  3682,  3986,   385,   294,
     146,   388,   631,   632,   385,  3389,   278,   388,  2547,   281,
      17,    18,  1828,  1829,   115,    17,    18,   146,  1931,  3043,
    1836,  3043,  1838,  1839,  2279,  3584,   655,  2447,    17,    18,
    2447,   526,   612,   613,   630,  1851,  1949,   604,   166,   553,
    1856,   639,   469,   557,    26,  1861,   525,   639,  1864,   146,
     166,   196,  1059,  1060,   621,  1871,  1872,   655,  1874,   655,
     469,   385,  4362,  4363,   388,    17,    18,    17,    18,   385,
     242,   146,   388,   653,  3863,  1337,   639,  1893,  1340,  3725,
    1896,  1343,  3728,  3729,  1900,  3469,   385,    17,    18,   388,
     604,   654,   608,  2348,   239,   586,  2484,  1104,  3887,  3745,
     579,  1917,  1918,  1919,  1920,    17,    18,   391,  3131,   630,
    1829,   653,   539,   213,  1930,  1931,  3330,    40,   263,   661,
    1936,  1937,  1938,   224,  1847,    48,   223,   173,   538,   133,
     539,    17,    18,  1949,   655,   385,   639,  2676,   388,   655,
     385,   527,   621,   388,  2683,   661,   385,  4447,  2876,   388,
    1966,   654,  1871,  1872,   661,  1874,   428,   543,  2924,   385,
      17,    18,   388,   646,   647,   648,   649,   650,   651,   532,
     385,  1987,   143,   388,    17,    18,   485,  1896,     6,    18,
     385,  1900,   164,   388,  3224,  2924,   549,   158,  3228,   361,
     234,   639,  1915,    17,    18,   367,   385,   639,  3338,   388,
    1919,  1920,    17,    18,   213,   639,   654,    17,    18,    17,
      18,  2027,   654,   623,    17,    18,   454,  1936,  1937,  1938,
     654,   239,   639,   557,  3150,   385,   560,  2043,   388,   385,
     615,    59,   388,   618,  2050,   608,   239,   654,   385,  3786,
     639,   388,   639,   385,  2060,  2061,   388,  2063,  2064,   658,
     636,  2955,   639,  3179,  3180,   654,   239,   654,   639,  1982,
     242,  2068,  2069,   141,  2935,   437,   385,   654,   234,   388,
    2183,   416,   213,   654,  3200,   380,  2189,  3301,  2085,  3218,
    2060,  2061,   655,    18,    49,  3832,    17,    18,   661,   385,
     199,   392,   388,   654,   655,  2102,  2103,   250,    17,    18,
    3688,  3689,   403,   612,   613,  2218,  2122,   613,  2027,   410,
     297,  2861,   299,   300,  1005,   639,   493,  2230,   654,   655,
    1011,  1012,   150,   639,   504,  3349,   504,  3349,   315,   385,
     654,  2050,   388,   294,   385,    17,    18,   388,   654,   321,
     639,  1872,   385,  1874,   653,   388,   149,   654,   655,  2072,
     654,   385,   136,   557,   388,   654,    61,    62,  2081,  2082,
    2167,  2168,  2169,  2170,   560,  2181,   538,  2183,    73,  2092,
    2093,  2094,  2095,  2189,  2097,  2098,  2879,   566,   385,  2195,
     659,   388,  2198,   385,   661,   367,   388,    17,    18,   639,
      20,   602,    17,    18,   639,    20,   385,   129,   211,   388,
     639,    18,  2218,   382,   654,  1936,  1937,  1938,   509,   654,
     653,  2324,   147,   639,  2230,   654,  2833,  2834,  2835,   591,
    4188,  4189,   519,   520,   639,   522,    33,   524,   654,   196,
    2812,   654,   655,   385,   639,   385,   388,   557,   388,   654,
     525,  2354,   539,    26,   574,    12,   654,   655,     6,   654,
     639,   623,  1123,  1124,  1125,   385,   443,   444,   388,   653,
     192,   653,   246,  2883,  2884,  2885,  2883,  2884,  2885,  1140,
    4211,   653,  3411,   385,   129,   661,   388,   653,    85,   639,
     199,   654,   655,   639,  4031,  4032,  4033,   749,   655,   221,
     653,   129,   639,   563,   654,    13,   653,   639,   654,   385,
      83,  1172,   388,   604,  1175,   318,   319,   654,  2324,   771,
     323,   324,   654,   654,   655,   654,   655,   199,   299,   300,
     639,   653,   784,   785,   136,  1196,  1197,    26,   385,  1200,
     147,   388,   653,  2349,   315,   654,   364,   192,  2354,   654,
     655,    81,   385,   639,   653,   388,  2801,   653,   115,  1220,
    1221,  3791,   178,   160,   192,  3791,   538,   136,   654,   291,
    2376,   385,  3488,   653,   388,   653,   133,  3333,  4336,   653,
     385,   653,  4340,   388,   653,   385,   653,   385,   388,   653,
     388,   164,   385,   639,    83,   388,   654,   655,   639,   653,
    3294,  3615,  3131,  3615,  3333,  2411,   639,   608,   654,   653,
     183,   653,   430,   654,   432,   639,   173,   473,   343,   538,
      83,   654,   613,   614,   566,   616,   653,   618,  3515,  2435,
     654,  2534,  2535,  2439,    17,    18,   654,   655,   146,   653,
    2446,  2447,   639,  3021,   246,   202,   291,   639,   370,   654,
     655,   623,  4543,  4542,  2460,   653,  2462,   654,   654,   655,
     639,   417,   654,   291,   385,   653,   196,   388,   653,   242,
     653,    83,   443,   444,   376,   654,   385,   246,  2484,   388,
     454,    36,   653,   655,  2490,    97,  2492,  2493,  4062,  4063,
     653,  4240,   383,  3707,   183,  3707,   653,   639,  3001,   639,
     653,   164,   654,   655,   654,   655,  3009,    62,   653,   239,
     553,   485,  2518,   385,   654,   223,   388,   654,   655,   639,
     653,  2527,   654,   655,  2530,   370,   653,  3556,  2534,  2535,
     287,  3015,   653,   263,   654,   653,   343,   639,  3941,  3942,
     654,   655,   370,  3027,   653,  3029,  3030,  2460,   321,  4507,
    4508,  3954,   654,   242,    61,    62,    34,  3041,  3961,   653,
    2530,   654,   655,   639,   119,   385,    27,   122,   388,   653,
     385,   496,   497,   388,   653,   130,   653,  2574,   654,   242,
    2577,  2578,   653,  2580,  3987,  3988,  2583,  2584,   361,   115,
    2587,   653,   639,   148,   367,  2592,   654,   655,  4210,   653,
    2597,  2598,  2599,  2600,  2601,    62,   639,   654,  2605,  2606,
    3917,  2608,    73,  2619,   654,   655,   413,  2614,  2615,  2616,
    2617,   654,    83,  2620,  2621,   639,  2623,   601,  2634,   654,
     655,   653,   321,   653,   639,   654,   655,   653,   435,   639,
     654,   639,  2648,   654,   655,   566,   639,   173,   574,   654,
     654,   655,   454,   265,   654,   376,   654,   653,  3965,   654,
     655,   418,   119,   653,   586,   122,   654,   655,   653,   147,
     400,   132,   361,   130,   471,   653,   202,   653,   367,   653,
     655,   654,   655,   485,  2681,   454,   416,   127,   653,   496,
     497,   148,   653,  2699,  2700,  2701,   251,  3307,   361,   653,
    3307,  3789,  3790,   653,   367,   147,   653,  4444,   654,   655,
     654,   655,   654,   655,   654,   655,   485,   653,   639,   644,
     645,   646,   647,   648,   649,   650,   651,   654,   655,   341,
     639,   235,   654,   530,   491,   653,   193,   653,   129,  2652,
    2653,   586,  2655,  3188,  2657,  2658,  2659,  2660,  2661,  2662,
    2663,  3329,   653,  2666,   366,   653,  2669,   653,   586,  2672,
     654,   655,   654,   655,   653,   538,   653,   639,   525,   653,
     231,   653,   233,   653,   437,   253,   653,  4708,   654,   655,
     653,  1642,   129,   654,   655,   132,   654,   655,   147,   229,
    2699,  2700,  2701,   653,   251,  3240,   653,   554,   276,   601,
     355,   192,   263,   654,   655,   654,   655,   654,   655,  3833,
    3834,   519,   520,   521,   522,   523,   524,   429,   653,   639,
    2826,   653,  2828,   105,   639,  3913,  2832,  2833,  2834,  2835,
     221,   539,   601,   654,   655,  2841,   653,   644,   645,   646,
     647,   648,   649,   650,   651,   192,    38,   156,   157,   538,
     623,   653,  1204,  1205,  2860,  2861,  4787,   653,  2864,   654,
     655,   653,  4040,   511,   621,   343,  1727,   654,   655,    51,
    1731,   654,   655,  2879,   221,   538,   654,  2883,  2884,  2885,
     654,   655,   655,   288,   653,   363,   364,   166,   654,   655,
    2896,    51,   418,   333,  1755,   352,   655,   337,   355,   383,
     291,   343,   363,   364,   344,   654,   655,   376,   369,   654,
     655,   190,    86,   525,    88,   376,   654,   655,  3313,  3314,
    3269,  3270,   199,  2929,   203,  3594,  3595,   376,   591,  3032,
     122,   479,  2841,  3417,   623,   595,   215,   129,   648,   493,
     504,   661,   661,    65,   291,   172,   501,  3525,   653,   129,
     277,   197,   132,  4082,    65,   416,   534,   553,   132,    81,
     623,   243,   440,   534,   511,  2971,  2972,   288,   163,   197,
      81,    93,    92,   655,   655,   377,   433,   549,   260,   370,
     154,   654,    93,  2896,   343,   425,   162,   266,   132,   268,
     272,   118,   655,   185,  3000,  4209,   660,  4209,  4086,  4087,
     192,  4089,  4090,  3012,  3010,  3011,   147,     6,   653,  3018,
     117,  3017,   192,     4,   484,   570,   295,   191,   496,   497,
     166,   167,   621,   370,   253,  3022,  3032,  3033,   489,   221,
     222,   557,  3038,  3042,   512,   655,   400,  3043,  3035,  3048,
      58,   221,   446,   483,   599,  3054,  3055,  3053,   178,   118,
      17,    18,   655,   579,   496,   497,   661,   203,   655,  3065,
     232,   232,  2971,    73,    13,   627,  3072,  3073,   654,   215,
     654,   353,  3078,   146,   196,    10,   655,   654,  3084,   201,
     661,   360,  3088,  4212,  3978,   196,  4115,  3093,   654,   654,
     201,   661,  4121,   115,  3666,   621,   653,   276,   661,   291,
      38,   376,   655,   164,   655,   288,  3019,  3020,   660,    51,
     256,   291,   253,   570,  3084,   288,   655,   239,   288,   288,
     288,   288,   268,  3129,   655,   166,   553,    20,   239,   653,
     230,   283,   655,   401,  3047,   596,   415,   496,   497,  3145,
     655,   263,   599,   574,  3053,   655,   574,   400,   197,   295,
     655,   173,   263,   166,   655,  4284,   123,   124,   125,   126,
     127,   655,   354,    73,   147,  3078,   644,   645,   646,   647,
     648,   649,   650,   651,   655,   253,   534,   369,   370,   254,
     202,   648,   129,   551,   122,   625,   187,   469,   197,   655,
     370,   129,   172,   534,   508,   586,   405,   142,   376,   655,
     404,   641,   343,   645,   646,   647,   648,   649,   650,   651,
     654,   357,   105,  3316,   655,   602,     7,   239,   634,   607,
     394,   655,   199,  3136,   654,   654,   648,   199,  3234,   654,
     654,   654,   595,   654,   654,  4364,  3242,   654,   647,   586,
     655,   653,  4456,   129,  4456,   192,   147,   185,   654,   494,
     563,   654,   563,   654,   192,   654,   654,   539,   655,   226,
     227,   228,   229,   654,   438,   287,   655,   651,   654,   162,
     253,   654,   654,   166,   221,   653,  3282,   653,   400,   653,
     655,   654,   563,   221,   222,  3857,   574,   646,   647,   648,
     649,   650,   651,  3871,   416,  3301,  3302,   628,   241,  3305,
     655,  3307,   195,   653,   197,   416,   192,   545,    12,   653,
    3316,  3414,    13,   211,   199,   655,  3322,   653,   661,   129,
     213,   653,   132,  3329,  3330,   655,   219,   655,   274,  3242,
     199,   654,   661,   176,   474,   221,   661,   661,   426,   655,
     600,  4259,   235,  3349,   291,   231,   493,   233,   655,   655,
     243,   197,    49,   291,    20,   496,   497,   250,  3364,   351,
     343,   129,   202,    57,   132,  3371,   333,   260,   335,   336,
     337,   563,  4401,    67,   525,   567,  3385,   344,   570,   272,
    4558,  3995,   192,   525,   277,   484,  3392,   129,    82,   581,
     132,   413,   514,   286,   586,  3401,   418,   589,  3404,    83,
      94,    95,    96,   514,   525,   291,   586,    91,  3414,   525,
     525,   221,  3418,   449,  3420,  3421,   354,   197,   385,   113,
     653,   388,  3335,   370,   192,  3528,   166,   365,  3434,  3435,
    4309,   369,   370,   166,   118,   166,   166,  4331,   166,   105,
    3446,   166,   343,  3449,   115,   166,   166,   166,   470,   166,
     192,  4044,   166,   221,   646,   647,  4350,   166,   425,   166,
     353,   166,  3371,   166,   166,   655,   166,  3473,   166,   491,
    3476,   129,   287,   166,   596,  3481,   166,   166,   160,   221,
     164,   291,   376,   376,   370,   596,   376,   129,   376,   608,
     654,   249,   654,   386,  4672,   129,   162,  3503,   661,   249,
     166,   654,  3415,   644,   645,   646,   647,   648,   649,   650,
     651,  3424,    20,   496,   497,   482,   483,   654,   661,    27,
     654,   654,  3528,   291,   655,   418,   654,   166,   654,  3632,
     201,   197,   554,     7,   192,   574,   654,   661,   560,   574,
    4569,  4570,   655,  4572,   661,   574,  4760,   213,  4760,   291,
     192,   655,   563,   219,   635,   239,   283,   579,   192,  4773,
     370,  4773,    89,   221,  4778,    73,  4778,  3476,   239,  4783,
     517,  4783,    49,   653,   653,    83,   469,   243,   166,   221,
    3493,   653,   604,   653,   250,   574,   105,   221,   166,   383,
     199,   199,   199,   250,   260,   496,   497,   199,   563,   621,
     493,   563,   370,   257,  3610,  4634,   272,  4636,  4637,  3615,
     431,   277,   655,   176,   370,   260,   287,   260,   389,   334,
     286,   653,   118,   118,   132,   563,  3632,    81,   370,   567,
     400,   400,   570,   291,   400,  4228,   320,   574,   332,   586,
     142,   261,   105,   581,  4523,   554,   539,   261,   586,   291,
     554,   589,   400,   142,   338,   349,   400,   291,   625,    49,
     574,   644,   645,   646,   647,   648,   649,   650,   651,   653,
    3676,   400,   639,   640,   641,   653,   402,   361,   400,   653,
     213,   563,   400,   382,   400,   661,   251,   353,   648,  3695,
     653,   251,   653,  3699,   431,   654,  4725,   205,  3801,   654,
     586,  3707,   595,   654,  4742,  3711,   654,  3713,   646,   647,
     376,   655,   370,  4381,   607,   608,  4288,   388,   654,   653,
     386,   661,   655,   231,   243,   233,   654,   654,   370,   654,
     383,   648,   653,   655,   235,   628,   370,   630,   376,   654,
     278,   260,   655,   644,   645,   646,   647,   648,   649,   650,
     651,   400,   418,   272,   654,   263,   661,   199,   654,  3672,
     601,   654,   655,   253,   431,   658,   659,    27,   166,    29,
    3873,   654,  3778,    14,   655,  3781,   586,   260,   260,  4658,
     243,  4660,  3788,  3789,  3790,  3791,   465,   481,   655,   653,
     400,   263,   263,   661,   376,  3801,   414,   260,    83,   470,
     376,    61,    62,   469,    64,    20,   654,   386,   655,   272,
     654,  4383,    49,    73,  4693,   653,   653,   487,   586,    83,
     491,   654,   630,    83,   654,   274,   467,   493,   181,   286,
     211,    91,   153,    97,   353,   270,   654,   654,   485,   655,
     213,   260,   260,   514,   586,   495,   655,   541,   376,   511,
     376,  4730,  4731,   654,   538,   363,   364,   376,   118,    57,
    3963,   369,   654,   104,   263,   559,   655,  3873,   376,    67,
     554,   653,   132,   539,   263,   135,   140,  3883,   655,   630,
    4458,   655,   654,   554,    82,    87,   653,  4781,   503,   238,
     353,   149,   654,   653,  3900,   136,    94,    95,    96,   653,
     653,   277,   654,    36,   164,   654,    36,  3913,   416,   150,
     370,   654,  3918,   376,    62,   113,   654,  3926,  3924,   251,
     654,   265,   654,   340,    18,   596,  3932,   426,   586,   595,
     654,   654,   173,   604,   630,   383,   177,   250,    49,   219,
     340,   654,   608,   655,   586,   653,   480,  4050,   189,   655,
     469,   661,   586,   608,   511,    20,   608,  3963,   132,   654,
     132,     6,   628,   655,   630,   653,   653,    12,   654,    14,
     211,   231,   655,   233,   654,  4643,  3889,   557,   653,   239,
     412,   489,    27,  3989,    29,   661,    36,   247,   654,   655,
     370,   655,   658,   659,   340,   180,   143,   563,   239,   563,
     540,   265,   262,   654,   563,   246,   469,   263,   557,   653,
     608,   612,   608,   653,    59,  3924,   317,   654,   653,    64,
     539,   123,   124,   125,   126,   127,   655,   653,   653,   618,
     654,   653,   618,  4039,   653,  4628,  4042,    15,    83,   601,
     132,   263,   263,    20,  4050,   286,    91,   369,   529,   630,
     653,  3964,   176,   474,   464,   654,   101,    63,   655,  4631,
     320,   654,   601,   383,   544,  4071,  4072,  4735,   653,   653,
     465,   250,   376,   118,   365,   161,   539,   341,   338,   653,
    4086,  4087,   613,  4089,  4090,   653,   627,   132,   596,  4417,
     135,    33,   662,   654,  4762,   370,   176,   565,   143,   363,
     364,   142,   366,   142,  4432,   150,   653,   164,   418,    75,
     197,   654,   197,   158,   627,   199,   653,    33,    65,   164,
     383,    65,   654,   397,   226,   227,   228,   229,   279,   654,
    4039,  4137,   655,   393,   332,   395,   653,   545,  4710,   439,
     654,   250,  4148,   403,   654,   160,   653,  4153,   659,   689,
     195,   349,   383,   383,   694,    49,    49,   159,    49,    49,
      49,   653,   653,  4072,   140,   429,   149,     5,   376,   376,
     160,  4499,   627,   234,   293,   659,  4182,  4183,   419,  4185,
     131,   286,    12,   662,   653,    49,   231,    49,   233,    49,
     155,   731,   601,   136,   239,   659,    55,   474,   439,   655,
     476,   654,   247,  4209,   654,   263,   447,   160,   748,   566,
     655,   216,  4784,   659,   455,   475,   655,   262,   232,   655,
     654,   654,  4219,  4220,  4137,   453,  4223,  4224,  4225,  4226,
      55,   333,    49,   335,   336,   337,  4242,   197,  4244,   197,
     236,   286,   344,   197,   485,   629,   132,   566,   235,   370,
     653,   493,   792,   793,   794,   795,  4158,   498,   499,   198,
    2361,   525,  4365,   655,   804,   463,  3786,  2671,  4274,  3507,
    2563,   531,   532,   533,  3898,   320,  4604,  1036,   538,  4253,
    4384,  4585,  3896,   481,  4586,  3900,  4614,  4070,  4762,  4723,
      48,  1056,   598,   338,   554,  4301,  1929,   342,   558,  2826,
     296,  1861,   298,   299,   300,   301,   302,   548,   304,   305,
     306,   307,   308,   309,   310,   311,   312,   577,   314,   315,
     316,   989,  3992,   425,  4732,  3992,  3992,  3992,  4325,  3992,
    3992,  3992,  3992,  3992,  3992,   595,  4601,  4410,   579,  4601,
    4536,   386,  4436,   541,  3992,  4435,  3992,  3992,   393,  4355,
     395,  1581,   892,  1100,  1830,  4079,  4257,  4685,   403,  4365,
     601,   559,   603,  4360,  4361,  4371,  3444,  4695,  2115,  4697,
    2633,  2855,  4369,  3609,  4477,  3282,  1371,  2860,  4355,  4460,
     482,   483,  3612,  4711,  4040,  4672,  4566,  4715,  4628,  3905,
    4228,   630,  1618,  3072,  2626,   655,  3357,  2634,  3676,  3075,
    3925,  4649,  4288,  3918,   449,  3171,  3736,  4113,  3770,  3974,
    4458,  4324,  3963,  3225,  2779,  4390,  3220,  2534,  4746,  4747,
    3228,    11,    11,  4751,  4507,  4340,  4508,  2191,  4327,  4336,
     475,  2697,  4185,  4121,  3392,  3068,  4442,  1069,  2633,  1515,
    1017,  4447,  3930,  2504,  2430,  4358,  4359,   443,   444,  1614,
    4456,  2122,  4442,  3694,  1919,  1593,  2841,  3277,  2317,  2404,
    2451,  4564,  3994,   619,  1943,   938,  3242,  2222,  4286,  2812,
    2226,  4477,  3340,  2519,  2513,  2316,  1167,  4065,  4247,  4580,
    3503,  4581,  3707,  2929,  1140,  1532,   531,   532,   533,  2342,
    3884,  3064,  4710,   538,  3873,  2195,  2456,  1354,  1040,  2398,
    1384,  2434,  3615,  3296,  1040,  3295,  3349,  4456,   609,   554,
    1040,  1040,  1635,   558,   685,   597,  2022,  2498,   597,  3713,
    2023,  1391,  1463,   625,  1850,  3280,  4670,  4484,  4705,  4576,
    4783,  4778,   577,  3965,  4447,  3329,  3301,   596,   640,   641,
    2481,  1421,  1082,  1783,   596,  3330,  2474,  2467,  1900,  2473,
     595,  1969,   830,  1411,   590,  4468,  4469,   918,  4564,  1346,
    4029,  2446,  1626,  4035,   591,   925,  2828,   627,    -1,    36,
    1036,   627,   627,    -1,  4580,  4581,    -1,  1036,  1036,  1119,
    1120,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1128,  1129,
    1130,  1131,  1132,  1133,  1134,  1135,  1136,  1137,  1138,  1139,
    4606,    -1,    69,    -1,    -1,    -1,    -1,  4613,  1148,  1149,
      -1,  1151,  1152,    -1,    -1,    -1,  1156,    -1,    -1,  1159,
    1160,  1161,  1162,    -1,  1164,  1165,  1166,    -1,    -1,    -1,
      -1,    -1,    -1,  1173,  1174,    -1,  1176,  1177,  1178,  1179,
    1180,    -1,    -1,  1183,  1184,  1185,  1186,  1187,  1188,  1189,
    1190,  1191,  1192,  1193,    -1,  1195,    -1,    -1,  1198,  1199,
      -1,    36,    -1,  1203,    -1,    -1,  4769,  1207,  1208,  1209,
      -1,    -1,   139,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1222,  1223,  1224,    -1,    -1,    -1,  4694,    -1,
      -1,  1231,    -1,  4699,    69,    -1,    -1,   164,  1238,  1239,
    1240,   168,  1242,    -1,    -1,    -1,    27,    -1,    29,  1249,
    1250,  1251,    -1,  1253,  1254,  1255,  1256,  1257,    -1,  1259,
    1260,  1261,  1262,  1263,  1264,  1265,  1266,    -1,    -1,  4735,
    1270,  1271,    -1,  4646,    -1,    -1,    -1,   204,    -1,    -1,
      61,    62,    -1,    64,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    73,    -1,  4760,    -1,  4762,    -1,   225,    -1,
      -1,    -1,    83,  4769,   139,    -1,    -1,  4773,    -1,    -1,
      91,    -1,  4778,   240,    -1,    -1,    -1,  4783,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   164,
      -1,    -1,    -1,   168,    -1,    -1,    -1,   118,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   132,    -1,    -1,   135,    -1,    -1,    -1,  1358,    -1,
      -1,   288,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   204,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   164,    -1,    -1,   313,    -1,    -1,    -1,
     225,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   694,    -1,   240,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1421,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1431,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     731,    -1,    -1,    -1,    -1,    -1,    -1,  1447,    -1,    -1,
     231,  1451,   233,   288,    -1,    -1,    -1,   748,   239,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   247,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   313,    -1,
      -1,   262,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     417,    -1,    -1,    -1,    -1,   276,    -1,    -1,    -1,   426,
      -1,    -1,    -1,    -1,   795,    -1,  1506,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   441,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   459,    -1,    -1,    -1,    -1,    -1,    -1,   320,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   338,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   503,    -1,    -1,   506,
      -1,    -1,   417,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   426,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   892,    -1,    -1,    -1,    -1,   441,   534,    -1,    -1,
      -1,    -1,   393,    -1,   395,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   403,    -1,   459,    -1,   553,    -1,    -1,   556,
     557,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1648,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   503,    -1,
      -1,   506,    -1,    -1,    -1,    -1,    -1,    -1,   605,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   475,    -1,    -1,    -1,    -1,   534,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   556,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     531,   532,   533,    -1,    -1,    -1,    -1,   538,    -1,    -1,
      -1,  1761,  1762,  1763,    -1,    -1,    -1,    -1,    -1,    -1,
     605,    -1,    -1,   554,    -1,    -1,  1776,   558,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1082,    -1,    -1,    -1,    -1,   577,    -1,    -1,    -1,
      -1,    -1,  1802,    -1,    -1,    -1,    -1,    -1,  1808,    -1,
      -1,  1811,    -1,  1813,   595,    -1,    -1,    -1,    -1,  1819,
      -1,  1821,  1822,    -1,    -1,    -1,    -1,    -1,  1119,  1120,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1128,  1129,    -1,
      -1,  1132,  1133,  1134,  1135,  1136,  1137,  1138,  1139,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1148,  1149,    -1,
    1151,  1152,    -1,    -1,    -1,    -1,    -1,    -1,  1159,  1160,
    1161,  1162,   653,    -1,  1165,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1173,  1174,    -1,  1176,  1177,    -1,    -1,    -1,
      -1,    -1,  1183,  1184,  1185,    -1,    -1,  1188,  1189,  1190,
    1191,  1192,  1193,    -1,  1195,    -1,    -1,  1198,  1199,    -1,
      -1,    -1,  1203,    -1,  1914,    -1,  1207,  1208,  1209,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1222,  1223,  1224,    -1,    -1,    -1,    -1,    -1,    -1,
    1231,    -1,    -1,    -1,    -1,    -1,    -1,  1238,  1239,  1240,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1967,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1976,    -1,    -1,    -1,
    1271,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,     6,    -1,    -1,    -1,
      -1,    -1,    12,    -1,    14,    -1,    16,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    27,    -1,    29,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1358,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    59,
      -1,    -1,    -1,    -1,    64,    65,    -1,    -1,    -1,    -1,
      -1,    71,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    83,    -1,  2115,    -1,    -1,    -1,    -1,
      -1,    91,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1421,   101,    -1,    -1,    -1,    -1,    -1,  2137,    -1,    -1,
    1431,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   118,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1447,    -1,    -1,    -1,
    1451,    -1,   132,    -1,    -1,   135,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   143,   144,    -1,    -1,    -1,    -1,    -1,
     150,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   158,    -1,
      -1,    -1,   162,    -1,   164,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2204,   175,    -1,    -1,  2208,    -1,
      -1,    -1,    -1,  2213,  2214,  1506,    -1,    -1,    -1,    -1,
      -1,    -1,  2222,    -1,  2224,   195,  2226,  2227,  2228,  2229,
      -1,    -1,  2232,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2242,    -1,  2244,  2245,    -1,  2247,  2248,  2249,
    2250,    -1,  2252,    -1,    -1,  2255,    -1,    -1,    -1,    -1,
      -1,   231,    -1,   233,  2264,    -1,    -1,   237,    -1,   239,
      -1,  2271,    -1,  2273,    -1,  2275,  2276,   247,  2278,  2279,
      -1,    -1,    -1,  2283,  2284,  2285,    -1,    -1,    -1,  2289,
    2290,  2291,   262,  2293,    -1,  2295,    -1,  2297,    -1,  2299,
      -1,  2301,    -1,    -1,    -1,    -1,  2306,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   286,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2325,    -1,    -1,    -1,    -1,
      -1,    -1,  2332,    -1,    -1,  2335,    27,    -1,    29,    -1,
      -1,  2341,    -1,    -1,  2344,    -1,    -1,    -1,  2348,    -1,
     320,    -1,    -1,    -1,    -1,    -1,    -1,  1648,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   338,    -1,
      61,    62,   342,    64,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    73,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    83,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      91,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   381,  2412,    -1,    -1,    -1,   386,    -1,    -1,    -1,
      -1,    -1,    -1,   393,    -1,   395,    -1,   118,    -1,    -1,
     400,    -1,    -1,   403,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   132,    -1,    -1,   135,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   434,    -1,    -1,    -1,    -1,    -1,
    1761,  1762,  1763,   164,    -1,    -1,    -1,    -1,   448,   449,
     450,   451,  2482,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   475,    -1,    -1,    -1,    -1,
      -1,  1802,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1811,    -1,  1813,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2533,    -1,    -1,    -1,    -1,    -1,    -1,
     231,    -1,   233,    -1,    -1,    -1,  2546,    -1,   239,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   247,    -1,    -1,    -1,
      -1,   531,   532,   533,  2564,  2565,    -1,    -1,   538,    -1,
      -1,   262,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   554,    -1,    -1,    -1,   558,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   577,    -1,    -1,
      -1,    -1,   582,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1914,    -1,   595,  2626,    -1,    -1,   320,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   338,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2674,  2675,  1967,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   659,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   393,    -1,   395,    -1,    -1,    -1,    -1,    -1,
    2710,    -1,   403,    -1,  2714,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2741,  2742,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2761,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2770,    -1,  2772,    -1,  2774,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   475,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2801,    -1,    -1,    -1,    -1,  2806,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2837,    -1,    -1,
     531,   532,   533,    -1,    -1,    -1,  2137,   538,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   554,    -1,    -1,    -1,   558,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   577,    -1,    -1,    14,
      -1,    16,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   595,    -1,    -1,    -1,    33,    -1,
      -1,  2911,    37,  2204,    -1,    -1,    -1,  2208,    -1,    -1,
      -1,    -1,  2213,  2214,    -1,    -1,    51,    52,    -1,    -1,
      -1,  2222,    -1,  2224,    59,  2226,    -1,  2228,  2229,    64,
      65,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2242,    -1,  2244,    -1,    -1,  2247,  2248,  2249,  2250,
      85,  2252,  2962,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2264,    -1,    -1,    -1,  2977,    -1,   104,
    2271,    -1,  2273,    -1,  2275,  2276,    -1,  2278,    -1,    -1,
      -1,    -1,  2283,  2284,  2285,    -1,    -1,    -1,  2289,  2290,
    2291,    -1,  2293,   128,  2295,    -1,  2297,    -1,  2299,    -1,
    2301,   136,   137,   138,    -1,  2306,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   149,   150,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2325,    -1,    -1,   162,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2341,    -1,   177,  2344,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3068,   194,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3081,  3082,    -1,   209,    -1,   211,    -1,    -1,    -1,
      -1,   216,    -1,    -1,    -1,   220,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   246,    -1,   248,    -1,    -1,    -1,    -1,    -1,    -1,
    3130,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   264,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3153,    -1,    -1,    -1,   282,    -1,    -1,
      -1,   286,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    27,
      -1,    29,    -1,    -1,    -1,  3185,  3186,    -1,  3188,    -1,
      -1,  2482,    -1,    -1,    -1,    -1,    -1,  3197,    -1,    -1,
      -1,    -1,  3202,    -1,    -1,  3205,    -1,  3207,  3208,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    64,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    83,    -1,    -1,    -1,    -1,
    3240,    -1,    -1,    91,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   381,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     118,  3271,    -1,   398,    -1,   400,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   132,    -1,    -1,   135,   413,    -1,
      -1,    -1,    -1,    -1,    -1,  3295,    -1,    -1,    -1,   424,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   164,    -1,    -1,    -1,
      -1,   446,    -1,    -1,   449,    -1,   451,    -1,    -1,   454,
      -1,    -1,   457,   458,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   468,    -1,    -1,   471,    -1,    -1,    -1,
      -1,  3351,    -1,    -1,   479,    -1,    -1,    -1,    -1,    -1,
     485,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   493,    -1,
      -1,    -1,    -1,   498,   499,   500,    -1,    -1,    -1,    -1,
    3380,    -1,    -1,   231,    -1,   233,    -1,    -1,    -1,    -1,
      -1,   239,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   247,
      -1,    -1,    -1,    -1,    -1,   530,    -1,    -1,    -1,    -1,
      -1,    -1,   537,    -1,   262,    -1,    -1,    -1,    -1,  2710,
      -1,    -1,    -1,  2714,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2741,  2742,    -1,    -1,    -1,    -1,    -1,   582,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   594,
    2761,    -1,   320,   598,    -1,    -1,   601,    -1,    -1,  2770,
      -1,  2772,   607,  2774,    -1,    -1,    -1,    -1,    -1,    -1,
     338,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    14,
      -1,    16,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   637,    -1,    -1,    -1,    -1,    -1,   643,    -1,
      -1,    -1,    37,    -1,    -1,    -1,    -1,    -1,   653,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    51,    52,    -1,    -1,
      -1,    -1,    -1,    -1,    59,   393,  2837,   395,    -1,    64,
      65,    -1,    -1,    -1,    -1,   403,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      85,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   104,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   128,    -1,    -1,  3616,    -1,    -1,    -1,
    2911,   136,   137,   138,    -1,    -1,    -1,   475,    -1,    -1,
      -1,    -1,    -1,    -1,   149,   150,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3652,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3660,    -1,   177,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2962,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   194,
      -1,  3681,    -1,   531,   532,   533,    -1,    -1,    -1,    -1,
     538,    -1,    -1,    -1,   209,    -1,   211,    -1,    -1,    -1,
      -1,   216,    -1,    -1,    -1,   220,   554,    -1,    -1,    -1,
     558,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   577,
      -1,   246,    -1,   248,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   595,    -1,   264,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3763,    -1,    -1,    -1,   282,    -1,    -1,
      -1,   286,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3081,  3082,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    13,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    25,    -1,    -1,    -1,  3815,    -1,    -1,    -1,  3819,
      -1,    -1,    36,    37,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    61,    62,    -1,
      -1,    -1,    -1,    -1,  3854,    69,    -1,    -1,    -1,    -1,
      74,    -1,  3153,    -1,    -1,    -1,   381,    -1,  3868,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   398,    -1,   400,   100,    -1,   102,    -1,
     104,    -1,    -1,    -1,  3185,  3186,    -1,    -1,   413,    -1,
      -1,    -1,   116,    -1,    -1,  3905,  3197,    -1,    -1,   424,
      -1,  3202,    -1,    -1,  3205,    -1,  3207,  3208,    -1,    -1,
      -1,    -1,    -1,   137,   138,    -1,    -1,    -1,    -1,    -1,
      -1,   446,    -1,    -1,   449,    -1,   451,    -1,    -1,   454,
      -1,    -1,   457,   458,    -1,    -1,    -1,    -1,    -1,   163,
     164,    -1,    -1,   468,    -1,   169,   471,    -1,   172,    -1,
      -1,    -1,    -1,    -1,   479,    -1,    -1,    -1,    -1,    -1,
     485,    -1,    -1,    -1,  3974,    -1,    -1,    -1,   493,    -1,
    3271,    -1,    -1,   498,   499,   500,   200,    -1,   202,    -1,
      -1,    -1,  3992,    -1,    -1,    -1,   210,    -1,   212,    -1,
      -1,    -1,    -1,    -1,  3295,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   530,    -1,    -1,    -1,    -1,
      -1,    -1,   537,    -1,   238,   239,   240,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    4040,    -1,    -1,    -1,    -1,    -1,    -1,   261,  4048,    -1,
      -1,    -1,    -1,    -1,  4054,    -1,  4056,    -1,    -1,    -1,
    3351,    -1,    -1,    -1,    -1,    -1,    -1,   582,    -1,   283,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   594,
      -1,    -1,    -1,   598,    -1,    -1,   601,    -1,    -1,    -1,
      -1,    -1,   607,    -1,    -1,    -1,    -1,    -1,    -1,   313,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   637,    -1,    -1,    -1,    -1,    -1,   643,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   653,    -1,
      -1,    -1,    -1,    -1,    -1,  4145,    -1,    -1,    -1,    -1,
      -1,  4151,  4152,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   380,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  4184,    -1,    -1,    -1,  4188,  4189,
      -1,    -1,   406,    -1,    -1,  4195,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   417,   418,    -1,    -1,   421,   422,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   442,    -1,
      -1,    -1,    -1,  4233,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   490,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   503,
      -1,    -1,    -1,    -1,  4294,    -1,  4296,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  4306,    -1,  4308,  4309,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     534,    -1,    -1,    -1,   538,  3616,    -1,  4327,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  4336,    -1,    -1,    -1,
    4340,    -1,   556,   557,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3652,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3660,
      -1,    35,    36,    -1,    -1,    -1,    -1,    41,    -1,    43,
      -1,    45,    46,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3681,   605,  4392,    -1,    -1,    -1,    -1,    -1,    62,    -1,
      -1,    -1,   616,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     624,    -1,    -1,    -1,    -1,  4415,    -1,  4417,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  4432,  4433,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    4450,    -1,    -1,    -1,    -1,   119,    -1,  4457,   122,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   130,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   148,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  4499,
      -1,   165,    -1,    -1,    -1,  4505,    -1,  4507,  4508,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  4522,  4523,  3815,    -1,    -1,   191,  3819,   193,
      -1,    -1,    -1,    -1,    -1,  4535,  4536,    -1,    -1,    -1,
      -1,    -1,   206,   207,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  4558,    -1,
      -1,    -1,    -1,  3854,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3868,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   251,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  4604,    -1,    -1,    -1,    -1,    -1,
      -1,  4611,    -1,    -1,  4614,    -1,   280,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   289,   290,    -1,   292,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  4651,    -1,    -1,    -1,    -1,    -1,    -1,  4658,    -1,
    4660,    -1,   326,   327,   328,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  4672,    -1,    -1,  4675,    -1,    -1,    -1,    -1,
      -1,   345,   346,   347,    -1,  4685,    -1,    -1,   352,    -1,
      -1,   355,    -1,  4693,    -1,  4695,    -1,  4697,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   372,   373,
      -1,  4711,    -1,    -1,    -1,  4715,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    4730,  4731,    -1,    -1,    -1,    -1,  4736,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   408,   409,  4746,  4747,    -1,    -1,
      -1,  4751,    -1,    -1,    -1,    -1,    -1,  4048,    -1,    -1,
      -1,    -1,    -1,  4054,    -1,  4056,    -1,    -1,    -1,   433,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  4786,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   489,    -1,    -1,    -1,   493,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   507,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  4145,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     564,    -1,    -1,   567,  4195,    -1,   570,   571,   572,   573,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  4233,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     614,   615,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   641,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  4294,    -1,  4296,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  4306,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  4415,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  4433,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  4457,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  4522,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    4611,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    4651,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,     5,
      -1,     7,     8,     9,    10,    11,    12,    -1,    -1,    15,
      -1,    -1,    -1,    19,  4675,    -1,    22,    -1,    24,    25,
      26,    27,    28,    29,    30,    31,    -1,    33,    -1,    -1,
      36,    37,    38,    39,    40,    41,    42,    -1,    44,    45,
      46,    47,    48,    -1,    50,    51,    -1,    -1,    54,    55,
      56,    57,    58,    -1,    60,    61,    62,    63,    64,    -1,
      66,    67,    68,    69,    70,    71,    72,    -1,    74,    75,
      76,    77,    78,    79,    80,  4736,    82,    83,    84,    85,
      86,    87,    88,    89,    -1,    91,    92,    -1,    94,    95,
      96,    97,    98,    -1,   100,   101,   102,   103,    -1,    -1,
     106,   107,   108,   109,   110,   111,    -1,   113,   114,   115,
      -1,   117,   118,   119,   120,   121,   122,    -1,    -1,    -1,
      -1,   127,   128,   129,    -1,  4786,   132,   133,    -1,   135,
      -1,    -1,    -1,   139,    -1,   141,   142,   143,   144,   145,
      -1,    -1,    -1,   149,    -1,    -1,   152,   153,   154,    -1,
      -1,    -1,   158,    -1,   160,   161,    -1,   163,   164,   165,
      -1,    -1,   168,   169,    -1,   171,   172,   173,   174,   175,
     176,   177,   178,    -1,   180,   181,   182,   183,   184,   185,
     186,   187,    -1,   189,   190,   191,   192,    -1,   194,    -1,
      -1,    -1,   198,    -1,   200,    -1,   202,    -1,   204,   205,
     206,   207,   208,   209,   210,    -1,   212,    -1,   214,    -1,
     216,   217,   218,    -1,   220,   221,   222,    -1,   224,   225,
      -1,    -1,    -1,   229,   230,   231,   232,   233,   234,    -1,
     236,   237,   238,    -1,   240,    -1,   242,    -1,    -1,    -1,
     246,   247,   248,   249,    -1,    -1,   252,    -1,   254,   255,
      -1,   257,   258,    -1,    -1,    -1,   262,    -1,    -1,   265,
     266,   267,    -1,   269,   270,    -1,   272,   273,   274,    -1,
      -1,    -1,    -1,    -1,   280,   281,    -1,   283,    -1,   285,
      -1,   287,   288,    -1,    -1,   291,    -1,    -1,    -1,    -1,
     296,   297,   298,   299,   300,   301,   302,   303,   304,   305,
     306,   307,   308,   309,   310,   311,    -1,   313,   314,   315,
     316,   317,   318,   319,   320,   321,   322,   323,   324,    -1,
      -1,    -1,    -1,   329,   330,   331,   332,   333,   334,    -1,
      -1,   337,   338,   339,   340,    -1,   342,   343,   344,   345,
     346,   347,   348,   349,   350,   351,   352,    -1,   354,   355,
     356,    -1,    -1,   359,   360,   361,   362,   363,   364,   365,
     366,   367,    -1,   369,   370,   371,    -1,   373,   374,   375,
      -1,   377,   378,   379,   380,    -1,   382,   383,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   392,   393,   394,    -1,
     396,   397,    -1,   399,    -1,   401,   402,   403,   404,   405,
     406,   407,   408,   409,   410,   411,    -1,   413,   414,   415,
      -1,   417,    -1,   419,   420,   421,   422,   423,    -1,   425,
     426,   427,    -1,    -1,   430,    -1,    -1,    -1,   434,   435,
     436,   437,   438,    -1,    -1,   441,   442,   443,   444,   445,
      -1,   447,   448,    -1,   450,   451,   452,   453,   454,   455,
      -1,   457,    -1,   459,   460,    -1,   462,   463,    -1,   465,
      -1,   467,    -1,   469,   470,   471,   472,   473,   474,   475,
     476,   477,   478,   479,   480,   481,    -1,   483,   484,    -1,
      -1,    -1,   488,   489,   490,   491,    -1,    -1,    -1,   495,
      -1,    -1,    -1,   499,    -1,   501,   502,   503,   504,   505,
     506,    -1,   508,   509,   510,   511,   512,   513,    -1,    -1,
      -1,    -1,    -1,    -1,   520,   521,    -1,   523,    -1,    -1,
     526,    -1,    -1,   529,   530,    -1,    -1,    -1,   534,   535,
     536,   537,   538,    -1,   540,   541,   542,   543,   544,   545,
     546,   547,   548,   549,   550,   551,   552,   553,   554,    -1,
     556,    -1,   558,   559,   560,   561,    -1,   563,   564,   565,
      -1,   567,   568,   569,   570,    -1,    -1,    -1,    -1,   575,
     576,   577,   578,    -1,   580,   581,   582,   583,   584,   585,
     586,   587,   588,   589,   590,   591,    -1,   593,   594,    -1,
      -1,   597,    -1,    -1,   600,    -1,   602,    -1,   604,   605,
     606,    -1,    -1,   609,   610,   611,   612,   613,    -1,    -1,
     616,   617,    -1,   619,   620,   621,   622,   623,   624,   625,
     626,    -1,    -1,    -1,    -1,    -1,    -1,   633,   634,    -1,
     636,   637,   638,    -1,    -1,   641,    -1,    -1,    -1,    -1,
     646,   647,    -1,    -1,    -1,    -1,   652,   653,    -1,    -1,
     656,   657,    -1,    -1,   660,   661,     5,    -1,     7,     8,
       9,    10,    11,    12,    13,    -1,    15,    -1,    -1,    -1,
      19,    -1,    -1,    22,    -1,    24,    25,    26,    27,    28,
      29,    30,    31,    -1,    33,    -1,    -1,    36,    37,    38,
      39,    40,    41,    42,    -1,    44,    45,    46,    -1,    48,
      -1,    50,    51,    -1,    -1,    54,    55,    56,    57,    58,
      -1,    60,    61,    62,    63,    64,    -1,    66,    67,    68,
      69,    70,    71,    72,    -1,    74,    75,    76,    77,    78,
      79,    80,    -1,    82,    83,    84,    85,    86,    87,    88,
      89,    -1,    91,    92,    -1,    94,    95,    96,    97,    98,
      -1,   100,   101,   102,   103,    -1,    -1,   106,   107,   108,
     109,   110,   111,    -1,   113,   114,   115,    -1,   117,   118,
     119,   120,   121,   122,    -1,    -1,    -1,    -1,   127,   128,
     129,    -1,    -1,   132,   133,    -1,   135,    -1,    -1,    -1,
     139,    -1,   141,   142,   143,   144,   145,    -1,    -1,    -1,
     149,    -1,    -1,   152,   153,   154,    -1,    -1,    -1,   158,
      -1,   160,   161,    -1,   163,   164,   165,    -1,    -1,   168,
     169,    -1,   171,   172,   173,   174,   175,   176,   177,   178,
      -1,   180,   181,   182,   183,   184,   185,   186,   187,    -1,
     189,   190,   191,   192,    -1,   194,    -1,    -1,    -1,   198,
      -1,   200,    -1,   202,    -1,   204,   205,   206,   207,   208,
     209,   210,    -1,   212,    -1,   214,    -1,   216,   217,   218,
      -1,   220,   221,   222,    -1,   224,   225,    -1,    -1,    -1,
     229,   230,   231,   232,   233,   234,    -1,   236,   237,   238,
      -1,   240,    -1,   242,    -1,    -1,    -1,   246,   247,   248,
     249,    -1,    -1,   252,    -1,   254,   255,    -1,   257,   258,
      -1,    -1,    -1,   262,    -1,    -1,   265,   266,   267,    -1,
      -1,   270,    -1,   272,   273,   274,    -1,    -1,    -1,    -1,
      -1,   280,   281,    -1,   283,    -1,   285,    -1,   287,   288,
      -1,    -1,   291,    -1,    -1,    -1,    -1,   296,   297,   298,
     299,   300,   301,   302,   303,   304,   305,   306,   307,   308,
     309,   310,   311,    -1,   313,   314,   315,   316,   317,   318,
     319,   320,   321,   322,   323,   324,    -1,    -1,    -1,    -1,
     329,   330,   331,   332,   333,   334,    -1,    -1,   337,   338,
     339,   340,    -1,   342,   343,   344,   345,   346,   347,   348,
     349,   350,   351,   352,    -1,   354,   355,   356,    -1,    -1,
     359,   360,   361,   362,   363,   364,   365,   366,   367,    -1,
     369,   370,   371,    -1,   373,   374,   375,   376,   377,   378,
     379,   380,    -1,   382,   383,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   392,   393,   394,    -1,   396,   397,    -1,
     399,    -1,   401,   402,   403,   404,   405,   406,   407,   408,
     409,   410,   411,    -1,   413,   414,   415,    -1,   417,    -1,
     419,   420,   421,   422,   423,    -1,   425,   426,   427,    -1,
      -1,   430,    -1,    -1,    -1,   434,   435,   436,   437,   438,
      -1,    -1,   441,   442,   443,   444,   445,    -1,   447,   448,
      -1,   450,   451,   452,   453,   454,   455,    -1,   457,    -1,
     459,   460,    -1,   462,   463,    -1,   465,    -1,   467,    -1,
     469,   470,   471,   472,   473,   474,   475,   476,   477,   478,
     479,   480,   481,    -1,   483,   484,    -1,    -1,    -1,   488,
     489,   490,   491,    -1,    -1,    -1,   495,    -1,    -1,    -1,
     499,    -1,   501,   502,   503,   504,   505,   506,    -1,   508,
     509,   510,   511,   512,   513,    -1,    -1,    -1,    -1,    -1,
      -1,   520,   521,    -1,   523,    -1,    -1,   526,    -1,    -1,
     529,   530,    -1,    -1,    -1,   534,   535,   536,   537,   538,
      -1,   540,   541,   542,   543,   544,   545,   546,   547,   548,
     549,   550,   551,   552,   553,   554,    -1,   556,    -1,   558,
     559,   560,   561,    -1,   563,   564,   565,    -1,   567,   568,
     569,   570,    -1,    -1,    -1,    -1,    -1,   576,   577,   578,
      -1,   580,   581,   582,   583,   584,   585,   586,   587,   588,
     589,   590,   591,    -1,   593,   594,    -1,    -1,   597,    -1,
      -1,   600,    -1,   602,    -1,   604,   605,   606,    -1,    -1,
     609,   610,   611,   612,   613,    -1,    -1,   616,   617,    -1,
     619,   620,   621,   622,   623,   624,   625,   626,    -1,    -1,
      -1,    -1,    -1,    -1,   633,   634,    -1,   636,   637,   638,
      -1,    -1,   641,    -1,    -1,    -1,    -1,   646,   647,    -1,
      -1,    -1,    -1,   652,   653,    -1,    -1,   656,   657,    -1,
      -1,   660,   661,     5,    -1,     7,     8,     9,    10,    11,
      12,    -1,    -1,    15,    -1,    -1,    -1,    19,    -1,    -1,
      22,    -1,    24,    25,    26,    27,    28,    29,    30,    31,
      -1,    33,    -1,    -1,    36,    37,    38,    39,    40,    41,
      42,    -1,    44,    45,    46,    -1,    48,    -1,    50,    51,
      -1,    -1,    54,    55,    56,    57,    58,    -1,    60,    61,
      62,    63,    64,    -1,    66,    67,    68,    69,    70,    71,
      72,    -1,    74,    75,    76,    77,    78,    79,    80,    -1,
      82,    83,    84,    85,    86,    87,    88,    89,    -1,    91,
      92,    -1,    94,    95,    96,    97,    98,    -1,   100,   101,
     102,   103,    -1,    -1,   106,   107,   108,   109,   110,   111,
      -1,   113,   114,   115,    -1,   117,   118,   119,   120,   121,
     122,    -1,    -1,    -1,    -1,   127,   128,   129,    -1,    -1,
     132,   133,    -1,   135,    -1,    -1,    -1,   139,    -1,   141,
     142,   143,   144,   145,    -1,    -1,    -1,   149,    -1,    -1,
     152,   153,   154,    -1,    -1,    -1,   158,    -1,   160,   161,
      -1,   163,   164,   165,    -1,    -1,   168,   169,    -1,   171,
     172,   173,   174,   175,   176,   177,   178,    -1,   180,   181,
     182,   183,   184,   185,   186,   187,    -1,   189,   190,   191,
     192,    -1,   194,    -1,    -1,    -1,   198,   199,   200,    -1,
     202,    -1,   204,   205,   206,   207,   208,   209,   210,    -1,
     212,    -1,   214,    -1,   216,   217,   218,    -1,   220,   221,
     222,    -1,   224,   225,    -1,    -1,    -1,   229,   230,   231,
     232,   233,   234,    -1,   236,   237,   238,    -1,   240,    -1,
     242,    -1,    -1,    -1,   246,   247,   248,   249,    -1,    -1,
     252,    -1,   254,   255,    -1,   257,   258,    -1,    -1,    -1,
     262,    -1,    -1,   265,   266,   267,    -1,    -1,   270,    -1,
     272,   273,   274,    -1,    -1,    -1,    -1,    -1,   280,   281,
      -1,   283,    -1,   285,    -1,   287,   288,    -1,    -1,   291,
      -1,    -1,    -1,    -1,   296,   297,   298,   299,   300,   301,
     302,   303,   304,   305,   306,   307,   308,   309,   310,   311,
      -1,   313,   314,   315,   316,   317,   318,   319,   320,   321,
     322,   323,   324,    -1,    -1,    -1,    -1,   329,   330,   331,
     332,   333,   334,    -1,    -1,   337,   338,   339,   340,    -1,
     342,   343,   344,   345,   346,   347,   348,   349,   350,   351,
     352,    -1,   354,   355,   356,    -1,    -1,   359,   360,   361,
     362,   363,   364,   365,   366,   367,    -1,   369,   370,   371,
      -1,   373,   374,   375,    -1,   377,   378,   379,   380,    -1,
     382,   383,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     392,   393,   394,    -1,   396,   397,    -1,   399,    -1,   401,
     402,   403,   404,   405,   406,   407,   408,   409,   410,   411,
      -1,   413,   414,   415,    -1,   417,    -1,   419,   420,   421,
     422,   423,    -1,   425,   426,   427,    -1,    -1,   430,    -1,
      -1,    -1,   434,   435,   436,   437,   438,    -1,    -1,   441,
     442,   443,   444,   445,    -1,   447,   448,    -1,   450,   451,
     452,   453,   454,   455,    -1,   457,    -1,   459,   460,    -1,
     462,   463,    -1,   465,    -1,   467,    -1,   469,   470,   471,
     472,   473,   474,   475,   476,   477,   478,   479,   480,   481,
      -1,   483,   484,    -1,    -1,    -1,   488,   489,   490,   491,
      -1,    -1,    -1,   495,    -1,    -1,    -1,   499,    -1,   501,
     502,   503,   504,   505,   506,    -1,   508,   509,   510,   511,
     512,   513,    -1,    -1,    -1,    -1,    -1,    -1,   520,   521,
      -1,   523,    -1,    -1,   526,    -1,    -1,   529,   530,    -1,
      -1,    -1,   534,   535,   536,   537,   538,    -1,   540,   541,
     542,   543,   544,   545,   546,   547,   548,   549,   550,   551,
     552,   553,   554,    -1,   556,    -1,   558,   559,   560,   561,
      -1,   563,   564,   565,    -1,   567,   568,   569,   570,    -1,
      -1,    -1,    -1,    -1,   576,   577,   578,    -1,   580,   581,
     582,   583,   584,   585,   586,   587,   588,   589,   590,   591,
      -1,   593,   594,    -1,    -1,   597,    -1,    -1,   600,    -1,
     602,    -1,   604,   605,   606,    -1,    -1,   609,   610,   611,
     612,   613,    -1,    -1,   616,   617,    -1,   619,   620,   621,
     622,   623,   624,   625,   626,    -1,    -1,    -1,    -1,    -1,
      -1,   633,   634,    -1,   636,   637,   638,    -1,    -1,   641,
      -1,    -1,    -1,    -1,   646,   647,    -1,    -1,    -1,    -1,
     652,   653,    -1,    -1,   656,   657,    -1,    -1,   660,   661,
       5,    -1,     7,     8,     9,    10,    11,    12,    -1,    -1,
      15,    -1,    -1,    -1,    19,    -1,    -1,    22,    -1,    24,
      25,    26,    27,    28,    29,    30,    31,    -1,    33,    -1,
      -1,    36,    37,    38,    39,    40,    41,    42,    -1,    44,
      45,    46,    -1,    48,    -1,    50,    51,    -1,    -1,    54,
      55,    56,    57,    58,    -1,    60,    61,    62,    63,    64,
      -1,    66,    67,    68,    69,    70,    71,    72,    -1,    74,
      75,    76,    77,    78,    79,    80,    -1,    82,    83,    84,
      85,    86,    87,    88,    89,    -1,    91,    92,    -1,    94,
      95,    96,    97,    98,    -1,   100,   101,   102,   103,    -1,
      -1,   106,   107,   108,   109,   110,   111,    -1,   113,   114,
     115,    -1,   117,   118,   119,   120,   121,   122,    -1,    -1,
      -1,    -1,   127,   128,   129,    -1,    -1,   132,   133,    -1,
     135,    -1,    -1,    -1,   139,    -1,   141,   142,   143,   144,
     145,    -1,    -1,    -1,   149,    -1,    -1,   152,   153,   154,
      -1,    -1,    -1,   158,    -1,   160,   161,    -1,   163,   164,
     165,    -1,    -1,   168,   169,    -1,   171,   172,   173,   174,
     175,   176,   177,   178,    -1,   180,   181,   182,   183,   184,
     185,   186,   187,    -1,   189,   190,   191,   192,    -1,   194,
      -1,    -1,    -1,   198,   199,   200,    -1,   202,    -1,   204,
     205,   206,   207,   208,   209,   210,    -1,   212,    -1,   214,
      -1,   216,   217,   218,    -1,   220,   221,   222,    -1,   224,
     225,    -1,    -1,    -1,   229,   230,   231,   232,   233,   234,
      -1,   236,   237,   238,    -1,   240,    -1,   242,    -1,    -1,
      -1,   246,   247,   248,   249,    -1,    -1,   252,    -1,   254,
     255,    -1,   257,   258,    -1,    -1,    -1,   262,    -1,    -1,
     265,   266,   267,    -1,    -1,   270,    -1,   272,   273,   274,
      -1,    -1,    -1,    -1,    -1,   280,   281,    -1,   283,    -1,
     285,    -1,   287,   288,    -1,    -1,   291,    -1,    -1,    -1,
      -1,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,    -1,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
      -1,    -1,    -1,    -1,   329,   330,   331,   332,   333,   334,
      -1,    -1,   337,   338,   339,   340,    -1,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,    -1,   354,
     355,   356,    -1,    -1,   359,   360,   361,   362,   363,   364,
     365,   366,   367,    -1,   369,   370,   371,    -1,   373,   374,
     375,    -1,   377,   378,   379,   380,    -1,   382,   383,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   392,   393,   394,
      -1,   396,   397,    -1,   399,    -1,   401,   402,   403,   404,
     405,   406,   407,   408,   409,   410,   411,    -1,   413,   414,
     415,    -1,   417,    -1,   419,   420,   421,   422,   423,    -1,
     425,   426,   427,    -1,    -1,   430,    -1,    -1,    -1,   434,
     435,   436,   437,   438,    -1,    -1,   441,   442,   443,   444,
     445,    -1,   447,   448,    -1,   450,   451,   452,   453,   454,
     455,    -1,   457,    -1,   459,   460,    -1,   462,   463,    -1,
     465,    -1,   467,    -1,   469,   470,   471,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,    -1,   483,   484,
      -1,    -1,    -1,   488,   489,   490,   491,    -1,    -1,    -1,
     495,    -1,    -1,    -1,   499,    -1,   501,   502,   503,   504,
     505,   506,    -1,   508,   509,   510,   511,   512,   513,    -1,
      -1,    -1,    -1,    -1,    -1,   520,   521,    -1,   523,    -1,
      -1,   526,    -1,    -1,   529,   530,    -1,    -1,    -1,   534,
     535,   536,   537,   538,    -1,   540,   541,   542,   543,   544,
     545,   546,   547,   548,   549,   550,   551,   552,   553,   554,
      -1,   556,    -1,   558,   559,   560,   561,    -1,   563,   564,
     565,    -1,   567,   568,   569,   570,    -1,    -1,    -1,    -1,
      -1,   576,   577,   578,    -1,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,    -1,   593,   594,
      -1,    -1,   597,    -1,    -1,   600,    -1,   602,    -1,   604,
     605,   606,    -1,    -1,   609,   610,   611,   612,   613,    -1,
      -1,   616,   617,    -1,   619,   620,   621,   622,   623,   624,
     625,   626,    -1,    -1,    -1,    -1,    -1,    -1,   633,   634,
      -1,   636,   637,   638,    -1,    -1,   641,    -1,    -1,    -1,
      -1,   646,   647,    -1,    -1,    -1,    -1,   652,   653,    -1,
      -1,   656,   657,    -1,    -1,   660,   661,     5,    -1,     7,
       8,     9,    10,    11,    12,    -1,    -1,    15,    -1,    -1,
      -1,    19,    -1,    -1,    22,    -1,    24,    25,    26,    27,
      28,    29,    30,    31,    -1,    33,    -1,    -1,    36,    37,
      38,    39,    40,    41,    42,    -1,    44,    45,    46,    -1,
      48,    -1,    50,    51,    -1,    -1,    54,    55,    56,    57,
      58,    -1,    60,    61,    62,    63,    64,    -1,    66,    67,
      68,    69,    70,    71,    72,    -1,    74,    75,    76,    77,
      78,    79,    80,    -1,    82,    83,    84,    85,    86,    87,
      88,    89,    -1,    91,    92,    -1,    94,    95,    96,    97,
      98,    -1,   100,   101,   102,   103,    -1,    -1,   106,   107,
     108,   109,   110,   111,    -1,   113,   114,   115,    -1,   117,
     118,   119,   120,   121,   122,    -1,    -1,    -1,    -1,   127,
     128,   129,    -1,    -1,   132,   133,    -1,   135,    -1,    -1,
      -1,   139,    -1,   141,   142,   143,   144,   145,    -1,    -1,
      -1,   149,    -1,    -1,   152,   153,   154,    -1,    -1,    -1,
     158,    -1,   160,   161,    -1,   163,   164,   165,    -1,    -1,
     168,   169,    -1,   171,   172,   173,   174,   175,   176,   177,
     178,    -1,   180,   181,   182,   183,   184,   185,   186,   187,
      -1,   189,   190,   191,   192,    -1,   194,    -1,    -1,    -1,
     198,   199,   200,    -1,   202,    -1,   204,   205,   206,   207,
     208,   209,   210,    -1,   212,    -1,   214,    -1,   216,   217,
     218,    -1,   220,   221,   222,    -1,   224,   225,    -1,    -1,
      -1,   229,   230,   231,   232,   233,   234,    -1,   236,   237,
     238,    -1,   240,    -1,   242,    -1,    -1,    -1,   246,   247,
     248,   249,    -1,    -1,   252,    -1,   254,   255,    -1,   257,
     258,    -1,    -1,    -1,   262,    -1,    -1,   265,   266,   267,
      -1,    -1,   270,    -1,   272,   273,   274,    -1,    -1,    -1,
      -1,    -1,   280,   281,    -1,   283,    -1,   285,    -1,   287,
     288,    -1,    -1,   291,    -1,    -1,    -1,    -1,   296,   297,
     298,   299,   300,   301,   302,   303,   304,   305,   306,   307,
     308,   309,   310,   311,    -1,   313,   314,   315,   316,   317,
     318,   319,   320,   321,   322,   323,   324,    -1,    -1,    -1,
      -1,   329,   330,   331,   332,   333,   334,    -1,    -1,   337,
     338,   339,   340,    -1,   342,   343,   344,   345,   346,   347,
     348,   349,   350,   351,   352,    -1,   354,   355,   356,    -1,
      -1,   359,   360,   361,   362,   363,   364,   365,   366,   367,
      -1,   369,   370,   371,    -1,   373,   374,   375,    -1,   377,
     378,   379,   380,    -1,   382,   383,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   392,   393,   394,    -1,   396,   397,
      -1,   399,    -1,   401,   402,   403,   404,   405,   406,   407,
     408,   409,   410,   411,    -1,   413,   414,   415,    -1,   417,
      -1,   419,   420,   421,   422,   423,    -1,   425,   426,   427,
      -1,    -1,   430,    -1,    -1,    -1,   434,   435,   436,   437,
     438,    -1,    -1,   441,   442,   443,   444,   445,    -1,   447,
     448,    -1,   450,   451,   452,   453,   454,   455,    -1,   457,
      -1,   459,   460,    -1,   462,   463,    -1,   465,    -1,   467,
      -1,   469,   470,   471,   472,   473,   474,   475,   476,   477,
     478,   479,   480,   481,    -1,   483,   484,    -1,    -1,    -1,
     488,   489,   490,   491,    -1,    -1,    -1,   495,    -1,    -1,
      -1,   499,    -1,   501,   502,   503,   504,   505,   506,    -1,
     508,   509,   510,   511,   512,   513,    -1,    -1,    -1,    -1,
      -1,    -1,   520,   521,    -1,   523,    -1,    -1,   526,    -1,
      -1,   529,   530,    -1,    -1,    -1,   534,   535,   536,   537,
     538,    -1,   540,   541,   542,   543,   544,   545,   546,   547,
     548,   549,   550,   551,   552,   553,   554,    -1,   556,    -1,
     558,   559,   560,   561,    -1,   563,   564,   565,    -1,   567,
     568,   569,   570,    -1,    -1,    -1,    -1,    -1,   576,   577,
     578,    -1,   580,   581,   582,   583,   584,   585,   586,   587,
     588,   589,   590,   591,    -1,   593,   594,    -1,    -1,   597,
      -1,    -1,   600,    -1,   602,    -1,   604,   605,   606,    -1,
      -1,   609,   610,   611,   612,   613,    -1,    -1,   616,   617,
      -1,   619,   620,   621,   622,   623,   624,   625,   626,    -1,
      -1,    -1,    -1,    -1,    -1,   633,   634,    -1,   636,   637,
     638,    -1,    -1,   641,    -1,    -1,    -1,    -1,   646,   647,
      -1,    -1,    -1,    -1,   652,   653,    -1,    -1,   656,   657,
      -1,    -1,   660,   661,     5,    -1,     7,     8,     9,    10,
      11,    12,    -1,    -1,    15,    -1,    -1,    -1,    19,    -1,
      -1,    22,    -1,    24,    25,    26,    27,    28,    29,    30,
      31,    -1,    33,    -1,    -1,    36,    37,    38,    39,    40,
      41,    42,    -1,    44,    45,    46,    -1,    48,    -1,    50,
      51,    -1,    -1,    54,    55,    56,    57,    58,    -1,    60,
      61,    62,    63,    64,    -1,    66,    67,    68,    69,    70,
      71,    72,    -1,    74,    75,    76,    77,    78,    79,    80,
      -1,    82,    83,    84,    85,    86,    87,    88,    89,    -1,
      91,    92,    -1,    94,    95,    96,    97,    98,    -1,   100,
     101,   102,   103,    -1,    -1,   106,   107,   108,   109,   110,
     111,    -1,   113,   114,   115,    -1,   117,   118,   119,   120,
     121,   122,    -1,    -1,    -1,    -1,   127,   128,   129,    -1,
      -1,   132,   133,    -1,   135,    -1,    -1,    -1,   139,    -1,
     141,   142,   143,   144,   145,    -1,    -1,    -1,   149,    -1,
      -1,   152,   153,   154,    -1,    -1,    -1,   158,    -1,   160,
     161,    -1,   163,   164,   165,    -1,    -1,   168,   169,    -1,
     171,   172,   173,   174,   175,   176,   177,   178,    -1,   180,
     181,   182,   183,   184,   185,   186,   187,    -1,   189,   190,
     191,   192,    -1,   194,    -1,    -1,    -1,   198,    -1,   200,
      -1,   202,    -1,   204,   205,   206,   207,   208,   209,   210,
      -1,   212,    -1,   214,    -1,   216,   217,   218,    -1,   220,
     221,   222,    -1,   224,   225,    -1,    -1,    -1,   229,   230,
     231,   232,   233,   234,    -1,   236,   237,   238,    -1,   240,
      -1,   242,    -1,    -1,    -1,   246,   247,   248,   249,    -1,
      -1,   252,    -1,   254,   255,    -1,   257,   258,    -1,    -1,
      -1,   262,    -1,    -1,   265,   266,   267,    -1,    -1,   270,
      -1,   272,   273,   274,    -1,    -1,    -1,    -1,    -1,   280,
     281,    -1,   283,    -1,   285,    -1,   287,   288,    -1,    -1,
     291,    -1,    -1,    -1,    -1,   296,   297,   298,   299,   300,
     301,   302,   303,   304,   305,   306,   307,   308,   309,   310,
     311,    -1,   313,   314,   315,   316,   317,   318,   319,   320,
     321,   322,   323,   324,    -1,    -1,    -1,    -1,   329,   330,
     331,   332,   333,   334,    -1,    -1,   337,   338,   339,   340,
      -1,   342,   343,   344,   345,   346,   347,   348,   349,   350,
     351,   352,    -1,   354,   355,   356,    -1,    -1,   359,   360,
     361,   362,   363,   364,   365,   366,   367,    -1,   369,   370,
     371,    -1,   373,   374,   375,    -1,   377,   378,   379,   380,
      -1,   382,   383,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   392,   393,   394,    -1,   396,   397,    -1,   399,    -1,
     401,   402,   403,   404,   405,   406,   407,   408,   409,   410,
     411,    -1,   413,   414,   415,    -1,   417,    -1,   419,   420,
     421,   422,   423,    -1,   425,   426,   427,    -1,    -1,   430,
      -1,    -1,    -1,   434,   435,   436,   437,   438,    -1,    -1,
     441,   442,   443,   444,   445,    -1,   447,   448,    -1,   450,
     451,   452,   453,   454,   455,    -1,   457,    -1,   459,   460,
      -1,   462,   463,    -1,   465,    -1,   467,    -1,   469,   470,
     471,   472,   473,   474,   475,   476,   477,   478,   479,   480,
     481,    -1,   483,   484,    -1,    -1,    -1,   488,   489,   490,
     491,    -1,    -1,    -1,   495,    -1,    -1,    -1,   499,    -1,
     501,   502,   503,   504,   505,   506,    -1,   508,   509,   510,
     511,   512,   513,    -1,    -1,    -1,    -1,    -1,    -1,   520,
     521,    -1,   523,    -1,    -1,   526,    -1,    -1,   529,   530,
      -1,    -1,    -1,   534,   535,   536,   537,   538,    -1,   540,
     541,   542,   543,   544,   545,   546,   547,   548,   549,   550,
     551,   552,   553,   554,    -1,   556,    -1,   558,   559,   560,
     561,    -1,   563,   564,   565,    -1,   567,   568,   569,   570,
      -1,    -1,    -1,    -1,    -1,   576,   577,   578,    -1,   580,
     581,   582,   583,   584,   585,   586,   587,   588,   589,   590,
     591,    -1,   593,   594,    -1,    -1,   597,    -1,    -1,   600,
      -1,   602,    -1,   604,   605,   606,    -1,    -1,   609,   610,
     611,   612,   613,    -1,    -1,   616,   617,    -1,   619,   620,
     621,   622,   623,   624,   625,   626,    -1,    -1,    -1,    -1,
      -1,    -1,   633,   634,    -1,   636,   637,   638,    -1,    -1,
     641,    -1,    -1,    -1,    -1,   646,   647,    -1,    -1,    -1,
      -1,   652,   653,    -1,    -1,   656,   657,    -1,    -1,   660,
     661,     5,    -1,     7,     8,     9,    10,    11,    12,    -1,
      -1,    15,    -1,    -1,    -1,    19,    -1,    -1,    22,    -1,
      24,    25,    26,    27,    28,    29,    30,    31,    -1,    33,
      -1,    -1,    36,    37,    38,    39,    40,    41,    42,    -1,
      44,    45,    46,    -1,    48,    -1,    50,    51,    -1,    -1,
      54,    55,    56,    57,    58,    -1,    60,    61,    62,    63,
      64,    -1,    66,    67,    68,    69,    70,    71,    72,    -1,
      74,    75,    76,    77,    78,    79,    80,    -1,    82,    83,
      84,    85,    86,    87,    88,    89,    -1,    91,    92,    -1,
      94,    95,    96,    97,    98,    -1,   100,   101,   102,   103,
      -1,    -1,   106,   107,   108,   109,   110,   111,    -1,   113,
     114,   115,    -1,   117,   118,   119,   120,   121,   122,    -1,
      -1,    -1,    -1,   127,   128,   129,    -1,    -1,   132,   133,
      -1,   135,    -1,    -1,    -1,   139,    -1,   141,   142,   143,
     144,   145,    -1,    -1,    -1,   149,    -1,    -1,   152,   153,
     154,    -1,    -1,    -1,   158,    -1,   160,   161,    -1,   163,
     164,   165,    -1,    -1,   168,   169,    -1,   171,   172,   173,
     174,   175,   176,   177,   178,    -1,   180,   181,   182,   183,
     184,   185,   186,   187,    -1,   189,   190,   191,   192,    -1,
     194,    -1,    -1,    -1,   198,    -1,   200,    -1,   202,    -1,
     204,   205,   206,   207,   208,   209,   210,    -1,   212,    -1,
     214,    -1,   216,   217,   218,    -1,   220,   221,   222,    -1,
     224,   225,    -1,    -1,    -1,   229,   230,   231,   232,   233,
     234,    -1,   236,   237,   238,    -1,   240,    -1,   242,    -1,
      -1,    -1,   246,   247,   248,   249,    -1,    -1,   252,    -1,
     254,   255,    -1,   257,   258,    -1,    -1,    -1,   262,    -1,
      -1,   265,   266,   267,    -1,    -1,   270,    -1,   272,   273,
     274,    -1,    -1,    -1,    -1,    -1,   280,   281,    -1,   283,
      -1,   285,    -1,   287,   288,    -1,    -1,   291,    -1,    -1,
      -1,    -1,   296,   297,   298,   299,   300,   301,   302,   303,
     304,   305,   306,   307,   308,   309,   310,   311,    -1,   313,
     314,   315,   316,   317,   318,   319,   320,   321,   322,   323,
     324,    -1,    -1,    -1,    -1,   329,   330,   331,   332,   333,
     334,    -1,    -1,   337,   338,   339,   340,    -1,   342,   343,
     344,   345,   346,   347,   348,   349,   350,   351,   352,    -1,
     354,   355,   356,    -1,    -1,   359,   360,   361,   362,   363,
     364,   365,   366,   367,    -1,   369,   370,   371,    -1,   373,
     374,   375,    -1,   377,   378,   379,   380,    -1,   382,   383,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   392,   393,
     394,    -1,   396,   397,    -1,   399,    -1,   401,   402,   403,
     404,   405,   406,   407,   408,   409,   410,   411,    -1,   413,
     414,   415,    -1,   417,    -1,   419,   420,   421,   422,   423,
      -1,   425,   426,   427,    -1,    -1,   430,    -1,    -1,    -1,
     434,   435,   436,   437,   438,    -1,    -1,   441,   442,   443,
     444,   445,    -1,   447,   448,    -1,   450,   451,   452,   453,
     454,   455,    -1,   457,    -1,   459,   460,    -1,   462,   463,
      -1,   465,    -1,   467,    -1,   469,   470,   471,   472,   473,
     474,   475,   476,   477,   478,   479,   480,   481,    -1,   483,
     484,    -1,    -1,    -1,   488,   489,   490,   491,    -1,    -1,
      -1,   495,    -1,    -1,    -1,   499,    -1,   501,   502,   503,
     504,   505,   506,    -1,   508,   509,   510,   511,   512,   513,
      -1,    -1,    -1,    -1,    -1,    -1,   520,   521,    -1,   523,
      -1,    -1,   526,    -1,    -1,   529,   530,    -1,    -1,    -1,
     534,   535,   536,   537,   538,    -1,   540,   541,   542,   543,
     544,   545,   546,   547,   548,   549,   550,   551,   552,   553,
     554,    -1,   556,    -1,   558,   559,   560,   561,    -1,   563,
     564,   565,    -1,   567,   568,   569,   570,    -1,    -1,    -1,
      -1,    -1,   576,   577,   578,    -1,   580,   581,   582,   583,
     584,   585,   586,   587,   588,   589,   590,   591,    -1,   593,
     594,    -1,    -1,   597,    -1,    -1,   600,    -1,   602,    -1,
     604,   605,   606,    -1,    -1,   609,   610,   611,   612,   613,
      -1,    -1,   616,   617,    -1,   619,   620,   621,   622,   623,
     624,   625,   626,    -1,    -1,    -1,    -1,    -1,    -1,   633,
     634,    -1,   636,   637,   638,    -1,    -1,   641,    -1,    -1,
      -1,    -1,   646,   647,    -1,    -1,    -1,    -1,   652,   653,
      -1,    -1,   656,   657,    -1,    -1,   660,   661,     5,    -1,
       7,     8,     9,    10,    11,    12,    13,    -1,    15,    -1,
      -1,    -1,    19,    -1,    -1,    22,    -1,    24,    25,    26,
      27,    28,    29,    30,    31,    -1,    33,    -1,    -1,    36,
      37,    38,    39,    40,    41,    42,    -1,    44,    45,    46,
      -1,    48,    -1,    50,    51,    -1,    -1,    54,    55,    56,
      57,    58,    -1,    60,    61,    62,    63,    64,    -1,    66,
      67,    68,    69,    70,    71,    72,    -1,    74,    75,    76,
      77,    78,    79,    80,    -1,    82,    83,    84,    85,    86,
      87,    88,    89,    -1,    91,    92,    -1,    94,    95,    96,
      97,    98,    -1,   100,   101,   102,   103,    -1,    -1,   106,
     107,   108,   109,   110,   111,    -1,   113,   114,   115,    -1,
     117,   118,   119,   120,   121,   122,    -1,    -1,    -1,    -1,
     127,   128,   129,    -1,    -1,   132,   133,    -1,   135,    -1,
      -1,    -1,   139,    -1,   141,   142,   143,   144,   145,    -1,
      -1,    -1,   149,    -1,    -1,   152,   153,   154,    -1,    -1,
      -1,   158,    -1,   160,   161,    -1,   163,   164,   165,    -1,
      -1,   168,   169,    -1,   171,   172,   173,   174,   175,   176,
     177,   178,    -1,   180,   181,   182,   183,   184,   185,   186,
     187,    -1,   189,   190,   191,   192,    -1,   194,    -1,    -1,
      -1,   198,    -1,   200,    -1,   202,    -1,   204,   205,   206,
     207,   208,   209,   210,    -1,   212,    -1,   214,    -1,   216,
     217,   218,    -1,   220,   221,   222,    -1,   224,   225,    -1,
      -1,    -1,   229,   230,   231,   232,   233,   234,    -1,   236,
     237,   238,    -1,   240,    -1,   242,    -1,    -1,    -1,   246,
     247,   248,   249,    -1,    -1,   252,    -1,   254,   255,    -1,
     257,   258,    -1,    -1,    -1,   262,    -1,    -1,   265,   266,
     267,    -1,    -1,   270,    -1,   272,   273,   274,    -1,    -1,
      -1,    -1,    -1,   280,   281,    -1,   283,    -1,   285,    -1,
     287,   288,    -1,    -1,   291,    -1,    -1,    -1,    -1,   296,
     297,   298,   299,   300,   301,   302,   303,   304,   305,   306,
     307,   308,   309,   310,   311,    -1,   313,   314,   315,   316,
     317,   318,   319,   320,   321,   322,   323,   324,    -1,    -1,
      -1,    -1,   329,   330,   331,   332,   333,   334,    -1,    -1,
     337,   338,   339,   340,    -1,   342,   343,   344,   345,   346,
     347,   348,   349,   350,   351,   352,    -1,   354,   355,   356,
      -1,    -1,   359,   360,   361,   362,   363,    -1,   365,   366,
     367,    -1,   369,   370,   371,    -1,   373,   374,   375,    -1,
     377,   378,   379,   380,    -1,   382,   383,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   392,   393,   394,    -1,   396,
     397,    -1,   399,    -1,   401,   402,   403,   404,   405,   406,
     407,   408,   409,   410,   411,    -1,   413,   414,   415,    -1,
     417,    -1,   419,   420,   421,   422,   423,    -1,   425,   426,
     427,    -1,    -1,   430,    -1,    -1,    -1,   434,   435,   436,
     437,   438,    -1,    -1,   441,   442,   443,   444,   445,    -1,
     447,   448,    -1,   450,   451,   452,   453,   454,   455,    -1,
     457,    -1,   459,   460,    -1,   462,   463,    -1,   465,    -1,
     467,    -1,   469,   470,   471,   472,   473,   474,   475,   476,
     477,   478,   479,   480,   481,    -1,   483,   484,    -1,    -1,
      -1,   488,   489,   490,   491,    -1,    -1,    -1,   495,    -1,
      -1,    -1,   499,    -1,   501,   502,   503,   504,   505,   506,
      -1,   508,   509,   510,   511,   512,   513,    -1,    -1,    -1,
      -1,    -1,    -1,   520,   521,    -1,   523,    -1,    -1,   526,
      -1,    -1,   529,   530,    -1,    -1,    -1,   534,   535,   536,
     537,   538,    -1,   540,   541,   542,   543,   544,   545,   546,
     547,   548,   549,   550,   551,   552,   553,   554,    -1,   556,
      -1,   558,   559,   560,   561,    -1,   563,   564,   565,    -1,
     567,   568,   569,   570,    -1,    -1,    -1,    -1,    -1,   576,
     577,   578,    -1,   580,   581,   582,   583,   584,   585,   586,
     587,   588,   589,   590,   591,    -1,   593,   594,    -1,    -1,
     597,    -1,    -1,   600,    -1,   602,    -1,   604,   605,   606,
      -1,    -1,   609,   610,   611,   612,   613,    -1,    -1,   616,
     617,    -1,   619,   620,   621,   622,   623,   624,   625,   626,
      -1,    -1,    -1,    -1,    -1,    -1,   633,   634,    -1,   636,
     637,   638,    -1,    -1,   641,    -1,    -1,    -1,    -1,   646,
     647,    -1,    -1,    -1,    -1,   652,   653,    -1,    -1,   656,
     657,    -1,    -1,   660,   661,     5,    -1,     7,     8,     9,
      10,    11,    12,    -1,    -1,    15,    -1,    -1,    -1,    19,
      -1,    -1,    22,    -1,    24,    25,    26,    27,    28,    29,
      30,    31,    -1,    33,    -1,    -1,    36,    37,    38,    39,
      40,    41,    42,    -1,    44,    45,    46,    -1,    48,    -1,
      50,    51,    -1,    -1,    54,    55,    56,    57,    58,    -1,
      60,    61,    62,    63,    64,    -1,    66,    67,    68,    69,
      70,    71,    72,    -1,    74,    75,    76,    77,    78,    79,
      80,    -1,    82,    83,    84,    85,    86,    87,    88,    89,
      -1,    91,    92,    -1,    94,    95,    96,    97,    98,    -1,
     100,   101,   102,   103,    -1,    -1,   106,   107,   108,   109,
     110,   111,    -1,   113,   114,   115,    -1,   117,   118,   119,
     120,   121,   122,    -1,    -1,    -1,    -1,   127,   128,   129,
      -1,    -1,   132,   133,    -1,   135,    -1,    -1,    -1,   139,
      -1,   141,   142,   143,   144,   145,    -1,    -1,    -1,   149,
      -1,    -1,   152,   153,   154,    -1,    -1,    -1,   158,    -1,
     160,   161,    -1,   163,   164,   165,    -1,    -1,   168,   169,
      -1,   171,   172,   173,   174,   175,   176,   177,   178,    -1,
     180,   181,   182,   183,   184,   185,   186,   187,    -1,   189,
     190,   191,   192,    -1,   194,    -1,    -1,    -1,   198,    -1,
     200,    -1,   202,    -1,   204,   205,   206,   207,   208,   209,
     210,    -1,   212,    -1,   214,    -1,   216,   217,   218,    -1,
     220,   221,   222,    -1,   224,   225,    -1,    -1,    -1,   229,
     230,   231,   232,   233,   234,    -1,   236,   237,   238,    -1,
     240,    -1,   242,    -1,    -1,    -1,   246,   247,   248,   249,
      -1,    -1,   252,    -1,   254,   255,    -1,   257,   258,    -1,
      -1,    -1,   262,    -1,    -1,   265,   266,   267,    -1,    -1,
     270,    -1,   272,   273,   274,    -1,    -1,    -1,    -1,    -1,
     280,   281,    -1,   283,    -1,   285,    -1,   287,   288,    -1,
      -1,   291,    -1,    -1,    -1,    -1,   296,   297,   298,   299,
     300,   301,   302,   303,   304,   305,   306,   307,   308,   309,
     310,   311,    -1,   313,   314,   315,   316,   317,   318,   319,
     320,   321,   322,   323,   324,    -1,    -1,    -1,    -1,   329,
     330,   331,   332,   333,   334,    -1,    -1,   337,   338,   339,
     340,    -1,   342,   343,   344,   345,   346,   347,   348,   349,
     350,   351,   352,    -1,   354,   355,   356,    -1,    -1,   359,
     360,   361,   362,   363,   364,   365,   366,   367,    -1,   369,
     370,   371,    -1,   373,   374,   375,    -1,   377,   378,   379,
     380,    -1,   382,   383,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   392,   393,   394,    -1,   396,   397,    -1,   399,
      -1,   401,   402,   403,   404,   405,   406,   407,   408,   409,
     410,   411,    -1,   413,   414,   415,    -1,   417,    -1,   419,
     420,   421,   422,   423,    -1,   425,   426,   427,    -1,    -1,
     430,    -1,    -1,    -1,   434,   435,   436,   437,   438,    -1,
      -1,   441,   442,   443,   444,   445,    -1,   447,   448,    -1,
     450,   451,   452,   453,   454,   455,    -1,   457,    -1,   459,
     460,    -1,   462,   463,    -1,   465,    -1,   467,    -1,   469,
     470,   471,   472,   473,   474,   475,   476,   477,   478,   479,
     480,   481,    -1,   483,   484,    -1,    -1,    -1,   488,   489,
     490,   491,    -1,    -1,    -1,   495,    -1,    -1,    -1,   499,
      -1,   501,   502,   503,   504,   505,   506,    -1,   508,   509,
     510,   511,   512,   513,    -1,    -1,    -1,    -1,    -1,    -1,
     520,   521,    -1,   523,    -1,    -1,   526,    -1,    -1,   529,
     530,    -1,    -1,    -1,   534,   535,   536,   537,   538,    -1,
     540,   541,   542,   543,   544,   545,   546,   547,   548,   549,
     550,   551,   552,   553,   554,    -1,   556,    -1,   558,   559,
     560,   561,    -1,   563,   564,   565,    -1,   567,   568,   569,
     570,    -1,    -1,    -1,    -1,    -1,   576,   577,   578,    -1,
     580,   581,   582,   583,   584,   585,   586,   587,   588,   589,
     590,   591,    -1,   593,   594,    -1,    -1,   597,    -1,    -1,
     600,    -1,   602,    -1,   604,   605,   606,    -1,    -1,   609,
     610,   611,   612,   613,    -1,    -1,   616,   617,    -1,   619,
     620,   621,   622,   623,   624,   625,   626,    -1,    -1,    -1,
      -1,    -1,    -1,   633,   634,    -1,   636,   637,   638,    -1,
      -1,   641,    -1,    -1,    -1,    -1,   646,   647,    -1,    -1,
      -1,    -1,   652,   653,    -1,    -1,   656,   657,    -1,    -1,
     660,   661,     5,    -1,     7,     8,     9,    10,    11,    12,
      -1,    -1,    15,    -1,    -1,    -1,    19,    -1,    -1,    22,
      -1,    24,    25,    26,    27,    28,    29,    30,    31,    -1,
      33,    -1,    -1,    36,    37,    38,    39,    40,    41,    42,
      -1,    44,    45,    46,    -1,    48,    -1,    50,    51,    -1,
      -1,    54,    55,    56,    57,    58,    -1,    60,    61,    62,
      63,    64,    -1,    66,    67,    68,    69,    70,    71,    72,
      -1,    74,    75,    76,    77,    78,    79,    80,    -1,    82,
      83,    84,    85,    86,    87,    88,    89,    -1,    91,    92,
      -1,    94,    95,    96,    97,    98,    -1,   100,   101,   102,
     103,    -1,    -1,   106,   107,   108,   109,   110,   111,    -1,
     113,   114,   115,    -1,   117,   118,   119,   120,   121,   122,
      -1,    -1,    -1,    -1,   127,   128,   129,    -1,    -1,   132,
     133,    -1,   135,    -1,    -1,    -1,   139,    -1,   141,   142,
     143,   144,   145,    -1,    -1,    -1,   149,    -1,    -1,   152,
     153,   154,    -1,    -1,    -1,   158,    -1,   160,   161,    -1,
     163,   164,   165,    -1,    -1,   168,   169,    -1,   171,   172,
     173,   174,   175,   176,   177,   178,    -1,   180,   181,   182,
     183,   184,   185,   186,   187,    -1,   189,   190,   191,   192,
      -1,   194,    -1,    -1,    -1,   198,    -1,   200,    -1,   202,
      -1,   204,   205,   206,   207,   208,   209,   210,    -1,   212,
      -1,   214,    -1,   216,   217,   218,    -1,   220,   221,   222,
      -1,   224,   225,    -1,    -1,    -1,   229,   230,   231,   232,
     233,   234,    -1,   236,   237,   238,    -1,   240,    -1,   242,
      -1,    -1,    -1,   246,   247,   248,   249,    -1,    -1,   252,
      -1,   254,   255,    -1,   257,   258,    -1,    -1,    -1,   262,
      -1,    -1,   265,   266,   267,    -1,    -1,   270,    -1,   272,
     273,   274,    -1,    -1,    -1,    -1,    -1,   280,   281,    -1,
     283,    -1,   285,    -1,   287,   288,    -1,    -1,   291,    -1,
      -1,    -1,    -1,   296,   297,   298,   299,   300,   301,   302,
     303,   304,   305,   306,   307,   308,   309,   310,   311,    -1,
     313,   314,   315,   316,   317,   318,   319,   320,   321,   322,
     323,   324,    -1,    -1,    -1,    -1,   329,   330,   331,   332,
     333,   334,    -1,    -1,   337,   338,   339,   340,    -1,   342,
     343,   344,   345,   346,   347,   348,   349,   350,   351,   352,
      -1,   354,   355,   356,    -1,    -1,   359,   360,   361,   362,
     363,   364,   365,   366,   367,    -1,   369,   370,   371,    -1,
     373,   374,   375,    -1,   377,   378,   379,   380,    -1,   382,
     383,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   392,
     393,   394,    -1,   396,   397,    -1,   399,    -1,   401,   402,
     403,   404,   405,   406,   407,   408,   409,   410,   411,    -1,
     413,   414,   415,    -1,   417,    -1,   419,   420,   421,   422,
     423,    -1,   425,   426,   427,    -1,    -1,   430,    -1,    -1,
      -1,   434,   435,   436,   437,   438,    -1,    -1,   441,   442,
     443,   444,   445,    -1,   447,   448,    -1,   450,   451,   452,
     453,   454,   455,    -1,   457,    -1,   459,   460,    -1,   462,
     463,    -1,   465,    -1,   467,    -1,   469,   470,   471,   472,
     473,   474,   475,   476,   477,   478,   479,   480,   481,    -1,
     483,   484,    -1,    -1,    -1,   488,   489,   490,   491,    -1,
      -1,    -1,   495,    -1,    -1,    -1,   499,    -1,   501,   502,
     503,   504,   505,   506,    -1,   508,   509,   510,   511,   512,
     513,    -1,    -1,    -1,    -1,    -1,    -1,   520,   521,    -1,
     523,    -1,    -1,   526,    -1,    -1,   529,   530,    -1,    -1,
      -1,   534,   535,   536,   537,   538,    -1,   540,   541,   542,
     543,   544,   545,   546,   547,   548,   549,   550,   551,   552,
     553,   554,    -1,   556,    -1,   558,   559,   560,   561,    -1,
     563,   564,   565,    -1,   567,   568,   569,   570,    -1,    -1,
      -1,    -1,    -1,   576,   577,   578,    -1,   580,   581,   582,
     583,   584,   585,   586,   587,   588,   589,   590,   591,    -1,
     593,   594,    -1,    -1,   597,    -1,    -1,   600,    -1,   602,
      -1,   604,   605,   606,    -1,    -1,   609,   610,   611,   612,
     613,    -1,    -1,   616,   617,    -1,   619,   620,   621,   622,
     623,   624,   625,   626,    -1,    -1,    -1,    -1,    -1,    -1,
     633,   634,    -1,   636,   637,   638,    -1,    -1,   641,    -1,
      -1,    -1,    -1,   646,   647,    -1,    -1,    -1,    -1,   652,
     653,    -1,    -1,   656,   657,    -1,    -1,   660,   661,     5,
      -1,     7,     8,     9,    10,    11,    12,    -1,    -1,    15,
      -1,    -1,    -1,    19,    -1,    -1,    22,    -1,    24,    25,
      26,    27,    28,    29,    30,    31,    -1,    33,    -1,    -1,
      36,    37,    38,    39,    40,    41,    42,    -1,    44,    45,
      46,    -1,    48,    -1,    50,    51,    -1,    -1,    54,    55,
      56,    57,    58,    -1,    60,    61,    62,    63,    64,    -1,
      66,    67,    68,    69,    70,    71,    72,    -1,    74,    75,
      76,    77,    78,    79,    80,    -1,    82,    83,    84,    85,
      86,    87,    88,    89,    -1,    91,    92,    -1,    94,    95,
      96,    97,    98,    -1,   100,   101,   102,   103,    -1,    -1,
     106,   107,   108,   109,   110,   111,    -1,   113,   114,   115,
      -1,   117,   118,   119,   120,   121,   122,    -1,    -1,    -1,
      -1,   127,   128,   129,    -1,    -1,   132,   133,    -1,   135,
      -1,    -1,    -1,   139,    -1,   141,   142,   143,   144,   145,
      -1,    -1,    -1,   149,    -1,    -1,   152,   153,   154,    -1,
      -1,    -1,   158,    -1,   160,   161,    -1,   163,   164,   165,
      -1,    -1,   168,   169,    -1,   171,   172,   173,   174,   175,
     176,   177,   178,    -1,   180,   181,   182,   183,   184,   185,
     186,   187,    -1,   189,   190,   191,   192,    -1,   194,    -1,
      -1,    -1,   198,    -1,   200,    -1,   202,    -1,   204,   205,
     206,   207,   208,   209,   210,    -1,   212,    -1,   214,    -1,
     216,   217,   218,    -1,   220,   221,   222,    -1,   224,   225,
      -1,    -1,    -1,   229,   230,   231,   232,   233,   234,    -1,
     236,   237,   238,    -1,   240,    -1,   242,    -1,    -1,    -1,
     246,   247,   248,   249,    -1,    -1,   252,    -1,   254,   255,
      -1,   257,   258,    -1,    -1,    -1,   262,    -1,    -1,   265,
     266,   267,    -1,    -1,   270,    -1,   272,   273,   274,    -1,
      -1,    -1,    -1,    -1,   280,   281,    -1,   283,    -1,   285,
      -1,   287,   288,    -1,    -1,   291,    -1,    -1,    -1,    -1,
     296,   297,   298,   299,   300,   301,   302,   303,   304,   305,
     306,   307,   308,   309,   310,   311,    -1,   313,   314,   315,
     316,   317,   318,   319,   320,   321,   322,   323,   324,    -1,
      -1,    -1,    -1,   329,   330,   331,   332,   333,   334,    -1,
      -1,   337,   338,   339,   340,    -1,   342,   343,   344,   345,
     346,   347,   348,   349,   350,   351,   352,    -1,   354,   355,
     356,    -1,    -1,   359,   360,   361,   362,   363,   364,   365,
     366,   367,    -1,   369,   370,   371,    -1,   373,   374,   375,
      -1,   377,   378,   379,   380,    -1,   382,   383,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   392,   393,   394,    -1,
     396,   397,    -1,   399,    -1,   401,   402,   403,   404,   405,
     406,   407,   408,   409,   410,   411,    -1,   413,   414,   415,
      -1,   417,    -1,   419,   420,   421,   422,   423,    -1,   425,
     426,   427,    -1,    -1,   430,    -1,    -1,    -1,   434,   435,
     436,   437,   438,    -1,    -1,   441,   442,   443,   444,   445,
      -1,   447,   448,    -1,   450,   451,   452,   453,   454,   455,
      -1,   457,    -1,   459,   460,    -1,   462,   463,    -1,   465,
      -1,   467,    -1,   469,   470,   471,   472,   473,   474,   475,
     476,   477,   478,   479,   480,   481,    -1,   483,   484,    -1,
      -1,    -1,   488,   489,   490,   491,    -1,    -1,    -1,   495,
      -1,    -1,    -1,   499,    -1,   501,   502,   503,   504,   505,
     506,    -1,   508,   509,   510,   511,   512,   513,    -1,    -1,
      -1,    -1,    -1,    -1,   520,   521,    -1,   523,    -1,    -1,
     526,    -1,    -1,   529,   530,    -1,    -1,    -1,   534,   535,
     536,   537,   538,    -1,   540,   541,   542,   543,   544,   545,
     546,   547,   548,   549,   550,   551,   552,   553,   554,    -1,
     556,    -1,   558,   559,   560,   561,    -1,   563,   564,   565,
      -1,   567,   568,   569,   570,    -1,    -1,    -1,    -1,    -1,
     576,   577,   578,    -1,   580,   581,   582,   583,   584,   585,
     586,   587,   588,   589,   590,   591,    -1,   593,   594,    -1,
      -1,   597,    -1,    -1,   600,    -1,   602,    -1,   604,   605,
     606,    -1,    -1,   609,   610,   611,   612,   613,    -1,    -1,
     616,   617,    -1,   619,   620,   621,   622,   623,   624,   625,
     626,    -1,    -1,    -1,    -1,    -1,    -1,   633,   634,    -1,
     636,   637,   638,    -1,    -1,   641,    -1,    -1,    -1,    -1,
     646,   647,    -1,    -1,    -1,    -1,   652,   653,    -1,    -1,
     656,   657,    -1,    -1,   660,   661,     5,    -1,     7,     8,
       9,    10,    11,    12,    -1,    -1,    15,    -1,    -1,    -1,
      19,    -1,    -1,    22,    -1,    24,    25,    26,    27,    28,
      29,    30,    31,    -1,    33,    -1,    -1,    36,    37,    38,
      39,    40,    41,    42,    -1,    44,    45,    46,    -1,    48,
      -1,    50,    51,    -1,    -1,    54,    55,    56,    57,    58,
      -1,    60,    61,    62,    63,    64,    -1,    66,    67,    68,
      69,    70,    71,    72,    -1,    74,    75,    76,    77,    78,
      79,    80,    -1,    82,    83,    84,    85,    86,    87,    88,
      89,    -1,    91,    92,    -1,    94,    95,    96,    97,    98,
      -1,   100,   101,   102,   103,    -1,    -1,   106,   107,   108,
     109,   110,   111,    -1,   113,   114,   115,    -1,   117,   118,
     119,   120,   121,   122,    -1,    -1,    -1,    -1,   127,   128,
     129,    -1,    -1,   132,   133,    -1,   135,    -1,    -1,    -1,
     139,    -1,   141,   142,   143,   144,   145,    -1,    -1,    -1,
     149,    -1,    -1,   152,   153,   154,    -1,    -1,    -1,   158,
      -1,   160,   161,    -1,   163,   164,   165,    -1,    -1,   168,
     169,    -1,   171,   172,   173,   174,   175,   176,   177,   178,
      -1,   180,   181,   182,   183,   184,   185,   186,   187,    -1,
     189,   190,   191,   192,    -1,   194,    -1,    -1,    -1,   198,
      -1,   200,    -1,   202,    -1,   204,   205,   206,   207,   208,
     209,   210,    -1,   212,    -1,   214,    -1,   216,   217,   218,
      -1,   220,   221,   222,    -1,   224,   225,    -1,    -1,    -1,
     229,   230,   231,   232,   233,   234,    -1,   236,   237,   238,
      -1,   240,    -1,   242,    -1,    -1,    -1,   246,   247,   248,
     249,    -1,    -1,   252,    -1,   254,   255,    -1,   257,   258,
      -1,    -1,    -1,   262,    -1,    -1,   265,   266,   267,    -1,
      -1,   270,    -1,   272,   273,   274,    -1,    -1,    -1,    -1,
      -1,   280,   281,    -1,   283,    -1,   285,    -1,   287,   288,
      -1,    -1,   291,    -1,    -1,    -1,    -1,   296,   297,   298,
     299,   300,   301,   302,   303,   304,   305,   306,   307,   308,
     309,   310,   311,    -1,   313,   314,   315,   316,   317,   318,
     319,   320,   321,   322,   323,   324,    -1,    -1,    -1,    -1,
     329,   330,   331,   332,   333,   334,    -1,    -1,   337,   338,
     339,   340,    -1,   342,   343,   344,   345,   346,   347,   348,
     349,   350,   351,   352,    -1,   354,   355,   356,    -1,    -1,
     359,   360,   361,   362,   363,   364,   365,   366,   367,    -1,
     369,   370,   371,    -1,   373,   374,   375,    -1,   377,   378,
     379,   380,    -1,   382,   383,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   392,   393,   394,    -1,   396,   397,    -1,
     399,    -1,   401,   402,   403,   404,   405,   406,   407,   408,
     409,   410,   411,    -1,   413,   414,   415,    -1,   417,    -1,
     419,   420,   421,   422,   423,    -1,   425,   426,   427,    -1,
      -1,   430,    -1,    -1,    -1,   434,   435,   436,   437,   438,
      -1,    -1,   441,   442,   443,   444,   445,    -1,   447,   448,
      -1,   450,   451,   452,   453,   454,   455,    -1,   457,    -1,
     459,   460,    -1,   462,   463,    -1,   465,    -1,   467,    -1,
     469,   470,   471,   472,   473,   474,   475,   476,   477,   478,
     479,   480,   481,    -1,   483,   484,    -1,    -1,    -1,   488,
     489,   490,   491,    -1,    -1,    -1,   495,    -1,    -1,    -1,
     499,    -1,   501,   502,   503,   504,   505,   506,    -1,   508,
     509,   510,   511,   512,   513,    -1,    -1,    -1,    -1,    -1,
      -1,   520,   521,    -1,   523,    -1,    -1,   526,    -1,    -1,
     529,   530,    -1,    -1,    -1,   534,   535,   536,   537,   538,
      -1,   540,   541,   542,   543,   544,   545,   546,   547,   548,
     549,   550,   551,   552,   553,   554,    -1,   556,    -1,   558,
     559,   560,   561,    -1,   563,   564,   565,    -1,   567,   568,
     569,   570,    -1,    -1,    -1,    -1,    -1,   576,   577,   578,
      -1,   580,   581,   582,   583,   584,   585,   586,   587,   588,
     589,   590,   591,    -1,   593,   594,    -1,    -1,   597,    -1,
      -1,   600,    -1,   602,    -1,   604,   605,   606,    -1,    -1,
     609,   610,   611,   612,   613,    -1,    -1,   616,   617,    -1,
     619,   620,   621,   622,   623,   624,   625,   626,    -1,    -1,
      -1,    -1,    -1,    -1,   633,   634,    -1,   636,   637,   638,
      -1,    -1,   641,    -1,    -1,    -1,    -1,   646,   647,    -1,
      -1,    -1,    -1,   652,   653,    -1,    -1,   656,   657,    -1,
      -1,   660,   661,     5,    -1,     7,     8,     9,    10,    11,
      12,    -1,    -1,    15,    -1,    -1,    -1,    19,    -1,    -1,
      22,    -1,    24,    25,    26,    27,    28,    29,    30,    31,
      -1,    33,    -1,    -1,    36,    37,    38,    39,    40,    41,
      42,    -1,    44,    45,    46,    -1,    48,    -1,    50,    51,
      -1,    -1,    54,    55,    56,    57,    58,    -1,    60,    61,
      62,    63,    64,    -1,    66,    67,    68,    69,    70,    71,
      72,    -1,    74,    75,    76,    77,    78,    79,    80,    -1,
      82,    83,    84,    85,    86,    87,    88,    89,    -1,    91,
      92,    -1,    94,    95,    96,    97,    98,    -1,   100,   101,
     102,   103,    -1,    -1,   106,   107,   108,   109,   110,   111,
      -1,   113,   114,   115,    -1,   117,   118,   119,   120,   121,
     122,    -1,    -1,    -1,    -1,   127,   128,   129,    -1,    -1,
     132,   133,    -1,   135,    -1,    -1,    -1,   139,    -1,   141,
     142,   143,   144,   145,    -1,    -1,    -1,   149,    -1,    -1,
     152,   153,   154,    -1,    -1,    -1,   158,    -1,   160,   161,
      -1,   163,   164,   165,    -1,    -1,   168,   169,    -1,   171,
     172,   173,   174,   175,   176,   177,   178,    -1,   180,   181,
     182,   183,   184,   185,   186,   187,    -1,   189,   190,   191,
     192,    -1,   194,    -1,    -1,    -1,   198,    -1,   200,    -1,
     202,    -1,   204,   205,   206,   207,   208,   209,   210,    -1,
     212,    -1,   214,    -1,   216,   217,   218,    -1,   220,   221,
     222,    -1,   224,   225,    -1,    -1,    -1,   229,   230,   231,
     232,   233,   234,    -1,   236,   237,   238,    -1,   240,    -1,
     242,    -1,    -1,    -1,   246,   247,   248,   249,    -1,    -1,
     252,    -1,   254,   255,    -1,   257,   258,    -1,    -1,    -1,
     262,    -1,    -1,   265,   266,   267,    -1,    -1,   270,    -1,
     272,   273,   274,    -1,    -1,    -1,    -1,    -1,   280,   281,
      -1,   283,    -1,   285,    -1,   287,   288,    -1,    -1,   291,
      -1,    -1,    -1,    -1,   296,   297,   298,   299,   300,   301,
     302,   303,   304,   305,   306,   307,   308,   309,   310,   311,
      -1,   313,   314,   315,   316,   317,   318,   319,   320,   321,
     322,   323,   324,   325,    -1,    -1,    -1,   329,   330,   331,
     332,   333,   334,    -1,    -1,   337,   338,   339,   340,    -1,
     342,   343,   344,   345,   346,   347,   348,   349,   350,   351,
     352,    -1,   354,   355,   356,    -1,    -1,   359,   360,   361,
     362,   363,    -1,   365,   366,   367,    -1,   369,   370,   371,
      -1,   373,   374,   375,    -1,   377,   378,   379,   380,    -1,
     382,   383,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     392,   393,   394,    -1,   396,   397,    -1,   399,    -1,   401,
     402,   403,   404,   405,   406,   407,   408,   409,   410,   411,
      -1,   413,   414,   415,    -1,   417,    -1,   419,   420,   421,
     422,   423,    -1,   425,   426,   427,    -1,    -1,   430,    -1,
      -1,    -1,   434,   435,   436,   437,   438,    -1,    -1,   441,
     442,   443,   444,   445,    -1,   447,   448,    -1,   450,   451,
     452,   453,   454,   455,    -1,   457,    -1,   459,   460,    -1,
     462,   463,    -1,   465,    -1,   467,    -1,   469,   470,   471,
     472,   473,   474,   475,   476,   477,   478,   479,   480,   481,
      -1,   483,   484,    -1,    -1,    -1,   488,   489,   490,   491,
      -1,    -1,    -1,   495,    -1,    -1,    -1,   499,    -1,   501,
     502,   503,   504,   505,   506,    -1,   508,   509,   510,   511,
     512,   513,    -1,    -1,    -1,    -1,    -1,    -1,   520,   521,
      -1,   523,    -1,    -1,   526,    -1,    -1,   529,   530,    -1,
      -1,    -1,   534,   535,   536,   537,   538,    -1,   540,   541,
     542,   543,   544,   545,   546,   547,   548,   549,   550,   551,
     552,   553,   554,    -1,   556,    -1,   558,   559,   560,   561,
      -1,   563,   564,   565,    -1,   567,   568,   569,   570,    -1,
      -1,    -1,    -1,    -1,   576,   577,   578,    -1,   580,   581,
     582,   583,   584,   585,   586,   587,   588,   589,   590,   591,
      -1,   593,   594,    -1,    -1,   597,    -1,    -1,   600,    -1,
     602,    -1,   604,   605,   606,    -1,    -1,   609,   610,   611,
     612,   613,    -1,    -1,   616,   617,    -1,   619,   620,   621,
     622,   623,   624,   625,   626,    -1,    -1,    -1,    -1,    -1,
      -1,   633,   634,    -1,   636,   637,   638,    -1,    -1,   641,
      -1,    -1,    -1,    -1,   646,   647,    -1,    -1,    -1,    -1,
     652,   653,    -1,    -1,   656,   657,    -1,    -1,   660,   661,
       5,    -1,     7,     8,     9,    10,    11,    12,    -1,    -1,
      15,    -1,    -1,    -1,    19,    -1,    -1,    22,    -1,    24,
      25,    26,    27,    28,    29,    30,    31,    -1,    33,    -1,
      -1,    36,    37,    38,    39,    40,    41,    42,    -1,    44,
      45,    46,    -1,    48,    -1,    50,    51,    -1,    -1,    54,
      55,    56,    57,    58,    -1,    60,    61,    62,    63,    64,
      -1,    66,    67,    68,    69,    70,    71,    72,    -1,    74,
      75,    76,    77,    78,    79,    80,    -1,    82,    83,    84,
      85,    86,    87,    88,    89,    -1,    91,    92,    -1,    94,
      95,    96,    97,    98,    -1,   100,   101,   102,   103,    -1,
      -1,   106,   107,   108,   109,   110,   111,    -1,   113,   114,
     115,    -1,   117,   118,   119,   120,   121,   122,    -1,    -1,
      -1,    -1,   127,   128,   129,    -1,    -1,   132,   133,    -1,
     135,    -1,    -1,    -1,   139,    -1,   141,   142,   143,   144,
     145,    -1,    -1,    -1,   149,    -1,    -1,   152,   153,   154,
      -1,    -1,    -1,   158,    -1,   160,   161,    -1,   163,   164,
     165,    -1,    -1,   168,   169,    -1,   171,   172,   173,   174,
     175,   176,   177,   178,    -1,   180,   181,   182,   183,   184,
     185,   186,   187,    -1,   189,   190,   191,   192,    -1,   194,
      -1,    -1,    -1,   198,    -1,   200,    -1,   202,    -1,   204,
     205,   206,   207,   208,   209,   210,    -1,   212,    -1,   214,
      -1,   216,   217,   218,    -1,   220,   221,   222,    -1,   224,
     225,    -1,    -1,    -1,   229,   230,   231,   232,   233,   234,
      -1,   236,   237,   238,    -1,   240,    -1,   242,    -1,    -1,
      -1,   246,   247,   248,   249,    -1,    -1,   252,    -1,   254,
     255,    -1,   257,   258,    -1,    -1,    -1,   262,    -1,    -1,
     265,   266,   267,    -1,    -1,   270,    -1,   272,   273,   274,
      -1,    -1,    -1,    -1,    -1,   280,   281,    -1,   283,    -1,
     285,    -1,   287,   288,    -1,    -1,   291,    -1,    -1,    -1,
      -1,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,    -1,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
      -1,    -1,    -1,    -1,   329,   330,   331,   332,   333,   334,
      -1,    -1,   337,   338,   339,   340,    -1,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,    -1,   354,
     355,   356,    -1,    -1,   359,   360,   361,   362,   363,    -1,
     365,   366,   367,    -1,   369,   370,   371,    -1,   373,   374,
     375,    -1,   377,   378,   379,   380,    -1,   382,   383,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   392,   393,   394,
      -1,   396,   397,    -1,   399,    -1,   401,   402,   403,   404,
     405,   406,   407,   408,   409,   410,   411,    -1,   413,   414,
     415,    -1,   417,    -1,   419,   420,   421,   422,   423,    -1,
     425,   426,   427,    -1,    -1,   430,    -1,    -1,    -1,   434,
     435,   436,   437,   438,    -1,    -1,   441,   442,   443,   444,
     445,    -1,   447,   448,    -1,   450,   451,   452,   453,   454,
     455,    -1,   457,    -1,   459,   460,    -1,   462,   463,    -1,
     465,    -1,   467,    -1,   469,   470,   471,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,    -1,   483,   484,
      -1,    -1,    -1,   488,   489,   490,   491,    -1,    -1,    -1,
     495,    -1,    -1,    -1,   499,    -1,   501,   502,   503,   504,
     505,   506,    -1,   508,   509,   510,   511,   512,   513,    -1,
      -1,    -1,    -1,    -1,    -1,   520,   521,    -1,   523,    -1,
      -1,   526,    -1,    -1,   529,   530,    -1,    -1,    -1,   534,
     535,   536,   537,   538,    -1,   540,   541,   542,   543,   544,
     545,   546,   547,   548,   549,   550,   551,   552,   553,   554,
      -1,   556,    -1,   558,   559,   560,   561,    -1,   563,   564,
     565,    -1,   567,   568,   569,   570,    -1,    -1,    -1,    -1,
      -1,   576,   577,   578,    -1,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,    -1,   593,   594,
      -1,    -1,   597,    -1,    -1,   600,    -1,   602,    -1,   604,
     605,   606,    -1,    -1,   609,   610,   611,   612,   613,    -1,
      -1,   616,   617,    -1,   619,   620,   621,   622,   623,   624,
     625,   626,    -1,    -1,    -1,    -1,    -1,    -1,   633,   634,
      -1,   636,   637,   638,    -1,    -1,   641,    -1,    -1,    -1,
      -1,   646,   647,    -1,    -1,    -1,    -1,   652,   653,    -1,
      -1,   656,   657,    -1,    -1,   660,   661,     5,    -1,     7,
       8,     9,    10,    11,    12,    -1,    -1,    15,    -1,    -1,
      -1,    19,    -1,    -1,    22,    -1,    24,    25,    26,    27,
      28,    29,    30,    31,    -1,    33,    -1,    -1,    36,    37,
      38,    39,    40,    41,    42,    -1,    44,    45,    46,    -1,
      48,    -1,    50,    51,    -1,    -1,    54,    55,    56,    57,
      58,    -1,    60,    61,    62,    63,    64,    -1,    66,    67,
      68,    69,    70,    71,    72,    -1,    74,    75,    76,    77,
      78,    79,    80,    -1,    82,    83,    84,    85,    86,    87,
      88,    89,    -1,    91,    92,    -1,    94,    95,    96,    97,
      98,    -1,   100,   101,   102,   103,    -1,    -1,   106,   107,
     108,   109,   110,   111,    -1,   113,   114,   115,    -1,   117,
     118,   119,   120,   121,   122,    -1,    -1,    -1,    -1,   127,
     128,   129,    -1,    -1,   132,   133,    -1,   135,    -1,    -1,
      -1,   139,    -1,   141,   142,   143,   144,   145,    -1,    -1,
      -1,   149,    -1,    -1,   152,   153,   154,    -1,    -1,    -1,
     158,    -1,   160,   161,    -1,   163,   164,   165,    -1,    -1,
     168,   169,    -1,   171,   172,   173,   174,   175,   176,   177,
     178,    -1,   180,   181,   182,   183,   184,   185,   186,   187,
      -1,   189,   190,   191,   192,    -1,   194,    -1,    -1,    -1,
     198,    -1,   200,    -1,   202,    -1,   204,   205,   206,   207,
     208,   209,   210,    -1,   212,    -1,   214,    -1,   216,   217,
     218,    -1,   220,   221,   222,    -1,   224,   225,    -1,    -1,
      -1,   229,   230,   231,   232,   233,   234,    -1,   236,   237,
     238,    -1,   240,    -1,   242,    -1,    -1,    -1,   246,   247,
     248,   249,    -1,    -1,   252,    -1,   254,   255,    -1,   257,
     258,    -1,    -1,    -1,   262,    -1,    -1,   265,   266,   267,
      -1,    -1,   270,    -1,   272,   273,   274,    -1,    -1,    -1,
      -1,    -1,   280,   281,    -1,   283,    -1,   285,    -1,   287,
     288,    -1,    -1,   291,    -1,    -1,    -1,    -1,   296,   297,
     298,   299,   300,   301,   302,   303,   304,   305,   306,   307,
     308,   309,   310,   311,    -1,   313,   314,   315,   316,   317,
     318,   319,   320,   321,   322,   323,   324,    -1,    -1,    -1,
      -1,   329,   330,   331,   332,   333,   334,    -1,    -1,   337,
     338,   339,   340,    -1,   342,   343,   344,   345,   346,   347,
     348,   349,   350,   351,   352,    -1,   354,   355,   356,    -1,
      -1,   359,   360,   361,   362,   363,    -1,   365,   366,   367,
      -1,   369,   370,   371,    -1,   373,   374,   375,    -1,   377,
     378,   379,   380,    -1,   382,   383,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   392,   393,   394,    -1,   396,   397,
      -1,   399,    -1,   401,   402,   403,   404,   405,   406,   407,
     408,   409,   410,   411,    -1,   413,   414,   415,    -1,   417,
      -1,   419,   420,   421,   422,   423,    -1,   425,   426,   427,
      -1,    -1,   430,    -1,    -1,    -1,   434,   435,   436,   437,
     438,    -1,    -1,   441,   442,   443,   444,   445,    -1,   447,
     448,    -1,   450,   451,   452,   453,   454,   455,    -1,   457,
      -1,   459,   460,    -1,   462,   463,    -1,   465,    -1,   467,
      -1,   469,   470,   471,   472,   473,   474,   475,   476,   477,
     478,   479,   480,   481,    -1,   483,   484,    -1,    -1,    -1,
     488,   489,   490,   491,    -1,    -1,    -1,   495,    -1,    -1,
      -1,   499,    -1,   501,   502,   503,   504,   505,   506,    -1,
     508,   509,   510,   511,   512,   513,    -1,    -1,    -1,    -1,
      -1,    -1,   520,   521,    -1,   523,    -1,    -1,   526,    -1,
      -1,   529,   530,    -1,    -1,    -1,   534,   535,   536,   537,
     538,    -1,   540,   541,   542,   543,   544,   545,   546,   547,
     548,   549,   550,   551,   552,   553,   554,    -1,   556,    -1,
     558,   559,   560,   561,    -1,   563,   564,   565,    -1,   567,
     568,   569,   570,    -1,    -1,    -1,    -1,    -1,   576,   577,
     578,    -1,   580,   581,   582,   583,   584,   585,   586,   587,
     588,   589,   590,   591,    -1,   593,   594,    -1,    -1,   597,
      -1,    -1,   600,    -1,   602,    -1,   604,   605,   606,    -1,
      -1,   609,   610,   611,   612,   613,    -1,    -1,   616,   617,
      -1,   619,   620,   621,   622,   623,   624,   625,   626,    -1,
      -1,    -1,    -1,    -1,    -1,   633,   634,    -1,   636,   637,
     638,    -1,    -1,   641,    -1,    -1,    -1,    -1,   646,   647,
      -1,    -1,    -1,    -1,   652,   653,    -1,    -1,   656,   657,
      -1,    -1,   660,   661,     5,    -1,     7,     8,     9,    10,
      11,    12,    -1,    -1,    15,    -1,    -1,    -1,    19,    -1,
      -1,    22,    -1,    24,    25,    26,    27,    28,    29,    30,
      31,    -1,    33,    -1,    -1,    36,    37,    38,    39,    40,
      41,    42,    -1,    44,    45,    46,    -1,    48,    -1,    50,
      51,    -1,    -1,    54,    55,    56,    57,    58,    -1,    60,
      61,    62,    63,    64,    -1,    66,    67,    68,    69,    70,
      71,    72,    -1,    74,    75,    76,    77,    78,    79,    80,
      -1,    82,    83,    84,    85,    86,    87,    88,    89,    -1,
      91,    92,    -1,    94,    95,    96,    97,    98,    -1,   100,
     101,   102,   103,    -1,    -1,   106,   107,   108,   109,   110,
     111,    -1,   113,   114,   115,    -1,   117,   118,   119,   120,
     121,   122,    -1,    -1,    -1,    -1,   127,   128,   129,    -1,
      -1,   132,   133,    -1,   135,    -1,    -1,    -1,   139,    -1,
     141,   142,   143,   144,   145,    -1,    -1,    -1,   149,    -1,
      -1,   152,   153,   154,    -1,    -1,    -1,   158,    -1,   160,
     161,    -1,   163,   164,   165,    -1,    -1,   168,   169,    -1,
     171,   172,   173,   174,   175,   176,   177,   178,    -1,   180,
     181,   182,   183,   184,   185,   186,   187,    -1,   189,   190,
     191,   192,    -1,   194,    -1,    -1,    -1,   198,    -1,   200,
      -1,   202,    -1,   204,   205,   206,   207,   208,   209,   210,
      -1,   212,    -1,   214,    -1,   216,   217,   218,    -1,   220,
     221,   222,    -1,   224,   225,    -1,    -1,    -1,   229,   230,
     231,   232,   233,   234,    -1,   236,   237,   238,    -1,   240,
      -1,   242,    -1,    -1,    -1,   246,   247,   248,   249,    -1,
      -1,   252,    -1,   254,   255,    -1,   257,   258,    -1,    -1,
      -1,   262,    -1,    -1,   265,   266,   267,    -1,    -1,   270,
      -1,   272,   273,   274,    -1,    -1,    -1,    -1,    -1,   280,
     281,    -1,   283,    -1,   285,    -1,   287,   288,    -1,    -1,
     291,    -1,    -1,    -1,    -1,   296,   297,   298,   299,   300,
     301,   302,   303,   304,   305,   306,   307,   308,   309,   310,
     311,    -1,   313,   314,   315,   316,   317,   318,   319,   320,
     321,   322,   323,   324,    -1,    -1,    -1,    -1,   329,   330,
     331,   332,   333,   334,    -1,    -1,   337,   338,   339,   340,
      -1,   342,   343,   344,   345,   346,   347,   348,   349,   350,
     351,   352,    -1,   354,   355,   356,    -1,    -1,   359,   360,
     361,   362,   363,    -1,   365,   366,   367,    -1,   369,   370,
     371,    -1,   373,   374,   375,    -1,   377,   378,   379,   380,
      -1,   382,   383,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   392,   393,   394,    -1,   396,   397,    -1,   399,    -1,
     401,   402,   403,   404,   405,   406,   407,   408,   409,   410,
     411,    -1,   413,   414,   415,    -1,   417,    -1,   419,   420,
     421,   422,   423,    -1,   425,   426,   427,    -1,    -1,   430,
      -1,    -1,    -1,   434,   435,   436,   437,   438,    -1,    -1,
     441,   442,   443,   444,   445,    -1,   447,   448,    -1,   450,
     451,   452,   453,   454,   455,    -1,   457,    -1,   459,   460,
      -1,   462,   463,    -1,   465,    -1,   467,    -1,   469,   470,
     471,   472,   473,   474,   475,   476,   477,   478,   479,   480,
     481,    -1,   483,   484,    -1,    -1,    -1,   488,   489,   490,
     491,    -1,    -1,    -1,   495,    -1,    -1,    -1,   499,    -1,
     501,   502,   503,   504,   505,   506,    -1,   508,   509,   510,
     511,   512,   513,    -1,    -1,    -1,    -1,    -1,    -1,   520,
     521,    -1,   523,    -1,    -1,   526,    -1,    -1,   529,   530,
      -1,    -1,    -1,   534,   535,   536,   537,   538,    -1,   540,
     541,   542,   543,   544,   545,   546,   547,   548,   549,   550,
     551,   552,   553,   554,    -1,   556,    -1,   558,   559,   560,
     561,    -1,   563,   564,   565,    -1,   567,   568,   569,   570,
      -1,    -1,    -1,    -1,    -1,   576,   577,   578,    -1,   580,
     581,   582,   583,   584,   585,   586,   587,   588,   589,   590,
     591,    -1,   593,   594,    -1,    -1,   597,    -1,    -1,   600,
      -1,   602,    -1,   604,   605,   606,    -1,    -1,   609,   610,
     611,   612,   613,    -1,    -1,   616,   617,    -1,   619,   620,
     621,   622,   623,   624,   625,   626,    -1,    -1,    -1,    -1,
      -1,    -1,   633,   634,    -1,   636,   637,   638,    -1,    -1,
     641,    -1,    -1,    -1,    -1,   646,   647,    -1,    -1,    -1,
      -1,   652,   653,    -1,    -1,   656,   657,    -1,    -1,   660,
     661,     5,    -1,     7,     8,     9,    10,    11,    12,    -1,
      -1,    15,    -1,    -1,    -1,    19,    -1,    -1,    22,    -1,
      24,    25,    26,    27,    28,    29,    30,    31,    -1,    33,
      -1,    -1,    -1,    37,    38,    -1,    -1,    41,    -1,    -1,
      44,    45,    46,    -1,    48,    -1,    50,    51,    -1,    -1,
      54,    -1,    -1,    57,    58,    -1,    60,    61,    -1,    63,
      64,    -1,    66,    67,    68,    69,    70,    71,    72,    -1,
      74,    75,    76,    77,    78,    79,    80,    -1,    82,    83,
      84,    85,    86,    87,    88,    89,    -1,    91,    92,    -1,
      94,    95,    96,    97,    98,    -1,   100,    -1,    -1,   103,
      -1,    -1,   106,    -1,   108,    -1,    -1,   111,    -1,   113,
      -1,    -1,    -1,   117,   118,   119,    -1,    -1,   122,    -1,
      -1,    -1,    -1,   127,   128,   129,    -1,    -1,    -1,   133,
      -1,   135,    -1,    -1,    -1,   139,    -1,   141,   142,   143,
     144,   145,    -1,    -1,    -1,   149,    -1,    -1,   152,   153,
     154,    -1,    -1,    -1,   158,    -1,   160,   161,    -1,   163,
     164,   165,    -1,    -1,   168,   169,    -1,   171,   172,   173,
     174,   175,   176,   177,    -1,    -1,   180,   181,   182,   183,
      -1,   185,   186,   187,    -1,   189,   190,   191,   192,    -1,
     194,    -1,    -1,    -1,   198,    -1,   200,    -1,   202,    -1,
     204,   205,   206,   207,   208,   209,   210,    -1,   212,    -1,
      -1,    -1,   216,   217,   218,    -1,   220,   221,   222,    -1,
     224,   225,    -1,    -1,    -1,   229,   230,   231,   232,   233,
      -1,    -1,   236,   237,   238,    -1,   240,    -1,   242,    -1,
      -1,    -1,    -1,   247,   248,    -1,    -1,    -1,   252,    -1,
     254,   255,    -1,   257,   258,    -1,    -1,    -1,   262,    -1,
      -1,   265,   266,   267,    -1,    -1,   270,    -1,    -1,   273,
     274,    -1,    -1,    -1,    -1,    -1,   280,   281,    -1,   283,
      -1,   285,    -1,   287,   288,    -1,    -1,   291,    -1,    -1,
      -1,    -1,   296,   297,   298,   299,   300,   301,   302,   303,
     304,   305,   306,   307,   308,   309,   310,   311,    -1,   313,
     314,   315,   316,    -1,   318,   319,   320,   321,    -1,   323,
     324,    -1,    -1,    -1,    -1,   329,   330,   331,   332,   333,
     334,    -1,    -1,   337,   338,    -1,   340,    -1,   342,    -1,
     344,   345,   346,   347,   348,   349,   350,   351,   352,    -1,
     354,   355,   356,    -1,    -1,   359,   360,   361,   362,    -1,
      -1,    -1,   366,   367,    -1,   369,   370,   371,    -1,   373,
     374,   375,    -1,   377,   378,   379,   380,    -1,   382,   383,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   392,   393,
     394,    -1,    -1,   397,    -1,   399,    -1,   401,   402,   403,
     404,   405,   406,   407,   408,   409,   410,    -1,    -1,   413,
     414,   415,    -1,   417,    -1,   419,   420,   421,   422,   423,
      -1,   425,   426,   427,    -1,    -1,   430,    -1,    -1,    -1,
     434,   435,   436,   437,   438,    -1,    -1,   441,   442,   443,
     444,   445,    -1,   447,   448,    -1,   450,   451,   452,    -1,
      -1,   455,    -1,   457,    -1,   459,   460,    -1,   462,   463,
      -1,   465,    -1,   467,    -1,    -1,   470,   471,   472,   473,
     474,   475,   476,   477,   478,   479,   480,   481,    -1,   483,
     484,    -1,    -1,    -1,   488,   489,   490,   491,    -1,    -1,
      -1,   495,    -1,    -1,    -1,   499,    -1,   501,   502,   503,
     504,   505,   506,    -1,   508,   509,   510,   511,   512,   513,
      -1,    -1,    -1,    -1,    -1,    -1,   520,   521,    -1,   523,
      -1,    -1,   526,    -1,    -1,   529,   530,    -1,    -1,    -1,
     534,    -1,    -1,   537,   538,    -1,   540,   541,   542,   543,
     544,   545,    -1,    -1,   548,   549,   550,   551,    -1,   553,
     554,    -1,   556,    -1,   558,   559,   560,   561,    -1,   563,
     564,   565,    -1,   567,   568,   569,   570,    -1,    -1,    -1,
      -1,    -1,   576,   577,   578,    -1,    -1,   581,   582,   583,
     584,   585,   586,   587,   588,   589,   590,   591,    -1,   593,
     594,    -1,    -1,   597,    -1,    -1,   600,    -1,   602,    -1,
     604,   605,   606,    -1,    -1,    -1,    -1,    -1,    -1,   613,
      -1,    -1,   616,    -1,    -1,    -1,   620,   621,   622,   623,
     624,   625,   626,    -1,    -1,    -1,    -1,    -1,    -1,   633,
     634,    -1,   636,   637,   638,    -1,    -1,   641,    -1,    -1,
      -1,     5,    -1,     7,     8,     9,    10,    11,    12,    -1,
      -1,    15,    -1,    -1,    -1,    19,   660,   661,    22,    -1,
      24,    25,    26,    27,    28,    29,    30,    31,    -1,    33,
      -1,    -1,    -1,    37,    -1,    -1,    -1,    41,    -1,    -1,
      44,    45,    46,    -1,    48,    -1,    50,    51,    -1,    -1,
      54,    -1,    -1,    57,    58,    -1,    60,    61,    -1,    63,
      64,    -1,    66,    67,    68,    69,    70,    71,    72,    -1,
      74,    75,    76,    77,    78,    79,    80,    -1,    82,    83,
      84,    85,    86,    87,    88,    89,    -1,    91,    92,    93,
      94,    95,    96,    97,    98,    -1,   100,    -1,    -1,   103,
      -1,    -1,   106,    -1,   108,    -1,    -1,   111,    -1,   113,
      -1,    -1,    -1,   117,   118,   119,    -1,    -1,   122,    -1,
      -1,    -1,    -1,   127,   128,    -1,    -1,    -1,    -1,   133,
      -1,   135,    -1,    -1,    -1,   139,    -1,   141,   142,   143,
     144,   145,    -1,    -1,    -1,   149,    -1,    -1,   152,   153,
     154,    -1,    -1,    -1,   158,    -1,   160,   161,    -1,   163,
     164,   165,    -1,    -1,   168,   169,    -1,   171,   172,   173,
     174,   175,   176,   177,    -1,    -1,   180,   181,   182,   183,
      -1,    -1,   186,   187,    -1,   189,   190,   191,    -1,    -1,
     194,    -1,    -1,    -1,   198,    -1,   200,   201,   202,    -1,
     204,   205,   206,   207,   208,   209,   210,    -1,   212,    -1,
      -1,    -1,   216,   217,   218,    -1,   220,    -1,    -1,    -1,
     224,   225,    -1,    -1,    -1,   229,   230,   231,   232,   233,
      -1,    -1,   236,   237,   238,   239,   240,    -1,   242,    -1,
      -1,    -1,    -1,   247,   248,    -1,    -1,    -1,   252,    -1,
     254,   255,    -1,   257,   258,    -1,    -1,    -1,   262,   263,
      -1,   265,   266,   267,    -1,    -1,   270,    -1,    -1,   273,
     274,    -1,   276,    -1,    -1,    -1,   280,   281,    -1,   283,
      -1,   285,    -1,   287,   288,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   296,   297,   298,   299,   300,   301,   302,   303,
     304,   305,   306,   307,   308,   309,   310,   311,    -1,   313,
     314,   315,   316,    -1,   318,   319,   320,   321,    -1,   323,
     324,    -1,    -1,    -1,    -1,   329,   330,   331,   332,   333,
     334,    -1,    -1,   337,   338,    -1,   340,    -1,   342,    -1,
     344,   345,   346,   347,   348,   349,   350,   351,   352,    -1,
      -1,   355,   356,    -1,    -1,   359,   360,   361,   362,    -1,
      -1,    -1,   366,   367,    -1,    -1,    -1,   371,    -1,   373,
     374,   375,    -1,   377,   378,   379,   380,    -1,   382,   383,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   392,   393,
     394,    -1,    -1,   397,    -1,   399,    -1,   401,   402,   403,
     404,   405,   406,   407,   408,   409,   410,    -1,    -1,   413,
     414,   415,    -1,   417,    -1,   419,   420,   421,   422,   423,
      -1,   425,   426,   427,    -1,    -1,   430,    -1,    -1,    -1,
     434,   435,   436,   437,   438,    -1,    -1,   441,   442,   443,
     444,   445,    -1,   447,   448,    -1,   450,   451,   452,    -1,
      -1,   455,    -1,   457,    -1,   459,   460,    -1,   462,   463,
      -1,   465,    -1,   467,    -1,    -1,   470,   471,   472,   473,
     474,   475,   476,   477,   478,   479,   480,   481,    -1,   483,
     484,   485,    -1,    -1,   488,   489,   490,   491,    -1,    -1,
      -1,   495,    -1,    -1,    -1,   499,    -1,   501,   502,   503,
     504,   505,   506,    -1,   508,   509,   510,   511,   512,   513,
     514,    -1,    -1,    -1,    -1,    -1,   520,   521,    -1,   523,
      -1,    -1,   526,    -1,    -1,   529,   530,    -1,    -1,    -1,
     534,    -1,    -1,   537,   538,    -1,   540,   541,   542,   543,
     544,   545,    -1,    -1,   548,   549,   550,   551,    -1,   553,
     554,    -1,   556,    -1,   558,   559,   560,   561,    -1,    -1,
     564,   565,    -1,   567,   568,   569,   570,    -1,    -1,    -1,
      -1,    -1,   576,   577,   578,    -1,    -1,    -1,   582,   583,
     584,   585,    -1,   587,   588,    -1,   590,   591,    -1,   593,
     594,    -1,    -1,   597,    -1,    -1,   600,    -1,   602,    -1,
     604,   605,   606,    -1,    -1,    -1,    -1,    -1,    -1,   613,
      -1,    -1,   616,    -1,    -1,    -1,   620,   621,   622,   623,
     624,   625,   626,    -1,    -1,    -1,    -1,    -1,    -1,   633,
     634,    -1,   636,   637,   638,    -1,    -1,   641,    -1,     5,
      -1,     7,     8,     9,    10,    11,    12,    -1,    -1,    15,
      -1,    -1,    -1,    19,    -1,    -1,    22,   661,    24,    25,
      26,    27,    28,    29,    30,    31,    -1,    33,    -1,    -1,
      -1,    37,    -1,    -1,    -1,    41,    -1,    -1,    44,    45,
      46,    -1,    48,    -1,    50,    51,    -1,    -1,    54,    -1,
      -1,    57,    58,    -1,    60,    61,    -1,    63,    64,    -1,
      66,    67,    68,    69,    70,    71,    72,    -1,    74,    75,
      76,    77,    78,    79,    80,    -1,    82,    83,    84,    85,
      86,    87,    88,    89,    -1,    91,    92,    93,    94,    95,
      96,    97,    98,    -1,   100,    -1,    -1,   103,    -1,    -1,
     106,    -1,   108,    -1,    -1,   111,    -1,   113,    -1,    -1,
      -1,   117,   118,   119,    -1,    -1,   122,    -1,    -1,    -1,
      -1,   127,   128,    -1,    -1,    -1,    -1,   133,    -1,   135,
      -1,    -1,    -1,   139,    -1,   141,   142,   143,   144,   145,
      -1,    -1,    -1,   149,    -1,    -1,   152,   153,   154,    -1,
      -1,    -1,   158,    -1,   160,   161,    -1,   163,   164,   165,
      -1,    -1,   168,   169,    -1,   171,   172,   173,   174,   175,
     176,   177,    -1,    -1,   180,   181,   182,   183,    -1,    -1,
     186,   187,    -1,   189,   190,   191,    -1,    -1,   194,    -1,
      -1,    -1,   198,    -1,   200,   201,   202,    -1,   204,   205,
     206,   207,   208,   209,   210,    -1,   212,    -1,    -1,    -1,
     216,   217,   218,    -1,   220,    -1,    -1,    -1,   224,   225,
      -1,    -1,    -1,   229,   230,   231,   232,   233,    -1,    -1,
     236,   237,   238,   239,   240,    -1,   242,    -1,    -1,    -1,
      -1,   247,   248,    -1,    -1,    -1,   252,    -1,   254,   255,
      -1,   257,   258,    -1,    -1,    -1,   262,   263,    -1,   265,
     266,   267,    -1,    -1,   270,    -1,    -1,   273,   274,    -1,
      -1,    -1,    -1,    -1,   280,   281,    -1,   283,    -1,   285,
      -1,   287,   288,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     296,   297,   298,   299,   300,   301,   302,   303,   304,   305,
     306,   307,   308,   309,   310,   311,    -1,   313,   314,   315,
     316,    -1,   318,   319,   320,   321,    -1,   323,   324,    -1,
      -1,    -1,    -1,   329,   330,   331,   332,   333,   334,    -1,
      -1,   337,   338,    -1,   340,    -1,   342,    -1,   344,   345,
     346,   347,   348,   349,   350,   351,   352,    -1,    -1,   355,
     356,    -1,    -1,   359,   360,   361,   362,    -1,    -1,    -1,
     366,   367,    -1,    -1,    -1,   371,    -1,   373,   374,   375,
      -1,   377,   378,   379,   380,    -1,   382,   383,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   392,   393,   394,    -1,
      -1,   397,    -1,   399,    -1,   401,   402,   403,   404,   405,
     406,   407,   408,   409,   410,    -1,    -1,   413,   414,   415,
      -1,   417,    -1,   419,   420,   421,   422,   423,    -1,   425,
     426,   427,    -1,    -1,   430,    -1,    -1,    -1,   434,   435,
     436,   437,   438,    -1,    -1,   441,   442,   443,   444,   445,
      -1,   447,   448,    -1,   450,   451,   452,    -1,    -1,   455,
      -1,   457,    -1,   459,   460,    -1,   462,   463,    -1,   465,
      -1,   467,    -1,    -1,   470,   471,   472,   473,   474,   475,
     476,   477,   478,   479,   480,   481,    -1,   483,   484,    -1,
      -1,    -1,   488,   489,   490,   491,    -1,    -1,    -1,   495,
      -1,    -1,    -1,   499,    -1,   501,   502,   503,   504,   505,
     506,    -1,   508,   509,   510,   511,   512,   513,   514,    -1,
      -1,    -1,    -1,    -1,   520,   521,    -1,   523,    -1,    -1,
     526,    -1,    -1,   529,   530,    -1,    -1,    -1,   534,    -1,
      -1,   537,   538,    -1,   540,   541,   542,   543,   544,   545,
      -1,    -1,   548,   549,   550,   551,    -1,   553,   554,    -1,
     556,    -1,   558,   559,   560,   561,    -1,    -1,   564,   565,
      -1,   567,   568,   569,   570,    -1,    -1,    -1,    -1,    -1,
     576,   577,   578,    -1,    -1,    -1,   582,   583,   584,   585,
      -1,   587,   588,    -1,   590,   591,    -1,   593,   594,    -1,
      -1,   597,    -1,    -1,   600,    -1,   602,    -1,   604,   605,
     606,    -1,    -1,    -1,    -1,    -1,    -1,   613,    -1,    -1,
     616,    -1,    -1,    -1,   620,   621,   622,   623,   624,   625,
     626,    -1,    -1,    -1,    -1,    -1,    -1,   633,   634,    -1,
     636,   637,   638,    -1,    -1,   641,    -1,     5,    -1,     7,
       8,     9,    10,    11,    12,    -1,    -1,    15,    -1,    -1,
      -1,    19,    -1,    -1,    22,   661,    24,    25,    26,    27,
      28,    29,    30,    31,    -1,    33,    -1,    -1,    -1,    37,
      -1,    -1,    -1,    41,    -1,    -1,    44,    45,    46,    -1,
      48,    -1,    50,    51,    -1,    -1,    54,    -1,    -1,    57,
      58,    -1,    60,    61,    -1,    63,    64,    -1,    66,    67,
      68,    69,    70,    71,    72,    -1,    74,    75,    76,    77,
      78,    79,    80,    -1,    82,    83,    84,    85,    86,    87,
      88,    89,    -1,    91,    92,    -1,    94,    95,    96,    97,
      98,    -1,   100,    -1,    -1,   103,    -1,    -1,   106,    -1,
     108,    -1,    -1,   111,    -1,   113,    -1,    -1,    -1,   117,
     118,   119,    -1,    -1,   122,    -1,    -1,    -1,    -1,   127,
     128,    -1,    -1,    -1,    -1,   133,    -1,   135,    -1,    -1,
      -1,   139,    -1,   141,   142,   143,   144,   145,    -1,    -1,
      -1,   149,    -1,    -1,   152,   153,   154,    -1,    -1,    -1,
     158,    -1,   160,   161,    -1,   163,   164,   165,    -1,    -1,
     168,   169,    -1,   171,   172,   173,   174,   175,   176,   177,
      -1,    -1,   180,   181,   182,   183,    -1,    -1,   186,   187,
      -1,   189,   190,   191,    -1,    -1,   194,    -1,    -1,    -1,
     198,    -1,   200,    -1,   202,    -1,   204,   205,   206,   207,
     208,   209,   210,    -1,   212,    -1,    -1,    -1,   216,   217,
     218,    -1,   220,    -1,    -1,    -1,   224,   225,    -1,    -1,
      -1,   229,   230,   231,   232,   233,    -1,    -1,   236,   237,
     238,    -1,   240,    -1,   242,    -1,    -1,    -1,    -1,   247,
     248,    -1,    -1,    -1,   252,    -1,   254,   255,    -1,   257,
     258,    -1,    -1,    -1,   262,    -1,    -1,   265,   266,   267,
      -1,    -1,   270,    -1,    -1,   273,   274,    -1,    -1,    -1,
      -1,    -1,   280,   281,    -1,   283,    -1,   285,    -1,   287,
     288,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   296,   297,
     298,   299,   300,   301,   302,   303,   304,   305,   306,   307,
     308,   309,   310,   311,    -1,   313,   314,   315,   316,    -1,
     318,   319,   320,   321,    -1,   323,   324,    -1,    -1,    -1,
      -1,   329,   330,   331,   332,   333,   334,    -1,    -1,   337,
     338,    -1,   340,    -1,   342,    -1,   344,   345,   346,   347,
     348,   349,   350,   351,   352,    -1,    -1,   355,   356,    -1,
      -1,   359,   360,   361,   362,    -1,    -1,    -1,   366,   367,
      -1,    -1,    -1,   371,    -1,   373,   374,   375,    -1,   377,
     378,   379,   380,    -1,   382,   383,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   392,   393,   394,    -1,    -1,   397,
      -1,   399,    -1,   401,   402,   403,   404,   405,   406,   407,
     408,   409,   410,    -1,    -1,   413,   414,   415,    -1,   417,
      -1,   419,   420,   421,   422,   423,    -1,   425,   426,   427,
      -1,    -1,   430,    -1,    -1,    -1,   434,   435,   436,   437,
     438,    -1,    -1,   441,   442,   443,   444,   445,    -1,   447,
     448,    -1,   450,   451,   452,    -1,    -1,   455,    -1,   457,
      -1,   459,   460,    -1,   462,   463,    -1,   465,    -1,   467,
      -1,    -1,   470,   471,   472,   473,   474,   475,   476,   477,
     478,   479,   480,   481,    -1,   483,   484,   485,    -1,    -1,
     488,   489,   490,   491,    -1,    -1,    -1,   495,    -1,    -1,
      -1,   499,    -1,   501,   502,   503,   504,   505,   506,    -1,
     508,   509,   510,   511,   512,   513,    -1,    -1,    -1,    -1,
      -1,    -1,   520,   521,    -1,   523,    -1,    -1,   526,    -1,
      -1,   529,   530,    -1,    -1,    -1,   534,    -1,    -1,   537,
     538,    -1,   540,   541,   542,   543,   544,   545,    -1,    -1,
     548,   549,   550,   551,    -1,   553,   554,    -1,   556,    -1,
     558,   559,   560,   561,    -1,    -1,   564,   565,    -1,   567,
     568,   569,   570,    -1,    -1,    -1,    -1,    -1,   576,   577,
     578,    -1,    -1,    -1,   582,   583,   584,   585,    -1,   587,
     588,    -1,   590,   591,    -1,   593,   594,    -1,    -1,   597,
      -1,    -1,   600,    -1,   602,    -1,   604,   605,   606,    -1,
      -1,    -1,    -1,    -1,    -1,   613,    -1,    -1,   616,    -1,
      -1,    -1,   620,   621,   622,   623,   624,   625,   626,    -1,
      -1,    -1,    -1,    -1,    -1,   633,   634,    -1,   636,   637,
     638,    -1,    -1,   641,    -1,     5,    -1,     7,     8,     9,
      10,    11,    12,    -1,    -1,    15,   654,    -1,    -1,    19,
      -1,    -1,    22,   661,    24,    25,    26,    27,    28,    29,
      30,    31,    -1,    33,    -1,    -1,    -1,    37,    -1,    -1,
      -1,    41,    -1,    -1,    44,    45,    46,    -1,    48,    -1,
      50,    51,    -1,    -1,    54,    -1,    -1,    57,    58,    -1,
      60,    61,    -1,    63,    64,    -1,    66,    67,    68,    69,
      70,    71,    72,    -1,    74,    75,    76,    77,    78,    79,
      80,    -1,    82,    83,    84,    85,    86,    87,    88,    89,
      -1,    91,    92,    -1,    94,    95,    96,    97,    98,    -1,
     100,    -1,    -1,   103,    -1,    -1,   106,    -1,   108,    -1,
      -1,   111,    -1,   113,    -1,    -1,    -1,   117,   118,   119,
      -1,    -1,   122,    -1,    -1,    -1,    -1,   127,   128,    -1,
      -1,    -1,    -1,   133,    -1,   135,    -1,    -1,    -1,   139,
      -1,   141,   142,   143,   144,   145,    -1,    -1,    -1,   149,
      -1,    -1,   152,   153,   154,    -1,    -1,    -1,   158,    -1,
     160,   161,    -1,   163,   164,   165,    -1,    -1,   168,   169,
      -1,   171,   172,   173,   174,   175,   176,   177,    -1,    -1,
     180,   181,   182,   183,    -1,    -1,   186,   187,    -1,   189,
     190,   191,    -1,    -1,   194,    -1,    -1,    -1,   198,    -1,
     200,    -1,   202,    -1,   204,   205,   206,   207,   208,   209,
     210,    -1,   212,    -1,    -1,    -1,   216,   217,   218,    -1,
     220,    -1,    -1,    -1,   224,   225,    -1,    -1,    -1,   229,
     230,   231,   232,   233,    -1,    -1,   236,   237,   238,    -1,
     240,    -1,   242,    -1,    -1,    -1,    -1,   247,   248,    -1,
      -1,    -1,   252,    -1,   254,   255,    -1,   257,   258,    -1,
      -1,    -1,   262,    -1,    -1,   265,   266,   267,    -1,    -1,
     270,    -1,    -1,   273,   274,    -1,    -1,    -1,    -1,    -1,
     280,   281,    -1,   283,    -1,   285,    -1,   287,   288,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   296,   297,   298,   299,
     300,   301,   302,   303,   304,   305,   306,   307,   308,   309,
     310,   311,    -1,   313,   314,   315,   316,    -1,   318,   319,
     320,   321,    -1,   323,   324,    -1,    -1,    -1,    -1,   329,
     330,   331,   332,   333,   334,    -1,    -1,   337,   338,    -1,
     340,    -1,   342,    -1,   344,   345,   346,   347,   348,   349,
     350,   351,   352,    -1,    -1,   355,   356,    -1,    -1,   359,
     360,   361,   362,    -1,    -1,    -1,   366,   367,    -1,    -1,
      -1,   371,    -1,   373,   374,   375,    -1,   377,   378,   379,
     380,    -1,   382,   383,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   392,   393,   394,    -1,    -1,   397,    -1,   399,
      -1,   401,   402,   403,   404,   405,   406,   407,   408,   409,
     410,    -1,    -1,   413,   414,   415,    -1,   417,    -1,   419,
     420,   421,   422,   423,    -1,   425,   426,   427,    -1,    -1,
     430,    -1,    -1,    -1,   434,   435,   436,   437,   438,    -1,
      -1,   441,   442,   443,   444,   445,    -1,   447,   448,    -1,
     450,   451,   452,    -1,    -1,   455,    -1,   457,    -1,   459,
     460,    -1,   462,   463,    -1,   465,    -1,   467,    -1,    -1,
     470,   471,   472,   473,   474,   475,   476,   477,   478,   479,
     480,   481,    -1,   483,   484,    -1,    -1,    -1,   488,   489,
     490,   491,    -1,    -1,    -1,   495,    -1,    -1,    -1,   499,
      -1,   501,   502,   503,   504,   505,   506,    -1,   508,   509,
     510,   511,   512,   513,    -1,    -1,    -1,    -1,    -1,    -1,
     520,   521,    -1,   523,    -1,    -1,   526,    -1,    -1,   529,
     530,    -1,    -1,    -1,   534,    -1,    -1,   537,   538,    -1,
     540,   541,   542,   543,   544,   545,    -1,    -1,   548,   549,
     550,   551,    -1,   553,   554,    -1,   556,    -1,   558,   559,
     560,   561,    -1,    -1,   564,   565,    -1,   567,   568,   569,
     570,    -1,    -1,    -1,    -1,    -1,   576,   577,   578,    -1,
      -1,    -1,   582,   583,   584,   585,    -1,   587,   588,    -1,
     590,   591,    -1,   593,   594,    -1,    -1,   597,    -1,    -1,
     600,    -1,   602,    -1,   604,   605,   606,    -1,    -1,    -1,
      -1,    -1,    -1,   613,    -1,    -1,   616,    -1,    -1,    -1,
     620,   621,   622,   623,   624,   625,   626,    -1,    -1,    -1,
      -1,    -1,    -1,   633,   634,    -1,   636,   637,   638,    -1,
      -1,   641,    -1,    -1,    -1,     5,    -1,     7,     8,     9,
      10,    11,    12,    -1,   654,    15,    -1,    -1,    -1,    19,
     660,   661,    22,    -1,    24,    25,    26,    27,    28,    29,
      30,    31,    -1,    33,    -1,    -1,    -1,    37,    -1,    -1,
      -1,    41,    -1,    -1,    44,    45,    46,    -1,    48,    -1,
      50,    51,    -1,    -1,    54,    -1,    -1,    57,    58,    -1,
      60,    61,    -1,    63,    64,    -1,    66,    67,    68,    69,
      70,    71,    72,    -1,    74,    75,    76,    77,    78,    79,
      80,    -1,    82,    83,    84,    85,    86,    87,    88,    89,
      -1,    91,    92,    -1,    94,    95,    96,    97,    98,    -1,
     100,    -1,    -1,   103,    -1,    -1,   106,    -1,   108,    -1,
      -1,   111,    -1,   113,    -1,    -1,    -1,   117,   118,   119,
      -1,    -1,   122,    -1,    -1,    -1,    -1,   127,   128,    -1,
      -1,    -1,    -1,   133,    -1,   135,    -1,    -1,    -1,   139,
      -1,   141,   142,   143,   144,   145,    -1,    -1,    -1,   149,
      -1,    -1,   152,   153,   154,    -1,    -1,    -1,   158,    -1,
     160,   161,    -1,   163,   164,   165,    -1,    -1,   168,   169,
      -1,   171,   172,   173,   174,   175,   176,   177,    -1,    -1,
     180,   181,   182,   183,    -1,    -1,   186,   187,    -1,   189,
     190,   191,    -1,    -1,   194,    -1,    -1,    -1,   198,    -1,
     200,    -1,   202,    -1,   204,   205,   206,   207,   208,   209,
     210,    -1,   212,    -1,    -1,    -1,   216,   217,   218,    -1,
     220,    -1,    -1,    -1,   224,   225,    -1,    -1,    -1,   229,
     230,   231,   232,   233,    -1,    -1,   236,   237,   238,    -1,
     240,    -1,   242,    -1,    -1,    -1,    -1,   247,   248,    -1,
      -1,    -1,   252,    -1,   254,   255,    -1,   257,   258,    -1,
      -1,    -1,   262,    -1,    -1,   265,   266,   267,    -1,    -1,
     270,    -1,    -1,   273,   274,    -1,    -1,    -1,    -1,    -1,
     280,   281,    -1,   283,    -1,   285,    -1,   287,   288,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   296,   297,   298,   299,
     300,   301,   302,   303,   304,   305,   306,   307,   308,   309,
     310,   311,    -1,   313,   314,   315,   316,    -1,   318,   319,
     320,   321,    -1,   323,   324,    -1,    -1,    -1,    -1,   329,
     330,   331,   332,   333,   334,    -1,    -1,   337,   338,    -1,
     340,    -1,   342,    -1,   344,   345,   346,   347,   348,   349,
     350,   351,   352,    -1,    -1,   355,   356,    -1,    -1,   359,
     360,   361,   362,    -1,    -1,    -1,   366,   367,    -1,    -1,
      -1,   371,    -1,   373,   374,   375,    -1,   377,   378,   379,
     380,    -1,   382,   383,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   392,   393,   394,    -1,    -1,   397,    -1,   399,
      -1,   401,   402,   403,   404,   405,   406,   407,   408,   409,
     410,    -1,    -1,   413,   414,   415,    -1,   417,    -1,   419,
     420,   421,   422,   423,    -1,   425,   426,   427,    -1,    -1,
     430,    -1,    -1,    -1,   434,   435,   436,   437,   438,    -1,
      -1,   441,   442,   443,   444,   445,    -1,   447,   448,    -1,
     450,   451,   452,    -1,    -1,   455,    -1,   457,    -1,   459,
     460,    -1,   462,   463,    -1,   465,    -1,   467,    -1,    -1,
     470,   471,   472,   473,   474,   475,   476,   477,   478,   479,
     480,   481,    -1,   483,   484,    -1,    -1,    -1,   488,   489,
     490,   491,    -1,    -1,    -1,   495,    -1,    -1,    -1,   499,
      -1,   501,   502,   503,   504,   505,   506,    -1,   508,   509,
     510,   511,   512,   513,    -1,    -1,    -1,    -1,    -1,    -1,
     520,   521,    -1,   523,    -1,    -1,   526,    -1,    -1,   529,
     530,    -1,    -1,    -1,   534,    -1,    -1,   537,   538,    -1,
     540,   541,   542,   543,   544,   545,    -1,    -1,   548,   549,
     550,   551,    -1,   553,   554,    -1,   556,    -1,   558,   559,
     560,   561,    -1,    -1,   564,   565,    -1,   567,   568,   569,
     570,    -1,    -1,    -1,    -1,    -1,   576,   577,   578,    -1,
      -1,    -1,   582,   583,   584,   585,    -1,   587,   588,    -1,
     590,   591,    -1,   593,   594,    -1,    -1,   597,    -1,    -1,
     600,    -1,   602,    -1,   604,   605,   606,    -1,    -1,    -1,
      -1,    -1,    -1,   613,    -1,    -1,   616,    -1,    -1,    -1,
     620,   621,   622,   623,   624,   625,   626,    -1,    -1,    -1,
      -1,    -1,    -1,   633,   634,    -1,   636,   637,   638,    -1,
      -1,   641,    -1,    -1,    -1,     5,    -1,     7,     8,     9,
      10,    11,    12,   653,    -1,    15,    -1,    -1,    -1,    19,
      -1,   661,    22,    -1,    24,    25,    26,    27,    28,    29,
      30,    31,    -1,    33,    -1,    -1,    -1,    37,    -1,    -1,
      -1,    41,    -1,    -1,    44,    45,    46,    -1,    48,    -1,
      50,    51,    -1,    -1,    54,    -1,    -1,    57,    58,    -1,
      60,    61,    -1,    63,    64,    -1,    66,    67,    68,    69,
      70,    71,    72,    -1,    74,    75,    76,    77,    78,    79,
      80,    -1,    82,    83,    84,    85,    86,    87,    88,    89,
      -1,    91,    92,    -1,    94,    95,    96,    97,    98,    -1,
     100,    -1,    -1,   103,    -1,    -1,   106,    -1,   108,    -1,
      -1,   111,    -1,   113,    -1,    -1,    -1,   117,   118,   119,
      -1,    -1,   122,    -1,    -1,    -1,    -1,   127,   128,    -1,
      -1,    -1,    -1,   133,    -1,   135,    -1,    -1,    -1,   139,
      -1,   141,   142,   143,   144,   145,    -1,    -1,    -1,   149,
      -1,    -1,   152,   153,   154,    -1,    -1,    -1,   158,    -1,
     160,   161,    -1,   163,   164,   165,    -1,    -1,   168,   169,
      -1,   171,   172,   173,   174,   175,   176,   177,    -1,    -1,
     180,   181,   182,   183,    -1,    -1,   186,   187,    -1,   189,
     190,   191,    -1,    -1,   194,    -1,    -1,    -1,   198,    -1,
     200,    -1,   202,    -1,   204,   205,   206,   207,   208,   209,
     210,    -1,   212,    -1,    -1,    -1,   216,   217,   218,    -1,
     220,    -1,    -1,    -1,   224,   225,    -1,    -1,    -1,   229,
     230,   231,   232,   233,    -1,    -1,   236,   237,   238,    -1,
     240,    -1,   242,    -1,    -1,    -1,    -1,   247,   248,    -1,
     250,    -1,   252,    -1,   254,   255,    -1,   257,   258,    -1,
      -1,    -1,   262,    -1,    -1,   265,   266,   267,    -1,    -1,
     270,    -1,    -1,   273,   274,    -1,    -1,    -1,    -1,    -1,
     280,   281,    -1,   283,    -1,   285,    -1,   287,   288,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   296,   297,   298,   299,
     300,   301,   302,   303,   304,   305,   306,   307,   308,   309,
     310,   311,    -1,   313,   314,   315,   316,    -1,   318,   319,
     320,   321,    -1,   323,   324,    -1,    -1,    -1,    -1,   329,
     330,   331,   332,   333,   334,    -1,    -1,   337,   338,    -1,
     340,    -1,   342,    -1,   344,   345,   346,   347,   348,   349,
     350,   351,   352,    -1,    -1,   355,   356,    -1,    -1,   359,
     360,   361,   362,    -1,    -1,    -1,   366,   367,    -1,    -1,
      -1,   371,    -1,   373,   374,   375,    -1,   377,   378,   379,
     380,    -1,   382,   383,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   392,   393,   394,    -1,    -1,   397,    -1,   399,
      -1,   401,   402,   403,   404,   405,   406,   407,   408,   409,
     410,    -1,    -1,   413,   414,   415,    -1,   417,    -1,   419,
     420,   421,   422,   423,    -1,   425,   426,   427,    -1,    -1,
     430,    -1,    -1,    -1,   434,   435,   436,   437,   438,    -1,
      -1,   441,   442,   443,   444,   445,    -1,   447,   448,    -1,
     450,   451,   452,    -1,    -1,   455,    -1,   457,    -1,   459,
     460,    -1,   462,   463,    -1,   465,    -1,   467,    -1,    -1,
     470,   471,   472,   473,   474,   475,   476,   477,   478,   479,
     480,   481,    -1,   483,   484,    -1,    -1,    -1,   488,   489,
     490,   491,    -1,    -1,    -1,   495,    -1,    -1,    -1,   499,
      -1,   501,   502,   503,   504,   505,   506,    -1,   508,   509,
     510,   511,   512,   513,    -1,    -1,    -1,    -1,    -1,    -1,
     520,   521,    -1,   523,    -1,    -1,   526,    -1,    -1,   529,
     530,    -1,    -1,    -1,   534,    -1,    -1,   537,   538,    -1,
     540,   541,   542,   543,   544,   545,    -1,    -1,   548,   549,
     550,   551,    -1,   553,   554,    -1,   556,    -1,   558,   559,
     560,   561,    -1,    -1,   564,   565,    -1,   567,   568,   569,
     570,    -1,    -1,    -1,    -1,    -1,   576,   577,   578,    -1,
      -1,    -1,   582,   583,   584,   585,    -1,   587,   588,    -1,
     590,   591,    -1,   593,   594,    -1,    -1,   597,    -1,    -1,
     600,    -1,   602,    -1,   604,   605,   606,    -1,    -1,    -1,
      -1,    -1,    -1,   613,    -1,    -1,   616,    -1,    -1,    -1,
     620,   621,   622,   623,   624,   625,   626,    -1,    -1,    -1,
      -1,    -1,    -1,   633,   634,    -1,   636,   637,   638,    -1,
      -1,   641,    -1,     5,    -1,     7,     8,     9,    10,    11,
      12,    -1,    -1,    15,    -1,    -1,    -1,    19,    -1,    -1,
      22,   661,    24,    25,    26,    27,    28,    29,    30,    31,
      -1,    33,    -1,    -1,    -1,    37,    -1,    -1,    -1,    41,
      -1,    -1,    44,    45,    46,    -1,    48,    -1,    50,    51,
      -1,    -1,    54,    -1,    -1,    57,    58,    -1,    60,    61,
      -1,    63,    64,    -1,    66,    67,    68,    69,    70,    71,
      72,    -1,    74,    75,    76,    77,    78,    79,    80,    -1,
      82,    83,    84,    85,    86,    87,    88,    89,    -1,    91,
      92,    -1,    94,    95,    96,    97,    98,    -1,   100,    -1,
      -1,   103,    -1,    -1,   106,    -1,   108,    -1,    -1,   111,
      -1,   113,    -1,    -1,    -1,   117,   118,   119,    -1,    -1,
     122,    -1,    -1,    -1,    -1,   127,   128,    -1,    -1,    -1,
      -1,   133,    -1,   135,    -1,    -1,    -1,   139,    -1,   141,
     142,   143,   144,   145,    -1,    -1,    -1,   149,    -1,    -1,
     152,   153,   154,    -1,    -1,    -1,   158,    -1,   160,   161,
      -1,   163,   164,   165,    -1,    -1,   168,   169,    -1,   171,
     172,   173,   174,   175,   176,   177,    -1,    -1,   180,   181,
     182,   183,    -1,    -1,   186,   187,    -1,   189,   190,   191,
      -1,    -1,   194,    -1,    -1,    -1,   198,    -1,   200,    -1,
     202,    -1,   204,   205,   206,   207,   208,   209,   210,    -1,
     212,    -1,    -1,    -1,   216,   217,   218,    -1,   220,    -1,
      -1,    -1,   224,   225,    -1,    -1,    -1,   229,   230,   231,
     232,   233,    -1,    -1,   236,   237,   238,    -1,   240,    -1,
     242,    -1,    -1,    -1,    -1,   247,   248,    -1,    -1,    -1,
     252,    -1,   254,   255,    -1,   257,   258,    -1,    -1,    -1,
     262,    -1,    -1,   265,   266,   267,    -1,    -1,   270,    -1,
      -1,   273,   274,    -1,    -1,    -1,    -1,    -1,   280,   281,
      -1,   283,    -1,   285,    -1,   287,   288,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   296,   297,   298,   299,   300,   301,
     302,   303,   304,   305,   306,   307,   308,   309,   310,   311,
      -1,   313,   314,   315,   316,    -1,   318,   319,   320,   321,
      -1,   323,   324,    -1,    -1,    -1,    -1,   329,   330,   331,
     332,   333,   334,    -1,    -1,   337,   338,    -1,   340,    -1,
     342,    -1,   344,   345,   346,   347,   348,   349,   350,   351,
     352,    -1,    -1,   355,   356,    -1,    -1,   359,   360,   361,
     362,    -1,    -1,    -1,   366,   367,    -1,    -1,    -1,   371,
      -1,   373,   374,   375,    -1,   377,   378,   379,   380,    -1,
     382,   383,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     392,   393,   394,    -1,    -1,   397,    -1,   399,    -1,   401,
     402,   403,   404,   405,   406,   407,   408,   409,   410,    -1,
      -1,   413,   414,   415,    -1,   417,    -1,   419,   420,   421,
     422,   423,    -1,   425,   426,   427,    -1,    -1,   430,    -1,
      -1,    -1,   434,   435,   436,   437,   438,    -1,    -1,   441,
     442,   443,   444,   445,    -1,   447,   448,    -1,   450,   451,
     452,    -1,    -1,   455,    -1,   457,    -1,   459,   460,    -1,
     462,   463,    -1,   465,    -1,   467,    -1,    -1,   470,   471,
     472,   473,   474,   475,   476,   477,   478,   479,   480,   481,
      -1,   483,   484,    -1,    -1,    -1,   488,   489,   490,   491,
      -1,    -1,    -1,   495,    -1,    -1,    -1,   499,    -1,   501,
     502,   503,   504,   505,   506,    -1,   508,   509,   510,   511,
     512,   513,    -1,    -1,    -1,    -1,    -1,    -1,   520,   521,
      -1,   523,    -1,    -1,   526,    -1,    -1,   529,   530,    -1,
      -1,    -1,   534,    -1,    -1,   537,   538,    -1,   540,   541,
     542,   543,   544,   545,    -1,    -1,   548,   549,   550,   551,
      -1,   553,   554,    -1,   556,    -1,   558,   559,   560,   561,
      -1,    -1,   564,   565,    -1,   567,   568,   569,   570,    -1,
      -1,    -1,    -1,    -1,   576,   577,   578,    -1,    -1,    -1,
     582,   583,   584,   585,    -1,   587,   588,    -1,   590,   591,
      -1,   593,   594,    -1,    -1,   597,    -1,    -1,   600,    -1,
     602,    -1,   604,   605,   606,    -1,    -1,    -1,    -1,    -1,
      -1,   613,    -1,    -1,   616,    -1,    -1,    -1,   620,   621,
     622,   623,   624,   625,   626,    -1,    -1,    -1,    -1,    -1,
      -1,   633,   634,    -1,   636,   637,   638,    -1,    -1,   641,
      -1,    -1,    -1,    -1,    -1,    -1,   648,     5,    -1,     7,
       8,     9,    10,    11,    12,    -1,    -1,    15,    -1,   661,
      -1,    19,    -1,    -1,    22,    -1,    24,    25,    26,    27,
      28,    29,    30,    31,    -1,    33,    -1,    -1,    -1,    37,
      -1,    -1,    -1,    41,    -1,    -1,    44,    45,    46,    -1,
      48,    -1,    50,    51,    -1,    -1,    54,    -1,    -1,    57,
      58,    -1,    60,    61,    -1,    63,    64,    -1,    66,    67,
      68,    69,    70,    71,    72,    -1,    74,    75,    76,    77,
      78,    79,    80,    -1,    82,    83,    84,    85,    86,    87,
      88,    89,    -1,    91,    92,    -1,    94,    95,    96,    97,
      98,    -1,   100,    -1,    -1,   103,    -1,    -1,   106,    -1,
     108,    -1,    -1,   111,    -1,   113,    -1,    -1,    -1,   117,
     118,   119,    -1,    -1,   122,    -1,    -1,    -1,    -1,   127,
     128,    -1,    -1,    -1,    -1,   133,    -1,   135,    -1,    -1,
      -1,   139,    -1,   141,   142,   143,   144,   145,    -1,    -1,
      -1,   149,    -1,    -1,   152,   153,   154,    -1,    -1,    -1,
     158,    -1,   160,   161,    -1,   163,   164,   165,    -1,    -1,
     168,   169,    -1,   171,   172,   173,   174,   175,   176,   177,
      -1,    -1,   180,   181,   182,   183,    -1,    -1,   186,   187,
      -1,   189,   190,   191,    -1,    -1,   194,    -1,    -1,    -1,
     198,    -1,   200,    -1,   202,    -1,   204,   205,   206,   207,
     208,   209,   210,    -1,   212,    -1,    -1,    -1,   216,   217,
     218,    -1,   220,    -1,    -1,    -1,   224,   225,    -1,    -1,
      -1,   229,   230,   231,   232,   233,    -1,    -1,   236,   237,
     238,    -1,   240,    -1,   242,    -1,    -1,    -1,    -1,   247,
     248,    -1,    -1,    -1,   252,    -1,   254,   255,    -1,   257,
     258,    -1,    -1,    -1,   262,    -1,    -1,   265,   266,   267,
      -1,    -1,   270,    -1,    -1,   273,   274,    -1,    -1,    -1,
      -1,    -1,   280,   281,    -1,   283,    -1,   285,    -1,   287,
     288,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   296,   297,
     298,   299,   300,   301,   302,   303,   304,   305,   306,   307,
     308,   309,   310,   311,    -1,   313,   314,   315,   316,    -1,
     318,   319,   320,   321,    -1,   323,   324,    -1,    -1,    -1,
      -1,   329,   330,   331,   332,   333,   334,    -1,    -1,   337,
     338,    -1,   340,    -1,   342,    -1,   344,   345,   346,   347,
     348,   349,   350,   351,   352,    -1,    -1,   355,   356,    -1,
      -1,   359,   360,   361,   362,    -1,    -1,    -1,   366,   367,
      -1,    -1,    -1,   371,    -1,   373,   374,   375,    -1,   377,
     378,   379,   380,    -1,   382,   383,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   392,   393,   394,    -1,    -1,   397,
      -1,   399,    -1,   401,   402,   403,   404,   405,   406,   407,
     408,   409,   410,    -1,    -1,   413,   414,   415,    -1,   417,
      -1,   419,   420,   421,   422,   423,    -1,   425,   426,   427,
      -1,    -1,   430,    -1,    -1,    -1,   434,   435,   436,   437,
     438,    -1,    -1,   441,   442,   443,   444,   445,    -1,   447,
     448,    -1,   450,   451,   452,    -1,    -1,   455,    -1,   457,
      -1,   459,   460,    -1,   462,   463,    -1,   465,    -1,   467,
      -1,    -1,   470,   471,   472,   473,   474,   475,   476,   477,
     478,   479,   480,   481,    -1,   483,   484,    -1,    -1,    -1,
     488,   489,   490,   491,    -1,    -1,    -1,   495,    -1,    -1,
      -1,   499,    -1,   501,   502,   503,   504,   505,   506,    -1,
     508,   509,   510,   511,   512,   513,    -1,    -1,    -1,    -1,
      -1,    -1,   520,   521,    -1,   523,    -1,    -1,   526,    -1,
      -1,   529,   530,    -1,    -1,    -1,   534,    -1,    -1,   537,
     538,    -1,   540,   541,   542,   543,   544,   545,    -1,    -1,
     548,   549,   550,   551,    -1,   553,   554,    -1,   556,    -1,
     558,   559,   560,   561,    -1,    -1,   564,   565,    -1,   567,
     568,   569,   570,    -1,    -1,    -1,    -1,    -1,   576,   577,
     578,    -1,    -1,    -1,   582,   583,   584,   585,    -1,   587,
     588,    -1,   590,   591,    -1,   593,   594,    -1,    -1,   597,
      -1,    -1,   600,    -1,   602,    -1,   604,   605,   606,    -1,
      -1,    -1,    -1,    -1,    -1,   613,    -1,    -1,   616,    -1,
      -1,    -1,   620,   621,   622,   623,   624,   625,   626,    -1,
      -1,    -1,    -1,    -1,    -1,   633,   634,    -1,   636,   637,
     638,    -1,    -1,   641,    -1,    -1,    -1,     5,    -1,     7,
       8,     9,    10,    11,    12,   653,    -1,    15,    -1,    -1,
      -1,    19,    -1,   661,    22,    -1,    24,    25,    26,    27,
      28,    29,    30,    31,    -1,    33,    -1,    -1,    -1,    37,
      -1,    -1,    -1,    41,    -1,    -1,    44,    45,    46,    -1,
      48,    -1,    50,    51,    -1,    -1,    54,    -1,    -1,    57,
      58,    -1,    60,    61,    -1,    63,    64,    -1,    66,    67,
      68,    69,    70,    71,    72,    -1,    74,    75,    76,    77,
      78,    79,    80,    -1,    82,    83,    84,    85,    86,    87,
      88,    89,    -1,    91,    92,    -1,    94,    95,    96,    97,
      98,    -1,   100,    -1,    -1,   103,    -1,    -1,   106,    -1,
     108,    -1,    -1,   111,    -1,   113,    -1,    -1,    -1,   117,
     118,   119,    -1,    -1,   122,    -1,    -1,    -1,    -1,   127,
     128,    -1,    -1,    -1,    -1,   133,    -1,   135,    -1,    -1,
      -1,   139,    -1,   141,   142,   143,   144,   145,    -1,    -1,
      -1,   149,    -1,    -1,   152,   153,   154,    -1,    -1,    -1,
     158,    -1,   160,   161,    -1,   163,   164,   165,    -1,    -1,
     168,   169,    -1,   171,   172,   173,   174,   175,   176,   177,
      -1,    -1,   180,   181,   182,   183,    -1,    -1,   186,   187,
      -1,   189,   190,   191,    -1,    -1,   194,    -1,    -1,    -1,
     198,    -1,   200,    -1,   202,    -1,   204,   205,   206,   207,
     208,   209,   210,    -1,   212,    -1,    -1,    -1,   216,   217,
     218,    -1,   220,    -1,    -1,    -1,   224,   225,    -1,    -1,
      -1,   229,   230,   231,   232,   233,    -1,    -1,   236,   237,
     238,    -1,   240,    -1,   242,    -1,    -1,    -1,    -1,   247,
     248,    -1,    -1,    -1,   252,    -1,   254,   255,    -1,   257,
     258,    -1,    -1,    -1,   262,    -1,    -1,   265,   266,   267,
      -1,    -1,   270,    -1,    -1,   273,   274,    -1,    -1,    -1,
      -1,    -1,   280,   281,    -1,   283,    -1,   285,    -1,   287,
     288,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   296,   297,
     298,   299,   300,   301,   302,   303,   304,   305,   306,   307,
     308,   309,   310,   311,    -1,   313,   314,   315,   316,    -1,
     318,   319,   320,   321,    -1,   323,   324,    -1,    -1,    -1,
      -1,   329,   330,   331,   332,   333,   334,    -1,    -1,   337,
     338,    -1,   340,    -1,   342,    -1,   344,   345,   346,   347,
     348,   349,   350,   351,   352,    -1,    -1,   355,   356,    -1,
      -1,   359,   360,   361,   362,    -1,    -1,    -1,   366,   367,
      -1,    -1,    -1,   371,    -1,   373,   374,   375,    -1,   377,
     378,   379,   380,    -1,   382,   383,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   392,   393,  