
/* A Bison parser, made by GNU Bison 2.4.1.  */

/* Skeleton implementation for Bison's Yacc-like parsers in C
   
      Copyright (C) 1984, 1989, 1990, 2000, 2001, 2002, 2003, 2004, 2005, 2006
   Free Software Foundation, Inc.
   
   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.  */

/* As a special exception, you may create a larger work that contains
   part or all of the Bison parser skeleton and distribute that work
   under terms of your choice, so long as that work isn't itself a
   parser generator using the skeleton or a modified version thereof
   as a parser skeleton.  Alternatively, if you modify or redistribute
   the parser skeleton itself, you may (at your option) remove this
   special exception, which will cause the skeleton and the resulting
   Bison output files to be licensed under the GNU General Public
   License without this special exception.
   
   This special exception was added by the Free Software Foundation in
   version 2.2 of Bison.  */

/* C LALR(1) parser skeleton written by Richard Stallman, by
   simplifying the original so-called "semantic" parser.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output.  */
#define YYBISON 1

/* Bison version.  */
#define YYBISON_VERSION "2.4.1"

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 1

/* Push parsers.  */
#define YYPUSH 0

/* Pull parsers.  */
#define YYPULL 1

/* Using locations.  */
#define YYLSP_NEEDED 0

/* Substitute the variable and function names.  */
#define yyparse         MYSQLparse
#define yylex           MYSQLlex
#define yyerror         MYSQLerror
#define yylval          MYSQLlval
#define yychar          MYSQLchar
#define yydebug         MYSQLdebug
#define yynerrs         MYSQLnerrs


/* Copy the first part of user declarations.  */

/* Line 189 of yacc.c  */
#line 25 "/home/buildbot/bzr/build/sql/sql_yacc.yy"

#define YYLIP  (& thd->m_parser_state->m_lip)
#define YYPS   (& thd->m_parser_state->m_yacc)
#define YYCSCL (thd->variables.character_set_client)

#define MYSQL_YACC
#define YYINITDEPTH 100
#define YYMAXDEPTH 3200                        /* Because of 64K stack */
#define Lex (thd->lex)

#define Select Lex->current_select
#include <my_global.h>
#include "sql_priv.h"
#include "unireg.h"                    // REQUIRED: for other includes
#include "sql_parse.h"                        /* comp_*_creator */
#include "sql_table.h"                        /* primary_key_name */
#include "sql_partition.h"  /* mem_alloc_error, partition_info, HASH_PARTITION */
#include "sql_acl.h"                          /* *_ACL */
#include "password.h"       /* my_make_scrambled_password_323, my_make_scrambled_password */
#include "sql_class.h"      /* Key_part_spec, enum_filetype, Diag_condition_item_name */
#include "slave.h"
#include "lex_symbol.h"
#include "item_create.h"
#include "sp_head.h"
#include "sp_pcontext.h"
#include "sp_rcontext.h"
#include "sp.h"
#include "sql_alter.h"                         // Sql_cmd_alter_table*
#include "sql_truncate.h"                      // Sql_cmd_truncate_table
#include "sql_admin.h"                         // Sql_cmd_analyze/Check..._table
#include "sql_partition_admin.h"               // Sql_cmd_alter_table_*_part.
#include "sql_handler.h"                       // Sql_cmd_handler_*
#include "sql_signal.h"
#include "sql_get_diagnostics.h"               // Sql_cmd_get_diagnostics
#include "event_parse_data.h"
#include "create_options.h"
#include <myisam.h>
#include <myisammrg.h>
#include "keycaches.h"
#include "set_var.h"
#include "rpl_mi.h"

/* this is to get the bison compilation windows warnings out */
#ifdef _MSC_VER
/* warning C4065: switch statement contains 'default' but no 'case' labels */
#pragma warning (disable : 4065)
#endif

int yylex(void *yylval, void *yythd);

#define yyoverflow(A,B,C,D,E,F)               \
  {                                           \
    ulong val= *(F);                          \
    if (my_yyoverflow((B), (D), &val))        \
    {                                         \
      yyerror(thd, (char*) (A));              \
      return 2;                               \
    }                                         \
    else                                      \
    {                                         \
      *(F)= (YYSIZE_T)val;                    \
    }                                         \
  }

#define MYSQL_YYABORT                         \
  do                                          \
  {                                           \
    LEX::cleanup_lex_after_parse_error(thd);  \
    YYABORT;                                  \
  } while (0)

#define MYSQL_YYABORT_UNLESS(A)         \
  if (!(A))                             \
  {                                     \
    my_parse_error(ER(ER_SYNTAX_ERROR));\
    MYSQL_YYABORT;                      \
  }

/*
  Work around for broken code generated by bison 1.875.

  The code generated by bison 1.875a and later, bison 2.1 and bison 2.2 is ok.
  With bison 1.875 however, the generated code contains:
<pre>
  yyerrlab1:
  #if defined (__GNUC_MINOR__) && 2093 <= (__GNUC__ * 1000 + __GNUC_MINOR__)
    __attribute__ ((__unused__))
  #endif
</pre>
  This usage of __attribute__ is illegal, so we remove it.
  See the following references for details:
  http://lists.gnu.org/archive/html/bug-bison/2004-02/msg00014.html
  http://gcc.gnu.org/bugzilla/show_bug.cgi?id=14273
*/

#if defined (__GNUC_MINOR__) && 2093 <= (__GNUC__ * 1000 + __GNUC_MINOR__)
#undef __attribute__
#define __attribute__(X)
#endif


#ifndef DBUG_OFF
#define YYDEBUG 1
#else
#define YYDEBUG 0
#endif

/**
  @brief Push an error message into MySQL error stack with line
  and position information.

  This function provides semantic action implementers with a way
  to push the famous "You have a syntax error near..." error
  message into the error stack, which is normally produced only if
  a parse error is discovered internally by the Bison generated
  parser.
*/

void my_parse_error(const char *s)
{
  THD *thd= current_thd;
  Lex_input_stream *lip= & thd->m_parser_state->m_lip;

  const char *yytext= lip->get_tok_start();
  if (!yytext)
    yytext= "";

  /* Push an error into the error stack */
  ErrConvString err(yytext, strlen(yytext), thd->variables.character_set_client);
  my_printf_error(ER_PARSE_ERROR,  ER(ER_PARSE_ERROR), MYF(0), s,
                  err.ptr(), lip->yylineno);
}

/**
  @brief Bison callback to report a syntax/OOM error

  This function is invoked by the bison-generated parser
  when a syntax error, a parse error or an out-of-memory
  condition occurs. This function is not invoked when the
  parser is requested to abort by semantic action code
  by means of YYABORT or YYACCEPT macros. This is why these
  macros should not be used (use MYSQL_YYABORT/MYSQL_YYACCEPT
  instead).

  The parser will abort immediately after invoking this callback.

  This function is not for use in semantic actions and is internal to
  the parser, as it performs some pre-return cleanup. 
  In semantic actions, please use my_parse_error or my_error to
  push an error into the error stack and MYSQL_YYABORT
  to abort from the parser.
*/

void MYSQLerror(THD *thd, const char *s)
{
  /*
    Restore the original LEX if it was replaced when parsing
    a stored procedure. We must ensure that a parsing error
    does not leave any side effects in the THD.
  */
  LEX::cleanup_lex_after_parse_error(thd);

  /* "parse error" changed into "syntax error" between bison 1.75 and 1.875 */
  if (strcmp(s,"parse error") == 0 || strcmp(s,"syntax error") == 0)
    s= ER(ER_SYNTAX_ERROR);
  my_parse_error(s);
}


#ifndef DBUG_OFF
void turn_parser_debug_on()
{
  /*
     MYSQLdebug is in sql/sql_yacc.cc, in bison generated code.
     Turning this option on is **VERY** verbose, and should be
     used when investigating a syntax error problem only.

     The syntax to run with bison traces is as follows :
     - Starting a server manually :
       mysqld --debug-dbug="d,parser_debug" ...
     - Running a test :
       mysql-test-run.pl --mysqld="--debug-dbug=d,parser_debug" ...

     The result will be in the process stderr (var/log/master.err)
   */

  extern int yydebug;
  yydebug= 1;
}
#endif

static bool is_native_function(THD *thd, const LEX_STRING *name)
{
  if (find_native_function_builder(thd, *name))
    return true;

  if (is_lex_native_function(name))
    return true;

  return false;
}


/**
  Helper action for a case statement (entering the CASE).
  This helper is used for both 'simple' and 'searched' cases.
  This helper, with the other case_stmt_action_..., is executed when
  the following SQL code is parsed:
<pre>
CREATE PROCEDURE proc_19194_simple(i int)
BEGIN
  DECLARE str CHAR(10);

  CASE i
    WHEN 1 THEN SET str="1";
    WHEN 2 THEN SET str="2";
    WHEN 3 THEN SET str="3";
    ELSE SET str="unknown";
  END CASE;

  SELECT str;
END
</pre>
  The actions are used to generate the following code:
<pre>
SHOW PROCEDURE CODE proc_19194_simple;
Pos     Instruction
0       set str@1 NULL
1       set_case_expr (12) 0 i@0
2       jump_if_not 5(12) (case_expr@0 = 1)
3       set str@1 _latin1'1'
4       jump 12
5       jump_if_not 8(12) (case_expr@0 = 2)
6       set str@1 _latin1'2'
7       jump 12
8       jump_if_not 11(12) (case_expr@0 = 3)
9       set str@1 _latin1'3'
10      jump 12
11      set str@1 _latin1'unknown'
12      stmt 0 "SELECT str"
</pre>

  @param lex the parser lex context
*/

void case_stmt_action_case(LEX *lex)
{
  lex->sphead->new_cont_backpatch(NULL);

  /*
    BACKPATCH: Creating target label for the jump to
    "case_stmt_action_end_case"
    (Instruction 12 in the example)
  */

  lex->spcont->push_label(current_thd, empty_lex_str, lex->sphead->instructions());
}

/**
  Helper action for a case expression statement (the expr in 'CASE expr').
  This helper is used for 'searched' cases only.
  @param lex the parser lex context
  @param expr the parsed expression
  @return 0 on success
*/

int case_stmt_action_expr(LEX *lex, Item* expr)
{
  sp_head *sp= lex->sphead;
  sp_pcontext *parsing_ctx= lex->spcont;
  int case_expr_id= parsing_ctx->register_case_expr();
  sp_instr_set_case_expr *i;

  if (parsing_ctx->push_case_expr_id(case_expr_id))
    return 1;

  i= new sp_instr_set_case_expr(sp->instructions(),
                                parsing_ctx, case_expr_id, expr, lex);

  sp->add_cont_backpatch(i);
  return sp->add_instr(i);
}

/**
  Helper action for a case when condition.
  This helper is used for both 'simple' and 'searched' cases.
  @param lex the parser lex context
  @param when the parsed expression for the WHEN clause
  @param simple true for simple cases, false for searched cases
*/

int case_stmt_action_when(LEX *lex, Item *when, bool simple)
{
  sp_head *sp= lex->sphead;
  sp_pcontext *ctx= lex->spcont;
  uint ip= sp->instructions();
  sp_instr_jump_if_not *i;
  Item_case_expr *var;
  Item *expr;

  if (simple)
  {
    var= new Item_case_expr(ctx->get_current_case_expr_id());

#ifndef DBUG_OFF
    if (var)
    {
      var->m_sp= sp;
    }
#endif

    expr= new Item_func_eq(var, when);
    i= new sp_instr_jump_if_not(ip, ctx, expr, lex);
  }
  else
    i= new sp_instr_jump_if_not(ip, ctx, when, lex);

  /*
    BACKPATCH: Registering forward jump from
    "case_stmt_action_when" to "case_stmt_action_then"
    (jump_if_not from instruction 2 to 5, 5 to 8 ... in the example)
  */

  return !MY_TEST(i) ||
         sp->push_backpatch(i, ctx->push_label(current_thd, empty_lex_str, 0)) ||
         sp->add_cont_backpatch(i) ||
         sp->add_instr(i);
}

/**
  Helper action for a case then statements.
  This helper is used for both 'simple' and 'searched' cases.
  @param lex the parser lex context
*/

int case_stmt_action_then(LEX *lex)
{
  sp_head *sp= lex->sphead;
  sp_pcontext *ctx= lex->spcont;
  uint ip= sp->instructions();
  sp_instr_jump *i = new sp_instr_jump(ip, ctx);
  if (!MY_TEST(i) || sp->add_instr(i))
    return 1;

  /*
    BACKPATCH: Resolving forward jump from
    "case_stmt_action_when" to "case_stmt_action_then"
    (jump_if_not from instruction 2 to 5, 5 to 8 ... in the example)
  */

  sp->backpatch(ctx->pop_label());

  /*
    BACKPATCH: Registering forward jump from
    "case_stmt_action_then" to "case_stmt_action_end_case"
    (jump from instruction 4 to 12, 7 to 12 ... in the example)
  */

  return sp->push_backpatch(i, ctx->last_label());
}

/**
  Helper action for an end case.
  This helper is used for both 'simple' and 'searched' cases.
  @param lex the parser lex context
  @param simple true for simple cases, false for searched cases
*/

void case_stmt_action_end_case(LEX *lex, bool simple)
{
  /*
    BACKPATCH: Resolving forward jump from
    "case_stmt_action_then" to "case_stmt_action_end_case"
    (jump from instruction 4 to 12, 7 to 12 ... in the example)
  */
  lex->sphead->backpatch(lex->spcont->pop_label());

  if (simple)
    lex->spcont->pop_case_expr_id();

  lex->sphead->do_cont_backpatch();
}


static bool
find_sys_var_null_base(THD *thd, struct sys_var_with_base *tmp)
{
  tmp->var= find_sys_var(thd, tmp->base_name.str, tmp->base_name.length);

  if (tmp->var == NULL)
    my_error(ER_UNKNOWN_SYSTEM_VARIABLE, MYF(0), tmp->base_name.str);
  else
    tmp->base_name= null_lex_str;

  return thd->is_error();
}


/**
  Helper action for a SET statement.
  Used to push a system variable into the assignment list.

  @param thd      the current thread
  @param tmp      the system variable with base name
  @param var_type the scope of the variable
  @param val      the value being assigned to the variable

  @return TRUE if error, FALSE otherwise.
*/

static bool
set_system_variable(THD *thd, struct sys_var_with_base *tmp,
                    enum enum_var_type var_type, Item *val)
{
  set_var *var;
  LEX *lex= thd->lex;

  /* No AUTOCOMMIT from a stored function or trigger. */
  if (lex->spcont && tmp->var == Sys_autocommit_ptr)
    lex->sphead->m_flags|= sp_head::HAS_SET_AUTOCOMMIT_STMT;

  if (val && val->type() == Item::FIELD_ITEM &&
      ((Item_field*)val)->table_name)
  {
    my_error(ER_WRONG_TYPE_FOR_VAR, MYF(0), tmp->var->name.str);
    return TRUE;
  }

  if (! (var= new set_var(var_type, tmp->var, &tmp->base_name, val)))
    return TRUE;

  return lex->var_list.push_back(var);
}


/**
  Helper action for a SET statement.
  Used to push a SP local variable into the assignment list.

  @param thd      the current thread
  @param var_type the SP local variable
  @param val      the value being assigned to the variable

  @return TRUE if error, FALSE otherwise.
*/

static bool
set_local_variable(THD *thd, sp_variable *spv, Item *val)
{
  Item *it;
  LEX *lex= thd->lex;
  sp_instr_set *sp_set;

  if (val)
    it= val;
  else if (spv->default_value)
    it= spv->default_value;
  else
  {
    it= new (thd->mem_root) Item_null();
    if (it == NULL)
      return TRUE;
  }

  sp_set= new sp_instr_set(lex->sphead->instructions(), lex->spcont,
                           spv->offset, it, spv->type, lex, TRUE);

  return (sp_set == NULL || lex->sphead->add_instr(sp_set));
}


/**
  Helper action for a SET statement.
  Used to SET a field of NEW row.

  @param thd      the current thread
  @param name     the field name
  @param val      the value being assigned to the row

  @return TRUE if error, FALSE otherwise.
*/

static bool
set_trigger_new_row(THD *thd, LEX_STRING *name, Item *val)
{
  LEX *lex= thd->lex;
  Item_trigger_field *trg_fld;
  sp_instr_set_trigger_field *sp_fld;

  /* QQ: Shouldn't this be field's default value ? */
  if (! val)
    val= new Item_null();

  DBUG_ASSERT(lex->trg_chistics.action_time == TRG_ACTION_BEFORE &&
              (lex->trg_chistics.event == TRG_EVENT_INSERT ||
               lex->trg_chistics.event == TRG_EVENT_UPDATE));

  trg_fld= new (thd->mem_root)
            Item_trigger_field(lex->current_context(),
                               Item_trigger_field::NEW_ROW,
                               name->str, UPDATE_ACL, FALSE);

  if (trg_fld == NULL)
    return TRUE;

  sp_fld= new sp_instr_set_trigger_field(lex->sphead->instructions(),
                                         lex->spcont, trg_fld, val, lex);

  if (sp_fld == NULL)
    return TRUE;

  /*
    Let us add this item to list of all Item_trigger_field
    objects in trigger.
  */
  lex->trg_table_fields.link_in_list(trg_fld, &trg_fld->next_trg_field);

  return lex->sphead->add_instr(sp_fld);
}


/**
  Create an object to represent a SP variable in the Item-hierarchy.

  @param  thd         The current thread.
  @param  name        The SP variable name.
  @param  spvar       The SP variable (optional).
  @param  start_in_q  Start position of the SP variable name in the query.
  @param  end_in_q    End position of the SP variable name in the query.

  @remark If spvar is not specified, the name is used to search for the
          variable in the parse-time context. If the variable does not
          exist, a error is set and NULL is returned to the caller.

  @return An Item_splocal object representing the SP variable, or NULL on error.
*/
static Item_splocal*
create_item_for_sp_var(THD *thd, LEX_STRING name, sp_variable *spvar,
                       const char *start_in_q, const char *end_in_q)
{
  Item_splocal *item;
  LEX *lex= thd->lex;
  uint pos_in_q, len_in_q;
  sp_pcontext *spc = lex->spcont;

  /* If necessary, look for the variable. */
  if (spc && !spvar)
    spvar= spc->find_variable(name, false);

  if (!spvar)
  {
    my_error(ER_SP_UNDECLARED_VAR, MYF(0), name.str);
    return NULL;
  }

  DBUG_ASSERT(spc && spvar);

  /* Position and length of the SP variable name in the query. */
  pos_in_q= start_in_q - lex->sphead->m_tmp_query;
  len_in_q= end_in_q - start_in_q;

  item= new (thd->mem_root)
    Item_splocal(name, spvar->offset, spvar->type, pos_in_q, len_in_q);

#ifndef DBUG_OFF
  if (item)
    item->m_sp= lex->sphead;
#endif

  return item;
}

/**
  Helper to resolve the SQL:2003 Syntax exception 1) in <in predicate>.
  See SQL:2003, Part 2, section 8.4 <in predicate>, Note 184, page 383.
  This function returns the proper item for the SQL expression
  <code>left [NOT] IN ( expr )</code>
  @param thd the current thread
  @param left the in predicand
  @param equal true for IN predicates, false for NOT IN predicates
  @param expr first and only expression of the in value list
  @return an expression representing the IN predicate.
*/
Item* handle_sql2003_note184_exception(THD *thd, Item* left, bool equal,
                                       Item *expr)
{
  /*
    Relevant references for this issue:
    - SQL:2003, Part 2, section 8.4 <in predicate>, page 383,
    - SQL:2003, Part 2, section 7.2 <row value expression>, page 296,
    - SQL:2003, Part 2, section 6.3 <value expression primary>, page 174,
    - SQL:2003, Part 2, section 7.15 <subquery>, page 370,
    - SQL:2003 Feature F561, "Full value expressions".

    The exception in SQL:2003 Note 184 means:
    Item_singlerow_subselect, which corresponds to a <scalar subquery>,
    should be re-interpreted as an Item_in_subselect, which corresponds
    to a <table subquery> when used inside an <in predicate>.

    Our reading of Note 184 is reccursive, so that all:
    - IN (( <subquery> ))
    - IN ((( <subquery> )))
    - IN '('^N <subquery> ')'^N
    - etc
    should be interpreted as a <table subquery>, no matter how deep in the
    expression the <subquery> is.
  */

  Item *result;

  DBUG_ENTER("handle_sql2003_note184_exception");

  if (expr->type() == Item::SUBSELECT_ITEM)
  {
    Item_subselect *expr2 = (Item_subselect*) expr;

    if (expr2->substype() == Item_subselect::SINGLEROW_SUBS)
    {
      Item_singlerow_subselect *expr3 = (Item_singlerow_subselect*) expr2;
      st_select_lex *subselect;

      /*
        Implement the mandated change, by altering the semantic tree:
          left IN Item_singlerow_subselect(subselect)
        is modified to
          left IN (subselect)
        which is represented as
          Item_in_subselect(left, subselect)
      */
      subselect= expr3->invalidate_and_restore_select_lex();
      result= new (thd->mem_root) Item_in_subselect(left, subselect);

      if (! equal)
        result = negate_expression(thd, result);

      DBUG_RETURN(result);
    }
  }

  if (equal)
    result= new (thd->mem_root) Item_func_eq(left, expr);
  else
    result= new (thd->mem_root) Item_func_ne(left, expr);

  DBUG_RETURN(result);
}

/**
   @brief Creates a new SELECT_LEX for a UNION branch.

   Sets up and initializes a SELECT_LEX structure for a query once the parser
   discovers a UNION token. The current SELECT_LEX is pushed on the stack and
   the new SELECT_LEX becomes the current one.

   @param lex The parser state.

   @param is_union_distinct True if the union preceding the new select statement
   uses UNION DISTINCT.

   @param is_top_level This should be @c TRUE if the newly created SELECT_LEX
   is a non-nested statement.

   @return <code>false</code> if successful, <code>true</code> if an error was
   reported. In the latter case parsing should stop.
 */
bool add_select_to_union_list(LEX *lex, bool is_union_distinct, 
                              bool is_top_level)
{
  /* 
     Only the last SELECT can have INTO. Since the grammar won't allow INTO in
     a nested SELECT, we make this check only when creating a top-level SELECT.
  */
  if (is_top_level && lex->result)
  {
    my_error(ER_WRONG_USAGE, MYF(0), "UNION", "INTO");
    return TRUE;
  }
  if (lex->current_select->linkage == GLOBAL_OPTIONS_TYPE)
  {
    my_parse_error(ER(ER_SYNTAX_ERROR));
    return TRUE;
  }
  /* This counter shouldn't be incremented for UNION parts */
  lex->nest_level--;
  if (mysql_new_select(lex, 0))
    return TRUE;
  mysql_init_select(lex);
  lex->current_select->linkage=UNION_TYPE;
  if (is_union_distinct) /* UNION DISTINCT - remember position */
    lex->current_select->master_unit()->union_distinct=
      lex->current_select;
  return FALSE;
}

/**
   @brief Initializes a SELECT_LEX for a query within parentheses (aka
   braces).

   @return false if successful, true if an error was reported. In the latter
   case parsing should stop.
 */
bool setup_select_in_parentheses(LEX *lex) 
{
  SELECT_LEX * sel= lex->current_select;
  if (sel->set_braces(1))
  {
    my_parse_error(ER(ER_SYNTAX_ERROR));
    return TRUE;
  }
  if (sel->linkage == UNION_TYPE &&
      !sel->master_unit()->first_select()->braces &&
      sel->master_unit()->first_select()->linkage ==
      UNION_TYPE)
  {
    my_parse_error(ER(ER_SYNTAX_ERROR));
    return TRUE;
  }
  if (sel->linkage == UNION_TYPE &&
      sel->olap != UNSPECIFIED_OLAP_TYPE &&
      sel->master_unit()->fake_select_lex)
  {
    my_error(ER_WRONG_USAGE, MYF(0), "CUBE/ROLLUP", "ORDER BY");
    return TRUE;
  }
  /* select in braces, can't contain global parameters */
  if (sel->master_unit()->fake_select_lex)
    sel->master_unit()->global_parameters=
      sel->master_unit()->fake_select_lex;
  return FALSE;
}

static bool add_create_index_prepare (LEX *lex, Table_ident *table)
{
  lex->sql_command= SQLCOM_CREATE_INDEX;
  if (!lex->current_select->add_table_to_list(lex->thd, table, NULL,
                                              TL_OPTION_UPDATING,
                                              TL_READ_NO_INSERT,
                                              MDL_SHARED_UPGRADABLE))
    return TRUE;
  lex->alter_info.reset();
  lex->alter_info.flags= Alter_info::ALTER_ADD_INDEX;
  lex->col_list.empty();
  lex->change= NullS;
  lex->option_list= NULL;
  return FALSE;
}

static bool add_create_index (LEX *lex, Key::Keytype type,
                              const LEX_STRING &name,
                              KEY_CREATE_INFO *info= NULL, bool generated= 0)
{
  Key *key;
  key= new Key(type, name, info ? info : &lex->key_create_info, generated, 
               lex->col_list, lex->option_list, lex->check_exists);
  if (key == NULL)
    return TRUE;

  lex->alter_info.key_list.push_back(key);
  lex->col_list.empty();
  return FALSE;
}


/**
  Create a separate LEX for each assignment if in SP.

  If we are in SP we want have own LEX for each assignment.
  This is mostly because it is hard for several sp_instr_set
  and sp_instr_set_trigger instructions share one LEX.
  (Well, it is theoretically possible but adds some extra
  overhead on preparation for execution stage and IMO less
  robust).

  QQ: May be we should simply prohibit group assignments in SP?

  @see sp_create_assignment_instr

  @param thd           Thread context
  @param no_lookahead  True if the parser has no lookahead
*/

static void sp_create_assignment_lex(THD *thd, bool no_lookahead)
{
  LEX *lex= thd->lex;

  if (lex->sphead)
  {
    Lex_input_stream *lip= &thd->m_parser_state->m_lip;
    LEX *old_lex= lex;
    lex->sphead->reset_lex(thd);
    lex= thd->lex;

    /* Set new LEX as if we at start of set rule. */
    lex->sql_command= SQLCOM_SET_OPTION;
    mysql_init_select(lex);
    lex->var_list.empty();
    lex->autocommit= 0;
    /* get_ptr() is only correct with no lookahead. */
    DBUG_ASSERT(no_lookahead);
    lex->sphead->m_tmp_query= lip->get_ptr();
    /* Inherit from outer lex. */
    lex->option_type= old_lex->option_type;
  }
}


/**
  Create a SP instruction for a SET assignment.

  @see sp_create_assignment_lex

  @param thd           Thread context
  @param no_lookahead  True if the parser has no lookahead

  @return false if success, true otherwise.
*/

static bool sp_create_assignment_instr(THD *thd, bool no_lookahead)
{
  LEX *lex= thd->lex;

  if (lex->sphead)
  {
    sp_head *sp= lex->sphead;

    if (!lex->var_list.is_empty())
    {
      /*
        We have assignment to user or system variable or
        option setting, so we should construct sp_instr_stmt
        for it.
      */
      LEX_STRING qbuff;
      sp_instr_stmt *i;
      Lex_input_stream *lip= &thd->m_parser_state->m_lip;

      if (!(i= new sp_instr_stmt(sp->instructions(), lex->spcont,
                                 lex)))
        return true;

      /*
        Extract the query statement from the tokenizer.  The
        end is either lip->ptr, if there was no lookahead,
        lip->tok_end otherwise.
      */
      if (no_lookahead)
        qbuff.length= lip->get_ptr() - sp->m_tmp_query;
      else
        qbuff.length= lip->get_tok_end() - sp->m_tmp_query;

      if (!(qbuff.str= (char*) alloc_root(thd->mem_root,
                                          qbuff.length + 5)))
        return true;

      strmake(strmake(qbuff.str, "SET ", 4), sp->m_tmp_query,
              qbuff.length);
      qbuff.length+= 4;
      i->m_query= qbuff;
      if (sp->add_instr(i))
        return true;
    }
    enum_var_type inner_option_type= lex->option_type;
    if (lex->sphead->restore_lex(thd))
      return true;
    /* Copy option_type to outer lex in case it has changed. */
    thd->lex->option_type= inner_option_type;
  }
  return false;
}




/* Line 189 of yacc.c  */
#line 955 "/home/buildbot/bzr/build/mkdist/sql/sql_yacc.cc"

/* Enabling traces.  */
#ifndef YYDEBUG
# define YYDEBUG 0
#endif

/* Enabling verbose error messages.  */
#ifdef YYERROR_VERBOSE
# undef YYERROR_VERBOSE
# define YYERROR_VERBOSE 1
#else
# define YYERROR_VERBOSE 0
#endif

/* Enabling the token table.  */
#ifndef YYTOKEN_TABLE
# define YYTOKEN_TABLE 0
#endif


/* Tokens.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
   /* Put the tokens into the symbol table, so that GDB and other debuggers
      know about them.  */
   enum yytokentype {
     ABORT_SYM = 258,
     ACCESSIBLE_SYM = 259,
     ACTION = 260,
     ADD = 261,
     ADMIN_SYM = 262,
     ADDDATE_SYM = 263,
     AFTER_SYM = 264,
     AGAINST = 265,
     AGGREGATE_SYM = 266,
     ALGORITHM_SYM = 267,
     ALL = 268,
     ALTER = 269,
     ALWAYS_SYM = 270,
     ANALYZE_SYM = 271,
     AND_AND_SYM = 272,
     AND_SYM = 273,
     ANY_SYM = 274,
     AS = 275,
     ASC = 276,
     ASCII_SYM = 277,
     ASENSITIVE_SYM = 278,
     AT_SYM = 279,
     AUTHORS_SYM = 280,
     AUTOEXTEND_SIZE_SYM = 281,
     AUTO_INC = 282,
     AUTO_SYM = 283,
     AVG_ROW_LENGTH = 284,
     AVG_SYM = 285,
     BACKUP_SYM = 286,
     BEFORE_SYM = 287,
     BEGIN_SYM = 288,
     BETWEEN_SYM = 289,
     BIGINT = 290,
     BINARY = 291,
     BINLOG_SYM = 292,
     BIN_NUM = 293,
     BIT_AND = 294,
     BIT_OR = 295,
     BIT_SYM = 296,
     BIT_XOR = 297,
     BLOB_SYM = 298,
     BLOCK_SYM = 299,
     BOOLEAN_SYM = 300,
     BOOL_SYM = 301,
     BOTH = 302,
     BTREE_SYM = 303,
     BY = 304,
     BYTE_SYM = 305,
     CACHE_SYM = 306,
     CALL_SYM = 307,
     CASCADE = 308,
     CASCADED = 309,
     CASE_SYM = 310,
     CAST_SYM = 311,
     CATALOG_NAME_SYM = 312,
     CHAIN_SYM = 313,
     CHANGE = 314,
     CHANGED = 315,
     CHARSET = 316,
     CHAR_SYM = 317,
     CHECKPOINT_SYM = 318,
     CHECKSUM_SYM = 319,
     CHECK_SYM = 320,
     CIPHER_SYM = 321,
     CLASS_ORIGIN_SYM = 322,
     CLIENT_SYM = 323,
     CLIENT_STATS_SYM = 324,
     CLOSE_SYM = 325,
     COALESCE = 326,
     CODE_SYM = 327,
     COLLATE_SYM = 328,
     COLLATION_SYM = 329,
     COLUMNS = 330,
     COLUMN_ADD_SYM = 331,
     COLUMN_CHECK_SYM = 332,
     COLUMN_CREATE_SYM = 333,
     COLUMN_DELETE_SYM = 334,
     COLUMN_GET_SYM = 335,
     COLUMN_SYM = 336,
     COLUMN_NAME_SYM = 337,
     COMMENT_SYM = 338,
     COMMITTED_SYM = 339,
     COMMIT_SYM = 340,
     COMPACT_SYM = 341,
     COMPLETION_SYM = 342,
     COMPRESSED_SYM = 343,
     CONCURRENT = 344,
     CONDITION_SYM = 345,
     CONNECTION_SYM = 346,
     CONSISTENT_SYM = 347,
     CONSTRAINT = 348,
     CONSTRAINT_CATALOG_SYM = 349,
     CONSTRAINT_NAME_SYM = 350,
     CONSTRAINT_SCHEMA_SYM = 351,
     CONTAINS_SYM = 352,
     CONTEXT_SYM = 353,
     CONTINUE_SYM = 354,
     CONTRIBUTORS_SYM = 355,
     CONVERT_SYM = 356,
     COUNT_SYM = 357,
     CPU_SYM = 358,
     CREATE = 359,
     CROSS = 360,
     CUBE_SYM = 361,
     CURDATE = 362,
     CURRENT_SYM = 363,
     CURRENT_USER = 364,
     CURRENT_ROLE = 365,
     CURRENT_POS_SYM = 366,
     CURSOR_SYM = 367,
     CURSOR_NAME_SYM = 368,
     CURTIME = 369,
     DATABASE = 370,
     DATABASES = 371,
     DATAFILE_SYM = 372,
     DATA_SYM = 373,
     DATETIME = 374,
     DATE_ADD_INTERVAL = 375,
     DATE_SUB_INTERVAL = 376,
     DATE_SYM = 377,
     DAY_HOUR_SYM = 378,
     DAY_MICROSECOND_SYM = 379,
     DAY_MINUTE_SYM = 380,
     DAY_SECOND_SYM = 381,
     DAY_SYM = 382,
     DEALLOCATE_SYM = 383,
     DECIMAL_NUM = 384,
     DECIMAL_SYM = 385,
     DECLARE_SYM = 386,
     DEFAULT = 387,
     DEFINER_SYM = 388,
     DELAYED_SYM = 389,
     DELAY_KEY_WRITE_SYM = 390,
     DELETE_SYM = 391,
     DESC = 392,
     DESCRIBE = 393,
     DES_KEY_FILE = 394,
     DETERMINISTIC_SYM = 395,
     DIAGNOSTICS_SYM = 396,
     DIRECTORY_SYM = 397,
     DISABLE_SYM = 398,
     DISCARD = 399,
     DISK_SYM = 400,
     DISTINCT = 401,
     DIV_SYM = 402,
     DOUBLE_SYM = 403,
     DO_SYM = 404,
     DROP = 405,
     DUAL_SYM = 406,
     DUMPFILE = 407,
     DUPLICATE_SYM = 408,
     DYNAMIC_SYM = 409,
     EACH_SYM = 410,
     ELSE = 411,
     ELSEIF_SYM = 412,
     ENABLE_SYM = 413,
     ENCLOSED = 414,
     END = 415,
     ENDS_SYM = 416,
     END_OF_INPUT = 417,
     ENGINES_SYM = 418,
     ENGINE_SYM = 419,
     ENUM = 420,
     EQ = 421,
     EQUAL_SYM = 422,
     ERROR_SYM = 423,
     ERRORS = 424,
     ESCAPED = 425,
     ESCAPE_SYM = 426,
     EVENTS_SYM = 427,
     EVENT_SYM = 428,
     EVERY_SYM = 429,
     EXCHANGE_SYM = 430,
     EXAMINED_SYM = 431,
     EXECUTE_SYM = 432,
     EXISTS = 433,
     EXIT_SYM = 434,
     EXPANSION_SYM = 435,
     EXPORT_SYM = 436,
     EXTENDED_SYM = 437,
     EXTENT_SIZE_SYM = 438,
     EXTRACT_SYM = 439,
     FALSE_SYM = 440,
     FAST_SYM = 441,
     FAULTS_SYM = 442,
     FETCH_SYM = 443,
     FILE_SYM = 444,
     FIRST_SYM = 445,
     FIXED_SYM = 446,
     FLOAT_NUM = 447,
     FLOAT_SYM = 448,
     FLUSH_SYM = 449,
     FORCE_SYM = 450,
     FOREIGN = 451,
     FOR_SYM = 452,
     FOUND_SYM = 453,
     FROM = 454,
     FULL = 455,
     FULLTEXT_SYM = 456,
     FUNCTION_SYM = 457,
     GE = 458,
     GENERAL = 459,
     GENERATED_SYM = 460,
     GEOMETRYCOLLECTION = 461,
     GEOMETRY_SYM = 462,
     GET_FORMAT = 463,
     GET_SYM = 464,
     GLOBAL_SYM = 465,
     GRANT = 466,
     GRANTS = 467,
     GROUP_SYM = 468,
     GROUP_CONCAT_SYM = 469,
     GT_SYM = 470,
     HANDLER_SYM = 471,
     HARD_SYM = 472,
     HASH_SYM = 473,
     HAVING = 474,
     HELP_SYM = 475,
     HEX_NUM = 476,
     HEX_STRING = 477,
     HIGH_PRIORITY = 478,
     HOST_SYM = 479,
     HOSTS_SYM = 480,
     HOUR_MICROSECOND_SYM = 481,
     HOUR_MINUTE_SYM = 482,
     HOUR_SECOND_SYM = 483,
     HOUR_SYM = 484,
     ID_SYM = 485,
     IDENT = 486,
     IDENTIFIED_SYM = 487,
     IDENT_QUOTED = 488,
     IF = 489,
     IGNORE_SYM = 490,
     IGNORE_SERVER_IDS_SYM = 491,
     IMPORT = 492,
     INDEXES = 493,
     INDEX_SYM = 494,
     INDEX_STATS_SYM = 495,
     INFILE = 496,
     INITIAL_SIZE_SYM = 497,
     INNER_SYM = 498,
     INOUT_SYM = 499,
     INSENSITIVE_SYM = 500,
     INSERT = 501,
     INSERT_METHOD = 502,
     INSTALL_SYM = 503,
     INTERVAL_SYM = 504,
     INTO = 505,
     INT_SYM = 506,
     INVOKER_SYM = 507,
     IN_SYM = 508,
     IO_SYM = 509,
     IPC_SYM = 510,
     IS = 511,
     ISOLATION = 512,
     ISSUER_SYM = 513,
     ITERATE_SYM = 514,
     JOIN_SYM = 515,
     KEYS = 516,
     KEY_BLOCK_SIZE = 517,
     KEY_SYM = 518,
     KILL_SYM = 519,
     LANGUAGE_SYM = 520,
     LAST_SYM = 521,
     LAST_VALUE = 522,
     LE = 523,
     LEADING = 524,
     LEAVES = 525,
     LEAVE_SYM = 526,
     LEFT = 527,
     LESS_SYM = 528,
     LEVEL_SYM = 529,
     LEX_HOSTNAME = 530,
     LIKE = 531,
     LIMIT = 532,
     LINEAR_SYM = 533,
     LINES = 534,
     LINESTRING = 535,
     LIST_SYM = 536,
     LOAD = 537,
     LOCAL_SYM = 538,
     LOCATOR_SYM = 539,
     LOCKS_SYM = 540,
     LOCK_SYM = 541,
     LOGFILE_SYM = 542,
     LOGS_SYM = 543,
     LONGBLOB = 544,
     LONGTEXT = 545,
     LONG_NUM = 546,
     LONG_SYM = 547,
     LOOP_SYM = 548,
     LOW_PRIORITY = 549,
     LT = 550,
     MASTER_CONNECT_RETRY_SYM = 551,
     MASTER_GTID_POS_SYM = 552,
     MASTER_HOST_SYM = 553,
     MASTER_LOG_FILE_SYM = 554,
     MASTER_LOG_POS_SYM = 555,
     MASTER_PASSWORD_SYM = 556,
     MASTER_PORT_SYM = 557,
     MASTER_SERVER_ID_SYM = 558,
     MASTER_SSL_CAPATH_SYM = 559,
     MASTER_SSL_CA_SYM = 560,
     MASTER_SSL_CERT_SYM = 561,
     MASTER_SSL_CIPHER_SYM = 562,
     MASTER_SSL_CRL_SYM = 563,
     MASTER_SSL_CRLPATH_SYM = 564,
     MASTER_SSL_KEY_SYM = 565,
     MASTER_SSL_SYM = 566,
     MASTER_SSL_VERIFY_SERVER_CERT_SYM = 567,
     MASTER_SYM = 568,
     MASTER_USER_SYM = 569,
     MASTER_USE_GTID_SYM = 570,
     MASTER_HEARTBEAT_PERIOD_SYM = 571,
     MATCH = 572,
     MAX_CONNECTIONS_PER_HOUR = 573,
     MAX_QUERIES_PER_HOUR = 574,
     MAX_ROWS = 575,
     MAX_SIZE_SYM = 576,
     MAX_SYM = 577,
     MAX_UPDATES_PER_HOUR = 578,
     MAX_USER_CONNECTIONS_SYM = 579,
     MAX_VALUE_SYM = 580,
     MEDIUMBLOB = 581,
     MEDIUMINT = 582,
     MEDIUMTEXT = 583,
     MEDIUM_SYM = 584,
     MEMORY_SYM = 585,
     MERGE_SYM = 586,
     MESSAGE_TEXT_SYM = 587,
     MICROSECOND_SYM = 588,
     MIGRATE_SYM = 589,
     MINUTE_MICROSECOND_SYM = 590,
     MINUTE_SECOND_SYM = 591,
     MINUTE_SYM = 592,
     MIN_ROWS = 593,
     MIN_SYM = 594,
     MODE_SYM = 595,
     MODIFIES_SYM = 596,
     MODIFY_SYM = 597,
     MOD_SYM = 598,
     MONTH_SYM = 599,
     MULTILINESTRING = 600,
     MULTIPOINT = 601,
     MULTIPOLYGON = 602,
     MUTEX_SYM = 603,
     MYSQL_ERRNO_SYM = 604,
     NAMES_SYM = 605,
     NAME_SYM = 606,
     NATIONAL_SYM = 607,
     NATURAL = 608,
     NCHAR_STRING = 609,
     NCHAR_SYM = 610,
     NDBCLUSTER_SYM = 611,
     NE = 612,
     NEG = 613,
     NEW_SYM = 614,
     NEXT_SYM = 615,
     NODEGROUP_SYM = 616,
     NONE_SYM = 617,
     NOT2_SYM = 618,
     NOT_SYM = 619,
     NOW_SYM = 620,
     NO_SYM = 621,
     NO_WAIT_SYM = 622,
     NO_WRITE_TO_BINLOG = 623,
     NULL_SYM = 624,
     NUM = 625,
     NUMBER_SYM = 626,
     NUMERIC_SYM = 627,
     NVARCHAR_SYM = 628,
     OFFSET_SYM = 629,
     OLD_PASSWORD = 630,
     ON = 631,
     ONE_SYM = 632,
     ONLY_SYM = 633,
     ONLINE_SYM = 634,
     OPEN_SYM = 635,
     OPTIMIZE = 636,
     OPTIONS_SYM = 637,
     OPTION = 638,
     OPTIONALLY = 639,
     OR2_SYM = 640,
     ORDER_SYM = 641,
     OR_OR_SYM = 642,
     OR_SYM = 643,
     OUTER = 644,
     OUTFILE = 645,
     OUT_SYM = 646,
     OWNER_SYM = 647,
     PACK_KEYS_SYM = 648,
     PAGE_SYM = 649,
     PAGE_CHECKSUM_SYM = 650,
     PARAM_MARKER = 651,
     PARSER_SYM = 652,
     PARSE_VCOL_EXPR_SYM = 653,
     PARTIAL = 654,
     PARTITION_SYM = 655,
     PARTITIONS_SYM = 656,
     PARTITIONING_SYM = 657,
     PASSWORD = 658,
     PERSISTENT_SYM = 659,
     PHASE_SYM = 660,
     PLUGINS_SYM = 661,
     PLUGIN_SYM = 662,
     POINT_SYM = 663,
     POLYGON = 664,
     PORT_SYM = 665,
     POSITION_SYM = 666,
     PRECISION = 667,
     PREPARE_SYM = 668,
     PRESERVE_SYM = 669,
     PREV_SYM = 670,
     PRIMARY_SYM = 671,
     PRIVILEGES = 672,
     PROCEDURE_SYM = 673,
     PROCESS = 674,
     PROCESSLIST_SYM = 675,
     PROFILE_SYM = 676,
     PROFILES_SYM = 677,
     PROXY_SYM = 678,
     PURGE = 679,
     QUARTER_SYM = 680,
     QUERY_SYM = 681,
     QUICK = 682,
     RANGE_SYM = 683,
     READS_SYM = 684,
     READ_ONLY_SYM = 685,
     READ_SYM = 686,
     READ_WRITE_SYM = 687,
     REAL = 688,
     REBUILD_SYM = 689,
     RECOVER_SYM = 690,
     REDOFILE_SYM = 691,
     REDO_BUFFER_SIZE_SYM = 692,
     REDUNDANT_SYM = 693,
     REFERENCES = 694,
     REGEXP = 695,
     RELAY = 696,
     RELAYLOG_SYM = 697,
     RELAY_LOG_FILE_SYM = 698,
     RELAY_LOG_POS_SYM = 699,
     RELAY_THREAD = 700,
     RELEASE_SYM = 701,
     RELOAD = 702,
     REMOVE_SYM = 703,
     RENAME = 704,
     REORGANIZE_SYM = 705,
     REPAIR = 706,
     REPEATABLE_SYM = 707,
     REPEAT_SYM = 708,
     REPLACE = 709,
     REPLICATION = 710,
     REQUIRE_SYM = 711,
     RESET_SYM = 712,
     RESIGNAL_SYM = 713,
     RESOURCES = 714,
     RESTORE_SYM = 715,
     RESTRICT = 716,
     RESUME_SYM = 717,
     RETURNED_SQLSTATE_SYM = 718,
     RETURNING_SYM = 719,
     RETURNS_SYM = 720,
     RETURN_SYM = 721,
     REVERSE_SYM = 722,
     REVOKE = 723,
     RIGHT = 724,
     ROLE_SYM = 725,
     ROLLBACK_SYM = 726,
     ROLLUP_SYM = 727,
     ROUTINE_SYM = 728,
     ROWS_SYM = 729,
     ROW_FORMAT_SYM = 730,
     ROW_SYM = 731,
     ROW_COUNT_SYM = 732,
     RTREE_SYM = 733,
     SAVEPOINT_SYM = 734,
     SCHEDULE_SYM = 735,
     SCHEMA_NAME_SYM = 736,
     SECOND_MICROSECOND_SYM = 737,
     SECOND_SYM = 738,
     SECURITY_SYM = 739,
     SELECT_SYM = 740,
     SENSITIVE_SYM = 741,
     SEPARATOR_SYM = 742,
     SERIALIZABLE_SYM = 743,
     SERIAL_SYM = 744,
     SESSION_SYM = 745,
     SERVER_SYM = 746,
     SERVER_OPTIONS = 747,
     SET = 748,
     SET_VAR = 749,
     SHARE_SYM = 750,
     SHIFT_LEFT = 751,
     SHIFT_RIGHT = 752,
     SHOW = 753,
     SHUTDOWN = 754,
     SIGNAL_SYM = 755,
     SIGNED_SYM = 756,
     SIMPLE_SYM = 757,
     SLAVE = 758,
     SLAVES = 759,
     SLAVE_POS_SYM = 760,
     SLOW = 761,
     SMALLINT = 762,
     SNAPSHOT_SYM = 763,
     SOCKET_SYM = 764,
     SOFT_SYM = 765,
     SONAME_SYM = 766,
     SOUNDS_SYM = 767,
     SOURCE_SYM = 768,
     SPATIAL_SYM = 769,
     SPECIFIC_SYM = 770,
     SQLEXCEPTION_SYM = 771,
     SQLSTATE_SYM = 772,
     SQLWARNING_SYM = 773,
     SQL_BIG_RESULT = 774,
     SQL_BUFFER_RESULT = 775,
     SQL_CACHE_SYM = 776,
     SQL_CALC_FOUND_ROWS = 777,
     SQL_NO_CACHE_SYM = 778,
     SQL_SMALL_RESULT = 779,
     SQL_SYM = 780,
     SQL_THREAD = 781,
     SSL_SYM = 782,
     STARTING = 783,
     STARTS_SYM = 784,
     START_SYM = 785,
     STATS_AUTO_RECALC_SYM = 786,
     STATS_PERSISTENT_SYM = 787,
     STATS_SAMPLE_PAGES_SYM = 788,
     STATUS_SYM = 789,
     STDDEV_SAMP_SYM = 790,
     STD_SYM = 791,
     STOP_SYM = 792,
     STORAGE_SYM = 793,
     STRAIGHT_JOIN = 794,
     STRING_SYM = 795,
     SUBCLASS_ORIGIN_SYM = 796,
     SUBDATE_SYM = 797,
     SUBJECT_SYM = 798,
     SUBPARTITIONS_SYM = 799,
     SUBPARTITION_SYM = 800,
     SUBSTRING = 801,
     SUM_SYM = 802,
     SUPER_SYM = 803,
     SUSPEND_SYM = 804,
     SWAPS_SYM = 805,
     SWITCHES_SYM = 806,
     SYSDATE = 807,
     TABLES = 808,
     TABLESPACE = 809,
     TABLE_REF_PRIORITY = 810,
     TABLE_STATS_SYM = 811,
     TABLE_SYM = 812,
     TABLE_CHECKSUM_SYM = 813,
     TABLE_NAME_SYM = 814,
     TEMPORARY = 815,
     TEMPTABLE_SYM = 816,
     TERMINATED = 817,
     TEXT_STRING = 818,
     TEXT_SYM = 819,
     THAN_SYM = 820,
     THEN_SYM = 821,
     TIMESTAMP = 822,
     TIMESTAMP_ADD = 823,
     TIMESTAMP_DIFF = 824,
     TIME_SYM = 825,
     TINYBLOB = 826,
     TINYINT = 827,
     TINYTEXT = 828,
     TO_SYM = 829,
     TRAILING = 830,
     TRANSACTION_SYM = 831,
     TRANSACTIONAL_SYM = 832,
     TRIGGERS_SYM = 833,
     TRIGGER_SYM = 834,
     TRIM = 835,
     TRUE_SYM = 836,
     TRUNCATE_SYM = 837,
     TYPES_SYM = 838,
     TYPE_SYM = 839,
     UDF_RETURNS_SYM = 840,
     ULONGLONG_NUM = 841,
     UNCOMMITTED_SYM = 842,
     UNDEFINED_SYM = 843,
     UNDERSCORE_CHARSET = 844,
     UNDOFILE_SYM = 845,
     UNDO_BUFFER_SIZE_SYM = 846,
     UNDO_SYM = 847,
     UNICODE_SYM = 848,
     UNINSTALL_SYM = 849,
     UNION_SYM = 850,
     UNIQUE_SYM = 851,
     UNKNOWN_SYM = 852,
     UNLOCK_SYM = 853,
     UNSIGNED = 854,
     UNTIL_SYM = 855,
     UPDATE_SYM = 856,
     UPGRADE_SYM = 857,
     USAGE = 858,
     USER = 859,
     USER_STATS_SYM = 860,
     USE_FRM = 861,
     USE_SYM = 862,
     USING = 863,
     UTC_DATE_SYM = 864,
     UTC_TIMESTAMP_SYM = 865,
     UTC_TIME_SYM = 866,
     VALUES = 867,
     VALUE_SYM = 868,
     VARBINARY = 869,
     VARCHAR = 870,
     VARIABLES = 871,
     VARIANCE_SYM = 872,
     VARYING = 873,
     VAR_SAMP_SYM = 874,
     VIA_SYM = 875,
     VIEW_SYM = 876,
     VIRTUAL_SYM = 877,
     WAIT_SYM = 878,
     WARNINGS = 879,
     WEEK_SYM = 880,
     WEIGHT_STRING_SYM = 881,
     WHEN_SYM = 882,
     WHERE = 883,
     WHILE_SYM = 884,
     WITH = 885,
     WITH_CUBE_SYM = 886,
     WITH_ROLLUP_SYM = 887,
     WORK_SYM = 888,
     WRAPPER_SYM = 889,
     WRITE_SYM = 890,
     X509_SYM = 891,
     XA_SYM = 892,
     XML_SYM = 893,
     XOR = 894,
     YEAR_MONTH_SYM = 895,
     YEAR_SYM = 896,
     ZEROFILL = 897,
     IMPOSSIBLE_ACTION = 898
   };
#endif
/* Tokens.  */
#define ABORT_SYM 258
#define ACCESSIBLE_SYM 259
#define ACTION 260
#define ADD 261
#define ADMIN_SYM 262
#define ADDDATE_SYM 263
#define AFTER_SYM 264
#define AGAINST 265
#define AGGREGATE_SYM 266
#define ALGORITHM_SYM 267
#define ALL 268
#define ALTER 269
#define ALWAYS_SYM 270
#define ANALYZE_SYM 271
#define AND_AND_SYM 272
#define AND_SYM 273
#define ANY_SYM 274
#define AS 275
#define ASC 276
#define ASCII_SYM 277
#define ASENSITIVE_SYM 278
#define AT_SYM 279
#define AUTHORS_SYM 280
#define AUTOEXTEND_SIZE_SYM 281
#define AUTO_INC 282
#define AUTO_SYM 283
#define AVG_ROW_LENGTH 284
#define AVG_SYM 285
#define BACKUP_SYM 286
#define BEFORE_SYM 287
#define BEGIN_SYM 288
#define BETWEEN_SYM 289
#define BIGINT 290
#define BINARY 291
#define BINLOG_SYM 292
#define BIN_NUM 293
#define BIT_AND 294
#define BIT_OR 295
#define BIT_SYM 296
#define BIT_XOR 297
#define BLOB_SYM 298
#define BLOCK_SYM 299
#define BOOLEAN_SYM 300
#define BOOL_SYM 301
#define BOTH 302
#define BTREE_SYM 303
#define BY 304
#define BYTE_SYM 305
#define CACHE_SYM 306
#define CALL_SYM 307
#define CASCADE 308
#define CASCADED 309
#define CASE_SYM 310
#define CAST_SYM 311
#define CATALOG_NAME_SYM 312
#define CHAIN_SYM 313
#define CHANGE 314
#define CHANGED 315
#define CHARSET 316
#define CHAR_SYM 317
#define CHECKPOINT_SYM 318
#define CHECKSUM_SYM 319
#define CHECK_SYM 320
#define CIPHER_SYM 321
#define CLASS_ORIGIN_SYM 322
#define CLIENT_SYM 323
#define CLIENT_STATS_SYM 324
#define CLOSE_SYM 325
#define COALESCE 326
#define CODE_SYM 327
#define COLLATE_SYM 328
#define COLLATION_SYM 329
#define COLUMNS 330
#define COLUMN_ADD_SYM 331
#define COLUMN_CHECK_SYM 332
#define COLUMN_CREATE_SYM 333
#define COLUMN_DELETE_SYM 334
#define COLUMN_GET_SYM 335
#define COLUMN_SYM 336
#define COLUMN_NAME_SYM 337
#define COMMENT_SYM 338
#define COMMITTED_SYM 339
#define COMMIT_SYM 340
#define COMPACT_SYM 341
#define COMPLETION_SYM 342
#define COMPRESSED_SYM 343
#define CONCURRENT 344
#define CONDITION_SYM 345
#define CONNECTION_SYM 346
#define CONSISTENT_SYM 347
#define CONSTRAINT 348
#define CONSTRAINT_CATALOG_SYM 349
#define CONSTRAINT_NAME_SYM 350
#define CONSTRAINT_SCHEMA_SYM 351
#define CONTAINS_SYM 352
#define CONTEXT_SYM 353
#define CONTINUE_SYM 354
#define CONTRIBUTORS_SYM 355
#define CONVERT_SYM 356
#define COUNT_SYM 357
#define CPU_SYM 358
#define CREATE 359
#define CROSS 360
#define CUBE_SYM 361
#define CURDATE 362
#define CURRENT_SYM 363
#define CURRENT_USER 364
#define CURRENT_ROLE 365
#define CURRENT_POS_SYM 366
#define CURSOR_SYM 367
#define CURSOR_NAME_SYM 368
#define CURTIME 369
#define DATABASE 370
#define DATABASES 371
#define DATAFILE_SYM 372
#define DATA_SYM 373
#define DATETIME 374
#define DATE_ADD_INTERVAL 375
#define DATE_SUB_INTERVAL 376
#define DATE_SYM 377
#define DAY_HOUR_SYM 378
#define DAY_MICROSECOND_SYM 379
#define DAY_MINUTE_SYM 380
#define DAY_SECOND_SYM 381
#define DAY_SYM 382
#define DEALLOCATE_SYM 383
#define DECIMAL_NUM 384
#define DECIMAL_SYM 385
#define DECLARE_SYM 386
#define DEFAULT 387
#define DEFINER_SYM 388
#define DELAYED_SYM 389
#define DELAY_KEY_WRITE_SYM 390
#define DELETE_SYM 391
#define DESC 392
#define DESCRIBE 393
#define DES_KEY_FILE 394
#define DETERMINISTIC_SYM 395
#define DIAGNOSTICS_SYM 396
#define DIRECTORY_SYM 397
#define DISABLE_SYM 398
#define DISCARD 399
#define DISK_SYM 400
#define DISTINCT 401
#define DIV_SYM 402
#define DOUBLE_SYM 403
#define DO_SYM 404
#define DROP 405
#define DUAL_SYM 406
#define DUMPFILE 407
#define DUPLICATE_SYM 408
#define DYNAMIC_SYM 409
#define EACH_SYM 410
#define ELSE 411
#define ELSEIF_SYM 412
#define ENABLE_SYM 413
#define ENCLOSED 414
#define END 415
#define ENDS_SYM 416
#define END_OF_INPUT 417
#define ENGINES_SYM 418
#define ENGINE_SYM 419
#define ENUM 420
#define EQ 421
#define EQUAL_SYM 422
#define ERROR_SYM 423
#define ERRORS 424
#define ESCAPED 425
#define ESCAPE_SYM 426
#define EVENTS_SYM 427
#define EVENT_SYM 428
#define EVERY_SYM 429
#define EXCHANGE_SYM 430
#define EXAMINED_SYM 431
#define EXECUTE_SYM 432
#define EXISTS 433
#define EXIT_SYM 434
#define EXPANSION_SYM 435
#define EXPORT_SYM 436
#define EXTENDED_SYM 437
#define EXTENT_SIZE_SYM 438
#define EXTRACT_SYM 439
#define FALSE_SYM 440
#define FAST_SYM 441
#define FAULTS_SYM 442
#define FETCH_SYM 443
#define FILE_SYM 444
#define FIRST_SYM 445
#define FIXED_SYM 446
#define FLOAT_NUM 447
#define FLOAT_SYM 448
#define FLUSH_SYM 449
#define FORCE_SYM 450
#define FOREIGN 451
#define FOR_SYM 452
#define FOUND_SYM 453
#define FROM 454
#define FULL 455
#define FULLTEXT_SYM 456
#define FUNCTION_SYM 457
#define GE 458
#define GENERAL 459
#define GENERATED_SYM 460
#define GEOMETRYCOLLECTION 461
#define GEOMETRY_SYM 462
#define GET_FORMAT 463
#define GET_SYM 464
#define GLOBAL_SYM 465
#define GRANT 466
#define GRANTS 467
#define GROUP_SYM 468
#define GROUP_CONCAT_SYM 469
#define GT_SYM 470
#define HANDLER_SYM 471
#define HARD_SYM 472
#define HASH_SYM 473
#define HAVING 474
#define HELP_SYM 475
#define HEX_NUM 476
#define HEX_STRING 477
#define HIGH_PRIORITY 478
#define HOST_SYM 479
#define HOSTS_SYM 480
#define HOUR_MICROSECOND_SYM 481
#define HOUR_MINUTE_SYM 482
#define HOUR_SECOND_SYM 483
#define HOUR_SYM 484
#define ID_SYM 485
#define IDENT 486
#define IDENTIFIED_SYM 487
#define IDENT_QUOTED 488
#define IF 489
#define IGNORE_SYM 490
#define IGNORE_SERVER_IDS_SYM 491
#define IMPORT 492
#define INDEXES 493
#define INDEX_SYM 494
#define INDEX_STATS_SYM 495
#define INFILE 496
#define INITIAL_SIZE_SYM 497
#define INNER_SYM 498
#define INOUT_SYM 499
#define INSENSITIVE_SYM 500
#define INSERT 501
#define INSERT_METHOD 502
#define INSTALL_SYM 503
#define INTERVAL_SYM 504
#define INTO 505
#define INT_SYM 506
#define INVOKER_SYM 507
#define IN_SYM 508
#define IO_SYM 509
#define IPC_SYM 510
#define IS 511
#define ISOLATION 512
#define ISSUER_SYM 513
#define ITERATE_SYM 514
#define JOIN_SYM 515
#define KEYS 516
#define KEY_BLOCK_SIZE 517
#define KEY_SYM 518
#define KILL_SYM 519
#define LANGUAGE_SYM 520
#define LAST_SYM 521
#define LAST_VALUE 522
#define LE 523
#define LEADING 524
#define LEAVES 525
#define LEAVE_SYM 526
#define LEFT 527
#define LESS_SYM 528
#define LEVEL_SYM 529
#define LEX_HOSTNAME 530
#define LIKE 531
#define LIMIT 532
#define LINEAR_SYM 533
#define LINES 534
#define LINESTRING 535
#define LIST_SYM 536
#define LOAD 537
#define LOCAL_SYM 538
#define LOCATOR_SYM 539
#define LOCKS_SYM 540
#define LOCK_SYM 541
#define LOGFILE_SYM 542
#define LOGS_SYM 543
#define LONGBLOB 544
#define LONGTEXT 545
#define LONG_NUM 546
#define LONG_SYM 547
#define LOOP_SYM 548
#define LOW_PRIORITY 549
#define LT 550
#define MASTER_CONNECT_RETRY_SYM 551
#define MASTER_GTID_POS_SYM 552
#define MASTER_HOST_SYM 553
#define MASTER_LOG_FILE_SYM 554
#define MASTER_LOG_POS_SYM 555
#define MASTER_PASSWORD_SYM 556
#define MASTER_PORT_SYM 557
#define MASTER_SERVER_ID_SYM 558
#define MASTER_SSL_CAPATH_SYM 559
#define MASTER_SSL_CA_SYM 560
#define MASTER_SSL_CERT_SYM 561
#define MASTER_SSL_CIPHER_SYM 562
#define MASTER_SSL_CRL_SYM 563
#define MASTER_SSL_CRLPATH_SYM 564
#define MASTER_SSL_KEY_SYM 565
#define MASTER_SSL_SYM 566
#define MASTER_SSL_VERIFY_SERVER_CERT_SYM 567
#define MASTER_SYM 568
#define MASTER_USER_SYM 569
#define MASTER_USE_GTID_SYM 570
#define MASTER_HEARTBEAT_PERIOD_SYM 571
#define MATCH 572
#define MAX_CONNECTIONS_PER_HOUR 573
#define MAX_QUERIES_PER_HOUR 574
#define MAX_ROWS 575
#define MAX_SIZE_SYM 576
#define MAX_SYM 577
#define MAX_UPDATES_PER_HOUR 578
#define MAX_USER_CONNECTIONS_SYM 579
#define MAX_VALUE_SYM 580
#define MEDIUMBLOB 581
#define MEDIUMINT 582
#define MEDIUMTEXT 583
#define MEDIUM_SYM 584
#define MEMORY_SYM 585
#define MERGE_SYM 586
#define MESSAGE_TEXT_SYM 587
#define MICROSECOND_SYM 588
#define MIGRATE_SYM 589
#define MINUTE_MICROSECOND_SYM 590
#define MINUTE_SECOND_SYM 591
#define MINUTE_SYM 592
#define MIN_ROWS 593
#define MIN_SYM 594
#define MODE_SYM 595
#define MODIFIES_SYM 596
#define MODIFY_SYM 597
#define MOD_SYM 598
#define MONTH_SYM 599
#define MULTILINESTRING 600
#define MULTIPOINT 601
#define MULTIPOLYGON 602
#define MUTEX_SYM 603
#define MYSQL_ERRNO_SYM 604
#define NAMES_SYM 605
#define NAME_SYM 606
#define NATIONAL_SYM 607
#define NATURAL 608
#define NCHAR_STRING 609
#define NCHAR_SYM 610
#define NDBCLUSTER_SYM 611
#define NE 612
#define NEG 613
#define NEW_SYM 614
#define NEXT_SYM 615
#define NODEGROUP_SYM 616
#define NONE_SYM 617
#define NOT2_SYM 618
#define NOT_SYM 619
#define NOW_SYM 620
#define NO_SYM 621
#define NO_WAIT_SYM 622
#define NO_WRITE_TO_BINLOG 623
#define NULL_SYM 624
#define NUM 625
#define NUMBER_SYM 626
#define NUMERIC_SYM 627
#define NVARCHAR_SYM 628
#define OFFSET_SYM 629
#define OLD_PASSWORD 630
#define ON 631
#define ONE_SYM 632
#define ONLY_SYM 633
#define ONLINE_SYM 634
#define OPEN_SYM 635
#define OPTIMIZE 636
#define OPTIONS_SYM 637
#define OPTION 638
#define OPTIONALLY 639
#define OR2_SYM 640
#define ORDER_SYM 641
#define OR_OR_SYM 642
#define OR_SYM 643
#define OUTER 644
#define OUTFILE 645
#define OUT_SYM 646
#define OWNER_SYM 647
#define PACK_KEYS_SYM 648
#define PAGE_SYM 649
#define PAGE_CHECKSUM_SYM 650
#define PARAM_MARKER 651
#define PARSER_SYM 652
#define PARSE_VCOL_EXPR_SYM 653
#define PARTIAL 654
#define PARTITION_SYM 655
#define PARTITIONS_SYM 656
#define PARTITIONING_SYM 657
#define PASSWORD 658
#define PERSISTENT_SYM 659
#define PHASE_SYM 660
#define PLUGINS_SYM 661
#define PLUGIN_SYM 662
#define POINT_SYM 663
#define POLYGON 664
#define PORT_SYM 665
#define POSITION_SYM 666
#define PRECISION 667
#define PREPARE_SYM 668
#define PRESERVE_SYM 669
#define PREV_SYM 670
#define PRIMARY_SYM 671
#define PRIVILEGES 672
#define PROCEDURE_SYM 673
#define PROCESS 674
#define PROCESSLIST_SYM 675
#define PROFILE_SYM 676
#define PROFILES_SYM 677
#define PROXY_SYM 678
#define PURGE 679
#define QUARTER_SYM 680
#define QUERY_SYM 681
#define QUICK 682
#define RANGE_SYM 683
#define READS_SYM 684
#define READ_ONLY_SYM 685
#define READ_SYM 686
#define READ_WRITE_SYM 687
#define REAL 688
#define REBUILD_SYM 689
#define RECOVER_SYM 690
#define REDOFILE_SYM 691
#define REDO_BUFFER_SIZE_SYM 692
#define REDUNDANT_SYM 693
#define REFERENCES 694
#define REGEXP 695
#define RELAY 696
#define RELAYLOG_SYM 697
#define RELAY_LOG_FILE_SYM 698
#define RELAY_LOG_POS_SYM 699
#define RELAY_THREAD 700
#define RELEASE_SYM 701
#define RELOAD 702
#define REMOVE_SYM 703
#define RENAME 704
#define REORGANIZE_SYM 705
#define REPAIR 706
#define REPEATABLE_SYM 707
#define REPEAT_SYM 708
#define REPLACE 709
#define REPLICATION 710
#define REQUIRE_SYM 711
#define RESET_SYM 712
#define RESIGNAL_SYM 713
#define RESOURCES 714
#define RESTORE_SYM 715
#define RESTRICT 716
#define RESUME_SYM 717
#define RETURNED_SQLSTATE_SYM 718
#define RETURNING_SYM 719
#define RETURNS_SYM 720
#define RETURN_SYM 721
#define REVERSE_SYM 722
#define REVOKE 723
#define RIGHT 724
#define ROLE_SYM 725
#define ROLLBACK_SYM 726
#define ROLLUP_SYM 727
#define ROUTINE_SYM 728
#define ROWS_SYM 729
#define ROW_FORMAT_SYM 730
#define ROW_SYM 731
#define ROW_COUNT_SYM 732
#define RTREE_SYM 733
#define SAVEPOINT_SYM 734
#define SCHEDULE_SYM 735
#define SCHEMA_NAME_SYM 736
#define SECOND_MICROSECOND_SYM 737
#define SECOND_SYM 738
#define SECURITY_SYM 739
#define SELECT_SYM 740
#define SENSITIVE_SYM 741
#define SEPARATOR_SYM 742
#define SERIALIZABLE_SYM 743
#define SERIAL_SYM 744
#define SESSION_SYM 745
#define SERVER_SYM 746
#define SERVER_OPTIONS 747
#define SET 748
#define SET_VAR 749
#define SHARE_SYM 750
#define SHIFT_LEFT 751
#define SHIFT_RIGHT 752
#define SHOW 753
#define SHUTDOWN 754
#define SIGNAL_SYM 755
#define SIGNED_SYM 756
#define SIMPLE_SYM 757
#define SLAVE 758
#define SLAVES 759
#define SLAVE_POS_SYM 760
#define SLOW 761
#define SMALLINT 762
#define SNAPSHOT_SYM 763
#define SOCKET_SYM 764
#define SOFT_SYM 765
#define SONAME_SYM 766
#define SOUNDS_SYM 767
#define SOURCE_SYM 768
#define SPATIAL_SYM 769
#define SPECIFIC_SYM 770
#define SQLEXCEPTION_SYM 771
#define SQLSTATE_SYM 772
#define SQLWARNING_SYM 773
#define SQL_BIG_RESULT 774
#define SQL_BUFFER_RESULT 775
#define SQL_CACHE_SYM 776
#define SQL_CALC_FOUND_ROWS 777
#define SQL_NO_CACHE_SYM 778
#define SQL_SMALL_RESULT 779
#define SQL_SYM 780
#define SQL_THREAD 781
#define SSL_SYM 782
#define STARTING 783
#define STARTS_SYM 784
#define START_SYM 785
#define STATS_AUTO_RECALC_SYM 786
#define STATS_PERSISTENT_SYM 787
#define STATS_SAMPLE_PAGES_SYM 788
#define STATUS_SYM 789
#define STDDEV_SAMP_SYM 790
#define STD_SYM 791
#define STOP_SYM 792
#define STORAGE_SYM 793
#define STRAIGHT_JOIN 794
#define STRING_SYM 795
#define SUBCLASS_ORIGIN_SYM 796
#define SUBDATE_SYM 797
#define SUBJECT_SYM 798
#define SUBPARTITIONS_SYM 799
#define SUBPARTITION_SYM 800
#define SUBSTRING 801
#define SUM_SYM 802
#define SUPER_SYM 803
#define SUSPEND_SYM 804
#define SWAPS_SYM 805
#define SWITCHES_SYM 806
#define SYSDATE 807
#define TABLES 808
#define TABLESPACE 809
#define TABLE_REF_PRIORITY 810
#define TABLE_STATS_SYM 811
#define TABLE_SYM 812
#define TABLE_CHECKSUM_SYM 813
#define TABLE_NAME_SYM 814
#define TEMPORARY 815
#define TEMPTABLE_SYM 816
#define TERMINATED 817
#define TEXT_STRING 818
#define TEXT_SYM 819
#define THAN_SYM 820
#define THEN_SYM 821
#define TIMESTAMP 822
#define TIMESTAMP_ADD 823
#define TIMESTAMP_DIFF 824
#define TIME_SYM 825
#define TINYBLOB 826
#define TINYINT 827
#define TINYTEXT 828
#define TO_SYM 829
#define TRAILING 830
#define TRANSACTION_SYM 831
#define TRANSACTIONAL_SYM 832
#define TRIGGERS_SYM 833
#define TRIGGER_SYM 834
#define TRIM 835
#define TRUE_SYM 836
#define TRUNCATE_SYM 837
#define TYPES_SYM 838
#define TYPE_SYM 839
#define UDF_RETURNS_SYM 840
#define ULONGLONG_NUM 841
#define UNCOMMITTED_SYM 842
#define UNDEFINED_SYM 843
#define UNDERSCORE_CHARSET 844
#define UNDOFILE_SYM 845
#define UNDO_BUFFER_SIZE_SYM 846
#define UNDO_SYM 847
#define UNICODE_SYM 848
#define UNINSTALL_SYM 849
#define UNION_SYM 850
#define UNIQUE_SYM 851
#define UNKNOWN_SYM 852
#define UNLOCK_SYM 853
#define UNSIGNED 854
#define UNTIL_SYM 855
#define UPDATE_SYM 856
#define UPGRADE_SYM 857
#define USAGE 858
#define USER 859
#define USER_STATS_SYM 860
#define USE_FRM 861
#define USE_SYM 862
#define USING 863
#define UTC_DATE_SYM 864
#define UTC_TIMESTAMP_SYM 865
#define UTC_TIME_SYM 866
#define VALUES 867
#define VALUE_SYM 868
#define VARBINARY 869
#define VARCHAR 870
#define VARIABLES 871
#define VARIANCE_SYM 872
#define VARYING 873
#define VAR_SAMP_SYM 874
#define VIA_SYM 875
#define VIEW_SYM 876
#define VIRTUAL_SYM 877
#define WAIT_SYM 878
#define WARNINGS 879
#define WEEK_SYM 880
#define WEIGHT_STRING_SYM 881
#define WHEN_SYM 882
#define WHERE 883
#define WHILE_SYM 884
#define WITH 885
#define WITH_CUBE_SYM 886
#define WITH_ROLLUP_SYM 887
#define WORK_SYM 888
#define WRAPPER_SYM 889
#define WRITE_SYM 890
#define X509_SYM 891
#define XA_SYM 892
#define XML_SYM 893
#define XOR 894
#define YEAR_MONTH_SYM 895
#define YEAR_SYM 896
#define ZEROFILL 897
#define IMPOSSIBLE_ACTION 898




#if ! defined YYSTYPE && ! defined YYSTYPE_IS_DECLARED
typedef union YYSTYPE
{

/* Line 214 of yacc.c  */
#line 897 "/home/buildbot/bzr/build/sql/sql_yacc.yy"

  int  num;
  ulong ulong_num;
  ulonglong ulonglong_number;
  longlong longlong_number;
  LEX_STRING lex_str;
  LEX_STRING *lex_str_ptr;
  LEX_SYMBOL symbol;
  LEX_TYPE lex_type;
  Table_ident *table;
  char *simple_string;
  Item *item;
  Item_num *item_num;
  List<Item> *item_list;
  List<String> *string_list;
  String *string;
  Key_part_spec *key_part;
  TABLE_LIST *table_list;
  udf_func *udf;
  LEX_USER *lex_user;
  struct sys_var_with_base variable;
  enum enum_var_type var_type;
  Key::Keytype key_type;
  enum ha_key_alg key_alg;
  handlerton *db_type;
  enum row_type row_type;
  enum ha_rkey_function ha_rkey_mode;
  enum enum_tx_isolation tx_isolation;
  enum Cast_target cast_type;
  enum Item_udftype udf_type;
  enum ha_choice choice;
  CHARSET_INFO *charset;
  thr_lock_type lock_type;
  interval_type interval, interval_time_st;
  timestamp_type date_time_type;
  st_select_lex *select_lex;
  chooser_compare_func_creator boolfunc2creator;
  class sp_condition_value *spcondvalue;
  struct { int vars, conds, hndlrs, curs; } spblock;
  sp_name *spname;
  LEX *lex;
  sp_head *sphead;
  struct p_elem_val *p_elem_value;
  enum index_hint_type index_hint;
  enum enum_filetype filetype;
  enum Foreign_key::fk_option m_fk_option;
  enum enum_yes_no_unknown m_yes_no_unk;
  Diag_condition_item_name diag_condition_item_name;
  Diagnostics_information::Which_area diag_area;
  Diagnostics_information *diag_info;
  Statement_information_item *stmt_info_item;
  Statement_information_item::Name stmt_info_item_name;
  List<Statement_information_item> *stmt_info_list;
  Condition_information_item *cond_info_item;
  Condition_information_item::Name cond_info_item_name;
  List<Condition_information_item> *cond_info_list;
  DYNCALL_CREATE_DEF *dyncol_def;
  List<DYNCALL_CREATE_DEF> *dyncol_def_list;
  bool is_not_empty;



/* Line 214 of yacc.c  */
#line 2340 "/home/buildbot/bzr/build/mkdist/sql/sql_yacc.cc"
} YYSTYPE;
# define YYSTYPE_IS_TRIVIAL 1
# define yystype YYSTYPE /* obsolescent; will be withdrawn */
# define YYSTYPE_IS_DECLARED 1
#endif


/* Copy the second part of user declarations.  */

/* Line 264 of yacc.c  */
#line 958 "/home/buildbot/bzr/build/sql/sql_yacc.yy"

bool my_yyoverflow(short **a, YYSTYPE **b, ulong *yystacksize);


/* Line 264 of yacc.c  */
#line 2357 "/home/buildbot/bzr/build/mkdist/sql/sql_yacc.cc"

#ifdef short
# undef short
#endif

#ifdef YYTYPE_UINT8
typedef YYTYPE_UINT8 yytype_uint8;
#else
typedef unsigned char yytype_uint8;
#endif

#ifdef YYTYPE_INT8
typedef YYTYPE_INT8 yytype_int8;
#elif (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
typedef signed char yytype_int8;
#else
typedef short int yytype_int8;
#endif

#ifdef YYTYPE_UINT16
typedef YYTYPE_UINT16 yytype_uint16;
#else
typedef unsigned short int yytype_uint16;
#endif

#ifdef YYTYPE_INT16
typedef YYTYPE_INT16 yytype_int16;
#else
typedef short int yytype_int16;
#endif

#ifndef YYSIZE_T
# ifdef __SIZE_TYPE__
#  define YYSIZE_T __SIZE_TYPE__
# elif defined size_t
#  define YYSIZE_T size_t
# elif ! defined YYSIZE_T && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# else
#  define YYSIZE_T unsigned int
# endif
#endif

#define YYSIZE_MAXIMUM ((YYSIZE_T) -1)

#ifndef YY_
# if YYENABLE_NLS
#  if ENABLE_NLS
#   include <libintl.h> /* INFRINGES ON USER NAME SPACE */
#   define YY_(msgid) dgettext ("bison-runtime", msgid)
#  endif
# endif
# ifndef YY_
#  define YY_(msgid) msgid
# endif
#endif

/* Suppress unused-variable warnings by "using" E.  */
#if ! defined lint || defined __GNUC__
# define YYUSE(e) ((void) (e))
#else
# define YYUSE(e) /* empty */
#endif

/* Identity function, used to suppress warnings about constant conditions.  */
#ifndef lint
# define YYID(n) (n)
#else
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static int
YYID (int yyi)
#else
static int
YYID (yyi)
    int yyi;
#endif
{
  return yyi;
}
#endif

#if ! defined yyoverflow || YYERROR_VERBOSE

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# ifdef YYSTACK_USE_ALLOCA
#  if YYSTACK_USE_ALLOCA
#   ifdef __GNUC__
#    define YYSTACK_ALLOC __builtin_alloca
#   elif defined __BUILTIN_VA_ARG_INCR
#    include <alloca.h> /* INFRINGES ON USER NAME SPACE */
#   elif defined _AIX
#    define YYSTACK_ALLOC __alloca
#   elif defined _MSC_VER
#    include <malloc.h> /* INFRINGES ON USER NAME SPACE */
#    define alloca _alloca
#   else
#    define YYSTACK_ALLOC alloca
#    if ! defined _ALLOCA_H && ! defined _STDLIB_H && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
#     include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#     ifndef _STDLIB_H
#      define _STDLIB_H 1
#     endif
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's `empty if-body' warning.  */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (YYID (0))
#  ifndef YYSTACK_ALLOC_MAXIMUM
    /* The OS might guarantee only one guard page at the bottom of the stack,
       and a page size can be as small as 4096 bytes.  So we cannot safely
       invoke alloca (N) if N exceeds 4096.  Use a slightly smaller number
       to allow for a few compiler-allocated temporary stack slots.  */
#   define YYSTACK_ALLOC_MAXIMUM 4032 /* reasonable circa 2006 */
#  endif
# else
#  define YYSTACK_ALLOC YYMALLOC
#  define YYSTACK_FREE YYFREE
#  ifndef YYSTACK_ALLOC_MAXIMUM
#   define YYSTACK_ALLOC_MAXIMUM YYSIZE_MAXIMUM
#  endif
#  if (defined __cplusplus && ! defined _STDLIB_H \
       && ! ((defined YYMALLOC || defined malloc) \
	     && (defined YYFREE || defined free)))
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   ifndef _STDLIB_H
#    define _STDLIB_H 1
#   endif
#  endif
#  ifndef YYMALLOC
#   define YYMALLOC malloc
#   if ! defined malloc && ! defined _STDLIB_H && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
void *malloc (YYSIZE_T); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
#  ifndef YYFREE
#   define YYFREE free
#   if ! defined free && ! defined _STDLIB_H && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
void free (void *); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
# endif
#endif /* ! defined yyoverflow || YYERROR_VERBOSE */


#if (! defined yyoverflow \
     && (! defined __cplusplus \
	 || (defined YYSTYPE_IS_TRIVIAL && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  yytype_int16 yyss_alloc;
  YYSTYPE yyvs_alloc;
};

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (sizeof (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (sizeof (yytype_int16) + sizeof (YYSTYPE)) \
      + YYSTACK_GAP_MAXIMUM)

/* Copy COUNT objects from FROM to TO.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if defined __GNUC__ && 1 < __GNUC__
#   define YYCOPY(To, From, Count) \
      __builtin_memcpy (To, From, (Count) * sizeof (*(From)))
#  else
#   define YYCOPY(To, From, Count)		\
      do					\
	{					\
	  YYSIZE_T yyi;				\
	  for (yyi = 0; yyi < (Count); yyi++)	\
	    (To)[yyi] = (From)[yyi];		\
	}					\
      while (YYID (0))
#  endif
# endif

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack_alloc, Stack)				\
    do									\
      {									\
	YYSIZE_T yynewbytes;						\
	YYCOPY (&yyptr->Stack_alloc, Stack, yysize);			\
	Stack = &yyptr->Stack_alloc;					\
	yynewbytes = yystacksize * sizeof (*Stack) + YYSTACK_GAP_MAXIMUM; \
	yyptr += yynewbytes / sizeof (*yyptr);				\
      }									\
    while (YYID (0))

#endif

/* YYFINAL -- State number of the termination state.  */
#define YYFINAL  622
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   65642

/* YYNTOKENS -- Number of terminals.  */
#define YYNTOKENS  663
/* YYNNTS -- Number of nonterminals.  */
#define YYNNTS  997
/* YYNRULES -- Number of rules.  */
#define YYNRULES  2820
/* YYNRULES -- Number of states.  */
#define YYNSTATES  4788

/* YYTRANSLATE(YYLEX) -- Bison symbol number corresponding to YYLEX.  */
#define YYUNDEFTOK  2
#define YYMAXUTOK   898

#define YYTRANSLATE(YYX)						\
  ((unsigned int) (YYX) <= YYMAXUTOK ? yytranslate[YYX] : YYUNDEFTOK)

/* YYTRANSLATE[YYLEX] -- Bison symbol number corresponding to YYLEX.  */
static const yytype_uint16 yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,   656,     2,     2,     2,   650,   645,     2,
     653,   654,   648,   647,   655,   646,   661,   649,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,   662,   659,
       2,     2,     2,     2,   660,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,   651,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,   657,   644,   658,   652,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    66,    67,    68,    69,    70,    71,    72,    73,    74,
      75,    76,    77,    78,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    88,    89,    90,    91,    92,    93,    94,
      95,    96,    97,    98,    99,   100,   101,   102,   103,   104,
     105,   106,   107,   108,   109,   110,   111,   112,   113,   114,
     115,   116,   117,   118,   119,   120,   121,   122,   123,   124,
     125,   126,   127,   128,   129,   130,   131,   132,   133,   134,
     135,   136,   137,   138,   139,   140,   141,   142,   143,   144,
     145,   146,   147,   148,   149,   150,   151,   152,   153,   154,
     155,   156,   157,   158,   159,   160,   161,   162,   163,   164,
     165,   166,   167,   168,   169,   170,   171,   172,   173,   174,
     175,   176,   177,   178,   179,   180,   181,   182,   183,   184,
     185,   186,   187,   188,   189,   190,   191,   192,   193,   194,
     195,   196,   197,   198,   199,   200,   201,   202,   203,   204,
     205,   206,   207,   208,   209,   210,   211,   212,   213,   214,
     215,   216,   217,   218,   219,   220,   221,   222,   223,   224,
     225,   226,   227,   228,   229,   230,   231,   232,   233,   234,
     235,   236,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   246,   247,   248,   249,   250,   251,   252,   253,   254,
     255,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,   396,   397,   398,   399,   400,   401,   402,   403,   404,
     405,   406,   407,   408,   409,   410,   411,   412,   413,   414,
     415,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,   427,   428,   429,   430,   431,   432,   433,   434,
     435,   436,   437,   438,   439,   440,   441,   442,   443,   444,
     445,   446,   447,   448,   449,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   460,   461,   462,   463,   464,
     465,   466,   467,   468,   469,   470,   471,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,   482,   483,   484,
     485,   486,   487,   488,   489,   490,   491,   492,   493,   494,
     495,   496,   497,   498,   499,   500,   501,   502,   503,   504,
     505,   506,   507,   508,   509,   510,   511,   512,   513,   514,
     515,   516,   517,   518,   519,   520,   521,   522,   523,   524,
     525,   526,   527,   528,   529,   530,   531,   532,   533,   534,
     535,   536,   537,   538,   539,   540,   541,   542,   543,   544,
     545,   546,   547,   548,   549,   550,   551,   552,   553,   554,
     555,   556,   557,   558,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   572,   573,   574,
     575,   576,   577,   578,   579,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,   592,   593,   594,
     595,   596,   597,   598,   599,   600,   601,   602,   603,   604,
     605,   606,   607,   608,   609,   610,   611,   612,   613,   614,
     615,   616,   617,   618,   619,   620,   621,   622,   623,   624,
     625,   626,   627,   628,   629,   630,   631,   632,   633,   634,
     635,   636,   637,   638,   639,   640,   641,   642,   643
};

#if YYDEBUG
/* YYPRHS[YYN] -- Index of the first RHS symbol of rule number YYN in
   YYRHS.  */
static const yytype_uint16 yyprhs[] =
{
       0,     0,     3,     5,     6,    11,    14,    15,    17,    19,
      21,    23,    25,    27,    29,    31,    33,    35,    37,    39,
      41,    43,    45,    47,    49,    51,    53,    55,    57,    59,
      61,    63,    65,    67,    69,    71,    73,    75,    77,    79,
      81,    83,    85,    87,    89,    91,    93,    95,    97,    99,
     101,   103,   105,   107,   109,   111,   113,   115,   117,   119,
     121,   123,   125,   127,   129,   131,   135,   137,   139,   144,
     146,   149,   150,   155,   156,   159,   163,   165,   168,   169,
     173,   174,   181,   183,   187,   191,   195,   199,   203,   207,
     211,   215,   219,   223,   227,   231,   235,   239,   243,   247,
     253,   255,   256,   258,   262,   264,   268,   272,   276,   280,
     284,   288,   292,   293,   295,   297,   298,   306,   307,   308,
     324,   325,   326,   342,   343,   344,   360,   361,   368,   369,
     373,   378,   384,   389,   393,   396,   407,   409,   413,   416,
     419,   422,   425,   428,   431,   434,   435,   449,   450,   457,
     460,   461,   463,   467,   469,   470,   473,   474,   477,   478,
     480,   484,   489,   490,   493,   494,   497,   499,   501,   503,
     505,   507,   509,   511,   513,   515,   517,   519,   521,   523,
     524,   528,   530,   531,   534,   535,   538,   541,   544,   547,
     550,   554,   558,   560,   562,   564,   567,   571,   575,   576,
     581,   582,   586,   587,   589,   593,   595,   596,   598,   602,
     604,   605,   609,   610,   612,   616,   618,   623,   624,   626,
     628,   630,   631,   635,   638,   642,   643,   647,   648,   654,
     660,   661,   669,   675,   676,   679,   681,   683,   685,   689,
     691,   693,   695,   699,   700,   702,   704,   706,   708,   711,
     713,   717,   719,   721,   722,   724,   725,   728,   732,   738,
     740,   742,   744,   746,   748,   750,   752,   754,   756,   758,
     760,   762,   764,   766,   768,   772,   777,   778,   780,   782,
     786,   788,   792,   796,   798,   801,   803,   805,   807,   809,
     813,   817,   819,   821,   823,   825,   827,   829,   831,   833,
     835,   837,   839,   841,   843,   845,   849,   850,   853,   855,
     857,   859,   861,   863,   865,   867,   869,   871,   873,   875,
     877,   879,   880,   886,   887,   890,   891,   895,   896,   899,
     902,   905,   908,   909,   916,   919,   920,   923,   925,   927,
     931,   932,   933,   934,   942,   943,   946,   949,   951,   953,
     954,   955,   964,   965,   972,   974,   977,   979,   982,   983,
     984,   991,   992,   993,  1000,  1001,  1004,  1005,  1011,  1012,
    1014,  1015,  1021,  1022,  1025,  1026,  1032,  1037,  1038,  1039,
    1048,  1049,  1057,  1059,  1061,  1063,  1065,  1067,  1070,  1075,
    1081,  1082,  1087,  1092,  1097,  1101,  1105,  1108,  1111,  1112,
    1115,  1117,  1120,  1124,  1126,  1128,  1130,  1132,  1134,  1137,
    1141,  1143,  1145,  1147,  1149,  1151,  1153,  1155,  1157,  1159,
    1161,  1164,  1168,  1170,  1172,  1174,  1176,  1178,  1180,  1182,
    1185,  1189,  1191,  1193,  1195,  1197,  1199,  1201,  1203,  1205,
    1207,  1210,  1214,  1216,  1218,  1220,  1223,  1226,  1229,  1231,
    1233,  1235,  1237,  1240,  1244,  1248,  1252,  1256,  1260,  1264,
    1268,  1272,  1277,  1278,  1280,  1282,  1284,  1286,  1288,  1289,
    1297,  1301,  1302,  1308,  1310,  1313,  1318,  1319,  1320,  1326,
    1327,  1335,  1337,  1338,  1340,  1341,  1346,  1347,  1348,  1352,
    1358,  1365,  1366,  1371,  1374,  1377,  1380,  1383,  1384,  1386,
    1387,  1391,  1392,  1394,  1396,  1400,  1402,  1407,  1413,  1419,
    1420,  1423,  1424,  1425,  1433,  1434,  1445,  1447,  1451,  1453,
    1455,  1456,  1459,  1460,  1464,  1466,  1470,  1471,  1478,  1480,
    1481,  1482,  1488,  1489,  1494,  1496,  1498,  1500,  1504,  1506,
    1510,  1511,  1512,  1518,  1520,  1524,  1526,  1528,  1529,  1533,
    1535,  1539,  1540,  1545,  1547,  1548,  1550,  1553,  1555,  1559,
    1564,  1568,  1572,  1576,  1580,  1585,  1590,  1594,  1595,  1596,
    1603,  1604,  1606,  1607,  1609,  1611,  1614,  1616,  1618,  1619,
    1621,  1623,  1626,  1628,  1629,  1633,  1635,  1639,  1640,  1642,
    1644,  1647,  1649,  1652,  1656,  1660,  1664,  1668,  1672,  1676,
    1680,  1684,  1688,  1692,  1696,  1700,  1704,  1708,  1712,  1716,
    1720,  1724,  1728,  1732,  1736,  1737,  1744,  1746,  1748,  1752,
    1757,  1762,  1765,  1768,  1771,  1775,  1779,  1783,  1787,  1791,
    1795,  1799,  1804,  1809,  1811,  1813,  1815,  1817,  1819,  1821,
    1823,  1825,  1827,  1829,  1831,  1833,  1835,  1838,  1840,  1842,
    1844,  1846,  1848,  1850,  1854,  1856,  1858,  1861,  1864,  1865,
    1874,  1875,  1885,  1886,  1896,  1897,  1907,  1916,  1919,  1920,
    1922,  1927,  1928,  1930,  1933,  1934,  1938,  1941,  1942,  1952,
    1953,  1956,  1957,  1959,  1961,  1962,  1964,  1967,  1969,  1971,
    1974,  1977,  1982,  1986,  1990,  1994,  1998,  2000,  2003,  2005,
    2007,  2011,  2014,  2018,  2021,  2024,  2026,  2030,  2034,  2037,
    2041,  2043,  2046,  2049,  2052,  2054,  2057,  2059,  2061,  2063,
    2066,  2070,  2073,  2077,  2080,  2083,  2087,  2091,  2095,  2096,
    2103,  2104,  2111,  2114,  2116,  2118,  2120,  2122,  2124,  2126,
    2128,  2130,  2132,  2134,  2136,  2139,  2142,  2144,  2147,  2149,
    2152,  2156,  2159,  2161,  2163,  2165,  2167,  2169,  2171,  2173,
    2176,  2177,  2179,  2181,  2187,  2188,  2190,  2193,  2195,  2197,
    2199,  2201,  2205,  2209,  2213,  2217,  2218,  2220,  2221,  2223,
    2224,  2226,  2229,  2231,  2233,  2236,  2239,  2244,  2246,  2250,
    2253,  2255,  2258,  2261,  2264,  2268,  2272,  2276,  2280,  2283,
    2286,  2288,  2291,  2293,  2295,  2297,  2299,  2301,  2302,  2305,
    2307,  2309,  2311,  2313,  2315,  2316,  2319,  2321,  2323,  2324,
    2326,  2328,  2331,  2334,  2336,  2339,  2342,  2343,  2345,  2347,
    2349,  2353,  2355,  2359,  2360,  2362,  2363,  2368,  2370,  2372,
    2374,  2375,  2377,  2380,  2382,  2384,  2387,  2389,  2393,  2397,
    2399,  2401,  2402,  2405,  2406,  2408,  2414,  2415,  2419,  2423,
    2425,  2426,  2429,  2432,  2435,  2436,  2440,  2444,  2451,  2458,
    2460,  2462,  2465,  2468,  2471,  2473,  2476,  2479,  2481,  2483,
    2484,  2486,  2488,  2490,  2492,  2493,  2495,  2497,  2499,  2500,
    2502,  2505,  2506,  2508,  2509,  2511,  2512,  2514,  2516,  2519,
    2521,  2524,  2526,  2529,  2532,  2535,  2539,  2542,  2546,  2550,
    2554,  2558,  2560,  2562,  2564,  2566,  2570,  2572,  2574,  2576,
    2581,  2584,  2586,  2591,  2592,  2594,  2597,  2598,  2601,  2603,
    2607,  2608,  2609,  2617,  2618,  2624,  2632,  2633,  2639,  2640,
    2646,  2647,  2653,  2654,  2659,  2660,  2671,  2675,  2680,  2684,
    2688,  2696,  2697,  2701,  2703,  2708,  2709,  2713,  2714,  2717,
    2718,  2720,  2721,  2724,  2727,  2730,  2733,  2735,  2737,  2739,
    2744,  2749,  2750,  2757,  2762,  2763,  2769,  2770,  2777,  2782,
    2786,  2788,  2796,  2799,  2801,  2803,  2804,  2811,  2812,  2816,
    2819,  2820,  2826,  2827,  2828,  2835,  2837,  2841,  2843,  2845,
    2849,  2853,  2857,  2860,  2865,  2866,  2874,  2875,  2876,  2885,
    2891,  2897,  2901,  2906,  2909,  2912,  2919,  2925,  2929,  2935,
    2937,  2939,  2941,  2943,  2945,  2946,  2948,  2950,  2953,  2956,
    2960,  2964,  2968,  2972,  2973,  2975,  2976,  2978,  2979,  2982,
    2983,  2985,  2988,  2990,  2992,  2994,  2995,  2997,  2999,  3000,
    3003,  3005,  3006,  3008,  3010,  3012,  3013,  3020,  3021,  3027,
    3032,  3037,  3041,  3042,  3044,  3046,  3050,  3054,  3057,  3060,
    3061,  3064,  3066,  3070,  3071,  3073,  3075,  3076,  3079,  3084,
    3086,  3090,  3091,  3097,  3098,  3100,  3102,  3103,  3110,  3111,
    3113,  3115,  3118,  3120,  3122,  3124,  3125,  3131,  3133,  3137,
    3140,  3141,  3145,  3147,  3152,  3154,  3155,  3160,  3162,  3163,
    3168,  3169,  3171,  3175,  3176,  3178,  3182,  3184,  3186,  3189,
    3190,  3196,  3197,  3199,  3201,  3204,  3206,  3208,  3210,  3212,
    3214,  3217,  3218,  3224,  3225,  3227,  3229,  3230,  3235,  3240,
    3244,  3250,  3252,  3256,  3260,  3261,  3268,  3270,  3272,  3274,
    3278,  3281,  3285,  3287,  3289,  3290,  3297,  3299,  3301,  3303,
    3307,  3311,  3316,  3317,  3324,  3325,  3328,  3329,  3334,  3335,
    3338,  3340,  3343,  3348,  3351,  3355,  3358,  3362,  3363,  3367,
    3368,  3369,  3376,  3379,  3381,  3383,  3386,  3389,  3398,  3403,
    3404,  3406,  3409,  3411,  3413,  3415,  3417,  3418,  3421,  3426,
    3430,  3432,  3434,  3438,  3443,  3444,  3445,  3446,  3449,  3452,
    3454,  3456,  3457,  3460,  3464,  3465,  3468,  3472,  3473,  3476,
    3480,  3484,  3488,  3491,  3495,  3500,  3504,  3509,  3513,  3518,
    3520,  3524,  3529,  3533,  3537,  3544,  3546,  3552,  3559,  3565,
    3573,  3580,  3589,  3595,  3602,  3607,  3612,  3618,  3622,  3627,
    3629,  3633,  3637,  3641,  3645,  3649,  3653,  3659,  3665,  3669,
    3673,  3677,  3681,  3685,  3689,  3691,  3693,  3695,  3697,  3699,
    3701,  3703,  3705,  3707,  3709,  3711,  3713,  3715,  3717,  3719,
    3721,  3723,  3724,  3727,  3729,  3732,  3734,  3736,  3738,  3741,
    3744,  3746,  3748,  3751,  3754,  3759,  3761,  3765,  3767,  3769,
    3771,  3773,  3775,  3779,  3781,  3783,  3785,  3787,  3791,  3794,
    3797,  3800,  3803,  3807,  3811,  3817,  3824,  3829,  3834,  3842,
    3845,  3852,  3858,  3865,  3872,  3877,  3882,  3888,  3893,  3900,
    3903,  3906,  3911,  3916,  3921,  3932,  3939,  3948,  3955,  3960,
    3965,  3972,  3977,  3982,  3987,  3994,  3999,  4007,  4015,  4023,
    4030,  4037,  4044,  4051,  4055,  4060,  4067,  4076,  4079,  4082,
    4091,  4100,  4107,  4114,  4117,  4124,  4131,  4140,  4149,  4156,
    4165,  4172,  4175,  4184,  4193,  4196,  4199,  4202,  4209,  4216,
    4221,  4226,  4235,  4240,  4245,  4250,  4255,  4259,  4268,  4273,
    4278,  4285,  4290,  4295,  4300,  4307,  4316,  4321,  4325,  4332,
    4337,  4344,  4350,  4359,  4367,  4378,  4380,  4387,  4392,  4397,
    4402,  4407,  4412,  4419,  4424,  4425,  4431,  4438,  4441,  4445,
    4446,  4451,  4452,  4456,  4457,  4459,  4461,  4465,  4470,  4475,
    4481,  4486,  4491,  4496,  4502,  4507,  4508,  4509,  4517,  4522,
    4528,  4533,  4539,  4544,  4549,  4554,  4559,  4564,  4570,  4571,
    4580,  4581,  4585,  4589,  4591,  4596,  4597,  4599,  4600,  4603,
    4604,  4605,  4610,  4615,  4618,  4619,  4623,  4626,  4630,  4633,
    4635,  4637,  4640,  4642,  4645,  4647,  4650,  4653,  4656,  4657,
    4661,  4662,  4664,  4666,  4670,  4672,  4676,  4678,  4682,  4683,
    4685,  4686,  4689,  4694,  4700,  4702,  4704,  4706,  4708,  4713,
    4715,  4719,  4723,  4724,  4731,  4732,  4741,  4746,  4747,  4756,
    4757,  4768,  4775,  4776,  4785,  4786,  4797,  4804,  4806,  4809,
    4811,  4813,  4816,  4817,  4819,  4825,  4826,  4832,  4836,  4842,
    4845,  4846,  4847,  4855,  4857,  4858,  4859,  4866,  4867,  4871,
    4872,  4873,  4879,  4880,  4882,  4883,  4885,  4886,  4889,  4893,
    4897,  4899,  4901,  4902,  4910,  4911,  4919,  4921,  4924,  4925,
    4926,  4929,  4930,  4933,  4934,  4936,  4938,  4940,  4942,  4946,
    4948,  4952,  4954,  4956,  4958,  4960,  4962,  4964,  4966,  4968,
    4970,  4972,  4974,  4976,  4978,  4980,  4982,  4984,  4986,  4988,
    4990,  4992,  4994,  4996,  4998,  5000,  5002,  5003,  5005,  5007,
    5008,  5011,  5012,  5014,  5015,  5016,  5020,  5021,  5022,  5026,
    5029,  5030,  5031,  5036,  5041,  5044,  5045,  5047,  5049,  5053,
    5057,  5059,  5062,  5063,  5065,  5066,  5071,  5076,  5079,  5080,
    5082,  5084,  5085,  5087,  5088,  5090,  5093,  5099,  5104,  5106,
    5110,  5114,  5116,  5118,  5120,  5122,  5124,  5126,  5127,  5130,
    5134,  5139,  5141,  5144,  5147,  5149,  5151,  5153,  5155,  5157,
    5159,  5161,  5163,  5165,  5167,  5169,  5171,  5173,  5175,  5177,
    5179,  5181,  5183,  5185,  5187,  5189,  5191,  5193,  5195,  5197,
    5199,  5200,  5201,  5208,  5209,  5211,  5215,  5217,  5221,  5222,
    5225,  5229,  5231,  5234,  5236,  5237,  5241,  5242,  5243,  5251,
    5254,  5256,  5257,  5261,  5262,  5270,  5271,  5279,  5284,  5291,
    5296,  5301,  5306,  5311,  5312,  5319,  5324,  5329,  5335,  5342,
    5347,  5349,  5353,  5355,  5358,  5360,  5364,  5366,  5367,  5370,
    5371,  5373,  5374,  5375,  5384,  5385,  5386,  5393,  5394,  5396,
    5398,  5400,  5402,  5404,  5407,  5409,  5411,  5413,  5417,  5422,
    5423,  5427,  5431,  5433,  5436,  5439,  5440,  5444,  5445,  5451,
    5455,  5457,  5461,  5463,  5467,  5469,  5471,  5472,  5474,  5475,
    5480,  5481,  5483,  5487,  5489,  5491,  5493,  5494,  5495,  5502,
    5503,  5504,  5516,  5520,  5522,  5526,  5530,  5532,  5536,  5537,
    5539,  5540,  5545,  5546,  5547,  5557,  5558,  5564,  5565,  5572,
    5573,  5576,  5578,  5582,  5585,  5590,  5591,  5594,  5595,  5598,
    5600,  5602,  5604,  5605,  5610,  5611,  5613,  5614,  5616,  5618,
    5622,  5624,  5626,  5629,  5632,  5635,  5637,  5639,  5641,  5643,
    5644,  5648,  5649,  5653,  5656,  5661,  5666,  5670,  5675,  5680,
    5682,  5686,  5690,  5694,  5698,  5705,  5708,  5711,  5712,  5719,
    5720,  5728,  5734,  5737,  5739,  5741,  5743,  5749,  5755,  5758,
    5761,  5763,  5768,  5772,  5775,  5779,  5782,  5785,  5787,  5791,
    5796,  5800,  5804,  5807,  5811,  5814,  5818,  5820,  5822,  5824,
    5826,  5830,  5834,  5838,  5842,  5846,  5850,  5854,  5858,  5862,
    5864,  5866,  5868,  5870,  5872,  5873,  5875,  5876,  5879,  5880,
    5882,  5884,  5886,  5887,  5890,  5891,  5894,  5895,  5898,  5901,
    5902,  5907,  5908,  5913,  5915,  5917,  5919,  5921,  5923,  5925,
    5927,  5928,  5930,  5932,  5933,  5935,  5937,  5938,  5943,  5944,
    5949,  5951,  5952,  5954,  5959,  5960,  5964,  5968,  5970,  5973,
    5976,  5979,  5982,  5985,  5989,  5992,  5994,  5996,  5998,  6000,
    6003,  6005,  6007,  6009,  6011,  6013,  6015,  6017,  6018,  6020,
    6021,  6025,  6026,  6030,  6034,  6036,  6037,  6042,  6044,  6047,
    6048,  6050,  6051,  6055,  6059,  6062,  6065,  6066,  6072,  6073,
    6075,  6077,  6078,  6080,  6082,  6085,  6087,  6090,  6092,  6095,
    6096,  6097,  6098,  6099,  6122,  6124,  6126,  6127,  6129,  6130,
    6132,  6134,  6135,  6137,  6139,  6140,  6143,  6146,  6148,  6152,
    6157,  6161,  6165,  6166,  6169,  6172,  6174,  6178,  6182,  6183,
    6188,  6189,  6193,  6195,  6197,  6198,  6202,  6205,  6209,  6211,
    6213,  6216,  6217,  6220,  6224,  6226,  6232,  6234,  6236,  6239,
    6242,  6244,  6246,  6248,  6250,  6252,  6254,  6256,  6259,  6262,
    6264,  6266,  6268,  6270,  6272,  6274,  6276,  6278,  6280,  6283,
    6285,  6287,  6289,  6291,  6293,  6296,  6299,  6302,  6304,  6306,
    6310,  6316,  6318,  6320,  6322,  6324,  6326,  6330,  6335,  6341,
    6343,  6349,  6353,  6356,  6358,  6362,  6365,  6368,  6373,  6375,
    6377,  6379,  6381,  6383,  6385,  6387,  6389,  6391,  6393,  6395,
    6397,  6399,  6401,  6405,  6408,  6410,  6412,  6414,  6416,  6418,
    6420,  6422,  6424,  6426,  6428,  6430,  6432,  6434,  6436,  6438,
    6440,  6442,  6444,  6446,  6448,  6450,  6452,  6454,  6456,  6458,
    6460,  6462,  6464,  6466,  6468,  6470,  6472,  6474,  6476,  6478,
    6480,  6482,  6484,  6486,  6488,  6490,  6492,  6494,  6496,  6498,
    6500,  6502,  6504,  6506,  6508,  6510,  6512,  6514,  6516,  6518,
    6520,  6522,  6524,  6526,  6528,  6530,  6532,  6534,  6536,  6538,
    6540,  6542,  6544,  6546,  6548,  6550,  6552,  6554,  6556,  6558,
    6560,  6562,  6564,  6566,  6568,  6570,  6572,  6574,  6576,  6578,
    6580,  6582,  6584,  6586,  6588,  6590,  6592,  6594,  6596,  6598,
    6600,  6602,  6604,  6606,  6608,  6610,  6612,  6614,  6616,  6618,
    6620,  6622,  6624,  6626,  6628,  6630,  6632,  6634,  6636,  6638,
    6640,  6642,  6644,  6646,  6648,  6650,  6652,  6654,  6656,  6658,
    6660,  6662,  6664,  6666,  6668,  6670,  6672,  6674,  6676,  6678,
    6680,  6682,  6684,  6686,  6688,  6690,  6692,  6694,  6696,  6698,
    6700,  6702,  6704,  6706,  6708,  6710,  6712,  6714,  6716,  6718,
    6720,  6722,  6724,  6726,  6728,  6730,  6732,  6734,  6736,  6738,
    6740,  6742,  6744,  6746,  6748,  6750,  6752,  6754,  6756,  6758,
    6760,  6762,  6764,  6766,  6768,  6770,  6772,  6774,  6776,  6778,
    6780,  6782,  6784,  6786,  6788,  6790,  6792,  6794,  6796,  6798,
    6800,  6802,  6804,  6806,  6808,  6810,  6812,  6814,  6816,  6818,
    6820,  6822,  6824,  6826,  6828,  6830,  6832,  6834,  6836,  6838,
    6840,  6842,  6844,  6846,  6848,  6850,  6852,  6854,  6856,  6858,
    6860,  6862,  6864,  6866,  6868,  6870,  6872,  6874,  6876,  6878,
    6880,  6882,  6884,  6886,  6888,  6890,  6892,  6894,  6896,  6898,
    6900,  6902,  6904,  6906,  6908,  6910,  6912,  6914,  6916,  6918,
    6920,  6922,  6924,  6926,  6928,  6930,  6932,  6934,  6936,  6938,
    6940,  6942,  6944,  6946,  6948,  6950,  6952,  6954,  6956,  6958,
    6960,  6962,  6964,  6966,  6968,  6970,  6972,  6974,  6976,  6978,
    6980,  6982,  6984,  6986,  6988,  6990,  6992,  6994,  6996,  6998,
    7000,  7002,  7004,  7006,  7008,  7010,  7012,  7014,  7016,  7018,
    7020,  7022,  7024,  7026,  7028,  7030,  7032,  7034,  7036,  7038,
    7040,  7042,  7044,  7046,  7048,  7050,  7052,  7054,  7056,  7058,
    7060,  7062,  7064,  7066,  7068,  7070,  7072,  7074,  7076,  7078,
    7080,  7082,  7084,  7086,  7088,  7090,  7092,  7094,  7096,  7098,
    7100,  7102,  7104,  7106,  7108,  7110,  7112,  7114,  7116,  7118,
    7120,  7122,  7124,  7126,  7128,  7130,  7132,  7134,  7136,  7138,
    7140,  7142,  7144,  7146,  7148,  7150,  7152,  7154,  7155,  7159,
    7160,  7164,  7165,  7169,  7170,  7174,  7175,  7179,  7182,  7183,
    7186,  7187,  7190,  7191,  7196,  7197,  7201,  7203,  7205,  7207,
    7209,  7210,  7212,  7214,  7216,  7217,  7220,  7223,  7226,  7230,
    7234,  7239,  7246,  7249,  7253,  7257,  7260,  7264,  7270,  7272,
    7276,  7280,  7282,  7284,  7288,  7292,  7294,  7298,  7301,  7304,
    7307,  7310,  7313,  7315,  7317,  7322,  7327,  7329,  7331,  7333,
    7335,  7337,  7338,  7343,  7345,  7347,  7349,  7353,  7357,  7359,
    7361,  7364,  7367,  7370,  7371,  7375,  7380,  7384,  7385,  7393,
    7395,  7398,  7400,  7402,  7404,  7406,  7408,  7410,  7411,  7417,
    7419,  7421,  7423,  7425,  7427,  7431,  7438,  7445,  7452,  7460,
    7466,  7470,  7475,  7477,  7481,  7490,  7499,  7508,  7515,  7520,
    7521,  7525,  7526,  7530,  7532,  7536,  7539,  7541,  7543,  7544,
    7546,  7548,  7551,  7552,  7554,  7556,  7560,  7561,  7565,  7566,
    7570,  7571,  7575,  7576,  7580,  7582,  7584,  7586,  7588,  7590,
    7592,  7594,  7596,  7598,  7600,  7602,  7605,  7608,  7610,  7614,
    7617,  7620,  7623,  7626,  7629,  7632,  7635,  7638,  7640,  7642,
    7645,  7646,  7648,  7652,  7654,  7657,  7660,  7663,  7665,  7669,
    7673,  7675,  7677,  7681,  7683,  7687,  7689,  7693,  7695,  7697,
    7699,  7701,  7706,  7712,  7717,  7724,  7726,  7727,  7731,  7735,
    7737,  7739,  7740,  7743,  7746,  7749,  7752,  7753,  7756,  7757,
    7761,  7764,  7766,  7769,  7772,  7775,  7778,  7781,  7782,  7786,
    7787,  7789,  7790,  7794,  7797,  7798,  7800,  7803,  7804,  7806,
    7811,  7816,  7822,  7825,  7829,  7830,  7832,  7833,  7838,  7839,
    7841,  7843,  7844,  7846,  7847,  7850,  7853,  7855,  7856,  7858,
    7860,  7863,  7867,  7870,  7871,  7878,  7882,  7883,  7884,  7885,
    7887,  7890,  7892,  7894,  7896,  7898,  7900,  7902,  7904,  7906,
    7908,  7911,  7914,  7918,  7920,  7922,  7924,  7926,  7928,  7930,
    7932,  7934,  7936,  7938,  7940,  7942,  7944,  7945,  7949,  7953,
    7957,  7961,  7962,  7966,  7970,  7971,  7979,  7980,  7984,  7986,
    7990,  7991,  7995,  7998,  8003,  8004,  8008,  8013,  8018,  8019,
    8020,  8021,  8038,  8047,  8055,  8056,  8057,  8058,  8059,  8060,
    8076,  8077,  8078,  8079,  8080,  8093,  8098,  8103,  8107,  8112,
    8116,  8119,  8121,  8125,  8131,  8133,  8135,  8136,  8138,  8140,
    8141,  8144,  8145,  8146,  8150,  8151,  8154,  8160,  8164,  8168,
    8172
};

/* YYRHS -- A `-1'-separated list of the rules' RHS.  */
static const yytype_int16 yyrhs[] =
{
     664,     0,    -1,   162,    -1,    -1,   667,   665,   659,   666,
      -1,   667,   162,    -1,    -1,   162,    -1,   668,    -1,  1589,
      -1,  1054,    -1,  1122,    -1,  1135,    -1,   722,    -1,   680,
      -1,  1136,    -1,  1114,    -1,  1595,    -1,   689,    -1,   669,
      -1,  1387,    -1,  1421,    -1,  1338,    -1,  1340,    -1,   673,
      -1,  1428,    -1,   758,    -1,  1555,    -1,  1545,    -1,   678,
      -1,  1351,    -1,  1657,    -1,  1659,    -1,  1149,    -1,  1449,
      -1,  1456,    -1,  1537,    -1,  1141,    -1,   969,    -1,   877,
      -1,  1156,    -1,   671,    -1,  1445,    -1,  1598,    -1,  1144,
      -1,  1117,    -1,  1354,    -1,  1439,    -1,   757,    -1,  1552,
      -1,  1596,    -1,  1597,    -1,  1168,    -1,  1510,    -1,   750,
      -1,  1407,    -1,  1454,    -1,  1101,    -1,  1104,    -1,  1400,
      -1,  1658,    -1,  1543,    -1,  1379,    -1,  1455,    -1,  1649,
      -1,   670,   413,  1502,    -1,   128,    -1,   150,    -1,   413,
    1502,   199,   672,    -1,  1499,    -1,   660,  1504,    -1,    -1,
     177,  1502,   674,   675,    -1,    -1,   608,   676,    -1,   676,
     655,   677,    -1,   677,    -1,   660,  1504,    -1,    -1,   220,
     679,  1504,    -1,    -1,    59,   313,   687,   574,   681,   682,
      -1,   683,    -1,   682,   655,   683,    -1,   298,   166,  1499,
      -1,   314,   166,  1499,    -1,   301,   166,  1499,    -1,   302,
     166,  1317,    -1,   296,   166,  1317,    -1,   311,   166,  1317,
      -1,   305,   166,  1499,    -1,   304,   166,  1499,    -1,   306,
     166,  1499,    -1,   307,   166,  1499,    -1,   310,   166,  1499,
      -1,   312,   166,  1317,    -1,   308,   166,  1499,    -1,   309,
     166,  1499,    -1,   316,   166,  1486,    -1,   236,   166,   653,
     684,   654,    -1,   686,    -1,    -1,   685,    -1,   684,   655,
     685,    -1,  1317,    -1,   299,   166,  1499,    -1,   300,   166,
    1319,    -1,   443,   166,  1499,    -1,   444,   166,  1317,    -1,
     315,   166,   111,    -1,   315,   166,   505,    -1,   315,   166,
     366,    -1,    -1,   688,    -1,  1499,    -1,    -1,   933,   929,
     557,   932,  1495,   690,   865,    -1,    -1,    -1,   104,  1031,
     239,   932,  1502,  1035,   376,  1495,   691,   653,  1048,   654,
    1036,   692,  1088,    -1,    -1,    -1,   104,  1032,   239,   932,
    1502,  1034,   376,  1495,   693,   653,  1048,   654,  1037,   694,
    1088,    -1,    -1,    -1,   104,  1033,   239,   932,  1502,  1034,
     376,  1495,   695,   653,  1048,   654,  1038,   696,  1088,    -1,
      -1,   104,   115,   932,  1502,   697,   926,    -1,    -1,   933,
     698,  1617,    -1,   104,   604,   715,  1576,    -1,   104,   470,
     715,  1559,  1557,    -1,   104,   287,   213,   828,    -1,   104,
     554,   825,    -1,   104,   699,    -1,   491,  1504,   196,   118,
     634,  1504,   382,   653,   700,   654,    -1,   701,    -1,   700,
     655,   701,    -1,   604,  1499,    -1,   224,  1499,    -1,   115,
    1499,    -1,   392,  1499,    -1,   403,  1499,    -1,   509,  1499,
      -1,   410,  1317,    -1,    -1,  1185,   173,   932,   716,   703,
     376,   480,   704,   709,   706,   711,   149,   712,    -1,    -1,
     174,  1191,  1287,   705,   707,   708,    -1,    24,  1191,    -1,
      -1,   158,    -1,   143,   376,   503,    -1,   143,    -1,    -1,
     529,  1191,    -1,    -1,   161,  1191,    -1,    -1,   710,    -1,
     376,    87,   414,    -1,   376,    87,   364,   414,    -1,    -1,
      83,  1499,    -1,    -1,   713,   714,    -1,   774,    -1,   776,
      -1,   772,    -1,   793,    -1,   811,    -1,   813,    -1,   808,
      -1,   778,    -1,   780,    -1,   781,    -1,   782,    -1,   783,
      -1,   785,    -1,    -1,  1502,   661,  1502,    -1,  1502,    -1,
      -1,   717,   719,    -1,    -1,   718,   720,    -1,    83,  1499,
      -1,   265,   525,    -1,   366,   525,    -1,    97,   525,    -1,
     429,   525,   118,    -1,   341,   525,   118,    -1,   721,    -1,
     719,    -1,   140,    -1,  1197,   140,    -1,   525,   484,   133,
      -1,   525,   484,   252,    -1,    -1,    52,   716,   723,   724,
      -1,    -1,   653,   725,   654,    -1,    -1,   726,    -1,   726,
     655,  1191,    -1,  1191,    -1,    -1,   728,    -1,   728,   655,
     730,    -1,   730,    -1,    -1,  1502,   729,   992,    -1,    -1,
     732,    -1,   732,   655,   733,    -1,   733,    -1,   734,   729,
    1502,   992,    -1,    -1,   253,    -1,   391,    -1,   244,    -1,
      -1,   735,   771,   659,    -1,   771,   659,    -1,   736,   771,
     659,    -1,    -1,   737,   738,   659,    -1,    -1,   131,   769,
     739,   992,   770,    -1,   131,  1502,    90,   197,   746,    -1,
      -1,   131,   743,   216,   197,   740,   744,   771,    -1,   131,
    1502,   112,   197,   741,    -1,    -1,   742,  1168,    -1,   179,
      -1,    99,    -1,   745,    -1,   744,   655,   745,    -1,   749,
      -1,  1317,    -1,   747,    -1,   517,   748,  1500,    -1,    -1,
     613,    -1,   746,    -1,  1502,    -1,   518,    -1,  1197,   198,
      -1,   516,    -1,   500,   751,   753,    -1,  1502,    -1,   747,
      -1,    -1,   751,    -1,    -1,   493,   754,    -1,   756,   166,
     755,    -1,   754,   655,   756,   166,   755,    -1,  1485,    -1,
    1222,    -1,  1491,    -1,    67,    -1,   541,    -1,    94,    -1,
      96,    -1,    95,    -1,    57,    -1,   481,    -1,   559,    -1,
      82,    -1,   113,    -1,   332,    -1,   349,    -1,   458,   752,
     753,    -1,   209,   759,   141,   760,    -1,    -1,   108,    -1,
     761,    -1,    90,   765,   766,    -1,   762,    -1,   761,   655,
     762,    -1,   763,   166,   764,    -1,  1502,    -1,   660,  1504,
      -1,   371,    -1,   477,    -1,   755,    -1,   767,    -1,   766,
     655,   767,    -1,   763,   166,   768,    -1,    67,    -1,   541,
      -1,    94,    -1,    96,    -1,    95,    -1,    57,    -1,   481,
      -1,   559,    -1,    82,    -1,   113,    -1,   332,    -1,   349,
      -1,   463,    -1,  1502,    -1,   769,   655,  1502,    -1,    -1,
     132,  1191,    -1,   774,    -1,   776,    -1,   772,    -1,   793,
      -1,   811,    -1,   813,    -1,   808,    -1,   778,    -1,   780,
      -1,   781,    -1,   782,    -1,   783,    -1,   785,    -1,    -1,
     234,   773,   788,   160,   234,    -1,    -1,   775,   668,    -1,
      -1,   466,   777,  1191,    -1,    -1,   779,   817,    -1,   271,
    1503,    -1,   259,  1503,    -1,   380,  1502,    -1,    -1,   188,
     786,  1502,   250,   784,   787,    -1,    70,  1502,    -1,    -1,
     360,   199,    -1,   199,    -1,  1502,    -1,   787,   655,  1502,
      -1,    -1,    -1,    -1,   789,  1191,   566,   790,   736,   791,
     792,    -1,    -1,   157,   788,    -1,   156,   736,    -1,   794,
      -1,   797,    -1,    -1,    -1,    55,   795,  1191,   796,   799,
     807,   160,    55,    -1,    -1,    55,   798,   800,   807,   160,
      55,    -1,   801,    -1,   799,   801,    -1,   804,    -1,   800,
     804,    -1,    -1,    -1,   627,   802,  1191,   803,   566,   736,
      -1,    -1,    -1,   627,   805,  1191,   806,   566,   736,    -1,
      -1,   156,   736,    -1,    -1,  1503,   662,   809,   817,   810,
      -1,    -1,  1503,    -1,    -1,  1503,   662,   812,   815,   810,
      -1,    -1,   814,   815,    -1,    -1,    33,   816,   737,   735,
     160,    -1,   293,   736,   160,   293,    -1,    -1,    -1,   629,
     818,  1191,   149,   819,   736,   160,   629,    -1,    -1,   453,
     736,   600,   820,  1191,   160,   453,    -1,    32,    -1,     9,
      -1,   246,    -1,   601,    -1,   136,    -1,   850,   852,    -1,
     850,    59,   847,   831,    -1,   850,     6,   847,   826,   835,
      -1,    -1,   607,   287,   213,  1502,    -1,   850,     6,   847,
     838,    -1,   850,   150,   847,   838,    -1,   851,   830,   841,
      -1,   851,   830,   844,    -1,     6,   848,    -1,     6,   849,
      -1,    -1,   832,   833,    -1,   834,    -1,   833,   834,    -1,
     833,   655,   834,    -1,   853,    -1,   854,    -1,   855,    -1,
     836,    -1,   837,    -1,   836,   837,    -1,   836,   655,   837,
      -1,   853,    -1,   854,    -1,   855,    -1,   856,    -1,   859,
      -1,   861,    -1,   863,    -1,   860,    -1,   839,    -1,   840,
      -1,   839,   840,    -1,   839,   655,   840,    -1,   853,    -1,
     854,    -1,   855,    -1,   861,    -1,   863,    -1,   842,    -1,
     843,    -1,   842,   843,    -1,   842,   655,   843,    -1,   853,
      -1,   857,    -1,   858,    -1,   859,    -1,   861,    -1,   863,
      -1,   860,    -1,   845,    -1,   846,    -1,   845,   846,    -1,
     845,   655,   846,    -1,   853,    -1,   861,    -1,   863,    -1,
     117,  1499,    -1,   590,  1499,    -1,   436,  1499,    -1,  1502,
      -1,  1502,    -1,   430,    -1,   432,    -1,   364,     4,    -1,
     242,  1371,   864,    -1,    26,  1371,   864,    -1,   321,  1371,
     864,    -1,   183,  1371,   864,    -1,   591,  1371,   864,    -1,
     437,  1371,   864,    -1,   361,  1371,  1318,    -1,    83,  1371,
    1499,    -1,  1414,   164,  1371,   941,    -1,    -1,   863,    -1,
     623,    -1,   367,    -1,  1320,    -1,  1498,    -1,    -1,   653,
     947,   654,   866,   934,   872,   869,    -1,   934,   872,   869,
      -1,    -1,   653,   922,   654,   867,  1602,    -1,   868,    -1,
     276,  1495,    -1,   653,   276,  1495,   654,    -1,    -1,    -1,
    1464,   925,   922,   870,  1599,    -1,    -1,  1464,   925,   653,
     922,   654,   871,  1602,    -1,   873,    -1,    -1,   874,    -1,
      -1,   400,   876,   875,   879,    -1,    -1,    -1,   400,   878,
     879,    -1,    49,   880,   890,   891,   898,    -1,   882,   263,
     883,   653,   884,   654,    -1,    -1,   882,   218,   881,   888,
      -1,   428,   888,    -1,   428,   887,    -1,   281,   888,    -1,
     281,   887,    -1,    -1,   278,    -1,    -1,    12,   166,  1318,
      -1,    -1,   885,    -1,   886,    -1,   885,   655,   886,    -1,
    1502,    -1,    75,   653,   884,   654,    -1,   653,  1185,   896,
    1186,   654,    -1,   653,  1185,   896,  1186,   654,    -1,    -1,
     401,  1318,    -1,    -1,    -1,   545,    49,   882,   218,   889,
     892,   897,    -1,    -1,   545,    49,   882,   263,   883,   653,
     894,   654,   893,   897,    -1,   895,    -1,   894,   655,   895,
      -1,  1502,    -1,  1194,    -1,    -1,   544,  1318,    -1,    -1,
     653,   899,   654,    -1,   900,    -1,   899,   655,   900,    -1,
      -1,   400,   901,   902,   903,   919,   914,    -1,  1502,    -1,
      -1,    -1,   612,   273,   565,   904,   906,    -1,    -1,   612,
     253,   905,   907,    -1,   325,    -1,   909,    -1,   909,    -1,
     653,   908,   654,    -1,   909,    -1,   908,   655,   909,    -1,
      -1,    -1,   653,   910,   912,   911,   654,    -1,   913,    -1,
     912,   655,   913,    -1,   325,    -1,  1194,    -1,    -1,   653,
     915,   654,    -1,   916,    -1,   915,   655,   916,    -1,    -1,
     545,   917,   918,   919,    -1,  1504,    -1,    -1,   920,    -1,
     920,   921,    -1,   921,    -1,   554,  1371,  1504,    -1,  1414,
     164,  1371,   941,    -1,    91,  1371,  1499,    -1,   361,  1371,
    1318,    -1,   320,  1371,  1320,    -1,   338,  1371,  1320,    -1,
     118,   142,  1371,  1499,    -1,   239,   142,  1371,  1499,    -1,
      83,  1371,  1499,    -1,    -1,    -1,   485,   923,  1179,  1183,
     924,   945,    -1,    -1,    20,    -1,    -1,   927,    -1,   928,
      -1,   927,   928,    -1,   940,    -1,   939,    -1,    -1,   930,
      -1,   931,    -1,   931,   930,    -1,   560,    -1,    -1,   234,
    1197,   178,    -1,   104,    -1,   104,   388,   454,    -1,    -1,
     936,    -1,   937,    -1,   937,   935,    -1,   937,    -1,   937,
     936,    -1,   937,   655,   936,    -1,   164,  1371,   941,    -1,
     320,  1371,  1319,    -1,   338,  1371,  1319,    -1,    29,  1371,
    1317,    -1,   403,  1371,  1499,    -1,    83,  1371,  1499,    -1,
      27,  1371,  1319,    -1,   393,  1371,  1317,    -1,   393,  1371,
     132,    -1,   531,  1371,  1317,    -1,   531,  1371,   132,    -1,
     532,  1371,  1317,    -1,   532,  1371,   132,    -1,   533,  1371,
    1317,    -1,   533,  1371,   132,    -1,    64,  1371,  1317,    -1,
     558,  1371,  1317,    -1,   395,  1371,  1323,    -1,   135,  1371,
    1317,    -1,   475,  1371,   943,    -1,    -1,   595,  1371,   938,
     653,  1437,   654,    -1,   939,    -1,   940,    -1,   247,  1371,
     944,    -1,   118,   142,  1371,  1499,    -1,   239,   142,  1371,
    1499,    -1,   554,  1502,    -1,   538,   145,    -1,   538,   330,
      -1,    91,  1371,  1499,    -1,   262,  1371,  1317,    -1,   577,
    1371,  1323,    -1,  1498,  1370,  1499,    -1,  1498,  1370,  1502,
      -1,  1498,  1370,  1320,    -1,  1498,  1370,   132,    -1,  1003,
     994,  1371,   996,    -1,  1003,    73,  1371,  1002,    -1,  1504,
      -1,  1504,    -1,   132,    -1,   191,    -1,   154,    -1,    88,
      -1,   438,    -1,    86,    -1,   394,    -1,   366,    -1,   190,
      -1,   266,    -1,  1310,    -1,  1178,  1182,    -1,   540,    -1,
     433,    -1,   130,    -1,   251,    -1,   948,    -1,   949,    -1,
     948,   655,   949,    -1,   950,    -1,   951,    -1,   960,   956,
      -1,   960,  1020,    -1,    -1,  1026,  1051,  1035,   653,  1048,
     654,   952,  1036,    -1,    -1,  1032,  1029,  1051,  1034,   653,
    1048,   654,   953,  1037,    -1,    -1,  1033,  1029,  1051,  1034,
     653,  1048,   654,   954,  1038,    -1,    -1,   958,  1027,  1051,
    1035,   653,  1048,   654,   955,  1036,    -1,   958,   196,   263,
    1051,   653,  1048,   654,  1020,    -1,   958,   957,    -1,    -1,
     957,    -1,    65,   653,  1191,   654,    -1,    -1,   959,    -1,
      93,  1050,    -1,    -1,  1494,   961,   962,    -1,   971,   989,
      -1,    -1,   971,   964,    20,   963,   653,   970,   654,   965,
     966,    -1,    -1,   205,    15,    -1,    -1,   622,    -1,   404,
      -1,    -1,   967,    -1,   967,   968,    -1,   968,    -1,   596,
      -1,   596,   263,    -1,    83,  1499,    -1,   398,   653,   970,
     654,    -1,  1185,  1191,  1186,    -1,   979,   987,   983,    -1,
     980,   988,   983,    -1,   193,   981,   983,    -1,    41,    -1,
      41,   986,    -1,    46,    -1,    45,    -1,   975,   986,  1006,
      -1,   975,  1006,    -1,   976,   986,  1007,    -1,   976,  1007,
      -1,    36,   986,    -1,    36,    -1,   977,   986,  1006,    -1,
     978,   986,  1007,    -1,   614,   986,    -1,   641,   987,   983,
      -1,   122,    -1,   570,   987,    -1,   567,   987,    -1,   119,
     987,    -1,   571,    -1,    43,   987,    -1,   974,    -1,   326,
      -1,   289,    -1,   292,   614,    -1,   292,   977,  1006,    -1,
     573,  1006,    -1,   564,   987,  1006,    -1,   328,  1006,    -1,
     290,  1006,    -1,   130,   981,   983,    -1,   372,   981,   983,
      -1,   191,   981,   983,    -1,    -1,   165,   972,   653,  1053,
     654,  1006,    -1,    -1,   493,   973,   653,  1053,   654,  1006,
      -1,   292,  1006,    -1,   489,    -1,   207,    -1,   206,    -1,
     408,    -1,   346,    -1,   280,    -1,   345,    -1,   409,    -1,
     347,    -1,    62,    -1,   355,    -1,   352,    62,    -1,   975,
     618,    -1,   615,    -1,   352,   615,    -1,   373,    -1,   355,
     615,    -1,   352,    62,   618,    -1,   355,   618,    -1,   251,
      -1,   572,    -1,   507,    -1,   327,    -1,    35,    -1,   433,
      -1,   148,    -1,   148,   412,    -1,    -1,   986,    -1,   982,
      -1,   653,   370,   655,   370,   654,    -1,    -1,   984,    -1,
     984,   985,    -1,   985,    -1,   501,    -1,   599,    -1,   642,
      -1,   653,   291,   654,    -1,   653,   586,   654,    -1,   653,
     129,   654,    -1,   653,   370,   654,    -1,    -1,   986,    -1,
      -1,   982,    -1,    -1,   990,    -1,   990,   991,    -1,   991,
      -1,   369,    -1,  1197,   369,    -1,   132,   993,    -1,   376,
     601,   365,  1188,    -1,    27,    -1,   489,   132,   613,    -1,
    1019,   263,    -1,   596,    -1,   596,   263,    -1,    83,  1499,
      -1,    73,  1000,    -1,  1498,  1370,  1499,    -1,  1498,  1370,
    1502,    -1,  1498,  1370,  1320,    -1,  1498,  1370,   132,    -1,
     971,  1001,    -1,   365,  1188,    -1,  1484,    -1,    62,   493,
      -1,    61,    -1,  1504,    -1,    36,    -1,   995,    -1,   132,
      -1,    -1,   994,   996,    -1,  1504,    -1,    36,    -1,   998,
      -1,   132,    -1,  1504,    -1,    -1,    73,  1002,    -1,  1000,
      -1,   132,    -1,    -1,   132,    -1,    22,    -1,    36,    22,
      -1,    22,    36,    -1,   593,    -1,   593,    36,    -1,    36,
     593,    -1,    -1,  1004,    -1,  1005,    -1,    50,    -1,   994,
     995,  1007,    -1,    36,    -1,    36,   994,   995,    -1,    -1,
      36,    -1,    -1,   653,  1318,  1009,   654,    -1,    21,    -1,
     137,    -1,   467,    -1,    -1,  1010,    -1,  1010,  1011,    -1,
    1011,    -1,  1318,    -1,  1013,  1012,    -1,  1014,    -1,  1015,
     655,  1014,    -1,  1013,   646,  1013,    -1,  1015,    -1,  1016,
      -1,    -1,   274,  1017,    -1,    -1,   416,    -1,   439,  1495,
    1021,  1023,  1024,    -1,    -1,   653,  1022,   654,    -1,  1022,
     655,  1502,    -1,  1502,    -1,    -1,   317,   200,    -1,   317,
     399,    -1,   317,   502,    -1,    -1,   376,   601,  1025,    -1,
     376,   136,  1025,    -1,   376,   601,  1025,   376,   136,  1025,
      -1,   376,   136,  1025,   376,   601,  1025,    -1,   461,    -1,
      53,    -1,   493,   369,    -1,   366,     5,    -1,   493,   132,
      -1,  1028,    -1,   416,   263,    -1,   596,  1029,    -1,   263,
      -1,   239,    -1,    -1,  1028,    -1,   261,    -1,   239,    -1,
     238,    -1,    -1,   596,    -1,   201,    -1,   514,    -1,    -1,
    1034,    -1,  1034,  1042,    -1,    -1,  1039,    -1,    -1,  1041,
      -1,    -1,  1040,    -1,  1044,    -1,  1039,  1044,    -1,  1045,
      -1,  1040,  1045,    -1,  1046,    -1,  1041,  1046,    -1,   608,
    1047,    -1,   584,  1047,    -1,   262,  1371,  1317,    -1,    83,
    1499,    -1,  1498,  1370,  1499,    -1,  1498,  1370,  1502,    -1,
    1498,  1370,  1320,    -1,  1498,  1370,   132,    -1,  1043,    -1,
    1042,    -1,  1043,    -1,  1043,    -1,   630,   397,  1498,    -1,
      48,    -1,   478,    -1,   218,    -1,  1048,   655,  1049,  1308,
      -1,  1049,  1308,    -1,  1502,    -1,  1502,   653,   370,   654,
      -1,    -1,  1494,    -1,   932,  1050,    -1,    -1,   661,  1502,
      -1,  1481,    -1,  1053,   655,  1481,    -1,    -1,    -1,    14,
    1055,  1093,   557,  1495,  1056,  1067,    -1,    -1,    14,   115,
    1066,  1057,   927,    -1,    14,   115,  1502,   602,   118,   142,
     351,    -1,    -1,    14,   418,   716,  1058,   717,    -1,    -1,
      14,   202,   716,  1059,   717,    -1,    -1,    14,  1623,  1620,
    1060,  1625,    -1,    -1,    14,  1620,  1061,  1625,    -1,    -1,
      14,  1620,   173,   716,  1062,  1063,  1064,   706,   711,  1065,
      -1,    14,   554,   827,    -1,    14,   287,   213,   829,    -1,
      14,   554,   824,    -1,    14,   554,   823,    -1,    14,   491,
    1504,   382,   653,   700,   654,    -1,    -1,   376,   480,   704,
      -1,   710,    -1,   376,   480,   704,   710,    -1,    -1,   449,
     574,   716,    -1,    -1,   149,   712,    -1,    -1,  1502,    -1,
      -1,   144,   554,    -1,   237,   554,    -1,  1082,   873,    -1,
    1082,  1071,    -1,  1071,    -1,   874,    -1,  1073,    -1,   150,
     400,  1349,  1080,    -1,   434,   400,  1143,  1072,    -1,    -1,
     381,   400,  1143,  1072,  1068,  1143,    -1,    16,   400,  1143,
    1072,    -1,    -1,    65,   400,  1072,  1069,  1138,    -1,    -1,
     451,   400,  1143,  1072,  1070,  1119,    -1,    71,   400,  1143,
    1318,    -1,   582,   400,  1072,    -1,  1076,    -1,   175,   400,
    1081,   630,   557,  1495,   876,    -1,   448,   402,    -1,    13,
      -1,  1080,    -1,    -1,     6,   400,   932,  1143,  1074,  1075,
      -1,    -1,   653,   899,   654,    -1,   401,  1318,    -1,    -1,
     450,   400,  1143,  1077,  1078,    -1,    -1,    -1,  1080,  1079,
     250,   653,   899,   654,    -1,  1081,    -1,  1080,   655,  1081,
      -1,  1502,    -1,  1084,    -1,  1082,   655,  1084,    -1,     6,
    1091,   932,    -1,  1083,   950,  1099,    -1,     6,   951,    -1,
    1083,   653,   947,   654,    -1,    -1,    59,  1091,  1349,  1494,
    1085,   960,  1099,    -1,    -1,    -1,   342,  1091,  1349,  1494,
    1086,   962,  1087,  1099,    -1,   150,  1091,  1349,  1494,  1098,
      -1,   150,   196,   263,  1349,  1494,    -1,   150,   416,   263,
      -1,   150,  1028,  1349,  1494,    -1,   143,   261,    -1,   158,
     261,    -1,    14,  1091,  1494,   493,   132,  1484,    -1,    14,
    1091,  1494,   150,   132,    -1,   449,  1100,  1495,    -1,   101,
     574,   994,   996,  1001,    -1,   935,    -1,   195,    -1,  1301,
      -1,  1089,    -1,  1090,    -1,    -1,  1090,    -1,  1089,    -1,
    1090,  1089,    -1,  1089,  1090,    -1,    12,  1371,   132,    -1,
      12,  1371,  1502,    -1,   286,  1371,   132,    -1,   286,  1371,
    1502,    -1,    -1,    81,    -1,    -1,   235,    -1,    -1,  1094,
    1095,    -1,    -1,  1096,    -1,  1096,  1097,    -1,  1097,    -1,
     235,    -1,   379,    -1,    -1,   461,    -1,    53,    -1,    -1,
       9,  1502,    -1,   190,    -1,    -1,   574,    -1,   166,    -1,
      20,    -1,    -1,   530,   503,   687,  1108,  1102,  1112,    -1,
      -1,   530,    13,   504,  1108,  1103,    -1,   537,   503,   687,
    1108,    -1,   537,    13,   504,  1108,    -1,   530,   576,  1105,
      -1,    -1,  1106,    -1,  1107,    -1,  1106,   655,  1107,    -1,
     630,    92,   508,    -1,   431,   378,    -1,   431,   635,    -1,
      -1,  1109,  1110,    -1,  1111,    -1,  1110,   655,  1111,    -1,
      -1,   526,    -1,   445,    -1,    -1,   600,  1113,    -1,   600,
     297,   166,  1499,    -1,   686,    -1,  1113,   655,   686,    -1,
      -1,    64,  1539,  1115,  1344,  1116,    -1,    -1,   427,    -1,
     182,    -1,    -1,   451,  1143,  1539,  1118,  1344,  1119,    -1,
      -1,  1120,    -1,  1121,    -1,  1121,  1120,    -1,   427,    -1,
     182,    -1,   606,    -1,    -1,    16,  1143,  1539,  1123,  1124,
      -1,  1125,    -1,  1124,   655,  1125,    -1,  1345,  1126,    -1,
      -1,   404,   197,  1127,    -1,    13,    -1,    75,  1128,   238,
    1130,    -1,    13,    -1,    -1,   653,  1129,  1132,   654,    -1,
      13,    -1,    -1,   653,  1131,  1133,   654,    -1,    -1,  1502,
      -1,  1132,   655,  1502,    -1,    -1,  1134,    -1,  1133,   655,
    1134,    -1,  1502,    -1,   416,    -1,    37,  1499,    -1,    -1,
      65,  1539,  1137,  1344,  1138,    -1,    -1,  1139,    -1,  1140,
      -1,  1140,  1139,    -1,   427,    -1,   186,    -1,   329,    -1,
     182,    -1,    60,    -1,   197,   602,    -1,    -1,   381,  1143,
    1539,  1142,  1344,    -1,    -1,   368,    -1,   283,    -1,    -1,
     449,  1539,  1145,  1147,    -1,   449,   604,   715,  1146,    -1,
    1507,   574,  1507,    -1,  1146,   655,  1507,   574,  1507,    -1,
    1148,    -1,  1147,   655,  1148,    -1,  1495,   574,  1495,    -1,
      -1,    51,   239,  1150,  1151,   253,  1155,    -1,  1152,    -1,
    1154,    -1,  1153,    -1,  1152,   655,  1153,    -1,  1495,  1164,
      -1,  1495,  1162,  1164,    -1,  1502,    -1,   132,    -1,    -1,
     282,   239,   250,    51,  1157,  1158,    -1,  1161,    -1,  1159,
      -1,  1160,    -1,  1159,   655,  1160,    -1,  1495,  1164,  1167,
      -1,  1495,  1162,  1164,  1167,    -1,    -1,   400,   876,  1163,
     653,  1072,   654,    -1,    -1,  1165,  1166,    -1,    -1,  1028,
     653,  1283,   654,    -1,    -1,   235,   270,    -1,  1169,    -1,
     485,  1172,    -1,   653,  1170,   654,  1602,    -1,   485,  1174,
      -1,   653,  1170,   654,    -1,   485,  1262,    -1,   653,  1171,
     654,    -1,    -1,  1174,  1173,  1599,    -1,    -1,    -1,  1175,
    1179,  1183,  1176,  1177,  1182,    -1,  1304,  1310,    -1,  1333,
      -1,  1178,    -1,  1333,  1178,    -1,  1178,  1333,    -1,   199,
    1242,  1293,  1298,  1295,  1304,  1310,  1324,    -1,   199,   151,
    1293,  1310,    -1,    -1,  1180,    -1,  1180,  1181,    -1,  1181,
      -1,  1616,    -1,   523,    -1,   521,    -1,    -1,   197,   601,
      -1,   286,   253,   495,   340,    -1,  1183,   655,  1184,    -1,
    1184,    -1,   648,    -1,  1185,  1489,  1186,    -1,  1185,  1191,
    1186,  1187,    -1,    -1,    -1,    -1,    20,  1502,    -1,    20,
    1499,    -1,  1502,    -1,  1499,    -1,    -1,   653,   654,    -1,
     653,  1318,   654,    -1,    -1,   653,   654,    -1,   653,  1318,
     654,    -1,    -1,   653,   654,    -1,  1191,  1195,  1191,    -1,
    1191,   639,  1191,    -1,  1191,  1196,  1191,    -1,   364,  1191,
      -1,  1192,   256,   581,    -1,  1192,   256,  1197,   581,    -1,
    1192,   256,   185,    -1,  1192,   256,  1197,   185,    -1,  1192,
     256,   597,    -1,  1192,   256,  1197,   597,    -1,  1192,    -1,
    1192,   256,   369,    -1,  1192,   256,  1197,   369,    -1,  1192,
     167,  1193,    -1,  1192,  1199,  1193,    -1,  1192,  1199,  1200,
     653,  1611,   654,    -1,  1193,    -1,  1194,   253,   653,  1611,
     654,    -1,  1194,  1197,   253,   653,  1611,   654,    -1,  1194,
     253,   653,  1191,   654,    -1,  1194,   253,   653,  1191,   655,
    1235,   654,    -1,  1194,  1197,   253,   653,  1191,   654,    -1,
    1194,  1197,   253,   653,  1191,   655,  1235,   654,    -1,  1194,
      34,  1194,    18,  1193,    -1,  1194,  1197,    34,  1194,    18,
    1193,    -1,  1194,   512,   276,  1194,    -1,  1194,   276,  1205,
    1297,    -1,  1194,  1197,   276,  1205,  1297,    -1,  1194,   440,
    1194,    -1,  1194,  1197,   440,  1194,    -1,  1194,    -1,  1194,
     644,  1194,    -1,  1194,   645,  1194,    -1,  1194,   496,  1194,
      -1,  1194,   497,  1194,    -1,  1194,   647,  1194,    -1,  1194,
     646,  1194,    -1,  1194,   647,   249,  1191,  1287,    -1,  1194,
     646,   249,  1191,  1287,    -1,  1194,   648,  1194,    -1,  1194,
     649,  1194,    -1,  1194,   650,  1194,    -1,  1194,   147,  1194,
      -1,  1194,   343,  1194,    -1,  1194,   651,  1194,    -1,  1205,
      -1,   388,    -1,   385,    -1,    18,    -1,    17,    -1,   364,
      -1,   363,    -1,   656,    -1,   363,    -1,   166,    -1,   203,
      -1,   215,    -1,   268,    -1,   295,    -1,   357,    -1,    13,
      -1,    19,    -1,    -1,    20,  1202,    -1,   251,    -1,   599,
     251,    -1,   148,    -1,   433,    -1,   193,    -1,   130,   981,
      -1,   975,  1006,    -1,   976,    -1,   122,    -1,   570,   987,
      -1,   119,   987,    -1,  1191,   655,  1191,  1201,    -1,  1203,
      -1,  1204,   655,  1203,    -1,  1491,    -1,  1206,    -1,  1207,
      -1,  1210,    -1,  1208,    -1,  1205,    73,  1504,    -1,  1485,
      -1,  1483,    -1,  1222,    -1,  1218,    -1,  1205,   387,  1205,
      -1,   647,  1205,    -1,   646,  1205,    -1,   652,  1205,    -1,
    1198,  1205,    -1,   653,  1611,   654,    -1,   653,  1191,   654,
      -1,   653,  1191,   655,  1235,   654,    -1,   476,   653,  1191,
     655,  1235,   654,    -1,   178,   653,  1611,   654,    -1,   657,
    1502,  1191,   658,    -1,   317,  1236,    10,   653,  1194,  1212,
     654,    -1,    36,  1205,    -1,    56,   653,  1191,    20,  1232,
     654,    -1,    55,  1238,  1240,  1239,   160,    -1,   101,   653,
    1191,   655,  1232,   654,    -1,   101,   653,  1191,   608,   995,
     654,    -1,   132,   653,  1491,   654,    -1,   612,   653,  1492,
     654,    -1,   249,  1191,  1287,   647,  1191,    -1,    62,   653,
    1235,   654,    -1,    62,   653,  1235,   608,   995,   654,    -1,
     109,  1190,    -1,   110,  1190,    -1,   122,   653,  1191,   654,
      -1,   127,   653,  1191,   654,    -1,   229,   653,  1191,   654,
      -1,   246,   653,  1191,   655,  1191,   655,  1191,   655,  1191,
     654,    -1,   249,   653,  1191,   655,  1191,   654,    -1,   249,
     653,  1191,   655,  1191,   655,  1235,   654,    -1,   272,   653,
    1191,   655,  1191,   654,    -1,   337,   653,  1191,   654,    -1,
     344,   653,  1191,   654,    -1,   469,   653,  1191,   655,  1191,
     654,    -1,   483,   653,  1191,   654,    -1,   570,   653,  1191,
     654,    -1,   567,   653,  1191,   654,    -1,   567,   653,  1191,
     655,  1191,   654,    -1,   580,   653,  1191,   654,    -1,   580,
     653,   269,  1191,   199,  1191,   654,    -1,   580,   653,   575,
    1191,   199,  1191,   654,    -1,   580,   653,    47,  1191,   199,
    1191,   654,    -1,   580,   653,   269,   199,  1191,   654,    -1,
     580,   653,   575,   199,  1191,   654,    -1,   580,   653,    47,
     199,  1191,   654,    -1,   580,   653,  1191,   199,  1191,   654,
      -1,   604,   653,   654,    -1,   641,   653,  1191,   654,    -1,
       8,   653,  1191,   655,  1191,   654,    -1,     8,   653,  1191,
     655,   249,  1191,  1287,   654,    -1,   107,  1190,    -1,   114,
    1189,    -1,   120,   653,  1191,   655,   249,  1191,  1287,   654,
      -1,   121,   653,  1191,   655,   249,  1191,  1287,   654,    -1,
     184,   653,  1287,   199,  1191,   654,    -1,   208,   653,  1289,
     655,  1191,   654,    -1,   365,  1189,    -1,   411,   653,  1194,
     253,  1191,   654,    -1,   542,   653,  1191,   655,  1191,   654,
      -1,   542,   653,  1191,   655,   249,  1191,  1287,   654,    -1,
     546,   653,  1191,   655,  1191,   655,  1191,   654,    -1,   546,
     653,  1191,   655,  1191,   654,    -1,   546,   653,  1191,   199,
    1191,   197,  1191,   654,    -1,   546,   653,  1191,   199,  1191,
     654,    -1,   552,  1189,    -1,   568,   653,  1288,   655,  1191,
     655,  1191,   654,    -1,   569,   653,  1288,   655,  1191,   655,
    1191,   654,    -1,   609,  1190,    -1,   611,  1189,    -1,   610,
    1189,    -1,    76,   653,  1191,   655,  1204,   654,    -1,    79,
     653,  1191,   655,  1235,   654,    -1,    77,   653,  1191,   654,
      -1,    78,   653,  1204,   654,    -1,    80,   653,  1191,   655,
    1191,    20,  1232,   654,    -1,    22,   653,  1191,   654,    -1,
      61,   653,  1191,   654,    -1,    71,   653,  1235,   654,    -1,
      74,   653,  1191,   654,    -1,   115,   653,   654,    -1,   234,
     653,  1191,   655,  1191,   655,  1191,   654,    -1,   267,   653,
    1235,   654,    -1,   333,   653,  1191,   654,    -1,   343,   653,
    1191,   655,  1191,   654,    -1,   375,   653,  1191,   654,    -1,
     403,   653,  1191,   654,    -1,   425,   653,  1191,   654,    -1,
     453,   653,  1191,   655,  1191,   654,    -1,   454,   653,  1191,
     655,  1191,   655,  1191,   654,    -1,   467,   653,  1191,   654,
      -1,   477,   653,   654,    -1,   582,   653,  1191,   655,  1191,
     654,    -1,   625,   653,  1191,   654,    -1,   625,   653,  1191,
     655,  1191,   654,    -1,   626,   653,  1191,  1018,   654,    -1,
     626,   653,  1191,    20,    62,  1008,  1018,   654,    -1,   626,
     653,  1191,    20,    36,  1008,   654,    -1,   626,   653,  1191,
     655,  1317,   655,  1317,   655,  1317,   654,    -1,  1209,    -1,
      97,   653,  1191,   655,  1191,   654,    -1,   206,   653,  1235,
     654,    -1,   280,   653,  1235,   654,    -1,   345,   653,  1235,
     654,    -1,   346,   653,  1235,   654,    -1,   347,   653,  1235,
     654,    -1,   408,   653,  1191,   655,  1191,   654,    -1,   409,
     653,  1235,   654,    -1,    -1,  1498,   653,  1211,  1215,   654,
      -1,  1502,   661,  1502,   653,  1234,   654,    -1,  1213,  1214,
      -1,   253,    45,   340,    -1,    -1,   253,   353,   265,   340,
      -1,    -1,   630,   426,   180,    -1,    -1,  1216,    -1,  1217,
      -1,  1216,   655,  1217,    -1,  1185,  1191,  1186,  1187,    -1,
      30,   653,  1230,   654,    -1,    30,   653,   146,  1230,   654,
      -1,    39,   653,  1230,   654,    -1,    40,   653,  1230,   654,
      -1,    42,   653,  1230,   654,    -1,   102,   653,  1292,   648,
     654,    -1,   102,   653,  1230,   654,    -1,    -1,    -1,   102,
     653,   146,  1219,  1235,  1220,   654,    -1,   339,   653,  1230,
     654,    -1,   339,   653,   146,  1230,   654,    -1,   322,   653,
    1230,   654,    -1,   322,   653,   146,  1230,   654,    -1,   536,
     653,  1230,   654,    -1,   617,   653,  1230,   654,    -1,   535,
     653,  1230,   654,    -1,   619,   653,  1230,   654,    -1,   547,
     653,  1230,   654,    -1,   547,   653,   146,  1230,   654,    -1,
      -1,   214,   653,  1225,  1221,  1235,  1227,  1226,   654,    -1,
      -1,   660,  1223,  1224,    -1,  1504,   494,  1191,    -1,  1504,
      -1,   660,  1526,  1504,  1052,    -1,    -1,   146,    -1,    -1,
     487,  1481,    -1,    -1,    -1,   386,    49,  1228,  1229,    -1,
    1229,   655,  1490,  1308,    -1,  1490,  1308,    -1,    -1,  1292,
    1231,  1191,    -1,    36,   987,    -1,    62,   987,  1006,    -1,
     355,   987,    -1,   251,    -1,   501,    -1,   501,   251,    -1,
     599,    -1,   599,   251,    -1,   122,    -1,   570,   987,    -1,
     119,   987,    -1,   130,   981,    -1,    -1,   148,  1233,   988,
      -1,    -1,  1235,    -1,  1191,    -1,  1235,   655,  1191,    -1,
    1237,    -1,   653,  1237,   654,    -1,  1491,    -1,  1237,   655,
    1491,    -1,    -1,  1191,    -1,    -1,   156,  1191,    -1,   627,
    1191,   566,  1191,    -1,  1240,   627,  1191,   566,  1191,    -1,
    1256,    -1,  1245,    -1,  1244,    -1,  1241,    -1,   657,  1502,
    1241,   658,    -1,  1243,    -1,  1244,   655,  1243,    -1,  1241,
    1253,  1241,    -1,    -1,  1241,  1253,  1241,   376,  1246,  1191,
      -1,    -1,  1241,  1253,  1241,   608,  1247,   653,  1286,   654,
      -1,  1241,   353,  1252,  1256,    -1,    -1,  1241,   272,  1272,
     260,  1241,   376,  1248,  1191,    -1,    -1,  1241,   272,  1272,
     260,  1256,  1249,   608,   653,  1286,   654,    -1,  1241,   353,
     272,  1272,   260,  1256,    -1,    -1,  1241,   469,  1272,   260,
    1241,   376,  1250,  1191,    -1,    -1,  1241,   469,  1272,   260,
    1256,  1251,   608,   653,  1286,   654,    -1,  1241,   353,   469,
    1272,   260,  1256,    -1,   260,    -1,   243,   260,    -1,   539,
      -1,  1252,    -1,   105,   260,    -1,    -1,  1255,    -1,   400,
     653,  1286,   654,   876,    -1,    -1,  1257,  1495,  1254,  1291,
    1281,    -1,  1271,  1270,  1267,    -1,   653,  1270,  1258,   654,
    1291,    -1,  1265,  1603,    -1,    -1,    -1,  1258,   595,  1607,
    1259,  1608,  1260,  1603,    -1,  1262,    -1,    -1,    -1,  1263,
    1614,  1183,  1264,   945,  1182,    -1,    -1,  1270,  1266,  1244,
      -1,    -1,    -1,  1268,  1179,  1183,  1269,   945,    -1,    -1,
     485,    -1,    -1,   389,    -1,    -1,   197,   260,    -1,   197,
     386,    49,    -1,   197,   213,    49,    -1,   195,    -1,   235,
      -1,    -1,  1274,  1028,  1273,  1276,   653,  1285,   654,    -1,
      -1,   607,  1028,  1273,  1277,   653,  1283,   654,    -1,  1275,
      -1,  1278,  1275,    -1,    -1,    -1,  1280,  1278,    -1,    -1,
    1282,  1279,    -1,    -1,  1285,    -1,  1502,    -1,   416,    -1,
    1284,    -1,  1285,   655,  1284,    -1,  1502,    -1,  1286,   655,
    1502,    -1,  1288,    -1,   123,    -1,   124,    -1,   125,    -1,
     126,    -1,   226,    -1,   227,    -1,   228,    -1,   335,    -1,
     336,    -1,   482,    -1,   640,    -1,   127,    -1,   625,    -1,
     229,    -1,   337,    -1,   344,    -1,   425,    -1,   483,    -1,
     333,    -1,   641,    -1,   122,    -1,   570,    -1,   119,    -1,
     567,    -1,    -1,    20,    -1,   166,    -1,    -1,  1290,  1502,
      -1,    -1,    13,    -1,    -1,    -1,   628,  1294,  1191,    -1,
      -1,    -1,   219,  1296,  1191,    -1,   171,  1205,    -1,    -1,
      -1,   213,    49,  1299,  1300,    -1,  1299,   655,  1490,  1308,
      -1,  1490,  1308,    -1,    -1,   631,    -1,   632,    -1,   386,
      49,  1302,    -1,  1302,   655,  1303,    -1,  1303,    -1,  1492,
    1308,    -1,    -1,  1305,    -1,    -1,   386,    49,  1306,  1307,
      -1,  1307,   655,  1490,  1308,    -1,  1490,  1308,    -1,    -1,
      21,    -1,   137,    -1,    -1,  1311,    -1,    -1,  1311,    -1,
     277,  1312,    -1,   277,  1312,   474,   176,  1314,    -1,   277,
     474,   176,  1314,    -1,  1313,    -1,  1313,   655,  1313,    -1,
    1313,   374,  1313,    -1,  1502,    -1,  1483,    -1,   586,    -1,
     291,    -1,   370,    -1,  1313,    -1,    -1,   277,  1313,    -1,
     277,   474,   176,    -1,   277,  1313,   474,   176,    -1,   370,
      -1,   646,   370,    -1,   646,   291,    -1,   370,    -1,   221,
      -1,   291,    -1,   586,    -1,   129,    -1,   192,    -1,   370,
      -1,   221,    -1,   291,    -1,   586,    -1,  1321,    -1,   370,
      -1,   586,    -1,   291,    -1,   129,    -1,   192,    -1,   370,
      -1,   586,    -1,   221,    -1,   291,    -1,  1321,    -1,  1322,
      -1,   129,    -1,   192,    -1,  1317,    -1,   132,    -1,    -1,
      -1,   418,  1502,  1325,   653,  1326,   654,    -1,    -1,  1327,
      -1,  1327,   655,  1328,    -1,  1328,    -1,  1185,  1191,  1186,
      -1,    -1,  1330,  1331,    -1,  1331,   655,  1332,    -1,  1332,
      -1,   660,  1504,    -1,  1504,    -1,    -1,   250,  1334,  1335,
      -1,    -1,    -1,   390,  1501,  1336,   997,  1337,  1465,  1468,
      -1,   152,  1501,    -1,  1329,    -1,    -1,   149,  1339,  1235,
      -1,    -1,   150,  1350,  1539,  1349,  1341,  1344,  1098,    -1,
      -1,   150,   239,  1349,  1502,   376,  1495,  1342,    -1,   150,
     115,  1349,  1502,    -1,   150,   202,  1349,  1502,   661,  1502,
      -1,   150,   202,  1349,  1502,    -1,   150,   418,  1349,   716,
      -1,   150,   604,   715,  1575,    -1,   150,   470,   715,  1559,
      -1,    -1,   150,   621,  1349,  1343,  1344,  1098,    -1,   150,
     173,  1349,   716,    -1,   150,   579,  1349,   716,    -1,   150,
     554,   850,   861,   862,    -1,   150,   287,   213,   851,   861,
     862,    -1,   150,   491,  1349,  1504,    -1,  1345,    -1,  1344,
     655,  1345,    -1,  1495,    -1,  1495,  1254,    -1,  1348,    -1,
    1347,   655,  1348,    -1,  1496,    -1,    -1,   234,   178,    -1,
      -1,   560,    -1,    -1,    -1,   246,  1352,  1357,  1092,  1359,
    1353,  1361,  1377,    -1,    -1,    -1,   454,  1355,  1358,  1359,
    1356,  1361,    -1,    -1,   294,    -1,   134,    -1,   223,    -1,
    1386,    -1,   134,    -1,   250,  1360,    -1,  1360,    -1,  1346,
      -1,  1364,    -1,   653,   654,  1364,    -1,   653,  1363,   654,
    1364,    -1,    -1,   493,  1362,  1368,    -1,  1363,   655,  1488,
      -1,  1488,    -1,   612,  1367,    -1,   613,  1367,    -1,    -1,
     922,  1365,  1599,    -1,    -1,   653,   922,   654,  1366,  1602,
      -1,  1367,   655,  1372,    -1,  1372,    -1,  1368,   655,  1369,
      -1,  1369,    -1,  1492,  1370,  1376,    -1,   166,    -1,   494,
      -1,    -1,  1370,    -1,    -1,   653,  1373,  1374,   654,    -1,
      -1,  1375,    -1,  1375,   655,  1376,    -1,  1376,    -1,  1191,
      -1,   132,    -1,    -1,    -1,   376,   153,  1378,   263,   601,
    1384,    -1,    -1,    -1,   601,  1380,  1386,  1092,  1242,   493,
    1382,  1381,  1293,  1304,  1315,    -1,  1382,   655,  1383,    -1,
    1383,    -1,  1492,  1370,  1376,    -1,  1384,   655,  1385,    -1,
    1385,    -1,  1492,  1370,  1376,    -1,    -1,   294,    -1,    -1,
     136,  1388,  1398,  1389,    -1,    -1,    -1,   199,  1495,  1254,
    1390,  1293,  1304,  1315,  1391,  1394,    -1,    -1,  1395,  1392,
     199,  1242,  1293,    -1,    -1,   199,  1347,  1393,   608,  1242,
    1293,    -1,    -1,   464,  1183,    -1,  1396,    -1,  1395,   655,
    1396,    -1,  1502,  1397,    -1,  1502,   661,  1502,  1397,    -1,
      -1,   661,   648,    -1,    -1,  1399,  1398,    -1,   427,    -1,
     294,    -1,   235,    -1,    -1,   582,  1402,  1401,  1345,    -1,
      -1,   557,    -1,    -1,  1404,    -1,  1405,    -1,  1404,   655,
    1405,    -1,   103,    -1,   330,    -1,    44,   254,    -1,    98,
     551,    -1,   394,   187,    -1,   255,    -1,   550,    -1,   513,
      -1,    13,    -1,    -1,   197,   426,   370,    -1,    -1,   498,
    1408,  1409,    -1,   116,  1420,    -1,  1416,   553,  1415,  1420,
      -1,  1416,   578,  1415,  1420,    -1,   172,  1415,  1420,    -1,
     557,   534,  1415,  1420,    -1,   380,   553,  1415,  1420,    -1,
     406,    -1,   406,   511,  1499,    -1,   406,   511,  1420,    -1,
     164,   942,  1412,    -1,   164,    13,  1412,    -1,  1416,    75,
    1417,  1495,  1415,  1420,    -1,  1413,   288,    -1,   503,   225,
      -1,    -1,    37,   172,  1418,  1419,  1410,  1309,    -1,    -1,
     442,   687,   172,  1418,  1419,  1411,  1309,    -1,  1030,  1417,
    1495,  1415,  1293,    -1,  1414,   163,    -1,    25,    -1,   100,
      -1,   417,    -1,   102,   653,   648,   654,   624,    -1,   102,
     653,   648,   654,   169,    -1,   624,  1309,    -1,   169,  1309,
      -1,   422,    -1,   421,  1403,  1406,  1309,    -1,  1525,   534,
    1420,    -1,  1416,   420,    -1,  1525,   616,  1420,    -1,   994,
    1420,    -1,    74,  1420,    -1,   212,    -1,   212,   197,  1506,
      -1,   104,   115,   932,  1502,    -1,   104,   557,  1495,    -1,
     104,   621,  1495,    -1,   313,   534,    -1,    13,   504,   534,
      -1,   503,   534,    -1,   503,   688,   534,    -1,    69,    -1,
     605,    -1,   556,    -1,   240,    -1,   104,   418,   716,    -1,
     104,   202,   716,    -1,   104,   579,   716,    -1,   418,   534,
    1420,    -1,   202,   534,  1420,    -1,   418,    72,   716,    -1,
     202,    72,   716,    -1,   104,   173,   716,    -1,  1425,   197,
    1191,    -1,   534,    -1,   348,    -1,   288,    -1,   313,    -1,
      36,    -1,    -1,   538,    -1,    -1,  1417,  1502,    -1,    -1,
     200,    -1,   199,    -1,   253,    -1,    -1,   253,  1499,    -1,
      -1,   199,  1319,    -1,    -1,   276,  1499,    -1,   628,  1191,
      -1,    -1,  1425,  1495,  1422,  1427,    -1,    -1,  1425,  1426,
    1423,  1424,    -1,  1168,    -1,  1351,    -1,  1354,    -1,  1379,
      -1,  1387,    -1,   137,    -1,   138,    -1,    -1,   182,    -1,
     401,    -1,    -1,  1481,    -1,  1502,    -1,    -1,   194,  1143,
    1429,  1430,    -1,    -1,  1539,  1431,  1437,  1432,    -1,  1435,
      -1,    -1,  1433,    -1,   630,   431,   286,  1438,    -1,    -1,
     197,  1434,   181,    -1,  1435,   655,  1436,    -1,  1436,    -1,
     168,   288,    -1,   164,   288,    -1,   204,   288,    -1,   506,
     288,    -1,    36,   288,    -1,   441,   288,   687,    -1,   426,
      51,    -1,   225,    -1,   417,    -1,   288,    -1,   534,    -1,
     503,   687,    -1,    69,    -1,   605,    -1,   556,    -1,   240,
      -1,   313,    -1,   139,    -1,   459,    -1,    -1,  1344,    -1,
      -1,    18,   143,    63,    -1,    -1,   457,  1440,  1441,    -1,
    1441,   655,  1442,    -1,  1442,    -1,    -1,   503,  1443,   687,
    1444,    -1,   313,    -1,   426,    51,    -1,    -1,    13,    -1,
      -1,   424,  1446,  1447,    -1,  1413,   288,  1448,    -1,   574,
    1499,    -1,    32,  1191,    -1,    -1,   264,  1450,  1451,  1452,
    1453,    -1,    -1,   217,    -1,   510,    -1,    -1,    91,    -1,
     426,    -1,   426,   230,    -1,  1191,    -1,   604,  1507,    -1,
     499,    -1,   607,  1502,    -1,    -1,    -1,    -1,    -1,   282,
    1461,  1457,  1463,  1462,   241,  1501,  1458,  1464,   250,   557,
    1495,  1254,  1459,   997,  1460,  1471,  1465,  1468,  1472,  1474,
    1477,    -1,   118,    -1,   638,    -1,    -1,   283,    -1,    -1,
      89,    -1,   294,    -1,    -1,   454,    -1,   235,    -1,    -1,
      75,  1466,    -1,  1466,  1467,    -1,  1467,    -1,   562,    49,
    1481,    -1,   384,   159,    49,  1481,    -1,   159,    49,  1481,
      -1,   170,    49,  1481,    -1,    -1,   279,  1469,    -1,  1469,
    1470,    -1,  1470,    -1,   562,    49,  1481,    -1,   528,    49,
    1481,    -1,    -1,   474,   232,    49,  1481,    -1,    -1,   235,
     370,  1473,    -1,   279,    -1,   474,    -1,    -1,   653,  1475,
     654,    -1,   653,   654,    -1,  1475,   655,  1476,    -1,  1476,
      -1,  1492,    -1,   660,  1504,    -1,    -1,   493,  1478,    -1,
    1478,   655,  1479,    -1,  1479,    -1,  1492,  1370,  1185,  1376,
    1186,    -1,   563,    -1,   354,    -1,   589,   563,    -1,  1480,
    1500,    -1,  1500,    -1,  1482,    -1,   221,    -1,   222,    -1,
      38,    -1,   396,    -1,  1485,    -1,   647,  1486,    -1,   646,
    1486,    -1,  1480,    -1,  1486,    -1,  1487,    -1,   369,    -1,
     185,    -1,   581,    -1,   221,    -1,   222,    -1,    38,    -1,
     589,  1482,    -1,   370,    -1,   291,    -1,   586,    -1,   129,
      -1,   192,    -1,   122,   563,    -1,   570,   563,    -1,   567,
     563,    -1,  1492,    -1,  1489,    -1,  1502,   661,   648,    -1,
    1502,   661,  1502,   661,   648,    -1,  1191,    -1,  1502,    -1,
    1493,    -1,  1502,    -1,  1493,    -1,  1502,   661,  1502,    -1,
     661,  1502,   661,  1502,    -1,  1502,   661,  1502,   661,  1502,
      -1,  1502,    -1,  1502,   661,  1502,   661,  1502,    -1,  1502,
     661,  1502,    -1,   661,  1502,    -1,  1502,    -1,  1502,   661,
    1502,    -1,   661,  1502,    -1,  1502,  1397,    -1,  1502,   661,
    1502,  1397,    -1,  1502,    -1,   231,    -1,   233,    -1,   563,
      -1,   563,    -1,   563,    -1,  1498,    -1,  1508,    -1,  1498,
      -1,  1509,    -1,  1502,    -1,  1499,    -1,   275,    -1,  1504,
      -1,  1504,   660,  1504,    -1,   109,  1190,    -1,  1505,    -1,
    1560,    -1,  1505,    -1,  1509,    -1,    22,    -1,    31,    -1,
      33,    -1,    50,    -1,    51,    -1,    61,    -1,    64,    -1,
      63,    -1,    70,    -1,    76,    -1,    77,    -1,    78,    -1,
      79,    -1,    80,    -1,    83,    -1,    85,    -1,    97,    -1,
     128,    -1,   149,    -1,   160,    -1,   176,    -1,   177,    -1,
     194,    -1,   209,    -1,   216,    -1,   220,    -1,   224,    -1,
     248,    -1,   265,    -1,   366,    -1,   380,    -1,   383,    -1,
     382,    -1,   392,    -1,   397,    -1,   410,    -1,   413,    -1,
     448,    -1,   451,    -1,   457,    -1,   460,    -1,   471,    -1,
     479,    -1,   484,    -1,   491,    -1,   499,    -1,   501,    -1,
     509,    -1,   503,    -1,   504,    -1,   511,    -1,   530,    -1,
     537,    -1,   582,    -1,   593,    -1,   594,    -1,   634,    -1,
     637,    -1,   602,    -1,     5,    -1,     8,    -1,     7,    -1,
       9,    -1,    10,    -1,    11,    -1,    12,    -1,    15,    -1,
      19,    -1,    24,    -1,    25,    -1,    27,    -1,    26,    -1,
      28,    -1,    29,    -1,    30,    -1,    37,    -1,    41,    -1,
      44,    -1,    46,    -1,    45,    -1,    48,    -1,    54,    -1,
      57,    -1,    58,    -1,    60,    -1,    66,    -1,    69,    -1,
      68,    -1,    67,    -1,    71,    -1,    72,    -1,    74,    -1,
      82,    -1,    75,    -1,    84,    -1,    86,    -1,    87,    -1,
      88,    -1,    89,    -1,    91,    -1,    92,    -1,    94,    -1,
      96,    -1,    95,    -1,    98,    -1,   100,    -1,   111,    -1,
     103,    -1,   106,    -1,   108,    -1,   113,    -1,   118,    -1,
     117,    -1,   119,    -1,   122,    -1,   127,    -1,   133,    -1,
     135,    -1,   139,    -1,   141,    -1,   142,    -1,   143,    -1,
     144,    -1,   145,    -1,   152,    -1,   153,    -1,   154,    -1,
     161,    -1,   165,    -1,   164,    -1,   163,    -1,   168,    -1,
     169,    -1,   171,    -1,   173,    -1,   172,    -1,   174,    -1,
     175,    -1,   180,    -1,   181,    -1,   182,    -1,   183,    -1,
     187,    -1,   186,    -1,   198,    -1,   158,    -1,   200,    -1,
     189,    -1,   190,    -1,   191,    -1,   204,    -1,   205,    -1,
     207,    -1,   206,    -1,   208,    -1,   212,    -1,   210,    -1,
     218,    -1,   217,    -1,   225,    -1,   229,    -1,   230,    -1,
     232,    -1,   236,    -1,   240,    -1,   252,    -1,   237,    -1,
     238,    -1,   242,    -1,   254,    -1,   255,    -1,   257,    -1,
     258,    -1,   247,    -1,   262,    -1,   267,    -1,   266,    -1,
     270,    -1,   273,    -1,   274,    -1,   280,    -1,   281,    -1,
     283,    -1,   285,    -1,   287,    -1,   288,    -1,   320,    -1,
     313,    -1,   316,    -1,   297,    -1,   298,    -1,   302,    -1,
     299,    -1,   300,    -1,   314,    -1,   315,    -1,   301,    -1,
     303,    -1,   296,    -1,   311,    -1,   305,    -1,   304,    -1,
     306,    -1,   307,    -1,   308,    -1,   309,    -1,   310,    -1,
     318,    -1,   319,    -1,   321,    -1,   323,    -1,   324,    -1,
     329,    -1,   330,    -1,   331,    -1,   332,    -1,   333,    -1,
     334,    -1,   337,    -1,   338,    -1,   342,    -1,   340,    -1,
     344,    -1,   345,    -1,   346,    -1,   347,    -1,   348,    -1,
     349,    -1,   351,    -1,   350,    -1,   352,    -1,   355,    -1,
     356,    -1,   360,    -1,   359,    -1,   367,    -1,   361,    -1,
     362,    -1,   371,    -1,   373,    -1,   374,    -1,   375,    -1,
     377,    -1,   379,    -1,   378,    -1,   393,    -1,   394,    -1,
     399,    -1,   402,    -1,   401,    -1,   403,    -1,   404,    -1,
     405,    -1,   407,    -1,   406,    -1,   408,    -1,   409,    -1,
     414,    -1,   415,    -1,   417,    -1,   419,    -1,   420,    -1,
     421,    -1,   422,    -1,   423,    -1,   425,    -1,   426,    -1,
     427,    -1,   430,    -1,   434,    -1,   435,    -1,   437,    -1,
     436,    -1,   438,    -1,   441,    -1,   442,    -1,   443,    -1,
     444,    -1,   445,    -1,   447,    -1,   450,    -1,   452,    -1,
     455,    -1,   459,    -1,   462,    -1,   463,    -1,   465,    -1,
     467,    -1,   470,    -1,   472,    -1,   473,    -1,   474,    -1,
     477,    -1,   475,    -1,   476,    -1,   478,    -1,   480,    -1,
     481,    -1,   483,    -1,   489,    -1,   488,    -1,   490,    -1,
     502,    -1,   495,    -1,   505,    -1,   506,    -1,   508,    -1,
     510,    -1,   512,    -1,   513,    -1,   521,    -1,   520,    -1,
     523,    -1,   526,    -1,   529,    -1,   534,    -1,   538,    -1,
     540,    -1,   541,    -1,   542,    -1,   543,    -1,   545,    -1,
     544,    -1,   548,    -1,   549,    -1,   550,    -1,   551,    -1,
     559,    -1,   556,    -1,   553,    -1,   558,    -1,   554,    -1,
     560,    -1,   561,    -1,   564,    -1,   565,    -1,   576,    -1,
     577,    -1,   578,    -1,   567,    -1,   568,    -1,   569,    -1,
     570,    -1,   583,    -1,   584,    -1,   585,    -1,   202,    -1,
     587,    -1,   588,    -1,   591,    -1,   590,    -1,   597,    -1,
     600,    -1,   604,    -1,   605,    -1,   606,    -1,   616,    -1,
     621,    -1,   622,    -1,   613,    -1,   624,    -1,   623,    -1,
     625,    -1,   626,    -1,   633,    -1,   636,    -1,   638,    -1,
     641,    -1,   620,    -1,    -1,   493,  1511,  1512,    -1,    -1,
    1528,  1513,  1518,    -1,    -1,   576,  1514,  1530,    -1,    -1,
    1524,  1515,  1516,    -1,    -1,  1527,  1517,  1518,    -1,   576,
    1530,    -1,    -1,   655,  1519,    -1,    -1,  1520,  1522,    -1,
      -1,  1519,   655,  1521,  1522,    -1,    -1,  1524,  1523,  1527,
      -1,  1528,    -1,   210,    -1,   283,    -1,   490,    -1,    -1,
     210,    -1,   283,    -1,   490,    -1,    -1,   210,   661,    -1,
     283,   661,    -1,   490,   661,    -1,  1529,  1370,  1536,    -1,
    1529,  1370,  1536,    -1,   660,  1504,  1370,  1191,    -1,   660,
     660,  1526,  1529,  1370,  1536,    -1,   994,   999,    -1,   350,
    1370,  1191,    -1,   350,   996,  1001,    -1,   470,  1504,    -1,
     403,  1370,  1535,    -1,   403,   197,  1507,  1370,  1535,    -1,
    1502,    -1,  1502,   661,  1502,    -1,   132,   661,  1502,    -1,
    1531,    -1,  1532,    -1,  1531,   655,  1532,    -1,  1532,   655,
    1531,    -1,  1533,    -1,   257,   274,  1534,    -1,   431,   378,
      -1,   431,   635,    -1,   431,   587,    -1,   431,    84,    -1,
     452,   431,    -1,   488,    -1,   563,    -1,   403,   653,   563,
     654,    -1,   375,   653,   563,   654,    -1,  1191,    -1,   132,
      -1,   376,    -1,    13,    -1,    36,    -1,    -1,   286,  1539,
    1538,  1540,    -1,   557,    -1,   553,    -1,  1541,    -1,  1540,
     655,  1541,    -1,  1495,  1291,  1542,    -1,   431,    -1,   635,
      -1,   635,    89,    -1,   294,   635,    -1,   431,   283,    -1,
      -1,   598,  1544,  1539,    -1,   216,  1495,   380,  1291,    -1,
     216,  1497,    70,    -1,    -1,   216,  1497,   431,  1546,  1547,
    1293,  1310,    -1,  1548,    -1,  1502,  1549,    -1,   190,    -1,
     360,    -1,   190,    -1,   360,    -1,   415,    -1,   266,    -1,
      -1,  1551,  1550,   653,  1375,   654,    -1,   166,    -1,   203,
      -1,   268,    -1,   215,    -1,   295,    -1,   468,   715,  1553,
      -1,  1563,   376,  1562,  1574,   199,  1577,    -1,  1563,   376,
     202,  1574,   199,  1577,    -1,  1563,   376,   418,  1574,   199,
    1577,    -1,    13,  1564,   655,   211,   383,   199,  1577,    -1,
     423,   376,  1507,   199,  1575,    -1,  1554,   199,  1577,    -1,
       7,   383,   197,  1561,    -1,  1561,    -1,   211,   715,  1556,
      -1,  1563,   376,  1562,  1574,   574,  1576,  1584,  1585,    -1,
    1563,   376,   202,  1574,   574,  1576,  1584,  1585,    -1,  1563,
     376,   418,  1574,   574,  1576,  1584,  1585,    -1,   423,   376,
    1507,   574,  1576,  1586,    -1,  1561,   574,  1576,  1558,    -1,
      -1,   630,     7,  1506,    -1,    -1,   630,     7,   383,    -1,
    1561,    -1,  1559,   655,  1561,    -1,   110,  1190,    -1,  1504,
      -1,  1560,    -1,    -1,   557,    -1,  1565,    -1,    13,  1564,
      -1,    -1,   417,    -1,  1566,    -1,  1565,   655,  1566,    -1,
      -1,   485,  1567,  1581,    -1,    -1,   246,  1568,  1581,    -1,
      -1,   601,  1569,  1581,    -1,    -1,   439,  1570,  1581,    -1,
     136,    -1,   603,    -1,   239,    -1,    14,    -1,   104,    -1,
     150,    -1,   177,    -1,   447,    -1,   499,    -1,   419,    -1,
     189,    -1,   211,   383,    -1,   498,   116,    -1,   548,    -1,
     104,   560,   553,    -1,   286,   553,    -1,   455,   503,    -1,
     455,    68,    -1,   104,   621,    -1,   498,   621,    -1,   104,
     473,    -1,    14,   473,    -1,   104,   604,    -1,   173,    -1,
     579,    -1,   104,   554,    -1,    -1,    18,    -1,  1573,  1571,
    1572,    -1,  1573,    -1,   543,   563,    -1,   258,   563,    -1,
      66,   563,    -1,   648,    -1,  1502,   661,   648,    -1,   648,
     661,   648,    -1,  1495,    -1,  1507,    -1,  1575,   655,  1507,
      -1,  1580,    -1,  1576,   655,  1580,    -1,  1506,    -1,  1577,
     655,  1506,    -1,   620,    -1,   630,    -1,   608,    -1,    20,
      -1,  1507,   232,    49,   563,    -1,  1507,   232,    49,   403,
     563,    -1,  1507,   232,  1578,  1504,    -1,  1507,   232,  1578,
    1504,  1579,  1499,    -1,  1506,    -1,    -1,   653,  1582,   654,
      -1,  1582,   655,  1583,    -1,  1583,    -1,  1502,    -1,    -1,
     456,  1572,    -1,   456,   527,    -1,   456,   636,    -1,   456,
     362,    -1,    -1,   630,  1587,    -1,    -1,   630,   211,   383,
      -1,  1587,  1588,    -1,  1588,    -1,   211,   383,    -1,   319,
    1317,    -1,   323,  1317,    -1,   318,  1317,    -1,   324,  1316,
      -1,    -1,    33,  1590,  1591,    -1,    -1,   633,    -1,    -1,
      18,   366,    58,    -1,    18,    58,    -1,    -1,   446,    -1,
     366,   446,    -1,    -1,   479,    -1,    85,  1591,  1592,  1593,
      -1,   471,  1591,  1592,  1593,    -1,   471,  1591,   574,  1594,
    1502,    -1,   479,  1502,    -1,   446,   479,  1502,    -1,    -1,
    1600,    -1,    -1,   595,  1607,  1601,  1169,    -1,    -1,  1600,
      -1,  1604,    -1,    -1,  1604,    -1,    -1,  1605,  1606,    -1,
    1305,  1309,    -1,  1311,    -1,    -1,   146,    -1,    13,    -1,
     485,  1261,    -1,   653,  1171,   654,    -1,  1608,  1603,    -1,
      -1,  1609,   595,  1607,  1610,  1608,  1603,    -1,  1612,  1609,
    1613,    -1,    -1,    -1,    -1,  1615,    -1,  1615,  1616,    -1,
    1616,    -1,   539,    -1,   223,    -1,   146,    -1,   524,    -1,
     519,    -1,   520,    -1,   522,    -1,    13,    -1,  1622,  1618,
      -1,  1621,  1619,    -1,  1623,  1620,  1625,    -1,  1625,    -1,
    1633,    -1,  1644,    -1,  1638,    -1,   702,    -1,  1625,    -1,
    1633,    -1,  1644,    -1,  1638,    -1,  1637,    -1,   702,    -1,
    1621,    -1,  1622,    -1,    -1,   133,   166,  1506,    -1,    12,
     166,   588,    -1,    12,   166,   331,    -1,    12,   166,   561,
      -1,    -1,   525,   484,   133,    -1,   525,   484,   252,    -1,
      -1,  1624,   621,  1495,  1626,  1627,    20,  1629,    -1,    -1,
     653,  1628,   654,    -1,  1502,    -1,  1628,   655,  1502,    -1,
      -1,  1630,  1631,  1632,    -1,   485,  1172,    -1,   653,  1170,
     654,  1602,    -1,    -1,   630,    65,   383,    -1,   630,    54,
      65,   383,    -1,   630,   283,    65,   383,    -1,    -1,    -1,
      -1,   579,  1185,   716,   821,   822,   376,  1185,  1634,  1495,
     197,  1185,  1635,   155,   476,  1636,   771,    -1,    11,  1185,
     202,  1502,   465,   946,   511,  1499,    -1,  1185,   202,  1502,
     465,   946,   511,  1499,    -1,    -1,    -1,    -1,    -1,    -1,
    1185,   202,   716,   653,  1639,   727,   654,  1640,   465,  1641,
     992,  1642,   718,  1643,   771,    -1,    -1,    -1,    -1,    -1,
     418,  1185,   716,  1645,   653,  1646,   731,   654,  1647,   718,
    1648,   771,    -1,   637,  1651,  1650,  1652,    -1,   637,   160,
    1650,  1654,    -1,   637,   413,  1650,    -1,   637,    85,  1650,
    1653,    -1,   637,   471,  1650,    -1,   637,   435,    -1,  1481,
      -1,  1481,   655,  1481,    -1,  1481,   655,  1481,   655,  1317,
      -1,    33,    -1,   530,    -1,    -1,   260,    -1,   462,    -1,
      -1,   377,   405,    -1,    -1,    -1,   549,  1655,  1656,    -1,
      -1,   197,   334,    -1,   248,   407,  1502,   511,  1499,    -1,
     248,   511,  1499,    -1,   594,   407,  1502,    -1,   594,   511,
    1499,    -1,   643,    -1
};

/* YYRLINE[YYN] -- source line where rule number YYN was defined.  */
static const yytype_uint16 yyrline[] =
{
       0,  1939,  1939,  1951,  1950,  1975,  1982,  1984,  1988,  1989,
    1994,  1995,  1996,  1997,  1998,  1999,  2000,  2001,  2002,  2003,
    2004,  2005,  2006,  2007,  2008,  2009,  2010,  2011,  2012,  2013,
    2014,  2015,  2016,  2017,  2018,  2019,  2020,  2021,  2022,  2023,
    2024,  2025,  2026,  2027,  2028,  2029,  2030,  2031,  2032,  2033,
    2034,  2035,  2036,  2037,  2038,  2039,  2040,  2041,  2042,  2043,
    2044,  2045,  2046,  2047,  2048,  2052,  2061,  2062,  2066,  2075,
    2081,  2091,  2090,  2100,  2102,  2106,  2107,  2111,  2124,  2123,
    2143,  2142,  2151,  2152,  2156,  2160,  2164,  2168,  2172,  2176,
    2181,  2185,  2189,  2193,  2197,  2201,  2206,  2210,  2215,  2246,
    2251,  2254,  2256,  2257,  2261,  2267,  2271,  2287,  2291,  2297,
    2307,  2317,  2330,  2334,  2338,  2354,  2353,  2398,  2403,  2397,
    2410,  2415,  2408,  2422,  2427,  2420,  2433,  2432,  2445,  2444,
    2460,  2464,  2468,  2472,  2476,  2483,  2496,  2497,  2501,  2505,
    2509,  2513,  2517,  2521,  2525,  2533,  2532,  2563,  2562,  2569,
    2576,  2577,  2583,  2589,  2599,  2605,  2611,  2613,  2620,  2621,
    2625,  2631,  2640,  2641,  2649,  2649,  2705,  2706,  2707,  2708,
    2709,  2710,  2711,  2712,  2713,  2714,  2715,  2716,  2717,  2722,
    2736,  2752,  2770,  2771,  2775,  2776,  2781,  2783,  2785,  2787,
    2789,  2791,  2793,  2799,  2800,  2801,  2805,  2809,  2817,  2816,
    2829,  2831,  2834,  2836,  2840,  2844,  2851,  2853,  2857,  2858,
    2863,  2883,  2911,  2913,  2917,  2918,  2922,  2949,  2950,  2951,
    2952,  2956,  2957,  2961,  2962,  2967,  2970,  2997,  2996,  3060,
    3076,  3075,  3131,  3157,  3157,  3180,  3181,  3186,  3188,  3193,
    3215,  3226,  3230,  3252,  3253,  3257,  3261,  3270,  3276,  3282,
    3291,  3305,  3328,  3334,  3335,  3341,  3344,  3348,  3356,  3376,
    3378,  3396,  3402,  3404,  3406,  3408,  3410,  3412,  3414,  3416,
    3418,  3420,  3422,  3424,  3429,  3444,  3460,  3461,  3466,  3472,
    3481,  3487,  3496,  3504,  3513,  3522,  3524,  3533,  3538,  3544,
    3553,  3561,  3563,  3565,  3567,  3569,  3571,  3573,  3575,  3577,
    3579,  3581,  3583,  3585,  3590,  3608,  3629,  3630,  3634,  3635,
    3636,  3637,  3638,  3639,  3640,  3641,  3642,  3643,  3644,  3645,
    3646,  3651,  3650,  3657,  3657,  3712,  3711,  3740,  3740,  3755,
    3808,  3851,  3872,  3871,  3893,  3912,  3914,  3915,  3919,  3939,
    3962,  3964,  3980,  3962,  3999,  4001,  4002,  4006,  4007,  4012,
    4018,  4011,  4039,  4038,  4054,  4055,  4059,  4060,  4065,  4069,
    4064,  4090,  4094,  4089,  4113,  4123,  4128,  4127,  4162,  4163,
    4168,  4167,  4199,  4199,  4214,  4213,  4250,  4262,  4264,  4261,
    4291,  4290,  4311,  4313,  4318,  4320,  4322,  4339,  4344,  4350,
    4357,  4358,  4366,  4372,  4381,  4387,  4393,  4394,  4398,  4398,
    4403,  4404,  4405,  4409,  4410,  4411,  4415,  4419,  4420,  4421,
    4425,  4426,  4427,  4428,  4429,  4430,  4431,  4432,  4436,  4440,
    4441,  4442,  4446,  4447,  4448,  4449,  4450,  4454,  4458,  4459,
    4460,  4464,  4465,  4466,  4467,  4468,  4469,  4470,  4474,  4478,
    4479,  4480,  4484,  4485,  4486,  4491,  4499,  4507,  4515,  4527,
    4539,  4544,  4549,  4557,  4565,  4573,  4581,  4589,  4597,  4605,
    4618,  4631,  4644,  4646,  4650,  4655,  4668,  4669,  4721,  4720,
    4723,  4729,  4729,  4730,  4744,  4745,  4749,  4751,  4750,  4754,
    4753,  4759,  4796,  4797,  4802,  4801,  4820,  4839,  4838,  4855,
    4859,  4867,  4866,  4869,  4871,  4873,  4875,  4880,  4881,  4887,
    4888,  4905,  4906,  4910,  4911,  4915,  4934,  4944,  4955,  4964,
    4965,  4981,  4983,  4982,  4987,  4985,  4996,  4997,  5001,  5019,
    5035,  5036,  5052,  5067,  5089,  5090,  5095,  5094,  5118,  5128,
    5150,  5149,  5167,  5166,  5186,  5208,  5212,  5241,  5253,  5254,
    5259,  5270,  5258,  5295,  5296,  5300,  5313,  5334,  5347,  5373,
    5374,  5379,  5378,  5415,  5420,  5421,  5425,  5426,  5430,  5432,
    5438,  5444,  5446,  5448,  5450,  5452,  5454,  5464,  5479,  5463,
    5493,  5494,  5498,  5499,  5503,  5504,  5508,  5509,  5513,  5514,
    5518,  5519,  5523,  5528,  5532,  5540,  5544,  5550,  5552,  5556,
    5557,  5561,  5562,  5563,  5567,  5572,  5577,  5582,  5587,  5592,
    5597,  5602,  5617,  5623,  5638,  5643,  5658,  5664,  5682,  5687,
    5692,  5697,  5702,  5707,  5713,  5712,  5738,  5739,  5740,  5745,
    5750,  5755,  5757,  5759,  5761,  5767,  5772,  5777,  5783,  5789,
    5795,  5804,  5822,  5839,  5862,  5876,  5877,  5878,  5879,  5880,
    5881,  5882,  5886,  5887,  5888,  5892,  5893,  5897,  5898,  5899,
    5900,  5905,  5912,  5913,  5917,  5918,  5922,  5923,  5931,  5930,
    5939,  5937,  5947,  5945,  5955,  5953,  5961,  5982,  5988,  5990,
    5994,  5998,  5999,  6003,  6008,  6007,  6033,  6036,  6035,  6045,
    6047,  6052,  6055,  6059,  6066,  6067,  6071,  6072,  6076,  6082,
    6088,  6092,  6108,  6124,  6125,  6126,  6127,  6132,  6136,  6141,
    6146,  6150,  6155,  6160,  6166,  6171,  6177,  6181,  6186,  6191,
    6209,  6211,  6213,  6226,  6228,  6233,  6238,  6250,  6255,  6260,
    6265,  6267,  6269,  6271,  6273,  6275,  6277,  6279,  6282,  6281,
    6286,  6285,  6289,  6291,  6300,  6301,  6302,  6308,  6309,  6310,
    6311,  6312,  6316,  6320,  6321,  6325,  6326,  6330,  6331,  6332,
    6333,  6334,  6338,  6339,  6340,  6341,  6342,  6346,  6351,  6353,
    6359,  6360,  6362,  6367,  6376,  6377,  6381,  6382,  6386,  6387,
    6388,  6392,  6393,  6394,  6395,  6398,  6399,  6403,  6404,  6408,
    6409,  6413,  6414,  6418,  6419,  6420,  6421,  6428,  6429,  6435,
    6441,  6447,  6453,  6454,  6467,  6473,  6479,  6485,  6494,  6515,
    6521,  6526,  6527,  6531,  6539,  6543,  6544,  6548,  6549,  6553,
    6562,  6566,  6567,  6571,  6579,  6580,  6584,  6585,  6589,  6590,
    6595,  6596,  6600,  6607,  6616,  6621,  6629,  6630,  6631,  6632,
    6633,  6634,  6639,  6647,  6648,  6653,  6652,  6665,  6666,  6670,
    6673,  6674,  6675,  6676,  6680,  6688,  6695,  6696,  6700,  6710,
    6711,  6715,  6716,  6719,  6721,  6725,  6737,  6738,  6742,  6749,
    6762,  6763,  6765,  6767,  6773,  6778,  6784,  6790,  6797,  6807,
    6808,  6809,  6810,  6811,  6815,  6819,  6820,  6824,  6825,  6829,
    6830,  6834,  6835,  6836,  6840,  6841,  6845,  6849,  6862,  6874,
    6875,  6879,  6880,  6884,  6885,  6889,  6890,  6894,  6895,  6899,
    6900,  6904,  6905,  6909,  6910,  6914,  6916,  6917,  6923,  6929,
    6935,  6943,  6944,  6948,  6952,  6953,  6966,  6967,  6968,  6972,
    6973,  6977,  6983,  6997,  6998,  7002,  7014,  7015,  7019,  7020,
    7028,  7045,  7027,  7065,  7064,  7078,  7090,  7089,  7108,  7107,
    7126,  7125,  7144,  7138,  7158,  7157,  7190,  7195,  7200,  7205,
    7210,  7220,  7221,  7222,  7223,  7227,  7228,  7240,  7241,  7245,
    7246,  7249,  7251,  7259,  7267,  7269,  7271,  7272,  7280,  7281,
    7285,  7294,  7292,  7305,  7318,  7317,  7330,  7328,  7341,  7348,
    7358,  7359,  7386,  7393,  7397,  7402,  7401,  7417,  7419,  7424,
    7432,  7431,  7447,  7451,  7450,  7462,  7463,  7467,  7482,  7483,
    7487,  7496,  7500,  7505,  7511,  7510,  7522,  7533,  7521,  7549,
    7558,  7567,  7577,  7586,  7592,  7598,  7607,  7616,  7635,  7655,
    7665,  7669,  7674,  7675,  7678,  7680,  7681,  7682,  7683,  7686,
    7691,  7702,  7707,  7718,  7719,  7723,  7724,  7728,  7728,  7731,
    7733,  7737,  7738,  7742,  7743,  7751,  7752,  7753,  7757,  7758,
    7763,  7771,  7772,  7773,  7774,  7779,  7778,  7788,  7787,  7794,
    7801,  7811,  7828,  7831,  7838,  7842,  7849,  7853,  7857,  7864,
    7864,  7870,  7871,  7875,  7876,  7877,  7881,  7882,  7895,  7902,
    7903,  7908,  7907,  7919,  7920,  7921,  7926,  7925,  7946,  7947,
    7951,  7952,  7956,  7957,  7958,  7963,  7962,  7983,  7984,  7988,
    7993,  7994,  8001,  8003,  8007,  8009,  8008,  8020,  8022,  8021,
    8034,  8035,  8040,  8049,  8050,  8051,  8055,  8061,  8070,  8079,
    8078,  8104,  8105,  8109,  8110,  8114,  8115,  8116,  8117,  8118,
    8119,  8124,  8123,  8144,  8145,  8146,  8151,  8150,  8156,  8163,
    8168,  8176,  8177,  8181,  8195,  8194,  8207,  8208,  8212,  8213,
    8217,  8227,  8237,  8238,  8243,  8242,  8253,  8254,  8258,  8259,
    8263,  8273,  8284,  8283,  8291,  8291,  8300,  8301,  8306,  8307,
    8316,  8325,  8326,  8330,  8335,  8340,  8345,  8350,  8349,  8369,
    8377,  8369,  8384,  8385,  8386,  8387,  8388,  8392,  8399,  8406,
    8408,  8419,  8420,  8424,  8425,  8453,  8483,  8485,  8491,  8501,
    8502,  8503,  8517,  8522,  8547,  8553,  8559,  8560,  8561,  8562,
    8563,  8567,  8568,  8569,  8573,  8574,  8575,  8579,  8580,  8585,
    8636,  8643,  8686,  8692,  8698,  8704,  8710,  8716,  8722,  8728,
    8732,  8738,  8744,  8750,  8756,  8762,  8766,  8772,  8781,  8787,
    8795,  8801,  8811,  8817,  8826,  8836,  8842,  8852,  8858,  8867,
    8871,  8877,  8883,  8889,  8895,  8901,  8907,  8913,  8919,  8925,
    8931,  8937,  8943,  8949,  8955,  8959,  8960,  8964,  8965,  8969,
    8970,  8974,  8975,  8979,  8980,  8981,  8982,  8983,  8984,  8988,
    8989,  8994,  9000,  9004,  9011,  9018,  9025,  9032,  9039,  9044,
    9050,  9057,  9064,  9072,  9083,  9105,  9112,  9120,  9121,  9122,
    9123,  9124,  9125,  9136,  9137,  9138,  9139,  9140,  9146,  9150,
    9156,  9162,  9168,  9174,  9176,  9183,  9190,  9196,  9220,  9229,
    9236,  9244,  9250,  9257,  9263,  9277,  9284,  9300,  9306,  9312,
    9320,  9328,  9334,  9340,  9346,  9352,  9366,  9377,  9383,  9389,
    9395,  9401,  9407,  9413,  9419,  9425,  9431,  9437,  9443,  9449,
    9455,  9461,  9467,  9473,  9481,  9502,  9509,  9515,  9522,  9529,
    9536,  9543,  9549,  9555,  9562,  9568,  9575,  9581,  9587,  9593,
    9599,  9605,  9623,  9629,  9635,  9642,  9649,  9657,  9664,  9671,
    9678,  9685,  9702,  9708,  9714,  9720,  9726,  9733,  9739,  9745,
    9751,  9757,  9763,  9774,  9780,  9786,  9792,  9798,  9806,  9812,
    9823,  9829,  9835,  9843,  9853,  9859,  9875,  9881,  9888,  9895,
    9902,  9909,  9916,  9920,  9940,  9939, 10011, 10052, 10054, 10059,
   10060, 10064, 10065, 10069, 10070, 10074, 10081, 10089, 10115, 10121,
   10127, 10133, 10139, 10145, 10154, 10161, 10163, 10160, 10170, 10181,
   10187, 10193, 10199, 10205, 10211, 10217, 10223, 10229, 10236, 10235,
   10255, 10254, 10269, 10279, 10287, 10303, 10304, 10309, 10314, 10317,
   10320, 10319, 10336, 10338, 10344, 10343, 10360, 10362, 10364, 10366,
   10368, 10370, 10372, 10374, 10376, 10378, 10384, 10390, 10393, 10392,
   10398, 10399, 10403, 10410, 10418, 10419, 10423, 10430, 10438, 10439,
   10443, 10444, 10448, 10456, 10467, 10468, 10480, 10491, 10492, 10498,
   10499, 10519, 10523, 10521, 10539, 10537, 10548, 10558, 10556, 10574,
   10573, 10583, 10594, 10592, 10611, 10610, 10621, 10633, 10634, 10635,
   10639, 10640, 10648, 10649, 10653, 10668, 10668, 10683, 10723, 10799,
   10810, 10815, 10807, 10834, 10854, 10862, 10854, 10871, 10870, 10893,
   10910, 10893, 10917, 10921, 10947, 10948, 10953, 10956, 10957, 10958,
   10962, 10963, 10968, 10967, 10973, 10972, 10980, 10981, 10984, 10986,
   10986, 10990, 10990, 10995, 10996, 11000, 11002, 11007, 11008, 11012,
   11023, 11036, 11037, 11038, 11039, 11040, 11041, 11042, 11043, 11044,
   11045, 11046, 11047, 11051, 11052, 11053, 11054, 11055, 11056, 11057,
   11058, 11059, 11063, 11064, 11065, 11066, 11069, 11071, 11072, 11076,
   11077, 11085, 11087, 11091, 11093, 11092, 11106, 11109, 11108, 11123,
   11129, 11143, 11145, 11149, 11151, 11156, 11157, 11177, 11202, 11206,
   11207, 11211, 11223, 11225, 11230, 11229, 11264, 11266, 11271, 11272,
   11273, 11278, 11285, 11289, 11290, 11294, 11301, 11305, 11312, 11319,
   11326, 11336, 11369, 11373, 11379, 11385, 11394, 11402, 11406, 11413,
   11414, 11418, 11419, 11420, 11424, 11425, 11426, 11427, 11428, 11429,
   11433, 11434, 11435, 11436, 11437, 11441, 11442, 11443, 11444, 11445,
   11449, 11450, 11451, 11452, 11453, 11457, 11462, 11463, 11467, 11468,
   11471, 11474, 11473, 11504, 11505, 11509, 11510, 11514, 11524, 11524,
   11534, 11535, 11539, 11558, 11591, 11590, 11603, 11611, 11602, 11613,
   11625, 11637, 11636, 11654, 11653, 11664, 11664, 11680, 11687, 11709,
   11729, 11741, 11745, 11750, 11749, 11759, 11765, 11772, 11777, 11782,
   11792, 11793, 11797, 11808, 11821, 11822, 11826, 11838, 11842, 11850,
   11851, 11859, 11867, 11858, 11877, 11884, 11876, 11894, 11902, 11903,
   11911, 11915, 11916, 11927, 11928, 11932, 11941, 11942, 11943, 11945,
   11944, 11955, 11956, 11960, 11961, 11963, 11962, 11966, 11965, 11971,
   11972, 11976, 11977, 11981, 11991, 11992, 11996, 11997, 12002, 12001,
   12015, 12016, 12020, 12025, 12033, 12034, 12042, 12044, 12044, 12052,
   12060, 12051, 12082, 12083, 12087, 12095, 12096, 12100, 12110, 12111,
   12118, 12117, 12133, 12144, 12132, 12147, 12146, 12158, 12157, 12170,
   12172, 12176, 12177, 12181, 12194, 12210, 12211, 12215, 12216, 12220,
   12221, 12222, 12227, 12226, 12247, 12249, 12252, 12254, 12257, 12258,
   12261, 12265, 12269, 12273, 12277, 12281, 12285, 12289, 12293, 12301,
   12304, 12314, 12313, 12329, 12336, 12344, 12352, 12360, 12368, 12376,
   12383, 12390, 12396, 12398, 12400, 12409, 12413, 12418, 12417, 12423,
   12422, 12427, 12436, 12443, 12448, 12453, 12458, 12460, 12462, 12464,
   12466, 12468, 12475, 12483, 12485, 12493, 12500, 12507, 12514, 12520,
   12526, 12535, 12543, 12547, 12552, 12559, 12564, 12571, 12578, 12585,
   12592, 12599, 12606, 12612, 12619, 12626, 12631, 12636, 12641, 12651,
   12653, 12655, 12660, 12661, 12664, 12666, 12670, 12671, 12675, 12676,
   12680, 12681, 12685, 12686, 12690, 12691, 12694, 12696, 12703, 12714,
   12713, 12729, 12728, 12738, 12739, 12740, 12741, 12742, 12746, 12747,
   12751, 12752, 12753, 12757, 12758, 12759, 12774, 12773, 12786, 12785,
   12796, 12800, 12801, 12814, 12817, 12816, 12828, 12829, 12834, 12836,
   12838, 12840, 12842, 12844, 12855, 12857, 12859, 12861, 12867, 12869,
   12880, 12882, 12884, 12886, 12888, 12890, 12892, 12897, 12898, 12902,
   12903, 12907, 12906, 12916, 12917, 12921, 12921, 12924, 12925, 12929,
   12930, 12935, 12934, 12945, 12949, 12953, 12966, 12965, 12980, 12981,
   12982, 12985, 12986, 12987, 12988, 12996, 13000, 13009, 13015, 13027,
   13038, 13048, 13058, 13026, 13066, 13067, 13071, 13072, 13076, 13077,
   13085, 13089, 13090, 13091, 13094, 13096, 13100, 13101, 13105, 13110,
   13117, 13122, 13129, 13131, 13135, 13136, 13140, 13145, 13153, 13154,
   13157, 13159, 13167, 13169, 13173, 13174, 13175, 13179, 13181, 13186,
   13187, 13196, 13197, 13201, 13202, 13206, 13219, 13242, 13254, 13261,
   13280, 13288, 13293, 13305, 13313, 13328, 13348, 13349, 13350, 13358,
   13359, 13360, 13361, 13368, 13374, 13380, 13386, 13392, 13398, 13410,
   13420, 13430, 13436, 13445, 13457, 13463, 13469, 13485, 13486, 13490,
   13499, 13514, 13518, 13564, 13568, 13585, 13589, 13667, 13691, 13721,
   13722, 13738, 13748, 13752, 13758, 13764, 13774, 13780, 13789, 13799,
   13800, 13828, 13842, 13856, 13871, 13872, 13882, 13883, 13893, 13894,
   13895, 13899, 13914, 13946, 13956, 13956, 13958, 13968, 13969, 13970,
   13971, 13972, 13973, 13974, 13975, 13976, 13977, 13978, 13979, 13980,
   13981, 13982, 13983, 13984, 13985, 13986, 13987, 13988, 13989, 13990,
   13991, 13992, 13993, 13994, 13995, 13996, 13997, 13998, 13999, 14000,
   14001, 14002, 14003, 14004, 14005, 14006, 14007, 14008, 14009, 14010,
   14011, 14012, 14013, 14014, 14015, 14016, 14017, 14018, 14019, 14020,
   14021, 14022, 14023, 14024, 14025, 14026, 14027, 14037, 14038, 14039,
   14040, 14041, 14042, 14043, 14044, 14045, 14046, 14047, 14048, 14049,
   14050, 14051, 14052, 14053, 14054, 14055, 14056, 14057, 14058, 14059,
   14060, 14061, 14062, 14063, 14064, 14065, 14066, 14067, 14068, 14069,
   14070, 14071, 14072, 14073, 14074, 14075, 14076, 14077, 14078, 14079,
   14080, 14081, 14082, 14083, 14084, 14085, 14086, 14091, 14092, 14093,
   14094, 14095, 14096, 14097, 14098, 14099, 14100, 14101, 14102, 14103,
   14104, 14105, 14106, 14107, 14108, 14109, 14110, 14111, 14112, 14113,
   14114, 14115, 14116, 14117, 14118, 14119, 14120, 14121, 14122, 14123,
   14124, 14125, 14126, 14127, 14128, 14129, 14130, 14131, 14132, 14133,
   14134, 14135, 14136, 14137, 14138, 14139, 14140, 14141, 14142, 14143,
   14144, 14145, 14146, 14147, 14148, 14149, 14150, 14151, 14152, 14153,
   14154, 14155, 14156, 14157, 14158, 14159, 14160, 14161, 14162, 14163,
   14164, 14165, 14166, 14167, 14168, 14169, 14170, 14171, 14172, 14173,
   14174, 14175, 14176, 14177, 14178, 14179, 14180, 14181, 14182, 14183,
   14184, 14185, 14186, 14187, 14188, 14189, 14190, 14191, 14192, 14193,
   14194, 14195, 14196, 14197, 14198, 14199, 14200, 14201, 14202, 14203,
   14204, 14205, 14206, 14207, 14208, 14209, 14210, 14211, 14212, 14213,
   14214, 14215, 14216, 14217, 14218, 14219, 14220, 14221, 14222, 14223,
   14224, 14225, 14226, 14227, 14228, 14229, 14230, 14231, 14232, 14233,
   14234, 14235, 14236, 14237, 14238, 14239, 14240, 14241, 14242, 14243,
   14244, 14245, 14246, 14247, 14248, 14249, 14250, 14251, 14252, 14253,
   14254, 14255, 14256, 14257, 14258, 14259, 14260, 14261, 14262, 14263,
   14264, 14265, 14266, 14267, 14268, 14269, 14270, 14271, 14272, 14273,
   14274, 14275, 14276, 14277, 14278, 14279, 14280, 14281, 14282, 14283,
   14284, 14285, 14286, 14287, 14288, 14289, 14290, 14291, 14292, 14293,
   14294, 14295, 14296, 14297, 14298, 14299, 14300, 14301, 14302, 14303,
   14304, 14305, 14306, 14307, 14308, 14309, 14310, 14311, 14312, 14313,
   14314, 14315, 14316, 14317, 14318, 14319, 14320, 14321, 14322, 14323,
   14324, 14325, 14326, 14327, 14328, 14329, 14330, 14331, 14332, 14333,
   14334, 14335, 14336, 14337, 14338, 14339, 14340, 14341, 14342, 14343,
   14344, 14345, 14346, 14347, 14348, 14349, 14350, 14362, 14361, 14379,
   14378, 14385, 14384, 14394, 14393, 14404, 14403, 14409, 14417, 14419,
   14424, 14424, 14433, 14432, 14446, 14445, 14450, 14454, 14455, 14456,
   14460, 14461, 14462, 14463, 14467, 14468, 14469, 14470, 14475, 14499,
   14525, 14536, 14548, 14561, 14576, 14595, 14601, 14626, 14639, 14665,
   14708, 14722, 14723, 14724, 14725, 14729, 14746, 14763, 14764, 14768,
   14769, 14770, 14771, 14775, 14776, 14785, 14796, 14797, 14798, 14804,
   14810, 14822, 14821, 14837, 14838, 14842, 14843, 14847, 14862, 14863,
   14864, 14869, 14870, 14875, 14874, 14894, 14906, 14919, 14918, 14952,
   14953, 14957, 14958, 14962, 14963, 14964, 14965, 14967, 14966, 14979,
   14980, 14981, 14982, 14983, 14989, 14994, 15000, 15011, 15022, 15026,
   15033, 15042, 15044, 15049, 15054, 15061, 15073, 15085, 15092, 15104,
   15105, 15108, 15109, 15112, 15117, 15125, 15136, 15156, 15159, 15161,
   15165, 15166, 15173, 15175, 15179, 15180, 15185, 15184, 15188, 15187,
   15191, 15190, 15194, 15193, 15196, 15197, 15198, 15199, 15200, 15201,
   15202, 15203, 15204, 15205, 15206, 15207, 15208, 15209, 15210, 15211,
   15212, 15213, 15214, 15215, 15216, 15217, 15218, 15219, 15220, 15221,
   15225, 15226, 15230, 15231, 15235, 15245, 15255, 15268, 15283, 15296,
   15309, 15321, 15326, 15334, 15339, 15347, 15352, 15359, 15359, 15360,
   15360, 15363, 15392, 15397, 15403, 15409, 15415, 15419, 15423, 15424,
   15428, 15455, 15457, 15461, 15465, 15469, 15476, 15477, 15481, 15482,
   15486, 15487, 15491, 15492, 15498, 15504, 15510, 15520, 15519, 15529,
   15530, 15535, 15536, 15537, 15542, 15543, 15544, 15548, 15549, 15553,
   15565, 15574, 15584, 15593, 15607, 15608, 15613, 15612, 15628, 15629,
   15630, 15634, 15635, 15639, 15639, 15661, 15662, 15666, 15667, 15668,
   15672, 15676, 15683, 15686, 15684, 15700, 15707, 15728, 15745, 15747,
   15751, 15752, 15756, 15757, 15765, 15766, 15767, 15768, 15774, 15780,
   15790, 15792, 15794, 15799, 15800, 15801, 15802, 15803, 15807, 15808,
   15809, 15810, 15811, 15812, 15822, 15823, 15828, 15841, 15854, 15856,
   15858, 15864, 15865, 15867, 15873, 15872, 15889, 15890, 15894, 15899,
   15907, 15907, 15931, 15932, 15937, 15938, 15940, 15942, 15960, 15966,
   15971, 15953, 16032, 16049, 16073, 16104, 16108, 16117, 16140, 16069,
   16203, 16227, 16236, 16243, 16202, 16263, 16267, 16271, 16275, 16279,
   16283, 16290, 16297, 16304, 16314, 16315, 16319, 16320, 16321, 16325,
   16326, 16331, 16333, 16332, 16338, 16339, 16343, 16350, 16360, 16366,
   16377
};
#endif

#if YYDEBUG || YYERROR_VERBOSE || YYTOKEN_TABLE
/* YYTNAME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals.  */
static const char *const yytname[] =
{
  "$end", "error", "$undefined", "ABORT_SYM", "ACCESSIBLE_SYM", "ACTION",
  "ADD", "ADMIN_SYM", "ADDDATE_SYM", "AFTER_SYM", "AGAINST",
  "AGGREGATE_SYM", "ALGORITHM_SYM", "ALL", "ALTER", "ALWAYS_SYM",
  "ANALYZE_SYM", "AND_AND_SYM", "AND_SYM", "ANY_SYM", "AS", "ASC",
  "ASCII_SYM", "ASENSITIVE_SYM", "AT_SYM", "AUTHORS_SYM",
  "AUTOEXTEND_SIZE_SYM", "AUTO_INC", "AUTO_SYM", "AVG_ROW_LENGTH",
  "AVG_SYM", "BACKUP_SYM", "BEFORE_SYM", "BEGIN_SYM", "BETWEEN_SYM",
  "BIGINT", "BINARY", "BINLOG_SYM", "BIN_NUM", "BIT_AND", "BIT_OR",
  "BIT_SYM", "BIT_XOR", "BLOB_SYM", "BLOCK_SYM", "BOOLEAN_SYM", "BOOL_SYM",
  "BOTH", "BTREE_SYM", "BY", "BYTE_SYM", "CACHE_SYM", "CALL_SYM",
  "CASCADE", "CASCADED", "CASE_SYM", "CAST_SYM", "CATALOG_NAME_SYM",
  "CHAIN_SYM", "CHANGE", "CHANGED", "CHARSET", "CHAR_SYM",
  "CHECKPOINT_SYM", "CHECKSUM_SYM", "CHECK_SYM", "CIPHER_SYM",
  "CLASS_ORIGIN_SYM", "CLIENT_SYM", "CLIENT_STATS_SYM", "CLOSE_SYM",
  "COALESCE", "CODE_SYM", "COLLATE_SYM", "COLLATION_SYM", "COLUMNS",
  "COLUMN_ADD_SYM", "COLUMN_CHECK_SYM", "COLUMN_CREATE_SYM",
  "COLUMN_DELETE_SYM", "COLUMN_GET_SYM", "COLUMN_SYM", "COLUMN_NAME_SYM",
  "COMMENT_SYM", "COMMITTED_SYM", "COMMIT_SYM", "COMPACT_SYM",
  "COMPLETION_SYM", "COMPRESSED_SYM", "CONCURRENT", "CONDITION_SYM",
  "CONNECTION_SYM", "CONSISTENT_SYM", "CONSTRAINT",
  "CONSTRAINT_CATALOG_SYM", "CONSTRAINT_NAME_SYM", "CONSTRAINT_SCHEMA_SYM",
  "CONTAINS_SYM", "CONTEXT_SYM", "CONTINUE_SYM", "CONTRIBUTORS_SYM",
  "CONVERT_SYM", "COUNT_SYM", "CPU_SYM", "CREATE", "CROSS", "CUBE_SYM",
  "CURDATE", "CURRENT_SYM", "CURRENT_USER", "CURRENT_ROLE",
  "CURRENT_POS_SYM", "CURSOR_SYM", "CURSOR_NAME_SYM", "CURTIME",
  "DATABASE", "DATABASES", "DATAFILE_SYM", "DATA_SYM", "DATETIME",
  "DATE_ADD_INTERVAL", "DATE_SUB_INTERVAL", "DATE_SYM", "DAY_HOUR_SYM",
  "DAY_MICROSECOND_SYM", "DAY_MINUTE_SYM", "DAY_SECOND_SYM", "DAY_SYM",
  "DEALLOCATE_SYM", "DECIMAL_NUM", "DECIMAL_SYM", "DECLARE_SYM", "DEFAULT",
  "DEFINER_SYM", "DELAYED_SYM", "DELAY_KEY_WRITE_SYM", "DELETE_SYM",
  "DESC", "DESCRIBE", "DES_KEY_FILE", "DETERMINISTIC_SYM",
  "DIAGNOSTICS_SYM", "DIRECTORY_SYM", "DISABLE_SYM", "DISCARD", "DISK_SYM",
  "DISTINCT", "DIV_SYM", "DOUBLE_SYM", "DO_SYM", "DROP", "DUAL_SYM",
  "DUMPFILE", "DUPLICATE_SYM", "DYNAMIC_SYM", "EACH_SYM", "ELSE",
  "ELSEIF_SYM", "ENABLE_SYM", "ENCLOSED", "END", "ENDS_SYM",
  "END_OF_INPUT", "ENGINES_SYM", "ENGINE_SYM", "ENUM", "EQ", "EQUAL_SYM",
  "ERROR_SYM", "ERRORS", "ESCAPED", "ESCAPE_SYM", "EVENTS_SYM",
  "EVENT_SYM", "EVERY_SYM", "EXCHANGE_SYM", "EXAMINED_SYM", "EXECUTE_SYM",
  "EXISTS", "EXIT_SYM", "EXPANSION_SYM", "EXPORT_SYM", "EXTENDED_SYM",
  "EXTENT_SIZE_SYM", "EXTRACT_SYM", "FALSE_SYM", "FAST_SYM", "FAULTS_SYM",
  "FETCH_SYM", "FILE_SYM", "FIRST_SYM", "FIXED_SYM", "FLOAT_NUM",
  "FLOAT_SYM", "FLUSH_SYM", "FORCE_SYM", "FOREIGN", "FOR_SYM", "FOUND_SYM",
  "FROM", "FULL", "FULLTEXT_SYM", "FUNCTION_SYM", "GE", "GENERAL",
  "GENERATED_SYM", "GEOMETRYCOLLECTION", "GEOMETRY_SYM", "GET_FORMAT",
  "GET_SYM", "GLOBAL_SYM", "GRANT", "GRANTS", "GROUP_SYM",
  "GROUP_CONCAT_SYM", "GT_SYM", "HANDLER_SYM", "HARD_SYM", "HASH_SYM",
  "HAVING", "HELP_SYM", "HEX_NUM", "HEX_STRING", "HIGH_PRIORITY",
  "HOST_SYM", "HOSTS_SYM", "HOUR_MICROSECOND_SYM", "HOUR_MINUTE_SYM",
  "HOUR_SECOND_SYM", "HOUR_SYM", "ID_SYM", "IDENT", "IDENTIFIED_SYM",
  "IDENT_QUOTED", "IF", "IGNORE_SYM", "IGNORE_SERVER_IDS_SYM", "IMPORT",
  "INDEXES", "INDEX_SYM", "INDEX_STATS_SYM", "INFILE", "INITIAL_SIZE_SYM",
  "INNER_SYM", "INOUT_SYM", "INSENSITIVE_SYM", "INSERT", "INSERT_METHOD",
  "INSTALL_SYM", "INTERVAL_SYM", "INTO", "INT_SYM", "INVOKER_SYM",
  "IN_SYM", "IO_SYM", "IPC_SYM", "IS", "ISOLATION", "ISSUER_SYM",
  "ITERATE_SYM", "JOIN_SYM", "KEYS", "KEY_BLOCK_SIZE", "KEY_SYM",
  "KILL_SYM", "LANGUAGE_SYM", "LAST_SYM", "LAST_VALUE", "LE", "LEADING",
  "LEAVES", "LEAVE_SYM", "LEFT", "LESS_SYM", "LEVEL_SYM", "LEX_HOSTNAME",
  "LIKE", "LIMIT", "LINEAR_SYM", "LINES", "LINESTRING", "LIST_SYM", "LOAD",
  "LOCAL_SYM", "LOCATOR_SYM", "LOCKS_SYM", "LOCK_SYM", "LOGFILE_SYM",
  "LOGS_SYM", "LONGBLOB", "LONGTEXT", "LONG_NUM", "LONG_SYM", "LOOP_SYM",
  "LOW_PRIORITY", "LT", "MASTER_CONNECT_RETRY_SYM", "MASTER_GTID_POS_SYM",
  "MASTER_HOST_SYM", "MASTER_LOG_FILE_SYM", "MASTER_LOG_POS_SYM",
  "MASTER_PASSWORD_SYM", "MASTER_PORT_SYM", "MASTER_SERVER_ID_SYM",
  "MASTER_SSL_CAPATH_SYM", "MASTER_SSL_CA_SYM", "MASTER_SSL_CERT_SYM",
  "MASTER_SSL_CIPHER_SYM", "MASTER_SSL_CRL_SYM", "MASTER_SSL_CRLPATH_SYM",
  "MASTER_SSL_KEY_SYM", "MASTER_SSL_SYM",
  "MASTER_SSL_VERIFY_SERVER_CERT_SYM", "MASTER_SYM", "MASTER_USER_SYM",
  "MASTER_USE_GTID_SYM", "MASTER_HEARTBEAT_PERIOD_SYM", "MATCH",
  "MAX_CONNECTIONS_PER_HOUR", "MAX_QUERIES_PER_HOUR", "MAX_ROWS",
  "MAX_SIZE_SYM", "MAX_SYM", "MAX_UPDATES_PER_HOUR",
  "MAX_USER_CONNECTIONS_SYM", "MAX_VALUE_SYM", "MEDIUMBLOB", "MEDIUMINT",
  "MEDIUMTEXT", "MEDIUM_SYM", "MEMORY_SYM", "MERGE_SYM",
  "MESSAGE_TEXT_SYM", "MICROSECOND_SYM", "MIGRATE_SYM",
  "MINUTE_MICROSECOND_SYM", "MINUTE_SECOND_SYM", "MINUTE_SYM", "MIN_ROWS",
  "MIN_SYM", "MODE_SYM", "MODIFIES_SYM", "MODIFY_SYM", "MOD_SYM",
  "MONTH_SYM", "MULTILINESTRING", "MULTIPOINT", "MULTIPOLYGON",
  "MUTEX_SYM", "MYSQL_ERRNO_SYM", "NAMES_SYM", "NAME_SYM", "NATIONAL_SYM",
  "NATURAL", "NCHAR_STRING", "NCHAR_SYM", "NDBCLUSTER_SYM", "NE", "NEG",
  "NEW_SYM", "NEXT_SYM", "NODEGROUP_SYM", "NONE_SYM", "NOT2_SYM",
  "NOT_SYM", "NOW_SYM", "NO_SYM", "NO_WAIT_SYM", "NO_WRITE_TO_BINLOG",
  "NULL_SYM", "NUM", "NUMBER_SYM", "NUMERIC_SYM", "NVARCHAR_SYM",
  "OFFSET_SYM", "OLD_PASSWORD", "ON", "ONE_SYM", "ONLY_SYM", "ONLINE_SYM",
  "OPEN_SYM", "OPTIMIZE", "OPTIONS_SYM", "OPTION", "OPTIONALLY", "OR2_SYM",
  "ORDER_SYM", "OR_OR_SYM", "OR_SYM", "OUTER", "OUTFILE", "OUT_SYM",
  "OWNER_SYM", "PACK_KEYS_SYM", "PAGE_SYM", "PAGE_CHECKSUM_SYM",
  "PARAM_MARKER", "PARSER_SYM", "PARSE_VCOL_EXPR_SYM", "PARTIAL",
  "PARTITION_SYM", "PARTITIONS_SYM", "PARTITIONING_SYM", "PASSWORD",
  "PERSISTENT_SYM", "PHASE_SYM", "PLUGINS_SYM", "PLUGIN_SYM", "POINT_SYM",
  "POLYGON", "PORT_SYM", "POSITION_SYM", "PRECISION", "PREPARE_SYM",
  "PRESERVE_SYM", "PREV_SYM", "PRIMARY_SYM", "PRIVILEGES", "PROCEDURE_SYM",
  "PROCESS", "PROCESSLIST_SYM", "PROFILE_SYM", "PROFILES_SYM", "PROXY_SYM",
  "PURGE", "QUARTER_SYM", "QUERY_SYM", "QUICK", "RANGE_SYM", "READS_SYM",
  "READ_ONLY_SYM", "READ_SYM", "READ_WRITE_SYM", "REAL", "REBUILD_SYM",
  "RECOVER_SYM", "REDOFILE_SYM", "REDO_BUFFER_SIZE_SYM", "REDUNDANT_SYM",
  "REFERENCES", "REGEXP", "RELAY", "RELAYLOG_SYM", "RELAY_LOG_FILE_SYM",
  "RELAY_LOG_POS_SYM", "RELAY_THREAD", "RELEASE_SYM", "RELOAD",
  "REMOVE_SYM", "RENAME", "REORGANIZE_SYM", "REPAIR", "REPEATABLE_SYM",
  "REPEAT_SYM", "REPLACE", "REPLICATION", "REQUIRE_SYM", "RESET_SYM",
  "RESIGNAL_SYM", "RESOURCES", "RESTORE_SYM", "RESTRICT", "RESUME_SYM",
  "RETURNED_SQLSTATE_SYM", "RETURNING_SYM", "RETURNS_SYM", "RETURN_SYM",
  "REVERSE_SYM", "REVOKE", "RIGHT", "ROLE_SYM", "ROLLBACK_SYM",
  "ROLLUP_SYM", "ROUTINE_SYM", "ROWS_SYM", "ROW_FORMAT_SYM", "ROW_SYM",
  "ROW_COUNT_SYM", "RTREE_SYM", "SAVEPOINT_SYM", "SCHEDULE_SYM",
  "SCHEMA_NAME_SYM", "SECOND_MICROSECOND_SYM", "SECOND_SYM",
  "SECURITY_SYM", "SELECT_SYM", "SENSITIVE_SYM", "SEPARATOR_SYM",
  "SERIALIZABLE_SYM", "SERIAL_SYM", "SESSION_SYM", "SERVER_SYM",
  "SERVER_OPTIONS", "SET", "SET_VAR", "SHARE_SYM", "SHIFT_LEFT",
  "SHIFT_RIGHT", "SHOW", "SHUTDOWN", "SIGNAL_SYM", "SIGNED_SYM",
  "SIMPLE_SYM", "SLAVE", "SLAVES", "SLAVE_POS_SYM", "SLOW", "SMALLINT",
  "SNAPSHOT_SYM", "SOCKET_SYM", "SOFT_SYM", "SONAME_SYM", "SOUNDS_SYM",
  "SOURCE_SYM", "SPATIAL_SYM", "SPECIFIC_SYM", "SQLEXCEPTION_SYM",
  "SQLSTATE_SYM", "SQLWARNING_SYM", "SQL_BIG_RESULT", "SQL_BUFFER_RESULT",
  "SQL_CACHE_SYM", "SQL_CALC_FOUND_ROWS", "SQL_NO_CACHE_SYM",
  "SQL_SMALL_RESULT", "SQL_SYM", "SQL_THREAD", "SSL_SYM", "STARTING",
  "STARTS_SYM", "START_SYM", "STATS_AUTO_RECALC_SYM",
  "STATS_PERSISTENT_SYM", "STATS_SAMPLE_PAGES_SYM", "STATUS_SYM",
  "STDDEV_SAMP_SYM", "STD_SYM", "STOP_SYM", "STORAGE_SYM", "STRAIGHT_JOIN",
  "STRING_SYM", "SUBCLASS_ORIGIN_SYM", "SUBDATE_SYM", "SUBJECT_SYM",
  "SUBPARTITIONS_SYM", "SUBPARTITION_SYM", "SUBSTRING", "SUM_SYM",
  "SUPER_SYM", "SUSPEND_SYM", "SWAPS_SYM", "SWITCHES_SYM", "SYSDATE",
  "TABLES", "TABLESPACE", "TABLE_REF_PRIORITY", "TABLE_STATS_SYM",
  "TABLE_SYM", "TABLE_CHECKSUM_SYM", "TABLE_NAME_SYM", "TEMPORARY",
  "TEMPTABLE_SYM", "TERMINATED", "TEXT_STRING", "TEXT_SYM", "THAN_SYM",
  "THEN_SYM", "TIMESTAMP", "TIMESTAMP_ADD", "TIMESTAMP_DIFF", "TIME_SYM",
  "TINYBLOB", "TINYINT", "TINYTEXT", "TO_SYM", "TRAILING",
  "TRANSACTION_SYM", "TRANSACTIONAL_SYM", "TRIGGERS_SYM", "TRIGGER_SYM",
  "TRIM", "TRUE_SYM", "TRUNCATE_SYM", "TYPES_SYM", "TYPE_SYM",
  "UDF_RETURNS_SYM", "ULONGLONG_NUM", "UNCOMMITTED_SYM", "UNDEFINED_SYM",
  "UNDERSCORE_CHARSET", "UNDOFILE_SYM", "UNDO_BUFFER_SIZE_SYM", "UNDO_SYM",
  "UNICODE_SYM", "UNINSTALL_SYM", "UNION_SYM", "UNIQUE_SYM", "UNKNOWN_SYM",
  "UNLOCK_SYM", "UNSIGNED", "UNTIL_SYM", "UPDATE_SYM", "UPGRADE_SYM",
  "USAGE", "USER", "USER_STATS_SYM", "USE_FRM", "USE_SYM", "USING",
  "UTC_DATE_SYM", "UTC_TIMESTAMP_SYM", "UTC_TIME_SYM", "VALUES",
  "VALUE_SYM", "VARBINARY", "VARCHAR", "VARIABLES", "VARIANCE_SYM",
  "VARYING", "VAR_SAMP_SYM", "VIA_SYM", "VIEW_SYM", "VIRTUAL_SYM",
  "WAIT_SYM", "WARNINGS", "WEEK_SYM", "WEIGHT_STRING_SYM", "WHEN_SYM",
  "WHERE", "WHILE_SYM", "WITH", "WITH_CUBE_SYM", "WITH_ROLLUP_SYM",
  "WORK_SYM", "WRAPPER_SYM", "WRITE_SYM", "X509_SYM", "XA_SYM", "XML_SYM",
  "XOR", "YEAR_MONTH_SYM", "YEAR_SYM", "ZEROFILL", "IMPOSSIBLE_ACTION",
  "'|'", "'&'", "'-'", "'+'", "'*'", "'/'", "'%'", "'^'", "'~'", "'('",
  "')'", "','", "'!'", "'{'", "'}'", "';'", "'@'", "'.'", "':'", "$accept",
  "query", "$@1", "opt_end_of_input", "verb_clause", "statement",
  "deallocate", "deallocate_or_drop", "prepare", "prepare_src", "execute",
  "$@2", "execute_using", "execute_var_list", "execute_var_ident", "help",
  "$@3", "change", "$@4", "master_defs", "master_def",
  "ignore_server_id_list", "ignore_server_id", "master_file_def",
  "optional_connection_name", "connection_name", "create", "$@5", "$@6",
  "$@7", "$@8", "$@9", "$@10", "$@11", "$@12", "$@13", "server_def",
  "server_options_list", "server_option", "event_tail", "$@14",
  "ev_schedule_time", "$@15", "opt_ev_status", "ev_starts", "ev_ends",
  "opt_ev_on_completion", "ev_on_completion", "opt_ev_comment",
  "ev_sql_stmt", "$@16", "ev_sql_stmt_inner", "clear_privileges",
  "sp_name", "sp_a_chistics", "sp_c_chistics", "sp_chistic",
  "sp_c_chistic", "sp_suid", "call", "$@17", "opt_sp_cparam_list",
  "opt_sp_cparams", "sp_cparams", "sp_fdparam_list", "sp_fdparams",
  "sp_init_param", "sp_fdparam", "sp_pdparam_list", "sp_pdparams",
  "sp_pdparam", "sp_opt_inout", "sp_proc_stmts", "sp_proc_stmts1",
  "sp_decls", "sp_decl", "$@18", "$@19", "sp_cursor_stmt", "$@20",
  "sp_handler_type", "sp_hcond_list", "sp_hcond_element", "sp_cond",
  "sqlstate", "opt_value", "sp_hcond", "signal_stmt", "signal_value",
  "opt_signal_value", "opt_set_signal_information",
  "signal_information_item_list", "signal_allowed_expr",
  "signal_condition_information_item_name", "resignal_stmt",
  "get_diagnostics", "which_area", "diagnostics_information",
  "statement_information", "statement_information_item",
  "simple_target_specification", "statement_information_item_name",
  "condition_number", "condition_information",
  "condition_information_item", "condition_information_item_name",
  "sp_decl_idents", "sp_opt_default", "sp_proc_stmt", "sp_proc_stmt_if",
  "$@21", "sp_proc_stmt_statement", "$@22", "sp_proc_stmt_return", "$@23",
  "sp_proc_stmt_unlabeled", "$@24", "sp_proc_stmt_leave",
  "sp_proc_stmt_iterate", "sp_proc_stmt_open", "sp_proc_stmt_fetch",
  "$@25", "sp_proc_stmt_close", "sp_opt_fetch_noise", "sp_fetch_list",
  "sp_if", "$@26", "$@27", "$@28", "sp_elseifs", "case_stmt_specification",
  "simple_case_stmt", "$@29", "$@30", "searched_case_stmt", "$@31",
  "simple_when_clause_list", "searched_when_clause_list",
  "simple_when_clause", "$@32", "$@33", "searched_when_clause", "$@34",
  "$@35", "else_clause_opt", "sp_labeled_control", "$@36", "sp_opt_label",
  "sp_labeled_block", "$@37", "sp_unlabeled_block", "$@38",
  "sp_block_content", "$@39", "sp_unlabeled_control", "$@40", "$@41",
  "$@42", "trg_action_time", "trg_event", "change_tablespace_access",
  "change_tablespace_info", "tablespace_info", "opt_logfile_group_name",
  "alter_tablespace_info", "logfile_group_info",
  "alter_logfile_group_info", "add_log_file", "change_ts_option_list",
  "$@43", "change_ts_options", "change_ts_option",
  "tablespace_option_list", "tablespace_options", "tablespace_option",
  "alter_tablespace_option_list", "alter_tablespace_options",
  "alter_tablespace_option", "logfile_group_option_list",
  "logfile_group_options", "logfile_group_option",
  "alter_logfile_group_option_list", "alter_logfile_group_options",
  "alter_logfile_group_option", "ts_datafile", "lg_undofile",
  "lg_redofile", "tablespace_name", "logfile_group_name", "ts_access_mode",
  "opt_ts_initial_size", "opt_ts_autoextend_size", "opt_ts_max_size",
  "opt_ts_extent_size", "opt_ts_undo_buffer_size",
  "opt_ts_redo_buffer_size", "opt_ts_nodegroup", "opt_ts_comment",
  "opt_ts_engine", "opt_ts_wait", "ts_wait", "size_number", "create_body",
  "$@44", "$@45", "create_like", "opt_create_select", "$@46", "$@47",
  "opt_create_partitioning", "opt_partitioning", "partitioning", "$@48",
  "have_partitioning", "partition_entry", "$@49", "partition",
  "part_type_def", "$@50", "opt_linear", "opt_key_algo", "part_field_list",
  "part_field_item_list", "part_field_item", "part_column_list",
  "part_func", "sub_part_func", "opt_num_parts", "opt_sub_part", "$@51",
  "$@52", "sub_part_field_list", "sub_part_field_item", "part_func_expr",
  "opt_num_subparts", "part_defs", "part_def_list", "part_definition",
  "$@53", "part_name", "opt_part_values", "$@54", "$@55", "part_func_max",
  "part_values_in", "part_value_list", "part_value_item", "$@56", "$@57",
  "part_value_item_list", "part_value_expr_item", "opt_sub_partition",
  "sub_part_list", "sub_part_definition", "$@58", "sub_name",
  "opt_part_options", "opt_part_option_list", "opt_part_option",
  "create_select", "$@59", "$@60", "opt_as", "opt_create_database_options",
  "create_database_options", "create_database_option", "opt_table_options",
  "table_options", "table_option", "opt_if_not_exists",
  "create_or_replace", "opt_create_table_options",
  "create_table_options_space_separated", "create_table_options",
  "create_table_option", "$@61", "default_charset", "default_collation",
  "storage_engines", "known_storage_engines", "row_types",
  "merge_insert_types", "opt_select_from", "udf_type", "create_field_list",
  "field_list", "field_list_item", "column_def", "key_def", "$@62", "$@63",
  "$@64", "$@65", "opt_check_constraint", "check_constraint",
  "opt_constraint", "constraint", "field_spec", "$@66", "field_def", "@67",
  "opt_generated_always", "vcol_opt_specifier", "vcol_opt_attribute",
  "vcol_opt_attribute_list", "vcol_attribute", "parse_vcol_expr",
  "virtual_column_func", "type", "$@68", "$@69", "spatial_type", "char",
  "nchar", "varchar", "nvarchar", "int_type", "real_type", "float_options",
  "precision", "field_options", "field_opt_list", "field_option",
  "field_length", "opt_field_length", "opt_precision", "opt_attribute",
  "opt_attribute_list", "attribute", "type_with_opt_collate",
  "now_or_signed_literal", "charset", "charset_name",
  "charset_name_or_default", "opt_load_data_charset",
  "old_or_new_charset_name", "old_or_new_charset_name_or_default",
  "collation_name", "opt_collate", "collation_name_or_default",
  "opt_default", "ascii", "unicode", "opt_binary", "opt_bin_mod",
  "ws_nweights", "$@70", "ws_level_flag_desc", "ws_level_flag_reverse",
  "ws_level_flags", "ws_level_number", "ws_level_list_item",
  "ws_level_list", "ws_level_range", "ws_level_list_or_range",
  "opt_ws_levels", "opt_primary", "references", "opt_ref_list", "ref_list",
  "opt_match_clause", "opt_on_update_delete", "delete_option",
  "normal_key_type", "constraint_key_type", "key_or_index",
  "opt_key_or_index", "keys_or_index", "opt_unique", "fulltext", "spatial",
  "init_key_options", "key_alg", "normal_key_options",
  "fulltext_key_options", "spatial_key_options", "normal_key_opts",
  "spatial_key_opts", "fulltext_key_opts", "key_using_alg", "all_key_opt",
  "normal_key_opt", "spatial_key_opt", "fulltext_key_opt",
  "btree_or_rtree", "key_list", "key_part", "opt_ident",
  "opt_if_not_exists_ident", "opt_component", "string_list", "alter",
  "$@71", "$@72", "$@73", "$@74", "$@75", "$@76", "$@77", "$@78",
  "ev_alter_on_schedule_completion", "opt_ev_rename_to", "opt_ev_sql_stmt",
  "ident_or_empty", "alter_commands", "$@79", "$@80", "$@81",
  "remove_partitioning", "all_or_alt_part_name_list", "add_partition_rule",
  "$@82", "add_part_extra", "reorg_partition_rule", "$@83",
  "reorg_parts_rule", "$@84", "alt_part_name_list", "alt_part_name_item",
  "alter_list", "add_column", "alter_list_item", "$@85", "$@86", "$@87",
  "opt_index_lock_algorithm", "alter_algorithm_option",
  "alter_lock_option", "opt_column", "opt_ignore", "alter_options", "$@88",
  "alter_options_part2", "alter_option_list", "alter_option",
  "opt_restrict", "opt_place", "opt_to", "slave", "$@89", "$@90", "start",
  "opt_start_transaction_option_list", "start_transaction_option_list",
  "start_transaction_option", "slave_thread_opts", "$@91",
  "slave_thread_opt_list", "slave_thread_opt", "slave_until",
  "slave_until_opts", "checksum", "$@92", "opt_checksum_type", "repair",
  "$@93", "opt_mi_repair_type", "mi_repair_types", "mi_repair_type",
  "analyze", "$@94", "analyze_table_list", "analyze_table_elem_spec",
  "opt_persistent_stat_clause", "persistent_stat_spec",
  "persistent_column_stat_spec", "$@95", "persistent_index_stat_spec",
  "$@96", "table_column_list", "table_index_list", "table_index_name",
  "binlog_base64_event", "check", "$@97", "opt_mi_check_type",
  "mi_check_types", "mi_check_type", "optimize", "$@98",
  "opt_no_write_to_binlog", "rename", "$@99", "rename_list",
  "table_to_table_list", "table_to_table", "keycache", "$@100",
  "keycache_list_or_parts", "keycache_list", "assign_to_keycache",
  "assign_to_keycache_parts", "key_cache_name", "preload", "$@101",
  "preload_list_or_parts", "preload_list", "preload_keys",
  "preload_keys_parts", "adm_partition", "$@102", "cache_keys_spec",
  "$@103", "cache_key_list_or_empty", "opt_ignore_leaves", "select",
  "select_init", "select_paren", "select_paren_derived", "select_init2",
  "$@104", "select_part2", "$@105", "$@106", "select_into", "select_from",
  "select_options", "select_option_list", "select_option",
  "select_lock_type", "select_item_list", "select_item", "remember_name",
  "remember_end", "select_alias", "opt_default_time_precision",
  "opt_time_precision", "optional_braces", "expr", "bool_pri", "predicate",
  "bit_expr", "or", "and", "not", "not2", "comp_op", "all_or_any",
  "opt_dyncol_type", "dyncol_type", "dyncall_create_element",
  "dyncall_create_list", "simple_expr", "function_call_keyword",
  "function_call_nonkeyword", "function_call_conflict",
  "geometry_function", "function_call_generic", "@107", "fulltext_options",
  "opt_natural_language_mode", "opt_query_expansion", "opt_udf_expr_list",
  "udf_expr_list", "udf_expr", "sum_expr", "$@108", "$@109", "$@110",
  "variable", "$@111", "variable_aux", "opt_distinct",
  "opt_gconcat_separator", "opt_gorder_clause", "$@112", "gorder_list",
  "in_sum_expr", "$@113", "cast_type", "$@114", "opt_expr_list",
  "expr_list", "ident_list_arg", "ident_list", "opt_expr", "opt_else",
  "when_list", "table_ref", "join_table_list", "esc_table_ref",
  "derived_table_list", "join_table", "$@115", "$@116", "$@117", "$@118",
  "$@119", "$@120", "inner_join", "normal_join", "opt_use_partition",
  "use_partition", "table_factor", "$@121", "select_derived_union",
  "$@122", "$@123", "select_init2_derived", "select_part2_derived",
  "$@124", "$@125", "select_derived", "$@126", "select_derived2", "$@127",
  "$@128", "get_select_lex", "select_derived_init", "opt_outer",
  "index_hint_clause", "index_hint_type", "index_hint_definition", "$@129",
  "$@130", "index_hints_list", "opt_index_hints_list", "$@131",
  "opt_key_definition", "$@132", "opt_key_usage_list", "key_usage_element",
  "key_usage_list", "using_list", "interval", "interval_time_stamp",
  "date_time_type", "table_alias", "opt_table_alias", "opt_all",
  "where_clause", "$@133", "having_clause", "$@134", "opt_escape",
  "group_clause", "group_list", "olap_opt", "alter_order_clause",
  "alter_order_list", "alter_order_item", "opt_order_clause",
  "order_clause", "$@135", "order_list", "order_dir",
  "opt_limit_clause_init", "opt_limit_clause", "limit_clause",
  "limit_options", "limit_option", "limit_rows_option",
  "delete_limit_clause", "int_num", "ulong_num", "real_ulong_num",
  "ulonglong_num", "real_ulonglong_num", "dec_num_error", "dec_num",
  "choice", "procedure_clause", "$@136", "procedure_list",
  "procedure_list2", "procedure_item", "select_var_list_init", "$@137",
  "select_var_list", "select_var_ident", "into", "$@138",
  "into_destination", "$@139", "$@140", "do", "$@141", "drop", "$@142",
  "$@143", "$@144", "table_list", "table_name",
  "table_name_with_opt_use_partition", "table_alias_ref_list",
  "table_alias_ref", "opt_if_exists", "opt_temporary", "insert", "$@145",
  "$@146", "replace", "$@147", "$@148", "insert_lock_option",
  "replace_lock_option", "insert2", "insert_table", "insert_field_spec",
  "$@149", "fields", "insert_values", "$@150", "$@151", "values_list",
  "ident_eq_list", "ident_eq_value", "equal", "opt_equal", "no_braces",
  "$@152", "opt_values", "values", "expr_or_default", "opt_insert_update",
  "$@153", "update", "$@154", "$@155", "update_list", "update_elem",
  "insert_update_list", "insert_update_elem", "opt_low_priority", "delete",
  "$@156", "single_multi", "$@157", "$@158", "$@159", "$@160",
  "opt_select_expressions", "table_wild_list", "table_wild_one",
  "opt_wild", "opt_delete_options", "opt_delete_option", "truncate",
  "$@161", "opt_table_sym", "opt_profile_defs", "profile_defs",
  "profile_def", "opt_profile_args", "show", "$@162", "show_param",
  "$@163", "$@164", "show_engine_param", "master_or_binary", "opt_storage",
  "opt_db", "opt_full", "from_or_in", "binlog_in", "binlog_from",
  "wild_and_where", "describe", "$@165", "$@166", "explainable_command",
  "describe_command", "opt_extended_describe", "opt_describe_column",
  "flush", "$@167", "flush_options", "$@168", "opt_flush_lock",
  "flush_lock", "$@169", "flush_options_list", "flush_option",
  "opt_table_list", "optional_flush_tables_arguments", "reset", "$@170",
  "reset_options", "reset_option", "$@171", "slave_reset_options", "purge",
  "$@172", "purge_options", "purge_option", "kill", "$@173", "kill_type",
  "kill_option", "kill_expr", "shutdown", "use", "load", "$@174", "$@175",
  "$@176", "$@177", "data_or_xml", "opt_local", "load_data_lock",
  "opt_duplicate", "opt_field_term", "field_term_list", "field_term",
  "opt_line_term", "line_term_list", "line_term",
  "opt_xml_rows_identified_by", "opt_ignore_lines", "lines_or_rows",
  "opt_field_or_var_spec", "fields_or_vars", "field_or_var",
  "opt_load_data_set_spec", "load_data_set_list", "load_data_set_elem",
  "text_literal", "text_string", "hex_or_bin_String", "param_marker",
  "signed_literal", "literal", "NUM_literal", "temporal_literal",
  "insert_ident", "table_wild", "order_ident", "simple_ident",
  "simple_ident_nospvar", "simple_ident_q", "field_ident", "table_ident",
  "table_ident_opt_wild", "table_ident_nodb", "IDENT_sys",
  "TEXT_STRING_sys", "TEXT_STRING_literal", "TEXT_STRING_filesystem",
  "ident", "label_ident", "ident_or_text", "user_maybe_role",
  "user_or_role", "user", "keyword", "keyword_sp", "set", "$@178",
  "start_option_value_list", "$@179", "$@180", "$@181",
  "start_option_value_list_following_option_type", "$@182",
  "option_value_list_continued", "option_value_list", "$@183", "$@184",
  "option_value", "$@185", "option_type", "opt_var_type",
  "opt_var_ident_type", "option_value_following_option_type",
  "option_value_no_option_type", "internal_variable_name",
  "transaction_characteristics", "transaction_access_mode",
  "isolation_level", "transaction_access_mode_types", "isolation_types",
  "text_or_password", "set_expr_or_default", "lock", "$@186",
  "table_or_tables", "table_lock_list", "table_lock", "lock_option",
  "unlock", "$@187", "handler", "$@188", "handler_read_or_scan",
  "handler_scan_function", "handler_rkey_function", "$@189",
  "handler_rkey_mode", "revoke", "revoke_command", "admin_option_for_role",
  "grant", "grant_command", "opt_with_admin", "opt_with_admin_option",
  "role_list", "current_role", "grant_role", "opt_table",
  "grant_privileges", "opt_privileges", "object_privilege_list",
  "object_privilege", "$@190", "$@191", "$@192", "$@193", "opt_and",
  "require_list", "require_list_element", "grant_ident", "user_list",
  "grant_list", "user_and_role_list", "via_or_with", "using_or_as",
  "grant_user", "opt_column_list", "column_list", "column_list_id",
  "require_clause", "grant_options", "opt_grant_option",
  "grant_option_list", "grant_option", "begin", "$@194", "opt_work",
  "opt_chain", "opt_release", "opt_savepoint", "commit", "rollback",
  "savepoint", "release", "union_clause", "union_list", "$@195",
  "union_opt", "opt_union_order_or_limit", "union_order_or_limit", "$@196",
  "order_or_limit", "union_option", "query_specification",
  "query_expression_body", "$@197", "subselect", "subselect_start",
  "subselect_end", "opt_query_expression_options",
  "query_expression_option_list", "query_expression_option",
  "view_or_trigger_or_sp_or_event", "definer_tail", "no_definer_tail",
  "definer_opt", "no_definer", "definer", "view_algorithm", "view_suid",
  "view_tail", "$@198", "view_list_opt", "view_list", "view_select",
  "$@199", "view_select_aux", "view_check_option", "trigger_tail", "$@200",
  "$@201", "$@202", "udf_tail", "sf_tail", "$@203", "$@204", "$@205",
  "$@206", "$@207", "sp_tail", "$@208", "$@209", "$@210", "$@211", "xa",
  "xid", "begin_or_start", "opt_join_or_resume", "opt_one_phase",
  "opt_suspend", "$@212", "opt_migrate", "install", "uninstall",
  "keep_gcc_happy", 0
};
#endif

# ifdef YYPRINT
/* YYTOKNUM[YYLEX-NUM] -- Internal token number corresponding to
   token YYLEX-NUM.  */
static const yytype_uint16 yytoknum[] =
{
       0,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,   396,   397,   398,   399,   400,   401,   402,   403,   404,
     405,   406,   407,   408,   409,   410,   411,   412,   413,   414,
     415,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,   427,   428,   429,   430,   431,   432,   433,   434,
     435,   436,   437,   438,   439,   440,   441,   442,   443,   444,
     445,   446,   447,   448,   449,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   460,   461,   462,   463,   464,
     465,   466,   467,   468,   469,   470,   471,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,   482,   483,   484,
     485,   486,   487,   488,   489,   490,   491,   492,   493,   494,
     495,   496,   497,   498,   499,   500,   501,   502,   503,   504,
     505,   506,   507,   508,   509,   510,   511,   512,   513,   514,
     515,   516,   517,   518,   519,   520,   521,   522,   523,   524,
     525,   526,   527,   528,   529,   530,   531,   532,   533,   534,
     535,   536,   537,   538,   539,   540,   541,   542,   543,   544,
     545,   546,   547,   548,   549,   550,   551,   552,   553,   554,
     555,   556,   557,   558,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   572,   573,   574,
     575,   576,   577,   578,   579,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,   592,   593,   594,
     595,   596,   597,   598,   599,   600,   601,   602,   603,   604,
     605,   606,   607,   608,   609,   610,   611,   612,   613,   614,
     615,   616,   617,   618,   619,   620,   621,   622,   623,   624,
     625,   626,   627,   628,   629,   630,   631,   632,   633,   634,
     635,   636,   637,   638,   639,   640,   641,   642,   643,   644,
     645,   646,   647,   648,   649,   650,   651,   652,   653,   654,
     655,   656,   657,   658,   659,   660,   661,   662,   663,   664,
     665,   666,   667,   668,   669,   670,   671,   672,   673,   674,
     675,   676,   677,   678,   679,   680,   681,   682,   683,   684,
     685,   686,   687,   688,   689,   690,   691,   692,   693,   694,
     695,   696,   697,   698,   699,   700,   701,   702,   703,   704,
     705,   706,   707,   708,   709,   710,   711,   712,   713,   714,
     715,   716,   717,   718,   719,   720,   721,   722,   723,   724,
     725,   726,   727,   728,   729,   730,   731,   732,   733,   734,
     735,   736,   737,   738,   739,   740,   741,   742,   743,   744,
     745,   746,   747,   748,   749,   750,   751,   752,   753,   754,
     755,   756,   757,   758,   759,   760,   761,   762,   763,   764,
     765,   766,   767,   768,   769,   770,   771,   772,   773,   774,
     775,   776,   777,   778,   779,   780,   781,   782,   783,   784,
     785,   786,   787,   788,   789,   790,   791,   792,   793,   794,
     795,   796,   797,   798,   799,   800,   801,   802,   803,   804,
     805,   806,   807,   808,   809,   810,   811,   812,   813,   814,
     815,   816,   817,   818,   819,   820,   821,   822,   823,   824,
     825,   826,   827,   828,   829,   830,   831,   832,   833,   834,
     835,   836,   837,   838,   839,   840,   841,   842,   843,   844,
     845,   846,   847,   848,   849,   850,   851,   852,   853,   854,
     855,   856,   857,   858,   859,   860,   861,   862,   863,   864,
     865,   866,   867,   868,   869,   870,   871,   872,   873,   874,
     875,   876,   877,   878,   879,   880,   881,   882,   883,   884,
     885,   886,   887,   888,   889,   890,   891,   892,   893,   894,
     895,   896,   897,   898,   124,    38,    45,    43,    42,    47,
      37,    94,   126,    40,    41,    44,    33,   123,   125,    59,
      64,    46,    58
};
# endif

/* YYR1[YYN] -- Symbol number of symbol that rule YYN derives.  */
static const yytype_uint16 yyr1[] =
{
       0,   663,   664,   665,   664,   664,   666,   666,   667,   667,
     668,   668,   668,   668,   668,   668,   668,   668,   668,   668,
     668,   668,   668,   668,   668,   668,   668,   668,   668,   668,
     668,   668,   668,   668,   668,   668,   668,   668,   668,   668,
     668,   668,   668,   668,   668,   668,   668,   668,   668,   668,
     668,   668,   668,   668,   668,   668,   668,   668,   668,   668,
     668,   668,   668,   668,   668,   669,   670,   670,   671,   672,
     672,   674,   673,   675,   675,   676,   676,   677,   679,   678,
     681,   680,   682,   682,   683,   683,   683,   683,   683,   683,
     683,   683,   683,   683,   683,   683,   683,   683,   683,   683,
     683,   684,   684,   684,   685,   686,   686,   686,   686,   686,
     686,   686,   687,   687,   688,   690,   689,   691,   692,   689,
     693,   694,   689,   695,   696,   689,   697,   689,   698,   689,
     689,   689,   689,   689,   689,   699,   700,   700,   701,   701,
     701,   701,   701,   701,   701,   703,   702,   705,   704,   704,
     706,   706,   706,   706,   707,   707,   708,   708,   709,   709,
     710,   710,   711,   711,   713,   712,   714,   714,   714,   714,
     714,   714,   714,   714,   714,   714,   714,   714,   714,   715,
     716,   716,   717,   717,   718,   718,   719,   719,   719,   719,
     719,   719,   719,   720,   720,   720,   721,   721,   723,   722,
     724,   724,   725,   725,   726,   726,   727,   727,   728,   728,
     729,   730,   731,   731,   732,   732,   733,   734,   734,   734,
     734,   735,   735,   736,   736,   737,   737,   739,   738,   738,
     740,   738,   738,   742,   741,   743,   743,   744,   744,   745,
     746,   746,   747,   748,   748,   749,   749,   749,   749,   749,
     750,   751,   751,   752,   752,   753,   753,   754,   754,   755,
     755,   755,   756,   756,   756,   756,   756,   756,   756,   756,
     756,   756,   756,   756,   757,   758,   759,   759,   760,   760,
     761,   761,   762,   763,   763,   764,   764,   765,   766,   766,
     767,   768,   768,   768,   768,   768,   768,   768,   768,   768,
     768,   768,   768,   768,   769,   769,   770,   770,   771,   771,
     771,   771,   771,   771,   771,   771,   771,   771,   771,   771,
     771,   773,   772,   775,   774,   777,   776,   779,   778,   780,
     781,   782,   784,   783,   785,   786,   786,   786,   787,   787,
     789,   790,   791,   788,   792,   792,   792,   793,   793,   795,
     796,   794,   798,   797,   799,   799,   800,   800,   802,   803,
     801,   805,   806,   804,   807,   807,   809,   808,   810,   810,
     812,   811,   814,   813,   816,   815,   817,   818,   819,   817,
     820,   817,   821,   821,   822,   822,   822,   823,   824,   825,
     826,   826,   827,   827,   828,   829,   830,   830,   832,   831,
     833,   833,   833,   834,   834,   834,   835,   836,   836,   836,
     837,   837,   837,   837,   837,   837,   837,   837,   838,   839,
     839,   839,   840,   840,   840,   840,   840,   841,   842,   842,
     842,   843,   843,   843,   843,   843,   843,   843,   844,   845,
     845,   845,   846,   846,   846,   847,   848,   849,   850,   851,
     852,   852,   852,   853,   854,   855,   856,   857,   858,   859,
     860,   861,   862,   862,   863,   863,   864,   864,   866,   865,
     865,   867,   865,   865,   868,   868,   869,   870,   869,   871,
     869,   872,   873,   873,   875,   874,   876,   878,   877,   879,
     880,   881,   880,   880,   880,   880,   880,   882,   882,   883,
     883,   884,   884,   885,   885,   886,   887,   888,   889,   890,
     890,   891,   892,   891,   893,   891,   894,   894,   895,   896,
     897,   897,   898,   898,   899,   899,   901,   900,   902,   903,
     904,   903,   905,   903,   906,   906,   907,   907,   908,   908,
     910,   911,   909,   912,   912,   913,   913,   914,   914,   915,
     915,   917,   916,   918,   919,   919,   920,   920,   921,   921,
     921,   921,   921,   921,   921,   921,   921,   923,   924,   922,
     925,   925,   926,   926,   927,   927,   928,   928,   929,   929,
     930,   930,   931,   932,   932,   933,   933,   934,   934,   935,
     935,   936,   936,   936,   937,   937,   937,   937,   937,   937,
     937,   937,   937,   937,   937,   937,   937,   937,   937,   937,
     937,   937,   937,   937,   938,   937,   937,   937,   937,   937,
     937,   937,   937,   937,   937,   937,   937,   937,   937,   937,
     937,   939,   940,   941,   942,   943,   943,   943,   943,   943,
     943,   943,   944,   944,   944,   945,   945,   946,   946,   946,
     946,   947,   948,   948,   949,   949,   950,   950,   952,   951,
     953,   951,   954,   951,   955,   951,   951,   951,   956,   956,
     957,   958,   958,   959,   961,   960,   962,   963,   962,   964,
     964,   965,   965,   965,   966,   966,   967,   967,   968,   968,
     968,   969,   970,   971,   971,   971,   971,   971,   971,   971,
     971,   971,   971,   971,   971,   971,   971,   971,   971,   971,
     971,   971,   971,   971,   971,   971,   971,   971,   971,   971,
     971,   971,   971,   971,   971,   971,   971,   971,   972,   971,
     973,   971,   971,   971,   974,   974,   974,   974,   974,   974,
     974,   974,   975,   976,   976,   977,   977,   978,   978,   978,
     978,   978,   979,   979,   979,   979,   979,   980,   980,   980,
     981,   981,   981,   982,   983,   983,   984,   984,   985,   985,
     985,   986,   986,   986,   986,   987,   987,   988,   988,   989,
     989,   990,   990,   991,   991,   991,   991,   991,   991,   991,
     991,   991,   991,   991,   991,   991,   991,   991,   992,   993,
     993,   994,   994,   995,   995,   996,   996,   997,   997,   998,
     998,   999,   999,  1000,  1001,  1001,  1002,  1002,  1003,  1003,
    1004,  1004,  1004,  1005,  1005,  1005,  1006,  1006,  1006,  1006,
    1006,  1006,  1006,  1007,  1007,  1009,  1008,  1010,  1010,  1011,
    1012,  1012,  1012,  1012,  1013,  1014,  1015,  1015,  1016,  1017,
    1017,  1018,  1018,  1019,  1019,  1020,  1021,  1021,  1022,  1022,
    1023,  1023,  1023,  1023,  1024,  1024,  1024,  1024,  1024,  1025,
    1025,  1025,  1025,  1025,  1026,  1027,  1027,  1028,  1028,  1029,
    1029,  1030,  1030,  1030,  1031,  1031,  1032,  1033,  1034,  1035,
    1035,  1036,  1036,  1037,  1037,  1038,  1038,  1039,  1039,  1040,
    1040,  1041,  1041,  1042,  1042,  1043,  1043,  1043,  1043,  1043,
    1043,  1044,  1044,  1045,  1046,  1046,  1047,  1047,  1047,  1048,
    1048,  1049,  1049,  1050,  1050,  1051,  1052,  1052,  1053,  1053,
    1055,  1056,  1054,  1057,  1054,  1054,  1058,  1054,  1059,  1054,
    1060,  1054,  1061,  1054,  1062,  1054,  1054,  1054,  1054,  1054,
    1054,  1063,  1063,  1063,  1063,  1064,  1064,  1065,  1065,  1066,
    1066,  1067,  1067,  1067,  1067,  1067,  1067,  1067,  1067,  1067,
    1067,  1068,  1067,  1067,  1069,  1067,  1070,  1067,  1067,  1067,
    1067,  1067,  1071,  1072,  1072,  1074,  1073,  1075,  1075,  1075,
    1077,  1076,  1078,  1079,  1078,  1080,  1080,  1081,  1082,  1082,
    1083,  1084,  1084,  1084,  1085,  1084,  1086,  1087,  1084,  1084,
    1084,  1084,  1084,  1084,  1084,  1084,  1084,  1084,  1084,  1084,
    1084,  1084,  1084,  1084,  1088,  1088,  1088,  1088,  1088,  1089,
    1089,  1090,  1090,  1091,  1091,  1092,  1092,  1094,  1093,  1095,
    1095,  1096,  1096,  1097,  1097,  1098,  1098,  1098,  1099,  1099,
    1099,  1100,  1100,  1100,  1100,  1102,  1101,  1103,  1101,  1101,
    1101,  1104,  1105,  1105,  1106,  1106,  1107,  1107,  1107,  1109,
    1108,  1110,  1110,  1111,  1111,  1111,  1112,  1112,  1112,  1113,
    1113,  1115,  1114,  1116,  1116,  1116,  1118,  1117,  1119,  1119,
    1120,  1120,  1121,  1121,  1121,  1123,  1122,  1124,  1124,  1125,
    1126,  1126,  1127,  1127,  1128,  1129,  1128,  1130,  1131,  1130,
    1132,  1132,  1132,  1133,  1133,  1133,  1134,  1134,  1135,  1137,
    1136,  1138,  1138,  1139,  1139,  1140,  1140,  1140,  1140,  1140,
    1140,  1142,  1141,  1143,  1143,  1143,  1145,  1144,  1144,  1146,
    1146,  1147,  1147,  1148,  1150,  1149,  1151,  1151,  1152,  1152,
    1153,  1154,  1155,  1155,  1157,  1156,  1158,  1158,  1159,  1159,
    1160,  1161,  1163,  1162,  1165,  1164,  1166,  1166,  1167,  1167,
    1168,  1169,  1169,  1170,  1170,  1171,  1171,  1173,  1172,  1175,
    1176,  1174,  1177,  1177,  1177,  1177,  1177,  1178,  1178,  1179,
    1179,  1180,  1180,  1181,  1181,  1181,  1182,  1182,  1182,  1183,
    1183,  1183,  1184,  1184,  1185,  1186,  1187,  1187,  1187,  1187,
    1187,  1188,  1188,  1188,  1189,  1189,  1189,  1190,  1190,  1191,
    1191,  1191,  1191,  1191,  1191,  1191,  1191,  1191,  1191,  1191,
    1192,  1192,  1192,  1192,  1192,  1192,  1193,  1193,  1193,  1193,
    1193,  1193,  1193,  1193,  1193,  1193,  1193,  1193,  1193,  1193,
    1194,  1194,  1194,  1194,  1194,  1194,  1194,  1194,  1194,  1194,
    1194,  1194,  1194,  1194,  1194,  1195,  1195,  1196,  1196,  1197,
    1197,  1198,  1198,  1199,  1199,  1199,  1199,  1199,  1199,  1200,
    1200,  1201,  1201,  1202,  1202,  1202,  1202,  1202,  1202,  1202,
    1202,  1202,  1202,  1202,  1203,  1204,  1204,  1205,  1205,  1205,
    1205,  1205,  1205,  1205,  1205,  1205,  1205,  1205,  1205,  1205,
    1205,  1205,  1205,  1205,  1205,  1205,  1205,  1205,  1205,  1205,
    1205,  1205,  1205,  1205,  1205,  1205,  1205,  1206,  1206,  1206,
    1206,  1206,  1206,  1206,  1206,  1206,  1206,  1206,  1206,  1206,
    1206,  1206,  1206,  1206,  1206,  1206,  1206,  1206,  1206,  1206,
    1206,  1206,  1206,  1206,  1206,  1207,  1207,  1207,  1207,  1207,
    1207,  1207,  1207,  1207,  1207,  1207,  1207,  1207,  1207,  1207,
    1207,  1207,  1207,  1207,  1207,  1207,  1207,  1207,  1207,  1207,
    1207,  1207,  1208,  1208,  1208,  1208,  1208,  1208,  1208,  1208,
    1208,  1208,  1208,  1208,  1208,  1208,  1208,  1208,  1208,  1208,
    1208,  1208,  1208,  1208,  1208,  1208,  1209,  1209,  1209,  1209,
    1209,  1209,  1209,  1209,  1211,  1210,  1210,  1212,  1212,  1213,
    1213,  1214,  1214,  1215,  1215,  1216,  1216,  1217,  1218,  1218,
    1218,  1218,  1218,  1218,  1218,  1219,  1220,  1218,  1218,  1218,
    1218,  1218,  1218,  1218,  1218,  1218,  1218,  1218,  1221,  1218,
    1223,  1222,  1224,  1224,  1224,  1225,  1225,  1226,  1226,  1227,
    1228,  1227,  1229,  1229,  1231,  1230,  1232,  1232,  1232,  1232,
    1232,  1232,  1232,  1232,  1232,  1232,  1232,  1232,  1233,  1232,
    1234,  1234,  1235,  1235,  1236,  1236,  1237,  1237,  1238,  1238,
    1239,  1239,  1240,  1240,  1241,  1241,  1242,  1243,  1243,  1244,
    1244,  1245,  1246,  1245,  1247,  1245,  1245,  1248,  1245,  1249,
    1245,  1245,  1250,  1245,  1251,  1245,  1245,  1252,  1252,  1252,
    1253,  1253,  1254,  1254,  1255,  1257,  1256,  1256,  1256,  1258,
    1259,  1260,  1258,  1261,  1263,  1264,  1262,  1266,  1265,  1268,
    1269,  1267,  1270,  1271,  1272,  1272,  1273,  1273,  1273,  1273,
    1274,  1274,  1276,  1275,  1277,  1275,  1278,  1278,  1279,  1280,
    1279,  1282,  1281,  1283,  1283,  1284,  1284,  1285,  1285,  1286,
    1286,  1287,  1287,  1287,  1287,  1287,  1287,  1287,  1287,  1287,
    1287,  1287,  1287,  1288,  1288,  1288,  1288,  1288,  1288,  1288,
    1288,  1288,  1289,  1289,  1289,  1289,  1290,  1290,  1290,  1291,
    1291,  1292,  1292,  1293,  1294,  1293,  1295,  1296,  1295,  1297,
    1297,  1298,  1298,  1299,  1299,  1300,  1300,  1300,  1301,  1302,
    1302,  1303,  1304,  1304,  1306,  1305,  1307,  1307,  1308,  1308,
    1308,  1309,  1309,  1310,  1310,  1311,  1311,  1311,  1312,  1312,
    1312,  1313,  1313,  1313,  1313,  1313,  1314,  1315,  1315,  1315,
    1315,  1316,  1316,  1316,  1317,  1317,  1317,  1317,  1317,  1317,
    1318,  1318,  1318,  1318,  1318,  1319,  1319,  1319,  1319,  1319,
    1320,  1320,  1320,  1320,  1320,  1321,  1322,  1322,  1323,  1323,
    1324,  1325,  1324,  1326,  1326,  1327,  1327,  1328,  1330,  1329,
    1331,  1331,  1332,  1332,  1334,  1333,  1336,  1337,  1335,  1335,
    1335,  1339,  1338,  1341,  1340,  1342,  1340,  1340,  1340,  1340,
    1340,  1340,  1340,  1343,  1340,  1340,  1340,  1340,  1340,  1340,
    1344,  1344,  1345,  1346,  1347,  1347,  1348,  1349,  1349,  1350,
    1350,  1352,  1353,  1351,  1355,  1356,  1354,  1357,  1357,  1357,
    1357,  1358,  1358,  1359,  1359,  1360,  1361,  1361,  1361,  1362,
    1361,  1363,  1363,  1364,  1364,  1365,  1364,  1366,  1364,  1367,
    1367,  1368,  1368,  1369,  1370,  1370,  1371,  1371,  1373,  1372,
    1374,  1374,  1375,  1375,  1376,  1376,  1377,  1378,  1377,  1380,
    1381,  1379,  1382,  1382,  1383,  1384,  1384,  1385,  1386,  1386,
    1388,  1387,  1390,  1391,  1389,  1392,  1389,  1393,  1389,  1394,
    1394,  1395,  1395,  1396,  1396,  1397,  1397,  1398,  1398,  1399,
    1399,  1399,  1401,  1400,  1402,  1402,  1403,  1403,  1404,  1404,
    1405,  1405,  1405,  1405,  1405,  1405,  1405,  1405,  1405,  1406,
    1406,  1408,  1407,  1409,  1409,  1409,  1409,  1409,  1409,  1409,
    1409,  1409,  1409,  1409,  1409,  1409,  1409,  1410,  1409,  1411,
    1409,  1409,  1409,  1409,  1409,  1409,  1409,  1409,  1409,  1409,
    1409,  1409,  1409,  1409,  1409,  1409,  1409,  1409,  1409,  1409,
    1409,  1409,  1409,  1409,  1409,  1409,  1409,  1409,  1409,  1409,
    1409,  1409,  1409,  1409,  1409,  1409,  1409,  1409,  1409,  1412,
    1412,  1412,  1413,  1413,  1414,  1414,  1415,  1415,  1416,  1416,
    1417,  1417,  1418,  1418,  1419,  1419,  1420,  1420,  1420,  1422,
    1421,  1423,  1421,  1424,  1424,  1424,  1424,  1424,  1425,  1425,
    1426,  1426,  1426,  1427,  1427,  1427,  1429,  1428,  1431,  1430,
    1430,  1432,  1432,  1433,  1434,  1433,  1435,  1435,  1436,  1436,
    1436,  1436,  1436,  1436,  1436,  1436,  1436,  1436,  1436,  1436,
    1436,  1436,  1436,  1436,  1436,  1436,  1436,  1437,  1437,  1438,
    1438,  1440,  1439,  1441,  1441,  1443,  1442,  1442,  1442,  1444,
    1444,  1446,  1445,  1447,  1448,  1448,  1450,  1449,  1451,  1451,
    1451,  1452,  1452,  1452,  1452,  1453,  1453,  1454,  1455,  1457,
    1458,  1459,  1460,  1456,  1461,  1461,  1462,  1462,  1463,  1463,
    1463,  1464,  1464,  1464,  1465,  1465,  1466,  1466,  1467,  1467,
    1467,  1467,  1468,  1468,  1469,  1469,  1470,  1470,  1471,  1471,
    1472,  1472,  1473,  1473,  1474,  1474,  1474,  1475,  1475,  1476,
    1476,  1477,  1477,  1478,  1478,  1479,  1480,  1480,  1480,  1480,
    1481,  1481,  1482,  1482,  1482,  1483,  1484,  1484,  1484,  1485,
    1485,  1485,  1485,  1485,  1485,  1485,  1485,  1485,  1485,  1486,
    1486,  1486,  1486,  1486,  1487,  1487,  1487,  1488,  1488,  1489,
    1489,  1490,  1491,  1491,  1492,  1492,  1493,  1493,  1493,  1494,
    1494,  1494,  1494,  1495,  1495,  1495,  1496,  1496,  1497,  1498,
    1498,  1499,  1500,  1501,  1502,  1502,  1503,  1503,  1504,  1504,
    1504,  1505,  1505,  1505,  1506,  1506,  1507,  1508,  1508,  1508,
    1508,  1508,  1508,  1508,  1508,  1508,  1508,  1508,  1508,  1508,
    1508,  1508,  1508,  1508,  1508,  1508,  1508,  1508,  1508,  1508,
    1508,  1508,  1508,  1508,  1508,  1508,  1508,  1508,  1508,  1508,
    1508,  1508,  1508,  1508,  1508,  1508,  1508,  1508,  1508,  1508,
    1508,  1508,  1508,  1508,  1508,  1508,  1508,  1508,  1508,  1508,
    1508,  1508,  1508,  1508,  1508,  1508,  1508,  1509,  1509,  1509,
    1509,  1509,  1509,  1509,  1509,  1509,  1509,  1509,  1509,  1509,
    1509,  1509,  1509,  1509,  1509,  1509,  1509,  1509,  1509,  1509,
    1509,  1509,  1509,  1509,  1509,  1509,  1509,  1509,  1509,  1509,
    1509,  1509,  1509,  1509,  1509,  1509,  1509,  1509,  1509,  1509,
    1509,  1509,  1509,  1509,  1509,  1509,  1509,  1509,  1509,  1509,
    1509,  1509,  1509,  1509,  1509,  1509,  1509,  1509,  1509,  1509,
    1509,  1509,  1509,  1509,  1509,  1509,  1509,  1509,  1509,  1509,
    1509,  1509,  1509,  1509,  1509,  1509,  1509,  1509,  1509,  1509,
    1509,  1509,  1509,  1509,  1509,  1509,  1509,  1509,  1509,  1509,
    1509,  1509,  1509,  1509,  1509,  1509,  1509,  1509,  1509,  1509,
    1509,  1509,  1509,  1509,  1509,  1509,  1509,  1509,  1509,  1509,
    1509,  1509,  1509,  1509,  1509,  1509,  1509,  1509,  1509,  1509,
    1509,  1509,  1509,  1509,  1509,  1509,  1509,  1509,  1509,  1509,
    1509,  1509,  1509,  1509,  1509,  1509,  1509,  1509,  1509,  1509,
    1509,  1509,  1509,  1509,  1509,  1509,  1509,  1509,  1509,  1509,
    1509,  1509,  1509,  1509,  1509,  1509,  1509,  1509,  1509,  1509,
    1509,  1509,  1509,  1509,  1509,  1509,  1509,  1509,  1509,  1509,
    1509,  1509,  1509,  1509,  1509,  1509,  1509,  1509,  1509,  1509,
    1509,  1509,  1509,  1509,  1509,  1509,  1509,  1509,  1509,  1509,
    1509,  1509,  1509,  1509,  1509,  1509,  1509,  1509,  1509,  1509,
    1509,  1509,  1509,  1509,  1509,  1509,  1509,  1509,  1509,  1509,
    1509,  1509,  1509,  1509,  1509,  1509,  1509,  1509,  1509,  1509,
    1509,  1509,  1509,  1509,  1509,  1509,  1509,  1509,  1509,  1509,
    1509,  1509,  1509,  1509,  1509,  1509,  1509,  1509,  1509,  1509,
    1509,  1509,  1509,  1509,  1509,  1509,  1509,  1509,  1509,  1509,
    1509,  1509,  1509,  1509,  1509,  1509,  1509,  1509,  1509,  1509,
    1509,  1509,  1509,  1509,  1509,  1509,  1509,  1509,  1509,  1509,
    1509,  1509,  1509,  1509,  1509,  1509,  1509,  1509,  1509,  1509,
    1509,  1509,  1509,  1509,  1509,  1509,  1509,  1509,  1509,  1509,
    1509,  1509,  1509,  1509,  1509,  1509,  1509,  1509,  1509,  1509,
    1509,  1509,  1509,  1509,  1509,  1509,  1509,  1511,  1510,  1513,
    1512,  1514,  1512,  1515,  1512,  1517,  1516,  1516,  1518,  1518,
    1520,  1519,  1521,  1519,  1523,  1522,  1522,  1524,  1524,  1524,
    1525,  1525,  1525,  1525,  1526,  1526,  1526,  1526,  1527,  1528,
    1528,  1528,  1528,  1528,  1528,  1528,  1528,  1528,  1529,  1529,
    1529,  1530,  1530,  1530,  1530,  1531,  1532,  1533,  1533,  1534,
    1534,  1534,  1534,  1535,  1535,  1535,  1536,  1536,  1536,  1536,
    1536,  1538,  1537,  1539,  1539,  1540,  1540,  1541,  1542,  1542,
    1542,  1542,  1542,  1544,  1543,  1545,  1545,  1546,  1545,  1547,
    1547,  1548,  1548,  1549,  1549,  1549,  1549,  1550,  1549,  1551,
    1551,  1551,  1551,  1551,  1552,  1553,  1553,  1553,  1553,  1553,
    1553,  1554,  1554,  1555,  1556,  1556,  1556,  1556,  1556,  1557,
    1557,  1558,  1558,  1559,  1559,  1560,  1561,  1561,  1562,  1562,
    1563,  1563,  1564,  1564,  1565,  1565,  1567,  1566,  1568,  1566,
    1569,  1566,  1570,  1566,  1566,  1566,  1566,  1566,  1566,  1566,
    1566,  1566,  1566,  1566,  1566,  1566,  1566,  1566,  1566,  1566,
    1566,  1566,  1566,  1566,  1566,  1566,  1566,  1566,  1566,  1566,
    1571,  1571,  1572,  1572,  1573,  1573,  1573,  1574,  1574,  1574,
    1574,  1575,  1575,  1576,  1576,  1577,  1577,  1578,  1578,  1579,
    1579,  1580,  1580,  1580,  1580,  1580,  1581,  1581,  1582,  1582,
    1583,  1584,  1584,  1584,  1584,  1584,  1585,  1585,  1586,  1586,
    1587,  1587,  1588,  1588,  1588,  1588,  1588,  1590,  1589,  1591,
    1591,  1592,  1592,  1592,  1593,  1593,  1593,  1594,  1594,  1595,
    1596,  1596,  1597,  1598,  1599,  1599,  1601,  1600,  1602,  1602,
    1602,  1603,  1603,  1605,  1604,  1606,  1606,  1607,  1607,  1607,
    1608,  1608,  1609,  1610,  1609,  1611,  1612,  1613,  1614,  1614,
    1615,  1615,  1616,  1616,  1616,  1616,  1616,  1616,  1616,  1616,
    1617,  1617,  1617,  1618,  1618,  1618,  1618,  1618,  1619,  1619,
    1619,  1619,  1619,  1619,  1620,  1620,  1621,  1622,  1623,  1623,
    1623,  1624,  1624,  1624,  1626,  1625,  1627,  1627,  1628,  1628,
    1630,  1629,  1631,  1631,  1632,  1632,  1632,  1632,  1634,  1635,
    1636,  1633,  1637,  1637,  1639,  1640,  1641,  1642,  1643,  1638,
    1645,  1646,  1647,  1648,  1644,  1649,  1649,  1649,  1649,  1649,
    1649,  1650,  1650,  1650,  1651,  1651,  1652,  1652,  1652,  1653,
    1653,  1654,  1655,  1654,  1656,  1656,  1657,  1657,  1658,  1658,
    1659
};

/* YYR2[YYN] -- Number of symbols composing right hand side of rule YYN.  */
static const yytype_uint8 yyr2[] =
{
       0,     2,     1,     0,     4,     2,     0,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     3,     1,     1,     4,     1,
       2,     0,     4,     0,     2,     3,     1,     2,     0,     3,
       0,     6,     1,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     5,
       1,     0,     1,     3,     1,     3,     3,     3,     3,     3,
       3,     3,     0,     1,     1,     0,     7,     0,     0,    15,
       0,     0,    15,     0,     0,    15,     0,     6,     0,     3,
       4,     5,     4,     3,     2,    10,     1,     3,     2,     2,
       2,     2,     2,     2,     2,     0,    13,     0,     6,     2,
       0,     1,     3,     1,     0,     2,     0,     2,     0,     1,
       3,     4,     0,     2,     0,     2,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     0,
       3,     1,     0,     2,     0,     2,     2,     2,     2,     2,
       3,     3,     1,     1,     1,     2,     3,     3,     0,     4,
       0,     3,     0,     1,     3,     1,     0,     1,     3,     1,
       0,     3,     0,     1,     3,     1,     4,     0,     1,     1,
       1,     0,     3,     2,     3,     0,     3,     0,     5,     5,
       0,     7,     5,     0,     2,     1,     1,     1,     3,     1,
       1,     1,     3,     0,     1,     1,     1,     1,     2,     1,
       3,     1,     1,     0,     1,     0,     2,     3,     5,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     3,     4,     0,     1,     1,     3,
       1,     3,     3,     1,     2,     1,     1,     1,     1,     3,
       3,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     3,     0,     2,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     0,     5,     0,     2,     0,     3,     0,     2,     2,
       2,     2,     0,     6,     2,     0,     2,     1,     1,     3,
       0,     0,     0,     7,     0,     2,     2,     1,     1,     0,
       0,     8,     0,     6,     1,     2,     1,     2,     0,     0,
       6,     0,     0,     6,     0,     2,     0,     5,     0,     1,
       0,     5,     0,     2,     0,     5,     4,     0,     0,     8,
       0,     7,     1,     1,     1,     1,     1,     2,     4,     5,
       0,     4,     4,     4,     3,     3,     2,     2,     0,     2,
       1,     2,     3,     1,     1,     1,     1,     1,     2,     3,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       2,     3,     1,     1,     1,     1,     1,     1,     1,     2,
       3,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       2,     3,     1,     1,     1,     2,     2,     2,     1,     1,
       1,     1,     2,     3,     3,     3,     3,     3,     3,     3,
       3,     4,     0,     1,     1,     1,     1,     1,     0,     7,
       3,     0,     5,     1,     2,     4,     0,     0,     5,     0,
       7,     1,     0,     1,     0,     4,     0,     0,     3,     5,
       6,     0,     4,     2,     2,     2,     2,     0,     1,     0,
       3,     0,     1,     1,     3,     1,     4,     5,     5,     0,
       2,     0,     0,     7,     0,    10,     1,     3,     1,     1,
       0,     2,     0,     3,     1,     3,     0,     6,     1,     0,
       0,     5,     0,     4,     1,     1,     1,     3,     1,     3,
       0,     0,     5,     1,     3,     1,     1,     0,     3,     1,
       3,     0,     4,     1,     0,     1,     2,     1,     3,     4,
       3,     3,     3,     3,     4,     4,     3,     0,     0,     6,
       0,     1,     0,     1,     1,     2,     1,     1,     0,     1,
       1,     2,     1,     0,     3,     1,     3,     0,     1,     1,
       2,     1,     2,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     0,     6,     1,     1,     3,     4,
       4,     2,     2,     2,     3,     3,     3,     3,     3,     3,
       3,     4,     4,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     2,     1,     1,     1,
       1,     1,     1,     3,     1,     1,     2,     2,     0,     8,
       0,     9,     0,     9,     0,     9,     8,     2,     0,     1,
       4,     0,     1,     2,     0,     3,     2,     0,     9,     0,
       2,     0,     1,     1,     0,     1,     2,     1,     1,     2,
       2,     4,     3,     3,     3,     3,     1,     2,     1,     1,
       3,     2,     3,     2,     2,     1,     3,     3,     2,     3,
       1,     2,     2,     2,     1,     2,     1,     1,     1,     2,
       3,     2,     3,     2,     2,     3,     3,     3,     0,     6,
       0,     6,     2,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     2,     2,     1,     2,     1,     2,
       3,     2,     1,     1,     1,     1,     1,     1,     1,     2,
       0,     1,     1,     5,     0,     1,     2,     1,     1,     1,
       1,     3,     3,     3,     3,     0,     1,     0,     1,     0,
       1,     2,     1,     1,     2,     2,     4,     1,     3,     2,
       1,     2,     2,     2,     3,     3,     3,     3,     2,     2,
       1,     2,     1,     1,     1,     1,     1,     0,     2,     1,
       1,     1,     1,     1,     0,     2,     1,     1,     0,     1,
       1,     2,     2,     1,     2,     2,     0,     1,     1,     1,
       3,     1,     3,     0,     1,     0,     4,     1,     1,     1,
       0,     1,     2,     1,     1,     2,     1,     3,     3,     1,
       1,     0,     2,     0,     1,     5,     0,     3,     3,     1,
       0,     2,     2,     2,     0,     3,     3,     6,     6,     1,
       1,     2,     2,     2,     1,     2,     2,     1,     1,     0,
       1,     1,     1,     1,     0,     1,     1,     1,     0,     1,
       2,     0,     1,     0,     1,     0,     1,     1,     2,     1,
       2,     1,     2,     2,     2,     3,     2,     3,     3,     3,
       3,     1,     1,     1,     1,     3,     1,     1,     1,     4,
       2,     1,     4,     0,     1,     2,     0,     2,     1,     3,
       0,     0,     7,     0,     5,     7,     0,     5,     0,     5,
       0,     5,     0,     4,     0,    10,     3,     4,     3,     3,
       7,     0,     3,     1,     4,     0,     3,     0,     2,     0,
       1,     0,     2,     2,     2,     2,     1,     1,     1,     4,
       4,     0,     6,     4,     0,     5,     0,     6,     4,     3,
       1,     7,     2,     1,     1,     0,     6,     0,     3,     2,
       0,     5,     0,     0,     6,     1,     3,     1,     1,     3,
       3,     3,     2,     4,     0,     7,     0,     0,     8,     5,
       5,     3,     4,     2,     2,     6,     5,     3,     5,     1,
       1,     1,     1,     1,     0,     1,     1,     2,     2,     3,
       3,     3,     3,     0,     1,     0,     1,     0,     2,     0,
       1,     2,     1,     1,     1,     0,     1,     1,     0,     2,
       1,     0,     1,     1,     1,     0,     6,     0,     5,     4,
       4,     3,     0,     1,     1,     3,     3,     2,     2,     0,
       2,     1,     3,     0,     1,     1,     0,     2,     4,     1,
       3,     0,     5,     0,     1,     1,     0,     6,     0,     1,
       1,     2,     1,     1,     1,     0,     5,     1,     3,     2,
       0,     3,     1,     4,     1,     0,     4,     1,     0,     4,
       0,     1,     3,     0,     1,     3,     1,     1,     2,     0,
       5,     0,     1,     1,     2,     1,     1,     1,     1,     1,
       2,     0,     5,     0,     1,     1,     0,     4,     4,     3,
       5,     1,     3,     3,     0,     6,     1,     1,     1,     3,
       2,     3,     1,     1,     0,     6,     1,     1,     1,     3,
       3,     4,     0,     6,     0,     2,     0,     4,     0,     2,
       1,     2,     4,     2,     3,     2,     3,     0,     3,     0,
       0,     6,     2,     1,     1,     2,     2,     8,     4,     0,
       1,     2,     1,     1,     1,     1,     0,     2,     4,     3,
       1,     1,     3,     4,     0,     0,     0,     2,     2,     1,
       1,     0,     2,     3,     0,     2,     3,     0,     2,     3,
       3,     3,     2,     3,     4,     3,     4,     3,     4,     1,
       3,     4,     3,     3,     6,     1,     5,     6,     5,     7,
       6,     8,     5,     6,     4,     4,     5,     3,     4,     1,
       3,     3,     3,     3,     3,     3,     5,     5,     3,     3,
       3,     3,     3,     3,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     0,     2,     1,     2,     1,     1,     1,     2,     2,
       1,     1,     2,     2,     4,     1,     3,     1,     1,     1,
       1,     1,     3,     1,     1,     1,     1,     3,     2,     2,
       2,     2,     3,     3,     5,     6,     4,     4,     7,     2,
       6,     5,     6,     6,     4,     4,     5,     4,     6,     2,
       2,     4,     4,     4,    10,     6,     8,     6,     4,     4,
       6,     4,     4,     4,     6,     4,     7,     7,     7,     6,
       6,     6,     6,     3,     4,     6,     8,     2,     2,     8,
       8,     6,     6,     2,     6,     6,     8,     8,     6,     8,
       6,     2,     8,     8,     2,     2,     2,     6,     6,     4,
       4,     8,     4,     4,     4,     4,     3,     8,     4,     4,
       6,     4,     4,     4,     6,     8,     4,     3,     6,     4,
       6,     5,     8,     7,    10,     1,     6,     4,     4,     4,
       4,     4,     6,     4,     0,     5,     6,     2,     3,     0,
       4,     0,     3,     0,     1,     1,     3,     4,     4,     5,
       4,     4,     4,     5,     4,     0,     0,     7,     4,     5,
       4,     5,     4,     4,     4,     4,     4,     5,     0,     8,
       0,     3,     3,     1,     4,     0,     1,     0,     2,     0,
       0,     4,     4,     2,     0,     3,     2,     3,     2,     1,
       1,     2,     1,     2,     1,     2,     2,     2,     0,     3,
       0,     1,     1,     3,     1,     3,     1,     3,     0,     1,
       0,     2,     4,     5,     1,     1,     1,     1,     4,     1,
       3,     3,     0,     6,     0,     8,     4,     0,     8,     0,
      10,     6,     0,     8,     0,    10,     6,     1,     2,     1,
       1,     2,     0,     1,     5,     0,     5,     3,     5,     2,
       0,     0,     7,     1,     0,     0,     6,     0,     3,     0,
       0,     5,     0,     1,     0,     1,     0,     2,     3,     3,
       1,     1,     0,     7,     0,     7,     1,     2,     0,     0,
       2,     0,     2,     0,     1,     1,     1,     1,     3,     1,
       3,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     0,     1,     1,     0,
       2,     0,     1,     0,     0,     3,     0,     0,     3,     2,
       0,     0,     4,     4,     2,     0,     1,     1,     3,     3,
       1,     2,     0,     1,     0,     4,     4,     2,     0,     1,
       1,     0,     1,     0,     1,     2,     5,     4,     1,     3,
       3,     1,     1,     1,     1,     1,     1,     0,     2,     3,
       4,     1,     2,     2,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       0,     0,     6,     0,     1,     3,     1,     3,     0,     2,
       3,     1,     2,     1,     0,     3,     0,     0,     7,     2,
       1,     0,     3,     0,     7,     0,     7,     4,     6,     4,
       4,     4,     4,     0,     6,     4,     4,     5,     6,     4,
       1,     3,     1,     2,     1,     3,     1,     0,     2,     0,
       1,     0,     0,     8,     0,     0,     6,     0,     1,     1,
       1,     1,     1,     2,     1,     1,     1,     3,     4,     0,
       3,     3,     1,     2,     2,     0,     3,     0,     5,     3,
       1,     3,     1,     3,     1,     1,     0,     1,     0,     4,
       0,     1,     3,     1,     1,     1,     0,     0,     6,     0,
       0,    11,     3,     1,     3,     3,     1,     3,     0,     1,
       0,     4,     0,     0,     9,     0,     5,     0,     6,     0,
       2,     1,     3,     2,     4,     0,     2,     0,     2,     1,
       1,     1,     0,     4,     0,     1,     0,     1,     1,     3,
       1,     1,     2,     2,     2,     1,     1,     1,     1,     0,
       3,     0,     3,     2,     4,     4,     3,     4,     4,     1,
       3,     3,     3,     3,     6,     2,     2,     0,     6,     0,
       7,     5,     2,     1,     1,     1,     5,     5,     2,     2,
       1,     4,     3,     2,     3,     2,     2,     1,     3,     4,
       3,     3,     2,     3,     2,     3,     1,     1,     1,     1,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     1,
       1,     1,     1,     1,     0,     1,     0,     2,     0,     1,
       1,     1,     0,     2,     0,     2,     0,     2,     2,     0,
       4,     0,     4,     1,     1,     1,     1,     1,     1,     1,
       0,     1,     1,     0,     1,     1,     0,     4,     0,     4,
       1,     0,     1,     4,     0,     3,     3,     1,     2,     2,
       2,     2,     2,     3,     2,     1,     1,     1,     1,     2,
       1,     1,     1,     1,     1,     1,     1,     0,     1,     0,
       3,     0,     3,     3,     1,     0,     4,     1,     2,     0,
       1,     0,     3,     3,     2,     2,     0,     5,     0,     1,
       1,     0,     1,     1,     2,     1,     2,     1,     2,     0,
       0,     0,     0,    22,     1,     1,     0,     1,     0,     1,
       1,     0,     1,     1,     0,     2,     2,     1,     3,     4,
       3,     3,     0,     2,     2,     1,     3,     3,     0,     4,
       0,     3,     1,     1,     0,     3,     2,     3,     1,     1,
       2,     0,     2,     3,     1,     5,     1,     1,     2,     2,
       1,     1,     1,     1,     1,     1,     1,     2,     2,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     2,     1,
       1,     1,     1,     1,     2,     2,     2,     1,     1,     3,
       5,     1,     1,     1,     1,     1,     3,     4,     5,     1,
       5,     3,     2,     1,     3,     2,     2,     4,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     3,     2,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     0,     3,     0,
       3,     0,     3,     0,     3,     0,     3,     2,     0,     2,
       0,     2,     0,     4,     0,     3,     1,     1,     1,     1,
       0,     1,     1,     1,     0,     2,     2,     2,     3,     3,
       4,     6,     2,     3,     3,     2,     3,     5,     1,     3,
       3,     1,     1,     3,     3,     1,     3,     2,     2,     2,
       2,     2,     1,     1,     4,     4,     1,     1,     1,     1,
       1,     0,     4,     1,     1,     1,     3,     3,     1,     1,
       2,     2,     2,     0,     3,     4,     3,     0,     7,     1,
       2,     1,     1,     1,     1,     1,     1,     0,     5,     1,
       1,     1,     1,     1,     3,     6,     6,     6,     7,     5,
       3,     4,     1,     3,     8,     8,     8,     6,     4,     0,
       3,     0,     3,     1,     3,     2,     1,     1,     0,     1,
       1,     2,     0,     1,     1,     3,     0,     3,     0,     3,
       0,     3,     0,     3,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     2,     2,     1,     3,     2,
       2,     2,     2,     2,     2,     2,     2,     1,     1,     2,
       0,     1,     3,     1,     2,     2,     2,     1,     3,     3,
       1,     1,     3,     1,     3,     1,     3,     1,     1,     1,
       1,     4,     5,     4,     6,     1,     0,     3,     3,     1,
       1,     0,     2,     2,     2,     2,     0,     2,     0,     3,
       2,     1,     2,     2,     2,     2,     2,     0,     3,     0,
       1,     0,     3,     2,     0,     1,     2,     0,     1,     4,
       4,     5,     2,     3,     0,     1,     0,     4,     0,     1,
       1,     0,     1,     0,     2,     2,     1,     0,     1,     1,
       2,     3,     2,     0,     6,     3,     0,     0,     0,     1,
       2,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       2,     2,     3,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     0,     3,     3,     3,
       3,     0,     3,     3,     0,     7,     0,     3,     1,     3,
       0,     3,     2,     4,     0,     3,     4,     4,     0,     0,
       0,    16,     8,     7,     0,     0,     0,     0,     0,    15,
       0,     0,     0,     0,    12,     4,     4,     3,     4,     3,
       2,     1,     3,     5,     1,     1,     0,     1,     1,     0,
       2,     0,     0,     3,     0,     2,     5,     3,     3,     3,
       1
};

/* YYDEFACT[STATE-NAME] -- Default rule to reduce with in state
   STATE-NUM when YYTABLE doesn't specify something else to do.  Zero
   means the default is an error.  */
static const yytype_uint16 yydefact[] =
{
       0,   930,  1133,  2687,     0,     0,     0,     0,     0,     0,
    2689,   585,    66,  1790,  1918,  1919,  1701,  1729,     2,     0,
    1133,   276,   179,     0,    78,  1731,     0,  1976,     0,     0,
    1133,     0,   487,     0,  1971,     0,     0,  1133,  1734,  1961,
     253,   179,  2689,     0,  1179,  2477,  1831,  1987,     0,     0,
       0,  1814,     0,  2553,  1779,     0,     0,  2820,     0,     0,
       3,     8,    19,     0,    41,    24,    29,    14,    18,    13,
      54,    48,    26,    39,   128,    38,    10,    57,    58,    16,
      45,    11,    12,    15,    37,    44,    33,    40,    52,  1170,
      22,    23,    30,    46,    62,    20,    59,    55,    21,  1920,
      25,    47,    42,    34,    56,    63,    35,    53,    36,    61,
      28,    49,    27,     9,    17,    50,    51,    43,    64,    31,
      60,    32,     0,   959,     0,     0,     0,     0,     0,     0,
    1037,   942,  2754,  2755,  2756,  1135,  1134,     0,  2689,  2091,
    1118,  1144,  2167,  2169,  2168,  2170,  2171,  2172,  2173,  2174,
    2175,  2108,  2176,  2177,  2179,  2178,  2180,  2181,  2182,  2109,
    2110,  2183,  2184,  2185,  2187,  2186,  2188,  2111,  2112,  2189,
    2190,  2191,  2192,  2113,  2115,  2114,  2193,  2196,  2195,  2194,
    2116,  2197,  2198,  2199,  2201,  2117,  2118,  2119,  2120,  2121,
    2200,  2122,  2202,  2123,  2203,  2204,  2205,  2206,  2207,  2208,
    2209,  2211,  2210,  2124,  2212,  2213,  2215,  2216,  2217,  2214,
    2218,  2220,  2219,  2221,  2222,  2223,  2125,  2224,  2225,  2226,
    2227,  2228,  2229,  2230,  2231,  2126,  2232,  2233,  2234,  2253,
    2127,  2235,  2238,  2237,  2236,  2239,  2240,  2241,  2243,  2242,
    2244,  2245,  2128,  2129,  2246,  2247,  2248,  2249,  2251,  2250,
    2255,  2256,  2257,  2130,  2252,  2254,  2454,  2258,  2259,  2261,
    2260,  2262,  2131,  2264,  2263,  2132,  2266,  2265,  2133,  2134,
    2267,  2268,  2269,  2089,  2270,  2090,  2271,  2274,  2275,  2272,
    2276,  2281,  2135,  2273,  2277,  2278,  2279,  2280,  2282,  2136,
    2284,  2283,  2285,  2286,  2287,  2288,  2289,  2290,  2291,  2292,
    2293,  2306,  2297,  2298,  2300,  2301,  2304,  2299,  2305,  2309,
    2308,  2310,  2311,  2312,  2313,  2314,  2307,  2295,  2302,  2303,
    2296,  2315,  2316,  2294,  2317,  2318,  2319,  2320,  2321,  2322,
    2323,  2324,  2325,  2326,  2327,  2329,  2328,  2330,  2331,  2332,
    2333,  2334,  2335,  2337,  2336,  2338,  2339,  2340,  2342,  2341,
    2344,  2345,  2137,  2343,  2346,  2347,  2348,  2349,  2350,  2352,
    2351,  2138,  2140,  2139,  2141,  2353,  2354,  2142,  2355,  2357,
    2356,  2358,  2359,  2360,  2362,  2361,  2363,  2364,  2143,  2144,
    2365,  2366,  2367,  2368,  2369,  2370,  2371,  2372,  2373,  2374,
    2375,  2376,  2377,  2378,  2380,  2379,  2381,  2382,  2383,  2384,
    2385,  2386,  2387,  2145,  2388,  2146,  2389,  2390,  2147,  2391,
    2148,  2392,  2393,  2394,  2395,  2396,  2149,  2397,  2398,  2399,
    2401,  2402,  2400,  2403,  2150,  2404,  2405,  2406,  2151,  2408,
    2407,  2409,  2152,  2411,  2153,  2154,  2410,  2156,  2157,  2412,
    2413,  2414,  2155,  2415,  2158,  2416,  2417,  2419,  2418,  2420,
    2421,  2422,  2159,  2423,  2160,  2424,  2425,  2426,  2427,  2428,
    2430,  2429,  2431,  2432,  2433,  2434,  2437,  2439,  2436,  2438,
    2435,  2440,  2441,  2442,  2443,  2447,  2448,  2449,  2450,  2444,
    2445,  2446,  2161,  2451,  2452,  2453,  2455,  2456,  2458,  2457,
    2162,  2163,  2459,  2460,  2166,  2461,  2462,  2463,  2467,  2464,
    2476,  2465,  2466,  2469,  2468,  2470,  2471,  2472,  2164,  2473,
    2165,  2474,  2475,   198,  2094,   181,  2095,  2107,   112,  2544,
    2543,  1081,  1119,  2690,  2691,   583,   886,     0,     0,   179,
       0,   887,     0,   885,   179,   134,     0,     0,     0,  1807,
       0,  1727,  1727,  1727,  1727,     0,  1727,   179,  1727,     0,
    1730,  1727,   179,  1727,     0,    71,  1926,   277,     0,     0,
       0,     0,     0,  2088,     0,  1737,     0,     0,  1978,  1994,
       0,  1995,  1989,  2541,     0,  1204,     0,     0,     0,     0,
     179,  1136,     0,  1788,     0,   243,   252,   254,   255,   251,
       0,  2691,  2702,  1171,  1177,  1189,     0,  1898,   255,     0,
     112,  1062,     0,   112,  1815,  1812,     0,     0,     0,  1788,
    1988,  2804,     0,     0,     0,  2800,     0,  2805,     0,  1179,
       0,     0,     1,     5,     0,     0,   582,  2756,     0,   579,
     580,  2248,  2357,  1911,  1909,  2083,     0,   933,   960,     0,
     938,     0,   936,  2100,  2099,  2098,     0,   949,   948,   946,
       0,   448,     0,  1039,     0,  2761,   940,  1095,  2688,     0,
     200,     0,     0,   113,   114,     0,     0,     0,  2694,     0,
       0,     0,   586,     0,     0,   133,     0,     0,   583,   583,
     583,  1811,  1810,  1809,     0,  1807,  2168,  2108,  2182,     0,
    2057,     0,     0,     0,  1488,     0,  2113,     0,  2197,  2199,
    2117,  2118,  2119,  2120,  2121,  2124,     0,     0,  1217,  1217,
    1217,  1214,     0,     0,     0,  2222,  2223,  2062,     0,     0,
       0,  2053,  2063,  2261,  2262,     0,  2055,  2056,  2268,     0,
       0,     0,  2283,     0,  2288,  2060,     0,     0,  2324,  2326,
       0,     0,  2330,  2331,  2332,  2333,  2037,  1272,     0,  1214,
    2052,  2059,  2349,  2045,  2358,  2363,  2364,     0,  2373,     0,
       0,  2395,     0,  2402,  2400,  2406,     0,     0,  2427,     0,
       0,  1214,  2036,  2447,  2448,  2449,  2450,     0,  2054,  2161,
    2061,     0,  2461,  1217,  1214,  1214,     0,     0,     0,  2470,
    2471,  2475,     0,     0,     0,  2726,  1271,     0,  1450,     0,
    1482,  1229,  1235,  1249,     0,  1264,  1298,  1299,  1301,  1405,
    1300,  1306,  1305,  1702,  2049,  1304,  1303,  2050,  2051,  1297,
    2073,  2094,  2072,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1894,     0,     0,  1713,  1727,    73,     0,     0,
    2602,  2617,  2618,  1217,  2614,  2619,  2242,  2129,  2255,     0,
    2616,  2608,     0,  2368,  2372,  2612,  2387,  2390,  2606,     0,
    2153,  2431,  2638,  2610,  2615,  2596,  2583,  2597,     0,     0,
    2600,  2604,  2085,  1596,  2556,  2557,     0,    79,  1739,  1740,
    1738,  1035,     0,  2817,  1979,  1980,  1981,     0,  1998,     0,
    1131,     0,     0,   497,   488,     0,  1893,  1892,     0,  1972,
    2703,     0,     0,  1086,  1742,  1789,     0,  1741,  1967,     0,
    1965,  1962,  1964,   244,     0,     0,   274,  2169,  2602,  2372,
    2574,     0,  2582,     0,  2697,  2694,  2704,  2739,  2734,  2733,
    2736,  2737,  1195,  2738,  1194,  2735,  2732,  1204,  1190,  1192,
    1193,   802,     0,     0,  2497,  2498,  2337,  2358,  2396,  2499,
    2444,     0,     0,  2518,  2478,  2483,  2479,     0,     0,  1853,
       0,   802,  1876,  1906,  1854,     0,     0,  1906,     0,  1631,
    1896,  1899,     0,  2501,  1867,   883,   882,  1879,   881,  2502,
    1892,     0,  1839,  1855,     0,  1816,  1860,   112,  2503,     0,
    1895,  1878,     0,  1877,  1631,  1906,     0,  1832,     0,     0,
       0,     0,     0,   250,  1069,  1069,     0,     0,  1061,  1063,
    1064,  1069,  1069,     0,  2818,  2819,  2554,  1035,  2044,  2042,
    2043,  2092,  2801,  2041,  2040,  2809,  2811,  2797,  2799,  2806,
    1173,     0,  2708,     6,    65,   129,  1204,  1204,  2756,   583,
     581,     0,  1923,  2759,  2760,  2758,   818,     0,  1217,  2101,
    2104,  2757,  2105,   182,   947,     0,   449,   182,     0,     0,
       0,     0,     0,   450,   451,   387,     0,  1043,  1044,  1038,
    1040,  1042,   944,     0,     0,   943,  2761,     0,     0,  1146,
    1148,  1147,  1164,   202,   199,   180,    80,  1083,  1720,  1722,
    1121,  2693,     0,     0,  2695,  2699,  1270,  1269,     0,   126,
     132,     0,  2589,  2593,     0,     0,  2104,  2665,     0,   130,
    2653,     0,     0,     0,     0,  1791,  1795,  1801,  1805,  1808,
       0,     0,  1601,  1319,  1601,  1601,  1601,  1489,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1601,     0,  1357,  1329,  1330,     0,  1358,     0,     0,
       0,  2064,     0,     0,     0,  2726,     0,     0,     0,  1455,
       0,     0,     0,  2726,     0,     0,     0,     0,     0,     0,
    1484,  1486,  2072,  1601,     0,     0,  1601,     0,     0,     0,
       0,     0,  1222,  1363,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1601,  1601,     0,
       0,  1601,  1371,  2066,     0,     0,     0,  2065,     0,     0,
       0,  2038,  2058,     0,  1374,  1376,  1375,     0,  1601,  1601,
       0,     0,     0,  1309,  1308,  1310,     0,     0,     0,     0,
       0,     0,  1268,  1267,  1266,  1265,     0,     0,     0,  1273,
       0,  1274,  1275,     0,  1276,  1277,  1278,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1311,     0,     0,     0,
    2039,  1414,     0,  1728,  1707,  1715,  1709,     0,  1894,  1710,
    1712,  1719,   462,     0,  1716,  2106,  2651,  1711,     0,  1703,
       0,    72,     0,  1950,  1955,     0,     0,     0,  1945,  1953,
    1947,  1954,  1946,     0,     0,  1956,   112,     0,  1948,  1952,
    1951,  1927,  1930,  1937,  1928,     0,     0,   275,   278,   280,
       0,   283,  2603,  2601,  2635,  2634,  2639,     0,  2636,  2632,
    2595,  2625,  2666,  2629,     0,  2666,  2631,  2630,  2666,  2626,
    2633,  2666,     0,  2598,     0,  1597,  1598,     0,  2555,     0,
    2084,  1036,     0,     0,  1982,  1983,     0,  1154,  1999,  2000,
    1996,  1596,  2542,  2545,     0,   691,  1205,   498,     0,     0,
     509,     0,     0,    68,    69,     0,  1138,     0,  1137,  1141,
       0,     0,     0,  1745,  1735,  1744,  1522,  1968,   112,     0,
     242,   267,   262,   270,   264,   266,   265,   271,   272,   273,
     268,   263,   269,   256,     0,     0,  2601,     0,     0,  2598,
    2698,     0,  2700,  2717,  1178,  2705,  1201,  1180,  1200,     0,
    1191,   801,     0,   804,   806,  1764,  1765,   805,   814,     0,
     803,     0,     0,  2515,     0,  2504,     0,   810,   812,   811,
    2512,   809,     0,     0,  2488,     0,     0,  1902,     0,     0,
    1866,     0,   583,     0,     0,     0,     0,     0,     0,  1833,
       0,     0,   634,     0,  1859,  1632,  1900,  1901,  1906,     0,
       0,  1906,     0,  1872,  1896,  1906,     0,  1906,  1828,     0,
       0,  1820,  1825,  1821,     0,  1827,  1826,  1829,  1817,  1818,
       0,  1846,  1874,     0,  1896,  1858,  1865,     0,  1845,  1852,
       0,  1863,  1896,  1896,     0,  1906,  1906,  1057,  1073,  1055,
    1067,  1068,     0,     0,  1060,  1059,  1813,  1525,     0,     0,
    2798,  2812,  2796,  2807,  2808,  2795,  1174,  2709,  1172,  2710,
       0,     7,     4,  1204,  1204,  1204,  2753,     0,  2741,  2748,
    2749,  2752,  2751,  2750,  2747,     0,  2740,  2743,  2744,  2746,
    2745,  2761,     0,  1913,  1914,  1915,  1916,  1917,  1912,  1910,
    1924,  1925,   819,   818,   574,   577,   576,     0,     0,  2103,
       0,   939,     0,  1894,   937,     0,     0,  1894,   398,  1894,
     452,   931,  1041,   951,     0,     0,   941,  1096,  1097,  1100,
       0,     0,   486,  1164,  1150,  1166,     0,   203,   205,     0,
    1085,  1084,     0,  1082,  1129,  1128,  1126,     0,  1127,  1125,
    1120,  1122,  1123,  2692,  2696,   584,   818,  1894,     0,     0,
     131,     0,   390,     0,     0,   888,   888,   888,  1797,  1724,
    1522,  1726,  2083,     0,     0,     0,  1803,     0,     0,  1602,
    1601,     0,  1464,     0,     0,     0,     0,  1490,     0,     0,
       0,     0,     0,     0,     0,     0,  1295,     0,     0,     0,
       0,     0,  1435,     0,  1464,  1218,  1676,  1677,  1661,  1662,
    1660,  1663,  1215,     0,  1664,  1675,  1386,     0,     0,     0,
       0,     0,     0,  1572,  1573,  1574,  1575,  1583,  1576,  1577,
    1578,  1585,  1590,  1579,  1580,  1586,  1587,  1588,  1581,  1589,
    1584,  1582,  1591,     0,  1571,     0,  1594,  1592,  1595,  1593,
       0,  1456,  1448,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1601,     0,     0,     0,  1601,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1397,     0,     0,
       0,     0,     0,  1601,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1353,     0,  2075,  2074,     0,     0,
       0,   851,     0,  1313,     0,  1312,  1534,     0,  2711,  2727,
       0,  2504,  1451,  1453,     0,  1220,  1219,  1221,  1232,  1225,
    1230,  1223,  1227,     0,  1279,  2175,  1233,     0,     0,  1261,
    2726,  1610,  1262,  1247,  1252,  1253,     0,  1250,  1251,     0,
    1255,     0,  1254,  1258,  1259,  1260,  1263,     0,     0,     0,
       0,  1302,  1307,  1483,  1204,  2076,     0,     0,   462,   465,
     464,  1717,   463,  1766,     0,  1045,     0,     0,    74,    76,
    1942,  1939,  1938,  1940,  1944,   112,  1949,  1941,     0,  1957,
    2222,  2447,  2450,   287,     0,   260,   259,   261,   284,     0,
       0,  2628,     0,  2609,     0,  2613,  2607,  2611,  2591,     0,
       0,  2599,     0,  2637,  2620,  2624,  2623,  2621,     0,  2622,
    2627,  2605,  1600,  2256,  2341,     0,  1603,  2559,  1732,  2816,
    1984,  2461,  1985,  1977,     0,  1997,     0,     0,     0,  1132,
     692,     0,  1204,   496,   495,   494,   493,     0,   511,   491,
     499,    70,     0,     0,  1973,     0,     0,     0,     0,  1088,
    1743,     0,     0,  1723,  1523,  1969,  1963,     0,     0,     0,
       0,     0,  2655,  2580,     0,     0,     0,  2701,  2719,  2718,
    2706,  1204,  1622,  1205,  1205,  2072,  2520,     0,  2514,  2513,
       0,     0,     0,  2533,  2516,     0,     0,  2482,  2521,  2522,
    2525,     0,     0,     0,     0,     0,  2519,  2444,  2484,  2485,
       0,  2490,  2480,  2539,  2540,  2537,  2538,  2536,  2509,  1873,
       0,  1904,  1907,  1908,     0,     0,  1887,  1881,  1880,  1870,
    1882,  1871,  1891,  1890,  1889,  1843,  1842,  1644,  1645,  2399,
    1643,  1635,  1638,  1642,  1641,  1836,  1897,  1886,  1884,  1868,
    1906,  1841,  1840,  1885,  1883,  1822,  1823,  1824,     0,  1631,
       0,  1902,  1875,  1906,  1896,     0,  1906,  1906,  1888,  1862,
    1864,  1058,  1075,  1074,  1070,  1071,  1076,  1066,  1065,  1543,
    1542,     0,  1497,     0,  1499,  1496,  1495,  1494,     0,  1542,
    2802,  2810,  2814,     0,  1631,  2716,  2714,     0,     0,     0,
     583,     0,     0,  2742,   115,   575,  1766,  1766,     0,  2102,
       0,     0,     0,     0,     0,     0,     0,   183,   192,     0,
       0,   396,   397,  1766,   395,   438,   439,   442,   443,   444,
       0,     0,     0,     0,     0,     0,     0,     0,   136,   445,
    1766,  1766,   392,   418,   419,   422,   423,   424,   425,   426,
     388,     0,   393,   818,     0,   953,   955,  2762,  2763,  2764,
       0,     0,  1099,  1153,  1145,  1152,  1149,  1164,  1162,  1151,
     878,   877,     0,  1165,   201,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    81,    82,   100,
    1721,  1130,  1124,   127,   818,  1766,  1766,  1766,  1766,   394,
     427,   428,   431,   432,   433,   434,   437,   435,   436,     0,
    2594,     0,     0,  1894,     0,  2657,  2658,     0,  2654,   889,
       0,     0,     0,     0,     0,  1792,     0,  2086,  1802,  1525,
    1806,  1805,     0,  1382,     0,  1428,     0,  1430,  1431,  1432,
       0,     0,     0,     0,     0,  1383,     0,  1327,  1384,  1385,
       0,  1379,     0,  1380,     0,     0,     0,     0,     0,     0,
       0,  1434,     0,  1216,     0,     0,  1331,  1332,  1324,  1316,
       0,  1407,     0,     0,  1333,     0,     0,     0,     0,  1388,
       0,  1408,  1485,     0,  1487,  2076,     0,  1440,  1389,  1338,
       0,  1438,     0,  1339,  1409,  1410,  1411,  1391,  1392,     0,
    1413,     0,  1393,     0,     0,  1396,     0,     0,  1341,  1444,
    1442,     0,     0,     0,     0,  1446,  1343,     0,     0,     0,
    1342,     0,     0,     0,     0,     0,     0,     0,  1345,     0,
    1325,  1443,  1445,  1399,     0,     0,     0,     0,     0,  1354,
       0,  2720,  1533,  2728,  1534,     0,     0,  2722,  2712,  2717,
    2725,  1317,     0,     0,  2077,  1226,  1231,  1224,  1228,  2726,
       0,     0,     0,     0,  1245,  1244,     0,     0,     0,  2726,
    1610,  1248,     0,     0,  1424,  1425,  1480,     0,  1708,  1705,
    1718,  1767,     0,  2652,  1047,  1046,  1714,  1045,    77,     0,
    1943,  1936,  1958,  1931,     0,   279,   288,   281,   285,   286,
     282,  2670,     0,  2669,     0,     0,  2588,  2647,  2650,  2083,
       0,     0,     0,  2569,  2563,  2570,  2572,  2566,  2571,  2573,
    2564,  2565,  2560,  2567,  1604,  1633,     0,  1986,  1155,  1157,
    1158,  1156,  1164,     0,     0,  2548,  2549,  2547,  2546,   501,
       0,   510,     0,   522,     0,     0,     0,  1975,  1974,     0,
    1139,  1142,  1143,  1093,  1092,  1094,  1087,  1089,  1090,   567,
    1749,     0,     0,     0,  1755,  1736,  1746,     0,  1970,  1966,
       0,   257,  2581,     0,     0,     0,     0,     0,     0,     0,
    1199,  1525,  1694,  1196,  1184,  1633,  1623,  1183,  1206,  1202,
       0,   817,   816,   815,   813,     0,     0,     0,     0,  2527,
    2528,     0,     0,  2505,  2506,  2507,     0,  2510,  2487,  2488,
       0,  2489,     0,  1903,     0,  1847,     0,  1869,     0,     0,
       0,     0,  1838,     0,  1861,  1819,  1904,  1837,  1603,  1896,
    1834,  1835,  1073,     0,  1056,  1542,  1525,     0,     0,  1517,
    1544,     0,  1544,  1519,  1520,  1525,     0,  1525,  1522,  1539,
       0,     0,  2813,  1624,  2715,     0,  2790,     0,     0,     0,
     181,   587,     0,     0,   935,   186,   189,   187,     0,   188,
       0,     0,   447,   446,     0,  1894,   440,   140,   139,   141,
     142,  1658,  1659,  1655,  1656,  1654,  1657,   144,   143,   138,
     950,     0,     0,     0,  1894,   420,   399,   400,   403,   404,
     405,  1033,  1766,  1033,     0,  1766,  1766,  1033,  1766,     0,
       0,  1766,  1766,     0,     0,  1766,     0,     0,  1033,     0,
    1766,     0,  1020,     0,     0,  1766,  1766,  1766,  1766,  1766,
    1033,     0,     0,  1766,  1766,   486,  1766,     0,     0,  1051,
       0,     0,  1766,  1766,  1766,  1766,     0,     0,  1766,  1766,
       0,  1766,   967,  1019,   589,   616,   617,   932,   966,   968,
     980,   482,     0,   998,  1022,  1023,  1021,     0,     0,     0,
       0,   150,  2766,  1098,     0,     0,  1563,   204,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1894,   429,  2590,     0,     0,  1766,
     389,   406,   407,   410,   411,   412,   413,   414,   417,   415,
     416,     0,  2661,  2663,     0,     0,   890,     0,     0,     0,
    1725,  1805,  1525,  1603,  2084,  1603,     0,  1804,     0,     0,
    1429,  1465,     0,  1491,     0,  1321,   775,   775,   775,  1474,
     760,  1478,  1469,   775,  1470,   775,  1472,     0,     0,     0,
    1281,  1296,     0,     0,     0,     0,     0,  1436,  1433,     0,
       0,     0,     0,  1459,     0,     0,     0,  1326,     0,  1419,
    1441,  1439,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1447,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   840,   846,
     849,   850,   852,   844,     0,  1401,  1314,  1204,  2729,  2731,
    1175,     0,  2721,  2723,   926,  1452,     0,  1242,  1238,     0,
    1236,  1609,  1257,  1256,     0,     0,     0,  1246,  1205,  1415,
    1204,     0,  1481,  2078,  1706,   461,   633,  1704,    75,  1934,
       0,  1929,  1932,     0,     0,  2667,     0,  2678,     0,     0,
       0,     0,     0,     0,     0,     0,  2558,  1634,  1776,     0,
    1164,  1168,  2093,  1990,  2551,  2552,  2550,     0,   502,   503,
     505,  1205,   519,   497,     0,   489,   492,     0,   501,     0,
    1091,  1189,     0,  1768,  1753,  1760,  1754,     0,     0,     0,
    1752,  2068,  2067,  2074,  2704,     0,  1569,     0,     0,  2579,
    2656,     0,     0,     0,  2707,  1603,  1603,  1688,     0,     0,
    1181,  1186,  1182,  1185,     0,  1203,  1210,  1209,  2069,  2076,
    2517,     0,     0,     0,     0,  2532,  2526,  2523,  2524,     0,
    2486,  2508,  2492,  2491,  2494,  2496,  1668,  1669,  1667,  1665,
    1666,  1905,  1631,  1857,  1856,  1646,  1637,     0,  1640,  1639,
    1830,  1849,  1851,  1906,  1072,     0,  1079,  1077,     0,  2711,
    1537,     0,  1521,  1518,  1545,     0,  1544,  1544,  1525,     0,
    1501,  1780,  1783,     0,  1500,  1596,  1527,  1189,  2803,  2815,
       0,     0,     0,   383,   382,     0,   145,  2784,     0,     0,
     671,   116,   473,   482,   588,   591,   632,   631,   191,   190,
     196,   197,  1672,  1673,  1670,  1671,   453,   466,  1674,   467,
     441,   137,   454,   455,   421,     0,   401,  1034,   923,   583,
    1002,     0,   672,   583,   874,   879,   879,   583,     0,     0,
    1133,     0,     0,  1727,     0,     0,  1133,     0,     0,     0,
    1766,     0,  1013,   962,     0,  1727,     0,  1727,  1727,  1014,
       0,     0,   963,  1766,     0,     0,     0,     0,     0,  1727,
    1133,     0,     0,     0,   484,     0,  1133,   982,  1054,  1053,
    1052,     0,  1133,  1133,     0,     0,     0,     0,   622,   623,
     621,     0,     0,     0,   614,   590,   818,   964,   483,   965,
     671,     0,  1048,   668,   674,  2079,     0,     0,   160,     0,
       0,   952,     0,   153,   151,   162,     0,     0,  1102,     0,
    1101,     0,  1566,     0,  1567,  1564,  1565,   101,    88,    84,
     105,   106,    86,    87,    91,    90,    92,    93,    96,    97,
      94,    89,    95,    85,   109,   111,   110,    98,   107,   108,
      83,   460,   459,   458,   457,   430,     0,     0,     0,  1894,
     408,  2662,  2660,  2659,     0,   916,   918,   917,   904,   903,
     117,   120,   123,     0,  1603,  1622,  2087,  1796,     0,  1355,
    1492,     0,     0,   776,  1466,   826,  1476,     0,  1477,   762,
     761,   777,  1468,  1471,  1475,  1473,  1320,  1328,  1377,     0,
    1294,  1378,     0,  1406,  1323,  1322,     0,     0,     0,  1361,
    1362,     0,  1457,     0,     0,  1335,     0,  1337,     0,     0,
    1421,  1390,  1412,  1364,  1394,     0,  1340,  1315,     0,  1365,
       0,  1370,  1368,     0,  1344,     0,     0,  1351,     0,  1349,
       0,  1350,     0,  1352,  1398,  1400,     0,     0,   851,   837,
     838,   839,     0,   841,   843,   845,     0,     0,  1535,  2730,
    1176,     0,     0,  1454,  1234,     0,  1243,  1240,     0,  1237,
    1206,  1426,  1416,     0,     0,   296,   291,   299,   293,   295,
     294,   300,   301,   302,   303,   297,   292,   298,   290,   289,
    2668,     0,  2587,  2592,  2649,  2648,  2671,  2671,  2671,     0,
    1605,     0,  1733,  1159,  1164,  1168,     0,  1160,  2001,   506,
       0,     0,     0,   526,     0,   524,   500,     0,  1140,  1204,
    1750,  1762,     0,  1770,     0,     0,  1747,  1757,     0,     0,
       0,  1756,   486,     0,   258,     0,  2576,  2577,  2575,  1633,
    1611,     0,     0,  1700,     0,  1695,  1197,     0,  1208,  1207,
       0,  2535,  2534,  2530,  2529,  2531,  2511,     0,     0,  1848,
    1636,  1631,  1844,     0,     0,  2717,  1596,  1529,  1525,  1498,
    1525,     0,     0,  1506,  1525,  1502,  1504,     0,  1603,     0,
    1561,  1204,  2071,  1625,  1628,     0,  2791,   386,   384,   385,
       0,     0,   206,   649,   650,   648,   647,     0,   474,     0,
       0,     0,   651,   652,   654,   655,  2001,   481,   818,   592,
     402,   673,   924,  1133,     0,     0,     0,   879,   667,   583,
     923,   888,   880,   583,   583,  1000,  1029,  1030,     0,     0,
     600,   597,     0,   609,   983,   974,   984,   995,   997,     0,
     599,   624,     0,     0,   612,  1727,     0,  1011,     0,     0,
     594,     0,     0,   643,   644,   642,   618,   625,  1031,  1032,
     595,   596,     0,     0,  1618,  1620,  1628,   602,   601,  1679,
    1678,   611,     0,   598,     0,  1017,   990,     0,   640,   638,
     635,   637,   636,   641,   639,   613,   604,   603,   606,   605,
     608,   607,   610,   626,   979,     0,  1033,  1033,   999,     0,
    2082,     0,  1050,  1001,     0,   656,   669,   657,     0,     0,
     630,   629,   627,   628,   161,   149,     0,     0,   954,   956,
       0,     0,   957,  2768,     0,  2770,  1104,  1105,     0,     0,
    1167,     0,     0,   102,   104,     0,   391,   456,   409,  2664,
       0,     0,     0,  1805,  1798,  1647,     0,  1493,     0,     0,
       0,     0,   820,   831,   829,   823,     0,   827,   828,  1467,
       0,     0,   778,  1479,   742,   775,  1291,   760,  1285,  1287,
    1283,     0,   743,  1286,   775,     0,   826,  1290,  1282,     0,
    1437,     0,     0,  1460,     0,     0,     0,     0,     0,     0,
       0,  1318,     0,  1417,     0,     0,     0,     0,     0,     0,
    1348,  1346,  1347,   835,  1403,     0,   848,   842,   840,   847,
       0,  1633,  2711,   927,  1239,     0,  1427,  1935,  1959,     0,
       0,  2676,  2676,  2676,  1775,  1774,     0,  1773,  1777,  1161,
    1169,  2003,  2002,     0,   504,   507,     0,   499,     0,   523,
       0,   490,   568,     0,     0,     0,  1771,  1759,  2708,  1748,
    1751,  2076,  1524,  1570,  2578,  1188,     0,  1606,  1699,  1696,
       0,  1689,  1691,  1693,     0,  2070,  2493,  2495,  1850,  1078,
    1080,  1530,  1528,  1538,     0,  1494,  1525,  1525,     0,  1494,
       0,     0,  1782,  1622,  1784,  1526,  1558,  1540,     0,  1629,
    1630,  1627,     0,   217,  1204,     0,     0,   207,   209,   210,
       0,     0,   471,   468,   671,   470,   570,   593,   985,     0,
     583,   875,   876,   888,   925,     0,   888,   888,     0,     0,
     973,  1004,  1121,     0,   978,   814,   619,     0,   969,  1012,
    1045,     0,   620,  1006,   971,     0,  1621,   485,   970,   992,
     976,  1957,  1003,  1049,   856,   756,   705,   696,   775,   699,
     698,   775,   710,   760,   758,   728,   760,   760,   735,   734,
     752,   738,   718,   826,   826,   717,   755,   826,   739,   737,
     741,     0,   743,   760,   748,   736,   740,   757,   733,   730,
     754,   775,   775,   775,   714,   753,   826,     0,   746,   775,
     675,   779,   716,   826,   833,     0,     0,   775,   777,  2081,
     147,   152,   163,   164,   945,  2767,     0,  2765,     0,  1110,
       0,  1163,  1568,    99,     0,     0,     0,     0,     0,     0,
    1793,  1356,   773,   771,   774,   772,   822,   821,   825,     0,
     824,   833,     0,     0,  1293,  1288,   744,  1292,  1284,  1289,
    1381,  1359,  1360,     0,  1458,  1449,  1387,     0,  1336,  1418,
       0,     0,  1395,  1366,  1369,  1367,  1372,  1373,     0,  1402,
       0,  1196,  1196,   645,  2724,  1241,     0,  1933,  2679,     0,
       0,  2675,  2673,     0,  2674,  2672,  2640,     0,  2585,  2586,
    2584,  2568,     0,     0,     0,  1204,   512,     0,   529,   528,
     525,  1633,  1761,  1763,  1769,  1758,     0,  1607,  1622,   807,
    1692,     0,  1198,     0,  1507,     0,  1511,  1516,  1512,     0,
    1503,     0,  1647,  1562,     0,  1633,  1628,     0,   220,   218,
     219,     0,   213,   215,   210,  2778,     0,  2785,     0,     0,
    2783,   475,  2708,   587,   653,   571,     0,   987,     0,     0,
       0,     0,     0,     0,  1016,     0,     0,   975,   996,  1018,
    1010,  1009,     0,     0,  1133,  1619,   991,   993,  1088,     0,
       0,   860,   704,   697,   715,   713,   764,   759,     0,   764,
     764,   724,   742,   719,     0,   826,   732,   723,   744,   747,
     749,   751,   764,     0,   826,   712,   711,   721,   708,   764,
     787,     0,     0,     0,     0,   783,     0,   854,     0,   790,
       0,   676,   780,   782,     0,     0,     0,   745,   826,   701,
     834,   833,   703,   826,   833,   764,   764,     0,   154,   958,
     323,  2769,  1179,     0,  2774,     0,  1111,  1107,  1108,  1103,
     103,   135,     0,  1628,   921,     0,     0,  2399,  1648,  1799,
     832,   830,     0,  1461,  1628,     0,  1420,  1422,   836,     0,
    1536,   646,     0,  2646,  2645,  2644,  2641,     0,     0,     0,
       0,     0,     0,  2677,  2681,  1772,     0,     0,     0,   520,
       0,     0,   554,   569,  1615,  1628,     0,  1633,     0,  1697,
    1690,  1531,     0,     0,     0,     0,     0,  1781,  1550,  1551,
       0,     0,  1556,  1560,  1541,  1626,  2782,  2792,   217,     0,
       0,   158,     0,   208,   814,   211,   472,   482,     0,   477,
       0,     0,   986,   670,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1015,  2046,  1048,   486,  1007,   972,
       0,   977,   615,     0,   859,     0,   864,   768,   769,   770,
     725,   765,   767,     0,   727,   695,   720,   750,   726,     0,
     722,   709,   793,   792,  1211,   785,   800,   680,     0,     0,
     791,   677,   781,   789,   784,     0,   700,   702,   706,   707,
     693,   694,  2080,     0,   156,   349,     0,   335,   321,     0,
       0,     0,   325,   165,   168,   166,     0,   167,   173,     0,
     174,   175,   176,   177,   178,   169,   347,   348,   172,   170,
     171,     0,  2096,     0,  2097,  2772,     0,     0,  2771,  1106,
       0,  1113,   891,     0,   920,     0,   893,   895,  1649,     0,
    1204,  1794,   763,     0,  1463,  1334,  1404,  1960,  2642,  2682,
    2685,  2683,  2684,  1651,     0,  2686,  2680,     0,  1522,  1205,
       0,   513,     0,   516,   518,   532,     0,  1766,  1766,     0,
       0,  1766,  1766,  1766,  1766,   547,   555,   557,     0,  1616,
    1617,     0,  1612,  1614,  1608,  1680,   808,  2004,  2711,  1508,
       0,  1513,     0,  1505,  1546,  1546,  1557,   184,   214,     0,
       0,   150,   159,  2786,   798,  2001,     0,  2704,   989,     0,
       0,     0,   658,     0,     0,  2048,  2047,  1005,   981,  1048,
       0,   857,     0,   861,   862,   863,     0,   855,   766,     0,
     928,     0,     0,   799,  1211,   788,     0,   797,   796,   794,
     795,   155,     0,   148,     0,     0,   334,   337,     0,     0,
     340,   330,   329,   331,     0,   324,   323,   323,   377,   328,
     374,   373,   366,  2708,     0,     0,     0,  1112,  1117,     0,
    1114,  1116,     0,  1766,   118,   892,   912,   911,   897,     0,
    1628,     0,     0,   121,   894,   914,   901,   124,   896,   913,
     899,  1650,  1800,  1628,  1653,  1652,  1778,  1786,     0,  1991,
       0,   521,   514,     0,     0,   530,     0,     0,  1766,  1766,
       0,     0,     0,     0,     0,   527,   556,  1766,  1628,     0,
    1187,     0,  2012,  1532,     0,     0,     0,  1554,  1552,  2793,
     216,  1204,   162,     0,   469,   479,   478,   988,     0,   664,
     891,   660,   662,  1008,     0,   858,     0,     0,   826,     0,
     826,  1212,     0,   786,  1204,   157,   350,   361,   364,   356,
     336,     0,     0,     0,   326,   323,     0,   310,   308,   309,
     315,   316,   317,   318,   319,   320,   311,   314,   312,   313,
     323,     0,   225,     0,     0,  2773,     0,  2775,     0,  1109,
       0,   906,     0,  1024,   898,     0,   919,   922,     0,  1024,
     902,  1024,   900,  1462,     0,     0,   807,   508,   520,   517,
     540,   533,   536,     0,   566,   560,     0,     0,   562,   563,
     561,   558,   551,     0,   549,     0,  1613,  1681,     0,     0,
       0,     0,  2005,  2007,     0,  1698,  1510,  1515,     0,  1547,
       0,     0,     0,   194,   193,   185,     0,   323,  2779,     0,
    2787,  2708,   666,   891,   659,   893,   895,     0,   870,     0,
     869,     0,   866,   865,   729,   929,   731,  1213,     0,     0,
       0,   323,   357,     0,   332,     0,     0,     0,     0,   223,
     380,     0,   221,   368,   368,  2776,  2777,  1115,   905,   119,
    1026,  1025,   910,   909,   907,   908,   915,   122,   125,  1785,
    1787,  1992,   515,   540,     0,   538,     0,   534,   531,   535,
     564,   565,     0,   548,     0,   559,     0,     0,     0,     0,
       0,  2006,     0,     0,  2013,  2015,  1549,  1548,  1563,     0,
     195,  2794,     0,   164,   184,   480,   665,   661,   663,   994,
     872,   873,   871,     0,     0,   681,   358,   364,   354,   362,
     323,     0,     0,   322,   341,   376,   224,     0,   378,     0,
     323,     0,   367,   369,   371,  1028,  1027,  2018,   537,     0,
     545,   541,   543,   546,   554,   553,   550,  1204,  2010,  2011,
       0,  2008,     0,     0,  2014,     0,     0,     0,   146,  2788,
       0,     0,   683,   682,   684,     0,   355,     0,     0,   353,
     333,   338,   323,     0,   323,   236,   235,     0,   227,   304,
     375,     0,   226,     0,  2004,   539,     0,     0,   552,     0,
       0,  1684,  1686,  2009,  2017,  2016,  1555,  1553,  2780,   323,
     868,   867,     0,   688,   678,   685,   687,   359,     0,   323,
       0,   323,     0,   323,     0,     0,     0,     0,     0,   222,
       0,  2012,   544,   542,  1205,  1682,  1204,   323,  2789,   690,
     689,   686,     0,   351,   323,   339,   344,   381,     0,   230,
     305,   306,     0,   233,     0,  2020,  1687,  1685,  2781,   323,
     323,   340,   343,   379,     0,     0,   228,   229,   241,   240,
     232,     0,  2019,     0,  2024,   323,   323,   345,   249,   247,
     323,   237,   245,   239,     0,   246,   307,   234,     0,     0,
    2031,     0,   231,   248,  2022,  2023,  2021,  2026,     0,     0,
    2028,  2029,     0,  1993,   238,  2030,  2025,     0,  2032,  2034,
       0,  2027,     0,  1204,  2033,     0,  1205,  2035
};

/* YYDEFGOTO[NTERM-NUM].  */
static const yytype_int16 yydefgoto[] =
{
      -1,    59,   624,  1532,    60,    61,    62,    63,    64,  1373,
      65,   837,  1291,  1838,  1839,    66,   564,    67,  1599,  2157,
    2158,  3502,  3503,  2159,   662,   663,    68,  2531,  3510,  4443,
    3511,  4449,  3512,  4451,  1616,   627,   535,  2097,  2098,  1536,
    3361,  3081,  3988,  3085,  4144,  4293,  4251,  2115,  3492,  3989,
    3990,  4153,   559,  2529,  1571,  4379,  2077,  4495,  2078,    69,
     660,  1084,  1596,  1597,  3666,  3667,  3899,  3668,  3891,  3892,
    3893,  3894,  4610,  4415,  4532,  4611,  4696,  4734,  4740,  4741,
    4657,  4750,  4751,  4752,  4738,   914,  4753,    70,   587,   588,
     916,  1403,  1853,  1404,    71,    72,   558,  1317,  1318,  1319,
    1320,  2370,  1854,  2365,  2366,  3258,  4658,  4736,  4416,  4417,
    4300,  4418,  4156,  4419,  4304,  4420,  4159,  4421,  4422,  4423,
    4424,  4602,  4425,  4299,  4650,  4412,  4413,  4652,  4716,  4732,
    4426,  4166,  4294,  4519,  4167,  4295,  4597,  4408,  4598,  4645,
    4712,  4409,  4520,  4648,  4523,  4427,  4433,  4612,  4428,  4434,
    4429,  4171,  4311,  4432,  4309,  4431,  4654,  4607,  2965,  3360,
     647,   648,   675,  2183,   649,  1100,  1054,  1573,  2110,  2111,
    2566,  2567,  2680,  2681,  2682,  2102,  2103,  2104,  2169,  2170,
    2171,  2084,  2085,  2086,  1577,  2081,  2082,   650,  1055,  1065,
    2105,  2106,  2107,  2686,  2173,  2174,  2175,  2176,  2108,  1831,
    2109,  2986,  2971,  3903,  3902,  2972,  3675,  4257,  4501,  3376,
    3377,  3068,  3442,  2128,    73,   576,   894,  1370,  2414,  1371,
    2416,  2847,  2848,  2849,  1903,  1904,  3856,  1908,  2413,  4039,
    4458,  4212,  4213,  2851,  4211,  2855,  3284,  3285,  3608,  3858,
    4042,  4463,  4354,  4558,  4461,  4554,  4462,  4556,  4667,  4621,
    4622,  4365,  4473,  4474,  4562,  4624,  4225,  4226,  4227,  2434,
    2861,  3861,  3906,  2163,  1563,  1564,   628,   629,   630,  3390,
      74,  2973,  2623,  2974,  2975,  3465,  2625,  2626,  2815,  1461,
    3455,  3426,  3831,  3367,  3371,  3372,  3373,  3374,  3375,  4390,
    4505,  4506,  4503,  3475,  3388,  3001,  3002,  3073,  3478,  3760,
    4286,  3970,  4644,  4684,  4685,  4686,    75,   891,  4074,  3938,
    3953,  3762,  3763,  3764,  3765,  3766,  3767,  3768,  3158,  3159,
    4110,  4111,  4112,  3153,  3154,  3533,  3971,  3972,  3973,  4075,
    4125,  3526,  1427,  1428,  4049,  1439,  1440,  2462,  1948,  2463,
    1567,  3527,  3528,  3529,  3982,  3217,  3828,  3223,  3224,  3225,
    2778,  2779,  2780,  2781,  2782,  2308,  3974,  3477,  3931,  4103,
    4106,  4277,  4512,  3003,  3389,  3004,  3393,   996,   536,  3005,
    3006,  2189,  2190,  4324,  4333,  4337,  4325,  4338,  4334,  4326,
    4327,  4328,  4340,  4336,  3138,  4002,  4003,  3381,  3391,  3233,
    4279,    76,   130,  2113,  1046,  1057,  1053,  1076,   655,  1583,
    2116,  2641,  3774,   637,  2627,  3924,  3692,  3928,  2628,  3405,
    2629,  3907,  4082,  2630,  3709,  3926,  4100,  3406,  3407,  2631,
    2632,  2633,  3916,  3923,  4269,  4539,  4540,  4541,  3007,  1352,
     652,   653,  1069,  1070,  1071,  2356,  3473,  3051,    77,  2036,
    2031,    78,  1008,  1009,  1010,  1507,  1508,  2034,  2035,  2504,
    2937,    79,   665,  1603,    80,  1381,  2426,  2427,  2428,    81,
    1077,  1587,  1588,  2122,  3090,  3498,  3779,  3999,  4181,  3995,
    4319,  4320,    82,    83,   666,  1610,  1611,  1612,    84,  1364,
     137,    85,   902,  1376,  1378,  1379,    86,   659,  1078,  1079,
    1080,  1081,  2124,    87,  1894,  2398,  2399,  2400,  2401,  1593,
    2645,  1594,  1595,  2133,  3277,    88,    89,   621,  2316,   593,
     926,   594,   595,  1942,  2453,  3832,   937,   938,   939,  2890,
    1417,  1418,  1419,  1900,  2895,  4283,  1147,  1143,   800,   801,
     802,   803,  1237,  1238,  3975,   804,  1247,  1797,  3170,  3548,
    1656,  1657,   805,   806,   807,   808,   809,   810,  1824,  3189,
    3190,  3563,  2343,  2344,  2345,   811,  2230,  3176,  2243,   812,
    1230,  1782,  1712,  3555,  3182,  3813,  4013,  1641,  2206,  2727,
    3161,  2811,  2310,  1169,  1170,  1128,  2213,  1647,  2042,  2043,
    2044,  2045,  2046,  3650,  3651,  4052,  3875,  4054,  3879,  2514,
    2515,  1923,  1924,  2047,  2048,  2938,  3873,  4238,  2311,  2312,
    2313,  3581,  2939,  3338,  2956,  2957,  3885,  2505,  2049,  2945,
    4377,  4061,  4062,  4492,  4491,  4063,  3883,  3884,  3655,  3656,
    3093,  3094,  3095,  2875,  1703,  1704,  1710,  1347,  1348,  1642,
    2395,  2835,  3868,  4046,  2334,  3627,  4044,  4232,  2636,  3434,
    3435,  2455,  2456,  2960,  3353,  3661,  1464,  3833,  2837,  2001,
    2925,  2926,  3790,  4205,  4739,  2783,  2921,  2987,  1674,  1675,
    3441,  4370,  4566,  4670,  4671,  4672,  3313,  3314,  3631,  3632,
    2457,  2887,  3315,  3869,  4237,    90,   540,    91,  1836,  2814,
    1288,  2362,  1088,  1383,  1628,  1629,   824,   554,    92,   565,
    2396,    93,   583,  1921,   881,   906,  1384,  1385,  2435,  2862,
    2869,  2436,  2874,  3618,  2864,  3290,  3291,  2351,  2352,  2865,
    3293,  3615,  3596,  3597,  3272,  3853,    94,   609,  3348,  2951,
    2952,  4346,  4347,   907,    95,   539,  1115,  2703,  4009,  1634,
    2194,  4191,  1116,  1117,  2197,   684,   685,    96,  1013,   605,
    1487,  1488,  1489,  2019,    97,   597,   997,  2922,  3331,  1995,
     898,  1283,  1468,  1000,  1469,  1981,  2485,  1450,    98,  1042,
    1041,  1558,    99,   633,  1559,   100,   838,  1311,  1849,  2821,
    2822,  3243,  1312,  1313,  2363,  3837,   101,   584,   911,   912,
    1388,  2439,   102,   578,   899,  1914,   103,   568,   886,  1356,
    1893,   104,   105,   106,   888,  3278,  4456,  4617,   572,  1896,
    1360,  3676,  4372,  4482,  4483,  4485,  4574,  4575,  4664,  4744,
    4766,  4760,  4769,  4770,  4773,  4778,  4779,   814,  1022,  1023,
     815,  4094,   816,   817,   818,  2870,  2871,  3354,   819,  2872,
     820,  3074,  1089,  1631,   562,   514,   644,  1024,  2843,   822,
    4173,  1049,  1285,  1107,  1108,   516,   517,   107,   596,   954,
    1444,  1434,  1443,  1968,  2479,  1972,  2481,  2482,  3327,  2913,
    3328,  2914,  1002,  1964,  1969,  2915,   957,  1957,  1958,  1959,
    1960,  2906,  1954,  1978,   108,   889,   521,  1362,  1363,  2407,
     109,   608,   110,  1349,  1886,  1887,  2392,  2834,  2393,   111,
     920,   921,   112,   866,  1620,  2376,  1102,  1052,  1103,  1872,
     869,  1323,   870,   871,  1338,  1332,  1341,  1335,  4027,  3845,
    3846,  2380,  1287,  1109,  1933,  2187,  3134,  1110,  1863,  2372,
    2373,  3591,  3848,  3262,  4033,  4034,   113,   138,   524,   668,
    1095,  1411,   114,   115,   116,   117,  1414,  1527,  2449,  1528,
    2317,  1529,  1530,  2056,  1940,  1778,  1779,  3231,  1227,  1228,
    2320,  2787,  2788,   940,  1035,  1546,  1538,   131,   132,   133,
     134,  1074,  1075,  2642,  3087,  3494,  3777,  3778,  3994,  4178,
    1540,  4070,  4582,  4707,  1541,  1542,  3362,  4072,  4383,  4584,
    4679,  1543,  2962,  3663,  4247,  4497,   118,  1025,   618,  1525,
    1520,  1522,  2052,  2522,   119,   120,   121
};

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
#define YYPACT_NINF -4108
static const int yypact[] =
{
    5560,  2413,  1221, -4108,  -130,   898, 57381,   766,  1340,  1340,
    -174,  3700, -4108, -4108, -4108, -4108, -4108,  3026, -4108, 57381,
    1221,  1057, -4108, 25598, -4108, -4108,   -53, -4108,   191,  1340,
    1221,   542, -4108, 57381, -4108,   858,  -157,  1221, -4108, -4108,
   50396, -4108,  -174, 57381, -4108, -4108, -4108, -4108, 50396,   188,
     285,   849,   578, -4108, -4108, 57381,  2481, -4108,  -156,  1485,
    1332, -4108, -4108,  1112, -4108, -4108, -4108, -4108, -4108, -4108,
   -4108, -4108, -4108, -4108,  -147, -4108, -4108, -4108, -4108, -4108,
   -4108, -4108, -4108, -4108, -4108, -4108, -4108, -4108, -4108, -4108,
   -4108, -4108, -4108, -4108, -4108, -4108, -4108, -4108, -4108, 26236,
   -4108, -4108, -4108, -4108, -4108, -4108, -4108, -4108, -4108, -4108,
   -4108, -4108, -4108, -4108, -4108, -4108, -4108, -4108, -4108, -4108,
   -4108, -4108,  1431, 57381,  1436, 57381,  1399, 57381, 48491, 57381,
   -4108,  1444, -4108, -4108,  1498, -4108, -4108,  1340,  -174, -4108,
   -4108, -4108, -4108, -4108, -4108, -4108, -4108, -4108, -4108, -4108,
   -4108, -4108, -4108, -4108, -4108, -4108, -4108, -4108, -4108, -4108,
   -4108, -4108, -4108, -4108, -4108, -4108, -4108, -4108, -4108, -4108,
   -4108, -4108, -4108, -4108, -4108, -4108, -4108, -4108, -4108, -4108,
   -4108, -4108, -4108, -4108, -4108, -4108, -4108, -4108, -4108, -4108,
   -4108, -4108, -4108, -4108, -4108, -4108, -4108, -4108, -4108, -4108,
   -4108, -4108, -4108, -4108, -4108, -4108, -4108, -4108, -4108, -4108,
   -4108, -4108, -4108, -4108, -4108, -4108, -4108, -4108, -4108, -4108,
   -4108, -4108, -4108, -4108, -4108, -4108, -4108, -4108, -4108, -4108,
   -4108, -4108, -4108, -4108, -4108, -4108, -4108, -4108, -4108, -4108,
   -4108, -4108, -4108, -4108, -4108, -4108, -4108, -4108, -4108, -4108,
   -4108, -4108, -4108, -4108, -4108, -4108, -4108, -4108, -4108, -4108,
   -4108, -4108, -4108, -4108, -4108, -4108, -4108, -4108, -4108, -4108,
   -4108, -4108, -4108, -4108, -4108, -4108, -4108, -4108, -4108, -4108,
   -4108, -4108, -4108, -4108, -4108, -4108, -4108, -4108, -4108, -4108,
   -4108, -4108, -4108, -4108, -4108, -4108, -4108, -4108, -4108, -4108,
   -4108, -4108, -4108, -4108, -4108, -4108, -4108, -4108, -4108, -4108,
   -4108, -4108, -4108, -4108, -4108, -4108, -4108, -4108, -4108, -4108,
   -4108, -4108, -4108, -4108, -4108, -4108, -4108, -4108, -4108, -4108,
   -4108, -4108, -4108, -4108, -4108, -4108, -4108, -4108, -4108, -4108,
   -4108, -4108, -4108, -4108, -4108, -4108, -4108, -4108, -4108, -4108,
   -4108, -4108, -4108, -4108, -4108, -4108, -4108, -4108, -4108, -4108,
   -4108, -4108, -4108, -4108, -4108, -4108, -4108, -4108, -4108, -4108,
   -4108, -4108, -4108, -4108, -4108, -4108, -4108, -4108, -4108, -4108,
   -4108, -4108, -4108, -4108, -4108, -4108, -4108, -4108, -4108, -4108,
   -4108, -4108, -4108, -4108, -4108, -4108, -4108, -4108, -4108, -4108,
   -4108, -4108, -4108, -4108, -4108, -4108, -4108, -4108, -4108, -4108,
   -4108, -4108, -4108, -4108, -4108, -4108, -4108, -4108, -4108, -4108,
   -4108, -4108, -4108, -4108, -4108, -4108, -4108, -4108, -4108, -4108,
   -4108, -4108, -4108, -4108, -4108, -4108, -4108, -4108, -4108, -4108,
   -4108, -4108, -4108, -4108, -4108, -4108, -4108, -4108, -4108, -4108,
   -4108, -4108, -4108, -4108, -4108, -4108, -4108, -4108, -4108, -4108,
   -4108, -4108, -4108, -4108, -4108, -4108, -4108, -4108, -4108, -4108,
   -4108, -4108, -4108, -4108, -4108, -4108, -4108, -4108, -4108, -4108,
   -4108, -4108, -4108, -4108, -4108, -4108, -4108, -4108, -4108, -4108,
   -4108, -4108, -4108, -4108, -4108, -4108, -4108, -4108, -4108, -4108,
   -4108, -4108, -4108, -4108, -4108, -4108, -4108, -4108, -4108, -4108,
   -4108, -4108, -4108, -4108, -4108,  1007, -4108, -4108,  -130, -4108,
   -4108, -4108, -4108, -4108,  1676,  1491, -4108,  1580,  1320, -4108,
   48491, -4108, 57381, -4108, -4108, -4108,  1566,  1594,  1700,    89,
   11975,  1585,  1585,  1585,  1585,  1669,  1585, -4108,  1585, 57381,
   -4108,  1585, -4108,  1585,  1340, -4108, -4108, -4108,  1773, 36426,
   57381,  1577,   220,   -94, 48491,  1174, 57381,  -130,    56, -4108,
    1696, -4108, -4108, -4108,  1340, -4108,  1935,  1776,   979, 57381,
   -4108, -4108,  1340,  1256,    26,  1349, -4108, -4108,  1514, -4108,
   37061,   161, -4108, -4108, -4108,  2362, 28150,  4325,  1514,  1520,
    -130,  -110,  1529,  -130, -4108, -4108, 57381,  -130,  1340,  1718,
   -4108, -4108,   158,   158,   158, -4108,   158, -4108,   158, -4108,
    -156,  1360, -4108, -4108,  1391, 57381, -4108,  1054,  1488, -4108,
    1511,   802,  1858, -4108, -4108,  1397,   873, -4108,  1464, 40871,
   -4108, 57381, -4108, -4108, -4108, -4108,  1699, -4108, -4108, -4108,
    2142, -4108,  1517,    84, 57381,  1551, -4108, -4108, -4108, 25598,
    1439, 57381,  1536, -4108, -4108, 25598, 25598,   876,  1264,  1180,
   57381, 57381, -4108, 45316,  1919, -4108,  2112, 40871,  1491,  1491,
    1491, -4108, -4108, -4108, 51031,    89,  1459,  1469,  1481, 17231,
   -4108,  1493,  1515,  1518, 11975,  1521,  1523,  1559,  1567,  1579,
    1583,  1595,  1608,  1624,  1634,  1642,  1660,  1673,  1683,  1683,
    1683,  1686,  1711,  1719,  1725,  -199,  1732, -4108,  1734,  1755,
    1759, -4108, -4108,  1764,  1766,  1779, -4108, -4108,  1787,  1790,
    1795, 12632,  1805,  1807,  1817, -4108, 22396,  1822,  1826,  1835,
    1837,  1847,  1852,  1854,  1856,  1867, -4108, -4108, 11975,  1686,
   -4108, -4108,  1887, -4108,  1889,  1891,  1903,  1911,  1920,  1939,
    1941,  1945,  1961,  1970,  1982,  1990,  1992,  1994,  1999,  2014,
    2019,  1686, -4108,  1090,  2023,  2035,  1094,  2046, -4108,  2049,
   -4108,   288,  2061,  1683,  1686,  1686,  2074,  2076,  2100,  2105,
    2110,  2129, 17231, 17231, 17231, 11975, -4108, 57381, -4108, 57381,
     456,  3357, -4108,  2808, 17231,   205, -4108, -4108, -4108, -4108,
   -4108, -4108, -4108,  1496,  1596, -4108, -4108, -4108, -4108, -4108,
   -4108,  2134,  1482,  2010, 57381, 57381, 57381, 57381, 57381, 57381,
   45316, 48491,  1623, 57381, 45951, -4108,  1585,  1621,  3821, 31335,
    1906,  1884,  1345,  1683, -4108, -4108,   -79,   552,   595,  1993,
   -4108, -4108,  1800,   649,  2127, -4108,   667,   404, -4108,    65,
     689,   724, -4108, -4108, -4108, -4108, -4108, -4108,  1785,  2401,
    1782, -4108, -4108,   139, -4108, -4108, 57381, -4108, -4108, -4108,
   -4108,  2316,  1975, -4108, -4108, -4108,   196,  2532,   221, 25598,
   -4108,  2004, 11975,   903, -4108,  -205, -4108, -4108,  2377, -4108,
   -4108, 45951, 25598, -4108, -4108, -4108, 23036, -4108, -4108,  2743,
   -4108,  2141, -4108, -4108,  1596,  3942, -4108,  2418,  1906,  2429,
   -4108,  2611, -4108,  2436,  2337,  1264,  2224, -4108, -4108, -4108,
   -4108, -4108, -4108, -4108, -4108, -4108, -4108,  2182,  2362, -4108,
   -4108,   381,  2353,  2190,   432,   436, 40236,  1130, 48491,   437,
      70, 28787, 41506,  2198, -4108, -4108, -4108,   800,  2359, -4108,
    2697, -4108, -4108,     1, -4108,  2225,   742,     1, 46586,  2610,
     190, -4108,   155, -4108,  2696, -4108, -4108, -4108, -4108, -4108,
    2365,  2352,  2400, -4108,   277,  2286, -4108,  -130, -4108,   -17,
   -4108, -4108,  2380, -4108,  2610,     1,   190, -4108,  2629,  2757,
     473,  2742,  1025, -4108, -4108, -4108,   -72,  2862, -4108,  2301,
   -4108, -4108, -4108, 25598, -4108, -4108, -4108,  2316, -4108, -4108,
   -4108, -4108,  2306, -4108, -4108,  2593,  2423, -4108, -4108,    60,
   -4108,  2324,   -18,  2817, -4108, -4108,   281,   -93,  1498,  1491,
   -4108,  1995, 42141, -4108, -4108, -4108,  2850,  2866,  1683,  2327,
   -4108, -4108, -4108, -4108, -4108,  2982, -4108, -4108,  2338,  2877,
    2877,  2877,  2992, -4108, -4108, -4108, 25598, -4108, -4108, -4108,
      84, -4108, -4108,  2514,  2378, -4108,  1551, 25598,  2752,  2355,
   -4108, -4108,  2608, 11975, -4108, -4108, -4108,    42, -4108, -4108,
     179, -4108,  2956,  2569, -4108, -4108, -4108, -4108,  2842, -4108,
   -4108,  2982,  -249, -4108,  2904,  2877,  2791, -4108,  2796,  2374,
   -4108, 57381, 57381, 57381, 25598, -4108,  2381, -4108,  2371, -4108,
   11975, 11975,   325,  2960,  3025,  3025,  3025,   456,  2415, 11975,
   11975, 11975, 11975, 11975, 11975, 11975, 11975, 11975, 11975, 11975,
   11975,   337,  2386, -4108, -4108, -4108,  1640, -4108,  2392, 11975,
   11975, -4108, 11975, 11975, 26874, -4108,  4746, 11975,   485,  2902,
   11975, 11975, 11975, 11975,  3512, 11975, 11975, 11975, 26874,  3039,
    2395, -4108,  2390,  1446, 11975, 11975,  1535, 11975, 11975, 11975,
   11975, 11975, -4108, -4108, 11975, 11975, 11975, 11975, 17231, 11975,
   11975, 11975, 11975, 11975, 11975,  2399, 11975,  3025,  3025, 11975,
   11975,  1539, -4108, -4108, 11975,  1351,  1351, -4108, 11975,  8690,
   11975, -4108, -4108,  2402, -4108, -4108, -4108, 26874,  3025,  3025,
   11975, 11975, 11975,  2960,  2960,  2960,   262,  2408,   933, 11975,
   29424,  2393, -4108, -4108, -4108, -4108, 11975, 11975, 11975, -4108,
   17231, -4108, -4108,  2310, -4108, -4108, -4108, 13289, 17231, 17231,
    2410, 17231, 17231, 17231, 17231, 17231,  2779, 17231, 17231, 17888,
   18545, 17231, 17231, 17231, 17231,   222,  2960, 48491, 17231, 11975,
   -4108, -4108, 57381, -4108, -4108, -4108,  2405,  2691,  1623, -4108,
    2417, -4108,   747,  2909, -4108, -4108, -4108,  2420, 25598, -4108,
    2419, -4108,  2780, -4108, -4108,  2789,  2790,  2794, -4108, -4108,
   -4108, -4108, -4108,  3032,  2801, -4108,  -130,  2803, -4108, -4108,
   -4108, -4108,  2441, -4108, -4108, 19202, 48491, -4108,  2443, -4108,
    2933, -4108, -4108, -4108, -4108, -4108, -4108,  2547, -4108, -4108,
   -4108, -4108,  2449, -4108, 45951,  2449, -4108, -4108,  2449, -4108,
   -4108,  2449, 40871,    64,  4121, -4108, -4108, 57381, -4108, 58016,
   -4108, -4108, 23036,  -130, -4108,  2873, 13946, -4108, -4108, -4108,
    2823,   150,  2452, -4108, 25598, -4108,   456, -4108,   114,   114,
    2707,  1508, 48491, -4108, -4108,   162,  2454,  2538,  2459, -4108,
    2549, 25598, 25598, -4108, -4108, -4108,  2729, -4108,  -130,    26,
   -4108, -4108, -4108, -4108, -4108, -4108, -4108, -4108, -4108, -4108,
   -4108, -4108, -4108,  2476,  2968,  2938,  2484, 45951, 40871,   812,
   -4108, 57381, -4108,  1556, -4108, -4108, -4108,  2488, -4108, 11975,
   -4108, -4108, 57381, -4108, -4108, -4108, -4108, -4108,  3063, 11975,
   -4108, 45951,   897, -4108,   781,  1047,   800, -4108, -4108, -4108,
   -4108, -4108, 57381, 51666,  2490,  9347,  2612,  2894,  -130, 11975,
   -4108,  2500,  1491, 57381, 57381, 57381, 25598, 57381, 25598, -4108,
       5,     5, -4108, 42776, -4108, -4108, -4108, -4108,     1, 57381,
   57381,     1, 40871, -4108,   190,   -13, 57381,     1, -4108,  2895,
    2599, -4108, -4108, -4108,  2965, -4108, -4108,  2957,  2498, -4108,
    2988, -4108, -4108,  2627,   190, -4108, -4108, 25598, -4108, -4108,
     190, -4108,   190,   190, 11975,     1,     1, -4108,   642, -4108,
   -4108, -4108,  2656,  -110, -4108, -4108, -4108,   778,   158,  2760,
   -4108, -4108, -4108, -4108, -4108, -4108, -4108, -4108, -4108, -4108,
      79, -4108, -4108, -4108, -4108, -4108, -4108,   234, -4108, -4108,
   -4108, -4108, -4108, -4108, -4108,   978, -4108, -4108, -4108, -4108,
   -4108,  1551, 25598, -4108, -4108, -4108, -4108, -4108, -4108, -4108,
   -4108, -4108, -4108,    78, -4108, -4108, -4108,  2172,  3024, -4108,
   48491,  3450,   -85,    11,  3450,  1917,  -130,   173, -4108,   173,
   -4108, -4108, -4108,  2793,   208, 25598, -4108,  2515, -4108,  2771,
   52301, 25598, -4108, -4108, -4108,  1548,  2520,  2524,   456,  4652,
   -4108, -4108, 25598, -4108, -4108, -4108, -4108,  2586, -4108, -4108,
   -4108, -4108,  2535, -4108, -4108, -4108,    90,  1769,  3183, 45316,
   -4108,  2561,  2585,   133, 40871, -4108, -4108, -4108,  2541, -4108,
    2729, -4108,  1576, 57381,  2998, 33879, -4108,   353,   861, -4108,
    3025,  2544, -4108,  2546,  2550,  2552, 11975,    88,  1339,  1036,
    -216,  1326,  1316,   391,  1334,   428, -4108,  1344,   534,   596,
     700,   200, -4108,  2553,  2560, -4108, -4108, -4108, -4108, -4108,
   -4108, -4108, -4108,  2562, -4108, -4108, -4108,   835,   874,  1343,
    1363,  2564,  2566, -4108, -4108, -4108, -4108, -4108, -4108, -4108,
   -4108, -4108, -4108, -4108, -4108, -4108, -4108, -4108, -4108, -4108,
   -4108, -4108, -4108,  3002, -4108,  1386, -4108, -4108, -4108, -4108,
    2559, -4108, -4108,  1374,   938,   960,   294,  2577,  1545,   977,
    1553,  1599,  2572, 26874, 57381,  3025,  2575,  1392,  1410,  3025,
    2583,   983,  1415,  1609,  1630,  1716,  1421,  1470,  1000,  1740,
    3035,  1484,  1023,  1032,  1501,  1041,  1084, -4108,  1510,  2584,
    2589,  1118,   243,  3025,  2591,   296,  2576,  2595,  1550, 10004,
   10661, 11318,   524,  1124, -4108,  2598, -4108,  2390,  2606,  2607,
     319,   211,  1557, -4108, 11975, -4108, -4108,   934,   822,  2644,
     145,  1047, -4108,  2768, 57381,  1954,   170, -4108, -4108, -4108,
   -4108, -4108, -4108,   803, -4108,  2617, -4108,  2624,  2062,  2613,
   11975,   192,  2613,  2833,   239,   239, 17231,  3097,  1959, 12632,
    2013, 12632,  2013,  2613,  2613,  2613, -4108, 17231,  2625, 17231,
   17231, -4108,  2960,   456,  2609,  1164, 57381, 25598,   747, -4108,
   -4108, -4108, -4108,   800, 45951,   125, 25598, 48491,  2626, -4108,
   -4108, -4108, -4108, -4108, -4108,  -130, -4108, -4108,  3814, 25598,
    2717,  2719,  2720, -4108, 31972, -4108, -4108, -4108, -4108, 31972,
     -24, -4108, 57381, -4108,  2710, -4108, -4108, -4108,  -237, 23674,
   23674, -4108, 23674, -4108, -4108, -4108, -4108, -4108,   404, -4108,
   -4108, -4108, -4108,    41,   278,  3753,  2659, -4108, -4108, -4108,
   -4108, 33244,   456, -4108, 25598, -4108,  3057,   653, 25598,  2640,
   -4108,  2643, -4108, -4108, -4108, -4108, -4108,  2750,  2755, -4108,
    3289, -4108, 11975,  -130, -4108, 45951, 45951, 25598, 25598,    50,
   -4108,  2106,  2654, -4108, -4108,  3297, -4108,  3942, 19202, 45316,
    3100,  3113, -4108,  2661, 23674, 23674, 23674, -4108, -4108, -4108,
   -4108, -4108,  1358,   456, -4108,  2657, -4108, 47221, -4108,   456,
     800,  2664,  2666, -4108, -4108,  3051,   583, -4108,  2678,  2683,
   -4108,  2676,  2686,  2692, 52936, 11975, -4108,   781, -4108, -4108,
     800, -4108, -4108, -4108, 17231,  1734, -4108,   456, -4108, -4108,
    -130,  3144, -4108,   456,  2698, 57381, -4108, -4108, -4108, -4108,
   -4108, -4108, -4108, -4108, -4108, -4108, -4108, -4108, -4108,  3178,
   -4108,  2884,   579, -4108, -4108, -4108, -4108, -4108, -4108, -4108,
       1, -4108, -4108, -4108, -4108, -4108, -4108, -4108,  2939,  2610,
    2286,  2894, -4108,     1,   190, 25598,     1,     1,   456, -4108,
   -4108, -4108, -4108, -4108,  2704, -4108,  2766, -4108, -4108, -4108,
   -4108, 57381,  3268,  2871, -4108,  2712, -4108, -4108, 25598, -4108,
    2721, -4108,  3180,  3331,  2610, -4108, -4108,  3184, 57381, 57381,
    1491, 57381, 57381, -4108, -4108, -4108,   800,   800,  3031, -4108,
    -130,  2860,  2872,  2875,  2876,  2878,  2903, -4108, -4108,  -130,
    -130, -4108, -4108,   800, -4108,  1677, -4108, -4108, -4108, -4108,
    -130,  -130,  -130,  -130,  3054,  -130,  -130,  1792, -4108, -4108,
     800,   800, -4108,  1895, -4108, -4108, -4108, -4108, -4108, -4108,
   -4108,  1093, -4108,  3858,   195, -4108,  2955, -4108, -4108, -4108,
   25598,  3208, -4108, -4108, -4108, -4108, -4108, -4108, -4108, -4108,
   -4108, -4108,  2754, -4108, -4108, 11975,  3242,  3248,  3250,  3251,
    3252,  3253,  3255,  3256,  3262,  3263,  3264,  3266,  3270,  3271,
    3276,  3277,  3283,  3295,  3296,  3298,  3300,  2812, -4108, -4108,
   -4108, -4108, -4108, -4108,   153,   800,   800,   800,   800, -4108,
    2257, -4108, -4108, -4108, -4108, -4108, -4108, -4108, -4108, 40871,
   -4108, 48491,  3147,   160,  1095, -4108, -4108, 48491, -4108,  1205,
    3087,  3094,  3096, 57381,  2861, -4108, 33879, -4108, -4108,   778,
   -4108,  2810, 14603, -4108,  2820, -4108, 11975, -4108, -4108, -4108,
     551, 11975, 11975,  3316,  2770, -4108, 47856, -4108, -4108, -4108,
   11975, -4108, 11975, -4108, 11975, 11975, 11975, 11975, 47856,  2770,
   11975, -4108,  2832, -4108,  3238,  3240, -4108, -4108, -4108, -4108,
   11975, -4108, 11975, 11975, -4108, 11975, 11975, 11975, 11975, -4108,
   11975, -4108, -4108, 17231, -4108,  2830,  2838, -4108, -4108, -4108,
    2839, -4108, 11975, -4108, -4108, -4108, -4108, -4108, -4108, 11975,
   -4108, 11975, -4108, 11975, 11975, -4108, 11975, 11975, -4108, -4108,
   -4108, 15260, 11975, 11975,  2843, -4108, -4108, 11975, 11975, 11975,
   -4108, 11975,  1257, 11975,  1784, 11975,  2081, 11975, -4108, 11975,
   -4108, -4108, -4108, -4108, 11975,   363,  2750,  3054,  2845, -4108,
    1796, -4108, -4108,  2278, -4108,   934,  2847, -4108, -4108,  1556,
   -4108, -4108, 48491, 11975, -4108, -4108, -4108, -4108, -4108, -4108,
   17231,   367,  2848, 17231, -4108,  2833,  3512,  3512,  2124, 11975,
     192,  2833, 11975,  2849,  2851, -4108, 11975, 57381, -4108, -4108,
   -4108, -4108, 48491, -4108, -4108, -4108, -4108,   125, -4108,  2419,
   -4108, -4108,  2640,   291,  3338,  2857, -4108, -4108, -4108, -4108,
   -4108, -4108,  1809, -4108, 40871,  3498, -4108,  2852, -4108,  2853,
    2941,  2942,  2945, -4108, -4108, -4108, -4108, -4108, -4108, -4108,
   -4108, -4108, -4108, -4108, -4108,  2610,  2106, -4108, -4108,  2867,
   -4108, -4108,  2608,  2958,  2890,  3254,  3445, -4108, -4108, 57381,
   17231, -4108,  3486,  2883,  2885,  3373,  2888,   456, -4108,  2969,
   -4108, -4108, -4108, -4108, -4108, -4108, -4108, -4108,   838, -4108,
   -4108,  2889,  2889, 21118, -4108, -4108, -4108, 57381, -4108, -4108,
    3378, -4108, -4108,  3163, 45951, 40871,  3349,  3354,  3355,   961,
   -4108,   183, -4108,   165,  3305,  2610, -4108,  3358, 49126, -4108,
   34514, -4108, -4108, -4108, -4108,   897,  2996,  2999,   -65, -4108,
   -4108,  3304,  3133, -4108, -4108, -4108,   800,   456, -4108,  2490,
    9347,  2911, 30061, -4108,  1150, -4108,   247, -4108, 43411,  3397,
   43411, 43411, -4108,  3206, -4108, -4108,  3144, -4108,  2659,   190,
   -4108, -4108,   642,  2282, -4108, -4108,   996,  3317,  3321, -4108,
    3194,  1401,  3194, -4108, -4108,   996, 26874,   778,  2729, -4108,
    3054,  3257, -4108, -4108, -4108, 57381, -4108,   389, 57381,  2931,
    -142,  5258, 47221, 44046, -4108, -4108, -4108, -4108,  3467, -4108,
    3470,   930, -4108, -4108,  2682,    11, -4108, -4108, -4108, -4108,
   -4108, -4108, -4108, -4108, -4108, -4108, -4108, -4108, -4108, -4108,
   -4108,  1917,  2682,  2682,   173, -4108,   127, -4108, -4108, -4108,
   -4108,  2671,   800,  3509,  3192,   800,   800,  3509,   800,  3195,
    3196,   800,   800,  3023,  3457,   800,  3339,  3047,  1661,  3342,
     800,  3204, -4108,  3052,  3466,   800,   800,   800,   800,   800,
    3509,  3209,  3561,   800,   800, -4108,   800,  3211,  3214,   180,
    3217,  3218,   800,   800,   800,   800,   163, 57381,   800,   800,
    3219,   800, -4108, -4108,  6057, -4108, -4108, -4108, -4108, -4108,
   -4108,   964, 24318, -4108, -4108, -4108, -4108,   800,     8,  1099,
    3046,   973,  2970, -4108,   360,  2976, 53571,   456,  2979,  3054,
    -130,  -130,  1150,  -130,  3054,  -130,  -130,  -130,  -130,  -130,
    -130,  -130,  3054,  3054,  -130,   872,  1429,  -130,  3054,  4652,
    -130,  2750,  2682,  2682,  1769, -4108, -4108,  3260,  3409,   800,
   -4108,  2075, -4108, -4108, -4108, -4108, -4108, -4108, -4108, -4108,
   -4108,  3071, -4108,   149,   210,   210, -4108, 25598, 25598, 25598,
   -4108,  2984,   778,  2659,  1670,  2659,  2995, -4108, 12632,  1589,
   -4108,   456, 11975,   456,  1850, -4108,  2997,  2997,  2997, -4108,
    3003, -4108, -4108,  2997,  3395,  2997,  3403,  3004,  3006,  1819,
    1490, -4108,  1861,  2145,  1616,  3007,  3010,  1496, -4108, 11975,
   11975,  1618,  1649,   638,  1153,  1157,   373, -4108,  1680,  3424,
   -4108, -4108,  1694,  1698,  1715,  1723,  1168,  1747,  1870, 12632,
    1768,  1298,   489, -4108,  1829,  1185,  1210,  1833, 11975,  1842,
   11975,  1859, 11975,  1898,  1908,  1916,  3012,  3012,   159, -4108,
    3000, -4108, -4108, -4108,  3014, -4108, -4108,  2182,  2278, -4108,
   -4108,  3017, -4108, -4108,  3013,   456,  3019, -4108, -4108, 11975,
   -4108,   205, -4108, -4108, 17231,   544,  3021, -4108,   456, -4108,
   -4108,  3034,  1496, -4108, -4108, -4108, -4108, -4108, -4108, -4108,
    3226, -4108, -4108,  4098, 31972, -4108, 57381,  -218,  3306,  3030,
   35149, 40871, 40871, 40871,  3040, 11975, -4108, -4108,  3318, 25598,
   -4108,  3460, -4108, -4108, -4108, -4108, -4108,  3043,  3045, -4108,
   -4108, -4108,  2833,  3420,  3301, -4108, -4108,  2750, 57381, 45951,
   -4108,  2362, 26874, -4108,  3053, -4108,  3053,  -163,  3048,  1880,
   -4108, -4108, -4108,  3049,  2224,  1894, -4108, 19202,  3508,  2420,
   -4108, 40871, 40871, 40871, -4108,  2659,  2659,   963,  3108,  3459,
   -4108, -4108, -4108, -4108, 54206, -4108, -4108, -4108, -4108,  1201,
   -4108,  3062,  3064,   146,  3286, -4108, -4108, -4108, -4108,  9347,
   -4108, -4108, -4108, -4108, -4108, -4108, -4108, -4108, -4108, -4108,
   -4108, -4108,  2610, -4108, -4108, -4108, -4108, 43411, -4108, -4108,
   -4108, -4108, -4108,     1, -4108,  3553, -4108,  3065,  -235,   822,
   -4108,  2578, -4108, -4108, -4108,  3461,  3194,  3194,   996,  3463,
    1202,  3069, -4108,   800, -4108,  2185, -4108,  2362, -4108, -4108,
   11975,  3265,  3072, -4108, -4108,   113, -4108, -4108,   974, 25598,
   19842, -4108, -4108,  3332, -4108,  3095, -4108, -4108, -4108, -4108,
   -4108, -4108, -4108, -4108, -4108, -4108, -4108, -4108, -4108, -4108,
   -4108, -4108, -4108, -4108, -4108,  1093, -4108, -4108, 27512,  1491,
   -4108,   230, -4108,  1491, -4108,  1548,  1548,  1491, 54841, 27512,
    1221,  1150,  3054,  1585,  3054, 55476,  1221,  -130,  -130,  2236,
     800,  3054, -4108, -4108,  3468,  1585,  3471,  1585,  1585, -4108,
   48491, 57381, -4108,   800,  1306,  3054, 56111,  1150,  1150,  1585,
    1221, 26874,  2558,  2649, -4108,  -130,  1221, -4108, -4108, -4108,
   -4108, 25598,  1221,  1221,  2059,  2797,  2981,  3055, -4108, -4108,
   -4108,  3054,  2649, 55476, -4108, -4108,  6988, -4108, -4108, -4108,
   20480, 57381,  1068,   206, -4108,  3074, 38331,  3319, -4108, 11975,
   11975,  3375, 57381,  3379, -4108,  3666, 57381,  3734, -4108,   142,
   -4108, 55476, -4108,  3102, -4108,  3105, -4108,  3054, -4108, -4108,
   -4108, -4108, -4108, -4108, -4108, -4108, -4108, -4108, -4108, -4108,
   -4108, -4108, -4108, -4108, -4108, -4108, -4108, -4108, -4108, -4108,
   -4108, -4108, -4108, -4108, -4108, -4108,  3109, 57381,  2682,   160,
   -4108, -4108, -4108, -4108,  -130, -4108, -4108, -4108, -4108, -4108,
   -4108, -4108, -4108, 33879,  2659,  3377, -4108, -4108,  3512, -4108,
     456, 11975,  1004, -4108, -4108,   176, -4108,  1465, -4108, -4108,
   -4108,  3111, -4108, -4108, -4108, -4108, -4108, -4108, -4108,  3093,
   -4108, -4108,  2770, -4108, -4108, -4108,  3107,  3512,  3512, -4108,
   -4108,  3717,  3282, 11975, 11975, -4108, 11975, -4108,   907,  3117,
    3142, -4108, -4108, -4108, -4108, 11975, -4108, -4108,  3512, -4108,
   11975, -4108, -4108, 11975, -4108, 11975, 11975, -4108,  1926, -4108,
    1930, -4108,  1936, -4108, -4108, -4108,  2750,  3122,  3504, -4108,
   -4108, -4108,  2750,  3312, -4108, -4108,  2750,  3054,  2488, -4108,
   -4108,   933, 57381, -4108, -4108,  1899, -4108, -4108, 11975, -4108,
   49126, -4108, -4108,  3603,  3499, -4108, -4108, -4108, -4108, -4108,
   -4108, -4108, -4108, -4108, -4108, -4108, -4108, -4108, -4108, -4108,
   -4108,  3575, -4108, -4108, -4108, -4108,  -121,  -121,  -121, 15917,
     456,  3634, -4108, -4108, -4108,  3460,  3518, -4108,    69, -4108,
   57381,  3135,  1534, -4108,  1913, -4108, -4108,  3136, -4108,  2182,
    3137, -4108,   800, 15917,  2889,  3309, -4108, -4108,  -163, 26874,
   34514, -4108, -4108, 57381, -4108, 40871,  2661,  2661,  2661,  2610,
    3583,  2958,  2958, -4108, 30698, -4108, -4108,  3302, -4108, -4108,
   35784, -4108, -4108, -4108, -4108, -4108, -4108, 30061, 52936, -4108,
   -4108,  2610, -4108,  -130,  2050,  1556,  2740, -4108,   778, -4108,
     996,  3540,  3542, -4108,   996, -4108, -4108, 26874,  2659, 15917,
   -4108,  2182,   456,  3148,   975,   974, -4108, -4108, -4108, -4108,
    3430,  3433, 57381, -4108, -4108, -4108, -4108,  3299, -4108, 25598,
    3158,  3160,  3162, -4108, -4108, -4108,   249, -4108,  5180, -4108,
   -4108, -4108, -4108,  1221,  3170,  3562,  3567,  1548, -4108,  1491,
   27512, -4108, -4108,  1491,  1491, -4108, -4108, -4108,   775, 55476,
   -4108, -4108, 27512, -4108, -4108, -4108,  3169, -4108, -4108,  2750,
   -4108, -4108, 44046,  -130, -4108,  1585, 57381, -4108, 27512, 27512,
   -4108,  3201,  -130, -4108, -4108, -4108, -4108, -4108, -4108, -4108,
   -4108, -4108, 27512, 55476,  3177, -4108,   975, -4108, -4108, -4108,
   -4108, -4108,  1935, -4108, 55476, -4108, -4108, 55476, -4108, -4108,
   -4108, -4108, -4108, -4108, -4108, -4108, -4108, -4108, -4108, -4108,
   -4108, -4108, -4108, -4108, -4108,  3186,  2993,  1297, -4108,  3179,
   -4108, 57381, -4108, -4108, 25598, -4108, -4108, -4108,  6770, 57381,
   -4108, -4108, -4108, -4108, -4108,   456,  3512,  3765, -4108, -4108,
    3350,  -130,  3705, -4108,  1933, -4108, -4108, -4108,  3617,  3205,
   -4108, 53571,  1947, -4108, -4108,  1917, -4108, -4108, -4108, -4108,
    3207,  3210,  3213,  2810, -4108,  3584,  1107,   456,  3222,  3223,
    3227,  3228,  3826,   185, -4108,  3831, 47856, -4108, -4108, -4108,
    1976,  3501, -4108, -4108, -4108,  2997, -4108,  3003, -4108, -4108,
   -4108,  3811, -4108, -4108,  2997,  3633,   176, -4108, -4108,  3232,
   -4108,  3234,  3235, -4108,   158,  3239,  1950,  1235,  1979,  3554,
    3630, -4108,  3472, -4108,  1973,  1226,  1978,  2003,  2005,  2012,
   -4108, -4108, -4108, -4108, -4108,  3245, -4108, -4108,   474, -4108,
    3241,  1506,   822, -4108, -4108,  1983, -4108, -4108,  3885,  3521,
    1643,  3278,  3278,  3278,  1734,   456,  2001, -4108, -4108, -4108,
   -4108, -4108, -4108,  3659, -4108, -4108,  3258,  3289, 57381, -4108,
    3301, -4108,  2488, 26874, 15917,  3259,  3272, -4108,   -18, -4108,
   -4108,  3267, -4108, -4108,  2661, -4108,  3863,  3695, -4108, -4108,
   48491,  3275, -4108, -4108,  3578, -4108, -4108, -4108, -4108, -4108,
   -4108, -4108, -4108,  2712,  3493,  3323,   996,   996,  3608,  3324,
   11975,  3273, -4108,  3377, -4108, -4108,   362,  2488, 11975, -4108,
   -4108, -4108,  3414,   947, -4108,  3453,  3280,  3285, -4108, -4108,
    -130,  3281, -4108, -4108, 20480, -4108,  3918, -4108, -4108, 11975,
    1491, -4108, -4108, -4108, -4108,  3291, -4108, -4108,  3810,  3815,
   -4108, -4108,  2535, 57381, -4108,  3063, -4108, 27512,  3169, -4108,
     182,  3389, -4108, -4108, -4108, 26874, -4108, -4108, -4108, 57381,
   -4108, 25598, -4108, -4108,  3310, -4108,  2997,  2997,  2997, -4108,
   -4108,  2997, -4108,  3003,  3536, -4108,  3003,  3003, -4108, -4108,
   -4108, -4108, -4108,   176,   442, -4108, -4108,   176, -4108, -4108,
   -4108,   130,  1302,  3003, -4108, -4108, -4108, -4108, -4108, -4108,
   -4108,  2997,  2997,  2997, -4108, -4108,   176,  2997, -4108,  2997,
   -4108,  2986, -4108,   214,   115,  2997,  2997,  2997,  3111,  3290,
   -4108, -4108, -4108, -4108, -4108, -4108, 57381, -4108,  1039, 57381,
     151, -4108, -4108, -4108,  3054,  2031, 57381, 57381, 57381, 44681,
   -4108, -4108, -4108, -4108, -4108, -4108, -4108, -4108, -4108, 47856,
   -4108,  3914,  3582,  3303, -4108, -4108, -4108, -4108, -4108, -4108,
   -4108, -4108, -4108, 11975, -4108, -4108, -4108, 11975, -4108, -4108,
    3614,  3777, -4108, -4108, -4108, -4108, -4108, -4108,  3311, -4108,
    3054,   165,   165, -4108, -4108, -4108,  3823, -4108, -4108,  3401,
    3404, -4108, -4108,  3406, -4108, -4108,   140,  1879, -4108, -4108,
   -4108, -4108, 15917,  3707,  3415, -4108, -4108,  3320,  3365, -4108,
   -4108,  1506, -4108, -4108, -4108, -4108, 11975, -4108,  3377,  2236,
   -4108, 30698, -4108,   933, -4108,  3371, -4108, -4108, -4108,  3372,
     456, 57381,  3584, -4108,   392,  1506,   975,  -130, -4108, -4108,
   -4108,  3329,  3333, -4108, -4108, -4108,  1099, -4108, 57381,  6770,
   -4108, -4108,   -18,  6057, -4108, -4108,  1162,   672,  2021,  3343,
    3344, 57381,  3345,  3347, -4108,  3537, 27512, -4108, -4108, -4108,
   -4108, -4108, 25598,  6770,  1221, -4108, -4108,  3169,   838,  3337,
   57381,  3669, -4108, -4108, -4108, -4108,  1139, -4108,  3351,  1139,
    1139, -4108,  2353, -4108,  3374,   176, -4108, -4108,  3385, -4108,
   -4108, -4108,  1139,  3352,   176, -4108, -4108, -4108, -4108,  1139,
   -4108, 48491,  -130,  3081,  3991, -4108,  3410, -4108,  3875,  3747,
    3992, -4108,  2764, -4108,  3751,  3646,   800, -4108,   176, -4108,
   -4108,  3914, -4108,   176,  3914,  1139,  1139, 57381,  3488, -4108,
   63731, -4108, -4108,  -156,  3393,  2041, -4108, -4108, -4108, -4108,
   -4108, -4108,  2068,   975,  3382,  2079,  2101,  3850,  3556,  3563,
   -4108, -4108,  3386,  3388,   975,  2030, -4108, -4108, -4108,  3387,
   -4108, -4108,  3965, -4108, -4108, -4108, -4108,   267,  3661,  3054,
    3054,  3054,  -101,  1879, -4108, -4108,  3444, 25598, 17231,  3503,
   57381,   141,  2777, -4108,  1136,   975, 11975,  2610, 44046, -4108,
   -4108, -4108, 11975,  3398, 11975,  3399,  2131, -4108, -4108, -4108,
    1548,  1548, -4108,   392, -4108, -4108, -4108, -4108,  1706, 57381,
   25598,  3375,  3591, -4108,  3063, -4108, -4108,  3332,  3309, -4108,
    2750,  3301, -4108, -4108, 57381, 57381,  2149, 57381, 57381,  2717,
    2719,  2720,  1429,  1429, -4108, -4108,  1068, -4108, -4108, -4108,
    3808, -4108, -4108,  2154, -4108,  1167,  3683, -4108, -4108, -4108,
   -4108,  1139, -4108,   158, -4108, -4108, -4108, -4108, -4108,   158,
   -4108, -4108, -4108, -4108,  3407, -4108, -4108, -4108,  3697,  3454,
   -4108, -4108, -4108, -4108, -4108, 38966, -4108, -4108, -4108, -4108,
   -4108, -4108, -4108, 11975,  3915,  3456, 57381,   760, -4108, 65001,
   65001, 57381, -4108, -4108, -4108, -4108,  6296, -4108, -4108,   769,
   -4108, -4108, -4108, -4108, -4108, -4108, -4108, -4108, -4108, -4108,
   -4108,  4047, -4108,  3422, -4108, -4108,  3431,   235, -4108, -4108,
   57381, 56746,  1299, 57381, -4108,  3716,   172,  1522, -4108,  3911,
    2182, -4108, -4108, 11975, -4108, -4108, -4108, -4108, -4108, -4108,
   -4108, -4108, -4108, -4108,    61, -4108, -4108, 26874,  2729, -4108,
    2750, -4108,  2168, -4108, -4108, -4108,  3525,   800,   800,  3950,
    3952,   800,   800,   800,   800,  3443,  2777, -4108,  3934, -4108,
   -4108, 11975, -4108, -4108,   456,  3681, -4108,  4026,   822,   456,
   57381,   456, 57381, -4108,  3906,  3906, -4108, -4108, -4108,  6770,
    3909,   973, -4108, -4108, -4108,   249,  3458,  2224, -4108,  2174,
    2180,  2200, -4108,  2207,  2211, -4108, -4108, -4108, -4108,  1068,
    3455, -4108, 57381, -4108, -4108, -4108,   246, -4108, -4108,  2243,
   -4108,  2254,  2153, -4108,  3407, -4108,  3462, -4108, -4108, -4108,
   -4108,   456, 11975, -4108, 11975,  3483, -4108, -4108,  3912, 57381,
   -4108, -4108, -4108, -4108, 11975, -4108, 63731, 63731, -4108, -4108,
   -4108, -4108,  4081,   -18,  4051,  3736,  4052, -4108, -4108,  2268,
   -4108, -4108,  -130,   800, -4108,  1299, -4108, -4108, -4108,   800,
     975,  3476,  3724, -4108,   172, -4108, -4108, -4108,  1522, -4108,
   -4108, -4108,  2488,   975, -4108, -4108,  3469, -4108,   800, -4108,
    3477, -4108, -4108, 57381,  3480, -4108,  -130,  -130,   800,   800,
    3140,  3140,  2750, 48491,  3577, -4108, -4108,   800,   975, 57381,
   -4108,  1108,  3846, -4108,  2270,  2281,  1396, -4108, -4108,  3411,
   -4108, -4108,  3666,  6770, -4108, -4108, -4108, -4108,  3699, -4108,
    1299, -4108, -4108, -4108,  3301, -4108,   984,   984,   176,   158,
     176, -4108,  3485, -4108, -4108,   456,   456, -4108,   219, -4108,
   -4108,  3891,  3982, 11975,   456, 60556,  3484, -4108, -4108, -4108,
   -4108, -4108, -4108, -4108, -4108, -4108, -4108, -4108, -4108, -4108,
   64366, 11975, -4108,   769,  4047, -4108,  3763, -4108,  3766, -4108,
   56746, -4108,  3054,   931, -4108, 39601, -4108, -4108,  1675,   931,
   -4108,   931, -4108, -4108, 26874, 15917,  2236, -4108,  3503, -4108,
    3495, -4108, -4108,   719, -4108, -4108,  -130,  -130, -4108, -4108,
   -4108, -4108, -4108,  2289, -4108, 48491, -4108, -4108,  4101,  4105,
    3997,  4108,  1108, -4108,  -133, -4108, -4108, -4108,  4109, -4108,
    4110,  3507,  3510, -4108, -4108, -4108,  4022, 63731, -4108,  4015,
   -4108,   -18, -4108,  1299, -4108,   172,  1522,  2292, -4108,  4161,
   -4108,   915,  3791,  3793, -4108, -4108, -4108, -4108,  3517,  3545,
   11975, 63731, -4108,  4013, -4108,  3945,  2175,  3883,  3522, -4108,
    3520,  2234,  4054, 65001, 65001, -4108, -4108, -4108, -4108, -4108,
    3900,  4175, -4108, -4108, -4108, -4108, -4108, -4108, -4108, -4108,
   -4108, -4108, -4108, -4108,  2294, -4108, 16574, -4108, -4108, -4108,
   -4108, -4108, 48491, -4108,  3577, -4108,  3535,   158,   158,  4140,
     158, -4108,  4141,  4146,  -133, -4108, -4108, -4108, 53571, 53571,
   -4108, -4108,  4043, -4108, -4108, -4108, -4108, -4108, -4108, -4108,
   -4108, -4108, -4108,  3598,  4066,   840, -4108,   241, -4108,   456,
   61191,  4148, 57381, -4108, -4108, -4108, -4108, 11975, -4108, 49761,
   61826,  3546, -4108, -4108, -4108, -4108, -4108,  3730, -4108,  3495,
   -4108,  3551, -4108,  2833,  2777, -4108, -4108,  3555, -4108, -4108,
     158, -4108,   158,   158, -4108,  3558,  2296,  3731, -4108,  3411,
     984,   984, -4108, -4108,   110, 11975, -4108,  4048,  3644, -4108,
    3560, -4108, 63731,  2251, 63731, -4108, -4108,  4000,  3564,  1704,
   -4108,  3559, -4108,  3985,  4026, -4108, 16574,  3566, -4108, 11975,
    3569,  3571, -4108, -4108, -4108, -4108, -4108, -4108, -4108, 63731,
   -4108, -4108,  -130,  3958, -4108,   110, -4108,   456,  4169, 63731,
   57381, 58651,  3774, 62461,  4031, 57381,  6770,  4032,  4033, -4108,
    4183,  3846, -4108, -4108,   456, -4108, -4108, 63731, -4108, -4108,
   -4108, -4108,  3667, -4108, 59286, -4108,  2548, -4108,  3612, -4108,
   -4108,  4114,  3001, -4108,   158,  4002, -4108, -4108, -4108, 63731,
   63731, -4108, -4108, -4108, 37696, 11975, -4108, -4108, -4108, -4108,
   -4108,   961, -4108,  3872,  3595, 59921, 63096, -4108, -4108, -4108,
   32609, -4108, -4108, -4108,  4061, -4108,   456, -4108,    28, 21756,
    3756, 37696, -4108, -4108, -4108, -4108, -4108, -4108, 48491,  2311,
   -4108, -4108, 26874, -4108, -4108, -4108, -4108, 24958,  3597, -4108,
     800, -4108, 26874, -4108, -4108, 15917, -4108, -4108
};

/* YYPGOTO[NTERM-NUM].  */
static const yytype_int16 yypgoto[] =
{
   -4108, -4108, -4108, -4108, -4108,    94, -4108, -4108, -4108, -4108,
   -4108, -4108, -4108, -4108,  1904, -4108, -4108, -4108, -4108, -4108,
    1598, -4108,   480, -2355,  -491,  3279, -4108, -4108, -4108, -4108,
   -4108, -4108, -4108, -4108, -4108, -4108, -4108,   764,  1709,  3244,
   -4108,   369, -4108,    21, -4108, -4108, -4108, -2961,  -107,  -307,
   -4108, -4108,   347,    29,  3220,  -306, -4107, -4108, -4108, -4108,
   -4108, -4108, -4108, -4108, -4108, -4108,   385,   384, -4108, -4108,
     215, -4108, -4108, -2535, -4108, -4108, -4108, -4108, -4108, -4108,
   -4108, -4108,  -477,  -437,  1831, -4108, -4108, -4108,  4238, -4108,
    3689, -4108, -1802,  2361, -4108, -4108, -4108, -4108, -4108,  2430,
   -1730, -4108, -4108, -4108,  1466, -4108, -4108, -4108,  -365,   305,
   -4108,   307, -4108,   309, -4108,   310, -4108,   311,   312,   313,
     315, -4108,   321, -4108, -4108,  -419, -4108, -4108, -4108, -4108,
     323, -4108, -4108, -4108, -4108, -4108, -4108, -4108,  -282, -4108,
   -4108,   -92, -4108, -4108,  -279,   329, -4108,  -213,   332, -4108,
     333, -4108,  -109, -4108,  -104, -4108, -4108, -4108, -4108, -4108,
   -4108, -4108, -4108, -4108, -4108, -4108, -4108,  3229, -4108, -4108,
   -4108, -2343, -4108, -4108, -2436,  2756, -4108, -1869, -4108, -4108,
   -1961, -4108, -4108, -1661,  1002, -4108, -4108,  1079,   327, -4108,
   -1369, -1950, -1892, -4108, -4108, -4108, -2043, -2037,  -787,  2503,
   -1216, -2389, -4108, -4108, -4108, -4108,    81, -4108, -4108,   257,
    1708,  2227, -4108, -2521, -4108, -4108,   895, -4108, -4108,  1492,
     734,  1486, -4108,  1063,  2983, -1258, -4108, -4108, -4108, -4108,
   -4108, -4108,     0,   316,  -102, -4108, -3811,   748, -4108, -4108,
   -4108, -4108, -4108, -4108, -4108, -4108, -3215, -4108, -4108, -4108,
    -302, -4108, -4108,  -198, -4108, -4108,  -265, -4108,   143, -2375,
   -4108, -4108, -4108, -4108,  2749, -1387, -4108,  3738, -4108,  -495,
   -4108,   468,  1749, -2721, -1984, -4108,  -943,  -931, -2935, -4108,
   -4108, -4108, -2071,  1020,  1309, -4108,   702,  1750, -2437, -4108,
   -4108, -4108, -4108, -4108,  1310, -4108, -4108,   476, -4108,   461,
   -4108, -4108, -4108, -4108, -4108,  -292, -4108,    -7, -3257, -4108,
   -4108, -4108, -2972,  1229,   661, -4108, -4108, -4108, -1467, -2993,
   -1224, -4108,   289, -2446, -2512,   633, -4108, -4108,   430, -3792,
   -4108,  -578, -2153, -2444,   -52, -4108, -4108,   445, -3444,  1871,
   -4108, -4108, -4108, -3389, -3470,  1631, -4108, -4108,  1187, -4108,
   -1257,  1188, -4108, -4108, -4108,  1193, -4108,    25, -4108, -4108,
   -4108, -4108, -3187, -4108, -4108, -1583, -2738, -4108, -4108,  4404,
    4406, -1566, -3124, -4062,   -87,   -86, -4108, -4108, -4108,  2232,
   -2092,    97,    86,    98,  1733,  -830,   248,  1043, -1729, -4108,
     317, -4108, -4108, -4108, -4108, -4108, -4108, -4108, -4108, -4108,
   -4108, -4108, -4108, -4108, -4108, -4108, -4108, -4108,  1806, -1342,
   -4108, -4108, -4108, -4108, -4108, -4108, -4108, -2406, -2903, -4108,
   -4108,  1372, -4108, -4108, -4108, -2299, -2080, -2075, -2428,  3425,
   -4108, -4108, -4108, -4108,  3376, -2258, -2929, -4108, -4108, -4108,
   -4108, -4108, -4108, -4108,  2932,  1317, -4108, -4108,  1952, -4108,
   -4108, -4108, -4108, -4108, -4108, -4108,   527,  2028, -4108, -4108,
   -4108, -4108,  2340, -4108, -4108, -4108, -4108, -4108, -4108, -4108,
   -4108,    17, -4108, -4108, -4108,   772,  2846, -4108, -4108, -4108,
      -9, -4108, -4108, -4108, -4108,  2551, -4108, -4108, -4108, -4108,
    2874, -4108, -4108, -4108, -4108, -4108, -4108,  1627, -4108,  2065,
   -4108, -1539, -4108, -4108,  1195, -1037,  2022,  -614,  2157,   481,
   -4108,  3855, -4108, -4108, -4108, -1685, -1714, -4108,  3538,  -899,
   -2679,  2534,  -570, -1928,  1237,   194,  1897,   506,  4004, -4108,
   -1153, -1181, -4108, -4108,  -668, -4108, -4108, -4108, -4108, -4108,
    2255,  2260,  -627, -4108, -4108, -4108, -4108, -4108, -4108, -4108,
   -4108, -4108, -4108, -4108,  1671, -4108, -4108, -4108, -4108, -1227,
   -4108, -4108, -4108, -4108, -4108, -4108, -4108,  1452, -4108, -2102,
   -4108, -4108,  -455, -4108,  3314, -4108, -4108, -4108, -2368, -1983,
    1967,  1147, -4108, -4108, -4108, -4108, -4108, -4108, -4108,  1980,
   -4108, -1608, -4108, -2809, -4108, -4108, -4108, -4108, -4108,  2173,
   -4108, -4108, -4108, -4108, -4108, -4108, -4108, -1732, -4108, -2033,
     245, -4108,   423, -4108, -4108, -4108, -4108, -4108, -4108, -4108,
     -83,   991,   -81, -2957, -1105,  1763, -4108, -4108, -1318,  3359,
   -2373, -4108, -4108, -4108,  2156, -4108, -4108, -4108, -4108, -4108,
     788, -2995,  2972, -4108, -4108, -3142,  -958, -2339,  -929, -4108,
   -1422,  1572,   621, -4108, -1903, -1120, -1747, -2966, -2458, -4108,
    1442, -4108, -4108, -4108, -4108,  -201, -4108, -4108, -4108,   635,
    2053, -4108, -4108, -4108, -4108, -4108, -4108, -4108, -4108, -4108,
   -4108,  -522,  -906, -4108, -4108,  2315,  -496, -4108,  3473, -4108,
   -4108,  3474, -4108, -4108, -4108, -4108,  3157,  3128,  2115, -4108,
   -4108, -2387, -4108, -4108,  2080, -4108,   900,  -937,  1223,  1222,
   -4108, -4108,  1225, -3259, -4108, -4108,  3478, -4108, -4108, -4108,
    1173, -4108,    67,  3913,  3482, -4108, -4108, -4108, -4108, -4108,
   -4108, -4108, -4108,  2891, -1079,  3841, -4108, -4108, -4108, -4108,
   -4108, -4108,  2508, -4108, -4108, -4108, -4108, -4108, -4108,  3068,
    3933,  -595, -1361, -4108,  -771,  2510,  2037,  -897, -4108, -4108,
   -4108, -4108,  3937, -4108, -4108, -4108, -4108, -4108, -4108, -4108,
   -4108, -4108, -4108,  2688,   827, -4108, -4108, -4108, -4108,  3150,
   -4108, -4108, -4108, -4108, -4108, -4108, -4108, -4108, -4108, -4108,
   -4108, -4108, -4108, -4108, -4108, -4108, -4108, -4108, -4108, -4108,
   -4108,  1263,  -122, -4108,    62,  -158, -4108,   -29, -4108, -4108,
   -4108, -4108, -4108,  -231, -4108, -4108,  -234, -4108, -1018,  3769,
   -1410,   584, -1286, -2570, -4108,  1252,  3138, -3396,  -692, -1203,
   -1214, -2710,    91, -4108, -4108,  3657,    87,   575,  -337,    -6,
   -3147,  -103,  -608,  -616,  -770, -4108, -3000, -4108, -4108, -4108,
   -4108, -4108, -4108, -4108, -4108,  2073, -4108, -4108, -4108,  1228,
   -4108,  3962, -4108,  2778,  1234,  3970, -1392,  2600,  2097,  2099,
   -4108, -4108,  2109, -1991, -4108, -4108,   166, -4108,  2673, -4108,
   -4108, -4108, -4108, -4108, -4108, -4108, -4108, -4108, -4108, -4108,
   -4108, -4108, -4108, -4108, -4108, -4108,  3745,  -453,  -458,  3168,
    3988,  3662, -4108,  3237, -4108, -4108, -4108, -4108, -4108,   555,
   -4108,   831,  2139, -1250, -2345, -4108, -4108,  2961,   504, -4108,
    1758,  -291,  -607, -4108, -4108,   554, -4108, -4108,  1561,  3998,
    3663, -4108, -4108, -4108, -4108, -4108, -2777,  -918, -4108, -3482,
   -2839, -1746, -4108, -4108, -2201, -3079, -4108, -4108, -1053, -4108,
   -4108, -4108, -4108, -1971, -4108, -4108, -4108,    -4,  3963,  3964,
    3966, -4108,  -795, -4108, -4108, -4108, -4108, -4108, -4108, -4108,
    3557, -4108, -4108, -4108, -4108,  3565, -4108, -4108, -4108, -4108,
   -4108,  3568, -4108, -4108, -4108, -4108, -4108,  1692, -4108, -4108,
   -4108, -4108, -4108, -4108, -4108, -4108, -4108
};

/* YYTABLE[YYPACT[STATE-NUM]].  What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule which
   number is the opposite.  If zero, do what YYDEFACT says.
   If YYTABLE_NINF, syntax error.  */
#define YYTABLE_NINF -2762
static const yytype_int16 yytable[] =
{
     515,  1098,   999,  1766,  1553,   892,  1031,  1740,  1415,  1429,
    1432,   556,  2132,   555,  1765,  2458,  2459,   563,   952,   995,
    1445,   574,  2195,  1051,  1560,   646,  1673,   577,   582,  1856,
     670,  1050,  2318,  2634,   589,   513,  1495,   592,  2635,  1636,
    1465,  2002,   589,  1897,  1171,  1282,   825,   826,   827,   610,
     829,  1970,   831,  2003,  2129,   833,  2836,   835,  2868,  1717,
    2191,  2192,  1123,  2728,  1286,  1465,  1832,  1798,  1799,  1106,
    1459,  1802,  1803,  1804,  1805,  2735,  1807,  1808,  1810,  1812,
    1813,  1814,  1815,  1816,  3044,   813,  2988,  1788,  1855,  2977,
    3654,   140,  1868,   635,  1796,  3420,  3117,  3301,  1496,  2817,
    3337,   868,  1682,  1565,  2988,  2988,   867,  1516,  3228,  1005,
    3481,  1906,  1012,  2010,   561,  1566,  2892,   638,  2793,   515,
    3488,   515,   645,   651,  2364,  2932,  2441,  2736,  3421,  2624,
     656,  1377,   922,  2023,  3000,  1265,  3865,   867,  2941,  3343,
    2687,  2026,  2027,  1087,  1090,  3009,  2688,  2950,  2936,  3013,
    3515,  3980,  3582,  2100,   640,  3496,   642,  3809,  4026,  1345,
    3028,  2569,  1232,  1233,  3997,  1223,  1224,  1225,  3532,  3132,
    1345,  1589,  3039,  2992,  2993,   522,  2065,  1266,  2354,   667,
    3219,  1339,  2184,  1111,  1112,  1113,  2100,  1232,  1233,  1901,
     634,  2557,  3948,  4682,  1912,   573,  1018,  3546,  3522,  2100,
    3048,   599,   581, -2561,  2087,  3155,  3156,  3797,  1491,  2675,
    1562,  3162,  3523,  3164,  2988,  2988,  2705,  1232,  1233,  2570,
     867,  3761,  1562,  2996,  1600,  1497,  3524,  1470,  1232,  1233,
    3323,  2305,  2423,  2684,  2565,  2354,  3522,   961,   942,  1604,
    -934,  1539,  1547,  2165,  2211,  3130,   961,   942,  2172,  3357,
    3523,  3919,  -572,  2083,  3379,  4322,  1817,  2454,  3135, -2713,
    1232,  1233,  3886,  1448,  3524,  1267,  1869,  3685,  3394,  4203,
    4259,  3384,  4494,   884,  3160,   961,   942,  1448,  1267,  1232,
    1233,  1586,  2638,  3123,  3124,  1562, -2083,  1354,  3382,  4314,
     874,  2685,  1533,  1992,  3706,  3384,  3220, -2637,   602,  3398,
    4315, -1599, -2643,   657,  3601,  1346,  1510,  4764,  3058,   569,
    1358,  1232,  1233,  1232,  1233,  -573,  1346,  2519, -2561,  1067,
    1523,  1006,  2429,  2968,   681,  1534,  1018, -2481,  4504,   619,
    3145,  4011,  3147,  3839,  2885,  3590,  1232,  1233,  1639,   908,
    1289,  2117,  2789,  2679,  3941,  3946,  3049,  2368,  3947,  1476,
    1639,  2079,  4344,  1993,   566,  3863,  1463,  2089,   139,  3358,
    3335,  1605,  2888,  2333,  1151,  1606,  2903,  3957, -2713,  2083,
    1232,  1233,  3077,  3088,  3979,  4521,  1607,   867,  1829,  1019,
    1020,  1618,  4396,   682,  1232,  1233,  1249,  2904,   590,  1466,
    1232,  1233,  2216,  2375,  4215,  4572,   519,  4521,  2963,  2776,
     520,  2178,  2083,   273,  2784,   275,  1619,  2060,  1232,  1233,
    -578,  -476,  3261,   626,  4216,  2083,  2923,  4014,  1624,  3336,
    4076,  2964,  3078,  2905,  2546,  2777,  3385,   674,  3136,  4573,
     570,  4345,  1073,   139,  4323,  3089,  2061,  1624,  2217,  1269,
   -2562,  4586,  2282,  1467, -1599,  1232,  1233,   580,  2101,  2431,
    2432,  2889,   909,  2369,  1152,  1372,   865,  4380,   567,   523,
    2118,   877,  1681,  1068,  3522,  2053,  1537,  1545,  2886,  1601,
    4045,  1640,  1336,  1232,  1233,  1818,  1171,  2424,  3523,  2949,
    3296,  2101,  1870,  1662,  3601,  2306,  1535,   865,  2819,  2911,
    3295,  1828,  3524,  3059,  2101,  3219,  1490,   620,  1819,  1965,
    2050, -2481,  4765,   961,  3942,  2080,  1232,  1233,  1608,  1019,
    1020,  4137,  3309,  3310,  4139,  1359,   683,  1492,  4316,   661,
    1007,  2166,  1524,  3602,   645,  3840,   651,  1829, -2761,   910,
    1234,  3645,  4494,  1235,  1624,  3649,  3306,  3307,  3308,  1994,
    1829,  1232,  1233,   651,  1552,  4204,   139, -2113,  1500,   990,
     139,  1232,  1233,   645,   872, -2562,  4116, -1559,   645,  3910,
     882,  1232,  1233,  1511,  1864,  4120,   885,   876,  1232,  1233,
     865,  2005,  2476,   900,  2008,  1793, -2637,  1413,  2011,  1268,
    2014, -1599,  1252,  4507,   645,  1234,  2355,  4058,  1235,  4136,
     953,  4500,  1268,  4035,  4138,  3370,  1234, -1559, -2264,  1235,
    1014,  2055, -2290, -2409,  1706,   664,  1609,  1707,  2029,  2030,
    3612,  3220,  1832,  1232,  1233,  1449,  2569,  2958,  2988,  1034,
    1565,  1871,  1355,  1857,  1801,  2335,  3221,  4059,  1234,  1449,
    4254,  1235,  1566,   645,  1830,  1056,  2338,  1931,  2687,  2341,
    2624,  1822,  1856,  2355,  2688,  3474,  3386,  1234,   515,  3682,
    1235,   875,  3380,   635,   883,  1085,  2425,  3677,  3882,   635,
     635,  1950,  1820,  2498,  1099,  1056,  3761,   645,  2039, -2561,
    2988,   645,  3657,  1565,  2570,  2639,  1650,  1651,  1118,  1234,
    3382,  1234,  1235,  1072,  1235,  1566,  1340,   664,  3137,  1471,
     664,   600,  3691,  3508,  1015,  2994,  2160,  1602,   990,  1534,
   -2561,  1855,  1705,  3602,  1234,  1602,  4683,  1235,  3699,  3700,
    1718,   990,  1720,  3125,  3359,  2212,  2087,  1232,  1233,  3144,
     836,  1021,  3703,  2297,  1733,  1734,  1735,   865,  1281,  2025,
    1172,  2684,  1739,  3324,  1106,   924,  1913,  -934,  1234,  3507,
     890,  1235,  2568,  3834,  4065,  3949,  3098,  2332,   903,  -572,
    1082,  3103,  1234,  2185,  3050,  1235,  2063,  3133,  1234,  3111,
    3112,  1235,  3944,  2186,   601,  3119,  1835,  1902,  3152,  3525,
   -2643,  3514,  2893,  2940,  1016,  3532,  1234,  2065,  3798,  1235,
    1602,  3622,  2995,  1830,  1236, -1599,  2088,  2411,   603,  2685,
    3918,  1229,  1932,  1231,  4051,  3497,  1830,  4343, -1599, -2643,
    1050,  2172,  4332,  2321,  3998,  3222,  1073,  3525,  2228,  1236,
    3843,  1477,  -573,  1234,  2683,  1846,  1235,  3229,  1274,   515,
    1276,  1277,  1056,   515,   645,   645,  3387,   515,   645,   571,
    2177,  4435,  3977,  1321,  1602,  4368,  2040,  3876,  3877,  1236,
    2041,  1234,  1899,  1430,  1235,  1433,  4407,  4397,  1436,  1441,
    1236,  1211,  1232,  1233,  1275,  2229,  2009,  1452,  1279,  1919,
    1535,  4184,  1284,  2841,  1050,  1462,  2307,  3152,  4596,  2089,
    1350,  2924,  4194,  4047,  1234, -2113,   673,  1235,  1232,  1233,
    3240,   677,  1236,   635,  2990,  1259,  1260,  1261,  1262,  1263,
    1264,  1232,  1233,  1501,   830,   645,   635,  1925,  2283,   834,
     635,  1236, -2761,  4233,  4721,  3101, -2562,  1337,  -476,  1234,
    2955,  3619,  1235,  3341,  3342,  1453,  1773,  1774,  3326,  1234,
    2868,  2820,  1235,  3281,  4056,  3688, -2264,   901, -2620,  1234,
   -2290, -2409,  1235,  1236,  1091,  1236,  1234, -2562, -1921,  1235,
     645,  3221,   645,  2572,  1454,   645,   645,  2404,  1773,  2247,
    2286,  2287,  3559,  2490,  2178,  1232,  1233,  1985,  1236,  4297,
    3624,  2469,   645,  2057,  2058,  2059,  1425,  2690,  3695, -1559,
    3625, -2624,  3644,  2303,  2304,  3653,  3648,  1232,  1233,  3640,
    1361,  1234,  1374,  3114,  1235,   606,  2634,  3920,  2325,  2067,
    4174,  2635,  1236,  1380,  1232,  1233,  3659,  1386,  1101,  4060,
    1232,  1233,  4301,  4302,  1314,  3027,  1236,   635,  2202,  4514,
    3698,  4516,  1236,  2465,  1934,   896,  1106,  1232,  1233,  4585,
    2423,  2798,  2799,  3804,  3181, -2623,  1502,  3185,  3186,  3000,
    1236,  2254,  3807,  2480,  1551,  3525,  1561,  4508,  1955,  3028,
    1232,  1233, -2113, -2621,  4557,  2569,  2220,  4591, -1921,  1232,
    1233,  1503,  1708,  1232,  1233,  1709,  3943,  3758,  1232,  1233,
     635,  2494,  4306,  2980,  2353, -2622,   122,  1236,  2928,  2929,
    3549,   635,  2749,  4080,   664,  3304,   664,  3471,  2003,   518,
    2003,  2003,  2624,  2222,  2405,  1234,  2687,  2032,  1235,   607,
    1465,  3160,  2688, -2264,  2364,  1236,  2524, -2290, -2409, -2713,
   -2627,  1232,  1233,  2570,  3363,  1625,  1626,  1627,  1632,  3401,
    4252,  3403,  3660,  2492,  1829,  3311,  3083,  2712,  3414,  2100,
    4298,  2397,  2707,  3079,  2827,  1465,  2497,  1783,  1236,  2500,
    2501,  3084,  3427,  3518,  3641,  1232,  1233,   141,  2933,  3438,
    3440,  1232,  1233,  3202,  3203,  2419,  2420,  3289,  1172,  4174,
    4174,  2060,  3457,  3459,  3461,  1278,  2856,  1581,  3462,  3440,
    1455,  2180,  1172,  1236,  1821,   557,   867,  4267,  2033,  4288,
    1232,  1233,  2326,  1236,  1232,  1233,  2087,  2797,  2298,  2684,
    2062,  1367,  2981,  1236,  1368,  1232,  1233,   124,  4446,  2225,
    1236,  3888,  2340,  2318,  3504,   575,  4550,  2568,  3237,  3238,
    3889,  4453,  1232,  1233,  1043,  1630,  3934, -2620, -2713,  3935,
    4513,  1767,  1956,  1858,  1589,  1144,  1145,  2597,  2470,  1766,
    1234,  1565,  4307,  1235,   645,  3364,  4476,  1232,  1233,  2852,
    1935,  2802,  2803,  1566,  2491,  1236,  1857,  2685,  3115,  3954,
    3955,  3956,  1092,  3351,  4642,  4555,  1234,  3959,  4559,  1235,
   -2624,  2226,  1232,  1233,  2342,  3985, -1921,  1961,  3472,  1234,
    3560,   645,  1235,  2039,  3400,  2424,  1825,  4478,  3689,  1911,
    3932,  3933,  1951,  3080,  1232,  1233,  2796,  3160,  4479,  2916,
    3160,  3160,   635,  4374,  4592,  4375,  2806, -1921,  2406,  1214,
    3430,  3431,   897,  1269,  1426,  3519,  1425,  3160,  2088,  1456,
    1952,  3275,  1766,  3927, -2623,  2172,  4174,  4174,   878,  1172,
     645,  3958,  2683,  2953,  2357,  1232,  1233,  3978,  3981,  3983,
    3984,  1457, -2621,  1234,  3580,  4081,  1235,  1431,   645,  2089,
    1962,  1369,  2410,  1232,  1233,  2083,   645,   579,  3890,  1236,
    4393,  1882,  2917,  1885, -2622,  1234,   635,  1123,  1235,  1330,
    4509,  1232,  1233,  3312,  2360,  2227,  1232,  1233,   635,  2214,
    1232,  1233,  1234,  1458,  2605,  1235,   645,  4273,  1234,  1871,
    1830,  1235,  4553,  3801,  3520,   635,   635,  3116,  2997, -2627,
    1232,  1233,  4322,  2177,  2327,  1234,  4613,  4613,  1235,  1270,
     904,  1232,  1233,   664,  4468,  4469,  2689,   879,  4308,  4373,
    2328,   645,   645, -1921,  4665,  1937,   604,  3365,  1234,  1232,
    1233,  1235,  2608,  1945,  2101,  4174,  1946,  1234,  1776,  2314,
    1235,  1234,  3392,  3392,  1235,   645,  1234,  1232,  1233,  1235,
    4174,  2040,  1232,  1233,  1044,  2041,  1966,   953,  1232,  1233,
    1889,  2918,  3921,  1386,  2425,  4510,    44,   515,   515,   515,
     635,   515,   635,  4680,  4681, -1921,  2768,  2004,  2178,  1639,
    1953,  1045,  4643,  2006,   515,  2690,   645,  2069,   880,  1234,
     515,  2442,  1235,  1386,  1236,   664,   867,  4511,  1687,  4543,
    4386,  2039,  1986,  1987,  1988,   622,  1990,  1232,  1233,  1390,
    2234,   635,  4480,  3024,   623,  3200,  3423,  4174,  2691,  2007,
    1236,  1232,  1233,  1234,   135,  2013,  1235,  1232,  1233,  1234,
    3169,  4342,  1235,  1236,  3366,  2203,   865,  2003,  1232,  1233,
    2919,  4174,  4265,  4266,  3992,   625,  4786,  1232,  1233,  2235,
     273,  4079,   275,  4174,  4174,  1982,  2130,  1963,  1234,  2909,
    4565,  1235,  1234,  1096,  1097,  1235,   635,  1989,  1639,  1991,
     905,  3122,  1639,  1234,  1569,  2511,  1235,  2451,   717,  1505,
    2131,  4323,  2012,  2676,   645,  2528,  4274,  1232,  1233,  1938,
    1234,  1050,  3424,  1235,  1232,  1233,  4268,  1236,  3345,   635,
    1691,  3266,  3267,  3268,  2125,   635,  1777,  2315,  2024,   136,
    3521,  1856,  1725,  2245,  3518,  1234,   635,   636,  1235,  1236,
    4174,  -212,   639,   591,  4236,  4322,  1232,  1233,  2452,  4488,
    4174,   676,   641,   645,    58,  2246,  1236,   654,   645,  3066,
    1234,   722,  1236,  1235,  1426,  3146,  2568,  1118,   832,  2201,
    1093,   124,  2250,  1232,  1233,  1232,  1233,  3350,  2262,  1236,
    4107,  1506,  1234,  2064,  2508,  1235,  4010,  2429,  1766,  2040,
    1855,  3236,  4174,  1203,  4174,  2269,  4489,  1207,  2692,  3292,
    3683,  2509,  1236,  2099,  3686,  3687,  1232,  1233,   661,  4275,
    4481,  1236,  3425,  2946,  1286,  1236,  2119,  2988,  2273,  4174,
    1236,  1729,  2127,  1234,  1692,  1753,  1235,  2274,  1695,  4174,
    2215,  4174,  3993,  4174,   667,  1696,  2276,  1232,  1233,   658,
    3076,  1234,  1939,  4256,  1235,  2451,  2801,  4174,  4235,  3839,
    1094,  1232,  1233,  3026,  4174,  1232,  1233,  1172,  2255,  1234,
     735,  3464,  1235,  1236,  1234,   669,  1909,  1235,  1234,  4174,
    4174,  1235,  1232,  1233,  2358,  2841,  2920,  3286,  4108,  2277,
    1232,  1233,  2997,  1204,  2053,  4174,  4174,  1208,  1234,  3499,
    4174,  1235,  3606,   273,  2248,   275,  3519,  1236,  2088,  1234,
    2683,  3791,  1235,  1236,  1232,  1233,  1106,  4229,  4230,  1666,
    2732,  1910,  4430,  2281,   672,  2737,  1697,  1234,  2324,  2299,
    1235,  4109,  4490,  1463,  4323,  1232,  1233,  2130,  2743,  2694,
    4043,  4231,  1236,   671,  4697,  1234,  1236,  3607,  1235,   751,
    1234,  1232,  1233,  1235,  3392,   678,  1234,  1236,  3183,  1235,
    3346,  2131,  3184,  2695,  4064,  4078,  4698,  2346,  1325,   823,
    2348,   635,  2758,  3195,  1236,  2347,   865,  1766,   645,  2880,
     635,   645,  1667,   679,  1699,  3530,  2318,  1050,  3436,  1865,
    3205, -1894,  1866,   635,  2464,  1867,  1232,  1233,  1321,  1236,
    1232,  1233,  2165,  1321,  2346,  1234,  2371,  3024,  1235,  1232,
    1233,  1668,  3320,  2379,  2379,  3206,  2379,  1232,  1233,  1234,
    2947,   586,  1235,  2248,  1236,  1234,  1232,  1233,  1235,   586,
    3823,  3504,   828,  2694,  3027,   645,  1234,  2177,   635,  1235,
    3817,  2812,   635,   519,  2689,  1234,  1236,   520,  1235,  1326,
    2130,  3840,  2988,  2988,   952,  1327,   273,  2695,   275,   645,
     645,   635,   635,  2690,   839,  1232,  1233,  3950,  2349,  2083,
    3951,  2100,  1172,   645,  2131,  1232,  1233,  4019,  2379,  2379,
    2379,  1669,   664,  1232,  1233,  1234,  1970,  1236,  1235,   680,
    2513,   645,  1234,  1232,  1233,  1235,   887,  1232,  1233,  1328,
    3888,  3909,  3201,  1232,  1233,  1236,  1415,   873,   953,  3889,
    2378,  2378,   913,  2378,  3329,  3576,  1329,  1232,  1233,  3578,
    2219,  1232,  1233,  1236,  1234,   895,  1700,  1235,  1236,  2487,
    2218,  1269,  1236,  2770,   893,  2402,  4600,  2988,  2221,  1361,
    1232,  1233,  1702,  1465, -1922,  1232,  1233,  2236,  2223,  2224,
    2418,  1234,  1236,  1234,  1235,  3841,  1235,   915,  1380,  2422,
    1670,  2083,   905,  1236,  1032,   780,  3349,  2237,  3642,   635,
    1232,  1233,  1232,  1233,  1004,  2378,  2378,  2378,  2244,  1232,
    1233,  1236,  2090,  1011,  1234,  2506,  3332,  1235,  1232,  1233,
    2241,  1269,   635,  3516,  1829,  1039,  2258,  1232,  1233,  1236,
    1033,  3521,   515,   515,  1236,  2530,   515,  3690,   876, -1894,
    1236,  3025,  1578,  1579,  2259,  1234,  1047,  2483,  1235,  2263,
    3805,   626,  3551,  3552,  1066,  2267,  1073,  3026,  2677,  1234,
    2330,  1058,  1235,  1234,  2693,  1766,  1235,  2526,  2527,  3288,
    4028,  3704,  1083,  3565,  4335,  4339,  3573,  3890,  1232,  1233,
    1234,  2100,  3708,  1235, -1922,  3710,  1249,  1622,  1234,  1236,
    1086,  1235,  1120,  1430,   635,  1104,  2499,  4691,  1105,  4693,
    3912,  3913,  1121,  1236,  2268,  1430,  4200,  4201,  4202,  1236,
    2166,    13,  1234,  1766,  1122,  1235,  1829,  2083,  2272,  2518,
    1236,  2091,  2804,  1272,  2953,  3448,  1124,  3449,  1059,  1236,
    4547,  1269,  4548,  1234,  4714,  2275,  1235,  2535,  2165,  1021,
    1249,   990,  1232,  1233,  2278,  3172,  2542,  2543,  1125,  1234,
    3842,  1126,  1235,   645,  1129,   645,  1130,  2547,  2548,  2549,
    2550,   645,  2558,  2559, -1805,  1857,  3843,  2701,  1273,  1236,
    2704,  3450,  1232,  1233,  4745,  4746,  1236,  4029,  4030,  2249,
    1269,  1060,  4031,  4032,  2290,  1345,  2167,  2251,  1269,  1249,
     645,  2309,  1131,  3451,  1234,   990,  2101,  1235,  1234,  2794,
    1132,  1235,   645,  1106,  1106,  1106,  1671,  1234,  1236,  1290,
    1235, -1805,  1133,   961,   942,  1234,  1134,  2196,  1235, -1894,
    2342,    25,  4335,  3149,  1234,  2066,  4339,  1235,  1135,  2816,
    3452,  1232,  1233,  2252,  1723,  1236,  3936,  1236,  2679,  3939,
    3940,  1136,  1829,  2264,  1269,  1932,  1932,  1932,  1232,  1233,
    3173,  1249,  3179,  1050,  1050,  1050,  3952,  1137, -1805,  3844,
    2772,  4350,  1666,  1234,  2265,  1269,  1235,  1138,  1236,  3694,
   -1599,   927,  1061,  1234,  1672,  1139,  1235,   961,   942,  1478,
    1830,  1234,  1252,  3180,  1235,  1026,  1027,   990,  1028,  2092,
    1029,  1234, -1922,  1140,  1235,  1234,   645,  2083,  1235,  1236,
    2093,  1234,  1509,  1322,  1235, -1805,  1141,  2094,  1514,  1515,
    1479,  2706,  2545,  1236,  3187,  1234,  1142,  1236,  1235,  1146,
    2165,  2813,  2689, -1922,  3235,  1667,   645, -1599,  3191,  2139,
    2140,  1346,  3192,  1333,  1236,  3614,  1252,  1324,  1234,  1342,
    2168,  1235,  1236,  1234,  1148,  2153,  1235,  4008,   645,  3193,
    2266,  1269,  1149,  3638,  1668,   927,  1331,  3194,  1150,  2003,
   -1599,  3770, -1599,  4608,  1480,  1153,  1236,  1154,  1234,  1481,
    1234,  1235,  1830,  1235,  2270,  1269,  2101,  1234, -1599,  1766,
    1235,  3196,  1465,  2850, -1599,  1252,  1234,  1236,  1155,  1235,
    3292,  4692,  1156,  4335,  4339,  1234,  3151,  1157,  1235,  1158,
   -1599, -1894,  3199,  1236,   928,   122,  2095,  2873, -1599,  2464,
    1430,  2876,  1159,   990,  3146, -1599,  2166,  1344,   645,   645,
    1160,  3412,  1829,  1161,  1669, -1599,  2560,  2561,  1162,    38,
    2786,  1269,  2897,  3453,  2899,  1254,  1255, -1599,  1165, -1922,
    1166,  4616, -1599,  2825,  2826,  4615,  1234,  1252,  1236,  1235,
    1167, -1599,  1236,  3168,  2224,  1173,   953,  4244,  4245,  1174,
      44,  1236,  2004,  3204,  2004,  2004,  1353,  3207,  1175,  1236,
    1176,  1766,  2318,  2155,  2156,  1789,  3209,  3454,  1236,  2083,
    1177,   929,  3436,  1334,  3383,  1178,  1062,  1179,   928,  1180,
    1767, -1922,  3395,  3211,   611,  3171,  1269,  3402,  1830,  2961,
    1181,  2096,   515,  1670,  3197,  1269,   645,   645,   123,  3416,
    1234,  3418,  3419,  1235,  3298,  3299,  3814,  1236, -1599,  4538,
    1184,  1482,  1185,  3432,  1186,  2896,   124,  1236,  3302,  3303,
    2564,  1351,  3213,  3584,  1269,  1236,  1187,  2966,  1254,  1255,
    1234, -1599,  3214,  1235,  1188,  1236,   612,  3609,  3610,  1236,
    3215, -1599,  1063,  1189,  1064,  1236,  1643,  1644,  1645,  2935,
    3570,  2139,  2140,  1357,  3571,   929, -2756,  3775,  3776,  1236,
    3572,  2429,  1190,  1663,  1191,  1604,    54,  2153,  1192,  2430,
    4349,  3783,  3784, -1599,  3816,  1259,  1260,  1261,  1262,  1263,
    1264,  3060,  1236,   990,  1193,   125,  1483,  1236,  2166,  1234,
    1254,  1255,  1235,  1194,  1829,  1726,  3075,  3822,  1730,  4095,
    3794,  3802,  3824,  3818,  1269,  1195,  1234,  3835,  1269,  1235,
    3096,   613,  1236,  1196,  1236,  1197,  1183,  1198,    58,  1749,
    1750,  1236,  1199,  1754, -1599,  3851,  3852,  3825,  1365,  3826,
    1236,  1261,  1262,  1263,  1264,  1375,  3827,  1200,  1202,  1236,
    1768,  1769,  1201,  1096,  1097,  4083,  1205,  4095, -1599,  1790,
    1484,  1215,  1216,  2507,  4195,  4001,  2561,  2551,  1206,  1932,
    3437,   635,   635,   635,  2167,  4179,  4180,  1050,  1830,  1209,
     126,  2381,  1210,  2382,  4730,  4731,  1257,  1258,  1259,  1260,
    1261,  1262,  1263,  1264,  1213,  4114,  4115,  1605,  2431,  2432,
    1236,  1606,  4182,  4183, -1599,  2155,  2156,  1217,  4118,  1218,
    3129,  3558,  1607,  4186,  4183,  4121,  -671,  3099,  3100,  1671,
    3102,  4604,  3104,  3105,  3106,  3107,  3108,  3109,  3110,   952,
    2552,  3113,  2997,  1219,  3118,  4187,  4183,  3121,  1220,  2433,
    1345,  4140,  4141,  1221,  2998,  2446,  2447,  2448,  1257,  1258,
    1259,  1260,  1261,  1262,  1263,  1264,  4726,  1343,  2551,  2553,
   -1599,  3439,  1222,  3585,  1236,  4243,  3303,  1271,  3140,  3141,
    3142,  3960, -1599, -1599,  1387,   990,  1389,   930,   931,  1485,
     933,  1405,   935,  4262,  4183,  1407,  2716,  4401,  4271,  4272,
    1408,  1666,  1409, -1599,  1236, -1599,  1410,   936,  1321,  1413,
    2371,  2508,  4352,  4353,  1350,   645,   645,   645,  4387,  3610,
    1416,   127,  2717,   635,  4388,  4183,  1486,  3961,  2509, -1599,
   -1599,  2552,  1248, -1599, -1599, -1599,  1421,  3962,  2168,  2554,
    2510,  1422,  2850,   645,  4389,  4183,  1767,  2852,  4787,  1442,
    4217,  4391,  4183,  1446,  1608,  4392,  4183,  -671,  4218,  1447,
    2553,  1172,   526,  1236,  1667,   645,   645,   645,  1451,  1666,
    1830,   930,   931,   932,   933,   934,   935,  1463,  3319,  2718,
    1236,  1791,  2719,  1472,   614,  4219,  3963,  4398,  4399,  1473,
    2720,   936, -1599,  2982,   128,  1474,  1346,  1792,  4400,  4399,
    2130,  1475,  2674,   273,  1494,   275,   615,  1498,  2721,  3697,
    1499,  2004,  4439,  4440,  4486,  3303,  2551,  2816,  2555,  3456,
    3274,  2511,  4020,  4021,  2131,  4487,  3303, -1599, -2756,  1504,
    2554, -1894,  1667,  4563,  4564,  3799,  4589,  3610,  4618,  4619,
    4677,  3501,   616, -1599,  1512,  1249,  1513,  4005,  4006, -1599,
    4258,  1518,  1609,   635,  3075,  4776,  4777,   129,  1756,  1757,
    1519,  1668,  1521,  2983,  3628,  3629,  3592,  3593,  1526,  1531,
    1249,  3318,  1562, -1599,  1568,  3849,  3850,  1570,  1572,  2552,
   -1599,  1575,  3075,  1766,  1576,   273,  1580,   275,  1584,  1585,
   -1599,  3399,  3397,  3075,  4348,  1590,  -679,  3409,  1592,  3408,
    1591,   617, -1599,  3960,  1613,  1614,  4220, -1599,  2553,  2555,
    1615,  2722,  1621, -2106,   645,  3408, -1599,  -853,  1623,  1624,
    3429,  3433,  1635,  1267, -2756,  1767,  1633,  3444,  1639,  4135,
    1665,  1669,  1646,  3446,  3447,   635,  1676,  2512,  1711,  1722,
    1723,  1724,  2984,  1747,  1784,  1806,  1764,  3408,  -671,  3961,
    3368,  1250,  1775,  1800,  3075,  3470,  1826,  1827,  1840,  3962,
    3483,  2999,  1619,  1833,  2997,  1834,   515,  1841,  1842,  1837,
    3493,  4086,  1843,  1844,  1251,  3408,  2998,  -671,  2554,  1845,
    4351,  1847,  2204, -1599,  3895,  4280,  1848,  4221,  1859,  1860,
    1861,  4280,  1862,  1890,  3410,  3411,  1895,  1898,  1907,  1915,
    2551,  3489,  1916,  3458,  1917,  4222, -1599,  2513,  3963,   690,
    1670,  3506,  2575,  1918,  2576,  2723, -1599,  1096,  1097,  1922,
    2551,  1927,  3443,  3965,  1928,  1929,  1947,  3513,  4223,  1930,
    3966,   541,  3445,  1941,  2556,  1971,  1979,  1980,  1984,  2015,
    2016,  1252,  2017,  2020,  2018,  3534,  -818,  -818, -1599,  2578,
    2021,  2022,  4402,  3482,  2037,  2051,  2068,  2555,  -818,  2114,
    2120,  1096,  1097,  2552,  2134,  2121,  1252,  2256,  2581,  2135,
    3967,  2260,  1249,  2551,  2551,   531,  2582,  3460,  2161,  -671,
    2179,  3964,  2182,  2552,   526,  2181,  2193,  2199,  2205,   542,
    2207,  2240,  2553,  4089,  2208,  2284,  2209,  2231,  2232, -1599,
     717,  3633,  3535,  2584,  2242,  3536,  2233,   273,  2238,   275,
    2239,  3509,  2553,  3537,  2248,  2253,  3583,  1562,   543,  2257,
    2585,  2288,  2130, -1599,  2897,  2556,  3339,  2261,  2279,  2319,
    1766,  3538,  4470,  2280,  1249,  2285,  2552,  2552,  1253,  -853,
    2289,  4348,  2300,  3968,  4260,  4261,  2131,  4263,  4264,  2590,
    2301,  2302,  2323, -1423,  1264,   544,   721,  -671,  2985,  1666,
   -1280,  2724,  2554,   722,  2850,  2553,  2553,  2329,  2339, -1599,
    1151,  2359,  1203,  1207,  2374,  4038,  3539,  2394,  2271,  2532,
    2533,  4048,  2554,  2873,  3621,  1602,  2409,  3623,  2403,   645,
    2412,  2415,   726,   727,  1254,  1255,  2544,  2437,   645,  1430,
    2438,  2443,  2444,   545,  2813,   990,  2445,  2466,  2460,  2467,
    1256,   953,   953,  2562,  2563,  2468,   273,  2896,   275,  1254,
    1255,  4224,  1667,  2471,  2594, -1599,  1671,  2473,  2472,  1415,
    2725,  1767,  2595,  2484,  3540,  2554,  2554,  2474, -1599,  1096,
    1097,  2555,  2486,  2475,  2488,  3965,  3669,  2596,  2489,  2502,
    3969,  2982,  3966,   635,  2516,  2493,  2503,  2517, -1599,  2726,
   -1599,  2555,   735,  2507,  3678,  4623,  2520,  2521,  1252,  4176,
    2523,  4515,  2534,  2556,  3075,  2536,  2525,  2541,  2670,  2671,
    2672,  2673,  4445,  3408, -1599, -1599,  3075,  2537, -1599, -1599,
    2538,  2539,  3967,  2540,  2640,  2644,   645,  2646,  2648,  -671,
    3408,  4455,  3075,  3075,  2649,  2598,  2650,  2651,  2652,  2653,
    3639,  2654,  2655,  1430,  2555,  2555,  3075,  3408,  2656,  2657,
    2658,  2983,  2659,  2599,  2678,   746,  2660,  2661,  3408,   -67,
    1252,  3408,  2662,  2663,   546,  3541,  4124,  4228,  3542,  2664,
     750,   751,  1257,  1258,  1259,  1260,  1261,  1262,  1263,  1264,
    3671,  2665,  2666,  2697,  2667,  3713,  2668,  2669,   635,  2702,
    2698,  2706,  2699,  3769,  2710,  3968,  2715,  1257,  1258,  1259,
    1260,  1261,  1262,  1263,  1264,  4623,  2738,  2739,  2603,  2740,
    2604,  2347,  2750,  2751,  2070,  3096,   547,  2763,  2606,  2785,
    3696,  2792,  2800,  2809,  2823,  2828,  2810,   531,  2071,  3702,
    2984,  2508,  2824,  2829,  2830,  2831,  2832,   548,   585,  2833,
     645,  2842,  2839,  1239,  1240,  2844,  3543,  3870,  2509,  1232,
    1233,  1254,  1255,  2070,  2846,  2853,  2854,  2845,  1902,  2857,
    2510,  2858,  2863,  2859,  2877,  1766,  2878,  2071,  2881,  4628,
    4629,  4493,  4631,  2882,  2883,  2452,  4771,  2451,  1766,  2901,
    1241,  1955,  2902,  1766,  1956,  3714,  2912,  2556,  1766,  4780,
    2612,  1249,  1242,  2927,  4771,   690,  2930,  2942,  3772,  4780,
     549,  2943,  3969,  2944,  2967,  2978,   550,  2556,  2979,  -671,
    2997,  2959,  3010,  1254,  1255,  3015,  3016,  3019,  2507,  3020,
    3022,  3023,  3859,  3029,  3031,   551,  3032,  1767,  3033,  3040,
    3041,  3046,  4673,  1243,  4674,  4675,  3047,  3052,  3053,  3063,
    3082,  2511,  3127,  3086,   645,  1244,  2613,  2614,  2615,  3091,
     552,  4228,  3097,  2616,  3131,  1683,  1684,  1685,  1686,  1687,
    2556,  2556,  3126,  2200,   772,  3143,  3163,   553,  4090,  2617,
    3152,  4091,  1245,  2618,  3165,  3226,  3157,  3244,  3166,  4089,
    3167,  3174,   778,  3544,  3175,  3216,   717,   780,  3075,  3227,
     781,  3230,  2619,  3234,  3232,  3239,  2072,  3188,  3264,  1257,
    1258,  1259,  1260,  1261,  1262,  1263,  1264,  3408,  3242,  3263,
    2621,  3075,  3545,  3269,  3271,  3276,  1430,  3279,  1367,  1767,
    3280,  3283,  3297,  3408,  4757,   635,  4742,  3305,  3294,  3316,
    3300,  4496,  3317,  2507,  1246,  2072,  3321,  3325,  3322,  3333,
    3334,  3340,   721,  3344,  3347,  3356,  2985,  4092,  4093,   722,
    3355,  3415,  2605,  3484,  3417,  3479,  2508,  2512,  1688,  1689,
    1690,  1691,  1258,  1259,  1260,  1261,  1262,  1263,  1264,  3491,
    3378,  3487,  2073,  2509,  3495,  3490,  3500,  3900,   726,   727,
    3501,  3550,  3505,  2053,  3531,  2510,  3553,  1252,  3633,  3554,
    3991,  3561,  3562,  3996,  1096,  1097,  3574,  2074,  2306,  3221,
    4004,  4004,  4004,  2004,  3587,  3588,  3589,  3598,  3600,  3605,
    3611,  2073,  3613,   645,  2429,  3008,  3626,  3634,  3011,  3012,
    3646,  3014,  3647,  3658,  3017,  3018,  3664,  2513,  3021,  3665,
    3670,  4498,  3672,  3030,  3673,   525,  2074,  3674,  3034,  3035,
    3036,  3037,  3038,  3679,  3693,  3680,  3042,  3043,   735,  3045,
    3681,  3701,  3705,  3712,   892,  3054,  3055,  3056,  3057,  3711,
    2075,  3061,  3062,  4783,  3064,  1692,  2511,  1693,  1694,  1695,
    1292,  2508,  2638,  3771,  3773,  3780,  1696,  1292,  2464,  3781,
    3786,  3789,  3796,  3787,  2571,   645,  3788,  3800,  2509,  3874,
    2572,  3803,  2573,  3806,  2574,  2876,  3792,  3793,  4048,  2075,
    2510,  3794,  3795,  1293,  3808,  2575,  3810,  2576,  3811,  3812,
    1293,   746,  3669,  3815,  3819,  3820,  3830,  1234,  3821,  3829,
    1235,   526,  3128,  3836,  3838,  4004,   750,   751,  3847,  3854,
    3075,  3855,  3866,  3864,  3867,  4099,   635,  2577,  3872,  2383,
    1254,  1255,  2578,  2579,  4104,  3887,  3881,  3852,  3320,  2580,
    3871, -1509, -1514,  3896,  3897,  3901,  2076,  1697,  3905,  -884,
    3898,  2581,  3914,  2384,  3911,  1430,  3922,  3915,  3937,  2582,
    3980,  3987,  4012,  1294,  4016,   645,  2385,  4017,  3802,  2583,
    1294,  2511,  2512,  3930,  4023,  4018,  4022,  4024,  2386,  4025,
    4036,  4496,  4037,  4040,  4066,  2076,  2584,  4041,  1295,  4053,
    4055,  4142,  1296,  4067,  3878,  1295,  4105,   527,  4068,  1296,
    1562,  4102,  3977,  2585,  1698,  1699,  4084,  4085,  4087,  1391,
    4088,  2586,  2587,  4117,  4113,  4119,  4127,  4129,  2588,  1392,
    4130,  4128,  4131,  4097,  4133,  4134,  2589,  4143,  1297,  2387,
    -961,  2388,  2590,  4177,  1393,  1297,  4188,  4190,  4197,  4228,
    4189,   635,  2513,  2591,  4214,  4185,  1394,  1395,  1396,  1298,
    4192,  4196,   645,  4193,  4199,  4207,  1298,  4210,  2389,  4123,
    4528,  4240,  4242,  2592,  1299,  1397,  4253,  4669,  4270,  4276,
    4282,  1299,  4284,  4249,   635,  4528,  4754,  4285,  1257,  1258,
    1259,  1260,  1261,  1262,  1263,  1264,  4292,  2512,  4004,  4004,
    4310,  4004,  4004,  -352,  4312,  4313,  4331,  4341,   528,   273,
    4355,   275,  4358,  4754,  4359,  2593,  4364,  2594,  4367,  4369,
     772,  4371,  1300,  4376,  4090,  2595,  4381,  4091,  4394,  1300,
    4407,  4410,  4385,  2390,  -370,  4404,  4436,  4438,   778,  4437,
    2596,  4448,  4472,   780,  4454,  4484,   781,  1301,  4208,  4290,
    4447,  4457,  4581,  4460,  1301,   841,  4669,  1700,  3474,  4517,
    4296,  4524,  4525,  4529,  2597,  4303,  4535,  2513,  4553,  4536,
    4567,  1236,  1701,  1702,  4568,  3245,  4569,  4570,  4576,  4577,
    4578,  4250,  4580,  4579,  4583,  3246,  4590,  4593,  2391,  4594,
     529,  4595,  4596,  4601,  4317,  4321,  4605,  4004,  2598,  4603,
    3247,  4606, -2460,  4092,  4093,  4609,  2597,  2572,  4627,  4630,
    4632,   530,  3248,  3249,  3250,  4633,  2599,   821,  4637,  4640,
    2600,  1767,  4641,  4649,  4663,  4662,  4666,  4678,  4688, -1683,
    4689,  3251,  4676,  4785,   531,  4690,  4694,  4700,  4699,  4695,
    4703,  4710,  4289,  4705,  4713,   842,  4706,  4717,  4719,  4722,
    4723,  1302,  4724,  4729,  2876,  4528,  2876,  4743,  1302,  2601,
    1303,  4733,  4758,  3413,  2602,  4661,  4735,  1303,  4759,  4772,
    4305,  2603,  4782,  2604,   532,  1304,  3422,   844,  2605,  4763,
    4471,  2606,  1304,  2818,  4000,  4071,  4395,  3120,  1493,  3785,
    2991,   845,  4382,  1305,  1398,  4499,  4638,  1574,  4639,  4069,
    1305,  1544,  4073,  4248,  4774,  4737,   598,  1003,  2440,  2367,
    3259,  1399,  2607,  4411,  1873,  4154,   533,  4155,  1874,  4157,
    4158,  4160,  4161,  4162,   534,  4163,  2608,  2609,  2610,  2611,
    1875,  4164,  4747,  4165,  4708,  4646,  4522,  1306,  4647,  4168,
    1307,  4614,  4169,  4170,  1306,  4534,  4528,  1307,  4528,  4533,
    1617,  2350,   849,  2612,  4255,  2112,  4384,  3707,   958,  3067,
    2622,  3857,  4728,  3604,  3287,  3282,   821,  4214,  1308,  4528,
     959,   821,  1905,  4459,  4209,  1308,  4552,   645,  3860,  4668,
     850,   896,   960,  4477,  4702,  2164,  4626,   851,  1040,  4366,
    1309,  4077,  2816,  3065,   519,  3662,  3904,  1309,   520,  3469,
    4528,  4528,  3072,  3476,  4098,  4762,   961,   942,   821,  2613,
    2614,  2615,  4096,  4711,   962,  3945,  2616,  4518,  3547,   963,
    4278,  3986,  4132,  2976,  4551,   821,  4122,   852,  3218,  4441,
    3577,  3575,  2617,  4502,  3579,   537,  2618,   538,  4587,  1310,
    4588,  2696,  4444,  1400,  4452,   964,  1310,   965,  3139,   966,
    3252,  4330,  4450,  3684,  4321,  2619,  4281,  3069,  3468,  4545,
    2620,   967,  1517,  4464,  4465,  2038,  1582,  3253,  1767,   821,
     821,   821,   821,  2621,  2934,  4101,  2860,  4537,  2162,  4625,
    2643,   821,    14,    15,  3917,  2126,  3273,  2840,  2421,   645,
    3599,  2884,  2791,  4175,  1030,  2450,  1420,  3586,  4403,  2731,
    2729,  3241,  1721,  1401,  2954,  3643,  4246,  2790, -1894,   968,
    4378,  2948,  3782,  3925,   969,  4635,  2807,   970,  4636,  3330,
    1664,  1402,  2054,  4057,  3463,  4727,  4050,  2891,  2700,  1888,
    1920,  2838,  2866,  3862,  1554,  1555,  3617,  -961,  3616,  1556,
    3652,  4549,  1017,  1557,  2198,   971,  1119,   972,  2495,  1996,
     998,  2496,  4544,  2931,  1001,   973,  2361,   974,  3929,  1926,
    1876,  3603,  4701,  4725,  4571,  4634,  4781,  4126,  4784,   821,
    1212,  3620,  2910,  4560,  4561,  3636,   645,  1944,   955,  2322,
     855,  3254,  3637,   975,   976,   977,   956,  2478,  1877,  2908,
    2907,  2408,  3096,  3096,  2900,  1280,  1878,  1936,   923,  3255,
    1406,  1881,  4198,  2879,  3260,  2188,   978,  4206,  1412,   925,
    1036,  1037,     0,  1038,  1548,     0,  4651,     0,     0,     0,
       0,     0,  1549,  4659,     0,  1550,   858,     0,   979,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   859,
    1879,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   980,  3256,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  3257,     0,     0,
       0,     0,     0,     0,     0,  4775,     0,     0,     0,  1880,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  4715,     0,     0,     0,     0,  4720,
       0,     0,     0,     0,     0,     0,     0,     0,  1127,     0,
     862,     0,     0,     0,     0,   981,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   863,     0,   864,     0,     0,     0,  4755,     0,
       0,   982,     0,     0,     0,  1164,     0,     0,     0,     0,
     821,     0,   983,   984,     0,     0,   985,   986,     0,     0,
       0,     0,  1182,  1767,     0,  4755,     0,     0,     0,     0,
       0,     0,   645,     0,     0,     0,  1767,   987,     0,  4709,
       0,  1767,     0,     0,     0,     0,  1767,   821,   821,     0,
       0,     0,     0,     0,     0,     0,   821,   821,   821,   821,
     821,   821,   821,   821,   821,   821,   821,   821,     0,  1226,
       0,     0,     0,     0,     0,     0,   821,   821,     0,   821,
     821,     0,     0,     0,   821,   988,     0,   821,   821,   821,
     821,     0,   821,   821,   821,     0,     0,     0,   989,     0,
       0,   821,   821,     0,   821,   821,   821,   821,   821,     0,
       0,   821,   821,   821,   821,   821,   821,   821,   821,   821,
     821,   821,     0,   821,     0,     0,   821,   821,     0, -2500,
       0,   821,     0,   990,     0,   821,   821,   821,     0,  1683,
    1684,  1685,  1686,  1687,     0,     0,     0,   821,   821,   821,
       0,   991,   992,     0,     0,     0,   821,     0,  2136,     0,
       0,     0,     0,   821,   821,   821,  1366,   821,     0,     0,
       0,     0,     0,     0,   821,   821,   821,     0,   821,   821,
     821,   821,   821,     0,   821,   821,   821,   821,   821,   821,
     821,   821,     0,     0,     0,   821,   821,     0,     0,     0,
     993,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0, -2500,     0,     0,     0,     0,     0,     0,  2137,   994,
    2138,  2139,  2140,  2141,  2142,     0,  2143,  2144,  2145,  2146,
    2147,  2148,  2149,  2150,  2151,     0,  2152,  2153,  2154,     0,
       0,     0,  1688,  1689,  1690,  1691,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   821,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   821,     0,     0,  1692,
       0,  1693,  1694,  1695,     0,     0,   821,  1598,     0,     0,
    1696,     0,     0,     0,     0,  2155,  2156,     0,     0,     0,
       0,     0,   821,     0,     0,     0,   821,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1637,  1638,     0,     0,     0,     0,
       0,     0,     0,  1648,  1649,     0,     0,  1652,  1653,  1654,
    1655,  1658,  1659,  1660,  1661,     0,     0,     0,     0,     0,
       0,     0,     0,  1677,  1678,     0,  1679,  1680,     0,     0,
       0,   821,     0,     0,  1713,  1714,  1715,  1716,     0,     0,
    1719,  1697,     0,     0,     0,     0,     0,     0,  1727,  1728,
       0,  1731,  1732,     0,     0,     0,     0,     0,  1736,  1737,
    1738,     0,     0,  1741,  1742,  1743,  1744,  1745,  1746,     0,
    1748,     0,     0,  1751,  1752,     0,     0,  2575,  1755,  2576,
       0,     0,  1758,  1762,  1763,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1770,  1771,  1772,     0,  1698,  1699,
       0,     0,     0,  1780,     0,     0,     0,     0,     0,     0,
    1785,  1786,  1787,     0,  2578,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2581,     0,     0,     0,     0,     0,     0,
       0,  2582,     0,  1823,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2575,     0,  2576,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2584,     0,
       0,     0,     0,   821,     0,     0,     0,     0,     0,     0,
       0,     0,  1562,     0,     0,  2585,     0,     0,     0,  -818,
    -818,     0,  2578,     0,     0,     0,     0,     0,     0,     0,
       0,  -818,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2581,     0,     0,  2590,     0,     0,     0,     0,  2582,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1892,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1700,     0,     0,     0,     0,  2584,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1701,  1702,     0,     0,
    1562,     0,     0,  2585,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   273,     0,   275,     0,     0,   821,   821,   821,  2594,
       0,     0,  2590,  1943,     0,     0,     0,  2595,     0,     0,
       0,   821,     0,  1949,     0,     0,     0,     0,     0,     0,
    4356,  4357,  2596,     0,  4360,  4361,  4362,  4363,     0,  1977,
       0,     0,     0,  1983,     0,     0,     0,   821,     0,     0,
       0,     0,     0,   821,     0,     0,   821,     0,   821,     0,
       0,     0,     0,     0,   821,     0,   821,   821,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   273,
       0,   275,     0,     0,     0,     0,     0,  2594,     0,     0,
    2598,     0,     0,     0,     0,  2595,     0,     0,  2028,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2599,     0,
    2596,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2969,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  4442,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   821,
       0,     0,     0,  2603,     1,  2604,     2,     0,  2598,     0,
       0,  4466,  4467,  2606,     0,     0,     0,     0,     0,     0,
    4475,     0,     0,     3,     0,     0,  2599,     4,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     5,     6,     0,     0,     0,     0,     0,     0,     7,
       0,     0,   821,     0,     8,     9,     0,     0,     0,     0,
       0,   821,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    10,     0,     0,     0,     0,
    2210,  2603,     0,  2604,     0,  2612,     0,     0,     0,     0,
       0,  2606,     0,     0,    11,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    12,     0,
       0,     0,     0,     0,     0,     0,    13,    14,    15,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    16,
      17,  2613,  2614,  2615,     0,     0,     0,     0,  2616,     0,
       0,     0,    18,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2612,  2617,     0,     0,    19,  2618,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    20,     0,     0,  2619,     0,     0,
       0,     0,     0,  2292,  2294,  2296,     0,     0,     0,    21,
    2637,    22,     0,     0,     0,  2621,    23,     0,     0,     0,
      24,     0,     0,     0,     0,     0,     0,     0,     0,  2613,
    2614,  2615,   821,     0,     0,     0,  2616,     0,     0,     0,
       0,     0,     0,     0,  2331,     0,    25,     0,    26,     0,
       0,     0,  2617,  2336,     0,  2337,  2618,     0,     0,     0,
       0,     0,     0,     0,    27,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2619,     0,     0,     0,     0,
       0,     0,    28,     0,     0,     0,    29,     0,     0,     0,
       0,     0,     0,  2621,     0,     0,     0,     0,     0,   821,
       0,     0,     0,   821,     0,     0,     0,     0,   821,   821,
       0,     0,     0,     0,     0,     0,     0,   821,     0,   821,
       0,   821,   821,   821,   821,     0,     0,   821,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   821,     0,   821,
     821,     0,   821,   821,   821,   821,     0,   821,     0,     0,
     821,  2970,     0,     0,     0,     0,  2417,     0,     0,   821,
       0,     0,     0,     0,     0,     0,   821,     0,   821,     0,
     821,   821,     0,   821,   821,     0,     0,     0,   821,   821,
     821,    30,     0,     0,   821,   821,   821,     0,   821,     0,
     821,     0,   821,     0,   821,     0,   821,     0,    31,     0,
      32,   821,     0,     0,     0,     0,     0,     0,     0,  2477,
       0,     0,     0,    33,     0,     0,     0,     0,     0,     0,
     821,     0,     0,     0,    34,     0,     0,   821,     0,     0,
     821,     0,     0,     0,     0,     0,   821,     0,     0,   821,
       0,     0,     0,   821,     0,     0,    35,     0,     0,    36,
       0,    37,     0,     0,    38,     0,     0,    39,    40,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    41,     0,
       0,    42,     0,     0,     0,     0,     0,     0,     0,    43,
       0,     0,     0,     0,     0,    44,     0,     0,     0,     0,
       0,     0,     0,    45,     0,     0,     0,     0,    46,    47,
      48,     0,     0,     0,     0,     0,     0,   821,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2575,     0,  2576,     0,     0,     0,
      49,     0,     0,     0,     0,     0,     0,    50,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  -818,  -818,
       0,  2578,     0,     0,     0,     0,     0,     0,     0,     0,
    -818,     0,     0,     0,     0,     0,     0,   821,     0,  2647,
    2581,     0,    51,     0,     0,     0,     0,     0,  2582,     0,
       0,     0,     0,     0,    52,     0,     0,     0,    53,     0,
       0,    54,     0,     0,     0,     0,     0,    55,     0,     0,
       0,     0,     0,     0,     0,  2584,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2637,  1562,
       0,     0,  2585,     0,     0,     0,     0,    56,     0,     0,
       0,  2989,     0,    57,     0,     0,  2709,     0,     0,     0,
    2711,     0,     0,    58,     0,  2713,  2714,     0,     0,  2989,
    2989,  2590,     0,     0,  1655,     0,  2730,     0,  1655,     0,
    2733,  2734,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2741,     0,  2742,     0,     0,  2744,
    2745,  2746,  2747,     0,  2748,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2752,     0,     0,     0,
       0,     0,     0,  2753,     0,  2754,     0,  2755,  2756,     0,
    2757,  2637,     0,     0,     0,  2760,  2761,  2762,   273,     0,
     275,  2764,  2765,  2766,     0,  2767,  2594,  2769,     0,  2771,
       0,  2773,     0,  2774,  2595,     0,     0,     0,  2775,     0,
       1,     0,     2,     0,     0,     0,     0,     0,     0,  2596,
       0,     0,     0,     0,     0,     0,     0,  2795,     0,  2989,
    2989,     0,     0,     4,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2805,     0,     0,  2808,     5,     6,     0,
       0,     0,     0,     0,     0,     7,     0,     0,     0,     0,
       8,     9,     0,     0,     0,   821,     0,     0,     0,   821,
       0,     0,     0,     0,     0,     0,     0,  2598,     0,     0,
       0,    10,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2599,   821,   821,     0,     0,
      11,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   821,     0,     0,     0,
       0,     0,     0,     0,    12,   821,     0,   821,     0,   821,
       0,     0,    13,    14,    15,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    16,    17,     0,     0,     0,
    2603,     0,  2604,     0,     0,     0,   821,     0,     0,     0,
    2606,   821,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    19,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1977,     0,     0,     0,     0,     0,
      20,     0,   821,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    21,     0,    22,     0,     0,
       0,     0,    23,     0,     0,     0,    24,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2612,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    25,     0,    26,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      27,     0,     0,     0,     0,     0,   821,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    28,     0,
       0,     0,    29,     0,     0,     0,     0,     0,  2613,  2614,
    2615,     0,     0,     0,     0,  2616,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2617,     0,     0,     0,  2618,     0,   821,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2637,     0,  2619,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2621,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    30,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    31,     0,    32,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    33,
       0,     0,  3148,     0,     0,     0,  3150,     0,     0,     0,
      34,     0,     0,  2637,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   821,   821,     0,     0,
       0,     0,    35,  3177,  3178,    36,     0,    37,     0,     0,
      38,     0,     0,    39,    40,     0,     0,     0,     0,     0,
       0,     0,     0,  3198,    41,     0,     0,    42,     0,     0,
       0,     0,  3208,     0,  3210,    43,  3212,     0,     0,     0,
       0,    44,     0,     0,     0,  2989,     0,     0,     0,    45,
       0,     0,     0,     0,    46,    47,    48,     0,     0,     0,
       0,     0,     0,     0,     0,  3715,  3716,     0,   821,     0,
       0,  3717,     0,  3718,     0,  3719,  3720,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    49,     0,     0,     0,
       0,     0,  3534,    50,     0,     0,     0,     0,     0,  3270,
     821,   821,     0,   821,     0,     0,     0,     0,     0,     0,
       0,     0,   821,     0,     0,     0,     0,   821,     0,     0,
     821,     0,   821,   821,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    51,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  3721,
      52,     0,  3722,     0,    53,   821,     0,    54,     0,     0,
    3723,     0,     0,    55,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1977,     0,     0,     0,     0,  3724,     0,
       0,     0,     0,     0,     0,     0,   821,     0,     0,     0,
       0,     0,     0,    56,     0,  3725,     0,     0,     0,    57,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    58,
     821,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  3726,     0,  3727,  3352,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  3728,  3729,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  3466,     0,     0,     0,     0,     0,
    2572,     0,  2573,     0,     0,     0,   821,     0,     0,     0,
       0,     0,     0,     0,     0,  2575,     0,  2576,     0,     0,
       0,  3730,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2637,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2577,     0,     0,
    3731,     0,  2578,     0,     0,     0,     0,     0,     0,  3732,
    3733,     0,  3734,     0,     0,     0,     0,     0,     0,     0,
       0,  2581,     0,     0,     0,     0,     0,     0,     0,  2582,
       0,     0,     0,  3485,  3486,     0,     0,     0,     0,  2583,
       0,     0,     0,     0,     0,     0,  3735,  3736,  3737,     0,
       0,     0,     0,     0,     0,     0,  2584,     0,     0,     0,
       0,     0,     0,     0,     0,  3738,  3739,  3740,     0,     0,
    1562,     0,  3741,  2585,     0,  3742,     0,     0,     0,     0,
       0,  2586,     0,     0,     0,     0,     0,     0,  3467,     0,
       0,     0,  3743,  3744,     0,     0,  2589,     0,     0,     0,
       0,     0,  2590,     0,     0,  3517,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  3745,  3746,
       0,     0,     0,  2592,     0,     0,     0,  3556,  3557,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  3564,
       0,     0,     0,  3747,  3566,     0,     0,  3567,     0,  3568,
    3569,     0,     0,     0,     0,     0,     0,     0,     0,   273,
       0,   275,     0,     0,     0,     0,     0,  2594,     0,     0,
       0,     0,     0,     0,     0,  2595,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2596,     0,     0,     0,     0,     0,     0,     0,     0,  3748,
       0,     0,     0,  3749,     0,     0,     0,     0,     0,     0,
       0,   821,     0,  3595,  2597,     0,     0,  3750,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  3595,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   821,  2598,     0,
       0,     0,     0,     0,     0,   821,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2599,     0,     0,     0,
    2600,     0,     0,     0,  3751,     0,   821,  3752,     0,     0,
    3753,  3754,  3755,  3756,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  3595,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2602,     0,     0,     0,     0,     0,
       0,  2603,     0,  2604,  3757,  3758,     0,     0,     0,     0,
       0,  2606,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  3759,     0,     0,     0,     0,     0,     0,  3976,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2609,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2612,     0,     0,     0,     0,     0,     0,
     821,     0,     0,     0,   821,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   821,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2613,
    2614,  2615,     0,   821,     0,     0,  2616,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2617,     0,     0,     0,  2618,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2637,     0,     0,     0,     0,  2619,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2621,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  3595,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  3976,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  4172,     0,     0,
       0,     0,     0,     0,  3880,     0,     0,     0,     0,     0,
       0,     0,  3352,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  3908,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   821,     0,     0,     0,     0,
       0,     0,     0,   821,     0,     0,     0,     0,     0,   821,
       0,   821,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     821,     0,     0,     0,     0,     0,  4172,  4172,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  3352,     0,     0,
       0,  4015,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  4329,
       0,     0,     0,  4329,  4329,     0,     0,     0,     0,     0,
     821,     0,     0,     0,     0,     0,  3595,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    3352,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   821,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   821,
       0,   821,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   821,     0,  4172,  4172,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  4329,     0,     0,     0,     0,     0,     0,     0,
       0,  4329,     0,     0,     0,  4329,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  4329,     0,     0,
    4234,     0,     0,     0,     0,     0,  4239,     0,  4241,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     821,     0,  4172,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  4172,   821,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  4546,     0,     0,     0,     0,
       0,     0,   821,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  4291,     0,     0,
       0,     0,     0,     0,  4172,     0,     0,     0,     0,     0,
    4329,     0,  4329,  4329,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   821,  4172,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    4172,  4172,     0,     0,     0,     0,     0,  3352,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   821,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  3352,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  4172,     0,     0,
       0,     0,     0,     0,   821,     0,     0,  4172,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  4405,     0,  4406,     0,
       0,     0,   821,     0,     0,     0,     0,     0,  4414,  4172,
       0,  4172,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   821,     0,     0,   821,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  4172,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  4172,     0,  4172,     0,
    4172,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  4172,     0,     0,     0,     0,     0,
       0,  4172,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  4172,  4172,     0,     0,
       0,     0,   821,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  4172,  4172,     0,     0,     0,  4172,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  4526,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  4531,     0,     0,     0,     0,
       0,     0,   821,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  3595,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  4599,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  4653,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  4687,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  4704,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   142,     0,   143,   686,   145,
     146,   147,   148,     0,     0,   149,     0,     0,     0,   150,
       0,     0,   687,     0,   152,   153,   154,   155,   156,   157,
     688,   159,     0,   160,     0,     0,   689,   161,   690,   691,
     692,   162,   693,     0,   163,   164,   165,  1759,   166,  4756,
     167,   168,     0,     0,   169,   694,   695,   170,   171,     0,
     172,   696,   697,   174,   175,     0,   176,   177,   178,   179,
     180,   698,   182,     0,   699,   184,   700,   701,   702,   703,
     704,     0,   190,   191,   192,   193,   194,   195,   196,   197,
       0,   198,   199,     0,   200,   201,   202,   705,   204,  3595,
     205,   706,   707,   206,     0,     0,   207,   708,   208,   709,
     710,   209,     0,   210,   711,   712,     0,   211,   212,   213,
     713,   714,   715,     0,     0,     0,     0,   716,   216,   717,
       0,     0,   718,   217,     0,   218,     0,     0,     0,   219,
       0,   220,   221,   222,   223,   224,     0,     0,     0,   225,
       0,     0,   226,   227,   228,     0,     0,     0,   229,     0,
     230,   231,     0,   232,   233,   234,     0,     0,   235,   236,
       0,   237,   238,   239,   240,   241,   242,   243,   719,     0,
     244,   245,   246,   247,   720,   721,   248,   249,     0,   250,
     251,   252,   722,     0,   253,     0,     0,     0,   254,     0,
     255,     0,   256,     0,   257,   258,   723,   260,   724,   262,
     263,     0,   264,     0,   725,     0,   265,   266,   267,     0,
     268,   726,   727,     0,   269,   270,     0,     0,     0,   728,
     272,   273,   274,   275,   729,     0,   276,   277,   278,     0,
     279,     0,   280,     0,     0,     0,   730,   281,   282,   731,
       0,     0,   283,     0,   284,   285,     0,   286,   287,     0,
       0,     0,   288,     0,     0,   289,   290,   732,     0,  1760,
     292,     0,   733,   293,   294,     0,     0,     0,     0,     0,
     734,   296,     0,   297,     0,   298,     0,   299,   300,     0,
       0,   735,     0,     0,     0,     0,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,     0,   317,   318,   319,   320,   736,   321,   322,
     323,   324,   737,   325,   326,     0,     0,     0,     0,   327,
     328,   329,   330,   738,   332,     0,     0,   739,   334,   740,
     335,     0,   336,   741,   742,   743,   744,   745,   341,   342,
     343,   344,   345,     0,   746,   346,   347,     0,     0,   348,
     349,   350,   351,   747,   748,   749,   352,   353,     0,   750,
     751,   354,     0,   355,   356,   752,     0,   358,   359,   360,
     361,     0,   362,   363,     0,     0,     0,     0,     0,     0,
       0,     0,   364,   365,   366,     0,   753,   367,     0,   368,
       0,   369,   370,   754,   372,   373,   374,   375,   755,   756,
     378,   757,     0,   379,   380,   381,     0,   382,     0,   383,
     384,   385,   386,   387,     0,   758,   389,   390,     0,     0,
     391,     0,     0,     0,   392,   393,   394,   395,   396,     0,
       0,   397,   398,   399,   400,   401,     0,   402,   403,     0,
     404,   405,   406,   759,   760,   407,     0,   408,     0,   409,
     410,     0,   411,   412,     0,   413,     0,   761,     0,   762,
     415,   416,   417,   418,   419,   420,   763,   764,   423,   424,
     425,   426,     0,   765,   428,     0,     0,     0,   429,   430,
     431,   432,     0,     0,     0,   433,     0,     0,     0,   434,
       0,   435,   436,   437,   438,   439,   440,     0,   441,   442,
     443,   444,   445,   446,     0,     0,     0,     0,     0,     0,
     447,   448,     0,   449,     0,     0,   450,     0,     0,   451,
     452,     0,     0,     0,   453,   766,   767,   454,   455,     0,
     456,   457,   768,   459,   460,   461,   769,   770,   462,   463,
     464,   465,   771,   466,   467,     0,   468,     0,   469,   470,
     471,   472,     0,   772,   473,   474,     0,   773,   774,   775,
     776,     0,     0,     0,     0,  1761,   479,   480,   481,     0,
     777,   778,   779,   483,   484,   485,   780,   486,   487,   781,
     488,   489,     0,   490,   491,     0,     0,   492,     0,     0,
     493,     0,   494,     0,   782,   496,   497,     0,     0,   783,
     784,   785,   786,   498,     0,     0,   499,   787,     0,   788,
     500,   501,   502,   503,   504,   789,   790,     0,     0,     0,
       0,     0,     0,   507,   508,     0,   509,   510,   511,     0,
       0,   791,     0,     0,     0,     0,   792,   793,     0,     0,
       0,     0,   794,   795,     0,     0,   796,   797,     0,     0,
     798,   799,   142,     0,   143,   686,   145,   146,   147,   148,
    1973,     0,   149,     0,     0,     0,   150,     0,     0,   687,
       0,   152,   153,   154,   155,   156,   157,   688,   159,     0,
     160,     0,     0,  1974,   161,   690,   691,   692,   162,   693,
       0,   163,   164,   165,     0,   166,     0,   167,   168,     0,
       0,   169,   694,   695,   170,   171,     0,   172,   696,   697,
     174,   175,     0,   176,   177,   178,   179,   180,   698,   182,
       0,   699,   184,   700,   701,   702,   703,   704,     0,   190,
     191,   192,   193,   194,   195,   196,   197,     0,   198,   199,
       0,   200,   201,   202,   705,   204,     0,   205,   706,   707,
     206,     0,     0,   207,   708,   208,   709,   710,   209,     0,
     210,   711,   712,     0,   211,   212,   213,   713,   714,   715,
       0,     0,     0,     0,   716,   216,   717,     0,     0,  1975,
     217,     0,   218,     0,     0,     0,   219,     0,   220,   221,
     222,   223,   224,     0,     0,     0,   225,     0,     0,   226,
     227,   228,     0,     0,     0,   229,     0,   230,   231,     0,
     232,   233,   234,     0,     0,   235,   236,     0,   237,   238,
     239,   240,   241,   242,   243,   719,     0,   244,   245,   246,
     247,   720,   721,   248,   249,     0,   250,   251,   252,   722,
       0,   253,     0,     0,     0,   254,     0,   255,     0,   256,
       0,   257,   258,   723,   260,   724,   262,   263,     0,   264,
       0,   725,     0,   265,   266,   267,     0,   268,   726,   727,
       0,   269,   270,     0,     0,     0,   728,   272,   273,   274,
     275,   729,     0,   276,   277,   278,     0,   279,     0,   280,
       0,     0,     0,   730,   281,   282,   731,     0,     0,   283,
       0,   284,   285,     0,   286,   287,     0,     0,     0,   288,
       0,     0,   289,   290,   732,     0,     0,   292,     0,   733,
     293,   294,     0,     0,     0,     0,     0,   734,   296,     0,
     297,     0,   298,     0,   299,   300,     0,     0,   735,     0,
       0,     0,     0,   301,   302,   303,   304,   305,   306,   307,
     308,   309,   310,   311,   312,   313,   314,   315,   316,     0,
     317,   318,   319,   320,   736,   321,   322,   323,   324,   737,
     325,   326,     0,     0,     0,     0,   327,   328,   329,   330,
     738,   332,     0,     0,   739,   334,   740,   335,     0,   336,
     741,   742,   743,   744,   745,   341,   342,   343,   344,   345,
       0,   746,   346,   347,     0,     0,   348,   349,   350,   351,
     747,   748,   749,   352,   353,     0,   750,   751,   354,     0,
     355,   356,   752,  1976,   358,   359,   360,   361,     0,   362,
     363,     0,     0,     0,     0,     0,     0,     0,     0,   364,
     365,   366,     0,   753,   367,     0,   368,     0,   369,   370,
     754,   372,   373,   374,   375,   755,   756,   378,   757,     0,
     379,   380,   381,     0,   382,     0,   383,   384,   385,   386,
     387,     0,   758,   389,   390,     0,     0,   391,     0,     0,
       0,   392,   393,   394,   395,   396,     0,     0,   397,   398,
     399,   400,   401,     0,   402,   403,     0,   404,   405,   406,
     759,   760,   407,     0,   408,     0,   409,   410,     0,   411,
     412,     0,   413,     0,   761,     0,   762,   415,   416,   417,
     418,   419,   420,   763,   764,   423,   424,   425,   426,     0,
     765,   428,     0,     0,     0,   429,   430,   431,   432,     0,
       0,     0,   433,     0,     0,     0,   434,     0,   435,   436,
     437,   438,   439,   440,     0,   441,   442,   443,   444,   445,
     446,     0,     0,     0,     0,     0,     0,   447,   448,     0,
     449,     0,     0,   450,     0,     0,   451,   452,     0,     0,
       0,   453,   766,   767,   454,   455,     0,   456,   457,   768,
     459,   460,   461,   769,   770,   462,   463,   464,   465,   771,
     466,   467,     0,   468,     0,   469,   470,   471,   472,     0,
     772,   473,   474,     0,   773,   774,   775,   776,     0,     0,
       0,     0,     0,   479,   480,   481,     0,   777,   778,   779,
     483,   484,   485,   780,   486,   487,   781,   488,   489,     0,
     490,   491,     0,     0,   492,     0,     0,   493,     0,   494,
       0,   782,   496,   497,     0,     0,   783,   784,   785,   786,
     498,     0,     0,   499,   787,     0,   788,   500,   501,   502,
     503,   504,   789,   790,     0,     0,     0,     0,     0,     0,
     507,   508,     0,   509,   510,   511,     0,     0,   791,     0,
       0,     0,     0,   792,   793,     0,     0,     0,     0,   794,
     795,     0,     0,   796,   797,     0,     0,   798,   799,   142,
       0,   143,   686,   145,   146,   147,   148,     0,     0,   149,
       0,     0,     0,   150,     0,     0,   687,     0,   152,   153,
     154,   155,   156,   157,   688,   159,     0,   160,     0,     0,
     689,   161,   690,   691,   692,   162,   693,     0,   163,   164,
     165,     0,   166,     0,   167,   168,     0,     0,   169,   694,
     695,   170,   171,     0,   172,   696,   697,   174,   175,     0,
     176,   177,   178,   179,   180,   698,   182,     0,   699,   184,
     700,   701,   702,   703,   704,     0,   190,   191,   192,   193,
     194,   195,   196,   197,     0,   198,   199,     0,   200,   201,
     202,   705,   204,     0,   205,   706,   707,   206,     0,     0,
     207,   708,   208,   709,   710,   209,     0,   210,   711,   712,
       0,   211,   212,   213,   713,   714,   715,     0,     0,     0,
       0,   716,   216,   717,     0,     0,   718,   217,     0,   218,
       0,     0,     0,   219,     0,   220,   221,   222,   223,   224,
       0,     0,     0,   225,     0,     0,   226,   227,   228,     0,
       0,     0,   229,     0,   230,   231,     0,   232,   233,   234,
       0,     0,   235,   236,     0,   237,   238,   239,   240,   241,
     242,   243,   719,     0,   244,   245,   246,   247,   720,   721,
     248,   249,     0,   250,   251,   252,   722,     0,   253,     0,
       0,     0,   254,  2291,   255,     0,   256,     0,   257,   258,
     723,   260,   724,   262,   263,     0,   264,     0,   725,     0,
     265,   266,   267,     0,   268,   726,   727,     0,   269,   270,
       0,     0,     0,   728,   272,   273,   274,   275,   729,     0,
     276,   277,   278,     0,   279,     0,   280,     0,     0,     0,
     730,   281,   282,   731,     0,     0,   283,     0,   284,   285,
       0,   286,   287,     0,     0,     0,   288,     0,     0,   289,
     290,   732,     0,     0,   292,     0,   733,   293,   294,     0,
       0,     0,     0,     0,   734,   296,     0,   297,     0,   298,
       0,   299,   300,     0,     0,   735,     0,     0,     0,     0,
     301,   302,   303,   304,   305,   306,   307,   308,   309,   310,
     311,   312,   313,   314,   315,   316,     0,   317,   318,   319,
     320,   736,   321,   322,   323,   324,   737,   325,   326,     0,
       0,     0,     0,   327,   328,   329,   330,   738,   332,     0,
       0,   739,   334,   740,   335,     0,   336,   741,   742,   743,
     744,   745,   341,   342,   343,   344,   345,     0,   746,   346,
     347,     0,     0,   348,   349,   350,   351,   747,   748,   749,
     352,   353,     0,   750,   751,   354,     0,   355,   356,   752,
       0,   358,   359,   360,   361,     0,   362,   363,     0,     0,
       0,     0,     0,     0,     0,     0,   364,   365,   366,     0,
     753,   367,     0,   368,     0,   369,   370,   754,   372,   373,
     374,   375,   755,   756,   378,   757,     0,   379,   380,   381,
       0,   382,     0,   383,   384,   385,   386,   387,     0,   758,
     389,   390,     0,     0,   391,     0,     0,     0,   392,   393,
     394,   395,   396,     0,     0,   397,   398,   399,   400,   401,
       0,   402,   403,     0,   404,   405,   406,   759,   760,   407,
       0,   408,     0,   409,   410,     0,   411,   412,     0,   413,
       0,   761,     0,   762,   415,   416,   417,   418,   419,   420,
     763,   764,   423,   424,   425,   426,     0,   765,   428,     0,
       0,     0,   429,   430,   431,   432,     0,     0,     0,   433,
       0,     0,     0,   434,     0,   435,   436,   437,   438,   439,
     440,     0,   441,   442,   443,   444,   445,   446,     0,     0,
       0,     0,     0,     0,   447,   448,     0,   449,     0,     0,
     450,     0,     0,   451,   452,     0,     0,     0,   453,   766,
     767,   454,   455,     0,   456,   457,   768,   459,   460,   461,
     769,   770,   462,   463,   464,   465,   771,   466,   467,     0,
     468,     0,   469,   470,   471,   472,     0,   772,   473,   474,
       0,   773,   774,   775,   776,     0,     0,     0,     0,     0,
     479,   480,   481,     0,   777,   778,   779,   483,   484,   485,
     780,   486,   487,   781,   488,   489,     0,   490,   491,     0,
       0,   492,     0,     0,   493,     0,   494,     0,   782,   496,
     497,     0,     0,   783,   784,   785,   786,   498,     0,     0,
     499,   787,     0,   788,   500,   501,   502,   503,   504,   789,
     790,     0,     0,     0,     0,     0,     0,   507,   508,     0,
     509,   510,   511,     0,     0,   791,     0,     0,     0,     0,
     792,   793,     0,     0,     0,     0,   794,   795,     0,     0,
     796,   797,     0,     0,   798,   799,   142,     0,   143,   686,
     145,   146,   147,   148,     0,     0,   149,     0,     0,     0,
     150,     0,     0,   687,     0,   152,   153,   154,   155,   156,
     157,   688,   159,     0,   160,     0,     0,   689,   161,   690,
     691,   692,   162,   693,     0,   163,   164,   165,     0,   166,
       0,   167,   168,     0,     0,   169,   694,   695,   170,   171,
       0,   172,   696,   697,   174,   175,     0,   176,   177,   178,
     179,   180,   698,   182,     0,   699,   184,   700,   701,   702,
     703,   704,     0,   190,   191,   192,   193,   194,   195,   196,
     197,     0,   198,   199,     0,   200,   201,   202,   705,   204,
       0,   205,   706,   707,   206,     0,     0,   207,   708,   208,
     709,   710,   209,     0,   210,   711,   712,     0,   211,   212,
     213,   713,   714,   715,     0,     0,     0,     0,   716,   216,
     717,     0,     0,   718,   217,     0,   218,     0,     0,     0,
     219,     0,   220,   221,   222,   223,   224,     0,     0,     0,
     225,     0,     0,   226,   227,   228,     0,     0,     0,   229,
       0,   230,   231,     0,   232,   233,   234,     0,     0,   235,
     236,     0,   237,   238,   239,   240,   241,   242,   243,   719,
       0,   244,   245,   246,   247,   720,   721,   248,   249,     0,
     250,   251,   252,   722,     0,   253,     0,     0,     0,   254,
    2293,   255,     0,   256,     0,   257,   258,   723,   260,   724,
     262,   263,     0,   264,     0,   725,     0,   265,   266,   267,
       0,   268,   726,   727,     0,   269,   270,     0,     0,     0,
     728,   272,   273,   274,   275,   729,     0,   276,   277,   278,
       0,   279,     0,   280,     0,     0,     0,   730,   281,   282,
     731,     0,     0,   283,     0,   284,   285,     0,   286,   287,
       0,     0,     0,   288,     0,     0,   289,   290,   732,     0,
       0,   292,     0,   733,   293,   294,     0,     0,     0,     0,
       0,   734,   296,     0,   297,     0,   298,     0,   299,   300,
       0,     0,   735,     0,     0,     0,     0,   301,   302,   303,
     304,   305,   306,   307,   308,   309,   310,   311,   312,   313,
     314,   315,   316,     0,   317,   318,   319,   320,   736,   321,
     322,   323,   324,   737,   325,   326,     0,     0,     0,     0,
     327,   328,   329,   330,   738,   332,     0,     0,   739,   334,
     740,   335,     0,   336,   741,   742,   743,   744,   745,   341,
     342,   343,   344,   345,     0,   746,   346,   347,     0,     0,
     348,   349,   350,   351,   747,   748,   749,   352,   353,     0,
     750,   751,   354,     0,   355,   356,   752,     0,   358,   359,
     360,   361,     0,   362,   363,     0,     0,     0,     0,     0,
       0,     0,     0,   364,   365,   366,     0,   753,   367,     0,
     368,     0,   369,   370,   754,   372,   373,   374,   375,   755,
     756,   378,   757,     0,   379,   380,   381,     0,   382,     0,
     383,   384,   385,   386,   387,     0,   758,   389,   390,     0,
       0,   391,     0,     0,     0,   392,   393,   394,   395,   396,
       0,     0,   397,   398,   399,   400,   401,     0,   402,   403,
       0,   404,   405,   406,   759,   760,   407,     0,   408,     0,
     409,   410,     0,   411,   412,     0,   413,     0,   761,     0,
     762,   415,   416,   417,   418,   419,   420,   763,   764,   423,
     424,   425,   426,     0,   765,   428,     0,     0,     0,   429,
     430,   431,   432,     0,     0,     0,   433,     0,     0,     0,
     434,     0,   435,   436,   437,   438,   439,   440,     0,   441,
     442,   443,   444,   445,   446,     0,     0,     0,     0,     0,
       0,   447,   448,     0,   449,     0,     0,   450,     0,     0,
     451,   452,     0,     0,     0,   453,   766,   767,   454,   455,
       0,   456,   457,   768,   459,   460,   461,   769,   770,   462,
     463,   464,   465,   771,   466,   467,     0,   468,     0,   469,
     470,   471,   472,     0,   772,   473,   474,     0,   773,   774,
     775,   776,     0,     0,     0,     0,     0,   479,   480,   481,
       0,   777,   778,   779,   483,   484,   485,   780,   486,   487,
     781,   488,   489,     0,   490,   491,     0,     0,   492,     0,
       0,   493,     0,   494,     0,   782,   496,   497,     0,     0,
     783,   784,   785,   786,   498,     0,     0,   499,   787,     0,
     788,   500,   501,   502,   503,   504,   789,   790,     0,     0,
       0,     0,     0,     0,   507,   508,     0,   509,   510,   511,
       0,     0,   791,     0,     0,     0,     0,   792,   793,     0,
       0,     0,     0,   794,   795,     0,     0,   796,   797,     0,
       0,   798,   799,   142,     0,   143,   686,   145,   146,   147,
     148,     0,     0,   149,     0,     0,     0,   150,     0,     0,
     687,     0,   152,   153,   154,   155,   156,   157,   688,   159,
       0,   160,     0,     0,   689,   161,   690,   691,   692,   162,
     693,     0,   163,   164,   165,     0,   166,     0,   167,   168,
       0,     0,   169,   694,   695,   170,   171,     0,   172,   696,
     697,   174,   175,     0,   176,   177,   178,   179,   180,   698,
     182,     0,   699,   184,   700,   701,   702,   703,   704,     0,
     190,   191,   192,   193,   194,   195,   196,   197,     0,   198,
     199,     0,   200,   201,   202,   705,   204,     0,   205,   706,
     707,   206,     0,     0,   207,   708,   208,   709,   710,   209,
       0,   210,   711,   712,     0,   211,   212,   213,   713,   714,
     715,     0,     0,     0,     0,   716,   216,   717,     0,     0,
     718,   217,     0,   218,     0,     0,     0,   219,     0,   220,
     221,   222,   223,   224,     0,     0,     0,   225,     0,     0,
     226,   227,   228,     0,     0,     0,   229,     0,   230,   231,
       0,   232,   233,   234,     0,     0,   235,   236,     0,   237,
     238,   239,   240,   241,   242,   243,   719,     0,   244,   245,
     246,   247,   720,   721,   248,   249,     0,   250,   251,   252,
     722,     0,   253,     0,     0,     0,   254,  2295,   255,     0,
     256,     0,   257,   258,   723,   260,   724,   262,   263,     0,
     264,     0,   725,     0,   265,   266,   267,     0,   268,   726,
     727,     0,   269,   270,     0,     0,     0,   728,   272,   273,
     274,   275,   729,     0,   276,   277,   278,     0,   279,     0,
     280,     0,     0,     0,   730,   281,   282,   731,     0,     0,
     283,     0,   284,   285,     0,   286,   287,     0,     0,     0,
     288,     0,     0,   289,   290,   732,     0,     0,   292,     0,
     733,   293,   294,     0,     0,     0,     0,     0,   734,   296,
       0,   297,     0,   298,     0,   299,   300,     0,     0,   735,
       0,     0,     0,     0,   301,   302,   303,   304,   305,   306,
     307,   308,   309,   310,   311,   312,   313,   314,   315,   316,
       0,   317,   318,   319,   320,   736,   321,   322,   323,   324,
     737,   325,   326,     0,     0,     0,     0,   327,   328,   329,
     330,   738,   332,     0,     0,   739,   334,   740,   335,     0,
     336,   741,   742,   743,   744,   745,   341,   342,   343,   344,
     345,     0,   746,   346,   347,     0,     0,   348,   349,   350,
     351,   747,   748,   749,   352,   353,     0,   750,   751,   354,
       0,   355,   356,   752,     0,   358,   359,   360,   361,     0,
     362,   363,     0,     0,     0,     0,     0,     0,     0,     0,
     364,   365,   366,     0,   753,   367,     0,   368,     0,   369,
     370,   754,   372,   373,   374,   375,   755,   756,   378,   757,
       0,   379,   380,   381,     0,   382,     0,   383,   384,   385,
     386,   387,     0,   758,   389,   390,     0,     0,   391,     0,
       0,     0,   392,   393,   394,   395,   396,     0,     0,   397,
     398,   399,   400,   401,     0,   402,   403,     0,   404,   405,
     406,   759,   760,   407,     0,   408,     0,   409,   410,     0,
     411,   412,     0,   413,     0,   761,     0,   762,   415,   416,
     417,   418,   419,   420,   763,   764,   423,   424,   425,   426,
       0,   765,   428,     0,     0,     0,   429,   430,   431,   432,
       0,     0,     0,   433,     0,     0,     0,   434,     0,   435,
     436,   437,   438,   439,   440,     0,   441,   442,   443,   444,
     445,   446,     0,     0,     0,     0,     0,     0,   447,   448,
       0,   449,     0,     0,   450,     0,     0,   451,   452,     0,
       0,     0,   453,   766,   767,   454,   455,     0,   456,   457,
     768,   459,   460,   461,   769,   770,   462,   463,   464,   465,
     771,   466,   467,     0,   468,     0,   469,   470,   471,   472,
       0,   772,   473,   474,     0,   773,   774,   775,   776,     0,
       0,     0,     0,     0,   479,   480,   481,     0,   777,   778,
     779,   483,   484,   485,   780,   486,   487,   781,   488,   489,
       0,   490,   491,     0,     0,   492,     0,     0,   493,     0,
     494,     0,   782,   496,   497,     0,     0,   783,   784,   785,
     786,   498,     0,     0,   499,   787,     0,   788,   500,   501,
     502,   503,   504,   789,   790,     0,     0,     0,     0,     0,
       0,   507,   508,     0,   509,   510,   511,     0,     0,   791,
       0,     0,     0,     0,   792,   793,     0,     0,     0,     0,
     794,   795,     0,     0,   796,   797,     0,     0,   798,   799,
     142,     0,   143,   686,   145,   146,   147,   148,     0,     0,
     149,     0,     0,     0,   150,     0,     0,   687,     0,   152,
     153,   154,   155,   156,   157,   688,   159,     0,   160,     0,
       0,   689,   161,   690,   691,   692,   162,   693,     0,   163,
     164,   165,     0,   166,     0,   167,   168,     0,     0,   169,
     694,   695,   170,   171,     0,   172,   696,   697,   174,   175,
       0,   176,   177,   178,   179,   180,   698,   182,     0,   699,
     184,   700,   701,   702,   703,   704,     0,   190,   191,   192,
     193,   194,   195,   196,   197,     0,   198,   199,     0,   200,
     201,   202,   705,   204,     0,   205,   706,   707,   206,     0,
       0,   207,   708,   208,   709,   710,   209,     0,   210,   711,
     712,     0,   211,   212,   213,   713,   714,   715,     0,     0,
       0,     0,   716,   216,   717,     0,     0,   718,   217,     0,
     218,     0,     0,     0,   219,     0,   220,   221,   222,   223,
     224,     0,     0,     0,   225,     0,     0,   226,   227,   228,
       0,     0,     0,   229,     0,   230,   231,     0,   232,   233,
     234,     0,     0,   235,   236,     0,   237,   238,   239,   240,
     241,   242,   243,   719,     0,   244,   245,   246,   247,   720,
     721,   248,   249,     0,   250,   251,   252,   722,     0,   253,
       0,     0,     0,   254,     0,   255,     0,   256,     0,   257,
     258,   723,   260,   724,   262,   263,     0,   264,     0,   725,
       0,   265,   266,   267,     0,   268,   726,   727,     0,   269,
     270,     0,     0,     0,   728,   272,   273,   274,   275,   729,
       0,   276,   277,   278,     0,   279,     0,   280,     0,     0,
       0,   730,   281,   282,   731,     0,     0,   283,     0,   284,
     285,     0,   286,   287,     0,     0,     0,   288,     0,     0,
     289,   290,   732,     0,     0,   292,     0,   733,   293,   294,
       0,     0,     0,     0,     0,   734,   296,     0,   297,     0,
     298,     0,   299,   300,     0,     0,   735,     0,     0,     0,
       0,   301,   302,   303,   304,   305,   306,   307,   308,   309,
     310,   311,   312,   313,   314,   315,   316,     0,   317,   318,
     319,   320,   736,   321,   322,   323,   324,   737,   325,   326,
       0,     0,     0,     0,   327,   328,   329,   330,   738,   332,
       0,     0,   739,   334,   740,   335,     0,   336,   741,   742,
     743,   744,   745,   341,   342,   343,   344,   345,     0,   746,
     346,   347,     0,     0,   348,   349,   350,   351,   747,   748,
     749,   352,   353,     0,   750,   751,   354,     0,   355,   356,
     752,     0,   358,   359,   360,   361,     0,   362,   363,     0,
       0,     0,     0,     0,     0,     0,     0,   364,   365,   366,
       0,   753,   367,     0,   368,     0,   369,   370,   754,   372,
     373,   374,   375,   755,   756,   378,   757,     0,   379,   380,
     381,     0,   382,     0,   383,   384,   385,   386,   387,     0,
     758,   389,   390,     0,     0,   391,     0,     0,     0,   392,
     393,   394,   395,   396,     0,     0,   397,   398,   399,   400,
     401,     0,   402,   403,     0,   404,   405,   406,   759,   760,
     407,     0,   408,     0,   409,   410,     0,   411,   412,     0,
     413,     0,   761,     0,   762,   415,   416,   417,   418,   419,
     420,   763,   764,   423,   424,   425,   426,     0,   765,   428,
       0,     0,     0,   429,   430,   431,   432,     0,     0,     0,
     433,     0,     0,     0,   434,     0,   435,   436,   437,   438,
     439,   440,     0,   441,   442,   443,   444,   445,   446,     0,
       0,     0,     0,     0,     0,   447,   448,     0,   449,     0,
       0,   450,     0,     0,   451,   452,     0,     0,     0,   453,
     766,   767,   454,   455,     0,   456,   457,   768,   459,   460,
     461,   769,   770,   462,   463,   464,   465,   771,   466,   467,
       0,   468,     0,   469,   470,   471,   472,     0,   772,   473,
     474,     0,   773,   774,   775,   776,     0,     0,     0,     0,
       0,   479,   480,   481,     0,   777,   778,   779,   483,   484,
     485,   780,   486,   487,   781,   488,   489,     0,   490,   491,
       0,     0,   492,     0,     0,   493,     0,   494,     0,   782,
     496,   497,     0,     0,   783,   784,   785,   786,   498,     0,
       0,   499,   787,     0,   788,   500,   501,   502,   503,   504,
     789,   790,     0,     0,     0,     0,     0,     0,   507,   508,
       0,   509,   510,   511,     0,     0,   791,     0,     0,     0,
       0,   792,   793,     0,     0,     0,     0,   794,   795,     0,
       0,   796,   797,     0,     0,   798,   799,   142,     0,   143,
     686,   145,   146,   147,   148,     0,     0,   149,     0,     0,
       0,   150,     0,     0,   687,     0,   152,   153,   154,   155,
     156,   157,   688,   159,     0,   160,     0,     0,   689,   161,
     690,   691,   692,   162,   693,     0,   163,   164,   165,     0,
     166,     0,   167,   168,     0,     0,   169,   694,   695,   170,
     171,     0,   172,   696,   697,   174,   175,     0,   176,   177,
     178,   179,   180,   698,   182,     0,   699,   184,   700,   701,
     702,   703,   704,     0,   190,   191,   192,   193,   194,   195,
     196,   197,     0,   198,   199,     0,   200,   201,   202,   705,
     204,     0,   205,   706,   707,   206,     0,     0,   207,   708,
     208,   709,   710,   209,     0,   210,   711,   712,     0,   211,
     212,   213,   713,   714,   715,     0,     0,     0,     0,   716,
     216,   717,     0,     0,   718,   217,     0,   218,     0,     0,
       0,   219,     0,   220,   221,   222,   223,   224,     0,     0,
       0,   225,     0,     0,   226,   227,   228,     0,     0,     0,
     229,     0,   230,   231,     0,   232,   233,   234,     0,     0,
     235,   236,     0,   237,   238,   239,   240,   241,   242,   243,
     719,     0,   244,   245,   246,   247,   720,   721,   248,   249,
       0,   250,   251,   252,   722,     0,   253,     0,     0,     0,
     254,     0,   255,     0,   256,     0,   257,   258,   723,   260,
     724,   262,   263,     0,   264,     0,   725,     0,   265,   266,
     267,     0,   268,   726,   727,     0,   269,   270,     0,     0,
       0,   728,   272,   273,   274,   275,   729,     0,   276,   277,
     278,     0,   279,     0,   280,     0,     0,     0,   730,   281,
     282,   731,     0,     0,   283,     0,   284,   285,     0,   286,
     287,     0,     0,     0,   288,     0,     0,   289,   290,   732,
       0,     0,   292,     0,   733,   293,   294,     0,     0,     0,
       0,     0,   734,   296,     0,   297,     0,   298,     0,   299,
     300,     0,     0,   735,     0,     0,     0,     0,   301,   302,
     303,   304,   305,   306,   307,   308,   309,   310,   311,   312,
     313,   314,   315,   316,     0,   317,   318,   319,   320,   736,
     321,   322,   323,   324,   737,   325,   326,     0,     0,     0,
       0,   327,   328,   329,   330,   738,   332,     0,     0,   739,
     334,   740,   335,     0,   336,   741,   742,   743,   744,   745,
     341,   342,   343,   344,   345,     0,   746,   346,   347,     0,
       0,   348,   349,   350,   351,   747,   748,   749,   352,   353,
       0,   750,   751,   354,     0,   355,   356,   752,     0,   358,
     359,   360,   361,     0,   362,   363,     0,     0,     0,     0,
       0,     0,     0,     0,   364,   365,   366,     0,   753,   367,
       0,   368,     0,   369,   370,   754,   372,   373,   374,   375,
     755,   756,   378,   757,     0,   379,   380,   381,     0,   382,
       0,   383,   384,   385,   386,   387,     0,   758,   389,   390,
       0,     0,   391,     0,     0,     0,   392,   393,   394,   395,
     396,     0,     0,   397,   398,   399,   400,   401,     0,   402,
     403,     0,   404,   405,   406,   759,   760,   407,     0,   408,
       0,   409,   410,     0,   411,   412,     0,   413,     0,   761,
       0,   762,   415,   416,   417,   418,   419,   420,   763,   764,
     423,   424,   425,   426,     0,   765,   428,     0,     0,     0,
     429,   430,   431,   432,     0,     0,     0,   433,     0,     0,
       0,   434,     0,   435,   436,   437,   438,   439,   440,     0,
     441,   442,   443,   444,   445,   446,     0,     0,     0,     0,
       0,     0,   447,   448,     0,   449,     0,     0,   450,     0,
       0,   451,   452,     0,     0,     0,   453,   766,   767,   454,
     455,     0,   456,   457,   768,   459,   460,   461,   769,   770,
     462,   463,   464,   465,   771,   466,   467,     0,   468,     0,
     469,   470,   471,   472,     0,   772,   473,   474,     0,   773,
     774,   775,   776,     0,     0,     0,     0,     0,   479,   480,
     481,     0,   777,   778,   779,   483,   484,   485,   780,   486,
     487,   781,   488,   489,     0,   490,   491,     0,     0,   492,
       0,     0,   493,     0,   494,     0,   782,   496,   497,     0,
       0,   783,   784,   785,   786,   498,     0,     0,   499,   787,
       0,   788,   500,   501,   502,   503,   504,   789,   790,     0,
       0,     0,     0,     0,     0,   507,   508,     0,   509,   510,
     511,     0,     0,   791,     0,     0,     0,     0,   792,   793,
       0,     0,     0,     0,   794,  1163,     0,     0,   796,   797,
       0,     0,   798,   799,   142,     0,   143,   686,   145,   146,
     147,   148,  1794,     0,   149,     0,     0,     0,  1795,     0,
       0,   687,     0,   152,   153,   154,   155,   156,   157,   688,
     159,     0,   160,     0,     0,   689,   161,   690,   691,   692,
     162,   693,     0,   163,   164,   165,     0,   166,     0,   167,
     168,     0,     0,   169,   694,   695,   170,   171,     0,   172,
     696,   697,   174,   175,     0,   176,   177,   178,   179,   180,
     698,   182,     0,   699,   184,   700,   701,   702,   703,   704,
       0,   190,   191,   192,   193,   194,   195,   196,   197,     0,
     198,   199,     0,   200,   201,   202,   705,   204,     0,   205,
     706,   707,   206,     0,     0,   207,   708,   208,   709,   710,
     209,     0,   210,   711,   712,     0,   211,   212,   213,   713,
     714,   715,     0,     0,     0,     0,   716,   216,   717,     0,
       0,   718,   217,     0,   218,     0,     0,     0,   219,     0,
     220,   221,   222,   223,   224,     0,     0,     0,   225,     0,
       0,   226,   227,   228,     0,     0,     0,   229,     0,   230,
     231,     0,   232,   233,   234,     0,     0,   235,   236,     0,
     237,   238,   239,   240,   241,   242,   243,   719,     0,   244,
     245,   246,   247,   720,   721,   248,   249,     0,   250,   251,
     252,   722,     0,   253,     0,     0,     0,   254,     0,   255,
       0,   256,     0,   257,   258,   723,   260,   724,   262,   263,
       0,   264,     0,   725,     0,   265,   266,   267,     0,   268,
     726,   727,     0,   269,   270,     0,     0,     0,   728,   272,
     273,   274,   275,   729,     0,   276,   277,   278,     0,   279,
       0,   280,     0,     0,     0,   730,   281,   282,   731,     0,
       0,   283,     0,   284,   285,     0,   286,   287,     0,     0,
       0,   288,     0,     0,   289,   290,   732,     0,     0,   292,
       0,   733,   293,   294,     0,     0,     0,     0,     0,   734,
     296,     0,   297,     0,   298,     0,   299,   300,     0,     0,
     735,     0,     0,     0,     0,   301,   302,   303,   304,   305,
     306,   307,   308,   309,   310,   311,   312,   313,   314,   315,
     316,     0,   317,   318,   319,   320,   736,   321,   322,   323,
     324,   737,   325,   326,     0,     0,     0,     0,   327,   328,
     329,   330,   738,   332,     0,     0,   739,   334,   740,   335,
       0,   336,   741,   742,   743,   744,   745,   341,   342,   343,
     344,   345,     0,   746,   346,   347,     0,     0,   348,   349,
     350,   351,   747,     0,   749,   352,   353,     0,   750,   751,
     354,     0,   355,   356,   752,     0,   358,   359,   360,   361,
       0,   362,   363,     0,     0,     0,     0,     0,     0,     0,
       0,   364,   365,   366,     0,   753,   367,     0,   368,     0,
     369,   370,   754,   372,   373,   374,   375,   755,   756,   378,
     757,     0,   379,   380,   381,     0,   382,     0,   383,   384,
     385,   386,   387,     0,   758,   389,   390,     0,     0,   391,
       0,     0,     0,   392,   393,   394,   395,   396,     0,     0,
     397,   398,   399,   400,   401,     0,   402,   403,     0,   404,
     405,   406,   759,   760,   407,     0,   408,     0,   409,   410,
       0,   411,   412,     0,   413,     0,   761,     0,   762,   415,
     416,   417,   418,   419,   420,   763,   764,   423,   424,   425,
     426,     0,   765,   428,     0,     0,     0,   429,   430,   431,
     432,     0,     0,     0,   433,     0,     0,     0,   434,     0,
     435,   436,   437,   438,   439,   440,     0,   441,   442,   443,
     444,   445,   446,     0,     0,     0,     0,     0,     0,   447,
     448,     0,   449,     0,     0,   450,     0,     0,   451,   452,
       0,     0,     0,   453,   766,   767,   454,   455,     0,   456,
     457,   768,   459,   460,   461,   769,   770,   462,   463,   464,
     465,   771,   466,   467,     0,   468,     0,   469,   470,   471,
     472,     0,   772,   473,   474,     0,   773,   774,   775,   776,
       0,     0,     0,     0,     0,   479,   480,   481,     0,   777,
     778,   779,   483,   484,   485,   780,   486,   487,   781,   488,
     489,     0,   490,   491,     0,     0,   492,     0,     0,   493,
       0,   494,     0,   782,   496,   497,     0,     0,   783,   784,
     785,   786,   498,     0,     0,   499,   787,     0,   788,   500,
     501,   502,   503,   504,   789,   790,     0,     0,     0,     0,
       0,     0,   507,   508,     0,   509,   510,   511,     0,     0,
     791,     0,     0,     0,     0,   792,   793,     0,     0,     0,
       0,   794,   795,     0,     0,   796,   797,     0,     0,   798,
     799,   142,     0,   143,   686,   145,   146,   147,   148,     0,
       0,   149,     0,     0,     0,   150,     0,     0,   687,     0,
     152,   153,   154,   155,   156,   157,   688,   159,     0,   160,
       0,     0,   689,   161,   690,   691,   692,   162,   693,     0,
     163,   164,   165,     0,   166,     0,   167,   168,     0,     0,
     169,   694,   695,   170,   171,     0,   172,   696,   697,   174,
     175,     0,   176,   177,   178,   179,   180,   698,   182,     0,
     699,   184,   700,   701,   702,   703,   704,     0,   190,   191,
     192,   193,   194,   195,   196,   197,     0,   198,   199,     0,
     200,   201,   202,   705,   204,     0,   205,   706,   707,   206,
       0,     0,   207,   708,   208,   709,   710,   209,     0,   210,
     711,   712,     0,   211,   212,   213,   713,   714,   715,     0,
       0,     0,     0,   716,   216,   717,     0,     0,   718,   217,
       0,   218,     0,     0,     0,   219,     0,   220,   221,   222,
     223,   224,     0,     0,     0,   225,     0,     0,   226,   227,
     228,     0,     0,     0,   229,     0,   230,   231,     0,   232,
     233,   234,     0,     0,   235,   236,     0,   237,   238,   239,
     240,   241,   242,   243,   719,     0,   244,   245,   246,   247,
     720,   721,   248,   249,     0,   250,   251,   252,   722,     0,
     253,     0,     0,     0,   254,     0,   255,     0,   256,     0,
     257,   258,   723,   260,   724,   262,   263,     0,   264,     0,
     725,     0,   265,   266,   267,     0,   268,   726,   727,     0,
     269,   270,     0,     0,     0,   728,   272,   273,   274,   275,
     729,     0,   276,   277,   278,     0,   279,     0,   280,     0,
       0,     0,   730,   281,   282,   731,     0,     0,   283,     0,
     284,   285,     0,   286,   287,     0,     0,     0,   288,     0,
       0,   289,   290,   732,     0,     0,   292,     0,   733,   293,
     294,     0,     0,     0,     0,     0,   734,   296,     0,   297,
       0,   298,     0,   299,   300,     0,     0,   735,     0,     0,
       0,     0,   301,   302,   303,   304,   305,   306,   307,   308,
     309,   310,   311,   312,   313,   314,   315,   316,     0,   317,
     318,   319,   320,   736,   321,   322,   323,   324,   737,   325,
     326,     0,     0,     0,     0,   327,   328,   329,   330,   738,
     332,     0,     0,   739,   334,   740,   335,     0,   336,   741,
     742,   743,   744,   745,   341,   342,   343,   344,   345,     0,
     746,   346,   347,     0,     0,   348,   349,   350,   351,   747,
     748,   749,   352,   353,     0,   750,   751,   354,     0,   355,
     356,   752,     0,   358,   359,   360,   361,     0,   362,   363,
       0,     0,     0,     0,     0,     0,     0,     0,   364,   365,
     366,     0,   753,   367,     0,   368,     0,   369,   370,   754,
     372,   373,   374,   375,   755,   756,   378,   757,     0,   379,
     380,   381,     0,   382,     0,   383,   384,   385,   386,   387,
       0,   758,   389,   390,     0,     0,   391,     0,     0,     0,
     392,   393,   394,   395,   396,     0,     0,   397,   398,   399,
     400,   401,     0,   402,   403,     0,   404,   405,   406,   759,
     760,   407,     0,   408,     0,   409,   410,     0,   411,   412,
       0,   413,     0,   761,     0,   762,   415,   416,   417,   418,
     419,   420,   763,   764,   423,   424,   425,   426,     0,   765,
     428,     0,     0,     0,   429,   430,   431,   432,     0,     0,
       0,   433,     0,     0,     0,   434,     0,   435,   436,   437,
     438,   439,   440,     0,   441,   442,   443,   444,   445,   446,
       0,     0,     0,     0,     0,     0,   447,   448,     0,   449,
       0,     0,   450,     0,     0,   451,   452,     0,     0,     0,
     453,   766,   767,   454,   455,     0,   456,   457,   768,   459,
     460,   461,   769,   770,   462,   463,   464,   465,   771,   466,
     467,     0,   468,     0,   469,   470,   471,   472,     0,   772,
     473,   474,     0,   773,   774,   775,   776,     0,     0,     0,
       0,     0,   479,   480,   481,     0,   777,   778,   779,   483,
     484,   485,   780,   486,   487,   781,   488,   489,     0,   490,
     491,     0,     0,   492,     0,     0,   493,     0,   494,     0,
    1891,   496,   497,     0,     0,   783,   784,   785,   786,   498,
       0,     0,   499,   787,     0,   788,   500,   501,   502,   503,
     504,   789,   790,     0,     0,     0,     0,     0,     0,   507,
     508,     0,   509,   510,   511,     0,     0,   791,     0,     0,
       0,     0,   792,   793,     0,     0,     0,     0,   794,   795,
       0,     0,   796,   797,     0,     0,   798,   799,   142,     0,
     143,   686,   145,   146,   147,   148,     0,     0,   149,     0,
       0,     0,   150,     0,     0,   687,     0,   152,   153,   154,
     155,   156,   157,   688,   159,     0,   160,     0,     0,   689,
     161,   690,   691,   692,   162,   693,     0,   163,   164,   165,
       0,   166,     0,   167,   168,     0,     0,   169,   694,   695,
     170,   171,     0,   172,   696,   697,   174,   175,     0,   176,
     177,   178,   179,   180,   698,   182,     0,   699,   184,   700,
     701,   702,   703,   704,     0,   190,   191,   192,   193,   194,
     195,   196,   197,     0,   198,   199,     0,   200,   201,   202,
     705,   204,     0,   205,   706,   707,   206,     0,     0,   207,
     708,   208,   709,   710,   209,     0,   210,   711,   712,     0,
     211,   212,   213,   713,   714,   715,     0,     0,     0,     0,
     716,   216,   717,     0,     0,   718,   217,     0,   218,     0,
       0,     0,   219,     0,   220,   221,   222,   223,   224,     0,
       0,     0,   225,     0,     0,   226,   227,   228,     0,     0,
       0,   229,     0,   230,   231,     0,   232,   233,   234,     0,
       0,   235,   236,     0,   237,   238,   239,   240,   241,   242,
     243,   719,     0,   244,   245,   246,   247,   720,   721,   248,
     249,     0,   250,   251,   252,   722,     0,   253,     0,     0,
       0,   254,     0,   255,     0,   256,     0,   257,   258,   723,
     260,   724,   262,   263,     0,   264,     0,   725,     0,   265,
     266,   267,     0,   268,   726,   727,     0,   269,   270,     0,
       0,     0,   728,   272,   273,   274,   275,   729,     0,   276,
     277,   278,     0,   279,     0,   280,     0,     0,     0,   730,
     281,   282,  2708,     0,     0,   283,     0,   284,   285,     0,
     286,   287,     0,     0,     0,   288,     0,     0,   289,   290,
     732,     0,     0,   292,     0,   733,   293,   294,     0,     0,
       0,     0,     0,   734,   296,     0,   297,     0,   298,     0,
     299,   300,     0,     0,   735,     0,     0,     0,     0,   301,
     302,   303,   304,   305,   306,   307,   308,   309,   310,   311,
     312,   313,   314,   315,   316,     0,   317,   318,   319,   320,
     736,   321,   322,   323,   324,   737,   325,   326,     0,     0,
       0,     0,   327,   328,   329,   330,   738,   332,     0,     0,
     739,   334,   740,   335,     0,   336,   741,   742,   743,   744,
     745,   341,   342,   343,   344,   345,     0,   746,   346,   347,
       0,     0,   348,   349,   350,   351,   747,   748,   749,   352,
     353,     0,   750,   751,   354,     0,   355,   356,   752,     0,
     358,   359,   360,   361,     0,   362,   363,     0,     0,     0,
       0,     0,     0,     0,     0,   364,   365,   366,     0,   753,
     367,     0,   368,     0,   369,   370,   754,   372,   373,   374,
     375,   755,   756,   378,   757,     0,   379,   380,   381,     0,
     382,     0,   383,   384,   385,   386,   387,     0,   758,   389,
     390,     0,     0,   391,     0,     0,     0,   392,   393,   394,
     395,   396,     0,     0,   397,   398,   399,   400,   401,     0,
     402,   403,     0,   404,   405,   406,   759,   760,   407,     0,
     408,     0,   409,   410,     0,   411,   412,     0,   413,     0,
     761,     0,   762,   415,   416,   417,   418,   419,   420,   763,
     764,   423,   424,   425,   426,     0,   765,   428,     0,     0,
       0,   429,   430,   431,   432,     0,     0,     0,   433,     0,
       0,     0,   434,     0,   435,   436,   437,   438,   439,   440,
       0,   441,   442,   443,   444,   445,   446,     0,     0,     0,
       0,     0,     0,   447,   448,     0,   449,     0,     0,   450,
       0,     0,   451,   452,     0,     0,     0,   453,   766,   767,
     454,   455,     0,   456,   457,   768,   459,   460,   461,   769,
     770,   462,   463,   464,   465,   771,   466,   467,     0,   468,
       0,   469,   470,   471,   472,     0,   772,   473,   474,     0,
     773,   774,   775,   776,     0,     0,     0,     0,     0,   479,
     480,   481,     0,   777,   778,   779,   483,   484,   485,   780,
     486,   487,   781,   488,   489,     0,   490,   491,     0,     0,
     492,     0,     0,   493,     0,   494,     0,   782,   496,   497,
       0,     0,   783,   784,   785,   786,   498,     0,     0,   499,
     787,     0,   788,   500,   501,   502,   503,   504,   789,   790,
       0,     0,     0,     0,     0,     0,   507,   508,     0,   509,
     510,   511,     0,     0,   791,     0,     0,     0,     0,   792,
     793,     0,     0,     0,     0,   794,   795,     0,     0,   796,
     797,     0,     0,   798,   799,   142,     0,   143,   686,   145,
     146,   147,   148,     0,     0,   149,     0,     0,     0,   150,
       0,     0,   687,     0,   152,   153,   154,   155,   156,   157,
     688,   159,     0,   160,     0,     0,   689,   161,   690,   691,
     692,   162,   693,     0,   163,   164,   165,     0,   166,     0,
     167,   168,     0,     0,   169,   694,   695,   170,   171,     0,
     172,   696,   697,   174,   175,     0,   176,   177,   178,   179,
     180,   698,   182,     0,   699,   184,   700,   701,   702,   703,
     704,     0,   190,   191,   192,   193,   194,   195,   196,   197,
       0,   198,   199,     0,   200,   201,   202,   705,   204,     0,
     205,   706,   707,   206,     0,     0,   207,   708,   208,   709,
     710,   209,     0,   210,   711,   712,     0,   211,   212,   213,
     713,   714,   715,     0,     0,     0,     0,   716,   216,   717,
       0,     0,   718,   217,     0,   218,     0,     0,     0,   219,
       0,   220,   221,   222,   223,   224,     0,     0,     0,   225,
       0,     0,   226,   227,   228,     0,     0,     0,   229,     0,
     230,   231,     0,   232,   233,   234,     0,     0,   235,   236,
       0,   237,   238,   239,   240,   241,   242,   243,   719,     0,
     244,   245,   246,   247,   720,   721,   248,   249,     0,   250,
     251,   252,   722,     0,   253,     0,     0,     0,   254,     0,
     255,     0,   256,     0,   257,   258,   723,   260,   724,   262,
     263,     0,   264,     0,   725,     0,   265,   266,   267,     0,
     268,   726,   727,     0,   269,   270,     0,     0,     0,   728,
     272,   273,   274,   275,   729,     0,   276,   277,   278,     0,
     279,     0,   280,     0,     0,     0,   730,   281,   282,  2759,
       0,     0,   283,     0,   284,   285,     0,   286,   287,     0,
       0,     0,   288,     0,     0,   289,   290,   732,     0,     0,
     292,     0,   733,   293,   294,     0,     0,     0,     0,     0,
     734,   296,     0,   297,     0,   298,     0,   299,   300,     0,
       0,   735,     0,     0,     0,     0,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,     0,   317,   318,   319,   320,   736,   321,   322,
     323,   324,   737,   325,   326,     0,     0,     0,     0,   327,
     328,   329,   330,   738,   332,     0,     0,   739,   334,   740,
     335,     0,   336,   741,   742,   743,   744,   745,   341,   342,
     343,   344,   345,     0,   746,   346,   347,     0,     0,   348,
     349,   350,   351,   747,   748,   749,   352,   353,     0,   750,
     751,   354,     0,   355,   356,   752,     0,   358,   359,   360,
     361,     0,   362,   363,     0,     0,     0,     0,     0,     0,
       0,     0,   364,   365,   366,     0,   753,   367,     0,   368,
       0,   369,   370,   754,   372,   373,   374,   375,   755,   756,
     378,   757,     0,   379,   380,   381,     0,   382,     0,   383,
     384,   385,   386,   387,     0,   758,   389,   390,     0,     0,
     391,     0,     0,     0,   392,   393,   394,   395,   396,     0,
       0,   397,   398,   399,   400,   401,     0,   402,   403,     0,
     404,   405,   406,   759,   760,   407,     0,   408,     0,   409,
     410,     0,   411,   412,     0,   413,     0,   761,     0,   762,
     415,   416,   417,   418,   419,   420,   763,   764,   423,   424,
     425,   426,     0,   765,   428,     0,     0,     0,   429,   430,
     431,   432,     0,     0,     0,   433,     0,     0,     0,   434,
       0,   435,   436,   437,   438,   439,   440,     0,   441,   442,
     443,   444,   445,   446,     0,     0,     0,     0,     0,     0,
     447,   448,     0,   449,     0,     0,   450,     0,     0,   451,
     452,     0,     0,     0,   453,   766,   767,   454,   455,     0,
     456,   457,   768,   459,   460,   461,   769,   770,   462,   463,
     464,   465,   771,   466,   467,     0,   468,     0,   469,   470,
     471,   472,     0,   772,   473,   474,     0,   773,   774,   775,
     776,     0,     0,     0,     0,     0,   479,   480,   481,     0,
     777,   778,   779,   483,   484,   485,   780,   486,   487,   781,
     488,   489,     0,   490,   491,     0,     0,   492,     0,     0,
     493,     0,   494,     0,   782,   496,   497,     0,     0,   783,
     784,   785,   786,   498,     0,     0,   499,   787,     0,   788,
     500,   501,   502,   503,   504,   789,   790,     0,     0,     0,
       0,     0,     0,   507,   508,     0,   509,   510,   511,     0,
       0,   791,     0,     0,     0,     0,   792,   793,     0,     0,
       0,     0,   794,   795,     0,     0,   796,   797,     0,     0,
     798,   799,   142,     0,   143,   686,   145,   146,   147,   148,
       0,     0,   149,     0,     0,     0,   150,     0,     0,   687,
       0,   152,   153,   154,   155,   156,   157,   688,   159,     0,
     160,     0,     0,   689,   161,   690,   691,   692,   162,   693,
       0,   163,   164,   165,     0,   166,     0,   167,   168,     0,
       0,   169,   694,   695,   170,   171,     0,   172,   696,   697,
     174,   175,     0,   176,   177,   178,   179,   180,   698,   182,
       0,   699,   184,   700,   701,   702,   703,   704,     0,   190,
     191,   192,   193,   194,   195,   196,   197,     0,   198,   199,
       0,   200,   201,   202,   705,   204,     0,   205,   706,   707,
     206,     0,     0,   207,   708,   208,   709,   710,   209,     0,
     210,   711,   712,     0,   211,   212,   213,   713,   714,   715,
       0,     0,     0,     0,   716,   216,   717,     0,     0,  3594,
     217,     0,   218,     0,     0,     0,   219,     0,   220,   221,
     222,   223,   224,     0,     0,     0,   225,     0,     0,   226,
     227,   228,     0,     0,     0,   229,     0,   230,   231,     0,
     232,   233,   234,     0,     0,   235,   236,     0,   237,   238,
     239,   240,   241,   242,   243,   719,     0,   244,   245,   246,
     247,   720,   721,   248,   249,     0,   250,   251,   252,   722,
       0,   253,     0,     0,     0,   254,     0,   255,     0,   256,
       0,   257,   258,   723,   260,   724,   262,   263,     0,   264,
       0,   725,     0,   265,   266,   267,     0,   268,   726,   727,
       0,   269,   270,     0,     0,     0,   728,   272,   273,   274,
     275,   729,     0,   276,   277,   278,     0,   279,     0,   280,
       0,     0,     0,   730,   281,   282,   731,     0,     0,   283,
       0,   284,   285,     0,   286,   287,     0,     0,     0,   288,
       0,     0,   289,   290,   732,     0,     0,   292,     0,   733,
     293,   294,     0,     0,     0,     0,     0,   734,   296,     0,
     297,     0,   298,     0,   299,   300,     0,     0,   735,     0,
       0,     0,     0,   301,   302,   303,   304,   305,   306,   307,
     308,   309,   310,   311,   312,   313,   314,   315,   316,     0,
     317,   318,   319,   320,   736,   321,   322,   323,   324,   737,
     325,   326,     0,     0,     0,     0,   327,   328,   329,   330,
     738,   332,     0,     0,   739,   334,   740,   335,     0,   336,
     741,   742,   743,   744,   745,   341,   342,   343,   344,   345,
       0,   746,   346,   347,     0,     0,   348,   349,   350,   351,
     747,   748,   749,   352,   353,     0,   750,   751,   354,     0,
     355,   356,   752,     0,   358,   359,   360,   361,     0,   362,
     363,     0,     0,     0,     0,     0,     0,     0,     0,   364,
     365,   366,     0,   753,   367,     0,   368,     0,   369,   370,
     754,   372,   373,   374,   375,   755,   756,   378,   757,     0,
     379,   380,   381,     0,   382,     0,   383,   384,   385,   386,
     387,     0,   758,   389,   390,     0,     0,   391,     0,     0,
       0,   392,   393,   394,   395,   396,     0,     0,   397,   398,
     399,   400,   401,     0,   402,   403,     0,   404,   405,   406,
     759,   760,   407,     0,   408,     0,   409,   410,     0,   411,
     412,     0,   413,     0,   761,     0,   762,   415,   416,   417,
     418,   419,   420,   763,   764,   423,   424,   425,   426,     0,
     765,   428,     0,     0,     0,   429,   430,   431,   432,     0,
       0,     0,   433,     0,     0,     0,   434,     0,   435,   436,
     437,   438,   439,   440,     0,   441,   442,   443,   444,   445,
     446,     0,     0,     0,     0,     0,     0,   447,   448,     0,
     449,     0,     0,   450,     0,     0,   451,   452,     0,     0,
       0,   453,   766,   767,   454,   455,     0,   456,   457,   768,
     459,   460,   461,   769,   770,   462,   463,   464,   465,   771,
     466,   467,     0,   468,     0,   469,   470,   471,   472,     0,
     772,   473,   474,     0,   773,   774,   775,   776,     0,     0,
       0,     0,     0,   479,   480,   481,     0,   777,   778,   779,
     483,   484,   485,   780,   486,   487,   781,   488,   489,     0,
     490,   491,     0,     0,   492,     0,     0,   493,     0,   494,
       0,   782,   496,   497,     0,     0,   783,   784,   785,   786,
     498,     0,     0,   499,   787,     0,   788,   500,   501,   502,
     503,   504,   789,   790,     0,     0,     0,     0,     0,     0,
     507,   508,     0,   509,   510,   511,     0,     0,   791,     0,
       0,     0,     0,   792,   793,     0,     0,     0,     0,   794,
     795,     0,     0,   796,   797,     0,     0,   798,   799,   142,
       0,   143,   686,   145,   146,   147,   148,     0,     0,   149,
       0,     0,     0,   150,     0,     0,   687,     0,   152,   153,
     154,   155,   156,   157,   688,   159,     0,   160,     0,     0,
     689,   161,   690,   691,   692,   162,   693,     0,   163,   164,
     165,     0,   166,     0,   167,   168,     0,     0,   169,   694,
     695,   170,   171,     0,   172,   696,   697,   174,   175,     0,
     176,   177,   178,   179,   180,   698,   182,     0,   699,   184,
     700,   701,   702,   703,   704,     0,   190,   191,   192,   193,
     194,   195,   196,   197,     0,   198,   199,     0,   200,   201,
     202,   705,   204,     0,   205,   706,   707,   206,     0,     0,
     207,   708,   208,   709,   710,   209,     0,   210,   711,   712,
       0,   211,   212,   213,   713,   714,   715,     0,     0,     0,
       0,   716,   216,   717,     0,     0,   718,   217,     0,   218,
       0,     0,     0,   219,     0,   220,   221,   222,   223,   224,
       0,     0,     0,   225,     0,     0,   226,   227,   228,     0,
       0,     0,   229,     0,   230,   231,     0,   232,   233,   234,
       0,     0,   235,   236,     0,   237,   238,   239,   240,   241,
     242,   243,   719,     0,   244,   245,   246,   247,   720,   721,
     248,   249,     0,   250,   251,   252,   722,     0,   253,     0,
       0,     0,   254,     0,   255,     0,   256,     0,   257,   258,
     723,   260,   724,   262,   263,     0,   264,     0,   725,     0,
     265,   266,   267,     0,   268,   726,   727,     0,   269,   270,
       0,     0,     0,   728,   272,   273,   274,   275,   729,     0,
     276,   277,   278,     0,   279,     0,   280,     0,     0,     0,
     730,   281,   282,   731,     0,     0,   283,     0,   284,   285,
       0,   286,   287,     0,     0,     0,   288,     0,     0,   289,
     290,   732,     0,     0,   292,     0,   733,   293,   294,     0,
       0,     0,     0,     0,   734,   296,     0,   297,     0,   298,
       0,   299,   300,     0,     0,   735,     0,     0,     0,     0,
     301,   302,   303,   304,   305,   306,   307,   308,   309,   310,
     311,   312,   313,   314,   315,   316,     0,   317,   318,   319,
     320,   736,   321,   322,   323,   324,   737,   325,   326,  4620,
       0,     0,     0,   327,   328,   329,   330,   738,   332,     0,
       0,   739,   334,   740,   335,     0,   336,   741,   742,   743,
     744,   745,   341,   342,   343,   344,   345,     0,   746,   346,
     347,     0,     0,   348,   349,   350,   351,   747,     0,   749,
     352,   353,     0,   750,   751,   354,     0,   355,   356,   752,
       0,   358,   359,   360,   361,     0,   362,   363,     0,     0,
       0,     0,     0,     0,     0,     0,   364,   365,   366,     0,
     753,   367,     0,   368,     0,   369,   370,   754,   372,   373,
     374,   375,   755,   756,   378,   757,     0,   379,   380,   381,
       0,   382,     0,   383,   384,   385,   386,   387,     0,   758,
     389,   390,     0,     0,   391,     0,     0,     0,   392,   393,
     394,   395,   396,     0,     0,   397,   398,   399,   400,   401,
       0,   402,   403,     0,   404,   405,   406,   759,   760,   407,
       0,   408,     0,   409,   410,     0,   411,   412,     0,   413,
       0,   761,     0,   762,   415,   416,   417,   418,   419,   420,
     763,   764,   423,   424,   425,   426,     0,   765,   428,     0,
       0,     0,   429,   430,   431,   432,     0,     0,     0,   433,
       0,     0,     0,   434,     0,   435,   436,   437,   438,   439,
     440,     0,   441,   442,   443,   444,   445,   446,     0,     0,
       0,     0,     0,     0,   447,   448,     0,   449,     0,     0,
     450,     0,     0,   451,   452,     0,     0,     0,   453,   766,
     767,   454,   455,     0,   456,   457,   768,   459,   460,   461,
     769,   770,   462,   463,   464,   465,   771,   466,   467,     0,
     468,     0,   469,   470,   471,   472,     0,   772,   473,   474,
       0,   773,   774,   775,   776,     0,     0,     0,     0,     0,
     479,   480,   481,     0,   777,   778,   779,   483,   484,   485,
     780,   486,   487,   781,   488,   489,     0,   490,   491,     0,
       0,   492,     0,     0,   493,     0,   494,     0,   782,   496,
     497,     0,     0,   783,   784,   785,   786,   498,     0,     0,
     499,   787,     0,   788,   500,   501,   502,   503,   504,   789,
     790,     0,     0,     0,     0,     0,     0,   507,   508,     0,
     509,   510,   511,     0,     0,   791,     0,     0,     0,     0,
     792,   793,     0,     0,     0,     0,   794,   795,     0,     0,
     796,   797,     0,     0,   798,   799,   142,     0,   143,   686,
     145,   146,   147,   148,     0,     0,   149,     0,     0,     0,
     150,     0,     0,   687,     0,   152,   153,   154,   155,   156,
     157,   688,   159,     0,   160,     0,     0,   689,   161,   690,
     691,   692,   162,   693,     0,   163,   164,   165,     0,   166,
       0,   167,   168,     0,     0,   169,   694,   695,   170,   171,
       0,   172,   696,   697,   174,   175,     0,   176,   177,   178,
     179,   180,   698,   182,     0,   699,   184,   700,   701,   702,
     703,   704,     0,   190,   191,   192,   193,   194,   195,   196,
     197,     0,   198,   199,     0,   200,   201,   202,   705,   204,
       0,   205,   706,   707,   206,     0,     0,   207,   708,   208,
     709,   710,   209,     0,   210,   711,   712,     0,   211,   212,
     213,   713,   714,   715,     0,     0,     0,     0,   716,   216,
     717,     0,     0,   718,   217,     0,   218,     0,     0,     0,
     219,     0,   220,   221,   222,   223,   224,     0,     0,     0,
     225,     0,     0,   226,   227,   228,     0,     0,     0,   229,
       0,   230,   231,     0,   232,   233,   234,     0,     0,   235,
     236,     0,   237,   238,   239,   240,   241,   242,   243,   719,
       0,   244,   245,   246,   247,   720,   721,   248,   249,     0,
     250,   251,   252,   722,     0,   253,     0,     0,     0,   254,
       0,   255,     0,   256,     0,   257,   258,   723,   260,   724,
     262,   263,     0,   264,     0,   725,     0,   265,   266,   267,
       0,   268,   726,   727,     0,   269,   270,     0,     0,     0,
     728,   272,   273,   274,   275,   729,     0,   276,   277,   278,
       0,   279,     0,   280,     0,     0,     0,   730,   281,   282,
     731,     0,     0,   283,     0,   284,   285,     0,   286,   287,
       0,     0,     0,   288,     0,     0,   289,   290,   732,     0,
       0,   292,     0,   733,   293,   294,     0,     0,     0,     0,
       0,   734,   296,     0,   297,     0,   298,     0,   299,   300,
       0,     0,   735,     0,     0,     0,     0,   301,   302,   303,
     304,   305,   306,   307,   308,   309,   310,   311,   312,   313,
     314,   315,   316,     0,   317,   318,   319,   320,   736,   321,
     322,   323,   324,   737,   325,   326,     0,     0,     0,     0,
     327,   328,   329,   330,   738,   332,     0,     0,   739,   334,
     740,   335,     0,   336,   741,   742,   743,   744,   745,   341,
     342,   343,   344,   345,     0,   746,   346,   347,     0,     0,
     348,   349,   350,   351,   747,     0,   749,   352,   353,     0,
     750,   751,   354,     0,   355,   356,   752,     0,   358,   359,
     360,   361,     0,   362,   363,     0,     0,     0,     0,     0,
       0,     0,     0,   364,   365,   366,     0,   753,   367,     0,
     368,     0,   369,   370,   754,   372,   373,   374,   375,   755,
     756,   378,   757,     0,   379,   380,   381,     0,   382,     0,
     383,   384,   385,   386,   387,     0,   758,   389,   390,     0,
       0,   391,     0,     0,     0,   392,   393,   394,   395,   396,
       0,     0,   397,   398,   399,   400,   401,     0,   402,   403,
       0,   404,   405,   406,   759,   760,   407,     0,   408,     0,
     409,   410,     0,   411,   412,     0,   413,     0,   761,     0,
     762,   415,   416,   417,   418,   419,   420,   763,   764,   423,
     424,   425,   426,     0,   765,   428,     0,     0,     0,   429,
     430,   431,   432,     0,     0,     0,   433,     0,     0,     0,
     434,     0,   435,   436,   437,   438,   439,   440,     0,   441,
     442,   443,   444,   445,   446,     0,     0,     0,     0,     0,
       0,   447,   448,     0,   449,     0,     0,   450,     0,     0,
     451,   452,     0,     0,     0,   453,   766,   767,   454,   455,
       0,   456,   457,   768,   459,   460,   461,   769,   770,   462,
     463,   464,   465,   771,   466,   467,     0,   468,     0,   469,
     470,   471,   472,     0,   772,   473,   474,     0,   773,   774,
     775,   776,     0,     0,     0,     0,     0,   479,   480,   481,
       0,   777,   778,   779,   483,   484,   485,   780,   486,   487,
     781,   488,   489,     0,   490,   491,     0,     0,   492,     0,
       0,   493,     0,   494,     0,   782,   496,   497,     0,     0,
     783,   784,   785,   786,   498,     0,     0,   499,   787,     0,
     788,   500,   501,   502,   503,   504,   789,   790,     0,     0,
       0,     0,     0,     0,   507,   508,     0,   509,   510,   511,
       0,     0,   791,     0,     0,     0,     0,   792,   793,     0,
       0,     0,     0,   794,   795,     0,     0,   796,   797,     0,
       0,   798,   799,   142,     0,   143,   686,   145,   146,   147,
     148,     0,     0,   149,     0,     0,     0,   150,     0,     0,
     687,     0,   152,   153,   154,   155,   156,   157,   688,   159,
       0,   160,     0,     0,   689,   161,   690,   691,   692,   162,
     693,     0,   163,   164,   165,     0,   166,     0,   167,   168,
       0,     0,   169,   694,   695,   170,   171,     0,   172,   696,
     697,   174,   175,     0,   176,   177,   178,   179,   180,   698,
     182,     0,   699,   184,   700,   701,   702,   703,   704,     0,
     190,   191,   192,   193,   194,   195,   196,   197,     0,   198,
     199,     0,   200,   201,   202,   705,   204,     0,   205,   706,
     707,   206,     0,     0,   207,   708,   208,   709,   710,   209,
       0,   210,   711,   712,     0,   211,   212,   213,   713,   714,
     715,     0,     0,     0,     0,   716,   216,   717,     0,     0,
     718,   217,     0,   218,     0,     0,     0,   219,     0,   220,
     221,   222,   223,   224,     0,     0,     0,   225,     0,     0,
     226,   227,   228,     0,     0,     0,   229,     0,   230,   231,
       0,   232,   233,   234,     0,     0,   235,   236,     0,   237,
     238,   239,   240,   241,   242,   243,   719,     0,   244,   245,
     246,   247,   720,   721,   248,   249,     0,   250,   251,   252,
     722,     0,   253,     0,     0,     0,   254,     0,   255,     0,
     256,     0,   257,   258,   723,   260,   724,   262,   263,     0,
     264,     0,   725,     0,   265,   266,   267,     0,   268,   726,
     727,     0,   269,   270,     0,     0,     0,   728,   272,   273,
     274,   275,   729,     0,   276,   277,   278,     0,   279,     0,
     280,     0,     0,     0,   730,   281,   282,  1809,     0,     0,
     283,     0,   284,   285,     0,   286,   287,     0,     0,     0,
     288,     0,     0,   289,   290,   732,     0,     0,   292,     0,
     733,   293,   294,     0,     0,     0,     0,     0,   734,   296,
       0,   297,     0,   298,     0,   299,   300,     0,     0,   735,
       0,     0,     0,     0,   301,   302,   303,   304,   305,   306,
     307,   308,   309,   310,   311,   312,   313,   314,   315,   316,
       0,   317,   318,   319,   320,   736,   321,   322,   323,   324,
     737,   325,   326,     0,     0,     0,     0,   327,   328,   329,
     330,   738,   332,     0,     0,   739,   334,   740,   335,     0,
     336,   741,   742,   743,   744,   745,   341,   342,   343,   344,
     345,     0,   746,   346,   347,     0,     0,   348,   349,   350,
     351,   747,     0,   749,   352,   353,     0,   750,   751,   354,
       0,   355,   356,   752,     0,   358,   359,   360,   361,     0,
     362,   363,     0,     0,     0,     0,     0,     0,     0,     0,
     364,   365,   366,     0,   753,   367,     0,   368,     0,   369,
     370,   754,   372,   373,   374,   375,   755,   756,   378,   757,
       0,   379,   380,   381,     0,   382,     0,   383,   384,   385,
     386,   387,     0,   758,   389,   390,     0,     0,   391,     0,
       0,     0,   392,   393,   394,   395,   396,     0,     0,   397,
     398,   399,   400,   401,     0,   402,   403,     0,   404,   405,
     406,   759,   760,   407,     0,   408,     0,   409,   410,     0,
     411,   412,     0,   413,     0,   761,     0,   762,   415,   416,
     417,   418,   419,   420,   763,   764,   423,   424,   425,   426,
       0,   765,   428,     0,     0,     0,   429,   430,   431,   432,
       0,     0,     0,   433,     0,     0,     0,   434,     0,   435,
     436,   437,   438,   439,   440,     0,   441,   442,   443,   444,
     445,   446,     0,     0,     0,     0,     0,     0,   447,   448,
       0,   449,     0,     0,   450,     0,     0,   451,   452,     0,
       0,     0,   453,   766,   767,   454,   455,     0,   456,   457,
     768,   459,   460,   461,   769,   770,   462,   463,   464,   465,
     771,   466,   467,     0,   468,     0,   469,   470,   471,   472,
       0,   772,   473,   474,     0,   773,   774,   775,   776,     0,
       0,     0,     0,     0,   479,   480,   481,     0,   777,   778,
     779,   483,   484,   485,   780,   486,   487,   781,   488,   489,
       0,   490,   491,     0,     0,   492,     0,     0,   493,     0,
     494,     0,   782,   496,   497,     0,     0,   783,   784,   785,
     786,   498,     0,     0,   499,   787,     0,   788,   500,   501,
     502,   503,   504,   789,   790,     0,     0,     0,     0,     0,
       0,   507,   508,     0,   509,   510,   511,     0,     0,   791,
       0,     0,     0,     0,   792,   793,     0,     0,     0,     0,
     794,   795,     0,     0,   796,   797,     0,     0,   798,   799,
     142,     0,   143,   686,   145,   146,   147,   148,     0,     0,
     149,     0,     0,     0,   150,     0,     0,   687,     0,   152,
     153,   154,   155,   156,   157,   688,   159,     0,   160,     0,
       0,   689,   161,   690,   691,   692,   162,   693,     0,   163,
     164,   165,     0,   166,     0,   167,   168,     0,     0,   169,
     694,   695,   170,   171,     0,   172,   696,   697,   174,   175,
       0,   176,   177,   178,   179,   180,   698,   182,     0,   699,
     184,   700,   701,   702,   703,   704,     0,   190,   191,   192,
     193,   194,   195,   196,   197,     0,   198,   199,     0,   200,
     201,   202,   705,   204,     0,   205,   706,   707,   206,     0,
       0,   207,   708,   208,   709,   710,   209,     0,   210,   711,
     712,     0,   211,   212,   213,   713,   714,   715,     0,     0,
       0,     0,   716,   216,   717,     0,     0,   718,   217,     0,
     218,     0,     0,     0,   219,     0,   220,   221,   222,   223,
     224,     0,     0,     0,   225,     0,     0,   226,   227,   228,
       0,     0,     0,   229,     0,   230,   231,     0,   232,   233,
     234,     0,     0,   235,   236,     0,   237,   238,   239,   240,
     241,   242,   243,   719,     0,   244,   245,   246,   247,   720,
     721,   248,   249,     0,   250,   251,   252,   722,     0,   253,
       0,     0,     0,   254,     0,   255,     0,   256,     0,   257,
     258,   723,   260,   724,   262,   263,     0,   264,     0,   725,
       0,   265,   266,   267,     0,   268,   726,   727,     0,   269,
     270,     0,     0,     0,   728,   272,   273,   274,   275,   729,
       0,   276,   277,   278,     0,   279,     0,   280,     0,     0,
       0,   730,   281,   282,  1811,     0,     0,   283,     0,   284,
     285,     0,   286,   287,     0,     0,     0,   288,     0,     0,
     289,   290,   732,     0,     0,   292,     0,   733,   293,   294,
       0,     0,     0,     0,     0,   734,   296,     0,   297,     0,
     298,     0,   299,   300,     0,     0,   735,     0,     0,     0,
       0,   301,   302,   303,   304,   305,   306,   307,   308,   309,
     310,   311,   312,   313,   314,   315,   316,     0,   317,   318,
     319,   320,   736,   321,   322,   323,   324,   737,   325,   326,
       0,     0,     0,     0,   327,   328,   329,   330,   738,   332,
       0,     0,   739,   334,   740,   335,     0,   336,   741,   742,
     743,   744,   745,   341,   342,   343,   344,   345,     0,   746,
     346,   347,     0,     0,   348,   349,   350,   351,   747,     0,
     749,   352,   353,     0,   750,   751,   354,     0,   355,   356,
     752,     0,   358,   359,   360,   361,     0,   362,   363,     0,
       0,     0,     0,     0,     0,     0,     0,   364,   365,   366,
       0,   753,   367,     0,   368,     0,   369,   370,   754,   372,
     373,   374,   375,   755,   756,   378,   757,     0,   379,   380,
     381,     0,   382,     0,   383,   384,   385,   386,   387,     0,
     758,   389,   390,     0,     0,   391,     0,     0,     0,   392,
     393,   394,   395,   396,     0,     0,   397,   398,   399,   400,
     401,     0,   402,   403,     0,   404,   405,   406,   759,   760,
     407,     0,   408,     0,   409,   410,     0,   411,   412,     0,
     413,     0,   761,     0,   762,   415,   416,   417,   418,   419,
     420,   763,   764,   423,   424,   425,   426,     0,   765,   428,
       0,     0,     0,   429,   430,   431,   432,     0,     0,     0,
     433,     0,     0,     0,   434,     0,   435,   436,   437,   438,
     439,   440,     0,   441,   442,   443,   444,   445,   446,     0,
       0,     0,     0,     0,     0,   447,   448,     0,   449,     0,
       0,   450,     0,     0,   451,   452,     0,     0,     0,   453,
     766,   767,   454,   455,     0,   456,   457,   768,   459,   460,
     461,   769,   770,   462,   463,   464,   465,   771,   466,   467,
       0,   468,     0,   469,   470,   471,   472,     0,   772,   473,
     474,     0,   773,   774,   775,   776,     0,     0,     0,     0,
       0,   479,   480,   481,     0,   777,   778,   779,   483,   484,
     485,   780,   486,   487,   781,   488,   489,     0,   490,   491,
       0,     0,   492,     0,     0,   493,     0,   494,     0,   782,
     496,   497,     0,     0,   783,   784,   785,   786,   498,     0,
       0,   499,   787,     0,   788,   500,   501,   502,   503,   504,
     789,   790,     0,     0,     0,     0,     0,     0,   507,   508,
       0,   509,   510,   511,     0,     0,   791,     0,     0,     0,
       0,   792,   793,     0,     0,     0,     0,   794,   795,     0,
       0,   796,   797,     0,     0,   798,   799,   142,     0,   143,
     144,   145,   146,   147,   148,     0,     0,   149,     0,     0,
       0,   150,     0,     0,   151,     0,   152,   153,   154,   155,
     156,   157,   158,   159,     0,   160,     0,     0,     0,   161,
     690,     0,     0,   162,     0,     0,   163,   164,   165,     0,
     166,     0,   167,   168,     0,     0,   169,     0,     0,   170,
     171,     0,   172,   173,     0,   174,   175,     0,   176,   177,
     178,   179,   180,   181,   182,     0,   183,   184,   185,   186,
     187,   188,   189,     0,   190,   191,   192,   193,   194,   195,
     196,   197,     0,   198,   199,     0,   200,   201,   202,   203,
     204,     0,   205,     0,     0,   206,     0,     0,   207,     0,
     208,     0,     0,   209,     0,   210,     0,     0,     0,   211,
     212,   213,     0,     0,  1850,     0,     0,     0,     0,   215,
     216,   717,     0,     0,     0,   217,     0,   218,     0,     0,
       0,   219,     0,   220,   221,   222,   223,   224,     0,     0,
       0,   225,     0,     0,   226,   227,   228,     0,     0,     0,
     229,     0,   230,   231,     0,   232,   233,   234,     0,     0,
     235,   236,     0,   237,   238,   239,   240,   241,   242,   243,
       0,     0,   244,   245,   246,   247,     0,   721,   248,   249,
       0,   250,   251,   252,   722,     0,   253,     0,     0,     0,
     254,     0,   255,     0,   256,     0,   257,   258,   259,   260,
     261,   262,   263,     0,   264,     0,     0,     0,   265,   266,
     267,     0,   268,   726,   727,     0,   269,   270,     0,     0,
       0,   271,   272,   273,   274,   275,     0,     0,   276,   277,
     278,     0,   279,     0,   280,     0,     0,     0,     0,   281,
     282,     0,     0,     0,   283,     0,   284,   285,     0,   286,
     287,     0,     0,     0,   288,     0,     0,   289,   290,   291,
       0,     0,   292,     0,     0,   293,   294,     0,     0,     0,
       0,     0,   295,   296,     0,   297,     0,   298,     0,   299,
     300,     0,     0,   735,     0,     0,     0,     0,   301,   302,
     303,   304,   305,   306,   307,   308,   309,   310,   311,   312,
     313,   314,   315,   316,     0,   317,   318,   319,   320,     0,
     321,   322,   323,   324,     0,   325,   326,     0,     0,     0,
       0,   327,   328,   329,   330,   331,   332,     0,     0,   333,
     334,     0,   335,     0,   336,     0,   337,   338,   339,   340,
     341,   342,   343,   344,   345,     0,   746,   346,   347,     0,
       0,   348,   349,   350,   351,     0,     0,     0,   352,   353,
       0,   750,   751,   354,     0,   355,   356,   357,     0,   358,
     359,   360,   361,     0,   362,   363,     0,     0,     0,     0,
       0,     0,     0,     0,   364,   365,   366,     0,     0,   367,
       0,   368,     0,   369,   370,   371,   372,   373,   374,   375,
     376,   377,   378,     0,     0,   379,   380,   381,     0,   382,
       0,   383,   384,   385,   386,   387,     0,   388,   389,   390,
       0,     0,   391,     0,     0,     0,   392,   393,   394,   395,
     396,     0,     0,   397,   398,   399,   400,   401,     0,   402,
     403,     0,   404,   405,   406,     0,     0,   407,     0,   408,
       0,   409,   410,     0,   411,   412,     0,   413,     0,   414,
       0,     0,   415,   416,   417,   418,   419,   420,   421,   422,
     423,   424,   425,   426,     0,   427,   428,     0,     0,     0,
     429,   430,   431,   432,     0,     0,     0,   433,     0,     0,
       0,   434,     0,   435,   436,   437,   438,   439,   440,     0,
     441,   442,   443,   444,   445,   446,     0,     0,     0,     0,
       0,     0,   447,   448,     0,   449,     0,     0,   450,     0,
       0,   451,   452,     0,     0,     0,   453,     0,     0,   454,
     455,     0,   456,   457,   458,   459,   460,   461,     0,     0,
     462,   463,   464,   465,     0,   466,   467,     0,   468,     0,
     469,   470,   471,   472,     0,   772,   473,   474,     0,  1851,
     476,   477,  1852,     0,     0,     0,     0,     0,   479,   480,
     481,     0,     0,   778,   482,   483,   484,   485,   780,   486,
     487,   781,   488,   489,     0,   490,   491,     0,     0,   492,
       0,     0,   493,     0,   494,     0,   495,   496,   497,     0,
       0,     0,     0,     0,     0,   498,     0,     0,   499,     0,
       0,     0,   500,   501,   502,   503,   504,   505,   506,     0,
       0,     0,     0,     0,     0,   507,   508,     0,   509,   510,
     511,     0,     0,   512,     0,     0,     0,   142,     0,   143,
     144,   145,   146,   147,   148,     0,     0,   149,     0,     0,
       0,   150,   798,   799,   151,     0,   152,   153,   154,   155,
     156,   157,   158,   159,     0,   160,     0,     0,     0,   161,
       0,     0,     0,   162,     0,     0,   163,   164,   165,     0,
     166,     0,   167,   168,     0,     0,   169,     0,     0,   170,
     171,     0,   172,   173,     0,   174,   175,     0,   176,   177,
     178,   179,   180,   181,   182,     0,   183,   184,   185,   186,
     187,   188,   189,     0,   190,   191,   192,   193,   194,   195,
     196,   197,     0,   198,   199,  2998,   200,   201,   202,   203,
     204,     0,   205,     0,     0,   206,     0,     0,   207,     0,
     208,     0,     0,   209,     0,   210,     0,     0,     0,   211,
     212,   213,     0,     0,   214,     0,     0,     0,     0,   215,
     216,     0,     0,     0,     0,   217,     0,   218,     0,     0,
       0,   219,     0,   220,   221,   222,   223,   224,     0,     0,
       0,   225,     0,     0,   226,   227,   228,     0,     0,     0,
     229,     0,   230,   231,     0,   232,   233,   234,     0,     0,
     235,   236,     0,   237,   238,   239,   240,   241,   242,   243,
       0,     0,   244,   245,   246,   247,     0,     0,   248,   249,
       0,   250,   251,   252,     0,     0,   253,     0,     0,     0,
     254,     0,   255,   526,   256,     0,   257,   258,   259,   260,
     261,   262,   263,     0,   264,     0,     0,     0,   265,   266,
     267,     0,   268,     0,     0,     0,   269,   270,     0,     0,
       0,   271,   272,   273,   274,   275,     0,     0,   276,   277,
     278,  2130,   279,     0,   280,     0,     0,     0,     0,   281,
     282,     0,     0,     0,   283,     0,   284,   285,     0,   286,
     287,     0,     0,     0,   288,  2131,     0,   289,   290,   291,
       0,     0,   292,     0,     0,   293,   294,     0,  3369,     0,
       0,     0,   295,   296,     0,   297,     0,   298,     0,   299,
     300,     0,     0,     0,     0,     0,     0,     0,   301,   302,
     303,   304,   305,   306,   307,   308,   309,   310,   311,   312,
     313,   314,   315,   316,     0,   317,   318,   319,   320,     0,
     321,   322,   323,   324,     0,   325,   326,     0,     0,     0,
       0,   327,   328,   329,   330,   331,   332,     0,     0,   333,
     334,     0,   335,     0,   336,     0,   337,   338,   339,   340,
     341,   342,   343,   344,   345,     0,     0,   346,   347,     0,
       0,   348,   349,   350,   351,     0,     0,     0,   352,   353,
       0,     0,     0,   354,     0,   355,   356,   357,     0,   358,
     359,   360,   361,     0,   362,   363,     0,     0,     0,     0,
       0,     0,     0,     0,   364,   365,   366,     0,     0,   367,
       0,   368,     0,   369,   370,   371,   372,   373,   374,   375,
     376,   377,   378,     0,     0,   379,   380,   381,     0,   382,
       0,   383,   384,   385,   386,   387,     0,   388,   389,   390,
       0,     0,   391,     0,     0,     0,   392,   393,   394,   395,
     396,     0,     0,   397,   398,   399,   400,   401,     0,   402,
     403,     0,   404,   405,   406,     0,     0,   407,     0,   408,
       0,   409,   410,     0,   411,   412,     0,   413,     0,   414,
       0,     0,   415,   416,   417,   418,   419,   420,   421,   422,
     423,   424,   425,   426,     0,   427,   428,  2429,     0,     0,
     429,   430,   431,   432,     0,     0,     0,   433,     0,     0,
       0,   434,     0,   435,   436,   437,   438,   439,   440,     0,
     441,   442,   443,   444,   445,   446,   531,     0,     0,     0,
       0,     0,   447,   448,     0,   449,     0,     0,   450,     0,
       0,   451,   452,     0,     0,     0,   453,     0,     0,   454,
     455,     0,   456,   457,   458,   459,   460,   461,     0,     0,
     462,   463,   464,   465,     0,   466,   467,     0,   468,     0,
     469,   470,   471,   472,     0,     0,   473,   474,     0,   475,
     476,   477,   478,     0,     0,     0,     0,     0,   479,   480,
     481,     0,     0,     0,   482,   483,   484,   485,     0,   486,
     487,     0,   488,   489,     0,   490,   491,     0,     0,   492,
       0,     0,   493,     0,   494,     0,   495,   496,   497,     0,
       0,     0,     0,     0,     0,   498,     0,     0,   499,     0,
       0,     0,   500,   501,   502,   503,   504,   505,   506,     0,
       0,     0,     0,     0,     0,   507,   508,     0,   509,   510,
     511,     0,     0,   512,     0,   142,     0,   143,   144,   145,
     146,   147,   148,     0,     0,   149,     0,     0,     0,   150,
       0,     0,   151,  3071,   152,   153,   154,   155,   156,   157,
     158,   159,     0,   160,     0,     0,     0,   161,     0,     0,
       0,   162,     0,     0,   163,   164,   165,     0,   166,     0,
     167,   168,     0,     0,   169,     0,     0,   170,   171,     0,
     172,   173,     0,   174,   175,     0,   176,   177,   178,   179,
     180,   181,   182,     0,   183,   184,   185,   186,   187,   188,
     189,     0,   190,   191,   192,   193,   194,   195,   196,   197,
       0,   198,   199,  2998,   200,   201,   202,   203,   204,     0,
     205,     0,     0,   206,     0,     0,   207,     0,   208,     0,
       0,   209,     0,   210,     0,     0,     0,   211,   212,   213,
       0,     0,   214,     0,     0,     0,     0,   215,   216,     0,
       0,     0,     0,   217,     0,   218,     0,     0,     0,   219,
       0,   220,   221,   222,   223,   224,     0,     0,     0,   225,
       0,     0,   226,   227,   228,     0,     0,     0,   229,     0,
     230,   231,     0,   232,   233,   234,     0,     0,   235,   236,
       0,   237,   238,   239,   240,   241,   242,   243,     0,     0,
     244,   245,   246,   247,     0,     0,   248,   249,     0,   250,
     251,   252,     0,     0,   253,     0,     0,     0,   254,     0,
     255,   526,   256,     0,   257,   258,   259,   260,   261,   262,
     263,     0,   264,     0,     0,     0,   265,   266,   267,     0,
     268,     0,     0,     0,   269,   270,     0,     0,     0,   271,
     272,   273,   274,   275,     0,     0,   276,   277,   278,  2130,
     279,     0,   280,     0,     0,     0,     0,   281,   282,     0,
       0,     0,   283,     0,   284,   285,     0,   286,   287,     0,
       0,     0,   288,  2131,     0,   289,   290,   291,     0,     0,
     292,     0,     0,   293,   294,     0,     0,     0,     0,     0,
     295,   296,     0,   297,     0,   298,     0,   299,   300,     0,
       0,     0,     0,     0,     0,     0,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,     0,   317,   318,   319,   320,     0,   321,   322,
     323,   324,     0,   325,   326,     0,     0,     0,     0,   327,
     328,   329,   330,   331,   332,     0,     0,   333,   334,     0,
     335,     0,   336,     0,   337,   338,   339,   340,   341,   342,
     343,   344,   345,     0,     0,   346,   347,     0,     0,   348,
     349,   350,   351,     0,     0,     0,   352,   353,     0,     0,
       0,   354,     0,   355,   356,   357,     0,   358,   359,   360,
     361,     0,   362,   363,     0,     0,     0,     0,     0,     0,
       0,     0,   364,   365,   366,     0,     0,   367,     0,   368,
       0,   369,   370,   371,   372,   373,   374,   375,   376,   377,
     378,     0,     0,   379,   380,   381,     0,   382,     0,   383,
     384,   385,   386,   387,     0,   388,   389,   390,     0,     0,
     391,     0,     0,     0,   392,   393,   394,   395,   396,     0,
       0,   397,   398,   399,   400,   401,     0,   402,   403,     0,
     404,   405,   406,     0,     0,   407,     0,   408,     0,   409,
     410,     0,   411,   412,     0,   413,     0,   414,     0,     0,
     415,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,     0,   427,   428,     0,     0,     0,   429,   430,
     431,   432,     0,     0,     0,   433,     0,     0,     0,   434,
       0,   435,   436,   437,   438,   439,   440,     0,   441,   442,
     443,   444,   445,   446,   531,     0,     0,     0,     0,     0,
     447,   448,     0,   449,     0,     0,   450,     0,     0,   451,
     452,     0,     0,     0,   453,     0,     0,   454,   455,     0,
     456,   457,   458,   459,   460,   461,     0,     0,   462,   463,
     464,   465,     0,   466,   467,     0,   468,     0,   469,   470,
     471,   472,     0,     0,   473,   474,     0,   475,   476,   477,
     478,     0,     0,     0,     0,     0,   479,   480,   481,     0,
       0,     0,   482,   483,   484,   485,     0,   486,   487,     0,
     488,   489,     0,   490,   491,     0,     0,   492,     0,     0,
     493,     0,   494,     0,   495,   496,   497,     0,     0,     0,
       0,     0,     0,   498,     0,     0,   499,     0,     0,     0,
     500,   501,   502,   503,   504,   505,   506,     0,     0,     0,
       0,     0,     0,   507,   508,     0,   509,   510,   511,     0,
       0,   512,     0,   142,     0,   143,   144,   145,   146,   147,
     148,     0,     0,   149,     0,     0,     0,   150,     0,     0,
     151,  3071,   152,   153,   154,   155,   156,   157,   158,   159,
       0,   160,     0,     0,     0,   161,     0,     0,     0,   162,
       0,     0,   163,   164,   165,     0,   166,     0,   167,   168,
       0,     0,   169,     0,     0,   170,   171,     0,   172,   173,
       0,   174,   175,     0,   176,   177,   178,   179,   180,   181,
     182,     0,   183,   184,   185,   186,   187,   188,   189,     0,
     190,   191,   192,   193,   194,   195,   196,   197,     0,   198,
     199,     0,   200,   201,   202,   203,   204,     0,   205,     0,
       0,   206,     0,     0,   207,     0,   208,     0,     0,   209,
       0,   210,     0,     0,     0,   211,   212,   213,     0,     0,
     214,     0,     0,     0,     0,   215,   216,     0,     0,     0,
       0,   217,     0,   218,     0,     0,     0,   219,     0,   220,
     221,   222,   223,   224,     0,     0,     0,   225,     0,     0,
     226,   227,   228,     0,     0,     0,   229,     0,   230,   231,
       0,   232,   233,   234,     0,     0,   235,   236,     0,   237,
     238,   239,   240,   241,   242,   243,     0,     0,   244,   245,
     246,   247,     0,     0,   248,   249,     0,   250,   251,   252,
       0,     0,   253,     0,     0,     0,   254,     0,   255,     0,
     256,     0,   257,   258,   259,   260,   261,   262,   263,     0,
     264,     0,     0,     0,   265,   266,   267,     0,   268,     0,
       0,     0,   269,   270,     0,     0,     0,   271,   272,   273,
     274,   275,     0,     0,   276,   277,   278,     0,   279,     0,
     280,     0,     0,     0,     0,   281,   282,     0,     0,     0,
     283,     0,   284,   285,     0,   286,   287,     0,     0,     0,
     288,     0,     0,   289,   290,   291,     0,     0,   292,     0,
       0,   293,   294,     0,     0,     0,     0,     0,   295,   296,
       0,   297,     0,   298,     0,   299,   300,     0,     0,     0,
       0,     0,     0,     0,   301,   302,   303,   304,   305,   306,
     307,   308,   309,   310,   311,   312,   313,   314,   315,   316,
       0,   317,   318,   319,   320,     0,   321,   322,   323,   324,
       0,   325,   326,     0,     0,     0,     0,   327,   328,   329,
     330,   331,   332,     0,     0,   333,   334,     0,   335,     0,
     336,     0,   337,   338,   339,   340,   341,   342,   343,   344,
     345,     0,     0,   346,   347,     0,     0,   348,   349,   350,
     351,     0,     0,     0,   352,   353,     0,     0,     0,   354,
       0,   355,   356,   357,     0,   358,   359,   360,   361,     0,
     362,   363,     0,     0,     0,     0,     0,     0,     0,     0,
     364,   365,   366,     0,     0,   367,     0,   368,     0,   369,
     370,   371,   372,   373,   374,   375,   376,   377,   378,     0,
       0,   379,   380,   381,     0,   382,     0,   383,   384,   385,
     386,   387,     0,   388,   389,   390,     0,     0,   391,     0,
       0,     0,   392,   393,   394,   395,   396,     0,     0,   397,
     398,   399,   400,   401,     0,   402,   403,     0,   404,   405,
     406,     0,     0,   407,     0,   408,     0,   409,   410,     0,
     411,   412,     0,   413,     0,   414,     0,     0,   415,   416,
     417,   418,   419,   420,   421,   422,   423,   424,   425,   426,
       0,   427,   428,  2429,     0,     0,   429,   430,   431,   432,
       0,     0,     0,   433,     0,     0,     0,   434,     0,   435,
     436,   437,   438,   439,   440,     0,   441,   442,   443,   444,
     445,   446,     0,     0,     0,     0,     0,     0,   447,   448,
       0,   449,     0,     0,   450,     0,     0,   451,   452,     0,
       0,     0,   453,     0,     0,   454,   455,     0,   456,   457,
     458,   459,   460,   461,     0,     0,   462,   463,   464,   465,
       0,   466,   467,     0,   468,     0,   469,   470,   471,   472,
       0,     0,   473,   474,     0,   475,   476,   477,   478,     0,
       0,     0,     0,     0,   479,   480,   481,     0,     0,     0,
     482,   483,   484,   485,     0,   486,   487,     0,   488,   489,
       0,   490,   491,     0,     0,   492,     0,     0,   493,     0,
     494,     0,   495,   496,   497,     0,     0,     0,     0,     0,
       0,   498,     0,     0,   499,     0,     0,     0,   500,   501,
     502,   503,   504,   505,   506,     0,     0,     0,     0,     0,
       0,   507,   508,     0,   509,   510,   511,     0,     0,   512,
       0,   142,     0,   143,   144,   145,   146,   147,   148,     0,
       0,   149,  2867,     0,     0,   150,     0,     0,   151,   799,
     152,   153,   154,   155,   156,   157,   158,   159,     0,   160,
       0,     0,     0,   161,     0,     0,     0,   162,     0,     0,
     163,   164,   165,     0,   166,     0,   167,   168,     0,     0,
     169,     0,     0,   170,   171,     0,   172,   173,     0,   174,
     175,     0,   176,   177,   178,   179,   180,   181,   182,     0,
     183,   184,   185,   186,   187,   188,   189,     0,   190,   191,
     192,   193,   194,   195,   196,   197,     0,   198,   199,     0,
     200,   201,   202,   203,   204,     0,   205,     0,     0,   206,
       0,     0,   207,     0,   208,     0,     0,   209,     0,   210,
       0,     0,     0,   211,   212,   213,     0,     0,   214,     0,
       0,     0,     0,   215,   216,     0,     0,     0,     0,   217,
       0,   218,     0,     0,     0,   219,     0,   220,   221,   222,
     223,   224,     0,     0,     0,   225,     0,     0,   226,   227,
     228,     0,     0,     0,   229,     0,   230,   231,     0,   232,
     233,   234,     0,     0,   235,   236,     0,   237,   238,   239,
     240,   241,   242,   243,     0,     0,   244,   245,   246,   247,
       0,     0,   248,   249,     0,   250,   251,   252,     0,     0,
     253,     0,     0,     0,   254,     0,   255,     0,   256,     0,
     257,   258,   259,   260,   261,   262,   263,     0,   264,     0,
       0,     0,   265,   266,   267,     0,   268,     0,     0,     0,
     269,   270,     0,     0,     0,   271,   272,   273,   274,   275,
       0,     0,   276,   277,   278,     0,   279,     0,   280,     0,
       0,     0,     0,   281,   282,     0,     0,     0,   283,     0,
     284,   285,     0,   286,   287,     0,     0,     0,   288,     0,
       0,   289,   290,   291,     0,     0,   292,     0,     0,   293,
     294,     0,     0,     0,     0,     0,   295,   296,     0,   297,
       0,   298,     0,   299,   300,     0,     0,     0,     0,     0,
       0,     0,   301,   302,   303,   304,   305,   306,   307,   308,
     309,   310,   311,   312,   313,   314,   315,   316,     0,   317,
     318,   319,   320,     0,   321,   322,   323,   324,     0,   325,
     326,     0,     0,     0,     0,   327,   328,   329,   330,   331,
     332,     0,     0,   333,   334,     0,   335,     0,   336,     0,
     337,   338,   339,   340,   341,   342,   343,   344,   345,     0,
       0,   346,   347,     0,     0,   348,   349,   350,   351,     0,
       0,     0,   352,   353,     0,     0,     0,   354,     0,   355,
     356,   357,     0,   358,   359,   360,   361,     0,   362,   363,
       0,     0,     0,     0,     0,     0,     0,     0,   364,   365,
     366,     0,     0,   367,     0,   368,     0,   369,   370,   371,
     372,   373,   374,   375,   376,   377,   378,     0,     0,   379,
     380,   381,     0,   382,     0,   383,   384,   385,   386,   387,
       0,   388,   389,   390,     0,     0,   391,     0,     0,     0,
     392,   393,   394,   395,   396,     0,     0,   397,   398,   399,
     400,   401,     0,   402,   403,     0,   404,   405,   406,     0,
       0,   407,     0,   408,     0,   409,   410,     0,   411,   412,
       0,   413,     0,   414,     0,     0,   415,   416,   417,   418,
     419,   420,   421,   422,   423,   424,   425,   426,     0,   427,
     428,     0,     0,     0,   429,   430,   431,   432,     0,     0,
       0,   433,     0,     0,     0,   434,     0,   435,   436,   437,
     438,   439,   440,     0,   441,   442,   443,   444,   445,   446,
       0,     0,     0,     0,     0,     0,   447,   448,     0,   449,
       0,     0,   450,     0,     0,   451,   452,     0,     0,     0,
     453,     0,     0,   454,   455,     0,   456,   457,   458,   459,
     460,   461,     0,     0,   462,   463,   464,   465,     0,   466,
     467,     0,   468,     0,   469,   470,   471,   472,     0,     0,
     473,   474,     0,   475,   476,   477,   478,     0,     0,     0,
       0,     0,   479,   480,   481,     0,     0,     0,   482,   483,
     484,   485,     0,   486,   487,     0,   488,   489,     0,   490,
     491,     0,     0,   492,     0,     0,   493,     0,   494,     0,
     495,   496,   497,     0,     0,     0,     0,     0,     0,   498,
       0,     0,   499,     0,     0,     0,   500,   501,   502,   503,
     504,   505,   506,     0,     0,     0,     0,     0,     0,   507,
     508,     0,   509,   510,   511,     0,     0,   512,     0,     0,
       0,   142,     0,   143,   144,   145,   146,   147,   148,     0,
    4767,   149,     0,     0,     0,   150,  4768,   799,   151,     0,
     152,   153,   154,   155,   156,   157,   158,   159,     0,   160,
       0,     0,     0,   161,     0,     0,     0,   162,     0,     0,
     163,   164,   165,     0,   166,     0,   167,   168,     0,     0,
     169,     0,     0,   170,   171,     0,   172,   173,     0,   174,
     175,     0,   176,   177,   178,   179,   180,   181,   182,     0,
     183,   184,   185,   186,   187,   188,   189,     0,   190,   191,
     192,   193,   194,   195,   196,   197,     0,   198,   199,     0,
     200,   201,   202,   203,   204,     0,   205,     0,     0,   206,
       0,     0,   207,     0,   208,     0,     0,   209,     0,   210,
       0,     0,     0,   211,   212,   213,     0,     0,   214,     0,
       0,     0,     0,   215,   216,     0,     0,     0,     0,   217,
       0,   218,     0,     0,     0,   219,     0,   220,   221,   222,
     223,   224,     0,     0,     0,   225,     0,     0,   226,   227,
     228,     0,     0,     0,   229,     0,   230,   231,     0,   232,
     233,   234,     0,     0,   235,   236,     0,   237,   238,   239,
     240,   241,   242,   243,     0,     0,   244,   245,   246,   247,
       0,     0,   248,   249,     0,   250,   251,   252,     0,     0,
     253,     0,     0,     0,   254,     0,   255,     0,   256,     0,
     257,   258,   259,   260,   261,   262,   263,     0,   264,     0,
       0,     0,   265,   266,   267,     0,   268,     0,     0,     0,
     269,   270,     0,     0,     0,   271,   272,   273,   274,   275,
       0,     0,   276,   277,   278,     0,   279,     0,   280,     0,
       0,     0,     0,   281,   282,     0,     0,     0,   283,     0,
     284,   285,     0,   286,   287,     0,     0,     0,   288,     0,
       0,   289,   290,   291,     0,     0,   292,     0,     0,   293,
     294,     0,     0,     0,     0,     0,   295,   296,     0,   297,
       0,   298,     0,   299,   300,     0,     0,     0,     0,     0,
       0,     0,   301,   302,   303,   304,   305,   306,   307,   308,
     309,   310,   311,   312,   313,   314,   315,   316,     0,   317,
     318,   319,   320,     0,   321,   322,   323,   324,     0,   325,
     326,     0,     0,     0,     0,   327,   328,   329,   330,   331,
     332,     0,     0,   333,   334,     0,   335,     0,   336,     0,
     337,   338,   339,   340,   341,   342,   343,   344,   345,     0,
       0,   346,   347,     0,     0,   348,   349,   350,   351,     0,
       0,     0,   352,   353,     0,     0,     0,   354,     0,   355,
     356,   357,     0,   358,   359,   360,   361,     0,   362,   363,
       0,     0,     0,     0,     0,     0,     0,     0,   364,   365,
     366,     0,     0,   367,     0,   368,     0,   369,   370,   371,
     372,   373,   374,   375,   376,   377,   378,     0,     0,   379,
     380,   381,     0,   382,     0,   383,   384,   385,   386,   387,
       0,   388,   389,   390,     0,     0,   391,     0,     0,     0,
     392,   393,   394,   395,   396,     0,     0,   397,   398,   399,
     400,   401,     0,   402,   403,     0,   404,   405,   406,     0,
       0,   407,     0,   408,     0,   409,   410,     0,   411,   412,
       0,   413,     0,   414,     0,     0,   415,   416,   417,   418,
     419,   420,   421,   422,   423,   424,   425,   426,     0,   427,
     428,     0,     0,     0,   429,   430,   431,   432,     0,     0,
       0,   433,     0,     0,     0,   434,     0,   435,   436,   437,
     438,   439,   440,     0,   441,   442,   443,   444,   445,   446,
       0,     0,     0,     0,     0,     0,   447,   448,     0,   449,
       0,     0,   450,     0,     0,   451,   452,     0,     0,     0,
     453,     0,     0,   454,   455,     0,   456,   457,   458,   459,
     460,   461,     0,     0,   462,   463,   464,   465,     0,   466,
     467,     0,   468,     0,   469,   470,   471,   472,     0,     0,
     473,   474,     0,   475,   476,   477,   478,     0,     0,     0,
       0,     0,   479,   480,   481,     0,     0,     0,   482,   483,
     484,   485,     0,   486,   487,     0,   488,   489,     0,   490,
     491,     0,     0,   492,     0,     0,   493,     0,   494,     0,
     495,   496,   497,     0,     0,     0,     0,     0,     0,   498,
       0,     0,   499,     0,     0,     0,   500,   501,   502,   503,
     504,   505,   506,     0,     0,     0,     0,     0,     0,   507,
     508,     0,   509,   510,   511,     0,     0,   512,     0,     0,
       0,   142,     0,   143,   144,   145,   146,   147,   148,  1168,
       0,   149,     0,     0,     0,   150,     0,   799,   151,     0,
     152,   153,   154,   155,   156,   157,   158,   159,     0,   160,
       0,     0,     0,   161,     0,     0,     0,   162,     0,     0,
     163,   164,   165,     0,   166,     0,   167,   168,     0,     0,
     169,     0,     0,   170,   171,     0,   172,   173,     0,   174,
     175,     0,   176,   177,   178,   179,   180,   181,   182,     0,
     183,   184,   185,   186,   187,   188,   189,     0,   190,   191,
     192,   193,   194,   195,   196,   197,     0,   198,   199,     0,
     200,   201,   202,   203,   204,     0,   205,     0,     0,   206,
       0,     0,   207,     0,   208,     0,     0,   209,     0,   210,
       0,     0,     0,   211,   212,   213,     0,     0,   214,     0,
       0,     0,     0,   215,   216,     0,     0,     0,     0,   217,
       0,   218,     0,     0,     0,   219,     0,   220,   221,   222,
     223,   224,     0,     0,     0,   225,     0,     0,   226,   227,
     228,     0,     0,     0,   229,     0,   230,   231,     0,   232,
     233,   234,     0,     0,   235,   236,     0,   237,   238,   239,
     240,   241,   242,   243,     0,     0,   244,   245,   246,   247,
       0,     0,   248,   249,     0,   250,   251,   252,     0,     0,
     253,     0,     0,     0,   254,     0,   255,     0,   256,     0,
     257,   258,   259,   260,   261,   262,   263,     0,   264,     0,
       0,     0,   265,   266,   267,     0,   268,     0,     0,     0,
     269,   270,     0,     0,     0,   271,   272,   273,   274,   275,
       0,     0,   276,   277,   278,     0,   279,     0,   280,     0,
       0,     0,     0,   281,   282,     0,  1382,     0,   283,     0,
     284,   285,     0,   286,   287,     0,     0,     0,   288,     0,
       0,   289,   290,   291,     0,     0,   292,     0,     0,   293,
     294,     0,     0,     0,     0,     0,   295,   296,     0,   297,
       0,   298,     0,   299,   300,     0,     0,     0,     0,     0,
       0,     0,   301,   302,   303,   304,   305,   306,   307,   308,
     309,   310,   311,   312,   313,   314,   315,   316,     0,   317,
     318,   319,   320,     0,   321,   322,   323,   324,     0,   325,
     326,     0,     0,     0,     0,   327,   328,   329,   330,   331,
     332,     0,     0,   333,   334,     0,   335,     0,   336,     0,
     337,   338,   339,   340,   341,   342,   343,   344,   345,     0,
       0,   346,   347,     0,     0,   348,   349,   350,   351,     0,
       0,     0,   352,   353,     0,     0,     0,   354,     0,   355,
     356,   357,     0,   358,   359,   360,   361,     0,   362,   363,
       0,     0,     0,     0,     0,     0,     0,     0,   364,   365,
     366,     0,     0,   367,     0,   368,     0,   369,   370,   371,
     372,   373,   374,   375,   376,   377,   378,     0,     0,   379,
     380,   381,     0,   382,     0,   383,   384,   385,   386,   387,
       0,   388,   389,   390,     0,     0,   391,     0,     0,     0,
     392,   393,   394,   395,   396,     0,     0,   397,   398,   399,
     400,   401,     0,   402,   403,     0,   404,   405,   406,     0,
       0,   407,     0,   408,     0,   409,   410,     0,   411,   412,
       0,   413,     0,   414,     0,     0,   415,   416,   417,   418,
     419,   420,   421,   422,   423,   424,   425,   426,     0,   427,
     428,     0,     0,     0,   429,   430,   431,   432,     0,     0,
       0,   433,     0,     0,     0,   434,     0,   435,   436,   437,
     438,   439,   440,     0,   441,   442,   443,   444,   445,   446,
       0,     0,     0,     0,     0,     0,   447,   448,     0,   449,
       0,     0,   450,     0,     0,   451,   452,     0,     0,     0,
     453,     0,     0,   454,   455,     0,   456,   457,   458,   459,
     460,   461,     0,     0,   462,   463,   464,   465,     0,   466,
     467,     0,   468,     0,   469,   470,   471,   472,     0,     0,
     473,   474,     0,   475,   476,   477,   478,     0,     0,     0,
       0,     0,   479,   480,   481,     0,     0,     0,   482,   483,
     484,   485,     0,   486,   487,     0,   488,   489,     0,   490,
     491,     0,     0,   492,     0,     0,   493,     0,   494,     0,
     495,   496,   497,     0,     0,     0,     0,     0,     0,   498,
       0,     0,   499,     0,     0,     0,   500,   501,   502,   503,
     504,   505,   506,     0,     0,     0,     0,     0,     0,   507,
     508,     0,   509,   510,   511,     0,     0,   512,     0,   142,
       0,   143,   144,   145,   146,   147,   148,     0,     0,   149,
       0,     0,     0,   150,     0,     0,   151,   560,   152,   153,
     154,   155,   156,   157,   158,   159,     0,   160,     0,     0,
       0,   161,     0,     0,     0,   162,     0,     0,   163,   164,
     165,     0,   166,     0,   167,   168,     0,     0,   169,     0,
       0,   170,   171,     0,   172,   173,     0,   174,   175,     0,
     176,   177,   178,   179,   180,   181,   182,     0,   183,   184,
     185,   186,   187,   188,   189,     0,   190,   191,   192,   193,
     194,   195,   196,   197,     0,   198,   199,     0,   200,   201,
     202,   203,   204,     0,   205,     0,     0,   206,     0,     0,
     207,     0,   208,     0,     0,   209,     0,   210,     0,     0,
       0,   211,   212,   213,     0,     0,   214,     0,     0,     0,
       0,   215,   216,     0,     0,     0,     0,   217,     0,   218,
       0,     0,     0,   219,     0,   220,   221,   222,   223,   224,
       0,     0,     0,   225,     0,     0,   226,   227,   228,     0,
       0,     0,   229,     0,   230,   231,     0,   232,   233,   234,
       0,     0,   235,   236,     0,   237,   238,   239,   240,   241,
     242,   243,     0,     0,   244,   245,   246,   247,     0,     0,
     248,   249,     0,   250,   251,   252,     0,     0,   253,     0,
       0,     0,   254,     0,   255,     0,   256,     0,   257,   258,
     259,   260,   261,   262,   263,     0,   264,     0,     0,     0,
     265,   266,   267,     0,   268,     0,     0,     0,   269,   270,
       0,     0,     0,   271,   272,   273,   274,   275,     0,     0,
     276,   277,   278,     0,   279,     0,   280,     0,     0,     0,
       0,   281,   282,     0,     0,     0,   283,     0,   284,   285,
       0,   286,   287,     0,     0,     0,   288,     0,     0,   289,
     290,   291,     0,     0,   292,     0,     0,   293,   294,     0,
       0,     0,     0,     0,   295,   296,     0,   297,     0,   298,
       0,   299,   300,     0,     0,     0,     0,     0,     0,     0,
     301,   302,   303,   304,   305,   306,   307,   308,   309,   310,
     311,   312,   313,   314,   315,   316,     0,   317,   318,   319,
     320,     0,   321,   322,   323,   324,     0,   325,   326,     0,
       0,     0,     0,   327,   328,   329,   330,   331,   332,     0,
       0,   333,   334,     0,   335,     0,   336,     0,   337,   338,
     339,   340,   341,   342,   343,   344,   345,     0,     0,   346,
     347,     0,     0,   348,   349,   350,   351,     0,     0,     0,
     352,   353,     0,     0,     0,   354,     0,   355,   356,   357,
       0,   358,   359,   360,   361,     0,   362,   363,     0,     0,
       0,     0,     0,     0,     0,     0,   364,   365,   366,     0,
       0,   367,     0,   368,     0,   369,   370,   371,   372,   373,
     374,   375,   376,   377,   378,     0,     0,   379,   380,   381,
       0,   382,     0,   383,   384,   385,   386,   387,     0,   388,
     389,   390,     0,     0,   391,     0,     0,     0,   392,   393,
     394,   395,   396,     0,     0,   397,   398,   399,   400,   401,
       0,   402,   403,     0,   404,   405,   406,     0,     0,   407,
       0,   408,     0,   409,   410,     0,   411,   412,     0,   413,
       0,   414,     0,     0,   415,   416,   417,   418,   419,   420,
     421,   422,   423,   424,   425,   426,     0,   427,   428,     0,
       0,     0,   429,   430,   431,   432,     0,     0,     0,   433,
       0,     0,     0,   434,     0,   435,   436,   437,   438,   439,
     440,     0,   441,   442,   443,   444,   445,   446,     0,     0,
       0,     0,     0,     0,   447,   448,     0,   449,     0,     0,
     450,     0,     0,   451,   452,     0,     0,     0,   453,     0,
       0,   454,   455,     0,   456,   457,   458,   459,   460,   461,
       0,     0,   462,   463,   464,   465,     0,   466,   467,     0,
     468,     0,   469,   470,   471,   472,     0,     0,   473,   474,
       0,   475,   476,   477,   478,     0,     0,     0,     0,     0,
     479,   480,   481,     0,     0,     0,   482,   483,   484,   485,
       0,   486,   487,     0,   488,   489,     0,   490,   491,     0,
       0,   492,     0,     0,   493,     0,   494,     0,   495,   496,
     497,     0,     0,     0,     0,     0,     0,   498,     0,     0,
     499,     0,     0,     0,   500,   501,   502,   503,   504,   505,
     506,     0,     0,     0,     0,     0,     0,   507,   508,     0,
     509,   510,   511,     0,     0,   512,     0,     0,     0,     0,
       0,     0,  2377,   142,     0,   143,   144,   145,   146,   147,
     148,     0,     0,   149,     0,   560,     0,   150,     0,     0,
     151,     0,   152,   153,   154,   155,   156,   157,   158,   159,
       0,   160,     0,     0,     0,   161,     0,     0,     0,   162,
       0,     0,   163,   164,   165,     0,   166,     0,   167,   168,
       0,     0,   169,     0,     0,   170,   171,     0,   172,   173,
       0,   174,   175,     0,   176,   177,   178,   179,   180,   181,
     182,     0,   183,   184,   185,   186,   187,   188,   189,     0,
     190,   191,   192,   193,   194,   195,   196,   197,     0,   198,
     199,     0,   200,   201,   202,   203,   204,     0,   205,     0,
       0,   206,     0,     0,   207,     0,   208,     0,     0,   209,
       0,   210,     0,     0,     0,   211,   212,   213,     0,     0,
     214,     0,     0,     0,     0,   215,   216,     0,     0,     0,
       0,   217,     0,   218,     0,     0,     0,   219,     0,   220,
     221,   222,   223,   224,     0,     0,     0,   225,     0,     0,
     226,   227,   228,     0,     0,     0,   229,     0,   230,   231,
       0,   232,   233,   234,     0,     0,   235,   236,     0,   237,
     238,   239,   240,   241,   242,   243,     0,     0,   244,   245,
     246,   247,     0,     0,   248,   249,     0,   250,   251,   252,
       0,     0,   253,     0,     0,     0,   254,     0,   255,     0,
     256,     0,   257,   258,   259,   260,   261,   262,   263,     0,
     264,     0,     0,     0,   265,   266,   267,     0,   268,     0,
       0,     0,   269,   270,     0,     0,     0,   271,   272,   273,
     274,   275,     0,     0,   276,   277,   278,     0,   279,     0,
     280,     0,     0,     0,     0,   281,   282,     0,     0,     0,
     283,     0,   284,   285,     0,   286,   287,     0,     0,     0,
     288,     0,     0,   289,   290,   291,     0,     0,   292,     0,
       0,   293,   294,     0,     0,     0,     0,     0,   295,   296,
       0,   297,     0,   298,     0,   299,   300,     0,     0,     0,
       0,     0,     0,     0,   301,   302,   303,   304,   305,   306,
     307,   308,   309,   310,   311,   312,   313,   314,   315,   316,
       0,   317,   318,   319,   320,     0,   321,   322,   323,   324,
       0,   325,   326,     0,     0,     0,     0,   327,   328,   329,
     330,   331,   332,     0,     0,   333,   334,     0,   335,     0,
     336,     0,   337,   338,   339,   340,   341,   342,   343,   344,
     345,     0,     0,   346,   347,     0,     0,   348,   349,   350,
     351,     0,     0,     0,   352,   353,     0,     0,     0,   354,
       0,   355,   356,   357,     0,   358,   359,   360,   361,     0,
     362,   363,     0,     0,     0,     0,     0,     0,     0,     0,
     364,   365,   366,     0,     0,   367,     0,   368,     0,   369,
     370,   371,   372,   373,   374,   375,   376,   377,   378,     0,
       0,   379,   380,   381,     0,   382,     0,   383,   384,   385,
     386,   387,     0,   388,   389,   390,     0,     0,   391,     0,
       0,     0,   392,   393,   394,   395,   396,     0,     0,   397,
     398,   399,   400,   401,     0,   402,   403,     0,   404,   405,
     406,     0,     0,   407,     0,   408,     0,   409,   410,     0,
     411,   412,     0,   413,     0,   414,     0,     0,   415,   416,
     417,   418,   419,   420,   421,   422,   423,   424,   425,   426,
       0,   427,   428,     0,     0,     0,   429,   430,   431,   432,
       0,     0,     0,   433,     0,     0,     0,   434,     0,   435,
     436,   437,   438,   439,   440,     0,   441,   442,   443,   444,
     445,   446,     0,     0,     0,     0,     0,     0,   447,   448,
       0,   449,     0,     0,   450,     0,     0,   451,   452,     0,
       0,     0,   453,     0,     0,   454,   455,     0,   456,   457,
     458,   459,   460,   461,     0,     0,   462,   463,   464,   465,
       0,   466,   467,     0,   468,     0,   469,   470,   471,   472,
       0,     0,   473,   474,     0,   475,   476,   477,   478,     0,
       0,     0,     0,     0,   479,   480,   481,     0,     0,     0,
     482,   483,   484,   485,     0,   486,   487,     0,   488,   489,
       0,   490,   491,     0,     0,   492,     0,     0,   493,     0,
     494,     0,   495,   496,   497,     0,     0,     0,     0,     0,
       0,   498,     0,     0,   499,     0,     0,     0,   500,   501,
     502,   503,   504,   505,   506,     0,     0,     0,     0,     0,
       0,   507,   508,     0,   509,   510,   511,     0,     0,   512,
       0,     0,     0,   142,     0,   143,   144,   145,   146,   147,
     148,  3070,     0,   149,     0,     0,     0,   150,     0,  3071,
     151,     0,   152,   153,   154,   155,   156,   157,   158,   159,
       0,   160,     0,     0,     0,   161,     0,     0,     0,   162,
       0,     0,   163,   164,   165,     0,   166,     0,   167,   168,
       0,     0,   169,     0,     0,   170,   171,     0,   172,   173,
       0,   174,   175,     0,   176,   177,   178,   179,   180,   181,
     182,     0,   183,   184,   185,   186,   187,   188,   189,     0,
     190,   191,   192,   193,   194,   195,   196,   197,     0,   198,
     199,     0,   200,   201,   202,   203,   204,     0,   205,     0,
       0,   206,     0,     0,   207,     0,   208,     0,     0,   209,
       0,   210,     0,     0,     0,   211,   212,   213,     0,     0,
     214,     0,     0,     0,     0,   215,   216,     0,     0,     0,
       0,   217,     0,   218,     0,     0,     0,   219,     0,   220,
     221,   222,   223,   224,     0,     0,     0,   225,     0,     0,
     226,   227,   228,     0,     0,     0,   229,     0,   230,   231,
       0,   232,   233,   234,     0,     0,   235,   236,     0,   237,
     238,   239,   240,   241,   242,   243,     0,     0,   244,   245,
     246,   247,     0,     0,   248,   249,     0,   250,   251,   252,
       0,     0,   253,     0,     0,     0,   254,     0,   255,     0,
     256,     0,   257,   258,   259,   260,   261,   262,   263,     0,
     264,     0,     0,     0,   265,   266,   267,     0,   268,     0,
       0,     0,   269,   270,     0,     0,     0,   271,   272,   273,
     274,   275,     0,     0,   276,   277,   278,     0,   279,     0,
     280,     0,     0,     0,     0,   281,   282,     0,     0,     0,
     283,     0,   284,   285,     0,   286,   287,     0,     0,     0,
     288,     0,     0,   289,   290,   291,     0,     0,   292,     0,
       0,   293,   294,     0,     0,     0,     0,     0,   295,   296,
       0,   297,     0,   298,     0,   299,   300,     0,     0,     0,
       0,     0,     0,     0,   301,   302,   303,   304,   305,   306,
     307,   308,   309,   310,   311,   312,   313,   314,   315,   316,
       0,   317,   318,   319,   320,     0,   321,   322,   323,   324,
       0,   325,   326,     0,     0,     0,     0,   327,   328,   329,
     330,   331,   332,     0,     0,   333,   334,     0,   335,     0,
     336,     0,   337,   338,   339,   340,   341,   342,   343,   344,
     345,     0,     0,   346,   347,     0,     0,   348,   349,   350,
     351,     0,     0,     0,   352,   353,     0,     0,     0,   354,
       0,   355,   356,   357,     0,   358,   359,   360,   361,     0,
     362,   363,     0,     0,     0,     0,     0,     0,     0,     0,
     364,   365,   366,     0,     0,   367,     0,   368,     0,   369,
     370,   371,   372,   373,   374,   375,   376,   377,   378,     0,
       0,   379,   380,   381,     0,   382,     0,   383,   384,   385,
     386,   387,     0,   388,   389,   390,     0,     0,   391,     0,
       0,     0,   392,   393,   394,   395,   396,     0,     0,   397,
     398,   399,   400,   401,     0,   402,   403,     0,   404,   405,
     406,     0,     0,   407,     0,   408,     0,   409,   410,     0,
     411,   412,     0,   413,     0,   414,     0,     0,   415,   416,
     417,   418,   419,   420,   421,   422,   423,   424,   425,   426,
       0,   427,   428,     0,     0,     0,   429,   430,   431,   432,
       0,     0,     0,   433,     0,     0,     0,   434,     0,   435,
     436,   437,   438,   439,   440,     0,   441,   442,   443,   444,
     445,   446,     0,     0,     0,     0,     0,     0,   447,   448,
       0,   449,     0,     0,   450,     0,     0,   451,   452,     0,
       0,     0,   453,     0,     0,   454,   455,     0,   456,   457,
     458,   459,   460,   461,     0,     0,   462,   463,   464,   465,
       0,   466,   467,     0,   468,     0,   469,   470,   471,   472,
       0,     0,   473,   474,     0,   475,   476,   477,   478,     0,
       0,     0,     0,     0,   479,   480,   481,     0,     0,     0,
     482,   483,   484,   485,     0,   486,   487,     0,   488,   489,
       0,   490,   491,     0,     0,   492,     0,     0,   493,     0,
     494,     0,   495,   496,   497,     0,     0,     0,     0,     0,
       0,   498,     0,     0,   499,     0,     0,     0,   500,   501,
     502,   503,   504,   505,   506,     0,     0,     0,     0,     0,
       0,   507,   508,     0,   509,   510,   511,     0,     0,   512,
       0,     0,     0,   142,     0,   143,   144,   145,   146,   147,
     148,     0,     0,   149,     0,     0,     0,   150,  4768,   799,
     151,     0,   152,   153,   154,   155,   156,   157,   158,   159,
       0,   160,     0,     0,     0,   161,     0,     0,     0,   162,
       0,     0,   163,   164,   165,     0,   166,     0,   167,   168,
       0,     0,   169,     0,     0,   170,   171,     0,   172,   173,
       0,   174,   175,     0,   176,   177,   178,   179,   180,   181,
     182,     0,   183,   184,   185,   186,   187,   188,   189,     0,
     190,   191,   192,   193,   194,   195,   196,   197,     0,   198,
     199,     0,   200,   201,   202,   203,   204,     0,   205,     0,
       0,   206,     0,     0,   207,     0,   208,     0,     0,   209,
       0,   210,     0,     0,     0,   211,   212,   213,     0,     0,
     214,     0,     0,     0,     0,   215,   216,     0,     0,     0,
       0,   217,     0,   218,     0,     0,     0,   219,     0,   220,
     221,   222,   223,   224,     0,     0,     0,   225,     0,     0,
     226,   227,   228,     0,     0,     0,   229,     0,   230,   231,
       0,   232,   233,   234,     0,     0,   235,   236,     0,   237,
     238,   239,   240,   241,   242,   243,     0,     0,   244,   245,
     246,   247,     0,     0,   248,   249,     0,   250,   251,   252,
       0,     0,   253,     0,     0,     0,   254,     0,   255,     0,
     256,     0,   257,   258,   259,   260,   261,   262,   263,     0,
     264,     0,     0,     0,   265,   266,   267,     0,   268,     0,
       0,     0,   269,   270,     0,     0,     0,   271,   272,   273,
     274,   275,     0,     0,   276,   277,   278,     0,   279,     0,
     280,     0,     0,     0,     0,   281,   282,     0,     0,     0,
     283,     0,   284,   285,     0,   286,   287,     0,     0,     0,
     288,     0,     0,   289,   290,   291,     0,     0,   292,     0,
       0,   293,   294,     0,     0,     0,     0,     0,   295,   296,
       0,   297,     0,   298,     0,   299,   300,     0,     0,     0,
       0,     0,     0,     0,   301,   302,   303,   304,   305,   306,
     307,   308,   309,   310,   311,   312,   313,   314,   315,   316,
       0,   317,   318,   319,   320,     0,   321,   322,   323,   324,
       0,   325,   326,     0,     0,     0,     0,   327,   328,   329,
     330,   331,   332,     0,     0,   333,   334,     0,   335,     0,
     336,     0,   337,   338,   339,   340,   341,   342,   343,   344,
     345,     0,     0,   346,   347,     0,     0,   348,   349,   350,
     351,     0,     0,     0,   352,   353,     0,     0,     0,   354,
       0,   355,   356,   357,     0,   358,   359,   360,   361,     0,
     362,   363,     0,     0,     0,     0,     0,     0,     0,     0,
     364,   365,   366,     0,     0,   367,     0,   368,     0,   369,
     370,   371,   372,   373,   374,   375,   376,   377,   378,     0,
       0,   379,   380,   381,     0,   382,     0,   383,   384,   385,
     386,   387,     0,   388,   389,   390,     0,     0,   391,     0,
       0,     0,   392,   393,   394,   395,   396,     0,     0,   397,
     398,   399,   400,   401,     0,   402,   403,     0,   404,   405,
     406,     0,     0,   407,     0,   408,     0,   409,   410,     0,
     411,   412,     0,   413,     0,   414,     0,     0,   415,   416,
     417,   418,   419,   420,   421,   422,   423,   424,   425,   426,
       0,   427,   428,     0,     0,     0,   429,   430,   431,   432,
       0,     0,     0,   433,     0,     0,     0,   434,     0,   435,
     436,   437,   438,   439,   440,     0,   441,   442,   443,   444,
     445,   446,     0,     0,     0,     0,     0,     0,   447,   448,
       0,   449,     0,     0,   450,     0,     0,   451,   452,     0,
       0,     0,   453,     0,     0,   454,   455,     0,   456,   457,
     458,   459,   460,   461,     0,     0,   462,   463,   464,   465,
       0,   466,   467,     0,   468,     0,   469,   470,   471,   472,
       0,     0,   473,   474,     0,   475,   476,   477,   478,     0,
       0,     0,     0,     0,   479,   480,   481,     0,     0,     0,
     482,   483,   484,   485,     0,   486,   487,     0,   488,   489,
       0,   490,   491,     0,     0,   492,     0,     0,   493,     0,
     494,     0,   495,   496,   497,     0,     0,     0,     0,     0,
       0,   498,     0,     0,   499,     0,     0,     0,   500,   501,
     502,   503,   504,   505,   506,     0,     0,     0,     0,     0,
       0,   507,   508,     0,   509,   510,   511,     0,     0,   512,
       0,   142,     0,   143,   144,   145,   146,   147,   148,     0,
       0,   149,     0,     0,     0,   150,     0,     0,   151,   560,
     152,   153,   154,   155,   156,   157,   158,   159,     0,   160,
       0,     0,     0,   161,     0,     0,     0,   162,     0,     0,
     163,   164,   165,     0,   166,     0,   167,   168,     0,     0,
     169,     0,     0,   170,   171,     0,   172,   173,     0,   174,
     175,     0,   176,   177,   178,   179,   180,   181,   182,     0,
     183,   184,   185,   186,   187,   188,   189,     0,   190,   191,
     192,   193,   194,   195,   196,   197,     0,   198,   199,     0,
     200,   201,   202,   203,   204,     0,   205,     0,     0,   206,
       0,     0,   207,     0,   208,     0,     0,   209,     0,   210,
       0,     0,     0,   211,   212,   213,     0,     0,   214,     0,
       0,     0,     0,   215,   216,     0,     0,     0,     0,   217,
       0,   218,     0,     0,     0,   219,     0,   220,   221,   222,
     223,   224,     0,     0,     0,   225,     0,     0,   226,   227,
     228,     0,     0,     0,   229,     0,   230,   231,     0,   232,
     233,   234,     0,     0,   235,   236,     0,   237,   238,   239,
     240,   241,   242,   243,     0,     0,   244,   245,   631,   247,
       0,     0,   248,   249,     0,   250,   251,   252,     0,     0,
     253,     0,     0,     0,   254,     0,   255,     0,   256,     0,
     257,   258,   259,   260,   261,   262,   263,     0,   264,     0,
       0,     0,   265,   266,   267,     0,   268,     0,     0,     0,
     269,   270,     0,     0,     0,   271,   272,   273,   274,   275,
       0,     0,   276,   277,   278,     0,   279,     0,   280,     0,
       0,     0,     0,   281,   282,     0,     0,     0,   283,     0,
     284,   285,     0,   286,   287,     0,     0,     0,   288,     0,
       0,   289,   290,   291,     0,     0,   292,     0,     0,   293,
     294,     0,     0,     0,     0,     0,   295,   296,     0,   297,
       0,   298,     0,   299,   300,     0,     0,     0,     0,     0,
       0,     0,   301,   302,   303,   304,   305,   306,   307,   308,
     309,   310,   311,   312,   313,   314,   315,   316,     0,   317,
     318,   319,   320,     0,   321,   322,   323,   324,     0,   325,
     326,     0,     0,     0,     0,   327,   328,   329,   330,   331,
     332,     0,     0,   333,   334,     0,   335,     0,   336,     0,
     337,   338,   339,   340,   341,   342,   343,   344,   345,     0,
       0,   346,   347,     0,     0,   348,   349,   350,   351,     0,
       0,     0,   352,   353,     0,     0,     0,   354,     0,   355,
     356,   357,     0,   358,   359,   360,   361,     0,   362,   363,
       0,     0,     0,     0,     0,     0,     0,     0,   364,   365,
     366,     0,     0,   367,     0,   368,     0,   632,   370,   371,
     372,   373,   374,   375,   376,   377,   378,     0,     0,   379,
     380,   381,     0,   382,     0,   383,   384,   385,   386,   387,
       0,   388,   389,   390,     0,     0,   391,     0,     0,     0,
     392,   393,   394,   395,   396,     0,     0,   397,   398,   399,
     400,   401,     0,   402,   403,     0,   404,   405,   406,     0,
       0,   407,     0,   408,     0,   409,   410,     0,   411,   412,
       0,   413,     0,   414,     0,     0,   415,   416,   417,   418,
     419,   420,   421,   422,   423,   424,   425,   426,     0,   427,
     428,     0,     0,     0,   429,   430,   431,   432,     0,     0,
       0,   433,     0,     0,     0,   434,     0,   435,   436,   437,
     438,   439,   440,     0,   441,   442,   443,   444,   445,   446,
       0,     0,     0,     0,     0,     0,   447,   448,     0,   449,
       0,     0,   450,     0,     0,   451,   452,     0,     0,     0,
     453,     0,     0,   454,   455,     0,   456,   457,   458,   459,
     460,   461,     0,     0,   462,   463,   464,   465,     0,   466,
     467,     0,   468,     0,   469,   470,   471,   472,     0,     0,
     473,   474,     0,   475,   476,   477,   478,     0,     0,     0,
       0,     0,   479,   480,   481,     0,     0,     0,   482,   483,
     484,   485,     0,   486,   487,     0,   488,   489,     0,   490,
     491,     0,     0,   492,     0,     0,   493,     0,   494,     0,
     495,   496,   497,     0,     0,     0,     0,     0,     0,   498,
       0,     0,   499,     0,     0,     0,   500,   501,   502,   503,
     504,   505,   506,     0,     0,     0,     0,     0,     0,   507,
     508,     0,   509,   510,   511,     0,     0,   512,     0,   142,
       0,   143,   144,   145,   146,   147,   148,     0,     0,   149,
       0,     0,     0,   150,     0,     0,   151,   560,   152,   153,
     154,   155,   156,   157,   158,   159,     0,   160,     0,     0,
       0,   161,     0,     0,     0,   162,     0,     0,   163,   164,
     165,     0,   166,     0,   167,   168,     0,     0,   169,     0,
       0,   170,   171,     0,   172,   173,     0,   174,   175,     0,
     176,   177,   178,   179,   180,   181,   182,     0,   183,   184,
     185,   186,   187,   188,   189,     0,   190,   191,   192,   193,
     194,   195,   196,   197,     0,   198,   199,     0,   200,   201,
     202,   203,   204,     0,   205,     0,     0,   206,     0,     0,
     207,     0,   208,     0,     0,   209,     0,   210,     0,     0,
       0,   211,   212,   213,     0,     0,   214,     0,     0,     0,
       0,   215,   216,     0,     0,     0,     0,   217,     0,   218,
       0,     0,     0,   219,     0,   220,   221,   222,   223,   224,
       0,     0,     0,   225,     0,     0,   226,   227,   228,     0,
       0,     0,   229,     0,   230,   231,     0,   232,   233,   234,
       0,     0,   235,   236,     0,   237,   238,   239,   240,   241,
     242,   243,     0,     0,   244,   245,   246,   247,     0,     0,
     248,   249,     0,   250,   251,   252,     0,     0,   253,     0,
       0,     0,   254,     0,   255,     0,   256,     0,   257,   258,
     259,   260,   261,   262,   263,     0,   264,     0,     0,     0,
     265,   266,   267,     0,   268,     0,     0,     0,   269,   270,
       0,     0,     0,   271,   272,   273,   274,   275,     0,     0,
     276,   277,   278,     0,   279,     0,   280,     0,     0,     0,
       0,   281,   282,     0,     0,     0,   283,     0,   284,   285,
       0,   286,   287,     0,     0,     0,   288,     0,     0,   289,
     290,   291,     0,     0,   292,     0,     0,   293,   294,     0,
       0,     0,     0,     0,   295,   296,     0,   297,     0,   298,
       0,   299,   300,     0,     0,     0,     0,     0,     0,     0,
     301,   302,   303,   304,   305,   306,   307,   308,   309,   310,
     311,   312,   313,   314,   315,   316,     0,   317,   318,   319,
     320,     0,   321,   322,   323,   324,     0,   325,   326,     0,
       0,     0,     0,   327,   328,   329,   330,   331,   332,     0,
       0,   333,   334,     0,   335,     0,   336,     0,   337,   338,
     339,   340,   341,   342,   343,   344,   345,     0,     0,   346,
     347,     0,     0,   348,   349,   350,   351,     0,     0,     0,
     352,   353,     0,     0,     0,   354,     0,   355,   356,   357,
       0,   358,   359,   360,   361,     0,   362,   363,     0,     0,
       0,     0,     0,     0,     0,     0,   364,   365,   366,     0,
       0,   367,     0,   368,     0,   369,   370,   371,   372,   373,
     374,   375,   376,   377,   378,     0,     0,   379,   380,   381,
       0,   382,     0,   383,   384,   385,   386,   387,     0,   388,
     389,   390,     0,     0,   391,     0,     0,     0,   392,   393,
     394,   395,   396,     0,     0,   397,   398,   399,   400,   401,
       0,   402,   403,     0,   404,   405,   406,     0,     0,   407,
       0,   408,     0,   409,   410,     0,   411,   412,     0,   413,
       0,   414,     0,     0,   415,   416,   417,   418,   419,   420,
     421,   422,   423,   424,   425,   426,     0,   427,   428,     0,
       0,     0,   429,   430,   431,   432,     0,     0,     0,   433,
       0,     0,     0,   434,     0,   435,   436,   437,   438,   439,
     440,     0,   441,   442,   443,   444,   445,   446,     0,     0,
       0,     0,     0,     0,   447,   448,     0,   449,     0,     0,
     450,     0,     0,   451,   452,     0,     0,     0,   453,     0,
       0,   454,   455,     0,   456,   457,   458,   459,   460,   461,
       0,     0,   462,   463,   464,   465,     0,   466,   467,     0,
     468,     0,   469,   470,   471,   472,     0,     0,   473,   474,
       0,   475,   476,   477,   478,     0,     0,     0,     0,     0,
     479,   480,   481,     0,     0,     0,   482,   483,   484,   485,
       0,   486,   487,     0,   488,   489,     0,   490,   491,     0,
       0,   492,     0,     0,   493,     0,   494,     0,   495,   496,
     497,     0,     0,     0,     0,     0,     0,   498,     0,     0,
     499,     0,     0,     0,   500,   501,   502,   503,   504,   505,
     506,     0,     0,     0,     0,     0,     0,   507,   508,     0,
     509,   510,   511,     0,     0,   512,     0,   142,     0,   143,
     144,   145,   146,   147,   148,     0,     0,   149,     0,     0,
       0,   150,     0,     0,   151,   799,   152,   153,   154,   155,
     156,   157,   158,   159,     0,   160,     0,     0,     0,   161,
       0,     0,     0,   162,     0,     0,   163,   164,   165,     0,
     166,     0,   167,   168,     0,     0,   169,     0,     0,   170,
     171,     0,   172,   173,     0,   174,   175,     0,   176,   177,
     178,   179,   180,   181,   182,     0,   183,   184,   185,   186,
     187,   188,   189,     0,   190,   191,   192,   193,   194,   195,
     196,   197,     0,   198,   199,     0,   200,   201,   202,   203,
     204,     0,   205,     0,     0,   206,     0,     0,   207,     0,
     208,     0,     0,   209,     0,   210,     0,     0,     0,   211,
     212,   213,     0,     0,   214,     0,     0,     0,     0,   215,
     216,     0,     0,     0,     0,   217,     0,   218,     0,     0,
       0,   219,     0,   220,   221,   222,   223,   224,     0,     0,
       0,   225,     0,     0,   226,   227,   228,     0,     0,     0,
     229,     0,   230,   231,     0,   232,   233,   234,     0,     0,
     235,   236,     0,   237,   238,   239,   240,   241,   242,   243,
       0,     0,   244,   245,   246,   247,     0,     0,   248,   249,
       0,   250,   251,   252,     0,     0,   253,     0,     0,     0,
     254,     0,   255,     0,   256,     0,   257,   258,   259,   260,
     261,   262,   263,     0,   264,     0,     0,     0,   265,   266,
     267,     0,   268,     0,     0,     0,   269,   270,     0,     0,
       0,   271,   272,   273,   274,   275,     0,     0,   276,   277,
     278,     0,   279,     0,   280,     0,     0,     0,     0,   281,
     282,     0,     0,     0,   283,     0,   284,   285,     0,   286,
     287,     0,     0,     0,   288,     0,     0,   289,   290,   291,
       0,     0,   292,     0,     0,   293,   294,     0,     0,     0,
       0,     0,   295,   296,     0,   297,     0,   298,     0,   299,
     300,     0,     0,     0,     0,     0,     0,     0,   301,   302,
     303,   304,   305,   306,   307,   308,   309,   310,   311,   312,
     313,   314,   315,   316,     0,   317,   318,   319,   320,     0,
     321,   322,   323,   324,     0,   325,   326,     0,     0,     0,
       0,   327,   328,   329,   330,   331,   332,     0,     0,   333,
     334,     0,   335,     0,   336,     0,   337,   338,   339,   340,
     341,   342,   343,   344,   345,     0,     0,   346,   347,     0,
       0,   348,   349,   350,   351,     0,     0,     0,   352,   353,
       0,     0,     0,   354,     0,   355,   356,   357,     0,   358,
     359,   360,   361,     0,   362,   363,     0,     0,     0,     0,
       0,     0,     0,     0,   364,   365,   366,     0,     0,   367,
       0,   368,     0,   369,   370,   371,   372,   373,   374,   375,
     376,   377,   378,     0,     0,   379,   380,   381,     0,   382,
       0,   383,   384,   385,   386,   387,     0,   388,   389,   390,
       0,     0,   391,     0,     0,     0,   392,   393,   394,   395,
     396,     0,     0,   397,   398,   399,   400,   401,     0,   402,
     403,     0,   404,   405,   406,     0,     0,   407,     0,   408,
       0,   409,   410,     0,   411,   412,     0,   413,     0,   414,
       0,     0,   415,   416,   417,   418,   419,   420,   421,   422,
     423,   424,   425,   426,     0,   427,   428,     0,     0,     0,
     429,   430,   431,   432,     0,     0,     0,   433,     0,     0,
       0,   434,     0,   435,   436,   437,   438,   439,   440,     0,
     441,   442,   443,   444,   445,   446,     0,     0,     0,     0,
       0,     0,   447,   448,     0,   449,     0,     0,   450,     0,
       0,   451,   452,     0,     0,     0,   453,     0,     0,   454,
     455,     0,   456,   457,   458,   459,   460,   461,     0,     0,
     462,   463,   464,   465,     0,   466,   467,     0,   468,     0,
     469,   470,   471,   472,     0,     0,   473,   474,     0,   475,
     476,   477,   478,     0,     0,     0,     0,     0,   479,   480,
     481,     0,     0,     0,   482,   483,   484,   485,     0,   486,
     487,     0,   488,   489,     0,   490,   491,     0,     0,   492,
       0,     0,   493,     0,   494,     0,   495,   496,   497,     0,
       0,     0,     0,     0,     0,   498,     0,     0,   499,     0,
       0,     0,   500,   501,   502,   503,   504,   505,   506,     0,
       0,     0,     0,     0,     0,   507,   508,     0,   509,   510,
     511,     0,     0,   512,     0,   142,     0,   143,   144,   145,
     146,   147,   148,     0,     0,   149,     0,     0,     0,   150,
       0,     0,   151,  3071,   152,   153,   154,   155,   156,   157,
     158,   159,     0,   160,     0,     0,     0,   161,     0,     0,
       0,   162,     0,     0,   163,   164,   165,     0,   166,     0,
     167,   168,     0,     0,   169,     0,     0,   170,   171,     0,
     172,   941,   942,   174,   175,     0,   176,   177,   178,   179,
     180,   181,   182,     0,   183,   184,   185,   186,   187,   188,
     189,     0,   190,   191,   192,   193,   194,   195,   196,   197,
       0,   198,   199,     0,   200,   201,   202,   203,   204,     0,
     205,     0,     0,   206,     0,     0,   207,     0,   208,     0,
       0,   209,     0,   210,     0,     0,     0,   211,   212,   213,
       0,     0,   214,     0,     0,     0,     0,   215,   216,     0,
       0,     0,   943,   217,     0,   218,     0,     0,     0,   219,
       0,   220,   221,   222,   223,   224,     0,     0,     0,   225,
       0,     0,   226,   227,   228,     0,     0,     0,   229,     0,
     230,   231,     0,   232,   233,   234,     0,     0,   235,   236,
       0,   237,   238,   239,   240,   241,   242,   243,     0,     0,
     244,   245,   246,   247,     0,     0,   248,   249,     0,   250,
     251,   252,     0,     0,   253,     0,     0,     0,   254,     0,
     255,     0,   256,     0,   257,   258,   259,   260,   261,   262,
     944,     0,   264,     0,     0,     0,   265,   266,   267,     0,
     268,     0,     0,     0,   269,   270,     0,     0,     0,   271,
     272,   273,   274,   275,     0,     0,   276,   277,   278,     0,
     279,     0,   280,     0,     0,     0,     0,   281,   282,     0,
       0,     0,   283,     0,   284,   285,     0,   286,   287,     0,
       0,     0,   288,     0,     0,   289,   290,   291,     0,     0,
     292,     0,     0,   293,   294,     0,     0,     0,     0,     0,
     295,   296,     0,   945,     0,   298,     0,   299,   300,     0,
       0,     0,     0,     0,     0,     0,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,     0,   317,   318,   319,   320,     0,   321,   322,
     323,   324,     0,   325,   326,     0,     0,     0,     0,   327,
     328,   329,   330,   331,   332,     0,     0,   333,   334,     0,
     335,     0,   336,     0,   337,   338,   339,   340,   341,   342,
     946,   344,   345,     0,     0,   346,   347,     0,     0,   348,
     349,   350,   351,     0,     0,     0,   352,   353,     0,     0,
       0,   354,     0,   355,   356,   357,     0,   358,   359,   360,
     361,     0,   362,   363,     0,     0,     0,     0,     0,     0,
       0,     0,   364,   365,   366,     0,     0,   367,     0,   368,
       0,   369,   370,   947,   372,   373,   374,   375,   376,   377,
     378,     0,     0,   379,   380,   381,     0,   382,     0,   383,
     384,   385,   386,   387,     0,   388,   389,   390,     0,     0,
     391,     0,     0,     0,   392,   393,   394,   395,   396,     0,
       0,   397,   398,   399,   400,   401,     0,   402,   403,     0,
     404,   405,   406,     0,     0,   407,     0,   408,     0,   409,
     410,     0,   411,   412,     0,   413,     0,   414,     0,     0,
     948,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,     0,   427,   428,     0,     0,     0,   429,   430,
     949,   432,     0,     0,     0,   433,     0,     0,     0,   434,
       0,   435,   436,   437,   438,   439,   440,     0,   441,   442,
     443,   444,   445,   446,     0,     0,     0,     0,     0,     0,
     447,   448,     0,   449,     0,     0,   450,     0,     0,   451,
     452,     0,     0,     0,   453,     0,     0,   454,   455,     0,
     456,   457,   458,   459,   460,   461,     0,     0,   462,   463,
     464,   465,     0,   466,   467,     0,   468,     0,   469,   470,
     471,   472,     0,     0,   473,   474,     0,   475,   476,   477,
     478,     0,     0,     0,     0,     0,   950,   480,   481,     0,
       0,     0,   482,   483,   484,   485,     0,   486,   487,     0,
     488,   489,     0,   490,   491,     0,     0,   492,     0,     0,
     493,     0,   494,     0,   495,   496,   497,     0,     0,     0,
       0,     0,     0,   498,     0,     0,   499,     0,     0,     0,
     500,   501,   502,   503,   504,   505,   506,     0,     0,     0,
       0,     0,     0,   507,   508,     0,   509,   510,   511,     0,
       0,   512,   142,     0,   143,   144,   145,   146,   147,   148,
       0,     0,   149,     0,     0,     0,   150,     0,     0,   151,
     951,   152,   153,   154,   155,   156,   157,   158,   159,     0,
     160,     0,     0,     0,   161,     0,     0,     0,   162,     0,
       0,   163,   164,   165,     0,   166,     0,   167,   168,     0,
       0,   169,     0,     0,   170,   171,     0,   172,   173,     0,
     174,   175,     0,   176,   177,   178,   179,   180,   181,   182,
       0,   183,   184,   185,   186,   187,   188,   189,     0,   190,
     191,   192,   193,   194,   195,   196,   197,     0,   198,   199,
       0,   200,   201,   202,   203,   204,     0,   205,     0,     0,
     206,     0,     0,   207,     0,   208,     0,     0,   209,     0,
     210,     0,     0,     0,   211,   212,   213,     0,     0,   214,
       0,     0,     0,     0,   215,   216,     0,     0,     0,     0,
     217,     0,   218,     0,     0,     0,   219,     0,   220,   221,
     222,   223,   224,     0,     0,     0,   225,     0,     0,   226,
     227,   228,     0,     0,     0,   229,     0,   230,   231,     0,
     232,   233,   234,     0,     0,   235,   236,     0,   237,   238,
     239,   240,   241,   242,   243,     0,     0,   244,   245,   246,
     247,     0,     0,   248,   249,     0,   250,   251,   252,     0,
       0,   253,     0,     0,     0,   254,     0,   255,     0,   256,
       0,   257,   258,   259,   260,   261,   262,   263,     0,   264,
       0,     0,     0,   265,   266,   267,     0,   268,     0,     0,
       0,   269,   270,     0,     0,     0,   271,   272,   273,   274,
     275,     0,     0,   276,   277,   278,     0,   279,     0,   280,
       0,     0,     0,     0,   281,   282,     0,     0,     0,   283,
       0,   284,   285,     0,   286,   287,     0,     0,     0,   288,
       0,     0,   289,   290,   291,     0,     0,   292,     0,     0,
     293,   294,   643,     0,     0,     0,     0,   295,   296,     0,
     297,     0,   298,     0,   299,   300,     0,     0,     0,     0,
       0,     0,     0,   301,   302,   303,   304,   305,   306,   307,
     308,   309,   310,   311,   312,   313,   314,   315,   316,     0,
     317,   318,   319,   320,     0,   321,   322,   323,   324,     0,
     325,   326,     0,     0,     0,     0,   327,   328,   329,   330,
     331,   332,     0,     0,   333,   334,     0,   335,     0,   336,
       0,   337,   338,   339,   340,   341,   342,   343,   344,   345,
       0,     0,   346,   347,     0,     0,   348,   349,   350,   351,
       0,     0,     0,   352,   353,     0,     0,     0,   354,     0,
     355,   356,   357,     0,   358,   359,   360,   361,     0,   362,
     363,     0,     0,     0,     0,     0,     0,     0,     0,   364,
     365,   366,     0,     0,   367,     0,   368,     0,   369,   370,
     371,   372,   373,   374,   375,   376,   377,   378,     0,     0,
     379,   380,   381,     0,   382,     0,   383,   384,   385,   386,
     387,     0,   388,   389,   390,     0,     0,   391,     0,     0,
       0,   392,   393,   394,   395,   396,     0,     0,   397,   398,
     399,   400,   401,     0,   402,   403,     0,   404,   405,   406,
       0,     0,   407,     0,   408,     0,   409,   410,     0,   411,
     412,     0,   413,     0,   414,     0,     0,   415,   416,   417,
     418,   419,   420,   421,   422,   423,   424,   425,   426,     0,
     427,   428,     0,     0,     0,   429,   430,   431,   432,     0,
       0,     0,   433,     0,     0,     0,   434,     0,   435,   436,
     437,   438,   439,   440,     0,   441,   442,   443,   444,   445,
     446,     0,     0,     0,     0,     0,     0,   447,   448,     0,
     449,     0,     0,   450,     0,     0,   451,   452,     0,     0,
       0,   453,     0,     0,   454,   455,     0,   456,   457,   458,
     459,   460,   461,     0,     0,   462,   463,   464,   465,     0,
     466,   467,     0,   468,     0,   469,   470,   471,   472,     0,
     139,   473,   474,     0,   475,   476,   477,   478,     0,     0,
       0,     0,     0,   479,   480,   481,     0,     0,     0,   482,
     483,   484,   485,     0,   486,   487,     0,   488,   489,     0,
     490,   491,     0,     0,   492,     0,     0,   493,     0,   494,
       0,   495,   496,   497,     0,     0,     0,     0,     0,     0,
     498,     0,     0,   499,     0,     0,     0,   500,   501,   502,
     503,   504,   505,   506,     0,     0,     0,     0,     0,     0,
     507,   508,     0,   509,   510,   511,     0,     0,   512,   142,
       0,   143,   144,   145,   146,   147,   148,     0,     0,   149,
       0,     0,     0,   150,     0,     0,   151,  1435,   152,   153,
     154,   155,   156,   157,   158,   159,     0,   160,     0,     0,
       0,   161,     0,     0,     0,   162,     0,     0,   163,   164,
     165,     0,   166,     0,   167,   168,     0,     0,   169,     0,
       0,   170,   171,     0,   172,   173,     0,   174,   175,     0,
     176,   177,   178,   179,   180,   181,   182,     0,   183,   184,
     185,   186,   187,   188,   189,     0,   190,   191,   192,   193,
     194,   195,   196,   197,     0,   198,   199,     0,   200,   201,
     202,   203,   204,     0,   205,     0,     0,   206,     0,     0,
     207,     0,   208,     0,     0,   209,     0,   210,     0,     0,
       0,   211,   212,   213,     0,     0,   214,     0,     0,     0,
       0,   215,   216,     0,     0,     0,     0,   217,     0,   218,
       0,     0,     0,   219,     0,   220,   221,   222,   223,   224,
       0,     0,     0,   225,     0,     0,   226,   227,   228,     0,
       0,     0,   229,     0,   230,   231,     0,   232,   233,   234,
       0,     0,   235,   236,     0,   237,   238,   239,   240,   241,
     242,   243,     0,     0,   244,   245,   246,   247,     0,     0,
     248,   249,     0,   250,   251,   252,     0,     0,   253,     0,
       0,     0,   254,     0,   255,     0,   256,     0,   257,   258,
     259,   260,   261,   262,   263,     0,   264,     0,     0,     0,
     265,   266,   267,     0,   268,     0,     0,     0,   269,   270,
       0,     0,     0,   271,   272,   273,   274,   275,     0,     0,
     276,   277,   278,     0,   279,     0,   280,     0,     0,     0,
       0,   281,   282,     0,     0,     0,   283,     0,   284,   285,
       0,   286,   287,     0,     0,     0,   288,     0,     0,   289,
     290,   291,     0,     0,   292,     0,     0,   293,   294,   643,
       0,     0,     0,     0,   295,   296,     0,   297,     0,   298,
       0,   299,   300,     0,     0,     0,     0,     0,     0,     0,
     301,   302,   303,   304,   305,   306,   307,   308,   309,   310,
     311,   312,   313,   314,   315,   316,     0,   317,   318,   319,
     320,     0,   321,   322,   323,   324,     0,   325,   326,     0,
       0,     0,     0,   327,   328,   329,   330,   331,   332,     0,
       0,   333,   334,     0,   335,     0,   336,     0,   337,   338,
     339,   340,   341,   342,   343,   344,   345,     0,     0,   346,
     347,     0,     0,   348,   349,   350,   351,     0,     0,     0,
     352,   353,     0,     0,     0,   354,     0,   355,   356,   357,
       0,   358,   359,   360,   361,     0,   362,   363,     0,     0,
       0,     0,     0,     0,     0,     0,   364,   365,   366,     0,
       0,   367,     0,   368,     0,   369,   370,   371,   372,   373,
     374,   375,   376,   377,   378,     0,     0,   379,   380,   381,
       0,   382,     0,   383,   384,   385,   386,   387,     0,   388,
     389,   390,     0,     0,   391,     0,     0,     0,   392,   393,
     394,   395,   396,     0,     0,   397,   398,   399,   400,   401,
       0,   402,   403,     0,   404,   405,   406,     0,     0,   407,
       0,   408,     0,   409,   410,     0,   411,   412,     0,   413,
       0,   414,     0,     0,   415,   416,   417,   418,   419,   420,
     421,   422,   423,   424,   425,   426,     0,   427,   428,     0,
       0,     0,   429,   430,   431,   432,     0,     0,     0,   433,
       0,     0,     0,   434,     0,   435,   436,   437,   438,   439,
     440,     0,   441,   442,   443,   444,   445,   446,     0,     0,
       0,     0,     0,     0,   447,   448,     0,   449,     0,     0,
     450,     0,     0,   451,   452,     0,     0,     0,   453,     0,
       0,   454,   455,     0,   456,   457,   458,   459,   460,   461,
       0,     0,   462,   463,   464,   465,     0,   466,   467,     0,
     468,     0,   469,   470,   471,   472,     0,   139,   473,   474,
       0,   475,   476,   477,   478,     0,     0,     0,     0,     0,
     479,   480,   481,     0,     0,     0,   482,   483,   484,   485,
       0,   486,   487,     0,   488,   489,     0,   490,   491,     0,
       0,   492,     0,     0,   493,     0,   494,     0,   495,   496,
     497,     0,     0,     0,     0,     0,     0,   498,     0,     0,
     499,     0,     0,     0,   500,   501,   502,   503,   504,   505,
     506,     0,     0,     0,     0,     0,     0,   507,   508,     0,
     509,   510,   511,     0,     0,   512,   142,     0,   143,   144,
     145,   146,   147,   148,     0,     0,   149,     0,     0,     0,
     150,     0,     0,   151,  1781,   152,   153,   154,   155,   156,
     157,   158,   159,     0,   160,     0,     0,     0,   161,     0,
       0,     0,   162,     0,     0,   163,   164,   165,     0,   166,
       0,   167,   168,     0,     0,   169,     0,     0,   170,   171,
       0,   172,   941,   942,   174,   175,     0,   176,   177,   178,
     179,   180,   181,   182,     0,   183,   184,   185,   186,   187,
     188,   189,     0,   190,   191,   192,   193,   194,   195,   196,
     197,     0,   198,   199,     0,   200,   201,   202,   203,   204,
       0,   205,     0,     0,   206,     0,     0,   207,     0,   208,
       0,     0,   209,     0,   210,     0,     0,     0,   211,   212,
     213,     0,     0,   214,     0,     0,     0,     0,   215,   216,
       0,     0,     0,   943,   217,     0,   218,     0,     0,     0,
     219,     0,   220,   221,   222,   223,   224,     0,     0,     0,
     225,     0,     0,   226,   227,   228,     0,     0,     0,   229,
       0,   230,   231,     0,   232,   233,   234,     0,     0,   235,
     236,     0,   237,   238,   239,   240,   241,   242,   243,     0,
       0,   244,   245,   246,   247,     0,     0,   248,   249,     0,
     250,   251,   252,     0,     0,   253,     0,     0,     0,   254,
       0,   255,     0,   256,     0,   257,   258,   259,   260,   261,
     262,   944,     0,   264,     0,     0,     0,   265,   266,   267,
       0,   268,     0,     0,     0,   269,   270,     0,     0,     0,
     271,   272,   273,   274,   275,     0,     0,   276,   277,   278,
       0,   279,     0,   280,     0,     0,     0,     0,   281,   282,
       0,     0,     0,   283,     0,   284,   285,     0,   286,   287,
       0,     0,     0,   288,     0,     0,   289,   290,   291,     0,
       0,   292,     0,     0,   293,   294,     0,     0,     0,     0,
       0,   295,   296,     0,   945,     0,   298,     0,   299,   300,
       0,     0,     0,     0,     0,     0,     0,   301,   302,   303,
     304,   305,   306,   307,   308,   309,   310,   311,   312,   313,
     314,   315,   316,     0,   317,   318,   319,   320,     0,   321,
     322,   323,   324,     0,   325,   326,     0,     0,     0,     0,
     327,   328,   329,   330,   331,   332,     0,     0,   333,   334,
       0,   335,     0,   336,     0,   337,   338,   339,   340,   341,
     342,   946,   344,   345,     0,     0,   346,   347,     0,     0,
     348,   349,   350,   351,     0,     0,     0,   352,   353,     0,
       0,     0,   354,     0,   355,   356,   357,     0,   358,   359,
     360,   361,     0,   362,   363,     0,     0,     0,     0,     0,
       0,     0,     0,   364,   365,   366,     0,     0,   367,     0,
     368,     0,   369,   370,   947,   372,   373,   374,   375,   376,
     377,   378,     0,     0,   379,   380,   381,     0,   382,     0,
     383,   384,   385,   386,   387,     0,   388,   389,   390,     0,
       0,   391,     0,     0,     0,   392,   393,   394,   395,   396,
       0,     0,   397,   398,   399,   400,   401,     0,   402,   403,
       0,   404,   405,   406,     0,     0,   407,     0,   408,     0,
     409,   410,     0,   411,   412,     0,   413,     0,   414,     0,
       0,   948,   416,   417,   418,   419,   420,   421,   422,   423,
     424,   425,   426,     0,   427,   428,     0,     0,     0,   429,
     430,   949,   432,     0,     0,     0,   433,     0,     0,     0,
     434,     0,   435,   436,   437,   438,   439,   440,     0,   441,
     442,   443,   444,   445,   446,     0,     0,     0,     0,     0,
       0,   447,   448,     0,   449,     0,     0,   450,     0,     0,
     451,   452,     0,     0,     0,   453,     0,     0,   454,   455,
       0,   456,   457,   458,   459,   460,   461,     0,     0,   462,
     463,   464,   465,     0,   466,   467,     0,   468,     0,   469,
     470,   471,   472,     0,     0,   473,   474,     0,   475,   476,
     477,   478,     0,     0,     0,     0,     0,   479,   480,   481,
       0,     0,     0,   482,   483,   484,   485,     0,   486,   487,
       0,   488,   489,     0,   490,   491,     0,     0,   492,     0,
       0,   493,     0,   494,     0,   495,   496,   497,     0,     0,
       0,     0,     0,     0,   498,     0,     0,   499,     0,     0,
       0,   500,   501,   502,   503,   504,   505,   506,     0,     0,
       0,     0,     0,     0,   507,   508,     0,   509,   510,   511,
       0,     0,   512,   142,     0,   143,   144,   145,   146,   147,
     148,     0,     0,   149,     0,     0,     0,   150,     0,     0,
     151,   951,   152,   153,   154,   155,   156,   157,   158,   159,
       0,   160,     0,     0,     0,   161,     0,     0,     0,   162,
       0,     0,   163,   164,   165,     0,   166,     0,   167,   168,
       0,     0,   169,     0,     0,   170,   171,     0,   172,   173,
       0,   174,   175,     0,   176,   177,   178,   179,   180,   181,
     182,     0,   183,   184,   185,   186,   187,   188,   189,     0,
     190,   191,   192,   193,   194,   195,   196,   197,     0,   198,
     199,     0,   200,   201,   202,   203,   204,     0,   205,     0,
       0,   206,     0,     0,   207,     0,   208,     0,     0,   209,
       0,   210,     0,     0,     0,   211,   212,   213,     0,     0,
     214,     0,     0,     0,     0,   215,   216,     0,     0,     0,
       0,   217,     0,   218,     0,     0,     0,   219,     0,   220,
     221,   222,   223,   224,     0,     0,     0,   225,     0,     0,
     226,   227,   228,     0,     0,     0,   229,     0,   230,   231,
       0,   232,   233,   234,     0,     0,   235,   236,     0,   237,
     238,   239,   240,   241,   242,   243,     0,     0,   244,   245,
     246,   247,     0,     0,   248,   249,     0,   250,   251,   252,
       0,     0,   253,     0,     0,     0,   254,     0,   255,     0,
     256,     0,   257,   258,   259,   260,   261,   262,   263,     0,
     264,     0,     0,     0,   265,   266,   267,     0,   268,     0,
       0,     0,   269,   270,     0,     0,     0,   271,   272,   273,
     274,   275,     0,     0,   276,   277,   278,     0,   279,     0,
     280,     0,     0,     0,     0,   281,   282,     0,     0,     0,
     283,     0,   284,   285,     0,   286,   287,     0,     0,     0,
     288,     0,     0,   289,   290,   291,     0,     0,   292,     0,
       0,   293,   294,   643,     0,     0,     0,     0,   295,   296,
       0,   297,     0,   298,     0,   299,   300,     0,     0,     0,
       0,     0,     0,     0,   301,   302,   303,   304,   305,   306,
     307,   308,   309,   310,   311,   312,   313,   314,   315,   316,
       0,   317,   318,   319,   320,     0,   321,   322,   323,   324,
       0,   325,   326,     0,     0,     0,     0,   327,   328,   329,
     330,   331,   332,     0,     0,   333,   334,     0,   335,     0,
     336,     0,   337,   338,   339,   340,   341,   342,   343,   344,
     345,     0,     0,   346,   347,     0,     0,   348,   349,   350,
     351,     0,     0,     0,   352,   353,     0,     0,     0,   354,
       0,   355,   356,   357,     0,   358,   359,   360,   361,     0,
     362,   363,     0,     0,     0,     0,     0,     0,     0,     0,
     364,   365,   366,     0,     0,   367,     0,   368,     0,   369,
     370,   371,   372,   373,   374,   375,   376,   377,   378,     0,
       0,   379,   380,   381,     0,   382,     0,   383,   384,   385,
     386,   387,     0,   388,   389,   390,     0,     0,   391,     0,
       0,     0,   392,   393,   394,   395,   396,     0,     0,   397,
     398,   399,   400,   401,     0,   402,   403,     0,   404,   405,
     406,     0,     0,   407,     0,   408,     0,   409,   410,     0,
     411,   412,     0,   413,     0,   414,     0,     0,   415,   416,
     417,   418,   419,   420,   421,   422,   423,   424,   425,   426,
       0,   427,   428,     0,     0,     0,   429,   430,   431,   432,
       0,     0,     0,   433,     0,     0,     0,   434,     0,   435,
     436,   437,   438,   439,   440,     0,   441,   442,   443,   444,
     445,   446,     0,     0,     0,     0,     0,     0,   447,   448,
       0,   449,     0,     0,   450,     0,     0,   451,   452,     0,
       0,     0,   453,     0,     0,   454,   455,     0,   456,   457,
     458,   459,   460,   461,     0,     0,   462,   463,   464,   465,
       0,   466,   467,     0,   468,     0,   469,   470,   471,   472,
       0,   139,   473,   474,     0,   475,   476,   477,   478,     0,
       0,     0,     0,     0,   479,   480,   481,     0,     0,     0,
     482,   483,   484,   485,     0,   486,   487,     0,   488,   489,
       0,   490,   491,     0,     0,   492,     0,     0,   493,     0,
     494,     0,   495,   496,   497,     0,     0,     0,     0,     0,
       0,   498,     0,     0,   499,     0,     0,     0,   500,   501,
     502,   503,   504,   505,   506,     0,     0,     0,     0,     0,
       0,   507,   508,     0,   509,   510,   511,     0,     0,   512,
     142,     0,   143,   144,   145,   146,   147,   148,     0,     0,
     149,     0,     0,     0,   150,     0,     0,   151,  3630,   152,
     153,   154,   155,   156,   157,   158,   159,     0,   160,     0,
       0,     0,   161,     0,     0,     0,   162,     0,     0,   163,
     164,   165,     0,   166,     0,   167,   168,     0,     0,   169,
       0,     0,   170,   171,     0,   172,   173,     0,   174,   175,
       0,   176,   177,   178,   179,   180,   181,   182,     0,   183,
     184,   185,   186,   187,   188,   189,     0,   190,   191,   192,
     193,   194,   195,   196,   197,  1315,   198,   199,     0,   200,
     201,   202,   203,   204,     0,   205,     0,     0,   206,     0,
       0,   207,     0,   208,     0,     0,   209,     0,   210,     0,
       0,     0,   211,   212,   213,     0,     0,   214,     0,     0,
       0,     0,   215,   216,     0,     0,     0,     0,   217,     0,
     218,     0,     0,     0,   219,     0,   220,   221,   222,   223,
     224,     0,     0,     0,   225,     0,     0,   226,   227,   228,
       0,     0,     0,   229,     0,   230,   231,     0,   232,   233,
     234,     0,     0,   235,   236,     0,   237,   238,   239,   240,
     241,   242,   243,     0,     0,   244,   245,   246,   247,     0,
       0,   248,   249,     0,   250,   251,   252,     0,     0,   253,
       0,     0,     0,   254,     0,   255,     0,   256,     0,   257,
     258,   259,   260,   261,   262,   263,     0,   264,     0,     0,
       0,   265,   266,   267,     0,   268,     0,     0,     0,   269,
     270,     0,     0,     0,   271,   272,   273,   274,   275,     0,
       0,   276,   277,   278,     0,   279,     0,   280,     0,     0,
       0,     0,   281,   282,     0,     0,     0,   283,     0,   284,
     285,     0,   286,   287,     0,     0,     0,   288,     0,     0,
     289,   290,   291,     0,     0,   292,     0,     0,   293,   294,
       0,     0,     0,     0,     0,   295,   296,     0,   297,     0,
     298,     0,   299,   300,     0,     0,     0,     0,     0,     0,
       0,   301,   302,   303,   304,   305,   306,   307,   308,   309,
     310,   311,   312,   313,   314,   315,   316,     0,   317,   318,
     319,   320,     0,   321,   322,   323,   324,     0,   325,   326,
       0,     0,     0,     0,   327,   328,   329,   330,   331,   332,
       0,     0,   333,   334,     0,   335,     0,   336,     0,   337,
     338,   339,   340,   341,   342,   343,   344,   345,     0,     0,
     346,   347,     0,     0,   348,   349,   350,   351,     0,     0,
       0,   352,   353,     0,     0,     0,   354,     0,   355,   356,
     357,     0,   358,   359,   360,   361,     0,   362,   363,     0,
       0,     0,     0,     0,     0,     0,     0,   364,   365,   366,
       0,     0,   367,     0,   368,     0,   369,   370,   371,   372,
     373,   374,   375,   376,   377,   378,     0,     0,   379,   380,
     381,     0,   382,     0,   383,   384,   385,   386,   387,     0,
     388,   389,   390,     0,     0,   391,     0,     0,     0,   392,
     393,   394,   395,   396,     0,     0,   397,   398,   399,   400,
     401,     0,   402,   403,     0,   404,   405,   406,     0,     0,
     407,     0,   408,     0,   409,   410,     0,   411,   412,     0,
     413,     0,   414,     0,     0,   415,   416,   417,   418,   419,
     420,   421,   422,   423,   424,   425,   426,     0,   427,   428,
       0,     0,     0,   429,   430,   431,   432,     0,     0,     0,
     433,     0,     0,     0,   434,     0,   435,   436,   437,   438,
     439,   440,     0,   441,   442,   443,   444,   445,   446,     0,
       0,     0,     0,     0,     0,   447,   448,     0,   449,     0,
       0,   450,     0,     0,   451,   452,     0,     0,     0,   453,
       0,     0,   454,   455,     0,   456,   457,   458,   459,   460,
     461,     0,     0,   462,   463,   464,   465,     0,   466,   467,
       0,   468,     0,   469,   470,   471,   472,     0,     0,   473,
     474,     0,   475,   476,   477,   478,     0,     0,     0,     0,
       0,   479,   480,   481,     0,     0,     0,   482,   483,   484,
     485,     0,   486,   487,     0,   488,   489,     0,   490,   491,
       0,     0,   492,     0,     0,   493,     0,   494,     0,   495,
     496,   497,     0,     0,     0,     0,     0,     0,   498,     0,
       0,   499,     0,     0,     0,   500,   501,   502,   503,   504,
     505,   506,     0,     0,     0,     0,     0,     0,   507,   508,
       0,   509,   510,   511,     0,     0,   512,   142,     0,   143,
     144,   145,   146,   147,   148,     0,     0,   149,     0,     0,
       0,   150,     0,     0,   151,  1316,   152,   153,   154,   155,
     156,   157,   158,   159,     0,   160,     0,     0,     0,   161,
       0,     0,     0,   162,     0,     0,   163,   164,   165,     0,
     166,     0,   167,   168,     0,     0,   169,     0,     0,   170,
     171,     0,   172,   173,     0,   174,   175,     0,   176,   177,
     178,   179,   180,   181,   182,     0,   183,   184,   185,   186,
     187,   188,   189,     0,   190,   191,   192,   193,   194,   195,
     196,   197,     0,   198,   199,     0,   200,   201,   202,   203,
     204,     0,   205,     0,     0,   206,     0,     0,   207,     0,
     208,     0,     0,   209,     0,   210,     0,     0,     0,   211,
     212,   213,     0,     0,   214,     0,     0,     0,     0,   215,
     216,     0,     0,     0,     0,   217,     0,   218,     0,     0,
       0,   219,     0,   220,   221,   222,   223,   224,     0,     0,
       0,   225,     0,     0,   226,   227,   228,     0,     0,     0,
     229,     0,   230,   231,     0,   232,   233,   234,     0,     0,
     235,   236,     0,   237,   238,   239,   240,   241,   242,   243,
       0,     0,   244,   245,   246,   247,     0,     0,   248,   249,
       0,   250,   251,   252,     0,     0,   253,     0,     0,     0,
     254,     0,   255,     0,   256,     0,   257,   258,   259,   260,
     261,   262,   263,     0,   264,     0,     0,     0,   265,   266,
     267,     0,   268,     0,     0,     0,   269,   270,     0,     0,
       0,   271,   272,   273,   274,   275,     0,     0,   276,   277,
     278,     0,   279,     0,   280,     0,     0,     0,     0,   281,
     282,     0,     0,     0,   283,     0,   284,   285,     0,   286,
     287,     0,     0,     0,   288,     0,     0,   289,   290,   291,
       0,     0,   292,     0,     0,   293,   294,     0,     0,     0,
       0,     0,   295,   296,     0,   297,     0,   298,     0,   299,
     300,     0,     0,     0,     0,     0,     0,     0,   301,   302,
     303,   304,   305,   306,   307,   308,   309,   310,   311,   312,
     313,   314,   315,   316,     0,   317,   318,   319,   320,     0,
     321,   322,   323,   324,     0,   325,   326,     0,     0,     0,
       0,   327,   328,   329,   330,   331,   332,     0,     0,   333,
     334,     0,   335,     0,   336,     0,   337,   338,   339,   340,
     341,   342,   343,   344,   345,     0,     0,   346,   347,     0,
       0,   348,   349,   350,   351,     0,     0,     0,   352,   353,
       0,     0,     0,   354,     0,   355,   356,   357,     0,   358,
     359,   360,   361,     0,   362,   363,     0,     0,     0,     0,
       0,     0,     0,     0,   364,   365,   366,     0,     0,   367,
       0,   368,     0,   369,   370,   371,   372,   373,   374,   375,
     376,   377,   378,     0,     0,   379,   380,   381,     0,   382,
       0,   383,   384,   385,   386,   387,     0,   388,   389,   390,
       0,     0,   391,     0,     0,     0,   392,   393,   394,   395,
     396,     0,     0,   397,   398,   399,   400,   401,     0,   402,
     403,     0,   404,   405,   406,     0,     0,   407,     0,   408,
       0,   409,   410,     0,   411,   412,     0,   413,     0,   414,
       0,     0,   415,   416,   417,   418,   419,   420,   421,   422,
     423,   424,   425,   426,     0,   427,   428,     0,     0,     0,
     429,   430,   431,   432,     0,     0,     0,   433,     0,     0,
       0,   434,     0,   435,   436,   437,   438,   439,   440,     0,
     441,   442,   443,   444,   445,   446,     0,     0,     0,     0,
       0,     0,   447,   448,     0,   449,     0,     0,   450,     0,
       0,   451,   452,     0,     0,     0,   453,     0,     0,   454,
     455,     0,   456,   457,   458,   459,   460,   461,     0,     0,
     462,   463,   464,   465,     0,   466,   467,     0,   468,     0,
     469,   470,   471,   472,     0,     0,   473,   474,     0,   475,
     476,   477,   478,     0,     0,     0,     0,     0,   479,   480,
     481,     0,     0,     0,   482,   483,   484,   485,     0,   486,
     487,     0,   488,   489,     0,   490,   491,     0,     0,   492,
       0,     0,   493,     0,   494,     0,   495,   496,   497,     0,
       0,     0,     0,     0,     0,   498,     0,     0,   499,     0,
       0,     0,   500,   501,   502,   503,   504,   505,   506,     0,
       0,     0,     0,     0,     0,   507,   508,     0,   509,   510,
     511,     0,     0,   512,   142,     0,   143,   144,   145,   146,
     147,   148,     0,     0,   149,     0,     0,     0,   150,     0,
       0,     0,  1316,   152,   153,   154,   155,   156,   157,   158,
       0,     0,  -372,     0,     0,     0,   161,     0,     0,     0,
     162,     0,     0,   163,   164,   165,     0,   166,     0,     0,
       0,     0,     0,   169,  4145,     0,   170,   171,     0,   172,
       0,     0,     0,     0,     0,   176,   177,   178,   179,  4146,
     181,   182,     0,   183,   184,     0,     0,     0,     0,     0,
       0,   190,     0,   192,     0,   194,   195,   196,   197,     0,
     198,   199,     0,   200,   201,   202,     0,   204,     0,   205,
       0,     0,   206,     0,     0,   207,     0,   208,     0,     0,
     209,     0,   210,     0,     0,     0,   211,   212,   213,     0,
       0,   214,     0,     0,     0,     0,   215,     0,     0,     0,
       0,     0,   217,     0,   218,     0,     0,     0,   219,     0,
     220,   221,   222,   223,   224,     0,     0,     0,     0,     0,
       0,   226,   227,   228,     0,     0,     0,   229,     0,     0,
     231,     0,   232,   233,   234,     0,     0,   235,   236,     0,
     237,   238,   239,   240,   241,     0,     0,     0,     0,   244,
     245,   246,   247,     0,     0,   248,   249,  4147,   250,   251,
     252,     0,     0,     0,     0,     0,     0,   254,     0,   255,
       0,   256,     0,   257,   258,   259,   260,   261,     0,   263,
       0,   264,     0,     0,     0,     0,   266,   267,     0,     0,
       0,     0,     0,     0,   270,     0,     0,     0,   271,   272,
     273,   274,   275,  4148,     0,   276,   277,   278,     0,   279,
       0,   280,     0,     0,     0,     0,   281,     0,     0,     0,
       0,   283,     0,   284,   285,     0,   286,   287,  4149,     0,
       0,   288,     0,     0,     0,   290,   291,     0,     0,   292,
    4150,     0,   293,   294,     0,     0,     0,     0,     0,   295,
     296,     0,   297,     0,   298,     0,   299,   300,     0,     0,
       0,     0,  -327,     0,     0,   301,   302,   303,   304,   305,
     306,   307,   308,   309,   310,   311,   312,   313,   314,   315,
     316,     0,   317,   318,   319,   320,     0,   321,   322,   323,
     324,     0,   325,   326,     0,     0,     0,     0,   327,   328,
     329,   330,   331,   332,     0,     0,   333,   334,     0,   335,
       0,   336,     0,   337,   338,   339,   340,   341,   342,   343,
     344,   345,     0,     0,   346,   347,     0,     0,   348,   349,
     350,   351,     0,     0,     0,     0,   353,     0,     0,     0,
     354,     0,   355,   356,   357,     0,   358,   359,   360,  4151,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   365,   366,     0,     0,     0,     0,   368,     0,
     369,   370,   371,   372,   373,   374,   375,   376,   377,     0,
       0,     0,     0,   380,   381,     0,   382,     0,   383,   384,
     385,   386,   387,     0,   388,   389,   390,     0,     0,   391,
       0,     0,     0,   392,   393,   394,   395,   396,     0,     0,
     397,   398,   399,   400,   401,     0,   402,     0,     0,   404,
       0,   406,  -327,     0,   407,     0,     0,     0,   409,     0,
       0,   411,   412,     0,   413,  4152,   414,     0,     0,   415,
       0,   417,   418,   419,   420,   421,   422,   423,     0,   425,
     426,     0,   427,     0,     0,     0,     0,   429,   430,   431,
       0,     0,     0,     0,   433,     0,     0,     0,     0,     0,
       0,   436,     0,     0,   439,   440,     0,   441,     0,   443,
       0,   445,   446,     0,     0,     0,     0,     0,     0,   447,
     448,     0,   449,     0,     0,   450,     0,     0,   451,     0,
       0,     0,     0,   453,     0,     0,     0,   455,     0,   456,
     457,   458,   459,   460,   461,     0,     0,   462,   463,   464,
     465,     0,   466,   467,     0,   468,     0,   469,   470,   471,
     472,     0,     0,   473,   474,     0,   475,   476,   477,   478,
       0,     0,     0,     0,     0,   479,   480,   481,     0,     0,
       0,     0,   483,   484,   485,     0,   486,   487,     0,   488,
     489,     0,     0,     0,     0,     0,   492,     0,     0,   493,
       0,     0,     0,   495,   496,   497,     0,     0,     0,     0,
       0,     0,   498,     0,     0,   499,     0,     0,     0,   500,
     501,   502,   503,   504,   505,   506,     0,     0,  -327,     0,
       0,     0,   507,     0,     0,   509,     0,   511,     0,   142,
     512,   143,   144,   145,   146,   147,   148,     0,     0,   149,
       0,     0,     0,   150,  4761,     0,   151,     0,   152,   153,
     154,   155,   156,   157,   158,   159,     0,   160,     0,     0,
       0,   161,     0,     0,     0,   162,     0,     0,   163,   164,
     165,     0,   166,     0,   167,   168,     0,     0,   169,     0,
       0,   170,   171,     0,   172,   173,     0,   174,   175,     0,
     176,   177,   178,   179,   180,   181,   182,     0,   183,   184,
     185,   186,   187,   188,   189,     0,   190,   191,   192,   193,
     194,   195,   196,   197,     0,   198,   199,     0,   200,   201,
     202,   203,   204,     0,   205,     0,     0,   206,     0,     0,
     207,     0,   208,  1048,     0,   209,     0,   210,     0,     0,
       0,   211,   212,   213,     0,     0,   214,     0,     0,     0,
       0,   215,   216,     0,     0,     0,     0,   217,     0,   218,
       0,     0,     0,   219,     0,   220,   221,   222,   223,   224,
       0,     0,     0,   225,     0,     0,   226,   227,   228,     0,
       0,     0,   229,     0,   230,   231,     0,   232,   233,   234,
       0,     0,   235,   236,     0,   237,   238,   239,   240,   241,
     242,   243,     0,     0,   244,   245,   246,   247,     0,     0,
     248,   249,     0,   250,   251,   252,     0,     0,   253,     0,
       0,     0,   254,     0,   255,     0,   256,     0,   257,   258,
     259,   260,   261,   262,   263,     0,   264,     0,     0,     0,
     265,   266,   267,     0,   268,     0,     0,     0,   269,   270,
       0,     0,     0,   271,   272,   273,   274,   275,     0,     0,
     276,   277,   278,     0,   279,     0,   280,     0,     0,     0,
       0,   281,   282,     0,     0,     0,   283,     0,   284,   285,
       0,   286,   287,     0,     0,     0,   288,     0,     0,   289,
     290,   291,     0,     0,   292,     0,     0,   293,   294,   643,
       0,     0,     0,     0,   295,   296,     0,   297,     0,   298,
       0,   299,   300,     0,     0,     0,     0,     0,     0,     0,
     301,   302,   303,   304,   305,   306,   307,   308,   309,   310,
     311,   312,   313,   314,   315,   316,     0,   317,   318,   319,
     320,     0,   321,   322,   323,   324,     0,   325,   326,     0,
       0,     0,     0,   327,   328,   329,   330,   331,   332,     0,
       0,   333,   334,     0,   335,     0,   336,     0,   337,   338,
     339,   340,   341,   342,   343,   344,   345,     0,     0,   346,
     347,     0,     0,   348,   349,   350,   351,     0,     0,     0,
     352,   353,     0,     0,     0,   354,     0,   355,   356,   357,
       0,   358,   359,   360,   361,     0,   362,   363,     0,     0,
       0,     0,     0,     0,     0,     0,   364,   365,   366,     0,
       0,   367,     0,   368,     0,   369,   370,   371,   372,   373,
     374,   375,   376,   377,   378,     0,     0,   379,   380,   381,
       0,   382,     0,   383,   384,   385,   386,   387,     0,   388,
     389,   390,     0,     0,   391,     0,     0,     0,   392,   393,
     394,   395,   396,     0,     0,   397,   398,   399,   400,   401,
       0,   402,   403,     0,   404,   405,   406,     0,     0,   407,
       0,   408,     0,   409,   410,     0,   411,   412,     0,   413,
       0,   414,     0,     0,   415,   416,   417,   418,   419,   420,
     421,   422,   423,   424,   425,   426,     0,   427,   428,     0,
       0,     0,   429,   430,   431,   432,     0,     0,     0,   433,
       0,     0,     0,   434,     0,   435,   436,   437,   438,   439,
     440,     0,   441,   442,   443,   444,   445,   446,     0,     0,
       0,     0,     0,     0,   447,   448,     0,   449,     0,     0,
     450,     0,     0,   451,   452,     0,     0,     0,   453,     0,
       0,   454,   455,     0,   456,   457,   458,   459,   460,   461,
       0,     0,   462,   463,   464,   465,     0,   466,   467,     0,
     468,     0,   469,   470,   471,   472,     0,   139,   473,   474,
       0,   475,   476,   477,   478,     0,     0,     0,     0,     0,
     479,   480,   481,     0,     0,     0,   482,   483,   484,   485,
       0,   486,   487,     0,   488,   489,     0,   490,   491,     0,
       0,   492,     0,     0,   493,     0,   494,     0,   495,   496,
     497,     0,     0,     0,     0,     0,     0,   498,     0,     0,
     499,     0,     0,     0,   500,   501,   502,   503,   504,   505,
     506,     0,     0,     0,     0,     0,     0,   507,   508,     0,
     509,   510,   511,     0,   142,   512,   143,   144,   145,   146,
     147,   148,     0,     0,   149,     0,     0,  1213,   150,     0,
       0,   151,     0,   152,   153,   154,   155,   156,   157,   158,
     159,     0,   160,     0,     0,     0,   161,     0,     0,     0,
     162,     0,     0,   163,   164,   165,     0,   166,     0,   167,
     168,     0,     0,   169,     0,     0,   170,   171,     0,   172,
     173,     0,   174,   175,     0,   176,   177,   178,   179,   180,
     181,   182,     0,   183,   184,   185,   186,   187,   188,   189,
       0,   190,   191,   192,   193,   194,   195,   196,   197,     0,
     198,   199,     0,   200,   201,   202,   203,   204,     0,   205,
       0,     0,   206,     0,     0,   207,     0,   208,     0,     0,
     209,     0,   210,     0,     0,     0,   211,   212,   213,     0,
       0,   214,     0,     0,     0,     0,   215,   216,     0,     0,
       0,     0,   217,     0,   218,     0,     0,     0,   219,     0,
     220,   221,   222,   223,   224,     0,     0,     0,   225,     0,
       0,   226,   227,   228,     0,     0,     0,   229,     0,   230,
     231,     0,   232,   233,   234,     0,     0,   235,   236,     0,
     237,   238,   239,   240,   241,   242,   243,     0,     0,   244,
     245,   246,   247,     0,     0,   248,   249,     0,   250,   251,
     252,     0,     0,   253,     0,     0,     0,   254,     0,   255,
       0,   256,     0,   257,   258,   259,   260,   261,   262,   263,
       0,   264,     0,     0,     0,   265,   266,   267,     0,   268,
       0,     0,     0,   269,   270,     0,     0,     0,   271,   272,
     273,   274,   275,     0,     0,   276,   277,   278,     0,   279,
       0,   280,     0,     0,     0,     0,   281,   282,     0,     0,
       0,   283,     0,   284,   285,     0,   286,   287,     0,     0,
       0,   288,     0,     0,   289,   290,   291,     0,     0,   292,
       0,     0,   293,   294,     0,     0,     0,     0,     0,   295,
     296,     0,   297,     0,   298,     0,   299,   300,     0,     0,
       0,     0,     0,     0,     0,   301,   302,   303,   304,   305,
     306,   307,   308,   309,   310,   311,   312,   313,   314,   315,
     316,     0,   317,   318,   319,   320,     0,   321,   322,   323,
     324,     0,   325,   326,     0,     0,     0,     0,   327,   328,
     329,   330,   331,   332,     0,     0,   333,   334,     0,   335,
       0,   336,     0,   337,   338,   339,   340,   341,   342,   343,
     344,   345,     0,     0,   346,   347,     0,     0,   348,   349,
     350,   351,     0,     0,     0,   352,   353,     0,     0,     0,
     354,     0,   355,   356,   357,     0,   358,   359,   360,   361,
       0,   362,   363,     0,     0,     0,     0,     0,     0,     0,
       0,   364,   365,   366,     0,     0,   367,     0,   368,     0,
     369,   370,   371,   372,   373,   374,   375,   376,   377,   378,
       0,     0,   379,   380,   381,     0,   382,     0,   383,   384,
     385,   386,   387,     0,   388,   389,   390,     0,     0,   391,
       0,     0,     0,   392,   393,   394,   395,   396,     0,     0,
     397,   398,   399,   400,   401,     0,   402,   403,     0,   404,
     405,   406,     0,     0,   407,     0,   408,     0,   409,   410,
       0,   411,   412,     0,   413,     0,   414,     0,     0,   415,
     416,   417,   418,   419,   420,   421,   422,   423,   424,   425,
     426,     0,   427,   428,     0,     0,     0,   429,   430,   431,
     432,     0,     0,     0,   433,     0,     0,     0,   434,     0,
     435,   436,   437,   438,   439,   440,     0,   441,   442,   443,
     444,   445,   446,     0,     0,     0,     0,     0,     0,   447,
     448,     0,   449,     0,     0,   450,     0,     0,   451,   452,
       0,     0,     0,   453,     0,     0,   454,   455,     0,   456,
     457,   458,   459,   460,   461,     0,     0,   462,   463,   464,
     465,     0,   466,   467,     0,   468,     0,   469,   470,   471,
     472,     0,     0,   473,   474,     0,   475,   476,   477,   478,
       0,     0,     0,     0,     0,   479,   480,   481,     0,     0,
       0,   482,   483,   484,   485,     0,   486,   487,     0,   488,
     489,     0,   490,   491,     0,     0,   492,     0,     0,   493,
       0,   494,     0,   495,   496,   497,     0,     0,     0,     0,
       0,     0,   498,     0,     0,   499,     0,     0,     0,   500,
     501,   502,   503,   504,   505,   506,     0,     0,     0,     0,
       0,     0,   507,   508,     0,   509,   510,   511,     0,   142,
     512,   143,   144,   145,   146,   147,   148,  2200,     0,   149,
       0,     0,     0,   150,     0,     0,   151,     0,   152,   153,
     154,   155,   156,   157,   158,   159,     0,   160,     0,     0,
       0,   161,     0,     0,     0,   162,     0,     0,   163,   164,
     165,     0,   166,     0,   167,   168,     0,     0,   169,     0,
       0,   170,   171,     0,   172,   173,     0,   174,   175,     0,
     176,   177,   178,   179,   180,   181,   182,     0,   183,   184,
     185,   186,   187,   188,   189,     0,   190,   191,   192,   193,
     194,   195,   196,   197,     0,   198,   199,     0,   200,   201,
     202,   203,   204,     0,   205,     0,     0,   206,     0,     0,
     207,     0,   208,     0,     0,   209,     0,   210,     0,     0,
       0,   211,   212,   213,     0,     0,   214,     0,     0,     0,
       0,   215,   216,     0,     0,     0,     0,   217,     0,   218,
       0,     0,     0,   219,     0,   220,   221,   222,   223,   224,
       0,     0,     0,   225,     0,     0,   226,   227,   228,     0,
       0,     0,   229,     0,   230,   231,     0,   232,   233,   234,
       0,     0,   235,   236,     0,   237,   238,   239,   240,   241,
     242,   243,     0,     0,   244,   245,   246,   247,     0,     0,
     248,   249,     0,   250,   251,   252,     0,     0,   253,     0,
       0,     0,   254,     0,   255,     0,   256,     0,   257,   258,
     259,   260,   261,   262,   263,     0,   264,     0,     0,     0,
     265,   266,   267,     0,   268,     0,     0,     0,   269,   270,
       0,     0,     0,   271,   272,   273,   274,   275,     0,     0,
     276,   277,   278,     0,   279,     0,   280,     0,     0,     0,
       0,   281,   282,     0,     0,     0,   283,     0,   284,   285,
       0,   286,   287,     0,     0,     0,   288,     0,     0,   289,
     290,   291,     0,     0,   292,     0,     0,   293,   294,     0,
       0,     0,     0,     0,   295,   296,     0,   297,     0,   298,
       0,   299,   300,     0,     0,     0,     0,     0,     0,     0,
     301,   302,   303,   304,   305,   306,   307,   308,   309,   310,
     311,   312,   313,   314,   315,   316,     0,   317,   318,   319,
     320,     0,   321,   322,   323,   324,     0,   325,   326,     0,
       0,     0,     0,   327,   328,   329,   330,   331,   332,     0,
       0,   333,   334,     0,   335,     0,   336,     0,   337,   338,
     339,   340,   341,   342,   343,   344,   345,     0,     0,   346,
     347,     0,     0,   348,   349,   350,   351,     0,     0,     0,
     352,   353,     0,     0,     0,   354,     0,   355,   356,   357,
       0,   358,   359,   360,   361,     0,   362,   363,     0,     0,
       0,     0,     0,     0,     0,     0,   364,   365,   366,     0,
       0,   367,     0,   368,     0,   369,   370,   371,   372,   373,
     374,   375,   376,   377,   378,     0,     0,   379,   380,   381,
       0,   382,     0,   383,   384,   385,   386,   387,     0,   388,
     389,   390,     0,     0,   391,     0,     0,     0,   392,   393,
     394,   395,   396,     0,     0,   397,   398,   399,   400,   401,
       0,   402,   403,     0,   404,   405,   406,     0,     0,   407,
       0,   408,     0,   409,   410,     0,   411,   412,     0,   413,
       0,   414,     0,     0,   415,   416,   417,   418,   419,   420,
     421,   422,   423,   424,   425,   426,     0,   427,   428,     0,
       0,     0,   429,   430,   431,   432,     0,     0,     0,   433,
       0,     0,     0,   434,     0,   435,   436,   437,   438,   439,
     440,     0,   441,   442,   443,   444,   445,   446,     0,     0,
       0,     0,     0,     0,   447,   448,     0,   449,     0,     0,
     450,     0,     0,   451,   452,     0,     0,     0,   453,     0,
       0,   454,   455,     0,   456,   457,   458,   459,   460,   461,
       0,     0,   462,   463,   464,   465,     0,   466,   467,     0,
     468,     0,   469,   470,   471,   472,     0,     0,   473,   474,
       0,   475,   476,   477,   478,     0,     0,     0,     0,     0,
     479,   480,   481,     0,     0,     0,   482,   483,   484,   485,
       0,   486,   487,     0,   488,   489,     0,   490,   491,     0,
       0,   492,     0,     0,   493,     0,   494,     0,   495,   496,
     497,     0,     0,     0,     0,     0,     0,   498,     0,     0,
     499,     0,     0,     0,   500,   501,   502,   503,   504,   505,
     506,     0,     0,     0,     0,     0,     0,   507,   508,     0,
     509,   510,   511,     0,   142,   512,   143,   144,   145,   146,
     147,   148,  2898,     0,   149,     0,     0,     0,   150,     0,
       0,   151,     0,   152,   153,   154,   155,   156,   157,   158,
     159,     0,   160,     0,     0,     0,   161,     0,     0,     0,
     162,     0,     0,   163,   164,   165,     0,   166,     0,   167,
     168,     0,     0,   169,     0,     0,   170,   171,     0,   172,
     173,     0,   174,   175,     0,   176,   177,   178,   179,   180,
     181,   182,     0,   183,   184,   185,   186,   187,   188,   189,
       0,   190,   191,   192,   193,   194,   195,   196,   197,     0,
     198,   199,     0,   200,   201,   202,   203,   204,     0,   205,
       0,     0,   206,     0,     0,   207,     0,   208,     0,     0,
     209,     0,   210,     0,     0,     0,   211,   212,   213,     0,
       0,   214,     0,     0,     0,     0,   215,   216,     0,     0,
       0,     0,   217,     0,   218,     0,     0,     0,   219,     0,
     220,   221,   222,   223,   224,     0,     0,     0,   225,     0,
       0,   226,   227,   228,     0,     0,     0,   229,     0,   230,
     231,     0,   232,   233,   234,     0,     0,   235,   236,     0,
     237,   238,   239,   240,   241,   242,   243,     0,     0,   244,
     245,   246,   247,     0,     0,   248,   249,     0,   250,   251,
     252,     0,     0,   253,     0,     0,     0,   254,     0,   255,
       0,   256,     0,   257,   258,   259,   260,   261,   262,   263,
       0,   264,     0,     0,     0,   265,   266,   267,     0,   268,
       0,     0,     0,   269,   270,     0,     0,     0,   271,   272,
     273,   274,   275,     0,     0,   276,   277,   278,     0,   279,
       0,   280,     0,     0,     0,     0,   281,   282,     0,     0,
       0,   283,     0,   284,   285,     0,   286,   287,     0,     0,
       0,   288,     0,     0,   289,   290,   291,     0,     0,   292,
       0,     0,   293,   294,     0,     0,     0,     0,     0,   295,
     296,     0,   297,     0,   298,     0,   299,   300,     0,     0,
       0,     0,     0,     0,     0,   301,   302,   303,   304,   305,
     306,   307,   308,   309,   310,   311,   312,   313,   314,   315,
     316,     0,   317,   318,   319,   320,     0,   321,   322,   323,
     324,     0,   325,   326,     0,     0,     0,     0,   327,   328,
     329,   330,   331,   332,     0,     0,   333,   334,     0,   335,
       0,   336,     0,   337,   338,   339,   340,   341,   342,   343,
     344,   345,     0,     0,   346,   347,     0,     0,   348,   349,
     350,   351,     0,     0,     0,   352,   353,     0,     0,     0,
     354,     0,   355,   356,   357,     0,   358,   359,   360,   361,
       0,   362,   363,     0,     0,     0,     0,     0,     0,     0,
       0,   364,   365,   366,     0,     0,   367,     0,   368,     0,
     369,   370,   371,   372,   373,   374,   375,   376,   377,   378,
       0,     0,   379,   380,   381,     0,   382,     0,   383,   384,
     385,   386,   387,     0,   388,   389,   390,     0,     0,   391,
       0,     0,     0,   392,   393,   394,   395,   396,     0,     0,
     397,   398,   399,   400,   401,     0,   402,   403,     0,   404,
     405,   406,     0,     0,   407,     0,   408,     0,   409,   410,
       0,   411,   412,     0,   413,     0,   414,     0,     0,   415,
     416,   417,   418,   419,   420,   421,   422,   423,   424,   425,
     426,     0,   427,   428,     0,     0,     0,   429,   430,   431,
     432,     0,     0,     0,   433,     0,     0,     0,   434,     0,
     435,   436,   437,   438,   439,   440,     0,   441,   442,   443,
     444,   445,   446,     0,     0,     0,     0,     0,     0,   447,
     448,     0,   449,     0,     0,   450,     0,     0,   451,   452,
       0,     0,     0,   453,     0,     0,   454,   455,     0,   456,
     457,   458,   459,   460,   461,     0,     0,   462,   463,   464,
     465,     0,   466,   467,     0,   468,     0,   469,   470,   471,
     472,     0,     0,   473,   474,     0,   475,   476,   477,   478,
       0,     0,     0,     0,     0,   479,   480,   481,     0,     0,
       0,   482,   483,   484,   485,     0,   486,   487,     0,   488,
     489,     0,   490,   491,     0,     0,   492,     0,     0,   493,
       0,   494,     0,   495,   496,   497,     0,     0,     0,     0,
       0,     0,   498,     0,     0,   499,     0,     0,     0,   500,
     501,   502,   503,   504,   505,   506,     0,     0,     0,     0,
       0,     0,   507,   508,     0,   509,   510,   511,     0,   142,
     512,   143,   144,   145,   146,   147,   148,  3265,     0,   149,
       0,     0,     0,   150,     0,     0,   151,     0,   152,   153,
     154,   155,   156,   157,   158,   159,     0,   160,     0,     0,
       0,   161,     0,     0,     0,   162,     0,     0,   163,   164,
     165,     0,   166,     0,   167,   168,     0,     0,   169,     0,
       0,   170,   171,     0,   172,   173,     0,   174,   175,     0,
     176,   177,   178,   179,   180,   181,   182,     0,   183,   184,
     185,   186,   187,   188,   189,     0,   190,   191,   192,   193,
     194,   195,   196,   197,     0,   198,   199,     0,   200,   201,
     202,   203,   204,     0,   205,     0,     0,   206,     0,     0,
     207,     0,   208,     0,     0,   209,     0,   210,     0,     0,
       0,   211,   212,   213,     0,     0,   214,     0,     0,     0,
       0,   215,   216,     0,     0,     0,     0,   217,     0,   218,
       0,     0,     0,   219,     0,   220,   221,   222,   223,   224,
       0,     0,     0,   225,     0,     0,   226,   227,   228,     0,
       0,     0,   229,     0,   230,   231,     0,   232,   233,   234,
       0,     0,   235,   236,     0,   237,   238,   239,   240,   241,
     242,   243,     0,     0,   244,   245,   246,   247,     0,     0,
     248,   249,     0,   250,   251,   252,     0,     0,   253,     0,
       0,     0,   254,     0,   255,     0,   256,     0,   257,   258,
     259,   260,   261,   262,   263,     0,   264,     0,     0,     0,
     265,   266,   267,     0,   268,     0,     0,     0,   269,   270,
       0,     0,     0,   271,   272,   273,   274,   275,     0,     0,
     276,   277,   278,     0,   279,     0,   280,     0,     0,     0,
       0,   281,   282,     0,     0,     0,   283,     0,   284,   285,
       0,   286,   287,     0,     0,     0,   288,     0,     0,   289,
     290,   291,     0,     0,   292,     0,     0,   293,   294,     0,
       0,     0,     0,     0,   295,   296,     0,   297,     0,   298,
       0,   299,   300,     0,     0,     0,     0,     0,     0,     0,
     301,   302,   303,   304,   305,   306,   307,   308,   309,   310,
     311,   312,   313,   314,   315,   316,     0,   317,   318,   319,
     320,     0,   321,   322,   323,   324,     0,   325,   326,     0,
       0,     0,     0,   327,   328,   329,   330,   331,   332,     0,
       0,   333,   334,     0,   335,     0,   336,     0,   337,   338,
     339,   340,   341,   342,   343,   344,   345,     0,     0,   346,
     347,     0,     0,   348,   349,   350,   351,     0,     0,     0,
     352,   353,     0,     0,     0,   354,     0,   355,   356,   357,
       0,   358,   359,   360,   361,     0,   362,   363,     0,     0,
       0,     0,     0,     0,     0,     0,   364,   365,   366,     0,
       0,   367,     0,   368,     0,   369,   370,   371,   372,   373,
     374,   375,   376,   377,   378,     0,     0,   379,   380,   381,
       0,   382,     0,   383,   384,   385,   386,   387,     0,   388,
     389,   390,     0,     0,   391,     0,     0,     0,   392,   393,
     394,   395,   396,     0,     0,   397,   398,   399,   400,   401,
       0,   402,   403,     0,   404,   405,   406,     0,     0,   407,
       0,   408,     0,   409,   410,     0,   411,   412,     0,   413,
       0,   414,     0,     0,   415,   416,   417,   418,   419,   420,
     421,   422,   423,   424,   425,   426,     0,   427,   428,     0,
       0,     0,   429,   430,   431,   432,     0,     0,     0,   433,
       0,     0,     0,   434,     0,   435,   436,   437,   438,   439,
     440,     0,   441,   442,   443,   444,   445,   446,     0,     0,
       0,     0,     0,     0,   447,   448,     0,   449,     0,     0,
     450,     0,     0,   451,   452,     0,     0,     0,   453,     0,
       0,   454,   455,     0,   456,   457,   458,   459,   460,   461,
       0,     0,   462,   463,   464,   465,     0,   466,   467,     0,
     468,     0,   469,   470,   471,   472,     0,     0,   473,   474,
       0,   475,   476,   477,   478,     0,     0,     0,     0,     0,
     479,   480,   481,     0,     0,     0,   482,   483,   484,   485,
       0,   486,   487,     0,   488,   489,     0,   490,   491,     0,
       0,   492,     0,     0,   493,     0,   494,     0,   495,   496,
     497,     0,     0,     0,     0,     0,     0,   498,     0,     0,
     499,     0,     0,     0,   500,   501,   502,   503,   504,   505,
     506,     0,     0,     0,     0,     0,     0,   507,   508,     0,
     509,   510,   511,     0,     0,   512,     0,     0,     0,     0,
       0,   142,  3635,   143,   144,   145,   146,   147,   148,   840,
     841,   149,     0,     0,     0,   150,     0,     0,   151,     0,
     152,   153,   154,   155,   156,   157,   158,   159,     0,   160,
       0,     0,     0,   161,     0,     0,     0,   162,     0,     0,
     163,   164,   165,     0,   166,     0,   167,   168,     0,     0,
     169,     0,     0,   170,   171,     0,   172,   173,     0,   174,
     175,     0,   176,   177,   178,   179,   180,   181,   182,     0,
     183,   184,   185,   186,   187,   188,   189,     0,   190,   191,
     192,   193,   194,   195,   196,   197,     0,   198,   199,     0,
     200,   201,   202,   203,   204,     0,   205,     0,     0,   206,
     842,     0,   207,     0,   208,     0,   843,   209,     0,   210,
       0,     0,     0,   211,   212,   213,     0,     0,   214,     0,
       0,     0,     0,   215,   216,     0,     0,     0,     0,   217,
       0,   218,   844,     0,     0,   219,     0,   220,   221,   222,
     223,   224,     0,     0,     0,   225,   845,     0,   226,   227,
     228,     0,     0,     0,   229,     0,   230,   231,     0,   232,
     233,   234,     0,     0,   235,   236,     0,   237,   238,   846,
     240,   241,   242,   847,     0,     0,   244,   245,   246,   247,
       0,     0,   248,   249,     0,   848,   251,   252,     0,     0,
     253,     0,     0,     0,   254,     0,   255,     0,   256,     0,
     257,   258,   259,   260,   261,   262,   263,   849,   264,     0,
       0,     0,   265,   266,   267,     0,   268,     0,     0,     0,
     269,   270,     0,     0,     0,   271,   272,   273,   274,   275,
       0,     0,   276,   277,   278,   850,   279,     0,   280,     0,
       0,     0,   851,   281,   282,     0,     0,     0,   283,     0,
     284,   285,     0,   286,   287,     0,     0,     0,   288,     0,
       0,   289,   290,   291,     0,     0,   292,     0,     0,   293,
     294,   643,     0,     0,     0,     0,   295,   296,     0,   297,
       0,   298,   852,   299,   300,     0,     0,     0,     0,     0,
       0,     0,   301,   302,   303,   304,   305,   306,   307,   308,
     309,   310,   311,   312,   313,   314,   315,   316,     0,   317,
     318,   319,   320,     0,   321,   322,   323,   324,     0,   325,
     326,     0,     0,     0,     0,   327,   328,   329,   330,   331,
     332,     0,     0,   333,   334,     0,   335,     0,   336,     0,
     337,   338,   339,   340,   341,   342,   343,   344,   345,     0,
       0,   346,   347,     0,     0,   348,   349,   350,   351,     0,
       0,     0,   352,   353,     0,     0,     0,   354,     0,   355,
     356,   357,     0,   358,   359,   360,   361,     0,   362,   363,
       0,     0,     0,     0,     0,     0,     0,     0,   364,   365,
     366,     0,     0,   367,     0,   368,     0,   369,   370,   371,
     372,   373,   374,   375,   376,   377,   378,     0,     0,   379,
     380,   381,     0,   382,     0,   853,   384,   385,   386,   854,
       0,   388,   389,   390,     0,     0,   391,     0,     0,     0,
     392,   393,   394,   395,   396,   855,     0,   397,   398,   399,
     400,   401,     0,   856,   403,     0,   404,   405,   406,     0,
       0,   857,     0,   408,     0,   409,   410,     0,   411,   412,
       0,   413,     0,   414,     0,     0,   415,   416,   417,   418,
     419,   420,   421,   422,   423,   424,   425,   426,     0,   427,
     428,   858,     0,     0,   429,   430,   431,   432,     0,     0,
       0,   433,     0,     0,   859,   860,     0,   435,   436,   437,
     438,   439,   440,     0,   441,   442,   443,   444,   445,   446,
       0,     0,     0,     0,     0,     0,   447,   448,     0,   449,
       0,     0,   450,     0,     0,   451,   452,     0,     0,     0,
     453,     0,     0,   454,   455,     0,   456,   457,   458,   459,
     460,   461,     0,     0,   861,   463,   464,   465,     0,   466,
     467,     0,   468,     0,   469,   470,   471,   472,     0,   139,
     473,   474,     0,   475,   476,   477,   478,     0,     0,     0,
       0,     0,   479,   480,   481,   862,     0,     0,   482,   483,
     484,   485,     0,   486,   487,     0,   488,   489,     0,   490,
     491,     0,     0,   492,     0,     0,   493,   863,   494,   864,
     495,   496,   497,     0,     0,     0,     0,     0,     0,   498,
       0,     0,   499,     0,     0,     0,   500,   501,   502,   503,
     504,   505,   506,     0,     0,     0,     0,     0,     0,   507,
     508,     0,   509,   510,   511,     0,   142,   512,   917,   144,
     145,   146,   147,   148,   918,   841,   149,     0,     0,     0,
     150,     0,     0,   151,     0,   152,   153,   154,   155,   156,
     157,   158,   159,     0,   160,     0,     0,     0,   161,     0,
       0,     0,   162,     0,     0,   163,   164,   165,     0,   166,
       0,   167,   168,     0,     0,   169,     0,     0,   170,   171,
       0,   172,   173,     0,   174,   175,     0,   176,   177,   178,
     179,   180,   181,   182,     0,   183,   184,   185,   186,   187,
     188,   189,     0,   190,   191,   192,   193,   194,   195,   196,
     197,     0,   198,   199,     0,   200,   201,   202,   203,   204,
       0,   205,     0,     0,   206,   842,     0,   207,     0,   208,
       0,   843,   209,     0,   210,     0,     0,     0,   211,   212,
     213,     0,     0,   214,     0,     0,     0,     0,   215,   216,
       0,     0,     0,     0,   217,     0,   218,   844,     0,     0,
     219,     0,   220,   221,   222,   223,   224,     0,     0,     0,
     225,   845,     0,   226,   227,   228,     0,     0,     0,   229,
       0,   230,   231,     0,   232,   233,   234,     0,     0,   235,
     236,     0,   237,   238,   846,   240,   241,   242,   847,     0,
       0,   244,   245,   246,   247,     0,     0,   248,   249,     0,
     848,   251,   252,     0,     0,   253,     0,     0,     0,   254,
       0,   255,     0,   256,     0,   257,   258,   259,   260,   261,
     262,   263,   849,   264,     0,     0,     0,   265,   266,   267,
       0,   268,     0,     0,     0,   269,   270,     0,     0,     0,
     271,   272,   273,   274,   275,     0,     0,   276,   277,   278,
     850,   279,     0,   280,     0,     0,     0,   851,   281,   282,
       0,     0,     0,   283,     0,   284,   285,     0,   286,   287,
       0,     0,     0,   288,     0,     0,   289,   290,   291,     0,
       0,   292,     0,     0,   293,   294,   643,     0,     0,     0,
       0,   295,   296,     0,   297,     0,   298,   852,   299,   300,
       0,     0,     0,     0,     0,     0,     0,   301,   302,   303,
     304,   305,   306,   307,   308,   309,   310,   311,   312,   313,
     314,   315,   316,     0,   317,   318,   319,   320,     0,   321,
     322,   323,   324,     0,   325,   326,     0,     0,     0,     0,
     327,   328,   329,   330,   331,   332,     0,     0,   333,   334,
       0,   335,     0,   336,     0,   337,   338,   339,   340,   341,
     342,   343,   344,   345,     0,     0,   346,   347,     0,     0,
     348,   349,   350,   351,     0,     0,     0,   352,   353,     0,
       0,     0,   354,     0,   355,   356,   357,     0,   358,   359,
     360,   361,     0,   362,   363,     0,     0,     0,     0,     0,
       0,     0,     0,   364,   365,   366,     0,     0,   367,     0,
     368,     0,   369,   370,   371,   372,   373,   374,   375,   376,
     377,   378,     0,     0,   379,   380,   381,     0,   382,     0,
     853,   384,   385,   386,   919,     0,   388,   389,   390,     0,
       0,   391,     0,     0,     0,   392,   393,   394,   395,   396,
     855,     0,   397,   398,   399,   400,   401,     0,   856,   403,
       0,   404,   405,   406,     0,     0,   857,     0,   408,     0,
     409,   410,     0,   411,   412,     0,   413,     0,   414,     0,
       0,   415,   416,   417,   418,   419,   420,   421,   422,   423,
     424,   425,   426,     0,   427,   428,   858,     0,     0,   429,
     430,   431,   432,     0,     0,     0,   433,     0,     0,   859,
     860,     0,   435,   436,   437,   438,   439,   440,     0,   441,
     442,   443,   444,   445,   446,     0,     0,     0,     0,     0,
       0,   447,   448,     0,   449,     0,     0,   450,     0,     0,
     451,   452,     0,     0,     0,   453,     0,     0,   454,   455,
       0,   456,   457,   458,   459,   460,   461,     0,     0,   861,
     463,   464,   465,     0,   466,   467,     0,   468,     0,   469,
     470,   471,   472,     0,   139,   473,   474,     0,   475,   476,
     477,   478,     0,     0,     0,     0,     0,   479,   480,   481,
     862,     0,     0,   482,   483,   484,   485,     0,   486,   487,
       0,   488,   489,     0,   490,   491,     0,     0,   492,     0,
       0,   493,   863,   494,   864,   495,   496,   497,     0,     0,
       0,     0,     0,     0,   498,     0,     0,   499,     0,     0,
       0,   500,   501,   502,   503,   504,   505,   506,     0,     0,
       0,     0,     0,     0,   507,   508,     0,   509,   510,   511,
       0,   142,   512,   143,   144,   145,   146,   147,   148,     0,
       0,   149,     0,     0,     0,   150,     0,     0,   151,     0,
     152,   153,   154,   155,   156,   157,   158,   159,     0,   160,
       0,     0,     0,   161,     0,     0,     0,   162,     0,     0,
     163,   164,   165,     0,   166,     0,   167,   168,     0,     0,
     169,     0,     0,   170,   171,     0,   172,   173,     0,   174,
     175,     0,   176,   177,   178,   179,   180,   181,   182,     0,
     183,   184,   185,   186,   187,   188,   189,     0,   190,   191,
     192,   193,   194,   195,   196,   197,     0,   198,   199,     0,
     200,   201,   202,   203,   204,     0,   205,     0,     0,   206,
       0,     0,   207,     0,   208,     0,     0,   209,     0,   210,
       0,     0,     0,   211,   212,   213,     0,     0,   214,     0,
       0,     0,     0,   215,   216,  2551,     0,     0,     0,   217,
       0,   218,     0,     0,     0,   219,     0,   220,   221,   222,
     223,   224,     0,     0,     0,   225,     0,     0,   226,   227,
     228,     0,     0,     0,   229,     0,   230,   231,     0,   232,
     233,   234,     0,     0,   235,   236,     0,   237,   238,   239,
     240,   241,   242,   243,     0,     0,   244,   245,   246,   247,
       0,     0,   248,   249,     0,   250,   251,   252,  2552,     0,
     253,     0,     0,     0,   254,     0,   255,     0,   256,     0,
     257,   258,   259,   260,   261,   262,   263,     0,   264,     0,
       0,     0,   265,   266,   267,     0,   268,  2553,     0,     0,
     269,   270,     0,     0,     0,   271,   272,   273,   274,   275,
       0,     0,   276,   277,   278,     0,   279,     0,   280,     0,
       0,     0,     0,   281,   282,     0,     0,     0,   283,     0,
     284,   285,     0,   286,   287,     0,     0,     0,   288,     0,
       0,   289,   290,   291,     0,     0,   292,     0,     0,   293,
     294,     0,     0,     0,     0,     0,   295,   296,     0,   297,
       0,   298,     0,   299,   300,     0,     0,  2554,     0,     0,
       0,     0,   301,   302,   303,   304,   305,   306,   307,   308,
     309,   310,   311,   312,   313,   314,   315,   316,     0,   317,
     318,   319,   320,     0,   321,   322,   323,   324,     0,   325,
     326,     0,     0,     0,     0,   327,   328,   329,   330,   331,
     332,     0,     0,   333,   334,     0,   335,     0,   336,     0,
     337,   338,   339,   340,   341,   342,   343,   344,   345,     0,
       0,   346,   347,     0,     0,   348,   349,   350,   351,  1096,
    1097,     0,   352,   353,     0,     0,  2555,   354,     0,   355,
     356,   357,     0,   358,   359,   360,   361,     0,   362,   363,
       0,     0,     0,     0,     0,     0,     0,     0,   364,   365,
     366,     0,     0,   367,     0,   368,     0,   369,   370,   371,
     372,   373,   374,   375,   376,   377,   378,     0,     0,   379,
     380,   381,     0,   382,     0,   383,   384,   385,   386,   387,
       0,   388,   389,   390,     0,     0,   391,     0,     0,     0,
     392,   393,   394,   395,   396,     0,     0,   397,   398,   399,
     400,   401,     0,   402,   403,     0,   404,   405,   406,     0,
       0,   407,     0,   408,     0,   409,   410,     0,   411,   412,
       0,   413,     0,   414,     0,     0,   415,   416,   417,   418,
     419,   420,   421,   422,   423,   424,   425,   426,     0,   427,
     428,     0,     0,     0,   429,   430,   431,   432,     0,     0,
       0,   433,     0,     0,     0,   434,     0,   435,   436,   437,
     438,   439,   440,     0,   441,   442,   443,   444,   445,   446,
       0,     0,  4748,   585,  4749,     0,   447,   448,     0,   449,
       0,     0,   450,     0,     0,   451,   452,     0,     0,     0,
     453,     0,     0,   454,   455,     0,   456,   457,   458,   459,
     460,   461,     0,     0,   462,   463,   464,   465,     0,   466,
     467,     0,   468,     0,   469,   470,   471,   472,     0,     0,
     473,   474,     0,   475,   476,   477,   478,     0,     0,     0,
       0,     0,   479,   480,   481,     0,     0,     0,   482,   483,
     484,   485,  2556,   486,   487,     0,   488,   489,     0,   490,
     491,     0,     0,   492,     0,     0,   493,     0,   494,     0,
     495,   496,   497,     0,     0,     0,     0,     0,     0,   498,
       0,     0,   499,     0,     0,     0,   500,   501,   502,   503,
     504,   505,   506,     0,     0,     0,     0,     0,     0,   507,
     508,     0,   509,   510,   511,     0,   142,   512,   143,   144,
     145,   146,   147,   148,     0,     0,   149,     0,     0,     0,
     150,     0,     0,   151,     0,   152,   153,   154,   155,   156,
     157,   158,   159,     0,   160,     0,     0,     0,   161,     0,
       0,     0,   162,     0,     0,   163,   164,   165,     0,   166,
       0,   167,   168,     0,     0,   169,     0,     0,   170,   171,
       0,   172,   173,     0,   174,   175,     0,   176,   177,   178,
     179,   180,   181,   182,     0,   183,   184,   185,   186,   187,
     188,   189,     0,   190,   191,   192,   193,   194,   195,   196,
     197,     0,   198,   199,     0,   200,   201,   202,   203,   204,
       0,   205,     0,     0,   206,     0,     0,   207,     0,   208,
       0,     0,   209,     0,   210,     0,     0,     0,   211,   212,
     213,     0,     0,   214,     0,     0,     0,     0,   215,   216,
    1666,     0,     0,  3480,   217,     0,   218,     0,     0,     0,
     219,     0,   220,   221,   222,   223,   224,     0,     0,     0,
     225,     0,     0,   226,   227,   228,     0,     0,     0,   229,
       0,   230,   231,     0,   232,   233,   234,     0,     0,   235,
     236,     0,   237,   238,   239,   240,   241,   242,   243,     0,
       0,   244,   245,   246,   247,     0,     0,   248,   249,     0,
     250,   251,   252,  1667,     0,   253,     0,     0,     0,   254,
       0,   255,     0,   256,     0,   257,   258,   259,   260,   261,
     262,   263,     0,   264,     0,     0,     0,   265,   266,   267,
       0,   268,  2982,     0,     0,   269,   270,     0,     0,     0,
     271,   272,   273,   274,   275,     0,     0,   276,   277,   278,
       0,   279,     0,   280,     0,     0,     0,     0,   281,   282,
       0,     0,     0,   283,     0,   284,   285,     0,   286,   287,
       0,     0,     0,   288,     0,     0,   289,   290,   291,     0,
       0,   292,     0,     0,   293,   294,     0,     0,     0,     0,
       0,   295,   296,     0,   297,     0,   298,     0,   299,   300,
       0,     0,  2983,     0,     0,     0,     0,   301,   302,   303,
     304,   305,   306,   307,   308,   309,   310,   311,   312,   313,
     314,   315,   316,     0,   317,   318,   319,   320,     0,   321,
     322,   323,   324,     0,   325,   326,     0,     0,     0,     0,
     327,   328,   329,   330,   331,   332,     0,     0,   333,   334,
       0,   335,     0,   336,     0,   337,   338,   339,   340,   341,
     342,   343,   344,   345,     0,     0,   346,   347,     0,     0,
     348,   349,   350,   351,     0,     0,     0,   352,   353,     0,
       0,  2984,   354,     0,   355,   356,   357,     0,   358,   359,
     360,   361,     0,   362,   363,     0,     0,     0,     0,     0,
       0,     0,     0,   364,   365,   366,     0,     0,   367,     0,
     368,     0,   369,   370,   371,   372,   373,   374,   375,   376,
     377,   378,     0,     0,   379,   380,   381,     0,   382,     0,
     383,   384,   385,   386,   387,     0,   388,   389,   390,     0,
       0,   391,     0,     0,     0,   392,   393,   394,   395,   396,
       0,     0,   397,   398,   399,   400,   401,     0,   402,   403,
       0,   404,   405,   406,     0,     0,   407,     0,   408,     0,
     409,   410,     0,   411,   412,     0,   413,     0,   414,     0,
       0,   415,   416,   417,   418,   419,   420,   421,   422,   423,
     424,   425,   426,     0,   427,   428,     0,     0,     0,   429,
     430,   431,   432,     0,     0,     0,   433,     0,     0,     0,
     434,     0,   435,   436,   437,   438,   439,   440,     0,   441,
     442,   443,   444,   445,   446,     0,     0,     0,     0,     0,
       0,   447,   448,     0,   449,     0,     0,   450,     0,     0,
     451,   452,     0,     0,     0,   453,     0,     0,   454,   455,
       0,   456,   457,   458,   459,   460,   461,     0,     0,   462,
     463,   464,   465,     0,   466,   467,     0,   468,     0,   469,
     470,   471,   472,     0,   139,   473,   474,     0,   475,   476,
     477,   478,     0,     0,     0,     0,     0,   479,   480,   481,
       0,     0,     0,   482,   483,   484,   485,  2985,   486,   487,
       0,   488,   489,     0,   490,   491,     0,     0,   492,     0,
       0,   493,     0,   494,     0,   495,   496,   497,     0,     0,
       0,     0,     0,     0,   498,     0,     0,   499,     0,     0,
       0,   500,   501,   502,   503,   504,   505,   506,     0,     0,
       0,     0,     0,     0,   507,   508,     0,   509,   510,   511,
       0,   142,   512,   143,   144,   145,   146,   147,   148,     0,
       0,   149,     0,     0,     0,   150,     0,     0,   151,     0,
     152,   153,   154,   155,   156,   157,   158,   159,     0,   160,
       0,     0,     0,   161,     0,     0,     0,   162,     0,     0,
     163,   164,   165,     0,   166,     0,   167,   168,     0,     0,
     169,     0,     0,   170,   171,     0,   172,   173,     0,   174,
     175,     0,   176,   177,   178,   179,   180,   181,   182,     0,
     183,   184,   185,   186,   187,   188,   189,     0,   190,   191,
     192,   193,   194,   195,   196,   197,     0,   198,   199,     0,
     200,   201,   202,   203,   204,     0,   205,     0,     0,   206,
       0,     0,   207,     0,   208,     0,     0,   209,     0,   210,
       0,     0,     0,   211,   212,   213,     0,     0,   214,     0,
       0,     0,     0,   215,   216,  1666,     0,     0,  4287,   217,
       0,   218,     0,     0,     0,   219,     0,   220,   221,   222,
     223,   224,     0,     0,     0,   225,     0,     0,   226,   227,
     228,     0,     0,     0,   229,     0,   230,   231,     0,   232,
     233,   234,     0,     0,   235,   236,     0,   237,   238,   239,
     240,   241,   242,   243,     0,     0,   244,   245,   246,   247,
       0,     0,   248,   249,     0,   250,   251,   252,  1667,     0,
     253,     0,     0,     0,   254,     0,   255,     0,   256,     0,
     257,   258,   259,   260,   261,   262,   263,     0,   264,     0,
       0,     0,   265,   266,   267,     0,   268,  2982,     0,     0,
     269,   270,     0,     0,     0,   271,   272,   273,   274,   275,
       0,     0,   276,   277,   278,     0,   279,     0,   280,     0,
       0,     0,     0,   281,   282,     0,     0,     0,   283,     0,
     284,   285,     0,   286,   287,     0,     0,     0,   288,     0,
       0,   289,   290,   291,     0,     0,   292,     0,     0,   293,
     294,     0,     0,     0,     0,     0,   295,   296,     0,   297,
       0,   298,     0,   299,   300,     0,     0,  2983,     0,     0,
       0,     0,   301,   302,   303,   304,   305,   306,   307,   308,
     309,   310,   311,   312,   313,   314,   315,   316,     0,   317,
     318,   319,   320,     0,   321,   322,   323,   324,     0,   325,
     326,     0,     0,     0,     0,   327,   328,   329,   330,   331,
     332,     0,     0,   333,   334,     0,   335,     0,   336,     0,
     337,   338,   339,   340,   341,   342,   343,   344,   345,     0,
       0,   346,   347,     0,     0,   348,   349,   350,   351,     0,
       0,     0,   352,   353,     0,     0,  2984,   354,     0,   355,
     356,   357,     0,   358,   359,   360,   361,     0,   362,   363,
       0,     0,     0,     0,     0,     0,     0,     0,   364,   365,
     366,     0,     0,   367,     0,   368,     0,   369,   370,   371,
     372,   373,   374,   375,   376,   377,   378,     0,     0,   379,
     380,   381,     0,   382,     0,   383,   384,   385,   386,   387,
       0,   388,   389,   390,     0,     0,   391,     0,     0,     0,
     392,   393,   394,   395,   396,     0,     0,   397,   398,   399,
     400,   401,     0,   402,   403,     0,   404,   405,   406,     0,
       0,   407,     0,   408,     0,   409,   410,     0,   411,   412,
       0,   413,     0,   414,     0,     0,   415,   416,   417,   418,
     419,   420,   421,   422,   423,   424,   425,   426,     0,   427,
     428,     0,     0,     0,   429,   430,   431,   432,     0,     0,
       0,   433,     0,     0,     0,   434,     0,   435,   436,   437,
     438,   439,   440,     0,   441,   442,   443,   444,   445,   446,
       0,     0,     0,     0,     0,     0,   447,   448,     0,   449,
       0,     0,   450,     0,     0,   451,   452,     0,     0,     0,
     453,     0,     0,   454,   455,     0,   456,   457,   458,   459,
     460,   461,     0,     0,   462,   463,   464,   465,     0,   466,
     467,     0,   468,     0,   469,   470,   471,   472,     0,   139,
     473,   474,     0,   475,   476,   477,   478,     0,     0,     0,
       0,     0,   479,   480,   481,     0,     0,     0,   482,   483,
     484,   485,  2985,   486,   487,     0,   488,   489,     0,   490,
     491,     0,     0,   492,     0,     0,   493,     0,   494,     0,
     495,   496,   497,     0,     0,     0,     0,     0,     0,   498,
       0,     0,   499,     0,     0,     0,   500,   501,   502,   503,
     504,   505,   506,     0,     0,     0,     0,     0,     0,   507,
     508,     0,   509,   510,   511,     0,   142,   512,   143,   144,
     145,   146,   147,   148,     0,     0,   149,     0,     0,     0,
     150,     0,     0,   151,     0,   152,   153,   154,   155,   156,
     157,   158,   159,     0,   160,     0,     0,     0,   161,     0,
       0,     0,   162,     0,     0,   163,   164,   165,     0,   166,
       0,   167,   168,     0,     0,   169,     0,     0,   170,   171,
       0,   172,   173,     0,   174,   175,     0,   176,   177,   178,
     179,   180,   181,   182,     0,   183,   184,   185,   186,   187,
     188,   189,     0,   190,   191,   192,   193,   194,   195,   196,
     197,     0,   198,   199,     0,   200,   201,   202,   203,   204,
       0,   205,     0,     0,   206,     0,     0,   207,     0,   208,
       0,     0,   209,     0,   210,     0,     0,     0,   211,   212,
     213,     0,     0,   214,     0,     0,     0,     0,   215,   216,
    1666,     0,     0,  4542,   217,     0,   218,     0,     0,     0,
     219,     0,   220,   221,   222,   223,   224,     0,     0,     0,
     225,     0,     0,   226,   227,   228,     0,     0,     0,   229,
       0,   230,   231,     0,   232,   233,   234,     0,     0,   235,
     236,     0,   237,   238,   239,   240,   241,   242,   243,     0,
       0,   244,   245,   246,   247,     0,     0,   248,   249,     0,
     250,   251,   252,  1667,     0,   253,     0,     0,     0,   254,
       0,   255,     0,   256,     0,   257,   258,   259,   260,   261,
     262,   263,     0,   264,     0,     0,     0,   265,   266,   267,
       0,   268,  2982,     0,     0,   269,   270,     0,     0,     0,
     271,   272,   273,   274,   275,     0,     0,   276,   277,   278,
       0,   279,     0,   280,     0,     0,     0,     0,   281,   282,
       0,     0,     0,   283,     0,   284,   285,     0,   286,   287,
       0,     0,     0,   288,     0,     0,   289,   290,   291,     0,
       0,   292,     0,     0,   293,   294,     0,     0,     0,     0,
       0,   295,   296,     0,   297,     0,   298,     0,   299,   300,
       0,     0,  2983,     0,     0,     0,     0,   301,   302,   303,
     304,   305,   306,   307,   308,   309,   310,   311,   312,   313,
     314,   315,   316,     0,   317,   318,   319,   320,     0,   321,
     322,   323,   324,     0,   325,   326,     0,     0,     0,     0,
     327,   328,   329,   330,   331,   332,     0,     0,   333,   334,
       0,   335,     0,   336,     0,   337,   338,   339,   340,   341,
     342,   343,   344,   345,     0,     0,   346,   347,     0,     0,
     348,   349,   350,   351,     0,     0,     0,   352,   353,     0,
       0,  2984,   354,     0,   355,   356,   357,     0,   358,   359,
     360,   361,     0,   362,   363,     0,     0,     0,     0,     0,
       0,     0,     0,   364,   365,   366,     0,     0,   367,     0,
     368,     0,   369,   370,   371,   372,   373,   374,   375,   376,
     377,   378,     0,     0,   379,   380,   381,     0,   382,     0,
     383,   384,   385,   386,   387,     0,   388,   389,   390,     0,
       0,   391,     0,     0,     0,   392,   393,   394,   395,   396,
       0,     0,   397,   398,   399,   400,   401,     0,   402,   403,
       0,   404,   405,   406,     0,     0,   407,     0,   408,     0,
     409,   410,     0,   411,   412,     0,   413,     0,   414,     0,
       0,   415,   416,   417,   418,   419,   420,   421,   422,   423,
     424,   425,   426,     0,   427,   428,     0,     0,     0,   429,
     430,   431,   432,     0,     0,     0,   433,     0,     0,     0,
     434,     0,   435,   436,   437,   438,   439,   440,     0,   441,
     442,   443,   444,   445,   446,     0,     0,     0,     0,     0,
       0,   447,   448,     0,   449,     0,     0,   450,     0,     0,
     451,   452,     0,     0,     0,   453,     0,     0,   454,   455,
       0,   456,   457,   458,   459,   460,   461,     0,     0,   462,
     463,   464,   465,     0,   466,   467,     0,   468,     0,   469,
     470,   471,   472,     0,   139,   473,   474,     0,   475,   476,
     477,   478,     0,     0,     0,     0,     0,   479,   480,   481,
       0,     0,     0,   482,   483,   484,   485,  2985,   486,   487,
       0,   488,   489,     0,   490,   491,     0,     0,   492,     0,
       0,   493,     0,   494,     0,   495,   496,   497,     0,     0,
       0,     0,     0,     0,   498,     0,     0,   499,     0,     0,
       0,   500,   501,   502,   503,   504,   505,   506,     0,     0,
       0,     0,     0,     0,   507,   508,     0,   509,   510,   511,
       0,   142,   512,   143,   144,   145,   146,   147,   148,     0,
       0,   149,     0,     0,     0,   150,     0,     0,   151,     0,
     152,   153,   154,   155,   156,   157,   158,   159,     0,   160,
       0,     0,  1423,   161,     0,     0,     0,   162,     0,     0,
     163,   164,   165,     0,   166,     0,   167,   168,     0,     0,
     169,     0,     0,   170,   171,     0,   172,   173,     0,   174,
     175,     0,   176,   177,   178,   179,   180,   181,   182,     0,
     183,   184,   185,   186,   187,   188,   189,     0,   190,   191,
     192,   193,   194,   195,   196,   197,     0,   198,   199,     0,
     200,   201,   202,   203,   204,     0,   205,     0,     0,   206,
       0,     0,   207,     0,   208,     0,     0,   209,     0,   210,
       0,     0,     0,   211,   212,   213,     0,     0,   214,     0,
       0,     0,     0,   215,   216,     0,     0,     0,  1424,   217,
       0,   218,     0,     0,     0,   219,     0,   220,   221,   222,
     223,   224,     0,     0,     0,   225,     0,     0,   226,   227,
     228,     0,     0,     0,   229,     0,   230,   231,     0,   232,
     233,   234,  1425,     0,   235,   236,     0,   237,   238,   239,
     240,   241,   242,   243,     0,     0,   244,   245,   246,   247,
       0,     0,   248,   249,     0,   250,   251,   252,     0,     0,
     253,     0,     0,     0,   254,     0,   255,     0,   256,     0,
     257,   258,   259,   260,   261,   262,   263,     0,   264,     0,
       0,     0,   265,   266,   267,     0,   268,     0,     0,     0,
     269,   270,     0,     0,     0,   271,   272,   273,   274,   275,
       0,     0,   276,   277,   278,     0,   279,     0,   280,     0,
       0,     0,     0,   281,   282,     0,     0,     0,   283,     0,
     284,   285,     0,   286,   287,     0,     0,     0,   288,     0,
       0,   289,   290,   291,     0,     0,   292,     0,     0,   293,
     294,   643,     0,     0,     0,     0,   295,   296,     0,   297,
       0,   298,     0,   299,   300,     0,     0,     0,     0,     0,
       0,     0,   301,   302,   303,   304,   305,   306,   307,   308,
     309,   310,   311,   312,   313,   314,   315,   316,     0,   317,
     318,   319,   320,     0,   321,   322,   323,   324,     0,   325,
     326,     0,     0,     0,     0,   327,   328,   329,   330,   331,
     332,     0,     0,   333,   334,     0,   335,     0,   336,     0,
     337,   338,   339,   340,   341,   342,   343,   344,   345,     0,
       0,   346,   347,     0,     0,   348,   349,   350,   351,     0,
       0,     0,   352,   353,     0,     0,     0,   354,     0,   355,
     356,   357,     0,   358,   359,   360,   361,     0,   362,   363,
       0,     0,     0,     0,     0,     0,     0,     0,   364,   365,
     366,     0,     0,   367,     0,   368,     0,   369,   370,   371,
     372,   373,   374,   375,   376,   377,   378,     0,     0,   379,
     380,   381,     0,   382,     0,   383,   384,   385,   386,   387,
       0,   388,   389,   390,     0,     0,   391,     0,     0,     0,
     392,   393,   394,   395,   396,     0,     0,   397,   398,   399,
     400,   401,     0,   402,   403,     0,   404,   405,   406,     0,
       0,   407,     0,   408,     0,   409,   410,     0,   411,   412,
       0,   413,     0,   414,     0,     0,   415,   416,   417,   418,
     419,   420,   421,   422,   423,   424,   425,   426,     0,   427,
     428,     0,     0,     0,   429,   430,   431,   432,     0,     0,
    1426,   433,     0,     0,     0,   434,     0,   435,   436,   437,
     438,   439,   440,     0,   441,   442,   443,   444,   445,   446,
       0,     0,     0,     0,     0,     0,   447,   448,     0,   449,
       0,     0,   450,     0,     0,   451,   452,     0,     0,     0,
     453,     0,     0,   454,   455,     0,   456,   457,   458,   459,
     460,   461,     0,     0,   462,   463,   464,   465,     0,   466,
     467,     0,   468,     0,   469,   470,   471,   472,     0,   139,
     473,   474,     0,   475,   476,   477,   478,     0,     0,     0,
       0,     0,   479,   480,   481,     0,     0,     0,   482,   483,
     484,   485,     0,   486,   487,     0,   488,   489,     0,   490,
     491,     0,     0,   492,     0,     0,   493,     0,   494,     0,
     495,   496,   497,     0,     0,     0,     0,     0,     0,   498,
       0,     0,   499,     0,     0,     0,   500,   501,   502,   503,
     504,   505,   506,     0,     0,     0,     0,     0,     0,   507,
     508,     0,   509,   510,   511,     0,   142,   512,   143,   144,
     145,   146,   147,   148,     0,     0,   149,     0,     0,     0,
     150,     0,     0,   151,     0,   152,   153,   154,   155,   156,
     157,   158,   159,     0,   160,     0,     0,     0,   161,     0,
       0,     0,   162,     0,     0,   163,   164,   165,     0,   166,
       0,   167,   168,     0,     0,   169,     0,     0,   170,   171,
       0,   172,   173,     0,   174,   175,     0,   176,   177,   178,
     179,   180,   181,   182,     0,   183,   184,   185,   186,   187,
     188,   189,     0,   190,   191,   192,   193,   194,   195,   196,
     197,     0,   198,   199,     0,   200,   201,   202,   203,   204,
       0,   205,     0,     0,   206,     0,     0,   207,     0,   208,
    1048,   843,   209,     0,   210,     0,     0,     0,   211,   212,
     213,     0,     0,   214,     0,     0,     0,     0,   215,   216,
       0,     0,     0,     0,   217,     0,   218,     0,     0,     0,
     219,     0,   220,   221,   222,   223,   224,     0,     0,     0,
     225,     0,     0,   226,   227,   228,     0,     0,     0,   229,
       0,   230,   231,     0,   232,   233,   234,     0,     0,   235,
     236,     0,   237,   238,   239,   240,   241,   242,   243,     0,
       0,   244,   245,   246,   247,     0,     0,   248,   249,     0,
     250,   251,   252,     0,     0,   253,     0,     0,     0,   254,
       0,   255,     0,   256,     0,   257,   258,   259,   260,   261,
     262,   263,     0,   264,     0,     0,     0,   265,   266,   267,
       0,   268,     0,     0,     0,   269,   270,     0,     0,     0,
     271,   272,   273,   274,   275,     0,     0,   276,   277,   278,
       0,   279,     0,   280,     0,     0,     0,     0,   281,   282,
       0,     0,     0,   283,     0,   284,   285,     0,   286,   287,
       0,     0,     0,   288,     0,     0,   289,   290,   291,     0,
       0,   292,     0,     0,   293,   294,   643,     0,     0,     0,
       0,   295,   296,     0,   297,     0,   298,     0,   299,   300,
       0,     0,     0,     0,     0,     0,     0,   301,   302,   303,
     304,   305,   306,   307,   308,   309,   310,   311,   312,   313,
     314,   315,   316,     0,   317,   318,   319,   320,     0,   321,
     322,   323,   324,     0,   325,   326,     0,     0,     0,     0,
     327,   328,   329,   330,   331,   332,     0,     0,   333,   334,
       0,   335,     0,   336,     0,   337,   338,   339,   340,   341,
     342,   343,   344,   345,     0,     0,   346,   347,     0,     0,
     348,   349,   350,   351,     0,     0,     0,   352,   353,     0,
       0,     0,   354,     0,   355,   356,   357,     0,   358,   359,
     360,   361,     0,   362,   363,     0,     0,     0,     0,     0,
       0,     0,     0,   364,   365,   366,     0,     0,   367,     0,
     368,     0,   369,   370,   371,   372,   373,   374,   375,   376,
     377,   378,     0,     0,   379,   380,   381,     0,   382,     0,
     383,   384,   385,   386,   387,     0,   388,   389,   390,     0,
       0,   391,     0,     0,     0,   392,   393,   394,   395,   396,
       0,     0,   397,   398,   399,   400,   401,     0,   402,   403,
       0,   404,   405,   406,     0,     0,   407,     0,   408,     0,
     409,   410,     0,   411,   412,     0,   413,     0,   414,     0,
       0,   415,   416,   417,   418,   419,   420,   421,   422,   423,
     424,   425,   426,     0,   427,   428,     0,     0,     0,   429,
     430,   431,   432,     0,     0,     0,   433,     0,     0,     0,
     434,     0,   435,   436,   437,   438,   439,   440,     0,   441,
     442,   443,   444,   445,   446,     0,     0,     0,     0,     0,
       0,   447,   448,     0,   449,     0,     0,   450,     0,     0,
     451,   452,     0,     0,     0,   453,     0,     0,   454,   455,
       0,   456,   457,   458,   459,   460,   461,     0,     0,   462,
     463,   464,   465,     0,   466,   467,     0,   468,     0,   469,
     470,   471,   472,     0,   139,   473,   474,     0,   475,   476,
     477,   478,     0,     0,     0,     0,     0,   479,   480,   481,
       0,     0,     0,   482,   483,   484,   485,     0,   486,   487,
       0,   488,   489,     0,   490,   491,     0,     0,   492,     0,
       0,   493,     0,   494,     0,   495,   496,   497,     0,     0,
       0,     0,     0,     0,   498,     0,     0,   499,     0,     0,
       0,   500,   501,   502,   503,   504,   505,   506,     0,     0,
       0,     0,     0,     0,   507,   508,     0,   509,   510,   511,
       0,   142,   512,   143,   144,   145,   146,   147,   148,     0,
       0,   149,     0,     0,     0,   150,     0,     0,   151,     0,
     152,   153,   154,   155,   156,   157,   158,   159,     0,   160,
       0,     0,  1437,   161,     0,     0,     0,   162,     0,     0,
     163,   164,   165,     0,   166,     0,   167,   168,     0,     0,
     169,     0,     0,   170,   171,     0,   172,   173,     0,   174,
     175,     0,   176,   177,   178,   179,   180,   181,   182,     0,
     183,   184,   185,   186,   187,   188,   189,     0,   190,   191,
     192,   193,   194,   195,   196,   197,     0,   198,   199,     0,
     200,   201,   202,   203,   204,     0,   205,     0,     0,   206,
       0,     0,   207,     0,   208,     0,     0,   209,     0,   210,
       0,     0,     0,   211,   212,   213,     0,     0,   214,     0,
       0,     0,     0,   215,   216,     0,     0,     0,  1438,   217,
       0,   218,     0,     0,     0,   219,     0,   220,   221,   222,
     223,   224,     0,     0,     0,   225,     0,     0,   226,   227,
     228,     0,     0,     0,   229,     0,   230,   231,     0,   232,
     233,   234,     0,     0,   235,   236,     0,   237,   238,   239,
     240,   241,   242,   243,     0,     0,   244,   245,   246,   247,
       0,     0,   248,   249,     0,   250,   251,   252,     0,     0,
     253,     0,     0,     0,   254,     0,   255,     0,   256,     0,
     257,   258,   259,   260,   261,   262,   263,     0,   264,     0,
       0,     0,   265,   266,   267,     0,   268,     0,     0,     0,
     269,   270,     0,     0,     0,   271,   272,   273,   274,   275,
       0,     0,   276,   277,   278,     0,   279,     0,   280,     0,
       0,     0,     0,   281,   282,     0,     0,     0,   283,     0,
     284,   285,     0,   286,   287,     0,     0,     0,   288,     0,
       0,   289,   290,   291,     0,     0,   292,     0,     0,   293,
     294,   643,     0,     0,     0,     0,   295,   296,     0,   297,
       0,   298,     0,   299,   300,     0,     0,     0,     0,     0,
       0,     0,   301,   302,   303,   304,   305,   306,   307,   308,
     309,   310,   311,   312,   313,   314,   315,   316,     0,   317,
     318,   319,   320,     0,   321,   322,   323,   324,     0,   325,
     326,     0,     0,     0,     0,   327,   328,   329,   330,   331,
     332,     0,     0,   333,   334,     0,   335,     0,   336,     0,
     337,   338,   339,   340,   341,   342,   343,   344,   345,     0,
       0,   346,   347,     0,     0,   348,   349,   350,   351,     0,
       0,     0,   352,   353,     0,     0,     0,   354,     0,   355,
     356,   357,     0,   358,   359,   360,   361,     0,   362,   363,
       0,     0,     0,     0,     0,     0,     0,     0,   364,   365,
     366,     0,     0,   367,     0,   368,     0,   369,   370,   371,
     372,   373,   374,   375,   376,   377,   378,     0,     0,   379,
     380,   381,     0,   382,     0,   383,   384,   385,   386,   387,
       0,   388,   389,   390,     0,     0,   391,     0,     0,     0,
     392,   393,   394,   395,   396,     0,     0,   397,   398,   399,
     400,   401,     0,   402,   403,     0,   404,   405,   406,     0,
       0,   407,     0,   408,     0,   409,   410,     0,   411,   412,
       0,   413,     0,   414,     0,     0,   415,   416,   417,   418,
     419,   420,   421,   422,   423,   424,   425,   426,     0,   427,
     428,     0,     0,     0,   429,   430,   431,   432,     0,     0,
       0,   433,     0,     0,     0,   434,     0,   435,   436,   437,
     438,   439,   440,     0,   441,   442,   443,   444,   445,   446,
       0,     0,     0,     0,     0,     0,   447,   448,     0,   449,
       0,     0,   450,     0,     0,   451,   452,     0,     0,     0,
     453,     0,     0,   454,   455,     0,   456,   457,   458,   459,
     460,   461,     0,     0,   462,   463,   464,   465,     0,   466,
     467,     0,   468,     0,   469,   470,   471,   472,     0,   139,
     473,   474,     0,   475,   476,   477,   478,     0,     0,     0,
       0,     0,   479,   480,   481,     0,     0,     0,   482,   483,
     484,   485,     0,   486,   487,     0,   488,   489,     0,   490,
     491,     0,     0,   492,     0,     0,   493,     0,   494,     0,
     495,   496,   497,     0,     0,     0,     0,     0,     0,   498,
       0,     0,   499,     0,     0,     0,   500,   501,   502,   503,
     504,   505,   506,     0,     0,     0,     0,     0,     0,   507,
     508,     0,   509,   510,   511,     0,   142,   512,   143,   144,
     145,   146,   147,   148,     0,     0,   149,     0,     0,     0,
     150,     0,     0,   151,     0,   152,   153,   154,   155,   156,
     157,   158,   159,     0,   160,     0,     0,     0,   161,  1018,
       0,     0,   162,     0,     0,   163,   164,   165,     0,   166,
       0,   167,   168,     0,     0,   169,     0,     0,   170,   171,
       0,   172,   173,     0,   174,   175,     0,   176,   177,   178,
     179,   180,   181,   182,     0,   183,   184,   185,   186,   187,
     188,   189,     0,   190,   191,   192,   193,   194,   195,   196,
     197,     0,   198,   199,     0,   200,   201,   202,   203,   204,
       0,   205,     0,     0,   206,     0,     0,   207,     0,   208,
       0,     0,   209,     0,   210,     0,     0,     0,   211,   212,
     213,     0,     0,   214,     0,     0,     0,     0,   215,   216,
       0,     0,     0,     0,   217,     0,   218,     0,     0,     0,
     219,     0,   220,   221,   222,   223,   224,     0,     0,     0,
     225,     0,     0,   226,   227,   228,     0,     0,     0,   229,
       0,   230,   231,     0,   232,   233,   234,     0,     0,   235,
     236,     0,   237,   238,   239,   240,   241,   242,   243,     0,
       0,   244,   245,   246,   247,     0,     0,   248,   249,     0,
     250,   251,   252,     0,     0,   253,     0,     0,     0,   254,
       0,   255,     0,   256,     0,   257,   258,   259,   260,   261,
     262,   263,     0,   264,     0,     0,     0,   265,   266,   267,
       0,   268,  1019,  1020,     0,   269,   270,     0,     0,     0,
     271,   272,   273,   274,   275,     0,     0,   276,   277,   278,
       0,   279,     0,   280,     0,     0,     0,     0,   281,   282,
       0,     0,     0,   283,     0,   284,   285,     0,   286,   287,
       0,     0,     0,   288,     0,     0,   289,   290,   291,     0,
       0,   292,     0,     0,   293,   294,     0,     0,     0,     0,
       0,   295,   296,     0,   297,     0,   298,     0,   299,   300,
       0,     0,     0,     0,     0,     0,     0,   301,   302,   303,
     304,   305,   306,   307,   308,   309,   310,   311,   312,   313,
     314,   315,   316,     0,   317,   318,   319,   320,     0,   321,
     322,   323,   324,     0,   325,   326,     0,     0,     0,     0,
     327,   328,   329,   330,   331,   332,     0,     0,   333,   334,
       0,   335,     0,   336,     0,   337,   338,   339,   340,   341,
     342,   343,   344,   345,     0,     0,   346,   347,     0,     0,
     348,   349,   350,   351,     0,     0,     0,   352,   353,     0,
       0,     0,   354,     0,   355,   356,   357,     0,   358,   359,
     360,   361,     0,   362,   363,     0,     0,     0,     0,     0,
       0,     0,     0,   364,   365,   366,     0,     0,   367,     0,
     368,     0,   369,   370,   371,   372,   373,   374,   375,   376,
     377,   378,     0,     0,   379,   380,   381,     0,   382,     0,
     383,   384,   385,   386,   387,     0,   388,   389,   390,     0,
       0,   391,     0,     0,     0,   392,   393,   394,   395,   396,
       0,     0,   397,   398,   399,   400,   401,     0,   402,   403,
       0,   404,   405,   406,     0,     0,   407,     0,   408,     0,
     409,   410,     0,   411,   412,     0,   413,     0,   414,     0,
       0,   415,   416,   417,   418,   419,   420,   421,   422,   423,
     424,   425,   426,     0,   427,   428,     0,     0,     0,   429,
     430,   431,   432,     0,     0,     0,   433,     0,     0,     0,
     434,     0,   435,   436,   437,   438,   439,   440,     0,   441,
     442,   443,   444,   445,   446,     0,     0,     0,     0,     0,
       0,   447,   448,     0,   449,     0,     0,   450,     0,     0,
     451,   452,     0,     0,     0,   453,     0,     0,   454,   455,
       0,   456,   457,   458,   459,   460,   461,     0,     0,   462,
     463,   464,   465,     0,   466,   467,     0,   468,     0,   469,
     470,   471,   472,     0,  1021,   473,   474,     0,   475,   476,
     477,   478,     0,     0,     0,     0,     0,   479,   480,   481,
       0,     0,     0,   482,   483,   484,   485,     0,   486,   487,
       0,   488,   489,     0,   490,   491,     0,     0,   492,     0,
       0,   493,     0,   494,     0,   495,   496,   497,     0,     0,
       0,     0,     0,     0,   498,     0,     0,   499,     0,     0,
       0,   500,   501,   502,   503,   504,   505,   506,     0,     0,
       0,     0,     0,     0,   507,   508,     0,   509,   510,   511,
       0,   142,   512,   143,   144,   145,   146,   147,   148,     0,
       0,   149,     0,     0,     0,   150,     0,     0,   151,     0,
     152,   153,   154,   155,   156,   157,   158,   159,     0,   160,
       0,     0,     0,   161,     0,     0,     0,   162,     0,     0,
     163,   164,   165,     0,   166,     0,   167,   168,     0,     0,
     169,     0,     0,   170,   171,     0,   172,   173,     0,   174,
     175,     0,   176,   177,   178,   179,   180,   181,   182,     0,
     183,   184,   185,   186,   187,   188,   189,     0,   190,   191,
     192,   193,   194,   195,   196,   197,     0,   198,   199,     0,
     200,   201,   202,   203,   204,     0,   205,     0,     0,   206,
       0,     0,   207,     0,   208,     0,     0,   209,     0,   210,
       0,     0,     0,   211,   212,   213,     0,     0,   214,     0,
       0,     0,     0,   215,   216,     0,     0,     0,     0,   217,
       0,   218,     0,     0,     0,   219,     0,   220,   221,   222,
     223,   224,     0,     0,     0,   225,     0,     0,   226,   227,
     228,     0,     0,     0,   229,     0,   230,   231,     0,   232,
     233,   234,     0,     0,   235,   236,     0,   237,   238,   239,
     240,   241,   242,   243,     0,     0,   244,   245,   246,   247,
       0,     0,   248,   249,     0,   250,   251,   252,     0,     0,
     253,     0,     0,     0,   254,     0,   255,     0,   256,     0,
     257,   258,   259,   260,   261,   262,   263,     0,   264,     0,
       0,     0,   265,   266,   267,     0,   268,     0,     0,     0,
     269,   270,     0,     0,     0,   271,   272,   273,   274,   275,
       0,     0,   276,   277,   278,     0,   279,     0,   280,     0,
       0,     0,     0,   281,   282,     0,     0,     0,   283,     0,
     284,   285,     0,   286,   287,     0,     0,     0,   288,     0,
       0,   289,   290,   291,     0,     0,   292,     0,     0,   293,
     294,     0,     0,     0,     0,     0,   295,   296,     0,   297,
       0,   298,     0,   299,   300,     0,     0,  1997,     0,     0,
       0,     0,   301,   302,   303,   304,   305,   306,   307,   308,
     309,   310,   311,   312,   313,   314,   315,   316,     0,   317,
     318,   319,   320,     0,   321,   322,   323,   324,     0,   325,
     326,     0,     0,     0,     0,   327,   328,   329,   330,   331,
     332,     0,     0,   333,   334,     0,   335,     0,   336,     0,
     337,   338,   339,   340,   341,   342,   343,   344,   345,     0,
       0,   346,   347,     0,     0,   348,   349,   350,   351,     0,
       0,     0,   352,   353,     0,     0,  1998,   354,     0,   355,
     356,   357,     0,   358,   359,   360,   361,     0,   362,   363,
       0,     0,     0,     0,     0,     0,     0,     0,   364,   365,
     366,     0,   753,   367,     0,   368,     0,   369,   370,   371,
     372,   373,   374,   375,   376,   377,   378,     0,     0,   379,
     380,   381,     0,   382,     0,   383,   384,   385,   386,   387,
       0,   388,   389,   390,     0,     0,   391,     0,     0,     0,
     392,   393,   394,   395,   396,     0,     0,   397,   398,   399,
     400,   401,     0,   402,   403,     0,   404,   405,   406,     0,
       0,   407,     0,   408,     0,   409,   410,     0,   411,   412,
       0,   413,     0,   414,     0,     0,   415,   416,   417,   418,
    1999,   420,   421,   422,   423,   424,   425,   426,     0,   427,
     428,     0,     0,     0,   429,   430,   431,   432,     0,     0,
       0,   433,     0,     0,     0,   434,     0,   435,   436,   437,
     438,   439,   440,     0,   441,   442,   443,   444,   445,   446,
       0,     0,     0,     0,     0,     0,   447,   448,     0,   449,
       0,     0,   450,     0,     0,   451,   452,     0,     0,     0,
     453,     0,     0,   454,   455,     0,   456,   457,   458,   459,
     460,   461,     0,     0,   462,   463,   464,   465,     0,   466,
     467,     0,   468,     0,   469,   470,   471,   472,     0,     0,
     473,   474,     0,   475,   476,   477,   478,     0,     0,     0,
       0,     0,   479,   480,   481,     0,     0,     0,   482,   483,
     484,   485,  2000,   486,   487,     0,   488,   489,     0,   490,
     491,     0,     0,   492,     0,     0,   493,     0,   494,     0,
     495,   496,   497,     0,     0,     0,     0,     0,     0,   498,
       0,     0,   499,     0,     0,     0,   500,   501,   502,   503,
     504,   505,   506,     0,     0,     0,     0,     0,     0,   507,
     508,     0,   509,   510,   511,     0,   142,   512,   143,   144,
     145,   146,   147,   148,     0,     0,   149,     0,     0,     0,
     150,     0,     0,   151,     0,   152,   153,   154,   155,   156,
     157,   158,   159,     0,   160,     0,     0,     0,   161,     0,
       0,     0,   162,     0,     0,   163,   164,   165,     0,   166,
       0,   167,   168,     0,     0,   169,     0,     0,   170,   171,
       0,   172,   173,     0,   174,   175,     0,   176,   177,   178,
     179,   180,   181,   182,     0,   183,   184,   185,   186,   187,
     188,   189,     0,   190,   191,   192,   193,   194,   195,   196,
     197,     0,   198,   199,     0,   200,   201,   202,   203,   204,
       0,   205,     0,     0,   206,     0,     0,   207,     0,   208,
       0,     0,   209,     0,   210,     0,     0,     0,   211,   212,
     213,     0,     0,   214,     0,     0,     0,     0,   215,   216,
       0,     0,     0,     0,   217,     0,   218,     0,     0,     0,
     219,     0,   220,   221,   222,   223,   224,     0,     0,     0,
     225,     0,     0,   226,   227,   228,     0,     0,     0,   229,
       0,   230,   231,     0,   232,   233,   234,     0,     0,   235,
     236,     0,   237,   238,   239,   240,   241,   242,   243,     0,
       0,   244,   245,   246,   247,     0,     0,   248,   249,     0,
     250,   251,   252,     0,     0,   253,     0,     0,     0,   254,
       0,   255,     0,   256,     0,   257,   258,   259,   260,   261,
     262,   263,     0,   264,     0,     0,     0,   265,   266,   267,
       0,   268,     0,     0,     0,   269,   270,     0,     0,     0,
     271,   272,   273,   274,   275,     0,     0,   276,   277,   278,
       0,   279,     0,   280,     0,     0,     0,     0,   281,   282,
       0,     0,     0,   283,     0,   284,   285,     0,   286,   287,
       0,     0,     0,   288,     0,     0,   289,   290,   291,     0,
       0,   292,     0,     0,   293,   294,     0,     0,     0,     0,
       0,   295,   296,     0,   297,     0,   298,     0,   299,   300,
       0,     0,  1997,     0,     0,     0,     0,   301,   302,   303,
     304,   305,   306,   307,   308,   309,   310,   311,   312,   313,
     314,   315,   316,     0,   317,   318,   319,   320,     0,   321,
     322,   323,   324,     0,   325,   326,     0,     0,     0,     0,
     327,   328,   329,   330,   331,   332,     0,     0,   333,   334,
       0,   335,     0,   336,     0,   337,   338,   339,   340,   341,
     342,   343,   344,   345,     0,     0,   346,   347,     0,     0,
     348,   349,   350,   351,     0,     0,     0,   352,   353,     0,
       0,  1998,   354,     0,   355,   356,   357,     0,   358,   359,
     360,   361,     0,   362,   363,     0,     0,     0,     0,     0,
       0,     0,     0,   364,   365,   366,     0,   753,   367,     0,
     368,     0,   369,   370,   371,   372,   373,   374,   375,   376,
     377,   378,     0,     0,   379,   380,   381,     0,   382,     0,
     383,   384,   385,   386,   387,     0,   388,   389,   390,     0,
       0,   391,     0,     0,     0,   392,   393,   394,   395,   396,
       0,     0,   397,   398,   399,   400,   401,     0,   402,   403,
       0,   404,   405,   406,     0,     0,   407,     0,   408,     0,
     409,   410,     0,   411,   412,     0,   413,     0,   414,     0,
       0,   415,   416,   417,   418,   419,   420,   421,   422,   423,
     424,   425,   426,     0,   427,   428,     0,     0,     0,   429,
     430,   431,   432,     0,     0,     0,   433,     0,     0,     0,
     434,     0,   435,   436,   437,   438,   439,   440,     0,   441,
     442,   443,   444,   445,   446,     0,     0,     0,     0,     0,
       0,   447,   448,     0,   449,     0,     0,   450,     0,     0,
     451,   452,     0,     0,     0,   453,     0,     0,   454,   455,
       0,   456,   457,   458,   459,   460,   461,     0,     0,   462,
     463,   464,   465,     0,   466,   467,     0,   468,     0,   469,
     470,   471,   472,     0,     0,   473,   474,     0,   475,   476,
     477,   478,     0,     0,     0,     0,     0,   479,   480,   481,
       0,     0,     0,   482,   483,   484,   485,  2000,   486,   487,
       0,   488,   489,     0,   490,   491,     0,     0,   492,     0,
       0,   493,     0,   494,     0,   495,   496,   497,     0,     0,
       0,     0,     0,     0,   498,     0,     0,   499,     0,     0,
       0,   500,   501,   502,   503,   504,   505,   506,     0,     0,
       0,     0,     0,     0,   507,   508,     0,   509,   510,   511,
       0,   142,   512,   143,   144,   145,   146,   147,   148,     0,
       0,   149,     0,     0,     0,   150,     0,     0,   151,     0,
     152,   153,   154,   155,   156,   157,   158,   159,     0,   160,
       0,     0,  1423,   161,     0,     0,     0,   162,     0,     0,
     163,   164,   165,     0,   166,     0,   167,   168,     0,     0,
     169,     0,     0,   170,   171,     0,   172,   173,     0,   174,
     175,     0,   176,   177,   178,   179,   180,   181,   182,     0,
     183,   184,   185,   186,   187,   188,   189,     0,   190,   191,
     192,   193,   194,   195,   196,   197,     0,   198,   199,     0,
     200,   201,   202,   203,   204,     0,   205,     0,     0,   206,
       0,     0,   207,     0,   208,     0,     0,   209,     0,   210,
       0,     0,     0,   211,   212,   213,     0,     0,   214,     0,
       0,     0,     0,   215,   216,     0,     0,     0,  1424,   217,
       0,   218,     0,     0,     0,   219,     0,   220,   221,   222,
     223,   224,     0,     0,     0,   225,     0,     0,   226,   227,
     228,     0,     0,     0,   229,     0,   230,   231,     0,   232,
     233,   234,     0,     0,   235,   236,     0,   237,   238,   239,
     240,   241,   242,   243,     0,     0,   244,   245,   246,   247,
       0,     0,   248,   249,     0,   250,   251,   252,     0,     0,
     253,     0,     0,     0,   254,     0,   255,     0,   256,     0,
     257,   258,   259,   260,   261,   262,   263,     0,   264,     0,
       0,     0,   265,   266,   267,     0,   268,     0,     0,     0,
     269,   270,     0,     0,     0,   271,   272,   273,   274,   275,
       0,     0,   276,   277,   278,     0,   279,     0,   280,     0,
       0,     0,     0,   281,   282,     0,     0,     0,   283,     0,
     284,   285,     0,   286,   287,     0,     0,     0,   288,     0,
       0,   289,   290,   291,     0,     0,   292,     0,     0,   293,
     294,   643,     0,     0,     0,     0,   295,   296,     0,   297,
       0,   298,     0,   299,   300,     0,     0,     0,     0,     0,
       0,     0,   301,   302,   303,   304,   305,   306,   307,   308,
     309,   310,   311,   312,   313,   314,   315,   316,     0,   317,
     318,   319,   320,     0,   321,   322,   323,   324,     0,   325,
     326,     0,     0,     0,     0,   327,   328,   329,   330,   331,
     332,     0,     0,   333,   334,     0,   335,     0,   336,     0,
     337,   338,   339,   340,   341,   342,   343,   344,   345,     0,
       0,   346,   347,     0,     0,   348,   349,   350,   351,     0,
       0,     0,   352,   353,     0,     0,     0,   354,     0,   355,
     356,   357,     0,   358,   359,   360,   361,     0,   362,   363,
       0,     0,     0,     0,     0,     0,     0,     0,   364,   365,
     366,     0,     0,   367,     0,   368,     0,   369,   370,   371,
     372,   373,   374,   375,   376,   377,   378,     0,     0,   379,
     380,   381,     0,   382,     0,   383,   384,   385,   386,   387,
       0,   388,   389,   390,     0,     0,   391,     0,     0,     0,
     392,   393,   394,   395,   396,     0,     0,   397,   398,   399,
     400,   401,     0,   402,   403,     0,   404,   405,   406,     0,
       0,   407,     0,   408,     0,   409,   410,     0,   411,   412,
       0,   413,     0,   414,     0,     0,   415,   416,   417,   418,
     419,   420,   421,   422,   423,   424,   425,   426,     0,   427,
     428,     0,     0,     0,   429,   430,   431,   432,     0,     0,
       0,   433,     0,     0,     0,   434,     0,   435,   436,   437,
     438,   439,   440,     0,   441,   442,   443,   444,   445,   446,
       0,     0,     0,     0,     0,     0,   447,   448,     0,   449,
       0,     0,   450,     0,     0,   451,   452,     0,     0,     0,
     453,     0,     0,   454,   455,     0,   456,   457,   458,   459,
     460,   461,     0,     0,   462,   463,   464,   465,     0,   466,
     467,     0,   468,     0,   469,   470,   471,   472,     0,   139,
     473,   474,     0,   475,   476,   477,   478,     0,     0,     0,
       0,     0,   479,   480,   481,     0,     0,     0,   482,   483,
     484,   485,     0,   486,   487,     0,   488,   489,     0,   490,
     491,     0,     0,   492,     0,     0,   493,     0,   494,     0,
     495,   496,   497,     0,     0,     0,     0,     0,     0,   498,
       0,     0,   499,     0,     0,     0,   500,   501,   502,   503,
     504,   505,   506,     0,     0,     0,     0,     0,     0,   507,
     508,     0,   509,   510,   511,     0,   142,   512,   143,   144,
     145,   146,   147,   148,     0,     0,   149,     0,     0,     0,
     150,     0,     0,   151,     0,   152,   153,   154,   155,   156,
     157,   158,   159,     0,   160,     0,     0,     0,   161,     0,
       0,     0,   162,     0,     0,   163,   164,   165,     0,   166,
       0,   167,   168,     0,     0,   169,     0,     0,   170,   171,
       0,   172,   173,     0,   174,   175,     0,   176,   177,   178,
     179,   180,   181,   182,     0,   183,   184,   185,   186,   187,
     188,   189,     0,   190,   191,   192,   193,   194,   195,   196,
     197,     0,   198,   199,     0,   200,   201,   202,   203,   204,
       0,   205,     0,     0,   206,     0,     0,   207,     0,   208,
       0,     0,   209,     0,   210,     0,     0,     0,   211,   212,
     213,     0,     0,   214,     0,     0,     0,     0,   215,   216,
       0,     0,     0,     0,   217,     0,   218,     0,     0,     0,
     219,     0,   220,   221,   222,   223,   224,     0,     0,     0,
     225,     0,     0,   226,   227,   228,     0,     0,     0,   229,
       0,   230,   231,     0,   232,   233,   234,     0,     0,   235,
     236,     0,   237,   238,   239,   240,   241,   242,   243,     0,
       0,   244,   245,   246,   247,     0,     0,   248,   249,     0,
     250,   251,   252,     0,     0,   253,     0,     0,     0,   254,
       0,   255,     0,   256,     0,   257,   258,   259,   260,   261,
     262,   263,     0,   264,     0,     0,     0,   265,   266,   267,
       0,   268,     0,     0,     0,   269,   270,     0,     0,     0,
     271,   272,   273,   274,   275,     0,     0,   276,   277,   278,
       0,   279,     0,   280,     0,     0,     0,     0,   281,   282,
       0,     0,     0,   283,     0,   284,   285,     0,   286,   287,
       0,     0,     0,   288,     0,     0,   289,   290,   291,     0,
       0,   292,     0,     0,   293,   294,     0,     0,     0,     0,
       0,   295,   296,     0,   297,     0,   298,     0,   299,   300,
       0,     0,  1997,     0,     0,     0,     0,   301,   302,   303,
     304,   305,   306,   307,   308,   309,   310,   311,   312,   313,
     314,   315,   316,     0,   317,   318,   319,   320,     0,   321,
     322,   323,   324,     0,   325,   326,     0,     0,     0,     0,
     327,   328,   329,   330,   331,   332,     0,     0,   333,   334,
       0,   335,     0,   336,     0,   337,   338,   339,   340,   341,
     342,   343,   344,   345,     0,     0,   346,   347,     0,     0,
     348,   349,   350,   351,     0,     0,     0,   352,   353,     0,
       0,  1998,   354,     0,   355,   356,   357,     0,   358,   359,
     360,   361,     0,   362,   363,     0,     0,     0,     0,     0,
       0,     0,     0,   364,   365,   366,     0,   753,   367,     0,
     368,     0,   369,   370,   371,   372,   373,   374,   375,   376,
     377,   378,     0,     0,   379,   380,   381,     0,   382,     0,
     383,   384,   385,   386,   387,     0,   388,   389,   390,     0,
       0,   391,     0,     0,     0,   392,   393,   394,   395,   396,
       0,     0,   397,   398,   399,   400,   401,     0,   402,   403,
       0,   404,   405,   406,     0,     0,   407,     0,   408,     0,
     409,   410,     0,   411,   412,     0,   413,     0,   414,     0,
       0,   415,   416,   417,   418,  4007,   420,   421,   422,   423,
     424,   425,   426,     0,   427,   428,     0,     0,     0,   429,
     430,   431,   432,     0,     0,     0,   433,     0,     0,     0,
     434,     0,   435,   436,   437,   438,   439,   440,     0,   441,
     442,   443,   444,   445,   446,     0,     0,     0,     0,     0,
       0,   447,   448,     0,   449,     0,     0,   450,     0,     0,
     451,   452,     0,     0,     0,   453,     0,     0,   454,   455,
       0,   456,   457,   458,   459,   460,   461,     0,     0,   462,
     463,   464,   465,     0,   466,   467,     0,   468,     0,   469,
     470,   471,   472,     0,     0,   473,   474,     0,   475,   476,
     477,   478,     0,     0,     0,     0,     0,   479,   480,   481,
       0,     0,     0,   482,   483,   484,   485,  2000,   486,   487,
       0,   488,   489,     0,   490,   491,     0,     0,   492,     0,
       0,   493,     0,   494,     0,   495,   496,   497,     0,     0,
       0,     0,     0,     0,   498,     0,     0,   499,     0,     0,
       0,   500,   501,   502,   503,   504,   505,   506,     0,     0,
       0,     0,     0,     0,   507,   508,     0,   509,   510,   511,
       0,   142,   512,   143,   144,   145,   146,   147,   148,     0,
       0,   149,     0,     0,     0,   150,     0,     0,   151,     0,
     152,   153,   154,   155,   156,   157,   158,   159,     0,   160,
       0,     0,     0,   161,     0,     0,     0,   162,     0,     0,
     163,   164,   165,     0,   166,     0,   167,   168,     0,     0,
     169,     0,     0,   170,   171,     0,   172,   173,     0,   174,
     175,     0,   176,   177,   178,   179,   180,   181,   182,     0,
     183,   184,   185,   186,   187,   188,   189,     0,   190,   191,
     192,   193,   194,   195,   196,   197,     0,   198,   199,     0,
     200,   201,   202,   203,   204,     0,   205,     0,     0,   206,
       0,     0,   207,     0,   208,     0,   843,   209,     0,   210,
       0,     0,     0,   211,   212,   213,     0,     0,   214,     0,
       0,     0,     0,   215,   216,     0,     0,     0,     0,   217,
       0,   218,     0,     0,     0,   219,     0,   220,   221,   222,
     223,   224,     0,     0,     0,   225,     0,     0,   226,   227,
     228,     0,     0,     0,   229,     0,   230,   231,     0,   232,
     233,   234,     0,     0,   235,   236,     0,   237,   238,   239,
     240,   241,   242,   243,     0,     0,   244,   245,   246,   247,
       0,     0,   248,   249,     0,   250,   251,   252,     0,     0,
     253,     0,     0,     0,   254,     0,   255,     0,   256,     0,
     257,   258,   259,   260,   261,   262,   263,     0,   264,     0,
       0,     0,   265,   266,   267,     0,   268,     0,     0,     0,
     269,   270,     0,     0,     0,   271,   272,   273,   274,   275,
       0,     0,   276,   277,   278,     0,   279,     0,   280,     0,
       0,     0,     0,   281,   282,     0,     0,     0,   283,     0,
     284,   285,     0,   286,   287,     0,     0,     0,   288,     0,
       0,   289,   290,   291,     0,     0,   292,     0,     0,   293,
     294,   643,     0,     0,     0,     0,   295,   296,     0,   297,
       0,   298,     0,   299,   300,     0,     0,     0,     0,     0,
       0,     0,   301,   302,   303,   304,   305,   306,   307,   308,
     309,   310,   311,   312,   313,   314,   315,   316,     0,   317,
     318,   319,   320,     0,   321,   322,   323,   324,     0,   325,
     326,     0,     0,     0,     0,   327,   328,   329,   330,   331,
     332,     0,     0,   333,   334,     0,   335,     0,   336,     0,
     337,   338,   339,   340,   341,   342,   343,   344,   345,     0,
       0,   346,   347,     0,     0,   348,   349,   350,   351,     0,
       0,     0,   352,   353,     0,     0,     0,   354,     0,   355,
     356,   357,     0,   358,   359,   360,   361,     0,   362,   363,
       0,     0,     0,     0,     0,     0,     0,     0,   364,   365,
     366,     0,     0,   367,     0,   368,     0,   369,   370,   371,
     372,   373,   374,   375,   376,   377,   378,     0,     0,   379,
     380,   381,     0,   382,     0,   383,   384,   385,   386,   387,
       0,   388,   389,   390,     0,     0,   391,     0,     0,     0,
     392,   393,   394,   395,   396,     0,     0,   397,   398,   399,
     400,   401,     0,   402,   403,     0,   404,   405,   406,     0,
       0,   407,     0,   408,     0,   409,   410,     0,   411,   412,
       0,   413,     0,   414,     0,     0,   415,   416,   417,   418,
     419,   420,   421,   422,   423,   424,   425,   426,     0,   427,
     428,     0,     0,     0,   429,   430,   431,   432,     0,     0,
       0,   433,     0,     0,     0,   434,     0,   435,   436,   437,
     438,   439,   440,     0,   441,   442,   443,   444,   445,   446,
       0,     0,     0,     0,     0,     0,   447,   448,     0,   449,
       0,     0,   450,     0,     0,   451,   452,     0,     0,     0,
     453,     0,     0,   454,   455,     0,   456,   457,   458,   459,
     460,   461,     0,     0,   462,   463,   464,   465,     0,   466,
     467,     0,   468,     0,   469,   470,   471,   472,     0,   139,
     473,   474,     0,   475,   476,   477,   478,     0,     0,     0,
       0,     0,   479,   480,   481,     0,     0,     0,   482,   483,
     484,   485,     0,   486,   487,     0,   488,   489,     0,   490,
     491,     0,     0,   492,     0,     0,   493,     0,   494,     0,
     495,   496,   497,     0,     0,     0,     0,     0,     0,   498,
       0,     0,   499,     0,     0,     0,   500,   501,   502,   503,
     504,   505,   506,     0,     0,     0,     0,     0,     0,   507,
     508,     0,   509,   510,   511,     0,   142,   512,   143,   144,
     145,   146,   147,   148,     0,     0,   149,     0,     0,     0,
     150,     0,     0,   151,     0,   152,   153,   154,   155,   156,
     157,   158,   159,     0,   160,     0,     0,     0,   161,     0,
       0,     0,   162,     0,     0,   163,   164,   165,     0,   166,
       0,   167,   168,     0,     0,   169,     0,     0,   170,   171,
       0,   172,   173,     0,   174,   175,     0,   176,   177,   178,
     179,   180,   181,   182,     0,   183,   184,   185,   186,   187,
     188,   189,     0,   190,   191,   192,   193,   194,   195,   196,
     197,     0,   198,   199,     0,   200,   201,   202,   203,   204,
       0,   205,     0,     0,   206,     0,     0,   207,     0,   208,
    1048,     0,   209,     0,   210,     0,     0,     0,   211,   212,
     213,     0,     0,   214,     0,     0,     0,     0,   215,   216,
       0,     0,     0,     0,   217,     0,   218,     0,     0,     0,
     219,     0,   220,   221,   222,   223,   224,     0,     0,     0,
     225,     0,     0,   226,   227,   228,     0,     0,     0,   229,
       0,   230,   231,     0,   232,   233,   234,     0,     0,   235,
     236,     0,   237,   238,   239,   240,   241,   242,   243,     0,
       0,   244,   245,   246,   247,     0,     0,   248,   249,     0,
     250,   251,   252,     0,     0,   253,     0,     0,     0,   254,
       0,   255,     0,   256,     0,   257,   258,   259,   260,   261,
     262,   263,     0,   264,     0,     0,     0,   265,   266,   267,
       0,   268,     0,     0,     0,   269,   270,     0,     0,     0,
     271,   272,   273,   274,   275,     0,     0,   276,   277,   278,
       0,   279,     0,   280,     0,     0,     0,     0,   281,   282,
       0,     0,     0,   283,     0,   284,   285,     0,   286,   287,
       0,     0,     0,   288,     0,     0,   289,   290,   291,     0,
       0,   292,     0,     0,   293,   294,   643,     0,     0,     0,
       0,   295,   296,     0,   297,     0,   298,     0,   299,   300,
       0,     0,     0,     0,     0,     0,     0,   301,   302,   303,
     304,   305,   306,   307,   308,   309,   310,   311,   312,   313,
     314,   315,   316,     0,   317,   318,   319,   320,     0,   321,
     322,   323,   324,     0,   325,   326,     0,     0,     0,     0,
     327,   328,   329,   330,   331,   332,     0,     0,   333,   334,
       0,   335,     0,   336,     0,   337,   338,   339,   340,   341,
     342,   343,   344,   345,     0,     0,   346,   347,     0,     0,
     348,   349,   350,   351,     0,     0,     0,   352,   353,     0,
       0,     0,   354,     0,   355,   356,   357,     0,   358,   359,
     360,   361,     0,   362,   363,     0,     0,     0,     0,     0,
       0,     0,     0,   364,   365,   366,     0,     0,   367,     0,
     368,     0,   369,   370,   371,   372,   373,   374,   375,   376,
     377,   378,     0,     0,   379,   380,   381,     0,   382,     0,
     383,   384,   385,   386,   387,     0,   388,   389,   390,     0,
       0,   391,     0,     0,     0,   392,   393,   394,   395,   396,
       0,     0,   397,   398,   399,   400,   401,     0,   402,   403,
       0,   404,   405,   406,     0,     0,   407,     0,   408,     0,
     409,   410,     0,   411,   412,     0,   413,     0,   414,     0,
       0,   415,   416,   417,   418,   419,   420,   421,   422,   423,
     424,   425,   426,     0,   427,   428,     0,     0,     0,   429,
     430,   431,   432,     0,     0,     0,   433,     0,     0,     0,
     434,     0,   435,   436,   437,   438,   439,   440,     0,   441,
     442,   443,   444,   445,   446,     0,     0,     0,     0,     0,
       0,   447,   448,     0,   449,     0,     0,   450,     0,     0,
     451,   452,     0,     0,     0,   453,     0,     0,   454,   455,
       0,   456,   457,   458,   459,   460,   461,     0,     0,   462,
     463,   464,   465,     0,   466,   467,     0,   468,     0,   469,
     470,   471,   472,     0,   139,   473,   474,     0,   475,   476,
     477,   478,     0,     0,     0,     0,     0,   479,   480,   481,
       0,     0,     0,   482,   483,   484,   485,     0,   486,   487,
       0,   488,   489,     0,   490,   491,     0,     0,   492,     0,
       0,   493,     0,   494,     0,   495,   496,   497,     0,     0,
       0,     0,     0,     0,   498,     0,     0,   499,     0,     0,
       0,   500,   501,   502,   503,   504,   505,   506,     0,     0,
       0,     0,     0,     0,   507,   508,     0,   509,   510,   511,
       0,   142,   512,   143,   144,   145,   146,   147,   148,  1460,
       0,   149,     0,     0,     0,   150,     0,     0,   151,     0,
     152,   153,   154,   155,   156,   157,   158,   159,     0,   160,
       0,     0,     0,   161,     0,     0,     0,   162,     0,     0,
     163,   164,   165,     0,   166,     0,   167,   168,     0,     0,
     169,     0,     0,   170,   171,     0,   172,   173,     0,   174,
     175,     0,   176,   177,   178,   179,   180,   181,   182,     0,
     183,   184,   185,   186,   187,   188,   189,     0,   190,   191,
     192,   193,   194,   195,   196,   197,     0,   198,   199,     0,
     200,   201,   202,   203,   204,     0,   205,     0,     0,   206,
       0,     0,   207,     0,   208,     0,     0,   209,     0,   210,
       0,     0,     0,   211,   212,   213,     0,     0,   214,     0,
       0,     0,     0,   215,   216,     0,     0,     0,     0,   217,
       0,   218,     0,     0,     0,   219,     0,   220,   221,   222,
     223,   224,     0,     0,     0,   225,     0,     0,   226,   227,
     228,     0,     0,     0,   229,     0,   230,   231,     0,   232,
     233,   234,     0,     0,   235,   236,     0,   237,   238,   239,
     240,   241,   242,   243,     0,     0,   244,   245,   246,   247,
       0,     0,   248,   249,     0,   250,   251,   252,     0,     0,
     253,     0,     0,     0,   254,     0,   255,     0,   256,     0,
     257,   258,   259,   260,   261,   262,   263,     0,   264,     0,
       0,     0,   265,   266,   267,     0,   268,     0,     0,     0,
     269,   270,     0,     0,     0,   271,   272,   273,   274,   275,
       0,     0,   276,   277,   278,     0,   279,     0,   280,     0,
       0,     0,     0,   281,   282,     0,     0,     0,   283,     0,
     284,   285,     0,   286,   287,     0,     0,     0,   288,     0,
       0,   289,   290,   291,     0,     0,   292,     0,     0,   293,
     294,   643,     0,     0,     0,     0,   295,   296,     0,   297,
       0,   298,     0,   299,   300,     0,     0,     0,     0,     0,
       0,     0,   301,   302,   303,   304,   305,   306,   307,   308,
     309,   310,   311,   312,   313,   314,   315,   316,     0,   317,
     318,   319,   320,     0,   321,   322,   323,   324,     0,   325,
     326,     0,     0,     0,     0,   327,   328,   329,   330,   331,
     332,     0,     0,   333,   334,     0,   335,     0,   336,     0,
     337,   338,   339,   340,   341,   342,   343,   344,   345,     0,
       0,   346,   347,     0,     0,   348,   349,   350,   351,     0,
       0,     0,   352,   353,     0,     0,     0,   354,     0,   355,
     356,   357,     0,   358,   359,   360,   361,     0,   362,   363,
       0,     0,     0,     0,     0,     0,     0,     0,   364,   365,
     366,     0,     0,   367,     0,   368,     0,   369,   370,   371,
     372,   373,   374,   375,   376,   377,   378,     0,     0,   379,
     380,   381,     0,   382,     0,   383,   384,   385,   386,   387,
       0,   388,   389,   390,     0,     0,   391,     0,     0,     0,
     392,   393,   394,   395,   396,     0,     0,   397,   398,   399,
     400,   401,     0,   402,   403,     0,   404,   405,   406,     0,
       0,   407,     0,   408,     0,   409,   410,     0,   411,   412,
       0,   413,     0,   414,     0,     0,   415,   416,   417,   418,
     419,   420,   421,   422,   423,   424,   425,   426,     0,   427,
     428,     0,     0,     0,   429,   430,   431,   432,     0,     0,
       0,   433,     0,     0,     0,   434,     0,   435,   436,   437,
     438,   439,   440,     0,   441,   442,   443,   444,   445,   446,
       0,     0,     0,     0,     0,     0,   447,   448,     0,   449,
       0,     0,   450,     0,     0,   451,   452,     0,     0,     0,
     453,     0,     0,   454,   455,     0,   456,   457,   458,   459,
     460,   461,     0,     0,   462,   463,   464,   465,     0,   466,
     467,     0,   468,     0,   469,   470,   471,   472,     0,   139,
     473,   474,     0,   475,   476,   477,   478,     0,     0,     0,
       0,     0,   479,   480,   481,     0,     0,     0,   482,   483,
     484,   485,     0,   486,   487,     0,   488,   489,     0,   490,
     491,     0,     0,   492,     0,     0,   493,     0,   494,     0,
     495,   496,   497,     0,     0,     0,     0,     0,     0,   498,
       0,     0,   499,     0,     0,     0,   500,   501,   502,   503,
     504,   505,   506,     0,     0,     0,     0,     0,     0,   507,
     508,     0,   509,   510,   511,     0,   142,   512,   143,   144,
     145,   146,   147,   148,     0,     0,   149,     0,     0,     0,
     150,     0,     0,   151,     0,   152,   153,   154,   155,   156,
     157,   158,   159,     0,   160,     0,     0,     0,   161,     0,
       0,     0,   162,     0,     0,   163,   164,   165,     0,   166,
       0,   167,   168,     0,     0,   169,     0,     0,   170,   171,
       0,   172,   173,     0,   174,   175,     0,   176,   177,   178,
     179,   180,   181,   182,     0,   183,   184,   185,   186,   187,
     188,   189,     0,   190,   191,   192,   193,   194,   195,   196,
     197,     0,   198,   199,     0,   200,   201,   202,   203,   204,
       0,   205,     0,     0,   206,     0,     0,   207,     0,   208,
       0,     0,   209,     0,   210,     0,     0,     0,   211,   212,
     213,     0,     0,   214,     0,     0,     0,     0,   215,   216,
       0,     0,     0,  2461,   217,     0,   218,     0,     0,     0,
     219,     0,   220,   221,   222,   223,   224,     0,     0,     0,
     225,     0,     0,   226,   227,   228,     0,     0,     0,   229,
       0,   230,   231,     0,   232,   233,   234,     0,     0,   235,
     236,     0,   237,   238,   239,   240,   241,   242,   243,     0,
       0,   244,   245,   246,   247,     0,     0,   248,   249,     0,
     250,   251,   252,     0,     0,   253,     0,     0,     0,   254,
       0,   255,     0,   256,     0,   257,   258,   259,   260,   261,
     262,   263,     0,   264,     0,     0,     0,   265,   266,   267,
       0,   268,     0,     0,     0,   269,   270,     0,     0,     0,
     271,   272,   273,   274,   275,     0,     0,   276,   277,   278,
       0,   279,     0,   280,     0,     0,     0,     0,   281,   282,
       0,     0,     0,   283,     0,   284,   285,     0,   286,   287,
       0,     0,     0,   288,     0,     0,   289,   290,   291,     0,
       0,   292,     0,     0,   293,   294,   643,     0,     0,     0,
       0,   295,   296,     0,   297,     0,   298,     0,   299,   300,
       0,     0,     0,     0,     0,     0,     0,   301,   302,   303,
     304,   305,   306,   307,   308,   309,   310,   311,   312,   313,
     314,   315,   316,     0,   317,   318,   319,   320,     0,   321,
     322,   323,   324,     0,   325,   326,     0,     0,     0,     0,
     327,   328,   329,   330,   331,   332,     0,     0,   333,   334,
       0,   335,     0,   336,     0,   337,   338,   339,   340,   341,
     342,   343,   344,   345,     0,     0,   346,   347,     0,     0,
     348,   349,   350,   351,     0,     0,     0,   352,   353,     0,
       0,     0,   354,     0,   355,   356,   357,     0,   358,   359,
     360,   361,     0,   362,   363,     0,     0,     0,     0,     0,
       0,     0,     0,   364,   365,   366,     0,     0,   367,     0,
     368,     0,   369,   370,   371,   372,   373,   374,   375,   376,
     377,   378,     0,     0,   379,   380,   381,     0,   382,     0,
     383,   384,   385,   386,   387,     0,   388,   389,   390,     0,
       0,   391,     0,     0,     0,   392,   393,   394,   395,   396,
       0,     0,   397,   398,   399,   400,   401,     0,   402,   403,
       0,   404,   405,   406,     0,     0,   407,     0,   408,     0,
     409,   410,     0,   411,   412,     0,   413,     0,   414,     0,
       0,   415,   416,   417,   418,   419,   420,   421,   422,   423,
     424,   425,   426,     0,   427,   428,     0,     0,     0,   429,
     430,   431,   432,     0,     0,     0,   433,     0,     0,     0,
     434,     0,   435,   436,   437,   438,   439,   440,     0,   441,
     442,   443,   444,   445,   446,     0,     0,     0,     0,     0,
       0,   447,   448,     0,   449,     0,     0,   450,     0,     0,
     451,   452,     0,     0,     0,   453,     0,     0,   454,   455,
       0,   456,   457,   458,   459,   460,   461,     0,     0,   462,
     463,   464,   465,     0,   466,   467,     0,   468,     0,   469,
     470,   471,   472,     0,   139,   473,   474,     0,   475,   476,
     477,   478,     0,     0,     0,     0,     0,   479,   480,   481,
       0,     0,     0,   482,   483,   484,   485,     0,   486,   487,
       0,   488,   489,     0,   490,   491,     0,     0,   492,     0,
       0,   493,     0,   494,     0,   495,   496,   497,     0,     0,
       0,     0,     0,     0,   498,     0,     0,   499,     0,     0,
       0,   500,   501,   502,   503,   504,   505,   506,     0,     0,
       0,     0,     0,     0,   507,   508,     0,   509,   510,   511,
       0,   142,   512,   143,   144,   145,   146,   147,   148,     0,
       0,   149,     0,     0,     0,   150,     0,     0,   151,     0,
     152,   153,   154,   155,   156,   157,   158,   159,     0,   160,
       0,     0,  1423,   161,     0,     0,     0,   162,     0,     0,
     163,   164,   165,     0,   166,     0,   167,   168,     0,     0,
     169,     0,     0,   170,   171,     0,   172,   173,     0,   174,
     175,     0,   176,   177,   178,   179,   180,   181,   182,     0,
     183,   184,   185,   186,   187,   188,   189,     0,   190,   191,
     192,   193,   194,   195,   196,   197,     0,   198,   199,     0,
     200,   201,   202,   203,   204,     0,   205,     0,     0,   206,
       0,     0,   207,     0,   208,     0,     0,   209,     0,   210,
       0,     0,     0,   211,   212,   213,     0,     0,   214,     0,
       0,     0,     0,   215,   216,     0,     0,     0,     0,   217,
       0,   218,     0,     0,     0,   219,     0,   220,   221,   222,
     223,   224,     0,     0,     0,   225,     0,     0,   226,   227,
     228,     0,     0,     0,   229,     0,   230,   231,     0,   232,
     233,   234,     0,     0,   235,   236,     0,   237,   238,   239,
     240,   241,   242,   243,     0,     0,   244,   245,   246,   247,
       0,     0,   248,   249,     0,   250,   251,   252,     0,     0,
     253,     0,     0,     0,   254,     0,   255,     0,   256,     0,
     257,   258,   259,   260,   261,   262,   263,     0,   264,     0,
       0,     0,   265,   266,   267,     0,   268,     0,     0,     0,
     269,   270,     0,     0,     0,   271,   272,   273,   274,   275,
       0,     0,   276,   277,   278,     0,   279,     0,   280,     0,
       0,     0,     0,   281,   282,     0,     0,     0,   283,     0,
     284,   285,     0,   286,   287,     0,     0,     0,   288,     0,
       0,   289,   290,   291,     0,     0,   292,     0,     0,   293,
     294,   643,     0,     0,     0,     0,   295,   296,     0,   297,
       0,   298,     0,   299,   300,     0,     0,     0,     0,     0,
       0,     0,   301,   302,   303,   304,   305,   306,   307,   308,
     309,   310,   311,   312,   313,   314,   315,   316,     0,   317,
     318,   319,   320,     0,   321,   322,   323,   324,     0,   325,
     326,     0,     0,     0,     0,   327,   328,   329,   330,   331,
     332,     0,     0,   333,   334,     0,   335,     0,   336,     0,
     337,   338,   339,   340,   341,   342,   343,   344,   345,     0,
       0,   346,   347,     0,     0,   348,   349,   350,   351,     0,
       0,     0,   352,   353,     0,     0,     0,   354,     0,   355,
     356,   357,     0,   358,   359,   360,   361,     0,   362,   363,
       0,     0,     0,     0,     0,     0,     0,     0,   364,   365,
     366,     0,     0,   367,     0,   368,     0,   369,   370,   371,
     372,   373,   374,   375,   376,   377,   378,     0,     0,   379,
     380,   381,     0,   382,     0,   383,   384,   385,   386,   387,
       0,   388,   389,   390,     0,     0,   391,     0,     0,     0,
     392,   393,   394,   395,   396,     0,     0,   397,   398,   399,
     400,   401,     0,   402,   403,     0,   404,   405,   406,     0,
       0,   407,     0,   408,     0,   409,   410,     0,   411,   412,
       0,   413,     0,   414,     0,     0,   415,   416,   417,   418,
     419,   420,   421,   422,   423,   424,   425,   426,     0,   427,
     428,     0,     0,     0,   429,   430,   431,   432,     0,     0,
       0,   433,     0,     0,     0,   434,     0,   435,   436,   437,
     438,   439,   440,     0,   441,   442,   443,   444,   445,   446,
       0,     0,     0,     0,     0,     0,   447,   448,     0,   449,
       0,     0,   450,     0,     0,   451,   452,     0,     0,     0,
     453,     0,     0,   454,   455,     0,   456,   457,   458,   459,
     460,   461,     0,     0,   462,   463,   464,   465,     0,   466,
     467,     0,   468,     0,   469,   470,   471,   472,     0,   139,
     473,   474,     0,   475,   476,   477,   478,     0,     0,     0,
       0,     0,   479,   480,   481,     0,     0,     0,   482,   483,
     484,   485,     0,   486,   487,     0,   488,   489,     0,   490,
     491,     0,     0,   492,     0,     0,   493,     0,   494,     0,
     495,   496,   497,     0,     0,     0,     0,     0,     0,   498,
       0,     0,   499,     0,     0,     0,   500,   501,   502,   503,
     504,   505,   506,     0,     0,     0,     0,     0,     0,   507,
     508,     0,   509,   510,   511,     0,   142,   512,   143,   144,
     145,   146,   147,   148,     0,     0,   149,     0,     0,     0,
     150,     0,     0,   151,     0,   152,   153,   154,   155,   156,
     157,   158,   159,     0,   160,     0,     0,     0,   161,     0,
       0,     0,   162,     0,     0,   163,   164,   165,     0,   166,
       0,   167,   168,     0,     0,   169,     0,     0,   170,   171,
       0,   172,   173,     0,   174,   175,     0,   176,   177,   178,
     179,   180,   181,   182,     0,   183,   184,   185,   186,   187,
     188,   189,     0,   190,   191,   192,   193,   194,   195,   196,
     197,     0,   198,   199,     0,   200,   201,   202,   203,   204,
       0,   205,     0,     0,   206,     0,     0,   207,     0,   208,
       0,     0,   209,     0,   210,     0,     0,     0,   211,   212,
     213,     0,     0,   214,     0,     0,     0,     0,   215,   216,
       0,     0,     0,     0,   217,     0,   218,     0,     0,     0,
     219,     0,   220,   221,   222,   223,   224,     0,     0,     0,
     225,     0,     0,   226,   227,   228,     0,     0,     0,   229,
       0,   230,   231,     0,   232,   233,   234,     0,     0,   235,
     236,     0,   237,   238,   239,   240,   241,   242,   243,     0,
       0,   244,   245,   246,   247,     0,     0,   248,   249,     0,
     250,   251,   252,     0,     0,   253,     0,     0,     0,   254,
       0,   255,     0,   256,     0,   257,   258,   259,   260,   261,
     262,   263,     0,   264,     0,     0,     0,   265,   266,   267,
       0,   268,     0,     0,     0,   269,   270,     0,     0,     0,
     271,   272,   273,   274,   275,     0,     0,   276,   277,   278,
       0,   279,     0,   280,     0,     0,     0,     0,   281,   282,
       0,     0,     0,   283,     0,   284,   285,     0,   286,   287,
       0,     0,     0,   288,     0,     0,   289,   290,   291,     0,
       0,   292,     0,     0,   293,   294,   643,     0,     0,     0,
       0,   295,   296,     0,   297,     0,   298,     0,   299,   300,
       0,     0,     0,     0,     0,     0,     0,   301,   302,   303,
     304,   305,   306,   307,   308,   309,   310,   311,   312,   313,
     314,   315,   316,     0,   317,   318,   319,   320,     0,   321,
     322,   323,   324,     0,   325,   326,     0,     0,     0,     0,
     327,   328,   329,   330,   331,   332,     0,     0,   333,   334,
       0,   335,     0,   336,     0,   337,   338,   339,   340,   341,
     342,   343,   344,   345,     0,     0,   346,   347,     0,     0,
     348,   349,   350,   351,     0,     0,     0,   352,   353,     0,
       0,     0,   354,     0,   355,   356,   357,     0,   358,   359,
     360,   361,     0,   362,   363,     0,     0,     0,     0,     0,
       0,     0,     0,   364,   365,   366,     0,     0,   367,     0,
     368,     0,   369,   370,   371,   372,   373,   374,   375,   376,
     377,   378,     0,     0,   379,   380,   381,     0,   382,     0,
     383,   384,   385,   386,   387,     0,   388,   389,   390,     0,
       0,   391,     0,     0,     0,   392,   393,   394,   395,   396,
       0,     0,   397,   398,   399,   400,   401,     0,   402,   403,
       0,   404,   405,   406,     0,     0,   407,     0,   408,     0,
     409,   410,     0,   411,   412,     0,   413,     0,   414,     0,
       0,   415,   416,   417,   418,   419,   420,   421,   422,   423,
     424,   425,   426,     0,   427,   428,     0,     0,     0,   429,
     430,   431,   432,     0,     0,     0,   433,     0,     0,     0,
     434,     0,   435,   436,   437,   438,   439,   440,     0,   441,
     442,   443,   444,   445,   446,     0,     0,     0,     0,     0,
       0,   447,   448,     0,   449,     0,     0,   450,     0,     0,
     451,   452,     0,     0,     0,   453,     0,     0,   454,   455,
       0,   456,   457,   458,   459,   460,   461,     0,     0,   462,
     463,   464,   465,     0,   466,   467,     0,   468,     0,   469,
     470,   471,   472,     0,   139,   473,   474,     0,   475,   476,
     477,   478,     0,     0,     0,     0,     0,   479,   480,   481,
       0,     0,     0,   482,   483,   484,   485,     0,   486,   487,
       0,   488,   489,     0,   490,   491,     0,     0,   492,     0,
       0,   493,     0,   494,     0,   495,   496,   497,     0,     0,
       0,     0,     0,     0,   498,     0,     0,   499,     0,     0,
       0,   500,   501,   502,   503,   504,   505,   506,     0,     0,
       0,     0,     0,     0,   507,   508,     0,   509,   510,   511,
       0,   142,   512,   143,   144,   145,   146,   147,   148,     0,
       0,   149,     0,     0,     0,   150,  2894,     0,   151,     0,
     152,   153,   154,   155,   156,   157,   158,   159,     0,   160,
       0,     0,     0,   161,     0,     0,     0,   162,     0,     0,
     163,   164,   165,     0,   166,     0,   167,   168,     0,     0,
     169,     0,     0,   170,   171,     0,   172,   173,     0,   174,
     175,     0,   176,   177,   178,   179,   180,   181,   182,     0,
     183,   184,   185,   186,   187,   188,   189,     0,   190,   191,
     192,   193,   194,   195,   196,   197,     0,   198,   199,     0,
     200,   201,   202,   203,   204,     0,   205,     0,     0,   206,
       0,     0,   207,     0,   208,     0,     0,   209,     0,   210,
       0,     0,     0,   211,   212,   213,     0,     0,   214,     0,
       0,     0,     0,   215,   216,     0,     0,     0,     0,   217,
       0,   218,     0,     0,     0,   219,     0,   220,   221,   222,
     223,   224,     0,     0,     0,   225,     0,     0,   226,   227,
     228,     0,     0,     0,   229,     0,   230,   231,     0,   232,
     233,   234,     0,     0,   235,   236,     0,   237,   238,   239,
     240,   241,   242,   243,     0,     0,   244,   245,   246,   247,
       0,     0,   248,   249,     0,   250,   251,   252,     0,     0,
     253,     0,     0,     0,   254,     0,   255,     0,   256,     0,
     257,   258,   259,   260,   261,   262,   263,     0,   264,     0,
       0,     0,   265,   266,   267,     0,   268,     0,     0,     0,
     269,   270,     0,     0,     0,   271,   272,   273,   274,   275,
       0,     0,   276,   277,   278,     0,   279,     0,   280,     0,
       0,     0,     0,   281,   282,     0,     0,     0,   283,     0,
     284,   285,     0,   286,   287,     0,     0,     0,   288,     0,
       0,   289,   290,   291,     0,     0,   292,     0,     0,   293,
     294,     0,     0,     0,     0,     0,   295,   296,     0,   297,
       0,   298,     0,   299,   300,     0,     0,     0,     0,     0,
       0,     0,   301,   302,   303,   304,   305,   306,   307,   308,
     309,   310,   311,   312,   313,   314,   315,   316,     0,   317,
     318,   319,   320,     0,   321,   322,   323,   324,     0,   325,
     326,     0,     0,     0,     0,   327,   328,   329,   330,   331,
     332,     0,     0,   333,   334,     0,   335,     0,   336,     0,
     337,   338,   339,   340,   341,   342,   343,   344,   345,     0,
       0,   346,   347,     0,     0,   348,   349,   350,   351,     0,
       0,     0,   352,   353,     0,     0,     0,   354,     0,   355,
     356,   357,     0,   358,   359,   360,   361,     0,   362,   363,
       0,     0,     0,     0,     0,     0,     0,     0,   364,   365,
     366,     0,     0,   367,     0,   368,     0,   369,   370,   371,
     372,   373,   374,   375,   376,   377,   378,     0,     0,   379,
     380,   381,     0,   382,     0,   383,   384,   385,   386,   387,
       0,   388,   389,   390,     0,     0,   391,     0,     0,     0,
     392,   393,   394,   395,   396,     0,     0,   397,   398,   399,
     400,   401,     0,   402,   403,     0,   404,   405,   406,     0,
       0,   407,     0,   408,     0,   409,   410,     0,   411,   412,
       0,   413,     0,   414,     0,     0,   415,   416,   417,   418,
     419,   420,   421,   422,   423,   424,   425,   426,     0,   427,
     428,     0,     0,     0,   429,   430,   431,   432,     0,     0,
       0,   433,     0,     0,     0,   434,     0,   435,   436,   437,
     438,   439,   440,     0,   441,   442,   443,   444,   445,   446,
       0,     0,     0,     0,     0,     0,   447,   448,     0,   449,
       0,     0,   450,     0,     0,   451,   452,     0,     0,     0,
     453,     0,     0,   454,   455,     0,   456,   457,   458,   459,
     460,   461,     0,     0,   462,   463,   464,   465,     0,   466,
     467,     0,   468,     0,   469,   470,   471,   472,     0,   139,
     473,   474,     0,   475,   476,   477,   478,     0,     0,     0,
       0,     0,   479,   480,   481,     0,     0,     0,   482,   483,
     484,   485,     0,   486,   487,     0,   488,   489,     0,   490,
     491,     0,     0,   492,     0,     0,   493,     0,   494,     0,
     495,   496,   497,     0,     0,     0,     0,     0,     0,   498,
       0,     0,   499,     0,     0,     0,   500,   501,   502,   503,
     504,   505,   506,     0,     0,     0,     0,     0,     0,   507,
     508,     0,   509,   510,   511,     0,   142,   512,   143,   144,
     145,   146,   147,   148,     0,     0,   149,     0,     0,     0,
     150,     0,     0,   151,     0,   152,   153,   154,   155,   156,
     157,   158,   159,     0,   160,     0,     0,     0,   161,     0,
       0,     0,   162,     0,     0,   163,   164,   165,     0,   166,
       0,   167,   168,     0,     0,   169,     0,     0,   170,   171,
       0,   172,   173,     0,   174,   175,     0,   176,   177,   178,
     179,   180,   181,   182,     0,   183,   184,   185,   186,   187,
     188,   189,     0,   190,   191,   192,   193,   194,   195,   196,
     197,     0,   198,   199,     0,   200,   201,   202,   203,   204,
    4655,   205,     0,     0,   206,     0,     0,   207,     0,   208,
       0,     0,   209,     0,   210,     0,     0,     0,   211,   212,
     213,     0,     0,   214,     0,     0,     0,     0,   215,   216,
       0,     0,     0,     0,   217,     0,   218,     0,     0,     0,
     219,     0,   220,   221,   222,   223,   224,     0,     0,     0,
     225,     0,     0,   226,   227,   228,     0,     0,     0,   229,
       0,   230,   231,     0,   232,   233,   234,     0,     0,   235,
     236,     0,   237,   238,   239,   240,   241,   242,   243,     0,
    4656,   244,   245,   246,   247,     0,     0,   248,   249,     0,
     250,   251,   252,     0,     0,   253,     0,     0,     0,   254,
       0,   255,     0,   256,     0,   257,   258,   259,   260,   261,
     262,   263,     0,   264,     0,     0,     0,   265,   266,   267,
       0,   268,     0,     0,     0,   269,   270,     0,     0,     0,
     271,   272,   273,   274,   275,     0,     0,   276,   277,   278,
       0,   279,     0,   280,     0,     0,     0,     0,   281,   282,
       0,     0,     0,   283,     0,   284,   285,     0,   286,   287,
       0,     0,     0,   288,     0,     0,   289,   290,   291,     0,
       0,   292,     0,     0,   293,   294,     0,     0,     0,     0,
       0,   295,   296,     0,   297,     0,   298,     0,   299,   300,
       0,     0,     0,     0,     0,     0,     0,   301,   302,   303,
     304,   305,   306,   307,   308,   309,   310,   311,   312,   313,
     314,   315,   316,     0,   317,   318,   319,   320,     0,   321,
     322,   323,   324,     0,   325,   326,     0,     0,     0,     0,
     327,   328,   329,   330,   331,   332,     0,     0,   333,   334,
       0,   335,     0,   336,     0,   337,   338,   339,   340,   341,
     342,   343,   344,   345,     0,     0,   346,   347,     0,     0,
     348,   349,   350,   351,     0,     0,     0,   352,   353,     0,
       0,     0,   354,     0,   355,   356,   357,     0,   358,   359,
     360,   361,     0,   362,   363,     0,     0,     0,     0,     0,
       0,     0,     0,   364,   365,   366,     0,     0,   367,     0,
     368,     0,   369,   370,   371,   372,   373,   374,   375,   376,
     377,   378,     0,     0,   379,   380,   381,     0,   382,     0,
     383,   384,   385,   386,   387,     0,   388,   389,   390,     0,
       0,   391,     0,     0,     0,   392,   393,   394,   395,   396,
       0,     0,   397,   398,   399,   400,   401,     0,   402,   403,
       0,   404,   405,   406,     0,     0,   407,     0,   408,     0,
     409,   410,     0,   411,   412,     0,   413,     0,   414,     0,
       0,   415,   416,   417,   418,   419,   420,   421,   422,   423,
     424,   425,   426,     0,   427,   428,     0,     0,     0,   429,
     430,   431,   432,     0,     0,     0,   433,     0,     0,     0,
     434,     0,   435,   436,   437,   438,   439,   440,     0,   441,
     442,   443,   444,   445,   446,     0,     0,     0,     0,     0,
       0,   447,   448,     0,   449,     0,     0,   450,     0,     0,
     451,   452,     0,     0,     0,   453,     0,     0,   454,   455,
       0,   456,   457,   458,   459,   460,   461,     0,     0,   462,
     463,   464,   465,     0,   466,   467,     0,   468,     0,   469,
     470,   471,   472,     0,     0,   473,   474,     0,   475,   476,
     477,   478,     0,     0,     0,     0,     0,   479,   480,   481,
       0,     0,     0,   482,   483,   484,   485,     0,   486,   487,
       0,   488,   489,     0,   490,   491,     0,     0,   492,     0,
       0,   493,     0,   494,     0,   495,   496,   497,     0,     0,
       0,     0,     0,     0,   498,     0,     0,   499,     0,     0,
       0,   500,   501,   502,   503,   504,   505,   506,     0,     0,
       0,     0,     0,     0,   507,   508,     0,   509,   510,   511,
       0,   142,   512,   143,   144,   145,   146,   147,   148,     0,
       0,   149,     0,     0,     0,   150,     0,     0,   151,     0,
     152,   153,   154,   155,   156,   157,   158,   159,     0,   160,
       0,     0,     0,   161,     0,     0,     0,   162,     0,     0,
     163,   164,   165,     0,   166,     0,   167,   168,     0,     0,
     169,     0,     0,   170,   171,     0,   172,   173,     0,   174,
     175,     0,   176,   177,   178,   179,   180,   181,   182,     0,
     183,   184,   185,   186,   187,   188,   189,     0,   190,   191,
     192,   193,   194,   195,   196,   197,     0,   198,   199,     0,
     200,   201,   202,   203,   204,     0,   205,     0,     0,   206,
       0,     0,   207,     0,   208,     0,     0,   209,     0,   210,
       0,     0,     0,   211,   212,   213,     0,     0,   214,     0,
       0,     0,     0,   215,   216,     0,     0,     0,     0,   217,
       0,   218,     0,     0,     0,   219,     0,   220,   221,   222,
     223,   224,     0,     0,     0,   225,     0,     0,   226,   227,
     228,     0,     0,     0,   229,     0,   230,   231,     0,   232,
     233,   234,     0,     0,   235,   236,     0,   237,   238,   239,
     240,   241,   242,   243,     0,     0,   244,   245,   246,   247,
       0,     0,   248,   249,     0,   250,   251,   252,     0,     0,
     253,     0,     0,     0,   254,     0,   255,     0,   256,     0,
     257,   258,   259,   260,   261,   262,   263,     0,   264,     0,
       0,     0,   265,   266,   267,     0,   268,     0,     0,     0,
     269,   270,     0,     0,     0,   271,   272,   273,   274,   275,
       0,     0,   276,   277,   278,     0,   279,     0,   280,     0,
       0,     0,     0,   281,   282,     0,     0,     0,   283,     0,
     284,   285,     0,   286,   287,     0,     0,     0,   288,     0,
       0,   289,   290,   291,     0,     0,   292,     0,     0,   293,
     294,     0,     0,     0,     0,     0,   295,   296,     0,   297,
       0,   298,     0,   299,   300,     0,     0,     0,     0,     0,
       0,     0,   301,   302,   303,   304,   305,   306,   307,   308,
     309,   310,   311,   312,   313,   314,   315,   316,     0,   317,
     318,   319,   320,     0,   321,   322,   323,   324,     0,   325,
     326,     0,     0,     0,     0,   327,   328,   329,   330,   331,
     332,     0,     0,   333,   334,     0,   335,     0,   336,     0,
     337,   338,   339,   340,   341,   342,   343,   344,   345,     0,
       0,   346,   347,     0,     0,   348,   349,   350,   351,     0,
       0,     0,   352,   353,     0,     0,     0,   354,     0,   355,
     356,   357,     0,   358,   359,   360,   361,     0,   362,   363,
       0,     0,     0,     0,     0,     0,     0,     0,   364,   365,
     366,     0,     0,   367,     0,   368,     0,   369,   370,   371,
     372,   373,   374,   375,   376,   377,   378,     0,     0,   379,
     380,   381,     0,   382,     0,   383,   384,   385,   386,   387,
       0,   388,   389,   390,     0,     0,   391,     0,     0,     0,
     392,   393,   394,   395,   396,     0,     0,   397,   398,   399,
     400,   401,     0,   402,   403,     0,   404,   405,   406,     0,
       0,   407,     0,   408,     0,   409,   410,     0,   411,   412,
       0,   413,     0,   414,     0,     0,   415,   416,   417,   418,
     419,   420,   421,   422,   423,   424,   425,   426,     0,   427,
     428,     0,     0,     0,   429,   430,   431,   432,     0,     0,
       0,   433,     0,     0,     0,   434,     0,   435,   436,   437,
     438,   439,   440,     0,   441,   442,   443,   444,   445,   446,
       0,     0,     0,   585,     0,     0,   447,   448,     0,   449,
       0,     0,   450,     0,     0,   451,   452,     0,     0,     0,
     453,     0,     0,   454,   455,     0,   456,   457,   458,   459,
     460,   461,     0,     0,   462,   463,   464,   465,     0,   466,
     467,     0,   468,     0,   469,   470,   471,   472,     0,     0,
     473,   474,     0,   475,   476,   477,   478,     0,     0,     0,
       0,     0,   479,   480,   481,     0,     0,     0,   482,   483,
     484,   485,     0,   486,   487,     0,   488,   489,     0,   490,
     491,     0,     0,   492,     0,     0,   493,     0,   494,     0,
     495,   496,   497,     0,     0,     0,     0,     0,     0,   498,
       0,     0,   499,     0,     0,     0,   500,   501,   502,   503,
     504,   505,   506,     0,     0,     0,     0,     0,     0,   507,
     508,     0,   509,   510,   511,     0,   142,   512,   143,   144,
     145,   146,   147,   148,     0,     0,   149,     0,     0,     0,
     150,     0,     0,   151,     0,   152,   153,   154,   155,   156,
     157,   158,   159,     0,   160,     0,     0,     0,   161,     0,
       0,     0,   162,     0,     0,   163,   164,   165,     0,   166,
       0,   167,   168,     0,     0,   169,     0,     0,   170,   171,
       0,   172,   173,     0,   174,   175,     0,   176,   177,   178,
     179,   180,   181,   182,     0,   183,   184,   185,   186,   187,
     188,   189,     0,   190,   191,   192,   193,   194,   195,   196,
     197,     0,   198,   199,     0,   200,   201,   202,   203,   204,
       0,   205,     0,     0,   206,     0,     0,   207,     0,   208,
       0,     0,   209,     0,   210,     0,     0,     0,   211,   212,
     213,     0,     0,   214,     0,     0,     0,     0,   215,   216,
       0,     0,     0,     0,   217,     0,   218,     0,     0,     0,
     219,     0,   220,   221,   222,   223,   224,     0,     0,     0,
     225,     0,     0,   226,   227,   228,     0,     0,     0,   229,
       0,   230,   231,     0,   232,   233,   234,     0,     0,   235,
     236,     0,   237,   238,   239,   240,   241,   242,   243,     0,
       0,   244,   245,   246,   247,     0,     0,   248,   249,     0,
     250,   251,   252,     0,     0,   253,     0,     0,     0,   254,
    1114,   255,     0,   256,     0,   257,   258,   259,   260,   261,
     262,   263,     0,   264,     0,     0,     0,   265,   266,   267,
       0,   268,     0,     0,     0,   269,   270,     0,     0,     0,
     271,   272,   273,   274,   275,     0,     0,   276,   277,   278,
       0,   279,     0,   280,     0,     0,     0,     0,   281,   282,
       0,     0,     0,   283,     0,   284,   285,     0,   286,   287,
       0,     0,     0,   288,     0,     0,   289,   290,   291,     0,
       0,   292,     0,     0,   293,   294,     0,     0,     0,     0,
       0,   295,   296,     0,   297,     0,   298,     0,   299,   300,
       0,     0,     0,     0,     0,     0,     0,   301,   302,   303,
     304,   305,   306,   307,   308,   309,   310,   311,   312,   313,
     314,   315,   316,     0,   317,   318,   319,   320,     0,   321,
     322,   323,   324,     0,   325,   326,     0,     0,     0,     0,
     327,   328,   329,   330,   331,   332,     0,     0,   333,   334,
       0,   335,     0,   336,     0,   337,   338,   339,   340,   341,
     342,   343,   344,   345,     0,     0,   346,   347,     0,     0,
     348,   349,   350,   351,     0,     0,     0,   352,   353,     0,
       0,     0,   354,     0,   355,   356,   357,     0,   358,   359,
     360,   361,     0,   362,   363,     0,     0,     0,     0,     0,
       0,     0,     0,   364,   365,   366,     0,     0,   367,     0,
     368,     0,   369,   370,   371,   372,   373,   374,   375,   376,
     377,   378,     0,     0,   379,   380,   381,     0,   382,     0,
     383,   384,   385,   386,   387,     0,   388,   389,   390,     0,
       0,   391,     0,     0,     0,   392,   393,   394,   395,   396,
       0,     0,   397,   398,   399,   400,   401,     0,   402,   403,
       0,   404,   405,   406,     0,     0,   407,     0,   408,     0,
     409,   410,     0,   411,   412,     0,   413,     0,   414,     0,
       0,   415,   416,   417,   418,   419,   420,   421,   422,   423,
     424,   425,   426,     0,   427,   428,     0,     0,     0,   429,
     430,   431,   432,     0,     0,     0,   433,     0,     0,     0,
     434,     0,   435,   436,   437,   438,   439,   440,     0,   441,
     442,   443,   444,   445,   446,     0,     0,     0,     0,     0,
       0,   447,   448,     0,   449,     0,     0,   450,     0,     0,
     451,   452,     0,     0,     0,   453,     0,     0,   454,   455,
       0,   456,   457,   458,   459,   460,   461,     0,     0,   462,
     463,   464,   465,     0,   466,   467,     0,   468,     0,   469,
     470,   471,   472,     0,     0,   473,   474,     0,   475,   476,
     477,   478,     0,     0,     0,     0,     0,   479,   480,   481,
       0,     0,     0,   482,   483,   484,   485,     0,   486,   487,
       0,   488,   489,     0,   490,   491,     0,     0,   492,     0,
       0,   493,     0,   494,     0,   495,   496,   497,     0,     0,
       0,     0,     0,     0,   498,     0,     0,   499,     0,     0,
       0,   500,   501,   502,   503,   504,   505,   506,     0,     0,
       0,     0,     0,     0,   507,   508,     0,   509,   510,   511,
       0,   142,   512,   143,   144,   145,   146,   147,   148,     0,
       0,   149,     0,     0,     0,   150,     0,     0,   151,     0,
     152,   153,   154,   155,   156,   157,   158,   159,     0,   160,
       0,     0,     0,   161,     0,     0,     0,   162,     0,     0,
     163,   164,   165,     0,   166,     0,   167,   168,     0,     0,
     169,     0,     0,   170,   171,     0,   172,   173,     0,   174,
     175,     0,   176,   177,   178,   179,   180,   181,   182,     0,
     183,   184,   185,   186,   187,   188,   189,     0,   190,   191,
     192,   193,   194,   195,   196,   197,     0,   198,   199,     0,
     200,   201,   202,   203,   204,     0,   205,     0,     0,   206,
       0,     0,   207,     0,   208,     0,     0,   209,     0,   210,
       0,     0,     0,   211,   212,   213,     0,     0,   214,     0,
       0,     0,     0,   215,   216,     0,     0,     0,   943,   217,
       0,   218,     0,     0,     0,   219,     0,   220,   221,   222,
     223,   224,     0,     0,     0,   225,     0,     0,   226,   227,
     228,     0,     0,     0,   229,     0,   230,   231,     0,   232,
     233,   234,     0,     0,   235,   236,     0,   237,   238,   239,
     240,   241,   242,   243,     0,     0,   244,   245,   246,   247,
       0,     0,   248,   249,     0,   250,   251,   252,     0,     0,
     253,     0,     0,     0,   254,     0,   255,     0,   256,     0,
     257,   258,   259,   260,   261,   262,   263,     0,   264,     0,
       0,     0,   265,   266,   267,     0,   268,     0,     0,     0,
     269,   270,     0,     0,     0,   271,   272,   273,   274,   275,
       0,     0,   276,   277,   278,     0,   279,     0,   280,     0,
       0,     0,     0,   281,   282,     0,     0,     0,   283,     0,
     284,   285,     0,   286,   287,     0,     0,     0,   288,     0,
       0,   289,   290,   291,     0,     0,   292,     0,     0,   293,
     294,     0,     0,     0,     0,     0,   295,   296,     0,   297,
       0,   298,     0,   299,   300,     0,     0,     0,     0,     0,
       0,     0,   301,   302,   303,   304,   305,   306,   307,   308,
     309,   310,   311,   312,   313,   314,   315,   316,     0,   317,
     318,   319,   320,     0,   321,   322,   323,   324,     0,   325,
     326,     0,     0,     0,     0,   327,   328,   329,   330,   331,
     332,     0,     0,   333,   334,     0,   335,     0,   336,     0,
     337,   338,   339,   340,   341,   342,   343,   344,   345,     0,
       0,   346,   347,     0,     0,   348,   349,   350,   351,     0,
       0,     0,   352,   353,     0,     0,     0,   354,     0,   355,
     356,   357,     0,   358,   359,   360,   361,     0,   362,   363,
       0,     0,     0,     0,     0,     0,     0,     0,   364,   365,
     366,     0,     0,   367,     0,   368,     0,   369,   370,   371,
     372,   373,   374,   375,   376,   377,   378,     0,     0,   379,
     380,   381,     0,   382,     0,   383,   384,   385,   386,   387,
       0,   388,   389,   390,     0,     0,   391,     0,     0,     0,
     392,   393,   394,   395,   396,     0,     0,   397,   398,   399,
     400,   401,     0,   402,   403,     0,   404,   405,   406,     0,
       0,   407,     0,   408,     0,   409,   410,     0,   411,   412,
       0,   413,     0,   414,     0,     0,   415,   416,   417,   418,
     419,   420,   421,   422,   423,   424,   425,   426,     0,   427,
     428,     0,     0,     0,   429,   430,   431,   432,     0,     0,
       0,   433,     0,     0,     0,   434,     0,   435,   436,   437,
     438,   439,   440,     0,   441,   442,   443,   444,   445,   446,
       0,     0,     0,     0,     0,     0,   447,   448,     0,   449,
       0,     0,   450,     0,     0,   451,   452,     0,     0,     0,
     453,     0,     0,   454,   455,     0,   456,   457,   458,   459,
     460,   461,     0,     0,   462,   463,   464,   465,     0,   466,
     467,     0,   468,     0,   469,   470,   471,   472,     0,     0,
     473,   474,     0,   475,   476,   477,   478,     0,     0,     0,
       0,     0,  1967,   480,   481,     0,     0,     0,   482,   483,
     484,   485,     0,   486,   487,     0,   488,   489,     0,   490,
     491,     0,     0,   492,     0,     0,   493,     0,   494,     0,
     495,   496,   497,     0,     0,     0,     0,     0,     0,   498,
       0,     0,   499,     0,     0,     0,   500,   501,   502,   503,
     504,   505,   506,     0,     0,     0,     0,     0,     0,   507,
     508,     0,   509,   510,   511,     0,   142,   512,   143,   144,
     145,   146,   147,   148,     0,     0,   149,     0,     0,     0,
     150,     0,     0,   151,     0,   152,   153,   154,   155,   156,
     157,   158,   159,     0,   160,     0,     0,     0,   161,     0,
       0,     0,   162,     0,     0,   163,   164,   165,     0,   166,
       0,   167,   168,     0,     0,   169,     0,     0,   170,   171,
       0,   172,   173,     0,   174,   175,     0,   176,   177,   178,
     179,   180,   181,   182,     0,   183,   184,   185,   186,   187,
     188,   189,     0,   190,   191,   192,   193,   194,   195,   196,
     197,     0,   198,   199,     0,   200,   201,   202,   203,   204,
       0,   205,     0,     0,   206,     0,     0,   207,     0,   208,
       0,     0,   209,     0,   210,     0,     0,     0,   211,   212,
     213,     0,     0,   214,     0,     0,     0,     0,   215,   216,
       0,     0,     0,  2123,   217,     0,   218,     0,     0,     0,
     219,     0,   220,   221,   222,   223,   224,     0,     0,     0,
     225,     0,     0,   226,   227,   228,     0,     0,     0,   229,
       0,   230,   231,     0,   232,   233,   234,     0,     0,   235,
     236,     0,   237,   238,   239,   240,   241,   242,   243,     0,
       0,   244,   245,   246,   247,     0,     0,   248,   249,     0,
     250,   251,   252,     0,     0,   253,     0,     0,     0,   254,
       0,   255,     0,   256,     0,   257,   258,   259,   260,   261,
     262,   263,     0,   264,     0,     0,     0,   265,   266,   267,
       0,   268,     0,     0,     0,   269,   270,     0,     0,     0,
     271,   272,   273,   274,   275,     0,     0,   276,   277,   278,
       0,   279,     0,   280,     0,     0,     0,     0,   281,   282,
       0,     0,     0,   283,     0,   284,   285,     0,   286,   287,
       0,     0,     0,   288,     0,     0,   289,   290,   291,     0,
       0,   292,     0,     0,   293,   294,     0,     0,     0,     0,
       0,   295,   296,     0,   297,     0,   298,     0,   299,   300,
       0,     0,     0,     0,     0,     0,     0,   301,   302,   303,
     304,   305,   306,   307,   308,   309,   310,   311,   312,   313,
     314,   315,   316,     0,   317,   318,   319,   320,     0,   321,
     322,   323,   324,     0,   325,   326,     0,     0,     0,     0,
     327,   328,   329,   330,   331,   332,     0,     0,   333,   334,
       0,   335,     0,   336,     0,   337,   338,   339,   340,   341,
     342,   343,   344,   345,     0,     0,   346,   347,     0,     0,
     348,   349,   350,   351,     0,     0,     0,   352,   353,     0,
       0,     0,   354,     0,   355,   356,   357,     0,   358,   359,
     360,   361,     0,   362,   363,     0,     0,     0,     0,     0,
       0,     0,     0,   364,   365,   366,     0,     0,   367,     0,
     368,     0,   369,   370,   371,   372,   373,   374,   375,   376,
     377,   378,     0,     0,   379,   380,   381,     0,   382,     0,
     383,   384,   385,   386,   387,     0,   388,   389,   390,     0,
       0,   391,     0,     0,     0,   392,   393,   394,   395,   396,
       0,     0,   397,   398,   399,   400,   401,     0,   402,   403,
       0,   404,   405,   406,     0,     0,   407,     0,   408,     0,
     409,   410,     0,   411,   412,     0,   413,     0,   414,     0,
       0,   415,   416,   417,   418,   419,   420,   421,   422,   423,
     424,   425,   426,     0,   427,   428,     0,     0,     0,   429,
     430,   431,   432,     0,     0,     0,   433,     0,     0,     0,
     434,     0,   435,   436,   437,   438,   439,   440,     0,   441,
     442,   443,   444,   445,   446,     0,     0,     0,     0,     0,
       0,   447,   448,     0,   449,     0,     0,   450,     0,     0,
     451,   452,     0,     0,     0,   453,     0,     0,   454,   455,
       0,   456,   457,   458,   459,   460,   461,     0,     0,   462,
     463,   464,   465,     0,   466,   467,     0,   468,     0,   469,
     470,   471,   472,     0,     0,   473,   474,     0,   475,   476,
     477,   478,     0,     0,     0,     0,     0,   479,   480,   481,
       0,     0,     0,   482,   483,   484,   485,     0,   486,   487,
       0,   488,   489,     0,   490,   491,     0,     0,   492,     0,
       0,   493,     0,   494,     0,   495,   496,   497,     0,     0,
       0,     0,     0,     0,   498,     0,     0,   499,     0,     0,
       0,   500,   501,   502,   503,   504,   505,   506,     0,     0,
       0,     0,     0,     0,   507,   508,     0,   509,   510,   511,
       0,   142,   512,   143,   144,   145,   146,   147,   148,     0,
       0,   149,     0,     0,     0,   150,     0,     0,   151,     0,
     152,   153,   154,   155,   156,   157,   158,   159,     0,   160,
       0,     0,     0,   161,     0,     0,     0,   162,     0,     0,
     163,   164,   165,     0,   166,     0,   167,   168,     0,     0,
     169,     0,     0,   170,   171,     0,   172,   173,     0,   174,
     175,     0,   176,   177,   178,   179,   180,   181,   182,     0,
     183,   184,   185,   186,   187,   188,   189,     0,   190,   191,
     192,   193,   194,   195,   196,   197,     0,   198,   199,     0,
     200,   201,   202,   203,   204,     0,   205,     0,     0,   206,
       0,     0,   207,     0,   208,     0,     0,   209,     0,   210,
       0,     0,     0,   211,   212,   213,     0,     0,   214,     0,
       0,     0,     0,   215,   216,     0,     0,     0,   943,   217,
       0,   218,     0,     0,     0,   219,     0,   220,   221,   222,
     223,   224,     0,     0,     0,   225,     0,     0,   226,   227,
     228,     0,     0,     0,   229,     0,   230,   231,     0,   232,
     233,   234,     0,     0,   235,   236,     0,   237,   238,   239,
     240,   241,   242,   243,     0,     0,   244,   245,   246,   247,
       0,     0,   248,   249,     0,   250,   251,   252,     0,     0,
     253,     0,     0,     0,   254,     0,   255,     0,   256,     0,
     257,   258,   259,   260,   261,   262,   263,     0,   264,     0,
       0,     0,   265,   266,   267,     0,   268,     0,     0,     0,
     269,   270,     0,     0,     0,   271,   272,   273,   274,   275,
       0,     0,   276,   277,   278,     0,   279,     0,   280,     0,
       0,     0,     0,   281,   282,     0,     0,     0,   283,     0,
     284,   285,     0,   286,   287,     0,     0,     0,   288,     0,
       0,   289,   290,   291,     0,     0,   292,     0,     0,   293,
     294,     0,     0,     0,     0,     0,   295,   296,     0,   297,
       0,   298,     0,   299,   300,     0,     0,     0,     0,     0,
       0,     0,   301,   302,   303,   304,   305,   306,   307,   308,
     309,   310,   311,   312,   313,   314,   315,   316,     0,   317,
     318,   319,   320,     0,   321,   322,   323,   324,     0,   325,
     326,     0,     0,     0,     0,   327,   328,   329,   330,   331,
     332,     0,     0,   333,   334,     0,   335,     0,   336,     0,
     337,   338,   339,   340,   341,   342,   343,   344,   345,     0,
       0,   346,   347,     0,     0,   348,   349,   350,   351,     0,
       0,     0,   352,   353,     0,     0,     0,   354,     0,   355,
     356,   357,     0,   358,   359,   360,   361,     0,   362,   363,
       0,     0,     0,     0,     0,     0,     0,     0,   364,   365,
     366,     0,     0,   367,     0,   368,     0,   369,   370,   371,
     372,   373,   374,   375,   376,   377,   378,     0,     0,   379,
     380,   381,     0,   382,     0,   383,   384,   385,   386,   387,
       0,   388,   389,   390,     0,     0,   391,     0,     0,     0,
     392,   393,   394,   395,   396,     0,     0,   397,   398,   399,
     400,   401,     0,   402,   403,     0,   404,   405,   406,     0,
       0,   407,     0,   408,     0,   409,   410,     0,   411,   412,
       0,   413,     0,   414,     0,     0,   415,   416,   417,   418,
     419,   420,   421,   422,   423,   424,   425,   426,     0,   427,
     428,     0,     0,     0,   429,   430,   431,   432,     0,     0,
       0,   433,     0,     0,     0,   434,     0,   435,   436,   437,
     438,   439,   440,     0,   441,   442,   443,   444,   445,   446,
       0,     0,     0,     0,     0,     0,   447,   448,     0,   449,
       0,     0,   450,     0,     0,   451,   452,     0,     0,     0,
     453,     0,     0,   454,   455,     0,   456,   457,   458,   459,
     460,   461,     0,     0,   462,   463,   464,   465,     0,   466,
     467,     0,   468,     0,   469,   470,   471,   472,     0,     0,
     473,   474,     0,   475,   476,   477,   478,     0,     0,     0,
       0,     0,   479,   480,   481,     0,     0,     0,   482,   483,
     484,   485,     0,   486,   487,     0,   488,   489,     0,   490,
     491,     0,     0,   492,     0,     0,   493,     0,   494,     0,
     495,   496,   497,     0,     0,     0,     0,     0,     0,   498,
       0,     0,   499,     0,     0,     0,   500,   501,   502,   503,
     504,   505,   506,     0,     0,     0,     0,     0,     0,   507,
     508,     0,   509,   510,   511,     0,   142,   512,   143,   144,
     145,   146,   147,   148,     0,     0,   149,     0,     0,     0,
     150,     0,     0,   151,     0,   152,   153,   154,   155,   156,
     157,   158,   159,     0,   160,     0,     0,     0,   161,     0,
       0,     0,   162,     0,     0,   163,   164,   165,     0,   166,
       0,   167,   168,     0,     0,   169,     0,     0,   170,   171,
       0,   172,   173,     0,   174,   175,     0,   176,   177,   178,
     179,   180,   181,   182,     0,   183,   184,   185,   186,   187,
     188,   189,     0,   190,   191,   192,   193,   194,   195,   196,
     197,     0,   198,   199,     0,   200,   201,   202,   203,   204,
       0,   205,     0,     0,   206,     0,     0,   207,     0,   208,
       0,     0,   209,     0,   210,     0,     0,     0,   211,   212,
     213,     0,     0,   214,     0,     0,     0,     0,   215,   216,
       0,     0,     0,     0,   217,     0,   218,     0,     0,     0,
     219,     0,   220,   221,   222,   223,   224,     0,     0,     0,
     225,     0,     0,   226,   227,   228,     0,     0,     0,   229,
       0,   230,   231,     0,   232,   233,   234,     0,     0,   235,
     236,     0,   237,   238,   239,   240,   241,   242,   243,     0,
       0,   244,   245,   246,   247,     0,     0,   248,   249,     0,
     250,   251,   252,     0,     0,   253,     0,     0,     0,   254,
       0,   255,     0,   256,     0,   257,   258,   259,   260,   261,
     262,   263,     0,   264,     0,     0,     0,   265,   266,   267,
       0,   268,     0,     0,     0,   269,   270,     0,     0,     0,
     271,   272,   273,   274,   275,     0,     0,   276,   277,   278,
       0,   279,     0,   280,     0,     0,     0,     0,   281,   282,
       0,     0,     0,   283,     0,   284,   285,     0,   286,   287,
       0,     0,     0,   288,     0,     0,   289,   290,   291,     0,
       0,   292,     0,     0,   293,   294,     0,     0,     0,     0,
       0,   295,   296,     0,   297,     0,   298,     0,   299,   300,
       0,     0,     0,     0,     0,     0,     0,   301,   302,   303,
     304,   305,   306,   307,   308,   309,   310,   311,   312,   313,
     314,   315,   316,     0,   317,   318,   319,   320,     0,   321,
     322,   323,   324,     0,   325,   326,     0,     0,     0,     0,
     327,   328,   329,   330,   331,   332,     0,     0,   333,   334,
       0,   335,     0,   336,     0,   337,   338,   339,   340,   341,
     342,   343,   344,   345,     0,     0,   346,   347,     0,     0,
     348,   349,   350,   351,     0,     0,     0,   352,   353,     0,
       0,     0,   354,     0,   355,   356,   357,     0,   358,   359,
     360,   361,     0,   362,   363,     0,     0,     0,     0,     0,
       0,     0,     0,   364,   365,   366,     0,     0,   367,     0,
     368,     0,   369,   370,   371,   372,   373,   374,   375,   376,
     377,   378,     0,     0,   379,   380,   381,  3092,   382,     0,
     383,   384,   385,   386,   387,     0,   388,   389,   390,     0,
       0,   391,     0,     0,     0,   392,   393,   394,   395,   396,
       0,     0,   397,   398,   399,   400,   401,     0,   402,   403,
       0,   404,   405,   406,     0,     0,   407,     0,   408,     0,
     409,   410,     0,   411,   412,     0,   413,     0,   414,     0,
       0,   415,   416,   417,   418,   419,   420,   421,   422,   423,
     424,   425,   426,     0,   427,   428,     0,     0,     0,   429,
     430,   431,   432,     0,     0,     0,   433,     0,     0,     0,
     434,     0,   435,   436,   437,   438,   439,   440,     0,   441,
     442,   443,   444,   445,   446,     0,     0,     0,     0,     0,
       0,   447,   448,     0,   449,     0,     0,   450,     0,     0,
     451,   452,     0,     0,     0,   453,     0,     0,   454,   455,
       0,   456,   457,   458,   459,   460,   461,     0,     0,   462,
     463,   464,   465,     0,   466,   467,     0,   468,     0,   469,
     470,   471,   472,     0,     0,   473,   474,     0,   475,   476,
     477,   478,     0,     0,     0,     0,     0,   479,   480,   481,
       0,     0,     0,   482,   483,   484,   485,     0,   486,   487,
       0,   488,   489,     0,   490,   491,     0,     0,   492,     0,
       0,   493,     0,   494,     0,   495,   496,   497,     0,     0,
       0,     0,     0,     0,   498,     0,     0,   499,     0,     0,
       0,   500,   501,   502,   503,   504,   505,   506,     0,     0,
       0,     0,     0,     0,   507,   508,     0,   509,   510,   511,
       0,   142,   512,   143,   144,   145,   146,   147,   148,     0,
       0,   149,     0,     0,     0,   150,     0,     0,   151,     0,
     152,   153,   154,   155,   156,   157,   158,   159,     0,   160,
       0,     0,     0,   161,     0,     0,     0,   162,     0,     0,
     163,   164,   165,     0,   166,     0,   167,   168,     0,     0,
     169,     0,     0,   170,   171,     0,   172,   173,     0,   174,
     175,     0,   176,   177,   178,   179,   180,   181,   182,     0,
     183,   184,   185,   186,   187,   188,   189,     0,   190,   191,
     192,   193,   194,   195,   196,   197,     0,   198,   199,     0,
     200,   201,   202,   203,   204,     0,   205,     0,     0,   206,
       0,     0,   207,     0,   208,     0,     0,   209,     0,   210,
       0,     0,     0,   211,   212,   213,     0,     0,   214,     0,
       0,     0,     0,   215,   216,     0,     0,     0,     0,   217,
       0,   218,     0,     0,     0,   219,     0,   220,   221,   222,
     223,   224,     0,     0,     0,   225,     0,     0,   226,   227,
     228,     0,     0,     0,   229,     0,   230,   231,     0,   232,
     233,   234,     0,     0,   235,   236,     0,   237,   238,   239,
     240,   241,   242,   243,     0,     0,   244,   245,   246,   247,
       0,     0,   248,   249,     0,   250,   251,   252,     0,     0,
     253,     0,     0,     0,   254,     0,   255,     0,   256,     0,
     257,   258,   259,   260,   261,   262,   263,     0,   264,     0,
       0,     0,   265,   266,   267,     0,   268,     0,     0,     0,
     269,   270,     0,     0,     0,   271,   272,   273,   274,   275,
       0,     0,   276,   277,   278,     0,   279,     0,   280,     0,
       0,     0,     0,   281,   282,     0,     0,     0,   283,     0,
     284,   285,     0,   286,   287,     0,     0,     0,   288,     0,
       0,   289,   290,   291,     0,     0,   292,     0,     0,   293,
     294,     0,     0,     0,     0,     0,   295,   296,     0,   297,
       0,   298,     0,   299,   300,     0,     0,     0,     0,     0,
       0,     0,   301,   302,   303,   304,   305,   306,   307,   308,
     309,   310,   311,   312,   313,   314,   315,   316,     0,   317,
     318,   319,   320,     0,   321,   322,   323,   324,     0,   325,
     326,     0,     0,     0,     0,   327,   328,   329,   330,   331,
     332,     0,     0,   333,   334,     0,   335,     0,   336,     0,
     337,   338,   339,   340,   341,   342,   343,   344,   345,     0,
       0,   346,   347,     0,     0,   348,   349,   350,   351,     0,
       0,     0,   352,   353,     0,     0,     0,   354,     0,   355,
     356,   357,     0,   358,   359,   360,   361,     0,   362,   363,
       0,     0,     0,     0,     0,     0,     0,     0,   364,   365,
     366,     0,     0,   367,     0,   368,     0,   369,   370,   371,
     372,   373,   374,   375,   376,   377,   378,     0,     0,   379,
     380,   381,     0,   382,     0,   383,   384,   385,   386,   387,
       0,   388,   389,   390,     0,     0,   391,     0,     0,     0,
     392,   393,   394,   395,   396,     0,     0,   397,   398,   399,
     400,   401,     0,   402,   403,     0,   404,   405,   406,     0,
       0,   407,     0,   408,     0,   409,   410,     0,   411,   412,
       0,   413,     0,   414,     0,     0,   415,   416,   417,   418,
     419,   420,   421,   422,   423,   424,   425,   426,     0,   427,
     428,     0,     0,     0,   429,   430,   431,   432,     0,     0,
       0,   433,     0,     0,     0,   434,     0,   435,   436,   437,
     438,   439,   440,     0,   441,   442,   443,   444,   445,   446,
       0,     0,     0,     0,     0,     0,   447,   448,     0,   449,
       0,     0,   450,     0,     0,   451,   452,     0,     0,     0,
     453,     0,     0,   454,   455,     0,   456,   457,   458,   459,
     460,   461,     0,     0,   462,   463,   464,   465,     0,   466,
     467,     0,   468,     0,   469,   470,   471,   472,     0,   139,
     473,   474,     0,   475,   476,   477,   478,     0,     0,     0,
       0,     0,   479,   480,   481,     0,     0,     0,   482,   483,
     484,   485,     0,   486,   487,     0,   488,   489,     0,   490,
     491,     0,     0,   492,     0,     0,   493,     0,   494,     0,
     495,   496,   497,     0,     0,     0,     0,     0,     0,   498,
       0,     0,   499,     0,     0,     0,   500,   501,   502,   503,
     504,   505,   506,     0,     0,     0,     0,     0,     0,   507,
     508,     0,   509,   510,   511,     0,   142,   512,   143,   144,
     145,   146,   147,   148,     0,     0,   149,     0,     0,     0,
     150,     0,     0,   151,     0,   152,   153,   154,   155,   156,
     157,   158,   159,     0,   160,     0,     0,     0,   161,     0,
       0,     0,   162,     0,     0,   163,   164,   165,     0,   166,
       0,   167,   168,     0,     0,   169,     0,     0,   170,   171,
       0,   172,   173,     0,   174,   175,     0,   176,   177,   178,
     179,   180,   181,   182,     0,   183,   184,   185,   186,   187,
     188,   189,     0,   190,   191,   192,   193,   194,   195,   196,
     197,     0,   198,   199,     0,   200,   201,   202,   203,   204,
       0,   205,     0,     0,   206,     0,     0,   207,     0,   208,
       0,     0,   209,     0,   210,     0,     0,     0,   211,   212,
     213,     0,     0,   214,     0,     0,     0,     0,   215,   216,
       0,     0,     0,  3396,   217,     0,   218,     0,     0,     0,
     219,     0,   220,   221,   222,   223,   224,     0,     0,     0,
     225,     0,     0,   226,   227,   228,     0,     0,     0,   229,
       0,   230,   231,     0,   232,   233,   234,     0,     0,   235,
     236,     0,   237,   238,   239,   240,   241,   242,   243,     0,
       0,   244,   245,   246,   247,     0,     0,   248,   249,     0,
     250,   251,   252,     0,     0,   253,     0,     0,     0,   254,
       0,   255,     0,   256,     0,   257,   258,   259,   260,   261,
     262,   263,     0,   264,     0,     0,     0,   265,   266,   267,
       0,   268,     0,     0,     0,   269,   270,     0,     0,     0,
     271,   272,   273,   274,   275,     0,     0,   276,   277,   278,
       0,   279,     0,   280,     0,     0,     0,     0,   281,   282,
       0,     0,     0,   283,     0,   284,   285,     0,   286,   287,
       0,     0,     0,   288,     0,     0,   289,   290,   291,     0,
       0,   292,     0,     0,   293,   294,     0,     0,     0,     0,
       0,   295,   296,     0,   297,     0,   298,     0,   299,   300,
       0,     0,     0,     0,     0,     0,     0,   301,   302,   303,
     304,   305,   306,   307,   308,   309,   310,   311,   312,   313,
     314,   315,   316,     0,   317,   318,   319,   320,     0,   321,
     322,   323,   324,     0,   325,   326,     0,     0,     0,     0,
     327,   328,   329,   330,   331,   332,     0,     0,   333,   334,
       0,   335,     0,   336,     0,   337,   338,   339,   340,   341,
     342,   343,   344,   345,     0,     0,   346,   347,     0,     0,
     348,   349,   350,   351,     0,     0,     0,   352,   353,     0,
       0,     0,   354,     0,   355,   356,   357,     0,   358,   359,
     360,   361,     0,   362,   363,     0,     0,     0,     0,     0,
       0,     0,     0,   364,   365,   366,     0,     0,   367,     0,
     368,     0,   369,   370,   371,   372,   373,   374,   375,   376,
     377,   378,     0,     0,   379,   380,   381,     0,   382,     0,
     383,   384,   385,   386,   387,     0,   388,   389,   390,     0,
       0,   391,     0,     0,     0,   392,   393,   394,   395,   396,
       0,     0,   397,   398,   399,   400,   401,     0,   402,   403,
       0,   404,   405,   406,     0,     0,   407,     0,   408,     0,
     409,   410,     0,   411,   412,     0,   413,     0,   414,     0,
       0,   415,   416,   417,   418,   419,   420,   421,   422,   423,
     424,   425,   426,     0,   427,   428,     0,     0,     0,   429,
     430,   431,   432,     0,     0,     0,   433,     0,     0,     0,
     434,     0,   435,   436,   437,   438,   439,   440,     0,   441,
     442,   443,   444,   445,   446,     0,     0,     0,     0,     0,
       0,   447,   448,     0,   449,     0,     0,   450,     0,     0,
     451,   452,     0,     0,     0,   453,     0,     0,   454,   455,
       0,   456,   457,   458,   459,   460,   461,     0,     0,   462,
     463,   464,   465,     0,   466,   467,     0,   468,     0,   469,
     470,   471,   472,     0,     0,   473,   474,     0,   475,   476,
     477,   478,     0,     0,     0,     0,     0,   479,   480,   481,
       0,     0,     0,   482,   483,   484,   485,     0,   486,   487,
       0,   488,   489,     0,   490,   491,     0,     0,   492,     0,
       0,   493,     0,   494,     0,   495,   496,   497,     0,     0,
       0,     0,     0,     0,   498,     0,     0,   499,     0,     0,
       0,   500,   501,   502,   503,   504,   505,   506,     0,     0,
       0,     0,     0,     0,   507,   508,     0,   509,   510,   511,
       0,   142,   512,   143,   144,   145,   146,   147,   148,  3404,
       0,   149,     0,     0,     0,   150,     0,     0,   151,     0,
     152,   153,   154,   155,   156,   157,   158,   159,     0,   160,
       0,     0,     0,   161,     0,     0,     0,   162,     0,     0,
     163,   164,   165,     0,   166,     0,   167,   168,     0,     0,
     169,     0,     0,   170,   171,     0,   172,   173,     0,   174,
     175,     0,   176,   177,   178,   179,   180,   181,   182,     0,
     183,   184,   185,   186,   187,   188,   189,     0,   190,   191,
     192,   193,   194,   195,   196,   197,     0,   198,   199,     0,
     200,   201,   202,   203,   204,     0,   205,     0,     0,   206,
       0,     0,   207,     0,   208,     0,     0,   209,     0,   210,
       0,     0,     0,   211,   212,   213,     0,     0,   214,     0,
       0,     0,     0,   215,   216,     0,     0,     0,     0,   217,
       0,   218,     0,     0,     0,   219,     0,   220,   221,   222,
     223,   224,     0,     0,     0,   225,     0,     0,   226,   227,
     228,     0,     0,     0,   229,     0,   230,   231,     0,   232,
     233,   234,     0,     0,   235,   236,     0,   237,   238,   239,
     240,   241,   242,   243,     0,     0,   244,   245,   246,   247,
       0,     0,   248,   249,     0,   250,   251,   252,     0,     0,
     253,     0,     0,     0,   254,     0,   255,     0,   256,     0,
     257,   258,   259,   260,   261,   262,   263,     0,   264,     0,
       0,     0,   265,   266,   267,     0,   268,     0,     0,     0,
     269,   270,     0,     0,     0,   271,   272,   273,   274,   275,
       0,     0,   276,   277,   278,     0,   279,     0,   280,     0,
       0,     0,     0,   281,   282,     0,     0,     0,   283,     0,
     284,   285,     0,   286,   287,     0,     0,     0,   288,     0,
       0,   289,   290,   291,     0,     0,   292,     0,     0,   293,
     294,     0,     0,     0,     0,     0,   295,   296,     0,   297,
       0,   298,     0,   299,   300,     0,     0,     0,     0,     0,
       0,     0,   301,   302,   303,   304,   305,   306,   307,   308,
     309,   310,   311,   312,   313,   314,   315,   316,     0,   317,
     318,   319,   320,     0,   321,   322,   323,   324,     0,   325,
     326,     0,     0,     0,     0,   327,   328,   329,   330,   331,
     332,     0,     0,   333,   334,     0,   335,     0,   336,     0,
     337,   338,   339,   340,   341,   342,   343,   344,   345,     0,
       0,   346,   347,     0,     0,   348,   349,   350,   351,     0,
       0,     0,   352,   353,     0,     0,     0,   354,     0,   355,
     356,   357,     0,   358,   359,   360,   361,     0,   362,   363,
       0,     0,     0,     0,     0,     0,     0,     0,   364,   365,
     366,     0,     0,   367,     0,   368,     0,   369,   370,   371,
     372,   373,   374,   375,   376,   377,   378,     0,     0,   379,
     380,   381,     0,   382,     0,   383,   384,   385,   386,   387,
       0,   388,   389,   390,     0,     0,   391,     0,     0,     0,
     392,   393,   394,   395,   396,     0,     0,   397,   398,   399,
     400,   401,     0,   402,   403,     0,   404,   405,   406,     0,
       0,   407,     0,   408,     0,   409,   410,     0,   411,   412,
       0,   413,     0,   414,     0,     0,   415,   416,   417,   418,
     419,   420,   421,   422,   423,   424,   425,   426,     0,   427,
     428,     0,     0,     0,   429,   430,   431,   432,     0,     0,
       0,   433,     0,     0,     0,   434,     0,   435,   436,   437,
     438,   439,   440,     0,   441,   442,   443,   444,   445,   446,
       0,     0,     0,     0,     0,     0,   447,   448,     0,   449,
       0,     0,   450,     0,     0,   451,   452,     0,     0,     0,
     453,     0,     0,   454,   455,     0,   456,   457,   458,   459,
     460,   461,     0,     0,   462,   463,   464,   465,     0,   466,
     467,     0,   468,     0,   469,   470,   471,   472,     0,     0,
     473,   474,     0,   475,   476,   477,   478,     0,     0,     0,
       0,     0,   479,   480,   481,     0,     0,     0,   482,   483,
     484,   485,     0,   486,   487,     0,   488,   489,     0,   490,
     491,     0,     0,   492,     0,     0,   493,     0,   494,     0,
     495,   496,   497,     0,     0,     0,     0,     0,     0,   498,
       0,     0,   499,     0,     0,     0,   500,   501,   502,   503,
     504,   505,   506,     0,     0,     0,     0,     0,     0,   507,
     508,     0,   509,   510,   511,     0,   142,   512,   143,   144,
     145,   146,   147,   148,     0,     0,   149,     0,     0,     0,
     150,     0,     0,   151,     0,   152,   153,   154,   155,   156,
     157,   158,   159,     0,   160,     0,     0,     0,   161,     0,
       0,     0,   162,     0,     0,   163,   164,   165,     0,   166,
       0,   167,   168,     0,     0,   169,     0,     0,   170,   171,
       0,   172,   173,     0,   174,   175,     0,   176,   177,   178,
     179,   180,   181,   182,     0,   183,   184,   185,   186,   187,
     188,   189,     0,   190,   191,   192,   193,   194,   195,   196,
     197,     0,   198,   199,     0,   200,   201,   202,   203,   204,
       0,   205,     0,     0,   206,     0,     0,   207,     0,   208,
       0,     0,   209,     0,   210,     0,     0,     0,   211,   212,
     213,     0,     0,   214,     0,     0,     0,     0,   215,   216,
       0,     0,     0,  3428,   217,     0,   218,     0,     0,     0,
     219,     0,   220,   221,   222,   223,   224,     0,     0,     0,
     225,     0,     0,   226,   227,   228,     0,     0,     0,   229,
       0,   230,   231,     0,   232,   233,   234,     0,     0,   235,
     236,     0,   237,   238,   239,   240,   241,   242,   243,     0,
       0,   244,   245,   246,   247,     0,     0,   248,   249,     0,
     250,   251,   252,     0,     0,   253,     0,     0,     0,   254,
       0,   255,     0,   256,     0,   257,   258,   259,   260,   261,
     262,   263,     0,   264,     0,     0,     0,   265,   266,   267,
       0,   268,     0,     0,     0,   269,   270,     0,     0,     0,
     271,   272,   273,   274,   275,     0,     0,   276,   277,   278,
       0,   279,     0,   280,     0,     0,     0,     0,   281,   282,
       0,     0,     0,   283,     0,   284,   285,     0,   286,   287,
       0,     0,     0,   288,     0,     0,   289,   290,   291,     0,
       0,   292,     0,     0,   293,   294,     0,     0,     0,     0,
       0,   295,   296,     0,   297,     0,   298,     0,   299,   300,
       0,     0,     0,     0,     0,     0,     0,   301,   302,   303,
     304,   305,   306,   307,   308,   309,   310,   311,   312,   313,
     314,   315,   316,     0,   317,   318,   319,   320,     0,   321,
     322,   323,   324,     0,   325,   326,     0,     0,     0,     0,
     327,   328,   329,   330,   331,   332,     0,     0,   333,   334,
       0,   335,     0,   336,     0,   337,   338,   339,   340,   341,
     342,   343,   344,   345,     0,     0,   346,   347,     0,     0,
     348,   349,   350,   351,     0,     0,     0,   352,   353,     0,
       0,     0,   354,     0,   355,   356,   357,     0,   358,   359,
     360,   361,     0,   362,   363,     0,     0,     0,     0,     0,
       0,     0,     0,   364,   365,   366,     0,     0,   367,     0,
     368,     0,   369,   370,   371,   372,   373,   374,   375,   376,
     377,   378,     0,     0,   379,   380,   381,     0,   382,     0,
     383,   384,   385,   386,   387,     0,   388,   389,   390,     0,
       0,   391,     0,     0,     0,   392,   393,   394,   395,   396,
       0,     0,   397,   398,   399,   400,   401,     0,   402,   403,
       0,   404,   405,   406,     0,     0,   407,     0,   408,     0,
     409,   410,     0,   411,   412,     0,   413,     0,   414,     0,
       0,   415,   416,   417,   418,   419,   420,   421,   422,   423,
     424,   425,   426,     0,   427,   428,     0,     0,     0,   429,
     430,   431,   432,     0,     0,     0,   433,     0,     0,     0,
     434,     0,   435,   436,   437,   438,   439,   440,     0,   441,
     442,   443,   444,   445,   446,     0,     0,     0,     0,     0,
       0,   447,   448,     0,   449,     0,     0,   450,     0,     0,
     451,   452,     0,     0,     0,   453,     0,     0,   454,   455,
       0,   456,   457,   458,   459,   460,   461,     0,     0,   462,
     463,   464,   465,     0,   466,   467,     0,   468,     0,   469,
     470,   471,   472,     0,     0,   473,   474,     0,   475,   476,
     477,   478,     0,     0,     0,     0,     0,   479,   480,   481,
       0,     0,     0,   482,   483,   484,   485,     0,   486,   487,
       0,   488,   489,     0,   490,   491,     0,     0,   492,     0,
       0,   493,     0,   494,     0,   495,   496,   497,     0,     0,
       0,     0,     0,     0,   498,     0,     0,   499,     0,     0,
       0,   500,   501,   502,   503,   504,   505,   506,     0,     0,
       0,     0,     0,     0,   507,   508,     0,   509,   510,   511,
       0,   142,   512,   143,   144,   145,   146,   147,   148,     0,
       0,   149,     0,     0,     0,   150,     0,     0,   151,     0,
     152,   153,   154,   155,   156,   157,   158,   159,     0,   160,
       0,     0,     0,   161,     0,     0,     0,   162,     0,     0,
     163,   164,   165,     0,   166,     0,   167,   168,     0,     0,
     169,     0,     0,   170,   171,     0,   172,   173,     0,   174,
     175,     0,   176,   177,   178,   179,   180,   181,   182,     0,
     183,   184,   185,   186,   187,   188,   189,     0,   190,   191,
     192,   193,   194,   195,   196,   197,     0,   198,   199,     0,
     200,   201,   202,   203,   204,     0,   205,     0,     0,   206,
       0,     0,   207,     0,   208,     0,     0,   209,     0,   210,
       0,     0,     0,   211,   212,   213,     0,     0,   214,     0,
       0,     0,     0,   215,   216,     0,     0,     0,     0,   217,
       0,   218,     0,     0,     0,   219,     0,   220,   221,   222,
     223,   224,     0,     0,     0,   225,     0,     0,   226,   227,
     228,     0,     0,     0,   229,     0,   230,   231,     0,   232,
     233,   234,     0,     0,   235,   236,     0,   237,   238,   239,
     240,   241,   242,   243,     0,     0,   244,   245,   246,   247,
       0,     0,   248,   249,     0,   250,   251,   252,     0,     0,
     253,     0,     0,     0,   254,     0,   255,     0,   256,     0,
     257,   258,   259,   260,   261,   262,   263,     0,   264,     0,
       0,     0,   265,   266,   267,     0,   268,     0,     0,     0,
     269,   270,     0,     0,     0,   271,   272,   273,   274,   275,
       0,     0,   276,   277,   278,     0,   279,     0,   280,     0,
       0,     0,     0,   281,   282,     0,     0,     0,   283,     0,
     284,   285,     0,   286,   287,     0,     0,     0,   288,     0,
       0,   289,   290,   291,     0,     0,   292,     0,     0,   293,
     294,     0,     0,     0,     0,     0,   295,   296,     0,   297,
       0,   298,     0,   299,   300,     0,     0,     0,     0,     0,
       0,     0,   301,   302,   303,   304,   305,   306,   307,   308,
     309,   310,   311,   312,   313,   314,   315,   316,     0,   317,
     318,   319,   320,     0,   321,   322,   323,   324,     0,   325,
     326,     0,     0,     0,     0,   327,   328,   329,   330,   331,
     332,     0,     0,   333,   334,     0,   335,     0,   336,     0,
     337,   338,   339,   340,   341,   342,   343,   344,   345,     0,
       0,   346,   347,     0,     0,   348,   349,   350,   351,     0,
       0,     0,   352,   353,     0,     0,     0,   354,     0,   355,
     356,   357,     0,   358,   359,   360,   361,     0,   362,   363,
       0,     0,     0,     0,     0,     0,     0,     0,   364,   365,
     366,     0,     0,   367,     0,   368,     0,   369,   370,   371,
     372,   373,   374,   375,   376,   377,   378,     0,     0,   379,
     380,   381,  4318,   382,     0,   383,   384,   385,   386,   387,
       0,   388,   389,   390,     0,     0,   391,     0,     0,     0,
     392,   393,   394,   395,   396,     0,     0,   397,   398,   399,
     400,   401,     0,   402,   403,     0,   404,   405,   406,     0,
       0,   407,     0,   408,     0,   409,   410,     0,   411,   412,
       0,   413,     0,   414,     0,     0,   415,   416,   417,   418,
     419,   420,   421,   422,   423,   424,   425,   426,     0,   427,
     428,     0,     0,     0,   429,   430,   431,   432,     0,     0,
       0,   433,     0,     0,     0,   434,     0,   435,   436,   437,
     438,   439,   440,     0,   441,   442,   443,   444,   445,   446,
       0,     0,     0,     0,     0,     0,   447,   448,     0,   449,
       0,     0,   450,     0,     0,   451,   452,     0,     0,     0,
     453,     0,     0,   454,   455,     0,   456,   457,   458,   459,
     460,   461,     0,     0,   462,   463,   464,   465,     0,   466,
     467,     0,   468,     0,   469,   470,   471,   472,     0,     0,
     473,   474,     0,   475,   476,   477,   478,     0,     0,     0,
       0,     0,   479,   480,   481,     0,     0,     0,   482,   483,
     484,   485,     0,   486,   487,     0,   488,   489,     0,   490,
     491,     0,     0,   492,     0,     0,   493,     0,   494,     0,
     495,   496,   497,     0,     0,     0,     0,     0,     0,   498,
       0,     0,   499,     0,     0,     0,   500,   501,   502,   503,
     504,   505,   506,     0,     0,     0,     0,     0,     0,   507,
     508,     0,   509,   510,   511,     0,   142,   512,   143,   144,
     145,   146,   147,   148,     0,     0,   149,     0,     0,     0,
     150,     0,     0,   151,     0,   152,   153,   154,   155,   156,
     157,   158,   159,     0,   160,     0,     0,     0,   161,     0,
       0,     0,   162,     0,     0,   163,   164,   165,     0,   166,
       0,   167,   168,     0,     0,   169,     0,     0,   170,   171,
       0,   172,   173,     0,   174,   175,     0,   176,   177,   178,
     179,   180,   181,   182,     0,   183,   184,   185,   186,   187,
     188,   189,     0,   190,   191,   192,   193,   194,   195,   196,
     197,     0,   198,   199,     0,   200,   201,   202,   203,   204,
       0,   205,     0,     0,   206,     0,     0,   207,     0,   208,
       0,     0,   209,     0,   210,     0,     0,     0,   211,   212,
     213,     0,     0,   214,     0,     0,     0,     0,   215,   216,
       0,     0,     0,     0,   217,     0,   218,     0,     0,     0,
     219,     0,   220,   221,   222,   223,   224,     0,     0,     0,
     225,     0,     0,   226,   227,   228,     0,     0,     0,   229,
       0,   230,   231,     0,   232,   233,   234,     0,     0,   235,
     236,     0,   237,   238,   239,   240,   241,   242,   243,     0,
       0,   244,   245,   246,   247,     0,     0,   248,   249,     0,
     250,   251,   252,     0,     0,   253,     0,     0,     0,   254,
       0,   255,     0,   256,     0,   257,   258,   259,   260,   261,
     262,   263,     0,   264,     0,     0,     0,   265,   266,   267,
       0,   268,     0,     0,     0,   269,   270,     0,     0,     0,
     271,   272,   273,   274,   275,     0,     0,   276,   277,   278,
       0,   279,     0,   280,     0,     0,     0,     0,   281,   282,
       0,     0,     0,   283,     0,   284,   285,     0,   286,   287,
       0,     0,     0,   288,     0,     0,   289,   290,   291,     0,
       0,   292,     0,     0,   293,   294,     0,     0,     0,     0,
       0,   295,   296,     0,   297,     0,   298,     0,   299,   300,
       0,     0,     0,     0,     0,     0,     0,   301,   302,   303,
     304,   305,   306,   307,   308,   309,   310,   311,   312,   313,
     314,   315,   316,     0,   317,   318,   319,   320,     0,   321,
     322,   323,   324,     0,   325,   326,     0,     0,     0,     0,
     327,   328,   329,   330,   331,   332,     0,     0,   333,   334,
       0,   335,     0,   336,     0,   337,   338,   339,   340,   341,
     342,   343,   344,   345,     0,     0,   346,   347,     0,     0,
     348,   349,   350,   351,     0,     0,     0,   352,   353,     0,
       0,     0,   354,     0,   355,   356,   357,     0,   358,   359,
     360,   361,     0,   362,   363,     0,     0,     0,     0,     0,
       0,     0,     0,   364,   365,   366,     0,     0,   367,     0,
     368,     0,   369,   370,   371,   372,   373,   374,   375,   376,
     377,   378,     0,     0,   379,   380,   381,     0,   382,     0,
     383,   384,   385,   386,   387,     0,   388,   389,   390,     0,
       0,   391,     0,     0,     0,   392,   393,   394,   395,   396,
       0,     0,   397,   398,   399,   400,   401,     0,   402,   403,
       0,   404,   405,   406,     0,     0,   407,     0,   408,     0,
     409,   410,     0,   411,   412,     0,   413,     0,   414,     0,
       0,   415,   416,   417,   418,   419,   420,   421,   422,   423,
     424,   425,   426,     0,   427,   428,     0,     0,     0,   429,
     430,   431,   432,     0,     0,     0,   433,     0,     0,     0,
     434,     0,   435,   436,   437,   438,   439,   440,     0,   441,
     442,   443,   444,   445,   446,     0,     0,     0,     0,     0,
       0,   447,   448,     0,   449,     0,     0,   450,     0,     0,
     451,   452,     0,     0,     0,   453,     0,     0,   454,   455,
       0,   456,   457,   458,   459,   460,   461,     0,     0,   462,
     463,   464,   465,     0,   466,   467,     0,   468,     0,   469,
     470,   471,   472,     0,     0,   473,   474,     0,   475,   476,
     477,   478,     0,     0,     0,     0,     0,   479,   480,   481,
       0,     0,     0,   482,   483,   484,   485,     0,   486,   487,
       0,   488,   489,     0,   490,   491,     0,     0,   492,     0,
       0,   493,     0,   494,     0,   495,   496,   497,     0,     0,
       0,     0,     0,     0,   498,     0,     0,   499,     0,     0,
       0,   500,   501,   502,   503,   504,   505,   506,     0,     0,
       0,     0,     0,     0,   507,   508,     0,   509,   510,   511,
       0,   142,   512,   143,   144,   145,   146,   147,   148,     0,
       0,   149,     0,     0,     0,   150,     0,     0,   151,     0,
     152,   153,   154,   155,   156,   157,   158,   159,     0,   160,
       0,     0,     0,   161,     0,     0,     0,   162,     0,     0,
     163,   164,   165,     0,   166,     0,   167,   168,     0,     0,
     169,     0,     0,   170,   171,     0,   172,   173,     0,   174,
     175,     0,   176,   177,   178,   179,   180,   181,   182,     0,
     183,   184,   185,   186,   187,   188,   189,     0,   190,   191,
     192,   193,   194,   195,   196,   197,     0,   198,   199,     0,
     200,   201,   202,   203,   204,     0,   205,     0,     0,   206,
       0,     0,   207,     0,   208,     0,     0,   209,     0,   210,
       0,     0,     0,   211,   212,   213,     0,     0,   214,     0,
       0,     0,     0,   215,   216,     0,     0,     0,     0,   217,
       0,   218,     0,     0,     0,   219,     0,   220,   221,   222,
     223,   224,     0,     0,     0,   225,     0,     0,   226,   227,
     228,     0,     0,     0,   229,     0,   230,   231,     0,   232,
     233,   234,     0,     0,   235,   236,     0,   237,   238,   239,
     240,   241,   242,   243,     0,     0,   244,   245,   246,   247,
       0,     0,   248,   249,     0,   250,  1883,   252,     0,     0,
     253,     0,     0,     0,   254,     0,   255,     0,   256,     0,
     257,   258,   259,   260,   261,   262,   263,     0,   264,     0,
       0,     0,   265,   266,   267,     0,   268,     0,     0,     0,
     269,   270,     0,     0,     0,   271,   272,   273,   274,   275,
       0,     0,   276,   277,   278,     0,   279,     0,   280,     0,
       0,     0,     0,   281,   282,     0,     0,     0,   283,     0,
     284,   285,     0,   286,   287,     0,     0,     0,   288,     0,
       0,   289,   290,   291,     0,     0,   292,     0,     0,   293,
     294,     0,     0,     0,     0,     0,   295,   296,     0,   297,
       0,   298,     0,   299,   300,     0,     0,     0,     0,     0,
       0,     0,   301,   302,   303,   304,   305,   306,   307,   308,
     309,   310,   311,   312,   313,   314,   315,   316,     0,   317,
     318,   319,   320,     0,   321,   322,   323,   324,     0,   325,
     326,     0,     0,     0,     0,   327,   328,   329,   330,   331,
     332,     0,     0,   333,   334,     0,   335,     0,   336,     0,
     337,   338,   339,   340,   341,   342,   343,   344,   345,     0,
       0,   346,   347,     0,     0,   348,  1884,   350,   351,     0,
       0,     0,   352,   353,     0,     0,     0,   354,     0,   355,
     356,   357,     0,   358,   359,   360,   361,     0,   362,   363,
       0,     0,     0,     0,     0,     0,     0,     0,   364,   365,
     366,     0,     0,   367,     0,   368,     0,   369,   370,   371,
     372,   373,   374,   375,   376,   377,   378,     0,     0,   379,
     380,   381,     0,   382,     0,   383,   384,   385,   386,   387,
       0,   388,   389,   390,     0,     0,   391,     0,     0,     0,
     392,   393,   394,   395,   396,     0,     0,   397,   398,   399,
     400,   401,     0,   402,   403,     0,   404,   405,   406,     0,
       0,   407,     0,   408,     0,   409,   410,     0,   411,   412,
       0,   413,     0,   414,     0,     0,   415,   416,   417,   418,
     419,   420,   421,   422,   423,   424,   425,   426,     0,   427,
     428,     0,     0,     0,   429,   430,   431,   432,     0,     0,
       0,   433,     0,     0,     0,   434,     0,   435,   436,   437,
     438,   439,   440,     0,   441,   442,   443,   444,   445,   446,
       0,     0,     0,     0,     0,     0,   447,   448,     0,   449,
       0,     0,   450,     0,     0,   451,   452,     0,     0,     0,
     453,     0,     0,   454,   455,     0,   456,   457,   458,   459,
     460,   461,     0,     0,   462,   463,   464,   465,     0,   466,
     467,     0,   468,     0,   469,   470,   471,   472,     0,     0,
     473,   474,     0,   475,   476,   477,   478,     0,     0,     0,
       0,     0,   479,   480,   481,     0,     0,     0,   482,   483,
     484,   485,     0,   486,   487,     0,   488,   489,     0,   490,
     491,     0,     0,   492,     0,     0,   493,     0,   494,     0,
     495,   496,   497,     0,     0,     0,     0,     0,     0,   498,
       0,     0,   499,     0,     0,     0,   500,   501,   502,   503,
     504,   505,   506,     0,     0,     0,     0,     0,     0,   507,
     508,     0,   509,   510,   511,     0,   142,   512,   143,   144,
     145,   146,   147,   148,     0,     0,   149,     0,     0,     0,
     150,     0,     0,     0,     0,   152,   153,   154,   155,   156,
     157,   158,     0,     0,  -372,     0,     0,     0,   161,     0,
       0,     0,   162,     0,     0,   163,   164,   165,     0,   166,
       0,     0,     0,     0,     0,   169,  4145,     0,   170,   171,
       0,   172,     0,     0,     0,     0,     0,   176,   177,   178,
     179,  4146,   181,   182,     0,   183,   184,     0,     0,     0,
       0,     0,     0,   190,     0,   192,     0,   194,   195,   196,
     197,     0,   198,   199,     0,   200,   201,   202,     0,   204,
       0,   205,     0,     0,   206,     0,     0,   207,     0,   208,
       0,     0,   209,     0,   210,     0,     0,     0,   211,   212,
     213,     0,     0,   214,     0,     0,     0,     0,   215,     0,
       0,     0,     0,     0,   217,     0,   218,     0,     0,     0,
     219,     0,   220,   221,   222,   223,   224,     0,     0,     0,
       0,     0,     0,   226,   227,   228,     0,  -342,  -342,   229,
       0,  -342,   231,     0,   232,   233,   234,     0,     0,   235,
     236,     0,   237,   238,   239,   240,   241,     0,     0,     0,
       0,   244,   245,   246,   247,     0,     0,   248,   249,  4147,
     250,   251,   252,     0,     0,     0,     0,     0,     0,   254,
       0,   255,     0,   256,     0,   257,   258,   259,   260,   261,
       0,   263,     0,   264,     0,     0,     0,     0,   266,   267,
       0,     0,     0,     0,     0,     0,   270,     0,     0,     0,
     271,   272,   273,   274,   275,  4148,     0,   276,   277,   278,
       0,   279,     0,   280,     0,     0,     0,     0,   281,     0,
       0,     0,     0,   283,     0,   284,   285,     0,   286,   287,
    4149,     0,     0,   288,     0,     0,     0,   290,   291,     0,
       0,   292,  4150,     0,   293,   294,     0,     0,     0,     0,
       0,   295,   296,     0,   297,     0,   298,     0,   299,   300,
       0,     0,     0,     0,  -327,     0,     0,   301,   302,   303,
     304,   305,   306,   307,   308,   309,   310,   311,   312,   313,
     314,   315,   316,     0,   317,   318,   319,   320,     0,   321,
     322,   323,   324,     0,   325,   326,     0,     0,     0,     0,
     327,   328,   329,   330,   331,   332,     0,     0,   333,   334,
       0,   335,     0,   336,     0,   337,   338,   339,   340,   341,
     342,   343,   344,   345,     0,     0,   346,   347,     0,     0,
     348,   349,   350,   351,     0,     0,     0,     0,   353,     0,
       0,     0,   354,     0,   355,   356,   357,     0,   358,   359,
     360,  4151,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   365,   366,     0,     0,     0,     0,
     368,     0,   369,   370,   371,   372,   373,   374,   375,   376,
     377,     0,     0,     0,     0,   380,   381,     0,   382,     0,
     383,   384,   385,   386,   387,     0,   388,   389,   390,     0,
       0,   391,     0,     0,     0,   392,   393,   394,   395,   396,
       0,     0,   397,   398,   399,   400,   401,     0,   402,     0,
       0,   404,     0,   406,  -327,     0,   407,     0,     0,     0,
     409,     0,     0,   411,   412,     0,   413,  4152,   414,     0,
       0,   415,     0,   417,   418,   419,   420,   421,   422,   423,
       0,   425,   426,     0,   427,     0,     0,     0,     0,   429,
     430,   431,     0,     0,     0,     0,   433,     0,     0,     0,
       0,     0,     0,   436,     0,     0,   439,   440,     0,   441,
       0,   443,     0,   445,   446,     0,     0,     0,     0,     0,
       0,   447,   448,     0,   449,     0,     0,   450,     0,     0,
     451,     0,     0,     0,     0,   453,     0,     0,     0,   455,
       0,   456,   457,   458,   459,   460,   461,     0,     0,   462,
     463,   464,   465,     0,   466,   467,     0,   468,     0,   469,
     470,   471,   472,     0,     0,   473,   474,     0,   475,   476,
     477,   478,     0,     0,     0,     0,     0,   479,   480,   481,
       0,     0,     0,     0,   483,   484,   485,     0,   486,   487,
       0,   488,   489,     0,     0,     0,     0,     0,   492,     0,
       0,   493,     0,     0,     0,   495,   496,   497,     0,     0,
       0,     0,     0,     0,   498,     0,     0,   499,     0,     0,
       0,   500,   501,   502,   503,   504,   505,   506,     0,     0,
    -327,     0,     0,     0,   507,     0,     0,   509,     0,   511,
       0,   142,   512,   143,   144,   145,   146,   147,   148,     0,
       0,   149,     0,     0,     0,   150,     0,     0,     0,     0,
     152,   153,   154,   155,   156,   157,   158,     0,     0,  -372,
       0,     0,     0,   161,     0,     0,     0,   162,     0,     0,
     163,   164,   165,     0,   166,     0,     0,     0,     0,     0,
     169,  4145,     0,   170,   171,     0,   172,     0,     0,     0,
       0,     0,   176,   177,   178,   179,  4146,   181,   182,     0,
     183,   184,     0,     0,     0,     0,     0,     0,   190,     0,
     192,     0,   194,   195,   196,   197,     0,   198,   199,     0,
     200,   201,   202,     0,   204,     0,   205,     0,     0,   206,
       0,     0,   207,     0,   208,     0,     0,   209,     0,   210,
       0,     0,     0,   211,   212,   213,     0,     0,   214,     0,
       0,     0,     0,   215,     0,     0,     0,     0,     0,   217,
       0,   218,     0,     0,     0,   219,     0,   220,   221,   222,
     223,   224,     0,     0,     0,     0,     0,     0,   226,   227,
     228,     0,  -363,     0,   229,     0,  -363,   231,     0,   232,
     233,   234,     0,     0,   235,   236,     0,   237,   238,   239,
     240,   241,     0,     0,     0,     0,   244,   245,   246,   247,
       0,     0,   248,   249,  4147,   250,   251,   252,     0,     0,
       0,     0,     0,     0,   254,     0,   255,     0,   256,     0,
     257,   258,   259,   260,   261,     0,   263,     0,   264,     0,
       0,     0,     0,   266,   267,     0,     0,     0,     0,     0,
       0,   270,     0,     0,     0,   271,   272,   273,   274,   275,
    4148,     0,   276,   277,   278,     0,   279,     0,   280,     0,
       0,     0,     0,   281,     0,     0,     0,     0,   283,     0,
     284,   285,     0,   286,   287,  4149,     0,     0,   288,     0,
       0,     0,   290,   291,     0,     0,   292,  4150,     0,   293,
     294,     0,     0,     0,     0,     0,   295,   296,     0,   297,
       0,   298,     0,   299,   300,     0,     0,     0,     0,  -327,
       0,     0,   301,   302,   303,   304,   305,   306,   307,   308,
     309,   310,   311,   312,   313,   314,   315,   316,     0,   317,
     318,   319,   320,     0,   321,   322,   323,   324,     0,   325,
     326,     0,     0,     0,     0,   327,   328,   329,   330,   331,
     332,     0,     0,   333,   334,     0,   335,     0,   336,     0,
     337,   338,   339,   340,   341,   342,   343,   344,   345,     0,
       0,   346,   347,     0,     0,   348,   349,   350,   351,     0,
       0,     0,     0,   353,     0,     0,     0,   354,     0,   355,
     356,   357,     0,   358,   359,   360,  4151,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   365,
     366,     0,     0,     0,     0,   368,     0,   369,   370,   371,
     372,   373,   374,   375,   376,   377,     0,     0,     0,     0,
     380,   381,     0,   382,     0,   383,   384,   385,   386,   387,
       0,   388,   389,   390,     0,     0,   391,     0,     0,     0,
     392,   393,   394,   395,   396,     0,     0,   397,   398,   399,
     400,   401,     0,   402,     0,     0,   404,     0,   406,  -327,
       0,   407,     0,     0,     0,   409,     0,     0,   411,   412,
       0,   413,  4152,   414,     0,     0,   415,     0,   417,   418,
     419,   420,   421,   422,   423,     0,   425,   426,     0,   427,
       0,     0,     0,     0,   429,   430,   431,     0,     0,     0,
       0,   433,     0,     0,     0,     0,     0,     0,   436,     0,
       0,   439,   440,     0,   441,     0,   443,     0,   445,   446,
       0,     0,     0,     0,     0,     0,   447,   448,     0,   449,
       0,     0,   450,     0,     0,   451,     0,     0,     0,     0,
     453,     0,     0,     0,   455,     0,   456,   457,   458,   459,
     460,   461,     0,     0,   462,   463,   464,   465,     0,   466,
     467,     0,   468,     0,   469,   470,   471,   472,     0,     0,
     473,   474,     0,   475,   476,   477,   478,     0,     0,     0,
       0,     0,   479,   480,   481,     0,     0,     0,     0,   483,
     484,   485,     0,   486,   487,     0,   488,   489,     0,     0,
       0,     0,     0,   492,     0,     0,   493,     0,     0,     0,
     495,   496,   497,     0,     0,     0,     0,     0,     0,   498,
       0,     0,   499,     0,     0,     0,   500,   501,   502,   503,
     504,   505,   506,  -363,     0,  -327,     0,     0,     0,   507,
       0,     0,   509,     0,   511,     0,   142,   512,   143,   144,
     145,   146,   147,   148,     0,     0,   149,     0,     0,     0,
     150,     0,     0,     0,     0,   152,   153,   154,   155,   156,
     157,   158,     0,     0,  -372,     0,     0,     0,   161,     0,
       0,     0,   162,     0,     0,   163,   164,   165,     0,   166,
       0,     0,     0,     0,     0,   169,  4145,     0,   170,   171,
       0,   172,     0,     0,     0,     0,     0,   176,   177,   178,
     179,  4146,   181,   182,     0,   183,   184,     0,     0,     0,
       0,     0,     0,   190,     0,   192,     0,   194,   195,   196,
     197,     0,   198,   199,     0,   200,   201,   202,     0,   204,
       0,   205,     0,     0,   206,     0,     0,   207,     0,   208,
       0,     0,   209,     0,   210,     0,     0,     0,   211,   212,
     213,     0,     0,   214,     0,     0,     0,     0,   215,     0,
       0,     0,     0,     0,   217,     0,   218,     0,     0,     0,
     219,     0,   220,   221,   222,   223,   224,     0,     0,     0,
       0,     0,     0,   226,   227,   228,     0,  -360,     0,   229,
       0,  -360,   231,     0,   232,   233,   234,     0,     0,   235,
     236,     0,   237,   238,   239,   240,   241,     0,     0,     0,
       0,   244,   245,   246,   247,     0,     0,   248,   249,  4147,
     250,   251,   252,     0,     0,     0,     0,     0,     0,   254,
       0,   255,     0,   256,     0,   257,   258,   259,   260,   261,
       0,   263,     0,   264,     0,     0,     0,     0,   266,   267,
       0,     0,     0,     0,     0,     0,   270,     0,     0,     0,
     271,   272,   273,   274,   275,  4148,     0,   276,   277,   278,
       0,   279,     0,   280,     0,     0,     0,     0,   281,     0,
       0,     0,     0,   283,     0,   284,   285,     0,   286,   287,
    4149,     0,     0,   288,     0,     0,     0,   290,   291,     0,
       0,   292,  4150,     0,   293,   294,     0,     0,     0,     0,
       0,   295,   296,     0,   297,     0,   298,     0,   299,   300,
       0,     0,     0,     0,  -327,     0,     0,   301,   302,   303,
     304,   305,   306,   307,   308,   309,   310,   311,   312,   313,
     314,   315,   316,     0,   317,   318,   319,   320,     0,   321,
     322,   323,   324,     0,   325,   326,     0,     0,     0,     0,
     327,   328,   329,   330,   331,   332,     0,     0,   333,   334,
       0,   335,     0,   336,     0,   337,   338,   339,   340,   341,
     342,   343,   344,   345,     0,     0,   346,   347,     0,     0,
     348,   349,   350,   351,     0,     0,     0,     0,   353,     0,
       0,     0,   354,     0,   355,   356,   357,     0,   358,   359,
     360,  4151,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   365,   366,     0,     0,     0,     0,
     368,     0,   369,   370,   371,   372,   373,   374,   375,   376,
     377,     0,     0,     0,     0,   380,   381,     0,   382,     0,
     383,   384,   385,   386,   387,     0,   388,   389,   390,     0,
       0,   391,     0,     0,     0,   392,   393,   394,   395,   396,
       0,     0,   397,   398,   399,   400,   401,     0,   402,     0,
       0,   404,     0,   406,  -327,     0,   407,     0,     0,     0,
     409,     0,     0,   411,   412,     0,   413,  4152,   414,     0,
       0,   415,     0,   417,   418,   419,   420,   421,   422,   423,
       0,   425,   426,     0,   427,     0,     0,     0,     0,   429,
     430,   431,     0,     0,     0,     0,   433,     0,     0,     0,
       0,     0,     0,   436,     0,     0,   439,   440,     0,   441,
       0,   443,     0,   445,   446,     0,     0,     0,     0,     0,
       0,   447,   448,     0,   449,     0,     0,   450,     0,     0,
     451,     0,     0,     0,     0,   453,     0,     0,     0,   455,
       0,   456,   457,   458,   459,   460,   461,     0,     0,   462,
     463,   464,   465,     0,   466,   467,     0,   468,     0,   469,
     470,   471,   472,     0,     0,   473,   474,     0,   475,   476,
     477,   478,     0,     0,     0,     0,     0,   479,   480,   481,
       0,     0,     0,     0,   483,   484,   485,     0,   486,   487,
       0,   488,   489,     0,     0,     0,     0,     0,   492,     0,
       0,   493,     0,     0,     0,   495,   496,   497,     0,     0,
       0,     0,     0,     0,   498,     0,     0,   499,     0,     0,
       0,   500,   501,   502,   503,   504,   505,   506,  -360,     0,
    -327,     0,     0,     0,   507,     0,     0,   509,     0,   511,
       0,   142,   512,   143,   144,   145,   146,   147,   148,     0,
       0,   149,     0,     0,     0,   150,     0,     0,     0,     0,
     152,   153,   154,   155,   156,   157,   158,     0,     0,  -372,
       0,     0,     0,   161,     0,     0,     0,   162,     0,     0,
     163,   164,   165,     0,   166,     0,     0,     0,     0,     0,
     169,  4145,     0,   170,   171,     0,   172,     0,     0,     0,
       0,     0,   176,   177,   178,   179,  4146,   181,   182,     0,
     183,   184,     0,     0,     0,     0,     0,     0,   190,     0,
     192,     0,   194,   195,   196,   197,     0,   198,   199,     0,
     200,   201,   202,     0,   204,     0,   205,     0,     0,   206,
       0,     0,   207,     0,   208,     0,     0,   209,     0,   210,
       0,     0,     0,   211,   212,   213,     0,     0,   214,     0,
       0,     0,     0,   215,     0,     0,     0,     0,     0,   217,
       0,   218,     0,     0,     0,   219,     0,   220,   221,   222,
     223,   224,     0,     0,     0,     0,     0,     0,   226,   227,
     228,     0,     0,     0,   229,     0,  4527,   231,     0,   232,
     233,   234,     0,     0,   235,   236,     0,   237,   238,   239,
     240,   241,     0,     0,     0,     0,   244,   245,   246,   247,
       0,     0,   248,   249,  4147,   250,   251,   252,     0,     0,
       0,     0,     0,     0,   254,     0,   255,     0,   256,     0,
     257,   258,   259,   260,   261,     0,   263,     0,   264,     0,
       0,     0,     0,   266,   267,     0,     0,     0,     0,     0,
       0,   270,     0,     0,     0,   271,   272,   273,   274,   275,
    4148,     0,   276,   277,   278,     0,   279,     0,   280,     0,
       0,     0,     0,   281,     0,     0,     0,     0,   283,     0,
     284,   285,     0,   286,   287,  4149,     0,     0,   288,     0,
       0,     0,   290,   291,     0,     0,   292,  4150,     0,   293,
     294,     0,     0,     0,     0,     0,   295,   296,     0,   297,
       0,   298,     0,   299,   300,     0,     0,     0,     0,  -327,
       0,     0,   301,   302,   303,   304,   305,   306,   307,   308,
     309,   310,   311,   312,   313,   314,   315,   316,     0,   317,
     318,   319,   320,     0,   321,   322,   323,   324,     0,   325,
     326,     0,     0,     0,     0,   327,   328,   329,   330,   331,
     332,     0,     0,   333,   334,     0,   335,     0,   336,     0,
     337,   338,   339,   340,   341,   342,   343,   344,   345,     0,
       0,   346,   347,     0,     0,   348,   349,   350,   351,     0,
       0,     0,     0,   353,     0,     0,     0,   354,     0,   355,
     356,   357,     0,   358,   359,   360,  4151,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   365,
     366,     0,     0,     0,     0,   368,     0,   369,   370,   371,
     372,   373,   374,   375,   376,   377,     0,     0,     0,     0,
     380,   381,     0,   382,     0,   383,   384,   385,   386,   387,
       0,   388,   389,   390,     0,     0,   391,     0,     0,     0,
     392,   393,   394,   395,   396,     0,     0,   397,   398,   399,
     400,   401,     0,   402,     0,     0,   404,     0,   406,  -327,
       0,   407,     0,     0,     0,   409,     0,     0,   411,   412,
       0,   413,  4152,   414,     0,     0,   415,     0,   417,   418,
     419,   420,   421,   422,   423,     0,   425,   426,     0,   427,
       0,     0,     0,     0,   429,   430,   431,     0,     0,     0,
       0,   433,     0,     0,     0,     0,     0,     0,   436,     0,
       0,   439,   440,     0,   441,     0,   443,     0,   445,   446,
       0,     0,     0,     0,     0,     0,   447,   448,     0,   449,
       0,     0,   450,     0,     0,   451,     0,     0,     0,     0,
     453,     0,     0,     0,   455,     0,   456,   457,   458,   459,
     460,   461,     0,     0,   462,   463,   464,   465,     0,   466,
     467,     0,   468,     0,   469,   470,   471,   472,     0,     0,
     473,   474,     0,   475,   476,   477,   478,     0,     0,     0,
       0,     0,   479,   480,   481,     0,     0,     0,     0,   483,
     484,   485,     0,   486,   487,     0,   488,   489,     0,     0,
       0,     0,     0,   492,     0,     0,   493,     0,     0,     0,
     495,   496,   497,     0,     0,     0,     0,     0,     0,   498,
       0,     0,   499,     0,     0,     0,   500,   501,   502,   503,
     504,   505,   506,     0,     0,  -327,     0,     0,     0,   507,
       0,     0,   509,     0,   511,     0,   142,   512,   143,   144,
     145,   146,   147,   148,     0,     0,   149,     0,     0,     0,
     150,     0,     0,     0,     0,   152,   153,   154,   155,   156,
     157,   158,     0,     0,  -372,     0,     0,     0,   161,     0,
       0,     0,   162,     0,     0,   163,   164,   165,     0,   166,
       0,     0,     0,     0,     0,   169,  4145,     0,   170,   171,
       0,   172,     0,     0,     0,     0,     0,   176,   177,   178,
     179,  4146,   181,   182,     0,   183,   184,     0,     0,     0,
       0,     0,     0,   190,     0,   192,     0,   194,   195,   196,
     197,     0,   198,   199,     0,   200,   201,   202,     0,   204,
       0,   205,     0,     0,   206,     0,     0,   207,     0,   208,
       0,     0,   209,     0,   210,     0,     0,     0,   211,   212,
     213,     0,     0,   214,     0,     0,     0,     0,   215,     0,
       0,     0,     0,     0,   217,     0,   218,     0,     0,     0,
     219,     0,   220,   221,   222,   223,   224,     0,     0,     0,
       0,     0,     0,   226,   227,   228,     0,     0,     0,   229,
       0,  -365,   231,     0,   232,   233,   234,     0,     0,   235,
     236,     0,   237,   238,   239,   240,   241,     0,     0,     0,
       0,   244,   245,   246,   247,     0,     0,   248,   249,  4147,
     250,   251,   252,     0,     0,     0,     0,     0,     0,   254,
       0,   255,     0,   256,     0,   257,   258,   259,   260,   261,
       0,   263,     0,   264,     0,     0,     0,     0,   266,   267,
       0,     0,     0,     0,     0,     0,   270,     0,     0,     0,
     271,   272,   273,   274,   275,  4148,     0,   276,   277,   278,
       0,   279,     0,   280,     0,     0,     0,     0,   281,     0,
       0,     0,     0,   283,     0,   284,   285,     0,   286,   287,
    4149,     0,     0,   288,     0,     0,     0,   290,   291,     0,
       0,   292,  4150,     0,   293,   294,     0,     0,     0,     0,
       0,   295,   296,     0,   297,     0,   298,     0,   299,   300,
       0,     0,     0,     0,  -327,     0,     0,   301,   302,   303,
     304,   305,   306,   307,   308,   309,   310,   311,   312,   313,
     314,   315,   316,     0,   317,   318,   319,   320,     0,   321,
     322,   323,   324,     0,   325,   326,     0,     0,     0,     0,
     327,   328,   329,   330,   331,   332,     0,     0,   333,   334,
       0,   335,     0,   336,     0,   337,   338,   339,   340,   341,
     342,   343,   344,   345,     0,     0,   346,   347,     0,     0,
     348,   349,   350,   351,     0,     0,     0,     0,   353,     0,
       0,     0,   354,     0,   355,   356,   357,     0,   358,   359,
     360,  4151,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   365,   366,     0,     0,     0,     0,
     368,     0,   369,   370,   371,   372,   373,   374,   375,   376,
     377,     0,     0,     0,     0,   380,   381,     0,   382,     0,
     383,   384,   385,   386,   387,     0,   388,   389,   390,     0,
       0,   391,     0,     0,     0,   392,   393,   394,   395,   396,
       0,     0,   397,   398,   399,   400,   401,     0,   402,     0,
       0,   404,     0,   406,  -327,     0,   407,     0,     0,     0,
     409,     0,     0,   411,   412,     0,   413,  4152,   414,     0,
       0,   415,     0,   417,   418,   419,   420,   421,   422,   423,
       0,   425,   426,     0,   427,     0,     0,     0,     0,   429,
     430,   431,     0,     0,     0,     0,   433,     0,     0,     0,
       0,     0,     0,   436,     0,     0,   439,   440,     0,   441,
       0,   443,     0,   445,   446,     0,     0,     0,     0,     0,
       0,   447,   448,     0,   449,     0,     0,   450,     0,     0,
     451,     0,     0,     0,     0,   453,     0,     0,     0,   455,
       0,   456,   457,   458,   459,   460,   461,     0,     0,   462,
     463,   464,   465,     0,   466,   467,     0,   468,     0,   469,
     470,   471,   472,     0,     0,   473,   474,     0,   475,   476,
     477,   478,     0,     0,     0,     0,     0,   479,   480,   481,
       0,     0,     0,     0,   483,   484,   485,     0,   486,   487,
       0,   488,   489,     0,     0,     0,     0,     0,   492,     0,
       0,   493,     0,     0,     0,   495,   496,   497,     0,     0,
       0,     0,     0,     0,   498,     0,     0,   499,     0,     0,
       0,   500,   501,   502,   503,   504,   505,   506,     0,     0,
    -327,     0,     0,     0,   507,     0,     0,   509,     0,   511,
       0,   142,   512,   143,   144,   145,   146,   147,   148,     0,
       0,   149,     0,     0,     0,   150,     0,     0,     0,     0,
     152,   153,   154,   155,   156,   157,   158,     0,     0,  -372,
       0,     0,     0,   161,     0,     0,     0,   162,     0,     0,
     163,   164,   165,     0,   166,     0,     0,     0,     0,     0,
     169,  4145,     0,   170,   171,     0,   172,     0,     0,     0,
       0,     0,   176,   177,   178,   179,  4146,   181,   182,     0,
     183,   184,     0,     0,     0,     0,     0,     0,   190,     0,
     192,     0,   194,   195,   196,   197,     0,   198,   199,     0,
     200,   201,   202,     0,   204,     0,   205,     0,     0,   206,
       0,     0,   207,     0,   208,     0,     0,   209,     0,   210,
       0,     0,     0,   211,   212,   213,     0,     0,   214,     0,
       0,     0,     0,   215,     0,     0,     0,     0,     0,   217,
       0,   218,     0,     0,     0,   219,     0,   220,   221,   222,
     223,   224,     0,     0,     0,     0,     0,     0,   226,   227,
     228,     0,     0,     0,   229,     0,  4660,   231,     0,   232,
     233,   234,     0,     0,   235,   236,     0,   237,   238,   239,
     240,   241,     0,     0,     0,     0,   244,   245,   246,   247,
       0,     0,   248,   249,  4147,   250,   251,   252,     0,     0,
       0,     0,     0,     0,   254,     0,   255,     0,   256,     0,
     257,   258,   259,   260,   261,     0,   263,     0,   264,     0,
       0,     0,     0,   266,   267,     0,     0,     0,     0,     0,
       0,   270,     0,     0,     0,   271,   272,   273,   274,   275,
    4148,     0,   276,   277,   278,     0,   279,     0,   280,     0,
       0,     0,     0,   281,     0,     0,     0,     0,   283,     0,
     284,   285,     0,   286,   287,  4149,     0,     0,   288,     0,
       0,     0,   290,   291,     0,     0,   292,  4150,     0,   293,
     294,     0,     0,     0,     0,     0,   295,   296,     0,   297,
       0,   298,     0,   299,   300,     0,     0,     0,     0,  -327,
       0,     0,   301,   302,   303,   304,   305,   306,   307,   308,
     309,   310,   311,   312,   313,   314,   315,   316,     0,   317,
     318,   319,   320,     0,   321,   322,   323,   324,     0,   325,
     326,     0,     0,     0,     0,   327,   328,   329,   330,   331,
     332,     0,     0,   333,   334,     0,   335,     0,   336,     0,
     337,   338,   339,   340,   341,   342,   343,   344,   345,     0,
       0,   346,   347,     0,     0,   348,   349,   350,   351,     0,
       0,     0,     0,   353,     0,     0,     0,   354,     0,   355,
     356,   357,     0,   358,   359,   360,  4151,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   365,
     366,     0,     0,     0,     0,   368,     0,   369,   370,   371,
     372,   373,   374,   375,   376,   377,     0,     0,     0,     0,
     380,   381,     0,   382,     0,   383,   384,   385,   386,   387,
       0,   388,   389,   390,     0,     0,   391,     0,     0,     0,
     392,   393,   394,   395,   396,     0,     0,   397,   398,   399,
     400,   401,     0,   402,     0,     0,   404,     0,   406,  -327,
       0,   407,     0,     0,     0,   409,     0,     0,   411,   412,
       0,   413,  4152,   414,     0,     0,   415,     0,   417,   418,
     419,   420,   421,   422,   423,     0,   425,   426,     0,   427,
       0,     0,     0,     0,   429,   430,   431,     0,     0,     0,
       0,   433,     0,     0,     0,     0,     0,     0,   436,     0,
       0,   439,   440,     0,   441,     0,   443,     0,   445,   446,
       0,     0,     0,     0,     0,     0,   447,   448,     0,   449,
       0,     0,   450,     0,     0,   451,     0,     0,     0,     0,
     453,     0,     0,     0,   455,     0,   456,   457,   458,   459,
     460,   461,     0,     0,   462,   463,   464,   465,     0,   466,
     467,     0,   468,     0,   469,   470,   471,   472,     0,     0,
     473,   474,     0,   475,   476,   477,   478,     0,     0,     0,
       0,     0,   479,   480,   481,     0,     0,     0,     0,   483,
     484,   485,     0,   486,   487,     0,   488,   489,     0,     0,
       0,     0,     0,   492,     0,     0,   493,     0,     0,     0,
     495,   496,   497,     0,     0,     0,     0,     0,     0,   498,
       0,     0,   499,     0,     0,     0,   500,   501,   502,   503,
     504,   505,   506,     0,     0,  -327,     0,     0,     0,   507,
       0,     0,   509,     0,   511,     0,   142,   512,   143,   144,
     145,   146,   147,   148,     0,     0,   149,     0,     0,     0,
     150,     0,     0,     0,     0,   152,   153,   154,   155,   156,
     157,   158,     0,     0,  -372,     0,     0,     0,   161,     0,
       0,     0,   162,     0,     0,   163,   164,   165,     0,   166,
       0,     0,     0,     0,     0,   169,  4145,     0,   170,   171,
       0,   172,     0,     0,     0,     0,     0,   176,   177,   178,
     179,  4146,   181,   182,     0,   183,   184,     0,     0,     0,
       0,     0,     0,   190,     0,   192,     0,   194,   195,   196,
     197,     0,   198,   199,     0,   200,   201,   202,     0,   204,
       0,   205,     0,     0,   206,     0,     0,   207,     0,   208,
       0,     0,   209,     0,   210,     0,     0,     0,   211,   212,
     213,     0,     0,   214,     0,     0,     0,     0,   215,     0,
       0,     0,     0,     0,   217,     0,   218,     0,     0,     0,
     219,     0,   220,   221,   222,   223,   224,     0,     0,     0,
       0,     0,     0,   226,   227,   228,     0,     0,     0,   229,
       0,  4718,   231,     0,   232,   233,   234,     0,     0,   235,
     236,     0,   237,   238,   239,   240,   241,     0,     0,     0,
       0,   244,   245,   246,   247,     0,     0,   248,   249,  4147,
     250,   251,   252,     0,     0,     0,     0,     0,     0,   254,
       0,   255,     0,   256,     0,   257,   258,   259,   260,   261,
       0,   263,     0,   264,     0,     0,     0,     0,   266,   267,
       0,     0,     0,     0,     0,     0,   270,     0,     0,     0,
     271,   272,   273,   274,   275,  4148,     0,   276,   277,   278,
       0,   279,     0,   280,     0,     0,     0,     0,   281,     0,
       0,     0,     0,   283,     0,   284,   285,     0,   286,   287,
    4149,     0,     0,   288,     0,     0,     0,   290,   291,     0,
       0,   292,  4150,     0,   293,   294,     0,     0,     0,     0,
       0,   295,   296,     0,   297,     0,   298,     0,   299,   300,
       0,     0,     0,     0,  -327,     0,     0,   301,   302,   303,
     304,   305,   306,   307,   308,   309,   310,   311,   312,   313,
     314,   315,   316,     0,   317,   318,   319,   320,     0,   321,
     322,   323,   324,     0,   325,   326,     0,     0,     0,     0,
     327,   328,   329,   330,   331,   332,     0,     0,   333,   334,
       0,   335,     0,   336,     0,   337,   338,   339,   340,   341,
     342,   343,   344,   345,     0,     0,   346,   347,     0,     0,
     348,   349,   350,   351,     0,     0,     0,     0,   353,     0,
       0,     0,   354,     0,   355,   356,   357,     0,   358,   359,
     360,  4151,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   365,   366,     0,     0,     0,     0,
     368,     0,   369,   370,   371,   372,   373,   374,   375,   376,
     377,     0,     0,     0,     0,   380,   381,     0,   382,     0,
     383,   384,   385,   386,   387,     0,   388,   389,   390,     0,
       0,   391,     0,     0,     0,   392,   393,   394,   395,   396,
       0,     0,   397,   398,   399,   400,   401,     0,   402,     0,
       0,   404,     0,   406,  -327,     0,   407,     0,     0,     0,
     409,     0,     0,   411,   412,     0,   413,  4152,   414,     0,
       0,   415,     0,   417,   418,   419,   420,   421,   422,   423,
       0,   425,   426,     0,   427,     0,     0,     0,     0,   429,
     430,   431,     0,     0,     0,     0,   433,     0,     0,     0,
       0,     0,     0,   436,     0,     0,   439,   440,     0,   441,
       0,   443,     0,   445,   446,     0,     0,     0,     0,     0,
       0,   447,   448,     0,   449,     0,     0,   450,     0,     0,
     451,     0,     0,     0,     0,   453,     0,     0,     0,   455,
       0,   456,   457,   458,   459,   460,   461,     0,     0,   462,
     463,   464,   465,     0,   466,   467,     0,   468,     0,   469,
     470,   471,   472,     0,     0,   473,   474,     0,   475,   476,
     477,   478,     0,     0,     0,     0,     0,   479,   480,   481,
       0,     0,     0,     0,   483,   484,   485,     0,   486,   487,
       0,   488,   489,     0,     0,     0,     0,     0,   492,     0,
       0,   493,     0,     0,     0,   495,   496,   497,     0,     0,
       0,     0,     0,     0,   498,     0,     0,   499,     0,     0,
       0,   500,   501,   502,   503,   504,   505,   506,     0,     0,
    -327,     0,     0,     0,   507,     0,     0,   509,     0,   511,
       0,   142,   512,   143,   144,   145,   146,   147,   148,     0,
       0,   149,     0,     0,     0,   150,     0,     0,     0,     0,
     152,   153,   154,   155,   156,   157,   158,     0,     0,  -372,
       0,     0,     0,   161,     0,     0,     0,   162,     0,     0,
     163,   164,   165,     0,   166,     0,     0,     0,     0,     0,
     169,  4145,     0,   170,   171,     0,   172,     0,     0,     0,
       0,     0,   176,   177,   178,   179,  4146,   181,   182,     0,
     183,   184,     0,     0,     0,     0,     0,     0,   190,     0,
     192,     0,   194,   195,   196,   197,     0,   198,   199,     0,
     200,   201,   202,     0,   204,     0,   205,     0,     0,   206,
       0,     0,   207,     0,   208,     0,     0,   209,     0,   210,
       0,     0,     0,   211,   212,   213,     0,     0,   214,     0,
       0,     0,     0,   215,     0,     0,     0,     0,     0,   217,
       0,   218,     0,     0,     0,   219,     0,   220,   221,   222,
     223,   224,     0,     0,     0,     0,     0,     0,   226,   227,
     228,     0,     0,     0,   229,     0,  -346,   231,     0,   232,
     233,   234,     0,     0,   235,   236,     0,   237,   238,   239,
     240,   241,     0,     0,     0,     0,   244,   245,   246,   247,
       0,     0,   248,   249,  4147,   250,   251,   252,     0,     0,
       0,     0,     0,     0,   254,     0,   255,     0,   256,     0,
     257,   258,   259,   260,   261,     0,   263,     0,   264,     0,
       0,     0,     0,   266,   267,     0,     0,     0,     0,     0,
       0,   270,     0,     0,     0,   271,   272,   273,   274,   275,
    4148,     0,   276,   277,   278,     0,   279,     0,   280,     0,
       0,     0,     0,   281,     0,     0,     0,     0,   283,     0,
     284,   285,     0,   286,   287,  4149,     0,     0,   288,     0,
       0,     0,   290,   291,     0,     0,   292,  4150,     0,   293,
     294,     0,     0,     0,     0,     0,   295,   296,     0,   297,
       0,   298,     0,   299,   300,     0,     0,     0,     0,  -327,
       0,     0,   301,   302,   303,   304,   305,   306,   307,   308,
     309,   310,   311,   312,   313,   314,   315,   316,     0,   317,
     318,   319,   320,     0,   321,   322,   323,   324,     0,   325,
     326,     0,     0,     0,     0,   327,   328,   329,   330,   331,
     332,     0,     0,   333,   334,     0,   335,     0,   336,     0,
     337,   338,   339,   340,   341,   342,   343,   344,   345,     0,
       0,   346,   347,     0,     0,   348,   349,   350,   351,     0,
       0,     0,     0,   353,     0,     0,     0,   354,     0,   355,
     356,   357,     0,   358,   359,   360,  4151,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   365,
     366,     0,     0,     0,     0,   368,     0,   369,   370,   371,
     372,   373,   374,   375,   376,   377,     0,     0,     0,     0,
     380,   381,     0,   382,     0,   383,   384,   385,   386,   387,
       0,   388,   389,   390,     0,     0,   391,     0,     0,     0,
     392,   393,   394,   395,   396,     0,     0,   397,   398,   399,
     400,   401,     0,   402,     0,     0,   404,     0,   406,  -327,
       0,   407,     0,     0,     0,   409,     0,     0,   411,   412,
       0,   413,  4152,   414,     0,     0,   415,     0,   417,   418,
     419,   420,   421,   422,   423,     0,   425,   426,     0,   427,
       0,     0,     0,     0,   429,   430,   431,     0,     0,     0,
       0,   433,     0,     0,     0,     0,     0,     0,   436,     0,
       0,   439,   440,     0,   441,     0,   443,     0,   445,   446,
       0,     0,     0,     0,     0,     0,   447,   448,     0,   449,
       0,     0,   450,     0,     0,   451,     0,     0,     0,     0,
     453,     0,     0,     0,   455,     0,   456,   457,   458,   459,
     460,   461,     0,     0,   462,   463,   464,   465,     0,   466,
     467,     0,   468,     0,   469,   470,   471,   472,     0,     0,
     473,   474,     0,   475,   476,   477,   478,     0,     0,     0,
       0,     0,   479,   480,   481,     0,     0,     0,     0,   483,
     484,   485,     0,   486,   487,     0,   488,   489,     0,     0,
       0,     0,     0,   492,     0,     0,   493,     0,     0,     0,
     495,   496,   497,     0,     0,     0,     0,     0,     0,   498,
       0,     0,   499,     0,     0,     0,   500,   501,   502,   503,
     504,   505,   506,     0,     0,  -327,     0,     0,     0,   507,
       0,     0,   509,     0,   511,     0,   142,   512,   143,   144,
     145,   146,   147,   148,     0,     0,   149,     0,     0,     0,
     150,     0,     0,     0,     0,   152,   153,   154,   155,   156,
     157,   158,     0,     0,  -372,     0,     0,     0,   161,     0,
       0,     0,   162,     0,     0,   163,   164,   165,     0,   166,
       0,     0,     0,     0,     0,   169,  4145,     0,   170,   171,
       0,   172,     0,     0,     0,     0,     0,   176,   177,   178,
     179,  4146,   181,   182,     0,   183,   184,     0,     0,     0,
       0,     0,     0,   190,     0,   192,     0,   194,   195,   196,
     197,     0,   198,   199,     0,   200,   201,   202,     0,   204,
       0,   205,     0,     0,   206,     0,     0,   207,     0,   208,
       0,     0,   209,     0,   210,     0,     0,     0,   211,   212,
     213,     0,     0,   214,     0,     0,     0,     0,   215,     0,
       0,     0,     0,     0,   217,     0,   218,     0,     0,     0,
     219,     0,   220,   221,   222,   223,   224,     0,     0,     0,
       0,     0,     0,   226,   227,   228,     0,     0,     0,   229,
       0,     0,   231,     0,   232,   233,   234,     0,     0,   235,
     236,     0,   237,   238,   239,   240,   241,     0,     0,     0,
       0,   244,   245,   246,   247,     0,     0,   248,   249,  4147,
     250,   251,   252,     0,     0,     0,     0,     0,     0,   254,
       0,   255,     0,   256,     0,   257,   258,   259,   260,   261,
       0,   263,     0,   264,     0,     0,     0,     0,   266,   267,
       0,     0,     0,     0,     0,     0,   270,     0,     0,     0,
     271,   272,   273,   274,   275,  4148,     0,   276,   277,   278,
       0,   279,     0,   280,     0,     0,     0,     0,   281,     0,
       0,     0,     0,   283,     0,   284,   285,     0,   286,   287,
    4149,     0,     0,   288,     0,     0,     0,   290,   291,     0,
       0,   292,  4150,     0,   293,   294,     0,     0,     0,     0,
       0,   295,   296,     0,   297,     0,   298,     0,   299,   300,
       0,     0,     0,     0,  -327,     0,     0,   301,   302,   303,
     304,   305,   306,   307,   308,   309,   310,   311,   312,   313,
     314,   315,   316,     0,   317,   318,   319,   320,     0,   321,
     322,   323,   324,     0,   325,   326,     0,     0,     0,     0,
     327,   328,   329,   330,   331,   332,     0,     0,   333,   334,
       0,   335,     0,   336,     0,   337,   338,   339,   340,   341,
     342,   343,   344,   345,     0,     0,   346,   347,     0,     0,
     348,   349,   350,   351,     0,     0,     0,     0,   353,     0,
       0,     0,   354,     0,   355,   356,   357,     0,   358,   359,
     360,  4151,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   365,   366,     0,     0,     0,     0,
     368,     0,   369,   370,   371,   372,   373,   374,   375,   376,
     377,     0,     0,     0,     0,   380,   381,     0,   382,     0,
     383,   384,   385,   386,   387,     0,   388,   389,   390,     0,
       0,   391,     0,     0,     0,   392,   393,   394,   395,   396,
       0,     0,   397,   398,   399,   400,   401,     0,   402,     0,
       0,   404,     0,   406,  -327,     0,   407,     0,     0,     0,
     409,     0,     0,   411,   412,     0,   413,  4152,   414,     0,
       0,   415,     0,   417,   418,   419,   420,   421,   422,   423,
       0,   425,   426,     0,   427,     0,     0,     0,     0,   429,
     430,   431,     0,     0,     0,     0,   433,     0,     0,     0,
       0,     0,     0,   436,     0,     0,   439,   440,     0,   441,
       0,   443,     0,   445,   446,     0,     0,     0,     0,     0,
       0,   447,   448,     0,   449,     0,     0,   450,     0,     0,
     451,     0,     0,     0,     0,   453,     0,     0,     0,   455,
       0,   456,   457,   458,   459,   460,   461,     0,     0,   462,
     463,   464,   465,     0,   466,   467,     0,   468,     0,   469,
     470,   471,   472,     0,     0,   473,   474,     0,   475,   476,
     477,   478,     0,     0,     0,     0,     0,   479,   480,   481,
       0,     0,     0,     0,   483,   484,   485,     0,   486,   487,
       0,   488,   489,     0,     0,     0,     0,     0,   492,     0,
       0,   493,     0,     0,     0,   495,   496,   497,     0,     0,
       0,     0,     0,     0,   498,     0,     0,   499,     0,     0,
       0,   500,   501,   502,   503,   504,   505,   506,     0,     0,
    -327,     0,     0,     0,   507,     0,     0,   509,     0,   511,
       0,   142,   512,   143,   144,   145,   146,   147,   148,     0,
       0,   149,     0,     0,     0,   150,     0,     0,     0,     0,
     152,   153,   154,   155,   156,   157,   158,     0,     0,  -372,
       0,     0,     0,   161,     0,     0,     0,   162,     0,     0,
     163,   164,   165,     0,   166,     0,     0,     0,     0,     0,
     169,  4145,     0,   170,   171,     0,   172,     0,     0,     0,
       0,     0,   176,   177,   178,   179,  4146,   181,   182,     0,
     183,   184,     0,     0,     0,     0,     0,     0,   190,     0,
     192,     0,   194,   195,   196,   197,     0,   198,   199,     0,
     200,   201,   202,     0,   204,     0,   205,     0,     0,   206,
       0,     0,   207,     0,   208,     0,     0,   209,     0,   210,
       0,     0,     0,   211,   212,   213,     0,     0,   214,     0,
       0,     0,     0,   215,     0,     0,     0,     0,     0,   217,
       0,   218,     0,     0,     0,   219,     0,   220,   221,   222,
     223,   224,     0,     0,     0,     0,     0,     0,   226,   227,
     228,     0,     0,     0,   229,     0,     0,   231,     0,   232,
     233,   234,     0,     0,   235,   236,     0,   237,   238,   239,
     240,   241,     0,     0,     0,     0,   244,   245,   246,   247,
       0,     0,   248,   249,  4147,   250,   251,   252,     0,     0,
       0,     0,     0,     0,   254,     0,   255,     0,   256,     0,
     257,   258,   259,   260,   261,     0,   263,     0,   264,     0,
       0,     0,     0,   266,   267,     0,     0,     0,     0,     0,
       0,   270,     0,     0,     0,   271,   272,   273,   274,   275,
    4148,     0,   276,   277,   278,     0,   279,     0,   280,     0,
       0,     0,     0,   281,     0,     0,     0,     0,   283,     0,
     284,   285,     0,   286,   287,  4149,     0,     0,   288,     0,
       0,     0,   290,   291,     0,     0,   292,  4150,     0,   293,
     294,     0,     0,     0,     0,     0,   295,   296,     0,   297,
       0,   298,     0,   299,   300,     0,     0,     0,     0,  -327,
       0,     0,   301,   302,   303,   304,   305,   306,   307,   308,
     309,   310,   311,   312,   313,   314,   315,   316,     0,   317,
     318,   319,   320,     0,   321,   322,   323,   324,     0,   325,
     326,     0,     0,     0,     0,   327,   328,   329,   330,   331,
     332,     0,     0,   333,   334,     0,   335,     0,   336,     0,
     337,   338,   339,   340,   341,   342,   343,   344,   345,     0,
       0,   346,   347,     0,     0,   348,   349,   350,   351,     0,
       0,     0,     0,   353,     0,     0,     0,   354,     0,   355,
     356,   357,     0,   358,   359,   360,  4151,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   365,
     366,     0,     0,     0,     0,   368,     0,   369,   370,   371,
     372,   373,   374,   375,   376,   377,     0,     0,     0,     0,
     380,   381,     0,   382,     0,   383,   384,   385,   386,   387,
       0,   388,   389,   390,     0,     0,   391,     0,     0,     0,
     392,   393,   394,   395,   396,     0,     0,   397,   398,   399,
     400,   401,     0,   402,     0,     0,   404,     0,   406,  -327,
       0,   407,     0,     0,     0,   409,     0,     0,   411,   412,
       0,   413,  4152,   414,     0,     0,   415,     0,   417,   418,
     419,   420,   421,   422,   423,     0,   425,   426,     0,   427,
       0,     0,     0,     0,   429,   430,   431,     0,     0,     0,
       0,   433,     0,     0,     0,     0,     0,     0,   436,     0,
       0,   439,   440,     0,   441,     0,   443,     0,   445,   446,
       0,     0,     0,     0,     0,     0,   447,   448,     0,   449,
       0,     0,   450,     0,     0,   451,     0,     0,     0,     0,
     453,     0,     0,     0,   455,     0,   456,   457,   458,   459,
     460,   461,     0,     0,   462,   463,   464,   465,     0,   466,
     467,     0,   468,     0,   469,   470,   471,   472,     0,     0,
     473,   474,     0,   475,   476,   477,   478,     0,     0,     0,
       0,     0,   479,   480,   481,     0,     0,     0,     0,   483,
     484,   485,     0,   486,   487,     0,   488,   489,     0,     0,
       0,     0,     0,   492,     0,     0,  4530,     0,     0,     0,
     495,   496,   497,     0,     0,     0,     0,     0,     0,   498,
       0,     0,   499,     0,     0,     0,   500,   501,   502,   503,
     504,   505,   506,     0,     0,  -327,     0,     0,     0,   507,
       0,     0,   509,     0,   511,     0,   142,   512,   143,   144,
     145,   146,   147,   148,     0,     0,   149,     0,     0,     0,
     150,     0,     0,     0,     0,   152,   153,   154,   155,   156,
     157,   158,     0,     0,     0,     0,     0,     0,   161,     0,
       0,     0,   162,     0,     0,   163,   164,   165,     0,   166,
       0,     0,     0,     0,     0,   169,     0,     0,   170,   171,
       0,   172,     0,     0,     0,     0,     0,   176,   177,   178,
     179,     0,   181,   182,     0,   183,   184,     0,     0,     0,
       0,     0,     0,   190,     0,   192,     0,   194,   195,   196,
     197,     0,   198,   199,     0,   200,   201,   202,     0,   204,
       0,   205,     0,     0,   206,     0,     0,   207,     0,   208,
       0,     0,   209,     0,   210,     0,     0,     0,   211,   212,
     213,     0,     0,   214,     0,     0,     0,     0,   215,     0,
       0,     0,     0,     0,   217,     0,   218,     0,     0,     0,
     219,     0,   220,   221,   222,   223,   224,     0,     0,     0,
       0,     0,     0,   226,   227,   228,     0,     0,     0,   229,
       0,     0,   231,     0,   232,   233,   234,     0,     0,   235,
     236,     0,   237,   238,   239,   240,   241,     0,     0,     0,
       0,   244,   245,   246,   247,     0,     0,   248,   249,     0,
     250,   251,   252,     0,     0,     0,     0,     0,     0,   254,
       0,   255,     0,   256,     0,   257,   258,   259,   260,   261,
       0,   263,     0,   264,     0,     0,     0,     0,   266,   267,
       0,     0,     0,     0,     0,     0,   270,     0,     0,     0,
     271,   272,   273,   274,   275,     0,     0,   276,   277,   278,
       0,   279,     0,   280,     0,     0,     0,     0,   281,     0,
       0,     0,     0,   283,     0,   284,   285,     0,   286,   287,
       0,     0,     0,   288,     0,     0,     0,   290,   291,     0,
       0,   292,     0,     0,   293,   294,     0,     0,     0,     0,
       0,   295,   296,     0,   297,     0,   298,     0,   299,   300,
       0,     0,     0,     0,     0,     0,     0,   301,   302,   303,
     304,   305,   306,   307,   308,   309,   310,   311,   312,   313,
     314,   315,   316,     0,   317,   318,   319,   320,     0,   321,
     322,   323,   324,     0,   325,   326,     0,     0,     0,     0,
     327,   328,   329,   330,   331,   332,     0,     0,   333,   334,
       0,   335,     0,   336,     0,   337,   338,   339,   340,   341,
     342,   343,   344,   345,     0,     0,   346,   347,     0,     0,
     348,   349,   350,   351,     0,     0,     0,     0,   353,     0,
       0,     0,   354,     0,   355,   356,   357,     0,   358,   359,
     360,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   365,   366,     0,     0,     0,     0,
     368,     0,   369,   370,   371,   372,   373,   374,   375,   376,
     377,     0,     0,     0,     0,   380,   381,     0,   382,     0,
     383,   384,   385,   386,   387,     0,   388,   389,   390,     0,
       0,   391,     0,     0,     0,   392,   393,   394,   395,   396,
       0,     0,   397,   398,   399,   400,   401,     0,   402,     0,
       0,   404,     0,   406,     0,     0,   407,     0,     0,     0,
     409,     0,     0,   411,   412,     0,   413,     0,   414,     0,
       0,   415,     0,   417,   418,   419,   420,   421,   422,   423,
       0,   425,   426,     0,   427,     0,     0,     0,     0,   429,
     430,   431,     0,     0,     0,     0,   433,     0,     0,     0,
       0,     0,     0,   436,     0,     0,   439,   440,     0,   441,
       0,   443,     0,   445,   446,     0,     0,     0,     0,     0,
       0,   447,   448,     0,   449,     0,     0,   450,     0,     0,
     451,     0,     0,     0,     0,   453,     0,     0,     0,   455,
       0,   456,   457,   458,   459,   460,   461,     0,     0,   462,
     463,   464,   465,     0,   466,   467,     0,   468,     0,   469,
     470,   471,   472,     0,     0,   473,   474,     0,   475,   476,
     477,   478,     0,     0,     0,     0,     0,   479,   480,   481,
       0,     0,     0,     0,   483,   484,   485,     0,   486,   487,
       0,   488,   489,     0,     0,     0,     0,     0,   492,     0,
       0,   493,     0,     0,     0,   495,   496,   497,     0,     0,
       0,     0,     0,     0,   498,     0,     0,   499,     0,     0,
       0,   500,   501,   502,   503,   504,   505,   506,     0,     0,
       0,     0,     0,     0,   507,     0,     0,   509,     0,   511,
       0,     0,   512
};

static const yytype_int16 yycheck[] =
{
       6,   669,   597,  1217,  1041,   575,   620,  1188,   926,   946,
     947,    20,  1595,    19,  1217,  1943,  1944,    23,   596,   597,
     957,    30,  1630,   639,  1042,   128,  1146,    33,    37,  1315,
     525,   639,  1778,  2113,    40,     6,   994,    43,  2113,  1118,
     969,  1463,    48,  1361,   736,   832,   542,   543,   544,    55,
     546,  1443,   548,  1463,  1593,   551,  2395,   553,  2433,  1164,
    1626,  1627,   689,  2216,   834,   994,  1282,  1248,  1249,   677,
     967,  1252,  1253,  1254,  1255,  2228,  1257,  1258,  1259,  1260,
    1261,  1262,  1263,  1264,  2605,   540,  2544,  1240,  1315,  2533,
    3349,     4,  1342,    99,  1247,  3030,  2666,  2874,   995,  2357,
    2939,   559,  1155,  1046,  2562,  2563,   559,  1013,  2787,   600,
    3076,  1369,   603,  1474,    23,  1046,  2455,   123,  2319,   125,
    3081,   127,   128,   129,  1854,  2498,  1928,  2229,  3031,  2113,
     134,   901,   590,  1494,  2571,   803,  3618,   590,  2506,  2948,
    2183,  1502,  1503,   665,   666,  2573,  2183,  2515,  2503,  2577,
    3145,    36,  3231,    26,   125,    13,   127,  3546,    18,    20,
    2588,  2111,    17,    18,    13,   792,   793,   794,  3161,    20,
      20,  1077,  2600,  2562,  2563,     9,  1563,   804,    53,    18,
      21,   116,    49,   678,   679,   680,    26,    17,    18,    75,
      99,  2094,    62,    83,    32,    29,    38,  3169,    22,    26,
      20,    13,    36,   162,  1573,  2717,  2718,    22,   225,  2170,
     132,  2723,    36,  2725,  2672,  2673,  2199,    17,    18,  2111,
     673,  3478,   132,  2566,   182,   996,    50,    72,    17,    18,
      84,    20,   182,  2183,  2103,    53,    22,    61,    62,    60,
     162,  1036,  1037,    83,   156,  2681,    61,    62,  1617,   136,
      36,  3695,   162,   242,  2975,    83,    34,  1942,    48,   277,
      17,    18,  3658,   276,    50,    73,   202,  3391,  3006,   370,
    4081,    65,  4379,   217,  2720,    61,    62,   276,    73,    17,
      18,  1076,    87,  2672,  2673,   132,   380,    91,  2998,    54,
      70,  2183,    11,   288,  3436,    65,   137,   376,    13,  3009,
      65,   162,   162,   137,   235,   166,   378,   279,   145,   118,
      89,    17,    18,    17,    18,   162,   166,  2049,   277,   235,
     260,   431,   485,   465,   235,   418,    38,   257,  4390,   485,
    2703,  3801,  2705,    66,   151,   456,    17,    18,    13,   313,
     836,   133,  2313,   183,  3733,  3734,   166,   371,  3737,    72,
      13,   436,   291,   348,   407,  3614,   277,  1573,   563,   246,
     595,   182,   197,   171,   563,   186,   431,  3756,   386,   242,
      17,    18,   364,    13,  3763,   156,   197,   830,   367,   221,
     222,   630,   136,   294,    17,    18,   147,   452,    41,   199,
      17,    18,   608,   630,   253,   528,   553,   156,     9,    36,
     557,  1617,   242,   231,  2307,   233,   655,   173,    17,    18,
     557,   162,   630,   560,   273,   242,   169,  3813,   655,   654,
    3902,    32,   414,   488,  2085,    62,   196,   530,   218,   562,
     239,   370,   525,   563,   262,    75,   202,   655,   654,   655,
     162,  4503,   199,   253,   294,    17,    18,   604,   321,   612,
     613,   286,   426,   477,   653,   660,   559,  4249,   511,   633,
     252,   564,  1154,   379,    22,   386,  1036,  1037,  2451,   427,
    3866,   146,    68,    17,    18,   253,  1168,   427,    36,  2512,
    2867,   321,   418,   146,   235,   274,   579,   590,   197,  2480,
     653,  1278,    50,   330,   321,    21,   987,   653,   276,  1436,
    1518,   431,   474,    61,    62,   590,    17,    18,   329,   221,
     222,  3981,  2885,  2886,  3984,   294,   427,   534,   283,   661,
     630,   361,   462,   454,   530,   258,   532,   367,   621,   503,
     385,  3340,  4639,   388,   655,  3344,  2881,  2882,  2883,   534,
     367,    17,    18,   549,  1039,   646,   563,   166,    75,   538,
     563,    17,    18,   559,   560,   277,  3945,   195,   564,  3683,
     566,    17,    18,   635,  1334,  3954,   510,   661,    17,    18,
     673,  1468,  1964,   579,  1471,  1243,   655,   595,  1475,   387,
    1477,   431,   343,  4394,   590,   385,   461,   195,   388,  3978,
     596,  4383,   387,  3852,  3983,  2970,   385,   235,   166,   388,
     606,  1530,   166,   166,   119,   518,   427,   122,  1505,  1506,
    3289,   137,  1828,    17,    18,   628,  2566,  2520,  3076,   625,
    1563,   557,   426,  1315,  1251,  1806,   467,   235,   385,   628,
    4074,   388,  1563,   639,   623,   641,  1817,  1407,  2681,  1820,
    2624,  1268,  1928,   461,  2681,   439,   416,   385,   654,  3387,
     388,   431,  2995,   659,   567,   661,   606,  3378,  3653,   665,
     666,  1431,   440,  2024,   670,   671,  3923,   673,   485,   628,
    3128,   677,  3351,  1616,  2566,   480,  1131,  1132,   684,   385,
    3390,   385,   388,   654,   388,  1616,   621,   600,   478,   534,
     603,   503,  3402,  3129,   607,  2564,  1602,   655,   538,   418,
     659,  1928,  1157,   454,   385,   655,   596,   388,  3418,  3419,
    1165,   538,  1167,  2674,   601,   627,  2085,    17,    18,  2702,
     554,   563,  3432,   199,  1179,  1180,  1181,   830,   831,  1500,
     736,  2681,  1187,   587,  1342,   574,   574,   659,   385,  3128,
     574,   388,  2111,  3582,  3886,   615,  2649,  1800,   582,   659,
     659,  2654,   385,   620,   574,   388,  1551,   608,   385,  2662,
    2663,   388,  3734,   630,   576,  2668,  1288,   653,   653,   593,
     630,  3144,  2457,  2505,   608,  3768,   385,  2164,   593,   388,
     655,  3302,   655,   623,   639,   635,  1573,  1907,   503,  2681,
    3693,   797,  1408,   799,  3873,   653,   623,  4193,   659,   659,
    1408,  2170,   630,   658,   653,   646,   525,   593,   608,   639,
     543,   534,   659,   385,  2183,  1306,   388,  2788,   824,   825,
     826,   827,   828,   829,   830,   831,   596,   833,   834,   638,
    1617,  4313,   618,   839,   655,  4231,   653,  3646,  3647,   639,
     657,   385,  1364,   946,   388,   948,   627,   601,   951,   952,
     639,   563,    17,    18,   825,   655,  1472,   115,   829,  1381,
     579,  4003,   833,  2402,  1472,   968,   655,   653,   627,  2085,
     876,   624,  4014,  3868,   385,   494,   529,   388,    17,    18,
    2808,   534,   639,   889,  2545,   646,   647,   648,   649,   650,
     651,    17,    18,   420,   547,   901,   902,  1388,   655,   552,
     906,   639,   621,  4045,  4696,  2652,   628,   503,   659,   385,
    2518,  3298,   388,  2946,  2947,   173,   654,   655,  2909,   385,
    3295,   630,   388,  2851,  3881,   150,   494,   580,   376,   385,
     494,   494,   388,   639,    58,   639,   385,   659,   136,   388,
     946,   467,   948,    12,   202,   951,   952,   294,   654,   655,
     654,   655,    45,   374,  2170,    17,    18,  1452,   639,   199,
    3305,   378,   968,  1533,  1534,  1535,   166,  2183,  3412,   607,
    3309,   376,  3340,   654,   655,  3348,  3344,    17,    18,  3334,
     889,   385,   895,   111,   388,   407,  3066,  3697,   185,  1567,
    3990,  3066,   639,   902,    17,    18,    21,   906,   671,   607,
      17,    18,  4149,  4150,   838,  2588,   639,  1013,   655,  4398,
    3416,  4400,   639,  1950,   202,    36,  1624,    17,    18,  4501,
     182,   654,   655,  3535,   386,   376,   553,   654,   655,  3466,
     639,  1723,  3544,  1970,  1038,   593,  1042,    53,   257,  3467,
      17,    18,   661,   376,   325,  2995,   655,   132,   246,    17,
      18,   578,   567,    17,    18,   570,   614,   615,    17,    18,
    1066,  2019,   293,   133,  1834,   376,    12,   639,  2490,  2491,
    3172,  1077,  2253,   401,   987,  2877,   989,     9,  2488,   313,
    2490,  2491,  3066,   655,   431,   385,  3129,   445,   388,   511,
    2019,  3537,  3129,   661,  2824,   639,  2054,   661,   661,   277,
     376,    17,    18,  2995,   130,  1111,  1112,  1113,  1114,  3012,
    4071,  3014,   137,  2010,   367,   152,   143,   566,  3021,    26,
     360,  1891,  2201,    24,  2374,  2054,  2023,  1230,   639,  2026,
    2027,   158,  3035,   129,  3335,    17,    18,   239,  2499,  3042,
    3043,    17,    18,   654,   655,  1915,  1916,  2861,  1154,  4149,
    4150,   173,  3055,  3056,  3057,   828,  2414,  1066,  3061,  3062,
     418,  1619,  1168,   639,  1267,   108,  1619,  4096,   526,  4135,
      17,    18,   369,   639,    17,    18,  2545,  2330,   654,  3129,
     202,   278,   252,   639,   281,    17,    18,   133,  4330,   655,
     639,   244,  1819,  2939,  3097,   653,  4455,  2566,   654,   655,
     253,  4343,    17,    18,   331,  1114,  3718,   655,   386,  3721,
    4397,  1217,   431,  1316,  2120,   709,   710,   286,   635,  2433,
     385,  2164,   453,   388,  1230,   251,  4368,    17,    18,  2410,
     418,  2336,  2337,  2164,   655,   639,  1928,  3129,   366,  3751,
    3752,  3753,   366,  2957,   404,  4460,   385,  3759,  4463,   388,
     655,   655,    17,    18,  1824,  3767,   454,   210,   190,   385,
     353,  1267,   388,   485,  3011,   427,  1272,   159,   493,  1372,
    3716,  3717,   375,   174,    17,    18,  2329,  3723,   170,   129,
    3726,  3727,  1288,  4240,   369,  4242,  2339,   485,   635,   783,
    3037,  3038,   313,   655,   494,   291,   166,  3743,  2085,   557,
     403,  2840,  2516,  3709,   655,  2674,  4306,  4307,   134,  1315,
    1316,  3757,  2681,  2516,  1836,    17,    18,  3763,  3764,  3765,
    3766,   579,   655,   385,  3227,   653,   388,   197,  1334,  2545,
     283,   428,  1902,    17,    18,   242,  1342,   479,   391,   639,
    4269,  1347,   192,  1349,   655,   385,  1352,  1974,   388,   843,
     366,    17,    18,   390,  1845,   655,    17,    18,  1364,    20,
      17,    18,   385,   621,   400,   388,  1372,   200,   385,   557,
     623,   388,   653,  3526,   370,  1381,  1382,   505,    81,   655,
      17,    18,    83,  2170,   581,   385,  4533,  4534,   388,   814,
     134,    17,    18,  1306,  4360,  4361,  2183,   223,   629,  4238,
     597,  1407,  1408,   601,  4619,  1411,   557,   433,   385,    17,
      18,   388,   448,  1419,   321,  4415,  1422,   385,   485,   485,
     388,   385,  3005,  3006,   388,  1431,   385,    17,    18,   388,
    4430,   653,    17,    18,   561,   657,  1442,  1443,    17,    18,
    1353,   291,  3700,  1352,   606,   461,   485,  1453,  1454,  1455,
    1456,  1457,  1458,  4640,  4641,   653,   199,  1463,  2674,    13,
     563,   588,   622,  1469,  1470,  2681,  1472,  1570,   294,   385,
    1476,  1929,   388,  1382,   639,  1388,  1929,   493,   127,  4445,
    4257,   485,  1453,  1454,  1455,     0,  1457,    17,    18,   914,
     655,  1497,   384,   196,   162,   197,   190,  4497,   403,  1470,
     639,    17,    18,   385,   283,  1476,   388,    17,    18,   385,
      20,  4190,   388,   639,   540,   654,  1619,  2927,    17,    18,
     370,  4521,  4092,  4093,   485,   413,  4785,    17,    18,   655,
     231,  3906,   233,  4533,  4534,  1448,   239,   490,   385,  2476,
    4475,   388,   385,   363,   364,   388,  1552,  1456,    13,  1458,
     294,  2671,    13,   385,  1048,   353,   388,   199,   129,   534,
     263,   262,  1475,  2179,  1570,  2060,   399,    17,    18,    13,
     385,  2179,   266,   388,    17,    18,  4097,   639,   376,  1585,
     229,  2831,  2832,  2833,  1590,  1591,   653,   653,  1497,   368,
     586,  2877,   146,   655,   129,   385,  1602,   166,   388,   639,
    4600,   654,   166,    42,  4048,    83,    17,    18,   250,   213,
    4610,   532,   213,  1619,   653,   655,   639,   173,  1624,   655,
     385,   192,   639,   388,   494,  2704,  2995,  1633,   549,  1635,
     366,   133,   655,    17,    18,    17,    18,  2955,   655,   639,
     501,   616,   385,  1552,   243,   388,  3799,   485,  2862,   653,
    2877,  2804,  4652,   563,  4654,   655,   260,   563,   563,  2862,
    3389,   260,   639,  1576,  3393,  3394,    17,    18,   661,   502,
     562,   639,   366,   272,  2444,   639,  1585,  4135,   655,  4679,
     639,   146,  1591,   385,   333,   146,   388,   655,   337,  4689,
     654,  4691,   653,  4693,    18,   344,   655,    17,    18,   138,
    2637,   385,   146,  4078,   388,   199,  2333,  4707,  4047,    66,
     446,    17,    18,   416,  4714,    17,    18,  1723,  1724,   385,
     291,  3063,   388,   639,   385,   234,   218,   388,   385,  4729,
    4730,   388,    17,    18,  1837,  3274,   586,  2857,   599,   655,
      17,    18,    81,   653,   386,  4745,  4746,   653,   385,  3091,
    4750,   388,   218,   231,   647,   233,   291,   639,  2545,   385,
    3129,   654,   388,   639,    17,    18,  2374,   631,   632,   129,
    2225,   263,  4307,   655,   454,  2230,   425,   385,  1784,   655,
     388,   642,   386,   277,   262,    17,    18,   239,  2243,   584,
    3861,   655,   639,   213,    90,   385,   639,   263,   388,   370,
     385,    17,    18,   388,  3387,   239,   385,   639,   655,   388,
     608,   263,   655,   608,  3885,   653,   112,   653,   473,   234,
    1826,  1827,  2277,   655,   639,   661,  1929,  3041,  1834,  2445,
    1836,  1837,   192,   239,   483,   370,  3582,  2445,  3041,  1335,
     655,   164,  1338,  1849,  1947,  1341,    17,    18,  1854,   639,
      17,    18,    83,  1859,   653,   385,  1862,   196,   388,    17,
      18,   221,   661,  1869,  1870,   655,  1872,    17,    18,   385,
     469,    40,   388,   647,   639,   385,    17,    18,   388,    48,
     654,  3784,   213,   584,  3467,  1891,   385,  2674,  1894,   388,
     655,  2346,  1898,   553,  2681,   385,   639,   557,   388,   554,
     239,   258,  4360,  4361,  2482,   560,   231,   608,   233,  1915,
    1916,  1917,  1918,  3129,   141,    17,    18,   615,  1827,   242,
     618,    26,  1928,  1929,   263,    17,    18,  3830,  1934,  1935,
    1936,   291,  1845,    17,    18,   385,  3328,   639,   388,   239,
     539,  1947,   385,    17,    18,   388,   250,    17,    18,   604,
     244,  3680,   654,    17,    18,   639,  2874,   380,  1964,   253,
    1869,  1870,   613,  1872,  2922,  3222,   621,    17,    18,  3226,
     654,    17,    18,   639,   385,   199,   625,   388,   639,  1985,
     654,   655,   639,   199,    49,  1894,  4521,  4445,   654,  1898,
      17,    18,   641,  2922,   136,    17,    18,   654,   654,   655,
    1913,   385,   639,   385,   388,   362,   388,   493,  1917,  1918,
     370,   242,   294,   639,   654,   586,  2953,   654,  3336,  2025,
      17,    18,    17,    18,   504,  1934,  1935,  1936,   654,    17,
      18,   639,   115,   504,   385,  2041,  2933,   388,    17,    18,
     654,   655,  2048,  3148,   367,   557,   654,    17,    18,   639,
     659,   586,  2058,  2059,   639,  2061,  2062,  3399,   661,   164,
     639,   400,  1060,  1061,   654,   385,   602,  1980,   388,   654,
    3537,   560,  3177,  3178,   557,   654,   525,   416,  2181,   385,
      18,   382,   388,   385,  2187,  3299,   388,  2058,  2059,  2859,
     211,  3433,   653,  3198,  4186,  4187,  3216,   391,    17,    18,
     385,    26,  3444,   388,   246,  3447,   147,  1105,   385,   639,
     574,   388,   653,  2216,  2120,   196,  2025,  4652,     6,  4654,
    3686,  3687,   653,   639,   654,  2228,  4029,  4030,  4031,   639,
     361,   136,   385,  3347,   653,   388,   367,   242,   654,  2048,
     639,   224,    18,   661,  3347,    86,   653,    88,     6,   639,
    4449,   655,  4451,   385,  4689,   654,   388,  2070,    83,   563,
     147,   538,    17,    18,   654,    20,  2079,  2080,   653,   385,
     527,   653,   388,  2179,   653,  2181,   653,  2090,  2091,  2092,
    2093,  2187,  2095,  2096,   608,  2877,   543,  2193,   178,   639,
    2196,   132,    17,    18,  4729,  4730,   639,   318,   319,   654,
     655,    59,   323,   324,   654,    20,   437,   654,   655,   147,
    2216,   654,   653,   154,   385,   538,   321,   388,   385,  2322,
     653,   388,  2228,  2831,  2832,  2833,   586,   385,   639,   608,
     388,   655,   653,    61,    62,   385,   653,   661,   388,   164,
    2810,   246,  4334,   654,   385,    73,  4338,   388,   653,  2352,
     191,    17,    18,   654,   655,   639,  3723,   639,   183,  3726,
    3727,   653,   367,   654,   655,  2881,  2882,  2883,    17,    18,
     654,   147,   654,  2881,  2882,  2883,  3743,   653,   608,   636,
     199,  4209,   129,   385,   654,   655,   388,   653,   639,  3409,
     105,    13,   150,   385,   654,   653,   388,    61,    62,    13,
     623,   385,   343,   654,   388,   613,   614,   538,   616,   392,
     618,   385,   454,   653,   388,   385,  2322,   242,   388,   639,
     403,   385,  1005,   417,   388,   655,   653,   410,  1011,  1012,
      44,   661,   655,   639,   654,   385,   653,   639,   388,   653,
      83,  2347,  3129,   485,  2799,   192,  2352,   162,   654,   299,
     300,   166,   654,   553,   639,  3292,   343,   473,   385,   574,
     591,   388,   639,   385,   653,   315,   388,  3789,  2374,   654,
     654,   655,   653,  3331,   221,    13,   383,   654,   653,  3789,
     195,  3486,   197,   149,    98,   653,   639,   653,   385,   103,
     385,   388,   623,   388,   654,   655,   321,   385,   213,  3613,
     388,   654,  3331,  2409,   219,   343,   385,   639,   653,   388,
    3613,   160,   653,  4505,  4506,   385,   566,   653,   388,   653,
     235,   164,   654,   639,   146,    12,   509,  2433,   243,  2532,
    2533,  2437,   653,   538,  3513,   250,   361,   655,  2444,  2445,
     653,  3019,   367,   653,   291,   260,   654,   655,   653,   454,
     654,   655,  2458,   394,  2460,   496,   497,   272,   653,   601,
     653,  4541,   277,   654,   655,  4540,   385,   343,   639,   388,
     653,   286,   639,   654,   655,   653,  2482,  4060,  4061,   653,
     485,   639,  2488,   654,  2490,  2491,   511,   654,   653,   639,
     653,  3705,  4238,   443,   444,   185,   654,   438,   639,   242,
     653,   223,  3705,   376,  2999,   653,   364,   653,   146,   653,
    2516,   653,  3007,   654,    33,   654,   655,  3013,   623,  2525,
     653,   604,  2528,   370,   654,   655,  2532,  2533,   115,  3025,
     385,  3027,  3028,   388,   654,   655,  3554,   639,   353,  4442,
     653,   255,   653,  3039,   653,  2458,   133,   639,   654,   655,
     655,   235,   654,   654,   655,   639,   653,  2528,   496,   497,
     385,   376,   654,   388,   653,   639,    85,   654,   655,   639,
     654,   386,   430,   653,   432,   639,  1124,  1125,  1126,   297,
     654,   299,   300,    51,   654,   223,   173,   654,   655,   639,
     654,   485,   653,  1141,   653,    60,   601,   315,   653,   493,
    4208,   654,   655,   418,   654,   646,   647,   648,   649,   650,
     651,  2617,   639,   538,   653,   202,   330,   639,   361,   385,
     496,   497,   388,   653,   367,  1173,  2632,   654,  1176,  3915,
     654,   655,   654,   654,   655,   653,   385,   654,   655,   388,
    2646,   160,   639,   653,   639,   653,   749,   653,   653,  1197,
    1198,   639,   653,  1201,   469,   654,   655,   654,   654,   654,
     639,   648,   649,   650,   651,   288,   654,   653,   771,   639,
    1218,  1219,   653,   363,   364,   654,   653,  3963,   493,   369,
     394,   784,   785,   105,   654,   654,   655,   129,   653,  3305,
     132,  2697,  2698,  2699,   437,   654,   655,  3305,   623,   653,
     287,  1870,   653,  1872,   156,   157,   644,   645,   646,   647,
     648,   649,   650,   651,   653,  3939,  3940,   182,   612,   613,
     639,   186,   654,   655,   539,   443,   444,   653,  3952,   653,
     655,  3186,   197,   654,   655,  3959,    65,  2650,  2651,   586,
    2653,   566,  2655,  2656,  2657,  2658,  2659,  2660,  2661,  3327,
     192,  2664,    81,   653,  2667,   654,   655,  2670,   653,   653,
      20,  3985,  3986,   653,    93,  1934,  1935,  1936,   644,   645,
     646,   647,   648,   649,   650,   651,  4704,   376,   129,   221,
     595,   132,   653,  3238,   639,   654,   655,   653,  2697,  2698,
    2699,    27,   607,   608,    51,   538,   655,   519,   520,   513,
     522,   383,   524,   654,   655,   376,    36,   654,   654,   655,
     199,   129,   376,   628,   639,   630,   479,   539,  2824,   595,
    2826,   243,   654,   655,  2830,  2831,  2832,  2833,   654,   655,
     648,   418,    62,  2839,   654,   655,   550,    73,   260,   654,
     655,   192,    34,   658,   659,   105,   493,    83,   591,   291,
     272,   661,  2858,  2859,   654,   655,  2862,  4038,  4786,   661,
      83,   654,   655,   504,   329,   654,   655,   196,    91,   172,
     221,  2877,   201,   639,   192,  2881,  2882,  2883,   653,   129,
     623,   519,   520,   521,   522,   523,   524,   277,  2894,   119,
     639,   581,   122,   197,   413,   118,   132,   654,   655,   534,
     130,   539,   162,   221,   491,   553,   166,   597,   654,   655,
     239,   511,   655,   231,   534,   233,   435,   288,   148,  3415,
     163,  2927,   654,   655,   654,   655,   129,  3030,   370,   132,
    2839,   353,  3831,  3832,   263,   654,   655,   197,   525,   197,
     291,   164,   192,   654,   655,  3523,   654,   655,   654,   655,
     654,   655,   471,   213,    92,   147,   655,  3787,  3788,   219,
    4080,   655,   427,  2969,  2970,   654,   655,   554,  1205,  1206,
     377,   221,   549,   291,  3311,  3312,  3267,  3268,   654,   162,
     147,  2894,   132,   243,   118,  3592,  3593,   660,     6,   192,
     250,   653,  2998,  4207,   117,   231,     4,   233,   484,   621,
     260,  3010,  3008,  3009,  4207,   253,    20,  3016,   400,  3015,
     655,   530,   272,    27,    58,   446,   239,   277,   221,   370,
     178,   251,   118,   232,  3030,  3031,   286,   263,   232,   655,
    3036,  3040,   661,    73,   621,  3041,   655,  3046,    13,  3976,
     654,   291,   627,  3052,  3053,  3051,   654,   469,   146,    10,
     655,   661,   370,   654,   661,   276,   654,  3063,    65,    73,
    2969,   253,   654,   653,  3070,  3071,   661,   376,   288,    83,
    3076,   400,   655,   164,    81,   655,  3082,   288,   288,   660,
    3086,  3911,   288,    51,   276,  3091,    93,   416,   291,   288,
    4210,   288,  1640,   353,  3664,  4113,   655,   320,   655,   166,
     553,  4119,   653,   230,  3017,  3018,   283,   655,   401,   655,
     129,  3082,   574,   132,   655,   338,   376,   539,   132,    38,
     370,  3127,    27,   574,    29,   355,   386,   363,   364,   400,
     129,   655,  3045,   369,   166,   197,    73,  3143,   361,   655,
     376,   115,  3051,   655,   586,   655,   534,   253,   648,   254,
     551,   343,   187,   655,   197,    62,    61,    62,   418,    64,
     172,   534,  4282,  3076,   508,   405,   142,   370,    73,   376,
     655,   363,   364,   192,   654,   404,   343,  1725,    83,   655,
     416,  1729,   147,   129,   129,   514,    91,   132,   602,   196,
       7,   205,   607,   192,   201,   634,   655,   199,   654,   173,
     654,   199,   221,   122,   654,  1753,   654,   654,   648,   469,
     129,  3314,   119,   118,   655,   122,   654,   231,   654,   233,
     654,  3134,   221,   130,   647,   653,  3232,   132,   202,   654,
     135,   655,   239,   493,  3240,   586,   658,   654,   654,   595,
    4454,   148,  4362,   654,   147,   654,   192,   192,   440,   263,
     655,  4454,   654,   489,  4084,  4085,   263,  4087,  4088,   164,
     654,   654,   494,   654,   651,   239,   185,   596,   586,   129,
     653,   501,   291,   192,  3280,   221,   221,   653,   653,   539,
     563,   655,   563,   563,   574,  3855,   193,   628,   253,  2066,
    2067,  3869,   291,  3299,  3300,   655,   653,  3303,   241,  3305,
     545,    12,   221,   222,   496,   497,  2083,   653,  3314,  3412,
      13,   211,   199,   287,  3320,   538,   655,   653,   661,   653,
     512,  3327,  3328,  2100,  2101,   274,   231,  3240,   233,   496,
     497,   554,   192,   655,   239,   595,   586,   661,   655,  4257,
     570,  3347,   247,   199,   251,   291,   291,   661,   608,   363,
     364,   370,   654,   661,   176,   369,  3362,   262,   474,   655,
     596,   221,   376,  3369,   493,   426,   600,   655,   628,   599,
     630,   370,   291,   105,  3383,  4556,   655,   197,   343,  3993,
      49,  4399,   351,   586,  3390,   525,   202,   484,  2165,  2166,
    2167,  2168,  4329,  3399,   654,   655,  3402,   525,   658,   659,
     525,   525,   416,   525,   449,   197,  3412,   653,   166,   416,
    3416,  4348,  3418,  3419,   166,   320,   166,   166,   166,   166,
    3333,   166,   166,  3526,   370,   370,  3432,  3433,   166,   166,
     166,   291,   166,   338,   287,   354,   166,   166,  3444,   413,
     343,  3447,   166,   166,   418,   352,   365,  4042,   355,   166,
     369,   370,   644,   645,   646,   647,   648,   649,   650,   651,
    3369,   166,   166,   376,   166,  3471,   166,   655,  3474,   608,
     376,   661,   376,  3479,   654,   489,   160,   644,   645,   646,
     647,   648,   649,   650,   651,  4666,   654,   249,   393,   249,
     395,   661,   654,   654,    83,  3501,   470,   654,   403,   654,
    3413,   654,   654,   654,   166,     7,   655,   514,    97,  3422,
     370,   243,   655,   661,   661,   574,   574,   491,   517,   574,
    3526,   563,   655,   166,   167,   635,   433,  3630,   260,    17,
      18,   496,   497,    83,    89,    49,   653,   283,   653,   166,
     272,   653,   653,   574,   166,  4759,   383,    97,   199,  4567,
    4568,   140,  4570,   199,   199,   250,  4759,   199,  4772,   563,
     203,   257,   563,  4777,   431,  3474,   655,   586,  4782,  4772,
     475,   147,   215,   176,  4777,    38,   370,   260,  3491,  4782,
     554,   260,   596,   389,   653,   118,   560,   586,   118,   596,
      81,   334,   400,   496,   497,   400,   400,   574,   105,   142,
     261,   554,  3608,   261,   400,   579,   554,  3613,   142,   400,
      49,   400,  4630,   256,  4632,  4633,   402,   400,   400,   400,
     574,   353,   213,   653,  3630,   268,   531,   532,   533,   653,
     604,  4226,   653,   538,   563,   123,   124,   125,   126,   127,
     586,   586,   382,   648,   563,   661,   251,   621,   567,   554,
     653,   570,   295,   558,   251,   655,   653,   431,   654,   122,
     654,   654,   581,   570,   654,   653,   129,   586,  3674,   655,
     589,   654,   577,   654,   661,   654,   265,   253,   648,   644,
     645,   646,   647,   648,   649,   650,   651,  3693,   654,   383,
     595,  3697,   599,   653,   376,   235,  3799,   654,   278,  3705,
     655,   400,   654,  3709,  4741,  3711,  4724,   199,   655,   601,
     661,  4379,   253,   105,   357,   265,   654,   431,   654,   166,
     655,   260,   185,   260,   655,   653,   586,   646,   647,   192,
     465,   263,   400,   414,   263,   661,   243,   469,   226,   227,
     228,   229,   645,   646,   647,   648,   649,   650,   651,    83,
     655,   376,   341,   260,    20,   376,   654,  3670,   221,   222,
     655,   654,   653,   386,   653,   272,    49,   343,  3871,   487,
    3776,   654,   630,  3779,   363,   364,   654,   366,   274,   467,
    3786,  3787,  3788,  3789,   181,   286,   211,   153,   270,   654,
     654,   341,   655,  3799,   485,  2572,   213,   495,  2575,  2576,
     260,  2578,   260,   655,  2581,  2582,   376,   539,  2585,   376,
     511,  4381,   654,  2590,   654,   115,   366,   655,  2595,  2596,
    2597,  2598,  2599,   653,   655,   263,  2603,  2604,   291,  2606,
     263,   630,   655,   654,  4404,  2612,  2613,  2614,  2615,   653,
     429,  2618,  2619,  4780,  2621,   333,   353,   335,   336,   337,
      36,   243,    87,   503,   149,   238,   344,    36,  3961,   654,
     653,   277,    36,   653,     6,  3871,   653,    36,   260,   376,
      12,   370,    14,    62,    16,  3881,   654,   654,  4456,   429,
     272,   654,   654,    69,   251,    27,   654,    29,   654,   654,
      69,   354,  3898,   654,   340,   265,   655,   385,   426,   654,
     388,   201,  2679,    18,   383,  3911,   369,   370,   630,   250,
    3916,   653,    49,   654,   219,  3924,  3922,    59,   340,   166,
     496,   497,    64,    65,  3930,   511,   653,   655,   661,    71,
     655,   608,   608,   480,   654,   654,   525,   425,    20,   239,
     655,    83,   132,   190,   653,  4048,   557,   132,   412,    91,
      36,   661,   370,   139,   340,  3961,   203,   180,   655,   101,
     139,   353,   469,   653,   563,   654,   143,   563,   215,   563,
     263,  4639,   557,   653,  3887,   525,   118,   612,   164,   608,
     608,  3987,   168,   654,   376,   164,   317,   287,   655,   168,
     132,   654,   618,   135,   482,   483,   653,   653,   653,    57,
     653,   143,   144,   618,   653,   653,    15,   132,   150,    67,
     263,   601,    20,  3922,   263,   369,   158,   529,   204,   266,
     162,   268,   164,   630,    82,   204,   176,   464,    63,  4624,
     474,  4037,   539,   175,  4040,   653,    94,    95,    96,   225,
     654,   654,  4048,   655,   383,   601,   225,   544,   295,  3962,
    4415,   653,   653,   195,   240,   113,   465,  4627,   250,   376,
     653,   240,   365,  4069,  4070,  4430,  4734,   613,   644,   645,
     646,   647,   648,   649,   650,   651,   161,   469,  4084,  4085,
      33,  4087,  4088,   627,   662,   654,   370,   176,   388,   231,
     565,   233,   142,  4761,   142,   237,   653,   239,   164,   418,
     563,    75,   288,   197,   567,   247,   197,   570,   653,   288,
     627,   199,   654,   360,    33,   653,    65,    65,   581,   383,
     262,   397,   545,   586,   655,   279,   589,   313,  4037,  4135,
     654,   654,  4497,   653,   313,    14,  4706,   625,   439,   654,
    4146,   250,   160,   659,   286,  4151,   383,   539,   653,   383,
      49,   639,   640,   641,    49,    57,   159,    49,    49,    49,
     653,  4070,   140,   653,   149,    67,     5,   376,   415,   376,
     470,   654,   627,   160,  4180,  4181,   293,  4183,   320,   234,
      82,   659,   662,   646,   647,   131,   286,    12,   653,    49,
      49,   491,    94,    95,    96,    49,   338,   540,   155,   601,
     342,  4207,   136,    55,   474,   659,   655,   476,   160,   654,
     566,   113,   654,  4783,   514,   655,   216,   232,   659,   655,
     654,   263,  4135,   654,    55,   104,   655,   453,   197,   197,
     197,   417,    49,   566,  4240,  4600,  4242,   235,   417,   381,
     426,   629,   370,  3020,   386,  4610,   132,   426,   653,   493,
    4156,   393,   655,   395,   554,   441,  3033,   136,   400,   198,
    4363,   403,   441,  2359,  3784,  3896,  4272,  2669,   989,  3505,
    2561,   150,  4251,   459,   332,  4382,  4583,  1057,  4584,  3894,
     459,  1037,  3898,  4068,  4761,  4722,    48,   598,  1927,  1859,
    2824,   349,   434,  4299,   173,  3990,   596,  3990,   177,  3990,
    3990,  3990,  3990,  3990,   604,  3990,   448,   449,   450,   451,
     189,  3990,  4731,  3990,  4679,  4597,  4408,   503,  4597,  3990,
     506,  4534,  3990,  3990,   503,  4434,  4691,   506,  4693,  4433,
    1101,  1828,   211,   475,  4077,  1579,  4255,  3442,    13,  2631,
    2113,  3607,  4707,  3280,  2858,  2853,   689,  4353,   534,  4714,
      25,   694,  1369,  4353,  4038,   534,  4458,  4363,  3610,  4624,
     239,    36,    37,  4369,  4666,  1616,  4564,   246,   630,  4226,
     556,  3903,  4475,  2624,   553,  3355,  3674,   556,   557,  3070,
    4745,  4746,  2632,  3073,  3923,  4750,    61,    62,   731,   531,
     532,   533,  3916,  4685,    69,  3734,   538,  4404,  3169,    74,
    4111,  3768,  3972,  2532,  4456,   748,  3961,   286,  2777,  4322,
    3223,  3218,   554,  4388,  3226,    11,   558,    11,  4505,   605,
    4506,  2189,  4325,   481,  4338,   100,   605,   102,  2695,   104,
     332,  4183,  4334,  3390,  4440,   577,  4119,  2631,  3066,  4445,
     582,   116,  1017,  4356,  4357,  1513,  1070,   349,  4454,   792,
     793,   794,   795,   595,  2502,  3928,  2428,  4440,  1612,  4562,
    2120,   804,   137,   138,  3692,  1591,  2839,  2402,  1917,  4475,
    3275,  2449,  2315,  3992,   619,  1941,   938,  3240,  4284,  2224,
    2220,  2810,  1168,   541,  2517,  3338,  4063,  2314,   163,   164,
    4245,  2511,  3501,  3705,   169,  4578,  2340,   172,  4579,  2927,
    1141,   559,  1530,  3882,  3062,  4706,  3871,  2454,  2193,  1352,
    1382,  2396,  2432,  3613,  1041,  1041,  3294,   659,  3293,  1041,
    3347,  4454,   609,  1041,  1633,   200,   685,   202,  2020,  1461,
     597,  2021,  4445,  2496,   597,   210,  1848,   212,  3711,  1389,
     419,  3278,  4664,  4701,  4482,  4574,  4777,  3963,  4782,   892,
     781,  3299,  2479,  4466,  4467,  3327,  4562,  1419,   596,  1781,
     439,   463,  3328,   238,   239,   240,   596,  1967,   447,  2472,
    2471,  1898,  4578,  4579,  2465,   830,   455,  1409,   590,   481,
     918,  1344,  4027,  2444,  2826,  1624,   261,  4033,   925,   591,
     627,   627,    -1,   627,  1037,    -1,  4602,    -1,    -1,    -1,
      -1,    -1,  1037,  4609,    -1,  1037,   485,    -1,   283,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   498,
     499,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   313,   541,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   559,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  4768,    -1,    -1,    -1,   548,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  4690,    -1,    -1,    -1,    -1,  4695,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   694,    -1,
     579,    -1,    -1,    -1,    -1,   380,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   601,    -1,   603,    -1,    -1,    -1,  4734,    -1,
      -1,   406,    -1,    -1,    -1,   731,    -1,    -1,    -1,    -1,
    1083,    -1,   417,   418,    -1,    -1,   421,   422,    -1,    -1,
      -1,    -1,   748,  4759,    -1,  4761,    -1,    -1,    -1,    -1,
      -1,    -1,  4768,    -1,    -1,    -1,  4772,   442,    -1,  4682,
      -1,  4777,    -1,    -1,    -1,    -1,  4782,  1120,  1121,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1129,  1130,  1131,  1132,
    1133,  1134,  1135,  1136,  1137,  1138,  1139,  1140,    -1,   795,
      -1,    -1,    -1,    -1,    -1,    -1,  1149,  1150,    -1,  1152,
    1153,    -1,    -1,    -1,  1157,   490,    -1,  1160,  1161,  1162,
    1163,    -1,  1165,  1166,  1167,    -1,    -1,    -1,   503,    -1,
      -1,  1174,  1175,    -1,  1177,  1178,  1179,  1180,  1181,    -1,
      -1,  1184,  1185,  1186,  1187,  1188,  1189,  1190,  1191,  1192,
    1193,  1194,    -1,  1196,    -1,    -1,  1199,  1200,    -1,   534,
      -1,  1204,    -1,   538,    -1,  1208,  1209,  1210,    -1,   123,
     124,   125,   126,   127,    -1,    -1,    -1,  1220,  1221,  1222,
      -1,   556,   557,    -1,    -1,    -1,  1229,    -1,   236,    -1,
      -1,    -1,    -1,  1236,  1237,  1238,   892,  1240,    -1,    -1,
      -1,    -1,    -1,    -1,  1247,  1248,  1249,    -1,  1251,  1252,
    1253,  1254,  1255,    -1,  1257,  1258,  1259,  1260,  1261,  1262,
    1263,  1264,    -1,    -1,    -1,  1268,  1269,    -1,    -1,    -1,
     605,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   616,    -1,    -1,    -1,    -1,    -1,    -1,   296,   624,
     298,   299,   300,   301,   302,    -1,   304,   305,   306,   307,
     308,   309,   310,   311,   312,    -1,   314,   315,   316,    -1,
      -1,    -1,   226,   227,   228,   229,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1356,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1419,    -1,    -1,   333,
      -1,   335,   336,   337,    -1,    -1,  1429,  1083,    -1,    -1,
     344,    -1,    -1,    -1,    -1,   443,   444,    -1,    -1,    -1,
      -1,    -1,  1445,    -1,    -1,    -1,  1449,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1120,  1121,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1129,  1130,    -1,    -1,  1133,  1134,  1135,
    1136,  1137,  1138,  1139,  1140,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1149,  1150,    -1,  1152,  1153,    -1,    -1,
      -1,  1504,    -1,    -1,  1160,  1161,  1162,  1163,    -1,    -1,
    1166,   425,    -1,    -1,    -1,    -1,    -1,    -1,  1174,  1175,
      -1,  1177,  1178,    -1,    -1,    -1,    -1,    -1,  1184,  1185,
    1186,    -1,    -1,  1189,  1190,  1191,  1192,  1193,  1194,    -1,
    1196,    -1,    -1,  1199,  1200,    -1,    -1,    27,  1204,    29,
      -1,    -1,  1208,  1209,  1210,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1220,  1221,  1222,    -1,   482,   483,
      -1,    -1,    -1,  1229,    -1,    -1,    -1,    -1,    -1,    -1,
    1236,  1237,  1238,    -1,    64,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    83,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    91,    -1,  1269,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    27,    -1,    29,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   118,    -1,
      -1,    -1,    -1,  1646,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   132,    -1,    -1,   135,    -1,    -1,    -1,    61,
      62,    -1,    64,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    73,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    83,    -1,    -1,   164,    -1,    -1,    -1,    -1,    91,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1356,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   625,    -1,    -1,    -1,    -1,   118,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   640,   641,    -1,    -1,
     132,    -1,    -1,   135,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   231,    -1,   233,    -1,    -1,  1759,  1760,  1761,   239,
      -1,    -1,   164,  1419,    -1,    -1,    -1,   247,    -1,    -1,
      -1,  1774,    -1,  1429,    -1,    -1,    -1,    -1,    -1,    -1,
    4217,  4218,   262,    -1,  4221,  4222,  4223,  4224,    -1,  1445,
      -1,    -1,    -1,  1449,    -1,    -1,    -1,  1800,    -1,    -1,
      -1,    -1,    -1,  1806,    -1,    -1,  1809,    -1,  1811,    -1,
      -1,    -1,    -1,    -1,  1817,    -1,  1819,  1820,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   231,
      -1,   233,    -1,    -1,    -1,    -1,    -1,   239,    -1,    -1,
     320,    -1,    -1,    -1,    -1,   247,    -1,    -1,  1504,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   338,    -1,
     262,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   276,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  4323,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1912,
      -1,    -1,    -1,   393,    14,   395,    16,    -1,   320,    -1,
      -1,  4358,  4359,   403,    -1,    -1,    -1,    -1,    -1,    -1,
    4367,    -1,    -1,    33,    -1,    -1,   338,    37,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    51,    52,    -1,    -1,    -1,    -1,    -1,    -1,    59,
      -1,    -1,  1965,    -1,    64,    65,    -1,    -1,    -1,    -1,
      -1,  1974,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    85,    -1,    -1,    -1,    -1,
    1646,   393,    -1,   395,    -1,   475,    -1,    -1,    -1,    -1,
      -1,   403,    -1,    -1,   104,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   128,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   136,   137,   138,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   149,
     150,   531,   532,   533,    -1,    -1,    -1,    -1,   538,    -1,
      -1,    -1,   162,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   475,   554,    -1,    -1,   177,   558,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   194,    -1,    -1,   577,    -1,    -1,
      -1,    -1,    -1,  1759,  1760,  1761,    -1,    -1,    -1,   209,
    2113,   211,    -1,    -1,    -1,   595,   216,    -1,    -1,    -1,
     220,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   531,
     532,   533,  2135,    -1,    -1,    -1,   538,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1800,    -1,   246,    -1,   248,    -1,
      -1,    -1,   554,  1809,    -1,  1811,   558,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   264,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   577,    -1,    -1,    -1,    -1,
      -1,    -1,   282,    -1,    -1,    -1,   286,    -1,    -1,    -1,
      -1,    -1,    -1,   595,    -1,    -1,    -1,    -1,    -1,  2202,
      -1,    -1,    -1,  2206,    -1,    -1,    -1,    -1,  2211,  2212,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2220,    -1,  2222,
      -1,  2224,  2225,  2226,  2227,    -1,    -1,  2230,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2240,    -1,  2242,
    2243,    -1,  2245,  2246,  2247,  2248,    -1,  2250,    -1,    -1,
    2253,   653,    -1,    -1,    -1,    -1,  1912,    -1,    -1,  2262,
      -1,    -1,    -1,    -1,    -1,    -1,  2269,    -1,  2271,    -1,
    2273,  2274,    -1,  2276,  2277,    -1,    -1,    -1,  2281,  2282,
    2283,   381,    -1,    -1,  2287,  2288,  2289,    -1,  2291,    -1,
    2293,    -1,  2295,    -1,  2297,    -1,  2299,    -1,   398,    -1,
     400,  2304,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1965,
      -1,    -1,    -1,   413,    -1,    -1,    -1,    -1,    -1,    -1,
    2323,    -1,    -1,    -1,   424,    -1,    -1,  2330,    -1,    -1,
    2333,    -1,    -1,    -1,    -1,    -1,  2339,    -1,    -1,  2342,
      -1,    -1,    -1,  2346,    -1,    -1,   446,    -1,    -1,   449,
      -1,   451,    -1,    -1,   454,    -1,    -1,   457,   458,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   468,    -1,
      -1,   471,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   479,
      -1,    -1,    -1,    -1,    -1,   485,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   493,    -1,    -1,    -1,    -1,   498,   499,
     500,    -1,    -1,    -1,    -1,    -1,    -1,  2410,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    27,    -1,    29,    -1,    -1,    -1,
     530,    -1,    -1,    -1,    -1,    -1,    -1,   537,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    61,    62,
      -1,    64,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      73,    -1,    -1,    -1,    -1,    -1,    -1,  2480,    -1,  2135,
      83,    -1,   582,    -1,    -1,    -1,    -1,    -1,    91,    -1,
      -1,    -1,    -1,    -1,   594,    -1,    -1,    -1,   598,    -1,
      -1,   601,    -1,    -1,    -1,    -1,    -1,   607,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   118,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2531,   132,
      -1,    -1,   135,    -1,    -1,    -1,    -1,   637,    -1,    -1,
      -1,  2544,    -1,   643,    -1,    -1,  2202,    -1,    -1,    -1,
    2206,    -1,    -1,   653,    -1,  2211,  2212,    -1,    -1,  2562,
    2563,   164,    -1,    -1,  2220,    -1,  2222,    -1,  2224,    -1,
    2226,  2227,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2240,    -1,  2242,    -1,    -1,  2245,
    2246,  2247,  2248,    -1,  2250,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2262,    -1,    -1,    -1,
      -1,    -1,    -1,  2269,    -1,  2271,    -1,  2273,  2274,    -1,
    2276,  2624,    -1,    -1,    -1,  2281,  2282,  2283,   231,    -1,
     233,  2287,  2288,  2289,    -1,  2291,   239,  2293,    -1,  2295,
      -1,  2297,    -1,  2299,   247,    -1,    -1,    -1,  2304,    -1,
      14,    -1,    16,    -1,    -1,    -1,    -1,    -1,    -1,   262,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2323,    -1,  2672,
    2673,    -1,    -1,    37,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2339,    -1,    -1,  2342,    51,    52,    -1,
      -1,    -1,    -1,    -1,    -1,    59,    -1,    -1,    -1,    -1,
      64,    65,    -1,    -1,    -1,  2708,    -1,    -1,    -1,  2712,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   320,    -1,    -1,
      -1,    85,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   338,  2739,  2740,    -1,    -1,
     104,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2759,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   128,  2768,    -1,  2770,    -1,  2772,
      -1,    -1,   136,   137,   138,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   149,   150,    -1,    -1,    -1,
     393,    -1,   395,    -1,    -1,    -1,  2799,    -1,    -1,    -1,
     403,  2804,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   177,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2480,    -1,    -1,    -1,    -1,    -1,
     194,    -1,  2835,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   209,    -1,   211,    -1,    -1,
      -1,    -1,   216,    -1,    -1,    -1,   220,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   475,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   246,    -1,   248,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     264,    -1,    -1,    -1,    -1,    -1,  2909,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   282,    -1,
      -1,    -1,   286,    -1,    -1,    -1,    -1,    -1,   531,   532,
     533,    -1,    -1,    -1,    -1,   538,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   554,    -1,    -1,    -1,   558,    -1,  2960,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2975,    -1,   577,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   595,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   381,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   398,    -1,   400,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   413,
      -1,    -1,  2708,    -1,    -1,    -1,  2712,    -1,    -1,    -1,
     424,    -1,    -1,  3066,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3079,  3080,    -1,    -1,
      -1,    -1,   446,  2739,  2740,   449,    -1,   451,    -1,    -1,
     454,    -1,    -1,   457,   458,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2759,   468,    -1,    -1,   471,    -1,    -1,
      -1,    -1,  2768,    -1,  2770,   479,  2772,    -1,    -1,    -1,
      -1,   485,    -1,    -1,    -1,  3128,    -1,    -1,    -1,   493,
      -1,    -1,    -1,    -1,   498,   499,   500,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    35,    36,    -1,  3151,    -1,
      -1,    41,    -1,    43,    -1,    45,    46,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   530,    -1,    -1,    -1,
      -1,    -1,    62,   537,    -1,    -1,    -1,    -1,    -1,  2835,
    3183,  3184,    -1,  3186,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3195,    -1,    -1,    -1,    -1,  3200,    -1,    -1,
    3203,    -1,  3205,  3206,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   582,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   119,
     594,    -1,   122,    -1,   598,  3238,    -1,   601,    -1,    -1,
     130,    -1,    -1,   607,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2909,    -1,    -1,    -1,    -1,   148,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3269,    -1,    -1,    -1,
      -1,    -1,    -1,   637,    -1,   165,    -1,    -1,    -1,   643,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   653,
    3293,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   191,    -1,   193,  2960,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   206,   207,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,     6,    -1,    -1,    -1,    -1,    -1,
      12,    -1,    14,    -1,    -1,    -1,  3349,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    27,    -1,    29,    -1,    -1,
      -1,   251,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3378,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    59,    -1,    -1,
     280,    -1,    64,    -1,    -1,    -1,    -1,    -1,    -1,   289,
     290,    -1,   292,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    83,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    91,
      -1,    -1,    -1,  3079,  3080,    -1,    -1,    -1,    -1,   101,
      -1,    -1,    -1,    -1,    -1,    -1,   326,   327,   328,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   118,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   345,   346,   347,    -1,    -1,
     132,    -1,   352,   135,    -1,   355,    -1,    -1,    -1,    -1,
      -1,   143,    -1,    -1,    -1,    -1,    -1,    -1,   150,    -1,
      -1,    -1,   372,   373,    -1,    -1,   158,    -1,    -1,    -1,
      -1,    -1,   164,    -1,    -1,  3151,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   408,   409,
      -1,    -1,    -1,   195,    -1,    -1,    -1,  3183,  3184,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3195,
      -1,    -1,    -1,   433,  3200,    -1,    -1,  3203,    -1,  3205,
    3206,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   231,
      -1,   233,    -1,    -1,    -1,    -1,    -1,   239,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   247,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     262,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   489,
      -1,    -1,    -1,   493,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3614,    -1,  3269,   286,    -1,    -1,   507,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3293,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3650,   320,    -1,
      -1,    -1,    -1,    -1,    -1,  3658,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   338,    -1,    -1,    -1,
     342,    -1,    -1,    -1,   564,    -1,  3679,   567,    -1,    -1,
     570,   571,   572,   573,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3349,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   386,    -1,    -1,    -1,    -1,    -1,
      -1,   393,    -1,   395,   614,   615,    -1,    -1,    -1,    -1,
      -1,   403,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   641,    -1,    -1,    -1,    -1,    -1,    -1,  3761,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   449,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   475,    -1,    -1,    -1,    -1,    -1,    -1,
    3813,    -1,    -1,    -1,  3817,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3852,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   531,
     532,   533,    -1,  3866,    -1,    -1,   538,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   554,    -1,    -1,    -1,   558,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3903,    -1,    -1,    -1,    -1,   577,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   595,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3614,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3972,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3990,    -1,    -1,
      -1,    -1,    -1,    -1,  3650,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3658,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3679,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  4038,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  4046,    -1,    -1,    -1,    -1,    -1,  4052,
      -1,  4054,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    4143,    -1,    -1,    -1,    -1,    -1,  4149,  4150,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3813,    -1,    -1,
      -1,  3817,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  4182,
      -1,    -1,    -1,  4186,  4187,    -1,    -1,    -1,    -1,    -1,
    4193,    -1,    -1,    -1,    -1,    -1,  3852,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3866,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  4231,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  4292,
      -1,  4294,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  4304,    -1,  4306,  4307,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  4325,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  4334,    -1,    -1,    -1,  4338,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  4390,    -1,    -1,
    4046,    -1,    -1,    -1,    -1,    -1,  4052,    -1,  4054,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    4413,    -1,  4415,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  4430,  4431,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  4448,    -1,    -1,    -1,    -1,
      -1,    -1,  4455,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  4143,    -1,    -1,
      -1,    -1,    -1,    -1,  4497,    -1,    -1,    -1,    -1,    -1,
    4503,    -1,  4505,  4506,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  4520,  4521,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    4533,  4534,    -1,    -1,    -1,    -1,    -1,  4193,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  4556,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  4231,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  4600,    -1,    -1,
      -1,    -1,    -1,    -1,  4607,    -1,    -1,  4610,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  4292,    -1,  4294,    -1,
      -1,    -1,  4645,    -1,    -1,    -1,    -1,    -1,  4304,  4652,
      -1,  4654,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  4666,    -1,    -1,  4669,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  4679,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  4689,    -1,  4691,    -1,
    4693,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  4707,    -1,    -1,    -1,    -1,    -1,
      -1,  4714,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  4729,  4730,    -1,    -1,
      -1,    -1,  4735,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  4745,  4746,    -1,    -1,    -1,  4750,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  4413,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  4431,    -1,    -1,    -1,    -1,
      -1,    -1,  4785,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  4455,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  4520,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  4607,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  4645,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  4669,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,     5,    -1,     7,     8,     9,
      10,    11,    12,    -1,    -1,    15,    -1,    -1,    -1,    19,
      -1,    -1,    22,    -1,    24,    25,    26,    27,    28,    29,
      30,    31,    -1,    33,    -1,    -1,    36,    37,    38,    39,
      40,    41,    42,    -1,    44,    45,    46,    47,    48,  4735,
      50,    51,    -1,    -1,    54,    55,    56,    57,    58,    -1,
      60,    61,    62,    63,    64,    -1,    66,    67,    68,    69,
      70,    71,    72,    -1,    74,    75,    76,    77,    78,    79,
      80,    -1,    82,    83,    84,    85,    86,    87,    88,    89,
      -1,    91,    92,    -1,    94,    95,    96,    97,    98,  4785,
     100,   101,   102,   103,    -1,    -1,   106,   107,   108,   109,
     110,   111,    -1,   113,   114,   115,    -1,   117,   118,   119,
     120,   121,   122,    -1,    -1,    -1,    -1,   127,   128,   129,
      -1,    -1,   132,   133,    -1,   135,    -1,    -1,    -1,   139,
      -1,   141,   142,   143,   144,   145,    -1,    -1,    -1,   149,
      -1,    -1,   152,   153,   154,    -1,    -1,    -1,   158,    -1,
     160,   161,    -1,   163,   164,   165,    -1,    -1,   168,   169,
      -1,   171,   172,   173,   174,   175,   176,   177,   178,    -1,
     180,   181,   182,   183,   184,   185,   186,   187,    -1,   189,
     190,   191,   192,    -1,   194,    -1,    -1,    -1,   198,    -1,
     200,    -1,   202,    -1,   204,   205,   206,   207,   208,   209,
     210,    -1,   212,    -1,   214,    -1,   216,   217,   218,    -1,
     220,   221,   222,    -1,   224,   225,    -1,    -1,    -1,   229,
     230,   231,   232,   233,   234,    -1,   236,   237,   238,    -1,
     240,    -1,   242,    -1,    -1,    -1,   246,   247,   248,   249,
      -1,    -1,   252,    -1,   254,   255,    -1,   257,   258,    -1,
      -1,    -1,   262,    -1,    -1,   265,   266,   267,    -1,   269,
     270,    -1,   272,   273,   274,    -1,    -1,    -1,    -1,    -1,
     280,   281,    -1,   283,    -1,   285,    -1,   287,   288,    -1,
      -1,   291,    -1,    -1,    -1,    -1,   296,   297,   298,   299,
     300,   301,   302,   303,   304,   305,   306,   307,   308,   309,
     310,   311,    -1,   313,   314,   315,   316,   317,   318,   319,
     320,   321,   322,   323,   324,    -1,    -1,    -1,    -1,   329,
     330,   331,   332,   333,   334,    -1,    -1,   337,   338,   339,
     340,    -1,   342,   343,   344,   345,   346,   347,   348,   349,
     350,   351,   352,    -1,   354,   355,   356,    -1,    -1,   359,
     360,   361,   362,   363,   364,   365,   366,   367,    -1,   369,
     370,   371,    -1,   373,   374,   375,    -1,   377,   378,   379,
     380,    -1,   382,   383,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   392,   393,   394,    -1,   396,   397,    -1,   399,
      -1,   401,   402,   403,   404,   405,   406,   407,   408,   409,
     410,   411,    -1,   413,   414,   415,    -1,   417,    -1,   419,
     420,   421,   422,   423,    -1,   425,   426,   427,    -1,    -1,
     430,    -1,    -1,    -1,   434,   435,   436,   437,   438,    -1,
      -1,   441,   442,   443,   444,   445,    -1,   447,   448,    -1,
     450,   451,   452,   453,   454,   455,    -1,   457,    -1,   459,
     460,    -1,   462,   463,    -1,   465,    -1,   467,    -1,   469,
     470,   471,   472,   473,   474,   475,   476,   477,   478,   479,
     480,   481,    -1,   483,   484,    -1,    -1,    -1,   488,   489,
     490,   491,    -1,    -1,    -1,   495,    -1,    -1,    -1,   499,
      -1,   501,   502,   503,   504,   505,   506,    -1,   508,   509,
     510,   511,   512,   513,    -1,    -1,    -1,    -1,    -1,    -1,
     520,   521,    -1,   523,    -1,    -1,   526,    -1,    -1,   529,
     530,    -1,    -1,    -1,   534,   535,   536,   537,   538,    -1,
     540,   541,   542,   543,   544,   545,   546,   547,   548,   549,
     550,   551,   552,   553,   554,    -1,   556,    -1,   558,   559,
     560,   561,    -1,   563,   564,   565,    -1,   567,   568,   569,
     570,    -1,    -1,    -1,    -1,   575,   576,   577,   578,    -1,
     580,   581,   582,   583,   584,   585,   586,   587,   588,   589,
     590,   591,    -1,   593,   594,    -1,    -1,   597,    -1,    -1,
     600,    -1,   602,    -1,   604,   605,   606,    -1,    -1,   609,
     610,   611,   612,   613,    -1,    -1,   616,   617,    -1,   619,
     620,   621,   622,   623,   624,   625,   626,    -1,    -1,    -1,
      -1,    -1,    -1,   633,   634,    -1,   636,   637,   638,    -1,
      -1,   641,    -1,    -1,    -1,    -1,   646,   647,    -1,    -1,
      -1,    -1,   652,   653,    -1,    -1,   656,   657,    -1,    -1,
     660,   661,     5,    -1,     7,     8,     9,    10,    11,    12,
      13,    -1,    15,    -1,    -1,    -1,    19,    -1,    -1,    22,
      -1,    24,    25,    26,    27,    28,    29,    30,    31,    -1,
      33,    -1,    -1,    36,    37,    38,    39,    40,    41,    42,
      -1,    44,    45,    46,    -1,    48,    -1,    50,    51,    -1,
      -1,    54,    55,    56,    57,    58,    -1,    60,    61,    62,
      63,    64,    -1,    66,    67,    68,    69,    70,    71,    72,
      -1,    74,    75,    76,    77,    78,    79,    80,    -1,    82,
      83,    84,    85,    86,    87,    88,    89,    -1,    91,    92,
      -1,    94,    95,    96,    97,    98,    -1,   100,   101,   102,
     103,    -1,    -1,   106,   107,   108,   109,   110,   111,    -1,
     113,   114,   115,    -1,   117,   118,   119,   120,   121,   122,
      -1,    -1,    -1,    -1,   127,   128,   129,    -1,    -1,   132,
     133,    -1,   135,    -1,    -1,    -1,   139,    -1,   141,   142,
     143,   144,   145,    -1,    -1,    -1,   149,    -1,    -1,   152,
     153,   154,    -1,    -1,    -1,   158,    -1,   160,   161,    -1,
     163,   164,   165,    -1,    -1,   168,   169,    -1,   171,   172,
     173,   174,   175,   176,   177,   178,    -1,   180,   181,   182,
     183,   184,   185,   186,   187,    -1,   189,   190,   191,   192,
      -1,   194,    -1,    -1,    -1,   198,    -1,   200,    -1,   202,
      -1,   204,   205,   206,   207,   208,   209,   210,    -1,   212,
      -1,   214,    -1,   216,   217,   218,    -1,   220,   221,   222,
      -1,   224,   225,    -1,    -1,    -1,   229,   230,   231,   232,
     233,   234,    -1,   236,   237,   238,    -1,   240,    -1,   242,
      -1,    -1,    -1,   246,   247,   248,   249,    -1,    -1,   252,
      -1,   254,   255,    -1,   257,   258,    -1,    -1,    -1,   262,
      -1,    -1,   265,   266,   267,    -1,    -1,   270,    -1,   272,
     273,   274,    -1,    -1,    -1,    -1,    -1,   280,   281,    -1,
     283,    -1,   285,    -1,   287,   288,    -1,    -1,   291,    -1,
      -1,    -1,    -1,   296,   297,   298,   299,   300,   301,   302,
     303,   304,   305,   306,   307,   308,   309,   310,   311,    -1,
     313,   314,   315,   316,   317,   318,   319,   320,   321,   322,
     323,   324,    -1,    -1,    -1,    -1,   329,   330,   331,   332,
     333,   334,    -1,    -1,   337,   338,   339,   340,    -1,   342,
     343,   344,   345,   346,   347,   348,   349,   350,   351,   352,
      -1,   354,   355,   356,    -1,    -1,   359,   360,   361,   362,
     363,   364,   365,   366,   367,    -1,   369,   370,   371,    -1,
     373,   374,   375,   376,   377,   378,   379,   380,    -1,   382,
     383,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   392,
     393,   394,    -1,   396,   397,    -1,   399,    -1,   401,   402,
     403,   404,   405,   406,   407,   408,   409,   410,   411,    -1,
     413,   414,   415,    -1,   417,    -1,   419,   420,   421,   422,
     423,    -1,   425,   426,   427,    -1,    -1,   430,    -1,    -1,
      -1,   434,   435,   436,   437,   438,    -1,    -1,   441,   442,
     443,   444,   445,    -1,   447,   448,    -1,   450,   451,   452,
     453,   454,   455,    -1,   457,    -1,   459,   460,    -1,   462,
     463,    -1,   465,    -1,   467,    -1,   469,   470,   471,   472,
     473,   474,   475,   476,   477,   478,   479,   480,   481,    -1,
     483,   484,    -1,    -1,    -1,   488,   489,   490,   491,    -1,
      -1,    -1,   495,    -1,    -1,    -1,   499,    -1,   501,   502,
     503,   504,   505,   506,    -1,   508,   509,   510,   511,   512,
     513,    -1,    -1,    -1,    -1,    -1,    -1,   520,   521,    -1,
     523,    -1,    -1,   526,    -1,    -1,   529,   530,    -1,    -1,
      -1,   534,   535,   536,   537,   538,    -1,   540,   541,   542,
     543,   544,   545,   546,   547,   548,   549,   550,   551,   552,
     553,   554,    -1,   556,    -1,   558,   559,   560,   561,    -1,
     563,   564,   565,    -1,   567,   568,   569,   570,    -1,    -1,
      -1,    -1,    -1,   576,   577,   578,    -1,   580,   581,   582,
     583,   584,   585,   586,   587,   588,   589,   590,   591,    -1,
     593,   594,    -1,    -1,   597,    -1,    -1,   600,    -1,   602,
      -1,   604,   605,   606,    -1,    -1,   609,   610,   611,   612,
     613,    -1,    -1,   616,   617,    -1,   619,   620,   621,   622,
     623,   624,   625,   626,    -1,    -1,    -1,    -1,    -1,    -1,
     633,   634,    -1,   636,   637,   638,    -1,    -1,   641,    -1,
      -1,    -1,    -1,   646,   647,    -1,    -1,    -1,    -1,   652,
     653,    -1,    -1,   656,   657,    -1,    -1,   660,   661,     5,
      -1,     7,     8,     9,    10,    11,    12,    -1,    -1,    15,
      -1,    -1,    -1,    19,    -1,    -1,    22,    -1,    24,    25,
      26,    27,    28,    29,    30,    31,    -1,    33,    -1,    -1,
      36,    37,    38,    39,    40,    41,    42,    -1,    44,    45,
      46,    -1,    48,    -1,    50,    51,    -1,    -1,    54,    55,
      56,    57,    58,    -1,    60,    61,    62,    63,    64,    -1,
      66,    67,    68,    69,    70,    71,    72,    -1,    74,    75,
      76,    77,    78,    79,    80,    -1,    82,    83,    84,    85,
      86,    87,    88,    89,    -1,    91,    92,    -1,    94,    95,
      96,    97,    98,    -1,   100,   101,   102,   103,    -1,    -1,
     106,   107,   108,   109,   110,   111,    -1,   113,   114,   115,
      -1,   117,   118,   119,   120,   121,   122,    -1,    -1,    -1,
      -1,   127,   128,   129,    -1,    -1,   132,   133,    -1,   135,
      -1,    -1,    -1,   139,    -1,   141,   142,   143,   144,   145,
      -1,    -1,    -1,   149,    -1,    -1,   152,   153,   154,    -1,
      -1,    -1,   158,    -1,   160,   161,    -1,   163,   164,   165,
      -1,    -1,   168,   169,    -1,   171,   172,   173,   174,   175,
     176,   177,   178,    -1,   180,   181,   182,   183,   184,   185,
     186,   187,    -1,   189,   190,   191,   192,    -1,   194,    -1,
      -1,    -1,   198,   199,   200,    -1,   202,    -1,   204,   205,
     206,   207,   208,   209,   210,    -1,   212,    -1,   214,    -1,
     216,   217,   218,    -1,   220,   221,   222,    -1,   224,   225,
      -1,    -1,    -1,   229,   230,   231,   232,   233,   234,    -1,
     236,   237,   238,    -1,   240,    -1,   242,    -1,    -1,    -1,
     246,   247,   248,   249,    -1,    -1,   252,    -1,   254,   255,
      -1,   257,   258,    -1,    -1,    -1,   262,    -1,    -1,   265,
     266,   267,    -1,    -1,   270,    -1,   272,   273,   274,    -1,
      -1,    -1,    -1,    -1,   280,   281,    -1,   283,    -1,   285,
      -1,   287,   288,    -1,    -1,   291,    -1,    -1,    -1,    -1,
     296,   297,   298,   299,   300,   301,   302,   303,   304,   305,
     306,   307,   308,   309,   310,   311,    -1,   313,   314,   315,
     316,   317,   318,   319,   320,   321,   322,   323,   324,    -1,
      -1,    -1,    -1,   329,   330,   331,   332,   333,   334,    -1,
      -1,   337,   338,   339,   340,    -1,   342,   343,   344,   345,
     346,   347,   348,   349,   350,   351,   352,    -1,   354,   355,
     356,    -1,    -1,   359,   360,   361,   362,   363,   364,   365,
     366,   367,    -1,   369,   370,   371,    -1,   373,   374,   375,
      -1,   377,   378,   379,   380,    -1,   382,   383,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   392,   393,   394,    -1,
     396,   397,    -1,   399,    -1,   401,   402,   403,   404,   405,
     406,   407,   408,   409,   410,   411,    -1,   413,   414,   415,
      -1,   417,    -1,   419,   420,   421,   422,   423,    -1,   425,
     426,   427,    -1,    -1,   430,    -1,    -1,    -1,   434,   435,
     436,   437,   438,    -1,    -1,   441,   442,   443,   444,   445,
      -1,   447,   448,    -1,   450,   451,   452,   453,   454,   455,
      -1,   457,    -1,   459,   460,    -1,   462,   463,    -1,   465,
      -1,   467,    -1,   469,   470,   471,   472,   473,   474,   475,
     476,   477,   478,   479,   480,   481,    -1,   483,   484,    -1,
      -1,    -1,   488,   489,   490,   491,    -1,    -1,    -1,   495,
      -1,    -1,    -1,   499,    -1,   501,   502,   503,   504,   505,
     506,    -1,   508,   509,   510,   511,   512,   513,    -1,    -1,
      -1,    -1,    -1,    -1,   520,   521,    -1,   523,    -1,    -1,
     526,    -1,    -1,   529,   530,    -1,    -1,    -1,   534,   535,
     536,   537,   538,    -1,   540,   541,   542,   543,   544,   545,
     546,   547,   548,   549,   550,   551,   552,   553,   554,    -1,
     556,    -1,   558,   559,   560,   561,    -1,   563,   564,   565,
      -1,   567,   568,   569,   570,    -1,    -1,    -1,    -1,    -1,
     576,   577,   578,    -1,   580,   581,   582,   583,   584,   585,
     586,   587,   588,   589,   590,   591,    -1,   593,   594,    -1,
      -1,   597,    -1,    -1,   600,    -1,   602,    -1,   604,   605,
     606,    -1,    -1,   609,   610,   611,   612,   613,    -1,    -1,
     616,   617,    -1,   619,   620,   621,   622,   623,   624,   625,
     626,    -1,    -1,    -1,    -1,    -1,    -1,   633,   634,    -1,
     636,   637,   638,    -1,    -1,   641,    -1,    -1,    -1,    -1,
     646,   647,    -1,    -1,    -1,    -1,   652,   653,    -1,    -1,
     656,   657,    -1,    -1,   660,   661,     5,    -1,     7,     8,
       9,    10,    11,    12,    -1,    -1,    15,    -1,    -1,    -1,
      19,    -1,    -1,    22,    -1,    24,    25,    26,    27,    28,
      29,    30,    31,    -1,    33,    -1,    -1,    36,    37,    38,
      39,    40,    41,    42,    -1,    44,    45,    46,    -1,    48,
      -1,    50,    51,    -1,    -1,    54,    55,    56,    57,    58,
      -1,    60,    61,    62,    63,    64,    -1,    66,    67,    68,
      69,    70,    71,    72,    -1,    74,    75,    76,    77,    78,
      79,    80,    -1,    82,    83,    84,    85,    86,    87,    88,
      89,    -1,    91,    92,    -1,    94,    95,    96,    97,    98,
      -1,   100,   101,   102,   103,    -1,    -1,   106,   107,   108,
     109,   110,   111,    -1,   113,   114,   115,    -1,   117,   118,
     119,   120,   121,   122,    -1,    -1,    -1,    -1,   127,   128,
     129,    -1,    -1,   132,   133,    -1,   135,    -1,    -1,    -1,
     139,    -1,   141,   142,   143,   144,   145,    -1,    -1,    -1,
     149,    -1,    -1,   152,   153,   154,    -1,    -1,    -1,   158,
      -1,   160,   161,    -1,   163,   164,   165,    -1,    -1,   168,
     169,    -1,   171,   172,   173,   174,   175,   176,   177,   178,
      -1,   180,   181,   182,   183,   184,   185,   186,   187,    -1,
     189,   190,   191,   192,    -1,   194,    -1,    -1,    -1,   198,
     199,   200,    -1,   202,    -1,   204,   205,   206,   207,   208,
     209,   210,    -1,   212,    -1,   214,    -1,   216,   217,   218,
      -1,   220,   221,   222,    -1,   224,   225,    -1,    -1,    -1,
     229,   230,   231,   232,   233,   234,    -1,   236,   237,   238,
      -1,   240,    -1,   242,    -1,    -1,    -1,   246,   247,   248,
     249,    -1,    -1,   252,    -1,   254,   255,    -1,   257,   258,
      -1,    -1,    -1,   262,    -1,    -1,   265,   266,   267,    -1,
      -1,   270,    -1,   272,   273,   274,    -1,    -1,    -1,    -1,
      -1,   280,   281,    -1,   283,    -1,   285,    -1,   287,   288,
      -1,    -1,   291,    -1,    -1,    -1,    -1,   296,   297,   298,
     299,   300,   301,   302,   303,   304,   305,   306,   307,   308,
     309,   310,   311,    -1,   313,   314,   315,   316,   317,   318,
     319,   320,   321,   322,   323,   324,    -1,    -1,    -1,    -1,
     329,   330,   331,   332,   333,   334,    -1,    -1,   337,   338,
     339,   340,    -1,   342,   343,   344,   345,   346,   347,   348,
     349,   350,   351,   352,    -1,   354,   355,   356,    -1,    -1,
     359,   360,   361,   362,   363,   364,   365,   366,   367,    -1,
     369,   370,   371,    -1,   373,   374,   375,    -1,   377,   378,
     379,   380,    -1,   382,   383,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   392,   393,   394,    -1,   396,   397,    -1,
     399,    -1,   401,   402,   403,   404,   405,   406,   407,   408,
     409,   410,   411,    -1,   413,   414,   415,    -1,   417,    -1,
     419,   420,   421,   422,   423,    -1,   425,   426,   427,    -1,
      -1,   430,    -1,    -1,    -1,   434,   435,   436,   437,   438,
      -1,    -1,   441,   442,   443,   444,   445,    -1,   447,   448,
      -1,   450,   451,   452,   453,   454,   455,    -1,   457,    -1,
     459,   460,    -1,   462,   463,    -1,   465,    -1,   467,    -1,
     469,   470,   471,   472,   473,   474,   475,   476,   477,   478,
     479,   480,   481,    -1,   483,   484,    -1,    -1,    -1,   488,
     489,   490,   491,    -1,    -1,    -1,   495,    -1,    -1,    -1,
     499,    -1,   501,   502,   503,   504,   505,   506,    -1,   508,
     509,   510,   511,   512,   513,    -1,    -1,    -1,    -1,    -1,
      -1,   520,   521,    -1,   523,    -1,    -1,   526,    -1,    -1,
     529,   530,    -1,    -1,    -1,   534,   535,   536,   537,   538,
      -1,   540,   541,   542,   543,   544,   545,   546,   547,   548,
     549,   550,   551,   552,   553,   554,    -1,   556,    -1,   558,
     559,   560,   561,    -1,   563,   564,   565,    -1,   567,   568,
     569,   570,    -1,    -1,    -1,    -1,    -1,   576,   577,   578,
      -1,   580,   581,   582,   583,   584,   585,   586,   587,   588,
     589,   590,   591,    -1,   593,   594,    -1,    -1,   597,    -1,
      -1,   600,    -1,   602,    -1,   604,   605,   606,    -1,    -1,
     609,   610,   611,   612,   613,    -1,    -1,   616,   617,    -1,
     619,   620,   621,   622,   623,   624,   625,   626,    -1,    -1,
      -1,    -1,    -1,    -1,   633,   634,    -1,   636,   637,   638,
      -1,    -1,   641,    -1,    -1,    -1,    -1,   646,   647,    -1,
      -1,    -1,    -1,   652,   653,    -1,    -1,   656,   657,    -1,
      -1,   660,   661,     5,    -1,     7,     8,     9,    10,    11,
      12,    -1,    -1,    15,    -1,    -1,    -1,    19,    -1,    -1,
      22,    -1,    24,    25,    26,    27,    28,    29,    30,    31,
      -1,    33,    -1,    -1,    36,    37,    38,    39,    40,    41,
      42,    -1,    44,    45,    46,    -1,    48,    -1,    50,    51,
      -1,    -1,    54,    55,    56,    57,    58,    -1,    60,    61,
      62,    63,    64,    -1,    66,    67,    68,    69,    70,    71,
      72,    -1,    74,    75,    76,    77,    78,    79,    80,    -1,
      82,    83,    84,    85,    86,    87,    88,    89,    -1,    91,
      92,    -1,    94,    95,    96,    97,    98,    -1,   100,   101,
     102,   103,    -1,    -1,   106,   107,   108,   109,   110,   111,
      -1,   113,   114,   115,    -1,   117,   118,   119,   120,   121,
     122,    -1,    -1,    -1,    -1,   127,   128,   129,    -1,    -1,
     132,   133,    -1,   135,    -1,    -1,    -1,   139,    -1,   141,
     142,   143,   144,   145,    -1,    -1,    -1,   149,    -1,    -1,
     152,   153,   154,    -1,    -1,    -1,   158,    -1,   160,   161,
      -1,   163,   164,   165,    -1,    -1,   168,   169,    -1,   171,
     172,   173,   174,   175,   176,   177,   178,    -1,   180,   181,
     182,   183,   184,   185,   186,   187,    -1,   189,   190,   191,
     192,    -1,   194,    -1,    -1,    -1,   198,   199,   200,    -1,
     202,    -1,   204,   205,   206,   207,   208,   209,   210,    -1,
     212,    -1,   214,    -1,   216,   217,   218,    -1,   220,   221,
     222,    -1,   224,   225,    -1,    -1,    -1,   229,   230,   231,
     232,   233,   234,    -1,   236,   237,   238,    -1,   240,    -1,
     242,    -1,    -1,    -1,   246,   247,   248,   249,    -1,    -1,
     252,    -1,   254,   255,    -1,   257,   258,    -1,    -1,    -1,
     262,    -1,    -1,   265,   266,   267,    -1,    -1,   270,    -1,
     272,   273,   274,    -1,    -1,    -1,    -1,    -1,   280,   281,
      -1,   283,    -1,   285,    -1,   287,   288,    -1,    -1,   291,
      -1,    -1,    -1,    -1,   296,   297,   298,   299,   300,   301,
     302,   303,   304,   305,   306,   307,   308,   309,   310,   311,
      -1,   313,   314,   315,   316,   317,   318,   319,   320,   321,
     322,   323,   324,    -1,    -1,    -1,    -1,   329,   330,   331,
     332,   333,   334,    -1,    -1,   337,   338,   339,   340,    -1,
     342,   343,   344,   345,   346,   347,   348,   349,   350,   351,
     352,    -1,   354,   355,   356,    -1,    -1,   359,   360,   361,
     362,   363,   364,   365,   366,   367,    -1,   369,   370,   371,
      -1,   373,   374,   375,    -1,   377,   378,   379,   380,    -1,
     382,   383,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     392,   393,   394,    -1,   396,   397,    -1,   399,    -1,   401,
     402,   403,   404,   405,   406,   407,   408,   409,   410,   411,
      -1,   413,   414,   415,    -1,   417,    -1,   419,   420,   421,
     422,   423,    -1,   425,   426,   427,    -1,    -1,   430,    -1,
      -1,    -1,   434,   435,   436,   437,   438,    -1,    -1,   441,
     442,   443,   444,   445,    -1,   447,   448,    -1,   450,   451,
     452,   453,   454,   455,    -1,   457,    -1,   459,   460,    -1,
     462,   463,    -1,   465,    -1,   467,    -1,   469,   470,   471,
     472,   473,   474,   475,   476,   477,   478,   479,   480,   481,
      -1,   483,   484,    -1,    -1,    -1,   488,   489,   490,   491,
      -1,    -1,    -1,   495,    -1,    -1,    -1,   499,    -1,   501,
     502,   503,   504,   505,   506,    -1,   508,   509,   510,   511,
     512,   513,    -1,    -1,    -1,    -1,    -1,    -1,   520,   521,
      -1,   523,    -1,    -1,   526,    -1,    -1,   529,   530,    -1,
      -1,    -1,   534,   535,   536,   537,   538,    -1,   540,   541,
     542,   543,   544,   545,   546,   547,   548,   549,   550,   551,
     552,   553,   554,    -1,   556,    -1,   558,   559,   560,   561,
      -1,   563,   564,   565,    -1,   567,   568,   569,   570,    -1,
      -1,    -1,    -1,    -1,   576,   577,   578,    -1,   580,   581,
     582,   583,   584,   585,   586,   587,   588,   589,   590,   591,
      -1,   593,   594,    -1,    -1,   597,    -1,    -1,   600,    -1,
     602,    -1,   604,   605,   606,    -1,    -1,   609,   610,   611,
     612,   613,    -1,    -1,   616,   617,    -1,   619,   620,   621,
     622,   623,   624,   625,   626,    -1,    -1,    -1,    -1,    -1,
      -1,   633,   634,    -1,   636,   637,   638,    -1,    -1,   641,
      -1,    -1,    -1,    -1,   646,   647,    -1,    -1,    -1,    -1,
     652,   653,    -1,    -1,   656,   657,    -1,    -1,   660,   661,
       5,    -1,     7,     8,     9,    10,    11,    12,    -1,    -1,
      15,    -1,    -1,    -1,    19,    -1,    -1,    22,    -1,    24,
      25,    26,    27,    28,    29,    30,    31,    -1,    33,    -1,
      -1,    36,    37,    38,    39,    40,    41,    42,    -1,    44,
      45,    46,    -1,    48,    -1,    50,    51,    -1,    -1,    54,
      55,    56,    57,    58,    -1,    60,    61,    62,    63,    64,
      -1,    66,    67,    68,    69,    70,    71,    72,    -1,    74,
      75,    76,    77,    78,    79,    80,    -1,    82,    83,    84,
      85,    86,    87,    88,    89,    -1,    91,    92,    -1,    94,
      95,    96,    97,    98,    -1,   100,   101,   102,   103,    -1,
      -1,   106,   107,   108,   109,   110,   111,    -1,   113,   114,
     115,    -1,   117,   118,   119,   120,   121,   122,    -1,    -1,
      -1,    -1,   127,   128,   129,    -1,    -1,   132,   133,    -1,
     135,    -1,    -1,    -1,   139,    -1,   141,   142,   143,   144,
     145,    -1,    -1,    -1,   149,    -1,    -1,   152,   153,   154,
      -1,    -1,    -1,   158,    -1,   160,   161,    -1,   163,   164,
     165,    -1,    -1,   168,   169,    -1,   171,   172,   173,   174,
     175,   176,   177,   178,    -1,   180,   181,   182,   183,   184,
     185,   186,   187,    -1,   189,   190,   191,   192,    -1,   194,
      -1,    -1,    -1,   198,    -1,   200,    -1,   202,    -1,   204,
     205,   206,   207,   208,   209,   210,    -1,   212,    -1,   214,
      -1,   216,   217,   218,    -1,   220,   221,   222,    -1,   224,
     225,    -1,    -1,    -1,   229,   230,   231,   232,   233,   234,
      -1,   236,   237,   238,    -1,   240,    -1,   242,    -1,    -1,
      -1,   246,   247,   248,   249,    -1,    -1,   252,    -1,   254,
     255,    -1,   257,   258,    -1,    -1,    -1,   262,    -1,    -1,
     265,   266,   267,    -1,    -1,   270,    -1,   272,   273,   274,
      -1,    -1,    -1,    -1,    -1,   280,   281,    -1,   283,    -1,
     285,    -1,   287,   288,    -1,    -1,   291,    -1,    -1,    -1,
      -1,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,    -1,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
      -1,    -1,    -1,    -1,   329,   330,   331,   332,   333,   334,
      -1,    -1,   337,   338,   339,   340,    -1,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,    -1,   354,
     355,   356,    -1,    -1,   359,   360,   361,   362,   363,   364,
     365,   366,   367,    -1,   369,   370,   371,    -1,   373,   374,
     375,    -1,   377,   378,   379,   380,    -1,   382,   383,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   392,   393,   394,
      -1,   396,   397,    -1,   399,    -1,   401,   402,   403,   404,
     405,   406,   407,   408,   409,   410,   411,    -1,   413,   414,
     415,    -1,   417,    -1,   419,   420,   421,   422,   423,    -1,
     425,   426,   427,    -1,    -1,   430,    -1,    -1,    -1,   434,
     435,   436,   437,   438,    -1,    -1,   441,   442,   443,   444,
     445,    -1,   447,   448,    -1,   450,   451,   452,   453,   454,
     455,    -1,   457,    -1,   459,   460,    -1,   462,   463,    -1,
     465,    -1,   467,    -1,   469,   470,   471,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,    -1,   483,   484,
      -1,    -1,    -1,   488,   489,   490,   491,    -1,    -1,    -1,
     495,    -1,    -1,    -1,   499,    -1,   501,   502,   503,   504,
     505,   506,    -1,   508,   509,   510,   511,   512,   513,    -1,
      -1,    -1,    -1,    -1,    -1,   520,   521,    -1,   523,    -1,
      -1,   526,    -1,    -1,   529,   530,    -1,    -1,    -1,   534,
     535,   536,   537,   538,    -1,   540,   541,   542,   543,   544,
     545,   546,   547,   548,   549,   550,   551,   552,   553,   554,
      -1,   556,    -1,   558,   559,   560,   561,    -1,   563,   564,
     565,    -1,   567,   568,   569,   570,    -1,    -1,    -1,    -1,
      -1,   576,   577,   578,    -1,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,    -1,   593,   594,
      -1,    -1,   597,    -1,    -1,   600,    -1,   602,    -1,   604,
     605,   606,    -1,    -1,   609,   610,   611,   612,   613,    -1,
      -1,   616,   617,    -1,   619,   620,   621,   622,   623,   624,
     625,   626,    -1,    -1,    -1,    -1,    -1,    -1,   633,   634,
      -1,   636,   637,   638,    -1,    -1,   641,    -1,    -1,    -1,
      -1,   646,   647,    -1,    -1,    -1,    -1,   652,   653,    -1,
      -1,   656,   657,    -1,    -1,   660,   661,     5,    -1,     7,
       8,     9,    10,    11,    12,    -1,    -1,    15,    -1,    -1,
      -1,    19,    -1,    -1,    22,    -1,    24,    25,    26,    27,
      28,    29,    30,    31,    -1,    33,    -1,    -1,    36,    37,
      38,    39,    40,    41,    42,    -1,    44,    45,    46,    -1,
      48,    -1,    50,    51,    -1,    -1,    54,    55,    56,    57,
      58,    -1,    60,    61,    62,    63,    64,    -1,    66,    67,
      68,    69,    70,    71,    72,    -1,    74,    75,    76,    77,
      78,    79,    80,    -1,    82,    83,    84,    85,    86,    87,
      88,    89,    -1,    91,    92,    -1,    94,    95,    96,    97,
      98,    -1,   100,   101,   102,   103,    -1,    -1,   106,   107,
     108,   109,   110,   111,    -1,   113,   114,   115,    -1,   117,
     118,   119,   120,   121,   122,    -1,    -1,    -1,    -1,   127,
     128,   129,    -1,    -1,   132,   133,    -1,   135,    -1,    -1,
      -1,   139,    -1,   141,   142,   143,   144,   145,    -1,    -1,
      -1,   149,    -1,    -1,   152,   153,   154,    -1,    -1,    -1,
     158,    -1,   160,   161,    -1,   163,   164,   165,    -1,    -1,
     168,   169,    -1,   171,   172,   173,   174,   175,   176,   177,
     178,    -1,   180,   181,   182,   183,   184,   185,   186,   187,
      -1,   189,   190,   191,   192,    -1,   194,    -1,    -1,    -1,
     198,    -1,   200,    -1,   202,    -1,   204,   205,   206,   207,
     208,   209,   210,    -1,   212,    -1,   214,    -1,   216,   217,
     218,    -1,   220,   221,   222,    -1,   224,   225,    -1,    -1,
      -1,   229,   230,   231,   232,   233,   234,    -1,   236,   237,
     238,    -1,   240,    -1,   242,    -1,    -1,    -1,   246,   247,
     248,   249,    -1,    -1,   252,    -1,   254,   255,    -1,   257,
     258,    -1,    -1,    -1,   262,    -1,    -1,   265,   266,   267,
      -1,    -1,   270,    -1,   272,   273,   274,    -1,    -1,    -1,
      -1,    -1,   280,   281,    -1,   283,    -1,   285,    -1,   287,
     288,    -1,    -1,   291,    -1,    -1,    -1,    -1,   296,   297,
     298,   299,   300,   301,   302,   303,   304,   305,   306,   307,
     308,   309,   310,   311,    -1,   313,   314,   315,   316,   317,
     318,   319,   320,   321,   322,   323,   324,    -1,    -1,    -1,
      -1,   329,   330,   331,   332,   333,   334,    -1,    -1,   337,
     338,   339,   340,    -1,   342,   343,   344,   345,   346,   347,
     348,   349,   350,   351,   352,    -1,   354,   355,   356,    -1,
      -1,   359,   360,   361,   362,   363,   364,   365,   366,   367,
      -1,   369,   370,   371,    -1,   373,   374,   375,    -1,   377,
     378,   379,   380,    -1,   382,   383,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   392,   393,   394,    -1,   396,   397,
      -1,   399,    -1,   401,   402,   403,   404,   405,   406,   407,
     408,   409,   410,   411,    -1,   413,   414,   415,    -1,   417,
      -1,   419,   420,   421,   422,   423,    -1,   425,   426,   427,
      -1,    -1,   430,    -1,    -1,    -1,   434,   435,   436,   437,
     438,    -1,    -1,   441,   442,   443,   444,   445,    -1,   447,
     448,    -1,   450,   451,   452,   453,   454,   455,    -1,   457,
      -1,   459,   460,    -1,   462,   463,    -1,   465,    -1,   467,
      -1,   469,   470,   471,   472,   473,   474,   475,   476,   477,
     478,   479,   480,   481,    -1,   483,   484,    -1,    -1,    -1,
     488,   489,   490,   491,    -1,    -1,    -1,   495,    -1,    -1,
      -1,   499,    -1,   501,   502,   503,   504,   505,   506,    -1,
     508,   509,   510,   511,   512,   513,    -1,    -1,    -1,    -1,
      -1,    -1,   520,   521,    -1,   523,    -1,    -1,   526,    -1,
      -1,   529,   530,    -1,    -1,    -1,   534,   535,   536,   537,
     538,    -1,   540,   541,   542,   543,   544,   545,   546,   547,
     548,   549,   550,   551,   552,   553,   554,    -1,   556,    -1,
     558,   559,   560,   561,    -1,   563,   564,   565,    -1,   567,
     568,   569,   570,    -1,    -1,    -1,    -1,    -1,   576,   577,
     578,    -1,   580,   581,   582,   583,   584,   585,   586,   587,
     588,   589,   590,   591,    -1,   593,   594,    -1,    -1,   597,
      -1,    -1,   600,    -1,   602,    -1,   604,   605,   606,    -1,
      -1,   609,   610,   611,   612,   613,    -1,    -1,   616,   617,
      -1,   619,   620,   621,   622,   623,   624,   625,   626,    -1,
      -1,    -1,    -1,    -1,    -1,   633,   634,    -1,   636,   637,
     638,    -1,    -1,   641,    -1,    -1,    -1,    -1,   646,   647,
      -1,    -1,    -1,    -1,   652,   653,    -1,    -1,   656,   657,
      -1,    -1,   660,   661,     5,    -1,     7,     8,     9,    10,
      11,    12,    13,    -1,    15,    -1,    -1,    -1,    19,    -1,
      -1,    22,    -1,    24,    25,    26,    27,    28,    29,    30,
      31,    -1,    33,    -1,    -1,    36,    37,    38,    39,    40,
      41,    42,    -1,    44,    45,    46,    -1,    48,    -1,    50,
      51,    -1,    -1,    54,    55,    56,    57,    58,    -1,    60,
      61,    62,    63,    64,    -1,    66,    67,    68,    69,    70,
      71,    72,    -1,    74,    75,    76,    77,    78,    79,    80,
      -1,    82,    83,    84,    85,    86,    87,    88,    89,    -1,
      91,    92,    -1,    94,    95,    96,    97,    98,    -1,   100,
     101,   102,   103,    -1,    -1,   106,   107,   108,   109,   110,
     111,    -1,   113,   114,   115,    -1,   117,   118,   119,   120,
     121,   122,    -1,    -1,    -1,    -1,   127,   128,   129,    -1,
      -1,   132,   133,    -1,   135,    -1,    -1,    -1,   139,    -1,
     141,   142,   143,   144,   145,    -1,    -1,    -1,   149,    -1,
      -1,   152,   153,   154,    -1,    -1,    -1,   158,    -1,   160,
     161,    -1,   163,   164,   165,    -1,    -1,   168,   169,    -1,
     171,   172,   173,   174,   175,   176,   177,   178,    -1,   180,
     181,   182,   183,   184,   185,   186,   187,    -1,   189,   190,
     191,   192,    -1,   194,    -1,    -1,    -1,   198,    -1,   200,
      -1,   202,    -1,   204,   205,   206,   207,   208,   209,   210,
      -1,   212,    -1,   214,    -1,   216,   217,   218,    -1,   220,
     221,   222,    -1,   224,   225,    -1,    -1,    -1,   229,   230,
     231,   232,   233,   234,    -1,   236,   237,   238,    -1,   240,
      -1,   242,    -1,    -1,    -1,   246,   247,   248,   249,    -1,
      -1,   252,    -1,   254,   255,    -1,   257,   258,    -1,    -1,
      -1,   262,    -1,    -1,   265,   266,   267,    -1,    -1,   270,
      -1,   272,   273,   274,    -1,    -1,    -1,    -1,    -1,   280,
     281,    -1,   283,    -1,   285,    -1,   287,   288,    -1,    -1,
     291,    -1,    -1,    -1,    -1,   296,   297,   298,   299,   300,
     301,   302,   303,   304,   305,   306,   307,   308,   309,   310,
     311,    -1,   313,   314,   315,   316,   317,   318,   319,   320,
     321,   322,   323,   324,    -1,    -1,    -1,    -1,   329,   330,
     331,   332,   333,   334,    -1,    -1,   337,   338,   339,   340,
      -1,   342,   343,   344,   345,   346,   347,   348,   349,   350,
     351,   352,    -1,   354,   355,   356,    -1,    -1,   359,   360,
     361,   362,   363,    -1,   365,   366,   367,    -1,   369,   370,
     371,    -1,   373,   374,   375,    -1,   377,   378,   379,   380,
      -1,   382,   383,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   392,   393,   394,    -1,   396,   397,    -1,   399,    -1,
     401,   402,   403,   404,   405,   406,   407,   408,   409,   410,
     411,    -1,   413,   414,   415,    -1,   417,    -1,   419,   420,
     421,   422,   423,    -1,   425,   426,   427,    -1,    -1,   430,
      -1,    -1,    -1,   434,   435,   436,   437,   438,    -1,    -1,
     441,   442,   443,   444,   445,    -1,   447,   448,    -1,   450,
     451,   452,   453,   454,   455,    -1,   457,    -1,   459,   460,
      -1,   462,   463,    -1,   465,    -1,   467,    -1,   469,   470,
     471,   472,   473,   474,   475,   476,   477,   478,   479,   480,
     481,    -1,   483,   484,    -1,    -1,    -1,   488,   489,   490,
     491,    -1,    -1,    -1,   495,    -1,    -1,    -1,   499,    -1,
     501,   502,   503,   504,   505,   506,    -1,   508,   509,   510,
     511,   512,   513,    -1,    -1,    -1,    -1,    -1,    -1,   520,
     521,    -1,   523,    -1,    -1,   526,    -1,    -1,   529,   530,
      -1,    -1,    -1,   534,   535,   536,   537,   538,    -1,   540,
     541,   542,   543,   544,   545,   546,   547,   548,   549,   550,
     551,   552,   553,   554,    -1,   556,    -1,   558,   559,   560,
     561,    -1,   563,   564,   565,    -1,   567,   568,   569,   570,
      -1,    -1,    -1,    -1,    -1,   576,   577,   578,    -1,   580,
     581,   582,   583,   584,   585,   586,   587,   588,   589,   590,
     591,    -1,   593,   594,    -1,    -1,   597,    -1,    -1,   600,
      -1,   602,    -1,   604,   605,   606,    -1,    -1,   609,   610,
     611,   612,   613,    -1,    -1,   616,   617,    -1,   619,   620,
     621,   622,   623,   624,   625,   626,    -1,    -1,    -1,    -1,
      -1,    -1,   633,   634,    -1,   636,   637,   638,    -1,    -1,
     641,    -1,    -1,    -1,    -1,   646,   647,    -1,    -1,    -1,
      -1,   652,   653,    -1,    -1,   656,   657,    -1,    -1,   660,
     661,     5,    -1,     7,     8,     9,    10,    11,    12,    -1,
      -1,    15,    -1,    -1,    -1,    19,    -1,    -1,    22,    -1,
      24,    25,    26,    27,    28,    29,    30,    31,    -1,    33,
      -1,    -1,    36,    37,    38,    39,    40,    41,    42,    -1,
      44,    45,    46,    -1,    48,    -1,    50,    51,    -1,    -1,
      54,    55,    56,    57,    58,    -1,    60,    61,    62,    63,
      64,    -1,    66,    67,    68,    69,    70,    71,    72,    -1,
      74,    75,    76,    77,    78,    79,    80,    -1,    82,    83,
      84,    85,    86,    87,    88,    89,    -1,    91,    92,    -1,
      94,    95,    96,    97,    98,    -1,   100,   101,   102,   103,
      -1,    -1,   106,   107,   108,   109,   110,   111,    -1,   113,
     114,   115,    -1,   117,   118,   119,   120,   121,   122,    -1,
      -1,    -1,    -1,   127,   128,   129,    -1,    -1,   132,   133,
      -1,   135,    -1,    -1,    -1,   139,    -1,   141,   142,   143,
     144,   145,    -1,    -1,    -1,   149,    -1,    -1,   152,   153,
     154,    -1,    -1,    -1,   158,    -1,   160,   161,    -1,   163,
     164,   165,    -1,    -1,   168,   169,    -1,   171,   172,   173,
     174,   175,   176,   177,   178,    -1,   180,   181,   182,   183,
     184,   185,   186,   187,    -1,   189,   190,   191,   192,    -1,
     194,    -1,    -1,    -1,   198,    -1,   200,    -1,   202,    -1,
     204,   205,   206,   207,   208,   209,   210,    -1,   212,    -1,
     214,    -1,   216,   217,   218,    -1,   220,   221,   222,    -1,
     224,   225,    -1,    -1,    -1,   229,   230,   231,   232,   233,
     234,    -1,   236,   237,   238,    -1,   240,    -1,   242,    -1,
      -1,    -1,   246,   247,   248,   249,    -1,    -1,   252,    -1,
     254,   255,    -1,   257,   258,    -1,    -1,    -1,   262,    -1,
      -1,   265,   266,   267,    -1,    -1,   270,    -1,   272,   273,
     274,    -1,    -1,    -1,    -1,    -1,   280,   281,    -1,   283,
      -1,   285,    -1,   287,   288,    -1,    -1,   291,    -1,    -1,
      -1,    -1,   296,   297,   298,   299,   300,   301,   302,   303,
     304,   305,   306,   307,   308,   309,   310,   311,    -1,   313,
     314,   315,   316,   317,   318,   319,   320,   321,   322,   323,
     324,    -1,    -1,    -1,    -1,   329,   330,   331,   332,   333,
     334,    -1,    -1,   337,   338,   339,   340,    -1,   342,   343,
     344,   345,   346,   347,   348,   349,   350,   351,   352,    -1,
     354,   355,   356,    -1,    -1,   359,   360,   361,   362,   363,
     364,   365,   366,   367,    -1,   369,   370,   371,    -1,   373,
     374,   375,    -1,   377,   378,   379,   380,    -1,   382,   383,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   392,   393,
     394,    -1,   396,   397,    -1,   399,    -1,   401,   402,   403,
     404,   405,   406,   407,   408,   409,   410,   411,    -1,   413,
     414,   415,    -1,   417,    -1,   419,   420,   421,   422,   423,
      -1,   425,   426,   427,    -1,    -1,   430,    -1,    -1,    -1,
     434,   435,   436,   437,   438,    -1,    -1,   441,   442,   443,
     444,   445,    -1,   447,   448,    -1,   450,   451,   452,   453,
     454,   455,    -1,   457,    -1,   459,   460,    -1,   462,   463,
      -1,   465,    -1,   467,    -1,   469,   470,   471,   472,   473,
     474,   475,   476,   477,   478,   479,   480,   481,    -1,   483,
     484,    -1,    -1,    -1,   488,   489,   490,   491,    -1,    -1,
      -1,   495,    -1,    -1,    -1,   499,    -1,   501,   502,   503,
     504,   505,   506,    -1,   508,   509,   510,   511,   512,   513,
      -1,    -1,    -1,    -1,    -1,    -1,   520,   521,    -1,   523,
      -1,    -1,   526,    -1,    -1,   529,   530,    -1,    -1,    -1,
     534,   535,   536,   537,   538,    -1,   540,   541,   542,   543,
     544,   545,   546,   547,   548,   549,   550,   551,   552,   553,
     554,    -1,   556,    -1,   558,   559,   560,   561,    -1,   563,
     564,   565,    -1,   567,   568,   569,   570,    -1,    -1,    -1,
      -1,    -1,   576,   577,   578,    -1,   580,   581,   582,   583,
     584,   585,   586,   587,   588,   589,   590,   591,    -1,   593,
     594,    -1,    -1,   597,    -1,    -1,   600,    -1,   602,    -1,
     604,   605,   606,    -1,    -1,   609,   610,   611,   612,   613,
      -1,    -1,   616,   617,    -1,   619,   620,   621,   622,   623,
     624,   625,   626,    -1,    -1,    -1,    -1,    -1,    -1,   633,
     634,    -1,   636,   637,   638,    -1,    -1,   641,    -1,    -1,
      -1,    -1,   646,   647,    -1,    -1,    -1,    -1,   652,   653,
      -1,    -1,   656,   657,    -1,    -1,   660,   661,     5,    -1,
       7,     8,     9,    10,    11,    12,    -1,    -1,    15,    -1,
      -1,    -1,    19,    -1,    -1,    22,    -1,    24,    25,    26,
      27,    28,    29,    30,    31,    -1,    33,    -1,    -1,    36,
      37,    38,    39,    40,    41,    42,    -1,    44,    45,    46,
      -1,    48,    -1,    50,    51,    -1,    -1,    54,    55,    56,
      57,    58,    -1,    60,    61,    62,    63,    64,    -1,    66,
      67,    68,    69,    70,    71,    72,    -1,    74,    75,    76,
      77,    78,    79,    80,    -1,    82,    83,    84,    85,    86,
      87,    88,    89,    -1,    91,    92,    -1,    94,    95,    96,
      97,    98,    -1,   100,   101,   102,   103,    -1,    -1,   106,
     107,   108,   109,   110,   111,    -1,   113,   114,   115,    -1,
     117,   118,   119,   120,   121,   122,    -1,    -1,    -1,    -1,
     127,   128,   129,    -1,    -1,   132,   133,    -1,   135,    -1,
      -1,    -1,   139,    -1,   141,   142,   143,   144,   145,    -1,
      -1,    -1,   149,    -1,    -1,   152,   153,   154,    -1,    -1,
      -1,   158,    -1,   160,   161,    -1,   163,   164,   165,    -1,
      -1,   168,   169,    -1,   171,   172,   173,   174,   175,   176,
     177,   178,    -1,   180,   181,   182,   183,   184,   185,   186,
     187,    -1,   189,   190,   191,   192,    -1,   194,    -1,    -1,
      -1,   198,    -1,   200,    -1,   202,    -1,   204,   205,   206,
     207,   208,   209,   210,    -1,   212,    -1,   214,    -1,   216,
     217,   218,    -1,   220,   221,   222,    -1,   224,   225,    -1,
      -1,    -1,   229,   230,   231,   232,   233,   234,    -1,   236,
     237,   238,    -1,   240,    -1,   242,    -1,    -1,    -1,   246,
     247,   248,   249,    -1,    -1,   252,    -1,   254,   255,    -1,
     257,   258,    -1,    -1,    -1,   262,    -1,    -1,   265,   266,
     267,    -1,    -1,   270,    -1,   272,   273,   274,    -1,    -1,
      -1,    -1,    -1,   280,   281,    -1,   283,    -1,   285,    -1,
     287,   288,    -1,    -1,   291,    -1,    -1,    -1,    -1,   296,
     297,   298,   299,   300,   301,   302,   303,   304,   305,   306,
     307,   308,   309,   310,   311,    -1,   313,   314,   315,   316,
     317,   318,   319,   320,   321,   322,   323,   324,    -1,    -1,
      -1,    -1,   329,   330,   331,   332,   333,   334,    -1,    -1,
     337,   338,   339,   340,    -1,   342,   343,   344,   345,   346,
     347,   348,   349,   350,   351,   352,    -1,   354,   355,   356,
      -1,    -1,   359,   360,   361,   362,   363,   364,   365,   366,
     367,    -1,   369,   370,   371,    -1,   373,   374,   375,    -1,
     377,   378,   379,   380,    -1,   382,   383,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   392,   393,   394,    -1,   396,
     397,    -1,   399,    -1,   401,   402,   403,   404,   405,   406,
     407,   408,   409,   410,   411,    -1,   413,   414,   415,    -1,
     417,    -1,   419,   420,   421,   422,   423,    -1,   425,   426,
     427,    -1,    -1,   430,    -1,    -1,    -1,   434,   435,   436,
     437,   438,    -1,    -1,   441,   442,   443,   444,   445,    -1,
     447,   448,    -1,   450,   451,   452,   453,   454,   455,    -1,
     457,    -1,   459,   460,    -1,   462,   463,    -1,   465,    -1,
     467,    -1,   469,   470,   471,   472,   473,   474,   475,   476,
     477,   478,   479,   480,   481,    -1,   483,   484,    -1,    -1,
      -1,   488,   489,   490,   491,    -1,    -1,    -1,   495,    -1,
      -1,    -1,   499,    -1,   501,   502,   503,   504,   505,   506,
      -1,   508,   509,   510,   511,   512,   513,    -1,    -1,    -1,
      -1,    -1,    -1,   520,   521,    -1,   523,    -1,    -1,   526,
      -1,    -1,   529,   530,    -1,    -1,    -1,   534,   535,   536,
     537,   538,    -1,   540,   541,   542,   543,   544,   545,   546,
     547,   548,   549,   550,   551,   552,   553,   554,    -1,   556,
      -1,   558,   559,   560,   561,    -1,   563,   564,   565,    -1,
     567,   568,   569,   570,    -1,    -1,    -1,    -1,    -1,   576,
     577,   578,    -1,   580,   581,   582,   583,   584,   585,   586,
     587,   588,   589,   590,   591,    -1,   593,   594,    -1,    -1,
     597,    -1,    -1,   600,    -1,   602,    -1,   604,   605,   606,
      -1,    -1,   609,   610,   611,   612,   613,    -1,    -1,   616,
     617,    -1,   619,   620,   621,   622,   623,   624,   625,   626,
      -1,    -1,    -1,    -1,    -1,    -1,   633,   634,    -1,   636,
     637,   638,    -1,    -1,   641,    -1,    -1,    -1,    -1,   646,
     647,    -1,    -1,    -1,    -1,   652,   653,    -1,    -1,   656,
     657,    -1,    -1,   660,   661,     5,    -1,     7,     8,     9,
      10,    11,    12,    -1,    -1,    15,    -1,    -1,    -1,    19,
      -1,    -1,    22,    -1,    24,    25,    26,    27,    28,    29,
      30,    31,    -1,    33,    -1,    -1,    36,    37,    38,    39,
      40,    41,    42,    -1,    44,    45,    46,    -1,    48,    -1,
      50,    51,    -1,    -1,    54,    55,    56,    57,    58,    -1,
      60,    61,    62,    63,    64,    -1,    66,    67,    68,    69,
      70,    71,    72,    -1,    74,    75,    76,    77,    78,    79,
      80,    -1,    82,    83,    84,    85,    86,    87,    88,    89,
      -1,    91,    92,    -1,    94,    95,    96,    97,    98,    -1,
     100,   101,   102,   103,    -1,    -1,   106,   107,   108,   109,
     110,   111,    -1,   113,   114,   115,    -1,   117,   118,   119,
     120,   121,   122,    -1,    -1,    -1,    -1,   127,   128,   129,
      -1,    -1,   132,   133,    -1,   135,    -1,    -1,    -1,   139,
      -1,   141,   142,   143,   144,   145,    -1,    -1,    -1,   149,
      -1,    -1,   152,   153,   154,    -1,    -1,    -1,   158,    -1,
     160,   161,    -1,   163,   164,   165,    -1,    -1,   168,   169,
      -1,   171,   172,   173,   174,   175,   176,   177,   178,    -1,
     180,   181,   182,   183,   184,   185,   186,   187,    -1,   189,
     190,   191,   192,    -1,   194,    -1,    -1,    -1,   198,    -1,
     200,    -1,   202,    -1,   204,   205,   206,   207,   208,   209,
     210,    -1,   212,    -1,   214,    -1,   216,   217,   218,    -1,
     220,   221,   222,    -1,   224,   225,    -1,    -1,    -1,   229,
     230,   231,   232,   233,   234,    -1,   236,   237,   238,    -1,
     240,    -1,   242,    -1,    -1,    -1,   246,   247,   248,   249,
      -1,    -1,   252,    -1,   254,   255,    -1,   257,   258,    -1,
      -1,    -1,   262,    -1,    -1,   265,   266,   267,    -1,    -1,
     270,    -1,   272,   273,   274,    -1,    -1,    -1,    -1,    -1,
     280,   281,    -1,   283,    -1,   285,    -1,   287,   288,    -1,
      -1,   291,    -1,    -1,    -1,    -1,   296,   297,   298,   299,
     300,   301,   302,   303,   304,   305,   306,   307,   308,   309,
     310,   311,    -1,   313,   314,   315,   316,   317,   318,   319,
     320,   321,   322,   323,   324,    -1,    -1,    -1,    -1,   329,
     330,   331,   332,   333,   334,    -1,    -1,   337,   338,   339,
     340,    -1,   342,   343,   344,   345,   346,   347,   348,   349,
     350,   351,   352,    -1,   354,   355,   356,    -1,    -1,   359,
     360,   361,   362,   363,   364,   365,   366,   367,    -1,   369,
     370,   371,    -1,   373,   374,   375,    -1,   377,   378,   379,
     380,    -1,   382,   383,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   392,   393,   394,    -1,   396,   397,    -1,   399,
      -1,   401,   402,   403,   404,   405,   406,   407,   408,   409,
     410,   411,    -1,   413,   414,   415,    -1,   417,    -1,   419,
     420,   421,   422,   423,    -1,   425,   426,   427,    -1,    -1,
     430,    -1,    -1,    -1,   434,   435,   436,   437,   438,    -1,
      -1,   441,   442,   443,   444,   445,    -1,   447,   448,    -1,
     450,   451,   452,   453,   454,   455,    -1,   457,    -1,   459,
     460,    -1,   462,   463,    -1,   465,    -1,   467,    -1,   469,
     470,   471,   472,   473,   474,   475,   476,   477,   478,   479,
     480,   481,    -1,   483,   484,    -1,    -1,    -1,   488,   489,
     490,   491,    -1,    -1,    -1,   495,    -1,    -1,    -1,   499,
      -1,   501,   502,   503,   504,   505,   506,    -1,   508,   509,
     510,   511,   512,   513,    -1,    -1,    -1,    -1,    -1,    -1,
     520,   521,    -1,   523,    -1,    -1,   526,    -1,    -1,   529,
     530,    -1,    -1,    -1,   534,   535,   536,   537,   538,    -1,
     540,   541,   542,   543,   544,   545,   546,   547,   548,   549,
     550,   551,   552,   553,   554,    -1,   556,    -1,   558,   559,
     560,   561,    -1,   563,   564,   565,    -1,   567,   568,   569,
     570,    -1,    -1,    -1,    -1,    -1,   576,   577,   578,    -1,
     580,   581,   582,   583,   584,   585,   586,   587,   588,   589,
     590,   591,    -1,   593,   594,    -1,    -1,   597,    -1,    -1,
     600,    -1,   602,    -1,   604,   605,   606,    -1,    -1,   609,
     610,   611,   612,   613,    -1,    -1,   616,   617,    -1,   619,
     620,   621,   622,   623,   624,   625,   626,    -1,    -1,    -1,
      -1,    -1,    -1,   633,   634,    -1,   636,   637,   638,    -1,
      -1,   641,    -1,    -1,    -1,    -1,   646,   647,    -1,    -1,
      -1,    -1,   652,   653,    -1,    -1,   656,   657,    -1,    -1,
     660,   661,     5,    -1,     7,     8,     9,    10,    11,    12,
      -1,    -1,    15,    -1,    -1,    -1,    19,    -1,    -1,    22,
      -1,    24,    25,    26,    27,    28,    29,    30,    31,    -1,
      33,    -1,    -1,    36,    37,    38,    39,    40,    41,    42,
      -1,    44,    45,    46,    -1,    48,    -1,    50,    51,    -1,
      -1,    54,    55,    56,    57,    58,    -1,    60,    61,    62,
      63,    64,    -1,    66,    67,    68,    69,    70,    71,    72,
      -1,    74,    75,    76,    77,    78,    79,    80,    -1,    82,
      83,    84,    85,    86,    87,    88,    89,    -1,    91,    92,
      -1,    94,    95,    96,    97,    98,    -1,   100,   101,   102,
     103,    -1,    -1,   106,   107,   108,   109,   110,   111,    -1,
     113,   114,   115,    -1,   117,   118,   119,   120,   121,   122,
      -1,    -1,    -1,    -1,   127,   128,   129,    -1,    -1,   132,
     133,    -1,   135,    -1,    -1,    -1,   139,    -1,   141,   142,
     143,   144,   145,    -1,    -1,    -1,   149,    -1,    -1,   152,
     153,   154,    -1,    -1,    -1,   158,    -1,   160,   161,    -1,
     163,   164,   165,    -1,    -1,   168,   169,    -1,   171,   172,
     173,   174,   175,   176,   177,   178,    -1,   180,   181,   182,
     183,   184,   185,   186,   187,    -1,   189,   190,   191,   192,
      -1,   194,    -1,    -1,    -1,   198,    -1,   200,    -1,   202,
      -1,   204,   205,   206,   207,   208,   209,   210,    -1,   212,
      -1,   214,    -1,   216,   217,   218,    -1,   220,   221,   222,
      -1,   224,   225,    -1,    -1,    -1,   229,   230,   231,   232,
     233,   234,    -1,   236,   237,   238,    -1,   240,    -1,   242,
      -1,    -1,    -1,   246,   247,   248,   249,    -1,    -1,   252,
      -1,   254,   255,    -1,   257,   258,    -1,    -1,    -1,   262,
      -1,    -1,   265,   266,   267,    -1,    -1,   270,    -1,   272,
     273,   274,    -1,    -1,    -1,    -1,    -1,   280,   281,    -1,
     283,    -1,   285,    -1,   287,   288,    -1,    -1,   291,    -1,
      -1,    -1,    -1,   296,   297,   298,   299,   300,   301,   302,
     303,   304,   305,   306,   307,   308,   309,   310,   311,    -1,
     313,   314,   315,   316,   317,   318,   319,   320,   321,   322,
     323,   324,    -1,    -1,    -1,    -1,   329,   330,   331,   332,
     333,   334,    -1,    -1,   337,   338,   339,   340,    -1,   342,
     343,   344,   345,   346,   347,   348,   349,   350,   351,   352,
      -1,   354,   355,   356,    -1,    -1,   359,   360,   361,   362,
     363,   364,   365,   366,   367,    -1,   369,   370,   371,    -1,
     373,   374,   375,    -1,   377,   378,   379,   380,    -1,   382,
     383,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   392,
     393,   394,    -1,   396,   397,    -1,   399,    -1,   401,   402,
     403,   404,   405,   406,   407,   408,   409,   410,   411,    -1,
     413,   414,   415,    -1,   417,    -1,   419,   420,   421,   422,
     423,    -1,   425,   426,   427,    -1,    -1,   430,    -1,    -1,
      -1,   434,   435,   436,   437,   438,    -1,    -1,   441,   442,
     443,   444,   445,    -1,   447,   448,    -1,   450,   451,   452,
     453,   454,   455,    -1,   457,    -1,   459,   460,    -1,   462,
     463,    -1,   465,    -1,   467,    -1,   469,   470,   471,   472,
     473,   474,   475,   476,   477,   478,   479,   480,   481,    -1,
     483,   484,    -1,    -1,    -1,   488,   489,   490,   491,    -1,
      -1,    -1,   495,    -1,    -1,    -1,   499,    -1,   501,   502,
     503,   504,   505,   506,    -1,   508,   509,   510,   511,   512,
     513,    -1,    -1,    -1,    -1,    -1,    -1,   520,   521,    -1,
     523,    -1,    -1,   526,    -1,    -1,   529,   530,    -1,    -1,
      -1,   534,   535,   536,   537,   538,    -1,   540,   541,   542,
     543,   544,   545,   546,   547,   548,   549,   550,   551,   552,
     553,   554,    -1,   556,    -1,   558,   559,   560,   561,    -1,
     563,   564,   565,    -1,   567,   568,   569,   570,    -1,    -1,
      -1,    -1,    -1,   576,   577,   578,    -1,   580,   581,   582,
     583,   584,   585,   586,   587,   588,   589,   590,   591,    -1,
     593,   594,    -1,    -1,   597,    -1,    -1,   600,    -1,   602,
      -1,   604,   605,   606,    -1,    -1,   609,   610,   611,   612,
     613,    -1,    -1,   616,   617,    -1,   619,   620,   621,   622,
     623,   624,   625,   626,    -1,    -1,    -1,    -1,    -1,    -1,
     633,   634,    -1,   636,   637,   638,    -1,    -1,   641,    -1,
      -1,    -1,    -1,   646,   647,    -1,    -1,    -1,    -1,   652,
     653,    -1,    -1,   656,   657,    -1,    -1,   660,   661,     5,
      -1,     7,     8,     9,    10,    11,    12,    -1,    -1,    15,
      -1,    -1,    -1,    19,    -1,    -1,    22,    -1,    24,    25,
      26,    27,    28,    29,    30,    31,    -1,    33,    -1,    -1,
      36,    37,    38,    39,    40,    41,    42,    -1,    44,    45,
      46,    -1,    48,    -1,    50,    51,    -1,    -1,    54,    55,
      56,    57,    58,    -1,    60,    61,    62,    63,    64,    -1,
      66,    67,    68,    69,    70,    71,    72,    -1,    74,    75,
      76,    77,    78,    79,    80,    -1,    82,    83,    84,    85,
      86,    87,    88,    89,    -1,    91,    92,    -1,    94,    95,
      96,    97,    98,    -1,   100,   101,   102,   103,    -1,    -1,
     106,   107,   108,   109,   110,   111,    -1,   113,   114,   115,
      -1,   117,   118,   119,   120,   121,   122,    -1,    -1,    -1,
      -1,   127,   128,   129,    -1,    -1,   132,   133,    -1,   135,
      -1,    -1,    -1,   139,    -1,   141,   142,   143,   144,   145,
      -1,    -1,    -1,   149,    -1,    -1,   152,   153,   154,    -1,
      -1,    -1,   158,    -1,   160,   161,    -1,   163,   164,   165,
      -1,    -1,   168,   169,    -1,   171,   172,   173,   174,   175,
     176,   177,   178,    -1,   180,   181,   182,   183,   184,   185,
     186,   187,    -1,   189,   190,   191,   192,    -1,   194,    -1,
      -1,    -1,   198,    -1,   200,    -1,   202,    -1,   204,   205,
     206,   207,   208,   209,   210,    -1,   212,    -1,   214,    -1,
     216,   217,   218,    -1,   220,   221,   222,    -1,   224,   225,
      -1,    -1,    -1,   229,   230,   231,   232,   233,   234,    -1,
     236,   237,   238,    -1,   240,    -1,   242,    -1,    -1,    -1,
     246,   247,   248,   249,    -1,    -1,   252,    -1,   254,   255,
      -1,   257,   258,    -1,    -1,    -1,   262,    -1,    -1,   265,
     266,   267,    -1,    -1,   270,    -1,   272,   273,   274,    -1,
      -1,    -1,    -1,    -1,   280,   281,    -1,   283,    -1,   285,
      -1,   287,   288,    -1,    -1,   291,    -1,    -1,    -1,    -1,
     296,   297,   298,   299,   300,   301,   302,   303,   304,   305,
     306,   307,   308,   309,   310,   311,    -1,   313,   314,   315,
     316,   317,   318,   319,   320,   321,   322,   323,   324,   325,
      -1,    -1,    -1,   329,   330,   331,   332,   333,   334,    -1,
      -1,   337,   338,   339,   340,    -1,   342,   343,   344,   345,
     346,   347,   348,   349,   350,   351,   352,    -1,   354,   355,
     356,    -1,    -1,   359,   360,   361,   362,   363,    -1,   365,
     366,   367,    -1,   369,   370,   371,    -1,   373,   374,   375,
      -1,   377,   378,   379,   380,    -1,   382,   383,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   392,   393,   394,    -1,
     396,   397,    -1,   399,    -1,   401,   402,   403,   404,   405,
     406,   407,   408,   409,   410,   411,    -1,   413,   414,   415,
      -1,   417,    -1,   419,   420,   421,   422,   423,    -1,   425,
     426,   427,    -1,    -1,   430,    -1,    -1,    -1,   434,   435,
     436,   437,   438,    -1,    -1,   441,   442,   443,   444,   445,
      -1,   447,   448,    -1,   450,   451,   452,   453,   454,   455,
      -1,   457,    -1,   459,   460,    -1,   462,   463,    -1,   465,
      -1,   467,    -1,   469,   470,   471,   472,   473,   474,   475,
     476,   477,   478,   479,   480,   481,    -1,   483,   484,    -1,
      -1,    -1,   488,   489,   490,   491,    -1,    -1,    -1,   495,
      -1,    -1,    -1,   499,    -1,   501,   502,   503,   504,   505,
     506,    -1,   508,   509,   510,   511,   512,   513,    -1,    -1,
      -1,    -1,    -1,    -1,   520,   521,    -1,   523,    -1,    -1,
     526,    -1,    -1,   529,   530,    -1,    -1,    -1,   534,   535,
     536,   537,   538,    -1,   540,   541,   542,   543,   544,   545,
     546,   547,   548,   549,   550,   551,   552,   553,   554,    -1,
     556,    -1,   558,   559,   560,   561,    -1,   563,   564,   565,
      -1,   567,   568,   569,   570,    -1,    -1,    -1,    -1,    -1,
     576,   577,   578,    -1,   580,   581,   582,   583,   584,   585,
     586,   587,   588,   589,   590,   591,    -1,   593,   594,    -1,
      -1,   597,    -1,    -1,   600,    -1,   602,    -1,   604,   605,
     606,    -1,    -1,   609,   610,   611,   612,   613,    -1,    -1,
     616,   617,    -1,   619,   620,   621,   622,   623,   624,   625,
     626,    -1,    -1,    -1,    -1,    -1,    -1,   633,   634,    -1,
     636,   637,   638,    -1,    -1,   641,    -1,    -1,    -1,    -1,
     646,   647,    -1,    -1,    -1,    -1,   652,   653,    -1,    -1,
     656,   657,    -1,    -1,   660,   661,     5,    -1,     7,     8,
       9,    10,    11,    12,    -1,    -1,    15,    -1,    -1,    -1,
      19,    -1,    -1,    22,    -1,    24,    25,    26,    27,    28,
      29,    30,    31,    -1,    33,    -1,    -1,    36,    37,    38,
      39,    40,    41,    42,    -1,    44,    45,    46,    -1,    48,
      -1,    50,    51,    -1,    -1,    54,    55,    56,    57,    58,
      -1,    60,    61,    62,    63,    64,    -1,    66,    67,    68,
      69,    70,    71,    72,    -1,    74,    75,    76,    77,    78,
      79,    80,    -1,    82,    83,    84,    85,    86,    87,    88,
      89,    -1,    91,    92,    -1,    94,    95,    96,    97,    98,
      -1,   100,   101,   102,   103,    -1,    -1,   106,   107,   108,
     109,   110,   111,    -1,   113,   114,   115,    -1,   117,   118,
     119,   120,   121,   122,    -1,    -1,    -1,    -1,   127,   128,
     129,    -1,    -1,   132,   133,    -1,   135,    -1,    -1,    -1,
     139,    -1,   141,   142,   143,   144,   145,    -1,    -1,    -1,
     149,    -1,    -1,   152,   153,   154,    -1,    -1,    -1,   158,
      -1,   160,   161,    -1,   163,   164,   165,    -1,    -1,   168,
     169,    -1,   171,   172,   173,   174,   175,   176,   177,   178,
      -1,   180,   181,   182,   183,   184,   185,   186,   187,    -1,
     189,   190,   191,   192,    -1,   194,    -1,    -1,    -1,   198,
      -1,   200,    -1,   202,    -1,   204,   205,   206,   207,   208,
     209,   210,    -1,   212,    -1,   214,    -1,   216,   217,   218,
      -1,   220,   221,   222,    -1,   224,   225,    -1,    -1,    -1,
     229,   230,   231,   232,   233,   234,    -1,   236,   237,   238,
      -1,   240,    -1,   242,    -1,    -1,    -1,   246,   247,   248,
     249,    -1,    -1,   252,    -1,   254,   255,    -1,   257,   258,
      -1,    -1,    -1,   262,    -1,    -1,   265,   266,   267,    -1,
      -1,   270,    -1,   272,   273,   274,    -1,    -1,    -1,    -1,
      -1,   280,   281,    -1,   283,    -1,   285,    -1,   287,   288,
      -1,    -1,   291,    -1,    -1,    -1,    -1,   296,   297,   298,
     299,   300,   301,   302,   303,   304,   305,   306,   307,   308,
     309,   310,   311,    -1,   313,   314,   315,   316,   317,   318,
     319,   320,   321,   322,   323,   324,    -1,    -1,    -1,    -1,
     329,   330,   331,   332,   333,   334,    -1,    -1,   337,   338,
     339,   340,    -1,   342,   343,   344,   345,   346,   347,   348,
     349,   350,   351,   352,    -1,   354,   355,   356,    -1,    -1,
     359,   360,   361,   362,   363,    -1,   365,   366,   367,    -1,
     369,   370,   371,    -1,   373,   374,   375,    -1,   377,   378,
     379,   380,    -1,   382,   383,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   392,   393,   394,    -1,   396,   397,    -1,
     399,    -1,   401,   402,   403,   404,   405,   406,   407,   408,
     409,   410,   411,    -1,   413,   414,   415,    -1,   417,    -1,
     419,   420,   421,   422,   423,    -1,   425,   426,   427,    -1,
      -1,   430,    -1,    -1,    -1,   434,   435,   436,   437,   438,
      -1,    -1,   441,   442,   443,   444,   445,    -1,   447,   448,
      -1,   450,   451,   452,   453,   454,   455,    -1,   457,    -1,
     459,   460,    -1,   462,   463,    -1,   465,    -1,   467,    -1,
     469,   470,   471,   472,   473,   474,   475,   476,   477,   478,
     479,   480,   481,    -1,   483,   484,    -1,    -1,    -1,   488,
     489,   490,   491,    -1,    -1,    -1,   495,    -1,    -1,    -1,
     499,    -1,   501,   502,   503,   504,   505,   506,    -1,   508,
     509,   510,   511,   512,   513,    -1,    -1,    -1,    -1,    -1,
      -1,   520,   521,    -1,   523,    -1,    -1,   526,    -1,    -1,
     529,   530,    -1,    -1,    -1,   534,   535,   536,   537,   538,
      -1,   540,   541,   542,   543,   544,   545,   546,   547,   548,
     549,   550,   551,   552,   553,   554,    -1,   556,    -1,   558,
     559,   560,   561,    -1,   563,   564,   565,    -1,   567,   568,
     569,   570,    -1,    -1,    -1,    -1,    -1,   576,   577,   578,
      -1,   580,   581,   582,   583,   584,   585,   586,   587,   588,
     589,   590,   591,    -1,   593,   594,    -1,    -1,   597,    -1,
      -1,   600,    -1,   602,    -1,   604,   605,   606,    -1,    -1,
     609,   610,   611,   612,   613,    -1,    -1,   616,   617,    -1,
     619,   620,   621,   622,   623,   624,   625,   626,    -1,    -1,
      -1,    -1,    -1,    -1,   633,   634,    -1,   636,   637,   638,
      -1,    -1,   641,    -1,    -1,    -1,    -1,   646,   647,    -1,
      -1,    -1,    -1,   652,   653,    -1,    -1,   656,   657,    -1,
      -1,   660,   661,     5,    -1,     7,     8,     9,    10,    11,
      12,    -1,    -1,    15,    -1,    -1,    -1,    19,    -1,    -1,
      22,    -1,    24,    25,    26,    27,    28,    29,    30,    31,
      -1,    33,    -1,    -1,    36,    37,    38,    39,    40,    41,
      42,    -1,    44,    45,    46,    -1,    48,    -1,    50,    51,
      -1,    -1,    54,    55,    56,    57,    58,    -1,    60,    61,
      62,    63,    64,    -1,    66,    67,    68,    69,    70,    71,
      72,    -1,    74,    75,    76,    77,    78,    79,    80,    -1,
      82,    83,    84,    85,    86,    87,    88,    89,    -1,    91,
      92,    -1,    94,    95,    96,    97,    98,    -1,   100,   101,
     102,   103,    -1,    -1,   106,   107,   108,   109,   110,   111,
      -1,   113,   114,   115,    -1,   117,   118,   119,   120,   121,
     122,    -1,    -1,    -1,    -1,   127,   128,   129,    -1,    -1,
     132,   133,    -1,   135,    -1,    -1,    -1,   139,    -1,   141,
     142,   143,   144,   145,    -1,    -1,    -1,   149,    -1,    -1,
     152,   153,   154,    -1,    -1,    -1,   158,    -1,   160,   161,
      -1,   163,   164,   165,    -1,    -1,   168,   169,    -1,   171,
     172,   173,   174,   175,   176,   177,   178,    -1,   180,   181,
     182,   183,   184,   185,   186,   187,    -1,   189,   190,   191,
     192,    -1,   194,    -1,    -1,    -1,   198,    -1,   200,    -1,
     202,    -1,   204,   205,   206,   207,   208,   209,   210,    -1,
     212,    -1,   214,    -1,   216,   217,   218,    -1,   220,   221,
     222,    -1,   224,   225,    -1,    -1,    -1,   229,   230,   231,
     232,   233,   234,    -1,   236,   237,   238,    -1,   240,    -1,
     242,    -1,    -1,    -1,   246,   247,   248,   249,    -1,    -1,
     252,    -1,   254,   255,    -1,   257,   258,    -1,    -1,    -1,
     262,    -1,    -1,   265,   266,   267,    -1,    -1,   270,    -1,
     272,   273,   274,    -1,    -1,    -1,    -1,    -1,   280,   281,
      -1,   283,    -1,   285,    -1,   287,   288,    -1,    -1,   291,
      -1,    -1,    -1,    -1,   296,   297,   298,   299,   300,   301,
     302,   303,   304,   305,   306,   307,   308,   309,   310,   311,
      -1,   313,   314,   315,   316,   317,   318,   319,   320,   321,
     322,   323,   324,    -1,    -1,    -1,    -1,   329,   330,   331,
     332,   333,   334,    -1,    -1,   337,   338,   339,   340,    -1,
     342,   343,   344,   345,   346,   347,   348,   349,   350,   351,
     352,    -1,   354,   355,   356,    -1,    -1,   359,   360,   361,
     362,   363,    -1,   365,   366,   367,    -1,   369,   370,   371,
      -1,   373,   374,   375,    -1,   377,   378,   379,   380,    -1,
     382,   383,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     392,   393,   394,    -1,   396,   397,    -1,   399,    -1,   401,
     402,   403,   404,   405,   406,   407,   408,   409,   410,   411,
      -1,   413,   414,   415,    -1,   417,    -1,   419,   420,   421,
     422,   423,    -1,   425,   426,   427,    -1,    -1,   430,    -1,
      -1,    -1,   434,   435,   436,   437,   438,    -1,    -1,   441,
     442,   443,   444,   445,    -1,   447,   448,    -1,   450,   451,
     452,   453,   454,   455,    -1,   457,    -1,   459,   460,    -1,
     462,   463,    -1,   465,    -1,   467,    -1,   469,   470,   471,
     472,   473,   474,   475,   476,   477,   478,   479,   480,   481,
      -1,   483,   484,    -1,    -1,    -1,   488,   489,   490,   491,
      -1,    -1,    -1,   495,    -1,    -1,    -1,   499,    -1,   501,
     502,   503,   504,   505,   506,    -1,   508,   509,   510,   511,
     512,   513,    -1,    -1,    -1,    -1,    -1,    -1,   520,   521,
      -1,   523,    -1,    -1,   526,    -1,    -1,   529,   530,    -1,
      -1,    -1,   534,   535,   536,   537,   538,    -1,   540,   541,
     542,   543,   544,   545,   546,   547,   548,   549,   550,   551,
     552,   553,   554,    -1,   556,    -1,   558,   559,   560,   561,
      -1,   563,   564,   565,    -1,   567,   568,   569,   570,    -1,
      -1,    -1,    -1,    -1,   576,   577,   578,    -1,   580,   581,
     582,   583,   584,   585,   586,   587,   588,   589,   590,   591,
      -1,   593,   594,    -1,    -1,   597,    -1,    -1,   600,    -1,
     602,    -1,   604,   605,   606,    -1,    -1,   609,   610,   611,
     612,   613,    -1,    -1,   616,   617,    -1,   619,   620,   621,
     622,   623,   624,   625,   626,    -1,    -1,    -1,    -1,    -1,
      -1,   633,   634,    -1,   636,   637,   638,    -1,    -1,   641,
      -1,    -1,    -1,    -1,   646,   647,    -1,    -1,    -1,    -1,
     652,   653,    -1,    -1,   656,   657,    -1,    -1,   660,   661,
       5,    -1,     7,     8,     9,    10,    11,    12,    -1,    -1,
      15,    -1,    -1,    -1,    19,    -1,    -1,    22,    -1,    24,
      25,    26,    27,    28,    29,    30,    31,    -1,    33,    -1,
      -1,    36,    37,    38,    39,    40,    41,    42,    -1,    44,
      45,    46,    -1,    48,    -1,    50,    51,    -1,    -1,    54,
      55,    56,    57,    58,    -1,    60,    61,    62,    63,    64,
      -1,    66,    67,    68,    69,    70,    71,    72,    -1,    74,
      75,    76,    77,    78,    79,    80,    -1,    82,    83,    84,
      85,    86,    87,    88,    89,    -1,    91,    92,    -1,    94,
      95,    96,    97,    98,    -1,   100,   101,   102,   103,    -1,
      -1,   106,   107,   108,   109,   110,   111,    -1,   113,   114,
     115,    -1,   117,   118,   119,   120,   121,   122,    -1,    -1,
      -1,    -1,   127,   128,   129,    -1,    -1,   132,   133,    -1,
     135,    -1,    -1,    -1,   139,    -1,   141,   142,   143,   144,
     145,    -1,    -1,    -1,   149,    -1,    -1,   152,   153,   154,
      -1,    -1,    -1,   158,    -1,   160,   161,    -1,   163,   164,
     165,    -1,    -1,   168,   169,    -1,   171,   172,   173,   174,
     175,   176,   177,   178,    -1,   180,   181,   182,   183,   184,
     185,   186,   187,    -1,   189,   190,   191,   192,    -1,   194,
      -1,    -1,    -1,   198,    -1,   200,    -1,   202,    -1,   204,
     205,   206,   207,   208,   209,   210,    -1,   212,    -1,   214,
      -1,   216,   217,   218,    -1,   220,   221,   222,    -1,   224,
     225,    -1,    -1,    -1,   229,   230,   231,   232,   233,   234,
      -1,   236,   237,   238,    -1,   240,    -1,   242,    -1,    -1,
      -1,   246,   247,   248,   249,    -1,    -1,   252,    -1,   254,
     255,    -1,   257,   258,    -1,    -1,    -1,   262,    -1,    -1,
     265,   266,   267,    -1,    -1,   270,    -1,   272,   273,   274,
      -1,    -1,    -1,    -1,    -1,   280,   281,    -1,   283,    -1,
     285,    -1,   287,   288,    -1,    -1,   291,    -1,    -1,    -1,
      -1,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,    -1,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
      -1,    -1,    -1,    -1,   329,   330,   331,   332,   333,   334,
      -1,    -1,   337,   338,   339,   340,    -1,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,    -1,   354,
     355,   356,    -1,    -1,   359,   360,   361,   362,   363,    -1,
     365,   366,   367,    -1,   369,   370,   371,    -1,   373,   374,
     375,    -1,   377,   378,   379,   380,    -1,   382,   383,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   392,   393,   394,
      -1,   396,   397,    -1,   399,    -1,   401,   402,   403,   404,
     405,   406,   407,   408,   409,   410,   411,    -1,   413,   414,
     415,    -1,   417,    -1,   419,   420,   421,   422,   423,    -1,
     425,   426,   427,    -1,    -1,   430,    -1,    -1,    -1,   434,
     435,   436,   437,   438,    -1,    -1,   441,   442,   443,   444,
     445,    -1,   447,   448,    -1,   450,   451,   452,   453,   454,
     455,    -1,   457,    -1,   459,   460,    -1,   462,   463,    -1,
     465,    -1,   467,    -1,   469,   470,   471,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,    -1,   483,   484,
      -1,    -1,    -1,   488,   489,   490,   491,    -1,    -1,    -1,
     495,    -1,    -1,    -1,   499,    -1,   501,   502,   503,   504,
     505,   506,    -1,   508,   509,   510,   511,   512,   513,    -1,
      -1,    -1,    -1,    -1,    -1,   520,   521,    -1,   523,    -1,
      -1,   526,    -1,    -1,   529,   530,    -1,    -1,    -1,   534,
     535,   536,   537,   538,    -1,   540,   541,   542,   543,   544,
     545,   546,   547,   548,   549,   550,   551,   552,   553,   554,
      -1,   556,    -1,   558,   559,   560,   561,    -1,   563,   564,
     565,    -1,   567,   568,   569,   570,    -1,    -1,    -1,    -1,
      -1,   576,   577,   578,    -1,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,    -1,   593,   594,
      -1,    -1,   597,    -1,    -1,   600,    -1,   602,    -1,   604,
     605,   606,    -1,    -1,   609,   610,   611,   612,   613,    -1,
      -1,   616,   617,    -1,   619,   620,   621,   622,   623,   624,
     625,   626,    -1,    -1,    -1,    -1,    -1,    -1,   633,   634,
      -1,   636,   637,   638,    -1,    -1,   641,    -1,    -1,    -1,
      -1,   646,   647,    -1,    -1,    -1,    -1,   652,   653,    -1,
      -1,   656,   657,    -1,    -1,   660,   661,     5,    -1,     7,
       8,     9,    10,    11,    12,    -1,    -1,    15,    -1,    -1,
      -1,    19,    -1,    -1,    22,    -1,    24,    25,    26,    27,
      28,    29,    30,    31,    -1,    33,    -1,    -1,    -1,    37,
      38,    -1,    -1,    41,    -1,    -1,    44,    45,    46,    -1,
      48,    -1,    50,    51,    -1,    -1,    54,    -1,    -1,    57,
      58,    -1,    60,    61,    -1,    63,    64,    -1,    66,    67,
      68,    69,    70,    71,    72,    -1,    74,    75,    76,    77,
      78,    79,    80,    -1,    82,    83,    84,    85,    86,    87,
      88,    89,    -1,    91,    92,    -1,    94,    95,    96,    97,
      98,    -1,   100,    -1,    -1,   103,    -1,    -1,   106,    -1,
     108,    -1,    -1,   111,    -1,   113,    -1,    -1,    -1,   117,
     118,   119,    -1,    -1,   122,    -1,    -1,    -1,    -1,   127,
     128,   129,    -1,    -1,    -1,   133,    -1,   135,    -1,    -1,
      -1,   139,    -1,   141,   142,   143,   144,   145,    -1,    -1,
      -1,   149,    -1,    -1,   152,   153,   154,    -1,    -1,    -1,
     158,    -1,   160,   161,    -1,   163,   164,   165,    -1,    -1,
     168,   169,    -1,   171,   172,   173,   174,   175,   176,   177,
      -1,    -1,   180,   181,   182,   183,    -1,   185,   186,   187,
      -1,   189,   190,   191,   192,    -1,   194,    -1,    -1,    -1,
     198,    -1,   200,    -1,   202,    -1,   204,   205,   206,   207,
     208,   209,   210,    -1,   212,    -1,    -1,    -1,   216,   217,
     218,    -1,   220,   221,   222,    -1,   224,   225,    -1,    -1,
      -1,   229,   230,   231,   232,   233,    -1,    -1,   236,   237,
     238,    -1,   240,    -1,   242,    -1,    -1,    -1,    -1,   247,
     248,    -1,    -1,    -1,   252,    -1,   254,   255,    -1,   257,
     258,    -1,    -1,    -1,   262,    -1,    -1,   265,   266,   267,
      -1,    -1,   270,    -1,    -1,   273,   274,    -1,    -1,    -1,
      -1,    -1,   280,   281,    -1,   283,    -1,   285,    -1,   287,
     288,    -1,    -1,   291,    -1,    -1,    -1,    -1,   296,   297,
     298,   299,   300,   301,   302,   303,   304,   305,   306,   307,
     308,   309,   310,   311,    -1,   313,   314,   315,   316,    -1,
     318,   319,   320,   321,    -1,   323,   324,    -1,    -1,    -1,
      -1,   329,   330,   331,   332,   333,   334,    -1,    -1,   337,
     338,    -1,   340,    -1,   342,    -1,   344,   345,   346,   347,
     348,   349,   350,   351,   352,    -1,   354,   355,   356,    -1,
      -1,   359,   360,   361,   362,    -1,    -1,    -1,   366,   367,
      -1,   369,   370,   371,    -1,   373,   374,   375,    -1,   377,
     378,   379,   380,    -1,   382,   383,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   392,   393,   394,    -1,    -1,   397,
      -1,   399,    -1,   401,   402,   403,   404,   405,   406,   407,
     408,   409,   410,    -1,    -1,   413,   414,   415,    -1,   417,
      -1,   419,   420,   421,   422,   423,    -1,   425,   426,   427,
      -1,    -1,   430,    -1,    -1,    -1,   434,   435,   436,   437,
     438,    -1,    -1,   441,   442,   443,   444,   445,    -1,   447,
     448,    -1,   450,   451,   452,    -1,    -1,   455,    -1,   457,
      -1,   459,   460,    -1,   462,   463,    -1,   465,    -1,   467,
      -1,    -1,   470,   471,   472,   473,   474,   475,   476,   477,
     478,   479,   480,   481,    -1,   483,   484,    -1,    -1,    -1,
     488,   489,   490,   491,    -1,    -1,    -1,   495,    -1,    -1,
      -1,   499,    -1,   501,   502,   503,   504,   505,   506,    -1,
     508,   509,   510,   511,   512,   513,    -1,    -1,    -1,    -1,
      -1,    -1,   520,   521,    -1,   523,    -1,    -1,   526,    -1,
      -1,   529,   530,    -1,    -1,    -1,   534,    -1,    -1,   537,
     538,    -1,   540,   541,   542,   543,   544,   545,    -1,    -1,
     548,   549,   550,   551,    -1,   553,   554,    -1,   556,    -1,
     558,   559,   560,   561,    -1,   563,   564,   565,    -1,   567,
     568,   569,   570,    -1,    -1,    -1,    -1,    -1,   576,   577,
     578,    -1,    -1,   581,   582,   583,   584,   585,   586,   587,
     588,   589,   590,   591,    -1,   593,   594,    -1,    -1,   597,
      -1,    -1,   600,    -1,   602,    -1,   604,   605,   606,    -1,
      -1,    -1,    -1,    -1,    -1,   613,    -1,    -1,   616,    -1,
      -1,    -1,   620,   621,   622,   623,   624,   625,   626,    -1,
      -1,    -1,    -1,    -1,    -1,   633,   634,    -1,   636,   637,
     638,    -1,    -1,   641,    -1,    -1,    -1,     5,    -1,     7,
       8,     9,    10,    11,    12,    -1,    -1,    15,    -1,    -1,
      -1,    19,   660,   661,    22,    -1,    24,    25,    26,    27,
      28,    29,    30,    31,    -1,    33,    -1,    -1,    -1,    37,
      -1,    -1,    -1,    41,    -1,    -1,    44,    45,    46,    -1,
      48,    -1,    50,    51,    -1,    -1,    54,    -1,    -1,    57,
      58,    -1,    60,    61,    -1,    63,    64,    -1,    66,    67,
      68,    69,    70,    71,    72,    -1,    74,    75,    76,    77,
      78,    79,    80,    -1,    82,    83,    84,    85,    86,    87,
      88,    89,    -1,    91,    92,    93,    94,    95,    96,    97,
      98,    -1,   100,    -1,    -1,   103,    -1,    -1,   106,    -1,
     108,    -1,    -1,   111,    -1,   113,    -1,    -1,    -1,   117,
     118,   119,    -1,    -1,   122,    -1,    -1,    -1,    -1,   127,
     128,    -1,    -1,    -1,    -1,   133,    -1,   135,    -1,    -1,
      -1,   139,    -1,   141,   142,   143,   144,   145,    -1,    -1,
      -1,   149,    -1,    -1,   152,   153,   154,    -1,    -1,    -1,
     158,    -1,   160,   161,    -1,   163,   164,   165,    -1,    -1,
     168,   169,    -1,   171,   172,   173,   174,   175,   176,   177,
      -1,    -1,   180,   181,   182,   183,    -1,    -1,   186,   187,
      -1,   189,   190,   191,    -1,    -1,   194,    -1,    -1,    -1,
     198,    -1,   200,   201,   202,    -1,   204,   205,   206,   207,
     208,   209,   210,    -1,   212,    -1,    -1,    -1,   216,   217,
     218,    -1,   220,    -1,    -1,    -1,   224,   225,    -1,    -1,
      -1,   229,   230,   231,   232,   233,    -1,    -1,   236,   237,
     238,   239,   240,    -1,   242,    -1,    -1,    -1,    -1,   247,
     248,    -1,    -1,    -1,   252,    -1,   254,   255,    -1,   257,
     258,    -1,    -1,    -1,   262,   263,    -1,   265,   266,   267,
      -1,    -1,   270,    -1,    -1,   273,   274,    -1,   276,    -1,
      -1,    -1,   280,   281,    -1,   283,    -1,   285,    -1,   287,
     288,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   296,   297,
     298,   299,   300,   301,   302,   303,   304,   305,   306,   307,
     308,   309,   310,   311,    -1,   313,   314,   315,   316,    -1,
     318,   319,   320,   321,    -1,   323,   324,    -1,    -1,    -1,
      -1,   329,   330,   331,   332,   333,   334,    -1,    -1,   337,
     338,    -1,   340,    -1,   342,    -1,   344,   345,   346,   347,
     348,   349,   350,   351,   352,    -1,    -1,   355,   356,    -1,
      -1,   359,   360,   361,   362,    -1,    -1,    -1,   366,   367,
      -1,    -1,    -1,   371,    -1,   373,   374,   375,    -1,   377,
     378,   379,   380,    -1,   382,   383,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   392,   393,   394,    -1,    -1,   397,
      -1,   399,    -1,   401,   402,   403,   404,   405,   406,   407,
     408,   409,   410,    -1,    -1,   413,   414,   415,    -1,   417,
      -1,   419,   420,   421,   422,   423,    -1,   425,   426,   427,
      -1,    -1,   430,    -1,    -1,    -1,   434,   435,   436,   437,
     438,    -1,    -1,   441,   442,   443,   444,   445,    -1,   447,
     448,    -1,   450,   451,   452,    -1,    -1,   455,    -1,   457,
      -1,   459,   460,    -1,   462,   463,    -1,   465,    -1,   467,
      -1,    -1,   470,   471,   472,   473,   474,   475,   476,   477,
     478,   479,   480,   481,    -1,   483,   484,   485,    -1,    -1,
     488,   489,   490,   491,    -1,    -1,    -1,   495,    -1,    -1,
      -1,   499,    -1,   501,   502,   503,   504,   505,   506,    -1,
     508,   509,   510,   511,   512,   513,   514,    -1,    -1,    -1,
      -1,    -1,   520,   521,    -1,   523,    -1,    -1,   526,    -1,
      -1,   529,   530,    -1,    -1,    -1,   534,    -1,    -1,   537,
     538,    -1,   540,   541,   542,   543,   544,   545,    -1,    -1,
     548,   549,   550,   551,    -1,   553,   554,    -1,   556,    -1,
     558,   559,   560,   561,    -1,    -1,   564,   565,    -1,   567,
     568,   569,   570,    -1,    -1,    -1,    -1,    -1,   576,   577,
     578,    -1,    -1,    -1,   582,   583,   584,   585,    -1,   587,
     588,    -1,   590,   591,    -1,   593,   594,    -1,    -1,   597,
      -1,    -1,   600,    -1,   602,    -1,   604,   605,   606,    -1,
      -1,    -1,    -1,    -1,    -1,   613,    -1,    -1,   616,    -1,
      -1,    -1,   620,   621,   622,   623,   624,   625,   626,    -1,
      -1,    -1,    -1,    -1,    -1,   633,   634,    -1,   636,   637,
     638,    -1,    -1,   641,    -1,     5,    -1,     7,     8,     9,
      10,    11,    12,    -1,    -1,    15,    -1,    -1,    -1,    19,
      -1,    -1,    22,   661,    24,    25,    26,    27,    28,    29,
      30,    31,    -1,    33,    -1,    -1,    -1,    37,    -1,    -1,
      -1,    41,    -1,    -1,    44,    45,    46,    -1,    48,    -1,
      50,    51,    -1,    -1,    54,    -1,    -1,    57,    58,    -1,
      60,    61,    -1,    63,    64,    -1,    66,    67,    68,    69,
      70,    71,    72,    -1,    74,    75,    76,    77,    78,    79,
      80,    -1,    82,    83,    84,    85,    86,    87,    88,    89,
      -1,    91,    92,    93,    94,    95,    96,    97,    98,    -1,
     100,    -1,    -1,   103,    -1,    -1,   106,    -1,   108,    -1,
      -1,   111,    -1,   113,    -1,    -1,    -1,   117,   118,   119,
      -1,    -1,   122,    -1,    -1,    -1,    -1,   127,   128,    -1,
      -1,    -1,    -1,   133,    -1,   135,    -1,    -1,    -1,   139,
      -1,   141,   142,   143,   144,   145,    -1,    -1,    -1,   149,
      -1,    -1,   152,   153,   154,    -1,    -1,    -1,   158,    -1,
     160,   161,    -1,   163,   164,   165,    -1,    -1,   168,   169,
      -1,   171,   172,   173,   174,   175,   176,   177,    -1,    -1,
     180,   181,   182,   183,    -1,    -1,   186,   187,    -1,   189,
     190,   191,    -1,    -1,   194,    -1,    -1,    -1,   198,    -1,
     200,   201,   202,    -1,   204,   205,   206,   207,   208,   209,
     210,    -1,   212,    -1,    -1,    -1,   216,   217,   218,    -1,
     220,    -1,    -1,    -1,   224,   225,    -1,    -1,    -1,   229,
     230,   231,   232,   233,    -1,    -1,   236,   237,   238,   239,
     240,    -1,   242,    -1,    -1,    -1,    -1,   247,   248,    -1,
      -1,    -1,   252,    -1,   254,   255,    -1,   257,   258,    -1,
      -1,    -1,   262,   263,    -1,   265,   266,   267,    -1,    -1,
     270,    -1,    -1,   273,   274,    -1,    -1,    -1,    -1,    -1,
     280,   281,    -1,   283,    -1,   285,    -1,   287,   288,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   296,   297,   298,   299,
     300,   301,   302,   303,   304,   305,   306,   307,   308,   309,
     310,   311,    -1,   313,   314,   315,   316,    -1,   318,   319,
     320,   321,    -1,   323,   324,    -1,    -1,    -1,    -1,   329,
     330,   331,   332,   333,   334,    -1,    -1,   337,   338,    -1,
     340,    -1,   342,    -1,   344,   345,   346,   347,   348,   349,
     350,   351,   352,    -1,    -1,   355,   356,    -1,    -1,   359,
     360,   361,   362,    -1,    -1,    -1,   366,   367,    -1,    -1,
      -1,   371,    -1,   373,   374,   375,    -1,   377,   378,   379,
     380,    -1,   382,   383,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   392,   393,   394,    -1,    -1,   397,    -1,   399,
      -1,   401,   402,   403,   404,   405,   406,   407,   408,   409,
     410,    -1,    -1,   413,   414,   415,    -1,   417,    -1,   419,
     420,   421,   422,   423,    -1,   425,   426,   427,    -1,    -1,
     430,    -1,    -1,    -1,   434,   435,   436,   437,   438,    -1,
      -1,   441,   442,   443,   444,   445,    -1,   447,   448,    -1,
     450,   451,   452,    -1,    -1,   455,    -1,   457,    -1,   459,
     460,    -1,   462,   463,    -1,   465,    -1,   467,    -1,    -1,
     470,   471,   472,   473,   474,   475,   476,   477,   478,   479,
     480,   481,    -1,   483,   484,    -1,    -1,    -1,   488,   489,
     490,   491,    -1,    -1,    -1,   495,    -1,    -1,    -1,   499,
      -1,   501,   502,   503,   504,   505,   506,    -1,   508,   509,
     510,   511,   512,   513,   514,    -1,    -1,    -1,    -1,    -1,
     520,   521,    -1,   523,    -1,    -1,   526,    -1,    -1,   529,
     530,    -1,    -1,    -1,   534,    -1,    -1,   537,   538,    -1,
     540,   541,   542,   543,   544,   545,    -1,    -1,   548,   549,
     550,   551,    -1,   553,   554,    -1,   556,    -1,   558,   559,
     560,   561,    -1,    -1,   564,   565,    -1,   567,   568,   569,
     570,    -1,    -1,    -1,    -1,    -1,   576,   577,   578,    -1,
      -1,    -1,   582,   583,   584,   585,    -1,   587,   588,    -1,
     590,   591,    -1,   593,   594,    -1,    -1,   597,    -1,    -1,
     600,    -1,   602,    -1,   604,   605,   606,    -1,    -1,    -1,
      -1,    -1,    -1,   613,    -1,    -1,   616,    -1,    -1,    -1,
     620,   621,   622,   623,   624,   625,   626,    -1,    -1,    -1,
      -1,    -1,    -1,   633,   634,    -1,   636,   637,   638,    -1,
      -1,   641,    -1,     5,    -1,     7,     8,     9,    10,    11,
      12,    -1,    -1,    15,    -1,    -1,    -1,    19,    -1,    -1,
      22,   661,    24,    25,    26,    27,    28,    29,    30,    31,
      -1,    33,    -1,    -1,    -1,    37,    -1,    -1,    -1,    41,
      -1,    -1,    44,    45,    46,    -1,    48,    -1,    50,    51,
      -1,    -1,    54,    -1,    -1,    57,    58,    -1,    60,    61,
      -1,    63,    64,    -1,    66,    67,    68,    69,    70,    71,
      72,    -1,    74,    75,    76,    77,    78,    79,    80,    -1,
      82,    83,    84,    85,    86,    87,    88,    89,    -1,    91,
      92,    -1,    94,    95,    96,    97,    98,    -1,   100,    -1,
      -1,   103,    -1,    -1,   106,    -1,   108,    -1,    -1,   111,
      -1,   113,    -1,    -1,    -1,   117,   118,   119,    -1,    -1,
     122,    -1,    -1,    -1,    -1,   127,   128,    -1,    -1,    -1,
      -1,   133,    -1,   135,    -1,    -1,    -1,   139,    -1,   141,
     142,   143,   144,   145,    -1,    -1,    -1,   149,    -1,    -1,
     152,   153,   154,    -1,    -1,    -1,   158,    -1,   160,   161,
      -1,   163,   164,   165,    -1,    -1,   168,   169,    -1,   171,
     172,   173,   174,   175,   176,   177,    -1,    -1,   180,   181,
     182,   183,    -1,    -1,   186,   187,    -1,   189,   190,   191,
      -1,    -1,   194,    -1,    -1,    -1,   198,    -1,   200,    -1,
     202,    -1,   204,   205,   206,   207,   208,   209,   210,    -1,
     212,    -1,    -1,    -1,   216,   217,   218,    -1,   220,    -1,
      -1,    -1,   224,   225,    -1,    -1,    -1,   229,   230,   231,
     232,   233,    -1,    -1,   236,   237,   238,    -1,   240,    -1,
     242,    -1,    -1,    -1,    -1,   247,   248,    -1,    -1,    -1,
     252,    -1,   254,   255,    -1,   257,   258,    -1,    -1,    -1,
     262,    -1,    -1,   265,   266,   267,    -1,    -1,   270,    -1,
      -1,   273,   274,    -1,    -1,    -1,    -1,    -1,   280,   281,
      -1,   283,    -1,   285,    -1,   287,   288,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   296,   297,   298,   299,   300,   301,
     302,   303,   304,   305,   306,   307,   308,   309,   310,   311,
      -1,   313,   314,   315,   316,    -1,   318,   319,   320,   321,
      -1,   323,   324,    -1,    -1,    -1,    -1,   329,   330,   331,
     332,   333,   334,    -1,    -1,   337,   338,    -1,   340,    -1,
     342,    -1,   344,   345,   346,   347,   348,   349,   350,   351,
     352,    -1,    -1,   355,   356,    -1,    -1,   359,   360,   361,
     362,    -1,    -1,    -1,   366,   367,    -1,    -1,    -1,   371,
      -1,   373,   374,   375,    -1,   377,   378,   379,   380,    -1,
     382,   383,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     392,   393,   394,    -1,    -1,   397,    -1,   399,    -1,   401,
     402,   403,   404,   405,   406,   407,   408,   409,   410,    -1,
      -1,   413,   414,   415,    -1,   417,    -1,   419,   420,   421,
     422,   423,    -1,   425,   426,   427,    -1,    -1,   430,    -1,
      -1,    -1,   434,   435,   436,   437,   438,    -1,    -1,   441,
     442,   443,   444,   445,    -1,   447,   448,    -1,   450,   451,
     452,    -1,    -1,   455,    -1,   457,    -1,   459,   460,    -1,
     462,   463,    -1,   465,    -1,   467,    -1,    -1,   470,   471,
     472,   473,   474,   475,   476,   477,   478,   479,   480,   481,
      -1,   483,   484,   485,    -1,    -1,   488,   489,   490,   491,
      -1,    -1,    -1,   495,    -1,    -1,    -1,   499,    -1,   501,
     502,   503,   504,   505,   506,    -1,   508,   509,   510,   511,
     512,   513,    -1,    -1,    -1,    -1,    -1,    -1,   520,   521,
      -1,   523,    -1,    -1,   526,    -1,    -1,   529,   530,    -1,
      -1,    -1,   534,    -1,    -1,   537,   538,    -1,   540,   541,
     542,   543,   544,   545,    -1,    -1,   548,   549,   550,   551,
      -1,   553,   554,    -1,   556,    -1,   558,   559,   560,   561,
      -1,    -1,   564,   565,    -1,   567,   568,   569,   570,    -1,
      -1,    -1,    -1,    -1,   576,   577,   578,    -1,    -1,    -1,
     582,   583,   584,   585,    -1,   587,   588,    -1,   590,   591,
      -1,   593,   594,    -1,    -1,   597,    -1,    -1,   600,    -1,
     602,    -1,   604,   605,   606,    -1,    -1,    -1,    -1,    -1,
      -1,   613,    -1,    -1,   616,    -1,    -1,    -1,   620,   621,
     622,   623,   624,   625,   626,    -1,    -1,    -1,    -1,    -1,
      -1,   633,   634,    -1,   636,   637,   638,    -1,    -1,   641,
      -1,     5,    -1,     7,     8,     9,    10,    11,    12,    -1,
      -1,    15,   654,    -1,    -1,    19,    -1,    -1,    22,   661,
      24,    25,    26,    27,    28,    29,    30,    31,    -1,    33,
      -1,    -1,    -1,    37,    -1,    -1,    -1,    41,    -1,    -1,
      44,    45,    46,    -1,    48,    -1,    50,    51,    -1,    -1,
      54,    -1,    -1,    57,    58,    -1,    60,    61,    -1,    63,
      64,    -1,    66,    67,    68,    69,    70,    71,    72,    -1,
      74,    75,    76,    77,    78,    79,    80,    -1,    82,    83,
      84,    85,    86,    87,    88,    89,    -1,    91,    92,    -1,
      94,    95,    96,    97,    98,    -1,   100,    -1,    -1,   103,
      -1,    -1,   106,    -1,   108,    -1,    -1,   111,    -1,   113,
      -1,    -1,    -1,   117,   118,   119,    -1,    -1,   122,    -1,
      -1,    -1,    -1,   127,   128,    -1,    -1,    -1,    -1,   133,
      -1,   135,    -1,    -1,    -1,   139,    -1,   141,   142,   143,
     144,   145,    -1,    -1,    -1,   149,    -1,    -1,   152,   153,
     154,    -1,    -1,    -1,   158,    -1,   160,   161,    -1,   163,
     164,   165,    -1,    -1,   168,   169,    -1,   171,   172,   173,
     174,   175,   176,   177,    -1,    -1,   180,   181,   182,   183,
      -1,    -1,   186,   187,    -1,   189,   190,   191,    -1,    -1,
     194,    -1,    -1,    -1,   198,    -1,   200,    -1,   202,    -1,
     204,   205,   206,   207,   208,   209,   210,    -1,   212,    -1,
      -1,    -1,   216,   217,   218,    -1,   220,    -1,    -1,    -1,
     224,   225,    -1,    -1,    -1,   229,   230,   231,   232,   233,
      -1,    -1,   236,   237,   238,    -1,   240,    -1,   242,    -1,
      -1,    -1,    -1,   247,   248,    -1,    -1,    -1,   252,    -1,
     254,   255,    -1,   257,   258,    -1,    -1,    -1,   262,    -1,
      -1,   265,   266,   267,    -1,    -1,   270,    -1,    -1,   273,
     274,    -1,    -1,    -1,    -1,    -1,   280,   281,    -1,   283,
      -1,   285,    -1,   287,   288,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   296,   297,   298,   299,   300,   301,   302,   303,
     304,   305,   306,   307,   308,   309,   310,   311,    -1,   313,
     314,   315,   316,    -1,   318,   319,   320,   321,    -1,   323,
     324,    -1,    -1,    -1,    -1,   329,   330,   331,   332,   333,
     334,    -1,    -1,   337,   338,    -1,   340,    -1,   342,    -1,
     344,   345,   346,   347,   348,   349,   350,   351,   352,    -1,
      -1,   355,   356,    -1,    -1,   359,   360,   361,   362,    -1,
      -1,    -1,   366,   367,    -1,    -1,    -1,   371,    -1,   373,
     374,   375,    -1,   377,   378,   379,   380,    -1,   382,   383,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   392,   393,
     394,    -1,    -1,   397,    -1,   399,    -1,   401,   402,   403,
     404,   405,   406,   407,   408,   409,   410,    -1,    -1,   413,
     414,   415,    -1,   417,    -1,   419,   420,   421,   422,   423,
      -1,   425,   426,   427,    -1,    -1,   430,    -1,    -1,    -1,
     434,   435,   436,   437,   438,    -1,    -1,   441,   442,   443,
     444,   445,    -1,   447,   448,    -1,   450,   451,   452,    -1,
      -1,   455,    -1,   457,    -1,   459,   460,    -1,   462,   463,
      -1,   465,    -1,   467,    -1,    -1,   470,   471,   472,   473,
     474,   475,   476,   477,   478,   479,   480,   481,    -1,   483,
     484,    -1,    -1,    -1,   488,   489,   490,   491,    -1,    -1,
      -1,   495,    -1,    -1,    -1,   499,    -1,   501,   502,   503,
     504,   505,   506,    -1,   508,   509,   510,   511,   512,   513,
      -1,    -1,    -1,    -1,    -1,    -1,   520,   521,    -1,   523,
      -1,    -1,   526,    -1,    -1,   529,   530,    -1,    -1,    -1,
     534,    -1,    -1,   537,   538,    -1,   540,   541,   542,   543,
     544,   545,    -1,    -1,   548,   549,   550,   551,    -1,   553,
     554,    -1,   556,    -1,   558,   559,   560,   561,    -1,    -1,
     564,   565,    -1,   567,   568,   569,   570,    -1,    -1,    -1,
      -1,    -1,   576,   577,   578,    -1,    -1,    -1,   582,   583,
     584,   585,    -1,   587,   588,    -1,   590,   591,    -1,   593,
     594,    -1,    -1,   597,    -1,    -1,   600,    -1,   602,    -1,
     604,   605,   606,    -1,    -1,    -1,    -1,    -1,    -1,   613,
      -1,    -1,   616,    -1,    -1,    -1,   620,   621,   622,   623,
     624,   625,   626,    -1,    -1,    -1,    -1,    -1,    -1,   633,
     634,    -1,   636,   637,   638,    -1,    -1,   641,    -1,    -1,
      -1,     5,    -1,     7,     8,     9,    10,    11,    12,    -1,
     654,    15,    -1,    -1,    -1,    19,   660,   661,    22,    -1,
      24,    25,    26,    27,    28,    29,    30,    31,    -1,    33,
      -1,    -1,    -1,    37,    -1,    -1,    -1,    41,    -1,    -1,
      44,    45,    46,    -1,    48,    -1,    50,    51,    -1,    -1,
      54,    -1,    -1,    57,    58,    -1,    60,    61,    -1,    63,
      64,    -1,    66,    67,    68,    69,    70,    71,    72,    -1,
      74,    75,    76,    77,    78,    79,    80,    -1,    82,    83,
      84,    85,    86,    87,    88,    89,    -1,    91,    92,    -1,
      94,    95,    96,    97,    98,    -1,   100,    -1,    -1,   103,
      -1,    -1,   106,    -1,   108,    -1,    -1,   111,    -1,   113,
      -1,    -1,    -1,   117,   118,   119,    -1,    -1,   122,    -1,
      -1,    -1,    -1,   127,   128,    -1,    -1,    -1,    -1,   133,
      -1,   135,    -1,    -1,    -1,   139,    -1,   141,   142,   143,
     144,   145,    -1,    -1,    -1,   149,    -1,    -1,   152,   153,
     154,    -1,    -1,    -1,   158,    -1,   160,   161,    -1,   163,
     164,   165,    -1,    -1,   168,   169,    -1,   171,   172,   173,
     174,   175,   176,   177,    -1,    -1,   180,   181,   182,   183,
      -1,    -1,   186,   187,    -1,   189,   190,   191,    -1,    -1,
     194,    -1,    -1,    -1,   198,    -1,   200,    -1,   202,    -1,
     204,   205,   206,   207,   208,   209,   210,    -1,   212,    -1,
      -1,    -1,   216,   217,   218,    -1,   220,    -1,    -1,    -1,
     224,   225,    -1,    -1,    -1,   229,   230,   231,   232,   233,
      -1,    -1,   236,   237,   238,    -1,   240,    -1,   242,    -1,
      -1,    -1,    -1,   247,   248,    -1,    -1,    -1,   252,    -1,
     254,   255,    -1,   257,   258,    -1,    -1,    -1,   262,    -1,
      -1,   265,   266,   267,    -1,    -1,   270,    -1,    -1,   273,
     274,    -1,    -1,    -1,    -1,    -1,   280,   281,    -1,   283,
      -1,   285,    -1,   287,   288,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   296,   297,   298,   299,   300,   301,   302,   303,
     304,   305,   306,   307,   308,   309,   310,   311,    -1,   313,
     314,   315,   316,    -1,   318,   319,   320,   321,    -1,   323,
     324,    -1,    -1,    -1,    -1,   329,   330,   331,   332,   333,
     334,    -1,    -1,   337,   338,    -1,   340,    -1,   342,    -1,
     344,   345,   346,   347,   348,   349,   350,   351,   352,    -1,
      -1,   355,   356,    -1,    -1,   359,   360,   361,   362,    -1,
      -1,    -1,   366,   367,    -1,    -1,    -1,   371,    -1,   373,
     374,   375,    -1,   377,   378,   379,   380,    -1,   382,   383,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   392,   393,
     394,    -1,    -1,   397,    -1,   399,    -1,   401,   402,   403,
     404,   405,   406,   407,   408,   409,   410,    -1,    -1,   413,
     414,   415,    -1,   417,    -1,   419,   420,   421,   422,   423,
      -1,   425,   426,   427,    -1,    -1,   430,    -1,    -1,    -1,
     434,   435,   436,   437,   438,    -1,    -1,   441,   442,   443,
     444,   445,    -1,   447,   448,    -1,   450,   451,   452,    -1,
      -1,   455,    -1,   457,    -1,   459,   460,    -1,   462,   463,
      -1,   465,    -1,   467,    -1,    -1,   470,   471,   472,   473,
     474,   475,   476,   477,   478,   479,   480,   481,    -1,   483,
     484,    -1,    -1,    -1,   488,   489,   490,   491,    -1,    -1,
      -1,   495,    -1,    -1,    -1,   499,    -1,   501,   502,   503,
     504,   505,   506,    -1,   508,   509,   510,   511,   512,   513,
      -1,    -1,    -1,    -1,    -1,    -1,   520,   521,    -1,   523,
      -1,    -1,   526,    -1,    -1,   529,   530,    -1,    -1,    -1,
     534,    -1,    -1,   537,   538,    -1,   540,   541,   542,   543,
     544,   545,    -1,    -1,   548,   549,   550,   551,    -1,   553,
     554,    -1,   556,    -1,   558,   559,   560,   561,    -1,    -1,
     564,   565,    -1,   567,   568,   569,   570,    -1,    -1,    -1,
      -1,    -1,   576,   577,   578,    -1,    -1,    -1,   582,   583,
     584,   585,    -1,   587,   588,    -1,   590,   591,    -1,   593,
     594,    -1,    -1,   597,    -1,    -1,   600,    -1,   602,    -1,
     604,   605,   606,    -1,    -1,    -1,    -1,    -1,    -1,   613,
      -1,    -1,   616,    -1,    -1,    -1,   620,   621,   622,   623,
     624,   625,   626,    -1,    -1,    -1,    -1,    -1,    -1,   633,
     634,    -1,   636,   637,   638,    -1,    -1,   641,    -1,    -1,
      -1,     5,    -1,     7,     8,     9,    10,    11,    12,   653,
      -1,    15,    -1,    -1,    -1,    19,    -1,   661,    22,    -1,
      24,    25,    26,    27,    28,    29,    30,    31,    -1,    33,
      -1,    -1,    -1,    37,    -1,    -1,    -1,    41,    -1,    -1,
      44,    45,    46,    -1,    48,    -1,    50,    51,    -1,    -1,
      54,    -1,    -1,    57,    58,    -1,    60,    61,    -1,    63,
      64,    -1,    66,    67,    68,    69,    70,    71,    72,    -1,
      74,    75,    76,    77,    78,    79,    80,    -1,    82,    83,
      84,    85,    86,    87,    88,    89,    -1,    91,    92,    -1,
      94,    95,    96,    97,    98,    -1,   100,    -1,    -1,   103,
      -1,    -1,   106,    -1,   108,    -1,    -1,   111,    -1,   113,
      -1,    -1,    -1,   117,   118,   119,    -1,    -1,   122,    -1,
      -1,    -1,    -1,   127,   128,    -1,    -1,    -1,    -1,   133,
      -1,   135,    -1,    -1,    -1,   139,    -1,   141,   142,   143,
     144,   145,    -1,    -1,    -1,   149,    -1,    -1,   152,   153,
     154,    -1,    -1,    -1,   158,    -1,   160,   161,    -1,   163,
     164,   165,    -1,    -1,   168,   169,    -1,   171,   172,   173,
     174,   175,   176,   177,    -1,    -1,   180,   181,   182,   183,
      -1,    -1,   186,   187,    -1,   189,   190,   191,    -1,    -1,
     194,    -1,    -1,    -1,   198,    -1,   200,    -1,   202,    -1,
     204,   205,   206,   207,   208,   209,   210,    -1,   212,    -1,
      -1,    -1,   216,   217,   218,    -1,   220,    -1,    -1,    -1,
     224,   225,    -1,    -1,    -1,   229,   230,   231,   232,   233,
      -1,    -1,   236,   237,   238,    -1,   240,    -1,   242,    -1,
      -1,    -1,    -1,   247,   248,    -1,   250,    -1,   252,    -1,
     254,   255,    -1,   257,   258,    -1,    -1,    -1,   262,    -1,
      -1,   265,   266,   267,    -1,    -1,   270,    -1,    -1,   273,
     274,    -1,    -1,    -1,    -1,    -1,   280,   281,    -1,   283,
      -1,   285,    -1,   287,   288,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   296,   297,   298,   299,   300,   301,   302,   303,
     304,   305,   306,   307,   308,   309,   310,   311,    -1,   313,
     314,   315,   316,    -1,   318,   319,   320,   321,    -1,   323,
     324,    -1,    -1,    -1,    -1,   329,   330,   331,   332,   333,
     334,    -1,    -1,   337,   338,    -1,   340,    -1,   342,    -1,
     344,   345,   346,   347,   348,   349,   350,   351,   352,    -1,
      -1,   355,   356,    -1,    -1,   359,   360,   361,   362,    -1,
      -1,    -1,   366,   367,    -1,    -1,    -1,   371,    -1,   373,
     374,   375,    -1,   377,   378,   379,   380,    -1,   382,   383,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   392,   393,
     394,    -1,    -1,   397,    -1,   399,    -1,   401,   402,   403,
     404,   405,   406,   407,   408,   409,   410,    -1,    -1,   413,
     414,   415,    -1,   417,    -1,   419,   420,   421,   422,   423,
      -1,   425,   426,   427,    -1,    -1,   430,    -1,    -1,    -1,
     434,   435,   436,   437,   438,    -1,    -1,   441,   442,   443,
     444,   445,    -1,   447,   448,    -1,   450,   451,   452,    -1,
      -1,   455,    -1,   457,    -1,   459,   460,    -1,   462,   463,
      -1,   465,    -1,   467,    -1,    -1,   470,   471,   472,   473,
     474,   475,   476,   477,   478,   479,   480,   481,    -1,   483,
     484,    -1,    -1,    -1,   488,   489,   490,   491,    -1,    -1,
      -1,   495,    -1,    -1,    -1,   499,    -1,   501,   502,   503,
     504,   505,   506,    -1,   508,   509,   510,   511,   512,   513,
      -1,    -1,    -1,    -1,    -1,    -1,   520,   521,    -1,   523,
      -1,    -1,   526,    -1,    -1,   529,   530,    -1,    -1,    -1,
     534,    -1,    -1,   537,   538,    -1,   540,   541,   542,   543,
     544,   545,    -1,    -1,   548,   549,   550,   551,    -1,   553,
     554,    -1,   556,    -1,   558,   559,   560,   561,    -1,    -1,
     564,   565,    -1,   567,   568,   569,   570,    -1,    -1,    -1,
      -1,    -1,   576,   577,   578,    -1,    -1,    -1,   582,   583,
     584,   585,    -1,   587,   588,    -1,   590,   591,    -1,   593,
     594,    -1,    -1,   597,    -1,    -1,   600,    -1,   602,    -1,
     604,   605,   606,    -1,    -1,    -1,    -1,    -1,    -1,   613,
      -1,    -1,   616,    -1,    -1,    -1,   620,   621,   622,   623,
     624,   625,   626,    -1,    -1,    -1,    -1,    -1,    -1,   633,
     634,    -1,   636,   637,   638,    -1,    -1,   641,    -1,     5,
      -1,     7,     8,     9,    10,    11,    12,    -1,    -1,    15,
      -1,    -1,    -1,    19,    -1,    -1,    22,   661,    24,    25,
      26,    27,    28,    29,    30,    31,    -1,    33,    -1,    -1,
      -1,    37,    -1,    -1,    -1,    41,    -1,    -1,    44,    45,
      46,    -1,    48,    -1,    50,    51,    -1,    -1,    54,    -1,
      -1,    57,    58,    -1,    60,    61,    -1,    63,    64,    -1,
      66,    67,    68,    69,    70,    71,    72,    -1,    74,    75,
      76,    77,    78,    79,    80,    -1,    82,    83,    84,    85,
      86,    87,    88,    89,    -1,    91,    92,    -1,    94,    95,
      96,    97,    98,    -1,   100,    -1,    -1,   103,    -1,    -1,
     106,    -1,   108,    -1,    -1,   111,    -1,   113,    -1,    -1,
      -1,   117,   118,   119,    -1,    -1,   122,    -1,    -1,    -1,
      -1,   127,   128,    -1,    -1,    -1,    -1,   133,    -1,   135,
      -1,    -1,    -1,   139,    -1,   141,   142,   143,   144,   145,
      -1,    -1,    -1,   149,    -1,    -1,   152,   153,   154,    -1,
      -1,    -1,   158,    -1,   160,   161,    -1,   163,   164,   165,
      -1,    -1,   168,   169,    -1,   171,   172,   173,   174,   175,
     176,   177,    -1,    -1,   180,   181,   182,   183,    -1,    -1,
     186,   187,    -1,   189,   190,   191,    -1,    -1,   194,    -1,
      -1,    -1,   198,    -1,   200,    -1,   202,    -1,   204,   205,
     206,   207,   208,   209,   210,    -1,   212,    -1,    -1,    -1,
     216,   217,   218,    -1,   220,    -1,    -1,    -1,   224,   225,
      -1,    -1,    -1,   229,   230,   231,   232,   233,    -1,    -1,
     236,   237,   238,    -1,   240,    -1,   242,    -1,    -1,    -1,
      -1,   247,   248,    -1,    -1,    -1,   252,    -1,   254,   255,
      -1,   257,   258,    -1,    -1,    -1,   262,    -1,    -1,   265,
     266,   267,    -1,    -1,   270,    -1,    -1,   273,   274,    -1,
      -1,    -1,    -1,    -1,   280,   281,    -1,   283,    -1,   285,
      -1,   287,   288,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     296,   297,   298,   299,   300,   301,   302,   303,   304,   305,
     306,   307,   308,   309,   310,   311,    -1,   313,   314,   315,
     316,    -1,   318,   319,   320,   321,    -1,   323,   324,    -1,
      -1,    -1,    -1,   329,   330,   331,   332,   333,   334,    -1,
      -1,   337,   338,    -1,   340,    -1,   342,    -1,   344,   345,
     346,   347,   348,   349,   350,   351,   352,    -1,    -1,   355,
     356,    -1,    -1,   359,   360,   361,   362,    -1,    -1,    -1,
     366,   367,    -1,    -1,    -1,   371,    -1,   373,   374,   375,
      -1,   377,   378,   379,   380,    -1,   382,   383,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   392,   393,   394,    -1,
      -1,   397,    -1,   399,    -1,   401,   402,   403,   404,   405,
     406,   407,   408,   409,   410,    -1,    -1,   413,   414,   415,
      -1,   417,    -1,   419,   420,   421,   422,   423,    -1,   425,
     426,   427,    -1,    -1,   430,    -1,    -1,    -1,   434,   435,
     436,   437,   438,    -1,    -1,   441,   442,   443,   444,   445,
      -1,   447,   448,    -1,   450,   451,   452,    -1,    -1,   455,
      -1,   457,    -1,   459,   460,    -1,   462,   463,    -1,   465,
      -1,   467,    -1,    -1,   470,   471,   472,   473,   474,   475,
     476,   477,   478,   479,   480,   481,    -1,   483,   484,    -1,
      -1,    -1,   488,   489,   490,   491,    -1,    -1,    -1,   495,
      -1,    -1,    -1,   499,    -1,   501,   502,   503,   504,   505,
     506,    -1,   508,   509,   510,   511,   512,   513,    -1,    -1,
      -1,    -1,    -1,    -1,   520,   521,    -1,   523,    -1,    -1,
     526,    -1,    -1,   529,   530,    -1,    -1,    -1,   534,    -1,
      -1,   537,   538,    -1,   540,   541,   542,   543,   544,   545,
      -1,    -1,   548,   549,   550,   551,    -1,   553,   554,    -1,
     556,    -1,   558,   559,   560,   561,    -1,    -1,   564,   565,
      -1,   567,   568,   569,   570,    -1,    -1,    -1,    -1,    -1,
     576,   577,   578,    -1,    -1,    -1,   582,   583,   584,   585,
      -1,   587,   588,    -1,   590,   591,    -1,   593,   594,    -1,
      -1,   597,    -1,    -1,   600,    -1,   602,    -1,   604,   605,
     606,    -1,    -1,    -1,    -1,    -1,    -1,   613,    -1,    -1,
     616,    -1,    -1,    -1,   620,   621,   622,   623,   624,   625,
     626,    -1,    -1,    -1,    -1,    -1,    -1,   633,   634,    -1,
     636,   637,   638,    -1,    -1,   641,    -1,    -1,    -1,    -1,
      -1,    -1,   648,     5,    -1,     7,     8,     9,    10,    11,
      12,    -1,    -1,    15,    -1,   661,    -1,    19,    -1,    -1,
      22,    -1,    24,    25,    26,    27,    28,    29,    30,    31,
      -1,    33,    -1,    -1,    -1,    37,    -1,    -1,    -1,    41,
      -1,    -1,    44,    45,    46,    -1,    48,    -1,    50,    51,
      -1,    -1,    54,    -1,    -1,    57,    58,    -1,    60,    61,
      -1,    63,    64,    -1,    66,    67,    68,    69,    70,    71,
      72,    -1,    74,    75,    76,    77,    78,    79,    80,    -1,
      82,    83,    84,    85,    86,    87,    88,    89,    -1,    91,
      92,    -1,    94,    95,    96,    97,    98,    -1,   100,    -1,
      -1,   103,    -1,    -1,   106,    -1,   108,    -1,    -1,   111,
      -1,   113,    -1,    -1,    -1,   117,   118,   119,    -1,    -1,
     122,    -1,    -1,    -1,    -1,   127,   128,    -1,    -1,    -1,
      -1,   133,    -1,   135,    -1,    -1,    -1,   139,    -1,   141,
     142,   143,   144,   145,    -1,    -1,    -1,   149,    -1,    -1,
     152,   153,   154,    -1,    -1,    -1,   158,    -1,   160,   161,
      -1,   163,   164,   165,    -1,    -1,   168,   169,    -1,   171,
     172,   173,   174,   175,   176,   177,    -1,    -1,   180,   181,
     182,   183,    -1,    -1,   186,   187,    -1,   189,   190,   191,
      -1,    -1,   194,    -1,    -1,    -1,   198,    -1,   200,    -1,
     202,    -1,   204,   205,   206,   207,   208,   209,   210,    -1,
     212,    -1,    -1,    -1,   216,   217,   218,    -1,   220,    -1,
      -1,    -1,   224,   225,    -1,    -1,    -1,   229,   230,   231,
     232,   233,    -1,    -1,   236,   237,   238,    -1,   240,    -1,
     242,    -1,    -1,    -1,    -1,   247,   248,    -1,    -1,    -1,
     252,    -1,   254,   255,    -1,   257,   258,    -1,    -1,    -1,
     262,    -1,    -1,   265,   266,   267,    -1,    -1,   270,    -1,
      -1,   273,   274,    -1,    -1,    -1,    -1,    -1,   280,   281,
      -1,   283,    -1,   285,    -1,   287,   288,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   296,   297,   298,   299,   300,   301,
     302,   303,   304,   305,   306,   307,   308,   309,   310,   311,
      -1,   313,   314,   315,   316,    -1,   318,   319,   320,   321,
      -1,   323,   324,    -1,    -1,    -1,    -1,   329,   330,   331,
     332,   333,   334,    -1,    -1,   337,   338,    -1,   340,    -1,
     342,    -1,   344,   345,   346,   347,   348,   349,   350,   351,
     352,    -1,    -1,   355,   356,    -1,    -1,   359,   360,   361,
     362,    -1,    -1,    -1,   366,   367,    -1,    -1,    -1,   371,
      -1,   373,   374,   375,    -1,   377,   378,   379,   380,    -1,
     382,   383,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     392,   393,   394,    -1,    -1,   397,    -1,   399,    -1,   401,
     402,   403,   404,   405,   406,   407,   408,   409,   410,    -1,
      -1,   413,   414,   415,    -1,   417,    -1,   419,   420,   421,
     422,   423,    -1,   425,   426,   427,    -1,    -1,   430,    -1,
      -1,    -1,   434,   435,   436,   437,   438,    -1,    -1,   441,
     442,   443,   444,   445,    -1,   447,   448,    -1,   450,   451,
     452,    -1,    -1,   455,    -1,   457,    -1,   459,   460,    -1,
     462,   463,    -1,   465,    -1,   467,    -1,    -1,   470,   471,
     472,   473,   474,   475,   476,   477,   478,   479,   480,   481,
      -1,   483,   484,    -1,    -1,    -1,   488,   489,   490,   491,
      -1,    -1,    -1,   495,    -1,    -1,    -1,   499,    -1,   501,
     502,   503,   504,   505,   506,    -1,   508,   509,   510,   511,
     512,   513,    -1,    -1,    -1,    -1,    -1,    -1,   520,   521,
      -1,   523,    -1,    -1,   526,    -1,    -1,   529,   530,    -1,
      -1,    -1,   534,    -1,    -1,   537,   538,    -1,   540,   541,
     542,   543,   544,   545,    -1,    -1,   548,   549,   550,   551,
      -1,   553,   554,    -1,   556,    -1,   558,   559,   560,   561,
      -1,    -1,   564,   565,    -1,   567,   568,   569,   570,    -1,
      -1,    -1,    -1,    -1,   576,   577,   578,    -1,    -1,    -1,
     582,   583,   584,   585,    -1,   587,   588,    -1,   590,   591,
      -1,   593,   594,    -1,    -1,   597,    -1,    -1,   600,    -1,
     602,    -1,   604,   605,   606,    -1,    -1,    -1,    -1,    -1,
      -1,   613,    -1,    -1,   616,    -1,    -1,    -1,   620,   621,
     622,   623,   624,   625,   626,    -1,    -1,    -1,    -1,    -1,
      -1,   633,   634,    -1,   636,   637,   638,    -1,    -1,   641,
      -1,    -1,    -1,     5,    -1,     7,     8,     9,    10,    11,
      12,   653,    -1,    15,    -1,    -1,    -1,    19,    -1,   661,
      22,    -1,    24,    25,    26,    27,    28,    29,    30,    31,
      -1,    33,    -1,    -1,    -1,    37,    -1,    -1,    -1,    41,
      -1,    -1,    44,    45,    46,    -1,    48,    -1,    50,    51,
      -1,    -1,    54,    -1,    -1,    57,    58,    -1,    60,    61,
      -1,    63,    64,    -1,    66,    67,    68,    69,    70,    71,
      72,    -1,    74,    75,    76,    77,    78,    79,    80,    -1,
      82,    83,    84,    85,    86,    87,    88,    89,    -1,    91,
      92,    -1,    94,    95,    96,    97,    98,    -1,   100,    -1,
      -1,   103,    -1,    -1,   106,    -1,   108,    -1,    -1,   111,
      -1,   113,    -1,    -1,    -1,   117,   118,   119,    -1,    -1,
     122,    -1,    -1,    -1,    -1,   127,   128,    -1,    -1,    -1,
      -1,   133,    -1,   135,    -1,    -1,    -1,   139,    -1,   141,
     142,   143,   144,   145,    -1,    -1,    -1,   149,    -1,    -1,
     152,   153,   154,    -1,    -1,    -1,   158,    -1,   160,   161,
      -1,   163,   164,   165,    -1,    -1,   168,   169,    -1,   171,
     172,   173,   174,   175,   176,   177,    -1,    -1,   180,   181,
     182,   183,    -1,    -1,   186,   187,    -1,   189,   190,   191,
      -1,    -1,   194,    -1,    -1,    -1,   198,    -1,   200,    -1,
     202,    -1,   204,   205,   206,   207,   208,   209,   210,    -1,
     212,    -1,    -1,    -1,   216,   217,   218,    -1,   220,    -1,
      -1,    -1,   224,   225,    -1,    -1,    -1,   229,   230,   231,
     232,   233,    -1,    -1,   236,   237,   238,    -1,   240,    -1,
     242,    -1,    -1,    -1,    -1,   247,   248,    -1,    -1,    -1,
     252,    -1,   254,   255,    -1,   257,   258,    -1,    -1,    -1,
     262,    -1,    -1,   265,   266,   267,    -1,    -1,   270,    -1,
      -1,   273,   274,    -1,    -1,    -1,    -1,    -1,   280,   281,
      -1,   283,    -1,   285,    -1,   287,   288,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   296,   297,   298,   299,   300,   301,
     302,   303,   304,   305,   306,   307,   308,   309,   310,   311,
      -1,   313,   314,   315,   316,    -1,   318,   319,   320,   321,
      -1,   323,   324,    -1,    -1,    -1,    -1,   329,   330,   331,
     332,   333,   334,    -1,    -1,   337,   338,    -1,   340,    -1,
     342,    -1,   344,   345,   346,   347,   348,   349,   350,   351,
     352,    -1,    -1,   355,   356,    -1,    -1,   359,   360,   361,
     362,    -1,    -1,    -1,   366,   367,    -1,    -1,    -1,   371,
      -1,   373,   374,   375,    -1,   377,   378,   379,   380,    -1,
     382,   383,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     392,   393,   394,    -1,    -1,   397,    -1,   399,    -1,   401,
     402,   403,   404,   405,   406,   407,   408,   409,   410,    -1,
      -1,   413,   414,   415,    -1,   417,    -1,   419,   420,   421,
     422,   423,    -1,   425,   426,   427,    -1,    -1,   430,    -1,
      -1,    -1,   434,   435,   436,   437,   438,    -1,    -1,   441,
     442,   443,   444,   445,    -1,   447,   448,    -1,   450,   451,
     452,    -1,    -1,   455,    -1,   457,    -1,   459,   460,    -1,
     462,   463,    -1,   465,    -1,   467,    -1,    -1,   470,   471,
     472,   473,   474,   475,   476,   477,   478,   479,   480,   481,
      -1,   483,   484,    -1,    -1,    -1,   488,   489,   490,   491,
      -1,    -1,    -1,   495,    -1,    -1,    -1,   499,    -1,   501,
     502,   503,   504,   505,   506,    -1,   508,   509,   510,   511,
     512,   513,    -1,    -1,    -1,    -1,    -1,    -1,   520,   521,
      -1,   523,    -1,    -1,   526,    -1,    -1,   529,   530,    -1,
      -1,    -1,   534,    -1,    -1,   537,   538,    -1,   540,   541,
     542,   543,   544,   545,    -1,    -1,   548,   549,   550,   551,
      -1,   553,   554,    -1,   556,    -1,   558,   559,   560,   561,
      -1,    -1,   564,   565,    -1,   567,   568,   569,   570,    -1,
      -1,    -1,    -1,    -1,   576,   577,   578,    -1,    -1,    -1,
     582,   583,   584,   585,    -1,   587,   588,    -1,   590,   591,
      -1,   593,   594,    -1,    -1,   597,    -1,    -1,   600,    -1,
     602,    -1,   604,   605,   606,    -1,    -1,    -1,    -1,    -1,
      -1,   613,    -1,    -1,   616,    -1,    -1,    -1,   620,   621,
     622,   623,   624,   625,   626,    -1,    -1,    -1,    -1,    -1,
      -1,   633,   634,    -1,   636,   637,   638,    -1,    -1,   641,
      -1,    -1,    -1,     5,    -1,     7,     8,     9,    10,    11,
      12,    -1,    -1,    15,    -1,    -1,    -1,    19,   660,   6