/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.results.cpu;

import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.netbeans.lib.profiler.results.CCTNode;
import org.netbeans.lib.profiler.results.ExportDataDumper;
import org.netbeans.lib.profiler.results.FilterSortSupport;
import org.netbeans.lib.profiler.results.cpu.CPUCCTContainer;
import org.netbeans.lib.profiler.results.cpu.PrestimeCPUCCTNode;

public class PrestimeCPUCCTNodeBacked
extends PrestimeCPUCCTNode {
    private static NumberFormat percentFormat = null;
    protected int selfCompactDataOfs;
    protected Set<Integer> compactDataOfs;
    protected int nChildren;
    private int methodID;
    private int nCalls;
    private long sleepTime0;
    private long totalTime0;
    private long totalTime1;
    private long waitTime0;

    public PrestimeCPUCCTNodeBacked(CPUCCTContainer cPUCCTContainer, PrestimeCPUCCTNode prestimeCPUCCTNode, int n) {
        super(cPUCCTContainer, prestimeCPUCCTNode);
        this.selfCompactDataOfs = n;
        this.compactDataOfs = new HashSet<Integer>();
        this.compactDataOfs.add(this.selfCompactDataOfs);
        this.container = cPUCCTContainer;
        this.nChildren = cPUCCTContainer.getNChildrenForNodeOfs(n);
        this.methodID = cPUCCTContainer.getMethodIdForNodeOfs(n);
        this.nCalls = cPUCCTContainer.getNCallsForNodeOfs(n);
        this.sleepTime0 = cPUCCTContainer.getSleepTime0ForNodeOfs(n);
        this.totalTime0 = cPUCCTContainer.getTotalTime0ForNodeOfs(n);
        if (cPUCCTContainer.collectingTwoTimeStamps) {
            this.totalTime1 = cPUCCTContainer.getTotalTime1ForNodeOfs(n);
        }
        this.waitTime0 = cPUCCTContainer.getWaitTime0ForNodeOfs(n);
    }

    protected PrestimeCPUCCTNodeBacked(CPUCCTContainer cPUCCTContainer, PrestimeCPUCCTNode[] prestimeCPUCCTNodeArray) {
        super(cPUCCTContainer, null);
        this.setThreadNode();
        this.children = prestimeCPUCCTNodeArray;
        this.nChildren = prestimeCPUCCTNodeArray.length;
        for (int i = 0; i < this.nChildren; ++i) {
            prestimeCPUCCTNodeArray[i].parent = this;
        }
    }

    PrestimeCPUCCTNodeBacked() {
    }

    public PrestimeCPUCCTNodeBacked createRootCopy() {
        PrestimeCPUCCTNodeBacked prestimeCPUCCTNodeBacked = new PrestimeCPUCCTNodeBacked(this.container, this.parent, this.selfCompactDataOfs);
        prestimeCPUCCTNodeBacked.parent = null;
        prestimeCPUCCTNodeBacked.compactDataOfs.clear();
        prestimeCPUCCTNodeBacked.compactDataOfs.addAll(this.compactDataOfs);
        prestimeCPUCCTNodeBacked.children = null;
        prestimeCPUCCTNodeBacked.nChildren = this.nChildren;
        prestimeCPUCCTNodeBacked.methodID = this.methodID;
        prestimeCPUCCTNodeBacked.nCalls = this.nCalls;
        prestimeCPUCCTNodeBacked.sleepTime0 = this.sleepTime0;
        prestimeCPUCCTNodeBacked.totalTime0 = this.totalTime0;
        prestimeCPUCCTNodeBacked.totalTime1 = this.totalTime1;
        prestimeCPUCCTNodeBacked.waitTime0 = this.waitTime0;
        return prestimeCPUCCTNodeBacked;
    }

    @Override
    public CCTNode getChild(int n) {
        this.getChildren();
        if (n < this.children.length) {
            return this.children[n];
        }
        return null;
    }

    @Override
    public CCTNode[] getChildren() {
        if (this.nChildren == 0) {
            return null;
        }
        if (this.children != null) {
            return this.children;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        PrestimeCPUCCTNodeBacked prestimeCPUCCTNodeBacked = null;
        FilterSortSupport.Configuration configuration = this.container.getCPUResSnapshot().getFilterSortInfo(this);
        Object object = this.compactDataOfs.iterator();
        while (object.hasNext()) {
            int n = object.next();
            int n2 = this.container.getNChildrenForNodeOfs(n);
            for (int i = 0; i < n2; ++i) {
                PrestimeCPUCCTNodeBacked prestimeCPUCCTNodeBacked2 = new PrestimeCPUCCTNodeBacked(this.container, this, this.container.getChildOfsForNodeOfs(n, i));
                if (FilterSortSupport.passesFilter(configuration, prestimeCPUCCTNodeBacked2.getNodeName())) {
                    int n3 = arrayList.indexOf(prestimeCPUCCTNodeBacked2);
                    if (n3 != -1) {
                        ((PrestimeCPUCCTNodeBacked)arrayList.get(n3)).merge(prestimeCPUCCTNodeBacked2);
                        continue;
                    }
                    arrayList.add(prestimeCPUCCTNodeBacked2);
                    continue;
                }
                if (prestimeCPUCCTNodeBacked == null) {
                    prestimeCPUCCTNodeBacked = prestimeCPUCCTNodeBacked2;
                    prestimeCPUCCTNodeBacked2.setFilteredNode();
                    arrayList.add(prestimeCPUCCTNodeBacked);
                    continue;
                }
                prestimeCPUCCTNodeBacked.merge(prestimeCPUCCTNodeBacked2);
            }
        }
        if (this.hasSelfTimeChild()) {
            object = new PrestimeCPUCCTNodeBacked(this.container, this.parent, this.selfCompactDataOfs);
            ((PrestimeCPUCCTNodeBacked)object).setSelfTimeNode();
            arrayList.add(object);
        }
        if (this.isFilteredNode() && prestimeCPUCCTNodeBacked != null && arrayList.size() == 1) {
            this.children = (PrestimeCPUCCTNode[])prestimeCPUCCTNodeBacked.getChildren();
            this.nChildren = this.children == null ? 0 : this.children.length;
            this.compactDataOfs = prestimeCPUCCTNodeBacked.compactDataOfs;
        } else {
            this.nChildren = arrayList.size();
            this.children = arrayList.toArray(new PrestimeCPUCCTNode[this.nChildren]);
        }
        this.sortChildren(configuration.getSortBy(), configuration.getSortOrder());
        return this.children;
    }

    private boolean hasSelfTimeChild() {
        return !this.isThreadNode() && !this.isFilteredNode() && this.compactDataOfs.size() == 1;
    }

    protected void merge(PrestimeCPUCCTNodeBacked prestimeCPUCCTNodeBacked) {
        this.children = null;
        this.nChildren += prestimeCPUCCTNodeBacked.nChildren;
        this.nCalls += prestimeCPUCCTNodeBacked.nCalls;
        this.sleepTime0 += prestimeCPUCCTNodeBacked.sleepTime0;
        this.totalTime0 += prestimeCPUCCTNodeBacked.totalTime0;
        this.totalTime1 += prestimeCPUCCTNodeBacked.totalTime1;
        this.waitTime0 += prestimeCPUCCTNodeBacked.waitTime0;
    }

    @Override
    protected void resetChildren() {
        if (this.compactDataOfs != null) {
            this.compactDataOfs.clear();
            this.compactDataOfs.add(this.selfCompactDataOfs);
            this.nChildren = this.container.getNChildrenForNodeOfs(this.selfCompactDataOfs);
        }
        if (this.children == null) {
            return;
        }
        if (!this.isThreadNode() || this.parent != null) {
            this.children = null;
        } else {
            super.resetChildren();
        }
    }

    @Override
    public void setSelfTimeNode() {
        super.setSelfTimeNode();
        this.nChildren = 0;
        this.children = null;
        int n = this.selfCompactDataOfs;
        this.totalTime0 = this.container.getSelfTime0ForNodeOfs(n);
        if (this.container.collectingTwoTimeStamps) {
            this.totalTime1 = this.container.getSelfTime1ForNodeOfs(n);
        }
    }

    @Override
    public int getMethodId() {
        return this.methodID;
    }

    @Override
    public int getNCalls() {
        return this.nCalls;
    }

    @Override
    public int getNChildren() {
        if (this.getChildren() == null) {
            return 0;
        }
        return this.nChildren;
    }

    @Override
    public long getSleepTime0() {
        return this.sleepTime0;
    }

    @Override
    public int getThreadId() {
        return this.container.getThreadId();
    }

    @Override
    public long getTotalTime0() {
        return this.totalTime0;
    }

    @Override
    public float getTotalTime0InPerCent() {
        float f = (float)(this.container.getWholeGraphNetTime0() > 0L ? (double)this.totalTime0 / (double)this.container.getWholeGraphNetTime0() * 100.0 : 0.0);
        return f < 100.0f ? f : 100.0f;
    }

    @Override
    public long getTotalTime1() {
        return this.totalTime1;
    }

    @Override
    public float getTotalTime1InPerCent() {
        return (float)(this.container.getWholeGraphNetTime1() > 0L ? (double)this.totalTime1 / (double)this.container.getWholeGraphNetTime1() * 100.0 : 0.0);
    }

    @Override
    public long getWaitTime0() {
        return this.waitTime0;
    }

    @Override
    public void sortChildren(int n, boolean bl) {
        this.container.getCPUResSnapshot().saveSortParams(n, bl, this);
        if (this.nChildren == 0 || this.children == null) {
            return;
        }
        this.doSortChildren(n, bl);
    }

    public void exportXMLData(ExportDataDumper exportDataDumper, String string) {
        String string2 = System.getProperty("line.separator");
        StringBuffer stringBuffer = new StringBuffer(string + "<node>" + string2);
        stringBuffer.append(string).append(" <Name>").append(this.replaceHTMLCharacters(this.getNodeName())).append("</Name>").append(string2);
        stringBuffer.append(string).append(" <Parent>").append(this.replaceHTMLCharacters(this.getParent() == null ? "none" : ((PrestimeCPUCCTNodeBacked)this.getParent()).getNodeName())).append("</Parent>").append(string2);
        stringBuffer.append(string).append(" <Time_Relative>").append(percentFormat.format((double)this.getTotalTime0InPerCent() / 100.0)).append("</Time_Relative>").append(string2);
        stringBuffer.append(string).append(" <Time>").append(this.getTotalTime0()).append("</Time>").append(string2);
        stringBuffer.append(string).append(" <Invocations>").append(this.getNCalls()).append("</Invocations>").append(string2);
        exportDataDumper.dumpData(stringBuffer);
        if (this.children != null) {
            for (int i = 0; i < this.nChildren; ++i) {
                ((PrestimeCPUCCTNodeBacked)this.children[i]).exportXMLData(exportDataDumper, string + "  ");
            }
        } else if (this.nChildren > 0) {
            int n = this.nChildren;
            PrestimeCPUCCTNode[] prestimeCPUCCTNodeArray = (PrestimeCPUCCTNode[])this.getChildren();
            this.children = null;
            for (int i = 0; i < this.nChildren; ++i) {
                ((PrestimeCPUCCTNodeBacked)prestimeCPUCCTNodeArray[i]).exportXMLData(exportDataDumper, string + "  ");
            }
            prestimeCPUCCTNodeArray = null;
            this.nChildren = n;
        }
        stringBuffer = new StringBuffer(string + "</node>");
        exportDataDumper.dumpData(stringBuffer);
    }

    public void exportHTMLData(ExportDataDumper exportDataDumper, int n) {
        int n2;
        StringBuffer stringBuffer = new StringBuffer("<tr><td class=\"method\"><pre class=\"method\">.");
        for (n2 = 0; n2 < n; ++n2) {
            stringBuffer.append(".");
        }
        stringBuffer.append(this.replaceHTMLCharacters(this.getNodeName())).append("</pre></td><td class=\"right\">").append(percentFormat.format((double)this.getTotalTime0InPerCent() / 100.0)).append("</td><td class=\"right\">").append(this.getTotalTime0()).append("</td><td class=\"right\">").append(this.getNCalls()).append("</td></tr>");
        exportDataDumper.dumpData(stringBuffer);
        if (this.children != null) {
            for (n2 = 0; n2 < this.nChildren; ++n2) {
                ((PrestimeCPUCCTNodeBacked)this.children[n2]).exportHTMLData(exportDataDumper, n + 1);
            }
        } else if (this.nChildren > 0) {
            n2 = this.nChildren;
            PrestimeCPUCCTNode[] prestimeCPUCCTNodeArray = (PrestimeCPUCCTNode[])this.getChildren();
            this.children = null;
            for (int i = 0; i < this.nChildren; ++i) {
                ((PrestimeCPUCCTNodeBacked)prestimeCPUCCTNodeArray[i]).exportHTMLData(exportDataDumper, n + 1);
            }
            prestimeCPUCCTNodeArray = null;
            this.nChildren = n2;
        }
    }

    private String replaceHTMLCharacters(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = string.length();
        block6: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '<': {
                    stringBuilder.append("&lt;");
                    continue block6;
                }
                case '>': {
                    stringBuilder.append("&gt;");
                    continue block6;
                }
                case '&': {
                    stringBuilder.append("&amp;");
                    continue block6;
                }
                case '\"': {
                    stringBuilder.append("&quot;");
                    continue block6;
                }
                default: {
                    stringBuilder.append(c);
                }
            }
        }
        return stringBuilder.toString();
    }

    public void exportCSVData(String string, int n, ExportDataDumper exportDataDumper) {
        int n2;
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = "\r\n";
        String string3 = "\"";
        String string4 = " ";
        stringBuffer.append(string3);
        for (n2 = 0; n2 < n; ++n2) {
            stringBuffer.append(string4);
        }
        stringBuffer.append(this.getNodeName()).append(string3).append(string);
        stringBuffer.append(string3).append(this.getTotalTime0InPerCent()).append(string3).append(string);
        stringBuffer.append(string3).append(this.getTotalTime0()).append(string3).append(string);
        stringBuffer.append(string3).append(this.getNCalls()).append(string3).append(string2);
        exportDataDumper.dumpData(stringBuffer);
        if (this.children != null) {
            for (n2 = 0; n2 < this.nChildren; ++n2) {
                ((PrestimeCPUCCTNodeBacked)this.children[n2]).exportCSVData(string, n + 1, exportDataDumper);
            }
        } else if (this.nChildren > 0) {
            n2 = this.nChildren;
            PrestimeCPUCCTNode[] prestimeCPUCCTNodeArray = (PrestimeCPUCCTNode[])this.getChildren();
            this.children = null;
            for (int i = 0; i < this.nChildren; ++i) {
                ((PrestimeCPUCCTNodeBacked)prestimeCPUCCTNodeArray[i]).exportCSVData(string, n + 1, exportDataDumper);
            }
            prestimeCPUCCTNodeArray = null;
            this.nChildren = n2;
        }
    }

    public static void setPercentFormat(NumberFormat numberFormat) {
        percentFormat = numberFormat;
    }
}

