/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.fs;

import java.io.IOException;
import java.nio.file.FileStore;
import java.nio.file.WatchService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import sun.nio.fs.LinuxFileStore;
import sun.nio.fs.LinuxNativeDispatcher;
import sun.nio.fs.LinuxUserDefinedFileAttributeView;
import sun.nio.fs.LinuxWatchService;
import sun.nio.fs.UnixException;
import sun.nio.fs.UnixFileSystem;
import sun.nio.fs.UnixFileSystemProvider;
import sun.nio.fs.UnixMountEntry;

class LinuxFileSystem
extends UnixFileSystem {
    LinuxFileSystem(UnixFileSystemProvider unixFileSystemProvider, String string) {
        super(unixFileSystemProvider, string);
    }

    @Override
    public WatchService newWatchService() throws IOException {
        return new LinuxWatchService(this);
    }

    @Override
    public Set<String> supportedFileAttributeViews() {
        return SupportedFileFileAttributeViewsHolder.supportedFileAttributeViews;
    }

    @Override
    void copyNonPosixAttributes(int n, int n2) {
        LinuxUserDefinedFileAttributeView.copyExtendedAttributes(n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Iterable<UnixMountEntry> getMountEntries(String string) {
        ArrayList<UnixMountEntry> arrayList = new ArrayList<UnixMountEntry>();
        try {
            long l = LinuxNativeDispatcher.setmntent(string.getBytes(), "r".getBytes());
            try {
                UnixMountEntry unixMountEntry;
                int n;
                while ((n = LinuxNativeDispatcher.getmntent(l, unixMountEntry = new UnixMountEntry())) >= 0) {
                    arrayList.add(unixMountEntry);
                }
            }
            finally {
                LinuxNativeDispatcher.endmntent(l);
            }
        }
        catch (UnixException unixException) {
            // empty catch block
        }
        return arrayList;
    }

    @Override
    Iterable<UnixMountEntry> getMountEntries() {
        return this.getMountEntries("/etc/mtab");
    }

    @Override
    FileStore getFileStore(UnixMountEntry unixMountEntry) throws IOException {
        return new LinuxFileStore(this, unixMountEntry);
    }

    private static class SupportedFileFileAttributeViewsHolder {
        static final Set<String> supportedFileAttributeViews = SupportedFileFileAttributeViewsHolder.supportedFileAttributeViews();

        private SupportedFileFileAttributeViewsHolder() {
        }

        private static Set<String> supportedFileAttributeViews() {
            HashSet<String> hashSet = new HashSet<String>();
            hashSet.addAll(UnixFileSystem.standardFileAttributeViews());
            hashSet.add("dos");
            hashSet.add("user");
            return Collections.unmodifiableSet(hashSet);
        }
    }
}

