/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rcp.application.actions;

import com.jrockit.mc.rcp.application.ApplicationPlugin;
import com.jrockit.mc.rcp.application.actions.Messages;
import com.jrockit.mc.ui.UIPlugin;
import com.jrockit.mc.ui.idesupport.FiletypeManager;
import com.jrockit.mc.ui.idesupport.IFiletypeOpener;
import com.jrockit.mc.ui.idesupport.OpenHandler;
import java.io.File;
import java.util.ArrayList;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;

public class OpenFileAction
extends Action
implements IWorkbenchWindowActionDelegate {
    private static final String KLEENE_STAR_DOT = "*.";
    private static final String FILE_OPEN_FILTER_PATH = "file.open.filter.path";
    private static final String DEMO_DIRECTORY = "flightrecordings";
    private static final String JDK_RELATIVE_DEMO_DIRECTORY = "sample/missioncontrol/flightrecordings";
    private IWorkbenchWindow m_window;
    private String m_filterPath;

    public OpenFileAction() {
        super(Messages.OpenFileAction_OPEN_FILE_TITLE_TEXT);
        this.setEnabled(true);
    }

    public void dispose() {
        this.m_window = null;
        this.m_filterPath = null;
    }

    public void init(IWorkbenchWindow window) {
        this.m_window = window;
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    public String getDefaultFilterPath() {
        String result = OpenFileAction.getLastFilterPath();
        if (result == null && (result = OpenFileAction.getSamplePath()) == null && (result = OpenFileAction.getUserHomePath()) == null) {
            result = "./";
        }
        return result;
    }

    private static String getLastFilterPath() {
        return OpenFileAction.getIfExists(ApplicationPlugin.getDefault().getDialogSettings().get(FILE_OPEN_FILTER_PATH));
    }

    private static String getUserHomePath() {
        return OpenFileAction.getIfExists(System.getProperty("user.home"));
    }

    public static String getSamplePath() {
        String javaHome = OpenFileAction.getIfExists(System.getProperty("java.home"));
        String result = null;
        if (javaHome != null && (result = OpenFileAction.getJoinedIfExists(javaHome, JDK_RELATIVE_DEMO_DIRECTORY)) == null) {
            result = OpenFileAction.getJoinedIfExists(new File(javaHome).getParent(), JDK_RELATIVE_DEMO_DIRECTORY);
        }
        if (result == null) {
            result = OpenFileAction.getJoinedIfExists(".", DEMO_DIRECTORY);
        }
        if (result == null) {
            result = OpenFileAction.getJoinedIfExists(OpenFileAction.getEclipseLaunchedSamplesFolder(), DEMO_DIRECTORY);
        }
        return result;
    }

    private static String getEclipseLaunchedSamplesFolder() {
        String app = Platform.getBundle((String)"com.jrockit.mc.rcp.application").getLocation();
        app = app.substring("reference:file:/".length());
        File base = new File(app).getParentFile();
        return OpenFileAction.getJoinedIfExists(base.getAbsolutePath(), "com.jrockit.mc.rcp.product/rootfiles/");
    }

    private static String getIfExists(String path) {
        if (OpenFileAction.exists(path)) {
            return path;
        }
        return null;
    }

    private static boolean exists(String path) {
        if (path != null) {
            return new File(path).exists();
        }
        return false;
    }

    private static String getJoinedIfExists(String base, String child) {
        if (base != null && child != null) {
            return OpenFileAction.getIfExists(new File(base, child).getPath());
        }
        return null;
    }

    public void setDefaultFilterPath(String path) {
        IDialogSettings settings = ApplicationPlugin.getDefault().getDialogSettings();
        settings.put(FILE_OPEN_FILTER_PATH, path);
    }

    public void run() {
        FileDialog dialog = new FileDialog(this.m_window.getShell(), 4098);
        dialog.setFilterPath(this.m_filterPath);
        this.setFilterNamesAndExtensions(dialog);
        dialog.setText(Messages.OpenFileAction_OPEN_FILE_TITLE);
        if (dialog.open() == null) {
            return;
        }
        String[] names = dialog.getFileNames();
        if (names != null) {
            this.setDefaultFilterPath(dialog.getFilterPath());
            this.m_filterPath = dialog.getFilterPath();
            int numberOfFilesNotFound = 0;
            StringBuffer notFound = new StringBuffer();
            String[] stringArray = names;
            int n = names.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                final File file = new File(String.valueOf(this.m_filterPath) + File.separator + name);
                if (file.exists()) {
                    final IWorkbenchWindow window = this.getWindow();
                    window.getWorkbench().getDisplay().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            OpenHandler command = UIPlugin.getDefault().getFiletypeManager().getFileOpener(file.getName());
                            if (command != null) {
                                command.open(window, (Object)file);
                            } else {
                                String msg = NLS.bind((String)Messages.OpenFileAction_FILEFORMAT_NOT_SUPPORTED_TEXT, (Object)file.getName());
                                MessageDialog.openError((Shell)window.getShell(), (String)Messages.OpenFileAction_ERROR_WHEN_OPENING_FILE_TEXT_TITLE, (String)msg);
                            }
                        }
                    });
                } else {
                    if (++numberOfFilesNotFound > 1) {
                        notFound.append('\n');
                    }
                    notFound.append(file.getName());
                }
                ++n2;
            }
            if (numberOfFilesNotFound > 0) {
                String msgFmt = numberOfFilesNotFound == 1 ? Messages.OpenFileAction_CANT_FIND_SINGLE_FILE_TEXT : Messages.OpenFileAction_CANT_FIND_MULTIPLE_FILES_TEXT;
                String msg = NLS.bind((String)msgFmt, (Object[])new Object[]{notFound.toString()});
                MessageDialog.openError((Shell)this.m_window.getShell(), (String)Messages.OpenFileAction_ERROR_WHEN_OPENING_FILE_TEXT_TITLE, (String)msg);
            }
        }
    }

    public IWorkbenchWindow getWindow() {
        return this.m_window;
    }

    private void setFilterNamesAndExtensions(FileDialog dialog) {
        FiletypeManager ftm = UIPlugin.getDefault().getFiletypeManager();
        ArrayList<String> filterExtensionsList = new ArrayList<String>();
        ArrayList<String> filterNamesList = new ArrayList<String>();
        if (File.pathSeparatorChar == ';') {
            this.addFilterStringForAll(filterExtensionsList, filterNamesList, ftm);
        }
        int defaultIndex = this.addSingleFilterString(filterExtensionsList, filterNamesList, ftm);
        filterExtensionsList.add("*.*");
        filterNamesList.add("All files (*.*)");
        String[] filterExtensions = new String[filterExtensionsList.size()];
        filterExtensionsList.toArray(filterExtensions);
        dialog.setFilterExtensions(filterExtensions);
        String[] filterNames = new String[filterNamesList.size()];
        filterNamesList.toArray(filterNames);
        dialog.setFilterNames(filterNames);
        if (defaultIndex != -1) {
            dialog.setFilterIndex(defaultIndex);
        }
    }

    private int addSingleFilterString(ArrayList<String> filterExtensionsList, ArrayList<String> filterNameList, FiletypeManager ftm) {
        int index = -1;
        IFiletypeOpener[] openers = ftm.getFiletypeOpeners();
        int n = 0;
        while (n < openers.length) {
            String[] fileExtensions;
            String[] stringArray = fileExtensions = openers[n].getFileExtensions();
            int n2 = fileExtensions.length;
            int n3 = 0;
            while (n3 < n2) {
                String fileExtension = stringArray[n3];
                filterExtensionsList.add(KLEENE_STAR_DOT + fileExtension);
                ++n3;
            }
            String[] fileExtensionNames = openers[n].getFileExtensionsNames();
            int m = 0;
            while (m < fileExtensionNames.length) {
                filterNameList.add(String.valueOf(fileExtensionNames[m]) + " ( " + KLEENE_STAR_DOT + fileExtensions[m] + " )");
                ++m;
            }
            if (openers[n].isDefault()) {
                index = n;
            }
            ++n;
        }
        return index;
    }

    private void addFilterStringForAll(ArrayList<String> filterExtensionsList, ArrayList<String> filterNameList, FiletypeManager ftm) {
        IFiletypeOpener[] openers;
        IFiletypeOpener[] iFiletypeOpenerArray = openers = ftm.getFiletypeOpeners();
        int n = openers.length;
        int n2 = 0;
        while (n2 < n) {
            IFiletypeOpener opener = iFiletypeOpenerArray[n2];
            String[] extensions = opener.getFileExtensions();
            if (extensions.length > 1) {
                String ext = this.getFilterStringForAll(extensions);
                filterExtensionsList.add(ext);
                filterNameList.add(String.valueOf(opener.getName()) + " ( " + ext + " )");
            }
            ++n2;
        }
    }

    private String getFilterStringForAll(String[] extensions) {
        StringBuilder builder = new StringBuilder();
        int n = 0;
        while (n < extensions.length) {
            builder.append(KLEENE_STAR_DOT);
            builder.append(extensions[n]);
            if (n != extensions.length - 1) {
                builder.append(File.pathSeparatorChar);
            }
            ++n;
        }
        return builder.toString();
    }

    public void run(IAction action) {
        this.run();
    }
}

