/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.memory;

import java.awt.AWTKeyStroke;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.HashSet;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumnModel;
import org.netbeans.lib.profiler.results.CCTNode;
import org.netbeans.lib.profiler.results.ExportDataDumper;
import org.netbeans.lib.profiler.results.memory.LivenessMemoryResultsSnapshot;
import org.netbeans.lib.profiler.results.memory.MemoryCCTManager;
import org.netbeans.lib.profiler.results.memory.MemoryResultsSnapshot;
import org.netbeans.lib.profiler.results.memory.PresoObjAllocCCTNode;
import org.netbeans.lib.profiler.results.memory.PresoObjLivenessCCTNode;
import org.netbeans.lib.profiler.ui.UIConstants;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.components.FilterComponent;
import org.netbeans.lib.profiler.ui.components.JTreeTable;
import org.netbeans.lib.profiler.ui.components.table.CustomBarCellRenderer;
import org.netbeans.lib.profiler.ui.components.treetable.AbstractTreeTableModel;
import org.netbeans.lib.profiler.ui.components.treetable.ExtendedTreeTableModel;
import org.netbeans.lib.profiler.ui.components.treetable.JTreeTablePanel;
import org.netbeans.lib.profiler.ui.components.treetable.TreeTableModel;
import org.netbeans.lib.profiler.ui.memory.MemoryResUserActionsHandler;
import org.netbeans.lib.profiler.ui.memory.ReverseMemCallGraphPanel;
import org.netbeans.lib.profiler.utils.StringUtils;
import org.netbeans.modules.profiler.api.icons.Icons;

public class SnapshotReverseMemCallGraphPanel
extends ReverseMemCallGraphPanel {
    private static final ResourceBundle messages = ResourceBundle.getBundle("org.netbeans.lib.profiler.ui.memory.Bundle");
    private static final String NO_STACK_TRACES_MSG = messages.getString("SnapshotReverseMemCallGraphPanel_NoStackTracesMsg");
    private static final String TREETABLE_ACCESS_NAME = messages.getString("SnapshotReverseMemCallGraphPanel_TreeTableAccessName");
    private static final String METHOD_NAME_FILTER = messages.getString("MemoryResultsPanel_MethodNameFilterHint");
    protected int classId;
    private AbstractTreeTableModel abstractTreeTableModel;
    private JPanel noContentPanel;
    private MemoryCCTManager callGraphManager;
    private MemoryResultsSnapshot snapshot;
    private boolean initialSortingOrder;
    private int initialSortingColumn;

    public SnapshotReverseMemCallGraphPanel(MemoryResultsSnapshot memoryResultsSnapshot, MemoryResUserActionsHandler memoryResUserActionsHandler) {
        super(memoryResUserActionsHandler, memoryResultsSnapshot instanceof LivenessMemoryResultsSnapshot);
        this.snapshot = memoryResultsSnapshot;
        this.noContentPanel = new JPanel();
        this.noContentPanel.setLayout(new BorderLayout());
        this.noContentPanel.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
        JLabel jLabel = new JLabel(Icons.getIcon((String)"ProfilerIcons.SnapshotMemory32"));
        jLabel.setBorder(BorderFactory.createEmptyBorder(10, 10, 0, 5));
        jLabel.setVerticalAlignment(1);
        jLabel.setEnabled(false);
        JTextArea jTextArea = new JTextArea(NO_STACK_TRACES_MSG);
        jTextArea.setBorder(BorderFactory.createEmptyBorder(10, 0, 0, 0));
        jTextArea.setFont(jTextArea.getFont().deriveFont(14));
        jTextArea.setEditable(false);
        jTextArea.setEnabled(false);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setLineWrap(true);
        jTextArea.setBackground(this.noContentPanel.getBackground());
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)jLabel, "West");
        jPanel.add((Component)jTextArea, "Center");
        this.noContentPanel.add((Component)jPanel, "North");
        this.setDefaultSorting();
    }

    public void setClassId(int n) {
        this.classId = n;
        this.callGraphManager = new MemoryCCTManager(this.snapshot, n, true);
        if (!this.callGraphManager.isEmpty()) {
            this.customBarCellRenderer = new CustomBarCellRenderer(0L, this.callGraphManager.getRootNode().totalObjSize);
            this.columnRenderers[1] = this.customBarCellRenderer;
        }
    }

    public BufferedImage getCurrentViewScreenshot(boolean bl) {
        if (this.treeTablePanel == null || this.treeTable == null) {
            return null;
        }
        if (bl) {
            return UIUtils.createScreenshot(this.treeTablePanel.getScrollPane());
        }
        return UIUtils.createScreenshot(this.treeTable);
    }

    private StringBuffer getCSVHeader(String string) {
        String string2 = "\r\n";
        String string3 = "\"";
        StringBuffer stringBuffer = new StringBuffer(string3 + this.columnNames[0] + string3 + string);
        for (int i = 2; i < this.columnNames.length; ++i) {
            stringBuffer.append(string3).append(this.columnNames[i]).append(string3).append(string);
        }
        stringBuffer.append(messages.getString("SnapshotReverseMemCallGraphPanel_ExportAddedColumnName")).append(string2);
        return stringBuffer;
    }

    public void exportData(int n, ExportDataDumper exportDataDumper, String string) {
        if (this.callGraphManager.getRootNode() instanceof PresoObjLivenessCCTNode) {
            ((PresoObjLivenessCCTNode)this.callGraphManager.getRootNode()).setDecimalFormat();
            switch (n) {
                case 1: {
                    exportDataDumper.dumpData(this.getCSVHeader(","));
                    ((PresoObjLivenessCCTNode)this.callGraphManager.getRootNode()).exportCSVData(",", 0, exportDataDumper);
                    exportDataDumper.close();
                    break;
                }
                case 2: {
                    exportDataDumper.dumpData(this.getCSVHeader(";"));
                    ((PresoObjLivenessCCTNode)this.callGraphManager.getRootNode()).exportCSVData(";", 0, exportDataDumper);
                    exportDataDumper.close();
                    break;
                }
                case 3: {
                    exportDataDumper.dumpData(this.getXMLHeader(string));
                    ((PresoObjLivenessCCTNode)this.callGraphManager.getRootNode()).exportXMLData(exportDataDumper, " ");
                    exportDataDumper.dumpDataAndClose(this.getXMLFooter());
                    break;
                }
                case 4: {
                    exportDataDumper.dumpData(this.getHTMLHeader(string));
                    ((PresoObjLivenessCCTNode)this.callGraphManager.getRootNode()).exportHTMLData(exportDataDumper, 0);
                    exportDataDumper.dumpDataAndClose(this.getHTMLFooter());
                }
            }
        } else {
            switch (n) {
                case 1: {
                    exportDataDumper.dumpData(this.getCSVHeader(","));
                    this.callGraphManager.getRootNode().exportCSVData(",", 0, exportDataDumper);
                    exportDataDumper.close();
                    break;
                }
                case 2: {
                    exportDataDumper.dumpData(this.getCSVHeader(";"));
                    this.callGraphManager.getRootNode().exportCSVData(";", 0, exportDataDumper);
                    exportDataDumper.close();
                    break;
                }
                case 3: {
                    exportDataDumper.dumpData(this.getXMLHeader(string));
                    this.callGraphManager.getRootNode().exportXMLData(exportDataDumper, " ");
                    exportDataDumper.dumpDataAndClose(this.getXMLFooter());
                    break;
                }
                case 4: {
                    exportDataDumper.dumpData(this.getHTMLHeader(string));
                    this.callGraphManager.getRootNode().exportHTMLData(exportDataDumper, 0);
                    exportDataDumper.dumpDataAndClose(this.getHTMLFooter());
                }
            }
        }
    }

    private StringBuffer getHTMLHeader(String string) {
        StringBuffer stringBuffer = new StringBuffer("<HTML><HEAD><meta http-equiv=\"Content-type\" content=\"text/html; charset=utf-8\" /><TITLE>" + string + "</TITLE><style type=\"text/css\">pre.method{overflow:auto;width:600;height:30;vertical-align:baseline}pre.parent{overflow:auto;width:400;height:30;vertical-align:baseline}td.method{text-align:left;width:600}td.parent{text-align:left;width:400}td.right{text-align:right;white-space:nowrap}</style></HEAD><BODY><table border=\"1\"><tr><th>" + this.columnNames[0] + "</th>");
        for (int i = 2; i < this.columnNames.length; ++i) {
            stringBuffer.append("<th>").append(this.columnNames[i]).append("</th>");
        }
        stringBuffer.append("<th>").append(messages.getString("SnapshotReverseMemCallGraphPanel_ExportAddedColumnName")).append("</th></tr>");
        return stringBuffer;
    }

    private StringBuffer getHTMLFooter() {
        return new StringBuffer("</TABLE></BODY></HTML>");
    }

    private StringBuffer getXMLHeader(String string) {
        String string2 = System.getProperty("line.separator");
        StringBuffer stringBuffer = new StringBuffer("<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + string2 + "<ExportedView Name=\"" + string + "\" type=\"tree\">" + string2 + "<tree>" + string2);
        return stringBuffer;
    }

    private StringBuffer getXMLFooter() {
        String string = System.getProperty("line.separator");
        StringBuffer stringBuffer = new StringBuffer("</tree>" + string + "</ExportedView>");
        return stringBuffer;
    }

    public void setDefaultSorting() {
        this.setSorting(1, false);
    }

    public boolean isEmpty() {
        return this.callGraphManager == null || this.callGraphManager.isEmpty();
    }

    public void setSorting(int n, boolean bl) {
        if (n == -1) {
            this.setDefaultSorting();
        } else {
            this.initialSortingColumn = n;
            this.initialSortingOrder = bl;
        }
    }

    public boolean fitsVisibleArea() {
        return !this.treeTablePanel.getScrollPane().getVerticalScrollBar().isEnabled();
    }

    public boolean hasView() {
        return this.treeTable != null;
    }

    @Override
    public void prepareResults() {
        if (this.callGraphManager == null || this.callGraphManager.isEmpty()) {
            this.removeAll();
            this.add((Component)this.noContentPanel, "Center");
        } else {
            this.abstractTreeTableModel = new AbstractTreeTableModel((CCTNode)this.callGraphManager.getRootNode(), this.initialSortingColumn, this.initialSortingOrder){

                @Override
                public int getColumnCount() {
                    return SnapshotReverseMemCallGraphPanel.this.columnNames.length;
                }

                @Override
                public String getColumnName(int n) {
                    return SnapshotReverseMemCallGraphPanel.this.columnNames[n];
                }

                @Override
                public Class getColumnClass(int n) {
                    if (n == 0) {
                        return TreeTableModel.class;
                    }
                    return Object.class;
                }

                @Override
                public Object getValueAt(Object object, int n) {
                    if (SnapshotReverseMemCallGraphPanel.this.extendedResults) {
                        PresoObjLivenessCCTNode presoObjLivenessCCTNode = (PresoObjLivenessCCTNode)object;
                        switch (n) {
                            case 0: {
                                return presoObjLivenessCCTNode;
                            }
                            case 1: {
                                return new Long(presoObjLivenessCCTNode.totalObjSize);
                            }
                            case 2: {
                                long l = ((PresoObjLivenessCCTNode)this.root).totalObjSize;
                                return SnapshotReverseMemCallGraphPanel.this.intFormat.format(presoObjLivenessCCTNode.totalObjSize) + " B (" + (l == 0L ? "-%" : SnapshotReverseMemCallGraphPanel.this.percentFormat.format((float)presoObjLivenessCCTNode.totalObjSize / (float)l)) + ")";
                            }
                            case 3: {
                                long l = ((PresoObjLivenessCCTNode)this.root).nLiveObjects;
                                return SnapshotReverseMemCallGraphPanel.this.intFormat.format(presoObjLivenessCCTNode.nLiveObjects) + " (" + (l == 0L ? "-%" : SnapshotReverseMemCallGraphPanel.this.percentFormat.format((float)presoObjLivenessCCTNode.nLiveObjects / (float)l)) + ")";
                            }
                            case 4: {
                                return SnapshotReverseMemCallGraphPanel.this.intFormat.format(presoObjLivenessCCTNode.nCalls);
                            }
                            case 5: {
                                return StringUtils.floatPerCentToString((float)presoObjLivenessCCTNode.avgObjectAge);
                            }
                            case 6: {
                                return SnapshotReverseMemCallGraphPanel.this.intFormat.format(presoObjLivenessCCTNode.survGen);
                            }
                        }
                    } else {
                        PresoObjAllocCCTNode presoObjAllocCCTNode = (PresoObjAllocCCTNode)object;
                        switch (n) {
                            case 0: {
                                return presoObjAllocCCTNode;
                            }
                            case 1: {
                                return new Long(presoObjAllocCCTNode.totalObjSize);
                            }
                            case 2: {
                                long l = ((PresoObjAllocCCTNode)this.root).totalObjSize;
                                return SnapshotReverseMemCallGraphPanel.this.intFormat.format(presoObjAllocCCTNode.totalObjSize) + " B (" + (l == 0L ? "-%" : SnapshotReverseMemCallGraphPanel.this.percentFormat.format((float)presoObjAllocCCTNode.totalObjSize / (float)l)) + ")";
                            }
                            case 3: {
                                long l = ((PresoObjAllocCCTNode)this.root).nCalls;
                                return SnapshotReverseMemCallGraphPanel.this.intFormat.format(presoObjAllocCCTNode.nCalls) + " (" + (l == 0L ? "-%" : SnapshotReverseMemCallGraphPanel.this.percentFormat.format((float)presoObjAllocCCTNode.nCalls / (float)l)) + ")";
                            }
                        }
                    }
                    return null;
                }

                @Override
                public String getColumnToolTipText(int n) {
                    return SnapshotReverseMemCallGraphPanel.this.columnToolTips[n];
                }

                @Override
                public void sortByColumn(int n, boolean bl) {
                    if (SnapshotReverseMemCallGraphPanel.this.extendedResults) {
                        PresoObjLivenessCCTNode presoObjLivenessCCTNode = (PresoObjLivenessCCTNode)this.root;
                        switch (n) {
                            case 0: {
                                presoObjLivenessCCTNode.sortChildren(6, bl);
                                break;
                            }
                            case 1: 
                            case 2: {
                                presoObjLivenessCCTNode.sortChildren(1, bl);
                                break;
                            }
                            case 3: {
                                presoObjLivenessCCTNode.sortChildren(2, bl);
                                break;
                            }
                            case 4: {
                                presoObjLivenessCCTNode.sortChildren(3, bl);
                                break;
                            }
                            case 5: {
                                presoObjLivenessCCTNode.sortChildren(4, bl);
                                break;
                            }
                            case 6: {
                                presoObjLivenessCCTNode.sortChildren(5, bl);
                            }
                        }
                    } else {
                        PresoObjAllocCCTNode presoObjAllocCCTNode = (PresoObjAllocCCTNode)this.root;
                        switch (n) {
                            case 0: {
                                presoObjAllocCCTNode.sortChildren(1, bl);
                                break;
                            }
                            case 1: 
                            case 2: {
                                presoObjAllocCCTNode.sortChildren(2, bl);
                                break;
                            }
                            case 3: {
                                presoObjAllocCCTNode.sortChildren(3, bl);
                            }
                        }
                    }
                }

                @Override
                public boolean getInitialSorting(int n) {
                    switch (n) {
                        case 0: {
                            return true;
                        }
                    }
                    return false;
                }
            };
            this.treeTableModel = new ExtendedTreeTableModel(this.abstractTreeTableModel);
            this.treeTable = new JTreeTable(this.treeTableModel){

                @Override
                public void doLayout() {
                    int n = 0;
                    int n2 = -1;
                    TableColumnModel tableColumnModel = this.getColumnModel();
                    for (int i = 0; i < SnapshotReverseMemCallGraphPanel.this.treeTableModel.getColumnCount(); ++i) {
                        int n3 = SnapshotReverseMemCallGraphPanel.this.treeTableModel.getRealColumn(i);
                        if (n3 == 0) {
                            n2 = i;
                            continue;
                        }
                        n += tableColumnModel.getColumn(i).getPreferredWidth();
                    }
                    if (n2 != -1) {
                        tableColumnModel.getColumn(n2).setPreferredWidth(Math.max(this.getWidth() - n, SnapshotReverseMemCallGraphPanel.this.minNamesColumnWidth));
                    }
                    super.doLayout();
                }
            };
            this.treeTable.getAccessibleContext().setAccessibleName(TREETABLE_ACCESS_NAME);
            this.treeTable.setRowSelectionAllowed(true);
            this.treeTable.setSelectionMode(0);
            this.treeTable.setGridColor(UIConstants.TABLE_VERTICAL_GRID_COLOR);
            this.treeTable.setSelectionBackground(UIConstants.TABLE_SELECTION_BACKGROUND_COLOR);
            this.treeTable.setSelectionForeground(UIConstants.TABLE_SELECTION_FOREGROUND_COLOR);
            this.treeTable.setShowHorizontalLines(false);
            this.treeTable.setShowVerticalLines(true);
            this.treeTable.setRowMargin(0);
            this.treeTable.setRowHeight(UIUtils.getDefaultRowHeight() + 2);
            this.treeTable.getInputMap(1).put(KeyStroke.getKeyStroke(10, 0), "DEFAULT_ACTION");
            this.treeTable.getActionMap().put("DEFAULT_ACTION", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    SnapshotReverseMemCallGraphPanel.this.performDefaultAction(SnapshotReverseMemCallGraphPanel.this.treePath);
                }
            });
            HashSet<AWTKeyStroke> hashSet = new HashSet<AWTKeyStroke>(this.treeTable.getFocusTraversalKeys(0));
            hashSet.add(KeyStroke.getKeyStroke(9, 0));
            this.treeTable.setFocusTraversalKeys(0, hashSet);
            hashSet = new HashSet<AWTKeyStroke>(this.treeTable.getFocusTraversalKeys(1));
            hashSet.add(KeyStroke.getKeyStroke(9, 1));
            this.treeTable.setFocusTraversalKeys(1, hashSet);
            this.setColumnsData();
            UIUtils.autoExpandRoot(this.treeTable.getTree());
            UIUtils.makeTreeAutoExpandable(this.treeTable.getTree());
            this.treeTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    int n = SnapshotReverseMemCallGraphPanel.this.treeTable.getSelectedRow();
                    if (n == -1) {
                        return;
                    }
                    SnapshotReverseMemCallGraphPanel.this.treePath = SnapshotReverseMemCallGraphPanel.this.treeTable.getTree().getPathForRow(n);
                }
            });
            this.treeTable.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent keyEvent) {
                    int n;
                    if ((keyEvent.getKeyCode() == 525 || keyEvent.getKeyCode() == 121 && keyEvent.getModifiers() == 1) && (n = SnapshotReverseMemCallGraphPanel.this.treeTable.getSelectedRow()) != -1) {
                        SnapshotReverseMemCallGraphPanel.this.treePath = SnapshotReverseMemCallGraphPanel.this.treeTable.getTree().getPathForRow(n);
                        PresoObjAllocCCTNode presoObjAllocCCTNode = (PresoObjAllocCCTNode)SnapshotReverseMemCallGraphPanel.this.treePath.getLastPathComponent();
                        SnapshotReverseMemCallGraphPanel.this.enableDisablePopup(presoObjAllocCCTNode);
                        Rectangle rectangle = SnapshotReverseMemCallGraphPanel.this.treeTable.getCellRect(n, 0, false);
                        SnapshotReverseMemCallGraphPanel.this.popupMenu.show(keyEvent.getComponent(), rectangle.x + SnapshotReverseMemCallGraphPanel.this.treeTable.getSize().width > 50 ? 50 : 5, rectangle.y);
                    }
                }
            });
            this.treeTable.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent mouseEvent) {
                    if (mouseEvent.getModifiers() == 4) {
                        SnapshotReverseMemCallGraphPanel.this.treePath = SnapshotReverseMemCallGraphPanel.this.treeTable.getTree().getPathForRow(SnapshotReverseMemCallGraphPanel.this.treeTable.rowAtPoint(mouseEvent.getPoint()));
                        if (SnapshotReverseMemCallGraphPanel.this.treePath != null) {
                            SnapshotReverseMemCallGraphPanel.this.treeTable.getTree().setSelectionPath(SnapshotReverseMemCallGraphPanel.this.treePath);
                        }
                    }
                }

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    SnapshotReverseMemCallGraphPanel.this.treePath = SnapshotReverseMemCallGraphPanel.this.treeTable.getTree().getPathForRow(SnapshotReverseMemCallGraphPanel.this.treeTable.rowAtPoint(mouseEvent.getPoint()));
                    if (SnapshotReverseMemCallGraphPanel.this.treePath == null) {
                        if (mouseEvent.getModifiers() == 4) {
                            SnapshotReverseMemCallGraphPanel.this.treeTable.getTree().clearSelection();
                        }
                    } else {
                        SnapshotReverseMemCallGraphPanel.this.treeTable.getTree().setSelectionPath(SnapshotReverseMemCallGraphPanel.this.treePath);
                        if (mouseEvent.getModifiers() == 4) {
                            PresoObjAllocCCTNode presoObjAllocCCTNode = (PresoObjAllocCCTNode)SnapshotReverseMemCallGraphPanel.this.treePath.getLastPathComponent();
                            SnapshotReverseMemCallGraphPanel.this.enableDisablePopup(presoObjAllocCCTNode);
                            SnapshotReverseMemCallGraphPanel.this.popupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                        } else if (mouseEvent.getModifiers() == 16 && mouseEvent.getClickCount() == 2 && SnapshotReverseMemCallGraphPanel.this.treeTableModel.isLeaf(SnapshotReverseMemCallGraphPanel.this.treePath.getPath()[SnapshotReverseMemCallGraphPanel.this.treePath.getPath().length - 1])) {
                            SnapshotReverseMemCallGraphPanel.this.performDefaultAction(SnapshotReverseMemCallGraphPanel.this.treePath);
                        }
                    }
                }
            });
            this.removeAll();
            this.treeTablePanel = new JTreeTablePanel(this.treeTable);
            this.treeTablePanel.clearBorders();
            this.treeTablePanel.setCorner("UPPER_RIGHT_CORNER", this.cornerButton);
            this.add((Component)this.treeTablePanel, "Center");
            this.initFilterPanel();
        }
    }

    private void initFilterPanel() {
        this.filterComponent = FilterComponent.create(true, true);
        this.filterComponent.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                String string = SnapshotReverseMemCallGraphPanel.this.filterComponent.getFilterValue();
                int n = SnapshotReverseMemCallGraphPanel.this.filterComponent.getFilterType();
                SnapshotReverseMemCallGraphPanel.this.snapshot.filterReverse(string, n, SnapshotReverseMemCallGraphPanel.this.treeTable.getSortingColumn(), SnapshotReverseMemCallGraphPanel.this.treeTable.getSortingOrder(), (PresoObjAllocCCTNode)SnapshotReverseMemCallGraphPanel.this.abstractTreeTableModel.getRoot(), SnapshotReverseMemCallGraphPanel.this.classId, true);
                SnapshotReverseMemCallGraphPanel.this.treeTable.updateTreeTable();
            }
        });
        this.filterComponent.setHint(METHOD_NAME_FILTER);
        this.add((Component)this.filterComponent.getComponent(), "South");
    }

    private void enableDisablePopup(PresoObjAllocCCTNode presoObjAllocCCTNode) {
        if (this.popupShowSource != null) {
            this.popupShowSource.setEnabled(!presoObjAllocCCTNode.isFilteredNode());
        }
    }
}

