/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.cpu;

import java.awt.AWTKeyStroke;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.text.NumberFormat;
import java.util.HashSet;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import org.netbeans.lib.profiler.results.CCTNode;
import org.netbeans.lib.profiler.results.ExportDataDumper;
import org.netbeans.lib.profiler.results.FilterSortSupport;
import org.netbeans.lib.profiler.results.cpu.PrestimeCPUCCTNode;
import org.netbeans.lib.profiler.results.cpu.PrestimeCPUCCTNodeBacked;
import org.netbeans.lib.profiler.ui.UIConstants;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.components.FilterComponent;
import org.netbeans.lib.profiler.ui.components.JTreeTable;
import org.netbeans.lib.profiler.ui.components.table.CustomBarCellRenderer;
import org.netbeans.lib.profiler.ui.components.table.LabelBracketTableCellRenderer;
import org.netbeans.lib.profiler.ui.components.table.LabelTableCellRenderer;
import org.netbeans.lib.profiler.ui.components.tree.EnhancedTreeCellRenderer;
import org.netbeans.lib.profiler.ui.components.tree.MethodNameTreeCellRenderer;
import org.netbeans.lib.profiler.ui.components.treetable.AbstractTreeTableModel;
import org.netbeans.lib.profiler.ui.components.treetable.ExtendedTreeTableModel;
import org.netbeans.lib.profiler.ui.components.treetable.JTreeTablePanel;
import org.netbeans.lib.profiler.ui.components.treetable.TreeTableModel;
import org.netbeans.lib.profiler.ui.cpu.CPUResUserActionsHandler;
import org.netbeans.lib.profiler.ui.cpu.CPUSelectionHandler;
import org.netbeans.lib.profiler.ui.cpu.ScreenshotProvider;
import org.netbeans.lib.profiler.ui.cpu.SnapshotCPUResultsPanel;
import org.netbeans.lib.profiler.utils.StringUtils;
import org.netbeans.modules.profiler.api.icons.Icons;

public class CCTDisplay
extends SnapshotCPUResultsPanel
implements ScreenshotProvider {
    private static final ResourceBundle messages = ResourceBundle.getBundle("org.netbeans.lib.profiler.ui.cpu.Bundle");
    private static final String METHOD_COLUMN_NAME = messages.getString("CCTDisplay_MethodColumnName");
    private static final String METHOD_COLUMN_TOOLTIP = messages.getString("CCTDisplay_MethodColumnToolTip");
    private static final String METHOD_FILTER_HINT = messages.getString("FlatProfilePanel_MethodFilterHint");
    private static final String CLASS_COLUMN_NAME = messages.getString("CCTDisplay_ClassColumnName");
    private static final String CLASS_COLUMN_TOOLTIP = messages.getString("CCTDisplay_ClassColumnToolTip");
    private static final String CLASS_FILTER_HINT = messages.getString("FlatProfilePanel_ClassFilterHint");
    private static final String PACKAGE_COLUMN_NAME = messages.getString("CCTDisplay_PackageColumnName");
    private static final String PACKAGE_COLUMN_TOOLTIP = messages.getString("CCTDisplay_PackageColumnToolTip");
    private static final String PACKAGE_FILTER_HINT = messages.getString("FlatProfilePanel_PackageFilterHint");
    private static final String TIME_REL_COLUMN_NAME = messages.getString("CCTDisplay_TimeRelColumnName");
    private static final String TIME_COLUMN_NAME = messages.getString("CCTDisplay_TimeColumnName");
    private static final String TIME_CPU_COLUMN_NAME = messages.getString("CCTDisplay_TimeCpuColumnName");
    private static final String INVOCATIONS_COLUMN_NAME = messages.getString("CCTDisplay_InvocationsColumnName");
    private static final String SAMPLES_COLUMN_NAME = messages.getString("CCTDisplay_SamplesColumnName");
    private static final String TIME_REL_COLUMN_TOOLTIP = messages.getString("CCTDisplay_TimeRelColumnToolTip");
    private static final String TIME_COLUMN_TOOLTIP = messages.getString("CCTDisplay_TimeColumnToolTip");
    private static final String TIME_CPU_COLUMN_TOOLTIP = messages.getString("CCTDisplay_TimeCpuColumnToolTip");
    private static final String INVOCATIONS_COLUMN_TOOLTIP = messages.getString("CCTDisplay_InvocationsColumnToolTip");
    private static final String SAMPLES_COLUMN_TOOLTIP = messages.getString("CCTDisplay_SamplesColumnToolTip");
    private static final String TREETABLE_ACCESS_NAME = messages.getString("CCTDisplay_TreeTableAccessName");
    private static final String FILTER_ITEM_NAME = messages.getString("FlatProfilePanel_FilterItemName");
    private static final boolean DEBUG = System.getProperty("org.netbeans.lib.profiler.ui.cpu.CCTDisplay") != null;
    protected JTreeTable treeTable;
    protected JTreeTablePanel treeTablePanel;
    protected FilterComponent filterComponent;
    protected boolean sortOrder;
    protected int sortingColumn;
    private AbstractTreeTableModel abstractTreeTableModel;
    private CPUSelectionHandler selectionHandler;
    private EnhancedTreeCellRenderer enhancedTreeCellRenderer = new MethodNameTreeCellRenderer();
    private ExtendedTreeTableModel treeTableModel;
    private Icon leafIcon = Icons.getIcon((String)"ProfilerIcons.NodeLeaf");
    private Icon nodeIcon = Icons.getIcon((String)"ProfilerIcons.NodeForward");
    private JButton cornerButton;
    private int minNamesColumnWidth;

    public CCTDisplay(CPUResUserActionsHandler cPUResUserActionsHandler, Boolean bl) {
        this(cPUResUserActionsHandler, null, bl);
    }

    public CCTDisplay(CPUResUserActionsHandler cPUResUserActionsHandler, CPUSelectionHandler cPUSelectionHandler, Boolean bl) {
        super(cPUResUserActionsHandler, bl);
        this.selectionHandler = cPUSelectionHandler;
        this.enhancedTreeCellRenderer.setLeafIcon(this.leafIcon);
        this.enhancedTreeCellRenderer.setClosedIcon(this.nodeIcon);
        this.enhancedTreeCellRenderer.setOpenIcon(this.nodeIcon);
        this.minNamesColumnWidth = this.getFontMetrics(this.getFont()).charWidth('W') * 30;
        this.cornerPopup = new JPopupMenu();
        this.cornerButton = this.createHeaderPopupCornerButton(this.cornerPopup);
        this.setDefaultSorting();
    }

    public void exportData(int n, ExportDataDumper exportDataDumper, boolean bl, String string) {
        this.percentFormat.setMaximumFractionDigits(2);
        this.percentFormat.setMinimumFractionDigits(2);
        PrestimeCPUCCTNodeBacked.setPercentFormat((NumberFormat)this.percentFormat);
        switch (n) {
            case 1: {
                exportDataDumper.dumpData(this.getCSVHeader(","));
                ((PrestimeCPUCCTNodeBacked)this.abstractTreeTableModel.getRoot()).exportCSVData(",", n, exportDataDumper);
                if (bl) break;
                exportDataDumper.close();
                break;
            }
            case 2: {
                exportDataDumper.dumpData(this.getCSVHeader(";"));
                ((PrestimeCPUCCTNodeBacked)this.abstractTreeTableModel.getRoot()).exportCSVData(";", n, exportDataDumper);
                if (bl) break;
                exportDataDumper.close();
                break;
            }
            case 3: {
                exportDataDumper.dumpData(this.getXMLHeader(bl, string));
                ((PrestimeCPUCCTNodeBacked)this.abstractTreeTableModel.getRoot()).exportXMLData(exportDataDumper, "  ");
                if (!bl) {
                    exportDataDumper.dumpDataAndClose(this.getXMLFooter(bl));
                    break;
                }
                exportDataDumper.dumpData(this.getXMLFooter(bl));
                break;
            }
            case 4: {
                exportDataDumper.dumpData(this.getHTMLHeader(string));
                ((PrestimeCPUCCTNodeBacked)this.abstractTreeTableModel.getRoot()).exportHTMLData(exportDataDumper, 0);
                if (!bl) {
                    exportDataDumper.dumpDataAndClose(this.getHTMLFooter(bl));
                    break;
                }
                exportDataDumper.dumpData(this.getHTMLFooter(bl));
            }
        }
        this.percentFormat.setMaximumFractionDigits(1);
        this.percentFormat.setMinimumFractionDigits(0);
    }

    public void clearSelection() {
        this.treeTable.clearSelection();
    }

    private StringBuffer getCSVHeader(String string) {
        String string2 = "\r\n";
        String string3 = "\"";
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.columnCount; ++i) {
            stringBuffer.append(string3).append(this.columnNames[i]).append(string3).append(string);
        }
        stringBuffer.append(string2);
        return stringBuffer;
    }

    private StringBuffer getHTMLHeader(String string) {
        StringBuffer stringBuffer = new StringBuffer("<HTML><HEAD><meta http-equiv=\"Content-type\" content=\"text/html; charset=utf-8\" /><TITLE>" + string + "</TITLE><style type=\"text/css\">pre.method{overflow:auto;width:600;height:30;vertical-align:baseline}pre.parent{overflow:auto;width:400;height:30;vertical-align:baseline}td.method{text-align:left;width:600}td.parent{text-align:left;width:400}td.right{text-align:right;white-space:nowrap}</style></HEAD><BODY><table border=\"1\"><tr>");
        stringBuffer.append("<th>").append(this.columnNames[0]).append("</th><th>").append(this.columnNames[1]).append("</th><th>").append(this.columnNames[2]).append("</th><th>").append(this.columnNames[3]).append("</th></tr>");
        return stringBuffer;
    }

    private StringBuffer getHTMLFooter(boolean bl) {
        if (bl) {
            return new StringBuffer("</TABLE>");
        }
        return new StringBuffer("</TABLE></BODY></HTML>");
    }

    private StringBuffer getXMLHeader(boolean bl, String string) {
        String string2 = System.getProperty("line.separator");
        StringBuffer stringBuffer = new StringBuffer("<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + string2 + "<ExportedView Name=\"" + string + "\" type=\"" + (bl ? "combined" : "tree") + "\">" + string2 + "<tree>" + string2);
        return stringBuffer;
    }

    private StringBuffer getXMLFooter(boolean bl) {
        String string = System.getProperty("line.separator");
        StringBuffer stringBuffer = !bl ? new StringBuffer("</tree>" + string + "</ExportedView>") : new StringBuffer("</tree>" + string + string);
        return stringBuffer;
    }

    @Override
    public int getCurrentThreadId() {
        return -10;
    }

    @Override
    public BufferedImage getCurrentViewScreenshot(boolean bl) {
        if (this.treeTablePanel == null || this.treeTable == null) {
            return null;
        }
        if (bl) {
            return UIUtils.createScreenshot(this.treeTablePanel.getScrollPane());
        }
        return UIUtils.createScreenshot(this.treeTable);
    }

    public void setDefaultSorting() {
        this.setSorting(1, false);
    }

    @Override
    public String getDefaultViewName() {
        return "cpu-calltree";
    }

    public void setFindString(String string) {
        this.treeTable.setFindParameters(string, 0);
    }

    public String getFindString() {
        return this.treeTable.getFindString();
    }

    public boolean isFindStringDefined() {
        return this.treeTable.isFindStringDefined();
    }

    public Object getResultsViewReference() {
        return this.treeTable;
    }

    public void setSorting(int n, boolean bl) {
        this.setSorting(n, bl, false);
    }

    public void setSorting(int n, boolean bl, boolean bl2) {
        if (!bl2 && n == -1) {
            this.setDefaultSorting();
        } else {
            this.sortingColumn = n;
            this.sortOrder = bl;
        }
        if (bl2) {
            this.treeTable.setSortingColumn(this.treeTableModel.getVirtualColumn(n));
            this.treeTable.setSortingOrder(bl);
            this.treeTableModel.sortByColumn(n, bl);
        }
    }

    @Override
    public int getSortingColumn() {
        if (this.treeTable == null || this.treeTableModel == null) {
            return -1;
        }
        return this.treeTableModel.getRealColumn(this.treeTable.getSortingColumn());
    }

    @Override
    public boolean getSortingOrder() {
        if (this.treeTable == null) {
            return false;
        }
        return this.treeTable.getSortingOrder();
    }

    public void addResultsViewFocusListener(FocusListener focusListener) {
        this.treeTable.addFocusListener(focusListener);
    }

    public boolean findFirst() {
        return this.treeTable.findFirst();
    }

    public boolean findNext() {
        return this.treeTable.findNext();
    }

    public boolean findPrevious() {
        return this.treeTable.findPrevious();
    }

    @Override
    public boolean fitsVisibleArea() {
        return !this.treeTablePanel.getScrollPane().getVerticalScrollBar().isEnabled();
    }

    @Override
    public void prepareResults() {
        int n;
        int n2 = n = this.snapshot.isCollectingTwoTimeStamps() ? 5 : 4;
        if (DEBUG) {
            ++this.columnCount;
        }
        if (this.columnCount != n) {
            this.initColumnsData();
        } else if (this.treeTable != null) {
            this.saveColumnsData();
        }
        if (this.treeTable != null) {
            this.sortingColumn = this.treeTable.getSortingColumn();
        }
        this.reset();
        if (this.filterComponent == null) {
            this.filterComponent = FilterComponent.create(true, true);
        }
        this.initVariableColumnNames();
        this.abstractTreeTableModel = new AbstractTreeTableModel((CCTNode)this.snapshot.getRootNode(this.currentView), this.sortingColumn, this.sortOrder){

            @Override
            public int getColumnCount() {
                return CCTDisplay.this.columnCount;
            }

            @Override
            public String getColumnName(int n) {
                return CCTDisplay.this.columnNames[n];
            }

            @Override
            public Class getColumnClass(int n) {
                if (n == 0) {
                    return TreeTableModel.class;
                }
                return Object.class;
            }

            @Override
            public Object getValueAt(Object object, int n) {
                if (!CCTDisplay.this.snapshot.isCollectingTwoTimeStamps() && n > 2) {
                    ++n;
                }
                PrestimeCPUCCTNode prestimeCPUCCTNode = (PrestimeCPUCCTNode)object;
                switch (n) {
                    case 0: {
                        return prestimeCPUCCTNode;
                    }
                    case 1: {
                        return CCTDisplay.this.getNodeTimeRel(prestimeCPUCCTNode.getTotalTime0(), prestimeCPUCCTNode.getTotalTime0InPerCent());
                    }
                    case 2: {
                        return CCTDisplay.this.getNodeTime(prestimeCPUCCTNode.getTotalTime0(), prestimeCPUCCTNode.getTotalTime0InPerCent());
                    }
                    case 3: {
                        return CCTDisplay.this.getNodeSecondaryTime(prestimeCPUCCTNode.getTotalTime1());
                    }
                    case 4: {
                        return CCTDisplay.this.getNodeInvocations(prestimeCPUCCTNode.getNCalls());
                    }
                    case 5: {
                        return this.getNodeMethodId(prestimeCPUCCTNode);
                    }
                }
                return null;
            }

            @Override
            public String getColumnToolTipText(int n) {
                return CCTDisplay.this.columnToolTips[n];
            }

            private Integer getNodeMethodId(PrestimeCPUCCTNode prestimeCPUCCTNode) {
                return prestimeCPUCCTNode.getMethodId();
            }

            @Override
            public void sortByColumn(int n, boolean bl) {
                CCTDisplay.this.sortOrder = bl;
                if (!CCTDisplay.this.snapshot.isCollectingTwoTimeStamps() && n > 2) {
                    ++n;
                }
                PrestimeCPUCCTNode prestimeCPUCCTNode = (PrestimeCPUCCTNode)this.root;
                switch (n) {
                    case 0: {
                        prestimeCPUCCTNode.sortChildren(1, bl);
                        break;
                    }
                    case 1: {
                        prestimeCPUCCTNode.sortChildren(2, bl);
                        break;
                    }
                    case 2: {
                        prestimeCPUCCTNode.sortChildren(2, bl);
                        break;
                    }
                    case 3: {
                        prestimeCPUCCTNode.sortChildren(3, bl);
                        break;
                    }
                    case 4: {
                        prestimeCPUCCTNode.sortChildren(4, bl);
                    }
                }
            }

            @Override
            public boolean getInitialSorting(int n) {
                return n == 0;
            }
        };
        this.treeTableModel = new ExtendedTreeTableModel(this.abstractTreeTableModel);
        if (this.columnsVisibility != null) {
            this.treeTableModel.setColumnsVisibility(this.columnsVisibility);
        }
        this.treeTable = new JTreeTable(this.treeTableModel){

            @Override
            public void doLayout() {
                int n = 0;
                int n2 = -1;
                TableColumnModel tableColumnModel = this.getColumnModel();
                for (int i = 0; i < CCTDisplay.this.treeTableModel.getColumnCount(); ++i) {
                    int n3 = CCTDisplay.this.treeTableModel.getRealColumn(i);
                    if (n3 == 0) {
                        n2 = i;
                        continue;
                    }
                    n += tableColumnModel.getColumn(i).getPreferredWidth();
                }
                if (n2 != -1) {
                    tableColumnModel.getColumn(n2).setPreferredWidth(Math.max(this.getWidth() - n, CCTDisplay.this.minNamesColumnWidth));
                }
                super.doLayout();
            }
        };
        this.treeTable.getAccessibleContext().setAccessibleName(TREETABLE_ACCESS_NAME);
        this.treeTable.setRowSelectionAllowed(true);
        this.treeTable.setSelectionMode(0);
        this.treeTable.setGridColor(UIConstants.TABLE_VERTICAL_GRID_COLOR);
        this.treeTable.setSelectionBackground(UIConstants.TABLE_SELECTION_BACKGROUND_COLOR);
        this.treeTable.setSelectionForeground(UIConstants.TABLE_SELECTION_FOREGROUND_COLOR);
        this.treeTable.setShowHorizontalLines(false);
        this.treeTable.setShowVerticalLines(true);
        this.treeTable.setRowMargin(0);
        this.treeTable.setRowHeight(UIUtils.getDefaultRowHeight() + 2);
        this.treeTable.getTree().setRootVisible(false);
        this.treeTable.getTree().setShowsRootHandles(true);
        this.treeTable.getInputMap(1).put(KeyStroke.getKeyStroke(10, 0), "DEFAULT_ACTION");
        this.treeTable.getActionMap().put("DEFAULT_ACTION", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CCTDisplay.this.performDefaultAction();
            }
        });
        HashSet<AWTKeyStroke> hashSet = new HashSet<AWTKeyStroke>(this.treeTable.getFocusTraversalKeys(0));
        hashSet.add(KeyStroke.getKeyStroke(9, 0));
        this.treeTable.setFocusTraversalKeys(0, hashSet);
        hashSet = new HashSet<AWTKeyStroke>(this.treeTable.getFocusTraversalKeys(1));
        hashSet.add(KeyStroke.getKeyStroke(9, 1));
        this.treeTable.setFocusTraversalKeys(1, hashSet);
        this.setColumnsData();
        UIUtils.autoExpandRoot(this.treeTable.getTree(), 2);
        UIUtils.makeTreeAutoExpandable(this.treeTable.getTree(), 2);
        this.treeTable.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                int n;
                if ((keyEvent.getKeyCode() == 525 || keyEvent.getKeyCode() == 121 && keyEvent.getModifiers() == 1) && (n = CCTDisplay.this.treeTable.getSelectedRow()) != -1) {
                    CCTDisplay.this.popupPath = CCTDisplay.this.treeTable.getTree().getPathForRow(n);
                    PrestimeCPUCCTNode prestimeCPUCCTNode = (PrestimeCPUCCTNode)CCTDisplay.this.popupPath.getLastPathComponent();
                    CCTDisplay.this.enableDisablePopup(prestimeCPUCCTNode);
                    Rectangle rectangle = CCTDisplay.this.treeTable.getCellRect(n, 0, false);
                    CCTDisplay.this.callGraphPopupMenu.show(keyEvent.getComponent(), rectangle.x + CCTDisplay.this.treeTable.getSize().width > 50 ? 50 : 5, rectangle.y);
                }
            }
        });
        this.treeTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (mouseEvent.getModifiers() == 4) {
                    CCTDisplay.this.popupPath = CCTDisplay.this.treeTable.getTree().getPathForRow(CCTDisplay.this.treeTable.rowAtPoint(mouseEvent.getPoint()));
                    if (CCTDisplay.this.popupPath != null) {
                        CCTDisplay.this.treeTable.getTree().setSelectionPath(CCTDisplay.this.popupPath);
                    }
                }
            }

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                CCTDisplay.this.popupPath = CCTDisplay.this.treeTable.getTree().getPathForRow(CCTDisplay.this.treeTable.rowAtPoint(mouseEvent.getPoint()));
                if (CCTDisplay.this.popupPath == null) {
                    if (mouseEvent.getModifiers() == 4) {
                        CCTDisplay.this.treeTable.getTree().clearSelection();
                    }
                } else {
                    CCTDisplay.this.treeTable.getTree().setSelectionPath(CCTDisplay.this.popupPath);
                    PrestimeCPUCCTNode prestimeCPUCCTNode = (PrestimeCPUCCTNode)CCTDisplay.this.popupPath.getLastPathComponent();
                    CCTDisplay.this.enableDisablePopup(prestimeCPUCCTNode);
                    if (mouseEvent.getModifiers() == 4) {
                        CCTDisplay.this.callGraphPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                    } else if (mouseEvent.getModifiers() == 16 && mouseEvent.getClickCount() == 2 && CCTDisplay.this.treeTableModel.isLeaf(CCTDisplay.this.popupPath.getPath()[CCTDisplay.this.popupPath.getPath().length - 1])) {
                        CCTDisplay.this.showSourceForMethod(CCTDisplay.this.popupPath);
                    }
                }
            }
        });
        this.treeTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                int n = CCTDisplay.this.treeTable.getSelectedRow();
                if (n == -1) {
                    return;
                }
                CCTDisplay.this.popupPath = CCTDisplay.this.treeTable.getTree().getPathForRow(n);
                PrestimeCPUCCTNode prestimeCPUCCTNode = (PrestimeCPUCCTNode)CCTDisplay.this.popupPath.getLastPathComponent();
                if (CCTDisplay.this.selectionHandler != null) {
                    CCTDisplay.this.selectionHandler.methodSelected(prestimeCPUCCTNode.getThreadId(), prestimeCPUCCTNode.getMethodId(), CCTDisplay.this.currentView);
                }
            }
        });
        this.treeTablePanel = new JTreeTablePanel(this.treeTable);
        this.treeTablePanel.clearBorders();
        this.treeTablePanel.setCorner("UPPER_RIGHT_CORNER", this.cornerButton);
        this.add((Component)this.treeTablePanel, "Center");
        this.initFilterPanel();
    }

    protected Float getNodeTimeRel(long l, float f) {
        return new Float(f);
    }

    protected String getNodeTime(long l, float f) {
        return StringUtils.mcsTimeToString((long)l) + " ms (" + this.percentFormat.format(f / 100.0f) + ")";
    }

    protected String getNodeSecondaryTime(long l) {
        return StringUtils.mcsTimeToString((long)l) + " ms";
    }

    protected String getNodeInvocations(int n) {
        return Integer.valueOf(n).toString();
    }

    private void initFilterPanel() {
        FilterSortSupport.Configuration configuration = this.snapshot.getFilterSortInfo((CCTNode)((PrestimeCPUCCTNode)this.treeTableModel.getRoot()));
        this.filterComponent.setFilter(configuration.getFilterString(), configuration.getFilterType());
        this.filterComponent.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                String string = CCTDisplay.this.filterComponent.getFilterValue();
                int n = CCTDisplay.this.filterComponent.getFilterType();
                CCTDisplay.this.snapshot.filterForward(string, n, (PrestimeCPUCCTNodeBacked)CCTDisplay.this.treeTableModel.getRoot());
                CCTDisplay.this.treeTable.updateTreeTable();
            }
        });
        this.add((Component)this.filterComponent.getComponent(), "South");
    }

    public void removeResultsViewFocusListener(FocusListener focusListener) {
        this.treeTable.removeFocusListener(focusListener);
    }

    @Override
    public void requestFocus() {
        if (this.treeTable != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    CCTDisplay.this.treeTable.requestFocus();
                }
            });
        }
    }

    @Override
    public void reset() {
        if (this.treeTablePanel != null) {
            this.remove(this.treeTablePanel);
            this.treeTablePanel = null;
            this.remove(this.filterComponent.getComponent());
            this.filterComponent = null;
        }
        this.treeTable = null;
        this.abstractTreeTableModel = null;
        this.treeTableModel = null;
    }

    public boolean silentlyFindFirst() {
        return this.treeTable.silentlyFindFirst();
    }

    @Override
    protected String getSelectedMethodName() {
        if (this.treeTable == null || this.treeTableModel == null) {
            return null;
        }
        if (this.treeTable.getSelectedRow() == -1) {
            return null;
        }
        PrestimeCPUCCTNode prestimeCPUCCTNode = (PrestimeCPUCCTNode)this.treeTable.getTree().getSelectionPath().getLastPathComponent();
        if (prestimeCPUCCTNode.isSelfTimeNode()) {
            prestimeCPUCCTNode = (PrestimeCPUCCTNode)prestimeCPUCCTNode.getParent();
        }
        if (prestimeCPUCCTNode.isThreadNode()) {
            prestimeCPUCCTNode = (PrestimeCPUCCTNode)prestimeCPUCCTNode.getChildren()[0];
        }
        return this.treeTableModel.getValueAt(prestimeCPUCCTNode, 0).toString();
    }

    @Override
    protected void initColumnSelectorItems() {
        this.cornerPopup.removeAll();
        for (int i = 0; i < this.columnCount; ++i) {
            JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(this.columnNames[i]);
            jCheckBoxMenuItem.setActionCommand(Integer.valueOf(i).toString());
            this.addMenuItemListener(jCheckBoxMenuItem);
            if (this.treeTable != null) {
                jCheckBoxMenuItem.setState(this.treeTableModel.isRealColumnVisible(i));
                if (i == 0) {
                    jCheckBoxMenuItem.setEnabled(false);
                }
            } else {
                jCheckBoxMenuItem.setState(true);
            }
            this.cornerPopup.add(jCheckBoxMenuItem);
        }
        this.cornerPopup.addSeparator();
        JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(FILTER_ITEM_NAME);
        jCheckBoxMenuItem.setActionCommand("Filter");
        this.addMenuItemListener(jCheckBoxMenuItem);
        if (this.filterComponent == null) {
            jCheckBoxMenuItem.setState(true);
        } else {
            jCheckBoxMenuItem.setState(this.filterComponent.getComponent().isVisible());
        }
        this.cornerPopup.add(jCheckBoxMenuItem);
        this.cornerPopup.pack();
    }

    private void setColumnsData() {
        TableColumnModel tableColumnModel = this.treeTable.getColumnModel();
        this.treeTable.setTreeCellRenderer(this.enhancedTreeCellRenderer);
        tableColumnModel.getColumn(0).setPreferredWidth(this.minNamesColumnWidth);
        for (int i = 0; i < this.treeTableModel.getColumnCount(); ++i) {
            int n = this.treeTableModel.getRealColumn(i);
            if (n == 0) continue;
            tableColumnModel.getColumn(i).setPreferredWidth(this.columnWidths[n - 1]);
            tableColumnModel.getColumn(i).setCellRenderer(this.columnRenderers[n]);
        }
    }

    private void addMenuItemListener(JCheckBoxMenuItem jCheckBoxMenuItem) {
        jCheckBoxMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getActionCommand().equals("Filter")) {
                    CCTDisplay.this.filterComponent.getComponent().setVisible(!CCTDisplay.this.filterComponent.getComponent().isVisible());
                    return;
                }
                boolean bl = false;
                int n = Integer.parseInt(actionEvent.getActionCommand());
                CCTDisplay.this.sortingColumn = CCTDisplay.this.treeTable.getSortingColumn();
                int n2 = CCTDisplay.this.treeTableModel.getRealColumn(CCTDisplay.this.sortingColumn);
                boolean bl2 = CCTDisplay.this.treeTableModel.isRealColumnVisible(n);
                if (bl2 && n == n2) {
                    CCTDisplay.this.sortingColumn = CCTDisplay.this.sortingColumn + 1 == CCTDisplay.this.treeTableModel.getColumnCount() ? CCTDisplay.this.sortingColumn - 1 : CCTDisplay.this.sortingColumn + 1;
                    n2 = CCTDisplay.this.treeTableModel.getRealColumn(CCTDisplay.this.sortingColumn);
                    bl = true;
                }
                CCTDisplay.this.treeTableModel.setRealColumnVisibility(n, !bl2);
                CCTDisplay.this.treeTable.createDefaultColumnsFromModel();
                CCTDisplay.this.treeTable.updateTreeTableHeader();
                CCTDisplay.this.sortingColumn = CCTDisplay.this.treeTableModel.getVirtualColumn(n2);
                if (bl) {
                    CCTDisplay.this.sortOrder = CCTDisplay.this.treeTableModel.getInitialSorting(CCTDisplay.this.sortingColumn);
                    CCTDisplay.this.treeTableModel.sortByColumn(CCTDisplay.this.sortingColumn, CCTDisplay.this.sortOrder);
                    CCTDisplay.this.treeTable.updateTreeTable();
                }
                CCTDisplay.this.treeTable.setSortingColumn(CCTDisplay.this.sortingColumn);
                CCTDisplay.this.treeTable.setSortingOrder(CCTDisplay.this.sortOrder);
                CCTDisplay.this.treeTable.getTableHeader().repaint();
                CCTDisplay.this.setColumnsData();
            }
        });
    }

    protected void enableDisablePopup(PrestimeCPUCCTNode prestimeCPUCCTNode) {
        boolean bl;
        boolean bl2 = bl = prestimeCPUCCTNode.getThreadId() != -1 && prestimeCPUCCTNode.getMethodId() != 0 && !prestimeCPUCCTNode.isFilteredNode();
        if (this.popupShowSource != null) {
            this.popupShowSource.setEnabled(bl && this.isShowSourceAvailable());
        }
        if (this.popupShowSubtree != null) {
            this.popupShowSubtree.setEnabled(bl);
        }
        if (this.popupShowReverse != null) {
            this.popupShowReverse.setEnabled(bl);
        }
        this.popupFind.setEnabled(bl);
        if (this.selectionHandler != null) {
            this.selectionHandler.methodSelected(prestimeCPUCCTNode.getThreadId(), prestimeCPUCCTNode.getMethodId(), this.currentView);
        }
    }

    protected void initColumnsData() {
        int n;
        int n2 = this.columnCount = this.snapshot.isCollectingTwoTimeStamps() ? 5 : 4;
        if (DEBUG) {
            ++this.columnCount;
        }
        this.columnWidths = new int[this.columnCount - 1];
        this.columnNames = new String[this.columnCount];
        this.columnRenderers = new TableCellRenderer[this.columnCount];
        this.columnsVisibility = new boolean[this.columnCount];
        for (n = 0; n < this.columnCount - 1; ++n) {
            this.columnsVisibility[n] = true;
        }
        if (this.isSampling() != null && !this.isSampling().booleanValue()) {
            this.columnsVisibility[this.columnCount - 1] = true;
        }
        n = 0;
        this.columnNames = new String[this.columnCount];
        this.columnNames[n++] = "";
        this.columnNames[n++] = TIME_REL_COLUMN_NAME;
        this.columnNames[n++] = TIME_COLUMN_NAME;
        if (this.snapshot.isCollectingTwoTimeStamps()) {
            this.columnNames[n++] = TIME_CPU_COLUMN_NAME;
        }
        String string = this.columnNames[n++] = this.isSampling() != null && this.isSampling() != false ? SAMPLES_COLUMN_NAME : INVOCATIONS_COLUMN_NAME;
        if (DEBUG) {
            this.columnNames[n++] = "JMethodID";
        }
        n = 0;
        this.columnToolTips = new String[this.columnCount];
        this.columnToolTips[n++] = "";
        this.columnToolTips[n++] = TIME_REL_COLUMN_TOOLTIP;
        this.columnToolTips[n++] = TIME_COLUMN_TOOLTIP;
        if (this.snapshot.isCollectingTwoTimeStamps()) {
            this.columnToolTips[n++] = TIME_CPU_COLUMN_TOOLTIP;
        }
        String string2 = this.columnToolTips[n++] = this.isSampling() != null && this.isSampling() != false ? SAMPLES_COLUMN_TOOLTIP : INVOCATIONS_COLUMN_TOOLTIP;
        if (DEBUG) {
            this.columnToolTips[n++] = "JMethodID for the method";
        }
        int n3 = this.getFontMetrics(this.getFont()).charWidth('W') * 12;
        CustomBarCellRenderer customBarCellRenderer = new CustomBarCellRenderer(0L, 100L);
        LabelTableCellRenderer labelTableCellRenderer = new LabelTableCellRenderer(11);
        LabelBracketTableCellRenderer labelBracketTableCellRenderer = new LabelBracketTableCellRenderer(11);
        this.columnRenderers[0] = null;
        this.columnWidths[0] = n3;
        this.columnRenderers[1] = customBarCellRenderer;
        this.columnWidths[1] = n3;
        this.columnRenderers[2] = labelBracketTableCellRenderer;
        for (int i = 3; i < this.columnCount; ++i) {
            this.columnWidths[i - 1] = n3;
            this.columnRenderers[i] = labelTableCellRenderer;
        }
        if (this.isSampling() == null) {
            --this.columnCount;
        }
    }

    private void initVariableColumnNames() {
        switch (this.currentView) {
            case 0: {
                this.columnNames[0] = METHOD_COLUMN_NAME;
                this.columnToolTips[0] = METHOD_COLUMN_TOOLTIP;
                this.filterComponent.setHint(METHOD_FILTER_HINT);
                break;
            }
            case 1: {
                this.columnNames[0] = CLASS_COLUMN_NAME;
                this.columnToolTips[0] = CLASS_COLUMN_TOOLTIP;
                this.filterComponent.setHint(CLASS_FILTER_HINT);
                break;
            }
            case 2: {
                this.columnNames[0] = PACKAGE_COLUMN_NAME;
                this.columnToolTips[0] = PACKAGE_COLUMN_TOOLTIP;
                this.filterComponent.setHint(PACKAGE_FILTER_HINT);
            }
        }
        if (this.treeTable != null) {
            this.treeTable.getTableHeader().repaint();
        }
    }

    private void saveColumnsData() {
        TableColumnModel tableColumnModel = this.treeTable.getColumnModel();
        for (int i = 0; i < this.treeTableModel.getColumnCount(); ++i) {
            int n = this.treeTableModel.getRealColumn(i);
            if (n == 0) continue;
            this.columnWidths[n - 1] = tableColumnModel.getColumn(i).getPreferredWidth();
        }
        this.columnsVisibility = this.treeTableModel.getColumnsVisibility();
    }

    @Override
    public void setColumnsVisibility(boolean[] blArray) {
        this.treeTableModel.setColumnsVisibility(blArray);
        this.treeTable.createDefaultColumnsFromModel();
        this.treeTable.updateTreeTableHeader();
        this.setColumnsData();
    }

    @Override
    public boolean[] getColumnsVisibility() {
        return this.treeTableModel.getColumnsVisibility();
    }

    public void setFilterVisible(boolean bl) {
        if (this.filterComponent != null) {
            this.filterComponent.getComponent().setVisible(bl);
        }
    }

    public boolean isFilterVisible() {
        return this.filterComponent == null ? false : this.filterComponent.getComponent().isVisible();
    }

    public int getFilterType() {
        return this.filterComponent.getFilterType();
    }

    public String getFilterValue() {
        return this.filterComponent.getFilterValue();
    }

    public void setFilterValues(String string, int n) {
        this.filterComponent.setFilter(string, n);
    }
}

