/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.heapwalk.model;

import java.text.NumberFormat;
import java.util.List;
import javax.swing.ImageIcon;
import org.netbeans.lib.profiler.heap.FieldValue;
import org.netbeans.lib.profiler.heap.JavaClass;
import org.netbeans.modules.profiler.heapwalk.model.AbstractHeapWalkerNode;
import org.netbeans.modules.profiler.heapwalk.model.BrowserUtils;
import org.netbeans.modules.profiler.heapwalk.model.Bundle;
import org.netbeans.modules.profiler.heapwalk.model.ChildrenComputer;
import org.netbeans.modules.profiler.heapwalk.model.HeapWalkerNode;
import org.netbeans.modules.profiler.heapwalk.model.HeapWalkerNodeFactory;

public class ClassNode
extends AbstractHeapWalkerNode {
    private static final NumberFormat numberFormat = NumberFormat.getInstance();
    private JavaClass javaClass;
    private String name;

    public ClassNode(JavaClass javaClass, String string, HeapWalkerNode heapWalkerNode) {
        this(javaClass, string, heapWalkerNode, heapWalkerNode == null ? 1 : heapWalkerNode.getMode());
    }

    public ClassNode(JavaClass javaClass, String string, HeapWalkerNode heapWalkerNode, int n) {
        super(heapWalkerNode, n);
        this.javaClass = javaClass;
        this.name = string;
    }

    public JavaClass getJavaClass() {
        return this.javaClass;
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    protected HeapWalkerNode[] computeChildren() {
        return BrowserUtils.lazilyCreateChildren(this, new ChildrenComputer(){

            @Override
            public HeapWalkerNode[] computeChildren() {
                HeapWalkerNode[] heapWalkerNodeArray = null;
                List list = ClassNode.this.getJavaClass().getStaticFieldValues();
                if (list.size() == 0) {
                    heapWalkerNodeArray = new HeapWalkerNode[]{HeapWalkerNodeFactory.createNoFieldsNode(ClassNode.this)};
                } else {
                    heapWalkerNodeArray = new HeapWalkerNode[list.size()];
                    for (int i = 0; i < heapWalkerNodeArray.length; ++i) {
                        heapWalkerNodeArray[i] = HeapWalkerNodeFactory.createFieldNode((FieldValue)list.get(i), ClassNode.this);
                    }
                }
                return heapWalkerNodeArray;
            }
        });
    }

    @Override
    protected ImageIcon computeIcon() {
        return BrowserUtils.ICON_INSTANCE;
    }

    @Override
    protected String computeName() {
        return this.name;
    }

    @Override
    protected String computeType() {
        return this.javaClass.getName();
    }

    @Override
    protected String computeValue() {
        return Bundle.ClassNode_NoneString();
    }

    @Override
    protected String computeSize() {
        return numberFormat.format(this.javaClass.getAllInstancesSize());
    }

    @Override
    protected String computeRetainedSize() {
        return numberFormat.format(this.javaClass.getRetainedSizeByClass());
    }

    public static abstract class RootNode
    extends ClassNode
    implements org.netbeans.modules.profiler.heapwalk.model.RootNode {
        public RootNode(JavaClass javaClass, String string, HeapWalkerNode heapWalkerNode) {
            super(javaClass, string, heapWalkerNode);
        }

        public RootNode(JavaClass javaClass, String string, HeapWalkerNode heapWalkerNode, int n) {
            super(javaClass, string, heapWalkerNode, n);
        }

        @Override
        public abstract void refreshView();
    }
}

