/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.util;

import java.lang.reflect.Array;

public final class EqualsToolkit {
    public static final int SEED = 23;
    private static final int ODD_PRIME_NUMBER = 37;

    private EqualsToolkit() {
        throw new Error("Don't instantiate");
    }

    public static boolean nullSafeEquals(Object a, Object b) {
        return a == null ? b == null : a.equals(b);
    }

    public static int hash(int seed, boolean bool) {
        return EqualsToolkit.firstTerm(seed) + (bool ? 1 : 0);
    }

    public static int hash(int seed, char c) {
        return EqualsToolkit.firstTerm(seed) + c;
    }

    public static int hash(int seed, int i) {
        return EqualsToolkit.firstTerm(seed) + i;
    }

    public static int hash(int seed, long l) {
        return EqualsToolkit.firstTerm(seed) + (int)(l ^ l >>> 32);
    }

    public static int hash(int seed, float f) {
        return EqualsToolkit.hash(seed, Float.floatToIntBits(f));
    }

    public static int hash(int seed, double d) {
        return EqualsToolkit.hash(seed, Double.doubleToLongBits(d));
    }

    public static int hash(Object object) {
        return EqualsToolkit.hash(37, object);
    }

    public static int hash(int seed, Object object) {
        if (object != null) {
            if (EqualsToolkit.isArray(object)) {
                int result = seed;
                int length = Array.getLength(object);
                int idx = 0;
                while (idx < length) {
                    result = EqualsToolkit.hash(result, Array.get(object, idx));
                    ++idx;
                }
                return result;
            }
            return EqualsToolkit.hash(seed, object.hashCode());
        }
        return EqualsToolkit.hash(seed, 0);
    }

    private static int firstTerm(int seed) {
        return 37 * seed;
    }

    private static boolean isArray(Object object) {
        return object.getClass().isArray();
    }
}

