/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.internal.parser.binary;

import com.jrockit.mc.flightrecorder.internal.parser.binary.IByteInput;
import com.jrockit.mc.flightrecorder.internal.parser.binary.IntegerParser;
import com.jrockit.mc.flightrecorder.internal.parser.binary.InvalidFlrFileException;
import com.jrockit.mc.flightrecorder.internal.parser.binary.LongParser;

public class ChunkHeader {
    private static final byte[] FLIGHT_RECORDER_MAGIC;
    private static final int CHUNK_HEAD_SIZE;
    private final long chunkPosition;
    private final int chunkIndex;
    private final int metaDataOffset;
    private final int metaDataLength;

    static {
        byte[] byArray = new byte[4];
        byArray[0] = 70;
        byArray[1] = 76;
        byArray[2] = 82;
        FLIGHT_RECORDER_MAGIC = byArray;
        CHUNK_HEAD_SIZE = FLIGHT_RECORDER_MAGIC.length + 4 + 8;
    }

    public ChunkHeader(IByteInput input, int chunkIndex, long chunkPosition) throws Exception {
        byte[] chunkHeader = input.read(chunkPosition, CHUNK_HEAD_SIZE);
        int i = 0;
        while (i < FLIGHT_RECORDER_MAGIC.length) {
            if (FLIGHT_RECORDER_MAGIC[i] != chunkHeader[i]) {
                throw new InvalidFlrFileException();
            }
            ++i;
        }
        this.metaDataOffset = (int)LongParser.readLong(chunkHeader, 8);
        this.metaDataLength = IntegerParser.readInt(input.read(chunkPosition + (long)this.metaDataOffset, 4), 0);
        this.chunkIndex = chunkIndex;
        this.chunkPosition = chunkPosition;
    }

    public int getChunkSize() {
        return this.metaDataOffset + this.metaDataLength;
    }

    public int getHeaderSize() {
        return CHUNK_HEAD_SIZE;
    }

    public long getChunkPosition() {
        return this.chunkPosition;
    }

    public int getChunkIndex() {
        return this.chunkIndex;
    }

    public int getMetaDataOffset() {
        return this.metaDataOffset;
    }

    public int getMetaDataSize() {
        return this.metaDataLength;
    }
}

