/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.snaptracer.impl;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.text.Format;
import java.text.SimpleDateFormat;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.netbeans.lib.profiler.charts.axis.TimeAxisUtils;
import org.netbeans.lib.profiler.ui.components.ProfilerToolbar;
import org.netbeans.modules.profiler.api.icons.Icons;
import org.netbeans.modules.profiler.snaptracer.impl.AttachToBugAction;
import org.netbeans.modules.profiler.snaptracer.impl.Bundle;
import org.netbeans.modules.profiler.snaptracer.impl.ExportSnapshotAction;
import org.netbeans.modules.profiler.snaptracer.impl.TracerModel;
import org.netbeans.modules.profiler.snaptracer.impl.swing.VisibilityHandler;
import org.netbeans.modules.profiler.snaptracer.impl.timeline.TimelinePanel;
import org.netbeans.modules.profiler.snaptracer.impl.timeline.TimelineSupport;
import org.openide.filesystems.FileObject;

final class TimelineView {
    private final TracerModel model;
    private TimelinePanel panel;
    private JButton selectAllButton;
    private JButton clearTimestampSelectionButton;
    private JLabel selectionLabel;
    private VisibilityHandler viewHandler;
    private static final Format df = new SimpleDateFormat(TimeAxisUtils.TIME_MSEC);

    TimelineView(TracerModel tracerModel) {
        this.model = tracerModel;
    }

    void reset() {
        if (this.panel != null) {
            this.panel.reset();
        }
    }

    void resetSelection() {
        if (this.panel != null) {
            this.panel.resetSelection();
        }
    }

    void updateActions() {
        if (this.panel != null) {
            this.panel.updateActions();
        }
    }

    Action zoomInAction() {
        if (this.panel != null) {
            return this.panel.zoomInAction();
        }
        return null;
    }

    Action zoomOutAction() {
        if (this.panel != null) {
            return this.panel.zoomOutAction();
        }
        return null;
    }

    Action toggleViewAction() {
        if (this.panel != null) {
            return this.panel.toggleViewAction();
        }
        return null;
    }

    AbstractButton mouseZoom() {
        if (this.panel != null) {
            return this.panel.mouseZoom();
        }
        return null;
    }

    AbstractButton mouseHScroll() {
        if (this.panel != null) {
            return this.panel.mouseHScroll();
        }
        return null;
    }

    AbstractButton mouseVScroll() {
        if (this.panel != null) {
            return this.panel.mouseVScroll();
        }
        return null;
    }

    void registerViewListener(VisibilityHandler visibilityHandler) {
        if (this.panel != null) {
            visibilityHandler.handle(this.panel);
        } else {
            this.viewHandler = visibilityHandler;
        }
    }

    boolean isShowing() {
        return this.panel != null && this.panel.isShowing();
    }

    JComponent getView() {
        final TimelineSupport timelineSupport = this.model.getTimelineSupport();
        this.panel = new TimelinePanel(timelineSupport);
        if (this.viewHandler != null) {
            this.viewHandler.handle(this.panel);
            this.viewHandler = null;
        }
        ProfilerToolbar profilerToolbar = ProfilerToolbar.create((boolean)true);
        FileObject fileObject = this.model.getSnapshot().getNpssFileObject();
        profilerToolbar.add((Action)new ExportSnapshotAction(fileObject));
        if (AttachToBugAction.isSupported()) {
            profilerToolbar.add((Action)new AttachToBugAction(fileObject));
        }
        profilerToolbar.addSeparator();
        profilerToolbar.add(this.panel.zoomInAction());
        profilerToolbar.add(this.panel.zoomOutAction());
        profilerToolbar.add(this.panel.toggleViewAction());
        profilerToolbar.addSeparator();
        ButtonGroup buttonGroup = new ButtonGroup();
        AbstractButton abstractButton = this.panel.mouseZoom();
        buttonGroup.add(abstractButton);
        profilerToolbar.add((Component)abstractButton);
        AbstractButton abstractButton2 = this.panel.mouseHScroll();
        buttonGroup.add(abstractButton2);
        profilerToolbar.add((Component)abstractButton2);
        profilerToolbar.addSeparator();
        this.selectAllButton = new JButton(Icons.getIcon((String)"TracerIcons.SelectAll")){

            @Override
            protected void fireActionPerformed(ActionEvent actionEvent) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        timelineSupport.selectAll();
                    }
                });
            }
        };
        this.selectAllButton.setToolTipText(Bundle.TOOLTIP_SelectAll());
        profilerToolbar.add((Component)this.selectAllButton);
        this.clearTimestampSelectionButton = new JButton(Icons.getIcon((String)"TracerIcons.MarkClear")){

            @Override
            protected void fireActionPerformed(ActionEvent actionEvent) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        timelineSupport.resetSelectedTimestamps();
                    }
                });
            }
        };
        this.clearTimestampSelectionButton.setToolTipText(Bundle.TOOLTIP_ClearMarks());
        profilerToolbar.add((Component)this.clearTimestampSelectionButton);
        profilerToolbar.addSeparator();
        this.selectionLabel = new JLabel();
        profilerToolbar.add((Component)this.selectionLabel);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)profilerToolbar.getComponent(), "North");
        jPanel.add((Component)this.panel, "Center");
        timelineSupport.addSelectionListener(new TimelineSupport.SelectionListener(){

            @Override
            public void intervalsSelectionChanged() {
                TimelineView.this.updateSelectionToolbar();
            }

            @Override
            public void indexSelectionChanged() {
                TimelineView.this.updateSelectionToolbar();
            }

            @Override
            public void timeSelectionChanged(boolean bl, boolean bl2) {
                TimelineView.this.updateSelectionToolbar();
            }
        });
        this.updateSelectionToolbar();
        return jPanel;
    }

    private void updateSelectionToolbar() {
        TimelineSupport timelineSupport = this.model.getTimelineSupport();
        this.selectAllButton.setEnabled(!timelineSupport.isSelectAll());
        this.clearTimestampSelectionButton.setEnabled(timelineSupport.isTimestampSelection(false));
        int n = timelineSupport.getStartIndex();
        int n2 = timelineSupport.getEndIndex();
        String string = " " + Bundle.LBL_Selection() + " ";
        if (n == -1) {
            string = string + Bundle.LBL_None();
        } else if (n == n2) {
            string = string + df.format(timelineSupport.getTimestamp(n)) + ", " + Bundle.LBL_SingleSample(n);
        } else {
            long l = timelineSupport.getTimestamp(n);
            long l2 = timelineSupport.getTimestamp(n2);
            string = string + Bundle.LBL_TwoTimes(df.format(l), df.format(l2));
            string = string + " (" + (l2 - l) + " ms)";
            string = string + ", " + Bundle.LBL_TwoSamples(n, n2);
        }
        if (timelineSupport.isSelectAll()) {
            string = string + ", " + Bundle.LBL_EntireSnapshot();
        }
        this.selectionLabel.setText(string);
    }
}

