/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.snaptracer.impl;

import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.LogRecord;
import javax.swing.Icon;
import org.netbeans.lib.profiler.results.cpu.PrestimeCPUCCTNode;
import org.netbeans.modules.profiler.LoadedSnapshot;
import org.netbeans.modules.profiler.SampledCPUSnapshot;
import org.netbeans.modules.profiler.snaptracer.logs.LogReader;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;

public final class IdeSnapshot {
    private SampledCPUSnapshot cpuSnapshot;
    private LogReader xmlLogs;
    private LogRecord lastRecord;
    private Map<Integer, LogRecord> recordsMap;
    private Map<Integer, LogRecordInfo> infosMap;
    private final FileObject npssFileObject;

    IdeSnapshot(FileObject fileObject, FileObject fileObject2) throws IOException {
        this.cpuSnapshot = new SampledCPUSnapshot(fileObject);
        this.npssFileObject = fileObject;
        if (fileObject2 != null) {
            this.xmlLogs = new LogReader(fileObject2);
            this.xmlLogs.load();
            this.recordsMap = new HashMap<Integer, LogRecord>();
            this.infosMap = new HashMap<Integer, LogRecordInfo>();
        }
    }

    int getSamplesCount() {
        return this.cpuSnapshot.getSamplesCount();
    }

    long getTimestamp(int n) throws IOException {
        return this.cpuSnapshot.getTimestamp(n);
    }

    FileObject getNpssFileObject() {
        return this.npssFileObject;
    }

    public boolean hasUiGestures() {
        return this.xmlLogs != null;
    }

    LoadedSnapshot getCPUSnapshot(int n, int n2) throws IOException {
        return this.cpuSnapshot.getCPUSnapshot(n, n2);
    }

    public long getValue(int n, int n2) throws IOException {
        Integer n3;
        if (n2 == 0) {
            return this.cpuSnapshot.getValue(n, n2);
        }
        if (this.xmlLogs != null && (n3 = this.getLogRecordValue(n)) != null) {
            return n3.intValue();
        }
        return 0L;
    }

    public LogRecordInfo getLogInfoForValue(long l) {
        if (this.xmlLogs == null || l == 0L) {
            return null;
        }
        Integer n = new Integer((int)l);
        LogRecordInfo logRecordInfo = this.infosMap.get(n);
        if (logRecordInfo == null) {
            LogRecord logRecord = this.recordsMap.get(n);
            assert (logRecord != null) : "Null record for value " + n;
            logRecordInfo = new LogRecordInfo(logRecord);
            LogRecordDecorator.decorate(logRecordInfo);
            this.infosMap.put(n, logRecordInfo);
        }
        return logRecordInfo;
    }

    private Integer getLogRecordValue(int n) throws IOException {
        long l = this.getTimestamp(n);
        LogRecord logRecord = this.xmlLogs.getRecordFor(l / 1000000L);
        if (logRecord != null) {
            long l2 = this.cpuSnapshot.getStartTime();
            long l3 = this.getTimestamp(this.getSamplesCount() - 1);
            long l4 = logRecord.getMillis() * 1000000L;
            if (l4 > l2 && l4 < l3 && logRecord != this.lastRecord) {
                Integer n2 = new Integer(n + 1);
                this.lastRecord = logRecord;
                this.recordsMap.put(n2, logRecord);
                return n2;
            }
        }
        return null;
    }

    String getThreadDump(int n) throws IOException {
        return this.cpuSnapshot.getThreadDump(n);
    }

    List<Integer> getIntervals(int n, int n2, PrestimeCPUCCTNode prestimeCPUCCTNode) throws IOException {
        return this.cpuSnapshot.getIntervals(n, n2, prestimeCPUCCTNode);
    }

    private static final class LogRecordDecorator
    implements InvocationHandler {
        private static final String DECORATIONS_CLASS = "org.netbeans.lib.uihandler.Decorations";
        private static final String DECORABLE_CLASS = "org.netbeans.lib.uihandler.Decorable";
        private static final String DECORATE_METHOD = "decorate";
        private static final String DECORABLE_SETNAME_METHOD = "setName";
        private static final String DECORABLE_SETDISPLAYNAME_METHOD = "setDisplayName";
        private static final String DECORABLE_SETICONBASE_METHOD = "setIconBaseWithExtension";
        private static final String DECORABLE_SETSHORTDESCRIPTOR_METHOD = "setShortDescription";
        private LogRecordInfo recInfo;
        private LogRecord rec;

        LogRecordDecorator(LogRecordInfo logRecordInfo) {
            this.recInfo = logRecordInfo;
            this.rec = logRecordInfo.record;
        }

        private void decorateRecord() {
            try {
                ClassLoader classLoader = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
                Class<?> clazz = Class.forName(DECORATIONS_CLASS, true, classLoader);
                Class<?> clazz2 = Class.forName(DECORABLE_CLASS, true, classLoader);
                Object object = Proxy.newProxyInstance(classLoader, new Class[]{clazz2}, (InvocationHandler)this);
                Method method = clazz.getDeclaredMethod(DECORATE_METHOD, LogRecord.class, clazz2);
                method.invoke(null, this.rec, object);
            }
            catch (IllegalAccessException illegalAccessException) {
                Exceptions.printStackTrace((Throwable)illegalAccessException);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Exceptions.printStackTrace((Throwable)illegalArgumentException);
            }
            catch (InvocationTargetException invocationTargetException) {
                Exceptions.printStackTrace((Throwable)invocationTargetException);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                Exceptions.printStackTrace((Throwable)noSuchMethodException);
            }
            catch (SecurityException securityException) {
                Exceptions.printStackTrace((Throwable)securityException);
            }
            catch (ClassNotFoundException classNotFoundException) {
                Exceptions.printStackTrace((Throwable)classNotFoundException);
            }
        }

        @Override
        public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
            String string = method.getName();
            if (DECORABLE_SETNAME_METHOD.equals(string)) {
                this.recInfo.setName((String)objectArray[0]);
            }
            if (DECORABLE_SETDISPLAYNAME_METHOD.equals(string)) {
                this.recInfo.setDisplayName((String)objectArray[0]);
            }
            if (DECORABLE_SETSHORTDESCRIPTOR_METHOD.equals(string)) {
                this.recInfo.setToolTip((String)objectArray[0]);
            }
            if (DECORABLE_SETICONBASE_METHOD.equals(string)) {
                String string2 = (String)objectArray[0];
                this.recInfo.setIcon(ImageUtilities.loadImageIcon((String)string2, (boolean)true));
            }
            return null;
        }

        static void decorate(LogRecordInfo logRecordInfo) {
            new LogRecordDecorator(logRecordInfo).decorateRecord();
        }
    }

    public static final class LogRecordInfo {
        private static final int MAX_DISPLAY_NAME = 40;
        private String name;
        private String displayName;
        private String toolTip;
        private Icon icon;
        private LogRecord record;

        LogRecordInfo(LogRecord logRecord) {
            this.record = logRecord;
        }

        void setName(String string) {
            this.name = string;
        }

        public String getName() {
            return this.name;
        }

        void setDisplayName(String string) {
            this.displayName = string;
        }

        public String getDisplayName() {
            String string;
            if (this.displayName == null && (string = this.record.getMessage()) != null && string.length() > 0) {
                StringBuilder stringBuilder = new StringBuilder(string);
                Object[] objectArray = this.record.getParameters();
                if (objectArray != null && objectArray.length > 0) {
                    String string2 = " (";
                    for (Object object : objectArray) {
                        stringBuilder.append(string2);
                        stringBuilder.append(object);
                        string2 = ", ";
                        if (stringBuilder.length() <= 40) continue;
                        return stringBuilder.substring(0, 40).concat(" ...");
                    }
                    stringBuilder.append(")");
                }
                return stringBuilder.toString();
            }
            return this.displayName;
        }

        void setToolTip(String string) {
            this.toolTip = string;
        }

        public String getToolTip() {
            return this.toolTip;
        }

        void setIcon(Icon icon) {
            this.icon = icon;
        }

        public Icon getIcon() {
            return this.icon;
        }
    }
}

