/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.core.explorer;

import com.sun.tools.visualvm.core.datasource.DataSource;
import com.sun.tools.visualvm.core.explorer.ExplorerContextMenuFactory;
import com.sun.tools.visualvm.core.explorer.ExplorerModelBuilder;
import com.sun.tools.visualvm.core.explorer.ExplorerNodeRenderer;
import com.sun.tools.visualvm.core.explorer.ExplorerSupport;
import com.sun.tools.visualvm.uisupport.UISupport;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreePath;
import org.openide.windows.WindowManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ExplorerComponent
extends JPanel {
    private static final Color MAC_TREE_BG_FOCUSED = new Color(214, 221, 229);
    private static final Color MAC_TREE_BG_NOTFOCUSED = new Color(232, 232, 232);
    private static ExplorerComponent instance;
    private JTree explorerTree;
    private boolean vetoTreeExpansion = false;

    public static synchronized ExplorerComponent instance() {
        if (instance == null) {
            instance = new ExplorerComponent();
        }
        return instance;
    }

    private ExplorerComponent() {
        this.initComponents();
    }

    public JTree getTree() {
        return this.explorerTree;
    }

    @Override
    public boolean requestFocusInWindow() {
        if (this.explorerTree != null) {
            return this.explorerTree.requestFocusInWindow();
        }
        return super.requestFocusInWindow();
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        this.explorerTree = new JTree(ExplorerModelBuilder.getInstance().getModel()){

            protected void processMouseEvent(MouseEvent e) {
                Set<DataSource> selectedDataSources;
                ExplorerComponent.this.vetoTreeExpansion = false;
                if (e.getModifiers() == 16 && e.getClickCount() >= this.getToggleClickCount() && ExplorerComponent.getDefaultAction(selectedDataSources = ExplorerSupport.sharedInstance().getSelectedDataSources()) != null) {
                    ExplorerComponent.this.vetoTreeExpansion = true;
                }
                super.processMouseEvent(e);
            }

            public void updateUI() {
                super.updateUI();
                this.setCellRenderer(new ExplorerNodeRenderer());
            }
        };
        this.explorerTree.setRootVisible(false);
        this.explorerTree.setShowsRootHandles(true);
        this.explorerTree.setRowHeight(ExplorerComponent.getTreeRowHeight());
        this.explorerTree.setCellRenderer(new ExplorerNodeRenderer());
        this.explorerTree.getSelectionModel().setSelectionMode(4);
        this.explorerTree.addKeyListener(new ExplorerTreeKeyAdapter());
        this.explorerTree.addMouseListener(new ExplorerTreeMouseAdapter());
        if (UISupport.isAquaLookAndFeel()) {
            final Frame mainWindow = WindowManager.getDefault().getMainWindow();
            final Window[] ownerWindow = new Window[1];
            final WindowFocusListener focusListener = new WindowFocusListener(){

                public void windowGainedFocus(WindowEvent e) {
                    this.update(true, e);
                }

                public void windowLostFocus(WindowEvent e) {
                    this.update(false, e);
                }

                private void update(boolean hasFocus, WindowEvent e) {
                    boolean focus;
                    Window oppositeWindow = e.getOppositeWindow();
                    boolean bl = focus = hasFocus || oppositeWindow == mainWindow || oppositeWindow == ownerWindow[0];
                    if (focus) {
                        ExplorerComponent.this.explorerTree.setBackground(MAC_TREE_BG_FOCUSED);
                    } else {
                        ExplorerComponent.this.explorerTree.setBackground(MAC_TREE_BG_NOTFOCUSED);
                    }
                }
            };
            mainWindow.addWindowFocusListener(focusListener);
            this.explorerTree.addHierarchyListener(new HierarchyListener(){

                public void hierarchyChanged(HierarchyEvent e) {
                    if ((e.getChangeFlags() & 1L) != 0L) {
                        Window newOwnerWindow = SwingUtilities.getWindowAncestor(ExplorerComponent.this.explorerTree);
                        if (ownerWindow[0] == newOwnerWindow) {
                            return;
                        }
                        if (ownerWindow[0] != null && ownerWindow[0] != mainWindow) {
                            ownerWindow[0].removeWindowFocusListener(focusListener);
                        }
                        ownerWindow[0] = newOwnerWindow;
                        if (ownerWindow[0] != null && ownerWindow[0] != mainWindow) {
                            ownerWindow[0].addWindowFocusListener(focusListener);
                        }
                    }
                }
            });
        }
        JScrollPane explorerTreeScrollPane = new JScrollPane(this.explorerTree, 20, 30);
        explorerTreeScrollPane.setBorder(BorderFactory.createEmptyBorder());
        explorerTreeScrollPane.setViewportBorder(BorderFactory.createEmptyBorder());
        String DEFAULT_ACTION_KEY = "DEFAULT_ACTION";
        this.getInputMap(2).put(KeyStroke.getKeyStroke(10, 0), DEFAULT_ACTION_KEY);
        this.getInputMap(1).put(KeyStroke.getKeyStroke(10, 0), DEFAULT_ACTION_KEY);
        this.getActionMap().put(DEFAULT_ACTION_KEY, new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                ExplorerComponent.this.performDefaultAction();
            }
        });
        this.explorerTree.addTreeWillExpandListener(new TreeWillExpandListener(){

            public void treeWillExpand(TreeExpansionEvent event) throws ExpandVetoException {
                if (!ExplorerComponent.this.vetoTreeExpansion) {
                    return;
                }
                ExplorerComponent.this.vetoTreeExpansion = false;
                throw new ExpandVetoException(event);
            }

            public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
                if (!ExplorerComponent.this.vetoTreeExpansion) {
                    return;
                }
                ExplorerComponent.this.vetoTreeExpansion = false;
                throw new ExpandVetoException(event);
            }
        });
        this.add((Component)explorerTreeScrollPane, "Center");
    }

    private static int getTreeRowHeight() {
        return new JLabel((String)"XXX").getPreferredSize().height + 4;
    }

    private static Action getDefaultAction(Set<DataSource> dataSources) {
        return ExplorerContextMenuFactory.instance().getDefaultActionFor(dataSources);
    }

    private void performDefaultAction() {
        Set<DataSource> selectedDataSources = ExplorerSupport.sharedInstance().getSelectedDataSources();
        Action defaultAction = ExplorerComponent.getDefaultAction(selectedDataSources);
        if (defaultAction != null) {
            defaultAction.actionPerformed(new ActionEvent(selectedDataSources, 0, "Default Action"));
        }
    }

    private void displayContextMenu(int x, int y) {
        JPopupMenu popupMenu = ExplorerContextMenuFactory.instance().createPopupMenu();
        if (popupMenu != null) {
            popupMenu.show(this.explorerTree, x, y);
        }
    }

    private class ExplorerTreeMouseAdapter
    extends MouseAdapter {
        private ExplorerTreeMouseAdapter() {
        }

        private void updatePathSelection(TreePath path, MouseEvent e) {
            if (path != null) {
                if (!ExplorerComponent.this.explorerTree.isPathSelected(path)) {
                    ExplorerComponent.this.explorerTree.setSelectionPath(path);
                }
            } else {
                ExplorerComponent.this.explorerTree.clearSelection();
            }
        }

        public void mousePressed(MouseEvent e) {
            TreePath path = ExplorerComponent.this.explorerTree.getPathForLocation(e.getX(), e.getY());
            this.updatePathSelection(path, e);
            if (e.isPopupTrigger()) {
                ExplorerComponent.this.displayContextMenu(e.getX(), e.getY());
            }
        }

        public void mouseReleased(MouseEvent e) {
            TreePath path = ExplorerComponent.this.explorerTree.getPathForLocation(e.getX(), e.getY());
            this.updatePathSelection(path, e);
            if (e.isPopupTrigger()) {
                ExplorerComponent.this.displayContextMenu(e.getX(), e.getY());
            }
        }

        public void mouseClicked(MouseEvent e) {
            if (SwingUtilities.isLeftMouseButton(e) && e.getClickCount() == ExplorerComponent.this.explorerTree.getToggleClickCount()) {
                ExplorerComponent.this.performDefaultAction();
            }
        }
    }

    private class ExplorerTreeKeyAdapter
    extends KeyAdapter {
        private ExplorerTreeKeyAdapter() {
        }

        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 525 || e.getKeyCode() == 121 && e.getModifiers() == 1) {
                int y;
                int x;
                e.consume();
                TreePath path = ExplorerComponent.this.explorerTree.getSelectionPath();
                if (path != null) {
                    Rectangle pathRect = ExplorerComponent.this.explorerTree.getPathBounds(path);
                    x = pathRect.x;
                    y = pathRect.y;
                } else {
                    Point pathPoint = new Point(ExplorerComponent.this.explorerTree.getWidth() / 3, ExplorerComponent.this.explorerTree.getHeight() / 3);
                    x = pathPoint.x;
                    y = pathPoint.y;
                }
                ExplorerComponent.this.displayContextMenu(x, y);
            }
        }
    }
}

