/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.controlpanel.ui.configuration.model.gui;

import com.jrockit.mc.flightrecorder.controlpanel.ui.configuration.model.gui.Value;
import com.jrockit.mc.flightrecorder.controlpanel.ui.configuration.model.gui.WidgetNode;
import com.jrockit.mc.flightrecorder.controlpanel.ui.configuration.model.xml.JFCGrammar;
import com.jrockit.mc.flightrecorder.controlpanel.ui.configuration.model.xml.XMLModel;
import com.jrockit.mc.flightrecorder.controlpanel.ui.configuration.model.xml.XMLTagInstance;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.forms.widgets.FormToolkit;

final class SelectionNode
extends WidgetNode {
    private final List<XMLTagInstance> m_optionElements = new ArrayList<XMLTagInstance>();
    private ComboViewer m_viewer;

    public SelectionNode(XMLModel model, XMLTagInstance selectionElement) {
        super(model, selectionElement);
    }

    private String getDefaultIdentifier() {
        return this.getInputElement().getValue(JFCGrammar.ATTRIBUTE_DEFAULT);
    }

    public void addItem(XMLTagInstance optionElement) {
        this.m_optionElements.add(optionElement);
    }

    @Override
    public void create(FormToolkit toolkit, Composite parent, int horisontalSpan) {
        Label label = toolkit.createLabel(parent, this.getLabel());
        this.adaptLabel(label);
        this.m_viewer = this.createViewer(parent, horisontalSpan);
        this.setViewerSelection();
    }

    @Override
    public void create(Composite parent, int horisontalSpan) {
        Label label = new Label(parent, 0);
        label.setText(this.getLabel());
        this.adaptLabel(label);
        this.m_viewer = this.createViewer(parent, horisontalSpan);
        this.setViewerSelection();
    }

    private void setViewerSelection() {
        XMLTagInstance selected = this.getSelected();
        if (selected != null) {
            this.m_viewer.setSelection((ISelection)new StructuredSelection((Object)selected));
        }
    }

    private void adaptLabel(Label label) {
        GridData gd1 = new GridData(4, 0x1000000, false, false);
        label.setLayoutData((Object)gd1);
        label.setToolTipText(this.getDescription());
    }

    private ComboViewer createViewer(Composite parent, int horisontalSpan) {
        ComboViewer viewer = new ComboViewer(parent);
        viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        viewer.getControl().setToolTipText(this.getDescription());
        viewer.setLabelProvider((IBaseLabelProvider)new ComboLabelProvider());
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection ss = (IStructuredSelection)event.getSelection();
                SelectionNode.this.select((XMLTagInstance)ss.getFirstElement());
            }
        });
        viewer.setInput(this.m_optionElements);
        GridData gd2 = new GridData(4, 4, true, false);
        gd2.horizontalSpan = horisontalSpan - 1;
        viewer.getControl().setLayoutData((Object)gd2);
        return viewer;
    }

    private XMLTagInstance getSelected() {
        for (XMLTagInstance optionElement : this.m_optionElements) {
            if (!this.getDefaultIdentifier().equalsIgnoreCase(optionElement.getValue(JFCGrammar.ATTRIBUTE_NAME))) continue;
            return optionElement;
        }
        return this.m_optionElements.size() > 0 ? this.m_optionElements.get(0) : null;
    }

    @Override
    Value getValue() {
        String valueId = this.getInputElement().getValue(JFCGrammar.ATTRIBUTE_DEFAULT);
        String value = null;
        for (XMLTagInstance optionElement : this.getInputElement().getTagsInstances()) {
            if (value == null) {
                value = optionElement.getContent();
            }
            if (!valueId.equalsIgnoreCase(optionElement.getValue(JFCGrammar.ATTRIBUTE_NAME))) continue;
            value = optionElement.getContent();
        }
        if (value == null) {
            value = "";
        }
        return Value.valueOf(value);
    }

    private void select(XMLTagInstance optionElement) {
        if (optionElement != null) {
            this.m_viewer.getControl().setToolTipText(optionElement.getValue(JFCGrammar.ATTRIBUTE_DESCRIPTION));
            String currentIdentifier = this.getDefaultIdentifier();
            String newIdentifier = optionElement.getValue(JFCGrammar.ATTRIBUTE_NAME);
            if (!currentIdentifier.equalsIgnoreCase(newIdentifier)) {
                this.getInputElement().setValue(JFCGrammar.ATTRIBUTE_DEFAULT, newIdentifier);
                this.fireChange();
                this.markDirty();
            }
        }
    }

    static /* synthetic */ void access$0(SelectionNode selectionNode, XMLTagInstance xMLTagInstance) {
        selectionNode.select(xMLTagInstance);
    }

    private static class ComboLabelProvider
    extends LabelProvider {
        private ComboLabelProvider() {
        }

        public String getText(Object element) {
            XMLTagInstance optionElement = (XMLTagInstance)element;
            return optionElement.getValue(JFCGrammar.ATTRIBUTE_LABEL_MANDATORY);
        }
    }
}

