/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.controlpanel.ui.configuration.model.gui;

import com.jrockit.mc.flightrecorder.controlpanel.ui.configuration.model.gui.Value;
import com.jrockit.mc.flightrecorder.controlpanel.ui.configuration.model.gui.WidgetNode;
import com.jrockit.mc.flightrecorder.controlpanel.ui.configuration.model.xml.XMLModel;
import com.jrockit.mc.flightrecorder.controlpanel.ui.configuration.model.xml.XMLTagInstance;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.forms.widgets.FormToolkit;

final class FlagNode
extends WidgetNode {
    public FlagNode(XMLModel model, XMLTagInstance flagElement) {
        super(model, flagElement);
    }

    @Override
    public void create(Composite parent, int horisontalSPan) {
        Label label = new Label(parent, 0);
        label.setText(this.getLabel());
        this.adaptLabel(label);
        Button button = new Button(parent, 32);
        this.adaptButton(horisontalSPan, button);
    }

    @Override
    public void create(FormToolkit toolkit, Composite parent, int horisontalSpan) {
        Label label = toolkit.createLabel(parent, this.getLabel());
        this.adaptLabel(label);
        Button button = toolkit.createButton(parent, null, 32);
        this.adaptButton(horisontalSpan, button);
    }

    private void adaptLabel(Label label) {
        GridData gd1 = new GridData(4, 0x1000000, false, false);
        label.setLayoutData((Object)gd1);
        label.setToolTipText(this.getDescription());
    }

    private void adaptButton(int horisontalSpan, Button button) {
        GridData gd = new GridData(4, 0x1000000, false, false);
        gd.horizontalSpan = horisontalSpan - 1;
        button.setLayoutData((Object)gd);
        button.setToolTipText(this.getDescription());
        button.setSelection(this.getEnabled());
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FlagNode.this.setValue(Value.valueOf(button.getSelection()).toString());
            }
        });
    }

    private boolean getEnabled() {
        return "true".equalsIgnoreCase(this.getValue().toString());
    }
}

