/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.output2.options;

import java.awt.Color;
import java.awt.EventQueue;
import java.awt.Font;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.UIManager;
import org.netbeans.core.output2.Controller;
import org.netbeans.swing.plaf.LFCustoms;
import org.openide.util.NbPreferences;
import org.openide.util.Parameters;
import org.openide.util.RequestProcessor;
import org.openide.windows.IOColors;

public class OutputOptions {
    private static OutputOptions DEFAULT = null;
    private boolean initialized = false;
    private static final Logger LOG = Logger.getLogger(OutputOptions.class.getName());
    private static AtomicBoolean saveScheduled = new AtomicBoolean(false);
    private static final String PREFIX = "output.settings.";
    public static final String PROP_FONT = "font";
    private static final String PROP_FONT_FAMILY = "font.family";
    private static final String PROP_FONT_SIZE = "font.size";
    private static final String PROP_FONT_STYLE = "font.style";
    public static final String PROP_COLOR_STANDARD = "color.standard";
    public static final String PROP_COLOR_ERROR = "color.error";
    public static final String PROP_COLOR_LINK = "color.link";
    public static final String PROP_COLOR_LINK_IMPORTANT = "color.link.important";
    public static final String PROP_COLOR_BACKGROUND = "color.backgorund";
    public static final String PROP_STYLE_LINK = "style.link";
    public static final String PROP_FONT_SIZE_WRAP = "font.size.wrap";
    private static final String PROP_INITIALIZED = "initialized";
    private static final int MIN_FONT_SIZE = 3;
    private static final int MAX_FONT_SIZE = 72;
    private static Font defaultFont = null;
    private Font font = null;
    private Font fontWrapped = null;
    private Color colorStandard;
    private Color colorError;
    private Color colorLink;
    private Color colorLinkImportant;
    private Color colorBackground;
    private LinkStyle linkStyle = LinkStyle.UNDERLINE;
    private PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private boolean defaultFontType = false;

    private OutputOptions(boolean bl) {
        this.resetToDefault();
        if (!bl) {
            return;
        }
        RequestProcessor.getDefault().post(new Runnable(){

            @Override
            public void run() {
                OutputOptions.this.loadFrom(NbPreferences.forModule(Controller.class));
            }
        });
    }

    final void resetToDefault() {
        this.setDefaultFont();
        this.setDefaultColors();
        this.setLinkStyle(LinkStyle.UNDERLINE);
    }

    public void loadFrom(Preferences preferences) {
        assert (!EventQueue.isDispatchThread());
        final OutputOptions outputOptions = new OutputOptions(false);
        String string = preferences.get("output.settings.font.family", OutputOptions.getDefaultFont().getFamily());
        int n = preferences.getInt("output.settings.font.size", OutputOptions.getDefaultFont().getSize());
        int n2 = preferences.getInt("output.settings.font.style", OutputOptions.getDefaultFont().getStyle());
        outputOptions.setFont(new Font(string, n2, n));
        int n3 = preferences.getInt("output.settings.font.size.wrap", OutputOptions.getDefaultFont().getSize());
        outputOptions.setFontForWrappedMode(OutputOptions.getDefaultFont().deriveFont((float)n3));
        int n4 = preferences.getInt("output.settings.color.standard", OutputOptions.getDefaultColorStandard().getRGB());
        outputOptions.setColorStandard(new Color(n4));
        int n5 = preferences.getInt("output.settings.color.error", OutputOptions.getDefaultColorError().getRGB());
        outputOptions.setColorError(new Color(n5));
        int n6 = preferences.getInt("output.settings.color.backgorund", OutputOptions.getDefaultColorBackground().getRGB());
        outputOptions.setColorBackground(new Color(n6));
        int n7 = preferences.getInt("output.settings.color.link", OutputOptions.getDefaultColorLink().getRGB());
        outputOptions.setColorLink(new Color(n7));
        int n8 = preferences.getInt("output.settings.color.link.important", OutputOptions.getDefaultColorLinkImportant().getRGB());
        String string2 = preferences.get("output.settings.style.link", "UNDERLINE");
        try {
            outputOptions.setLinkStyle(LinkStyle.valueOf(string2));
        }
        catch (Exception exception) {
            LOG.log(Level.INFO, "Invalid link style {0}", string2);
        }
        outputOptions.setColorLinkImportant(new Color(n8));
        EventQueue.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                OutputOptions.this.assign(outputOptions);
                OutputOptions outputOptions2 = OutputOptions.this;
                synchronized (outputOptions2) {
                    OutputOptions.this.initialized = true;
                }
                OutputOptions.this.pcs.firePropertyChange(OutputOptions.PROP_INITIALIZED, false, true);
            }
        });
    }

    public void saveTo(Preferences preferences) {
        assert (!EventQueue.isDispatchThread());
        preferences.putInt("output.settings.color.standard", this.getColorStandard().getRGB());
        preferences.putInt("output.settings.color.error", this.getColorError().getRGB());
        preferences.putInt("output.settings.color.backgorund", this.getColorBackground().getRGB());
        preferences.putInt("output.settings.color.link", this.getColorLink().getRGB());
        preferences.putInt("output.settings.color.link.important", this.getColorLinkImportant().getRGB());
        preferences.putInt("output.settings.font.size", this.getFont().getSize());
        preferences.putInt("output.settings.font.style", this.getFont().getStyle());
        preferences.putInt("output.settings.font.size.wrap", this.getFontForWrappedMode().getSize());
        preferences.put("output.settings.font.family", this.getFont().getFamily());
        preferences.put("output.settings.style.link", this.getLinkStyle().name());
        try {
            preferences.flush();
        }
        catch (BackingStoreException backingStoreException) {
            LOG.log(Level.INFO, null, backingStoreException);
        }
    }

    private void setDefaultColors() {
        this.setColorStandard(OutputOptions.getDefaultColorStandard());
        this.setColorError(OutputOptions.getDefaultColorError());
        this.setColorLink(OutputOptions.getDefaultColorLink());
        this.setColorLinkImportant(OutputOptions.getDefaultColorLinkImportant());
        this.setColorBackground(OutputOptions.getDefaultColorBackground());
    }

    private void setDefaultFont() {
        this.setFont(OutputOptions.getDefaultFont());
        this.setFontForWrappedMode(OutputOptions.getDefaultFont());
    }

    public static Font getDefaultFont() {
        if (defaultFont == null) {
            Font font;
            int n = UIManager.getInt("uiFontSize");
            if (n < 3) {
                n = UIManager.getInt("customFontSize");
            }
            if (n < 3 && (font = (Font)UIManager.get("controlFont")) != null) {
                n = font.getSize();
            }
            if (n < 3) {
                n = 11;
            }
            defaultFont = new Font("Monospaced", 0, n);
        }
        return defaultFont;
    }

    public Font getFont() {
        return this.font;
    }

    public Font getFontForWrappedMode() {
        return this.fontWrapped;
    }

    public Font getFont(boolean bl) {
        return bl ? this.getFontForWrappedMode() : this.getFont();
    }

    public Color getColorStandard() {
        return this.colorStandard;
    }

    public Color getColorError() {
        return this.colorError;
    }

    public Color getColorLink() {
        return this.colorLink;
    }

    public Color getColorLinkImportant() {
        return this.colorLinkImportant;
    }

    public Color getColorBackground() {
        return this.colorBackground;
    }

    public LinkStyle getLinkStyle() {
        return this.linkStyle;
    }

    public void setFont(Font font) {
        Font font2 = this.checkFontToSet(font);
        if (!font2.equals(this.font)) {
            Font font3 = this.font;
            this.font = font2;
            this.defaultFontType = this.checkDefaultFontType();
            this.pcs.firePropertyChange(PROP_FONT, font3, font2);
        }
    }

    private void setFontForWrappedMode(Font font) {
        Font font2 = this.checkFontToSet(font);
        if (!font2.equals(this.fontWrapped)) {
            int n = this.fontWrapped != null ? this.fontWrapped.getSize() : 0;
            this.fontWrapped = font2;
            this.pcs.firePropertyChange(PROP_FONT_SIZE_WRAP, n, font2.getSize());
        }
    }

    private Font checkFontToSet(Font font) {
        Font font2;
        Font font3 = font2 = font == null ? OutputOptions.getDefaultFont() : font;
        if (font2.getSize() < 3) {
            font2 = font2.deriveFont(3.0f);
        } else if (font2.getSize() > 72) {
            font2 = font2.deriveFont(72.0f);
        }
        return font2;
    }

    public void setFontSize(boolean bl, int n) {
        if (this.getFont() != null && (!bl || this.isDefaultFontType()) && n != this.getFont().getSize()) {
            this.setFont(this.getFont().deriveFont((float)n));
        }
        if (this.getFontForWrappedMode() != null && (bl || this.isDefaultFontType())) {
            this.setFontForWrappedMode(this.getFontForWrappedMode().deriveFont((float)n));
        }
    }

    public boolean isDefaultFontType() {
        return this.defaultFontType;
    }

    private boolean checkDefaultFontType() {
        Font font = OutputOptions.getDefaultFont();
        return font.getName().equals(this.font.getName()) && font.getStyle() == this.font.getStyle();
    }

    public void setColorStandard(Color color) {
        Parameters.notNull((CharSequence)"colorStandard", (Object)color);
        if (!color.equals(this.colorStandard)) {
            Color color2 = this.colorStandard;
            this.colorStandard = color;
            this.pcs.firePropertyChange(PROP_COLOR_STANDARD, color2, color);
        }
    }

    public void setColorError(Color color) {
        Parameters.notNull((CharSequence)"colorError", (Object)color);
        if (!color.equals(this.colorError)) {
            Color color2 = this.colorError;
            this.colorError = color;
            this.pcs.firePropertyChange(PROP_COLOR_ERROR, color2, color);
        }
    }

    public void setColorLink(Color color) {
        Parameters.notNull((CharSequence)"colorLink", (Object)color);
        if (!color.equals(this.colorLink)) {
            Color color2 = this.colorLink;
            this.colorLink = color;
            this.pcs.firePropertyChange(PROP_COLOR_LINK, color2, color);
        }
    }

    public void setColorLinkImportant(Color color) {
        Parameters.notNull((CharSequence)"colorLinkImportant", (Object)color);
        if (!color.equals(this.colorLinkImportant)) {
            Color color2 = this.colorLinkImportant;
            this.colorLinkImportant = color;
            this.pcs.firePropertyChange(PROP_COLOR_LINK_IMPORTANT, color2, color);
        }
    }

    public void setColorBackground(Color color) {
        Parameters.notNull((CharSequence)"colorBackground", (Object)color);
        if (!color.equals(this.colorBackground)) {
            Color color2 = this.colorBackground;
            this.colorBackground = color;
            this.pcs.firePropertyChange(PROP_COLOR_BACKGROUND, color2, color);
        }
    }

    public void setLinkStyle(LinkStyle linkStyle) {
        Parameters.notNull((CharSequence)"linkStyle", (Object)((Object)linkStyle));
        if (!linkStyle.equals((Object)this.linkStyle)) {
            LinkStyle linkStyle2 = this.linkStyle;
            this.linkStyle = linkStyle;
            this.pcs.firePropertyChange(PROP_STYLE_LINK, (Object)linkStyle2, (Object)linkStyle);
        }
    }

    public static synchronized OutputOptions getDefault() {
        if (DEFAULT == null) {
            DEFAULT = new OutputOptions(true);
        }
        return DEFAULT;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.removePropertyChangeListener(propertyChangeListener);
    }

    public OutputOptions makeCopy() {
        final OutputOptions outputOptions = new OutputOptions(false);
        outputOptions.font = this.font;
        outputOptions.fontWrapped = this.fontWrapped;
        outputOptions.colorStandard = this.colorStandard;
        outputOptions.colorError = this.colorError;
        outputOptions.colorBackground = this.colorBackground;
        outputOptions.colorLink = this.colorLink;
        outputOptions.colorLinkImportant = this.colorLinkImportant;
        outputOptions.initialized = this.initialized;
        outputOptions.linkStyle = this.linkStyle;
        if (!this.initialized) {
            PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if (propertyChangeEvent.getPropertyName().equals(OutputOptions.PROP_INITIALIZED)) {
                        outputOptions.assign(OutputOptions.this);
                        outputOptions.initialized = true;
                        outputOptions.pcs.firePropertyChange(OutputOptions.PROP_INITIALIZED, false, true);
                        OutputOptions.this.removePropertyChangeListener(this);
                    }
                }
            };
            this.addPropertyChangeListener(propertyChangeListener);
        }
        return outputOptions;
    }

    public void assign(OutputOptions outputOptions) {
        this.setFont(outputOptions.getFont());
        this.setFontForWrappedMode(outputOptions.getFontForWrappedMode());
        this.setColorStandard(outputOptions.getColorStandard());
        this.setColorError(outputOptions.getColorError());
        this.setColorLink(outputOptions.getColorLink());
        this.setColorLinkImportant(outputOptions.getColorLinkImportant());
        this.setColorBackground(outputOptions.getColorBackground());
        this.setLinkStyle(outputOptions.getLinkStyle());
    }

    static Color getDefaultColorStandard() {
        Color color = UIManager.getColor("nb.output.foreground");
        if (color == null && (color = UIManager.getColor("textText")) == null) {
            color = Color.BLACK;
        }
        return color;
    }

    static Color getDefaultColorBackground() {
        Color color = UIManager.getColor("nb.output.backgorund");
        if (color == null) {
            color = UIManager.getColor("TextField.background");
            if (color == null) {
                color = Color.WHITE;
            } else if ("Nimbus".equals(UIManager.getLookAndFeel().getName())) {
                color = new Color(color.getRGB());
            }
        }
        return color;
    }

    static Color getDefaultColorError() {
        Color color = UIManager.getColor("nb.output.err.foreground");
        if (color == null) {
            color = LFCustoms.shiftColor((Color)Color.red);
        }
        return color;
    }

    static Color getDefaultColorLink() {
        Color color = UIManager.getColor("nb.output.link.foreground");
        if (color == null) {
            color = LFCustoms.shiftColor((Color)Color.blue);
        }
        return color;
    }

    static Color getDefaultColorLinkImportant() {
        Color color = UIManager.getColor("nb.output.link.foreground.important");
        if (color == null) {
            return OutputOptions.getDefaultColorLink();
        }
        return color;
    }

    public Color getColorForType(IOColors.OutputType outputType) {
        switch (outputType) {
            case OUTPUT: {
                return this.getColorStandard();
            }
            case ERROR: {
                return this.getColorError();
            }
            case HYPERLINK: {
                return this.getColorLink();
            }
            case HYPERLINK_IMPORTANT: {
                return this.getColorLinkImportant();
            }
        }
        return this.getColorStandard();
    }

    public static void storeDefault() {
        if (saveScheduled.compareAndSet(false, true)) {
            RequestProcessor.getDefault().post(new Runnable(){

                @Override
                public void run() {
                    OutputOptions.getDefault().saveTo(NbPreferences.forModule(Controller.class));
                    saveScheduled.set(false);
                }
            }, 100);
        }
    }

    public static enum LinkStyle {
        NONE,
        UNDERLINE;

    }
}

