/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.controlpanel.ui.wizards;

import com.jrockit.mc.flightrecorder.configuration.IRecordingConfiguration;
import com.jrockit.mc.flightrecorder.controlpanel.ui.configuration.model.xml.XMLModel;
import com.jrockit.mc.flightrecorder.controlpanel.ui.messages.internal.Messages;
import com.jrockit.mc.flightrecorder.controlpanel.ui.model.PrivateStorageDelegate;
import com.jrockit.mc.flightrecorder.controlpanel.ui.model.RecordingTemplate;
import com.jrockit.mc.flightrecorder.controlpanel.ui.model.RecordingTemplateModel;
import com.jrockit.mc.flightrecorder.controlpanel.ui.model.RecordingTemplateRepository;
import com.jrockit.mc.flightrecorder.controlpanel.ui.wizards.TemplateEditPage;
import com.jrockit.mc.flightrecorder.controlpanel.ui.wizards.TemplateLabelProvider;
import com.jrockit.mc.flightrecorder.controlpanel.ui.wizards.TemplateProvider;
import com.jrockit.mc.flightrecorder.ui.FlightRecorderUI;
import com.jrockit.mc.rjmx.services.flr.EventTypeID;
import com.jrockit.mc.rjmx.services.flr.IEventSettingsHolder;
import com.jrockit.mc.rjmx.services.flr.IEventTypeInfo;
import com.jrockit.mc.ui.misc.DialogToolkit;
import com.jrockit.mc.ui.wizards.OnePageWizardDialog;
import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class TemplateManagerWizardPage
extends WizardPage {
    private static final String JFC_FILE_EXTENSION = "*.jfc";
    private static final String ALL_FILE_EXTENSION = "*";
    private static final String[] FILE_EXTENSIONS = new String[]{"*.jfc", "*"};
    private static final String[] FILE_DESCRIPTIONS = new String[]{NLS.bind((String)Messages.FILE_RECORDING_DESCRIPTION, (Object)"*.jfc"), Messages.FILE_ALL_DESCRIPTION};
    private static final int MAX_REMOVE_TEMPLATES_TO_DISPLAY = 5;
    private final RecordingTemplateRepository repository;
    private final IEventSettingsHolder initialEventTypeSettings;
    private final Map<EventTypeID, IEventTypeInfo> eventTypeInfos;
    private Observer repositoryObserver;
    private TableViewer tableViewer;
    private Button editButton;
    private Button exportButton;
    private Button deleteButton;
    private Button newButton;
    private Button duplicateButton;

    public static Dialog createDialogFor(Shell shell, RecordingTemplateRepository repository, IEventSettingsHolder currentEventTypeSettings, Map<EventTypeID, IEventTypeInfo> eventTypeInfos) {
        OnePageWizardDialog dialog = new OnePageWizardDialog(shell, (IWizardPage)new TemplateManagerWizardPage(repository, currentEventTypeSettings, eventTypeInfos));
        dialog.setHideCancelButton(true);
        dialog.setWidthConstraint(600, 800);
        dialog.setHeightConstraint(600, 800);
        return dialog;
    }

    public TemplateManagerWizardPage(RecordingTemplateRepository repository, IEventSettingsHolder currentEventTypeSettings, Map<EventTypeID, IEventTypeInfo> eventTypeInfos) {
        super("templateManager", currentEventTypeSettings == null ? Messages.TEMPLATE_MANAGER_DIALOG_OFFLINE_TITLE : Messages.TEMPLATE_MANAGER_DIALOG_TITLE, null);
        this.repository = repository;
        this.initialEventTypeSettings = currentEventTypeSettings;
        this.eventTypeInfos = eventTypeInfos != null ? eventTypeInfos : Collections.emptyMap();
        if (this.initialEventTypeSettings == null) {
            this.setDescription(Messages.TEMPLATE_MANAGER_OFFLINE_DESCRIPTION);
        } else {
            this.setDescription(Messages.TEMPLATE_MANAGER_DESCRIPTION);
        }
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        container.setLayout((Layout)layout);
        this.tableViewer = new TableViewer(container, 2562);
        this.tableViewer.setContentProvider((IContentProvider)new TemplateProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new DelegatingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)new TemplateLabelProvider()));
        this.tableViewer.setInput((Object)this.repository);
        this.tableViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        this.tableViewer.getTable().setData("name", (Object)"templateTable");
        Composite buttons = new Composite(container, 0);
        buttons.setLayoutData((Object)new GridData(4, 1, false, true));
        layout = new GridLayout(1, true);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        buttons.setLayout((Layout)layout);
        this.createButtons(buttons);
        this.setControl((Control)container);
        this.setUpListeners();
    }

    protected void setUpListeners() {
        this.updateButtonsAccordingTo(this.tableViewer.getSelection());
        this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                TemplateManagerWizardPage.this.updateButtonsAccordingTo(event.getSelection());
            }
        });
        this.updateButtonsForRepository();
        this.repositoryObserver = new Observer(){

            @Override
            public void update(Observable o, Object arg) {
                if (TemplateManagerWizardPage.this.tableViewer != null) {
                    TemplateManagerWizardPage.this.tableViewer.refresh();
                }
                TemplateManagerWizardPage.this.updateButtonsForRepository();
            }
        };
        this.repository.addObserver(this.repositoryObserver);
    }

    private void updateButtonsAccordingTo(ISelection selection) {
        boolean someSelected;
        boolean oneSelected = false;
        boolean allDeletable = someSelected = !selection.isEmpty();
        boolean oneEditable = false;
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection sel = (IStructuredSelection)selection;
            oneSelected = sel.size() == 1;
            oneEditable = oneSelected && ((IRecordingConfiguration)sel.getFirstElement()).isSaveable();
            Iterator templates = sel.iterator();
            while (allDeletable && templates.hasNext()) {
                allDeletable &= ((IRecordingConfiguration)templates.next()).isDeletable();
            }
        }
        this.editButton.setEnabled(oneEditable);
        this.exportButton.setEnabled(oneSelected);
        this.deleteButton.setEnabled(allDeletable);
        this.duplicateButton.setEnabled(someSelected);
    }

    private void updateButtonsForRepository() {
        if (this.newButton != null) {
            this.newButton.setVisible(this.repository.canCreateTemplates());
        }
    }

    protected void createButtons(Composite buttons) {
        this.editButton = this.createButton(buttons, Messages.BUTTON_EDIT_TEXT);
        this.editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TemplateManagerWizardPage.this.editSelected();
            }
        });
        this.createButton(buttons, Messages.BUTTON_IMPORT_FILE_TEXT).addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TemplateManagerWizardPage.this.importUsingFileDialog();
            }
        });
        this.exportButton = this.createButton(buttons, Messages.BUTTON_EXPORT_FILE_TEXT);
        this.exportButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TemplateManagerWizardPage.this.exportUsingFileDialog();
            }
        });
        this.deleteButton = this.createButton(buttons, Messages.BUTTON_REMOVE_TEXT);
        this.deleteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TemplateManagerWizardPage.this.deleteSelected();
            }
        });
        this.newButton = this.createButton(buttons, Messages.BUTTON_NEW_TEXT);
        this.newButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TemplateManagerWizardPage.this.createNewTemplate();
            }
        });
        this.duplicateButton = this.createButton(buttons, Messages.BUTTON_DUPLICATE_TEXT);
        this.duplicateButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TemplateManagerWizardPage.this.duplicateSelected();
            }
        });
    }

    private Button createButton(Composite container, String text) {
        Button button = new Button(container, 0);
        button.setText(text);
        button.setLayoutData((Object)new GridData(4, 4, true, false));
        return button;
    }

    private void editSelected() {
        IRecordingConfiguration template = this.getSingleSelectedTemplate();
        if (template != null) {
            IRecordingConfiguration workingCopy = template.createWorkingCopy();
            RecordingTemplateModel model = new RecordingTemplateModel(workingCopy, this.initialEventTypeSettings, this.eventTypeInfos);
            Dialog dialog = TemplateEditPage.createDialogFor(this.getShell(), model, this.repository);
            if (dialog.open() == 0) {
                this.repository.notifyObservers();
            }
        }
    }

    private void importUsingFileDialog() {
        FileDialog fileDialog = new FileDialog(this.getShell(), 4098);
        fileDialog.setFilterExtensions(FILE_EXTENSIONS);
        fileDialog.setFilterNames(FILE_DESCRIPTIONS);
        if (fileDialog.open() == null) {
            return;
        }
        ArrayList<File> files = new ArrayList<File>(fileDialog.getFileNames().length);
        File directory = new File(fileDialog.getFilterPath());
        String[] stringArray = fileDialog.getFileNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String fileName = stringArray[n2];
            files.add(new File(directory, fileName));
            ++n2;
        }
        List<IRecordingConfiguration> imported = TemplateManagerWizardPage.importFilesTo(this.repository, files);
        if (!imported.isEmpty()) {
            this.repository.notifyObservers();
            this.tableViewer.setSelection((ISelection)new StructuredSelection(imported), true);
        }
    }

    public static List<IRecordingConfiguration> importFilesTo(RecordingTemplateRepository repository, Collection<File> files) {
        ArrayList<IRecordingConfiguration> imported = new ArrayList<IRecordingConfiguration>(files.size());
        StringBuilder errBuf = new StringBuilder();
        for (File file : files) {
            try {
                XMLModel model = RecordingTemplate.createModel(file);
                RecordingTemplate template = new RecordingTemplate(model, PrivateStorageDelegate.getDelegate());
                if (repository.addAsUnique(template)) {
                    imported.add(template);
                    continue;
                }
                errBuf.append(file.getName());
                errBuf.append(" (local storage)\n");
            }
            catch (IOException ioe) {
                errBuf.append(file.getName());
                errBuf.append(" (" + ioe.getMessage() + ")\n");
            }
            catch (ParseException pe) {
                errBuf.append(file.getName());
                errBuf.append(" (" + pe.getMessage() + ")\n");
            }
            catch (IllegalArgumentException iae) {
                errBuf.append(file.getName());
                errBuf.append(" (" + iae.getMessage() + ")\n");
            }
        }
        if (errBuf.length() != 0) {
            DialogToolkit.showErrorDialogAsync((Display)Display.getDefault(), (String)Messages.IMPORT_FILE_TEMPLATE_WIZARD_PAGE_ERROR_DIALOG_TITLE, (String)(String.valueOf(Messages.IMPORT_FILE_TEMPLATE_WIZARD_PAGE_ERROR_DIALOG_MSG) + errBuf.toString()));
        }
        return imported;
    }

    private void exportUsingFileDialog() {
        IRecordingConfiguration template = this.getSingleSelectedTemplate();
        if (template == null) {
            return;
        }
        FileDialog fileDialog = new FileDialog(this.getShell(), 8192);
        fileDialog.setFilterExtensions(FILE_EXTENSIONS);
        fileDialog.setFilterNames(FILE_DESCRIPTIONS);
        fileDialog.setOverwrite(true);
        fileDialog.setFileName(template.getName());
        String fileName = fileDialog.open();
        if (fileName == null) {
            return;
        }
        try {
            template.exportToFile(new File(fileName));
        }
        catch (IOException ioe) {
            DialogToolkit.showExceptionDialogAsync((Display)this.getControl().getDisplay(), (String)Messages.IMPORT_EXPORT_TOOLKIT_COULD_NOT_EXPORT_DIALOG_TITLE, (Throwable)ioe);
        }
    }

    private IRecordingConfiguration getSingleSelectedTemplate() {
        ISelection selection = this.tableViewer.getSelection();
        if (selection instanceof IStructuredSelection) {
            return (IRecordingConfiguration)((IStructuredSelection)selection).getFirstElement();
        }
        return null;
    }

    private Iterable<IRecordingConfiguration> getSelectedTemplates() {
        ISelection selection = this.tableViewer.getSelection();
        if (selection instanceof IStructuredSelection) {
            List list = ((IStructuredSelection)selection).toList();
            return list;
        }
        return Collections.emptyList();
    }

    private void deleteSelected() {
        int selectedCount = 0;
        StringBuilder namesBuilder = new StringBuilder();
        for (IRecordingConfiguration template : this.getSelectedTemplates()) {
            if (selectedCount < 5) {
                namesBuilder.append("\n");
                namesBuilder.append(template.getName());
            } else if (selectedCount == 5) {
                namesBuilder.append("\n...");
            }
            ++selectedCount;
        }
        if (selectedCount <= 0) {
            return;
        }
        boolean askConfirm = FlightRecorderUI.getDefault().getConfirmRemoveTemplate();
        boolean doDelete = false;
        if (askConfirm) {
            MessageDialogWithToggle confirmDialog;
            String messageText = NLS.bind((String)Messages.CONFIRM_REMOVE_TEMPLATE_DIALOG_MESSAGE_SINGULAR, (Object)namesBuilder.toString());
            if (selectedCount > 1) {
                messageText = NLS.bind((String)Messages.CONFIRM_REMOVE_TEMPLATE_DIALOG_MESSAGE_PLURAL, (Object)selectedCount, (Object)namesBuilder.toString());
            }
            if ((confirmDialog = MessageDialogWithToggle.openOkCancelConfirm((Shell)this.getShell(), (String)Messages.CONFIRM_REMOVE_TEMPLATE_DIALOG_TITLE, (String)messageText, (String)Messages.CONFIRM_REMOVE_TEMPLATE_DIALOG_CHECKBOX_ASK_CONFIRMATION, (boolean)true, null, null)).getReturnCode() == 0) {
                doDelete = true;
                if (!confirmDialog.getToggleState()) {
                    FlightRecorderUI.getDefault().setConfirmRemoveTemplate(false);
                }
            }
        } else {
            doDelete = true;
        }
        if (doDelete) {
            for (IRecordingConfiguration template : this.getSelectedTemplates()) {
                if (!template.delete()) continue;
                this.repository.remove(template);
            }
            this.repository.notifyObservers();
        }
    }

    private void duplicateSelected() {
        ArrayList<IRecordingConfiguration> added = new ArrayList<IRecordingConfiguration>();
        for (IRecordingConfiguration template : this.getSelectedTemplates()) {
            try {
                IRecordingConfiguration newTemplate = template.createCloneWithStorage(PrivateStorageDelegate.getDelegate());
                if (newTemplate == null || !this.repository.addAsUnique(newTemplate)) continue;
                added.add(newTemplate);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (!added.isEmpty()) {
            this.repository.notifyObservers();
            this.tableViewer.setSelection((ISelection)new StructuredSelection(added), true);
        }
    }

    private void createNewTemplate() {
        try {
            IRecordingConfiguration newTemplate = this.repository.createTemplate();
            if (newTemplate != null && this.repository.addAsUnique(newTemplate)) {
                this.repository.notifyObservers();
                this.tableViewer.setSelection((ISelection)new StructuredSelection((Object)newTemplate), true);
            }
        }
        catch (IOException ioe) {
            DialogToolkit.showExceptionDialogAsync((Display)this.getControl().getDisplay(), (String)Messages.TEMPLATE_MANAGER_COULD_NOT_CREATE_TEMPLATE_ERROR_DIALOG_TITLE, (Throwable)ioe);
        }
    }

    public void dispose() {
        this.repository.deleteObserver(this.repositoryObserver);
        super.dispose();
    }
}

