/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.controlpanel.ui.actions;

import com.jrockit.mc.common.io.IOToolkit;
import com.jrockit.mc.flightrecorder.controlpanel.ui.ControlPanel;
import com.jrockit.mc.flightrecorder.controlpanel.ui.FlightRecorderProvider;
import com.jrockit.mc.flightrecorder.controlpanel.ui.messages.internal.Messages;
import com.jrockit.mc.flightrecorder.controlpanel.ui.wizards.RecordingWizardModel;
import com.jrockit.mc.flightrecorder.controlpanel.ui.wizards.StartRecordingWizard;
import com.jrockit.mc.rjmx.IConnectionHandle;
import com.jrockit.mc.rjmx.services.flr.IFlightRecorderService;
import com.jrockit.mc.ui.wizards.AbstractWizardUserAction;
import java.io.Closeable;
import org.eclipse.jface.wizard.IWizard;

public class StartRecordingAction
extends AbstractWizardUserAction {
    private final FlightRecorderProvider recorder;

    public StartRecordingAction(FlightRecorderProvider recorder) {
        super(Messages.ACTION_START_RECORDING_LABEL, Messages.ACTION_START_RECORDING_TOOLTIP, ControlPanel.getDefault().getMCImageDescriptor("FLR_on.gif"));
        this.recorder = recorder;
    }

    public IWizard doCreateWizard() throws Exception {
        StartRecordingWizard startRecordingWizard;
        IConnectionHandle handle = null;
        try {
            handle = this.recorder.getServerHandle().connect(Messages.ACTION_START_RECORDING_LABEL);
            String serverName = this.recorder.getServerHandle().getServerDescriptor().getDisplayName();
            RecordingWizardModel model = new RecordingWizardModel((IFlightRecorderService)handle.getServiceOrDummy(IFlightRecorderService.class), RecordingWizardModel.getDefaultRecordingFileName(serverName));
            this.recorder.resetWarning();
            startRecordingWizard = new StartRecordingWizard(model, this.recorder);
        }
        catch (Exception e) {
            try {
                this.recorder.setWarning(e.getLocalizedMessage());
                throw e;
            }
            catch (Throwable throwable) {
                IOToolkit.closeSilently(handle);
                throw throwable;
            }
        }
        IOToolkit.closeSilently((Closeable)handle);
        return startRecordingWizard;
    }
}

