/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.triggers.internal;

import com.jrockit.mc.common.xml.XmlToolkit;
import com.jrockit.mc.rjmx.triggers.TriggerEvent;
import com.jrockit.mc.rjmx.triggers.internal.AbstractNotificationAction;
import com.jrockit.mc.rjmx.triggers.internal.NotificationToolkit;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Element;

public final class NotificationActionLogToFile
extends AbstractNotificationAction {
    private static final Logger LOGGER = Logger.getLogger("com.jrockit.mc.rjmx");
    public static final String XML_ELEMENT_LOG_FILE = "log_file";
    public static final String NAME = "Log to file";
    public static final String DESCRIPTION = "Logs the notification event on the user specified log text file.";
    private String m_logFileName;
    private FileWriter m_file;
    private PrintWriter m_printWriter;

    @Override
    public void handleNotificationEvent(TriggerEvent e) {
        NotificationToolkit.prettyPrint(this.getPrintWriter(), e);
        this.getPrintWriter().flush();
        if (this.getPrintWriter().checkError()) {
            LOGGER.severe("Can't write to log file " + this.getName());
        }
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getDescription() {
        return DESCRIPTION;
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public void initializeFromXml(Element node) {
        this.setLogFileName(XmlToolkit.getSetting((Element)node, (String)XML_ELEMENT_LOG_FILE, (String)"default.log"));
    }

    @Override
    public void exportToXml(Element actionNode) {
        XmlToolkit.setSetting((Element)actionNode, (String)XML_ELEMENT_LOG_FILE, (String)this.getLogFileName());
    }

    public String getLogFileName() {
        return this.m_logFileName;
    }

    public void setLogFileName(String logFileName) {
        this.m_logFileName = logFileName;
        if (this.m_file != null) {
            try {
                this.m_file.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.m_file = null;
        if (this.m_printWriter != null) {
            this.m_printWriter.close();
        }
        this.m_printWriter = null;
    }

    private PrintWriter getPrintWriter() {
        if (this.m_printWriter == null) {
            try {
                this.m_file = new FileWriter(this.getLogFileName(), true);
                this.m_printWriter = new PrintWriter(this.m_file);
            }
            catch (IOException e) {
                LOGGER.log(Level.SEVERE, "Could not open log to write to!", e);
            }
        }
        return this.m_printWriter;
    }
}

