/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.subscription.storage.internal;

import com.jrockit.mc.common.DefaultTimestampedData;
import com.jrockit.mc.common.ITimestampedData;
import com.jrockit.mc.common.util.BoundedList;
import com.jrockit.mc.rjmx.services.IAttributeStorage;
import com.jrockit.mc.rjmx.services.MRIDataSeries;
import com.jrockit.mc.rjmx.subscription.IMRIValueListener;
import com.jrockit.mc.rjmx.subscription.ISubscriptionService;
import com.jrockit.mc.rjmx.subscription.MRI;
import com.jrockit.mc.rjmx.subscription.MRIValueEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Observable;
import java.util.Observer;

public class BufferingAttributeStorage
extends Observable
implements IAttributeStorage {
    private static final int DEFAULT_CACHE_SIZE = 604800;
    private final BoundedList<ITimestampedData> cache = new BoundedList(604800);
    private final MRI mri;
    private final ISubscriptionService subscriptionService;
    private final IMRIValueListener valueListener = new IMRIValueListener(){

        @Override
        public void valueChanged(MRIValueEvent event) {
            Object value = event.getValue();
            if (value instanceof Number) {
                DefaultTimestampedData data = new DefaultTimestampedData(Long.valueOf(event.getTimestamp() * 1000L * 1000L), (Number)((Number)value).doubleValue());
                BufferingAttributeStorage.this.cache.add((Object)data);
                BufferingAttributeStorage.this.setChanged();
                BufferingAttributeStorage.this.notifyObservers(data);
            }
        }
    };
    private final List<MRIDataSeries> dataSeries = new ArrayList<MRIDataSeries>(1);

    public BufferingAttributeStorage(MRI attribute, ISubscriptionService subscriptionService) {
        this.mri = attribute;
        this.subscriptionService = subscriptionService;
        this.dataSeries.add(new MRIDataSeries(){

            public Iterator<ITimestampedData> createIterator(long min, long max) {
                return BufferingAttributeStorage.this.cache.iterator();
            }

            @Override
            public MRI getAttribute() {
                return BufferingAttributeStorage.this.mri;
            }
        });
    }

    @Override
    public long getDataStart() {
        ITimestampedData first = (ITimestampedData)this.cache.getFirst();
        return first != null ? (Long)first.getX() : Long.MAX_VALUE;
    }

    @Override
    public long getDataEnd() {
        ITimestampedData last = (ITimestampedData)this.cache.getLast();
        return last != null ? (Long)last.getX() : Long.MIN_VALUE;
    }

    @Override
    public synchronized void addObserver(Observer o) {
        if (this.countObservers() == 0) {
            this.subscriptionService.addMRIValueListener(this.mri, this.valueListener);
        }
        super.addObserver(o);
    }

    @Override
    public synchronized void deleteObserver(Observer o) {
        super.deleteObserver(o);
        if (this.countObservers() == 0) {
            this.subscriptionService.removeMRIValueListener(this.mri, this.valueListener);
        }
    }

    void dispose() {
        this.subscriptionService.removeMRIValueListener(this.mri, this.valueListener);
    }

    public List<MRIDataSeries> getDataSeries() {
        return this.dataSeries;
    }
}

