/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.subscription.internal;

import com.jrockit.mc.rjmx.IConnectionHandle;
import com.jrockit.mc.rjmx.subscription.IMRIMetaDataService;
import com.jrockit.mc.rjmx.subscription.IMRISubscription;
import com.jrockit.mc.rjmx.subscription.ISubscriptionService;
import com.jrockit.mc.rjmx.subscription.IUpdatePolicy;
import com.jrockit.mc.rjmx.subscription.MRI;
import com.jrockit.mc.rjmx.subscription.PolicyFactory;
import com.jrockit.mc.rjmx.subscription.internal.DefaultUpdatePolicy;
import com.jrockit.mc.rjmx.subscription.internal.OneShotUpdatePolicy;
import com.jrockit.mc.rjmx.subscription.internal.SimpleUpdatePolicy;

public final class UpdatePolicyToolkit {
    private UpdatePolicyToolkit() throws InstantiationException {
        throw new InstantiationException("Should not be instantiated!");
    }

    public static int getDefaultUpdateInterval() {
        return Integer.getInteger("com.jrockit.console.preferences.updateinterval", new Integer("1000"));
    }

    public static int getUpdateInterval(IConnectionHandle handle, MRI mri) {
        Integer time = (Integer)UpdatePolicyToolkit.getMetaDataService(handle).getMetaData(mri, "UpdateTime");
        if (time != null) {
            return time;
        }
        return -1;
    }

    public static int getUpdateTime(IConnectionHandle handle, MRI attributeDescriptor) {
        int time = UpdatePolicyToolkit.getUpdateInterval(handle, attributeDescriptor);
        if (time > -1) {
            return time;
        }
        return UpdatePolicyToolkit.getDefaultUpdateInterval();
    }

    public static void setUpdatePolicy(IConnectionHandle handle, MRI attributeDescriptor, IUpdatePolicy policy) {
        if (policy instanceof OneShotUpdatePolicy) {
            UpdatePolicyToolkit.getMetaDataService(handle).setMetaData(attributeDescriptor, "UpdateTime", 0);
        } else if (policy instanceof SimpleUpdatePolicy) {
            SimpleUpdatePolicy s = (SimpleUpdatePolicy)policy;
            UpdatePolicyToolkit.getMetaDataService(handle).setMetaData(attributeDescriptor, "UpdateTime", s.getIntervalTime());
        } else if (policy instanceof DefaultUpdatePolicy) {
            UpdatePolicyToolkit.getMetaDataService(handle).setMetaData(attributeDescriptor, "UpdateTime", -1);
        } else {
            throw new UnsupportedOperationException(policy.getClass() + "is not supported!");
        }
        UpdatePolicyToolkit.updateExistingSubscription(handle, attributeDescriptor);
    }

    private static void updateExistingSubscription(IConnectionHandle handle, MRI attributeDescriptor) {
        ISubscriptionService service = handle.getServiceOrNull(ISubscriptionService.class);
        if (service == null) {
            return;
        }
        IMRISubscription attributeSubscription = service.getMRISubscription(attributeDescriptor);
        if (attributeSubscription != null) {
            attributeSubscription.setUpdatePolicy(UpdatePolicyToolkit.getUpdatePolicy(handle, attributeDescriptor));
        }
    }

    public static IUpdatePolicy getUpdatePolicy(IConnectionHandle handle, MRI attributeDescriptor) {
        return UpdatePolicyToolkit.getUpdatePolicy(UpdatePolicyToolkit.getUpdateInterval(handle, attributeDescriptor));
    }

    public static IUpdatePolicy getUpdatePolicy(int updateInterval) {
        if (updateInterval <= -1) {
            return PolicyFactory.createDefaultUpdatePolicy();
        }
        if (updateInterval == 0) {
            return PolicyFactory.createOneShotPolicy();
        }
        return PolicyFactory.createSimpleUpdatePolicy(updateInterval);
    }

    private static IMRIMetaDataService getMetaDataService(IConnectionHandle handle) {
        return handle.getServiceOrDummy(IMRIMetaDataService.class);
    }
}

