/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.subscription.internal;

import com.jrockit.mc.rjmx.subscription.MRI;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanServerConnection;
import javax.management.NotificationFilter;
import javax.management.NotificationFilterSupport;
import javax.management.NotificationListener;
import javax.management.ObjectName;

public class SyntheticAttributeToolkit {
    public static Set<ObjectName> lookupMxBeans(MBeanServerConnection connection, String domain, String type) {
        HashSet<ObjectName> mxBeans = new HashSet<ObjectName>();
        try {
            for (ObjectName objectName : connection.queryNames(null, null)) {
                if (!objectName.getDomain().equals(domain) || !type.equals(objectName.getKeyProperty("type"))) continue;
                mxBeans.add(objectName);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return mxBeans;
    }

    public static MRI[] createNotificationDescriptors(MBeanServerConnection connection, Set<ObjectName> mxBeans, String type) {
        ArrayList<MRI> notificationDescriptors = new ArrayList<MRI>();
        block2: for (ObjectName mxBean : mxBeans) {
            try {
                MBeanNotificationInfo[] mBeanNotificationInfoArray = connection.getMBeanInfo(mxBean).getNotifications();
                int n = mBeanNotificationInfoArray.length;
                int n2 = 0;
                while (n2 < n) {
                    MBeanNotificationInfo notification = mBeanNotificationInfoArray[n2];
                    String[] stringArray = notification.getNotifTypes();
                    int n3 = stringArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String notifType = stringArray[n4];
                        if (notifType.equals(type)) {
                            notificationDescriptors.add(new MRI(MRI.Type.NOTIFICATION, mxBean, type));
                            continue block2;
                        }
                        ++n4;
                    }
                    ++n2;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return notificationDescriptors.toArray(new MRI[notificationDescriptors.size()]);
    }

    public static void subscribeToNotifications(MBeanServerConnection connection, NotificationListener listener, MRI[] notificationDescriptors) {
        MRI[] mRIArray = notificationDescriptors;
        int n = notificationDescriptors.length;
        int n2 = 0;
        while (n2 < n) {
            MRI notification = mRIArray[n2];
            try {
                connection.addNotificationListener(notification.getObjectName(), listener, SyntheticAttributeToolkit.createNotificationFilter(notification), null);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++n2;
        }
    }

    private static NotificationFilter createNotificationFilter(MRI notification) {
        NotificationFilterSupport filter = new NotificationFilterSupport();
        filter.enableType(notification.getDataPath());
        return filter;
    }

    public static void unsubscribeFromNotifications(MBeanServerConnection connection, NotificationListener listener, MRI[] notificationDescriptors) {
        MRI[] mRIArray = notificationDescriptors;
        int n = notificationDescriptors.length;
        int n2 = 0;
        while (n2 < n) {
            MRI notification = mRIArray[n2];
            try {
                connection.removeNotificationListener(notification.getObjectName(), listener);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++n2;
        }
    }
}

