/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.subscription.internal;

import com.jrockit.mc.rjmx.subscription.IMRIMetaData;
import com.jrockit.mc.rjmx.subscription.IMRIMetaDataService;
import com.jrockit.mc.rjmx.subscription.MRI;

class MRIMetaDataWrapper
implements IMRIMetaData {
    private final MRI mri;
    private final IMRIMetaDataService service;

    public MRIMetaDataWrapper(MRI mri, IMRIMetaDataService service) {
        this.mri = mri;
        this.service = service;
    }

    @Override
    public MRI getMRI() {
        return this.mri;
    }

    @Override
    public Object getMetaData(String key) {
        return this.service.getMetaData(this.getMRI(), key);
    }

    @Override
    public String getDescription() {
        return (String)this.getMetaData("Description");
    }

    @Override
    public String getValueType() {
        return (String)this.getMetaData("AttributeType");
    }

    @Override
    public String getDisplayName() {
        return (String)this.getMetaData("DisplayName");
    }

    @Override
    public int getUpdateTime() {
        Integer updateTime = (Integer)this.getMetaData("UpdateTime");
        if (updateTime != null) {
            return updateTime;
        }
        return -1;
    }

    @Override
    public String getUnitString() {
        return (String)this.getMetaData("UnitString");
    }

    public boolean equals(Object that) {
        if (that instanceof MRIMetaDataWrapper) {
            return this.getMRI().equals(((MRIMetaDataWrapper)that).getMRI());
        }
        return false;
    }

    public int hashCode() {
        return this.getMRI().hashCode();
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + '[' + this.getMRI() + ",update time=" + this.getUpdateTime() + ']';
    }
}

