/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.subscription.internal;

import com.jrockit.mc.rjmx.IConnectionHandle;
import com.jrockit.mc.rjmx.subscription.IMRIMetaData;
import com.jrockit.mc.rjmx.subscription.IMRIMetaDataService;
import com.jrockit.mc.rjmx.subscription.IMRISubscription;
import com.jrockit.mc.rjmx.subscription.IMRIValueListener;
import com.jrockit.mc.rjmx.subscription.IUpdatePolicy;
import com.jrockit.mc.rjmx.subscription.MRI;
import com.jrockit.mc.rjmx.subscription.MRIMetaDataToolkit;
import com.jrockit.mc.rjmx.subscription.MRIValueEvent;
import com.jrockit.mc.rjmx.subscription.internal.AttributeToolkit;
import com.jrockit.mc.rjmx.subscription.internal.IValueFilter;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MalformedObjectNameException;

public abstract class AbstractAttributeSubscription
implements IMRISubscription {
    private static final Logger LOGGER = Logger.getLogger("com.jrockit.mc.rjmx");
    public static final String DEBUG_MODULE = "ATTRSUB";
    public static final String UNIT_STRING_PERCENT = "%";
    public static final String UNIT_STRING_BYTES = "bytes";
    private final IConnectionHandle m_connectionHandle;
    private final Set<IMRIValueListener> m_attributeListenerList = Collections.synchronizedSet(new HashSet(1));
    private final IMRIMetaData m_attributeInfo;
    private MRIValueEvent m_lastEvent;
    private IUpdatePolicy m_updatePolicy;
    private final IValueFilter m_valueFilter;
    private Integer cachedHashCode;

    public AbstractAttributeSubscription(IConnectionHandle connectionHandle, IMRIMetaData info) {
        this.m_connectionHandle = connectionHandle;
        if (info.getMRI().getObjectName() == null) {
            throw new IllegalArgumentException("Subscriptions may not be created from attribute name references.");
        }
        if (!this.m_connectionHandle.hasService(IMRIMetaDataService.class)) {
            throw new IllegalArgumentException("Connection handle must have the IMBeanHelperService for subscriptions to work!");
        }
        this.m_attributeInfo = info;
        this.m_valueFilter = AttributeToolkit.getValueFilter(info);
    }

    public void addAttributeValueListener(IMRIValueListener listener) {
        if (listener == null) {
            throw new NullPointerException("Listener may not be null!");
        }
        if (this.m_attributeListenerList.contains(listener)) {
            throw new IllegalArgumentException("This listener has already been added!");
        }
        this.m_attributeListenerList.add(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void substituteAttributeValueListener(IMRIValueListener oldListener, IMRIValueListener newListener) {
        if (oldListener == null || newListener == null) {
            throw new NullPointerException("Listeners may not be null!");
        }
        if (oldListener != newListener) {
            Set<IMRIValueListener> set = this.m_attributeListenerList;
            synchronized (set) {
                this.removeAttributeValueListener(oldListener);
                this.addAttributeValueListener(newListener);
            }
        }
    }

    public void removeAttributeValueListener(IMRIValueListener listener) {
        this.m_attributeListenerList.remove(listener);
    }

    public boolean hasAttributeValueListeners() {
        return this.m_attributeListenerList.size() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireAttributeChange(MRIValueEvent attributeEvent) {
        IMRIValueListener[] tmpListeners;
        if (attributeEvent == null) {
            return;
        }
        Set<IMRIValueListener> set = this.m_attributeListenerList;
        synchronized (set) {
            tmpListeners = this.m_attributeListenerList.toArray(new IMRIValueListener[this.m_attributeListenerList.size()]);
        }
        IMRIValueListener[] iMRIValueListenerArray = tmpListeners;
        int n = tmpListeners.length;
        int n2 = 0;
        while (n2 < n) {
            IMRIValueListener l = iMRIValueListenerArray[n2];
            l.valueChanged(attributeEvent);
            ++n2;
        }
    }

    @Override
    public IConnectionHandle getConnectionHandle() {
        return this.m_connectionHandle;
    }

    @Override
    public MRIValueEvent getLastMRIValueEvent() {
        return this.m_lastEvent;
    }

    protected void storeAndFireEvent(MRIValueEvent event) {
        if (this.m_valueFilter != null && this.m_valueFilter.filterObject(event.getValue())) {
            LOGGER.log(Level.INFO, "Subscription filtered out value: " + event.getValue());
            return;
        }
        if (this.m_lastEvent != null && event.getTimestamp() < this.m_lastEvent.getTimestamp()) {
            LOGGER.log(Level.INFO, "Subscription dropped attribute event because timestamp was older than last event.");
            return;
        }
        this.m_lastEvent = event;
        this.fireAttributeChange(event);
    }

    @Override
    public String getDescription() {
        return this.getMRIMetaData().getDescription();
    }

    @Override
    public String getName() {
        return MRIMetaDataToolkit.getDisplayName(this.getConnectionHandle(), this.getMRIMetaData().getMRI());
    }

    @Override
    public IMRIMetaData getMRIMetaData() {
        return this.m_attributeInfo;
    }

    public boolean equals(Object obj) {
        if (obj instanceof AbstractAttributeSubscription) {
            AbstractAttributeSubscription other = (AbstractAttributeSubscription)obj;
            return this.m_connectionHandle.getServerDescriptor().getGUID().equals(other.m_connectionHandle.getServerDescriptor().getGUID()) && this.getMRIMetaData().equals(other.getMRIMetaData());
        }
        return false;
    }

    public int hashCode() {
        if (this.cachedHashCode == null) {
            this.cachedHashCode = (String.valueOf(this.m_connectionHandle.getServerDescriptor().getGUID()) + this.getMRIMetaData().getMRI().getQualifiedName()).hashCode();
        }
        return this.cachedHashCode;
    }

    protected MRI getAttributeFromString(String attributeDescription) throws MalformedObjectNameException {
        return MRI.createFromQualifiedName(attributeDescription);
    }

    protected Object getMetaData(String extendedPropertyKeyFirst) {
        return this.getConnectionHandle().getServiceOrDummy(IMRIMetaDataService.class).getMetaData(this.getMRIMetaData().getMRI(), extendedPropertyKeyFirst);
    }

    @Override
    public IUpdatePolicy getUpdatePolicy() {
        return this.m_updatePolicy;
    }

    @Override
    public void setUpdatePolicy(IUpdatePolicy updatePolicy) {
        this.m_updatePolicy = updatePolicy;
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + '[' + this.getMRIMetaData() + ']';
    }
}

