/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.persistence.internal;

import com.jrockit.mc.common.io.IOToolkit;
import com.jrockit.mc.common.string.StringToolkit;
import com.jrockit.mc.rjmx.RJMXPlugin;
import com.jrockit.mc.rjmx.persistence.internal.PersistenceFile;
import com.jrockit.mc.rjmx.subscription.IMRIValueListener;
import com.jrockit.mc.rjmx.subscription.MRI;
import com.jrockit.mc.rjmx.subscription.MRIValueEvent;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.logging.Level;

class AttributeWriter
implements IMRIValueListener {
    static final String SERIES_FILE_NAME = "series.info";
    private long currentFileSize;
    private DataOutputStream currentFileStream;
    private File currentFile;
    private File dir;
    private final MRI mri;
    private boolean isEnabled;
    private Boolean isRunning;
    private long maxFileSize;

    AttributeWriter(MRI mri, File persistenceDir, long maxFileSize) {
        this.mri = mri;
        this.setMaxFileSize(maxFileSize);
        this.setPersistenceDir(persistenceDir);
    }

    synchronized void setMaxFileSize(long maxFileSize) {
        this.maxFileSize = maxFileSize;
    }

    synchronized void setPersistenceDir(File persistenceDir) {
        if (!(persistenceDir = new File(persistenceDir, StringToolkit.encodeFilename((String)this.mri.getQualifiedName()))).equals(this.dir)) {
            this.dir = persistenceDir;
            IOToolkit.closeSilently((Closeable)this.currentFileStream);
            this.currentFileStream = null;
            this.currentFile = null;
            if (this.dir.isDirectory()) {
                ArrayList<PersistenceFile> existingFiles = new ArrayList<PersistenceFile>();
                File[] fileArray = this.dir.listFiles(PersistenceFile.FILTER);
                int n = fileArray.length;
                int n2 = 0;
                while (n2 < n) {
                    File f = fileArray[n2];
                    try {
                        PersistenceFile pfr = new PersistenceFile(f);
                        if (!pfr.isCorrupt()) {
                            existingFiles.add(pfr);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    ++n2;
                }
                Collections.sort(existingFiles, PersistenceFile.PERSISTENCE_FILE_START_COMPARATOR);
                if (existingFiles.size() > 0) {
                    this.currentFile = ((PersistenceFile)existingFiles.get((int)(existingFiles.size() - 1))).file;
                    this.currentFileSize = this.currentFile.length();
                }
            }
            if (!Boolean.FALSE.equals(this.isRunning)) {
                this.isRunning = null;
            }
        }
    }

    synchronized void setEnabled(boolean enabled) {
        this.isEnabled = enabled;
    }

    synchronized boolean isEnabled() {
        return this.isEnabled;
    }

    synchronized void start() {
        this.isRunning = null;
    }

    synchronized void stop() {
        this.isRunning = false;
        IOToolkit.closeSilently((Closeable)this.currentFileStream);
        this.currentFileStream = null;
    }

    @Override
    public void valueChanged(MRIValueEvent event) {
        Object value = event.getValue();
        if (value instanceof Number) {
            this.write(event.getTimestamp() * 1000L * 1000L, ((Number)event.getValue()).doubleValue());
        } else if (value != null) {
            RJMXPlugin.getDefault().getLogger().log(Level.WARNING, "Can not write value of type " + value.getClass().getCanonicalName());
        }
    }

    private synchronized void write(long timestamp, double value) {
        if (this.isEnabled && !Boolean.FALSE.equals(this.isRunning)) {
            if (this.isRunning == null) {
                if (this.dir.isDirectory() || this.dir.mkdirs()) {
                    this.writeSeriesStart(timestamp);
                    this.isRunning = true;
                } else {
                    RJMXPlugin.getDefault().getLogger().log(Level.WARNING, "Could not create directory " + this.dir.getPath());
                    return;
                }
            }
            try {
                this.ensureWriter();
                this.doWrite(timestamp, value);
            }
            catch (IOException e) {
                try {
                    this.createNewWriter();
                    this.doWrite(timestamp, value);
                }
                catch (IOException e1) {
                    IOToolkit.closeSilently((Closeable)this.currentFileStream);
                    this.currentFileStream = null;
                    this.currentFile = null;
                    RJMXPlugin.getDefault().getLogger().log(Level.WARNING, "Failed to write event", e1);
                }
            }
        }
    }

    private void writeSeriesStart(long timestamp) {
        block5: {
            DataOutputStream seriesFile = null;
            try {
                try {
                    seriesFile = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(new File(this.dir, SERIES_FILE_NAME), true)));
                    seriesFile.writeLong(timestamp);
                }
                catch (IOException e) {
                    RJMXPlugin.getDefault().getLogger().log(Level.WARNING, "Failed to write series start", e);
                    IOToolkit.closeSilently(seriesFile);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                IOToolkit.closeSilently(seriesFile);
                throw throwable;
            }
            IOToolkit.closeSilently((Closeable)seriesFile);
        }
    }

    private void doWrite(long timestamp, double value) throws IOException {
        this.currentFileStream.writeLong(timestamp);
        this.currentFileStream.writeDouble(value);
        this.currentFileSize += 16L;
    }

    private void ensureWriter() throws IOException {
        if (this.currentFileSize + 16L > this.maxFileSize) {
            this.createNewWriter();
        } else if (this.currentFileStream == null) {
            if (this.currentFile != null) {
                this.currentFileStream = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(this.currentFile, true)));
            } else {
                this.createNewWriter();
            }
        }
    }

    private void createNewWriter() throws IOException {
        String fileName;
        File file;
        IOToolkit.closeSilently((Closeable)this.currentFileStream);
        this.currentFileStream = null;
        while ((file = new File(this.dir, fileName = "values_" + System.currentTimeMillis() + ".histdata")).exists()) {
        }
        this.currentFileStream = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
        this.currentFileStream.writeUTF(this.mri.getQualifiedName());
        this.currentFileStream.flush();
        this.currentFileSize = file.length();
        this.currentFile = file;
    }
}

