/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.masterfs.filebasedfs.naming;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import org.netbeans.modules.masterfs.filebasedfs.naming.FileName;
import org.netbeans.modules.masterfs.filebasedfs.naming.FileNaming;
import org.netbeans.modules.masterfs.filebasedfs.naming.FolderName;
import org.netbeans.modules.masterfs.filebasedfs.naming.NameRef;
import org.netbeans.modules.masterfs.filebasedfs.utils.FileInfo;
import org.netbeans.modules.masterfs.filebasedfs.utils.Utils;
import org.netbeans.modules.masterfs.providers.ProvidedExtensions;
import org.openide.util.Utilities;

public final class NamingFactory {
    private static NameRef[] names = new NameRef[2];
    private static int namesCount;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static FileNaming fromFile(File file) {
        if (Utilities.isWindows() && file.getPath().length() == 2 && file.getPath().charAt(1) == ':') {
            file = new File(file.getPath() + File.separator);
        }
        LinkedList<FileInfo> linkedList = new LinkedList<FileInfo>();
        for (File file2 = file; file2 != null; file2 = file2.getParentFile()) {
            linkedList.addFirst(new FileInfo(file2));
        }
        ArrayList arrayList = new ArrayList();
        FileNaming fileNaming = null;
        int n = 0;
        while (n < linkedList.size()) {
            Object object2;
            FileInfo fileInfo = (FileInfo)linkedList.get(n);
            if ("\\\\".equals(fileInfo.getFile().getPath())) {
                ++n;
                continue;
            }
            for (Object object2 : arrayList) {
                ((FileInfo)object2).isDirectory();
            }
            arrayList.clear();
            Object object3 = n == linkedList.size() - 1 ? FileType.unknown : FileType.directory;
            object2 = NamingFactory.class;
            // MONITORENTER : org.netbeans.modules.masterfs.filebasedfs.naming.NamingFactory.class
            FileNaming fileNaming2 = NamingFactory.registerInstanceOfFileNaming(fileNaming, fileInfo, object3, arrayList);
            if (fileNaming2 == null) {
                // MONITOREXIT : object2
                continue;
            }
            fileNaming = fileNaming2;
            ++n;
            // MONITOREXIT : object2
        }
        return fileNaming;
    }

    public static synchronized int getSize() {
        return namesCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static FileNaming fromFile(FileNaming fileNaming, File file, boolean bl) {
        FileNaming fileNaming2;
        FileInfo fileInfo = new FileInfo(file);
        ArrayList arrayList = new ArrayList();
        do {
            Object object2;
            for (Object object2 : arrayList) {
                ((FileInfo)object2).isDirectory();
            }
            object2 = NamingFactory.class;
            // MONITORENTER : org.netbeans.modules.masterfs.filebasedfs.naming.NamingFactory.class
            fileNaming2 = NamingFactory.registerInstanceOfFileNaming(fileNaming, fileInfo, null, bl, FileType.unknown, arrayList);
            // MONITOREXIT : object2
        } while (fileNaming2 == null);
        return fileNaming2;
    }

    public static synchronized FileNaming checkCaseSensitivity(FileNaming fileNaming, File file) throws IOException {
        if (!fileNaming.getFile().getName().equals(file.getName())) {
            boolean bl;
            boolean bl2 = bl = !Utils.equals(new File(file, "a"), new File(file, "A"));
            if (!bl) {
                FileName fileName = (FileName)fileNaming;
                fileName.updateCase(file.getName());
            }
        }
        return fileNaming;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FileNaming[] rename(FileNaming fileNaming, String string, ProvidedExtensions.IOHandler iOHandler) throws IOException {
        LinkedHashSet<FileNaming> linkedHashSet = new LinkedHashSet<FileNaming>();
        FileNaming fileNaming2 = fileNaming.rename(string, iOHandler);
        boolean bl = fileNaming2 != fileNaming;
        Class<NamingFactory> clazz = NamingFactory.class;
        synchronized (NamingFactory.class) {
            linkedHashSet.add(fileNaming2);
            NamingFactory.collectSubnames(fileNaming, linkedHashSet);
            // ** MonitorExit[var6_6] (shouldn't be in output)
            return bl ? linkedHashSet.toArray(new FileNaming[linkedHashSet.size()]) : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<FileNaming> findSubTree(FileNaming fileNaming) {
        LinkedHashSet<FileNaming> linkedHashSet = new LinkedHashSet<FileNaming>();
        Class<NamingFactory> clazz = NamingFactory.class;
        synchronized (NamingFactory.class) {
            NamingFactory.collectSubnames(fileNaming, linkedHashSet);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return linkedHashSet;
        }
    }

    private static void collectSubnames(FileNaming fileNaming, Collection<FileNaming> collection) {
        assert (Thread.holdsLock(NamingFactory.class));
        HashSet hashSet = new HashSet(names.length);
        for (int i = 0; i < names.length; ++i) {
            block1: for (NameRef nameRef = names[i]; nameRef != null; nameRef = nameRef.next()) {
                FileNaming fileNaming2 = (FileNaming)nameRef.get();
                LinkedList<FileNaming> linkedList = new LinkedList<FileNaming>();
                FileNaming fileNaming3 = fileNaming2;
                while (true) {
                    if (fileNaming3 == null || hashSet.contains(fileNaming3)) {
                        hashSet.addAll(linkedList);
                        continue block1;
                    }
                    linkedList.addFirst(fileNaming3);
                    if (fileNaming.equals(fileNaming3) || collection.contains(fileNaming3)) {
                        collection.addAll(linkedList);
                        continue block1;
                    }
                    fileNaming3 = fileNaming3.getParent();
                }
            }
        }
    }

    public static Integer createID(File file) {
        return Utils.hashCode(file);
    }

    private static FileNaming registerInstanceOfFileNaming(FileNaming fileNaming, FileInfo fileInfo, FileType fileType, Collection<? super FileInfo> collection) {
        return NamingFactory.registerInstanceOfFileNaming(fileNaming, fileInfo, null, false, fileType, collection);
    }

    private static void rehash(int n) {
        int n2;
        assert (Thread.holdsLock(NamingFactory.class));
        NameRef[] nameRefArray = new NameRef[n];
        for (n2 = 0; n2 < names.length; ++n2) {
            NameRef nameRef = names[n2];
            if (nameRef == null) continue;
            for (NameRef nameRef2 : names[n2].disconnectAll()) {
                FileNaming fileNaming = (FileNaming)nameRef2.get();
                if (fileNaming == null) continue;
                Integer n3 = NamingFactory.createID(fileNaming.getFile());
                int n4 = Math.abs(n3) % nameRefArray.length;
                NameRef nameRef3 = nameRefArray[n4];
                nameRefArray[n4] = nameRef2;
                if (nameRef3 == null) {
                    nameRef2.setIndex(n4);
                    continue;
                }
                nameRef2.setNext(nameRef3);
            }
        }
        for (n2 = 0; n2 < nameRefArray.length; ++n2) {
            assert (NamingFactory.checkIndex(nameRefArray, n2));
        }
        names = nameRefArray;
    }

    private static FileNaming registerInstanceOfFileNaming(FileNaming fileNaming, FileInfo fileInfo, FileNaming fileNaming2, boolean bl, FileType fileType, Collection<? super FileInfo> collection) {
        FileNaming fileNaming3;
        assert (Thread.holdsLock(NamingFactory.class));
        NamingFactory.cleanQueue();
        Integer n = NamingFactory.createID(fileInfo.getFile());
        int n2 = Math.abs(n) % names.length;
        NameRef nameRef = NamingFactory.getReference(names[n2], fileInfo.getFile());
        FileNaming fileNaming4 = nameRef != null ? (FileNaming)nameRef.get() : null;
        Boolean bl2 = null;
        Boolean bl3 = null;
        if (bl) {
            if (fileNaming4 != null) {
                bl2 = fileNaming4.isDirectory();
                if (!fileInfo.isDirectoryComputed()) {
                    collection.add(fileInfo);
                    return null;
                }
                bl3 = fileInfo.isDirectory();
                if (bl2 != bl3) {
                    fileNaming4 = null;
                }
            }
            if (fileNaming4 != null) {
                try {
                    NamingFactory.checkCaseSensitivity(fileNaming4, fileInfo.getFile());
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        Boolean bl4 = null;
        if (fileNaming4 != null && (bl4 = Boolean.valueOf(Utils.equals(fileNaming4.getFile(), fileInfo.getFile()))).booleanValue()) {
            fileNaming3 = fileNaming4;
        } else {
            block23: {
                if (fileNaming2 == null) {
                    if (fileType == FileType.unknown && !fileInfo.isDirectoryComputed()) {
                        collection.add(fileInfo);
                        return null;
                    }
                    fileNaming3 = NamingFactory.createFileNaming(fileInfo, n, fileNaming, fileType);
                } else {
                    fileNaming3 = fileNaming2;
                }
                NameRef nameRef2 = new NameRef(fileNaming3);
                NameRef nameRef3 = names[n2];
                NamingFactory.names[n2] = nameRef2;
                if (nameRef3 == null) {
                    nameRef2.setIndex(n2);
                } else {
                    nameRef2.setNext(nameRef3);
                }
                assert (NamingFactory.checkIndex(names, n2));
                if (nameRef != null) {
                    NameRef nameRef4 = nameRef2;
                    while (true) {
                        if (nameRef4.next() == nameRef) {
                            FileNaming fileNaming5 = (FileNaming)nameRef.get();
                            if (fileNaming5 instanceof FileName) {
                                ((FileName)fileNaming5).recordCleanup("cachedElement: " + fileNaming4 + " ref: " + fileNaming5 + " file: " + fileInfo + " filesEqual: " + bl4 + " cachedIsDirectory: " + bl2 + " fileIsDirectory: " + bl3);
                            }
                            nameRef.clear();
                            nameRef4.skip(nameRef);
                            break block23;
                        }
                        nameRef4 = nameRef4.next();
                    }
                }
                ++namesCount;
            }
            assert (NamingFactory.checkIndex(names, n2));
            if (namesCount * 4 > names.length * 3) {
                NamingFactory.rehash(names.length * 2);
            }
        }
        assert (fileNaming3 != null);
        return fileNaming3;
    }

    private static NameRef getReference(NameRef nameRef, File file) {
        while (nameRef != null) {
            FileNaming fileNaming = (FileNaming)nameRef.get();
            if (fileNaming != null && Utils.equals(fileNaming.getFile(), file)) {
                return nameRef;
            }
            nameRef = nameRef.next();
        }
        return null;
    }

    private static FileNaming createFileNaming(FileInfo fileInfo, Integer n, FileNaming fileNaming, FileType fileType) {
        FileName fileName = null;
        if (fileType.equals((Object)FileType.unknown)) {
            fileType = fileInfo.isDirectory() ? FileType.directory : FileType.file;
        }
        switch (fileType) {
            case file: {
                fileName = new FileName(fileNaming, fileInfo.getFile(), n);
                break;
            }
            case directory: {
                fileName = new FolderName(fileNaming, fileInfo.getFile(), n);
            }
        }
        return fileName;
    }

    public static String dumpId(Integer n) {
        return NamingFactory.dump(n, null);
    }

    public static synchronized boolean isValid(FileNaming fileNaming) {
        int n = Math.abs(fileNaming.getId()) % names.length;
        for (NameRef nameRef = names[n]; nameRef != null; nameRef = nameRef.next()) {
            if (nameRef.get() != fileNaming) continue;
            return true;
        }
        return false;
    }

    static synchronized String dump(Integer n, File file) {
        StringBuilder stringBuilder = new StringBuilder();
        String string = Integer.toHexString(n);
        stringBuilder.append("Showing references to ").append(string).append("\n");
        int n2 = 0;
        int n3 = Math.abs(n) % names.length;
        for (NameRef nameRef = names[n3]; nameRef != null; nameRef = nameRef.next()) {
            if (file != null && !file.equals(nameRef.getFile())) continue;
            ++n2;
            NamingFactory.dumpFileNaming(stringBuilder, nameRef.get());
        }
        stringBuilder.append("References: ").append(n2);
        return stringBuilder.toString();
    }

    private static void dumpFileNaming(StringBuilder stringBuilder, Object object) {
        if (object == null) {
            stringBuilder.append("null");
            return;
        }
        if (object instanceof FolderName) {
            stringBuilder.append("FolderName: ");
        } else {
            stringBuilder.append("FileName: ");
        }
        stringBuilder.append(object).append("#").append(Integer.toHexString(object.hashCode())).append("@").append(Integer.toHexString(System.identityHashCode(object))).append("\n");
        if (object instanceof FileName) {
            ((FileName)object).dumpCreation(stringBuilder);
        }
    }

    private static void cleanQueue() {
        assert (Thread.holdsLock(NamingFactory.class));
        while (true) {
            NameRef nameRef;
            if ((nameRef = (NameRef)NameRef.QUEUE.poll()) == null) {
                return;
            }
            int n = nameRef.getIndex();
            if (n == -1) continue;
            if (names[n] != null) {
                NamingFactory.names[n] = names[n].remove(nameRef);
                --namesCount;
            }
            if (!$assertionsDisabled && !NamingFactory.checkIndex(names, n)) break;
        }
        throw new AssertionError();
    }

    private static boolean checkIndex(NameRef[] nameRefArray, int n) {
        if (nameRefArray[n] == null) {
            return true;
        }
        return n == nameRefArray[n].getIndex();
    }

    static enum FileType {
        file,
        directory,
        unknown;

    }
}

