/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.view.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JSeparator;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.core.windows.Constants;
import org.netbeans.core.windows.WindowManagerImpl;
import org.netbeans.core.windows.view.ui.StatusLine;
import org.netbeans.core.windows.view.ui.toolbars.ToolbarConfiguration;
import org.openide.LifecycleManager;
import org.openide.awt.MenuBar;
import org.openide.awt.StatusLineElementProvider;
import org.openide.awt.ToolbarPool;
import org.openide.cookies.InstanceCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.windows.TopComponent;

public final class MainWindow {
    static final long serialVersionUID = -1160791973145645501L;
    private final JFrame frame;
    private static JMenuBar mainMenuBar;
    private Component desktop;
    private JPanel desktopPanel;
    private static JPanel innerIconsPanel;
    private boolean inited;
    private Lookup.Result<SaveCookie> saveResult;
    private Lookup.Result<DataObject> dobResult;
    private LookupListener saveListener;
    private static MainWindow theInstance;
    private static final Logger LOGGER;
    private static Lookup.Result<StatusLineElementProvider> result;
    private static final String ICON_16 = "org/netbeans/core/startup/frame.gif";
    private static final String ICON_32 = "org/netbeans/core/startup/frame32.gif";
    private static final String ICON_48 = "org/netbeans/core/startup/frame48.gif";
    private Rectangle forcedBounds = null;
    private boolean isFullScreenMode = false;
    private Rectangle restoreBounds;
    private int restoreExtendedState = 0;
    private boolean isSwitchingFullScreenMode = false;
    private boolean isUndecorated = true;
    private int windowDecorationStyle = 1;

    private MainWindow(JFrame jFrame) {
        this.frame = jFrame;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MainWindow install(JFrame jFrame) {
        Class<MainWindow> clazz = MainWindow.class;
        synchronized (MainWindow.class) {
            if (null != theInstance) {
                LOGGER.log(Level.INFO, "Installing MainWindow again, existing frame is: " + MainWindow.theInstance.frame);
            }
            theInstance = new MainWindow(jFrame);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return theInstance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MainWindow getInstance() {
        Class<MainWindow> clazz = MainWindow.class;
        synchronized (MainWindow.class) {
            if (null == theInstance) {
                LOGGER.log(Level.INFO, "Accessing uninitialized MainWindow, using dummy JFrame instead.");
                theInstance = new MainWindow(new JFrame());
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return theInstance;
        }
    }

    public static void init() {
        if (mainMenuBar == null) {
            Object object;
            mainMenuBar = MainWindow.createMenuBar();
            ToolbarPool.getDefault().waitFinished();
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            Class<?> clazz = toolkit.getClass();
            if (clazz.getName().equals("sun.awt.X11.XToolkit")) {
                try {
                    object = clazz.getDeclaredField("awtAppClassName");
                    ((Field)object).setAccessible(true);
                    ((Field)object).set(null, NbBundle.getMessage(MainWindow.class, (String)"CTL_MainWindow_Title_No_Project", (Object)"").trim());
                }
                catch (Exception exception) {
                    LOGGER.log(Level.FINE, null, exception);
                }
            }
            if ("gnome-shell".equals(object = System.getenv("DESKTOP_SESSION")) || "gnome".equals(object) || "mate".equals(object)) {
                try {
                    Class<?> clazz2 = Class.forName("sun.awt.X11.XWM");
                    Field field = clazz2.getDeclaredField("awt_wmgr");
                    field.setAccessible(true);
                    Field field2 = clazz2.getDeclaredField("OTHER_WM");
                    field2.setAccessible(true);
                    if (field.get(null).equals(field2.get(null))) {
                        Field field3 = clazz2.getDeclaredField("METACITY_WM");
                        field3.setAccessible(true);
                        field.set(null, field3.get(null));
                        LOGGER.info("installed #198639 workaround");
                    }
                }
                catch (Exception exception) {
                    LOGGER.log(Level.FINE, null, exception);
                }
            }
        }
    }

    public void initializeComponents() {
        Object object;
        if (this.inited) {
            return;
        }
        this.inited = true;
        JPanel jPanel = new JPanel(new BorderLayout()){

            @Override
            public void paint(Graphics graphics) {
                super.paint(graphics);
                LOGGER.log(Level.FINE, "Paint method of main window invoked normally.");
                WindowManagerImpl.getInstance().mainWindowPainted();
            }
        };
        if (MainWindow.isShowCustomBackground()) {
            jPanel.setOpaque(false);
        }
        this.frame.setContentPane(jPanel);
        MainWindow.init();
        this.initRootPane();
        MainWindow.initFrameIcons(this.frame);
        this.initListeners();
        this.frame.setDefaultCloseOperation(0);
        this.frame.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(MainWindow.class).getString("ACSD_MainWindow"));
        this.frame.setJMenuBar(mainMenuBar);
        if (!Constants.NO_TOOLBARS) {
            object = MainWindow.getToolbarComponent();
            this.frame.getContentPane().add((Component)object, "North");
        }
        if (!Constants.SWITCH_STATUSLINE_IN_MENUBAR) {
            if (Constants.CUSTOM_STATUS_LINE_PATH == null) {
                object = new StatusLine();
                ((JLabel)object).setText(" ");
                ((JComponent)object).setPreferredSize(new Dimension(0, ((JComponent)object).getPreferredSize().height));
                ((JComponent)object).setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 0));
                JPanel jPanel2 = new JPanel(new BorderLayout());
                if (MainWindow.isShowCustomBackground()) {
                    jPanel2.setOpaque(false);
                }
                int n = 0;
                if (Utilities.isMac()) {
                    n = 12;
                    if ("Aqua".equals(UIManager.getLookAndFeel().getID())) {
                        jPanel2.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, UIManager.getColor("NbBrushedMetal.darkShadow")), BorderFactory.createMatteBorder(1, 0, 0, 0, UIManager.getColor("NbBrushedMetal.lightShadow"))));
                    }
                }
                jPanel2.setBorder(BorderFactory.createCompoundBorder(jPanel2.getBorder(), BorderFactory.createEmptyBorder(0, 0, 0, n)));
                if (!"Aqua".equals(UIManager.getLookAndFeel().getID()) && !UIManager.getBoolean("NbMainWindow.StatusBar.HideSeparator")) {
                    jPanel2.add((Component)new JSeparator(), "North");
                }
                jPanel2.add((Component)object, "Center");
                MainWindow.decoratePanel(jPanel2, false);
                jPanel2.setName("statusLine");
                this.frame.getContentPane().add((Component)jPanel2, "South");
            } else {
                object = MainWindow.getCustomStatusLine();
                if (object != null) {
                    this.frame.getContentPane().add((Component)object, "South");
                }
            }
        }
        this.frame.getContentPane().add((Component)this.getDesktopPanel(), "Center");
        MenuSelectionManager.defaultManager().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                MenuElement[] menuElementArray = MenuSelectionManager.defaultManager().getSelectedPath();
                if (menuElementArray != null && menuElementArray.length > 0 && menuElementArray[0] == MainWindow.this.frame.getJMenuBar() && !MainWindow.this.frame.isActive()) {
                    MainWindow.this.frame.toFront();
                }
            }
        });
        object = NbBundle.getMessage(MainWindow.class, (String)"CTL_MainWindow_Title_No_Project", (Object)System.getProperty("netbeans.buildnumber"));
        if (!((String)object).isEmpty()) {
            this.frame.setTitle((String)object);
        }
        if (Utilities.getOperatingSystem() == 4096) {
            this.saveResult = Utilities.actionsGlobalContext().lookupResult(SaveCookie.class);
            this.dobResult = Utilities.actionsGlobalContext().lookupResult(DataObject.class);
            if (null != this.saveResult && null != this.dobResult) {
                this.saveListener = new LookupListener(){

                    public void resultChanged(LookupEvent lookupEvent) {
                        if (lookupEvent.getSource() == MainWindow.this.saveResult) {
                            boolean bl = MainWindow.this.saveResult.allItems().size() > 0;
                            MainWindow.this.frame.getRootPane().putClientProperty("Window.documentModified", bl ? Boolean.TRUE : Boolean.FALSE);
                        } else if (lookupEvent.getSource() == MainWindow.this.dobResult) {
                            Collection collection = MainWindow.this.dobResult.allItems();
                            int n = collection.size();
                            switch (n) {
                                case 1: {
                                    FileObject fileObject;
                                    File file;
                                    DataObject dataObject = (DataObject)((Lookup.Item)collection.iterator().next()).getInstance();
                                    if (null != dataObject && (file = FileUtil.toFile((FileObject)(fileObject = dataObject.getPrimaryFile()))) != null) {
                                        MainWindow.this.frame.getRootPane().putClientProperty("Window.documentFile", file);
                                        break;
                                    }
                                }
                                default: {
                                    MainWindow.this.frame.getRootPane().putClientProperty("Window.documentFile", null);
                                }
                            }
                        }
                    }
                };
                this.saveResult.addLookupListener(this.saveListener);
                this.dobResult.addLookupListener(this.saveListener);
            }
        }
    }

    private static void decoratePanel(JPanel jPanel, boolean bl) {
        assert (bl || SwingUtilities.isEventDispatchThread()) : "Must run in AWT queue.";
        if (innerIconsPanel != null) {
            jPanel.remove(innerIconsPanel);
        }
        if ((innerIconsPanel = MainWindow.getStatusLineElements(jPanel)) != null) {
            jPanel.add((Component)innerIconsPanel, "East");
        }
        if (MainWindow.isShowCustomBackground()) {
            jPanel.setOpaque(false);
        }
    }

    static JPanel getStatusLineElements(JPanel jPanel) {
        Collection collection;
        if (result == null) {
            result = Lookup.getDefault().lookup(new Lookup.Template(StatusLineElementProvider.class));
            result.addLookupListener((LookupListener)new StatusLineElementsListener(jPanel));
        }
        if ((collection = result.allInstances()) == null || collection.isEmpty()) {
            return null;
        }
        final Iterator iterator = collection.iterator();
        final JPanel jPanel2 = new JPanel(new FlowLayout(2, 0, 0));
        if (MainWindow.isShowCustomBackground()) {
            jPanel2.setOpaque(false);
        }
        jPanel2.setBorder(BorderFactory.createEmptyBorder(1, 0, 0, 2));
        final boolean[] blArray = new boolean[]{false};
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                while (iterator.hasNext()) {
                    StatusLineElementProvider statusLineElementProvider = (StatusLineElementProvider)iterator.next();
                    Component component = statusLineElementProvider.getStatusLineElement();
                    if (component == null) continue;
                    blArray[0] = true;
                    jPanel2.add(component);
                }
            }
        };
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(runnable);
            return jPanel2;
        }
        runnable.run();
        return blArray[0] ? jPanel2 : null;
    }

    protected void initRootPane() {
        JRootPane jRootPane = this.frame.getRootPane();
        if (null == jRootPane) {
            return;
        }
        if ("Aqua".equals(UIManager.getLookAndFeel().getID()) && null == System.getProperty("apple.awt.brushMetalLook")) {
            jRootPane.putClientProperty("apple.awt.brushMetalLook", Boolean.TRUE);
        }
        HelpCtx.setHelpIDString((JComponent)jRootPane, (String)new HelpCtx(MainWindow.class).getHelpID());
        if (Utilities.isWindows()) {
            JPanel jPanel = new JPanel(){

                @Override
                public void setVisible(boolean bl) {
                    if (bl != this.isVisible()) {
                        super.setVisible(bl);
                    }
                }
            };
            jPanel.setName(jRootPane.getName() + ".nbGlassPane");
            jPanel.setVisible(false);
            ((JPanel)jPanel).setOpaque(false);
            jRootPane.setGlassPane(jPanel);
        }
    }

    public void setBounds(Rectangle rectangle) {
        this.frame.setBounds(rectangle);
    }

    public void setExtendedState(int n) {
        this.frame.setExtendedState(n);
    }

    public void setVisible(boolean bl) {
        if ("false".equals(System.getProperty("org.netbeans.core.WindowSystem.show"))) {
            return;
        }
        this.frame.setVisible(bl);
    }

    public int getExtendedState() {
        return this.frame.getExtendedState();
    }

    public JMenuBar getJMenuBar() {
        return this.frame.getJMenuBar();
    }

    private static Border getDesktopBorder() {
        Border border = (Border)UIManager.get("nb.desktop.splitpane.border");
        if (border != null) {
            return border;
        }
        return new EmptyBorder(1, 1, 1, 1);
    }

    static void initFrameIcons(Frame frame) {
        List<Image> list = frame.getIconImages();
        if (!list.isEmpty()) {
            return;
        }
        frame.setIconImages(Arrays.asList(ImageUtilities.loadImage((String)ICON_16, (boolean)true), ImageUtilities.loadImage((String)ICON_32, (boolean)true), ImageUtilities.loadImage((String)ICON_48, (boolean)true)));
    }

    private void initListeners() {
        this.frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                LifecycleManager.getDefault().exit();
            }
        });
    }

    static void preInitMenuAndToolbar() {
        MainWindow.createMenuBar();
        ToolbarPool.getDefault();
    }

    private static JMenuBar createMenuBar() {
        JMenuBar jMenuBar = MainWindow.getCustomMenuBar();
        if (jMenuBar == null) {
            jMenuBar = new MenuBar(null);
        }
        jMenuBar.setBorderPainted(false);
        if (jMenuBar instanceof MenuBar) {
            ((MenuBar)jMenuBar).waitFinished();
        }
        if (Constants.SWITCH_STATUSLINE_IN_MENUBAR) {
            if (Constants.CUSTOM_STATUS_LINE_PATH == null) {
                StatusLine statusLine = new StatusLine();
                JSeparator jSeparator = new JSeparator(1);
                Dimension dimension = jSeparator.getPreferredSize();
                dimension.width += 6;
                jSeparator.setPreferredSize(dimension);
                JPanel jPanel = new JPanel(new BorderLayout());
                jPanel.add((Component)jSeparator, "West");
                jPanel.add((Component)statusLine, "Center");
                MainWindow.decoratePanel(jPanel, true);
                jPanel.setName("statusLine");
                jMenuBar.add(jPanel);
            } else {
                JComponent jComponent = MainWindow.getCustomStatusLine();
                if (jComponent != null) {
                    jMenuBar.add(jComponent);
                }
            }
        }
        return jMenuBar;
    }

    private static JMenuBar getCustomMenuBar() {
        try {
            DataObject dataObject;
            InstanceCookie instanceCookie;
            String string = Constants.CUSTOM_MENU_BAR_PATH;
            if (string == null) {
                return null;
            }
            FileObject fileObject = FileUtil.getConfigFile((String)string);
            if (fileObject != null && (instanceCookie = (InstanceCookie)(dataObject = DataObject.find((FileObject)fileObject)).getCookie(InstanceCookie.class)) != null) {
                return (JMenuBar)instanceCookie.instanceCreate();
            }
        }
        catch (Exception exception) {
            Exceptions.printStackTrace((Throwable)exception);
        }
        return null;
    }

    private static JComponent getCustomStatusLine() {
        try {
            DataObject dataObject;
            InstanceCookie instanceCookie;
            String string = Constants.CUSTOM_STATUS_LINE_PATH;
            if (string == null) {
                return null;
            }
            FileObject fileObject = FileUtil.getConfigFile((String)string);
            if (fileObject != null && (instanceCookie = (InstanceCookie)(dataObject = DataObject.find((FileObject)fileObject)).getCookie(InstanceCookie.class)) != null) {
                return (JComponent)instanceCookie.instanceCreate();
            }
        }
        catch (Exception exception) {
            Exceptions.printStackTrace((Throwable)exception);
        }
        return null;
    }

    private static JComponent getToolbarComponent() {
        ToolbarPool toolbarPool = ToolbarPool.getDefault();
        toolbarPool.waitFinished();
        return toolbarPool;
    }

    private void initializeBounds() {
        Rectangle rectangle = WindowManagerImpl.getInstance().getEditorAreaState() == 0 ? WindowManagerImpl.getInstance().getMainWindowBoundsJoined() : WindowManagerImpl.getInstance().getMainWindowBoundsSeparated();
        if (null != this.forcedBounds) {
            rectangle = new Rectangle(this.forcedBounds);
            this.frame.setPreferredSize(rectangle.getSize());
            this.forcedBounds = null;
        }
        if (!rectangle.isEmpty()) {
            this.frame.setBounds(rectangle);
        }
    }

    public void prepareWindow() {
        this.initializeBounds();
    }

    public void setDesktop(Component component) {
        if (this.desktop == component) {
            if (this.desktop != null && !Arrays.asList(this.getDesktopPanel().getComponents()).contains(this.desktop)) {
                this.getDesktopPanel().add(this.desktop, "Center");
            }
            return;
        }
        if (this.desktop != null) {
            this.getDesktopPanel().remove(this.desktop);
        }
        this.desktop = component;
        if (this.desktop != null) {
            this.getDesktopPanel().add(this.desktop, "Center");
        }
        this.frame.invalidate();
        this.frame.validate();
        this.frame.repaint();
    }

    public Component getDesktop() {
        return this.desktop;
    }

    public boolean hasDesktop() {
        return this.desktop != null;
    }

    private JPanel getDesktopPanel() {
        if (this.desktopPanel == null) {
            this.desktopPanel = new JPanel();
            this.desktopPanel.setBorder(MainWindow.getDesktopBorder());
            this.desktopPanel.setLayout(new BorderLayout());
            if (MainWindow.isShowCustomBackground()) {
                this.desktopPanel.setOpaque(false);
            }
        }
        return this.desktopPanel;
    }

    public Rectangle getPureMainWindowBounds() {
        Rectangle rectangle = this.frame.getBounds();
        if (this.desktop != null) {
            Dimension dimension = this.desktop.getSize();
            rectangle.height -= dimension.height;
        }
        return rectangle;
    }

    public void setFullScreenMode(boolean bl) {
        boolean bl2;
        ToolbarConfiguration toolbarConfiguration;
        if (this.isFullScreenMode == bl || this.isSwitchingFullScreenMode || Utilities.isMac()) {
            return;
        }
        this.isSwitchingFullScreenMode = true;
        if (!this.isFullScreenMode) {
            this.restoreExtendedState = this.frame.getExtendedState();
            this.restoreBounds = this.frame.getBounds();
            this.isUndecorated = this.frame.isUndecorated();
            this.windowDecorationStyle = this.frame.getRootPane().getWindowDecorationStyle();
        }
        final TopComponent topComponent = TopComponent.getRegistry().getActivated();
        GraphicsDevice graphicsDevice = null;
        GraphicsConfiguration graphicsConfiguration = this.frame.getGraphicsConfiguration();
        if (null != graphicsConfiguration) {
            graphicsDevice = graphicsConfiguration.getDevice();
            if (this.isFullScreenMode && graphicsDevice.isFullScreenSupported() && !Utilities.isMac() && !Utilities.isWindows()) {
                try {
                    graphicsDevice.setFullScreenWindow(null);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    LOGGER.log(Level.FINE, null, illegalArgumentException);
                }
            }
        }
        this.isFullScreenMode = bl;
        if (Utilities.isWindows()) {
            this.frame.setVisible(false);
        } else {
            WindowManagerImpl.getInstance().setVisible(false);
        }
        this.frame.dispose();
        this.frame.setUndecorated(this.isFullScreenMode || this.isUndecorated);
        this.frame.getRootPane().setWindowDecorationStyle(this.isFullScreenMode ? 0 : this.windowDecorationStyle);
        final String string = ToolbarPool.getDefault().getConfiguration();
        if (null != string && null != (toolbarConfiguration = ToolbarConfiguration.findConfiguration(string))) {
            toolbarConfiguration.rebuildMenu();
        }
        MainWindow.getToolbarComponent().setVisible(!this.isFullScreenMode);
        boolean bl3 = bl2 = !this.isFullScreenMode;
        if (bl2 || this.isFullScreenMode() && !Utilities.isWindows()) {
            if (bl2) {
                this.forcedBounds = this.restoreBounds;
            } else if (null != graphicsConfiguration) {
                this.forcedBounds = graphicsConfiguration.getBounds();
            } else {
                GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
                this.forcedBounds = graphicsEnvironment.getMaximumWindowBounds();
            }
        }
        if (null != graphicsDevice && graphicsDevice.isFullScreenSupported() && !Utilities.isWindows()) {
            graphicsDevice.setFullScreenWindow(this.isFullScreenMode ? this.frame : null);
        } else {
            this.frame.setExtendedState(this.isFullScreenMode ? 6 : this.restoreExtendedState);
        }
        if (Utilities.isWindows()) {
            this.frame.setVisible(true);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MainWindow.this.frame.invalidate();
                    MainWindow.this.frame.validate();
                    MainWindow.this.frame.repaint();
                    if (bl2) {
                        MainWindow.this.frame.setPreferredSize(MainWindow.this.restoreBounds.getSize());
                        MainWindow.this.frame.setBounds(MainWindow.this.restoreBounds);
                    }
                    ToolbarPool.getDefault().setConfiguration(string);
                    MainWindow.this.isSwitchingFullScreenMode = false;
                    if (null != topComponent) {
                        topComponent.requestFocusInWindow();
                    }
                }
            });
        } else {
            WindowManagerImpl.getInstance().setVisible(true);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MainWindow.this.frame.invalidate();
                    MainWindow.this.frame.validate();
                    MainWindow.this.frame.repaint();
                    ToolbarPool.getDefault().setConfiguration(string);
                    MainWindow.this.isSwitchingFullScreenMode = false;
                    if (null != topComponent) {
                        topComponent.requestFocusInWindow();
                    }
                }
            });
        }
    }

    public boolean isFullScreenMode() {
        return this.isFullScreenMode;
    }

    public JFrame getFrame() {
        return this.frame;
    }

    private static boolean isShowCustomBackground() {
        return UIManager.getBoolean("NbMainWindow.showCustomBackground");
    }

    static {
        LOGGER = Logger.getLogger(MainWindow.class.getName());
    }

    private static class HeavyWeightPopup
    extends Popup {
        public HeavyWeightPopup(Component component, Component component2, int n, int n2) {
            super(component, component2, n, n2);
        }
    }

    private static class HeavyWeightPopupFactory
    extends PopupFactory {
        private HeavyWeightPopupFactory() {
        }

        @Override
        public Popup getPopup(Component component, Component component2, int n, int n2) throws IllegalArgumentException {
            return new HeavyWeightPopup(component, component2, n, n2);
        }
    }

    private static class StatusLineElementsListener
    implements LookupListener {
        private JPanel decoratingPanel;

        StatusLineElementsListener(JPanel jPanel) {
            this.decoratingPanel = jPanel;
        }

        public void resultChanged(LookupEvent lookupEvent) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MainWindow.decoratePanel(StatusLineElementsListener.this.decoratingPanel, false);
                }
            });
        }
    }
}

