/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.actions;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import org.netbeans.core.windows.ModeImpl;
import org.netbeans.core.windows.TopComponentTracker;
import org.netbeans.core.windows.WindowManagerImpl;
import org.netbeans.core.windows.view.ui.popupswitcher.KeyboardPopupSwitcher;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;
import org.openide.windows.TopComponent;

public final class RecentViewListAction
extends AbstractAction
implements PropertyChangeListener {
    private final boolean documentsOnly;

    public RecentViewListAction() {
        this(false);
    }

    public static Action createDocumentsOnlyInstance() {
        return new RecentViewListAction(true);
    }

    private RecentViewListAction(boolean bl) {
        this.documentsOnly = bl;
        this.putValue("Name", NbBundle.getMessage(RecentViewListAction.class, (String)(bl ? "CTL_RecentViewListAction" : "CTL_RecentDocumentListAction")));
        TopComponent.getRegistry().addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)TopComponent.getRegistry()));
        this.updateEnabled();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        KeyStroke keyStroke;
        TopComponent[] topComponentArray;
        boolean bl;
        boolean bl2 = true;
        boolean bl3 = bl = !this.documentsOnly;
        if ("immediately".equals(actionEvent.getActionCommand()) && null != (topComponentArray = TopComponent.getRegistry().getActivated())) {
            if (TopComponentTracker.getDefault().isEditorTopComponent((TopComponent)topComponentArray)) {
                bl = false;
            } else {
                bl2 = false;
                bl = true;
            }
        }
        if ((topComponentArray = RecentViewListAction.getRecentWindows(bl2, bl)).length < 2) {
            return;
        }
        if (!"immediately".equals(actionEvent.getActionCommand()) && !(actionEvent.getSource() instanceof JMenuItem) && (keyStroke = Utilities.stringToKey((String)actionEvent.getActionCommand())) != null) {
            int n = keyStroke.getKeyCode();
            int n2 = 16;
            int n3 = 0;
            int n4 = keyStroke.getModifiers();
            if ((2 & n4) != 0) {
                n3 = 17;
            } else if ((8 & n4) != 0) {
                n3 = 18;
            } else if ((4 & n4) != 0) {
                n3 = 157;
            }
            if (n3 != 0) {
                if (!KeyboardPopupSwitcher.isShown()) {
                    KeyboardPopupSwitcher.showPopup(this.documentsOnly, n3, n, (actionEvent.getModifiers() & 1) == 0);
                }
                return;
            }
        }
        int n = (actionEvent.getModifiers() & 1) == 0 ? 1 : topComponentArray.length - 1;
        TopComponent topComponent = topComponentArray[n];
        WindowManagerImpl windowManagerImpl = WindowManagerImpl.getInstance();
        ModeImpl modeImpl = (ModeImpl)windowManagerImpl.findMode(topComponent);
        if (modeImpl != null && modeImpl != windowManagerImpl.getCurrentMaximizedMode()) {
            windowManagerImpl.switchMaximizedMode(null);
        }
        topComponent.requestActive();
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("opened".equals(propertyChangeEvent.getPropertyName())) {
            this.updateEnabled();
        }
    }

    public static String getStringRep4Unixes() {
        if (Utilities.isUnix() && !Utilities.isMac()) {
            return "Actions/Window/org-netbeans-core-windows-actions-RecentViewListAction.instance";
        }
        return null;
    }

    private void updateEnabled() {
        this.setEnabled(this.isMoreThanOneViewOpened());
    }

    private boolean isMoreThanOneViewOpened() {
        if (!this.documentsOnly) {
            return TopComponent.getRegistry().getOpened().size() > 1;
        }
        for (ModeImpl modeImpl : WindowManagerImpl.getInstance().getModes()) {
            if (modeImpl.getKind() != 1) continue;
            return modeImpl.getOpenedTopComponents().size() > 1;
        }
        return false;
    }

    private static TopComponent[] getRecentWindows(boolean bl, boolean bl2) {
        WindowManagerImpl windowManagerImpl = WindowManagerImpl.getInstance();
        TopComponent[] topComponentArray = windowManagerImpl.getRecentViewList();
        TopComponentTracker topComponentTracker = TopComponentTracker.getDefault();
        ArrayList<TopComponent> arrayList = new ArrayList<TopComponent>();
        for (int i = 0; i < topComponentArray.length; ++i) {
            ModeImpl modeImpl;
            TopComponent topComponent = topComponentArray[i];
            if (topComponent == null || (modeImpl = (ModeImpl)windowManagerImpl.findMode(topComponent)) == null || (!bl || !topComponentTracker.isEditorTopComponent(topComponent)) && (!bl2 || !topComponentTracker.isViewTopComponent(topComponent))) continue;
            arrayList.add(topComponent);
        }
        return arrayList.toArray(new TopComponent[0]);
    }
}

