/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.actions;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.Timer;
import org.netbeans.core.windows.ModeImpl;
import org.netbeans.core.windows.Switches;
import org.netbeans.core.windows.WindowManagerImpl;
import org.netbeans.core.windows.actions.ActionUtils;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;
import org.openide.windows.TopComponent;

public class CloseAllButThisAction
extends AbstractAction
implements PropertyChangeListener,
Runnable {
    private TopComponent tc;
    private boolean isContext;
    private Timer updateTimer;
    private final Object LOCK = new Object();

    public CloseAllButThisAction() {
        this.isContext = false;
        this.putValue("Name", NbBundle.getMessage(CloseAllButThisAction.class, (String)"CTL_CloseAllButThisAction_MainMenu"));
        this.updateTimer = new Timer(300, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CloseAllButThisAction.this.updateEnabled();
            }
        });
        this.updateTimer.setRepeats(false);
        TopComponent.getRegistry().addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)TopComponent.getRegistry()));
        this.updateEnabled();
    }

    public CloseAllButThisAction(TopComponent topComponent, boolean bl) {
        this.tc = topComponent;
        this.isContext = bl;
        this.putValue("Name", NbBundle.getMessage(CloseAllButThisAction.class, (String)"CTL_CloseAllButThisAction"));
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        TopComponent topComponent = this.obtainTC();
        if (topComponent != null) {
            ActionUtils.closeAllExcept(topComponent, this.isContext);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if ("activated".equals(string) || "opened".equals(string)) {
            this.scheduleUpdate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleUpdate() {
        Object object = this.LOCK;
        synchronized (object) {
            if (this.updateTimer.isRunning()) {
                this.updateTimer.restart();
            } else {
                this.updateTimer.start();
            }
        }
    }

    private void updateEnabled() {
        Mutex.EVENT.readAccess((Runnable)this);
    }

    @Override
    public void run() {
        TopComponent topComponent = this.obtainTC();
        WindowManagerImpl windowManagerImpl = WindowManagerImpl.getInstance();
        ModeImpl modeImpl = (ModeImpl)windowManagerImpl.findMode(topComponent);
        boolean bl = this.isContext ? modeImpl.getOpenedTopComponents().size() > 1 : windowManagerImpl.getEditorTopComponents().length > 1;
        this.setEnabled(modeImpl != null && modeImpl.getKind() == 1 && bl && Switches.isEditorTopComponentClosingEnabled());
    }

    private TopComponent obtainTC() {
        return this.tc == null ? TopComponent.getRegistry().getActivated() : this.tc;
    }

    @Override
    public void putValue(String string, Object object) {
        if ("AcceleratorKey".equals(string)) {
            ActionUtils.putSharedAccelerator("CloseAllButThis", object);
        } else {
            super.putValue(string, object);
        }
    }

    @Override
    public Object getValue(String string) {
        if ("AcceleratorKey".equals(string)) {
            return ActionUtils.getSharedAccelerator("CloseAllButThis");
        }
        return super.getValue(string);
    }
}

