/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.actions;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.netbeans.core.windows.ModeImpl;
import org.netbeans.core.windows.Switches;
import org.netbeans.core.windows.TopComponentTracker;
import org.netbeans.core.windows.WindowManagerImpl;
import org.netbeans.core.windows.actions.ActionsFactory;
import org.netbeans.core.windows.actions.CloseAllButThisAction;
import org.netbeans.core.windows.actions.CloseAllDocumentsAction;
import org.netbeans.core.windows.actions.CloseModeAction;
import org.netbeans.core.windows.actions.CloseWindowAction;
import org.netbeans.core.windows.actions.CollapseTabGroupAction;
import org.netbeans.core.windows.actions.DockModeAction;
import org.netbeans.core.windows.actions.DockWindowAction;
import org.netbeans.core.windows.actions.MaximizeWindowAction;
import org.netbeans.core.windows.actions.MinimizeModeAction;
import org.netbeans.core.windows.actions.MoveModeAction;
import org.netbeans.core.windows.actions.MoveWindowAction;
import org.netbeans.core.windows.actions.NewTabGroupAction;
import org.netbeans.core.windows.actions.ResizeModeAction;
import org.netbeans.core.windows.actions.UndockModeAction;
import org.netbeans.core.windows.actions.UndockWindowAction;
import org.netbeans.core.windows.view.ui.slides.SlideController;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.cookies.SaveCookie;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.actions.Presenter;
import org.openide.windows.TopComponent;

public abstract class ActionUtils {
    private static HashMap<Object, Object> sharedAccelerators = new HashMap();

    private ActionUtils() {
    }

    public static Action[] createDefaultPopupActions(TopComponent topComponent) {
        Action[] actionArray;
        ModeImpl modeImpl = ActionUtils.findMode(topComponent);
        int n = modeImpl != null ? modeImpl.getKind() : 1;
        TopComponentTracker topComponentTracker = TopComponentTracker.getDefault();
        boolean bl = topComponentTracker.isEditorTopComponent(topComponent);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (n == 1) {
            if (Switches.isClosingEnabled(topComponent) && (bl && Switches.isEditorTopComponentClosingEnabled() || !bl && Switches.isViewTopComponentClosingEnabled())) {
                arrayList.add(new CloseWindowAction(topComponent));
            }
            if (Switches.isEditorTopComponentClosingEnabled()) {
                arrayList.add(new CloseAllDocumentsAction(true));
                actionArray = new CloseAllButThisAction(topComponent, true);
                if (modeImpl != null && modeImpl.getOpenedTopComponents().size() == 1) {
                    actionArray.setEnabled(false);
                }
                arrayList.add(actionArray);
            }
            arrayList.add(null);
            if (Switches.isTopComponentMaximizationEnabled() && Switches.isMaximizationEnabled(topComponent)) {
                arrayList.add(new MaximizeWindowAction(topComponent));
            }
            if (Switches.isTopComponentUndockingEnabled() && Switches.isUndockingEnabled(topComponent)) {
                arrayList.add(new UndockWindowAction(topComponent));
            }
            if (Switches.isEditorModeUndockingEnabled() && bl) {
                arrayList.add(new UndockModeAction(modeImpl));
            }
            if (Switches.isTopComponentUndockingEnabled() && Switches.isUndockingEnabled(topComponent)) {
                arrayList.add(new DockWindowAction(topComponent));
            }
            if (Switches.isEditorModeUndockingEnabled() && bl) {
                arrayList.add(new DockModeAction(modeImpl, null));
            }
            if (bl) {
                arrayList.add(null);
                arrayList.add(new CloneDocumentAction(topComponent));
                arrayList.add(new NewTabGroupAction(topComponent));
                arrayList.add(new CollapseTabGroupAction(modeImpl));
            }
        } else if (n == 0) {
            if (Switches.isClosingEnabled(topComponent) && (bl && Switches.isEditorTopComponentClosingEnabled() || !bl && Switches.isViewTopComponentClosingEnabled())) {
                arrayList.add(new CloseWindowAction(topComponent));
            }
            if (Switches.isModeClosingEnabled()) {
                arrayList.add(new CloseModeAction(modeImpl));
            }
            arrayList.add(null);
            if (Switches.isTopComponentMaximizationEnabled() && Switches.isMaximizationEnabled(topComponent)) {
                arrayList.add(new MaximizeWindowAction(topComponent));
            }
            if (Switches.isTopComponentSlidingEnabled() && Switches.isSlidingEnabled(topComponent)) {
                arrayList.add(ActionUtils.createMinimizeWindowAction(topComponent));
            }
            if (Switches.isModeSlidingEnabled()) {
                arrayList.add(new MinimizeModeAction(modeImpl));
            }
            if (Switches.isTopComponentUndockingEnabled() && Switches.isUndockingEnabled(topComponent)) {
                arrayList.add(new UndockWindowAction(topComponent));
            }
            if (Switches.isViewModeUndockingEnabled()) {
                arrayList.add(new UndockModeAction(modeImpl));
            }
            if (Switches.isTopComponentUndockingEnabled() && Switches.isUndockingEnabled(topComponent)) {
                arrayList.add(new DockWindowAction(topComponent));
            }
            if (Switches.isViewModeUndockingEnabled()) {
                arrayList.add(new DockModeAction(modeImpl, null));
            }
            arrayList.add(null);
            arrayList.add(new MoveWindowAction(topComponent));
            arrayList.add(new MoveModeAction(modeImpl));
            arrayList.add(new ResizeModeAction(modeImpl));
            if (bl) {
                arrayList.add(null);
                arrayList.add(new CloneDocumentAction(topComponent));
            }
        } else if (n == 2) {
            if (Switches.isClosingEnabled(topComponent) && (bl && Switches.isEditorTopComponentClosingEnabled() || !bl && Switches.isViewTopComponentClosingEnabled())) {
                arrayList.add(new CloseWindowAction(topComponent));
            }
            if (Switches.isModeClosingEnabled()) {
                arrayList.add(new CloseModeAction(modeImpl));
            }
            arrayList.add(null);
            if (Switches.isTopComponentMaximizationEnabled() && Switches.isMaximizationEnabled(topComponent)) {
                arrayList.add(new MaximizeWindowAction(topComponent));
            }
            if (Switches.isTopComponentSlidingEnabled() && Switches.isSlidingEnabled(topComponent)) {
                arrayList.add(ActionUtils.createDisabledAction("CTL_MinimizeWindowAction"));
            }
            if (Switches.isModeSlidingEnabled()) {
                arrayList.add(ActionUtils.createDisabledAction("CTL_MinimizeModeAction"));
            }
            if (Switches.isTopComponentUndockingEnabled() && Switches.isUndockingEnabled(topComponent)) {
                arrayList.add(new UndockWindowAction(topComponent));
            }
            if (Switches.isViewModeUndockingEnabled()) {
                arrayList.add(ActionUtils.createDisabledAction("CTL_UndockModeAction"));
            }
            if (Switches.isTopComponentUndockingEnabled() && Switches.isUndockingEnabled(topComponent)) {
                arrayList.add(new DockWindowAction(topComponent));
            }
            if (Switches.isViewModeUndockingEnabled() || Switches.isModeSlidingEnabled()) {
                arrayList.add(new DockModeAction(ActionUtils.findPreviousMode(topComponent, modeImpl), modeImpl));
            }
            arrayList.add(null);
            arrayList.add(ActionUtils.createDisabledAction("CTL_MoveWindowAction"));
            arrayList.add(ActionUtils.createDisabledAction("CTL_MoveModeAction"));
            arrayList.add(ActionUtils.createDisabledAction("CTL_ResizeModeAction"));
            if (bl) {
                arrayList.add(null);
                arrayList.add(new CloneDocumentAction(topComponent));
            }
        }
        actionArray = arrayList.toArray(new Action[arrayList.size()]);
        for (ActionsFactory actionsFactory : Lookup.getDefault().lookupAll(ActionsFactory.class)) {
            actionArray = actionsFactory.createPopupActions(topComponent, actionArray);
        }
        return actionArray;
    }

    public static Action[] createDefaultPopupActions(ModeImpl modeImpl) {
        int n = modeImpl != null ? modeImpl.getKind() : 1;
        ArrayList<Action> arrayList = new ArrayList<Action>();
        if (n == 1) {
            if (Switches.isEditorTopComponentClosingEnabled()) {
                arrayList.add(ActionUtils.createDisabledAction("CTL_CloseWindowAction"));
                arrayList.add(new CloseAllDocumentsAction(true));
                arrayList.add(ActionUtils.createDisabledAction("CTL_CloseAllButThisAction"));
                arrayList.add(null);
            }
            arrayList.add(null);
            if (Switches.isTopComponentMaximizationEnabled()) {
                arrayList.add(ActionUtils.createDisabledAction("CTL_MaximizeWindowAction"));
            }
            if (Switches.isTopComponentUndockingEnabled()) {
                arrayList.add(ActionUtils.createDisabledAction("CTL_UndockWindowAction"));
            }
            if (Switches.isEditorModeUndockingEnabled()) {
                arrayList.add(new UndockModeAction(modeImpl));
            }
            if (Switches.isTopComponentUndockingEnabled()) {
                arrayList.add(ActionUtils.createDisabledAction("CTL_UndockWindowAction_Dock"));
            }
            if (Switches.isEditorModeUndockingEnabled()) {
                arrayList.add(new DockModeAction(modeImpl, null));
            }
            arrayList.add(null);
            arrayList.add(ActionUtils.createDisabledAction("CTL_CloneDocumentAction"));
            arrayList.add(ActionUtils.createDisabledAction("CTL_NewTabGroupAction"));
            arrayList.add(new CollapseTabGroupAction(modeImpl));
        } else if (n == 0) {
            if (Switches.isViewTopComponentClosingEnabled()) {
                arrayList.add(ActionUtils.createDisabledAction("CTL_CloseWindowAction"));
            }
            if (Switches.isModeClosingEnabled()) {
                arrayList.add(new CloseModeAction(modeImpl));
            }
            arrayList.add(null);
            if (Switches.isTopComponentMaximizationEnabled()) {
                arrayList.add(ActionUtils.createDisabledAction("CTL_MaximizeWindowAction"));
            }
            if (Switches.isTopComponentSlidingEnabled()) {
                arrayList.add(ActionUtils.createDisabledAction("LBL_AutoHideWindowAction"));
            }
            if (Switches.isModeSlidingEnabled()) {
                arrayList.add(new MinimizeModeAction(modeImpl));
            }
            if (Switches.isTopComponentUndockingEnabled()) {
                arrayList.add(ActionUtils.createDisabledAction("CTL_UndockWindowAction"));
            }
            if (Switches.isViewModeUndockingEnabled()) {
                arrayList.add(new UndockModeAction(modeImpl));
            }
            if (Switches.isTopComponentUndockingEnabled()) {
                arrayList.add(ActionUtils.createDisabledAction("CTL_UndockWindowAction_Dock"));
            }
            if (Switches.isViewModeUndockingEnabled()) {
                arrayList.add(new DockModeAction(modeImpl, null));
            }
            arrayList.add(null);
            arrayList.add(ActionUtils.createDisabledAction("CTL_MoveWindowAction"));
            arrayList.add(new MoveModeAction(modeImpl));
            arrayList.add(new ResizeModeAction(modeImpl));
        } else if (n == 2) {
            if (Switches.isViewTopComponentClosingEnabled()) {
                arrayList.add(ActionUtils.createDisabledAction("CTL_CloseWindowAction"));
                arrayList.add(new CloseModeAction(modeImpl));
            }
            if (modeImpl.getState() == 0 && Switches.isTopComponentMaximizationEnabled()) {
                arrayList.add(ActionUtils.createDisabledAction("CTL_MaximizeWindowAction"));
            }
            if (Switches.isTopComponentUndockingEnabled()) {
                arrayList.add(ActionUtils.createDisabledAction("CTL_UndockWindowAction"));
            }
        }
        Action[] actionArray = arrayList.toArray(new Action[arrayList.size()]);
        for (ActionsFactory actionsFactory : Lookup.getDefault().lookupAll(ActionsFactory.class)) {
            actionArray = actionsFactory.createPopupActions(modeImpl, actionArray);
        }
        return actionArray;
    }

    static Action createMinimizeWindowAction(TopComponent topComponent) {
        SlideController slideController = (SlideController)((Object)SwingUtilities.getAncestorOfClass(SlideController.class, (Component)topComponent));
        ModeImpl modeImpl = ActionUtils.findMode(topComponent);
        int n = null == modeImpl ? -1 : modeImpl.getOpenedTopComponents().indexOf(topComponent);
        boolean bl = WindowManagerImpl.getInstance().isTopComponentMinimized(topComponent);
        AutoHideWindowAction autoHideWindowAction = new AutoHideWindowAction(slideController, n, bl);
        autoHideWindowAction.setEnabled(null != modeImpl && modeImpl.getState() == 0);
        return autoHideWindowAction;
    }

    public static void closeAllDocuments(boolean bl) {
        if (bl) {
            TopComponent topComponent = TopComponent.getRegistry().getActivated();
            List<TopComponent> list = ActionUtils.getOpened(topComponent);
            ActionUtils.closeAll(list.toArray(new TopComponent[list.size()]));
        } else {
            TopComponent[] topComponentArray = WindowManagerImpl.getInstance().getEditorTopComponents();
            ActionUtils.closeAll(topComponentArray);
        }
    }

    private static void closeAll(TopComponent[] topComponentArray) {
        for (TopComponent topComponent : topComponentArray) {
            if (!Switches.isClosingEnabled(topComponent)) continue;
            final TopComponent topComponent2 = topComponent;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    topComponent2.putClientProperty((Object)"inCloseAll", (Object)Boolean.TRUE);
                    topComponent2.close();
                }
            });
        }
    }

    public static void closeAllExcept(TopComponent topComponent, boolean bl) {
        if (bl) {
            List<TopComponent> list = ActionUtils.getOpened(topComponent);
            for (TopComponent topComponent2 : list) {
                if (!Switches.isClosingEnabled(topComponent2) || topComponent2 == topComponent) continue;
                topComponent2.putClientProperty((Object)"inCloseAll", (Object)Boolean.TRUE);
                topComponent2.close();
            }
        } else {
            TopComponent[] topComponentArray;
            for (TopComponent topComponent3 : topComponentArray = WindowManagerImpl.getInstance().getEditorTopComponents()) {
                if (!Switches.isClosingEnabled(topComponent3) || topComponent3 == topComponent) continue;
                topComponent3.putClientProperty((Object)"inCloseAll", (Object)Boolean.TRUE);
                topComponent3.close();
            }
        }
    }

    private static List<TopComponent> getOpened(TopComponent topComponent) {
        ModeImpl modeImpl = ActionUtils.findMode(topComponent);
        ArrayList<TopComponent> arrayList = new ArrayList<TopComponent>();
        if (modeImpl != null) {
            arrayList.addAll(modeImpl.getOpenedTopComponents());
        }
        return arrayList;
    }

    static void closeWindow(TopComponent topComponent) {
        topComponent.close();
    }

    private static void saveDocument(TopComponent topComponent) {
        SaveCookie saveCookie = ActionUtils.getSaveCookie(topComponent);
        if (saveCookie != null) {
            try {
                saveCookie.save();
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
    }

    private static SaveCookie getSaveCookie(TopComponent topComponent) {
        Lookup lookup = topComponent.getLookup();
        Object object = lookup.lookup(SaveCookie.class);
        if (object instanceof SaveCookie) {
            return (SaveCookie)object;
        }
        return null;
    }

    static void cloneWindow(TopComponent topComponent) {
        if (topComponent instanceof TopComponent.Cloneable) {
            TopComponent topComponent2 = ((TopComponent.Cloneable)topComponent).cloneComponent();
            int n = -1;
            ModeImpl modeImpl = ActionUtils.findMode(topComponent);
            if (null != modeImpl) {
                TopComponent[] topComponentArray = modeImpl.getTopComponents();
                for (int i = 0; i < topComponentArray.length; ++i) {
                    if (topComponentArray[i] != topComponent) continue;
                    n = i + 1;
                    break;
                }
                if (n >= topComponentArray.length) {
                    n = -1;
                }
            }
            if (n >= 0) {
                topComponent2.openAtTabPosition(n);
            } else {
                topComponent2.open();
            }
            topComponent2.requestActive();
        }
    }

    static void putSharedAccelerator(Object object, Object object2) {
        sharedAccelerators.put(object, object2);
    }

    static Object getSharedAccelerator(Object object) {
        return sharedAccelerators.get(object);
    }

    private static Action createDisabledAction(String string) {
        return new DisabledAction(NbBundle.getMessage(ActionUtils.class, (String)string));
    }

    static ModeImpl findMode(TopComponent topComponent) {
        TopComponent topComponent2;
        WindowManagerImpl windowManagerImpl = WindowManagerImpl.getInstance();
        ModeImpl modeImpl = (ModeImpl)windowManagerImpl.findMode(topComponent);
        if (null == modeImpl && null != (topComponent2 = (TopComponent)SwingUtilities.getAncestorOfClass(TopComponent.class, (Component)topComponent))) {
            modeImpl = (ModeImpl)windowManagerImpl.findMode(topComponent2);
        }
        return modeImpl;
    }

    private static ModeImpl findPreviousMode(TopComponent topComponent, ModeImpl modeImpl) {
        ModeImpl modeImpl2 = null;
        WindowManagerImpl windowManagerImpl = WindowManagerImpl.getInstance();
        String string = windowManagerImpl.findTopComponentID(topComponent);
        if (null != string) {
            modeImpl2 = windowManagerImpl.getPreviousModeForTopComponent(string, modeImpl);
        }
        return modeImpl2;
    }

    private static class DisabledAction
    extends AbstractAction {
        private DisabledAction(String string) {
            super(string);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
        }

        @Override
        public boolean isEnabled() {
            return false;
        }
    }

    private static class CloneDocumentAction
    extends AbstractAction {
        private final TopComponent tc;

        public CloneDocumentAction(TopComponent topComponent) {
            this.tc = topComponent;
            this.putValue("Name", NbBundle.getMessage(ActionUtils.class, (String)"LBL_CloneDocumentAction"));
            this.putValue("_nb_action_id_", "clone");
            this.setEnabled(topComponent instanceof TopComponent.Cloneable);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ActionUtils.cloneWindow(this.tc);
        }
    }

    public static final class ToggleWindowTransparencyAction
    extends AbstractAction {
        public ToggleWindowTransparencyAction(SlideController slideController, int n, boolean bl) {
            this.putValue("Name", NbBundle.getMessage(ActionUtils.class, (String)"LBL_ToggleWindowTransparencyAction"));
        }

        public HelpCtx getHelpCtx() {
            return null;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(ActionUtils.class, (String)"LBL_WindowTransparencyHint"), 1));
        }
    }

    public static final class AutoHideWindowAction
    extends AbstractAction
    implements Presenter.Popup {
        private final SlideController slideController;
        private final int tabIndex;
        private boolean state;
        private JCheckBoxMenuItem menuItem;

        public AutoHideWindowAction(SlideController slideController, int n, boolean bl) {
            this.slideController = slideController;
            this.tabIndex = n;
            this.state = bl;
            this.putValue("Name", NbBundle.getMessage(ActionUtils.class, (String)"LBL_AutoHideWindowAction"));
        }

        public HelpCtx getHelpCtx() {
            return null;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.state = !this.state;
            this.getMenuItem().setSelected(this.state);
            this.slideController.userToggledAutoHide(this.tabIndex, this.state);
        }

        public JMenuItem getPopupPresenter() {
            return this.getMenuItem();
        }

        private JCheckBoxMenuItem getMenuItem() {
            if (this.menuItem == null) {
                this.menuItem = new JCheckBoxMenuItem("", this.state);
                Mnemonics.setLocalizedText((AbstractButton)this.menuItem, (String)((String)this.getValue("Name")));
                this.menuItem.setAccelerator(KeyStroke.getKeyStroke(8, 128));
                this.menuItem.addActionListener(this);
                this.menuItem.setEnabled(this.isEnabled());
            }
            return this.menuItem;
        }
    }
}

