/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.tabcontrol;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.DefaultButtonModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.table.TableCellRenderer;
import org.netbeans.swing.popupswitcher.SwitcherTable;
import org.netbeans.swing.popupswitcher.SwitcherTableItem;
import org.netbeans.swing.tabcontrol.TabData;
import org.netbeans.swing.tabcontrol.TabDisplayer;
import org.netbeans.swing.tabcontrol.event.TabActionEvent;
import org.openide.awt.CloseButtonFactory;

class DocumentSwitcherTable
extends SwitcherTable {
    private final JButton btnClose;
    private final TabDisplayer displayer;
    private int lastRow = -1;
    private int lastCol = -1;
    private boolean inCloseButtonRect = false;

    public DocumentSwitcherTable(TabDisplayer tabDisplayer, SwitcherTableItem[] switcherTableItemArray, int n) {
        super(switcherTableItemArray, n);
        this.displayer = tabDisplayer;
        this.btnClose = this.createCloseButton();
        ToolTipManager.sharedInstance().registerComponent(this);
    }

    @Override
    public Component prepareRenderer(TableCellRenderer tableCellRenderer, int n, int n2) {
        SwitcherTableItem switcherTableItem = (SwitcherTableItem)this.getModel().getValueAt(n, n2);
        boolean bl = n == this.getSelectedRow() && n2 == this.getSelectedColumn() && switcherTableItem != null;
        Component component = super.prepareRenderer(tableCellRenderer, n, n2);
        if (bl) {
            JPanel jPanel = new JPanel(new BorderLayout(5, 0));
            jPanel.add(component, "Center");
            jPanel.add((Component)this.btnClose, "East");
            jPanel.setBackground(component.getBackground());
            return jPanel;
        }
        return component;
    }

    boolean onMouseEvent(MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        point = SwingUtilities.convertPoint((Component)mouseEvent.getSource(), point, this);
        int n = this.getSelectedRow();
        int n2 = this.getSelectedColumn();
        if (n < 0 || n2 < 0) {
            return false;
        }
        Rectangle rectangle = this.getCellRect(n, n2, false);
        if (rectangle.contains(point)) {
            Dimension dimension = this.btnClose.getPreferredSize();
            int n3 = rectangle.x + rectangle.width - dimension.width;
            int n4 = rectangle.y + (rectangle.height - dimension.height) / 2;
            Rectangle rectangle2 = new Rectangle(n3, n4, dimension.width, dimension.height);
            boolean bl = rectangle2.contains(point);
            boolean bl2 = this.inCloseButtonRect != bl;
            this.inCloseButtonRect = bl;
            if (bl && mouseEvent.getID() == 501) {
                Item item = (Item)this.getModel().getValueAt(n, n2);
                TabData tabData = item.getTabData();
                int n5 = this.displayer.getModel().indexOf(tabData);
                if (n5 >= 0) {
                    TabActionEvent tabActionEvent = new TabActionEvent((Object)this.displayer, "close", n5);
                    this.displayer.postActionEvent(tabActionEvent);
                    return true;
                }
            }
            if (bl2 && this.lastRow == n && this.lastCol == n2) {
                this.repaint(rectangle2);
            }
            this.lastCol = n2;
            this.lastRow = n;
            return bl;
        }
        return false;
    }

    @Override
    public String getToolTipText(MouseEvent mouseEvent) {
        int n = this.rowAtPoint(mouseEvent.getPoint());
        int n2 = this.columnAtPoint(mouseEvent.getPoint());
        if (n >= 0 && n2 <= 0) {
            SwitcherTableItem switcherTableItem = (SwitcherTableItem)this.getModel().getValueAt(n, n2);
            return switcherTableItem.getDescription();
        }
        return null;
    }

    private JButton createCloseButton() {
        Icon icon;
        JButton jButton = CloseButtonFactory.createBigCloseButton();
        jButton.setModel(new DefaultButtonModel(){

            @Override
            public boolean isRollover() {
                return DocumentSwitcherTable.this.inCloseButtonRect;
            }
        });
        Icon icon2 = UIManager.getIcon("nb.popupswitcher.closebutton.defaultIcon");
        if (null != icon2) {
            jButton.setIcon(icon2);
        }
        if (null != (icon = UIManager.getIcon("nb.popupswitcher.closebutton.rolloverIcon"))) {
            jButton.setRolloverIcon(icon);
        }
        return jButton;
    }

    static class Item
    extends SwitcherTableItem {
        private final TabData tabData;

        public Item(SwitcherTableItem.Activatable activatable, String string, String string2, TabData tabData, boolean bl) {
            super(activatable, string, string2, tabData.getIcon(), bl, tabData.getTooltip());
            this.tabData = tabData;
        }

        public TabData getTabData() {
            return this.tabData;
        }
    }
}

