/*
 * Decompiled with CFR 0.152.
 */
package org.openide.awt;

import java.awt.EventQueue;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.util.Collection;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JToggleButton;
import org.openide.awt.Actions;
import org.openide.awt.Mnemonics;
import org.openide.util.ContextAwareAction;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbPreferences;
import org.openide.util.WeakListeners;
import org.openide.util.WeakSet;
import org.openide.util.actions.ActionInvoker;
import org.openide.util.actions.Presenter;

class AlwaysEnabledAction
extends AbstractAction
implements PropertyChangeListener,
ContextAwareAction {
    private static final Logger LOG = Logger.getLogger(AlwaysEnabledAction.class.getName());
    private static final String PREFERENCES_NODE = "preferencesNode";
    private static final String PREFERENCES_KEY = "preferencesKey";
    private static final String PREFERENCES_DEFAULT = "preferencesDefault";
    final Map map;
    private final AlwaysEnabledAction parent;
    private PropertyChangeListener weakL;
    ActionListener delegate;
    final Lookup context;
    final Object equals;

    static AlwaysEnabledAction create(Map map) {
        return map.containsKey(PREFERENCES_KEY) ? new CheckBox(map) : new AlwaysEnabledAction(map);
    }

    public AlwaysEnabledAction(Map map) {
        this.map = map;
        this.context = null;
        this.equals = this;
        this.parent = null;
    }

    AlwaysEnabledAction(Map map, AlwaysEnabledAction alwaysEnabledAction, Lookup lookup, Object object) {
        this.map = map;
        this.parent = alwaysEnabledAction;
        this.context = lookup;
        this.equals = object;
    }

    private static ActionListener bindToContext(ActionListener actionListener, Lookup lookup) {
        if (lookup != null && actionListener instanceof ContextAwareAction) {
            return ((ContextAwareAction)actionListener).createContextAwareInstance(lookup);
        }
        return actionListener;
    }

    protected ActionListener getDelegate() {
        if (this.delegate == null) {
            ActionListener actionListener;
            Object object;
            if (this.parent == null) {
                object = this.map.get("delegate");
                if (!(object instanceof ActionListener)) {
                    throw new NullPointerException("No 'delegate' in " + this.map);
                }
                actionListener = (ActionListener)object;
            } else {
                actionListener = this.parent.getDelegate();
            }
            this.delegate = AlwaysEnabledAction.bindToContext(actionListener, this.context);
            if (this.delegate instanceof Action) {
                object = (Action)this.delegate;
                if (this.weakL == null) {
                    this.weakL = WeakListeners.propertyChange((PropertyChangeListener)this, object);
                }
                object.addPropertyChangeListener(this.weakL);
                this.syncActionDelegateProperty("Name", (Action)object);
            }
        }
        return this.delegate;
    }

    private void syncActionDelegateProperty(String string, Action action) {
        Object object = AlwaysEnabledAction.extractCommonAttribute(this.map, string);
        Object object2 = action.getValue(string);
        if (object != null) {
            if (object2 == null) {
                action.putValue(string, object);
            } else if (!object2.equals(object)) {
                LOG.log(Level.FINE, "Value of property \"{0}\" of AlwaysEnabledAction is \"{1}\" but delegate {2} has \"{3}\"", new Object[]{string, object, this.delegate, object2});
            }
        }
    }

    @Override
    public boolean isEnabled() {
        if (this.delegate instanceof Action) {
            return ((Action)this.delegate).isEnabled();
        }
        return true;
    }

    @Override
    public void actionPerformed(final ActionEvent actionEvent) {
        assert (EventQueue.isDispatchThread());
        if (this.getDelegate() instanceof Action && !((Action)this.getDelegate()).isEnabled()) {
            Toolkit.getDefaultToolkit().beep();
            this.firePropertyChange("enabled", null, this.isEnabled());
            return;
        }
        boolean bl = Boolean.TRUE.equals(this.map.get("asynchronous"));
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                AlwaysEnabledAction.this.getDelegate().actionPerformed(actionEvent);
            }
        };
        ActionInvoker.invokeAction((Action)this, (ActionEvent)actionEvent, (boolean)bl, (Runnable)runnable);
    }

    @Override
    public Object getValue(String string) {
        Object object;
        if (this.delegate instanceof Action) {
            object = ((Action)this.delegate).getValue(string);
            if (object != null) {
                return object;
            }
            if ("iconBase".equals(string) && ((Action)this.delegate).getValue("SmallIcon") != null) {
                return null;
            }
        }
        return (object = AlwaysEnabledAction.extractCommonAttribute(this.map, string)) != null ? object : super.getValue(string);
    }

    static final Object extractCommonAttribute(Map map, String string) {
        try {
            if ("Name".equals(string)) {
                String string2 = (String)map.get("displayName");
                return string2;
            }
            if ("MnemonicKey".equals(string)) {
                String string3 = (String)map.get("displayName");
                int n = Mnemonics.findMnemonicAmpersand(string3);
                if (n == -1) {
                    return null;
                }
                int n2 = string3.charAt(n + 1);
                if (n2 >= 97 && n2 <= 122) {
                    n2 -= 32;
                }
                return n2;
            }
            if ("SmallIcon".equals(string)) {
                Image image;
                Image image2 = image = map == null ? null : (Image)map.get("iconBase");
                if (image instanceof Icon) {
                    return (Icon)((Object)image);
                }
                if (image instanceof URL) {
                    image = Toolkit.getDefaultToolkit().getImage((URL)((Object)image));
                }
                if (image instanceof Image) {
                    return ImageUtilities.image2Icon((Image)image);
                }
                if (image instanceof String) {
                    return ImageUtilities.loadImageIcon((String)((String)((Object)image)), (boolean)true);
                }
            }
            if ("iconBase".equals(string)) {
                return map == null ? null : map.get("iconBase");
            }
            if ("noIconInMenu".equals(string)) {
                return map == null ? null : map.get("noIconInMenu");
            }
            if (!"delegate".equals(string) && !"instanceCreate".equals(string)) {
                return map == null ? null : map.get(string);
            }
        }
        catch (RuntimeException runtimeException) {
            LOG.log(Level.WARNING, "Could not get action attribute " + string, runtimeException);
        }
        return null;
    }

    public int hashCode() {
        if (this.equals == this) {
            return super.hashCode();
        }
        return this.equals.hashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof AlwaysEnabledAction) {
            AlwaysEnabledAction alwaysEnabledAction = (AlwaysEnabledAction)object;
            if (this == this.equals && alwaysEnabledAction == alwaysEnabledAction.equals) {
                return this == alwaysEnabledAction;
            }
            if (this.equals.equals(alwaysEnabledAction.equals)) {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return "AlwaysEnabledAction[" + this.getValue("Name") + "]";
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getSource() == this.delegate) {
            this.firePropertyChange(propertyChangeEvent.getPropertyName(), propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
        }
    }

    public Action createContextAwareInstance(Lookup lookup) {
        return new AlwaysEnabledAction(this.map, this, lookup, this.equals);
    }

    static class DefaultIconToggleButton
    extends JToggleButton {
        private Icon unknownIcon;

        DefaultIconToggleButton() {
        }

        @Override
        public Icon getIcon() {
            Icon icon = super.getIcon();
            if (null == icon && (null == this.getText() || this.getText().isEmpty())) {
                if (this.unknownIcon == null) {
                    this.unknownIcon = ImageUtilities.loadImageIcon((String)"org/openide/awt/resources/unknown.gif", (boolean)false);
                }
                icon = this.unknownIcon;
            }
            return icon;
        }
    }

    static final class CheckBox
    extends AlwaysEnabledAction
    implements Presenter.Menu,
    Presenter.Popup,
    Presenter.Toolbar,
    PreferenceChangeListener,
    LookupListener {
        private static final long serialVersionUID = 1L;
        private static final ActionListener EMPTY = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
            }
        };
        private JCheckBoxMenuItem menuItem;
        private JCheckBoxMenuItem popupItem;
        private WeakSet<AbstractButton> toolbarItems;
        private Preferences preferencesNode;
        private Lookup.Result<Preferences> preferencesNodeResult;
        private boolean prefsListening;

        CheckBox(Map map) {
            super(map);
        }

        CheckBox(Map map, AlwaysEnabledAction alwaysEnabledAction, Lookup lookup, Object object) {
            super(map, alwaysEnabledAction, lookup, object);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.togglePreferencesSelected();
            super.actionPerformed(actionEvent);
        }

        public JMenuItem getMenuPresenter() {
            if (this.menuItem == null) {
                this.menuItem = new JCheckBoxMenuItem();
                this.menuItem.setSelected(this.isPreferencesSelected());
                Actions.connect((JMenuItem)this.menuItem, this, false);
            }
            return this.menuItem;
        }

        public JMenuItem getPopupPresenter() {
            if (this.popupItem == null) {
                this.popupItem = new JCheckBoxMenuItem();
                this.popupItem.setSelected(this.isPreferencesSelected());
                Actions.connect((JMenuItem)this.popupItem, this, true);
            }
            return this.popupItem;
        }

        public AbstractButton getToolbarPresenter() {
            if (this.toolbarItems == null) {
                this.toolbarItems = new WeakSet(4);
            }
            DefaultIconToggleButton defaultIconToggleButton = new DefaultIconToggleButton();
            this.toolbarItems.add((Object)defaultIconToggleButton);
            defaultIconToggleButton.setSelected(this.isPreferencesSelected());
            Actions.connect((AbstractButton)defaultIconToggleButton, this);
            return defaultIconToggleButton;
        }

        @Override
        public void preferenceChange(PreferenceChangeEvent preferenceChangeEvent) {
            this.updateItemsSelected();
        }

        @Override
        protected ActionListener getDelegate() {
            return EMPTY;
        }

        @Override
        public Action createContextAwareInstance(Lookup lookup) {
            return new CheckBox(this.map, this, lookup, this.equals);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean isPreferencesSelected() {
            boolean bl;
            String string = (String)this.getValue(AlwaysEnabledAction.PREFERENCES_KEY);
            Preferences preferences = this.prefs();
            if (string != null && preferences != null) {
                Object object = this.getValue(AlwaysEnabledAction.PREFERENCES_DEFAULT);
                bl = preferences.getBoolean(string, object instanceof Boolean ? (Boolean)object : false);
                CheckBox checkBox = this;
                synchronized (checkBox) {
                    if (!this.prefsListening) {
                        this.prefsListening = true;
                        preferences.addPreferenceChangeListener(this);
                    }
                }
            } else {
                bl = false;
            }
            return bl;
        }

        private void updateItemsSelected() {
            boolean bl = this.isPreferencesSelected();
            if (this.menuItem != null) {
                this.menuItem.setSelected(bl);
            }
            if (this.popupItem != null) {
                this.popupItem.setSelected(bl);
            }
            if (this.toolbarItems != null) {
                for (AbstractButton abstractButton : this.toolbarItems) {
                    abstractButton.setSelected(bl);
                }
            }
        }

        private synchronized Preferences prefs() {
            if (this.preferencesNode == null) {
                Object object = this.getValue(AlwaysEnabledAction.PREFERENCES_NODE);
                if (object instanceof String) {
                    String string = (String)object;
                    if (string.startsWith("system:")) {
                        this.preferencesNode = Preferences.systemRoot();
                        if (this.preferencesNode != null) {
                            string = string.substring("system:".length());
                            try {
                                this.preferencesNode = this.preferencesNode.nodeExists(string) ? this.preferencesNode.node(string) : null;
                            }
                            catch (BackingStoreException backingStoreException) {
                                this.preferencesNode = null;
                            }
                        }
                    } else if (string.startsWith("user:")) {
                        this.preferencesNode = Preferences.userRoot();
                        if (this.preferencesNode != null) {
                            string = string.substring("user:".length());
                            try {
                                this.preferencesNode = this.preferencesNode.nodeExists(string) ? this.preferencesNode.node(string) : null;
                            }
                            catch (BackingStoreException backingStoreException) {
                                this.preferencesNode = null;
                            }
                        }
                    } else {
                        this.preferencesNode = NbPreferences.root();
                        if (this.preferencesNode != null) {
                            try {
                                this.preferencesNode = this.preferencesNode.nodeExists(string) ? this.preferencesNode.node(string) : null;
                            }
                            catch (BackingStoreException backingStoreException) {
                                this.preferencesNode = null;
                            }
                        }
                    }
                } else if (object instanceof Preferences) {
                    this.preferencesNode = (Preferences)object;
                } else {
                    if (object instanceof Lookup) {
                        Lookup lookup = (Lookup)object;
                        this.preferencesNodeResult = lookup.lookupResult(Preferences.class);
                        Collection collection = this.preferencesNodeResult.allInstances();
                        if (collection.size() > 0) {
                            this.preferencesNode = (Preferences)collection.iterator().next();
                            this.preferencesNodeResult.addLookupListener((LookupListener)this);
                        }
                        return (Preferences)lookup.lookup(Preferences.class);
                    }
                    this.preferencesNode = null;
                }
            }
            return this.preferencesNode;
        }

        public void resultChanged(LookupEvent lookupEvent) {
            this.preferencesNode = null;
            this.preferencesNodeResult = null;
            this.updateItemsSelected();
        }

        private void togglePreferencesSelected() {
            String string = (String)this.getValue(AlwaysEnabledAction.PREFERENCES_KEY);
            Preferences preferences = this.prefs();
            if (string != null && preferences != null) {
                Object object = this.getValue(AlwaysEnabledAction.PREFERENCES_DEFAULT);
                preferences.putBoolean(string, !preferences.getBoolean(string, object instanceof Boolean ? (Boolean)object : false));
            }
        }
    }
}

