/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.console.ui.notification.uicomponents;

import com.jrockit.mc.console.ui.notification.uicomponents.FieldFocusListener;
import com.jrockit.mc.console.ui.notification.uicomponents.InputItem;
import com.jrockit.mc.rjmx.triggers.fields.internal.Field;
import com.jrockit.mc.ui.uibuilder.IUIBuilder;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Text;

public class TextInputItem
extends InputItem
implements Field.FieldValueChangeListener {
    private Text m_text;

    public TextInputItem(Field field, IUIBuilder builder) {
        super(field, builder);
    }

    protected Text getText() {
        return this.m_text;
    }

    @Override
    protected void create() {
        this.createUI();
        this.addListeners();
    }

    protected void createUI() {
        this.getUIBuilder().createLabel(String.valueOf(this.getField().getName()) + ":", this.getField().getDescription());
        this.m_text = this.getUIBuilder().createText(this.getField().getValue(), this.getField().getDescription(), 0);
        this.getUIBuilder().layout();
    }

    protected void addListeners() {
        this.getField().addFieldValueListener((Field.FieldValueChangeListener)this);
        this.getText().addFocusListener((FocusListener)this.createFieldFocusListener());
        this.getText().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                TextInputItem.this.getField().removeFieldValueListener((Field.FieldValueChangeListener)TextInputItem.this);
            }
        });
        this.getText().addModifyListener(new ModifyListener(){
            private Color m_defaultColor = null;

            public void modifyText(ModifyEvent e) {
                if (this.m_defaultColor == null) {
                    this.m_defaultColor = TextInputItem.this.m_text.getForeground();
                }
                if (!TextInputItem.this.getField().validateValue(TextInputItem.this.m_text.getText())) {
                    TextInputItem.this.getText().setForeground(JFaceColors.getErrorText((Display)TextInputItem.this.getText().getDisplay()));
                } else {
                    TextInputItem.this.getText().setForeground(this.m_defaultColor);
                }
            }
        });
    }

    protected FieldFocusListener createFieldFocusListener() {
        return new FieldFocusListener(this.getText(), this.getField());
    }

    public void onChange(Field freshField) {
        this.getText().setText(this.getField().getValue());
    }
}

