/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.console.ui.notification.uicomponents;

import com.jrockit.mc.console.ui.notification.uicomponents.FieldFocusListener;
import com.jrockit.mc.console.ui.notification.uicomponents.Messages;
import com.jrockit.mc.console.ui.notification.uicomponents.TextInputItem;
import com.jrockit.mc.core.CorePlugin;
import com.jrockit.mc.core.MCFile;
import com.jrockit.mc.rjmx.triggers.fields.internal.Field;
import com.jrockit.mc.ui.uibuilder.IUIBuilder;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Text;

public class FileInputItem
extends TextInputItem {
    private Text m_text;
    private Button m_browseButton;

    public FileInputItem(Field field, IUIBuilder builder) {
        super(field, builder);
    }

    @Override
    protected Text getText() {
        return this.m_text;
    }

    Button getBrowseButton() {
        return this.m_browseButton;
    }

    @Override
    protected void create() {
        this.createUI();
        this.addListeners();
    }

    @Override
    protected void addListeners() {
        this.getText().addFocusListener((FocusListener)new FieldFocusListener(this.m_text, this.getField()));
        this.getBrowseButton().addSelectionListener((SelectionListener)new BrowseSelectionListener());
        final Field.FieldValueChangeListener listener = new Field.FieldValueChangeListener(){

            public void onChange(Field field) {
                FileInputItem.this.getText().setText(field.getFileName());
            }
        };
        this.getField().addFieldValueListener(listener);
        this.m_text.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                FileInputItem.this.getField().removeFieldValueListener(listener);
            }
        });
    }

    @Override
    protected void createUI() {
        this.getUIBuilder().createLabel(String.valueOf(this.getField().getName()) + ":", "");
        this.m_text = this.getUIBuilder().createText(this.getField().getValue(), this.getField().getDescription(), 0);
        this.m_browseButton = this.getUIBuilder().createButton(Messages.FileInputItem_BUTTON_BROWSE_TEXT, Messages.FileInputItem_BUTTON_BROWSE_TOOLTIP);
        this.getUIBuilder().layout();
    }

    private final class BrowseSelectionListener
    implements SelectionListener {
        public void widgetSelected(SelectionEvent e) {
            MCFile path = this.onBrowse();
            if (path != null) {
                FileInputItem.this.getField().setValue(path.getPath().toOSString());
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        protected MCFile onBrowse() {
            String filename = FileInputItem.this.getField().getFileName();
            return CorePlugin.getDefault().getIDESupport().browseForSaveAsFile(NLS.bind((String)Messages.FileInputItem_SELECT_FIELD_TEXT, (Object)FileInputItem.this.getField().getName()), this.getFilename(filename), this.getContainerPath(filename), this.getFileExtension(filename), "");
        }

        private String getFilename(String filename) {
            int index = filename.lastIndexOf(46);
            if (index >= 0) {
                return filename.substring(0, index);
            }
            return filename;
        }

        private IPath getContainerPath(String filename) {
            return new Path(filename).removeLastSegments(1);
        }

        private String getFileExtension(String filename) {
            int index = filename.lastIndexOf(46);
            if (index >= 0) {
                return filename.substring(index + 1);
            }
            return "";
        }
    }
}

