/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.api.java;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.netbeans.lib.profiler.classfile.ClassFileParser;
import org.netbeans.lib.profiler.classfile.ClassInfo;
import org.netbeans.modules.profiler.api.java.SourceClassInfo;
import org.netbeans.modules.profiler.api.java.SourceMethodInfo;
import org.netbeans.modules.profiler.api.java.SourcePackageInfo;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public final class ExternalPackages {
    private static final Comparator<FileObject> pathComparator = new Comparator<FileObject>(){

        @Override
        public int compare(FileObject fileObject, FileObject fileObject2) {
            return fileObject.getPath().compareTo(fileObject2.getPath());
        }
    };

    public static List<SourcePackageInfo> forPath(FileObject fileObject) {
        FileObject fileObject2 = null;
        if (fileObject.getExt().equalsIgnoreCase("jar")) {
            if (FileUtil.isArchiveFile((FileObject)fileObject)) {
                fileObject2 = FileUtil.getArchiveRoot((FileObject)fileObject);
            }
        } else if (fileObject.isFolder()) {
            fileObject2 = fileObject;
        }
        if (fileObject != null) {
            Object object;
            Object object2;
            LinkedList<FileObject> linkedList = new LinkedList<FileObject>();
            TreeSet<FileObject> treeSet = new TreeSet<FileObject>(pathComparator);
            HashSet<String> hashSet = new HashSet<String>();
            linkedList.offer(fileObject2);
            while (!linkedList.isEmpty()) {
                object2 = (FileObject)linkedList.poll();
                if (object2 == null) continue;
                if (object2.isData() && object2.getExt().equalsIgnoreCase("class")) {
                    object = object2.getParent().getPath();
                    int n = ((String)object).lastIndexOf(47);
                    while (n > -1) {
                        hashSet.add((String)object);
                        object = ((String)object).substring(0, n);
                        n = ((String)object).lastIndexOf(47);
                    }
                    hashSet.add((String)object);
                    continue;
                }
                linkedList.addAll(Arrays.asList(object2.getChildren()));
            }
            object2 = fileObject2.getFolders(false);
            while (object2.hasMoreElements()) {
                object = (FileObject)object2.nextElement();
                if (!hashSet.contains(object.getPath())) continue;
                treeSet.add((FileObject)object);
            }
            object = new ArrayList(treeSet.size());
            for (FileObject fileObject3 : treeSet) {
                object.add(new FilePackageInfo(fileObject2, fileObject3, hashSet));
            }
            return object;
        }
        return Collections.EMPTY_LIST;
    }

    private static class FileMethodInfo
    extends SourceMethodInfo {
        private static int getModifiers(ClassInfo classInfo, int n) {
            int n2 = 0;
            if (classInfo.isMethodAbstract(n)) {
                n2 += 1024;
            }
            if (classInfo.isMethodPrivate(n)) {
                n2 += 2;
            }
            if (classInfo.isMethodProtected(n)) {
                n2 += 4;
            }
            if (classInfo.isMethodPublic(n)) {
                ++n2;
            }
            if (classInfo.isMethodFinal(n)) {
                n2 += 16;
            }
            if (classInfo.isMethodStatic(n)) {
                n2 += 8;
            }
            if (classInfo.isMethodNative(n)) {
                n2 += 256;
            }
            return n2;
        }

        public FileMethodInfo(ClassInfo classInfo, int n) {
            super(classInfo.getName().replace('/', '.'), classInfo.getMethodName(n), classInfo.getMethodSignature(n), classInfo.getMethodName(n), false, FileMethodInfo.getModifiers(classInfo, n));
        }
    }

    private static class PlainClassInfo
    extends SourceClassInfo {
        PlainClassInfo(String string) {
            super(string, string, string);
        }

        @Override
        public FileObject getFile() {
            return null;
        }

        @Override
        public Set<SourceMethodInfo> getMethods(boolean bl) {
            return Collections.EMPTY_SET;
        }

        @Override
        public Set<SourceClassInfo> getSubclasses() {
            return Collections.EMPTY_SET;
        }

        @Override
        public Set<SourceClassInfo> getInnerClases() {
            return Collections.EMPTY_SET;
        }

        @Override
        public Set<SourceMethodInfo> getConstructors() {
            return Collections.EMPTY_SET;
        }

        @Override
        public SourceClassInfo getSuperType() {
            return new PlainClassInfo("");
        }

        @Override
        public Set<SourceClassInfo> getInterfaces() {
            return Collections.EMPTY_SET;
        }
    }

    private static class FileClassInfo
    extends SourceClassInfo {
        private FileObject root;
        private FileObject clazz;
        private ClassInfo ci;

        public FileClassInfo(ClassInfo classInfo, FileObject fileObject, FileObject fileObject2) {
            super(fileObject2.getName(), FileUtil.getRelativePath((FileObject)fileObject, (FileObject)fileObject2).replace('/', '.').replace(".class", ""), FileUtil.getRelativePath((FileObject)fileObject, (FileObject)fileObject2).replace(".class", ""));
            this.ci = classInfo;
            this.clazz = fileObject2;
            this.root = fileObject;
        }

        @Override
        public Set<SourceMethodInfo> getConstructors() {
            String[] stringArray = this.ci.getMethodNames();
            HashSet<SourceMethodInfo> hashSet = new HashSet<SourceMethodInfo>();
            if (stringArray != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    if (!stringArray[i].equals("<init>")) continue;
                    hashSet.add(new FileMethodInfo(this.ci, i));
                }
            }
            return hashSet;
        }

        @Override
        public FileObject getFile() {
            return this.clazz;
        }

        @Override
        public Set<SourceClassInfo> getInnerClases() {
            HashSet<SourceClassInfo> hashSet = new HashSet<SourceClassInfo>();
            ClassFileParser classFileParser = new ClassFileParser();
            Enumeration enumeration = this.clazz.getParent().getData(false);
            while (enumeration.hasMoreElements()) {
                final FileObject fileObject = (FileObject)enumeration.nextElement();
                if (!fileObject.getName().contains("$") || !fileObject.getName().startsWith(this.clazz.getName()) || fileObject.getName().equals(this.clazz.getName())) continue;
                ClassInfo classInfo = new ClassInfo(fileObject.getName(), 0){

                    protected byte[] getClassFileBytes() throws IOException, ClassNotFoundException {
                        return fileObject.asBytes();
                    }
                };
                try {
                    classFileParser.parseClassFile(fileObject.asBytes(), classInfo);
                    hashSet.add(new FileClassInfo(classInfo, this.root, fileObject));
                }
                catch (IOException iOException) {
                }
                catch (ClassFileParser.ClassFileReadException classFileReadException) {}
            }
            return hashSet;
        }

        @Override
        public Set<SourceClassInfo> getInterfaces() {
            HashSet<SourceClassInfo> hashSet = new HashSet<SourceClassInfo>();
            String[] stringArray = this.ci.getInterfaceNames();
            if (stringArray != null) {
                for (String string : stringArray) {
                    hashSet.add(new PlainClassInfo(string));
                }
            }
            return hashSet;
        }

        @Override
        public Set<SourceMethodInfo> getMethods(boolean bl) {
            String[] stringArray = this.ci.getMethodNames();
            HashSet<SourceMethodInfo> hashSet = new HashSet<SourceMethodInfo>();
            if (stringArray != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    if (stringArray[i].equals("<init>")) continue;
                    hashSet.add(new FileMethodInfo(this.ci, i));
                }
            }
            return hashSet;
        }

        @Override
        public Set<SourceClassInfo> getSubclasses() {
            return Collections.EMPTY_SET;
        }

        @Override
        public SourceClassInfo getSuperType() {
            String string = this.ci.getSuperclassName();
            if (string == null) {
                string = Object.class.getName();
            }
            return new PlainClassInfo(string);
        }
    }

    private static class FilePackageInfo
    extends SourcePackageInfo {
        private FileObject root;
        private FileObject pkg;
        private Set<String> pkgsContent;

        public FilePackageInfo(FileObject fileObject, FileObject fileObject2, Set<String> set) {
            super(FileUtil.getRelativePath((FileObject)fileObject, (FileObject)fileObject2), FileUtil.getRelativePath((FileObject)fileObject, (FileObject)fileObject2).replace('/', '.'), SourcePackageInfo.Scope.SOURCE);
            this.pkg = fileObject2;
            this.root = fileObject;
            this.pkgsContent = set;
        }

        @Override
        public Collection<SourceClassInfo> getClasses() {
            FileObject fileObject;
            TreeSet<FileObject> treeSet = new TreeSet<FileObject>(pathComparator);
            Enumeration enumeration = this.pkg.getData(false);
            while (enumeration.hasMoreElements()) {
                fileObject = (FileObject)enumeration.nextElement();
                if (!fileObject.getExt().equalsIgnoreCase("class")) continue;
                treeSet.add(fileObject);
            }
            fileObject = new ClassFileParser();
            ArrayList<SourceClassInfo> arrayList = new ArrayList<SourceClassInfo>();
            for (final FileObject fileObject2 : treeSet) {
                if (fileObject2.getName().contains("$")) continue;
                ClassInfo classInfo = new ClassInfo(fileObject2.getName(), 0){

                    protected byte[] getClassFileBytes() throws IOException, ClassNotFoundException {
                        return fileObject2.asBytes();
                    }
                };
                try {
                    fileObject.parseClassFile(fileObject2.asBytes(), classInfo);
                    arrayList.add(new FileClassInfo(classInfo, this.root, fileObject2));
                }
                catch (IOException iOException) {
                }
                catch (ClassFileParser.ClassFileReadException classFileReadException) {}
            }
            return arrayList;
        }

        @Override
        public Collection<SourcePackageInfo> getSubpackages() {
            TreeSet treeSet = new TreeSet(pathComparator);
            Enumeration enumeration = this.pkg.getFolders(false);
            while (enumeration.hasMoreElements()) {
                treeSet.add(enumeration.nextElement());
            }
            ArrayList<SourcePackageInfo> arrayList = new ArrayList<SourcePackageInfo>();
            for (FileObject fileObject : treeSet) {
                if (!this.pkgsContent.contains(fileObject.getPath())) continue;
                arrayList.add(new FilePackageInfo(this.root, fileObject, this.pkgsContent));
            }
            return arrayList;
        }
    }
}

