/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.console.historicaldata.editors;

import com.jrockit.mc.common.Callback;
import com.jrockit.mc.common.unit.KindOfQuantity;
import com.jrockit.mc.common.unit.UnitLookup;
import com.jrockit.mc.console.historicaldata.HistoricalDataPlugin;
import com.jrockit.mc.console.historicaldata.editors.InformationSectionPart;
import com.jrockit.mc.console.historicaldata.editors.Messages;
import com.jrockit.mc.console.ui.actions.ResetToDefaultsAction;
import com.jrockit.mc.rjmx.RJMXPlugin;
import com.jrockit.mc.rjmx.persistence.internal.PersistenceReader;
import com.jrockit.mc.rjmx.services.IAttributeStorageService;
import com.jrockit.mc.rjmx.subscription.IMRIMetaDataService;
import com.jrockit.mc.rjmx.subscription.IMRIService;
import com.jrockit.mc.rjmx.subscription.MRI;
import com.jrockit.mc.rjmx.ui.RJMXUIPlugin;
import com.jrockit.mc.rjmx.ui.internal.CombinedChartSectionPart;
import com.jrockit.mc.rjmx.ui.internal.SectionPartManager;
import com.jrockit.mc.ui.formpage.internal.MCFormPage;
import com.jrockit.mc.ui.misc.MCActionContributionItem;
import com.jrockit.mc.ui.sections.MCSectionPart;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class HistoricalDataTab
extends MCFormPage {
    private static final String TAB_ID = "historicalDataPage";
    private static final String CHART_SECTION_ID = "chartSection";
    private static final int DEFAULT_MAX_NO_CHARTS = 3;
    private static final int DEFAULT_MAX_NO_ATTRIBUTES = 100;
    private final String serverUid;
    private final File persistenceDirectory;

    public HistoricalDataTab(FormEditor editor, String uid, File directory) {
        super(editor, TAB_ID, Messages.HistoricalDataPage_TITLE);
        this.serverUid = uid;
        this.persistenceDirectory = directory;
    }

    public Image getTitleImage() {
        return HistoricalDataPlugin.getDefault().getImage("historic-data-16.gif");
    }

    protected void createFormContent(IManagedForm managedForm) {
        super.createFormContent(managedForm);
        managedForm.getForm().setImage(HistoricalDataPlugin.getDefault().getImage("historic-data-16.gif"));
        managedForm.getForm().setText(Messages.HistoricalDataPage_TITLE);
        final SectionPartManager sectionPartManager = new SectionPartManager(managedForm);
        final PersistenceReader reader = new PersistenceReader(this.persistenceDirectory, this.serverUid);
        final IMRIMetaDataService mds = (IMRIMetaDataService)RJMXPlugin.getDefault().getService(IMRIMetaDataService.class);
        if (reader.getAttributes().isEmpty()) {
            HistoricalDataTab.showHelp(managedForm);
        } else {
            Action newChartAction = new Action(Messages.NewChartAction_ADD_CHART_TEXT, RJMXUIPlugin.getDefault().getMCImageDescriptor("add-obj.gif")){

                public void run() {
                    HistoricalDataTab.createChart(sectionPartManager, reader, mds, sectionPartManager.createUniqueSectionPartTitle(Messages.NewChartAction_MY_CHART_X_TEXT));
                }
            };
            IToolBarManager toolbar = managedForm.getForm().getToolBarManager();
            toolbar.prependToGroup("MC_TB_GROUP", (IContributionItem)new MCActionContributionItem((IAction)new ResetToDefaultsAction(){

                protected void reset() {
                    sectionPartManager.destroyAllParts();
                    HistoricalDataTab.addDefaultCharts(sectionPartManager, reader, mds);
                }
            }));
            toolbar.prependToGroup("MC_TB_GROUP", (IContributionItem)new MCActionContributionItem((IAction)newChartAction));
            toolbar.update(true);
            IMemento configuration = this.getConfiguration();
            if (configuration == null) {
                HistoricalDataTab.addDefaultCharts(sectionPartManager, reader, mds);
            } else {
                IMemento[] iMementoArray = configuration.getChildren(CHART_SECTION_ID);
                int n = iMementoArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IMemento cs = iMementoArray[n2];
                    HistoricalDataTab.createChart(sectionPartManager, reader, mds, null).restoreState(cs);
                    ++n2;
                }
            }
        }
    }

    private IMemento getConfiguration() {
        if (this.serverUid == null) {
            return null;
        }
        try {
            return XMLMemento.createReadRoot((Reader)new StringReader(RJMXPlugin.getDefault().getServerPreferences(this.serverUid).get(TAB_ID, "")));
        }
        catch (WorkbenchException e) {
            return null;
        }
    }

    public String getId() {
        return TAB_ID;
    }

    public void dispose() {
        if (this.serverUid != null) {
            XMLMemento state = XMLMemento.createWriteRoot((String)TAB_ID);
            IFormPart[] iFormPartArray = this.getManagedForm().getParts();
            int n = iFormPartArray.length;
            int n2 = 0;
            while (n2 < n) {
                IFormPart part = iFormPartArray[n2];
                if (part instanceof CombinedChartSectionPart) {
                    ((CombinedChartSectionPart)part).saveState(state.createChild(CHART_SECTION_ID));
                } else if (part instanceof InformationSectionPart) {
                    return;
                }
                ++n2;
            }
            StringWriter sw = new StringWriter();
            try {
                state.save((Writer)sw);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            RJMXPlugin.getDefault().getServerPreferences(this.serverUid).put(TAB_ID, sw.toString());
        }
        super.dispose();
    }

    private static void showHelp(IManagedForm managedForm) {
        Composite parent = managedForm.getForm().getBody();
        FormToolkit toolkit = managedForm.getToolkit();
        InformationSectionPart isp = new InformationSectionPart(parent, toolkit, 256, "com.jrockit.mc.console.ui.historical.data.information");
        managedForm.addPart((IFormPart)isp);
        isp.getSection().setLayoutData((Object)new GridData(4, 4, true, true));
    }

    private static void addDefaultCharts(SectionPartManager spm, PersistenceReader pr, IMRIMetaDataService mds) {
        HashMap mrisByKind = new HashMap();
        for (MRI mri : pr.getAttributes()) {
            KindOfQuantity kind = UnitLookup.getUnitOrDefault((String)mds.getMetaData(mri).getUnitString()).getContentType();
            ArrayList<MRI> list = (ArrayList<MRI>)mrisByKind.get(kind);
            if (list == null) {
                list = new ArrayList<MRI>();
                mrisByKind.put(kind, list);
            }
            if (list.size() >= 100) continue;
            list.add(mri);
        }
        ArrayList allAttributes = new ArrayList(mrisByKind.entrySet());
        Collections.sort(allAttributes, new Comparator<Map.Entry<KindOfQuantity<?>, List<MRI>>>(){

            @Override
            public int compare(Map.Entry<KindOfQuantity<?>, List<MRI>> e1, Map.Entry<KindOfQuantity<?>, List<MRI>> e2) {
                return e2.getValue().size() - e1.getValue().size();
            }
        });
        int i = 0;
        while (i < 3 && i < allAttributes.size()) {
            Map.Entry e = (Map.Entry)allAttributes.get(i);
            List l = (List)e.getValue();
            HistoricalDataTab.createChart(spm, pr, mds, ((KindOfQuantity)e.getKey()).getName()).add(l.toArray(new MRI[l.size()]));
            ++i;
        }
    }

    private static CombinedChartSectionPart createChart(SectionPartManager spm, PersistenceReader pr, IMRIMetaDataService mds, String title) {
        CombinedChartSectionPart hcsp = new CombinedChartSectionPart(spm.getContainer(), spm.getFormToolkit(), 322, mds, (IMRIService)pr, (IAttributeStorageService)pr){

            protected Callback<Boolean> createEnableUpdatesCallback() {
                return new Callback<Boolean>(){

                    public void call(Boolean parameter) {
                    }
                };
            }
        };
        spm.add((MCSectionPart)hcsp, true, true);
        if (title != null) {
            hcsp.getChart().getChartModel().setChartTitle(title);
            hcsp.getChart().getChartModel().notifyObservers();
        }
        hcsp.getChart().showLast(3600000000000L);
        return hcsp;
    }
}

