/*
 * Decompiled with CFR 0.152.
 */
package org.openide.text;

import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Element;
import javax.swing.text.StyledDocument;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.DocumentLine;
import org.openide.text.Line;
import org.openide.text.LineStruct;
import org.openide.text.NbDocument;
import org.openide.util.WeakListeners;

final class LineListener
implements DocumentListener {
    private int orig;
    private Element root;
    private int lines;
    private LineStruct struct = new LineStruct();
    CloneableEditorSupport support;

    public LineListener(StyledDocument styledDocument, CloneableEditorSupport cloneableEditorSupport) {
        this.root = NbDocument.findLineRootElement(styledDocument);
        this.orig = this.lines = this.root.getElementCount();
        this.support = cloneableEditorSupport;
        styledDocument.addDocumentListener(WeakListeners.document((DocumentListener)this, (Object)styledDocument));
    }

    public int getOriginalLineCount() {
        return this.orig;
    }

    public int getLine(int n) {
        return this.struct.convert(n, true);
    }

    public int getOld(int n) {
        return this.struct.convert(n, false);
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        int n = this.root.getElementCount();
        int n2 = this.lines - n;
        this.lines = n;
        StyledDocument styledDocument = this.support.getDocument();
        if (styledDocument == null) {
            return;
        }
        int n3 = NbDocument.findLineNumber(styledDocument, documentEvent.getOffset());
        if (n2 > 0) {
            this.struct.deleteLines(n3, n2);
        }
        if (this.support == null) {
            return;
        }
        Line.Set set = this.support.getLineSet();
        if (!(set instanceof DocumentLine.Set)) {
            return;
        }
        ((DocumentLine.Set)set).linesChanged(n3, n3 + n2, documentEvent);
        if (n2 > 0) {
            ((DocumentLine.Set)set).linesMoved(n3, n);
        }
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        int n = this.root.getElementCount();
        int n2 = n - this.lines;
        this.lines = n;
        StyledDocument styledDocument = this.support.getDocument();
        if (styledDocument == null) {
            return;
        }
        int n3 = NbDocument.findLineNumber(styledDocument, documentEvent.getOffset());
        if (n2 > 0) {
            this.struct.insertLines(n3, n2);
        }
        if (this.support == null) {
            return;
        }
        Line.Set set = this.support.getLineSet();
        if (!(set instanceof DocumentLine.Set)) {
            return;
        }
        ((DocumentLine.Set)set).linesChanged(n3, n3, documentEvent);
        if (n2 > 0) {
            ((DocumentLine.Set)set).linesMoved(n3, n);
        }
    }
}

