/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.components.ui.util;

import com.jrockit.mc.components.ui.behaviors.IStatusListener;
import com.jrockit.mc.components.ui.behaviors.IStatusProvider;
import com.jrockit.mc.components.ui.util.AbstractStatusProvider;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;

public class StatusProvider
extends AbstractStatusProvider {
    private final Map<IStatusProvider, IStatusListener> m_providers = Collections.synchronizedMap(new IdentityHashMap());

    public final void addStatusProvider(IStatusProvider provider) {
        IStatusListener listener = new IStatusListener(){

            @Override
            public void onChange(IStatus status) {
                StatusProvider.this.fireChange(status);
            }
        };
        provider.addStatusListener(listener);
        this.m_providers.put(provider, listener);
    }

    public final void removeStatusProvider(IStatusProvider provider) {
        IStatusListener statusListener = this.m_providers.remove(provider);
        if (statusListener != null) {
            provider.removeStatusListener(statusListener);
        }
    }

    public final void clear() {
        this.clearListeners();
        this.clearProviders();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearProviders() {
        Map<IStatusProvider, IStatusListener> map = this.m_providers;
        synchronized (map) {
            Iterator<Map.Entry<IStatusProvider, IStatusListener>> entries = this.m_providers.entrySet().iterator();
            while (entries.hasNext()) {
                Map.Entry<IStatusProvider, IStatusListener> entry = entries.next();
                if (entry.getValue() != null) {
                    entry.getKey().removeStatusListener(entry.getValue());
                }
                entries.remove();
            }
        }
    }

    @Override
    public IStatus getStatus() {
        Object[] objects = this.m_providers.keySet().toArray();
        IStatus[] statuses = new IStatus[objects.length];
        int n = 0;
        while (n < objects.length) {
            IStatusProvider sp = (IStatusProvider)objects[n];
            statuses[n] = sp.getStatus();
            ++n;
        }
        if (statuses.length == 0) {
            return STATUS_OK;
        }
        if (statuses.length == 1) {
            return statuses[0];
        }
        return new MultiStatus("com.jrockit.mc.components.ui", 0, statuses, "Multi Status", null);
    }
}

