/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.components.ui.design.view.toolbar;

import com.jrockit.mc.components.ui.contributions.UserInterfaceContribution;
import com.jrockit.mc.components.ui.design.view.toolbar.TabPageLabelProvider;
import com.jrockit.mc.components.ui.tab.TabDescriptorRepository;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Shell;

public abstract class ToolbarBaseMenu
extends MenuManager {
    private final Viewer m_viewer;
    private final TabPageLabelProvider m_imageProvider;

    public ToolbarBaseMenu(String title, Viewer viewer, TabPageLabelProvider provider) {
        super(title);
        this.m_viewer = viewer;
        this.m_imageProvider = provider;
        this.setRemoveAllWhenShown(true);
        this.hookMenuListener(this);
    }

    protected abstract void populateForSelected(TabDescriptorRepository var1, Object var2);

    protected final void hookMenuListener(MenuManager manager) {
        manager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                ToolbarBaseMenu.this.populateMenu(manager);
            }
        });
    }

    protected final TabPageLabelProvider getTabImageProvider() {
        return this.m_imageProvider;
    }

    protected final Shell getShell() {
        return this.m_viewer.getControl().getShell();
    }

    protected final void addRefreshAction(IAction action) {
        action.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getProperty().equals("refresh")) {
                    ToolbarBaseMenu.this.m_imageProvider.clear();
                    ToolbarBaseMenu.this.getViewer().refresh();
                }
            }
        });
        this.add(action);
    }

    protected final Viewer getViewer() {
        return this.m_viewer;
    }

    protected void populateMenu(IMenuManager manager) {
        ITreeSelection ss = (ITreeSelection)this.m_viewer.getSelection();
        if (!ss.isEmpty()) {
            TreePath path = ss.getPaths()[0];
            UserInterfaceContribution uic = (UserInterfaceContribution)path.getFirstSegment();
            TabDescriptorRepository tdr = uic.getUserInterface().getTabRepository();
            this.populateForSelected(tdr, ss.getFirstElement());
        }
    }
}

