/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.components.ui.design.view.layout;

import com.jrockit.mc.components.ui.design.DesignerTab;
import com.jrockit.mc.components.ui.design.view.layout.DesignerTabSelectionListener;
import com.jrockit.mc.components.ui.design.view.layout.HistoryPart;
import com.jrockit.mc.components.ui.design.view.layout.LayoutSubPart;
import com.jrockit.mc.components.ui.design.view.layout.TreePart;
import com.jrockit.mc.components.ui.design.view.layout.TypePart;
import com.jrockit.mc.components.ui.messages.internal.Messages;
import com.jrockit.mc.ui.UIPlugin;
import com.jrockit.mc.ui.misc.SelectionProvider;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.part.Page;

public final class LayoutPage
extends Page {
    private final DesignerTabSelectionListener m_layoutSelectionListener = new DesignerTabSelectionListener(this);
    private final List<LayoutSubPart> m_parts = new ArrayList<LayoutSubPart>();
    private Composite m_container;

    public void init(IPageSite pageSite) {
        super.init(pageSite);
    }

    public void createControl(Composite parent) {
        this.m_container = new Composite(parent, 0);
        this.getSite().setSelectionProvider((ISelectionProvider)new SelectionProvider());
        Label componentText = new Label(this.m_container, 0x1000000);
        componentText.setText(Messages.LAYOUT_PAGE_STRUCTURE_LABEL);
        componentText.setLayoutData((Object)this.createLayoutData(false));
        this.addPart(this.m_container, new TreePart((IWorkbenchSite)this.getSite()), true);
        Label text = new Label(this.m_container, 0x1000000);
        text.setText(Messages.LAYOUT_PAGE_SETTINGS_TITLE);
        text.setLayoutData((Object)this.createLayoutData(false));
        this.addPart(this.m_container, new TypePart((IWorkbenchSite)this.getSite()), false);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginBottom = 0;
        Label historyText = new Label(this.m_container, 0x1000000);
        historyText.setText(Messages.LAYOUT_PAGE_HISTORY_LABEL);
        historyText.setLayoutData((Object)this.createLayoutData(false));
        this.addPart(this.m_container, new HistoryPart((IWorkbenchSite)this.getSite()), true);
        this.m_container.setLayout((Layout)layout);
        this.initializeSelectionListener();
    }

    private void addPart(Composite container, LayoutSubPart layoutPart, boolean grabheight) {
        Control control = layoutPart.create(container);
        control.setLayoutData((Object)this.createLayoutData(grabheight));
        this.m_parts.add(layoutPart);
    }

    private GridData createLayoutData(boolean grabHeight) {
        return new GridData(4, 4, true, grabHeight);
    }

    public List<LayoutSubPart> getParts() {
        return this.m_parts;
    }

    public Control getControl() {
        return this.m_container;
    }

    private ISelectionService getSelectionService() {
        return this.getSite().getWorkbenchWindow().getSelectionService();
    }

    private void initializeSelectionListener() {
        this.getSelectionService().addSelectionListener((ISelectionListener)this.m_layoutSelectionListener);
    }

    private void clearSelectionListener() {
        if (this.m_layoutSelectionListener != null) {
            this.getSelectionService().removeSelectionListener((ISelectionListener)this.m_layoutSelectionListener);
        }
    }

    public Image getImage() {
        return UIPlugin.getDefault().getImage("layout.gif");
    }

    public void dispose() {
        for (LayoutSubPart part : this.getParts()) {
            part.dispose();
        }
        this.clearSelectionListener();
        super.dispose();
    }

    public void setFocus() {
        if (!this.getParts().isEmpty()) {
            this.getParts().get(0).setFocus();
        }
    }

    public void setTab(DesignerTab tab) {
        for (LayoutSubPart subPart : this.getParts()) {
            subPart.setTab(tab);
        }
    }

    public void update() {
        for (LayoutSubPart subPart : this.getParts()) {
            if (subPart.getControl() == null || subPart.getControl().isDisposed()) continue;
            subPart.update();
        }
    }
}

