/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.components.ui.design;

import com.jrockit.mc.common.persistence.ISettingFetcher;
import com.jrockit.mc.common.persistence.PersistenceToolkit;
import com.jrockit.mc.common.persistence.Setting;
import com.jrockit.mc.common.persistence.Type;
import com.jrockit.mc.components.ui.components.ComponentDescriptor;
import com.jrockit.mc.components.ui.design.LayoutData;
import com.jrockit.mc.components.ui.design.LayoutItemType;
import java.util.List;
import java.util.Observable;
import java.util.Observer;

public final class LayoutItem
extends Observable {
    private static final String LAYOUT_DATA = "layoutData";
    private static final String LAYOUT_ITEMS = "layoutItems";
    private static final String LAYOUT_ITEM = "layoutItem";
    private static final String COMPONENT_DESCRIPTOR = "componentDescriptor";
    private static final String SELECTED = "selected";
    private final Setting m_setting = new Setting("layoutItem");

    static {
        PersistenceToolkit.registerFetcher(LayoutItem.class, (ISettingFetcher)new ISettingFetcher<LayoutItem>(){

            public Setting getSetting(LayoutItem layoutItem) {
                return layoutItem.m_setting;
            }
        });
    }

    public LayoutItem() {
        this.setComponentDescripor(this.createDefaultComponentDescriptor());
        this.hookLayoutDataObserver();
    }

    private void hookLayoutDataObserver() {
        this.getLayoutData().addObserver(new Observer(){

            @Override
            public void update(Observable arg0, Object arg1) {
                LayoutItem.this.setChanged();
            }
        });
    }

    private ComponentDescriptor createDefaultComponentDescriptor() {
        ComponentDescriptor cd = new ComponentDescriptor();
        cd.setName("");
        cd.setTypeIdentifier("mc.empty");
        cd.setDescription("");
        return cd;
    }

    public LayoutData getLayoutData() {
        return (LayoutData)this.m_setting.getChildObject(LAYOUT_DATA, LayoutData.class);
    }

    public void add(LayoutItem item) {
        this.getChildren().add(item);
        this.setChanged();
    }

    public void remove(LayoutItem item) {
        this.getChildren().remove(item);
        this.setChanged();
    }

    @Override
    public void setChanged() {
        super.setChanged();
    }

    public List<LayoutItem> getChildren() {
        return (List)this.m_setting.getChildObject(LAYOUT_ITEMS, new Type(List.class, new Type[]{new Type(LayoutItem.class)}));
    }

    public LayoutItem createBefore(LayoutItem beforeItem) {
        LayoutItem child = new LayoutItem();
        this.addBefore(beforeItem, child);
        return child;
    }

    public LayoutItem createAfter(LayoutItem afterItem) {
        LayoutItem child = new LayoutItem();
        this.addAfter(afterItem, child);
        return child;
    }

    private void addBefore(LayoutItem beforeItem, LayoutItem item) {
        int index = 0;
        for (LayoutItem anItem : this.getChildren()) {
            if (beforeItem.equals(anItem)) {
                this.getChildren().add(index, item);
                this.setChanged();
                return;
            }
            ++index;
        }
    }

    private void addAfter(LayoutItem afterItem, LayoutItem item) {
        int index = 0;
        for (LayoutItem anItem : this.getChildren()) {
            ++index;
            if (!afterItem.equals(anItem)) continue;
            if (index < this.getChildren().size()) {
                this.getChildren().add(index, item);
                continue;
            }
            this.getChildren().add(item);
        }
        this.setChanged();
    }

    public LayoutItemType getType() {
        return LayoutItemType.lookup(this.getComponentDescriptor().getTypeIdentifier());
    }

    public ComponentDescriptor getComponentDescriptor() {
        return (ComponentDescriptor)this.m_setting.getChildObject(COMPONENT_DESCRIPTOR, ComponentDescriptor.class);
    }

    public void resetComponentDescriptor() {
        this.m_setting.setChildObject(COMPONENT_DESCRIPTOR, (Object)this.createDefaultComponentDescriptor());
        this.setChanged();
    }

    public void setComponentDescripor(ComponentDescriptor cd) {
        this.m_setting.setChildObject(COMPONENT_DESCRIPTOR, (Object)cd);
        this.setChanged();
    }

    public void setLayoutdata(LayoutData data) {
        this.m_setting.setChildObject(LAYOUT_DATA, (Object)data);
    }

    public void setSelected() {
        this.m_setting.setChildObject(SELECTED, (Object)Boolean.TRUE);
    }

    public boolean isSelected() {
        return (Boolean)this.m_setting.getChildObject(SELECTED, Boolean.class);
    }

    public void cleartSelection() {
        this.m_setting.setChildObject(SELECTED, null);
    }
}

