/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.options.keymap;

import java.awt.event.ActionEvent;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.JEditorPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.text.TextAction;
import org.netbeans.core.options.keymap.api.ShortcutAction;
import org.netbeans.core.options.keymap.spi.KeymapManager;
import org.netbeans.spi.quicksearch.SearchProvider;
import org.netbeans.spi.quicksearch.SearchRequest;
import org.netbeans.spi.quicksearch.SearchResponse;
import org.openide.awt.StatusDisplayer;
import org.openide.cookies.EditorCookie;
import org.openide.nodes.Node;
import org.openide.text.CloneableEditor;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class ActionsSearchProvider
implements SearchProvider {
    private volatile SearchRequest currentRequest;

    public void evaluate(final SearchRequest searchRequest, final SearchResponse searchResponse) {
        this.currentRequest = searchRequest;
        final HashMap<Object, String> hashMap = new HashMap<Object, String>();
        final ArrayList<ActionInfo> arrayList = new ArrayList<ActionInfo>(7);
        for (KeymapManager object : Lookup.getDefault().lookupAll(KeymapManager.class)) {
            Map<ShortcutAction, Set<String>> map = object.getKeymap(object.getCurrentProfile());
            for (Map.Entry<String, Set<ShortcutAction>> entry : object.getActions().entrySet()) {
                for (ShortcutAction shortcutAction : entry.getValue()) {
                    if (this.currentRequest != searchRequest) {
                        return;
                    }
                    ActionInfo actionInfo = this.getActionInfo(shortcutAction, map.get(shortcutAction), entry.getKey());
                    if (actionInfo == null || this.doEvaluation(shortcutAction.getDisplayName(), searchRequest, actionInfo, searchResponse, arrayList, hashMap)) continue;
                    return;
                }
            }
        }
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    Node[] nodeArray = TopComponent.getRegistry().getActivatedNodes();
                    for (int i = 0; i < nodeArray.length; ++i) {
                        Action[] actionArray = nodeArray[i].getActions(false);
                        for (int j = 0; j < actionArray.length; ++j) {
                            String string;
                            if (ActionsSearchProvider.this.currentRequest != searchRequest) {
                                return;
                            }
                            Action action = ActionsSearchProvider.this.checkNodeAction(actionArray[j]);
                            if (action == null) continue;
                            ActionInfo actionInfo = new ActionInfo(action, null, null, null);
                            Object object = action.getValue("Name");
                            if (!(object instanceof String) || ActionsSearchProvider.this.doEvaluation(string = ((String)object).replaceFirst("&(?! )", ""), searchRequest, actionInfo, searchResponse, arrayList, hashMap)) continue;
                            return;
                        }
                    }
                }
            });
        }
        catch (InterruptedException interruptedException) {
            Exceptions.printStackTrace((Throwable)interruptedException);
        }
        catch (InvocationTargetException invocationTargetException) {
            Exceptions.printStackTrace((Throwable)invocationTargetException);
        }
        for (ActionInfo actionInfo : arrayList) {
            if (this.currentRequest != searchRequest) {
                return;
            }
            if (this.addAction(actionInfo, searchResponse, hashMap)) continue;
            return;
        }
    }

    private boolean addAction(ActionInfo actionInfo, SearchResponse searchResponse, Map<Object, String> map) {
        Object object;
        Object object2;
        KeyStroke keyStroke = null;
        Set<String> set = actionInfo.getShortcuts();
        if (set != null && set.size() > 0) {
            object2 = set.iterator().next();
            keyStroke = Utilities.stringToKey((String)object2);
        }
        object2 = actionInfo.getAction();
        if (keyStroke == null && (object = object2.getValue("AcceleratorKey")) instanceof KeyStroke) {
            keyStroke = (KeyStroke)object;
        }
        object = null;
        ShortcutAction shortcutAction = actionInfo.getShortcutAction();
        if (shortcutAction != null) {
            object = shortcutAction.getDisplayName();
        } else {
            Object object3 = object2.getValue("Name");
            if (object3 instanceof String) {
                object = ((String)object3).replaceFirst("&(?! )", "");
            }
        }
        if (actionInfo.getCategory() != null && !actionInfo.getCategory().isEmpty() && !actionInfo.getCategory().equals(object)) {
            object = (String)object + " (" + actionInfo.getCategory() + ")";
        }
        if (map.put(object2, (String)object) != null) {
            return true;
        }
        return searchResponse.addResult((Runnable)new ActionResult((Action)object2), (String)object, null, Collections.singletonList(keyStroke));
    }

    private boolean doEvaluation(String string, SearchRequest searchRequest, ActionInfo actionInfo, SearchResponse searchResponse, List<ActionInfo> list, Map<Object, String> map) {
        int n = string.toLowerCase().indexOf(searchRequest.getText().toLowerCase());
        if (n == 0) {
            return this.addAction(actionInfo, searchResponse, map);
        }
        if (n != -1) {
            list.add(actionInfo);
        }
        return true;
    }

    private ActionInfo getActionInfo(final ShortcutAction shortcutAction, final Set<String> set, final String string) {
        final ActionInfo[] actionInfoArray = new ActionInfo[1];
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    Class<?> clazz = shortcutAction.getClass();
                    Field field = null;
                    try {
                        field = clazz.getDeclaredField("action");
                        field.setAccessible(true);
                        Action action = (Action)field.get(shortcutAction);
                        if (!action.isEnabled()) {
                            return;
                        }
                        actionInfoArray[0] = new ActionInfo(action, shortcutAction, set, string);
                        return;
                    }
                    catch (Throwable throwable) {
                        if (throwable instanceof ThreadDeath) {
                            throw (ThreadDeath)throwable;
                        }
                        Logger.getLogger(this.getClass().getName()).log(Level.FINE, "Some problem getting action " + shortcutAction.getDisplayName(), throwable);
                        return;
                    }
                }
            });
        }
        catch (InterruptedException interruptedException) {
            Exceptions.printStackTrace((Throwable)interruptedException);
        }
        catch (InvocationTargetException invocationTargetException) {
            Exceptions.printStackTrace((Throwable)invocationTargetException);
        }
        return actionInfoArray[0];
    }

    private static ActionEvent createActionEvent(Action action) {
        Object object = null;
        int n = 1001;
        if (action instanceof TextAction) {
            EditorCookie editorCookie = (EditorCookie)Utilities.actionsGlobalContext().lookup(EditorCookie.class);
            if (editorCookie == null) {
                return null;
            }
            JEditorPane[] jEditorPaneArray = editorCookie.getOpenedPanes();
            if (jEditorPaneArray == null || jEditorPaneArray.length <= 0) {
                return null;
            }
            object = jEditorPaneArray[0];
        }
        if (object == null) {
            object = TopComponent.getRegistry().getActivated();
        }
        if (object == null) {
            object = WindowManager.getDefault().getMainWindow();
        }
        return new ActionEvent(object, n, null);
    }

    private Action checkNodeAction(Action action) {
        if (action == null) {
            return null;
        }
        try {
            if (action.isEnabled()) {
                return action;
            }
        }
        catch (Throwable throwable) {
            if (throwable instanceof ThreadDeath) {
                throw (ThreadDeath)throwable;
            }
            Logger.getLogger(this.getClass().getName()).log(Level.FINE, "Problem asking isEnabled on action " + action, throwable);
        }
        return null;
    }

    private static class ActionInfo {
        private Action action;
        private ShortcutAction shortcutAction = null;
        private Set<String> shortcuts = null;
        private String category = null;

        public ActionInfo(Action action, ShortcutAction shortcutAction, Set<String> set, String string) {
            this.action = action;
            this.shortcutAction = shortcutAction;
            this.shortcuts = set;
            this.category = string;
        }

        public Action getAction() {
            return this.action;
        }

        public ShortcutAction getShortcutAction() {
            return this.shortcutAction;
        }

        public Set<String> getShortcuts() {
            return this.shortcuts;
        }

        public String getCategory() {
            return this.category;
        }
    }

    private static class ActionResult
    implements Runnable {
        private static Logger UILOG = Logger.getLogger("org.netbeans.ui.actions");
        private Action command;

        public ActionResult(Action action) {
            this.command = action;
        }

        @Override
        public void run() {
            try {
                JEditorPane jEditorPane;
                Action action;
                Action action2 = this.command;
                ActionEvent actionEvent = ActionsSearchProvider.createActionEvent(this.command);
                Object object = actionEvent.getSource();
                if (object instanceof CloneableEditor && (action = (jEditorPane = ((CloneableEditor)object).getEditorPane()).getActionMap().get(this.command.getValue("Name"))) != null) {
                    action2 = action;
                }
                action2.actionPerformed(actionEvent);
                this.uiLog(true);
            }
            catch (Throwable throwable) {
                this.uiLog(false);
                if (throwable instanceof ThreadDeath) {
                    throw (ThreadDeath)throwable;
                }
                Object object = this.command.getValue("Name");
                String string = "";
                if (object instanceof String) {
                    string = (String)object;
                }
                Logger.getLogger(this.getClass().getName()).log(Level.FINE, string + " action can not be invoked.", throwable);
                StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(this.getClass(), (String)"MSG_ActionFailure", (Object)string));
            }
        }

        private void uiLog(boolean bl) {
            LogRecord logRecord = new LogRecord(Level.FINER, bl ? "LOG_QUICKSEARCH_ACTION" : "LOG_QUICKSEARCH_ACTION_FAILED");
            logRecord.setParameters(new Object[]{this.command.getClass().getName(), this.command.getValue("Name")});
            logRecord.setResourceBundle(NbBundle.getBundle(ActionsSearchProvider.class));
            logRecord.setResourceBundleName(ActionsSearchProvider.class.getPackage().getName() + ".Bundle");
            logRecord.setLoggerName(UILOG.getName());
            UILOG.log(logRecord);
        }
    }
}

