/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import org.netbeans.api.keyring.Keyring;
import org.netbeans.core.NbProxySelector;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.util.NetworkSettings;
import org.openide.util.Parameters;
import org.openide.util.Utilities;

public class ProxySettings {
    public static final String PROXY_HTTP_HOST = "proxyHttpHost";
    public static final String PROXY_HTTP_PORT = "proxyHttpPort";
    public static final String PROXY_HTTPS_HOST = "proxyHttpsHost";
    public static final String PROXY_HTTPS_PORT = "proxyHttpsPort";
    public static final String PROXY_SOCKS_HOST = "proxySocksHost";
    public static final String PROXY_SOCKS_PORT = "proxySocksPort";
    public static final String NOT_PROXY_HOSTS = "proxyNonProxyHosts";
    public static final String PROXY_TYPE = "proxyType";
    public static final String USE_PROXY_AUTHENTICATION = "useProxyAuthentication";
    public static final String PROXY_AUTHENTICATION_USERNAME = "proxyAuthenticationUsername";
    public static final String PROXY_AUTHENTICATION_PASSWORD = "proxyAuthenticationPassword";
    public static final String USE_PROXY_ALL_PROTOCOLS = "useProxyAllProtocols";
    public static final String DIRECT = "DIRECT";
    public static final String PAC = "PAC";
    private static String presetNonProxyHosts;
    public static final int DIRECT_CONNECTION = 0;
    public static final int AUTO_DETECT_PROXY = 1;
    public static final int MANUAL_SET_PROXY = 2;
    public static final int AUTO_DETECT_PAC = 3;
    public static final int MANUAL_SET_PAC = 4;
    private static final Logger LOGGER;

    private static Preferences getPreferences() {
        return NbPreferences.forModule(ProxySettings.class);
    }

    public static String getHttpHost() {
        return ProxySettings.normalizeProxyHost(ProxySettings.getPreferences().get(PROXY_HTTP_HOST, ""));
    }

    public static String getHttpPort() {
        return ProxySettings.getPreferences().get(PROXY_HTTP_PORT, "");
    }

    public static String getHttpsHost() {
        if (ProxySettings.useProxyAllProtocols()) {
            return ProxySettings.getHttpHost();
        }
        return ProxySettings.getPreferences().get(PROXY_HTTPS_HOST, "");
    }

    public static String getHttpsPort() {
        if (ProxySettings.useProxyAllProtocols()) {
            return ProxySettings.getHttpPort();
        }
        return ProxySettings.getPreferences().get(PROXY_HTTPS_PORT, "");
    }

    public static String getSocksHost() {
        if (ProxySettings.useProxyAllProtocols()) {
            return ProxySettings.getHttpHost();
        }
        return ProxySettings.getPreferences().get(PROXY_SOCKS_HOST, "");
    }

    public static String getSocksPort() {
        if (ProxySettings.useProxyAllProtocols()) {
            return ProxySettings.getHttpPort();
        }
        return ProxySettings.getPreferences().get(PROXY_SOCKS_PORT, "");
    }

    public static String getNonProxyHosts() {
        String string = ProxySettings.getPreferences().get(NOT_PROXY_HOSTS, ProxySettings.getDefaultUserNonProxyHosts());
        return ProxySettings.compactNonProxyHosts(string);
    }

    public static int getProxyType() {
        int n = ProxySettings.getPreferences().getInt(PROXY_TYPE, 1);
        if (1 == n) {
            n = NbProxySelector.usePAC() ? 3 : 1;
        }
        return n;
    }

    public static boolean useAuthentication() {
        return ProxySettings.getPreferences().getBoolean(USE_PROXY_AUTHENTICATION, false);
    }

    public static boolean useProxyAllProtocols() {
        return ProxySettings.getPreferences().getBoolean(USE_PROXY_ALL_PROTOCOLS, false);
    }

    public static String getAuthenticationUsername() {
        return ProxySettings.getPreferences().get(PROXY_AUTHENTICATION_USERNAME, "");
    }

    public static char[] getAuthenticationPassword() {
        char[] cArray;
        String string = ProxySettings.getPreferences().get(PROXY_AUTHENTICATION_PASSWORD, null);
        if (string != null) {
            ProxySettings.getPreferences().remove(PROXY_AUTHENTICATION_PASSWORD);
            ProxySettings.setAuthenticationPassword(string.toCharArray());
        }
        return (cArray = Keyring.read((String)PROXY_AUTHENTICATION_PASSWORD)) != null ? cArray : new char[]{};
    }

    public static void setAuthenticationPassword(char[] cArray) {
        Keyring.save((String)PROXY_AUTHENTICATION_PASSWORD, (char[])cArray, (String)NbBundle.getMessage(ProxySettings.class, (String)"ProxySettings.password.description"));
    }

    static void addPreferenceChangeListener(PreferenceChangeListener preferenceChangeListener) {
        ProxySettings.getPreferences().addPreferenceChangeListener(preferenceChangeListener);
    }

    static void removePreferenceChangeListener(PreferenceChangeListener preferenceChangeListener) {
        ProxySettings.getPreferences().removePreferenceChangeListener(preferenceChangeListener);
    }

    private static String getSystemNonProxyHosts() {
        String string = System.getProperty("netbeans.system_http_non_proxy_hosts");
        return string == null ? "" : string;
    }

    private static String getPresetNonProxyHosts() {
        if (presetNonProxyHosts == null) {
            presetNonProxyHosts = System.getProperty("http.nonProxyHosts", "");
        }
        return presetNonProxyHosts;
    }

    private static String getDefaultUserNonProxyHosts() {
        return ProxySettings.getModifiedNonProxyHosts(ProxySettings.getSystemNonProxyHosts());
    }

    private static String concatProxies(String ... stringArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : stringArray) {
            if (string == null || (string = string.trim()).isEmpty()) continue;
            if (stringBuilder.length() > 0 && stringBuilder.charAt(stringBuilder.length() - 1) != '|' && !string.startsWith("|")) {
                stringBuilder.append('|');
            }
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    private static String getModifiedNonProxyHosts(String string) {
        String string2;
        String string3 = string.replaceAll(";", "|").replaceAll(",", "|");
        String string4 = string2 = ProxySettings.getPresetNonProxyHosts() == null ? "" : ProxySettings.getPresetNonProxyHosts().replaceAll(";", "|").replaceAll(",", "|");
        if (Utilities.isWindows()) {
            string3 = ProxySettings.addReguralToNonProxyHosts(string3);
        }
        String string5 = NbBundle.getMessage(ProxySettings.class, (String)"StaticNonProxyHosts");
        String string6 = ProxySettings.concatProxies(string2, string3, string5);
        try {
            String string7 = InetAddress.getLocalHost().getHostName();
            if (!"localhost".equals(string7)) {
                string6 = string6 + "|" + string7;
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return ProxySettings.compactNonProxyHosts(string6);
    }

    private static String compactNonProxyHosts(String string) {
        Object object;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        StringBuilder stringBuilder = new StringBuilder();
        while (stringTokenizer.hasMoreTokens()) {
            object = stringTokenizer.nextToken().trim();
            if (((String)object).length() == 0) continue;
            if (stringBuilder.length() > 0) {
                stringBuilder.append("|");
            }
            stringBuilder.append((String)object);
        }
        stringTokenizer = new StringTokenizer(stringBuilder.toString(), "|");
        object = new HashSet();
        StringBuilder stringBuilder2 = new StringBuilder();
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (!object.add(string2.toLowerCase(Locale.US))) continue;
            if (stringBuilder2.length() > 0) {
                stringBuilder2.append('|');
            }
            stringBuilder2.append(string2);
        }
        return stringBuilder2.toString();
    }

    private static String addReguralToNonProxyHosts(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
        StringBuilder stringBuilder = new StringBuilder();
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.indexOf(42) == -1) {
                string2 = string2 + '*';
            }
            if (stringBuilder.length() > 0) {
                stringBuilder.append('|');
            }
            stringBuilder.append(string2);
        }
        return stringBuilder.toString();
    }

    public static String normalizeProxyHost(String string) {
        if (string.toLowerCase(Locale.US).startsWith("http://")) {
            return string.substring(7, string.length());
        }
        return string;
    }

    private static InetSocketAddress analyzeProxy(URI uRI) {
        Parameters.notNull((CharSequence)"uri", (Object)uRI);
        List<Proxy> list = ProxySelector.getDefault().select(uRI);
        assert (list != null) : "ProxySelector cannot return null for " + uRI;
        assert (!list.isEmpty()) : "ProxySelector cannot return empty list for " + uRI;
        Proxy proxy = list.get(0);
        if (Proxy.Type.DIRECT == proxy.type()) {
            return null;
        }
        if (proxy.address() instanceof InetSocketAddress) {
            return (InetSocketAddress)proxy.address();
        }
        LOGGER.log(Level.INFO, proxy.address() + " is not instanceof InetSocketAddress but " + proxy.address().getClass());
        return null;
    }

    static {
        LOGGER = Logger.getLogger(ProxySettings.class.getName());
    }

    public static class NbProxyCredentialsProvider
    extends NetworkSettings.ProxyCredentialsProvider {
        public String getProxyHost(URI uRI) {
            if (ProxySettings.getPreferences() == null) {
                return null;
            }
            InetSocketAddress inetSocketAddress = ProxySettings.analyzeProxy(uRI);
            return inetSocketAddress == null ? null : inetSocketAddress.getHostName();
        }

        public String getProxyPort(URI uRI) {
            if (ProxySettings.getPreferences() == null) {
                return null;
            }
            InetSocketAddress inetSocketAddress = ProxySettings.analyzeProxy(uRI);
            return inetSocketAddress == null ? null : Integer.toString(inetSocketAddress.getPort());
        }

        protected String getProxyUserName(URI uRI) {
            if (ProxySettings.getPreferences() == null) {
                return null;
            }
            return ProxySettings.getAuthenticationUsername();
        }

        protected char[] getProxyPassword(URI uRI) {
            if (ProxySettings.getPreferences() == null) {
                return null;
            }
            return ProxySettings.getAuthenticationPassword();
        }

        protected boolean isProxyAuthentication(URI uRI) {
            if (ProxySettings.getPreferences() == null) {
                return false;
            }
            return ProxySettings.getPreferences().getBoolean(ProxySettings.USE_PROXY_AUTHENTICATION, false);
        }
    }

    static class SystemProxySettings
    extends ProxySettings {
        SystemProxySettings() {
        }

        public static String getHttpHost() {
            if (SystemProxySettings.isSystemProxyDetect()) {
                return SystemProxySettings.getSystemProxyHost();
            }
            return "";
        }

        public static String getHttpPort() {
            if (SystemProxySettings.isSystemProxyDetect()) {
                return SystemProxySettings.getSystemProxyPort();
            }
            return "";
        }

        public static String getHttpsHost() {
            if (SystemProxySettings.isSystemProxyDetect()) {
                return SystemProxySettings.getSystemProxyHost();
            }
            return "";
        }

        public static String getHttpsPort() {
            if (SystemProxySettings.isSystemProxyDetect()) {
                return SystemProxySettings.getSystemProxyPort();
            }
            return "";
        }

        public static String getSocksHost() {
            if (SystemProxySettings.isSystemSocksServerDetect()) {
                return SystemProxySettings.getSystemSocksServerHost();
            }
            return "";
        }

        public static String getSocksPort() {
            if (SystemProxySettings.isSystemSocksServerDetect()) {
                return SystemProxySettings.getSystemSocksServerPort();
            }
            return "";
        }

        public static String getNonProxyHosts() {
            return ProxySettings.getDefaultUserNonProxyHosts();
        }

        private static boolean isSystemProxyDetect() {
            if (NbProxySelector.useSystemProxies()) {
                return true;
            }
            String string = System.getProperty("netbeans.system_http_proxy");
            return string != null && !ProxySettings.DIRECT.equals(string);
        }

        private static String getSystemProxyHost() {
            String string = System.getProperty("netbeans.system_http_proxy");
            if (string == null) {
                return "";
            }
            int n = string.lastIndexOf(":");
            if (n <= 0 || n >= string.length() - 1) {
                return "";
            }
            return SystemProxySettings.normalizeProxyHost(string.substring(0, n));
        }

        private static String getSystemProxyPort() {
            String string = System.getProperty("netbeans.system_http_proxy");
            if (string == null) {
                return "";
            }
            int n = string.lastIndexOf(":");
            if (n <= 0 || n >= string.length() - 1) {
                return "";
            }
            String string2 = string.substring(n + 1);
            if (string2.indexOf(47) >= 0) {
                string2 = string2.substring(0, string2.indexOf(47));
            }
            return string2;
        }

        private static boolean isSystemSocksServerDetect() {
            return SystemProxySettings.isSystemProxyDetect() && System.getProperty("netbeans.system_socks_proxy") != null;
        }

        private static String getSystemSocksServerHost() {
            String string = System.getProperty("netbeans.system_socks_proxy");
            if (string == null) {
                return "";
            }
            int n = string.lastIndexOf(":");
            if (n <= 0 || n >= string.length() - 1) {
                return "";
            }
            return SystemProxySettings.normalizeProxyHost(string.substring(0, n));
        }

        private static String getSystemSocksServerPort() {
            String string = System.getProperty("netbeans.system_socks_proxy");
            if (string == null) {
                return "";
            }
            int n = string.lastIndexOf(":");
            if (n <= 0 || n >= string.length() - 1) {
                return "";
            }
            String string2 = string.substring(n + 1);
            if (string2.indexOf(47) >= 0) {
                string2 = string2.substring(0, string2.indexOf(47));
            }
            return string2;
        }
    }
}

