/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.netbeans.core.ProxySettings;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

public class ProxyAutoConfig {
    private static final Map<String, ProxyAutoConfig> file2pac = new HashMap<String, ProxyAutoConfig>(2);
    private static RequestProcessor RP = new RequestProcessor(ProxyAutoConfig.class);
    private static final String NS_PROXY_AUTO_CONFIG_URL = "nbinst://org.netbeans.core/modules/ext/nsProxyAutoConfig.js";
    private static final String PROTO_FILE = "file://";
    private static final Logger LOGGER = Logger.getLogger(ProxyAutoConfig.class.getName());
    private Invocable inv = null;
    private final RequestProcessor.Task initTask;
    private final URI pacURI;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized ProxyAutoConfig get(String string) {
        if (file2pac.get(string) == null) {
            LOGGER.fine("Init ProxyAutoConfig for " + string);
            ProxyAutoConfig proxyAutoConfig = null;
            try {
                proxyAutoConfig = new ProxyAutoConfig(string);
            }
            catch (URISyntaxException uRISyntaxException) {
                Logger.getLogger(ProxyAutoConfig.class.getName()).warning("Parsing " + string + " to URI throws " + uRISyntaxException);
            }
            finally {
                file2pac.put(string, proxyAutoConfig);
            }
        }
        return file2pac.get(string);
    }

    private ProxyAutoConfig(String string) throws URISyntaxException {
        assert (file2pac.get(string) == null) : "Only once object for " + string + " must exist.";
        String string2 = this.normalizePAC(string);
        this.pacURI = new URI(string2);
        this.initTask = RP.post(new Runnable(){

            @Override
            public void run() {
                ProxyAutoConfig.this.initEngine();
            }
        });
    }

    public URI getPacURI() {
        return this.pacURI;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initEngine() {
        ScriptEngine scriptEngine;
        InputStream inputStream;
        try {
            inputStream = this.pacURI.isAbsolute() ? ProxyAutoConfig.downloadPAC(this.pacURI.toURL()) : null;
        }
        catch (IOException iOException) {
            LOGGER.log(Level.INFO, "InputStream for " + this.pacURI + " throws " + iOException, iOException);
            return;
        }
        if (inputStream == null) {
            return;
        }
        String string = ProxyAutoConfig.downloadUtils();
        try {
            scriptEngine = ProxyAutoConfig.evalPAC(inputStream, string);
        }
        catch (FileNotFoundException fileNotFoundException) {
            LOGGER.log(Level.FINE, "While constructing ProxyAutoConfig thrown " + fileNotFoundException, fileNotFoundException);
            return;
        }
        catch (ScriptException scriptException) {
            LOGGER.log(Level.FINE, "While constructing ProxyAutoConfig thrown " + scriptException, scriptException);
            return;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    LOGGER.log(Level.FINE, "While closing PAC input stream thrown " + iOException, iOException);
                }
            }
        }
        assert (scriptEngine != null) : "JavaScri5pt engine cannot be null";
        if (scriptEngine == null) {
            LOGGER.log(Level.WARNING, "JavaScript engine cannot be null");
            return;
        }
        this.inv = (Invocable)((Object)scriptEngine);
    }

    public List<Proxy> findProxyForURL(URI uRI) {
        assert (this.initTask != null) : "initTask has be to posted.";
        if (!this.initTask.isFinished()) {
            while (!this.initTask.isFinished()) {
                try {
                    RP.post(new Runnable(){

                        @Override
                        public void run() {
                        }
                    }).waitFinished(100L);
                }
                catch (InterruptedException interruptedException) {
                    LOGGER.log(Level.FINEST, interruptedException.getMessage(), interruptedException);
                }
            }
        }
        if (this.inv == null) {
            return Collections.singletonList(Proxy.NO_PROXY);
        }
        Object object = null;
        try {
            object = this.inv.invokeFunction("FindProxyForURL", uRI.toString(), uRI.getHost());
        }
        catch (ScriptException scriptException) {
            LOGGER.log(Level.FINE, "While invoking FindProxyForURL(" + uRI + ", " + uRI.getHost() + " thrown " + scriptException, scriptException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            LOGGER.log(Level.FINE, "While invoking FindProxyForURL(" + uRI + ", " + uRI.getHost() + " thrown " + noSuchMethodException, noSuchMethodException);
        }
        List<Proxy> list = this.analyzeResult(uRI, object);
        if (list == null) {
            LOGGER.info("findProxyForURL(" + uRI + ") returns null.");
            list = Collections.emptyList();
        }
        LOGGER.fine("findProxyForURL(" + uRI + ") returns " + Arrays.asList(list));
        return list;
    }

    private static InputStream downloadPAC(URL uRL) throws IOException {
        URLConnection uRLConnection = uRL.openConnection(Proxy.NO_PROXY);
        InputStream inputStream = uRLConnection.getInputStream();
        return inputStream;
    }

    private static ScriptEngine evalPAC(InputStream inputStream, String string) throws FileNotFoundException, ScriptException {
        ScriptEngineManager scriptEngineManager = new ScriptEngineManager();
        ScriptEngine scriptEngine = scriptEngineManager.getEngineByName("JavaScript");
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        scriptEngine.eval(inputStreamReader);
        scriptEngine.eval(string);
        return scriptEngine;
    }

    private List<Proxy> analyzeResult(URI uRI, Object object) {
        if (object == null) {
            LOGGER.fine("Null result for " + uRI);
            return null;
        }
        String string = uRI.getScheme();
        assert (string != null) : "Invalid scheme of uri " + uRI + ". Scheme cannot be null!";
        if (string == null) {
            return null;
        }
        Proxy.Type type = "http".equals(string) || "https".equals(string) ? Proxy.Type.HTTP : Proxy.Type.SOCKS;
        StringTokenizer stringTokenizer = new StringTokenizer(object.toString(), ";");
        LinkedList<Proxy> linkedList = new LinkedList<Proxy>();
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if ("DIRECT".equals(string2.trim())) {
                linkedList.add(Proxy.NO_PROXY);
                continue;
            }
            String string3 = ProxyAutoConfig.getHost(string2);
            Integer n = ProxyAutoConfig.getPort(string2);
            if (string3 == null || n == null) continue;
            linkedList.add(new Proxy(type, new InetSocketAddress(string3, (int)n)));
        }
        return linkedList;
    }

    private static String getHost(String string) {
        int n;
        if (string.startsWith("PROXY ")) {
            string = string.substring(6);
        }
        if ((n = string.lastIndexOf(":")) <= 0 || n >= string.length() - 1) {
            LOGGER.info("No port in " + string);
            return null;
        }
        String string2 = string.substring(0, n);
        return ProxySettings.normalizeProxyHost(string2);
    }

    private static Integer getPort(String string) {
        int n;
        if (string.startsWith("PROXY ")) {
            string = string.substring(6);
        }
        if ((n = string.lastIndexOf(":")) <= 0 || n >= string.length() - 1) {
            LOGGER.info("No port in " + string);
            return null;
        }
        String string2 = string.substring(n + 1);
        if (string2.indexOf(47) >= 0) {
            string2 = string2.substring(0, string2.indexOf(47));
        }
        try {
            return Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            LOGGER.log(Level.INFO, numberFormatException.getLocalizedMessage(), numberFormatException);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String downloadUtils() {
        StringBuilder stringBuilder = new StringBuilder();
        BufferedReader bufferedReader = null;
        FileObject fileObject = null;
        try {
            try {
                fileObject = URLMapper.findFileObject((URL)new URL(NS_PROXY_AUTO_CONFIG_URL));
            }
            catch (MalformedURLException malformedURLException) {
                LOGGER.log(Level.INFO, malformedURLException.getMessage(), malformedURLException);
            }
            bufferedReader = new BufferedReader(new FileReader(FileUtil.toFile((FileObject)fileObject)));
        }
        catch (FileNotFoundException fileNotFoundException) {
            LOGGER.log(Level.INFO, fileNotFoundException.getMessage(), fileNotFoundException);
        }
        try {
            String string;
            boolean bl = false;
            while ((string = bufferedReader.readLine()) != null) {
                if ((string = string.trim()).startsWith("var pacUtils =")) {
                    bl = true;
                }
                if (!bl) continue;
                if (string.endsWith("+")) {
                    string = string.substring(0, string.length() - 1);
                }
                stringBuilder.append(string.replaceAll("\"", "").replaceAll("\\\\n", "").replaceAll("\\\\\\\\", "\\\\"));
                stringBuilder.append(System.getProperty("line.separator"));
            }
        }
        catch (IOException iOException) {
            LOGGER.log(Level.INFO, "While downloading nsProxyAutoConfig.js thrown " + iOException.getMessage(), iOException);
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {
                    LOGGER.log(Level.FINE, iOException.getMessage(), iOException);
                }
            }
        }
        return stringBuilder.toString();
    }

    private String normalizePAC(String string) {
        File file;
        String string2;
        int n = string.indexOf("\n");
        if (n != -1) {
            string = string.substring(0, n);
        }
        if ((n = string.indexOf("\r")) != -1) {
            string = string.substring(0, n);
        }
        if ((string2 = string).startsWith(PROTO_FILE)) {
            string2 = string2.substring(PROTO_FILE.length());
        }
        if ((n = (string = (file = new File(string2)).canRead() ? Utilities.toURI((File)file).toString() : string.replaceAll("\\\\", "/")).indexOf(" ")) != -1) {
            string = string.substring(0, n);
        }
        return string.trim();
    }
}

