/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core;

import java.io.IOException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.netbeans.core.ProxyAutoConfig;
import org.netbeans.core.ProxySettings;

public final class NbProxySelector
extends ProxySelector {
    private final ProxySelector original;
    private static final Logger LOG = Logger.getLogger(NbProxySelector.class.getName());
    private static Object useSystemProxies;

    private NbProxySelector(ProxySelector proxySelector) {
        this.original = proxySelector;
        LOG.fine("java.net.useSystemProxies has been set to " + NbProxySelector.useSystemProxies());
        LOG.fine("In launcher was detected netbeans.system_http_proxy: " + System.getProperty("netbeans.system_http_proxy", "N/A"));
        LOG.fine("In launcher was detected netbeans.system_socks_proxy: " + System.getProperty("netbeans.system_socks_proxy", "N/A"));
        ProxySettings.addPreferenceChangeListener(new ProxySettingsListener());
        this.copySettingsToSystem();
    }

    static ProxySelector create(ProxySelector proxySelector) {
        return new NbProxySelector(proxySelector);
    }

    static void register() {
        ProxySelector proxySelector = ProxySelector.getDefault();
        if (proxySelector == null) {
            LOG.warning("No default system ProxySelector was found thus NetBeans ProxySelector won't delegate on it");
        } else {
            LOG.log(Level.FINE, "Override the original ProxySelector: {0}", proxySelector);
        }
        ProxySelector.setDefault(NbProxySelector.create(proxySelector));
    }

    @Override
    public List<Proxy> select(URI uRI) {
        List<Object> list = new ArrayList();
        int n = ProxySettings.getProxyType();
        switch (n) {
            case 0: {
                list = Collections.singletonList(Proxy.NO_PROXY);
                break;
            }
            case 1: {
                if (NbProxySelector.useSystemProxies()) {
                    if (this.original == null) break;
                    list = this.original.select(uRI);
                    break;
                }
                String string = uRI.getScheme();
                assert (string != null) : "Invalid scheme of uri " + uRI + ". Scheme cannot be null!";
                if (NbProxySelector.dontUseProxy(ProxySettings.SystemProxySettings.getNonProxyHosts(), uRI.getHost())) {
                    list.add(Proxy.NO_PROXY);
                    break;
                }
                if (string.toLowerCase(Locale.US).startsWith("http")) {
                    String string2 = ProxySettings.SystemProxySettings.getHttpPort();
                    if (string2 != null && string2.length() > 0 && ProxySettings.SystemProxySettings.getHttpHost().length() > 0) {
                        int n2 = Integer.parseInt(string2);
                        Proxy proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(ProxySettings.SystemProxySettings.getHttpHost(), n2));
                        list.add(proxy);
                    }
                } else {
                    String string3 = ProxySettings.SystemProxySettings.getSocksPort();
                    String string4 = ProxySettings.SystemProxySettings.getSocksHost();
                    if (string3 != null && string3.length() > 0 && string4.length() > 0) {
                        int n3 = Integer.parseInt(string3);
                        Proxy proxy = new Proxy(Proxy.Type.SOCKS, new InetSocketAddress(string4, n3));
                        list.add(proxy);
                    }
                }
                if (this.original == null) break;
                list.addAll(this.original.select(uRI));
                break;
            }
            case 2: {
                String string = uRI.getScheme();
                assert (string != null) : "Invalid scheme of uri " + uRI + ". Scheme cannot be null!";
                if (NbProxySelector.dontUseProxy(ProxySettings.getNonProxyHosts(), uRI.getHost())) {
                    list.add(Proxy.NO_PROXY);
                    break;
                }
                if (string.toLowerCase(Locale.US).startsWith("http")) {
                    String string5 = ProxySettings.getHttpHost();
                    String string6 = ProxySettings.getHttpPort();
                    if (string6 != null && string6.length() > 0 && string5.length() > 0) {
                        int n4 = Integer.parseInt(string6);
                        Proxy proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(string5, n4));
                        list.add(proxy);
                    } else {
                        LOG.fine("Incomplete HTTP Proxy [" + string5 + "/" + string6 + "] found in ProxySelector[Type: " + ProxySettings.getProxyType() + "] for uri " + uRI + ". ");
                        if (this.original != null) {
                            LOG.finest("Fallback to the default ProxySelector which returns " + this.original.select(uRI));
                            list.addAll(this.original.select(uRI));
                        }
                    }
                } else {
                    String string7 = ProxySettings.getSocksPort();
                    String string8 = ProxySettings.getSocksHost();
                    if (string7 != null && string7.length() > 0 && string8.length() > 0) {
                        int n5 = Integer.parseInt(string7);
                        Proxy proxy = new Proxy(Proxy.Type.SOCKS, new InetSocketAddress(string8, n5));
                        list.add(proxy);
                    } else {
                        LOG.fine("Incomplete SOCKS Server [" + string8 + "/" + string7 + "] found in ProxySelector[Type: " + ProxySettings.getProxyType() + "] for uri " + uRI + ". ");
                        if (this.original != null) {
                            LOG.finest("Fallback to the default ProxySelector which returns " + this.original.select(uRI));
                            list.addAll(this.original.select(uRI));
                        }
                    }
                }
                list.add(Proxy.NO_PROXY);
                break;
            }
            case 3: {
                if (NbProxySelector.useSystemProxies()) {
                    if (this.original != null) {
                        list = this.original.select(uRI);
                    }
                } else {
                    if (NbProxySelector.dontUseProxy(ProxySettings.getNonProxyHosts(), uRI.getHost())) {
                        list.add(Proxy.NO_PROXY);
                        break;
                    }
                    ProxyAutoConfig proxyAutoConfig = ProxyAutoConfig.get(NbProxySelector.getPacFile());
                    assert (proxyAutoConfig != null) : "Instance of ProxyAutoConfig found for " + NbProxySelector.getPacFile();
                    if (proxyAutoConfig == null) {
                        LOG.finest("No instance of ProxyAutoConfig(" + NbProxySelector.getPacFile() + ") for URI " + uRI);
                        list.add(Proxy.NO_PROXY);
                    }
                    if (proxyAutoConfig.getPacURI().getHost() == null) {
                        LOG.log(Level.FINEST, "Identifying proxy for URI {0}---{1}, PAC LOCAL URI: {2}", new Object[]{uRI.toString(), uRI.getHost(), proxyAutoConfig.getPacURI().toString()});
                        list.addAll(proxyAutoConfig.findProxyForURL(uRI));
                    } else if (proxyAutoConfig.getPacURI().getHost().equals(uRI.getHost())) {
                        list.add(Proxy.NO_PROXY);
                    } else {
                        LOG.log(Level.FINEST, "Identifying proxy for URI {0}---{1}, PAC URI: {2}---{3}", new Object[]{uRI.toString(), uRI.getHost(), proxyAutoConfig.getPacURI().toString(), proxyAutoConfig.getPacURI().getHost()});
                        list.addAll(proxyAutoConfig.findProxyForURL(uRI));
                    }
                }
                list.add(Proxy.NO_PROXY);
                break;
            }
            case 4: {
                if (NbProxySelector.dontUseProxy(ProxySettings.getNonProxyHosts(), uRI.getHost())) {
                    list.add(Proxy.NO_PROXY);
                    break;
                }
                ProxyAutoConfig proxyAutoConfig = ProxyAutoConfig.get(NbProxySelector.getPacFile());
                assert (proxyAutoConfig != null) : "Instance of ProxyAutoConfig found for " + NbProxySelector.getPacFile();
                if (proxyAutoConfig == null) {
                    LOG.finest("No instance of ProxyAutoConfig(" + NbProxySelector.getPacFile() + ") for URI " + uRI);
                    list.add(Proxy.NO_PROXY);
                }
                if (proxyAutoConfig.getPacURI().getHost() == null) {
                    LOG.log(Level.FINEST, "Identifying proxy for URI {0}---{1}, PAC LOCAL URI: {2}", new Object[]{uRI.toString(), uRI.getHost(), proxyAutoConfig.getPacURI().toString()});
                    list.addAll(proxyAutoConfig.findProxyForURL(uRI));
                } else if (proxyAutoConfig.getPacURI().getHost().equals(uRI.getHost())) {
                    list.add(Proxy.NO_PROXY);
                } else {
                    LOG.log(Level.FINEST, "Identifying proxy for URI {0}---{1}, PAC URI: {2}---{3}", new Object[]{uRI.toString(), uRI.getHost(), proxyAutoConfig.getPacURI().toString(), proxyAutoConfig.getPacURI().getHost()});
                    list.addAll(proxyAutoConfig.findProxyForURL(uRI));
                }
                list.add(Proxy.NO_PROXY);
                break;
            }
            default: {
                assert (false) : "Invalid proxy type: " + n;
                break;
            }
        }
        LOG.finest("NbProxySelector[Type: " + ProxySettings.getProxyType() + ", Use HTTP for all protocols: " + ProxySettings.useProxyAllProtocols() + "] returns " + list + " for URI " + uRI);
        return list;
    }

    @Override
    public void connectFailed(URI uRI, SocketAddress socketAddress, IOException iOException) {
        LOG.log(Level.INFO, "connectionFailed(" + uRI + ", " + socketAddress + ")", iOException);
    }

    private void copySettingsToSystem() {
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        int n = ProxySettings.getProxyType();
        switch (n) {
            case 0: {
                string = null;
                string2 = null;
                string6 = null;
                string7 = null;
                string3 = null;
                string4 = null;
                string5 = null;
                break;
            }
            case 1: {
                string = ProxySettings.SystemProxySettings.getHttpHost();
                string2 = ProxySettings.SystemProxySettings.getHttpPort();
                string6 = ProxySettings.SystemProxySettings.getHttpsHost();
                string7 = ProxySettings.SystemProxySettings.getHttpsPort();
                string4 = ProxySettings.SystemProxySettings.getSocksHost();
                string5 = ProxySettings.SystemProxySettings.getSocksPort();
                ProxySettings.SystemProxySettings.getNonProxyHosts();
                break;
            }
            case 2: {
                string = ProxySettings.getHttpHost();
                string2 = ProxySettings.getHttpPort();
                string6 = ProxySettings.getHttpsHost();
                string7 = ProxySettings.getHttpsPort();
                string3 = ProxySettings.getNonProxyHosts();
                string4 = ProxySettings.getSocksHost();
                string5 = ProxySettings.getSocksPort();
                break;
            }
            case 3: {
                string = null;
                string2 = null;
                string6 = null;
                string7 = null;
                ProxySettings.SystemProxySettings.getNonProxyHosts();
                string4 = null;
                string5 = null;
                break;
            }
            case 4: {
                string = null;
                string2 = null;
                string6 = null;
                string7 = null;
                ProxySettings.getNonProxyHosts();
                string4 = null;
                string5 = null;
                break;
            }
            default: {
                assert (false) : "Invalid proxy type: " + n;
                break;
            }
        }
        this.setOrClearProperty("http.proxyHost", string, false);
        this.setOrClearProperty("http.proxyPort", string2, true);
        this.setOrClearProperty("http.nonProxyHosts", string3, false);
        this.setOrClearProperty("https.proxyHost", string6, false);
        this.setOrClearProperty("https.proxyPort", string7, true);
        this.setOrClearProperty("https.nonProxyHosts", string3, false);
        this.setOrClearProperty("socksProxyHost", string4, false);
        this.setOrClearProperty("socksProxyPort", string5, true);
        LOG.fine("Set System's http.proxyHost/Port/NonProxyHost to " + string + "/" + string2 + "/" + string3);
        LOG.fine("Set System's https.proxyHost/Port to " + string6 + "/" + string7);
        LOG.fine("Set System's socksProxyHost/Port to " + string4 + "/" + string5);
    }

    private void setOrClearProperty(String string, String string2, boolean bl) {
        assert (string != null);
        if (string2 == null || string2.length() == 0) {
            System.clearProperty(string);
        } else {
            if (bl) {
                try {
                    Integer.parseInt(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    LOG.log(Level.INFO, numberFormatException.getMessage(), numberFormatException);
                }
            }
            System.setProperty(string, string2);
        }
    }

    static boolean dontUseProxy(String string, String string2) {
        if (string2 == null) {
            return false;
        }
        if (NbProxySelector.dontUseIp(string, string2)) {
            return true;
        }
        return NbProxySelector.dontUseHostName(string, string2);
    }

    private static boolean dontUseHostName(String string, String string2) {
        if (string2 == null) {
            return false;
        }
        boolean bl = false;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|", false);
        while (stringTokenizer.hasMoreTokens() && !bl) {
            String string3 = stringTokenizer.nextToken().trim();
            int n = string3.indexOf("*");
            if (n == -1) {
                bl = string3.equals(string2);
                if (!bl) continue;
                LOG.finest("NbProxySelector[Type: " + ProxySettings.getProxyType() + "]. Host " + string2 + " found in nonProxyHosts: " + string);
                continue;
            }
            String string4 = string3.substring(0, n - 1 < 0 ? 0 : n - 1);
            String string5 = string3.substring(n + 1 > string3.length() ? string3.length() : n + 1);
            boolean bl2 = n > 0;
            boolean bl3 = n < string3.length() - 1;
            bl = bl2 && string2.startsWith(string4) || bl3 && string2.endsWith(string5);
            if (!bl) continue;
            LOG.finest("NbProxySelector[Type: " + ProxySettings.getProxyType() + "]. Host " + string2 + " found in nonProxyHosts: " + string);
        }
        return bl;
    }

    private static boolean dontUseIp(String string, String string2) {
        if (string2 == null) {
            return false;
        }
        String string3 = null;
        try {
            string3 = InetAddress.getByName(string2).getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            LOG.log(Level.FINE, unknownHostException.getLocalizedMessage(), unknownHostException);
        }
        if (string3 == null) {
            return false;
        }
        boolean bl = false;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|", false);
        while (stringTokenizer.hasMoreTokens() && !bl) {
            String string4 = stringTokenizer.nextToken().trim();
            int n = string4.indexOf("*");
            if (n == -1) {
                bl = string4.equals(string3);
                if (!bl) continue;
                LOG.finest("NbProxySelector[Type: " + ProxySettings.getProxyType() + "]. Host's IP " + string3 + " found in nonProxyHosts: " + string);
                continue;
            }
            try {
                bl = Pattern.matches(string4, string3);
                if (!bl) continue;
                LOG.finest("NbProxySelector[Type: " + ProxySettings.getProxyType() + "]. Host's IP" + string3 + " found in nonProxyHosts: " + string);
            }
            catch (PatternSyntaxException patternSyntaxException) {}
        }
        return bl;
    }

    static boolean useSystemProxies() {
        if (useSystemProxies == null) {
            try {
                Class<?> clazz = Class.forName("sun.net.NetProperties");
                Method method = clazz.getMethod("getBoolean", String.class);
                useSystemProxies = method.invoke(null, "java.net.useSystemProxies");
            }
            catch (Exception exception) {
                LOG.log(Level.FINEST, "Cannot get value of java.net.useSystemProxies bacause " + exception.getMessage(), exception);
            }
        }
        return useSystemProxies != null && "true".equalsIgnoreCase(useSystemProxies.toString());
    }

    static boolean usePAC() {
        String string = System.getProperty("netbeans.system_http_proxy");
        boolean bl = string != null && string.startsWith("PAC");
        return bl;
    }

    private static String getPacFile() {
        String string = System.getProperty("netbeans.system_http_proxy");
        return string.substring(4).trim();
    }

    private class ProxySettingsListener
    implements PreferenceChangeListener {
        private ProxySettingsListener() {
        }

        @Override
        public void preferenceChange(PreferenceChangeEvent preferenceChangeEvent) {
            if (preferenceChangeEvent.getKey().startsWith("proxy") || preferenceChangeEvent.getKey().startsWith("useProxy")) {
                NbProxySelector.this.copySettingsToSystem();
            }
        }
    }
}

